"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_command_1 = require("./base-command");
const app_1 = require("./app");
const locale_1 = require("@joplin/lib/locale");
const BaseModel_1 = require("@joplin/lib/BaseModel");
const Folder_1 = require("@joplin/lib/models/Folder");
const Note_1 = require("@joplin/lib/models/Note");
class Command extends base_command_1.default {
    usage() {
        return 'ren <item> <name>';
    }
    description() {
        return (0, locale_1._)('Renames the given <item> (note or notebook) to <name>.');
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async action(args) {
        const pattern = args['item'];
        const name = args['name'];
        const item = await (0, app_1.default)().loadItem('folderOrNote', pattern);
        this.encryptionCheck(item);
        if (!item)
            throw new Error((0, locale_1._)('Cannot find "%s".', pattern));
        const newItem = {
            id: item.id,
            title: name,
            type_: item.type_,
        };
        if (item.type_ === BaseModel_1.default.TYPE_FOLDER) {
            await Folder_1.default.save(newItem);
        }
        else {
            await Note_1.default.save(newItem);
        }
    }
}
module.exports = Command;
//# sourceMappingURL=command-ren.js.map