"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_command_1 = require("./base-command");
const app_1 = require("./app");
const locale_1 = require("@joplin/lib/locale");
const Folder_1 = require("@joplin/lib/models/Folder");
const BaseModel_1 = require("@joplin/lib/BaseModel");
const string_utils_1 = require("@joplin/lib/string-utils");
class Command extends base_command_1.default {
    usage() {
        return 'rmbook <notebook>';
    }
    description() {
        return (0, locale_1._)('Deletes the given notebook.');
    }
    options() {
        return [
            ['-f, --force', (0, locale_1._)('Deletes the notebook without asking for confirmation.')],
            ['-p, --permanent', (0, locale_1._)('Permanently deletes the notebook, skipping the trash.')],
        ];
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async action(args) {
        var _a;
        const pattern = args['notebook'];
        const force = args.options && args.options.force === true;
        const folder = await (0, app_1.default)().loadItemOrFail(BaseModel_1.default.TYPE_FOLDER, pattern);
        const permanent = ((_a = args.options) === null || _a === void 0 ? void 0 : _a.permanent) === true || !!folder.deleted_time;
        const ellipsizedFolderTitle = (0, string_utils_1.substrWithEllipsis)(folder.title, 0, 32);
        let msg;
        if (permanent) {
            msg = (0, locale_1._)('Permanently delete notebook "%s"?\n\nAll notes and sub-notebooks within this notebook will be permanently deleted.', ellipsizedFolderTitle);
        }
        else {
            msg = (0, locale_1._)('Move notebook "%s" to the trash?\n\nAll notes and sub-notebooks within this notebook will also be moved to the trash.', ellipsizedFolderTitle);
        }
        const ok = force ? true : await this.prompt(msg, { booleanAnswerDefault: 'n' });
        if (!ok)
            return;
        await Folder_1.default.delete(folder.id, { toTrash: !permanent, sourceDescription: 'rmbook command' });
    }
}
module.exports = Command;
//# sourceMappingURL=command-rmbook.js.map