"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ObjectUtils_1 = require("./ObjectUtils");
describe('ObjectUtils', () => {
    test('should convert object values to functions', () => {
        const v = (0, ObjectUtils_1.convertValuesToFunctions)({ a: 6, b: () => 7, c: 'test' });
        expect(v.a()).toBe(6);
        expect(v.b()).toBe(7);
        expect(v.c()).toBe('test');
    });
    test('should sort an object\'s entries by value', () => {
        expect((0, ObjectUtils_1.sortByValue)({
            a: 1,
            b: 'test1',
            c: 'test3',
            d: 'test2',
        })).toEqual({
            b: 'test1',
            d: 'test2',
            c: 'test3',
            a: 1,
        });
    });
});
//# sourceMappingURL=ObjectUtils.test.js.map