"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runtime = exports.declaration = void 0;
const markupLanguageUtils_1 = require("../markupLanguageUtils");
const Setting_1 = require("../models/Setting");
const shim_1 = require("../shim");
const theme_1 = require("../theme");
const attachedResources_1 = require("../utils/attachedResources");
exports.declaration = {
    name: 'renderMarkup',
};
const getMarkupToHtml = () => {
    // In the desktop app, resources accessed with file:// URLs can't be displayed in certain places (e.g. the note
    // viewer and plugin WebViews). On mobile, however, joplin-content:// URLs don't work. As such, use different
    // protocols on different platforms:
    const protocol = shim_1.default.isElectron() ? 'joplin-content://note-viewer/' : 'file://';
    return markupLanguageUtils_1.default.newMarkupToHtml({}, {
        resourceBaseUrl: `${protocol}${Setting_1.default.value('resourceDir')}/`,
        customCss: '',
    });
};
const runtime = () => {
    return {
        execute: async (_context, markupLanguage, markup, _rendererOptions = null, renderOptions = null) => {
            const markupToHtml = getMarkupToHtml();
            try {
                const html = await markupToHtml.render(markupLanguage, markup, (0, theme_1.themeStyle)(Setting_1.default.value('theme')), Object.assign(Object.assign({}, renderOptions), { resources: await (0, attachedResources_1.default)(markup), splitted: true }));
                return html;
            }
            catch (error) {
                error.message = `Could not render markup: markupLanguage: ${markupLanguage} Markup: ${markup}: ${error.message}`;
                throw error;
            }
        },
    };
};
exports.runtime = runtime;
//# sourceMappingURL=renderMarkup.js.map