"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runtime = exports.declaration = void 0;
const CommandService_1 = require("../services/CommandService");
const locale_1 = require("../locale");
const registry_1 = require("../registry");
const Setting_1 = require("../models/Setting");
const NavService_1 = require("../services/NavService");
exports.declaration = {
    name: 'synchronize',
    label: () => (0, locale_1._)('Synchronise'),
    iconName: 'fa-sync-alt',
};
// Note that this command actually acts as a toggle - it starts or cancels
// synchronisation depending on the "syncStarted" parameter
const runtime = () => {
    return {
        execute: async (context, syncStarted = null) => {
            syncStarted = syncStarted === null ? context.state.syncStarted : syncStarted;
            const action = syncStarted ? 'cancel' : 'start';
            if (!Setting_1.default.value('sync.target')) {
                context.dispatch({
                    type: 'DIALOG_OPEN',
                    name: 'syncWizard',
                });
                return 'init';
            }
            if (!(await registry_1.reg.syncTarget().isAuthenticated())) {
                if (registry_1.reg.syncTarget().authRouteName()) {
                    CommandService_1.utils.store.dispatch({
                        type: 'NAV_GO',
                        routeName: registry_1.reg.syncTarget().authRouteName(),
                    });
                    return 'auth';
                }
                const error = new Error('Not authenticated with sync target - please check your credentials.');
                CommandService_1.utils.store.dispatch({
                    type: 'SYNC_REPORT_UPDATE',
                    report: { errors: [error] },
                });
                if (Setting_1.default.value('sync.target') === 11) {
                    await NavService_1.default.go('JoplinServerSamlLogin');
                }
                registry_1.reg.logger().error(error);
                return 'error';
            }
            let sync = null;
            try {
                sync = await registry_1.reg.syncTarget().synchronizer();
            }
            catch (error) {
                registry_1.reg.logger().error('Could not initialise synchroniser: ');
                registry_1.reg.logger().error(error);
                error.message = `Could not initialise synchroniser: ${error.message}`;
                CommandService_1.utils.store.dispatch({
                    type: 'SYNC_REPORT_UPDATE',
                    report: { errors: [error] },
                });
                return 'error';
            }
            if (action === 'cancel') {
                sync.cancel();
                return 'cancel';
            }
            else {
                void registry_1.reg.scheduleSync(0);
                return 'sync';
            }
        },
    };
};
exports.runtime = runtime;
//# sourceMappingURL=synchronize.js.map