"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const locale_1 = require("../../locale");
const Setting_1 = require("../../models/Setting");
const shim_1 = require("../../shim");
const SyncTargetJoplinServerSAML_1 = require("../../SyncTargetJoplinServerSAML");
const prefixWithHttps_1 = require("../../utils/prefixWithHttps");
class SamlShared {
    openLoginPage() {
        const samlUrl = Setting_1.default.value('sync.11.path');
        if (!samlUrl) {
            const message = (0, locale_1._)('No URL for SAML authentication set.');
            void shim_1.default.showErrorDialog(message);
            throw new Error(message);
        }
        shim_1.default.openUrl(`${(0, prefixWithHttps_1.default)(samlUrl)}/login/sso-saml-app`);
        return Promise.resolve();
    }
    processLoginCode(code) {
        if (this.isLoginCodeValid(code)) {
            return (0, SyncTargetJoplinServerSAML_1.authenticateWithCode)(this.cleanCode(code));
        }
        else {
            return Promise.resolve(false);
        }
    }
    isLoginCodeValid(code) {
        const cleanedCode = this.cleanCode(code);
        return !isNaN(+cleanedCode) && cleanedCode.length === 9;
    }
    cleanCode(code) {
        return code.replace(/\s|-/gi, '');
    }
}
exports.default = SamlShared;
//# sourceMappingURL=SamlShared.js.map