"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Setting_1 = require("./models/Setting");
const registry_1 = require("./registry");
const sync = {
    start: jest.fn().mockReturnValue({}),
};
describe('Registry', () => {
    let originalSyncTarget;
    beforeAll(() => {
        Setting_1.default.setConstant('env', Setting_1.Env.Prod);
        originalSyncTarget = registry_1.reg.syncTarget;
        registry_1.reg.syncTarget = () => ({
            isAuthenticated: () => true,
            synchronizer: () => sync,
        });
    });
    afterAll(() => {
        Setting_1.default.setConstant('env', Setting_1.Env.Dev);
        registry_1.reg.syncTarget = originalSyncTarget;
    });
    beforeEach(() => {
        jest.useFakeTimers();
        Setting_1.default.setValue('sync.interval', 300);
    });
    afterEach(() => {
        Setting_1.default.setValue('sync.interval', 0);
        registry_1.reg.setupRecurrentSync();
    });
    describe('when on mobile data', () => {
        beforeEach(() => {
            Setting_1.default.setValue('sync.mobileWifiOnly', true);
            Setting_1.default.setValue('sync.target', 1);
            registry_1.reg.setIsOnMobileData(true);
        });
        it('should not sync automatically', () => {
            registry_1.reg.setupRecurrentSync();
            jest.runOnlyPendingTimers();
            expect(sync.start).toHaveBeenCalledTimes(0);
        });
        it('should sync if do wifi check is false', done => {
            void registry_1.reg.scheduleSync(1, null, false)
                // eslint-disable-next-line promise/prefer-await-to-then -- Old code before rule was applied
                .then(() => {
                expect(sync.start).toHaveBeenCalled();
                done();
            });
            jest.runOnlyPendingTimers();
        });
        it('should sync if "sync only over wifi" is disabled in settings', () => {
            Setting_1.default.setValue('sync.mobileWifiOnly', false);
            registry_1.reg.setupRecurrentSync();
            jest.runOnlyPendingTimers();
            expect(sync.start).toHaveBeenCalled();
        });
    });
    describe('when not on mobile data', () => {
        beforeEach(() => {
            Setting_1.default.setValue('sync.mobileWifiOnly', true);
            registry_1.reg.setIsOnMobileData(false);
        });
        it('should sync automatically', () => {
            registry_1.reg.setupRecurrentSync();
            jest.runOnlyPendingTimers();
            expect(sync.start).toHaveBeenCalled();
        });
    });
});
//# sourceMappingURL=registry.test.js.map