"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = commandsToMarkdownTable;
const markdownUtils_1 = require("../../markdownUtils");
function commandsToMarkdownTable() {
    const headers = [
        {
            name: 'commandName',
            label: 'Name',
        },
        {
            name: 'description',
            label: 'Description',
        },
        {
            name: 'props',
            label: 'Props',
        },
    ];
    const rows = [];
    for (const commandName in this.commands_) {
        const row = {
            commandName: commandName,
            description: this.label(commandName),
        };
        rows.push(row);
    }
    return markdownUtils_1.default.createMarkdownTable(headers, rows);
}
//# sourceMappingURL=commandsToMarkdownTable.js.map