"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const InteropService_Exporter_Base_1 = require("./InteropService_Exporter_Base");
const InteropService_Importer_Base_1 = require("./InteropService_Importer_Base");
const Module_1 = require("./Module");
const types_1 = require("./types");
describe('Module', () => {
    it('should return correct default fullLabel for an ImportModule', () => {
        const baseMetadata = {
            format: 'Foo_test',
            description: 'Some description here',
            sources: [types_1.FileSystemItem.File, types_1.FileSystemItem.Directory],
        };
        const importModuleMultiSource = (0, Module_1.makeImportModule)(baseMetadata, () => new InteropService_Importer_Base_1.default());
        const importModuleSingleSource = (0, Module_1.makeImportModule)(Object.assign(Object.assign({}, baseMetadata), { sources: [types_1.FileSystemItem.File] }), () => new InteropService_Importer_Base_1.default());
        // The two modules should have the same data, except for their sources.
        expect(importModuleMultiSource.format).toBe('Foo_test');
        expect(importModuleSingleSource.format).toBe(importModuleMultiSource.format);
        expect(importModuleMultiSource.sources).toHaveLength(2);
        expect(importModuleSingleSource.sources).toHaveLength(1);
        const baseLabel = 'FOO - Some description here';
        expect(importModuleMultiSource.fullLabel()).toBe(baseLabel);
        expect(importModuleSingleSource.fullLabel()).toBe(baseLabel);
        // Should only include (File) if the import module has more than one source
        expect(importModuleMultiSource.fullLabel(types_1.FileSystemItem.File)).toBe(`${baseLabel} (File)`);
        expect(importModuleSingleSource.fullLabel(types_1.FileSystemItem.File)).toBe(baseLabel);
    });
    it('should return correct default fullLabel for an ExportModule', () => {
        const testExportModule = (0, Module_1.makeExportModule)({
            // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
            format: 'format_test_______TEST',
            description: 'Testing...',
        }, () => new InteropService_Exporter_Base_1.default());
        // Should only include the portion of format before the first underscore
        const label = 'FORMAT - Testing...';
        expect(testExportModule.fullLabel()).toBe(label);
        // Sources should only be shown for import modules
        expect(testExportModule.fullLabel(types_1.FileSystemItem.File)).toBe(label);
        expect(testExportModule.fullLabel(types_1.FileSystemItem.Directory)).toBe(label);
    });
});
//# sourceMappingURL=Module.test.js.map