"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = default_1;
// enable file link URLs in MarkdownIt. Keeps other URL restrictions of MarkdownIt untouched.
// Format [link name](file://...)
function default_1(url) {
    const BAD_PROTO_RE = /^(vbscript|javascript|data):/;
    const GOOD_DATA_RE = /^data:image\/(gif|png|jpeg|webp);/;
    // url should be normalized at this point, and existing entities are decoded
    const str = url.trim().toLowerCase();
    if (str.startsWith('data:image/svg+xml,') || str.startsWith('data:image/svg+xml;utf8,')) {
        return true;
    }
    return BAD_PROTO_RE.test(str) ? (!!GOOD_DATA_RE.test(str)) : true;
}
//# sourceMappingURL=validateLinks.js.map