#= 
    1. Using the below raw expression interface for dense nonlinear problems significantly 
      reduces JuMP's building time
    2. `linking_constraints = true` is necessary to be able to solve this dense quadrilinear instance
=#

replace_expr(expr::Any, x) = expr
function replace_expr(expr::Expr, x)
    if Base.Meta.isexpr(expr, :ref)
        return x[expr.args[2]]
    end
    for i in 1:length(expr.args)
        expr.args[i] = replace_expr(expr.args[i], x)
    end
    return expr
end

function m_10_4_10_100_1(; solver = nothing)
    m = JuMP.Model(solver)

    # ----- Variables ----- #
    x_Idx = Any[1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
    @variable(m, 0 <= x[x_Idx] <= 1)

    # ----- Objective ----- #
    obj = :((
        0.7278 * x[1] * x[2] - 0.8657 * x[1] * x[3] - 0.1454 * x[1] * x[4] -
        0.7254 * x[1] * x[5] - 0.7618 * x[1] * x[6] - 0.3881 * x[1] * x[7] +
        0.2265 * x[1] * x[8] +
        0.3273 * x[1] * x[9] +
        0.7918 * x[1] * x[10] +
        0.5074 * x[2] * x[3] +
        0.2597 * x[2] * x[4] - 0.558 * x[2] * x[5] - 0.0323 * x[2] * x[6] +
        0.23 * x[2] * x[7] +
        0.9753 * x[2] * x[8] +
        0.1184 * x[2] * x[9] - 0.2582 * x[2] * x[10] - 0.3248 * x[3] * x[4] +
        0.4909 * x[3] * x[5] +
        0.1395 * x[3] * x[6] - 0.0877 * x[3] * x[7] +
        0.2964 * x[3] * x[8] +
        0.3672 * x[3] * x[9] - 0.6592 * x[3] * x[10] - 0.4539 * x[4] * x[5] -
        0.1185 * x[4] * x[6] - 0.0846 * x[4] * x[7] - 0.2095 * x[4] * x[8] +
        0.3767 * x[4] * x[9] - 0.4022 * x[4] * x[10] - 0.5895 * x[5] * x[6] -
        0.6154 * x[5] * x[7] - 0.162 * x[5] * x[8] + 0.3813 * x[5] * x[9] -
        0.7189 * x[5] * x[10] - 0.7125 * x[6] * x[7] +
        0.3249 * x[6] * x[8] +
        0.1514 * x[6] * x[9] +
        0.5499 * x[6] * x[10] +
        0.5506 * x[7] * x[8] +
        0.5307 * x[7] * x[9] +
        0.753 * x[7] * x[10] - 0.8016 * x[8] * x[9] - 0.331 * x[8] * x[10] +
        0.2902 * x[9] * x[10] - 0.7368 * x[1] +
        0.6151 * x[2] +
        0.0837 * x[3] - 0.4685 * x[4] - 0.0823 * x[5] +
        0.0219 * x[6] +
        0.0097 * x[7] +
        0.9235 * x[8] +
        0.1005 * x[9] - 0.6207 * x[10] + 0.6888 * x[1] * x[2] * x[3] -
        0.4837 * x[1] * x[2] * x[4] +
        0.6795 * x[1] * x[2] * x[5] +
        0.0753 * x[1] * x[2] * x[6] +
        0.2431 * x[1] * x[2] * x[7] - 0.0184 * x[1] * x[2] * x[8] -
        0.4303 * x[1] * x[2] * x[9] - 0.5289 * x[1] * x[2] * x[10] +
        0.3028 * x[1] * x[3] * x[4] +
        0.2143 * x[1] * x[3] * x[5] - 0.2037 * x[1] * x[3] * x[6] +
        0.6976 * x[1] * x[3] * x[7] +
        0.2752 * x[1] * x[3] * x[8] - 0.4824 * x[1] * x[3] * x[9] -
        0.2823 * x[1] * x[3] * x[10] + 0.1237 * x[1] * x[4] * x[5] -
        0.7571 * x[1] * x[4] * x[6] + 0.9569 * x[1] * x[4] * x[7] -
        0.2336 * x[1] * x[4] * x[8] + 0.4414 * x[1] * x[4] * x[9] -
        0.2835 * x[1] * x[4] * x[10] +
        0.8198 * x[1] * x[5] * x[6] +
        0.0874 * x[1] * x[5] * x[7] +
        0.9194 * x[1] * x[5] * x[8] +
        0.8589 * x[1] * x[5] * x[9] +
        0.2666 * x[1] * x[5] * x[10] - 0.4088 * x[1] * x[6] * x[7] -
        0.6505 * x[1] * x[6] * x[8] +
        0.6852 * x[1] * x[6] * x[9] +
        0.2372 * x[1] * x[6] * x[10] +
        0.4118 * x[1] * x[7] * x[8] - 0.5151 * x[1] * x[7] * x[9] +
        0.5959 * x[1] * x[7] * x[10] - 0.218 * x[1] * x[8] * x[9] -
        0.7801 * x[1] * x[8] * x[10] + 0.5074 * x[1] * x[9] * x[10] -
        0.9404 * x[2] * x[3] * x[4] +
        0.4013 * x[2] * x[3] * x[5] +
        0.0504 * x[2] * x[3] * x[6] +
        0.5051 * x[2] * x[3] * x[7] +
        0.2954 * x[2] * x[3] * x[8] +
        0.7422 * x[2] * x[3] * x[9] +
        0.6614 * x[2] * x[3] * x[10] +
        0.9144 * x[2] * x[4] * x[5] - 0.5555 * x[2] * x[4] * x[6] +
        0.159 * x[2] * x[4] * x[7] +
        0.9815 * x[2] * x[4] * x[8] +
        0.6799 * x[2] * x[4] * x[9] - 0.6504 * x[2] * x[4] * x[10] +
        0.4191 * x[2] * x[5] * x[6] - 0.3969 * x[2] * x[5] * x[7] -
        0.9499 * x[2] * x[5] * x[8] +
        0.8335 * x[2] * x[5] * x[9] +
        0.3776 * x[2] * x[5] * x[10] +
        0.5135 * x[2] * x[6] * x[7] +
        0.8655 * x[2] * x[6] * x[8] - 0.89 * x[2] * x[6] * x[9] -
        0.0021 * x[2] * x[6] * x[10] - 0.881 * x[2] * x[7] * x[8] -
        0.6563 * x[2] * x[7] * x[9] + 0.3767 * x[2] * x[7] * x[10] -
        0.3868 * x[2] * x[8] * x[9] +
        0.4704 * x[2] * x[8] * x[10] +
        0.5043 * x[2] * x[9] * x[10] - 0.2086 * x[3] * x[4] * x[5] -
        0.8244 * x[3] * x[4] * x[6] - 0.9021 * x[3] * x[4] * x[7] +
        0.5587 * x[3] * x[4] * x[8] +
        0.3616 * x[3] * x[4] * x[9] - 0.3769 * x[3] * x[4] * x[10] +
        0.0455 * x[3] * x[5] * x[6] +
        0.0116 * x[3] * x[5] * x[7] - 0.1229 * x[3] * x[5] * x[8] +
        0.1753 * x[3] * x[5] * x[9] - 0.4053 * x[3] * x[5] * x[10] -
        0.4102 * x[3] * x[6] * x[7] - 0.8524 * x[3] * x[6] * x[8] +
        0.9499 * x[3] * x[6] * x[9] +
        0.4563 * x[3] * x[6] * x[10] +
        0.5162 * x[3] * x[7] * x[8] - 0.3816 * x[3] * x[7] * x[9] -
        0.507 * x[3] * x[7] * x[10] - 0.4862 * x[3] * x[8] * x[9] +
        0.2361 * x[3] * x[8] * x[10] +
        0.8756 * x[3] * x[9] * x[10] +
        0.9844 * x[4] * x[5] * x[6] - 0.5504 * x[4] * x[5] * x[7] +
        0.8946 * x[4] * x[5] * x[8] +
        0.6956 * x[4] * x[5] * x[9] +
        0.4003 * x[4] * x[5] * x[10] +
        0.1089 * x[4] * x[6] * x[7] - 0.1168 * x[4] * x[6] * x[8] -
        0.5016 * x[4] * x[6] * x[9] + 0.7953 * x[4] * x[6] * x[10] -
        0.7085 * x[4] * x[7] * x[8] - 0.1308 * x[4] * x[7] * x[9] -
        0.0852 * x[4] * x[7] * x[10] - 0.3812 * x[4] * x[8] * x[9] -
        0.0382 * x[4] * x[8] * x[10] +
        0.3795 * x[4] * x[9] * x[10] +
        0.6216 * x[5] * x[6] * x[7] - 0.2157 * x[5] * x[6] * x[8] -
        0.4137 * x[5] * x[6] * x[9] +
        0.152 * x[5] * x[6] * x[10] +
        0.4507 * x[5] * x[7] * x[8] - 0.7145 * x[5] * x[7] * x[9] -
        0.3329 * x[5] * x[7] * x[10] - 0.6792 * x[5] * x[8] * x[9] +
        0.0692 * x[5] * x[8] * x[10] +
        0.4467 * x[5] * x[9] * x[10] - 0.5436 * x[6] * x[7] * x[8] -
        0.602 * x[6] * x[7] * x[9] +
        0.9452 * x[6] * x[7] * x[10] +
        0.9871 * x[6] * x[8] * x[9] - 0.8361 * x[6] * x[8] * x[10] -
        0.4982 * x[6] * x[9] * x[10] - 0.5683 * x[7] * x[8] * x[9] -
        0.6084 * x[7] * x[8] * x[10] + 0.7005 * x[7] * x[9] * x[10] -
        0.9106 * x[8] * x[9] * x[10] +
        0.9951 * x[1] * x[2] * x[3] * x[4] +
        0.1336 * x[1] * x[2] * x[3] * x[5] +
        0.9318 * x[1] * x[2] * x[3] * x[6] +
        0.4959 * x[1] * x[2] * x[3] * x[7] - 0.2652 * x[1] * x[2] * x[3] * x[8] -
        0.0387 * x[1] * x[2] * x[3] * x[9] - 0.8525 * x[1] * x[2] * x[3] * x[10] -
        0.9893 * x[1] * x[2] * x[4] * x[5] - 0.3058 * x[1] * x[2] * x[4] * x[6] -
        0.3155 * x[1] * x[2] * x[4] * x[7] - 0.5641 * x[1] * x[2] * x[4] * x[8] -
        0.7337 * x[1] * x[2] * x[4] * x[9] + 0.801 * x[1] * x[2] * x[4] * x[10] -
        0.2265 * x[1] * x[2] * x[5] * x[6] - 0.109 * x[1] * x[2] * x[5] * x[7] +
        0.3239 * x[1] * x[2] * x[5] * x[8] - 0.9678 * x[1] * x[2] * x[5] * x[9] +
        0.3017 * x[1] * x[2] * x[5] * x[10] +
        0.2928 * x[1] * x[2] * x[6] * x[7] - 0.354 * x[1] * x[2] * x[6] * x[8] +
        0.7114 * x[1] * x[2] * x[6] * x[9] - 0.1974 * x[1] * x[2] * x[6] * x[10] -
        0.5863 * x[1] * x[2] * x[7] * x[8] +
        0.9371 * x[1] * x[2] * x[7] * x[9] +
        0.1968 * x[1] * x[2] * x[7] * x[10] +
        0.346 * x[1] * x[2] * x[8] * x[9] - 0.0862 * x[1] * x[2] * x[8] * x[10] -
        0.34 * x[1] * x[2] * x[9] * x[10] - 0.7992 * x[1] * x[3] * x[4] * x[5] +
        0.5109 * x[1] * x[3] * x[4] * x[6] +
        0.2114 * x[1] * x[3] * x[4] * x[7] +
        0.4381 * x[1] * x[3] * x[4] * x[8] +
        0.7947 * x[1] * x[3] * x[4] * x[9] +
        0.3165 * x[1] * x[3] * x[4] * x[10] - 0.6986 * x[1] * x[3] * x[5] * x[6] +
        0.2246 * x[1] * x[3] * x[5] * x[7] +
        0.9573 * x[1] * x[3] * x[5] * x[8] +
        0.9983 * x[1] * x[3] * x[5] * x[9] - 0.4864 * x[1] * x[3] * x[5] * x[10] +
        0.1017 * x[1] * x[3] * x[6] * x[7] +
        0.3181 * x[1] * x[3] * x[6] * x[8] +
        0.108 * x[1] * x[3] * x[6] * x[9] +
        0.9555 * x[1] * x[3] * x[6] * x[10] +
        0.8038 * x[1] * x[3] * x[7] * x[8] +
        0.3158 * x[1] * x[3] * x[7] * x[9] +
        0.4577 * x[1] * x[3] * x[7] * x[10] - 0.1951 * x[1] * x[3] * x[8] * x[9] +
        0.8573 * x[1] * x[3] * x[8] * x[10] - 0.7043 * x[1] * x[3] * x[9] * x[10] +
        0.3491 * x[1] * x[4] * x[5] * x[6] +
        0.5392 * x[1] * x[4] * x[5] * x[7] - 0.3214 * x[1] * x[4] * x[5] * x[8] -
        0.7684 * x[1] * x[4] * x[5] * x[9] +
        0.2287 * x[1] * x[4] * x[5] * x[10] +
        0.6412 * x[1] * x[4] * x[6] * x[7] +
        0.8942 * x[1] * x[4] * x[6] * x[8] +
        0.4623 * x[1] * x[4] * x[6] * x[9] - 0.0048 * x[1] * x[4] * x[6] * x[10] -
        0.2504 * x[1] * x[4] * x[7] * x[8] - 0.157 * x[1] * x[4] * x[7] * x[9] +
        0.1058 * x[1] * x[4] * x[7] * x[10] +
        0.9958 * x[1] * x[4] * x[8] * x[9] +
        0.9808 * x[1] * x[4] * x[8] * x[10] +
        0.4926 * x[1] * x[4] * x[9] * x[10] +
        0.9075 * x[1] * x[5] * x[6] * x[7] - 0.8135 * x[1] * x[5] * x[6] * x[8] +
        0.468 * x[1] * x[5] * x[6] * x[9] +
        0.5035 * x[1] * x[5] * x[6] * x[10] +
        0.8937 * x[1] * x[5] * x[7] * x[8] +
        0.4124 * x[1] * x[5] * x[7] * x[9] +
        0.6276 * x[1] * x[5] * x[7] * x[10] +
        0.1172 * x[1] * x[5] * x[8] * x[9] - 0.8766 * x[1] * x[5] * x[8] * x[10] -
        0.0392 * x[1] * x[5] * x[9] * x[10] + 0.1954 * x[1] * x[6] * x[7] * x[8] -
        0.7249 * x[1] * x[6] * x[7] * x[9] +
        0.1748 * x[1] * x[6] * x[7] * x[10] +
        0.0399 * x[1] * x[6] * x[8] * x[9] +
        0.7718 * x[1] * x[6] * x[8] * x[10] - 0.3924 * x[1] * x[6] * x[9] * x[10] +
        0.3393 * x[1] * x[7] * x[8] * x[9] +
        0.3299 * x[1] * x[7] * x[8] * x[10] +
        0.0074 * x[1] * x[7] * x[9] * x[10] - 0.4768 * x[1] * x[8] * x[9] * x[10] -
        0.8469 * x[2] * x[3] * x[4] * x[5] - 0.7975 * x[2] * x[3] * x[4] * x[6] +
        0.0985 * x[2] * x[3] * x[4] * x[7] - 0.2488 * x[2] * x[3] * x[4] * x[8] -
        0.9697 * x[2] * x[3] * x[4] * x[9] +
        0.5858 * x[2] * x[3] * x[4] * x[10] +
        0.2418 * x[2] * x[3] * x[5] * x[6] +
        0.5472 * x[2] * x[3] * x[5] * x[7] +
        0.9072 * x[2] * x[3] * x[5] * x[8] - 0.7715 * x[2] * x[3] * x[5] * x[9] -
        0.3631 * x[2] * x[3] * x[5] * x[10] + 0.1936 * x[2] * x[3] * x[6] * x[7] -
        0.9037 * x[2] * x[3] * x[6] * x[8] - 0.7716 * x[2] * x[3] * x[6] * x[9] -
        0.5681 * x[2] * x[3] * x[6] * x[10] - 0.7989 * x[2] * x[3] * x[7] * x[8] -
        0.8533 * x[2] * x[3] * x[7] * x[9] - 0.5063 * x[2] * x[3] * x[7] * x[10] -
        0.1132 * x[2] * x[3] * x[8] * x[9] - 0.5833 * x[2] * x[3] * x[8] * x[10] +
        0.134 * x[2] * x[3] * x[9] * x[10] - 0.9514 * x[2] * x[4] * x[5] * x[6] -
        0.1594 * x[2] * x[4] * x[5] * x[7] - 0.2043 * x[2] * x[4] * x[5] * x[8] +
        0.9532 * x[2] * x[4] * x[5] * x[9] +
        0.3852 * x[2] * x[4] * x[5] * x[10] - 0.9901 * x[2] * x[4] * x[6] * x[7] -
        0.7402 * x[2] * x[4] * x[6] * x[8] - 0.9064 * x[2] * x[4] * x[6] * x[9] +
        0.6796 * x[2] * x[4] * x[6] * x[10] +
        0.357 * x[2] * x[4] * x[7] * x[8] +
        0.1639 * x[2] * x[4] * x[7] * x[9] +
        0.4671 * x[2] * x[4] * x[7] * x[10] - 0.7679 * x[2] * x[4] * x[8] * x[9] +
        0.6806 * x[2] * x[4] * x[8] * x[10] +
        0.67 * x[2] * x[4] * x[9] * x[10] +
        0.4931 * x[2] * x[5] * x[6] * x[7] +
        0.6864 * x[2] * x[5] * x[6] * x[8] +
        0.0577 * x[2] * x[5] * x[6] * x[9] +
        0.331 * x[2] * x[5] * x[6] * x[10] +
        0.4615 * x[2] * x[5] * x[7] * x[8] - 0.1788 * x[2] * x[5] * x[7] * x[9] -
        0.2886 * x[2] * x[5] * x[7] * x[10] + 0.4708 * x[2] * x[5] * x[8] * x[9] -
        0.0574 * x[2] * x[5] * x[8] * x[10] - 0.0747 * x[2] * x[5] * x[9] * x[10] +
        0.5194 * x[2] * x[6] * x[7] * x[8] +
        0.4049 * x[2] * x[6] * x[7] * x[9] - 0.4841 * x[2] * x[6] * x[7] * x[10] +
        0.8754 * x[2] * x[6] * x[8] * x[9] - 0.0878 * x[2] * x[6] * x[8] * x[10] +
        0.617 * x[2] * x[6] * x[9] * x[10] +
        0.8177 * x[2] * x[7] * x[8] * x[9] +
        0.3898 * x[2] * x[7] * x[8] * x[10] - 0.561 * x[2] * x[7] * x[9] * x[10] +
        0.7099 * x[2] * x[8] * x[9] * x[10] +
        0.4888 * x[3] * x[4] * x[5] * x[6] - 0.3978 * x[3] * x[4] * x[5] * x[7] +
        0.3439 * x[3] * x[4] * x[5] * x[8] +
        0.2374 * x[3] * x[4] * x[5] * x[9] +
        0.9351 * x[3] * x[4] * x[5] * x[10] +
        0.9805 * x[3] * x[4] * x[6] * x[7] - 0.324 * x[3] * x[4] * x[6] * x[8] +
        0.8415 * x[3] * x[4] * x[6] * x[9] - 0.3219 * x[3] * x[4] * x[6] * x[10] +
        0.8619 * x[3] * x[4] * x[7] * x[8] +
        0.0931 * x[3] * x[4] * x[7] * x[9] - 0.069 * x[3] * x[4] * x[7] * x[10] -
        0.6462 * x[3] * x[4] * x[8] * x[9] - 0.244 * x[3] * x[4] * x[8] * x[10] -
        0.6496 * x[3] * x[4] * x[9] * x[10] - 0.2863 * x[3] * x[5] * x[6] * x[7] +
        0.3314 * x[3] * x[5] * x[6] * x[8] +
        0.2371 * x[3] * x[5] * x[6] * x[9] - 0.0621 * x[3] * x[5] * x[6] * x[10] -
        0.3675 * x[3] * x[5] * x[7] * x[8] - 0.4622 * x[3] * x[5] * x[7] * x[9] -
        0.6002 * x[3] * x[5] * x[7] * x[10] - 0.1691 * x[3] * x[5] * x[8] * x[9] +
        0.9586 * x[3] * x[5] * x[8] * x[10] +
        0.0864 * x[3] * x[5] * x[9] * x[10] - 0.741 * x[3] * x[6] * x[7] * x[8] +
        0.6095 * x[3] * x[6] * x[7] * x[9] +
        0.6916 * x[3] * x[6] * x[7] * x[10] +
        0.4181 * x[3] * x[6] * x[8] * x[9] +
        0.0579 * x[3] * x[6] * x[8] * x[10] +
        0.3277 * x[3] * x[6] * x[9] * x[10] +
        0.8015 * x[3] * x[7] * x[8] * x[9] +
        0.8823 * x[3] * x[7] * x[8] * x[10] - 0.7712 * x[3] * x[7] * x[9] * x[10] +
        0.7333 * x[3] * x[8] * x[9] * x[10] +
        0.2647 * x[4] * x[5] * x[6] * x[7] - 0.5144 * x[4] * x[5] * x[6] * x[8] -
        0.6792 * x[4] * x[5] * x[6] * x[9] - 0.9575 * x[4] * x[5] * x[6] * x[10] -
        0.6195 * x[4] * x[5] * x[7] * x[8] - 0.3753 * x[4] * x[5] * x[7] * x[9] +
        0.6193 * x[4] * x[5] * x[7] * x[10] +
        0.1474 * x[4] * x[5] * x[8] * x[9] +
        0.6525 * x[4] * x[5] * x[8] * x[10] - 0.4271 * x[4] * x[5] * x[9] * x[10] -
        0.679 * x[4] * x[6] * x[7] * x[8] - 0.3382 * x[4] * x[6] * x[7] * x[9] -
        0.4683 * x[4] * x[6] * x[7] * x[10] +
        0.0896 * x[4] * x[6] * x[8] * x[9] +
        0.107 * x[4] * x[6] * x[8] * x[10] - 0.9568 * x[4] * x[6] * x[9] * x[10] -
        0.7025 * x[4] * x[7] * x[8] * x[9] - 0.7902 * x[4] * x[7] * x[8] * x[10] +
        0.2284 * x[4] * x[7] * x[9] * x[10] - 0.1874 * x[4] * x[8] * x[9] * x[10] +
        0.8031 * x[5] * x[6] * x[7] * x[8] +
        0.8857 * x[5] * x[6] * x[7] * x[9] - 0.6868 * x[5] * x[6] * x[7] * x[10] +
        0.8739 * x[5] * x[6] * x[8] * x[9] - 0.7291 * x[5] * x[6] * x[8] * x[10] -
        0.2574 * x[5] * x[6] * x[9] * x[10] - 0.357 * x[5] * x[7] * x[8] * x[9] +
        0.4299 * x[5] * x[7] * x[8] * x[10] +
        0.4594 * x[5] * x[7] * x[9] * x[10] - 0.2428 * x[5] * x[8] * x[9] * x[10] +
        0.6579 * x[6] * x[7] * x[8] * x[9] +
        0.9073 * x[6] * x[7] * x[8] * x[10] - 0.3832 * x[6] * x[7] * x[9] * x[10] +
        0.1595 * x[6] * x[8] * x[9] * x[10] - 0.5331 * x[7] * x[8] * x[9] * x[10]
    ))
    obj = replace_expr(obj, x)
    JuMP.set_nonlinear_objective(m, MOI.MIN_SENSE, obj)

    # ----- Constraints ----- #
    e2 = :(
        0.4626 * x[1] * x[2] + 0.0198 * x[1] * x[3] - 0.4397 * x[1] * x[4] +
        0.9861 * x[1] * x[5] +
        0.5225 * x[1] * x[6] - 0.9346 * x[1] * x[7] +
        0.4133 * x[1] * x[8] +
        0.3442 * x[1] * x[9] - 0.8199 * x[1] * x[10] - 0.0776 * x[2] * x[3] -
        0.4723 * x[2] * x[4] - 0.289 * x[2] * x[5] + 0.4463 * x[2] * x[6] -
        0.9454 * x[2] * x[7] +
        0.1697 * x[2] * x[8] +
        0.3885 * x[2] * x[9] - 0.7786 * x[2] * x[10] +
        0.0525 * x[3] * x[4] +
        0.9874 * x[3] * x[5] +
        0.4525 * x[3] * x[6] +
        0.521 * x[3] * x[7] - 0.5928 * x[3] * x[8] + 0.7265 * x[3] * x[9] -
        0.615 * x[3] * x[10] - 0.8237 * x[4] * x[5] - 0.5174 * x[4] * x[6] +
        0.821 * x[4] * x[7] +
        0.6597 * x[4] * x[8] - 0.8449 * x[4] * x[9] +
        0.743 * x[4] * x[10] +
        0.1144 * x[5] * x[6] - 0.2056 * x[5] * x[7] +
        0.9986 * x[5] * x[8] +
        0.54 * x[5] * x[9] +
        0.5713 * x[5] * x[10] +
        0.5068 * x[6] * x[7] +
        0.1204 * x[6] * x[8] +
        0.3888 * x[6] * x[9] +
        0.7512 * x[6] * x[10] - 0.9713 * x[7] * x[8] - 0.4285 * x[7] * x[9] -
        0.6373 * x[7] * x[10] +
        0.6154 * x[8] * x[9] +
        0.1051 * x[8] * x[10] - 0.0283 * x[9] * x[10] + 0.0735 * x[1] -
        0.9093 * x[2] - 0.7123 * x[3] +
        0.5603 * x[4] +
        0.5412 * x[5] - 0.6809 * x[6] - 0.0621 * x[7] - 0.674 * x[8] + 0.0977 * x[9] -
        0.3899 * x[10] + (-0.6347 * x[1] * x[2] * x[3]) -
        0.9763 * x[1] * x[2] * x[4] + 0.8874 * x[1] * x[2] * x[5] -
        0.0161 * x[1] * x[2] * x[6] +
        0.9611 * x[1] * x[2] * x[7] +
        0.2266 * x[1] * x[2] * x[8] - 0.2746 * x[1] * x[2] * x[9] +
        0.0648 * x[1] * x[2] * x[10] - 0.7084 * x[1] * x[3] * x[4] -
        0.7343 * x[1] * x[3] * x[5] - 0.2376 * x[1] * x[3] * x[6] +
        0.4007 * x[1] * x[3] * x[7] +
        0.0995 * x[1] * x[3] * x[8] +
        0.6511 * x[1] * x[3] * x[9] +
        0.0747 * x[1] * x[3] * x[10] +
        0.3247 * x[1] * x[4] * x[5] - 0.8937 * x[1] * x[4] * x[6] -
        0.6571 * x[1] * x[4] * x[7] +
        0.2373 * x[1] * x[4] * x[8] +
        0.5175 * x[1] * x[4] * x[9] +
        0.8201 * x[1] * x[4] * x[10] +
        0.428 * x[1] * x[5] * x[6] +
        0.48 * x[1] * x[5] * x[7] - 0.2866 * x[1] * x[5] * x[8] +
        0.6437 * x[1] * x[5] * x[9] +
        0.1041 * x[1] * x[5] * x[10] +
        0.3016 * x[1] * x[6] * x[7] - 0.6249 * x[1] * x[6] * x[8] +
        0.6366 * x[1] * x[6] * x[9] - 0.9552 * x[1] * x[6] * x[10] +
        0.3144 * x[1] * x[7] * x[8] - 0.7607 * x[1] * x[7] * x[9] -
        0.2293 * x[1] * x[7] * x[10] - 0.5147 * x[1] * x[8] * x[9] +
        0.9307 * x[1] * x[8] * x[10] - 0.0294 * x[1] * x[9] * x[10] +
        0.9847 * x[2] * x[3] * x[4] - 0.4374 * x[2] * x[3] * x[5] +
        0.9569 * x[2] * x[3] * x[6] +
        0.9057 * x[2] * x[3] * x[7] - 0.5138 * x[2] * x[3] * x[8] -
        0.1668 * x[2] * x[3] * x[9] + 0.4716 * x[2] * x[3] * x[10] -
        0.6094 * x[2] * x[4] * x[5] +
        0.2787 * x[2] * x[4] * x[6] +
        0.2594 * x[2] * x[4] * x[7] - 0.7943 * x[2] * x[4] * x[8] -
        0.7225 * x[2] * x[4] * x[9] - 0.0902 * x[2] * x[4] * x[10] +
        0.9687 * x[2] * x[5] * x[6] - 0.1502 * x[2] * x[5] * x[7] +
        0.4096 * x[2] * x[5] * x[8] - 0.2692 * x[2] * x[5] * x[9] -
        0.5992 * x[2] * x[5] * x[10] - 0.1808 * x[2] * x[6] * x[7] -
        0.5216 * x[2] * x[6] * x[8] + 0.41 * x[2] * x[6] * x[9] -
        0.8418 * x[2] * x[6] * x[10] - 0.5924 * x[2] * x[7] * x[8] -
        0.9653 * x[2] * x[7] * x[9] - 0.3314 * x[2] * x[7] * x[10] -
        0.4303 * x[2] * x[8] * x[9] + 0.6908 * x[2] * x[8] * x[10] -
        0.0111 * x[2] * x[9] * x[10] + 0.4202 * x[3] * x[4] * x[5] -
        0.4907 * x[3] * x[4] * x[6] + 0.6454 * x[3] * x[4] * x[7] -
        0.4368 * x[3] * x[4] * x[8] +
        0.2496 * x[3] * x[4] * x[9] +
        0.4916 * x[3] * x[4] * x[10] +
        0.7479 * x[3] * x[5] * x[6] - 0.7442 * x[3] * x[5] * x[7] -
        0.4416 * x[3] * x[5] * x[8] +
        0.847 * x[3] * x[5] * x[9] +
        0.9726 * x[3] * x[5] * x[10] +
        0.5786 * x[3] * x[6] * x[7] - 0.3041 * x[3] * x[6] * x[8] +
        0.5286 * x[3] * x[6] * x[9] - 0.6138 * x[3] * x[6] * x[10] -
        0.8712 * x[3] * x[7] * x[8] - 0.9096 * x[3] * x[7] * x[9] -
        0.707 * x[3] * x[7] * x[10] +
        0.6138 * x[3] * x[8] * x[9] +
        0.312 * x[3] * x[8] * x[10] - 0.5107 * x[3] * x[9] * x[10] -
        0.3513 * x[4] * x[5] * x[6] +
        0.9673 * x[4] * x[5] * x[7] +
        0.2275 * x[4] * x[5] * x[8] - 0.415 * x[4] * x[5] * x[9] -
        0.0089 * x[4] * x[5] * x[10] + 0.4723 * x[4] * x[6] * x[7] -
        0.9209 * x[4] * x[6] * x[8] - 0.9687 * x[4] * x[6] * x[9] -
        0.043 * x[4] * x[6] * x[10] +
        0.5532 * x[4] * x[7] * x[8] +
        0.8139 * x[4] * x[7] * x[9] +
        0.8304 * x[4] * x[7] * x[10] - 0.3323 * x[4] * x[8] * x[9] -
        0.4014 * x[4] * x[8] * x[10] + 0.6574 * x[4] * x[9] * x[10] -
        0.0813 * x[5] * x[6] * x[7] - 0.9703 * x[5] * x[6] * x[8] -
        0.3218 * x[5] * x[6] * x[9] - 0.8836 * x[5] * x[6] * x[10] -
        0.8145 * x[5] * x[7] * x[8] + 0.3035 * x[5] * x[7] * x[9] -
        0.2096 * x[5] * x[7] * x[10] +
        0.2399 * x[5] * x[8] * x[9] +
        0.6504 * x[5] * x[8] * x[10] - 0.3218 * x[5] * x[9] * x[10] -
        0.3831 * x[6] * x[7] * x[8] - 0.2782 * x[6] * x[7] * x[9] -
        0.1766 * x[6] * x[7] * x[10] - 0.0781 * x[6] * x[8] * x[9] -
        0.2352 * x[6] * x[8] * x[10] + 0.2862 * x[6] * x[9] * x[10] -
        0.5167 * x[7] * x[8] * x[9] +
        0.4314 * x[7] * x[8] * x[10] +
        0.7136 * x[7] * x[9] * x[10] - 0.6721 * x[8] * x[9] * x[10] +
        (-0.5978 * x[1] * x[2] * x[3] * x[4]) - 0.5025 * x[1] * x[2] * x[3] * x[5] +
        0.9402 * x[1] * x[2] * x[3] * x[6] +
        0.5528 * x[1] * x[2] * x[3] * x[7] - 0.4546 * x[1] * x[2] * x[3] * x[8] -
        0.0061 * x[1] * x[2] * x[3] * x[9] - 0.2025 * x[1] * x[2] * x[3] * x[10] +
        0.2266 * x[1] * x[2] * x[4] * x[5] - 0.8295 * x[1] * x[2] * x[4] * x[6] +
        0.474 * x[1] * x[2] * x[4] * x[7] +
        0.7257 * x[1] * x[2] * x[4] * x[8] - 0.3179 * x[1] * x[2] * x[4] * x[9] +
        0.3889 * x[1] * x[2] * x[4] * x[10] +
        0.2838 * x[1] * x[2] * x[5] * x[6] - 0.829 * x[1] * x[2] * x[5] * x[7] +
        0.416 * x[1] * x[2] * x[5] * x[8] +
        0.1849 * x[1] * x[2] * x[5] * x[9] - 0.5344 * x[1] * x[2] * x[5] * x[10] -
        0.8496 * x[1] * x[2] * x[6] * x[7] - 0.3513 * x[1] * x[2] * x[6] * x[8] +
        0.8262 * x[1] * x[2] * x[6] * x[9] - 0.5914 * x[1] * x[2] * x[6] * x[10] -
        0.0945 * x[1] * x[2] * x[7] * x[8] + 0.4543 * x[1] * x[2] * x[7] * x[9] -
        0.9433 * x[1] * x[2] * x[7] * x[10] +
        0.0341 * x[1] * x[2] * x[8] * x[9] +
        0.5353 * x[1] * x[2] * x[8] * x[10] +
        0.7887 * x[1] * x[2] * x[9] * x[10] +
        0.889 * x[1] * x[3] * x[4] * x[5] - 0.4204 * x[1] * x[3] * x[4] * x[6] +
        0.0629 * x[1] * x[3] * x[4] * x[7] - 0.5343 * x[1] * x[3] * x[4] * x[8] -
        0.3744 * x[1] * x[3] * x[4] * x[9] - 0.717 * x[1] * x[3] * x[4] * x[10] -
        0.3148 * x[1] * x[3] * x[5] * x[6] - 0.6929 * x[1] * x[3] * x[5] * x[7] +
        0.6984 * x[1] * x[3] * x[5] * x[8] +
        0.9441 * x[1] * x[3] * x[5] * x[9] - 0.1182 * x[1] * x[3] * x[5] * x[10] +
        0.5489 * x[1] * x[3] * x[6] * x[7] - 0.0876 * x[1] * x[3] * x[6] * x[8] +
        0.729 * x[1] * x[3] * x[6] * x[9] +
        0.456 * x[1] * x[3] * x[6] * x[10] +
        0.2747 * x[1] * x[3] * x[7] * x[8] +
        0.4481 * x[1] * x[3] * x[7] * x[9] +
        0.2084 * x[1] * x[3] * x[7] * x[10] - 0.9474 * x[1] * x[3] * x[8] * x[9] -
        0.4145 * x[1] * x[3] * x[8] * x[10] - 0.6056 * x[1] * x[3] * x[9] * x[10] +
        0.8973 * x[1] * x[4] * x[5] * x[6] +
        0.0637 * x[1] * x[4] * x[5] * x[7] - 0.9793 * x[1] * x[4] * x[5] * x[8] -
        0.0957 * x[1] * x[4] * x[5] * x[9] +
        0.9272 * x[1] * x[4] * x[5] * x[10] +
        0.9722 * x[1] * x[4] * x[6] * x[7] - 0.3182 * x[1] * x[4] * x[6] * x[8] +
        0.9186 * x[1] * x[4] * x[6] * x[9] - 0.3466 * x[1] * x[4] * x[6] * x[10] +
        0.4085 * x[1] * x[4] * x[7] * x[8] +
        0.5809 * x[1] * x[4] * x[7] * x[9] +
        0.4471 * x[1] * x[4] * x[7] * x[10] +
        0.4579 * x[1] * x[4] * x[8] * x[9] - 0.1092 * x[1] * x[4] * x[8] * x[10] -
        0.2364 * x[1] * x[4] * x[9] * x[10] +
        0.8444 * x[1] * x[5] * x[6] * x[7] +
        0.4968 * x[1] * x[5] * x[6] * x[8] - 0.1465 * x[1] * x[5] * x[6] * x[9] -
        0.5651 * x[1] * x[5] * x[6] * x[10] +
        0.4588 * x[1] * x[5] * x[7] * x[8] +
        0.5938 * x[1] * x[5] * x[7] * x[9] +
        0.1168 * x[1] * x[5] * x[7] * x[10] +
        0.7708 * x[1] * x[5] * x[8] * x[9] - 0.2337 * x[1] * x[5] * x[8] * x[10] -
        0.5184 * x[1] * x[5] * x[9] * x[10] - 0.3698 * x[1] * x[6] * x[7] * x[8] -
        0.1342 * x[1] * x[6] * x[7] * x[9] - 0.904 * x[1] * x[6] * x[7] * x[10] -
        0.1518 * x[1] * x[6] * x[8] * x[9] +
        0.4747 * x[1] * x[6] * x[8] * x[10] +
        0.7456 * x[1] * x[6] * x[9] * x[10] - 0.384 * x[1] * x[7] * x[8] * x[9] +
        0.6866 * x[1] * x[7] * x[8] * x[10] +
        0.6322 * x[1] * x[7] * x[9] * x[10] - 0.1864 * x[1] * x[8] * x[9] * x[10] +
        0.73 * x[2] * x[3] * x[4] * x[5] +
        0.7045 * x[2] * x[3] * x[4] * x[6] +
        0.0242 * x[2] * x[3] * x[4] * x[7] +
        0.5528 * x[2] * x[3] * x[4] * x[8] - 0.0143 * x[2] * x[3] * x[4] * x[9] -
        0.5903 * x[2] * x[3] * x[4] * x[10] - 0.1097 * x[2] * x[3] * x[5] * x[6] -
        0.1329 * x[2] * x[3] * x[5] * x[7] - 0.8906 * x[2] * x[3] * x[5] * x[8] +
        0.401 * x[2] * x[3] * x[5] * x[9] +
        0.8385 * x[2] * x[3] * x[5] * x[10] - 0.222 * x[2] * x[3] * x[6] * x[7] -
        0.5022 * x[2] * x[3] * x[6] * x[8] - 0.2673 * x[2] * x[3] * x[6] * x[9] +
        0.9973 * x[2] * x[3] * x[6] * x[10] +
        0.3242 * x[2] * x[3] * x[7] * x[8] - 0.6405 * x[2] * x[3] * x[7] * x[9] +
        0.7448 * x[2] * x[3] * x[7] * x[10] - 0.5121 * x[2] * x[3] * x[8] * x[9] -
        0.7672 * x[2] * x[3] * x[8] * x[10] +
        0.6364 * x[2] * x[3] * x[9] * x[10] +
        0.0713 * x[2] * x[4] * x[5] * x[6] +
        0.9761 * x[2] * x[4] * x[5] * x[7] - 0.1674 * x[2] * x[4] * x[5] * x[8] +
        0.6164 * x[2] * x[4] * x[5] * x[9] - 0.5201 * x[2] * x[4] * x[5] * x[10] +
        0.9405 * x[2] * x[4] * x[6] * x[7] - 0.2474 * x[2] * x[4] * x[6] * x[8] +
        0.2668 * x[2] * x[4] * x[6] * x[9] - 0.7262 * x[2] * x[4] * x[6] * x[10] +
        0.5369 * x[2] * x[4] * x[7] * x[8] - 0.7976 * x[2] * x[4] * x[7] * x[9] +
        0.1039 * x[2] * x[4] * x[7] * x[10] +
        0.6633 * x[2] * x[4] * x[8] * x[9] - 0.2455 * x[2] * x[4] * x[8] * x[10] +
        0.7355 * x[2] * x[4] * x[9] * x[10] +
        0.2493 * x[2] * x[5] * x[6] * x[7] +
        0.1046 * x[2] * x[5] * x[6] * x[8] - 0.5768 * x[2] * x[5] * x[6] * x[9] +
        0.6454 * x[2] * x[5] * x[6] * x[10] - 0.2728 * x[2] * x[5] * x[7] * x[8] -
        0.539 * x[2] * x[5] * x[7] * x[9] - 0.3418 * x[2] * x[5] * x[7] * x[10] +
        0.3602 * x[2] * x[5] * x[8] * x[9] - 0.1419 * x[2] * x[5] * x[8] * x[10] -
        0.0954 * x[2] * x[5] * x[9] * x[10] + 0.8552 * x[2] * x[6] * x[7] * x[8] -
        0.1075 * x[2] * x[6] * x[7] * x[9] +
        0.3345 * x[2] * x[6] * x[7] * x[10] +
        0.5617 * x[2] * x[6] * x[8] * x[9] +
        0.5817 * x[2] * x[6] * x[8] * x[10] - 0.6045 * x[2] * x[6] * x[9] * x[10] -
        0.4872 * x[2] * x[7] * x[8] * x[9] +
        0.3536 * x[2] * x[7] * x[8] * x[10] +
        0.7971 * x[2] * x[7] * x[9] * x[10] - 0.25 * x[2] * x[8] * x[9] * x[10] -
        0.9599 * x[3] * x[4] * x[5] * x[6] - 0.196 * x[3] * x[4] * x[5] * x[7] +
        0.9819 * x[3] * x[4] * x[5] * x[8] +
        0.9495 * x[3] * x[4] * x[5] * x[9] +
        0.9406 * x[3] * x[4] * x[5] * x[10] +
        0.9377 * x[3] * x[4] * x[6] * x[7] - 0.2505 * x[3] * x[4] * x[6] * x[8] -
        0.8054 * x[3] * x[4] * x[6] * x[9] +
        0.5014 * x[3] * x[4] * x[6] * x[10] +
        0.649 * x[3] * x[4] * x[7] * x[8] +
        0.4489 * x[3] * x[4] * x[7] * x[9] - 0.2659 * x[3] * x[4] * x[7] * x[10] +
        0.2441 * x[3] * x[4] * x[8] * x[9] - 0.3874 * x[3] * x[4] * x[8] * x[10] -
        0.3974 * x[3] * x[4] * x[9] * x[10] +
        0.3528 * x[3] * x[5] * x[6] * x[7] +
        0.6601 * x[3] * x[5] * x[6] * x[8] +
        0.1126 * x[3] * x[5] * x[6] * x[9] +
        0.1189 * x[3] * x[5] * x[6] * x[10] - 0.3444 * x[3] * x[5] * x[7] * x[8] +
        0.4614 * x[3] * x[5] * x[7] * x[9] - 0.6835 * x[3] * x[5] * x[7] * x[10] +
        0.0658 * x[3] * x[5] * x[8] * x[9] +
        0.5684 * x[3] * x[5] * x[8] * x[10] - 0.5684 * x[3] * x[5] * x[9] * x[10] -
        0.3494 * x[3] * x[6] * x[7] * x[8] + 0.0029 * x[3] * x[6] * x[7] * x[9] -
        0.5542 * x[3] * x[6] * x[7] * x[10] - 0.067 * x[3] * x[6] * x[8] * x[9] -
        0.6264 * x[3] * x[6] * x[8] * x[10] - 0.6098 * x[3] * x[6] * x[9] * x[10] -
        0.5862 * x[3] * x[7] * x[8] * x[9] +
        0.8116 * x[3] * x[7] * x[8] * x[10] +
        0.5998 * x[3] * x[7] * x[9] * x[10] +
        0.4699 * x[3] * x[8] * x[9] * x[10] - 0.1693 * x[4] * x[5] * x[6] * x[7] +
        0.622 * x[4] * x[5] * x[6] * x[8] +
        0.9767 * x[4] * x[5] * x[6] * x[9] - 0.0178 * x[4] * x[5] * x[6] * x[10] -
        0.5614 * x[4] * x[5] * x[7] * x[8] +
        0.5238 * x[4] * x[5] * x[7] * x[9] +
        0.8146 * x[4] * x[5] * x[7] * x[10] +
        0.1793 * x[4] * x[5] * x[8] * x[9] +
        0.7412 * x[4] * x[5] * x[8] * x[10] - 0.9228 * x[4] * x[5] * x[9] * x[10] +
        0.8761 * x[4] * x[6] * x[7] * x[8] - 0.9062 * x[4] * x[6] * x[7] * x[9] +
        0.7942 * x[4] * x[6] * x[7] * x[10] - 0.9605 * x[4] * x[6] * x[8] * x[9] +
        0.9985 * x[4] * x[6] * x[8] * x[10] +
        0.9604 * x[4] * x[6] * x[9] * x[10] +
        0.2233 * x[4] * x[7] * x[8] * x[9] +
        0.1751 * x[4] * x[7] * x[8] * x[10] +
        0.9245 * x[4] * x[7] * x[9] * x[10] +
        0.7868 * x[4] * x[8] * x[9] * x[10] - 0.5956 * x[5] * x[6] * x[7] * x[8] -
        0.9745 * x[5] * x[6] * x[7] * x[9] - 0.49 * x[5] * x[6] * x[7] * x[10] +
        0.7809 * x[5] * x[6] * x[8] * x[9] - 0.4609 * x[5] * x[6] * x[8] * x[10] +
        0.778 * x[5] * x[6] * x[9] * x[10] +
        0.0383 * x[5] * x[7] * x[8] * x[9] - 0.2656 * x[5] * x[7] * x[8] * x[10] +
        0.9676 * x[5] * x[7] * x[9] * x[10] +
        0.7539 * x[5] * x[8] * x[9] * x[10] +
        0.3629 * x[6] * x[7] * x[8] * x[9] - 0.2751 * x[6] * x[7] * x[8] * x[10] -
        0.6036 * x[6] * x[7] * x[9] * x[10] - 0.6255 * x[6] * x[8] * x[9] * x[10] +
        0.9753 * x[7] * x[8] * x[9] * x[10] <= 15.442
    )
    e2 = replace_expr(e2, x)
    JuMP.add_nonlinear_constraint(m, e2)
    e3 = :(
        (-0.4919 * x[1] * x[2]) - 0.0339 * x[1] * x[3] +
        0.2248 * x[1] * x[4] +
        0.366 * x[1] * x[5] - 0.1987 * x[1] * x[6] - 0.5784 * x[1] * x[7] +
        0.8198 * x[1] * x[8] - 0.0486 * x[1] * x[9] +
        0.7126 * x[1] * x[10] +
        0.8337 * x[2] * x[3] +
        0.0308 * x[2] * x[4] +
        0.4378 * x[2] * x[5] - 0.4249 * x[2] * x[6] - 0.876 * x[2] * x[7] -
        0.247 * x[2] * x[8] - 0.482 * x[2] * x[9] +
        0.0808 * x[2] * x[10] +
        0.0687 * x[3] * x[4] - 0.9379 * x[3] * x[5] - 0.1556 * x[3] * x[6] -
        0.1534 * x[3] * x[7] + 0.2972 * x[3] * x[8] - 0.682 * x[3] * x[9] -
        0.2246 * x[3] * x[10] +
        0.2078 * x[4] * x[5] +
        0.0801 * x[4] * x[6] +
        0.412 * x[4] * x[7] - 0.7653 * x[4] * x[8] +
        0.7097 * x[4] * x[9] +
        0.1609 * x[4] * x[10] +
        0.0463 * x[5] * x[6] - 0.049 * x[5] * x[7] - 0.9321 * x[5] * x[8] +
        0.5337 * x[5] * x[9] +
        0.6369 * x[5] * x[10] - 0.8873 * x[6] * x[7] - 0.5746 * x[6] * x[8] +
        0.4865 * x[6] * x[9] - 0.3803 * x[6] * x[10] - 0.7699 * x[7] * x[8] +
        0.7363 * x[7] * x[9] - 0.2812 * x[7] * x[10] + 0.8172 * x[8] * x[9] -
        0.5754 * x[8] * x[10] - 0.2821 * x[9] * x[10] - 0.8113 * x[1] +
        0.3038 * x[2] +
        0.8093 * x[3] +
        0.5277 * x[4] +
        0.7849 * x[5] +
        0.6706 * x[6] +
        0.0152 * x[7] - 0.009 * x[8] +
        0.0082 * x[9] +
        0.5372 * x[10] +
        (-0.0925 * x[1] * x[2] * x[3]) - 0.4232 * x[1] * x[2] * x[4] +
        0.4301 * x[1] * x[2] * x[5] - 0.1282 * x[1] * x[2] * x[6] +
        0.2232 * x[1] * x[2] * x[7] +
        0.124 * x[1] * x[2] * x[8] - 0.3137 * x[1] * x[2] * x[9] +
        0.5432 * x[1] * x[2] * x[10] - 0.0037 * x[1] * x[3] * x[4] -
        0.0924 * x[1] * x[3] * x[5] + 0.3913 * x[1] * x[3] * x[6] -
        0.6371 * x[1] * x[3] * x[7] - 0.1172 * x[1] * x[3] * x[8] -
        0.1265 * x[1] * x[3] * x[9] - 0.8825 * x[1] * x[3] * x[10] -
        0.2623 * x[1] * x[4] * x[5] - 0.1383 * x[1] * x[4] * x[6] -
        0.6027 * x[1] * x[4] * x[7] - 0.21 * x[1] * x[4] * x[8] -
        0.5062 * x[1] * x[4] * x[9] - 0.8757 * x[1] * x[4] * x[10] +
        0.8153 * x[1] * x[5] * x[6] +
        0.0395 * x[1] * x[5] * x[7] - 0.8308 * x[1] * x[5] * x[8] -
        0.2081 * x[1] * x[5] * x[9] - 0.797 * x[1] * x[5] * x[10] -
        0.9042 * x[1] * x[6] * x[7] - 0.5208 * x[1] * x[6] * x[8] +
        0.2869 * x[1] * x[6] * x[9] +
        0.0977 * x[1] * x[6] * x[10] - 0.6313 * x[1] * x[7] * x[8] -
        0.1462 * x[1] * x[7] * x[9] + 0.2552 * x[1] * x[7] * x[10] -
        0.8255 * x[1] * x[8] * x[9] +
        0.0742 * x[1] * x[8] * x[10] +
        0.6895 * x[1] * x[9] * x[10] - 0.181 * x[2] * x[3] * x[4] -
        0.5937 * x[2] * x[3] * x[5] +
        0.6543 * x[2] * x[3] * x[6] +
        0.9317 * x[2] * x[3] * x[7] - 0.2445 * x[2] * x[3] * x[8] +
        0.2943 * x[2] * x[3] * x[9] +
        0.3555 * x[2] * x[3] * x[10] - 0.1086 * x[2] * x[4] * x[5] -
        0.6558 * x[2] * x[4] * x[6] - 0.296 * x[2] * x[4] * x[7] -
        0.3417 * x[2] * x[4] * x[8] + 0.4937 * x[2] * x[4] * x[9] -
        0.457 * x[2] * x[4] * x[10] + 0.1226 * x[2] * x[5] * x[6] -
        0.7351 * x[2] * x[5] * x[7] + 0.5968 * x[2] * x[5] * x[8] -
        0.5881 * x[2] * x[5] * x[9] - 0.9469 * x[2] * x[5] * x[10] -
        0.6075 * x[2] * x[6] * x[7] - 0.9843 * x[2] * x[6] * x[8] +
        0.6435 * x[2] * x[6] * x[9] +
        0.8889 * x[2] * x[6] * x[10] - 0.064 * x[2] * x[7] * x[8] -
        0.7728 * x[2] * x[7] * x[9] - 0.679 * x[2] * x[7] * x[10] +
        0.6905 * x[2] * x[8] * x[9] +
        0.7074 * x[2] * x[8] * x[10] - 0.3972 * x[2] * x[9] * x[10] -
        0.4977 * x[3] * x[4] * x[5] - 0.5983 * x[3] * x[4] * x[6] -
        0.4784 * x[3] * x[4] * x[7] - 0.4858 * x[3] * x[4] * x[8] +
        0.2572 * x[3] * x[4] * x[9] - 0.0521 * x[3] * x[4] * x[10] +
        0.7398 * x[3] * x[5] * x[6] +
        0.2972 * x[3] * x[5] * x[7] +
        0.7789 * x[3] * x[5] * x[8] +
        0.5905 * x[3] * x[5] * x[9] +
        0.7603 * x[3] * x[5] * x[10] - 0.5705 * x[3] * x[6] * x[7] +
        0.9037 * x[3] * x[6] * x[8] +
        0.4382 * x[3] * x[6] * x[9] - 0.7787 * x[3] * x[6] * x[10] +
        0.9149 * x[3] * x[7] * x[8] +
        0.2939 * x[3] * x[7] * x[9] +
        0.1637 * x[3] * x[7] * x[10] - 0.9742 * x[3] * x[8] * x[9] -
        0.4477 * x[3] * x[8] * x[10] + 0.6009 * x[3] * x[9] * x[10] -
        0.3442 * x[4] * x[5] * x[6] + 0.1588 * x[4] * x[5] * x[7] -
        0.9521 * x[4] * x[5] * x[8] + 0.3398 * x[4] * x[5] * x[9] -
        0.6371 * x[4] * x[5] * x[10] - 0.4268 * x[4] * x[6] * x[7] +
        0.3169 * x[4] * x[6] * x[8] +
        0.1779 * x[4] * x[6] * x[9] - 0.8726 * x[4] * x[6] * x[10] -
        0.7344 * x[4] * x[7] * x[8] +
        0.4833 * x[4] * x[7] * x[9] +
        0.0007 * x[4] * x[7] * x[10] - 0.9371 * x[4] * x[8] * x[9] +
        0.9815 * x[4] * x[8] * x[10] - 0.9932 * x[4] * x[9] * x[10] +
        0.3986 * x[5] * x[6] * x[7] +
        0.5181 * x[5] * x[6] * x[8] - 0.4916 * x[5] * x[6] * x[9] -
        0.3371 * x[5] * x[6] * x[10] +
        0.1457 * x[5] * x[7] * x[8] +
        0.9832 * x[5] * x[7] * x[9] - 0.0207 * x[5] * x[7] * x[10] +
        0.1223 * x[5] * x[8] * x[9] +
        0.2128 * x[5] * x[8] * x[10] - 0.8286 * x[5] * x[9] * x[10] -
        0.4837 * x[6] * x[7] * x[8] - 0.0592 * x[6] * x[7] * x[9] +
        0.6266 * x[6] * x[7] * x[10] +
        0.4492 * x[6] * x[8] * x[9] +
        0.9861 * x[6] * x[8] * x[10] - 0.8687 * x[6] * x[9] * x[10] -
        0.8504 * x[7] * x[8] * x[9] + 0.6624 * x[7] * x[8] * x[10] -
        0.1745 * x[7] * x[9] * x[10] +
        0.3241 * x[8] * x[9] * x[10] +
        0.15 * x[1] * x[2] * x[3] * x[4] - 0.7118 * x[1] * x[2] * x[3] * x[5] -
        0.6134 * x[1] * x[2] * x[3] * x[6] +
        0.3822 * x[1] * x[2] * x[3] * x[7] +
        0.9004 * x[1] * x[2] * x[3] * x[8] - 0.7372 * x[1] * x[2] * x[3] * x[9] +
        0.42 * x[1] * x[2] * x[3] * x[10] - 0.2405 * x[1] * x[2] * x[4] * x[5] -
        0.204 * x[1] * x[2] * x[4] * x[6] - 0.998 * x[1] * x[2] * x[4] * x[7] -
        0.1736 * x[1] * x[2] * x[4] * x[8] +
        0.6076 * x[1] * x[2] * x[4] * x[9] +
        0.7557 * x[1] * x[2] * x[4] * x[10] - 0.7184 * x[1] * x[2] * x[5] * x[6] -
        0.9139 * x[1] * x[2] * x[5] * x[7] + 0.1313 * x[1] * x[2] * x[5] * x[8] -
        0.8836 * x[1] * x[2] * x[5] * x[9] + 0.7427 * x[1] * x[2] * x[5] * x[10] -
        0.3114 * x[1] * x[2] * x[6] * x[7] - 0.0203 * x[1] * x[2] * x[6] * x[8] -
        0.4356 * x[1] * x[2] * x[6] * x[9] - 0.5229 * x[1] * x[2] * x[6] * x[10] +
        0.0993 * x[1] * x[2] * x[7] * x[8] +
        0.4277 * x[1] * x[2] * x[7] * x[9] +
        0.8057 * x[1] * x[2] * x[7] * x[10] +
        0.5147 * x[1] * x[2] * x[8] * x[9] +
        0.0785 * x[1] * x[2] * x[8] * x[10] +
        0.2918 * x[1] * x[2] * x[9] * x[10] +
        0.5539 * x[1] * x[3] * x[4] * x[5] +
        0.758 * x[1] * x[3] * x[4] * x[6] +
        0.2055 * x[1] * x[3] * x[4] * x[7] - 0.877 * x[1] * x[3] * x[4] * x[8] -
        0.1218 * x[1] * x[3] * x[4] * x[9] - 0.9826 * x[1] * x[3] * x[4] * x[10] -
        0.4008 * x[1] * x[3] * x[5] * x[6] +
        0.947 * x[1] * x[3] * x[5] * x[7] +
        0.9103 * x[1] * x[3] * x[5] * x[8] - 0.5734 * x[1] * x[3] * x[5] * x[9] +
        0.3479 * x[1] * x[3] * x[5] * x[10] +
        0.0723 * x[1] * x[3] * x[6] * x[7] - 0.2806 * x[1] * x[3] * x[6] * x[8] -
        0.9973 * x[1] * x[3] * x[6] * x[9] + 0.6989 * x[1] * x[3] * x[6] * x[10] -
        0.1571 * x[1] * x[3] * x[7] * x[8] + 0.4957 * x[1] * x[3] * x[7] * x[9] -
        0.9767 * x[1] * x[3] * x[7] * x[10] + 0.2287 * x[1] * x[3] * x[8] * x[9] -
        0.1111 * x[1] * x[3] * x[8] * x[10] +
        0.3253 * x[1] * x[3] * x[9] * x[10] +
        0.3775 * x[1] * x[4] * x[5] * x[6] +
        0.8783 * x[1] * x[4] * x[5] * x[7] +
        0.4335 * x[1] * x[4] * x[5] * x[8] - 0.0967 * x[1] * x[4] * x[5] * x[9] +
        0.269 * x[1] * x[4] * x[5] * x[10] - 0.5516 * x[1] * x[4] * x[6] * x[7] -
        0.2037 * x[1] * x[4] * x[6] * x[8] + 0.6602 * x[1] * x[4] * x[6] * x[9] -
        0.722 * x[1] * x[4] * x[6] * x[10] +
        0.5119 * x[1] * x[4] * x[7] * x[8] +
        0.586 * x[1] * x[4] * x[7] * x[9] - 0.5442 * x[1] * x[4] * x[7] * x[10] +
        0.0562 * x[1] * x[4] * x[8] * x[9] - 0.7251 * x[1] * x[4] * x[8] * x[10] -
        0.6521 * x[1] * x[4] * x[9] * x[10] - 0.7049 * x[1] * x[5] * x[6] * x[7] +
        0.62 * x[1] * x[5] * x[6] * x[8] - 0.497 * x[1] * x[5] * x[6] * x[9] -
        0.1799 * x[1] * x[5] * x[6] * x[10] +
        0.9132 * x[1] * x[5] * x[7] * x[8] +
        0.4395 * x[1] * x[5] * x[7] * x[9] +
        0.6708 * x[1] * x[5] * x[7] * x[10] +
        0.5537 * x[1] * x[5] * x[8] * x[9] +
        0.0758 * x[1] * x[5] * x[8] * x[10] +
        0.2226 * x[1] * x[5] * x[9] * x[10] +
        0.3882 * x[1] * x[6] * x[7] * x[8] +
        0.2014 * x[1] * x[6] * x[7] * x[9] - 0.8073 * x[1] * x[6] * x[7] * x[10] +
        0.0984 * x[1] * x[6] * x[8] * x[9] - 0.4142 * x[1] * x[6] * x[8] * x[10] -
        0.5883 * x[1] * x[6] * x[9] * x[10] +
        0.6861 * x[1] * x[7] * x[8] * x[9] +
        0.303 * x[1] * x[7] * x[8] * x[10] +
        0.9262 * x[1] * x[7] * x[9] * x[10] +
        0.2199 * x[1] * x[8] * x[9] * x[10] - 0.1922 * x[2] * x[3] * x[4] * x[5] -
        0.7428 * x[2] * x[3] * x[4] * x[6] - 0.7244 * x[2] * x[3] * x[4] * x[7] -
        0.5698 * x[2] * x[3] * x[4] * x[8] +
        0.046 * x[2] * x[3] * x[4] * x[9] +
        0.4195 * x[2] * x[3] * x[4] * x[10] +
        0.0448 * x[2] * x[3] * x[5] * x[6] - 0.6311 * x[2] * x[3] * x[5] * x[7] +
        0.7262 * x[2] * x[3] * x[5] * x[8] - 0.3714 * x[2] * x[3] * x[5] * x[9] -
        0.9939 * x[2] * x[3] * x[5] * x[10] +
        0.9992 * x[2] * x[3] * x[6] * x[7] +
        0.7608 * x[2] * x[3] * x[6] * x[8] - 0.5125 * x[2] * x[3] * x[6] * x[9] +
        0.0878 * x[2] * x[3] * x[6] * x[10] +
        0.522 * x[2] * x[3] * x[7] * x[8] +
        0.3632 * x[2] * x[3] * x[7] * x[9] - 0.1574 * x[2] * x[3] * x[7] * x[10] +
        0.1895 * x[2] * x[3] * x[8] * x[9] - 0.1071 * x[2] * x[3] * x[8] * x[10] +
        0.889 * x[2] * x[3] * x[9] * x[10] - 0.6673 * x[2] * x[4] * x[5] * x[6] +
        0.9491 * x[2] * x[4] * x[5] * x[7] - 0.8262 * x[2] * x[4] * x[5] * x[8] -
        0.6978 * x[2] * x[4] * x[5] * x[9] + 0.8198 * x[2] * x[4] * x[5] * x[10] -
        0.5889 * x[2] * x[4] * x[6] * x[7] - 0.5569 * x[2] * x[4] * x[6] * x[8] -
        0.7317 * x[2] * x[4] * x[6] * x[9] +
        0.3949 * x[2] * x[4] * x[6] * x[10] +
        0.9541 * x[2] * x[4] * x[7] * x[8] - 0.9943 * x[2] * x[4] * x[7] * x[9] -
        0.0116 * x[2] * x[4] * x[7] * x[10] - 0.5047 * x[2] * x[4] * x[8] * x[9] +
        0.8051 * x[2] * x[4] * x[8] * x[10] - 0.7914 * x[2] * x[4] * x[9] * x[10] +
        0.5505 * x[2] * x[5] * x[6] * x[7] - 0.7908 * x[2] * x[5] * x[6] * x[8] +
        0.2414 * x[2] * x[5] * x[6] * x[9] - 0.3313 * x[2] * x[5] * x[6] * x[10] +
        0.9555 * x[2] * x[5] * x[7] * x[8] +
        0.3839 * x[2] * x[5] * x[7] * x[9] +
        0.6554 * x[2] * x[5] * x[7] * x[10] +
        0.9363 * x[2] * x[5] * x[8] * x[9] - 0.4451 * x[2] * x[5] * x[8] * x[10] -
        0.2679 * x[2] * x[5] * x[9] * x[10] - 0.6916 * x[2] * x[6] * x[7] * x[8] +
        0.9618 * x[2] * x[6] * x[7] * x[9] +
        0.8635 * x[2] * x[6] * x[7] * x[10] - 0.5314 * x[2] * x[6] * x[8] * x[9] -
        0.7532 * x[2] * x[6] * x[8] * x[10] - 0.2676 * x[2] * x[6] * x[9] * x[10] +
        0.6789 * x[2] * x[7] * x[8] * x[9] - 0.7484 * x[2] * x[7] * x[8] * x[10] +
        0.9799 * x[2] * x[7] * x[9] * x[10] - 0.04 * x[2] * x[8] * x[9] * x[10] +
        0.9229 * x[3] * x[4] * x[5] * x[6] +
        0.9211 * x[3] * x[4] * x[5] * x[7] +
        0.5065 * x[3] * x[4] * x[5] * x[8] +
        0.2912 * x[3] * x[4] * x[5] * x[9] +
        0.3298 * x[3] * x[4] * x[5] * x[10] +
        0.7586 * x[3] * x[4] * x[6] * x[7] +
        0.4593 * x[3] * x[4] * x[6] * x[8] +
        0.3926 * x[3] * x[4] * x[6] * x[9] +
        0.0687 * x[3] * x[4] * x[6] * x[10] +
        0.4976 * x[3] * x[4] * x[7] * x[8] +
        0.6535 * x[3] * x[4] * x[7] * x[9] - 0.9917 * x[3] * x[4] * x[7] * x[10] -
        0.5502 * x[3] * x[4] * x[8] * x[9] - 0.1718 * x[3] * x[4] * x[8] * x[10] +
        0.2573 * x[3] * x[4] * x[9] * x[10] - 0.9025 * x[3] * x[5] * x[6] * x[7] +
        0.3264 * x[3] * x[5] * x[6] * x[8] - 0.6443 * x[3] * x[5] * x[6] * x[9] +
        0.1642 * x[3] * x[5] * x[6] * x[10] +
        0.9221 * x[3] * x[5] * x[7] * x[8] - 0.428 * x[3] * x[5] * x[7] * x[9] -
        0.4399 * x[3] * x[5] * x[7] * x[10] +
        0.7566 * x[3] * x[5] * x[8] * x[9] +
        0.354 * x[3] * x[5] * x[8] * x[10] - 0.5276 * x[3] * x[5] * x[9] * x[10] -
        0.6272 * x[3] * x[6] * x[7] * x[8] - 0.8758 * x[3] * x[6] * x[7] * x[9] -
        0.6662 * x[3] * x[6] * x[7] * x[10] - 0.5727 * x[3] * x[6] * x[8] * x[9] -
        0.1467 * x[3] * x[6] * x[8] * x[10] - 0.8066 * x[3] * x[6] * x[9] * x[10] -
        0.53 * x[3] * x[7] * x[8] * x[9] - 0.7406 * x[3] * x[7] * x[8] * x[10] +
        0.8858 * x[3] * x[7] * x[9] * x[10] - 0.3289 * x[3] * x[8] * x[9] * x[10] -
        0.8604 * x[4] * x[5] * x[6] * x[7] - 0.0148 * x[4] * x[5] * x[6] * x[8] +
        0.3933 * x[4] * x[5] * x[6] * x[9] +
        0.4846 * x[4] * x[5] * x[6] * x[10] - 0.7567 * x[4] * x[5] * x[7] * x[8] +
        0.083 * x[4] * x[5] * x[7] * x[9] - 0.0985 * x[4] * x[5] * x[7] * x[10] +
        0.3703 * x[4] * x[5] * x[8] * x[9] +
        0.6679 * x[4] * x[5] * x[8] * x[10] +
        0.8643 * x[4] * x[5] * x[9] * x[10] +
        0.533 * x[4] * x[6] * x[7] * x[8] +
        0.1871 * x[4] * x[6] * x[7] * x[9] - 0.1905 * x[4] * x[6] * x[7] * x[10] +
        0.9994 * x[4] * x[6] * x[8] * x[9] - 0.7306 * x[4] * x[6] * x[8] * x[10] -
        0.2797 * x[4] * x[6] * x[9] * x[10] - 0.7742 * x[4] * x[7] * x[8] * x[9] +
        0.2634 * x[4] * x[7] * x[8] * x[10] - 0.6882 * x[4] * x[7] * x[9] * x[10] -
        0.1916 * x[4] * x[8] * x[9] * x[10] - 0.6292 * x[5] * x[6] * x[7] * x[8] +
        0.3706 * x[5] * x[6] * x[7] * x[9] +
        0.2252 * x[5] * x[6] * x[7] * x[10] - 0.5111 * x[5] * x[6] * x[8] * x[9] -
        0.7106 * x[5] * x[6] * x[8] * x[10] +
        0.436 * x[5] * x[6] * x[9] * x[10] +
        0.6397 * x[5] * x[7] * x[8] * x[9] - 0.7626 * x[5] * x[7] * x[8] * x[10] -
        0.7465 * x[5] * x[7] * x[9] * x[10] - 0.4273 * x[5] * x[8] * x[9] * x[10] +
        0.9735 * x[6] * x[7] * x[8] * x[9] - 0.5091 * x[6] * x[7] * x[8] * x[10] -
        0.0217 * x[6] * x[7] * x[9] * x[10] - 0.9406 * x[6] * x[8] * x[9] * x[10] -
        0.5301 * x[7] * x[8] * x[9] * x[10] <= 38.337
    )
    e3 = replace_expr(e3, x)
    JuMP.add_nonlinear_constraint(m, e3)
    e4 = :(
        0.802 * x[1] * x[2] - 0.8383 * x[1] * x[3] +
        0.3569 * x[1] * x[4] +
        0.0003 * x[1] * x[5] +
        0.8089 * x[1] * x[6] - 0.875 * x[1] * x[7] + 0.4462 * x[1] * x[8] -
        0.3338 * x[1] * x[9] + 0.1814 * x[1] * x[10] - 0.8771 * x[2] * x[3] -
        0.9101 * x[2] * x[4] + 0.1635 * x[2] * x[5] - 0.1352 * x[2] * x[6] -
        0.8026 * x[2] * x[7] +
        0.9155 * x[2] * x[8] +
        0.5442 * x[2] * x[9] - 0.7053 * x[2] * x[10] +
        0.4455 * x[3] * x[4] +
        0.9929 * x[3] * x[5] - 0.3529 * x[3] * x[6] - 0.8803 * x[3] * x[7] -
        0.9694 * x[3] * x[8] +
        0.7938 * x[3] * x[9] +
        0.664 * x[3] * x[10] +
        0.5083 * x[4] * x[5] - 0.3124 * x[4] * x[6] - 0.4061 * x[4] * x[7] +
        0.0858 * x[4] * x[8] - 0.2714 * x[4] * x[9] - 0.8232 * x[4] * x[10] -
        0.1146 * x[5] * x[6] +
        0.9703 * x[5] * x[7] +
        0.9858 * x[5] * x[8] +
        0.859 * x[5] * x[9] +
        0.0264 * x[5] * x[10] - 0.8325 * x[6] * x[7] - 0.2402 * x[6] * x[8] +
        0.9962 * x[6] * x[9] - 0.612 * x[6] * x[10] - 0.7468 * x[7] * x[8] +
        0.5066 * x[7] * x[9] +
        0.5209 * x[7] * x[10] - 0.8096 * x[8] * x[9] + 0.2097 * x[8] * x[10] -
        0.8223 * x[9] * x[10] +
        0.8219 * x[1] +
        0.8915 * x[2] +
        0.4384 * x[3] +
        0.0104 * x[4] - 0.6145 * x[5] + 0.3569 * x[6] - 0.0835 * x[7] -
        0.1778 * x[8] + 0.1688 * x[9] - 0.6302 * x[10] +
        (-0.9893 * x[1] * x[2] * x[3]) - 0.5615 * x[1] * x[2] * x[4] +
        0.7985 * x[1] * x[2] * x[5] +
        0.1976 * x[1] * x[2] * x[6] - 0.1837 * x[1] * x[2] * x[7] -
        0.7994 * x[1] * x[2] * x[8] - 0.7895 * x[1] * x[2] * x[9] +
        0.146 * x[1] * x[2] * x[10] - 0.5227 * x[1] * x[3] * x[4] +
        0.3006 * x[1] * x[3] * x[5] +
        0.8038 * x[1] * x[3] * x[6] - 0.0596 * x[1] * x[3] * x[7] +
        0.152 * x[1] * x[3] * x[8] +
        0.5178 * x[1] * x[3] * x[9] - 0.1747 * x[1] * x[3] * x[10] +
        0.9976 * x[1] * x[4] * x[5] +
        0.1196 * x[1] * x[4] * x[6] - 0.5697 * x[1] * x[4] * x[7] -
        0.8498 * x[1] * x[4] * x[8] - 0.6921 * x[1] * x[4] * x[9] -
        0.0832 * x[1] * x[4] * x[10] +
        0.7875 * x[1] * x[5] * x[6] +
        0.2374 * x[1] * x[5] * x[7] +
        0.2773 * x[1] * x[5] * x[8] +
        0.8304 * x[1] * x[5] * x[9] - 0.2771 * x[1] * x[5] * x[10] +
        0.8288 * x[1] * x[6] * x[7] - 0.6953 * x[1] * x[6] * x[8] +
        0.9491 * x[1] * x[6] * x[9] - 0.1701 * x[1] * x[6] * x[10] +
        0.4837 * x[1] * x[7] * x[8] - 0.9392 * x[1] * x[7] * x[9] -
        0.0295 * x[1] * x[7] * x[10] +
        0.8232 * x[1] * x[8] * x[9] +
        0.8049 * x[1] * x[8] * x[10] +
        0.8403 * x[1] * x[9] * x[10] +
        0.0402 * x[2] * x[3] * x[4] +
        0.4708 * x[2] * x[3] * x[5] +
        0.653 * x[2] * x[3] * x[6] +
        0.4072 * x[2] * x[3] * x[7] +
        0.3477 * x[2] * x[3] * x[8] - 0.8469 * x[2] * x[3] * x[9] -
        0.0643 * x[2] * x[3] * x[10] +
        0.9855 * x[2] * x[4] * x[5] +
        0.169 * x[2] * x[4] * x[6] +
        0.1277 * x[2] * x[4] * x[7] +
        0.1701 * x[2] * x[4] * x[8] - 0.2288 * x[2] * x[4] * x[9] +
        0.6269 * x[2] * x[4] * x[10] - 0.165 * x[2] * x[5] * x[6] -
        0.3328 * x[2] * x[5] * x[7] +
        0.0711 * x[2] * x[5] * x[8] +
        0.8548 * x[2] * x[5] * x[9] +
        0.4886 * x[2] * x[5] * x[10] - 0.4103 * x[2] * x[6] * x[7] +
        0.1394 * x[2] * x[6] * x[8] - 0.3792 * x[2] * x[6] * x[9] -
        0.061 * x[2] * x[6] * x[10] - 0.6923 * x[2] * x[7] * x[8] +
        0.194 * x[2] * x[7] * x[9] - 0.2253 * x[2] * x[7] * x[10] -
        0.6197 * x[2] * x[8] * x[9] - 0.799 * x[2] * x[8] * x[10] -
        0.9851 * x[2] * x[9] * x[10] - 0.164 * x[3] * x[4] * x[5] +
        0.1448 * x[3] * x[4] * x[6] +
        0.0185 * x[3] * x[4] * x[7] +
        0.3829 * x[3] * x[4] * x[8] +
        0.2687 * x[3] * x[4] * x[9] +
        0.9428 * x[3] * x[4] * x[10] +
        0.9418 * x[3] * x[5] * x[6] +
        0.4694 * x[3] * x[5] * x[7] +
        0.8523 * x[3] * x[5] * x[8] - 0.87 * x[3] * x[5] * x[9] -
        0.5796 * x[3] * x[5] * x[10] - 0.486 * x[3] * x[6] * x[7] +
        0.3746 * x[3] * x[6] * x[8] +
        0.4788 * x[3] * x[6] * x[9] +
        0.0586 * x[3] * x[6] * x[10] +
        0.1473 * x[3] * x[7] * x[8] +
        0.2498 * x[3] * x[7] * x[9] - 0.6388 * x[3] * x[7] * x[10] +
        0.2472 * x[3] * x[8] * x[9] - 0.3687 * x[3] * x[8] * x[10] +
        0.3536 * x[3] * x[9] * x[10] +
        0.0072 * x[4] * x[5] * x[6] - 0.5806 * x[4] * x[5] * x[7] -
        0.5058 * x[4] * x[5] * x[8] - 0.116 * x[4] * x[5] * x[9] +
        0.191 * x[4] * x[5] * x[10] +
        0.3699 * x[4] * x[6] * x[7] +
        0.3731 * x[4] * x[6] * x[8] +
        0.0031 * x[4] * x[6] * x[9] +
        0.9294 * x[4] * x[6] * x[10] - 0.6047 * x[4] * x[7] * x[8] +
        0.2348 * x[4] * x[7] * x[9] +
        0.8324 * x[4] * x[7] * x[10] +
        0.6608 * x[4] * x[8] * x[9] - 0.1673 * x[4] * x[8] * x[10] -
        0.9519 * x[4] * x[9] * x[10] + 0.8066 * x[5] * x[6] * x[7] -
        0.9313 * x[5] * x[6] * x[8] - 0.0297 * x[5] * x[6] * x[9] -
        0.7382 * x[5] * x[6] * x[10] - 0.672 * x[5] * x[7] * x[8] +
        0.3061 * x[5] * x[7] * x[9] - 0.1984 * x[5] * x[7] * x[10] -
        0.8696 * x[5] * x[8] * x[9] - 0.5035 * x[5] * x[8] * x[10] +
        0.2835 * x[5] * x[9] * x[10] +
        0.2576 * x[6] * x[7] * x[8] - 0.5016 * x[6] * x[7] * x[9] -
        0.738 * x[6] * x[7] * x[10] - 0.6402 * x[6] * x[8] * x[9] +
        0.2333 * x[6] * x[8] * x[10] - 0.1863 * x[6] * x[9] * x[10] +
        0.6045 * x[7] * x[8] * x[9] - 0.5819 * x[7] * x[8] * x[10] -
        0.809 * x[7] * x[9] * x[10] - 0.3189 * x[8] * x[9] * x[10] +
        0.8521 * x[1] * x[2] * x[3] * x[5] - 0.8164 * x[1] * x[2] * x[3] * x[4] +
        0.4163 * x[1] * x[2] * x[3] * x[6] +
        0.6625 * x[1] * x[2] * x[3] * x[7] +
        0.6022 * x[1] * x[2] * x[3] * x[8] +
        0.1782 * x[1] * x[2] * x[3] * x[9] +
        0.63 * x[1] * x[2] * x[3] * x[10] +
        0.4385 * x[1] * x[2] * x[4] * x[5] +
        0.9963 * x[1] * x[2] * x[4] * x[6] +
        0.8737 * x[1] * x[2] * x[4] * x[7] +
        0.382 * x[1] * x[2] * x[4] * x[8] +
        0.4417 * x[1] * x[2] * x[4] * x[9] +
        0.2669 * x[1] * x[2] * x[4] * x[10] +
        0.7712 * x[1] * x[2] * x[5] * x[6] +
        0.5226 * x[1] * x[2] * x[5] * x[7] +
        0.3681 * x[1] * x[2] * x[5] * x[8] +
        0.7255 * x[1] * x[2] * x[5] * x[9] - 0.4059 * x[1] * x[2] * x[5] * x[10] +
        0.9658 * x[1] * x[2] * x[6] * x[7] - 0.8057 * x[1] * x[2] * x[6] * x[8] +
        0.2716 * x[1] * x[2] * x[6] * x[9] - 0.8667 * x[1] * x[2] * x[6] * x[10] -
        0.6541 * x[1] * x[2] * x[7] * x[8] - 0.0723 * x[1] * x[2] * x[7] * x[9] -
        0.1218 * x[1] * x[2] * x[7] * x[10] + 0.6082 * x[1] * x[2] * x[8] * x[9] -
        0.1423 * x[1] * x[2] * x[8] * x[10] +
        0.5249 * x[1] * x[2] * x[9] * x[10] +
        0.4167 * x[1] * x[3] * x[4] * x[5] - 0.507 * x[1] * x[3] * x[4] * x[6] +
        0.8024 * x[1] * x[3] * x[4] * x[7] - 0.8732 * x[1] * x[3] * x[4] * x[8] -
        0.9641 * x[1] * x[3] * x[4] * x[9] + 0.8948 * x[1] * x[3] * x[4] * x[10] -
        0.0228 * x[1] * x[3] * x[5] * x[6] - 0.2308 * x[1] * x[3] * x[5] * x[7] -
        0.8365 * x[1] * x[3] * x[5] * x[8] - 0.0407 * x[1] * x[3] * x[5] * x[9] -
        0.6009 * x[1] * x[3] * x[5] * x[10] - 0.2916 * x[1] * x[3] * x[6] * x[7] -
        0.1374 * x[1] * x[3] * x[6] * x[8] +
        0.8125 * x[1] * x[3] * x[6] * x[9] +
        0.8725 * x[1] * x[3] * x[6] * x[10] +
        0.4909 * x[1] * x[3] * x[7] * x[8] +
        0.9356 * x[1] * x[3] * x[7] * x[9] +
        0.7571 * x[1] * x[3] * x[7] * x[10] - 0.4834 * x[1] * x[3] * x[8] * x[9] +
        0.5875 * x[1] * x[3] * x[8] * x[10] - 0.8418 * x[1] * x[3] * x[9] * x[10] -
        0.9637 * x[1] * x[4] * x[5] * x[6] - 0.3318 * x[1] * x[4] * x[5] * x[7] -
        0.3304 * x[1] * x[4] * x[5] * x[8] + 0.0086 * x[1] * x[4] * x[5] * x[9] -
        0.2382 * x[1] * x[4] * x[5] * x[10] + 0.7865 * x[1] * x[4] * x[6] * x[7] -
        0.4775 * x[1] * x[4] * x[6] * x[8] - 0.0112 * x[1] * x[4] * x[6] * x[9] +
        0.4793 * x[1] * x[4] * x[6] * x[10] +
        0.2361 * x[1] * x[4] * x[7] * x[8] +
        0.3537 * x[1] * x[4] * x[7] * x[9] +
        0.4693 * x[1] * x[4] * x[7] * x[10] +
        0.7316 * x[1] * x[4] * x[8] * x[9] +
        0.3182 * x[1] * x[4] * x[8] * x[10] +
        0.8041 * x[1] * x[4] * x[9] * x[10] - 0.4561 * x[1] * x[5] * x[6] * x[7] +
        0.8676 * x[1] * x[5] * x[6] * x[8] - 0.7196 * x[1] * x[5] * x[6] * x[9] -
        0.3273 * x[1] * x[5] * x[6] * x[10] - 0.0517 * x[1] * x[5] * x[7] * x[8] -
        0.9975 * x[1] * x[5] * x[7] * x[9] - 0.5365 * x[1] * x[5] * x[7] * x[10] +
        0.9168 * x[1] * x[5] * x[8] * x[9] +
        0.7715 * x[1] * x[5] * x[8] * x[10] +
        0.1129 * x[1] * x[5] * x[9] * x[10] - 0.3254 * x[1] * x[6] * x[7] * x[8] -
        0.6267 * x[1] * x[6] * x[7] * x[9] - 0.2341 * x[1] * x[6] * x[7] * x[10] +
        0.332 * x[1] * x[6] * x[8] * x[9] +
        0.8281 * x[1] * x[6] * x[8] * x[10] - 0.1747 * x[1] * x[6] * x[9] * x[10] +
        0.9767 * x[1] * x[7] * x[8] * x[9] - 0.6643 * x[1] * x[7] * x[8] * x[10] -
        0.7506 * x[1] * x[7] * x[9] * x[10] + 0.0168 * x[1] * x[8] * x[9] * x[10] -
        0.0513 * x[2] * x[3] * x[4] * x[5] - 0.6878 * x[2] * x[3] * x[4] * x[6] -
        0.0265 * x[2] * x[3] * x[4] * x[7] +
        0.6138 * x[2] * x[3] * x[4] * x[8] +
        0.9757 * x[2] * x[3] * x[4] * x[9] - 0.8293 * x[2] * x[3] * x[4] * x[10] +
        0.9219 * x[2] * x[3] * x[5] * x[6] +
        0.403 * x[2] * x[3] * x[5] * x[7] - 0.0383 * x[2] * x[3] * x[5] * x[8] -
        0.1156 * x[2] * x[3] * x[5] * x[9] - 0.9505 * x[2] * x[3] * x[5] * x[10] -
        0.5166 * x[2] * x[3] * x[6] * x[7] - 0.7652 * x[2] * x[3] * x[6] * x[8] -
        0.9915 * x[2] * x[3] * x[6] * x[9] - 0.477 * x[2] * x[3] * x[6] * x[10] +
        0.1948 * x[2] * x[3] * x[7] * x[8] - 0.9361 * x[2] * x[3] * x[7] * x[9] -
        0.0442 * x[2] * x[3] * x[7] * x[10] - 0.4517 * x[2] * x[3] * x[8] * x[9] -
        0.8448 * x[2] * x[3] * x[8] * x[10] - 0.8462 * x[2] * x[3] * x[9] * x[10] +
        0.7179 * x[2] * x[4] * x[5] * x[6] +
        0.1438 * x[2] * x[4] * x[5] * x[7] - 0.831 * x[2] * x[4] * x[5] * x[8] +
        0.1377 * x[2] * x[4] * x[5] * x[9] +
        0.2404 * x[2] * x[4] * x[5] * x[10] +
        0.4776 * x[2] * x[4] * x[6] * x[7] +
        0.9781 * x[2] * x[4] * x[6] * x[8] - 0.4061 * x[2] * x[4] * x[6] * x[9] -
        0.8912 * x[2] * x[4] * x[6] * x[10] +
        0.9125 * x[2] * x[4] * x[7] * x[8] +
        0.706 * x[2] * x[4] * x[7] * x[9] - 0.8906 * x[2] * x[4] * x[7] * x[10] +
        0.942 * x[2] * x[4] * x[8] * x[9] - 0.0261 * x[2] * x[4] * x[8] * x[10] -
        0.068 * x[2] * x[4] * x[9] * x[10] - 0.847 * x[2] * x[5] * x[6] * x[7] +
        0.5746 * x[2] * x[5] * x[6] * x[8] - 0.3526 * x[2] * x[5] * x[6] * x[9] +
        0.4389 * x[2] * x[5] * x[6] * x[10] +
        0.4542 * x[2] * x[5] * x[7] * x[8] +
        0.0367 * x[2] * x[5] * x[7] * x[9] - 0.3709 * x[2] * x[5] * x[7] * x[10] +
        0.8193 * x[2] * x[5] * x[8] * x[9] +
        0.5633 * x[2] * x[5] * x[8] * x[10] - 0.0382 * x[2] * x[5] * x[9] * x[10] -
        0.959 * x[2] * x[6] * x[7] * x[8] - 0.7036 * x[2] * x[6] * x[7] * x[9] +
        0.7485 * x[2] * x[6] * x[7] * x[10] - 0.0868 * x[2] * x[6] * x[8] * x[9] -
        0.6044 * x[2] * x[6] * x[8] * x[10] +
        0.3054 * x[2] * x[6] * x[9] * x[10] +
        0.6064 * x[2] * x[7] * x[8] * x[9] - 0.5288 * x[2] * x[7] * x[8] * x[10] -
        0.0285 * x[2] * x[7] * x[9] * x[10] - 0.5481 * x[2] * x[8] * x[9] * x[10] -
        0.7647 * x[3] * x[4] * x[5] * x[6] + 0.6671 * x[3] * x[4] * x[5] * x[7] -
        0.0921 * x[3] * x[4] * x[5] * x[8] + 0.7822 * x[3] * x[4] * x[5] * x[9] -
        0.688 * x[3] * x[4] * x[5] * x[10] - 0.623 * x[3] * x[4] * x[6] * x[7] -
        0.6958 * x[3] * x[4] * x[6] * x[8] +
        0.2072 * x[3] * x[4] * x[6] * x[9] +
        0.8573 * x[3] * x[4] * x[6] * x[10] +
        0.9353 * x[3] * x[4] * x[7] * x[8] - 0.7581 * x[3] * x[4] * x[7] * x[9] -
        0.6678 * x[3] * x[4] * x[7] * x[10] +
        0.7244 * x[3] * x[4] * x[8] * x[9] +
        0.497 * x[3] * x[4] * x[8] * x[10] +
        0.8841 * x[3] * x[4] * x[9] * x[10] - 0.419 * x[3] * x[5] * x[6] * x[7] -
        0.5639 * x[3] * x[5] * x[6] * x[8] +
        0.3384 * x[3] * x[5] * x[6] * x[9] +
        0.8517 * x[3] * x[5] * x[6] * x[10] +
        0.2487 * x[3] * x[5] * x[7] * x[8] +
        0.352 * x[3] * x[5] * x[7] * x[9] - 0.9956 * x[3] * x[5] * x[7] * x[10] +
        0.1963 * x[3] * x[5] * x[8] * x[9] +
        0.6505 * x[3] * x[5] * x[8] * x[10] +
        0.8868 * x[3] * x[5] * x[9] * x[10] +
        0.064 * x[3] * x[6] * x[7] * x[8] - 0.2306 * x[3] * x[6] * x[7] * x[9] +
        0.3456 * x[3] * x[6] * x[7] * x[10] - 0.0124 * x[3] * x[6] * x[8] * x[9] -
        0.7644 * x[3] * x[6] * x[8] * x[10] - 0.9407 * x[3] * x[6] * x[9] * x[10] -
        0.5041 * x[3] * x[7] * x[8] * x[9] - 0.4612 * x[3] * x[7] * x[8] * x[10] +
        0.6372 * x[3] * x[7] * x[9] * x[10] - 0.9423 * x[3] * x[8] * x[9] * x[10] +
        0.4769 * x[4] * x[5] * x[6] * x[7] +
        0.6691 * x[4] * x[5] * x[6] * x[8] - 0.6518 * x[4] * x[5] * x[6] * x[9] +
        0.5892 * x[4] * x[5] * x[6] * x[10] +
        0.1282 * x[4] * x[5] * x[7] * x[8] - 0.0097 * x[4] * x[5] * x[7] * x[9] -
        0.0037 * x[4] * x[5] * x[7] * x[10] - 0.4974 * x[4] * x[5] * x[8] * x[9] -
        0.1368 * x[4] * x[5] * x[8] * x[10] - 0.663 * x[4] * x[5] * x[9] * x[10] -
        0.3471 * x[4] * x[6] * x[7] * x[8] - 0.9665 * x[4] * x[6] * x[7] * x[9] -
        0.6331 * x[4] * x[6] * x[7] * x[10] - 0.0998 * x[4] * x[6] * x[8] * x[9] +
        0.9348 * x[4] * x[6] * x[8] * x[10] - 0.5585 * x[4] * x[6] * x[9] * x[10] -
        0.1588 * x[4] * x[7] * x[8] * x[9] + 0.3535 * x[4] * x[7] * x[8] * x[10] -
        0.5013 * x[4] * x[7] * x[9] * x[10] +
        0.5619 * x[4] * x[8] * x[9] * x[10] +
        0.6594 * x[5] * x[6] * x[7] * x[8] - 0.6765 * x[5] * x[6] * x[7] * x[9] +
        0.8412 * x[5] * x[6] * x[7] * x[10] - 0.6171 * x[5] * x[6] * x[8] * x[9] +
        0.5953 * x[5] * x[6] * x[8] * x[10] +
        0.9679 * x[5] * x[6] * x[9] * x[10] +
        0.7684 * x[5] * x[7] * x[8] * x[9] +
        0.3959 * x[5] * x[7] * x[8] * x[10] +
        0.61 * x[5] * x[7] * x[9] * x[10] +
        0.6235 * x[5] * x[8] * x[9] * x[10] - 0.2316 * x[6] * x[7] * x[8] * x[9] +
        0.2738 * x[6] * x[7] * x[8] * x[10] - 0.5261 * x[6] * x[7] * x[9] * x[10] +
        0.6011 * x[6] * x[8] * x[9] * x[10] +
        0.421 * x[7] * x[8] * x[9] * x[10] <= 52.864
    )
    e4 = replace_expr(e4, x)
    JuMP.add_nonlinear_constraint(m, e4)
    e5 = :(
        (-0.1375 * x[1] * x[2]) - 0.0134 * x[1] * x[3] - 0.7802 * x[1] * x[4] +
        0.1529 * x[1] * x[5] - 0.7427 * x[1] * x[6] + 0.034 * x[1] * x[7] -
        0.1986 * x[1] * x[8] + 0.1794 * x[1] * x[9] - 0.2451 * x[1] * x[10] -
        0.1578 * x[2] * x[3] +
        0.2522 * x[2] * x[4] +
        0.562 * x[2] * x[5] +
        0.9868 * x[2] * x[6] +
        0.0232 * x[2] * x[7] +
        0.5897 * x[2] * x[8] +
        0.1998 * x[2] * x[9] - 0.9026 * x[2] * x[10] + 0.5954 * x[3] * x[4] -
        0.0184 * x[3] * x[5] - 0.9132 * x[3] * x[6] - 0.0269 * x[3] * x[7] +
        0.5776 * x[3] * x[8] +
        0.2437 * x[3] * x[9] - 0.9638 * x[3] * x[10] + 0.4683 * x[4] * x[5] -
        0.0524 * x[4] * x[6] + 0.865 * x[4] * x[7] - 0.0714 * x[4] * x[8] -
        0.5196 * x[4] * x[9] +
        0.2146 * x[4] * x[10] +
        0.2514 * x[5] * x[6] - 0.9667 * x[5] * x[7] - 0.328 * x[5] * x[8] +
        0.185 * x[5] * x[9] - 0.1588 * x[5] * x[10] - 0.6343 * x[6] * x[7] +
        0.7847 * x[6] * x[8] +
        0.2423 * x[6] * x[9] - 0.357 * x[6] * x[10] - 0.2066 * x[7] * x[8] -
        0.1247 * x[7] * x[9] - 0.9086 * x[7] * x[10] - 0.4053 * x[8] * x[9] -
        0.6526 * x[8] * x[10] - 0.7753 * x[9] * x[10] +
        0.6139 * x[1] +
        0.0606 * x[2] - 0.4917 * x[3] + 0.82 * x[4] - 0.8487 * x[5] - 0.4958 * x[6] -
        0.4949 * x[7] +
        0.7862 * x[8] +
        0.7091 * x[9] - 0.6288 * x[10] + 0.496 * x[1] * x[2] * x[3] -
        0.6663 * x[1] * x[2] * x[4] + 0.2055 * x[1] * x[2] * x[5] -
        0.1878 * x[1] * x[2] * x[6] +
        0.5555 * x[1] * x[2] * x[7] +
        0.0953 * x[1] * x[2] * x[8] - 0.3364 * x[1] * x[2] * x[9] -
        0.0269 * x[1] * x[2] * x[10] + 0.958 * x[1] * x[3] * x[4] -
        0.871 * x[1] * x[3] * x[5] - 0.3226 * x[1] * x[3] * x[6] -
        0.8197 * x[1] * x[3] * x[7] - 0.1814 * x[1] * x[3] * x[8] -
        0.8487 * x[1] * x[3] * x[9] + 0.2095 * x[1] * x[3] * x[10] -
        0.2767 * x[1] * x[4] * x[5] - 0.3641 * x[1] * x[4] * x[6] -
        0.0245 * x[1] * x[4] * x[7] +
        0.4568 * x[1] * x[4] * x[8] +
        0.3128 * x[1] * x[4] * x[9] +
        0.4853 * x[1] * x[4] * x[10] +
        0.9152 * x[1] * x[5] * x[6] - 0.5344 * x[1] * x[5] * x[7] +
        0.9609 * x[1] * x[5] * x[8] +
        0.1761 * x[1] * x[5] * x[9] +
        0.344 * x[1] * x[5] * x[10] - 0.3941 * x[1] * x[6] * x[7] +
        0.8352 * x[1] * x[6] * x[8] - 0.8145 * x[1] * x[6] * x[9] +
        0.4713 * x[1] * x[6] * x[10] - 0.2967 * x[1] * x[7] * x[8] +
        0.1227 * x[1] * x[7] * x[9] +
        0.6128 * x[1] * x[7] * x[10] - 0.5156 * x[1] * x[8] * x[9] -
        0.1357 * x[1] * x[8] * x[10] + 0.4391 * x[1] * x[9] * x[10] -
        0.916 * x[2] * x[3] * x[4] - 0.9986 * x[2] * x[3] * x[5] +
        0.3863 * x[2] * x[3] * x[6] - 0.0975 * x[2] * x[3] * x[7] +
        0.8211 * x[2] * x[3] * x[8] +
        0.6467 * x[2] * x[3] * x[9] +
        0.054 * x[2] * x[3] * x[10] +
        0.0186 * x[2] * x[4] * x[5] +
        0.3056 * x[2] * x[4] * x[6] +
        0.6154 * x[2] * x[4] * x[7] +
        0.0074 * x[2] * x[4] * x[8] +
        0.4949 * x[2] * x[4] * x[9] +
        0.6723 * x[2] * x[4] * x[10] +
        0.3352 * x[2] * x[5] * x[6] +
        0.0008 * x[2] * x[5] * x[7] +
        0.5953 * x[2] * x[5] * x[8] - 0.6033 * x[2] * x[5] * x[9] +
        0.5045 * x[2] * x[5] * x[10] - 0.269 * x[2] * x[6] * x[7] +
        0.6495 * x[2] * x[6] * x[8] +
        0.8248 * x[2] * x[6] * x[9] - 0.6363 * x[2] * x[6] * x[10] +
        0.6394 * x[2] * x[7] * x[8] +
        0.1078 * x[2] * x[7] * x[9] +
        0.8161 * x[2] * x[7] * x[10] - 0.4037 * x[2] * x[8] * x[9] +
        0.2088 * x[2] * x[8] * x[10] - 0.6234 * x[2] * x[9] * x[10] -
        0.5131 * x[3] * x[4] * x[5] - 0.3159 * x[3] * x[4] * x[6] -
        0.3376 * x[3] * x[4] * x[7] - 0.8348 * x[3] * x[4] * x[8] -
        0.4805 * x[3] * x[4] * x[9] +
        0.8075 * x[3] * x[4] * x[10] +
        0.1383 * x[3] * x[5] * x[6] - 0.8913 * x[3] * x[5] * x[7] -
        0.4103 * x[3] * x[5] * x[8] + 0.4252 * x[3] * x[5] * x[9] -
        0.7663 * x[3] * x[5] * x[10] - 0.9546 * x[3] * x[6] * x[7] +
        0.1664 * x[3] * x[6] * x[8] - 0.1357 * x[3] * x[6] * x[9] +
        0.843 * x[3] * x[6] * x[10] - 0.4141 * x[3] * x[7] * x[8] +
        0.9824 * x[3] * x[7] * x[9] +
        0.8706 * x[3] * x[7] * x[10] +
        0.3098 * x[3] * x[8] * x[9] - 0.8453 * x[3] * x[8] * x[10] +
        0.4691 * x[3] * x[9] * x[10] - 0.4006 * x[4] * x[5] * x[6] +
        0.3848 * x[4] * x[5] * x[7] +
        0.9792 * x[4] * x[5] * x[8] - 0.4612 * x[4] * x[5] * x[9] -
        0.9516 * x[4] * x[5] * x[10] - 0.4543 * x[4] * x[6] * x[7] +
        0.5378 * x[4] * x[6] * x[8] - 0.8641 * x[4] * x[6] * x[9] +
        0.6423 * x[4] * x[6] * x[10] - 0.8484 * x[4] * x[7] * x[8] -
        0.3092 * x[4] * x[7] * x[9] +
        0.6513 * x[4] * x[7] * x[10] +
        0.0055 * x[4] * x[8] * x[9] +
        0.0029 * x[4] * x[8] * x[10] +
        0.9821 * x[4] * x[9] * x[10] +
        0.477 * x[5] * x[6] * x[7] +
        0.9873 * x[5] * x[6] * x[8] +
        0.2413 * x[5] * x[6] * x[9] +
        0.3671 * x[5] * x[6] * x[10] - 0.2025 * x[5] * x[7] * x[8] -
        0.5689 * x[5] * x[7] * x[9] +
        0.6425 * x[5] * x[7] * x[10] +
        0.4043 * x[5] * x[8] * x[9] - 0.2493 * x[5] * x[8] * x[10] -
        0.4849 * x[5] * x[9] * x[10] + 0.3103 * x[6] * x[7] * x[8] -
        0.2523 * x[6] * x[7] * x[9] +
        0.7611 * x[6] * x[7] * x[10] +
        0.3698 * x[6] * x[8] * x[9] - 0.8896 * x[6] * x[8] * x[10] +
        0.7634 * x[6] * x[9] * x[10] - 0.3524 * x[7] * x[8] * x[9] -
        0.7996 * x[7] * x[8] * x[10] +
        0.4739 * x[7] * x[9] * x[10] +
        0.5203 * x[8] * x[9] * x[10] +
        0.8851 * x[1] * x[2] * x[3] * x[4] +
        0.9515 * x[1] * x[2] * x[3] * x[5] - 0.0604 * x[1] * x[2] * x[3] * x[6] -
        0.8915 * x[1] * x[2] * x[3] * x[7] - 0.0968 * x[1] * x[2] * x[3] * x[8] -
        0.5954 * x[1] * x[2] * x[3] * x[9] - 0.902 * x[1] * x[2] * x[3] * x[10] +
        0.9315 * x[1] * x[2] * x[4] * x[5] +
        0.4294 * x[1] * x[2] * x[4] * x[6] +
        0.7398 * x[1] * x[2] * x[4] * x[7] - 0.6759 * x[1] * x[2] * x[4] * x[8] -
        0.0166 * x[1] * x[2] * x[4] * x[9] + 0.3176 * x[1] * x[2] * x[4] * x[10] -
        0.434 * x[1] * x[2] * x[5] * x[6] - 0.8219 * x[1] * x[2] * x[5] * x[7] -
        0.9323 * x[1] * x[2] * x[5] * x[8] - 0.2384 * x[1] * x[2] * x[5] * x[9] +
        0.2604 * x[1] * x[2] * x[5] * x[10] +
        0.4567 * x[1] * x[2] * x[6] * x[7] +
        0.7508 * x[1] * x[2] * x[6] * x[8] +
        0.1384 * x[1] * x[2] * x[6] * x[9] - 0.5557 * x[1] * x[2] * x[6] * x[10] -
        0.2385 * x[1] * x[2] * x[7] * x[8] +
        0.0199 * x[1] * x[2] * x[7] * x[9] +
        0.7632 * x[1] * x[2] * x[7] * x[10] - 0.9947 * x[1] * x[2] * x[8] * x[9] -
        0.3877 * x[1] * x[2] * x[8] * x[10] + 0.8177 * x[1] * x[2] * x[9] * x[10] -
        0.3725 * x[1] * x[3] * x[4] * x[5] - 0.3487 * x[1] * x[3] * x[4] * x[6] -
        0.8521 * x[1] * x[3] * x[4] * x[7] + 0.7201 * x[1] * x[3] * x[4] * x[8] -
        0.9411 * x[1] * x[3] * x[4] * x[9] - 0.6075 * x[1] * x[3] * x[4] * x[10] +
        0.4446 * x[1] * x[3] * x[5] * x[6] - 0.6889 * x[1] * x[3] * x[5] * x[7] +
        0.5368 * x[1] * x[3] * x[5] * x[8] +
        0.9675 * x[1] * x[3] * x[5] * x[9] - 0.1386 * x[1] * x[3] * x[5] * x[10] -
        0.4474 * x[1] * x[3] * x[6] * x[7] - 0.8875 * x[1] * x[3] * x[6] * x[8] -
        0.7171 * x[1] * x[3] * x[6] * x[9] - 0.2179 * x[1] * x[3] * x[6] * x[10] -
        0.317 * x[1] * x[3] * x[7] * x[8] - 0.0332 * x[1] * x[3] * x[7] * x[9] -
        0.625 * x[1] * x[3] * x[7] * x[10] +
        0.2913 * x[1] * x[3] * x[8] * x[9] +
        0.0755 * x[1] * x[3] * x[8] * x[10] - 0.0178 * x[1] * x[3] * x[9] * x[10] -
        0.215 * x[1] * x[4] * x[5] * x[6] - 0.7588 * x[1] * x[4] * x[5] * x[7] +
        0.2416 * x[1] * x[4] * x[5] * x[8] - 0.1383 * x[1] * x[4] * x[5] * x[9] +
        0.2175 * x[1] * x[4] * x[5] * x[10] - 0.5311 * x[1] * x[4] * x[6] * x[7] -
        0.6322 * x[1] * x[4] * x[6] * x[8] - 0.8211 * x[1] * x[4] * x[6] * x[9] -
        0.2421 * x[1] * x[4] * x[6] * x[10] - 0.9794 * x[1] * x[4] * x[7] * x[8] +
        0.6866 * x[1] * x[4] * x[7] * x[9] +
        0.144 * x[1] * x[4] * x[7] * x[10] +
        0.935 * x[1] * x[4] * x[8] * x[9] - 0.7224 * x[1] * x[4] * x[8] * x[10] -
        0.79 * x[1] * x[4] * x[9] * x[10] - 0.6261 * x[1] * x[5] * x[6] * x[7] -
        0.59 * x[1] * x[5] * x[6] * x[8] +
        0.8708 * x[1] * x[5] * x[6] * x[9] +
        0.5423 * x[1] * x[5] * x[6] * x[10] +
        0.3356 * x[1] * x[5] * x[7] * x[8] +
        0.142 * x[1] * x[5] * x[7] * x[9] +
        0.5119 * x[1] * x[5] * x[7] * x[10] +
        0.7599 * x[1] * x[5] * x[8] * x[9] - 0.4022 * x[1] * x[5] * x[8] * x[10] +
        0.4446 * x[1] * x[5] * x[9] * x[10] - 0.8166 * x[1] * x[6] * x[7] * x[8] +
        0.6446 * x[1] * x[6] * x[7] * x[9] - 0.1284 * x[1] * x[6] * x[7] * x[10] -
        0.3651 * x[1] * x[6] * x[8] * x[9] - 0.2567 * x[1] * x[6] * x[8] * x[10] +
        0.1421 * x[1] * x[6] * x[9] * x[10] - 0.8825 * x[1] * x[7] * x[8] * x[9] -
        0.6058 * x[1] * x[7] * x[8] * x[10] + 0.503 * x[1] * x[7] * x[9] * x[10] -
        0.0462 * x[1] * x[8] * x[9] * x[10] - 0.717 * x[2] * x[3] * x[4] * x[5] +
        0.0253 * x[2] * x[3] * x[4] * x[6] - 0.9476 * x[2] * x[3] * x[4] * x[7] -
        0.3171 * x[2] * x[3] * x[4] * x[8] + 0.5691 * x[2] * x[3] * x[4] * x[9] -
        0.3612 * x[2] * x[3] * x[4] * x[10] +
        0.0488 * x[2] * x[3] * x[5] * x[6] +
        0.423 * x[2] * x[3] * x[5] * x[7] +
        0.2762 * x[2] * x[3] * x[5] * x[8] +
        0.0221 * x[2] * x[3] * x[5] * x[9] +
        0.3975 * x[2] * x[3] * x[5] * x[10] - 0.5281 * x[2] * x[3] * x[6] * x[7] -
        0.722 * x[2] * x[3] * x[6] * x[8] - 0.1433 * x[2] * x[3] * x[6] * x[9] +
        0.1957 * x[2] * x[3] * x[6] * x[10] +
        0.7882 * x[2] * x[3] * x[7] * x[8] +
        0.9988 * x[2] * x[3] * x[7] * x[9] +
        0.8552 * x[2] * x[3] * x[7] * x[10] +
        0.3681 * x[2] * x[3] * x[8] * x[9] - 0.6187 * x[2] * x[3] * x[8] * x[10] -
        0.2208 * x[2] * x[3] * x[9] * x[10] - 0.8222 * x[2] * x[4] * x[5] * x[6] +
        0.3944 * x[2] * x[4] * x[5] * x[7] +
        0.4808 * x[2] * x[4] * x[5] * x[8] - 0.8075 * x[2] * x[4] * x[5] * x[9] -
        0.8579 * x[2] * x[4] * x[5] * x[10] - 0.5665 * x[2] * x[4] * x[6] * x[7] -
        0.895 * x[2] * x[4] * x[6] * x[8] - 0.3975 * x[2] * x[4] * x[6] * x[9] +
        0.4934 * x[2] * x[4] * x[6] * x[10] +
        0.2624 * x[2] * x[4] * x[7] * x[8] +
        0.2931 * x[2] * x[4] * x[7] * x[9] - 0.8108 * x[2] * x[4] * x[7] * x[10] -
        0.6769 * x[2] * x[4] * x[8] * x[9] - 0.2571 * x[2] * x[4] * x[8] * x[10] +
        0.1818 * x[2] * x[4] * x[9] * x[10] - 0.5706 * x[2] * x[5] * x[6] * x[7] +
        0.6166 * x[2] * x[5] * x[6] * x[8] - 0.7727 * x[2] * x[5] * x[6] * x[9] -
        0.2887 * x[2] * x[5] * x[6] * x[10] - 0.6625 * x[2] * x[5] * x[7] * x[8] -
        0.4673 * x[2] * x[5] * x[7] * x[9] + 0.9985 * x[2] * x[5] * x[7] * x[10] -
        0.0513 * x[2] * x[5] * x[8] * x[9] - 0.243 * x[2] * x[5] * x[8] * x[10] +
        0.9283 * x[2] * x[5] * x[9] * x[10] - 0.9095 * x[2] * x[6] * x[7] * x[8] +
        0.0583 * x[2] * x[6] * x[7] * x[9] +
        0.823 * x[2] * x[6] * x[7] * x[10] - 0.5969 * x[2] * x[6] * x[8] * x[9] +
        0.8222 * x[2] * x[6] * x[8] * x[10] - 0.0405 * x[2] * x[6] * x[9] * x[10] -
        0.131 * x[2] * x[7] * x[8] * x[9] - 0.3485 * x[2] * x[7] * x[8] * x[10] +
        0.8998 * x[2] * x[7] * x[9] * x[10] - 0.2805 * x[2] * x[8] * x[9] * x[10] +
        0.5217 * x[3] * x[4] * x[5] * x[6] - 0.933 * x[3] * x[4] * x[5] * x[7] +
        0.9836 * x[3] * x[4] * x[5] * x[8] - 0.9513 * x[3] * x[4] * x[5] * x[9] -
        0.9415 * x[3] * x[4] * x[5] * x[10] - 0.4551 * x[3] * x[4] * x[6] * x[7] +
        0.4972 * x[3] * x[4] * x[6] * x[8] - 0.429 * x[3] * x[4] * x[6] * x[9] -
        0.5465 * x[3] * x[4] * x[6] * x[10] - 0.1411 * x[3] * x[4] * x[7] * x[8] +
        0.5444 * x[3] * x[4] * x[7] * x[9] +
        0.1779 * x[3] * x[4] * x[7] * x[10] +
        0.0402 * x[3] * x[4] * x[8] * x[9] - 0.9732 * x[3] * x[4] * x[8] * x[10] -
        0.3496 * x[3] * x[4] * x[9] * x[10] - 0.2575 * x[3] * x[5] * x[6] * x[7] +
        0.6694 * x[3] * x[5] * x[6] * x[8] - 0.4773 * x[3] * x[5] * x[6] * x[9] +
        0.4754 * x[3] * x[5] * x[6] * x[10] - 0.9142 * x[3] * x[5] * x[7] * x[8] +
        0.6845 * x[3] * x[5] * x[7] * x[9] - 0.7219 * x[3] * x[5] * x[7] * x[10] +
        0.7798 * x[3] * x[5] * x[8] * x[9] +
        0.0733 * x[3] * x[5] * x[8] * x[10] - 0.7376 * x[3] * x[5] * x[9] * x[10] +
        0.0256 * x[3] * x[6] * x[7] * x[8] - 0.2386 * x[3] * x[6] * x[7] * x[9] +
        0.8016 * x[3] * x[6] * x[7] * x[10] +
        0.6794 * x[3] * x[6] * x[8] * x[9] +
        0.6011 * x[3] * x[6] * x[8] * x[10] - 0.1622 * x[3] * x[6] * x[9] * x[10] -
        0.0369 * x[3] * x[7] * x[8] * x[9] - 0.5992 * x[3] * x[7] * x[8] * x[10] +
        0.9241 * x[3] * x[7] * x[9] * x[10] +
        0.9873 * x[3] * x[8] * x[9] * x[10] +
        0.5992 * x[4] * x[5] * x[6] * x[7] +
        0.8133 * x[4] * x[5] * x[6] * x[8] +
        0.4239 * x[4] * x[5] * x[6] * x[9] - 0.1981 * x[4] * x[5] * x[6] * x[10] +
        0.5006 * x[4] * x[5] * x[7] * x[8] - 0.5385 * x[4] * x[5] * x[7] * x[9] +
        0.1593 * x[4] * x[5] * x[7] * x[10] - 0.0871 * x[4] * x[5] * x[8] * x[9] -
        0.9382 * x[4] * x[5] * x[8] * x[10] - 0.0148 * x[4] * x[5] * x[9] * x[10] -
        0.4904 * x[4] * x[6] * x[7] * x[8] + 0.5096 * x[4] * x[6] * x[7] * x[9] -
        0.4809 * x[4] * x[6] * x[7] * x[10] - 0.4848 * x[4] * x[6] * x[8] * x[9] +
        0.3062 * x[4] * x[6] * x[8] * x[10] +
        0.9318 * x[4] * x[6] * x[9] * x[10] - 0.1853 * x[4] * x[7] * x[8] * x[9] +
        0.5946 * x[4] * x[7] * x[8] * x[10] - 0.9998 * x[4] * x[7] * x[9] * x[10] +
        0.054 * x[4] * x[8] * x[9] * x[10] +
        0.9006 * x[5] * x[6] * x[7] * x[8] - 0.322 * x[5] * x[6] * x[7] * x[9] -
        0.4127 * x[5] * x[6] * x[7] * x[10] - 0.6934 * x[5] * x[6] * x[8] * x[9] +
        0.408 * x[5] * x[6] * x[8] * x[10] - 0.6923 * x[5] * x[6] * x[9] * x[10] -
        0.0869 * x[5] * x[7] * x[8] * x[9] - 0.0219 * x[5] * x[7] * x[8] * x[10] +
        0.4814 * x[5] * x[7] * x[9] * x[10] - 0.0782 * x[5] * x[8] * x[9] * x[10] -
        0.3978 * x[6] * x[7] * x[8] * x[9] - 0.0586 * x[6] * x[7] * x[8] * x[10] +
        0.8491 * x[6] * x[7] * x[9] * x[10] - 0.9975 * x[6] * x[8] * x[9] * x[10] +
        0.5027 * x[7] * x[8] * x[9] * x[10] <= 85.414
    )
    e5 = replace_expr(e5, x)
    JuMP.add_nonlinear_constraint(m, e5)
    e6 = :(
        (-0.4481 * x[1] * x[2]) - 0.0269 * x[1] * x[3] - 0.1364 * x[1] * x[4] -
        0.9192 * x[1] * x[5] +
        0.5189 * x[1] * x[6] +
        0.3404 * x[1] * x[7] +
        0.1516 * x[1] * x[8] +
        0.4074 * x[1] * x[9] - 0.3842 * x[1] * x[10] + 0.4361 * x[2] * x[3] -
        0.6147 * x[2] * x[4] - 0.8 * x[2] * x[5] + 0.1892 * x[2] * x[6] -
        0.8637 * x[2] * x[7] +
        0.3065 * x[2] * x[8] +
        0.2325 * x[2] * x[9] +
        0.2648 * x[2] * x[10] +
        0.3826 * x[3] * x[4] +
        0.6438 * x[3] * x[5] - 0.5217 * x[3] * x[6] +
        0.3787 * x[3] * x[7] +
        0.7293 * x[3] * x[8] - 0.1202 * x[3] * x[9] +
        0.5314 * x[3] * x[10] +
        0.2886 * x[4] * x[5] - 0.4004 * x[4] * x[6] - 0.3376 * x[4] * x[7] -
        0.9079 * x[4] * x[8] - 0.4125 * x[4] * x[9] +
        0.8876 * x[4] * x[10] +
        0.3379 * x[5] * x[6] - 0.2619 * x[5] * x[7] - 0.7405 * x[5] * x[8] +
        0.1524 * x[5] * x[9] +
        0.8941 * x[5] * x[10] +
        0.2131 * x[6] * x[7] - 0.3442 * x[6] * x[8] + 0.5042 * x[6] * x[9] -
        0.931 * x[6] * x[10] + 0.6521 * x[7] * x[8] - 0.3237 * x[7] * x[9] +
        0.27 * x[7] * x[10] +
        0.2362 * x[8] * x[9] +
        0.5923 * x[8] * x[10] +
        0.986 * x[9] * x[10] - 0.0644 * x[1] + 0.6635 * x[2] - 0.7397 * x[3] +
        0.942 * x[4] - 0.6956 * x[5] +
        0.7189 * x[6] +
        0.2027 * x[7] +
        0.7485 * x[8] +
        0.4619 * x[9] +
        0.0043 * x[10] +
        (-0.4047 * x[1] * x[2] * x[3]) - 0.8727 * x[1] * x[2] * x[4] -
        0.014 * x[1] * x[2] * x[5] - 0.9627 * x[1] * x[2] * x[6] -
        0.15 * x[1] * x[2] * x[7] - 0.7809 * x[1] * x[2] * x[8] -
        0.4473 * x[1] * x[2] * x[9] +
        0.4151 * x[1] * x[2] * x[10] +
        0.0728 * x[1] * x[3] * x[4] - 0.2027 * x[1] * x[3] * x[5] -
        0.4616 * x[1] * x[3] * x[6] +
        0.1176 * x[1] * x[3] * x[7] +
        0.108 * x[1] * x[3] * x[8] +
        0.3765 * x[1] * x[3] * x[9] +
        0.305 * x[1] * x[3] * x[10] - 0.5298 * x[1] * x[4] * x[5] -
        0.0275 * x[1] * x[4] * x[6] - 0.8101 * x[1] * x[4] * x[7] -
        0.4449 * x[1] * x[4] * x[8] - 0.8782 * x[1] * x[4] * x[9] -
        0.6795 * x[1] * x[4] * x[10] - 0.8655 * x[1] * x[5] * x[6] -
        0.6457 * x[1] * x[5] * x[7] + 0.8807 * x[1] * x[5] * x[8] -
        0.7634 * x[1] * x[5] * x[9] + 0.217 * x[1] * x[5] * x[10] -
        0.0549 * x[1] * x[6] * x[7] - 0.9422 * x[1] * x[6] * x[8] -
        0.9389 * x[1] * x[6] * x[9] - 0.2805 * x[1] * x[6] * x[10] -
        0.3906 * x[1] * x[7] * x[8] +
        0.8925 * x[1] * x[7] * x[9] +
        0.359 * x[1] * x[7] * x[10] - 0.3714 * x[1] * x[8] * x[9] -
        0.5488 * x[1] * x[8] * x[10] +
        0.1483 * x[1] * x[9] * x[10] +
        0.225 * x[2] * x[3] * x[4] +
        0.7272 * x[2] * x[3] * x[5] - 0.8881 * x[2] * x[3] * x[6] -
        0.0211 * x[2] * x[3] * x[7] - 0.4108 * x[2] * x[3] * x[8] -
        0.0434 * x[2] * x[3] * x[9] - 0.7799 * x[2] * x[3] * x[10] -
        0.4614 * x[2] * x[4] * x[5] - 0.0865 * x[2] * x[4] * x[6] +
        0.3207 * x[2] * x[4] * x[7] +
        0.0431 * x[2] * x[4] * x[8] +
        0.8559 * x[2] * x[4] * x[9] - 0.2257 * x[2] * x[4] * x[10] -
        0.1022 * x[2] * x[5] * x[6] - 0.5768 * x[2] * x[5] * x[7] -
        0.8797 * x[2] * x[5] * x[8] +
        0.3955 * x[2] * x[5] * x[9] +
        0.7964 * x[2] * x[5] * x[10] +
        0.2734 * x[2] * x[6] * x[7] +
        0.0895 * x[2] * x[6] * x[8] - 0.4146 * x[2] * x[6] * x[9] +
        0.9077 * x[2] * x[6] * x[10] - 0.1895 * x[2] * x[7] * x[8] +
        0.994 * x[2] * x[7] * x[9] - 0.6899 * x[2] * x[7] * x[10] +
        0.9394 * x[2] * x[8] * x[9] - 0.2503 * x[2] * x[8] * x[10] -
        0.2187 * x[2] * x[9] * x[10] - 0.1793 * x[3] * x[4] * x[5] +
        0.9029 * x[3] * x[4] * x[6] +
        0.1218 * x[3] * x[4] * x[7] +
        0.2453 * x[3] * x[4] * x[8] +
        0.7306 * x[3] * x[4] * x[9] - 0.2001 * x[3] * x[4] * x[10] +
        0.7936 * x[3] * x[5] * x[6] - 0.7984 * x[3] * x[5] * x[7] -
        0.589 * x[3] * x[5] * x[8] + 0.6958 * x[3] * x[5] * x[9] -
        0.0455 * x[3] * x[5] * x[10] - 0.267 * x[3] * x[6] * x[7] +
        0.8622 * x[3] * x[6] * x[8] - 0.5897 * x[3] * x[6] * x[9] +
        0.1178 * x[3] * x[6] * x[10] +
        0.8772 * x[3] * x[7] * x[8] - 0.7239 * x[3] * x[7] * x[9] +
        0.8153 * x[3] * x[7] * x[10] +
        0.9875 * x[3] * x[8] * x[9] +
        0.0661 * x[3] * x[8] * x[10] +
        0.0747 * x[3] * x[9] * x[10] - 0.9466 * x[4] * x[5] * x[6] +
        0.9993 * x[4] * x[5] * x[7] +
        0.4921 * x[4] * x[5] * x[8] +
        0.1736 * x[4] * x[5] * x[9] - 0.5295 * x[4] * x[5] * x[10] -
        0.5874 * x[4] * x[6] * x[7] - 0.9963 * x[4] * x[6] * x[8] -
        0.6875 * x[4] * x[6] * x[9] - 0.6238 * x[4] * x[6] * x[10] +
        0.0738 * x[4] * x[7] * x[8] +
        0.3122 * x[4] * x[7] * x[9] +
        0.9116 * x[4] * x[7] * x[10] - 0.7073 * x[4] * x[8] * x[9] +
        0.3956 * x[4] * x[8] * x[10] +
        0.6408 * x[4] * x[9] * x[10] +
        0.906 * x[5] * x[6] * x[7] +
        0.4384 * x[5] * x[6] * x[8] - 0.0051 * x[5] * x[6] * x[9] +
        0.689 * x[5] * x[6] * x[10] +
        0.8015 * x[5] * x[7] * x[8] - 0.1671 * x[5] * x[7] * x[9] +
        0.1501 * x[5] * x[7] * x[10] - 0.6129 * x[5] * x[8] * x[9] -
        0.4673 * x[5] * x[8] * x[10] - 0.2172 * x[5] * x[9] * x[10] +
        0.5448 * x[6] * x[7] * x[8] +
        0.5743 * x[6] * x[7] * x[9] - 0.2467 * x[6] * x[7] * x[10] +
        0.8448 * x[6] * x[8] * x[9] - 0.784 * x[6] * x[8] * x[10] -
        0.2975 * x[6] * x[9] * x[10] - 0.9803 * x[7] * x[8] * x[9] +
        0.9786 * x[7] * x[8] * x[10] +
        0.1967 * x[7] * x[9] * x[10] - 0.9423 * x[8] * x[9] * x[10] +
        0.4814 * x[1] * x[2] * x[3] * x[4] +
        0.1703 * x[1] * x[2] * x[3] * x[5] +
        0.511 * x[1] * x[2] * x[3] * x[6] +
        0.9122 * x[1] * x[2] * x[3] * x[7] +
        0.1772 * x[1] * x[2] * x[3] * x[8] +
        0.6143 * x[1] * x[2] * x[3] * x[9] +
        0.0351 * x[1] * x[2] * x[3] * x[10] - 0.6117 * x[1] * x[2] * x[4] * x[5] +
        0.6903 * x[1] * x[2] * x[4] * x[6] +
        0.8105 * x[1] * x[2] * x[4] * x[7] +
        0.3583 * x[1] * x[2] * x[4] * x[8] +
        0.296 * x[1] * x[2] * x[4] * x[9] +
        0.6876 * x[1] * x[2] * x[4] * x[10] - 0.393 * x[1] * x[2] * x[5] * x[6] -
        0.3819 * x[1] * x[2] * x[5] * x[7] - 0.3434 * x[1] * x[2] * x[5] * x[8] +
        0.498 * x[1] * x[2] * x[5] * x[9] +
        0.3344 * x[1] * x[2] * x[5] * x[10] - 0.6604 * x[1] * x[2] * x[6] * x[7] +
        0.1448 * x[1] * x[2] * x[6] * x[8] - 0.2679 * x[1] * x[2] * x[6] * x[9] -
        0.9699 * x[1] * x[2] * x[6] * x[10] + 0.4874 * x[1] * x[2] * x[7] * x[8] -
        0.2642 * x[1] * x[2] * x[7] * x[9] +
        0.0611 * x[1] * x[2] * x[7] * x[10] +
        0.1584 * x[1] * x[2] * x[8] * x[9] - 0.3937 * x[1] * x[2] * x[8] * x[10] +
        0.9029 * x[1] * x[2] * x[9] * x[10] - 0.3443 * x[1] * x[3] * x[4] * x[5] +
        0.1484 * x[1] * x[3] * x[4] * x[6] +
        0.4433 * x[1] * x[3] * x[4] * x[7] +
        0.3218 * x[1] * x[3] * x[4] * x[8] - 0.2226 * x[1] * x[3] * x[4] * x[9] +
        0.3904 * x[1] * x[3] * x[4] * x[10] +
        0.6146 * x[1] * x[3] * x[5] * x[6] - 0.8245 * x[1] * x[3] * x[5] * x[7] +
        0.8728 * x[1] * x[3] * x[5] * x[8] - 0.3059 * x[1] * x[3] * x[5] * x[9] +
        0.8877 * x[1] * x[3] * x[5] * x[10] +
        0.1024 * x[1] * x[3] * x[6] * x[7] +
        0.1653 * x[1] * x[3] * x[6] * x[8] - 0.3166 * x[1] * x[3] * x[6] * x[9] +
        0.13 * x[1] * x[3] * x[6] * x[10] - 0.4146 * x[1] * x[3] * x[7] * x[8] -
        0.0127 * x[1] * x[3] * x[7] * x[9] +
        0.4993 * x[1] * x[3] * x[7] * x[10] +
        0.6925 * x[1] * x[3] * x[8] * x[9] - 0.0677 * x[1] * x[3] * x[8] * x[10] -
        0.2175 * x[1] * x[3] * x[9] * x[10] + 0.828 * x[1] * x[4] * x[5] * x[6] -
        0.1967 * x[1] * x[4] * x[5] * x[7] + 0.4211 * x[1] * x[4] * x[5] * x[8] -
        0.2497 * x[1] * x[4] * x[5] * x[9] + 0.462 * x[1] * x[4] * x[5] * x[10] -
        0.7244 * x[1] * x[4] * x[6] * x[7] + 0.5054 * x[1] * x[4] * x[6] * x[8] -
        0.6719 * x[1] * x[4] * x[6] * x[9] +
        0.2062 * x[1] * x[4] * x[6] * x[10] +
        0.4854 * x[1] * x[4] * x[7] * x[8] - 0.8001 * x[1] * x[4] * x[7] * x[9] +
        0.4813 * x[1] * x[4] * x[7] * x[10] - 0.2475 * x[1] * x[4] * x[8] * x[9] +
        0.659 * x[1] * x[4] * x[8] * x[10] - 0.8335 * x[1] * x[4] * x[9] * x[10] +
        0.2203 * x[1] * x[5] * x[6] * x[7] +
        0.8903 * x[1] * x[5] * x[6] * x[8] - 0.7647 * x[1] * x[5] * x[6] * x[9] +
        0.5881 * x[1] * x[5] * x[6] * x[10] - 0.3864 * x[1] * x[5] * x[7] * x[8] -
        0.5257 * x[1] * x[5] * x[7] * x[9] - 0.5672 * x[1] * x[5] * x[7] * x[10] -
        0.0589 * x[1] * x[5] * x[8] * x[9] - 0.1993 * x[1] * x[5] * x[8] * x[10] -
        0.4537 * x[1] * x[5] * x[9] * x[10] +
        0.7725 * x[1] * x[6] * x[7] * x[8] +
        0.1709 * x[1] * x[6] * x[7] * x[9] - 0.0676 * x[1] * x[6] * x[7] * x[10] -
        0.6013 * x[1] * x[6] * x[8] * x[9] + 0.8428 * x[1] * x[6] * x[8] * x[10] -
        0.6915 * x[1] * x[6] * x[9] * x[10] +
        0.8838 * x[1] * x[7] * x[8] * x[9] +
        0.9223 * x[1] * x[7] * x[8] * x[10] +
        0.5193 * x[1] * x[7] * x[9] * x[10] +
        0.3182 * x[1] * x[8] * x[9] * x[10] - 0.221 * x[2] * x[3] * x[4] * x[5] +
        0.6815 * x[2] * x[3] * x[4] * x[6] - 0.0966 * x[2] * x[3] * x[4] * x[7] -
        0.1797 * x[2] * x[3] * x[4] * x[8] - 0.7994 * x[2] * x[3] * x[4] * x[9] +
        0.6868 * x[2] * x[3] * x[4] * x[10] +
        0.4518 * x[2] * x[3] * x[5] * x[6] +
        0.8514 * x[2] * x[3] * x[5] * x[7] +
        0.6759 * x[2] * x[3] * x[5] * x[8] - 0.6871 * x[2] * x[3] * x[5] * x[9] +
        0.6584 * x[2] * x[3] * x[5] * x[10] - 0.2458 * x[2] * x[3] * x[6] * x[7] +
        0.6472 * x[2] * x[3] * x[6] * x[8] - 0.3359 * x[2] * x[3] * x[6] * x[9] -
        0.863 * x[2] * x[3] * x[6] * x[10] +
        0.1233 * x[2] * x[3] * x[7] * x[8] +
        0.6612 * x[2] * x[3] * x[7] * x[9] +
        0.2013 * x[2] * x[3] * x[7] * x[10] +
        0.6938 * x[2] * x[3] * x[8] * x[9] - 0.7642 * x[2] * x[3] * x[8] * x[10] +
        0.3951 * x[2] * x[3] * x[9] * x[10] - 0.3524 * x[2] * x[4] * x[5] * x[6] -
        0.9741 * x[2] * x[4] * x[5] * x[7] + 0.6833 * x[2] * x[4] * x[5] * x[8] -
        0.4752 * x[2] * x[4] * x[5] * x[9] - 0.3353 * x[2] * x[4] * x[5] * x[10] +
        0.9698 * x[2] * x[4] * x[6] * x[7] - 0.9741 * x[2] * x[4] * x[6] * x[8] -
        0.1607 * x[2] * x[4] * x[6] * x[9] +
        0.7583 * x[2] * x[4] * x[6] * x[10] +
        0.803 * x[2] * x[4] * x[7] * x[8] - 0.4884 * x[2] * x[4] * x[7] * x[9] +
        0.459 * x[2] * x[4] * x[7] * x[10] +
        0.7593 * x[2] * x[4] * x[8] * x[9] +
        0.3966 * x[2] * x[4] * x[8] * x[10] +
        0.2922 * x[2] * x[4] * x[9] * x[10] - 0.8999 * x[2] * x[5] * x[6] * x[7] -
        0.3177 * x[2] * x[5] * x[6] * x[8] + 0.2054 * x[2] * x[5] * x[6] * x[9] -
        0.0702 * x[2] * x[5] * x[6] * x[10] - 0.1661 * x[2] * x[5] * x[7] * x[8] +
        0.949 * x[2] * x[5] * x[7] * x[9] +
        0.8319 * x[2] * x[5] * x[7] * x[10] - 0.2402 * x[2] * x[5] * x[8] * x[9] +
        0.3515 * x[2] * x[5] * x[8] * x[10] - 0.6997 * x[2] * x[5] * x[9] * x[10] +
        0.7683 * x[2] * x[6] * x[7] * x[8] - 0.6599 * x[2] * x[6] * x[7] * x[9] +
        0.1491 * x[2] * x[6] * x[7] * x[10] +
        0.4292 * x[2] * x[6] * x[8] * x[9] +
        0.5753 * x[2] * x[6] * x[8] * x[10] - 0.2752 * x[2] * x[6] * x[9] * x[10] -
        0.7367 * x[2] * x[7] * x[8] * x[9] +
        0.2302 * x[2] * x[7] * x[8] * x[10] +
        0.9897 * x[2] * x[7] * x[9] * x[10] - 0.5626 * x[2] * x[8] * x[9] * x[10] -
        0.3133 * x[3] * x[4] * x[5] * x[6] - 0.113 * x[3] * x[4] * x[5] * x[7] +
        0.3194 * x[3] * x[4] * x[5] * x[8] +
        0.4135 * x[3] * x[4] * x[5] * x[9] - 0.4578 * x[3] * x[4] * x[5] * x[10] -
        0.4937 * x[3] * x[4] * x[6] * x[7] +
        0.2359 * x[3] * x[4] * x[6] * x[8] +
        0.2791 * x[3] * x[4] * x[6] * x[9] - 0.8753 * x[3] * x[4] * x[6] * x[10] -
        0.8146 * x[3] * x[4] * x[7] * x[8] +
        0.3627 * x[3] * x[4] * x[7] * x[9] +
        0.6978 * x[3] * x[4] * x[7] * x[10] - 0.1502 * x[3] * x[4] * x[8] * x[9] +
        0.8516 * x[3] * x[4] * x[8] * x[10] - 0.8482 * x[3] * x[4] * x[9] * x[10] -
        0.7326 * x[3] * x[5] * x[6] * x[7] + 0.3347 * x[3] * x[5] * x[6] * x[8] -
        0.3677 * x[3] * x[5] * x[6] * x[9] +
        0.8576 * x[3] * x[5] * x[6] * x[10] +
        0.8423 * x[3] * x[5] * x[7] * x[8] +
        0.4222 * x[3] * x[5] * x[7] * x[9] +
        0.3568 * x[3] * x[5] * x[7] * x[10] +
        0.1597 * x[3] * x[5] * x[8] * x[9] +
        0.2008 * x[3] * x[5] * x[8] * x[10] +
        0.6678 * x[3] * x[5] * x[9] * x[10] - 0.7699 * x[3] * x[6] * x[7] * x[8] +
        0.6536 * x[3] * x[6] * x[7] * x[9] - 0.4263 * x[3] * x[6] * x[7] * x[10] +
        0.5469 * x[3] * x[6] * x[8] * x[9] +
        0.6991 * x[3] * x[6] * x[8] * x[10] +
        0.4764 * x[3] * x[6] * x[9] * x[10] - 0.6822 * x[3] * x[7] * x[8] * x[9] -
        0.709 * x[3] * x[7] * x[8] * x[10] - 0.6123 * x[3] * x[7] * x[9] * x[10] -
        0.6075 * x[3] * x[8] * x[9] * x[10] - 0.6624 * x[4] * x[5] * x[6] * x[7] +
        0.3302 * x[4] * x[5] * x[6] * x[8] +
        0.6541 * x[4] * x[5] * x[6] * x[9] - 0.6579 * x[4] * x[5] * x[6] * x[10] -
        0.5587 * x[4] * x[5] * x[7] * x[8] - 0.1261 * x[4] * x[5] * x[7] * x[9] +
        0.8603 * x[4] * x[5] * x[7] * x[10] +
        0.1445 * x[4] * x[5] * x[8] * x[9] - 0.773 * x[4] * x[5] * x[8] * x[10] +
        0.1692 * x[4] * x[5] * x[9] * x[10] +
        0.8432 * x[4] * x[6] * x[7] * x[8] +
        0.8133 * x[4] * x[6] * x[7] * x[9] +
        0.1169 * x[4] * x[6] * x[7] * x[10] - 0.1312 * x[4] * x[6] * x[8] * x[9] +
        0.9717 * x[4] * x[6] * x[8] * x[10] +
        0.3126 * x[4] * x[6] * x[9] * x[10] +
        0.4154 * x[4] * x[7] * x[8] * x[9] - 0.0105 * x[4] * x[7] * x[8] * x[10] +
        0.4772 * x[4] * x[7] * x[9] * x[10] +
        0.1875 * x[4] * x[8] * x[9] * x[10] +
        0.9525 * x[5] * x[6] * x[7] * x[8] - 0.3099 * x[5] * x[6] * x[7] * x[9] -
        0.239 * x[5] * x[6] * x[7] * x[10] +
        0.5059 * x[5] * x[6] * x[8] * x[9] +
        0.466 * x[5] * x[6] * x[8] * x[10] - 0.334 * x[5] * x[6] * x[9] * x[10] +
        0.8077 * x[5] * x[7] * x[8] * x[9] +
        0.3148 * x[5] * x[7] * x[8] * x[10] - 0.4982 * x[5] * x[7] * x[9] * x[10] +
        0.2499 * x[5] * x[8] * x[9] * x[10] - 0.4484 * x[6] * x[7] * x[8] * x[9] +
        0.0002 * x[6] * x[7] * x[8] * x[10] +
        0.9242 * x[6] * x[7] * x[9] * x[10] - 0.3877 * x[6] * x[8] * x[9] * x[10] -
        0.776 * x[7] * x[8] * x[9] * x[10] <= 91.904
    )
    e6 = replace_expr(e6, x)
    JuMP.add_nonlinear_constraint(m, e6)
    e7 = :(
        0.1493 * x[1] * x[2] - 0.0821 * x[1] * x[3] + 0.497 * x[1] * x[4] -
        0.9345 * x[1] * x[5] +
        0.4136 * x[1] * x[6] +
        0.7518 * x[1] * x[7] - 0.343 * x[1] * x[8] - 0.4928 * x[1] * x[9] +
        0.7599 * x[1] * x[10] +
        0.6319 * x[2] * x[3] - 0.8854 * x[2] * x[4] +
        0.7768 * x[2] * x[5] +
        0.0498 * x[2] * x[6] - 0.87 * x[2] * x[7] + 0.2151 * x[2] * x[8] -
        0.5144 * x[2] * x[9] - 0.4663 * x[2] * x[10] - 0.7141 * x[3] * x[4] +
        0.3885 * x[3] * x[5] +
        0.8542 * x[3] * x[6] +
        0.7864 * x[3] * x[7] +
        0.2841 * x[3] * x[8] - 0.2428 * x[3] * x[9] - 0.8116 * x[3] * x[10] +
        0.8953 * x[4] * x[5] +
        0.2995 * x[4] * x[6] - 0.2316 * x[4] * x[7] - 0.7342 * x[4] * x[8] +
        0.3091 * x[4] * x[9] - 0.114 * x[4] * x[10] - 0.6494 * x[5] * x[6] -
        0.5173 * x[5] * x[7] - 0.7047 * x[5] * x[8] - 0.764 * x[5] * x[9] -
        0.2591 * x[5] * x[10] - 0.6065 * x[6] * x[7] - 0.5798 * x[6] * x[8] +
        0.1489 * x[6] * x[9] - 0.7814 * x[6] * x[10] + 0.0265 * x[7] * x[8] -
        0.0071 * x[7] * x[9] - 0.985 * x[7] * x[10] +
        0.9441 * x[8] * x[9] +
        0.4356 * x[8] * x[10] +
        0.9238 * x[9] * x[10] - 0.8049 * x[1] - 0.4609 * x[2] + 0.0185 * x[3] -
        0.5567 * x[4] +
        0.5428 * x[5] +
        0.8039 * x[6] - 0.7982 * x[7] +
        0.433 * x[8] +
        0.3945 * x[9] - 0.8879 * x[10] + 0.7921 * x[1] * x[2] * x[4] -
        0.9752 * x[1] * x[2] * x[3] - 0.6234 * x[1] * x[2] * x[5] -
        0.2596 * x[1] * x[2] * x[6] +
        0.038 * x[1] * x[2] * x[7] +
        0.7493 * x[1] * x[2] * x[8] +
        0.0256 * x[1] * x[2] * x[9] - 0.457 * x[1] * x[2] * x[10] -
        0.3738 * x[1] * x[3] * x[4] + 0.2854 * x[1] * x[3] * x[5] -
        0.4543 * x[1] * x[3] * x[6] - 0.03 * x[1] * x[3] * x[7] -
        0.9105 * x[1] * x[3] * x[8] - 0.7535 * x[1] * x[3] * x[9] -
        0.1891 * x[1] * x[3] * x[10] +
        0.6336 * x[1] * x[4] * x[5] +
        0.1559 * x[1] * x[4] * x[6] - 0.3327 * x[1] * x[4] * x[7] -
        0.0413 * x[1] * x[4] * x[8] - 0.3352 * x[1] * x[4] * x[9] -
        0.9197 * x[1] * x[4] * x[10] - 0.3498 * x[1] * x[5] * x[6] -
        0.3321 * x[1] * x[5] * x[7] + 0.3069 * x[1] * x[5] * x[8] -
        0.6815 * x[1] * x[5] * x[9] - 0.9023 * x[1] * x[5] * x[10] -
        0.3243 * x[1] * x[6] * x[7] - 0.7002 * x[1] * x[6] * x[8] +
        0.8733 * x[1] * x[6] * x[9] +
        0.7257 * x[1] * x[6] * x[10] +
        0.807 * x[1] * x[7] * x[8] - 0.3247 * x[1] * x[7] * x[9] +
        0.751 * x[1] * x[7] * x[10] - 0.1371 * x[1] * x[8] * x[9] +
        0.3378 * x[1] * x[8] * x[10] +
        0.4854 * x[1] * x[9] * x[10] +
        0.6818 * x[2] * x[3] * x[4] - 0.2154 * x[2] * x[3] * x[5] +
        0.9713 * x[2] * x[3] * x[6] +
        0.0508 * x[2] * x[3] * x[7] - 0.0821 * x[2] * x[3] * x[8] -
        0.2744 * x[2] * x[3] * x[9] +
        0.3301 * x[2] * x[3] * x[10] +
        0.0977 * x[2] * x[4] * x[5] +
        0.7447 * x[2] * x[4] * x[6] +
        0.152 * x[2] * x[4] * x[7] +
        0.6629 * x[2] * x[4] * x[8] - 0.8393 * x[2] * x[4] * x[9] +
        0.1067 * x[2] * x[4] * x[10] - 0.9084 * x[2] * x[5] * x[6] +
        0.761 * x[2] * x[5] * x[7] +
        0.5597 * x[2] * x[5] * x[8] - 0.2003 * x[2] * x[5] * x[9] -
        0.9542 * x[2] * x[5] * x[10] - 0.1824 * x[2] * x[6] * x[7] -
        0.8383 * x[2] * x[6] * x[8] - 0.6698 * x[2] * x[6] * x[9] +
        0.0278 * x[2] * x[6] * x[10] - 0.6996 * x[2] * x[7] * x[8] -
        0.3721 * x[2] * x[7] * x[9] - 0.0097 * x[2] * x[7] * x[10] -
        0.1389 * x[2] * x[8] * x[9] - 0.1557 * x[2] * x[8] * x[10] +
        0.3259 * x[2] * x[9] * x[10] +
        0.2066 * x[3] * x[4] * x[5] +
        0.4973 * x[3] * x[4] * x[6] - 0.0794 * x[3] * x[4] * x[7] +
        0.9822 * x[3] * x[4] * x[8] +
        0.9661 * x[3] * x[4] * x[9] - 0.7344 * x[3] * x[4] * x[10] +
        0.5813 * x[3] * x[5] * x[6] - 0.0259 * x[3] * x[5] * x[7] -
        0.8178 * x[3] * x[5] * x[8] +
        0.1696 * x[3] * x[5] * x[9] +
        0.0474 * x[3] * x[5] * x[10] - 0.6102 * x[3] * x[6] * x[7] +
        0.3413 * x[3] * x[6] * x[8] - 0.0321 * x[3] * x[6] * x[9] +
        0.3867 * x[3] * x[6] * x[10] - 0.9594 * x[3] * x[7] * x[8] -
        0.0941 * x[3] * x[7] * x[9] +
        0.2824 * x[3] * x[7] * x[10] +
        0.2279 * x[3] * x[8] * x[9] - 0.2678 * x[3] * x[8] * x[10] +
        0.8357 * x[3] * x[9] * x[10] - 0.1385 * x[4] * x[5] * x[6] -
        0.0028 * x[4] * x[5] * x[7] +
        0.6343 * x[4] * x[5] * x[8] +
        0.6558 * x[4] * x[5] * x[9] - 0.3929 * x[4] * x[5] * x[10] +
        0.5754 * x[4] * x[6] * x[7] +
        0.5376 * x[4] * x[6] * x[8] - 0.9033 * x[4] * x[6] * x[9] -
        0.3758 * x[4] * x[6] * x[10] +
        0.0538 * x[4] * x[7] * x[8] +
        0.5201 * x[4] * x[7] * x[9] +
        0.0502 * x[4] * x[7] * x[10] +
        0.6526 * x[4] * x[8] * x[9] +
        0.3788 * x[4] * x[8] * x[10] - 0.2957 * x[4] * x[9] * x[10] +
        0.2894 * x[5] * x[6] * x[7] - 0.7789 * x[5] * x[6] * x[8] -
        0.7901 * x[5] * x[6] * x[9] +
        0.4762 * x[5] * x[6] * x[10] +
        0.4641 * x[5] * x[7] * x[8] +
        0.4006 * x[5] * x[7] * x[9] +
        0.9277 * x[5] * x[7] * x[10] +
        0.1455 * x[5] * x[8] * x[9] - 0.2138 * x[5] * x[8] * x[10] +
        0.5281 * x[5] * x[9] * x[10] - 0.3557 * x[6] * x[7] * x[8] +
        0.9451 * x[6] * x[7] * x[9] +
        0.3845 * x[6] * x[7] * x[10] - 0.931 * x[6] * x[8] * x[9] -
        0.7231 * x[6] * x[8] * x[10] - 0.1203 * x[6] * x[9] * x[10] +
        0.6813 * x[7] * x[8] * x[9] - 0.1748 * x[7] * x[8] * x[10] -
        0.893 * x[7] * x[9] * x[10] +
        0.3339 * x[8] * x[9] * x[10] +
        (-0.8394 * x[1] * x[2] * x[3] * x[4]) - 0.7701 * x[1] * x[2] * x[3] * x[5] -
        0.3017 * x[1] * x[2] * x[3] * x[6] - 0.2722 * x[1] * x[2] * x[3] * x[7] +
        0.4795 * x[1] * x[2] * x[3] * x[8] +
        0.3531 * x[1] * x[2] * x[3] * x[9] +
        0.2825 * x[1] * x[2] * x[3] * x[10] +
        0.3274 * x[1] * x[2] * x[4] * x[5] - 0.4461 * x[1] * x[2] * x[4] * x[6] +
        0.2588 * x[1] * x[2] * x[4] * x[7] +
        0.5324 * x[1] * x[2] * x[4] * x[8] - 0.6424 * x[1] * x[2] * x[4] * x[9] -
        0.573 * x[1] * x[2] * x[4] * x[10] +
        0.6427 * x[1] * x[2] * x[5] * x[6] +
        0.1464 * x[1] * x[2] * x[5] * x[7] +
        0.7913 * x[1] * x[2] * x[5] * x[8] +
        0.0191 * x[1] * x[2] * x[5] * x[9] +
        0.6857 * x[1] * x[2] * x[5] * x[10] +
        0.3674 * x[1] * x[2] * x[6] * x[7] - 0.7488 * x[1] * x[2] * x[6] * x[8] -
        0.9634 * x[1] * x[2] * x[6] * x[9] - 0.2154 * x[1] * x[2] * x[6] * x[10] +
        0.9814 * x[1] * x[2] * x[7] * x[8] +
        0.3058 * x[1] * x[2] * x[7] * x[9] - 0.5648 * x[1] * x[2] * x[7] * x[10] +
        0.043 * x[1] * x[2] * x[8] * x[9] +
        0.3748 * x[1] * x[2] * x[8] * x[10] - 0.1711 * x[1] * x[2] * x[9] * x[10] +
        0.1803 * x[1] * x[3] * x[4] * x[5] - 0.3642 * x[1] * x[3] * x[4] * x[6] +
        0.4124 * x[1] * x[3] * x[4] * x[7] +
        0.2058 * x[1] * x[3] * x[4] * x[8] +
        0.2026 * x[1] * x[3] * x[4] * x[9] +
        0.3626 * x[1] * x[3] * x[4] * x[10] +
        0.5458 * x[1] * x[3] * x[5] * x[6] - 0.0222 * x[1] * x[3] * x[5] * x[7] -
        0.7975 * x[1] * x[3] * x[5] * x[8] - 0.5112 * x[1] * x[3] * x[5] * x[9] +
        0.0613 * x[1] * x[3] * x[5] * x[10] +
        0.769 * x[1] * x[3] * x[6] * x[7] +
        0.701 * x[1] * x[3] * x[6] * x[8] - 0.7641 * x[1] * x[3] * x[6] * x[9] +
        0.3574 * x[1] * x[3] * x[6] * x[10] - 0.0437 * x[1] * x[3] * x[7] * x[8] +
        0.7193 * x[1] * x[3] * x[7] * x[9] +
        0.4535 * x[1] * x[3] * x[7] * x[10] +
        0.5978 * x[1] * x[3] * x[8] * x[9] +
        0.0133 * x[1] * x[3] * x[8] * x[10] +
        0.8512 * x[1] * x[3] * x[9] * x[10] - 0.6772 * x[1] * x[4] * x[5] * x[6] +
        0.5878 * x[1] * x[4] * x[5] * x[7] - 0.3585 * x[1] * x[4] * x[5] * x[8] +
        0.1872 * x[1] * x[4] * x[5] * x[9] +
        0.0589 * x[1] * x[4] * x[5] * x[10] - 0.3317 * x[1] * x[4] * x[6] * x[7] +
        0.7479 * x[1] * x[4] * x[6] * x[8] - 0.9671 * x[1] * x[4] * x[6] * x[9] +
        0.9391 * x[1] * x[4] * x[6] * x[10] +
        0.9018 * x[1] * x[4] * x[7] * x[8] +
        0.32 * x[1] * x[4] * x[7] * x[9] +
        0.6027 * x[1] * x[4] * x[7] * x[10] - 0.6141 * x[1] * x[4] * x[8] * x[9] +
        0.531 * x[1] * x[4] * x[8] * x[10] +
        0.2639 * x[1] * x[4] * x[9] * x[10] +
        0.3663 * x[1] * x[5] * x[6] * x[7] - 0.233 * x[1] * x[5] * x[6] * x[8] +
        0.4189 * x[1] * x[5] * x[6] * x[9] +
        0.4041 * x[1] * x[5] * x[6] * x[10] +
        0.304 * x[1] * x[5] * x[7] * x[8] +
        0.3126 * x[1] * x[5] * x[7] * x[9] +
        0.0481 * x[1] * x[5] * x[7] * x[10] - 0.5275 * x[1] * x[5] * x[8] * x[9] -
        0.1305 * x[1] * x[5] * x[8] * x[10] - 0.6678 * x[1] * x[5] * x[9] * x[10] -
        0.5155 * x[1] * x[6] * x[7] * x[8] +
        0.5784 * x[1] * x[6] * x[7] * x[9] +
        0.0016 * x[1] * x[6] * x[7] * x[10] - 0.1111 * x[1] * x[6] * x[8] * x[9] -
        0.3946 * x[1] * x[6] * x[8] * x[10] - 0.98 * x[1] * x[6] * x[9] * x[10] -
        0.1806 * x[1] * x[7] * x[8] * x[9] + 0.988 * x[1] * x[7] * x[8] * x[10] -
        0.6747 * x[1] * x[7] * x[9] * x[10] - 0.3078 * x[1] * x[8] * x[9] * x[10] +
        0.2953 * x[2] * x[3] * x[4] * x[5] - 0.8559 * x[2] * x[3] * x[4] * x[6] +
        0.3771 * x[2] * x[3] * x[4] * x[7] - 0.6117 * x[2] * x[3] * x[4] * x[8] +
        0.1766 * x[2] * x[3] * x[4] * x[9] +
        0.472 * x[2] * x[3] * x[4] * x[10] - 0.1445 * x[2] * x[3] * x[5] * x[6] -
        0.1965 * x[2] * x[3] * x[5] * x[7] +
        0.5678 * x[2] * x[3] * x[5] * x[8] +
        0.8256 * x[2] * x[3] * x[5] * x[9] - 0.0288 * x[2] * x[3] * x[5] * x[10] -
        0.0473 * x[2] * x[3] * x[6] * x[7] +
        0.1173 * x[2] * x[3] * x[6] * x[8] +
        0.6063 * x[2] * x[3] * x[6] * x[9] - 0.8786 * x[2] * x[3] * x[6] * x[10] +
        0.8495 * x[2] * x[3] * x[7] * x[8] +
        0.1714 * x[2] * x[3] * x[7] * x[9] +
        0.4934 * x[2] * x[3] * x[7] * x[10] - 0.7093 * x[2] * x[3] * x[8] * x[9] -
        0.5405 * x[2] * x[3] * x[8] * x[10] + 0.7902 * x[2] * x[3] * x[9] * x[10] -
        0.333 * x[2] * x[4] * x[5] * x[6] +
        0.9342 * x[2] * x[4] * x[5] * x[7] +
        0.6046 * x[2] * x[4] * x[5] * x[8] - 0.7882 * x[2] * x[4] * x[5] * x[9] +
        0.4245 * x[2] * x[4] * x[5] * x[10] - 0.3577 * x[2] * x[4] * x[6] * x[7] -
        0.6746 * x[2] * x[4] * x[6] * x[8] - 0.1915 * x[2] * x[4] * x[6] * x[9] -
        0.0401 * x[2] * x[4] * x[6] * x[10] - 0.9931 * x[2] * x[4] * x[7] * x[8] +
        0.0294 * x[2] * x[4] * x[7] * x[9] +
        0.5066 * x[2] * x[4] * x[7] * x[10] +
        0.9387 * x[2] * x[4] * x[8] * x[9] +
        0.4504 * x[2] * x[4] * x[8] * x[10] - 0.8174 * x[2] * x[4] * x[9] * x[10] -
        0.1996 * x[2] * x[5] * x[6] * x[7] +
        0.3514 * x[2] * x[5] * x[6] * x[8] +
        0.316 * x[2] * x[5] * x[6] * x[9] +
        0.6336 * x[2] * x[5] * x[6] * x[10] - 0.5032 * x[2] * x[5] * x[7] * x[8] -
        0.4267 * x[2] * x[5] * x[7] * x[9] - 0.9986 * x[2] * x[5] * x[7] * x[10] -
        0.5176 * x[2] * x[5] * x[8] * x[9] - 0.9889 * x[2] * x[5] * x[8] * x[10] -
        0.2244 * x[2] * x[5] * x[9] * x[10] - 0.1486 * x[2] * x[6] * x[7] * x[8] +
        0.4237 * x[2] * x[6] * x[7] * x[9] +
        0.7526 * x[2] * x[6] * x[7] * x[10] +
        0.3702 * x[2] * x[6] * x[8] * x[9] - 0.0792 * x[2] * x[6] * x[8] * x[10] +
        0.3093 * x[2] * x[6] * x[9] * x[10] - 0.3792 * x[2] * x[7] * x[8] * x[9] +
        0.5826 * x[2] * x[7] * x[8] * x[10] - 0.027 * x[2] * x[7] * x[9] * x[10] +
        0.2429 * x[2] * x[8] * x[9] * x[10] +
        0.4158 * x[3] * x[4] * x[5] * x[6] - 0.5107 * x[3] * x[4] * x[5] * x[7] -
        0.3875 * x[3] * x[4] * x[5] * x[8] - 0.8247 * x[3] * x[4] * x[5] * x[9] -
        0.1237 * x[3] * x[4] * x[5] * x[10] - 0.9108 * x[3] * x[4] * x[6] * x[7] +
        0.8865 * x[3] * x[4] * x[6] * x[8] - 0.2339 * x[3] * x[4] * x[6] * x[9] -
        0.3238 * x[3] * x[4] * x[6] * x[10] + 0.3171 * x[3] * x[4] * x[7] * x[8] -
        0.7991 * x[3] * x[4] * x[7] * x[9] + 0.8642 * x[3] * x[4] * x[7] * x[10] -
        0.3354 * x[3] * x[4] * x[8] * x[9] - 0.9854 * x[3] * x[4] * x[8] * x[10] +
        0.6736 * x[3] * x[4] * x[9] * x[10] +
        0.9472 * x[3] * x[5] * x[6] * x[7] - 0.6774 * x[3] * x[5] * x[6] * x[8] +
        0.2819 * x[3] * x[5] * x[6] * x[9] - 0.8312 * x[3] * x[5] * x[6] * x[10] +
        0.9588 * x[3] * x[5] * x[7] * x[8] +
        0.6607 * x[3] * x[5] * x[7] * x[9] - 0.7955 * x[3] * x[5] * x[7] * x[10] -
        0.3957 * x[3] * x[5] * x[8] * x[9] - 0.7523 * x[3] * x[5] * x[8] * x[10] -
        0.232 * x[3] * x[5] * x[9] * x[10] + 0.7743 * x[3] * x[6] * x[7] * x[8] -
        0.4182 * x[3] * x[6] * x[7] * x[9] - 0.8409 * x[3] * x[6] * x[7] * x[10] +
        0.2953 * x[3] * x[6] * x[8] * x[9] - 0.6522 * x[3] * x[6] * x[8] * x[10] +
        0.2996 * x[3] * x[6] * x[9] * x[10] - 0.319 * x[3] * x[7] * x[8] * x[9] +
        0.092 * x[3] * x[7] * x[8] * x[10] - 0.9485 * x[3] * x[7] * x[9] * x[10] +
        0.7382 * x[3] * x[8] * x[9] * x[10] - 0.1359 * x[4] * x[5] * x[6] * x[7] +
        0.3935 * x[4] * x[5] * x[6] * x[8] +
        0.8373 * x[4] * x[5] * x[6] * x[9] +
        0.8982 * x[4] * x[5] * x[6] * x[10] - 0.5906 * x[4] * x[5] * x[7] * x[8] -
        0.1772 * x[4] * x[5] * x[7] * x[9] + 0.834 * x[4] * x[5] * x[7] * x[10] -
        0.6971 * x[4] * x[5] * x[8] * x[9] - 0.5593 * x[4] * x[5] * x[8] * x[10] +
        0.5782 * x[4] * x[5] * x[9] * x[10] - 0.0524 * x[4] * x[6] * x[7] * x[8] +
        0.3458 * x[4] * x[6] * x[7] * x[9] - 0.5235 * x[4] * x[6] * x[7] * x[10] -
        0.1639 * x[4] * x[6] * x[8] * x[9] +
        0.8372 * x[4] * x[6] * x[8] * x[10] +
        0.6061 * x[4] * x[6] * x[9] * x[10] - 0.0421 * x[4] * x[7] * x[8] * x[9] +
        0.0078 * x[4] * x[7] * x[8] * x[10] +
        0.992 * x[4] * x[7] * x[9] * x[10] - 0.9383 * x[4] * x[8] * x[9] * x[10] +
        0.3232 * x[5] * x[6] * x[7] * x[8] - 0.1077 * x[5] * x[6] * x[7] * x[9] -
        0.6034 * x[5] * x[6] * x[7] * x[10] +
        0.5167 * x[5] * x[6] * x[8] * x[9] +
        0.5893 * x[5] * x[6] * x[8] * x[10] +
        0.3498 * x[5] * x[6] * x[9] * x[10] +
        0.9897 * x[5] * x[7] * x[8] * x[9] - 0.4292 * x[5] * x[7] * x[8] * x[10] +
        0.6811 * x[5] * x[7] * x[9] * x[10] - 0.9318 * x[5] * x[8] * x[9] * x[10] -
        0.628 * x[6] * x[7] * x[8] * x[9] - 0.7347 * x[6] * x[7] * x[8] * x[10] -
        0.6338 * x[6] * x[7] * x[9] * x[10] - 0.0089 * x[6] * x[8] * x[9] * x[10] +
        0.435 * x[7] * x[8] * x[9] * x[10] <= 46.589
    )
    e7 = replace_expr(e7, x)
    JuMP.add_nonlinear_constraint(m, e7)
    e8 = :(
        0.0457 * x[1] * x[2] + 0.9914 * x[1] * x[3] - 0.2043 * x[1] * x[4] -
        0.8175 * x[1] * x[5] - 0.3506 * x[1] * x[6] +
        0.8449 * x[1] * x[7] +
        0.9969 * x[1] * x[8] +
        0.7066 * x[1] * x[9] +
        0.7814 * x[1] * x[10] - 0.2681 * x[2] * x[3] +
        0.1122 * x[2] * x[4] +
        0.5142 * x[2] * x[5] +
        0.5563 * x[2] * x[6] +
        0.7168 * x[2] * x[7] +
        0.1767 * x[2] * x[8] - 0.4082 * x[2] * x[9] +
        0.6883 * x[2] * x[10] +
        0.4342 * x[3] * x[4] +
        0.2648 * x[3] * x[5] +
        0.3778 * x[3] * x[6] - 0.8064 * x[3] * x[7] +
        0.6143 * x[3] * x[8] +
        0.0073 * x[3] * x[9] - 0.385 * x[3] * x[10] - 0.1292 * x[4] * x[5] +
        0.0795 * x[4] * x[6] - 0.3467 * x[4] * x[7] +
        0.4255 * x[4] * x[8] +
        0.5645 * x[4] * x[9] - 0.6424 * x[4] * x[10] + 0.0119 * x[5] * x[6] -
        0.6729 * x[5] * x[7] +
        0.5847 * x[5] * x[8] +
        0.7055 * x[5] * x[9] +
        0.325 * x[5] * x[10] +
        0.2792 * x[6] * x[7] +
        0.0091 * x[6] * x[8] - 0.8959 * x[6] * x[9] - 0.2254 * x[6] * x[10] +
        0.718 * x[7] * x[8] +
        0.7289 * x[7] * x[9] +
        0.0895 * x[7] * x[10] - 0.3158 * x[8] * x[9] - 0.6424 * x[8] * x[10] -
        0.4076 * x[9] * x[10] - 0.7606 * x[1] - 0.4835 * x[2] + 0.7128 * x[3] -
        0.7993 * x[4] + 0.1586 * x[5] - 0.2892 * x[6] - 0.297 * x[7] +
        0.4053 * x[8] +
        0.5703 * x[9] +
        0.8903 * x[10] +
        (-0.9557 * x[1] * x[2] * x[3]) - 0.0043 * x[1] * x[2] * x[4] -
        0.3711 * x[1] * x[2] * x[5] - 0.3175 * x[1] * x[2] * x[6] -
        0.3467 * x[1] * x[2] * x[7] - 0.0837 * x[1] * x[2] * x[8] +
        0.397 * x[1] * x[2] * x[9] - 0.8681 * x[1] * x[2] * x[10] -
        0.2124 * x[1] * x[3] * x[4] + 0.9815 * x[1] * x[3] * x[5] -
        0.5043 * x[1] * x[3] * x[6] - 0.2869 * x[1] * x[3] * x[7] +
        0.6841 * x[1] * x[3] * x[8] - 0.4616 * x[1] * x[3] * x[9] +
        0.4655 * x[1] * x[3] * x[10] - 0.6494 * x[1] * x[4] * x[5] -
        0.2862 * x[1] * x[4] * x[6] - 0.5755 * x[1] * x[4] * x[7] -
        0.5887 * x[1] * x[4] * x[8] +
        0.3282 * x[1] * x[4] * x[9] +
        0.0774 * x[1] * x[4] * x[10] +
        0.6841 * x[1] * x[5] * x[6] - 0.2826 * x[1] * x[5] * x[7] +
        0.9124 * x[1] * x[5] * x[8] +
        0.8253 * x[1] * x[5] * x[9] +
        0.1537 * x[1] * x[5] * x[10] - 0.6056 * x[1] * x[6] * x[7] +
        0.1527 * x[1] * x[6] * x[8] +
        0.8957 * x[1] * x[6] * x[9] - 0.5742 * x[1] * x[6] * x[10] +
        0.235 * x[1] * x[7] * x[8] - 0.5581 * x[1] * x[7] * x[9] -
        0.6459 * x[1] * x[7] * x[10] +
        0.6936 * x[1] * x[8] * x[9] +
        0.5801 * x[1] * x[8] * x[10] +
        0.6639 * x[1] * x[9] * x[10] +
        0.6154 * x[2] * x[3] * x[4] +
        0.593 * x[2] * x[3] * x[5] - 0.5041 * x[2] * x[3] * x[6] -
        0.8966 * x[2] * x[3] * x[7] +
        0.2624 * x[2] * x[3] * x[8] +
        0.1377 * x[2] * x[3] * x[9] - 0.3901 * x[2] * x[3] * x[10] -
        0.244 * x[2] * x[4] * x[5] - 0.0898 * x[2] * x[4] * x[6] +
        0.7614 * x[2] * x[4] * x[7] - 0.7333 * x[2] * x[4] * x[8] +
        0.3803 * x[2] * x[4] * x[9] +
        0.6721 * x[2] * x[4] * x[10] - 0.1619 * x[2] * x[5] * x[6] +
        0.8134 * x[2] * x[5] * x[7] +
        0.9525 * x[2] * x[5] * x[8] +
        0.992 * x[2] * x[5] * x[9] +
        0.7007 * x[2] * x[5] * x[10] +
        0.3342 * x[2] * x[6] * x[7] +
        0.7684 * x[2] * x[6] * x[8] +
        0.3835 * x[2] * x[6] * x[9] - 0.3171 * x[2] * x[6] * x[10] -
        0.5577 * x[2] * x[7] * x[8] + 0.6115 * x[2] * x[7] * x[9] -
        0.1189 * x[2] * x[7] * x[10] +
        0.8643 * x[2] * x[8] * x[9] +
        0.3953 * x[2] * x[8] * x[10] - 0.3491 * x[2] * x[9] * x[10] -
        0.7712 * x[3] * x[4] * x[5] - 0.8291 * x[3] * x[4] * x[6] -
        0.3737 * x[3] * x[4] * x[7] + 0.388 * x[3] * x[4] * x[8] -
        0.5345 * x[3] * x[4] * x[9] - 0.2952 * x[3] * x[4] * x[10] +
        0.2886 * x[3] * x[5] * x[6] +
        0.0765 * x[3] * x[5] * x[7] +
        0.8758 * x[3] * x[5] * x[8] +
        0.4549 * x[3] * x[5] * x[9] - 0.0236 * x[3] * x[5] * x[10] -
        0.1005 * x[3] * x[6] * x[7] + 0.7607 * x[3] * x[6] * x[8] -
        0.7844 * x[3] * x[6] * x[9] - 0.0479 * x[3] * x[6] * x[10] +
        0.9452 * x[3] * x[7] * x[8] - 0.1973 * x[3] * x[7] * x[9] +
        0.6377 * x[3] * x[7] * x[10] +
        0.5098 * x[3] * x[8] * x[9] - 0.3909 * x[3] * x[8] * x[10] +
        0.9553 * x[3] * x[9] * x[10] +
        0.1032 * x[4] * x[5] * x[6] +
        0.6899 * x[4] * x[5] * x[7] +
        0.8619 * x[4] * x[5] * x[8] +
        0.3971 * x[4] * x[5] * x[9] - 0.3458 * x[4] * x[5] * x[10] -
        0.5388 * x[4] * x[6] * x[7] + 0.8271 * x[4] * x[6] * x[8] -
        0.4226 * x[4] * x[6] * x[9] +
        0.3216 * x[4] * x[6] * x[10] +
        0.5984 * x[4] * x[7] * x[8] +
        0.8383 * x[4] * x[7] * x[9] +
        0.9912 * x[4] * x[7] * x[10] - 0.6707 * x[4] * x[8] * x[9] +
        0.623 * x[4] * x[8] * x[10] +
        0.93 * x[4] * x[9] * x[10] - 0.9724 * x[5] * x[6] * x[7] +
        0.693 * x[5] * x[6] * x[8] - 0.4268 * x[5] * x[6] * x[9] -
        0.9103 * x[5] * x[6] * x[10] + 0.0769 * x[5] * x[7] * x[8] -
        0.9401 * x[5] * x[7] * x[9] +
        0.4041 * x[5] * x[7] * x[10] +
        0.256 * x[5] * x[8] * x[9] - 0.4499 * x[5] * x[8] * x[10] -
        0.967 * x[5] * x[9] * x[10] +
        0.7441 * x[6] * x[7] * x[8] +
        0.9925 * x[6] * x[7] * x[9] - 0.8395 * x[6] * x[7] * x[10] +
        0.0652 * x[6] * x[8] * x[9] +
        0.6151 * x[6] * x[8] * x[10] - 0.5872 * x[6] * x[9] * x[10] -
        0.021 * x[7] * x[8] * x[9] - 0.355 * x[7] * x[8] * x[10] -
        0.0804 * x[7] * x[9] * x[10] - 0.8904 * x[8] * x[9] * x[10] +
        0.8792 * x[1] * x[2] * x[3] * x[5] - 0.0645 * x[1] * x[2] * x[3] * x[4] -
        0.8687 * x[1] * x[2] * x[3] * x[6] + 0.3423 * x[1] * x[2] * x[3] * x[7] -
        0.9285 * x[1] * x[2] * x[3] * x[8] - 0.8432 * x[1] * x[2] * x[3] * x[9] -
        0.5799 * x[1] * x[2] * x[3] * x[10] - 0.6942 * x[1] * x[2] * x[4] * x[5] -
        0.4111 * x[1] * x[2] * x[4] * x[6] +
        0.386 * x[1] * x[2] * x[4] * x[7] +
        0.1187 * x[1] * x[2] * x[4] * x[8] +
        0.12 * x[1] * x[2] * x[4] * x[9] +
        0.3772 * x[1] * x[2] * x[4] * x[10] - 0.7117 * x[1] * x[2] * x[5] * x[6] -
        0.5063 * x[1] * x[2] * x[5] * x[7] - 0.5562 * x[1] * x[2] * x[5] * x[8] +
        0.5658 * x[1] * x[2] * x[5] * x[9] - 0.9644 * x[1] * x[2] * x[5] * x[10] +
        0.9425 * x[1] * x[2] * x[6] * x[7] - 0.7938 * x[1] * x[2] * x[6] * x[8] +
        0.0856 * x[1] * x[2] * x[6] * x[9] +
        0.9841 * x[1] * x[2] * x[6] * x[10] - 0.5537 * x[1] * x[2] * x[7] * x[8] -
        0.6452 * x[1] * x[2] * x[7] * x[9] - 0.6664 * x[1] * x[2] * x[7] * x[10] -
        0.5412 * x[1] * x[2] * x[8] * x[9] + 0.6908 * x[1] * x[2] * x[8] * x[10] -
        0.5576 * x[1] * x[2] * x[9] * x[10] + 0.1221 * x[1] * x[3] * x[4] * x[5] -
        0.925 * x[1] * x[3] * x[4] * x[6] + 0.4836 * x[1] * x[3] * x[4] * x[7] -
        0.4814 * x[1] * x[3] * x[4] * x[8] - 0.8928 * x[1] * x[3] * x[4] * x[9] +
        0.8237 * x[1] * x[3] * x[4] * x[10] +
        0.2967 * x[1] * x[3] * x[5] * x[6] +
        0.519 * x[1] * x[3] * x[5] * x[7] - 0.4036 * x[1] * x[3] * x[5] * x[8] +
        0.2184 * x[1] * x[3] * x[5] * x[9] +
        0.5597 * x[1] * x[3] * x[5] * x[10] - 0.6636 * x[1] * x[3] * x[6] * x[7] -
        0.2396 * x[1] * x[3] * x[6] * x[8] + 0.2761 * x[1] * x[3] * x[6] * x[9] -
        0.8421 * x[1] * x[3] * x[6] * x[10] + 0.5215 * x[1] * x[3] * x[7] * x[8] -
        0.3457 * x[1] * x[3] * x[7] * x[9] +
        0.54 * x[1] * x[3] * x[7] * x[10] +
        0.1788 * x[1] * x[3] * x[8] * x[9] +
        0.2414 * x[1] * x[3] * x[8] * x[10] - 0.055 * x[1] * x[3] * x[9] * x[10] -
        0.2767 * x[1] * x[4] * x[5] * x[6] +
        0.3488 * x[1] * x[4] * x[5] * x[7] +
        0.0979 * x[1] * x[4] * x[5] * x[8] - 0.6934 * x[1] * x[4] * x[5] * x[9] -
        0.6615 * x[1] * x[4] * x[5] * x[10] + 0.503 * x[1] * x[4] * x[6] * x[7] -
        0.7626 * x[1] * x[4] * x[6] * x[8] - 0.7943 * x[1] * x[4] * x[6] * x[9] -
        0.3063 * x[1] * x[4] * x[6] * x[10] + 0.0558 * x[1] * x[4] * x[7] * x[8] -
        0.2301 * x[1] * x[4] * x[7] * x[9] + 0.5779 * x[1] * x[4] * x[7] * x[10] -
        0.0523 * x[1] * x[4] * x[8] * x[9] +
        0.4117 * x[1] * x[4] * x[8] * x[10] +
        0.7896 * x[1] * x[4] * x[9] * x[10] - 0.3012 * x[1] * x[5] * x[6] * x[7] -
        0.0166 * x[1] * x[5] * x[6] * x[8] - 0.6013 * x[1] * x[5] * x[6] * x[9] -
        0.27 * x[1] * x[5] * x[6] * x[10] - 0.5193 * x[1] * x[5] * x[7] * x[8] +
        0.0948 * x[1] * x[5] * x[7] * x[9] +
        0.2315 * x[1] * x[5] * x[7] * x[10] - 0.8466 * x[1] * x[5] * x[8] * x[9] -
        0.4082 * x[1] * x[5] * x[8] * x[10] + 0.7234 * x[1] * x[5] * x[9] * x[10] -
        0.2451 * x[1] * x[6] * x[7] * x[8] + 0.486 * x[1] * x[6] * x[7] * x[9] -
        0.9333 * x[1] * x[6] * x[7] * x[10] - 0.577 * x[1] * x[6] * x[8] * x[9] +
        0.6391 * x[1] * x[6] * x[8] * x[10] - 0.078 * x[1] * x[6] * x[9] * x[10] -
        0.7901 * x[1] * x[7] * x[8] * x[9] + 0.3108 * x[1] * x[7] * x[8] * x[10] -
        0.5911 * x[1] * x[7] * x[9] * x[10] - 0.7161 * x[1] * x[8] * x[9] * x[10] +
        0.6677 * x[2] * x[3] * x[4] * x[5] +
        0.9834 * x[2] * x[3] * x[4] * x[6] - 0.2604 * x[2] * x[3] * x[4] * x[7] +
        0.1312 * x[2] * x[3] * x[4] * x[8] +
        0.1699 * x[2] * x[3] * x[4] * x[9] +
        0.8036 * x[2] * x[3] * x[4] * x[10] +
        0.4179 * x[2] * x[3] * x[5] * x[6] - 0.4876 * x[2] * x[3] * x[5] * x[7] -
        0.9695 * x[2] * x[3] * x[5] * x[8] + 0.8412 * x[2] * x[3] * x[5] * x[9] -
        0.6245 * x[2] * x[3] * x[5] * x[10] - 0.2725 * x[2] * x[3] * x[6] * x[7] +
        0.9959 * x[2] * x[3] * x[6] * x[8] +
        0.7839 * x[2] * x[3] * x[6] * x[9] - 0.2566 * x[2] * x[3] * x[6] * x[10] -
        0.3715 * x[2] * x[3] * x[7] * x[8] - 0.1659 * x[2] * x[3] * x[7] * x[9] -
        0.3605 * x[2] * x[3] * x[7] * x[10] +
        0.4571 * x[2] * x[3] * x[8] * x[9] +
        0.157 * x[2] * x[3] * x[8] * x[10] +
        0.3664 * x[2] * x[3] * x[9] * x[10] +
        0.2114 * x[2] * x[4] * x[5] * x[6] - 0.8717 * x[2] * x[4] * x[5] * x[7] +
        0.7656 * x[2] * x[4] * x[5] * x[8] - 0.1614 * x[2] * x[4] * x[5] * x[9] +
        0.208 * x[2] * x[4] * x[5] * x[10] +
        0.2939 * x[2] * x[4] * x[6] * x[7] +
        0.4719 * x[2] * x[4] * x[6] * x[8] +
        0.1079 * x[2] * x[4] * x[6] * x[9] - 0.1952 * x[2] * x[4] * x[6] * x[10] +
        0.9831 * x[2] * x[4] * x[7] * x[8] - 0.3912 * x[2] * x[4] * x[7] * x[9] -
        0.0164 * x[2] * x[4] * x[7] * x[10] - 0.7641 * x[2] * x[4] * x[8] * x[9] +
        0.825 * x[2] * x[4] * x[8] * x[10] +
        0.7573 * x[2] * x[4] * x[9] * x[10] - 0.0731 * x[2] * x[5] * x[6] * x[7] -
        0.7839 * x[2] * x[5] * x[6] * x[8] +
        0.2375 * x[2] * x[5] * x[6] * x[9] +
        0.342 * x[2] * x[5] * x[6] * x[10] - 0.2362 * x[2] * x[5] * x[7] * x[8] +
        0.7813 * x[2] * x[5] * x[7] * x[9] +
        0.6021 * x[2] * x[5] * x[7] * x[10] +
        0.3864 * x[2] * x[5] * x[8] * x[9] +
        0.7828 * x[2] * x[5] * x[8] * x[10] - 0.2355 * x[2] * x[5] * x[9] * x[10] +
        0.1796 * x[2] * x[6] * x[7] * x[8] - 0.7816 * x[2] * x[6] * x[7] * x[9] +
        0.6992 * x[2] * x[6] * x[7] * x[10] - 0.5391 * x[2] * x[6] * x[8] * x[9] +
        0.1898 * x[2] * x[6] * x[8] * x[10] - 0.3419 * x[2] * x[6] * x[9] * x[10] -
        0.6057 * x[2] * x[7] * x[8] * x[9] + 0.4886 * x[2] * x[7] * x[8] * x[10] -
        0.0693 * x[2] * x[7] * x[9] * x[10] + 0.6415 * x[2] * x[8] * x[9] * x[10] -
        0.1695 * x[3] * x[4] * x[5] * x[6] - 0.662 * x[3] * x[4] * x[5] * x[7] -
        0.6558 * x[3] * x[4] * x[5] * x[8] - 0.2137 * x[3] * x[4] * x[5] * x[9] +
        0.0807 * x[3] * x[4] * x[5] * x[10] +
        0.2775 * x[3] * x[4] * x[6] * x[7] - 0.639 * x[3] * x[4] * x[6] * x[8] +
        0.1566 * x[3] * x[4] * x[6] * x[9] +
        0.4792 * x[3] * x[4] * x[6] * x[10] +
        0.1403 * x[3] * x[4] * x[7] * x[8] - 0.6095 * x[3] * x[4] * x[7] * x[9] +
        0.9322 * x[3] * x[4] * x[7] * x[10] - 0.0214 * x[3] * x[4] * x[8] * x[9] +
        0.3126 * x[3] * x[4] * x[8] * x[10] - 0.6241 * x[3] * x[4] * x[9] * x[10] +
        0.1136 * x[3] * x[5] * x[6] * x[7] +
        0.4677 * x[3] * x[5] * x[6] * x[8] - 0.6577 * x[3] * x[5] * x[6] * x[9] +
        0.3394 * x[3] * x[5] * x[6] * x[10] - 0.7785 * x[3] * x[5] * x[7] * x[8] -
        0.7024 * x[3] * x[5] * x[7] * x[9] + 0.2443 * x[3] * x[5] * x[7] * x[10] -
        0.2521 * x[3] * x[5] * x[8] * x[9] + 0.2286 * x[3] * x[5] * x[8] * x[10] -
        0.0991 * x[3] * x[5] * x[9] * x[10] - 0.7218 * x[3] * x[6] * x[7] * x[8] +
        0.9204 * x[3] * x[6] * x[7] * x[9] - 0.1743 * x[3] * x[6] * x[7] * x[10] +
        0.2405 * x[3] * x[6] * x[8] * x[9] +
        0.1433 * x[3] * x[6] * x[8] * x[10] +
        0.402 * x[3] * x[6] * x[9] * x[10] +
        0.7113 * x[3] * x[7] * x[8] * x[9] - 0.14 * x[3] * x[7] * x[8] * x[10] +
        0.1251 * x[3] * x[7] * x[9] * x[10] +
        0.0473 * x[3] * x[8] * x[9] * x[10] - 0.5929 * x[4] * x[5] * x[6] * x[7] +
        0.0649 * x[4] * x[5] * x[6] * x[8] +
        0.9708 * x[4] * x[5] * x[6] * x[9] +
        0.6177 * x[4] * x[5] * x[6] * x[10] +
        0.5806 * x[4] * x[5] * x[7] * x[8] - 0.1607 * x[4] * x[5] * x[7] * x[9] +
        0.059 * x[4] * x[5] * x[7] * x[10] - 0.8811 * x[4] * x[5] * x[8] * x[9] -
        0.4492 * x[4] * x[5] * x[8] * x[10] +
        0.7614 * x[4] * x[5] * x[9] * x[10] +
        0.2033 * x[4] * x[6] * x[7] * x[8] - 0.9171 * x[4] * x[6] * x[7] * x[9] -
        0.0382 * x[4] * x[6] * x[7] * x[10] - 0.8299 * x[4] * x[6] * x[8] * x[9] -
        0.5709 * x[4] * x[6] * x[8] * x[10] - 0.396 * x[4] * x[6] * x[9] * x[10] +
        0.7934 * x[4] * x[7] * x[8] * x[9] +
        0.0689 * x[4] * x[7] * x[8] * x[10] - 0.4928 * x[4] * x[7] * x[9] * x[10] -
        0.4895 * x[4] * x[8] * x[9] * x[10] +
        0.8422 * x[5] * x[6] * x[7] * x[8] +
        0.8058 * x[5] * x[6] * x[7] * x[9] - 0.3989 * x[5] * x[6] * x[7] * x[10] -
        0.7604 * x[5] * x[6] * x[8] * x[9] - 0.2455 * x[5] * x[6] * x[8] * x[10] -
        0.1685 * x[5] * x[6] * x[9] * x[10] - 0.5593 * x[5] * x[7] * x[8] * x[9] -
        0.7832 * x[5] * x[7] * x[8] * x[10] +
        0.0926 * x[5] * x[7] * x[9] * x[10] +
        0.6215 * x[5] * x[8] * x[9] * x[10] +
        0.3352 * x[6] * x[7] * x[8] * x[9] +
        0.3423 * x[6] * x[7] * x[8] * x[10] - 0.8728 * x[6] * x[7] * x[9] * x[10] +
        0.6484 * x[6] * x[8] * x[9] * x[10] - 0.2626 * x[7] * x[8] * x[9] * x[10] <=
        14.826
    )
    e8 = replace_expr(e8, x)
    JuMP.add_nonlinear_constraint(m, e8)
    e9 = :(
        0.1204 * x[1] * x[3] - 0.6331 * x[1] * x[2] + 0.2074 * x[1] * x[4] -
        0.0007 * x[1] * x[5] + 0.1524 * x[1] * x[6] - 0.1373 * x[1] * x[7] -
        0.5286 * x[1] * x[8] + 0.0533 * x[1] * x[9] - 0.0113 * x[1] * x[10] +
        0.039 * x[2] * x[3] +
        0.746 * x[2] * x[4] - 0.7493 * x[2] * x[5] - 0.3501 * x[2] * x[6] -
        0.7046 * x[2] * x[7] + 0.623 * x[2] * x[8] - 0.3282 * x[2] * x[9] +
        0.2535 * x[2] * x[10] +
        0.7369 * x[3] * x[4] - 0.3179 * x[3] * x[5] - 0.7554 * x[3] * x[6] +
        0.3384 * x[3] * x[7] +
        0.7428 * x[3] * x[8] +
        0.6871 * x[3] * x[9] - 0.2774 * x[3] * x[10] + 0.1942 * x[4] * x[5] -
        0.0372 * x[4] * x[6] +
        0.9036 * x[4] * x[7] +
        0.9891 * x[4] * x[8] +
        0.2623 * x[4] * x[9] +
        0.4058 * x[4] * x[10] +
        0.2905 * x[5] * x[6] +
        0.8707 * x[5] * x[7] - 0.6906 * x[5] * x[8] +
        0.0175 * x[5] * x[9] +
        0.7644 * x[5] * x[10] +
        0.1747 * x[6] * x[7] - 0.3217 * x[6] * x[8] - 0.3756 * x[6] * x[9] -
        0.4446 * x[6] * x[10] - 0.5191 * x[7] * x[8] + 0.8229 * x[7] * x[9] -
        0.0585 * x[7] * x[10] +
        0.7931 * x[8] * x[9] +
        0.2165 * x[8] * x[10] +
        0.3018 * x[9] * x[10] - 0.6853 * x[1] + 0.4834 * x[2] - 0.9677 * x[3] +
        0.9793 * x[4] - 0.3145 * x[5] + 0.9356 * x[6] - 0.651 * x[7] - 0.7873 * x[8] +
        0.5914 * x[9] - 0.82 * x[10] + 0.6907 * x[1] * x[2] * x[4] -
        0.4133 * x[1] * x[2] * x[3] + 0.0963 * x[1] * x[2] * x[5] -
        0.2825 * x[1] * x[2] * x[6] +
        0.0354 * x[1] * x[2] * x[7] +
        0.5125 * x[1] * x[2] * x[8] +
        0.9351 * x[1] * x[2] * x[9] +
        0.7973 * x[1] * x[2] * x[10] - 0.8916 * x[1] * x[3] * x[4] -
        0.7597 * x[1] * x[3] * x[5] +
        0.2381 * x[1] * x[3] * x[6] +
        0.0077 * x[1] * x[3] * x[7] +
        0.3442 * x[1] * x[3] * x[8] +
        0.1405 * x[1] * x[3] * x[9] +
        0.8568 * x[1] * x[3] * x[10] - 0.261 * x[1] * x[4] * x[5] -
        0.8792 * x[1] * x[4] * x[6] - 0.0695 * x[1] * x[4] * x[7] -
        0.827 * x[1] * x[4] * x[8] +
        0.5092 * x[1] * x[4] * x[9] +
        0.4796 * x[1] * x[4] * x[10] - 0.7576 * x[1] * x[5] * x[6] -
        0.2986 * x[1] * x[5] * x[7] - 0.6192 * x[1] * x[5] * x[8] -
        0.8556 * x[1] * x[5] * x[9] - 0.0737 * x[1] * x[5] * x[10] -
        0.0614 * x[1] * x[6] * x[7] - 0.0832 * x[1] * x[6] * x[8] -
        0.6275 * x[1] * x[6] * x[9] - 0.4122 * x[1] * x[6] * x[10] +
        0.1479 * x[1] * x[7] * x[8] - 0.4795 * x[1] * x[7] * x[9] +
        0.4531 * x[1] * x[7] * x[10] - 0.564 * x[1] * x[8] * x[9] -
        0.7735 * x[1] * x[8] * x[10] +
        0.5994 * x[1] * x[9] * x[10] +
        0.5007 * x[2] * x[3] * x[4] +
        0.5843 * x[2] * x[3] * x[5] - 0.436 * x[2] * x[3] * x[6] -
        0.2484 * x[2] * x[3] * x[7] +
        0.5402 * x[2] * x[3] * x[8] +
        0.4467 * x[2] * x[3] * x[9] - 0.7388 * x[2] * x[3] * x[10] +
        0.449 * x[2] * x[4] * x[5] +
        0.2 * x[2] * x[4] * x[6] - 0.2227 * x[2] * x[4] * x[7] +
        0.1216 * x[2] * x[4] * x[8] - 0.1403 * x[2] * x[4] * x[9] +
        0.2873 * x[2] * x[4] * x[10] - 0.9251 * x[2] * x[5] * x[6] -
        0.9097 * x[2] * x[5] * x[7] - 0.299 * x[2] * x[5] * x[8] -
        0.037 * x[2] * x[5] * x[9] +
        0.1356 * x[2] * x[5] * x[10] +
        0.1424 * x[2] * x[6] * x[7] +
        0.9099 * x[2] * x[6] * x[8] - 0.8295 * x[2] * x[6] * x[9] -
        0.9163 * x[2] * x[6] * x[10] - 0.886 * x[2] * x[7] * x[8] -
        0.5395 * x[2] * x[7] * x[9] +
        0.4885 * x[2] * x[7] * x[10] +
        0.0733 * x[2] * x[8] * x[9] +
        0.6171 * x[2] * x[8] * x[10] +
        0.9443 * x[2] * x[9] * x[10] +
        0.8452 * x[3] * x[4] * x[5] +
        0.2589 * x[3] * x[4] * x[6] - 0.3954 * x[3] * x[4] * x[7] +
        0.2099 * x[3] * x[4] * x[8] - 0.4274 * x[3] * x[4] * x[9] +
        0.7638 * x[3] * x[4] * x[10] +
        0.0518 * x[3] * x[5] * x[6] - 0.7951 * x[3] * x[5] * x[7] -
        0.0508 * x[3] * x[5] * x[8] - 0.2861 * x[3] * x[5] * x[9] +
        0.0163 * x[3] * x[5] * x[10] +
        0.3989 * x[3] * x[6] * x[7] - 0.3631 * x[3] * x[6] * x[8] -
        0.1875 * x[3] * x[6] * x[9] +
        0.6995 * x[3] * x[6] * x[10] +
        0.5373 * x[3] * x[7] * x[8] +
        0.7748 * x[3] * x[7] * x[9] +
        0.0892 * x[3] * x[7] * x[10] +
        0.093 * x[3] * x[8] * x[9] - 0.4689 * x[3] * x[8] * x[10] +
        0.4298 * x[3] * x[9] * x[10] - 0.4441 * x[4] * x[5] * x[6] -
        0.9731 * x[4] * x[5] * x[7] - 0.0911 * x[4] * x[5] * x[8] -
        0.8933 * x[4] * x[5] * x[9] - 0.3553 * x[4] * x[5] * x[10] -
        0.1372 * x[4] * x[6] * x[7] +
        0.239 * x[4] * x[6] * x[8] +
        0.9347 * x[4] * x[6] * x[9] - 0.8911 * x[4] * x[6] * x[10] -
        0.528 * x[4] * x[7] * x[8] - 0.13 * x[4] * x[7] * x[9] -
        0.2034 * x[4] * x[7] * x[10] - 0.69 * x[4] * x[8] * x[9] +
        0.2966 * x[4] * x[8] * x[10] +
        0.9593 * x[4] * x[9] * x[10] - 0.9582 * x[5] * x[6] * x[7] +
        0.4532 * x[5] * x[6] * x[8] +
        0.5574 * x[5] * x[6] * x[9] - 0.4571 * x[5] * x[6] * x[10] -
        0.9344 * x[5] * x[7] * x[8] - 0.1114 * x[5] * x[7] * x[9] +
        0.477 * x[5] * x[7] * x[10] - 0.0515 * x[5] * x[8] * x[9] -
        0.456 * x[5] * x[8] * x[10] +
        0.1071 * x[5] * x[9] * x[10] +
        0.3639 * x[6] * x[7] * x[8] +
        0.1604 * x[6] * x[7] * x[9] +
        0.7412 * x[6] * x[7] * x[10] - 0.842 * x[6] * x[8] * x[9] +
        0.2298 * x[6] * x[8] * x[10] - 0.7632 * x[6] * x[9] * x[10] +
        0.467 * x[7] * x[8] * x[9] - 0.3678 * x[7] * x[8] * x[10] -
        0.0498 * x[7] * x[9] * x[10] +
        0.2148 * x[8] * x[9] * x[10] +
        0.607 * x[1] * x[2] * x[3] * x[4] - 0.984 * x[1] * x[2] * x[3] * x[5] +
        0.1984 * x[1] * x[2] * x[3] * x[6] - 0.3261 * x[1] * x[2] * x[3] * x[7] +
        0.9942 * x[1] * x[2] * x[3] * x[8] +
        0.4899 * x[1] * x[2] * x[3] * x[9] +
        0.1859 * x[1] * x[2] * x[3] * x[10] +
        0.7152 * x[1] * x[2] * x[4] * x[5] +
        0.6231 * x[1] * x[2] * x[4] * x[6] - 0.3239 * x[1] * x[2] * x[4] * x[7] +
        0.6656 * x[1] * x[2] * x[4] * x[8] +
        0.6511 * x[1] * x[2] * x[4] * x[9] +
        0.4798 * x[1] * x[2] * x[4] * x[10] - 0.6549 * x[1] * x[2] * x[5] * x[6] +
        0.3657 * x[1] * x[2] * x[5] * x[7] +
        0.2469 * x[1] * x[2] * x[5] * x[8] +
        0.1256 * x[1] * x[2] * x[5] * x[9] - 0.83 * x[1] * x[2] * x[5] * x[10] +
        0.8632 * x[1] * x[2] * x[6] * x[7] - 0.6316 * x[1] * x[2] * x[6] * x[8] +
        0.901 * x[1] * x[2] * x[6] * x[9] +
        0.2282 * x[1] * x[2] * x[6] * x[10] - 0.3158 * x[1] * x[2] * x[7] * x[8] -
        0.9495 * x[1] * x[2] * x[7] * x[9] + 0.379 * x[1] * x[2] * x[7] * x[10] -
        0.7787 * x[1] * x[2] * x[8] * x[9] - 0.3534 * x[1] * x[2] * x[8] * x[10] +
        0.0053 * x[1] * x[2] * x[9] * x[10] - 0.1876 * x[1] * x[3] * x[4] * x[5] -
        0.502 * x[1] * x[3] * x[4] * x[6] +
        0.1311 * x[1] * x[3] * x[4] * x[7] +
        0.6431 * x[1] * x[3] * x[4] * x[8] +
        0.3694 * x[1] * x[3] * x[4] * x[9] - 0.7882 * x[1] * x[3] * x[4] * x[10] -
        0.3699 * x[1] * x[3] * x[5] * x[6] - 0.874 * x[1] * x[3] * x[5] * x[7] -
        0.4416 * x[1] * x[3] * x[5] * x[8] +
        0.2313 * x[1] * x[3] * x[5] * x[9] +
        0.357 * x[1] * x[3] * x[5] * x[10] +
        0.1096 * x[1] * x[3] * x[6] * x[7] +
        0.9751 * x[1] * x[3] * x[6] * x[8] +
        0.4229 * x[1] * x[3] * x[6] * x[9] - 0.0638 * x[1] * x[3] * x[6] * x[10] +
        0.9879 * x[1] * x[3] * x[7] * x[8] +
        0.8635 * x[1] * x[3] * x[7] * x[9] +
        0.4333 * x[1] * x[3] * x[7] * x[10] +
        0.8267 * x[1] * x[3] * x[8] * x[9] +
        0.3304 * x[1] * x[3] * x[8] * x[10] +
        0.7375 * x[1] * x[3] * x[9] * x[10] +
        0.1234 * x[1] * x[4] * x[5] * x[6] - 0.2028 * x[1] * x[4] * x[5] * x[7] +
        0.4864 * x[1] * x[4] * x[5] * x[8] +
        0.4254 * x[1] * x[4] * x[5] * x[9] - 0.7986 * x[1] * x[4] * x[5] * x[10] -
        0.3318 * x[1] * x[4] * x[6] * x[7] +
        0.7505 * x[1] * x[4] * x[6] * x[8] +
        0.8088 * x[1] * x[4] * x[6] * x[9] - 0.4503 * x[1] * x[4] * x[6] * x[10] +
        0.8307 * x[1] * x[4] * x[7] * x[8] - 0.9624 * x[1] * x[4] * x[7] * x[9] -
        0.172 * x[1] * x[4] * x[7] * x[10] + 0.2328 * x[1] * x[4] * x[8] * x[9] -
        0.0483 * x[1] * x[4] * x[8] * x[10] - 0.8543 * x[1] * x[4] * x[9] * x[10] -
        0.1414 * x[1] * x[5] * x[6] * x[7] - 0.6745 * x[1] * x[5] * x[6] * x[8] +
        0.2956 * x[1] * x[5] * x[6] * x[9] - 0.9646 * x[1] * x[5] * x[6] * x[10] +
        0.6631 * x[1] * x[5] * x[7] * x[8] - 0.921 * x[1] * x[5] * x[7] * x[9] +
        0.7216 * x[1] * x[5] * x[7] * x[10] - 0.0916 * x[1] * x[5] * x[8] * x[9] +
        0.5066 * x[1] * x[5] * x[8] * x[10] - 0.2279 * x[1] * x[5] * x[9] * x[10] +
        0.4388 * x[1] * x[6] * x[7] * x[8] +
        0.1251 * x[1] * x[6] * x[7] * x[9] - 0.4666 * x[1] * x[6] * x[7] * x[10] -
        0.6096 * x[1] * x[6] * x[8] * x[9] - 0.1296 * x[1] * x[6] * x[8] * x[10] +
        0.147 * x[1] * x[6] * x[9] * x[10] - 0.8773 * x[1] * x[7] * x[8] * x[9] +
        0.3256 * x[1] * x[7] * x[8] * x[10] +
        0.1917 * x[1] * x[7] * x[9] * x[10] - 0.7454 * x[1] * x[8] * x[9] * x[10] +
        0.953 * x[2] * x[3] * x[4] * x[5] - 0.2524 * x[2] * x[3] * x[4] * x[6] +
        0.6998 * x[2] * x[3] * x[4] * x[7] +
        0.9019 * x[2] * x[3] * x[4] * x[8] +
        0.0886 * x[2] * x[3] * x[4] * x[9] - 0.745 * x[2] * x[3] * x[4] * x[10] +
        0.7499 * x[2] * x[3] * x[5] * x[6] +
        0.064 * x[2] * x[3] * x[5] * x[7] - 0.919 * x[2] * x[3] * x[5] * x[8] -
        0.9064 * x[2] * x[3] * x[5] * x[9] + 0.2797 * x[2] * x[3] * x[5] * x[10] -
        0.6761 * x[2] * x[3] * x[6] * x[7] - 0.9433 * x[2] * x[3] * x[6] * x[8] +
        0.4738 * x[2] * x[3] * x[6] * x[9] - 0.469 * x[2] * x[3] * x[6] * x[10] -
        0.6195 * x[2] * x[3] * x[7] * x[8] +
        0.4109 * x[2] * x[3] * x[7] * x[9] +
        0.774 * x[2] * x[3] * x[7] * x[10] - 0.6599 * x[2] * x[3] * x[8] * x[9] +
        0.5277 * x[2] * x[3] * x[8] * x[10] - 0.207 * x[2] * x[3] * x[9] * x[10] +
        0.7556 * x[2] * x[4] * x[5] * x[6] - 0.0444 * x[2] * x[4] * x[5] * x[7] -
        0.6359 * x[2] * x[4] * x[5] * x[8] +
        0.5783 * x[2] * x[4] * x[5] * x[9] +
        0.4262 * x[2] * x[4] * x[5] * x[10] - 0.5666 * x[2] * x[4] * x[6] * x[7] +
        0.4188 * x[2] * x[4] * x[6] * x[8] +
        0.3495 * x[2] * x[4] * x[6] * x[9] - 0.6488 * x[2] * x[4] * x[6] * x[10] -
        0.9492 * x[2] * x[4] * x[7] * x[8] - 0.2321 * x[2] * x[4] * x[7] * x[9] -
        0.0055 * x[2] * x[4] * x[7] * x[10] - 0.556 * x[2] * x[4] * x[8] * x[9] +
        0.3175 * x[2] * x[4] * x[8] * x[10] +
        0.392 * x[2] * x[4] * x[9] * x[10] +
        0.7571 * x[2] * x[5] * x[6] * x[7] - 0.123 * x[2] * x[5] * x[6] * x[8] -
        0.9402 * x[2] * x[5] * x[6] * x[9] + 0.9707 * x[2] * x[5] * x[6] * x[10] -
        0.9632 * x[2] * x[5] * x[7] * x[8] +
        0.5879 * x[2] * x[5] * x[7] * x[9] +
        0.7006 * x[2] * x[5] * x[7] * x[10] +
        0.3368 * x[2] * x[5] * x[8] * x[9] +
        0.7005 * x[2] * x[5] * x[8] * x[10] - 0.9946 * x[2] * x[5] * x[9] * x[10] -
        0.5453 * x[2] * x[6] * x[7] * x[8] - 0.6007 * x[2] * x[6] * x[7] * x[9] +
        0.1658 * x[2] * x[6] * x[7] * x[10] +
        0.5857 * x[2] * x[6] * x[8] * x[9] - 0.6648 * x[2] * x[6] * x[8] * x[10] -
        0.3842 * x[2] * x[6] * x[9] * x[10] - 0.8785 * x[2] * x[7] * x[8] * x[9] -
        0.3002 * x[2] * x[7] * x[8] * x[10] - 0.1467 * x[2] * x[7] * x[9] * x[10] +
        0.5581 * x[2] * x[8] * x[9] * x[10] +
        0.255 * x[3] * x[4] * x[5] * x[6] - 0.3062 * x[3] * x[4] * x[5] * x[7] -
        0.1995 * x[3] * x[4] * x[5] * x[8] +
        0.7855 * x[3] * x[4] * x[5] * x[9] +
        0.076 * x[3] * x[4] * x[5] * x[10] +
        0.9889 * x[3] * x[4] * x[6] * x[7] +
        0.6766 * x[3] * x[4] * x[6] * x[8] +
        0.3158 * x[3] * x[4] * x[6] * x[9] - 0.8643 * x[3] * x[4] * x[6] * x[10] -
        0.8024 * x[3] * x[4] * x[7] * x[8] - 0.6817 * x[3] * x[4] * x[7] * x[9] -
        0.9275 * x[3] * x[4] * x[7] * x[10] + 0.5669 * x[3] * x[4] * x[8] * x[9] -
        0.8213 * x[3] * x[4] * x[8] * x[10] +
        0.3068 * x[3] * x[4] * x[9] * x[10] +
        0.9216 * x[3] * x[5] * x[6] * x[7] +
        0.8245 * x[3] * x[5] * x[6] * x[8] - 0.387 * x[3] * x[5] * x[6] * x[9] +
        0.2332 * x[3] * x[5] * x[6] * x[10] - 0.2114 * x[3] * x[5] * x[7] * x[8] -
        0.5222 * x[3] * x[5] * x[7] * x[9] - 0.1285 * x[3] * x[5] * x[7] * x[10] +
        0.2733 * x[3] * x[5] * x[8] * x[9] - 0.5025 * x[3] * x[5] * x[8] * x[10] -
        0.3684 * x[3] * x[5] * x[9] * x[10] - 0.1281 * x[3] * x[6] * x[7] * x[8] +
        0.7043 * x[3] * x[6] * x[7] * x[9] +
        0.4752 * x[3] * x[6] * x[7] * x[10] +
        0.4398 * x[3] * x[6] * x[8] * x[9] - 0.2425 * x[3] * x[6] * x[8] * x[10] +
        0.0265 * x[3] * x[6] * x[9] * x[10] +
        0.1761 * x[3] * x[7] * x[8] * x[9] +
        0.6789 * x[3] * x[7] * x[8] * x[10] - 0.2652 * x[3] * x[7] * x[9] * x[10] -
        0.7416 * x[3] * x[8] * x[9] * x[10] +
        0.3104 * x[4] * x[5] * x[6] * x[7] +
        0.5838 * x[4] * x[5] * x[6] * x[8] - 0.2481 * x[4] * x[5] * x[6] * x[9] -
        0.5737 * x[4] * x[5] * x[6] * x[10] +
        0.1995 * x[4] * x[5] * x[7] * x[8] +
        0.7254 * x[4] * x[5] * x[7] * x[9] - 0.6076 * x[4] * x[5] * x[7] * x[10] +
        0.2583 * x[4] * x[5] * x[8] * x[9] +
        0.3748 * x[4] * x[5] * x[8] * x[10] - 0.821 * x[4] * x[5] * x[9] * x[10] -
        0.7231 * x[4] * x[6] * x[7] * x[8] +
        0.792 * x[4] * x[6] * x[7] * x[9] +
        0.1935 * x[4] * x[6] * x[7] * x[10] +
        0.3677 * x[4] * x[6] * x[8] * x[9] - 0.3893 * x[4] * x[6] * x[8] * x[10] -
        0.5531 * x[4] * x[6] * x[9] * x[10] + 0.3063 * x[4] * x[7] * x[8] * x[9] -
        0.3756 * x[4] * x[7] * x[8] * x[10] + 0.9983 * x[4] * x[7] * x[9] * x[10] -
        0.4544 * x[4] * x[8] * x[9] * x[10] +
        0.8651 * x[5] * x[6] * x[7] * x[8] +
        0.8738 * x[5] * x[6] * x[7] * x[9] +
        0.7123 * x[5] * x[6] * x[7] * x[10] - 0.789 * x[5] * x[6] * x[8] * x[9] -
        0.9015 * x[5] * x[6] * x[8] * x[10] + 0.8536 * x[5] * x[6] * x[9] * x[10] -
        0.6222 * x[5] * x[7] * x[8] * x[9] + 0.531 * x[5] * x[7] * x[8] * x[10] -
        0.7534 * x[5] * x[7] * x[9] * x[10] +
        0.1807 * x[5] * x[8] * x[9] * x[10] +
        0.8496 * x[6] * x[7] * x[8] * x[9] +
        0.0791 * x[6] * x[7] * x[8] * x[10] +
        0.8057 * x[6] * x[7] * x[9] * x[10] - 0.81 * x[6] * x[8] * x[9] * x[10] +
        0.7906 * x[7] * x[8] * x[9] * x[10] <= 9.957
    )
    e9 = replace_expr(e9, x)
    JuMP.add_nonlinear_constraint(m, e9)
    e10 = :(
        (-0.6891 * x[1] * x[2]) - 0.416 * x[1] * x[3] - 0.4715 * x[1] * x[4] +
        0.6858 * x[1] * x[5] - 0.4223 * x[1] * x[6] +
        0.7652 * x[1] * x[7] +
        0.7955 * x[1] * x[8] +
        0.5377 * x[1] * x[9] +
        0.9667 * x[1] * x[10] - 0.8157 * x[2] * x[3] - 0.9023 * x[2] * x[4] -
        0.5467 * x[2] * x[5] - 0.3177 * x[2] * x[6] - 0.9398 * x[2] * x[7] +
        0.2349 * x[2] * x[8] +
        0.001 * x[2] * x[9] +
        0.3641 * x[2] * x[10] - 0.9461 * x[3] * x[4] +
        0.1124 * x[3] * x[5] +
        0.0992 * x[3] * x[6] +
        0.0372 * x[3] * x[7] - 0.6933 * x[3] * x[8] + 0.9793 * x[3] * x[9] -
        0.2495 * x[3] * x[10] - 0.865 * x[4] * x[5] - 0.5344 * x[4] * x[6] +
        0.3443 * x[4] * x[7] +
        0.0946 * x[4] * x[8] +
        0.99 * x[4] * x[9] +
        0.1293 * x[4] * x[10] - 0.1439 * x[5] * x[6] - 0.1023 * x[5] * x[7] +
        0.4527 * x[5] * x[8] - 0.9526 * x[5] * x[9] - 0.9404 * x[5] * x[10] -
        0.4876 * x[6] * x[7] - 0.4892 * x[6] * x[8] - 0.8809 * x[6] * x[9] +
        0.5844 * x[6] * x[10] - 0.5909 * x[7] * x[8] +
        0.8432 * x[7] * x[9] +
        0.4261 * x[7] * x[10] - 0.7159 * x[8] * x[9] +
        0.6584 * x[8] * x[10] +
        0.0654 * x[9] * x[10] +
        0.9716 * x[1] +
        0.3374 * x[2] - 0.6073 * x[3] - 0.4237 * x[4] +
        0.4155 * x[5] +
        0.8152 * x[6] - 0.6799 * x[7] - 0.7925 * x[8] - 0.3313 * x[9] -
        0.8543 * x[10] + (-0.1007 * x[1] * x[2] * x[3]) -
        0.5326 * x[1] * x[2] * x[4] +
        0.6566 * x[1] * x[2] * x[5] +
        0.1937 * x[1] * x[2] * x[6] - 0.9996 * x[1] * x[2] * x[7] -
        0.5367 * x[1] * x[2] * x[8] - 0.1918 * x[1] * x[2] * x[9] -
        0.8802 * x[1] * x[2] * x[10] - 0.6497 * x[1] * x[3] * x[4] -
        0.3399 * x[1] * x[3] * x[5] +
        0.0515 * x[1] * x[3] * x[6] +
        0.8846 * x[1] * x[3] * x[7] +
        0.022 * x[1] * x[3] * x[8] +
        0.9133 * x[1] * x[3] * x[9] - 0.7262 * x[1] * x[3] * x[10] -
        0.7918 * x[1] * x[4] * x[5] - 0.6313 * x[1] * x[4] * x[6] +
        0.9966 * x[1] * x[4] * x[7] - 0.6426 * x[1] * x[4] * x[8] -
        0.3197 * x[1] * x[4] * x[9] - 0.2285 * x[1] * x[4] * x[10] +
        0.0003 * x[1] * x[5] * x[6] +
        0.8027 * x[1] * x[5] * x[7] +
        0.8966 * x[1] * x[5] * x[8] +
        0.6134 * x[1] * x[5] * x[9] +
        0.0598 * x[1] * x[5] * x[10] - 0.9651 * x[1] * x[6] * x[7] +
        0.9353 * x[1] * x[6] * x[8] +
        0.8902 * x[1] * x[6] * x[9] - 0.007 * x[1] * x[6] * x[10] +
        0.5675 * x[1] * x[7] * x[8] +
        0.8712 * x[1] * x[7] * x[9] +
        0.2321 * x[1] * x[7] * x[10] - 0.3199 * x[1] * x[8] * x[9] +
        0.0664 * x[1] * x[8] * x[10] - 0.3827 * x[1] * x[9] * x[10] +
        0.4324 * x[2] * x[3] * x[4] +
        0.9173 * x[2] * x[3] * x[5] +
        0.0144 * x[2] * x[3] * x[6] +
        0.0691 * x[2] * x[3] * x[7] - 0.2872 * x[2] * x[3] * x[8] -
        0.8985 * x[2] * x[3] * x[9] +
        0.0914 * x[2] * x[3] * x[10] +
        0.1849 * x[2] * x[4] * x[5] - 0.0897 * x[2] * x[4] * x[6] -
        0.7576 * x[2] * x[4] * x[7] - 0.1726 * x[2] * x[4] * x[8] +
        0.9337 * x[2] * x[4] * x[9] +
        0.0318 * x[2] * x[4] * x[10] - 0.2369 * x[2] * x[5] * x[6] +
        0.9287 * x[2] * x[5] * x[7] - 0.9551 * x[2] * x[5] * x[8] -
        0.6268 * x[2] * x[5] * x[9] +
        0.4162 * x[2] * x[5] * x[10] +
        0.7695 * x[2] * x[6] * x[7] +
        0.615 * x[2] * x[6] * x[8] +
        0.4118 * x[2] * x[6] * x[9] - 0.8214 * x[2] * x[6] * x[10] +
        0.1937 * x[2] * x[7] * x[8] +
        0.2846 * x[2] * x[7] * x[9] - 0.1472 * x[2] * x[7] * x[10] +
        0.307 * x[2] * x[8] * x[9] +
        0.7698 * x[2] * x[8] * x[10] - 0.6545 * x[2] * x[9] * x[10] -
        0.5534 * x[3] * x[4] * x[5] +
        0.0359 * x[3] * x[4] * x[6] +
        0.7667 * x[3] * x[4] * x[7] +
        0.0927 * x[3] * x[4] * x[8] - 0.5321 * x[3] * x[4] * x[9] -
        0.4937 * x[3] * x[4] * x[10] +
        0.7388 * x[3] * x[5] * x[6] +
        0.9809 * x[3] * x[5] * x[7] +
        0.0004 * x[3] * x[5] * x[8] +
        0.695 * x[3] * x[5] * x[9] +
        0.5494 * x[3] * x[5] * x[10] +
        0.6195 * x[3] * x[6] * x[7] +
        0.2356 * x[3] * x[6] * x[8] - 0.1412 * x[3] * x[6] * x[9] +
        0.7508 * x[3] * x[6] * x[10] - 0.769 * x[3] * x[7] * x[8] -
        0.1995 * x[3] * x[7] * x[9] + 0.7897 * x[3] * x[7] * x[10] -
        0.9464 * x[3] * x[8] * x[9] - 0.0035 * x[3] * x[8] * x[10] +
        0.7893 * x[3] * x[9] * x[10] +
        0.2009 * x[4] * x[5] * x[6] +
        0.573 * x[4] * x[5] * x[7] +
        0.0687 * x[4] * x[5] * x[8] +
        0.3609 * x[4] * x[5] * x[9] +
        0.7069 * x[4] * x[5] * x[10] +
        0.3176 * x[4] * x[6] * x[7] - 0.2025 * x[4] * x[6] * x[8] +
        0.9283 * x[4] * x[6] * x[9] +
        0.6098 * x[4] * x[6] * x[10] +
        0.6859 * x[4] * x[7] * x[8] - 0.3653 * x[4] * x[7] * x[9] -
        0.406 * x[4] * x[7] * x[10] + 0.6706 * x[4] * x[8] * x[9] -
        0.4475 * x[4] * x[8] * x[10] - 0.1989 * x[4] * x[9] * x[10] -
        0.5974 * x[5] * x[6] * x[7] +
        0.4318 * x[5] * x[6] * x[8] +
        0.3654 * x[5] * x[6] * x[9] - 0.2119 * x[5] * x[6] * x[10] -
        0.0018 * x[5] * x[7] * x[8] - 0.9865 * x[5] * x[7] * x[9] -
        0.8902 * x[5] * x[7] * x[10] - 0.6653 * x[5] * x[8] * x[9] +
        0.3769 * x[5] * x[8] * x[10] - 0.2194 * x[5] * x[9] * x[10] +
        0.8789 * x[6] * x[7] * x[8] - 0.7093 * x[6] * x[7] * x[9] +
        0.3827 * x[6] * x[7] * x[10] - 0.0405 * x[6] * x[8] * x[9] +
        0.7626 * x[6] * x[8] * x[10] +
        0.4358 * x[6] * x[9] * x[10] +
        0.7368 * x[7] * x[8] * x[9] - 0.0174 * x[7] * x[8] * x[10] -
        0.4531 * x[7] * x[9] * x[10] +
        0.3375 * x[8] * x[9] * x[10] +
        (-0.4826 * x[1] * x[2] * x[3] * x[4]) - 0.2493 * x[1] * x[2] * x[3] * x[5] +
        0.5075 * x[1] * x[2] * x[3] * x[6] - 0.6548 * x[1] * x[2] * x[3] * x[7] -
        0.7159 * x[1] * x[2] * x[3] * x[8] - 0.7049 * x[1] * x[2] * x[3] * x[9] -
        0.3438 * x[1] * x[2] * x[3] * x[10] - 0.1976 * x[1] * x[2] * x[4] * x[5] +
        0.0079 * x[1] * x[2] * x[4] * x[6] - 0.8311 * x[1] * x[2] * x[4] * x[7] +
        0.3371 * x[1] * x[2] * x[4] * x[8] +
        0.6852 * x[1] * x[2] * x[4] * x[9] +
        0.2669 * x[1] * x[2] * x[4] * x[10] +
        0.3508 * x[1] * x[2] * x[5] * x[6] - 0.281 * x[1] * x[2] * x[5] * x[7] -
        0.1383 * x[1] * x[2] * x[5] * x[8] - 0.5659 * x[1] * x[2] * x[5] * x[9] +
        0.008 * x[1] * x[2] * x[5] * x[10] - 0.2438 * x[1] * x[2] * x[6] * x[7] +
        0.8352 * x[1] * x[2] * x[6] * x[8] - 0.6792 * x[1] * x[2] * x[6] * x[9] -
        0.505 * x[1] * x[2] * x[6] * x[10] - 0.117 * x[1] * x[2] * x[7] * x[8] -
        0.3067 * x[1] * x[2] * x[7] * x[9] - 0.3803 * x[1] * x[2] * x[7] * x[10] +
        0.7882 * x[1] * x[2] * x[8] * x[9] +
        0.3372 * x[1] * x[2] * x[8] * x[10] - 0.919 * x[1] * x[2] * x[9] * x[10] -
        0.7383 * x[1] * x[3] * x[4] * x[5] +
        0.7541 * x[1] * x[3] * x[4] * x[6] +
        0.5834 * x[1] * x[3] * x[4] * x[7] +
        0.1474 * x[1] * x[3] * x[4] * x[8] +
        0.0948 * x[1] * x[3] * x[4] * x[9] - 0.3359 * x[1] * x[3] * x[4] * x[10] +
        0.165 * x[1] * x[3] * x[5] * x[6] +
        0.3496 * x[1] * x[3] * x[5] * x[7] +
        0.6279 * x[1] * x[3] * x[5] * x[8] - 0.6031 * x[1] * x[3] * x[5] * x[9] +
        0.1115 * x[1] * x[3] * x[5] * x[10] - 0.7796 * x[1] * x[3] * x[6] * x[7] -
        0.5661 * x[1] * x[3] * x[6] * x[8] +
        0.1693 * x[1] * x[3] * x[6] * x[9] +
        0.957 * x[1] * x[3] * x[6] * x[10] +
        0.7301 * x[1] * x[3] * x[7] * x[8] - 0.1917 * x[1] * x[3] * x[7] * x[9] +
        0.9096 * x[1] * x[3] * x[7] * x[10] - 0.2321 * x[1] * x[3] * x[8] * x[9] -
        0.1408 * x[1] * x[3] * x[8] * x[10] + 0.9235 * x[1] * x[3] * x[9] * x[10] -
        0.5794 * x[1] * x[4] * x[5] * x[6] + 0.227 * x[1] * x[4] * x[5] * x[7] -
        0.3337 * x[1] * x[4] * x[5] * x[8] - 0.3646 * x[1] * x[4] * x[5] * x[9] -
        0.4327 * x[1] * x[4] * x[5] * x[10] - 0.1094 * x[1] * x[4] * x[6] * x[7] +
        0.3825 * x[1] * x[4] * x[6] * x[8] +
        0.5071 * x[1] * x[4] * x[6] * x[9] +
        0.8944 * x[1] * x[4] * x[6] * x[10] - 0.3627 * x[1] * x[4] * x[7] * x[8] +
        0.065 * x[1] * x[4] * x[7] * x[9] +
        0.7137 * x[1] * x[4] * x[7] * x[10] +
        0.5367 * x[1] * x[4] * x[8] * x[9] +
        0.1169 * x[1] * x[4] * x[8] * x[10] +
        0.1142 * x[1] * x[4] * x[9] * x[10] - 0.814 * x[1] * x[5] * x[6] * x[7] +
        0.7162 * x[1] * x[5] * x[6] * x[8] +
        0.4038 * x[1] * x[5] * x[6] * x[9] +
        0.3275 * x[1] * x[5] * x[6] * x[10] - 0.7578 * x[1] * x[5] * x[7] * x[8] +
        0.2681 * x[1] * x[5] * x[7] * x[9] +
        0.618 * x[1] * x[5] * x[7] * x[10] +
        0.8112 * x[1] * x[5] * x[8] * x[9] +
        0.652 * x[1] * x[5] * x[8] * x[10] +
        0.5574 * x[1] * x[5] * x[9] * x[10] +
        0.1105 * x[1] * x[6] * x[7] * x[8] - 0.685 * x[1] * x[6] * x[7] * x[9] +
        0.2517 * x[1] * x[6] * x[7] * x[10] - 0.2113 * x[1] * x[6] * x[8] * x[9] -
        0.9952 * x[1] * x[6] * x[8] * x[10] - 0.9702 * x[1] * x[6] * x[9] * x[10] -
        0.3537 * x[1] * x[7] * x[8] * x[9] + 0.326 * x[1] * x[7] * x[8] * x[10] -
        0.2615 * x[1] * x[7] * x[9] * x[10] - 0.1564 * x[1] * x[8] * x[9] * x[10] +
        0.9175 * x[2] * x[3] * x[4] * x[5] - 0.5903 * x[2] * x[3] * x[4] * x[6] +
        0.9029 * x[2] * x[3] * x[4] * x[7] +
        0.3648 * x[2] * x[3] * x[4] * x[8] - 0.9126 * x[2] * x[3] * x[4] * x[9] -
        0.644 * x[2] * x[3] * x[4] * x[10] +
        0.7789 * x[2] * x[3] * x[5] * x[6] +
        0.0203 * x[2] * x[3] * x[5] * x[7] +
        0.8897 * x[2] * x[3] * x[5] * x[8] - 0.5469 * x[2] * x[3] * x[5] * x[9] -
        0.2008 * x[2] * x[3] * x[5] * x[10] +
        0.6762 * x[2] * x[3] * x[6] * x[7] +
        0.3243 * x[2] * x[3] * x[6] * x[8] - 0.6903 * x[2] * x[3] * x[6] * x[9] +
        0.2058 * x[2] * x[3] * x[6] * x[10] +
        0.3876 * x[2] * x[3] * x[7] * x[8] +
        0.3695 * x[2] * x[3] * x[7] * x[9] +
        0.0322 * x[2] * x[3] * x[7] * x[10] - 0.502 * x[2] * x[3] * x[8] * x[9] -
        0.9679 * x[2] * x[3] * x[8] * x[10] + 0.6939 * x[2] * x[3] * x[9] * x[10] -
        0.7335 * x[2] * x[4] * x[5] * x[6] - 0.0071 * x[2] * x[4] * x[5] * x[7] +
        0.7911 * x[2] * x[4] * x[5] * x[8] - 0.8217 * x[2] * x[4] * x[5] * x[9] -
        0.6734 * x[2] * x[4] * x[5] * x[10] + 0.5343 * x[2] * x[4] * x[6] * x[7] -
        0.6164 * x[2] * x[4] * x[6] * x[8] - 0.0679 * x[2] * x[4] * x[6] * x[9] -
        0.3156 * x[2] * x[4] * x[6] * x[10] - 0.9986 * x[2] * x[4] * x[7] * x[8] -
        0.0287 * x[2] * x[4] * x[7] * x[9] + 0.3193 * x[2] * x[4] * x[7] * x[10] -
        0.92 * x[2] * x[4] * x[8] * x[9] - 0.147 * x[2] * x[4] * x[8] * x[10] -
        0.9656 * x[2] * x[4] * x[9] * x[10] - 0.9044 * x[2] * x[5] * x[6] * x[7] +
        0.9256 * x[2] * x[5] * x[6] * x[8] - 0.0849 * x[2] * x[5] * x[6] * x[9] -
        0.2946 * x[2] * x[5] * x[6] * x[10] + 0.4543 * x[2] * x[5] * x[7] * x[8] -
        0.6516 * x[2] * x[5] * x[7] * x[9] - 0.2951 * x[2] * x[5] * x[7] * x[10] -
        0.5713 * x[2] * x[5] * x[8] * x[9] +
        0.9107 * x[2] * x[5] * x[8] * x[10] +
        0.5607 * x[2] * x[5] * x[9] * x[10] +
        0.5813 * x[2] * x[6] * x[7] * x[8] +
        0.1879 * x[2] * x[6] * x[7] * x[9] +
        0.0879 * x[2] * x[6] * x[7] * x[10] - 0.1947 * x[2] * x[6] * x[8] * x[9] -
        0.5199 * x[2] * x[6] * x[8] * x[10] - 0.661 * x[2] * x[6] * x[9] * x[10] +
        0.7548 * x[2] * x[7] * x[8] * x[9] - 0.8094 * x[2] * x[7] * x[8] * x[10] -
        0.8729 * x[2] * x[7] * x[9] * x[10] + 0.703 * x[2] * x[8] * x[9] * x[10] -
        0.6193 * x[3] * x[4] * x[5] * x[6] +
        0.863 * x[3] * x[4] * x[5] * x[7] +
        0.3731 * x[3] * x[4] * x[5] * x[8] +
        0.975 * x[3] * x[4] * x[5] * x[9] - 0.9151 * x[3] * x[4] * x[5] * x[10] -
        0.1013 * x[3] * x[4] * x[6] * x[7] - 0.7563 * x[3] * x[4] * x[6] * x[8] -
        0.9394 * x[3] * x[4] * x[6] * x[9] - 0.1056 * x[3] * x[4] * x[6] * x[10] +
        0.5528 * x[3] * x[4] * x[7] * x[8] - 0.4469 * x[3] * x[4] * x[7] * x[9] -
        0.6919 * x[3] * x[4] * x[7] * x[10] + 0.6454 * x[3] * x[4] * x[8] * x[9] -
        0.7436 * x[3] * x[4] * x[8] * x[10] - 0.4406 * x[3] * x[4] * x[9] * x[10] -
        0.6553 * x[3] * x[5] * x[6] * x[7] + 0.0815 * x[3] * x[5] * x[6] * x[8] -
        0.2592 * x[3] * x[5] * x[6] * x[9] - 0.3449 * x[3] * x[5] * x[6] * x[10] -
        0.723 * x[3] * x[5] * x[7] * x[8] + 0.7367 * x[3] * x[5] * x[7] * x[9] -
        0.5166 * x[3] * x[5] * x[7] * x[10] - 0.6852 * x[3] * x[5] * x[8] * x[9] +
        0.5099 * x[3] * x[5] * x[8] * x[10] - 0.1606 * x[3] * x[5] * x[9] * x[10] -
        0.8887 * x[3] * x[6] * x[7] * x[8] +
        0.499 * x[3] * x[6] * x[7] * x[9] +
        0.6686 * x[3] * x[6] * x[7] * x[10] +
        0.4415 * x[3] * x[6] * x[8] * x[9] - 0.2126 * x[3] * x[6] * x[8] * x[10] -
        0.8338 * x[3] * x[6] * x[9] * x[10] - 0.8861 * x[3] * x[7] * x[8] * x[9] -
        0.9484 * x[3] * x[7] * x[8] * x[10] - 0.2048 * x[3] * x[7] * x[9] * x[10] -
        0.1835 * x[3] * x[8] * x[9] * x[10] - 0.2758 * x[4] * x[5] * x[6] * x[7] -
        0.5844 * x[4] * x[5] * x[6] * x[8] +
        0.3621 * x[4] * x[5] * x[6] * x[9] +
        0.6829 * x[4] * x[5] * x[6] * x[10] - 0.5893 * x[4] * x[5] * x[7] * x[8] +
        0.5491 * x[4] * x[5] * x[7] * x[9] - 0.8351 * x[4] * x[5] * x[7] * x[10] +
        0.5027 * x[4] * x[5] * x[8] * x[9] +
        0.7318 * x[4] * x[5] * x[8] * x[10] - 0.8597 * x[4] * x[5] * x[9] * x[10] +
        0.7574 * x[4] * x[6] * x[7] * x[8] - 0.9517 * x[4] * x[6] * x[7] * x[9] -
        0.6703 * x[4] * x[6] * x[7] * x[10] +
        0.1705 * x[4] * x[6] * x[8] * x[9] +
        0.3118 * x[4] * x[6] * x[8] * x[10] - 0.299 * x[4] * x[6] * x[9] * x[10] +
        0.1919 * x[4] * x[7] * x[8] * x[9] +
        0.2 * x[4] * x[7] * x[8] * x[10] +
        0.0314 * x[4] * x[7] * x[9] * x[10] - 0.9798 * x[4] * x[8] * x[9] * x[10] -
        0.4391 * x[5] * x[6] * x[7] * x[8] + 0.4177 * x[5] * x[6] * x[7] * x[9] -
        0.3681 * x[5] * x[6] * x[7] * x[10] - 0.7607 * x[5] * x[6] * x[8] * x[9] +
        0.6108 * x[5] * x[6] * x[8] * x[10] +
        0.9076 * x[5] * x[6] * x[9] * x[10] +
        0.3781 * x[5] * x[7] * x[8] * x[9] +
        0.4656 * x[5] * x[7] * x[8] * x[10] - 0.965 * x[5] * x[7] * x[9] * x[10] -
        0.7647 * x[5] * x[8] * x[9] * x[10] - 0.7166 * x[6] * x[7] * x[8] * x[9] -
        0.7744 * x[6] * x[7] * x[8] * x[10] - 0.1137 * x[6] * x[7] * x[9] * x[10] +
        0.2768 * x[6] * x[8] * x[9] * x[10] - 0.1211 * x[7] * x[8] * x[9] * x[10] <=
        84.029
    )
    e10 = replace_expr(e10, x)
    JuMP.add_nonlinear_constraint(m, e10)
    e11 = :(
        0.591 * x[1] * x[3] - 0.6987 * x[1] * x[2] + 0.7248 * x[1] * x[4] -
        0.3342 * x[1] * x[5] +
        0.2565 * x[1] * x[6] +
        0.0506 * x[1] * x[7] +
        0.1018 * x[1] * x[8] +
        0.6964 * x[1] * x[9] - 0.3124 * x[1] * x[10] - 0.0906 * x[2] * x[3] -
        0.4594 * x[2] * x[4] - 0.7137 * x[2] * x[5] + 0.6835 * x[2] * x[6] -
        0.9256 * x[2] * x[7] + 0.8048 * x[2] * x[8] - 0.8525 * x[2] * x[9] +
        0.6184 * x[2] * x[10] +
        0.6039 * x[3] * x[4] - 0.1299 * x[3] * x[5] +
        0.7409 * x[3] * x[6] +
        0.7098 * x[3] * x[7] - 0.7156 * x[3] * x[8] + 0.7937 * x[3] * x[9] -
        0.9671 * x[3] * x[10] - 0.8201 * x[4] * x[5] - 0.9828 * x[4] * x[6] -
        0.2199 * x[4] * x[7] - 0.1975 * x[4] * x[8] +
        0.6526 * x[4] * x[9] +
        0.8052 * x[4] * x[10] +
        0.2971 * x[5] * x[6] +
        0.1198 * x[5] * x[7] +
        0.217 * x[5] * x[8] +
        0.0079 * x[5] * x[9] - 0.3018 * x[5] * x[10] + 0.9843 * x[6] * x[7] -
        0.9696 * x[6] * x[8] + 0.8791 * x[6] * x[9] - 0.9214 * x[6] * x[10] -
        0.6654 * x[7] * x[8] +
        0.8961 * x[7] * x[9] +
        0.7488 * x[7] * x[10] - 0.816 * x[8] * x[9] +
        0.7283 * x[8] * x[10] +
        0.7735 * x[9] * x[10] +
        0.4313 * x[1] - 0.8995 * x[2] - 0.0242 * x[3] + 0.1137 * x[4] -
        0.0807 * x[5] + 0.3716 * x[6] - 0.9041 * x[7] - 0.0494 * x[8] +
        0.8577 * x[9] +
        0.4838 * x[10] +
        0.4225 * x[1] * x[2] * x[4] - 0.2484 * x[1] * x[2] * x[3] +
        0.9204 * x[1] * x[2] * x[5] +
        0.4425 * x[1] * x[2] * x[6] +
        0.8533 * x[1] * x[2] * x[7] - 0.8434 * x[1] * x[2] * x[8] +
        0.3368 * x[1] * x[2] * x[9] - 0.2922 * x[1] * x[2] * x[10] -
        0.674 * x[1] * x[3] * x[4] - 0.506 * x[1] * x[3] * x[5] +
        0.45 * x[1] * x[3] * x[6] +
        0.9451 * x[1] * x[3] * x[7] - 0.6033 * x[1] * x[3] * x[8] -
        0.5666 * x[1] * x[3] * x[9] - 0.5187 * x[1] * x[3] * x[10] -
        0.2378 * x[1] * x[4] * x[5] - 0.8728 * x[1] * x[4] * x[6] +
        0.2078 * x[1] * x[4] * x[7] - 0.4754 * x[1] * x[4] * x[8] -
        0.0257 * x[1] * x[4] * x[9] - 0.6292 * x[1] * x[4] * x[10] -
        0.3056 * x[1] * x[5] * x[6] +
        0.9041 * x[1] * x[5] * x[7] +
        0.9193 * x[1] * x[5] * x[8] +
        0.1786 * x[1] * x[5] * x[9] - 0.8288 * x[1] * x[5] * x[10] +
        0.8871 * x[1] * x[6] * x[7] - 0.5883 * x[1] * x[6] * x[8] -
        0.4245 * x[1] * x[6] * x[9] + 0.2509 * x[1] * x[6] * x[10] -
        0.8896 * x[1] * x[7] * x[8] - 0.7735 * x[1] * x[7] * x[9] +
        0.6383 * x[1] * x[7] * x[10] - 0.7938 * x[1] * x[8] * x[9] -
        0.6181 * x[1] * x[8] * x[10] + 0.0857 * x[1] * x[9] * x[10] -
        0.4053 * x[2] * x[3] * x[4] + 0.2158 * x[2] * x[3] * x[5] -
        0.7104 * x[2] * x[3] * x[6] + 0.1614 * x[2] * x[3] * x[7] -
        0.5585 * x[2] * x[3] * x[8] - 0.0765 * x[2] * x[3] * x[9] -
        0.9573 * x[2] * x[3] * x[10] + 0.744 * x[2] * x[4] * x[5] -
        0.1551 * x[2] * x[4] * x[6] +
        0.4025 * x[2] * x[4] * x[7] +
        0.9942 * x[2] * x[4] * x[8] - 0.2869 * x[2] * x[4] * x[9] -
        0.6106 * x[2] * x[4] * x[10] + 0.5482 * x[2] * x[5] * x[6] -
        0.5155 * x[2] * x[5] * x[7] +
        0.2689 * x[2] * x[5] * x[8] +
        0.291 * x[2] * x[5] * x[9] - 0.6436 * x[2] * x[5] * x[10] -
        0.6477 * x[2] * x[6] * x[7] - 0.0194 * x[2] * x[6] * x[8] -
        0.2997 * x[2] * x[6] * x[9] + 0.7213 * x[2] * x[6] * x[10] -
        0.9991 * x[2] * x[7] * x[8] +
        0.8354 * x[2] * x[7] * x[9] +
        0.9739 * x[2] * x[7] * x[10] +
        0.9231 * x[2] * x[8] * x[9] - 0.5433 * x[2] * x[8] * x[10] -
        0.5059 * x[2] * x[9] * x[10] +
        0.1579 * x[3] * x[4] * x[5] +
        0.9595 * x[3] * x[4] * x[6] - 0.4744 * x[3] * x[4] * x[7] -
        0.7872 * x[3] * x[4] * x[8] +
        0.8894 * x[3] * x[4] * x[9] +
        0.6219 * x[3] * x[4] * x[10] - 0.9093 * x[3] * x[5] * x[6] +
        0.9121 * x[3] * x[5] * x[7] +
        0.4676 * x[3] * x[5] * x[8] - 0.056 * x[3] * x[5] * x[9] +
        0.7962 * x[3] * x[5] * x[10] +
        0.2177 * x[3] * x[6] * x[7] - 0.1877 * x[3] * x[6] * x[8] +
        0.2283 * x[3] * x[6] * x[9] +
        0.5367 * x[3] * x[6] * x[10] - 0.594 * x[3] * x[7] * x[8] +
        0.022 * x[3] * x[7] * x[9] - 0.9741 * x[3] * x[7] * x[10] -
        0.7372 * x[3] * x[8] * x[9] - 0.0799 * x[3] * x[8] * x[10] +
        0.6106 * x[3] * x[9] * x[10] +
        0.4631 * x[4] * x[5] * x[6] - 0.7378 * x[4] * x[5] * x[7] -
        0.8125 * x[4] * x[5] * x[8] - 0.4392 * x[4] * x[5] * x[9] -
        0.7147 * x[4] * x[5] * x[10] - 0.974 * x[4] * x[6] * x[7] +
        0.9874 * x[4] * x[6] * x[8] +
        0.422 * x[4] * x[6] * x[9] +
        0.6878 * x[4] * x[6] * x[10] +
        0.12 * x[4] * x[7] * x[8] - 0.8755 * x[4] * x[7] * x[9] -
        0.2555 * x[4] * x[7] * x[10] - 0.5743 * x[4] * x[8] * x[9] -
        0.5735 * x[4] * x[8] * x[10] - 0.6477 * x[4] * x[9] * x[10] +
        0.0007 * x[5] * x[6] * x[7] +
        0.0896 * x[5] * x[6] * x[8] +
        0.1403 * x[5] * x[6] * x[9] +
        0.0392 * x[5] * x[6] * x[10] - 0.9063 * x[5] * x[7] * x[8] -
        0.3817 * x[5] * x[7] * x[9] +
        0.8622 * x[5] * x[7] * x[10] +
        0.0331 * x[5] * x[8] * x[9] - 0.1539 * x[5] * x[8] * x[10] -
        0.684 * x[5] * x[9] * x[10] +
        0.8427 * x[6] * x[7] * x[8] +
        0.679 * x[6] * x[7] * x[9] - 0.8744 * x[6] * x[7] * x[10] -
        0.5763 * x[6] * x[8] * x[9] +
        0.131 * x[6] * x[8] * x[10] +
        0.7207 * x[6] * x[9] * x[10] +
        0.2711 * x[7] * x[8] * x[9] +
        0.901 * x[7] * x[8] * x[10] - 0.0142 * x[7] * x[9] * x[10] +
        0.7093 * x[8] * x[9] * x[10] +
        0.7493 * x[1] * x[2] * x[3] * x[5] - 0.7313 * x[1] * x[2] * x[3] * x[4] -
        0.1795 * x[1] * x[2] * x[3] * x[6] - 0.6154 * x[1] * x[2] * x[3] * x[7] +
        0.4774 * x[1] * x[2] * x[3] * x[8] +
        0.2237 * x[1] * x[2] * x[3] * x[9] +
        0.819 * x[1] * x[2] * x[3] * x[10] - 0.2799 * x[1] * x[2] * x[4] * x[5] -
        0.4367 * x[1] * x[2] * x[4] * x[6] - 0.7202 * x[1] * x[2] * x[4] * x[7] +
        0.7141 * x[1] * x[2] * x[4] * x[8] +
        0.2112 * x[1] * x[2] * x[4] * x[9] +
        0.7705 * x[1] * x[2] * x[4] * x[10] +
        0.0843 * x[1] * x[2] * x[5] * x[6] +
        0.3562 * x[1] * x[2] * x[5] * x[7] +
        0.7516 * x[1] * x[2] * x[5] * x[8] +
        0.6577 * x[1] * x[2] * x[5] * x[9] +
        0.288 * x[1] * x[2] * x[5] * x[10] +
        0.179 * x[1] * x[2] * x[6] * x[7] +
        0.1567 * x[1] * x[2] * x[6] * x[8] - 0.3688 * x[1] * x[2] * x[6] * x[9] +
        0.7408 * x[1] * x[2] * x[6] * x[10] - 0.4765 * x[1] * x[2] * x[7] * x[8] +
        0.6741 * x[1] * x[2] * x[7] * x[9] +
        0.112 * x[1] * x[2] * x[7] * x[10] - 0.8509 * x[1] * x[2] * x[8] * x[9] +
        0.4165 * x[1] * x[2] * x[8] * x[10] - 0.9974 * x[1] * x[2] * x[9] * x[10] -
        0.3871 * x[1] * x[3] * x[4] * x[5] +
        0.6783 * x[1] * x[3] * x[4] * x[6] +
        0.8508 * x[1] * x[3] * x[4] * x[7] - 0.7738 * x[1] * x[3] * x[4] * x[8] +
        0.6638 * x[1] * x[3] * x[4] * x[9] +
        0.5599 * x[1] * x[3] * x[4] * x[10] +
        0.7158 * x[1] * x[3] * x[5] * x[6] +
        0.1086 * x[1] * x[3] * x[5] * x[7] - 0.69 * x[1] * x[3] * x[5] * x[8] -
        0.4714 * x[1] * x[3] * x[5] * x[9] +
        0.6628 * x[1] * x[3] * x[5] * x[10] +
        0.1565 * x[1] * x[3] * x[6] * x[7] +
        0.2639 * x[1] * x[3] * x[6] * x[8] - 0.0214 * x[1] * x[3] * x[6] * x[9] -
        0.6831 * x[1] * x[3] * x[6] * x[10] - 0.7759 * x[1] * x[3] * x[7] * x[8] +
        0.3236 * x[1] * x[3] * x[7] * x[9] - 0.768 * x[1] * x[3] * x[7] * x[10] -
        0.4247 * x[1] * x[3] * x[8] * x[9] +
        0.4122 * x[1] * x[3] * x[8] * x[10] +
        0.4506 * x[1] * x[3] * x[9] * x[10] +
        0.3552 * x[1] * x[4] * x[5] * x[6] +
        0.446 * x[1] * x[4] * x[5] * x[7] +
        0.3144 * x[1] * x[4] * x[5] * x[8] +
        0.4965 * x[1] * x[4] * x[5] * x[9] - 0.8063 * x[1] * x[4] * x[5] * x[10] -
        0.612 * x[1] * x[4] * x[6] * x[7] +
        0.7794 * x[1] * x[4] * x[6] * x[8] +
        0.834 * x[1] * x[4] * x[6] * x[9] +
        0.6108 * x[1] * x[4] * x[6] * x[10] +
        0.8644 * x[1] * x[4] * x[7] * x[8] - 0.8542 * x[1] * x[4] * x[7] * x[9] -
        0.2302 * x[1] * x[4] * x[7] * x[10] - 0.1178 * x[1] * x[4] * x[8] * x[9] -
        0.9046 * x[1] * x[4] * x[8] * x[10] - 0.262 * x[1] * x[4] * x[9] * x[10] -
        0.6183 * x[1] * x[5] * x[6] * x[7] + 0.6188 * x[1] * x[5] * x[6] * x[8] -
        0.0381 * x[1] * x[5] * x[6] * x[9] - 0.7188 * x[1] * x[5] * x[6] * x[10] -
        0.1034 * x[1] * x[5] * x[7] * x[8] +
        0.4047 * x[1] * x[5] * x[7] * x[9] +
        0.0084 * x[1] * x[5] * x[7] * x[10] - 0.4031 * x[1] * x[5] * x[8] * x[9] +
        0.702 * x[1] * x[5] * x[8] * x[10] - 0.8478 * x[1] * x[5] * x[9] * x[10] +
        0.7782 * x[1] * x[6] * x[7] * x[8] +
        0.7223 * x[1] * x[6] * x[7] * x[9] +
        0.5405 * x[1] * x[6] * x[7] * x[10] +
        0.7626 * x[1] * x[6] * x[8] * x[9] - 0.2324 * x[1] * x[6] * x[8] * x[10] -
        0.6926 * x[1] * x[6] * x[9] * x[10] - 0.4473 * x[1] * x[7] * x[8] * x[9] +
        0.5227 * x[1] * x[7] * x[8] * x[10] - 0.1544 * x[1] * x[7] * x[9] * x[10] +
        0.1788 * x[1] * x[8] * x[9] * x[10] - 0.8851 * x[2] * x[3] * x[4] * x[5] -
        0.397 * x[2] * x[3] * x[4] * x[6] - 0.8556 * x[2] * x[3] * x[4] * x[7] +
        0.5239 * x[2] * x[3] * x[4] * x[8] +
        0.0308 * x[2] * x[3] * x[4] * x[9] - 0.7734 * x[2] * x[3] * x[4] * x[10] +
        0.3039 * x[2] * x[3] * x[5] * x[6] - 0.7162 * x[2] * x[3] * x[5] * x[7] +
        0.3885 * x[2] * x[3] * x[5] * x[8] - 0.999 * x[2] * x[3] * x[5] * x[9] -
        0.1183 * x[2] * x[3] * x[5] * x[10] - 0.1821 * x[2] * x[3] * x[6] * x[7] +
        0.6174 * x[2] * x[3] * x[6] * x[8] - 0.854 * x[2] * x[3] * x[6] * x[9] +
        0.5544 * x[2] * x[3] * x[6] * x[10] +
        0.232 * x[2] * x[3] * x[7] * x[8] - 0.6641 * x[2] * x[3] * x[7] * x[9] -
        0.3447 * x[2] * x[3] * x[7] * x[10] +
        0.6963 * x[2] * x[3] * x[8] * x[9] +
        0.1228 * x[2] * x[3] * x[8] * x[10] +
        0.1779 * x[2] * x[3] * x[9] * x[10] +
        0.973 * x[2] * x[4] * x[5] * x[6] +
        0.1374 * x[2] * x[4] * x[5] * x[7] - 0.5653 * x[2] * x[4] * x[5] * x[8] +
        0.3235 * x[2] * x[4] * x[5] * x[9] - 0.7351 * x[2] * x[4] * x[5] * x[10] +
        0.1866 * x[2] * x[4] * x[6] * x[7] - 0.1166 * x[2] * x[4] * x[6] * x[8] +
        0.6616 * x[2] * x[4] * x[6] * x[9] +
        0.3928 * x[2] * x[4] * x[6] * x[10] +
        0.4047 * x[2] * x[4] * x[7] * x[8] - 0.492 * x[2] * x[4] * x[7] * x[9] +
        0.0233 * x[2] * x[4] * x[7] * x[10] - 0.0839 * x[2] * x[4] * x[8] * x[9] +
        0.9802 * x[2] * x[4] * x[8] * x[10] +
        0.2466 * x[2] * x[4] * x[9] * x[10] +
        0.0186 * x[2] * x[5] * x[6] * x[7] +
        0.761 * x[2] * x[5] * x[6] * x[8] +
        0.1837 * x[2] * x[5] * x[6] * x[9] +
        0.6049 * x[2] * x[5] * x[6] * x[10] - 0.782 * x[2] * x[5] * x[7] * x[8] +
        0.8772 * x[2] * x[5] * x[7] * x[9] +
        0.9354 * x[2] * x[5] * x[7] * x[10] +
        0.5135 * x[2] * x[5] * x[8] * x[9] +
        0.5527 * x[2] * x[5] * x[8] * x[10] +
        0.5089 * x[2] * x[5] * x[9] * x[10] - 0.9858 * x[2] * x[6] * x[7] * x[8] +
        0.7245 * x[2] * x[6] * x[7] * x[9] - 0.7463 * x[2] * x[6] * x[7] * x[10] -
        0.5182 * x[2] * x[6] * x[8] * x[9] - 0.6181 * x[2] * x[6] * x[8] * x[10] -
        0.815 * x[2] * x[6] * x[9] * x[10] - 0.1105 * x[2] * x[7] * x[8] * x[9] -
        0.6992 * x[2] * x[7] * x[8] * x[10] +
        0.2491 * x[2] * x[7] * x[9] * x[10] +
        0.6866 * x[2] * x[8] * x[9] * x[10] - 0.7184 * x[3] * x[4] * x[5] * x[6] +
        0.7077 * x[3] * x[4] * x[5] * x[7] - 0.8608 * x[3] * x[4] * x[5] * x[8] -
        0.851 * x[3] * x[4] * x[5] * x[9] + 0.6374 * x[3] * x[4] * x[5] * x[10] -
        0.0365 * x[3] * x[4] * x[6] * x[7] +
        0.7884 * x[3] * x[4] * x[6] * x[8] +
        0.6555 * x[3] * x[4] * x[6] * x[9] - 0.3754 * x[3] * x[4] * x[6] * x[10] -
        0.0738 * x[3] * x[4] * x[7] * x[8] +
        0.9879 * x[3] * x[4] * x[7] * x[9] +
        0.0135 * x[3] * x[4] * x[7] * x[10] - 0.3498 * x[3] * x[4] * x[8] * x[9] -
        0.0971 * x[3] * x[4] * x[8] * x[10] + 0.904 * x[3] * x[4] * x[9] * x[10] -
        0.2376 * x[3] * x[5] * x[6] * x[7] + 0.2933 * x[3] * x[5] * x[6] * x[8] -
        0.9793 * x[3] * x[5] * x[6] * x[9] - 0.2463 * x[3] * x[5] * x[6] * x[10] +
        0.4602 * x[3] * x[5] * x[7] * x[8] +
        0.2682 * x[3] * x[5] * x[7] * x[9] - 0.5987 * x[3] * x[5] * x[7] * x[10] +
        0.5991 * x[3] * x[5] * x[8] * x[9] - 0.2997 * x[3] * x[5] * x[8] * x[10] +
        0.4424 * x[3] * x[5] * x[9] * x[10] - 0.2551 * x[3] * x[6] * x[7] * x[8] -
        0.4591 * x[3] * x[6] * x[7] * x[9] +
        0.191 * x[3] * x[6] * x[7] * x[10] +
        0.7592 * x[3] * x[6] * x[8] * x[9] - 0.4934 * x[3] * x[6] * x[8] * x[10] -
        0.5187 * x[3] * x[6] * x[9] * x[10] - 0.1522 * x[3] * x[7] * x[8] * x[9] -
        0.7995 * x[3] * x[7] * x[8] * x[10] +
        0.2015 * x[3] * x[7] * x[9] * x[10] +
        0.7515 * x[3] * x[8] * x[9] * x[10] - 0.3003 * x[4] * x[5] * x[6] * x[7] -
        0.0052 * x[4] * x[5] * x[6] * x[8] - 0.2116 * x[4] * x[5] * x[6] * x[9] -
        0.069 * x[4] * x[5] * x[6] * x[10] +
        0.4125 * x[4] * x[5] * x[7] * x[8] +
        0.1911 * x[4] * x[5] * x[7] * x[9] +
        0.141 * x[4] * x[5] * x[7] * x[10] - 0.4838 * x[4] * x[5] * x[8] * x[9] +
        0.0428 * x[4] * x[5] * x[8] * x[10] - 0.3545 * x[4] * x[5] * x[9] * x[10] -
        0.836 * x[4] * x[6] * x[7] * x[8] +
        0.9044 * x[4] * x[6] * x[7] * x[9] +
        0.9537 * x[4] * x[6] * x[7] * x[10] +
        0.0803 * x[4] * x[6] * x[8] * x[9] - 0.4248 * x[4] * x[6] * x[8] * x[10] +
        0.9858 * x[4] * x[6] * x[9] * x[10] +
        0.8136 * x[4] * x[7] * x[8] * x[9] +
        0.6273 * x[4] * x[7] * x[8] * x[10] +
        0.3116 * x[4] * x[7] * x[9] * x[10] +
        0.5186 * x[4] * x[8] * x[9] * x[10] +
        0.4613 * x[5] * x[6] * x[7] * x[8] +
        0.5744 * x[5] * x[6] * x[7] * x[9] - 0.5661 * x[5] * x[6] * x[7] * x[10] -
        0.7528 * x[5] * x[6] * x[8] * x[9] - 0.1247 * x[5] * x[6] * x[8] * x[10] -
        0.5048 * x[5] * x[6] * x[9] * x[10] +
        0.1487 * x[5] * x[7] * x[8] * x[9] +
        0.6904 * x[5] * x[7] * x[8] * x[10] - 0.4091 * x[5] * x[7] * x[9] * x[10] +
        0.8667 * x[5] * x[8] * x[9] * x[10] +
        0.4524 * x[6] * x[7] * x[8] * x[9] - 0.4188 * x[6] * x[7] * x[8] * x[10] -
        0.3955 * x[6] * x[7] * x[9] * x[10] + 0.3814 * x[6] * x[8] * x[9] * x[10] -
        0.4766 * x[7] * x[8] * x[9] * x[10] <= 99.878
    )
    e11 = replace_expr(e11, x)
    JuMP.add_nonlinear_constraint(m, e11)

    return m
end
