# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: amplifybackend
using AWS.Compat
using AWS.UUIDs

"""
    clone_backend(app_id, backend_environment_name, target_environment_name)
    clone_backend(app_id, backend_environment_name, target_environment_name, params::Dict{String,<:Any})

This operation clones an existing backend.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `target_environment_name`: The name of the destination backend environment to be created.

"""
function clone_backend(
    appId,
    backendEnvironmentName,
    targetEnvironmentName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/environments/$(backendEnvironmentName)/clone",
        Dict{String,Any}("targetEnvironmentName" => targetEnvironmentName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function clone_backend(
    appId,
    backendEnvironmentName,
    targetEnvironmentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/environments/$(backendEnvironmentName)/clone",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("targetEnvironmentName" => targetEnvironmentName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_backend(app_id, app_name, backend_environment_name)
    create_backend(app_id, app_name, backend_environment_name, params::Dict{String,<:Any})

This operation creates a backend for an Amplify app. Backends are automatically created at
the time of app creation.

# Arguments
- `app_id`: The app ID.
- `app_name`: The name of the app.
- `backend_environment_name`: The name of the backend environment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"resourceConfig"`: The resource configuration for creating a backend.
- `"resourceName"`: The name of the resource.
"""
function create_backend(
    appId,
    appName,
    backendEnvironmentName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend",
        Dict{String,Any}(
            "appId" => appId,
            "appName" => appName,
            "backendEnvironmentName" => backendEnvironmentName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_backend(
    appId,
    appName,
    backendEnvironmentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "appId" => appId,
                    "appName" => appName,
                    "backendEnvironmentName" => backendEnvironmentName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_backend_api(app_id, backend_environment_name, resource_config, resource_name)
    create_backend_api(app_id, backend_environment_name, resource_config, resource_name, params::Dict{String,<:Any})

Creates a new backend API resource.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `resource_config`: The resource configuration for this request.
- `resource_name`: The name of this resource.

"""
function create_backend_api(
    appId,
    backendEnvironmentName,
    resourceConfig,
    resourceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/api",
        Dict{String,Any}(
            "backendEnvironmentName" => backendEnvironmentName,
            "resourceConfig" => resourceConfig,
            "resourceName" => resourceName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_backend_api(
    appId,
    backendEnvironmentName,
    resourceConfig,
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/api",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "backendEnvironmentName" => backendEnvironmentName,
                    "resourceConfig" => resourceConfig,
                    "resourceName" => resourceName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_backend_auth(app_id, backend_environment_name, resource_config, resource_name)
    create_backend_auth(app_id, backend_environment_name, resource_config, resource_name, params::Dict{String,<:Any})

Creates a new backend authentication resource.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `resource_config`: The resource configuration for this request object.
- `resource_name`: The name of this resource.

"""
function create_backend_auth(
    appId,
    backendEnvironmentName,
    resourceConfig,
    resourceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/auth",
        Dict{String,Any}(
            "backendEnvironmentName" => backendEnvironmentName,
            "resourceConfig" => resourceConfig,
            "resourceName" => resourceName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_backend_auth(
    appId,
    backendEnvironmentName,
    resourceConfig,
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/auth",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "backendEnvironmentName" => backendEnvironmentName,
                    "resourceConfig" => resourceConfig,
                    "resourceName" => resourceName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_backend_config(app_id)
    create_backend_config(app_id, params::Dict{String,<:Any})

Creates a config object for a backend.

# Arguments
- `app_id`: The app ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"backendManagerAppId"`: The app ID for the backend manager.
"""
function create_backend_config(appId; aws_config::AbstractAWSConfig=current_aws_config())
    return amplifybackend(
        "POST",
        "/backend/$(appId)/config";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_backend_config(
    appId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/config",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_backend_storage(app_id, backend_environment_name, resource_config, resource_name)
    create_backend_storage(app_id, backend_environment_name, resource_config, resource_name, params::Dict{String,<:Any})

Creates a backend storage resource.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `resource_config`: The resource configuration for creating backend storage.
- `resource_name`: The name of the storage resource.

"""
function create_backend_storage(
    appId,
    backendEnvironmentName,
    resourceConfig,
    resourceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/storage",
        Dict{String,Any}(
            "backendEnvironmentName" => backendEnvironmentName,
            "resourceConfig" => resourceConfig,
            "resourceName" => resourceName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_backend_storage(
    appId,
    backendEnvironmentName,
    resourceConfig,
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/storage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "backendEnvironmentName" => backendEnvironmentName,
                    "resourceConfig" => resourceConfig,
                    "resourceName" => resourceName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_token(app_id)
    create_token(app_id, params::Dict{String,<:Any})

Generates a one-time challenge code to authenticate a user into your Amplify Admin UI.

# Arguments
- `app_id`: The app ID.

"""
function create_token(appId; aws_config::AbstractAWSConfig=current_aws_config())
    return amplifybackend(
        "POST",
        "/backend/$(appId)/challenge";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_token(
    appId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/challenge",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_backend(app_id, backend_environment_name)
    delete_backend(app_id, backend_environment_name, params::Dict{String,<:Any})

Removes an existing environment from your Amplify project.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.

"""
function delete_backend(
    appId, backendEnvironmentName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/environments/$(backendEnvironmentName)/remove";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_backend(
    appId,
    backendEnvironmentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/environments/$(backendEnvironmentName)/remove",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_backend_api(app_id, backend_environment_name, resource_name)
    delete_backend_api(app_id, backend_environment_name, resource_name, params::Dict{String,<:Any})

Deletes an existing backend API resource.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `resource_name`: The name of this resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"resourceConfig"`: Defines the resource configuration for the data model in your Amplify
  project.
"""
function delete_backend_api(
    appId,
    backendEnvironmentName,
    resourceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/api/$(backendEnvironmentName)/remove",
        Dict{String,Any}("resourceName" => resourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_backend_api(
    appId,
    backendEnvironmentName,
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/api/$(backendEnvironmentName)/remove",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceName" => resourceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_backend_auth(app_id, backend_environment_name, resource_name)
    delete_backend_auth(app_id, backend_environment_name, resource_name, params::Dict{String,<:Any})

Deletes an existing backend authentication resource.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `resource_name`: The name of this resource.

"""
function delete_backend_auth(
    appId,
    backendEnvironmentName,
    resourceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/auth/$(backendEnvironmentName)/remove",
        Dict{String,Any}("resourceName" => resourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_backend_auth(
    appId,
    backendEnvironmentName,
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/auth/$(backendEnvironmentName)/remove",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceName" => resourceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_backend_storage(app_id, backend_environment_name, resource_name, service_name)
    delete_backend_storage(app_id, backend_environment_name, resource_name, service_name, params::Dict{String,<:Any})

Removes the specified backend storage resource.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `resource_name`: The name of the storage resource.
- `service_name`: The name of the storage service.

"""
function delete_backend_storage(
    appId,
    backendEnvironmentName,
    resourceName,
    serviceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/storage/$(backendEnvironmentName)/remove",
        Dict{String,Any}("resourceName" => resourceName, "serviceName" => serviceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_backend_storage(
    appId,
    backendEnvironmentName,
    resourceName,
    serviceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/storage/$(backendEnvironmentName)/remove",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "resourceName" => resourceName, "serviceName" => serviceName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_token(app_id, session_id)
    delete_token(app_id, session_id, params::Dict{String,<:Any})

Deletes the challenge token based on the given appId and sessionId.

# Arguments
- `app_id`: The app ID.
- `session_id`: The session ID.

"""
function delete_token(appId, sessionId; aws_config::AbstractAWSConfig=current_aws_config())
    return amplifybackend(
        "POST",
        "/backend/$(appId)/challenge/$(sessionId)/remove";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_token(
    appId,
    sessionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/challenge/$(sessionId)/remove",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    generate_backend_apimodels(app_id, backend_environment_name, resource_name)
    generate_backend_apimodels(app_id, backend_environment_name, resource_name, params::Dict{String,<:Any})

Generates a model schema for an existing backend API resource.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `resource_name`: The name of this resource.

"""
function generate_backend_apimodels(
    appId,
    backendEnvironmentName,
    resourceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/api/$(backendEnvironmentName)/generateModels",
        Dict{String,Any}("resourceName" => resourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function generate_backend_apimodels(
    appId,
    backendEnvironmentName,
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/api/$(backendEnvironmentName)/generateModels",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceName" => resourceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_backend(app_id)
    get_backend(app_id, params::Dict{String,<:Any})

Provides project-level details for your Amplify UI project.

# Arguments
- `app_id`: The app ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"backendEnvironmentName"`: The name of the backend environment.
"""
function get_backend(appId; aws_config::AbstractAWSConfig=current_aws_config())
    return amplifybackend(
        "POST",
        "/backend/$(appId)/details";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_backend(
    appId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/details",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_backend_api(app_id, backend_environment_name, resource_name)
    get_backend_api(app_id, backend_environment_name, resource_name, params::Dict{String,<:Any})

Gets the details for a backend API.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `resource_name`: The name of this resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"resourceConfig"`: Defines the resource configuration for the data model in your Amplify
  project.
"""
function get_backend_api(
    appId,
    backendEnvironmentName,
    resourceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/api/$(backendEnvironmentName)/details",
        Dict{String,Any}("resourceName" => resourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_backend_api(
    appId,
    backendEnvironmentName,
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/api/$(backendEnvironmentName)/details",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceName" => resourceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_backend_apimodels(app_id, backend_environment_name, resource_name)
    get_backend_apimodels(app_id, backend_environment_name, resource_name, params::Dict{String,<:Any})

Gets a model introspection schema for an existing backend API resource.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `resource_name`: The name of this resource.

"""
function get_backend_apimodels(
    appId,
    backendEnvironmentName,
    resourceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/api/$(backendEnvironmentName)/getModels",
        Dict{String,Any}("resourceName" => resourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_backend_apimodels(
    appId,
    backendEnvironmentName,
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/api/$(backendEnvironmentName)/getModels",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceName" => resourceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_backend_auth(app_id, backend_environment_name, resource_name)
    get_backend_auth(app_id, backend_environment_name, resource_name, params::Dict{String,<:Any})

Gets a backend auth details.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `resource_name`: The name of this resource.

"""
function get_backend_auth(
    appId,
    backendEnvironmentName,
    resourceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/auth/$(backendEnvironmentName)/details",
        Dict{String,Any}("resourceName" => resourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_backend_auth(
    appId,
    backendEnvironmentName,
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/auth/$(backendEnvironmentName)/details",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceName" => resourceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_backend_job(app_id, backend_environment_name, job_id)
    get_backend_job(app_id, backend_environment_name, job_id, params::Dict{String,<:Any})

Returns information about a specific job.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `job_id`: The ID for the job.

"""
function get_backend_job(
    appId, backendEnvironmentName, jobId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifybackend(
        "GET",
        "/backend/$(appId)/job/$(backendEnvironmentName)/$(jobId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_backend_job(
    appId,
    backendEnvironmentName,
    jobId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "GET",
        "/backend/$(appId)/job/$(backendEnvironmentName)/$(jobId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_backend_storage(app_id, backend_environment_name, resource_name)
    get_backend_storage(app_id, backend_environment_name, resource_name, params::Dict{String,<:Any})

Gets details for a backend storage resource.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `resource_name`: The name of the storage resource.

"""
function get_backend_storage(
    appId,
    backendEnvironmentName,
    resourceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/storage/$(backendEnvironmentName)/details",
        Dict{String,Any}("resourceName" => resourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_backend_storage(
    appId,
    backendEnvironmentName,
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/storage/$(backendEnvironmentName)/details",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceName" => resourceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_token(app_id, session_id)
    get_token(app_id, session_id, params::Dict{String,<:Any})

Gets the challenge token based on the given appId and sessionId.

# Arguments
- `app_id`: The app ID.
- `session_id`: The session ID.

"""
function get_token(appId, sessionId; aws_config::AbstractAWSConfig=current_aws_config())
    return amplifybackend(
        "GET",
        "/backend/$(appId)/challenge/$(sessionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_token(
    appId,
    sessionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "GET",
        "/backend/$(appId)/challenge/$(sessionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    import_backend_auth(app_id, backend_environment_name, native_client_id, user_pool_id, web_client_id)
    import_backend_auth(app_id, backend_environment_name, native_client_id, user_pool_id, web_client_id, params::Dict{String,<:Any})

Imports an existing backend authentication resource.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `native_client_id`: The ID of the Amazon Cognito native client.
- `user_pool_id`: The ID of the Amazon Cognito user pool.
- `web_client_id`: The ID of the Amazon Cognito web client.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"identityPoolId"`: The ID of the Amazon Cognito identity pool.
"""
function import_backend_auth(
    appId,
    backendEnvironmentName,
    nativeClientId,
    userPoolId,
    webClientId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/auth/$(backendEnvironmentName)/import",
        Dict{String,Any}(
            "nativeClientId" => nativeClientId,
            "userPoolId" => userPoolId,
            "webClientId" => webClientId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_backend_auth(
    appId,
    backendEnvironmentName,
    nativeClientId,
    userPoolId,
    webClientId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/auth/$(backendEnvironmentName)/import",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "nativeClientId" => nativeClientId,
                    "userPoolId" => userPoolId,
                    "webClientId" => webClientId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    import_backend_storage(app_id, backend_environment_name, service_name)
    import_backend_storage(app_id, backend_environment_name, service_name, params::Dict{String,<:Any})

Imports an existing backend storage resource.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `service_name`: The name of the storage service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"bucketName"`: The name of the S3 bucket.
"""
function import_backend_storage(
    appId,
    backendEnvironmentName,
    serviceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/storage/$(backendEnvironmentName)/import",
        Dict{String,Any}("serviceName" => serviceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_backend_storage(
    appId,
    backendEnvironmentName,
    serviceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/storage/$(backendEnvironmentName)/import",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("serviceName" => serviceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_backend_jobs(app_id, backend_environment_name)
    list_backend_jobs(app_id, backend_environment_name, params::Dict{String,<:Any})

Lists the jobs for the backend of an Amplify app.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"jobId"`: The ID for the job.
- `"maxResults"`: The maximum number of results that you want in the response.
- `"nextToken"`: The token for the next set of results.
- `"operation"`: Filters the list of response objects to include only those with the
  specified operation name.
- `"status"`: Filters the list of response objects to include only those with the specified
  status.
"""
function list_backend_jobs(
    appId, backendEnvironmentName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/job/$(backendEnvironmentName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_backend_jobs(
    appId,
    backendEnvironmentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/job/$(backendEnvironmentName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_s3_buckets()
    list_s3_buckets(params::Dict{String,<:Any})

The list of S3 buckets in your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: Reserved for future use.
"""
function list_s3_buckets(; aws_config::AbstractAWSConfig=current_aws_config())
    return amplifybackend(
        "POST", "/s3Buckets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_s3_buckets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifybackend(
        "POST", "/s3Buckets", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    remove_all_backends(app_id)
    remove_all_backends(app_id, params::Dict{String,<:Any})

Removes all backend environments from your Amplify project.

# Arguments
- `app_id`: The app ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"cleanAmplifyApp"`: Cleans up the Amplify Console app if this value is set to true.
"""
function remove_all_backends(appId; aws_config::AbstractAWSConfig=current_aws_config())
    return amplifybackend(
        "POST",
        "/backend/$(appId)/remove";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_all_backends(
    appId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/remove",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_backend_config(app_id)
    remove_backend_config(app_id, params::Dict{String,<:Any})

Removes the AWS resources required to access the Amplify Admin UI.

# Arguments
- `app_id`: The app ID.

"""
function remove_backend_config(appId; aws_config::AbstractAWSConfig=current_aws_config())
    return amplifybackend(
        "POST",
        "/backend/$(appId)/config/remove";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_backend_config(
    appId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/config/remove",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_backend_api(app_id, backend_environment_name, resource_name)
    update_backend_api(app_id, backend_environment_name, resource_name, params::Dict{String,<:Any})

Updates an existing backend API resource.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `resource_name`: The name of this resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"resourceConfig"`: Defines the resource configuration for the data model in your Amplify
  project.
"""
function update_backend_api(
    appId,
    backendEnvironmentName,
    resourceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/api/$(backendEnvironmentName)",
        Dict{String,Any}("resourceName" => resourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_backend_api(
    appId,
    backendEnvironmentName,
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/api/$(backendEnvironmentName)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceName" => resourceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_backend_auth(app_id, backend_environment_name, resource_config, resource_name)
    update_backend_auth(app_id, backend_environment_name, resource_config, resource_name, params::Dict{String,<:Any})

Updates an existing backend authentication resource.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `resource_config`: The resource configuration for this request object.
- `resource_name`: The name of this resource.

"""
function update_backend_auth(
    appId,
    backendEnvironmentName,
    resourceConfig,
    resourceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/auth/$(backendEnvironmentName)",
        Dict{String,Any}(
            "resourceConfig" => resourceConfig, "resourceName" => resourceName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_backend_auth(
    appId,
    backendEnvironmentName,
    resourceConfig,
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/auth/$(backendEnvironmentName)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "resourceConfig" => resourceConfig, "resourceName" => resourceName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_backend_config(app_id)
    update_backend_config(app_id, params::Dict{String,<:Any})

Updates the AWS resources required to access the Amplify Admin UI.

# Arguments
- `app_id`: The app ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"loginAuthConfig"`: Describes the Amazon Cognito configuration for Admin UI access.
"""
function update_backend_config(appId; aws_config::AbstractAWSConfig=current_aws_config())
    return amplifybackend(
        "POST",
        "/backend/$(appId)/config/update";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_backend_config(
    appId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/config/update",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_backend_job(app_id, backend_environment_name, job_id)
    update_backend_job(app_id, backend_environment_name, job_id, params::Dict{String,<:Any})

Updates a specific job.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `job_id`: The ID for the job.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"operation"`: Filters the list of response objects to include only those with the
  specified operation name.
- `"status"`: Filters the list of response objects to include only those with the specified
  status.
"""
function update_backend_job(
    appId, backendEnvironmentName, jobId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/job/$(backendEnvironmentName)/$(jobId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_backend_job(
    appId,
    backendEnvironmentName,
    jobId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/job/$(backendEnvironmentName)/$(jobId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_backend_storage(app_id, backend_environment_name, resource_config, resource_name)
    update_backend_storage(app_id, backend_environment_name, resource_config, resource_name, params::Dict{String,<:Any})

Updates an existing backend storage resource.

# Arguments
- `app_id`: The app ID.
- `backend_environment_name`: The name of the backend environment.
- `resource_config`: The resource configuration for updating backend storage.
- `resource_name`: The name of the storage resource.

"""
function update_backend_storage(
    appId,
    backendEnvironmentName,
    resourceConfig,
    resourceName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/storage/$(backendEnvironmentName)",
        Dict{String,Any}(
            "resourceConfig" => resourceConfig, "resourceName" => resourceName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_backend_storage(
    appId,
    backendEnvironmentName,
    resourceConfig,
    resourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifybackend(
        "POST",
        "/backend/$(appId)/storage/$(backendEnvironmentName)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "resourceConfig" => resourceConfig, "resourceName" => resourceName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
