# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: lex_model_building_service
using AWS.Compat
using AWS.UUIDs

"""
    create_bot_version(name)
    create_bot_version(name, params::Dict{String,<:Any})

Creates a new version of the bot based on the LATEST version. If the LATEST version of this
resource hasn't changed since you created the last version, Amazon Lex doesn't create a new
version. It returns the last created version.  You can update only the LATEST version of
the bot. You can't update the numbered versions that you create with the CreateBotVersion
operation.   When you create the first version of a bot, Amazon Lex sets the version to 1.
Subsequent versions increment by 1. For more information, see versioning-intro.   This
operation requires permission for the lex:CreateBotVersion action.

# Arguments
- `name`: The name of the bot that you want to create a new version of. The name is case
  sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"checksum"`: Identifies a specific revision of the LATEST version of the bot. If you
  specify a checksum and the LATEST version of the bot has a different checksum, a
  PreconditionFailedException exception is returned and Amazon Lex doesn't publish a new
  version. If you don't specify a checksum, Amazon Lex publishes the LATEST version.
"""
function create_bot_version(name; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "POST",
        "/bots/$(name)/versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_bot_version(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "POST",
        "/bots/$(name)/versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_intent_version(name)
    create_intent_version(name, params::Dict{String,<:Any})

Creates a new version of an intent based on the LATEST version of the intent. If the LATEST
version of this intent hasn't changed since you last updated it, Amazon Lex doesn't create
a new version. It returns the last version you created.  You can update only the LATEST
version of the intent. You can't update the numbered versions that you create with the
CreateIntentVersion operation.   When you create a version of an intent, Amazon Lex sets
the version to 1. Subsequent versions increment by 1. For more information, see
versioning-intro.  This operation requires permissions to perform the
lex:CreateIntentVersion action.

# Arguments
- `name`: The name of the intent that you want to create a new version of. The name is case
  sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"checksum"`: Checksum of the LATEST version of the intent that should be used to create
  the new version. If you specify a checksum and the LATEST version of the intent has a
  different checksum, Amazon Lex returns a PreconditionFailedException exception and doesn't
  publish a new version. If you don't specify a checksum, Amazon Lex publishes the LATEST
  version.
"""
function create_intent_version(name; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "POST",
        "/intents/$(name)/versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_intent_version(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "POST",
        "/intents/$(name)/versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_slot_type_version(name)
    create_slot_type_version(name, params::Dict{String,<:Any})

Creates a new version of a slot type based on the LATEST version of the specified slot
type. If the LATEST version of this resource has not changed since the last version that
you created, Amazon Lex doesn't create a new version. It returns the last version that you
created.   You can update only the LATEST version of a slot type. You can't update the
numbered versions that you create with the CreateSlotTypeVersion operation.  When you
create a version of a slot type, Amazon Lex sets the version to 1. Subsequent versions
increment by 1. For more information, see versioning-intro.  This operation requires
permissions for the lex:CreateSlotTypeVersion action.

# Arguments
- `name`: The name of the slot type that you want to create a new version for. The name is
  case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"checksum"`: Checksum for the LATEST version of the slot type that you want to publish.
  If you specify a checksum and the LATEST version of the slot type has a different checksum,
  Amazon Lex returns a PreconditionFailedException exception and doesn't publish the new
  version. If you don't specify a checksum, Amazon Lex publishes the LATEST version.
"""
function create_slot_type_version(name; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "POST",
        "/slottypes/$(name)/versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_slot_type_version(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "POST",
        "/slottypes/$(name)/versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_bot(name)
    delete_bot(name, params::Dict{String,<:Any})

Deletes all versions of the bot, including the LATEST version. To delete a specific version
of the bot, use the DeleteBotVersion operation. The DeleteBot operation doesn't immediately
remove the bot schema. Instead, it is marked for deletion and removed later. Amazon Lex
stores utterances indefinitely for improving the ability of your bot to respond to user
inputs. These utterances are not removed when the bot is deleted. To remove the utterances,
use the DeleteUtterances operation. If a bot has an alias, you can't delete it. Instead,
the DeleteBot operation returns a ResourceInUseException exception that includes a
reference to the alias that refers to the bot. To remove the reference to the bot, delete
the alias. If you get the same exception again, delete the referring alias until the
DeleteBot operation is successful. This operation requires permissions for the
lex:DeleteBot action.

# Arguments
- `name`: The name of the bot. The name is case sensitive.

"""
function delete_bot(name; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "DELETE", "/bots/$(name)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function delete_bot(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "DELETE",
        "/bots/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_bot_alias(bot_name, name)
    delete_bot_alias(bot_name, name, params::Dict{String,<:Any})

Deletes an alias for the specified bot.  You can't delete an alias that is used in the
association between a bot and a messaging channel. If an alias is used in a channel
association, the DeleteBot operation returns a ResourceInUseException exception that
includes a reference to the channel association that refers to the bot. You can remove the
reference to the alias by deleting the channel association. If you get the same exception
again, delete the referring association until the DeleteBotAlias operation is successful.

# Arguments
- `bot_name`: The name of the bot that the alias points to.
- `name`: The name of the alias to delete. The name is case sensitive.

"""
function delete_bot_alias(botName, name; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "DELETE",
        "/bots/$(botName)/aliases/$(name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_bot_alias(
    botName,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "DELETE",
        "/bots/$(botName)/aliases/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_bot_channel_association(alias_name, bot_name, name)
    delete_bot_channel_association(alias_name, bot_name, name, params::Dict{String,<:Any})

Deletes the association between an Amazon Lex bot and a messaging platform. This operation
requires permission for the lex:DeleteBotChannelAssociation action.

# Arguments
- `alias_name`: An alias that points to the specific version of the Amazon Lex bot to which
  this association is being made.
- `bot_name`: The name of the Amazon Lex bot.
- `name`: The name of the association. The name is case sensitive.

"""
function delete_bot_channel_association(
    aliasName, botName, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "DELETE",
        "/bots/$(botName)/aliases/$(aliasName)/channels/$(name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_bot_channel_association(
    aliasName,
    botName,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "DELETE",
        "/bots/$(botName)/aliases/$(aliasName)/channels/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_bot_version(name, version)
    delete_bot_version(name, version, params::Dict{String,<:Any})

Deletes a specific version of a bot. To delete all versions of a bot, use the DeleteBot
operation.  This operation requires permissions for the lex:DeleteBotVersion action.

# Arguments
- `name`: The name of the bot.
- `version`: The version of the bot to delete. You cannot delete the LATEST version of the
  bot. To delete the LATEST version, use the DeleteBot operation.

"""
function delete_bot_version(
    name, version; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "DELETE",
        "/bots/$(name)/versions/$(version)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_bot_version(
    name,
    version,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "DELETE",
        "/bots/$(name)/versions/$(version)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_intent(name)
    delete_intent(name, params::Dict{String,<:Any})

Deletes all versions of the intent, including the LATEST version. To delete a specific
version of the intent, use the DeleteIntentVersion operation.  You can delete a version of
an intent only if it is not referenced. To delete an intent that is referred to in one or
more bots (see how-it-works), you must remove those references first.    If you get the
ResourceInUseException exception, it provides an example reference that shows where the
intent is referenced. To remove the reference to the intent, either update the bot or
delete it. If you get the same exception when you attempt to delete the intent again,
repeat until the intent has no references and the call to DeleteIntent is successful.
This operation requires permission for the lex:DeleteIntent action.

# Arguments
- `name`: The name of the intent. The name is case sensitive.

"""
function delete_intent(name; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "DELETE", "/intents/$(name)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function delete_intent(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "DELETE",
        "/intents/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_intent_version(name, version)
    delete_intent_version(name, version, params::Dict{String,<:Any})

Deletes a specific version of an intent. To delete all versions of a intent, use the
DeleteIntent operation.  This operation requires permissions for the
lex:DeleteIntentVersion action.

# Arguments
- `name`: The name of the intent.
- `version`: The version of the intent to delete. You cannot delete the LATEST version of
  the intent. To delete the LATEST version, use the DeleteIntent operation.

"""
function delete_intent_version(
    name, version; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "DELETE",
        "/intents/$(name)/versions/$(version)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_intent_version(
    name,
    version,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "DELETE",
        "/intents/$(name)/versions/$(version)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_slot_type(name)
    delete_slot_type(name, params::Dict{String,<:Any})

Deletes all versions of the slot type, including the LATEST version. To delete a specific
version of the slot type, use the DeleteSlotTypeVersion operation.  You can delete a
version of a slot type only if it is not referenced. To delete a slot type that is referred
to in one or more intents, you must remove those references first.    If you get the
ResourceInUseException exception, the exception provides an example reference that shows
the intent where the slot type is referenced. To remove the reference to the slot type,
either update the intent or delete it. If you get the same exception when you attempt to
delete the slot type again, repeat until the slot type has no references and the
DeleteSlotType call is successful.   This operation requires permission for the
lex:DeleteSlotType action.

# Arguments
- `name`: The name of the slot type. The name is case sensitive.

"""
function delete_slot_type(name; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "DELETE",
        "/slottypes/$(name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_slot_type(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "DELETE",
        "/slottypes/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_slot_type_version(name, version)
    delete_slot_type_version(name, version, params::Dict{String,<:Any})

Deletes a specific version of a slot type. To delete all versions of a slot type, use the
DeleteSlotType operation.  This operation requires permissions for the
lex:DeleteSlotTypeVersion action.

# Arguments
- `name`: The name of the slot type.
- `version`: The version of the slot type to delete. You cannot delete the LATEST version
  of the slot type. To delete the LATEST version, use the DeleteSlotType operation.

"""
function delete_slot_type_version(
    name, version; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "DELETE",
        "/slottypes/$(name)/version/$(version)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_slot_type_version(
    name,
    version,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "DELETE",
        "/slottypes/$(name)/version/$(version)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_utterances(bot_name, user_id)
    delete_utterances(bot_name, user_id, params::Dict{String,<:Any})

Deletes stored utterances. Amazon Lex stores the utterances that users send to your bot.
Utterances are stored for 15 days for use with the GetUtterancesView operation, and then
stored indefinitely for use in improving the ability of your bot to respond to user input.
Use the DeleteUtterances operation to manually delete stored utterances for a specific
user. When you use the DeleteUtterances operation, utterances stored for improving your
bot's ability to respond to user input are deleted immediately. Utterances stored for use
with the GetUtterancesView operation are deleted after 15 days. This operation requires
permissions for the lex:DeleteUtterances action.

# Arguments
- `bot_name`: The name of the bot that stored the utterances.
- `user_id`:  The unique identifier for the user that made the utterances. This is the user
  ID that was sent in the PostContent or PostText operation request that contained the
  utterance.

"""
function delete_utterances(
    botName, userId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "DELETE",
        "/bots/$(botName)/utterances/$(userId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_utterances(
    botName,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "DELETE",
        "/bots/$(botName)/utterances/$(userId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_bot(name, versionoralias)
    get_bot(name, versionoralias, params::Dict{String,<:Any})

Returns metadata information for a specific bot. You must provide the bot name and the bot
version or alias.   This operation requires permissions for the lex:GetBot action.

# Arguments
- `name`: The name of the bot. The name is case sensitive.
- `versionoralias`: The version or alias of the bot.

"""
function get_bot(name, versionoralias; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "GET",
        "/bots/$(name)/versions/$(versionoralias)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_bot(
    name,
    versionoralias,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "GET",
        "/bots/$(name)/versions/$(versionoralias)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_bot_alias(bot_name, name)
    get_bot_alias(bot_name, name, params::Dict{String,<:Any})

Returns information about an Amazon Lex bot alias. For more information about aliases, see
versioning-aliases. This operation requires permissions for the lex:GetBotAlias action.

# Arguments
- `bot_name`: The name of the bot.
- `name`: The name of the bot alias. The name is case sensitive.

"""
function get_bot_alias(botName, name; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "GET",
        "/bots/$(botName)/aliases/$(name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_bot_alias(
    botName,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "GET",
        "/bots/$(botName)/aliases/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_bot_aliases(bot_name)
    get_bot_aliases(bot_name, params::Dict{String,<:Any})

Returns a list of aliases for a specified Amazon Lex bot. This operation requires
permissions for the lex:GetBotAliases action.

# Arguments
- `bot_name`: The name of the bot.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of aliases to return in the response. The default is
  50. .
- `"nameContains"`: Substring to match in bot alias names. An alias will be returned if any
  part of its name matches the substring. For example, \"xyz\" matches both \"xyzabc\" and
  \"abcxyz.\"
- `"nextToken"`: A pagination token for fetching the next page of aliases. If the response
  to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch
  the next page of aliases, specify the pagination token in the next request.
"""
function get_bot_aliases(botName; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "GET",
        "/bots/$(botName)/aliases/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_bot_aliases(
    botName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "GET",
        "/bots/$(botName)/aliases/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_bot_channel_association(alias_name, bot_name, name)
    get_bot_channel_association(alias_name, bot_name, name, params::Dict{String,<:Any})

Returns information about the association between an Amazon Lex bot and a messaging
platform. This operation requires permissions for the lex:GetBotChannelAssociation action.

# Arguments
- `alias_name`: An alias pointing to the specific version of the Amazon Lex bot to which
  this association is being made.
- `bot_name`: The name of the Amazon Lex bot.
- `name`: The name of the association between the bot and the channel. The name is case
  sensitive.

"""
function get_bot_channel_association(
    aliasName, botName, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "GET",
        "/bots/$(botName)/aliases/$(aliasName)/channels/$(name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_bot_channel_association(
    aliasName,
    botName,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "GET",
        "/bots/$(botName)/aliases/$(aliasName)/channels/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_bot_channel_associations(alias_name, bot_name)
    get_bot_channel_associations(alias_name, bot_name, params::Dict{String,<:Any})

 Returns a list of all of the channels associated with the specified bot.  The
GetBotChannelAssociations operation requires permissions for the
lex:GetBotChannelAssociations action.

# Arguments
- `alias_name`: An alias pointing to the specific version of the Amazon Lex bot to which
  this association is being made.
- `bot_name`: The name of the Amazon Lex bot in the association.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of associations to return in the response. The default
  is 50.
- `"nameContains"`: Substring to match in channel association names. An association will be
  returned if any part of its name matches the substring. For example, \"xyz\" matches both
  \"xyzabc\" and \"abcxyz.\" To return all bot channel associations, use a hyphen (\"-\") as
  the nameContains parameter.
- `"nextToken"`: A pagination token for fetching the next page of associations. If the
  response to this call is truncated, Amazon Lex returns a pagination token in the response.
  To fetch the next page of associations, specify the pagination token in the next request.
"""
function get_bot_channel_associations(
    aliasName, botName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "GET",
        "/bots/$(botName)/aliases/$(aliasName)/channels/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_bot_channel_associations(
    aliasName,
    botName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "GET",
        "/bots/$(botName)/aliases/$(aliasName)/channels/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_bot_versions(name)
    get_bot_versions(name, params::Dict{String,<:Any})

Gets information about all of the versions of a bot. The GetBotVersions operation returns a
BotMetadata object for each version of a bot. For example, if a bot has three numbered
versions, the GetBotVersions operation returns four BotMetadata objects in the response,
one for each numbered version and one for the LATEST version.  The GetBotVersions operation
always returns at least one version, the LATEST version. This operation requires
permissions for the lex:GetBotVersions action.

# Arguments
- `name`: The name of the bot for which versions should be returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of bot versions to return in the response. The default
  is 10.
- `"nextToken"`: A pagination token for fetching the next page of bot versions. If the
  response to this call is truncated, Amazon Lex returns a pagination token in the response.
  To fetch the next page of versions, specify the pagination token in the next request.
"""
function get_bot_versions(name; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "GET",
        "/bots/$(name)/versions/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_bot_versions(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "GET",
        "/bots/$(name)/versions/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_bots()
    get_bots(params::Dict{String,<:Any})

Returns bot information as follows:    If you provide the nameContains field, the response
includes information for the LATEST version of all bots whose name contains the specified
string.   If you don't specify the nameContains field, the operation returns information
about the LATEST version of all of your bots.   This operation requires permission for the
lex:GetBots action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of bots to return in the response that the request
  will return. The default is 10.
- `"nameContains"`: Substring to match in bot names. A bot will be returned if any part of
  its name matches the substring. For example, \"xyz\" matches both \"xyzabc\" and \"abcxyz.\"
- `"nextToken"`: A pagination token that fetches the next page of bots. If the response to
  this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the
  next page of bots, specify the pagination token in the next request.
"""
function get_bots(; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "GET", "/bots/"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_bots(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "GET", "/bots/", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_builtin_intent(signature)
    get_builtin_intent(signature, params::Dict{String,<:Any})

Returns information about a built-in intent. This operation requires permission for the
lex:GetBuiltinIntent action.

# Arguments
- `signature`: The unique identifier for a built-in intent. To find the signature for an
  intent, see Standard Built-in Intents in the Alexa Skills Kit.

"""
function get_builtin_intent(signature; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "GET",
        "/builtins/intents/$(signature)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_builtin_intent(
    signature,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "GET",
        "/builtins/intents/$(signature)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_builtin_intents()
    get_builtin_intents(params::Dict{String,<:Any})

Gets a list of built-in intents that meet the specified criteria. This operation requires
permission for the lex:GetBuiltinIntents action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"locale"`: A list of locales that the intent supports.
- `"maxResults"`: The maximum number of intents to return in the response. The default is
  10.
- `"nextToken"`: A pagination token that fetches the next page of intents. If this API call
  is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page
  of intents, use the pagination token in the next request.
- `"signatureContains"`: Substring to match in built-in intent signatures. An intent will
  be returned if any part of its signature matches the substring. For example, \"xyz\"
  matches both \"xyzabc\" and \"abcxyz.\" To find the signature for an intent, see Standard
  Built-in Intents in the Alexa Skills Kit.
"""
function get_builtin_intents(; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "GET", "/builtins/intents/"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_builtin_intents(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "GET",
        "/builtins/intents/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_builtin_slot_types()
    get_builtin_slot_types(params::Dict{String,<:Any})

Gets a list of built-in slot types that meet the specified criteria. For a list of built-in
slot types, see Slot Type Reference in the Alexa Skills Kit. This operation requires
permission for the lex:GetBuiltInSlotTypes action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"locale"`: A list of locales that the slot type supports.
- `"maxResults"`: The maximum number of slot types to return in the response. The default
  is 10.
- `"nextToken"`: A pagination token that fetches the next page of slot types. If the
  response to this API call is truncated, Amazon Lex returns a pagination token in the
  response. To fetch the next page of slot types, specify the pagination token in the next
  request.
- `"signatureContains"`: Substring to match in built-in slot type signatures. A slot type
  will be returned if any part of its signature matches the substring. For example, \"xyz\"
  matches both \"xyzabc\" and \"abcxyz.\"
"""
function get_builtin_slot_types(; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "GET",
        "/builtins/slottypes/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_builtin_slot_types(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "GET",
        "/builtins/slottypes/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_export(export_type, name, resource_type, version)
    get_export(export_type, name, resource_type, version, params::Dict{String,<:Any})

Exports the contents of a Amazon Lex resource in a specified format.

# Arguments
- `export_type`: The format of the exported data.
- `name`: The name of the bot to export.
- `resource_type`: The type of resource to export.
- `version`: The version of the bot to export.

"""
function get_export(
    exportType,
    name,
    resourceType,
    version;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "GET",
        "/exports/",
        Dict{String,Any}(
            "exportType" => exportType,
            "name" => name,
            "resourceType" => resourceType,
            "version" => version,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_export(
    exportType,
    name,
    resourceType,
    version,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "GET",
        "/exports/",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "exportType" => exportType,
                    "name" => name,
                    "resourceType" => resourceType,
                    "version" => version,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_import(import_id)
    get_import(import_id, params::Dict{String,<:Any})

Gets information about an import job started with the StartImport operation.

# Arguments
- `import_id`: The identifier of the import job information to return.

"""
function get_import(importId; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "GET",
        "/imports/$(importId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_import(
    importId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "GET",
        "/imports/$(importId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_intent(name, version)
    get_intent(name, version, params::Dict{String,<:Any})

 Returns information about an intent. In addition to the intent name, you must specify the
intent version.   This operation requires permissions to perform the lex:GetIntent action.

# Arguments
- `name`: The name of the intent. The name is case sensitive.
- `version`: The version of the intent.

"""
function get_intent(name, version; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "GET",
        "/intents/$(name)/versions/$(version)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_intent(
    name,
    version,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "GET",
        "/intents/$(name)/versions/$(version)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_intent_versions(name)
    get_intent_versions(name, params::Dict{String,<:Any})

Gets information about all of the versions of an intent. The GetIntentVersions operation
returns an IntentMetadata object for each version of an intent. For example, if an intent
has three numbered versions, the GetIntentVersions operation returns four IntentMetadata
objects in the response, one for each numbered version and one for the LATEST version.  The
GetIntentVersions operation always returns at least one version, the LATEST version. This
operation requires permissions for the lex:GetIntentVersions action.

# Arguments
- `name`: The name of the intent for which versions should be returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of intent versions to return in the response. The
  default is 10.
- `"nextToken"`: A pagination token for fetching the next page of intent versions. If the
  response to this call is truncated, Amazon Lex returns a pagination token in the response.
  To fetch the next page of versions, specify the pagination token in the next request.
"""
function get_intent_versions(name; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "GET",
        "/intents/$(name)/versions/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_intent_versions(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "GET",
        "/intents/$(name)/versions/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_intents()
    get_intents(params::Dict{String,<:Any})

Returns intent information as follows:    If you specify the nameContains field, returns
the LATEST version of all intents that contain the specified string.    If you don't
specify the nameContains field, returns information about the LATEST version of all
intents.     The operation requires permission for the lex:GetIntents action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of intents to return in the response. The default is
  10.
- `"nameContains"`: Substring to match in intent names. An intent will be returned if any
  part of its name matches the substring. For example, \"xyz\" matches both \"xyzabc\" and
  \"abcxyz.\"
- `"nextToken"`: A pagination token that fetches the next page of intents. If the response
  to this API call is truncated, Amazon Lex returns a pagination token in the response. To
  fetch the next page of intents, specify the pagination token in the next request.
"""
function get_intents(; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "GET", "/intents/"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_intents(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "GET", "/intents/", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_migration(migration_id)
    get_migration(migration_id, params::Dict{String,<:Any})

Provides details about an ongoing or complete migration from an Amazon Lex V1 bot to an
Amazon Lex V2 bot. Use this operation to view the migration alerts and warnings related to
the migration.

# Arguments
- `migration_id`: The unique identifier of the migration to view. The migrationID is
  returned by the operation.

"""
function get_migration(migrationId; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "GET",
        "/migrations/$(migrationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_migration(
    migrationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "GET",
        "/migrations/$(migrationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_migrations()
    get_migrations(params::Dict{String,<:Any})

Gets a list of migrations between Amazon Lex V1 and Amazon Lex V2.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of migrations to return in the response. The default
  is 10.
- `"migrationStatusEquals"`: Filters the list to contain only migrations in the specified
  state.
- `"nextToken"`: A pagination token that fetches the next page of migrations. If the
  response to this operation is truncated, Amazon Lex returns a pagination token in the
  response. To fetch the next page of migrations, specify the pagination token in the request.
- `"sortByAttribute"`: The field to sort the list of migrations by. You can sort by the
  Amazon Lex V1 bot name or the date and time that the migration was started.
- `"sortByOrder"`: The order so sort the list.
- `"v1BotNameContains"`: Filters the list to contain only bots whose name contains the
  specified string. The string is matched anywhere in bot name.
"""
function get_migrations(; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "GET", "/migrations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_migrations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "GET", "/migrations", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_slot_type(name, version)
    get_slot_type(name, version, params::Dict{String,<:Any})

Returns information about a specific version of a slot type. In addition to specifying the
slot type name, you must specify the slot type version. This operation requires permissions
for the lex:GetSlotType action.

# Arguments
- `name`: The name of the slot type. The name is case sensitive.
- `version`: The version of the slot type.

"""
function get_slot_type(name, version; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "GET",
        "/slottypes/$(name)/versions/$(version)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_slot_type(
    name,
    version,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "GET",
        "/slottypes/$(name)/versions/$(version)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_slot_type_versions(name)
    get_slot_type_versions(name, params::Dict{String,<:Any})

Gets information about all versions of a slot type. The GetSlotTypeVersions operation
returns a SlotTypeMetadata object for each version of a slot type. For example, if a slot
type has three numbered versions, the GetSlotTypeVersions operation returns four
SlotTypeMetadata objects in the response, one for each numbered version and one for the
LATEST version.  The GetSlotTypeVersions operation always returns at least one version, the
LATEST version. This operation requires permissions for the lex:GetSlotTypeVersions action.

# Arguments
- `name`: The name of the slot type for which versions should be returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of slot type versions to return in the response. The
  default is 10.
- `"nextToken"`: A pagination token for fetching the next page of slot type versions. If
  the response to this call is truncated, Amazon Lex returns a pagination token in the
  response. To fetch the next page of versions, specify the pagination token in the next
  request.
"""
function get_slot_type_versions(name; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "GET",
        "/slottypes/$(name)/versions/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_slot_type_versions(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "GET",
        "/slottypes/$(name)/versions/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_slot_types()
    get_slot_types(params::Dict{String,<:Any})

Returns slot type information as follows:    If you specify the nameContains field, returns
the LATEST version of all slot types that contain the specified string.    If you don't
specify the nameContains field, returns information about the LATEST version of all slot
types.     The operation requires permission for the lex:GetSlotTypes action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of slot types to return in the response. The default
  is 10.
- `"nameContains"`: Substring to match in slot type names. A slot type will be returned if
  any part of its name matches the substring. For example, \"xyz\" matches both \"xyzabc\"
  and \"abcxyz.\"
- `"nextToken"`: A pagination token that fetches the next page of slot types. If the
  response to this API call is truncated, Amazon Lex returns a pagination token in the
  response. To fetch next page of slot types, specify the pagination token in the next
  request.
"""
function get_slot_types(; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "GET", "/slottypes/"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_slot_types(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "GET", "/slottypes/", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_utterances_view(bot_versions, botname, status_type)
    get_utterances_view(bot_versions, botname, status_type, params::Dict{String,<:Any})

Use the GetUtterancesView operation to get information about the utterances that your users
have made to your bot. You can use this list to tune the utterances that your bot responds
to. For example, say that you have created a bot to order flowers. After your users have
used your bot for a while, use the GetUtterancesView operation to see the requests that
they have made and whether they have been successful. You might find that the utterance \"I
want flowers\" is not being recognized. You could add this utterance to the OrderFlowers
intent so that your bot recognizes that utterance. After you publish a new version of a
bot, you can get information about the old version and the new so that you can compare the
performance across the two versions.  Utterance statistics are generated once a day. Data
is available for the last 15 days. You can request information for up to 5 versions of your
bot in each request. Amazon Lex returns the most frequent utterances received by the bot in
the last 15 days. The response contains information about a maximum of 100 utterances for
each version. If you set childDirected field to true when you created your bot, if you are
using slot obfuscation with one or more slots, or if you opted out of participating in
improving Amazon Lex, utterances are not available. This operation requires permissions for
the lex:GetUtterancesView action.

# Arguments
- `bot_versions`: An array of bot versions for which utterance information should be
  returned. The limit is 5 versions per request.
- `botname`: The name of the bot for which utterance information should be returned.
- `status_type`: To return utterances that were recognized and handled, use Detected. To
  return utterances that were not recognized, use Missed.

"""
function get_utterances_view(
    bot_versions, botname, status_type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "GET",
        "/bots/$(botname)/utterances?view=aggregation",
        Dict{String,Any}("bot_versions" => bot_versions, "status_type" => status_type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_utterances_view(
    bot_versions,
    botname,
    status_type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "GET",
        "/bots/$(botname)/utterances?view=aggregation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "bot_versions" => bot_versions, "status_type" => status_type
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Gets a list of tags associated with the specified resource. Only bots, bot aliases, and bot
channels can have tags associated with them.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to get a list of tags for.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_bot(child_directed, locale, name)
    put_bot(child_directed, locale, name, params::Dict{String,<:Any})

Creates an Amazon Lex conversational bot or replaces an existing bot. When you create or
update a bot you are only required to specify a name, a locale, and whether the bot is
directed toward children under age 13. You can use this to add intents later, or to remove
intents from an existing bot. When you create a bot with the minimum information, the bot
is created or updated but Amazon Lex returns the  response FAILED. You can build the bot
after you add one or more intents. For more information about Amazon Lex bots, see
how-it-works.  If you specify the name of an existing bot, the fields in the request
replace the existing values in the LATEST version of the bot. Amazon Lex removes any fields
that you don't provide values for in the request, except for the idleTTLInSeconds and
privacySettings fields, which are set to their default values. If you don't specify values
for required fields, Amazon Lex throws an exception. This operation requires permissions
for the lex:PutBot action. For more information, see security-iam.

# Arguments
- `child_directed`: For each Amazon Lex bot created with the Amazon Lex Model Building
  Service, you must specify whether your use of Amazon Lex is related to a website, program,
  or other application that is directed or targeted, in whole or in part, to children under
  age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying
  true or false in the childDirected field. By specifying true in the childDirected field,
  you confirm that your use of Amazon Lex is related to a website, program, or other
  application that is directed or targeted, in whole or in part, to children under age 13 and
  subject to COPPA. By specifying false in the childDirected field, you confirm that your use
  of Amazon Lex is not related to a website, program, or other application that is directed
  or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may
  not specify a default value for the childDirected field that does not accurately reflect
  whether your use of Amazon Lex is related to a website, program, or other application that
  is directed or targeted, in whole or in part, to children under age 13 and subject to
  COPPA. If your use of Amazon Lex relates to a website, program, or other application that
  is directed in whole or in part, to children under age 13, you must obtain any required
  verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in
  connection with websites, programs, or other applications that are directed or targeted, in
  whole or in part, to children under age 13, see the Amazon Lex FAQ.
- `locale`:  Specifies the target locale for the bot. Any intent used in the bot must be
  compatible with the locale of the bot.  The default is en-US.
- `name`: The name of the bot. The name is not case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"abortStatement"`: When Amazon Lex can't understand the user's input in context, it
  tries to elicit the information a few times. After that, Amazon Lex sends the message
  defined in abortStatement to the user, and then cancels the conversation. To set the number
  of retries, use the valueElicitationPrompt field for the slot type.  For example, in a
  pizza ordering bot, Amazon Lex might ask a user \"What type of crust would you like?\" If
  the user's response is not one of the expected responses (for example, \"thin crust, \"deep
  dish,\" etc.), Amazon Lex tries to elicit a correct response a few more times.  For
  example, in a pizza ordering application, OrderPizza might be one of the intents. This
  intent might require the CrustType slot. You specify the valueElicitationPrompt field when
  you create the CrustType slot. If you have defined a fallback intent the cancel statement
  will not be sent to the user, the fallback intent is used instead. For more information,
  see  AMAZON.FallbackIntent.
- `"checksum"`: Identifies a specific revision of the LATEST version. When you create a new
  bot, leave the checksum field blank. If you specify a checksum you get a
  BadRequestException exception. When you want to update a bot, set the checksum field to the
  checksum of the most recent revision of the LATEST version. If you don't specify the
  checksum field, or if the checksum does not match the LATEST version, you get a
  PreconditionFailedException exception.
- `"clarificationPrompt"`: When Amazon Lex doesn't understand the user's intent, it uses
  this message to get clarification. To specify how many times Amazon Lex should repeat the
  clarification prompt, use the maxAttempts field. If Amazon Lex still doesn't understand, it
  sends the message in the abortStatement field.  When you create a clarification prompt,
  make sure that it suggests the correct response from the user. for example, for a bot that
  orders pizza and drinks, you might create this clarification prompt: \"What would you like
  to do? You can say 'Order a pizza' or 'Order a drink.'\" If you have defined a fallback
  intent, it will be invoked if the clarification prompt is repeated the number of times
  defined in the maxAttempts field. For more information, see  AMAZON.FallbackIntent. If you
  don't define a clarification prompt, at runtime Amazon Lex will return a 400 Bad Request
  exception in three cases:    Follow-up prompt - When the user responds to a follow-up
  prompt but does not provide an intent. For example, in response to a follow-up prompt that
  says \"Would you like anything else today?\" the user says \"Yes.\" Amazon Lex will return
  a 400 Bad Request exception because it does not have a clarification prompt to send to the
  user to get an intent.   Lambda function - When using a Lambda function, you return an
  ElicitIntent dialog type. Since Amazon Lex does not have a clarification prompt to get an
  intent from the user, it returns a 400 Bad Request exception.   PutSession operation - When
  using the PutSession operation, you send an ElicitIntent dialog type. Since Amazon Lex does
  not have a clarification prompt to get an intent from the user, it returns a 400 Bad
  Request exception.
- `"createVersion"`: When set to true a new numbered version of the bot is created. This is
  the same as calling the CreateBotVersion operation. If you don't specify createVersion, the
  default is false.
- `"description"`: A description of the bot.
- `"detectSentiment"`: When set to true user utterances are sent to Amazon Comprehend for
  sentiment analysis. If you don't specify detectSentiment, the default is false.
- `"enableModelImprovements"`: Set to true to enable access to natural language
  understanding improvements.  When you set the enableModelImprovements parameter to true you
  can use the nluIntentConfidenceThreshold parameter to configure confidence scores. For more
  information, see Confidence Scores. You can only set the enableModelImprovements parameter
  in certain Regions. If you set the parameter to true, your bot has access to accuracy
  improvements. The Regions where you can set the enableModelImprovements parameter to true
  are:   US East (N. Virginia) (us-east-1)   US West (Oregon) (us-west-2)   Asia Pacific
  (Sydney) (ap-southeast-2)   EU (Ireland) (eu-west-1)   In other Regions, the
  enableModelImprovements parameter is set to true by default. In these Regions setting the
  parameter to false throws a ValidationException exception.
- `"idleSessionTTLInSeconds"`: The maximum time in seconds that Amazon Lex retains the data
  gathered in a conversation. A user interaction session remains active for the amount of
  time specified. If no conversation occurs during this time, the session expires and Amazon
  Lex deletes any data provided before the timeout. For example, suppose that a user chooses
  the OrderPizza intent, but gets sidetracked halfway through placing an order. If the user
  doesn't complete the order within the specified time, Amazon Lex discards the slot
  information that it gathered, and the user must start over. If you don't include the
  idleSessionTTLInSeconds element in a PutBot operation request, Amazon Lex uses the default
  value. This is also true if the request replaces an existing bot. The default is 300
  seconds (5 minutes).
- `"intents"`: An array of Intent objects. Each intent represents a command that a user can
  express. For example, a pizza ordering bot might support an OrderPizza intent. For more
  information, see how-it-works.
- `"nluIntentConfidenceThreshold"`: Determines the threshold where Amazon Lex will insert
  the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative
  intents in a PostContent or PostText response. AMAZON.FallbackIntent and
  AMAZON.KendraSearchIntent are only inserted if they are configured for the bot. You must
  set the enableModelImprovements parameter to true to use confidence scores in the following
  regions.   US East (N. Virginia) (us-east-1)   US West (Oregon) (us-west-2)   Asia Pacific
  (Sydney) (ap-southeast-2)   EU (Ireland) (eu-west-1)   In other Regions, the
  enableModelImprovements parameter is set to true by default. For example, suppose a bot is
  configured with the confidence threshold of 0.80 and the AMAZON.FallbackIntent. Amazon Lex
  returns three alternative intents with the following confidence scores: IntentA (0.70),
  IntentB (0.60), IntentC (0.50). The response from the PostText operation would be:
  AMAZON.FallbackIntent   IntentA   IntentB   IntentC
- `"processBehavior"`: If you set the processBehavior element to BUILD, Amazon Lex builds
  the bot so that it can be run. If you set the element to SAVE Amazon Lex saves the bot, but
  doesn't build it.  If you don't specify this value, the default value is BUILD.
- `"tags"`: A list of tags to add to the bot. You can only add tags when you create a bot,
  you can't use the PutBot operation to update the tags on a bot. To update tags, use the
  TagResource operation.
- `"voiceId"`: The Amazon Polly voice ID that you want Amazon Lex to use for voice
  interactions with the user. The locale configured for the voice must match the locale of
  the bot. For more information, see Voices in Amazon Polly in the Amazon Polly Developer
  Guide.
"""
function put_bot(
    childDirected, locale, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "PUT",
        "/bots/$(name)/versions/$LATEST",
        Dict{String,Any}("childDirected" => childDirected, "locale" => locale);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_bot(
    childDirected,
    locale,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "PUT",
        "/bots/$(name)/versions/$LATEST",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("childDirected" => childDirected, "locale" => locale),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_bot_alias(bot_name, bot_version, name)
    put_bot_alias(bot_name, bot_version, name, params::Dict{String,<:Any})

Creates an alias for the specified version of the bot or replaces an alias for the
specified bot. To change the version of the bot that the alias points to, replace the
alias. For more information about aliases, see versioning-aliases. This operation requires
permissions for the lex:PutBotAlias action.

# Arguments
- `bot_name`: The name of the bot.
- `bot_version`: The version of the bot.
- `name`: The name of the alias. The name is not case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"checksum"`: Identifies a specific revision of the LATEST version. When you create a new
  bot alias, leave the checksum field blank. If you specify a checksum you get a
  BadRequestException exception. When you want to update a bot alias, set the checksum field
  to the checksum of the most recent revision of the LATEST version. If you don't specify the
   checksum field, or if the checksum does not match the LATEST version, you get a
  PreconditionFailedException exception.
- `"conversationLogs"`: Settings for conversation logs for the alias.
- `"description"`: A description of the alias.
- `"tags"`: A list of tags to add to the bot alias. You can only add tags when you create
  an alias, you can't use the PutBotAlias operation to update the tags on a bot alias. To
  update tags, use the TagResource operation.
"""
function put_bot_alias(
    botName, botVersion, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "PUT",
        "/bots/$(botName)/aliases/$(name)",
        Dict{String,Any}("botVersion" => botVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_bot_alias(
    botName,
    botVersion,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "PUT",
        "/bots/$(botName)/aliases/$(name)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("botVersion" => botVersion), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_intent(name)
    put_intent(name, params::Dict{String,<:Any})

Creates an intent or replaces an existing intent. To define the interaction between the
user and your bot, you use one or more intents. For a pizza ordering bot, for example, you
would create an OrderPizza intent.  To create an intent or replace an existing intent, you
must provide the following:   Intent name. For example, OrderPizza.   Sample utterances.
For example, \"Can I order a pizza, please.\" and \"I want to order a pizza.\"
Information to be gathered. You specify slot types for the information that your bot will
request from the user. You can specify standard slot types, such as a date or a time, or
custom slot types such as the size and crust of a pizza.   How the intent will be
fulfilled. You can provide a Lambda function or configure the intent to return the intent
information to the client application. If you use a Lambda function, when all of the intent
information is available, Amazon Lex invokes your Lambda function. If you configure your
intent to return the intent information to the client application.    You can specify other
optional information in the request, such as:   A confirmation prompt to ask the user to
confirm an intent. For example, \"Shall I order your pizza?\"   A conclusion statement to
send to the user after the intent has been fulfilled. For example, \"I placed your pizza
order.\"   A follow-up prompt that asks the user for additional activity. For example,
asking \"Do you want to order a drink with your pizza?\"   If you specify an existing
intent name to update the intent, Amazon Lex replaces the values in the LATEST version of
the intent with the values in the request. Amazon Lex removes fields that you don't provide
in the request. If you don't specify the required fields, Amazon Lex throws an exception.
When you update the LATEST version of an intent, the status field of any bot that uses the
LATEST version of the intent is set to NOT_BUILT. For more information, see how-it-works.
This operation requires permissions for the lex:PutIntent action.

# Arguments
- `name`: The name of the intent. The name is not case sensitive.  The name can't match a
  built-in intent name, or a built-in intent name with \"AMAZON.\" removed. For example,
  because there is a built-in intent called AMAZON.HelpIntent, you can't create a custom
  intent called HelpIntent. For a list of built-in intents, see Standard Built-in Intents in
  the Alexa Skills Kit.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"checksum"`: Identifies a specific revision of the LATEST version. When you create a new
  intent, leave the checksum field blank. If you specify a checksum you get a
  BadRequestException exception. When you want to update a intent, set the checksum field to
  the checksum of the most recent revision of the LATEST version. If you don't specify the
  checksum field, or if the checksum does not match the LATEST version, you get a
  PreconditionFailedException exception.
- `"conclusionStatement"`:  The statement that you want Amazon Lex to convey to the user
  after the intent is successfully fulfilled by the Lambda function.  This element is
  relevant only if you provide a Lambda function in the fulfillmentActivity. If you return
  the intent to the client application, you can't specify this element.  The followUpPrompt
  and conclusionStatement are mutually exclusive. You can specify only one.
- `"confirmationPrompt"`: Prompts the user to confirm the intent. This question should have
  a yes or no answer. Amazon Lex uses this prompt to ensure that the user acknowledges that
  the intent is ready for fulfillment. For example, with the OrderPizza intent, you might
  want to confirm that the order is correct before placing it. For other intents, such as
  intents that simply respond to user questions, you might not need to ask the user for
  confirmation before providing the information.   You you must provide both the
  rejectionStatement and the confirmationPrompt, or neither.
- `"createVersion"`: When set to true a new numbered version of the intent is created. This
  is the same as calling the CreateIntentVersion operation. If you do not specify
  createVersion, the default is false.
- `"description"`: A description of the intent.
- `"dialogCodeHook"`:  Specifies a Lambda function to invoke for each user input. You can
  invoke this Lambda function to personalize user interaction.  For example, suppose your bot
  determines that the user is John. Your Lambda function might retrieve John's information
  from a backend database and prepopulate some of the values. For example, if you find that
  John is gluten intolerant, you might set the corresponding intent slot, GlutenIntolerant,
  to true. You might find John's phone number and set the corresponding session attribute.
- `"followUpPrompt"`: Amazon Lex uses this prompt to solicit additional activity after
  fulfilling an intent. For example, after the OrderPizza intent is fulfilled, you might
  prompt the user to order a drink. The action that Amazon Lex takes depends on the user's
  response, as follows:   If the user says \"Yes\" it responds with the clarification prompt
  that is configured for the bot.   if the user says \"Yes\" and continues with an utterance
  that triggers an intent it starts a conversation for the intent.   If the user says \"No\"
  it responds with the rejection statement configured for the the follow-up prompt.   If it
  doesn't recognize the utterance it repeats the follow-up prompt again.   The followUpPrompt
  field and the conclusionStatement field are mutually exclusive. You can specify only one.
- `"fulfillmentActivity"`: Required. Describes how the intent is fulfilled. For example,
  after a user provides all of the information for a pizza order, fulfillmentActivity defines
  how the bot places an order with a local pizza store.   You might configure Amazon Lex to
  return all of the intent information to the client application, or direct it to invoke a
  Lambda function that can process the intent (for example, place an order with a pizzeria).
- `"inputContexts"`: An array of InputContext objects that lists the contexts that must be
  active for Amazon Lex to choose the intent in a conversation with the user.
- `"kendraConfiguration"`: Configuration information required to use the
  AMAZON.KendraSearchIntent intent to connect to an Amazon Kendra index. For more
  information, see  AMAZON.KendraSearchIntent.
- `"outputContexts"`: An array of OutputContext objects that lists the contexts that the
  intent activates when the intent is fulfilled.
- `"parentIntentSignature"`: A unique identifier for the built-in intent to base this
  intent on. To find the signature for an intent, see Standard Built-in Intents in the Alexa
  Skills Kit.
- `"rejectionStatement"`: When the user answers \"no\" to the question defined in
  confirmationPrompt, Amazon Lex responds with this statement to acknowledge that the intent
  was canceled.   You must provide both the rejectionStatement and the confirmationPrompt, or
  neither.
- `"sampleUtterances"`: An array of utterances (strings) that a user might say to signal
  the intent. For example, \"I want {PizzaSize} pizza\", \"Order {Quantity} {PizzaSize}
  pizzas\".  In each utterance, a slot name is enclosed in curly braces.
- `"slots"`: An array of intent slots. At runtime, Amazon Lex elicits required slot values
  from the user using prompts defined in the slots. For more information, see how-it-works.
"""
function put_intent(name; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "PUT",
        "/intents/$(name)/versions/$LATEST";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_intent(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "PUT",
        "/intents/$(name)/versions/$LATEST",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_slot_type(name)
    put_slot_type(name, params::Dict{String,<:Any})

Creates a custom slot type or replaces an existing custom slot type. To create a custom
slot type, specify a name for the slot type and a set of enumeration values, which are the
values that a slot of this type can assume. For more information, see how-it-works. If you
specify the name of an existing slot type, the fields in the request replace the existing
values in the LATEST version of the slot type. Amazon Lex removes the fields that you don't
provide in the request. If you don't specify required fields, Amazon Lex throws an
exception. When you update the LATEST version of a slot type, if a bot uses the LATEST
version of an intent that contains the slot type, the bot's status field is set to
NOT_BUILT. This operation requires permissions for the lex:PutSlotType action.

# Arguments
- `name`: The name of the slot type. The name is not case sensitive.  The name can't match
  a built-in slot type name, or a built-in slot type name with \"AMAZON.\" removed. For
  example, because there is a built-in slot type called AMAZON.DATE, you can't create a
  custom slot type called DATE. For a list of built-in slot types, see Slot Type Reference in
  the Alexa Skills Kit.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"checksum"`: Identifies a specific revision of the LATEST version. When you create a new
  slot type, leave the checksum field blank. If you specify a checksum you get a
  BadRequestException exception. When you want to update a slot type, set the checksum field
  to the checksum of the most recent revision of the LATEST version. If you don't specify the
   checksum field, or if the checksum does not match the LATEST version, you get a
  PreconditionFailedException exception.
- `"createVersion"`: When set to true a new numbered version of the slot type is created.
  This is the same as calling the CreateSlotTypeVersion operation. If you do not specify
  createVersion, the default is false.
- `"description"`: A description of the slot type.
- `"enumerationValues"`: A list of EnumerationValue objects that defines the values that
  the slot type can take. Each value can have a list of synonyms, which are additional values
  that help train the machine learning model about the values that it resolves for a slot.  A
  regular expression slot type doesn't require enumeration values. All other slot types
  require a list of enumeration values. When Amazon Lex resolves a slot value, it generates a
  resolution list that contains up to five possible values for the slot. If you are using a
  Lambda function, this resolution list is passed to the function. If you are not using a
  Lambda function you can choose to return the value that the user entered or the first value
  in the resolution list as the slot value. The valueSelectionStrategy field indicates the
  option to use.
- `"parentSlotTypeSignature"`: The built-in slot type used as the parent of the slot type.
  When you define a parent slot type, the new slot type has all of the same configuration as
  the parent. Only AMAZON.AlphaNumeric is supported.
- `"slotTypeConfigurations"`: Configuration information that extends the parent built-in
  slot type. The configuration is added to the settings for the parent slot type.
- `"valueSelectionStrategy"`: Determines the slot resolution strategy that Amazon Lex uses
  to return slot type values. The field can be set to one of the following values:
  ORIGINAL_VALUE - Returns the value entered by the user, if the user value is similar to the
  slot value.    TOP_RESOLUTION - If there is a resolution list for the slot, return the
  first value in the resolution list as the slot type value. If there is no resolution list,
  null is returned.   If you don't specify the valueSelectionStrategy, the default is
  ORIGINAL_VALUE.
"""
function put_slot_type(name; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "PUT",
        "/slottypes/$(name)/versions/$LATEST";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_slot_type(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "PUT",
        "/slottypes/$(name)/versions/$LATEST",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_import(merge_strategy, payload, resource_type)
    start_import(merge_strategy, payload, resource_type, params::Dict{String,<:Any})

Starts a job to import a resource to Amazon Lex.

# Arguments
- `merge_strategy`: Specifies the action that the StartImport operation should take when
  there is an existing resource with the same name.   FAIL_ON_CONFLICT - The import operation
  is stopped on the first conflict between a resource in the import file and an existing
  resource. The name of the resource causing the conflict is in the failureReason field of
  the response to the GetImport operation. OVERWRITE_LATEST - The import operation proceeds
  even if there is a conflict with an existing resource. The LASTEST version of the existing
  resource is overwritten with the data from the import file.
- `payload`: A zip archive in binary format. The archive should contain one file, a JSON
  file containing the resource to import. The resource should match the type specified in the
  resourceType field.
- `resource_type`: Specifies the type of resource to export. Each resource also exports any
  resources that it depends on.    A bot exports dependent intents.   An intent exports
  dependent slot types.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: A list of tags to add to the imported bot. You can only add tags when you
  import a bot, you can't add tags to an intent or slot type.
"""
function start_import(
    mergeStrategy, payload, resourceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "POST",
        "/imports/",
        Dict{String,Any}(
            "mergeStrategy" => mergeStrategy,
            "payload" => payload,
            "resourceType" => resourceType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_import(
    mergeStrategy,
    payload,
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "POST",
        "/imports/",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "mergeStrategy" => mergeStrategy,
                    "payload" => payload,
                    "resourceType" => resourceType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_migration(migration_strategy, v1_bot_name, v1_bot_version, v2_bot_name, v2_bot_role)
    start_migration(migration_strategy, v1_bot_name, v1_bot_version, v2_bot_name, v2_bot_role, params::Dict{String,<:Any})

Starts migrating a bot from Amazon Lex V1 to Amazon Lex V2. Migrate your bot when you want
to take advantage of the new features of Amazon Lex V2. For more information, see Migrating
a bot in the Amazon Lex developer guide.

# Arguments
- `migration_strategy`: The strategy used to conduct the migration.    CREATE_NEW - Creates
  a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new bot.
  UPDATE_EXISTING - Overwrites the existing Amazon Lex V2 bot metadata and the locale being
  migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale
  doesn't exist, a new locale is created in the Amazon Lex V2 bot.
- `v1_bot_name`: The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.
- `v1_bot_version`: The version of the bot to migrate to Amazon Lex V2. You can migrate the
  LATEST version as well as any numbered version.
- `v2_bot_name`: The name of the Amazon Lex V2 bot that you are migrating the Amazon Lex V1
  bot to.    If the Amazon Lex V2 bot doesn't exist, you must use the CREATE_NEW migration
  strategy.   If the Amazon Lex V2 bot exists, you must use the UPDATE_EXISTING migration
  strategy to change the contents of the Amazon Lex V2 bot.
- `v2_bot_role`: The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.

"""
function start_migration(
    migrationStrategy,
    v1BotName,
    v1BotVersion,
    v2BotName,
    v2BotRole;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "POST",
        "/migrations",
        Dict{String,Any}(
            "migrationStrategy" => migrationStrategy,
            "v1BotName" => v1BotName,
            "v1BotVersion" => v1BotVersion,
            "v2BotName" => v2BotName,
            "v2BotRole" => v2BotRole,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_migration(
    migrationStrategy,
    v1BotName,
    v1BotVersion,
    v2BotName,
    v2BotRole,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "POST",
        "/migrations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "migrationStrategy" => migrationStrategy,
                    "v1BotName" => v1BotName,
                    "v1BotVersion" => v1BotVersion,
                    "v2BotName" => v2BotName,
                    "v2BotRole" => v2BotRole,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds the specified tags to the specified resource. If a tag key already exists, the
existing value is replaced with the new value.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to
  tag.
- `tags`: A list of tag keys to add to the resource. If a tag key already exists, the
  existing value is replaced with the new value.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return lex_model_building_service(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes tags from a bot, bot alias or bot channel.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to remove the tags from.
- `tag_keys`: A list of tag keys to remove from the resource. If a tag key does not exist
  on the resource, it is ignored.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lex_model_building_service(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lex_model_building_service(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
