# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: route53resolver
using AWS.Compat
using AWS.UUIDs

"""
    associate_firewall_rule_group(creator_request_id, firewall_rule_group_id, name, priority, vpc_id)
    associate_firewall_rule_group(creator_request_id, firewall_rule_group_id, name, priority, vpc_id, params::Dict{String,<:Any})

Associates a FirewallRuleGroup with a VPC, to provide DNS filtering for the VPC.

# Arguments
- `creator_request_id`: A unique string that identifies the request and that allows failed
  requests to be retried without the risk of running the operation twice. CreatorRequestId
  can be any unique string, for example, a date/time stamp.
- `firewall_rule_group_id`: The unique identifier of the firewall rule group.
- `name`: A name that lets you identify the association, to manage and use it.
- `priority`: The setting that determines the processing order of the rule group among the
  rule groups that you associate with the specified VPC. DNS Firewall filters VPC traffic
  starting from the rule group with the lowest numeric priority setting.  You must specify a
  unique priority for each rule group that you associate with a single VPC. To make it easier
  to insert rule groups later, leave space between the numbers, for example, use 101, 200,
  and so on. You can change the priority setting for a rule group association after you
  create it. The allowed values for Priority are between 100 and 9900.
- `vpc_id`: The unique identifier of the VPC that you want to associate with the rule
  group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MutationProtection"`: If enabled, this setting disallows modification or removal of the
  association, to help prevent against accidentally altering DNS firewall protections. When
  you create the association, the default setting is DISABLED.
- `"Tags"`: A list of the tag keys and values that you want to associate with the rule
  group association.
"""
function associate_firewall_rule_group(
    CreatorRequestId,
    FirewallRuleGroupId,
    Name,
    Priority,
    VpcId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "AssociateFirewallRuleGroup",
        Dict{String,Any}(
            "CreatorRequestId" => CreatorRequestId,
            "FirewallRuleGroupId" => FirewallRuleGroupId,
            "Name" => Name,
            "Priority" => Priority,
            "VpcId" => VpcId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_firewall_rule_group(
    CreatorRequestId,
    FirewallRuleGroupId,
    Name,
    Priority,
    VpcId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "AssociateFirewallRuleGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CreatorRequestId" => CreatorRequestId,
                    "FirewallRuleGroupId" => FirewallRuleGroupId,
                    "Name" => Name,
                    "Priority" => Priority,
                    "VpcId" => VpcId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_resolver_endpoint_ip_address(ip_address, resolver_endpoint_id)
    associate_resolver_endpoint_ip_address(ip_address, resolver_endpoint_id, params::Dict{String,<:Any})

Adds IP addresses to an inbound or an outbound Resolver endpoint. If you want to add more
than one IP address, submit one AssociateResolverEndpointIpAddress request for each IP
address. To remove an IP address from an endpoint, see
DisassociateResolverEndpointIpAddress.

# Arguments
- `ip_address`: Either the IPv4 address that you want to add to a Resolver endpoint or a
  subnet ID. If you specify a subnet ID, Resolver chooses an IP address for you from the
  available IPs in the specified subnet.
- `resolver_endpoint_id`: The ID of the Resolver endpoint that you want to associate IP
  addresses with.

"""
function associate_resolver_endpoint_ip_address(
    IpAddress, ResolverEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "AssociateResolverEndpointIpAddress",
        Dict{String,Any}(
            "IpAddress" => IpAddress, "ResolverEndpointId" => ResolverEndpointId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_resolver_endpoint_ip_address(
    IpAddress,
    ResolverEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "AssociateResolverEndpointIpAddress",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IpAddress" => IpAddress, "ResolverEndpointId" => ResolverEndpointId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_resolver_query_log_config(resolver_query_log_config_id, resource_id)
    associate_resolver_query_log_config(resolver_query_log_config_id, resource_id, params::Dict{String,<:Any})

Associates an Amazon VPC with a specified query logging configuration. Route 53 Resolver
logs DNS queries that originate in all of the Amazon VPCs that are associated with a
specified query logging configuration. To associate more than one VPC with a configuration,
submit one AssociateResolverQueryLogConfig request for each VPC.  The VPCs that you
associate with a query logging configuration must be in the same Region as the
configuration.  To remove a VPC from a query logging configuration, see
DisassociateResolverQueryLogConfig.

# Arguments
- `resolver_query_log_config_id`: The ID of the query logging configuration that you want
  to associate a VPC with.
- `resource_id`: The ID of an Amazon VPC that you want this query logging configuration to
  log queries for.  The VPCs and the query logging configuration must be in the same Region.

"""
function associate_resolver_query_log_config(
    ResolverQueryLogConfigId, ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "AssociateResolverQueryLogConfig",
        Dict{String,Any}(
            "ResolverQueryLogConfigId" => ResolverQueryLogConfigId,
            "ResourceId" => ResourceId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_resolver_query_log_config(
    ResolverQueryLogConfigId,
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "AssociateResolverQueryLogConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResolverQueryLogConfigId" => ResolverQueryLogConfigId,
                    "ResourceId" => ResourceId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_resolver_rule(resolver_rule_id, vpcid)
    associate_resolver_rule(resolver_rule_id, vpcid, params::Dict{String,<:Any})

Associates a Resolver rule with a VPC. When you associate a rule with a VPC, Resolver
forwards all DNS queries for the domain name that is specified in the rule and that
originate in the VPC. The queries are forwarded to the IP addresses for the DNS resolvers
that are specified in the rule. For more information about rules, see CreateResolverRule.

# Arguments
- `resolver_rule_id`: The ID of the Resolver rule that you want to associate with the VPC.
  To list the existing Resolver rules, use ListResolverRules.
- `vpcid`: The ID of the VPC that you want to associate the Resolver rule with.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Name"`: A name for the association that you're creating between a Resolver rule and a
  VPC.
"""
function associate_resolver_rule(
    ResolverRuleId, VPCId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "AssociateResolverRule",
        Dict{String,Any}("ResolverRuleId" => ResolverRuleId, "VPCId" => VPCId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_resolver_rule(
    ResolverRuleId,
    VPCId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "AssociateResolverRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResolverRuleId" => ResolverRuleId, "VPCId" => VPCId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_firewall_domain_list(creator_request_id, name)
    create_firewall_domain_list(creator_request_id, name, params::Dict{String,<:Any})

Creates an empty firewall domain list for use in DNS Firewall rules. You can populate the
domains for the new list with a file, using ImportFirewallDomains, or with domain strings,
using UpdateFirewallDomains.

# Arguments
- `creator_request_id`: A unique string that identifies the request and that allows you to
  retry failed requests without the risk of running the operation twice. CreatorRequestId can
  be any unique string, for example, a date/time stamp.
- `name`: A name that lets you identify the domain list to manage and use it.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of the tag keys and values that you want to associate with the domain
  list.
"""
function create_firewall_domain_list(
    CreatorRequestId, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "CreateFirewallDomainList",
        Dict{String,Any}("CreatorRequestId" => CreatorRequestId, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_firewall_domain_list(
    CreatorRequestId,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "CreateFirewallDomainList",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CreatorRequestId" => CreatorRequestId, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_firewall_rule(action, creator_request_id, firewall_domain_list_id, firewall_rule_group_id, name, priority)
    create_firewall_rule(action, creator_request_id, firewall_domain_list_id, firewall_rule_group_id, name, priority, params::Dict{String,<:Any})

Creates a single DNS Firewall rule in the specified rule group, using the specified domain
list.

# Arguments
- `action`: The action that DNS Firewall should take on a DNS query when it matches one of
  the domains in the rule's domain list:    ALLOW - Permit the request to go through.
  ALERT - Permit the request and send metrics and logs to Cloud Watch.    BLOCK - Disallow
  the request. This option requires additional details in the rule's BlockResponse.
- `creator_request_id`: A unique string that identifies the request and that allows you to
  retry failed requests without the risk of running the operation twice. CreatorRequestId can
  be any unique string, for example, a date/time stamp.
- `firewall_domain_list_id`: The ID of the domain list that you want to use in the rule.
- `firewall_rule_group_id`: The unique identifier of the firewall rule group where you want
  to create the rule.
- `name`: A name that lets you identify the rule in the rule group.
- `priority`: The setting that determines the processing order of the rule in the rule
  group. DNS Firewall processes the rules in a rule group by order of priority, starting from
  the lowest setting. You must specify a unique priority for each rule in a rule group. To
  make it easier to insert rules later, leave space between the numbers, for example, use
  100, 200, and so on. You can change the priority setting for the rules in a rule group at
  any time.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BlockOverrideDnsType"`: The DNS record's type. This determines the format of the record
  value that you provided in BlockOverrideDomain. Used for the rule action BLOCK with a
  BlockResponse setting of OVERRIDE. This setting is required if the BlockResponse setting is
  OVERRIDE.
- `"BlockOverrideDomain"`: The custom DNS record to send back in response to the query.
  Used for the rule action BLOCK with a BlockResponse setting of OVERRIDE. This setting is
  required if the BlockResponse setting is OVERRIDE.
- `"BlockOverrideTtl"`: The recommended amount of time, in seconds, for the DNS resolver or
  web browser to cache the provided override record. Used for the rule action BLOCK with a
  BlockResponse setting of OVERRIDE. This setting is required if the BlockResponse setting is
  OVERRIDE.
- `"BlockResponse"`: The way that you want DNS Firewall to block the request, used with the
  rule action setting BLOCK.     NODATA - Respond indicating that the query was successful,
  but no response is available for it.    NXDOMAIN - Respond indicating that the domain name
  that's in the query doesn't exist.    OVERRIDE - Provide a custom override in the response.
  This option requires custom handling details in the rule's BlockOverride* settings.    This
  setting is required if the rule action setting is BLOCK.
- `"FirewallDomainRedirectionAction"`:  How you want the the rule to evaluate DNS
  redirection in the DNS redirection chain, such as CNAME or DNAME.
  Inspect_Redirection_Domain (Default) inspects all domains in the redirection chain. The
  individual domains in the redirection chain must be added to the domain list.
  Trust_Redirection_Domain  inspects only the first domain in the redirection chain. You
  don't need to add the subsequent domains in the domain in the redirection list to the
  domain list.
- `"Qtype"`:  The DNS query type you want the rule to evaluate. Allowed values are;     A:
  Returns an IPv4 address.   AAAA: Returns an Ipv6 address.   CAA: Restricts CAs that can
  create SSL/TLS certifications for the domain.   CNAME: Returns another domain name.   DS:
  Record that identifies the DNSSEC signing key of a delegated zone.   MX: Specifies mail
  servers.   NAPTR: Regular-expression-based rewriting of domain names.   NS: Authoritative
  name servers.   PTR: Maps an IP address to a domain name.   SOA: Start of authority record
  for the zone.   SPF: Lists the servers authorized to send emails from a domain.   SRV:
  Application specific values that identify servers.   TXT: Verifies email senders and
  application-specific values.   A query type you define by using the DNS type ID, for
  example 28 for AAAA. The values must be defined as TYPENUMBER, where the NUMBER can be
  1-65334, for example, TYPE28. For more information, see List of DNS record types.
"""
function create_firewall_rule(
    Action,
    CreatorRequestId,
    FirewallDomainListId,
    FirewallRuleGroupId,
    Name,
    Priority;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "CreateFirewallRule",
        Dict{String,Any}(
            "Action" => Action,
            "CreatorRequestId" => CreatorRequestId,
            "FirewallDomainListId" => FirewallDomainListId,
            "FirewallRuleGroupId" => FirewallRuleGroupId,
            "Name" => Name,
            "Priority" => Priority,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_firewall_rule(
    Action,
    CreatorRequestId,
    FirewallDomainListId,
    FirewallRuleGroupId,
    Name,
    Priority,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "CreateFirewallRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Action" => Action,
                    "CreatorRequestId" => CreatorRequestId,
                    "FirewallDomainListId" => FirewallDomainListId,
                    "FirewallRuleGroupId" => FirewallRuleGroupId,
                    "Name" => Name,
                    "Priority" => Priority,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_firewall_rule_group(creator_request_id, name)
    create_firewall_rule_group(creator_request_id, name, params::Dict{String,<:Any})

Creates an empty DNS Firewall rule group for filtering DNS network traffic in a VPC. You
can add rules to the new rule group by calling CreateFirewallRule.

# Arguments
- `creator_request_id`: A unique string defined by you to identify the request. This allows
  you to retry failed requests without the risk of running the operation twice. This can be
  any unique string, for example, a timestamp.
- `name`: A name that lets you identify the rule group, to manage and use it.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of the tag keys and values that you want to associate with the rule
  group.
"""
function create_firewall_rule_group(
    CreatorRequestId, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "CreateFirewallRuleGroup",
        Dict{String,Any}("CreatorRequestId" => CreatorRequestId, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_firewall_rule_group(
    CreatorRequestId,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "CreateFirewallRuleGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CreatorRequestId" => CreatorRequestId, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_outpost_resolver(creator_request_id, name, outpost_arn, preferred_instance_type)
    create_outpost_resolver(creator_request_id, name, outpost_arn, preferred_instance_type, params::Dict{String,<:Any})

Creates a Route 53 Resolver on an Outpost.

# Arguments
- `creator_request_id`: A unique string that identifies the request and that allows failed
  requests to be retried without the risk of running the operation twice.   CreatorRequestId
  can be any unique string, for example, a date/time stamp.
- `name`: A friendly name that lets you easily find a configuration in the Resolver
  dashboard in the Route 53 console.
- `outpost_arn`: The Amazon Resource Name (ARN) of the Outpost. If you specify this, you
  must also specify a value for the PreferredInstanceType.
- `preferred_instance_type`:  The Amazon EC2 instance type. If you specify this, you must
  also specify a value for the OutpostArn.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"InstanceCount"`: Number of Amazon EC2 instances for the Resolver on Outpost. The
  default and minimal value is 4.
- `"Tags"`:  A string that helps identify the Route 53 Resolvers on Outpost.
"""
function create_outpost_resolver(
    CreatorRequestId,
    Name,
    OutpostArn,
    PreferredInstanceType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "CreateOutpostResolver",
        Dict{String,Any}(
            "CreatorRequestId" => CreatorRequestId,
            "Name" => Name,
            "OutpostArn" => OutpostArn,
            "PreferredInstanceType" => PreferredInstanceType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_outpost_resolver(
    CreatorRequestId,
    Name,
    OutpostArn,
    PreferredInstanceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "CreateOutpostResolver",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CreatorRequestId" => CreatorRequestId,
                    "Name" => Name,
                    "OutpostArn" => OutpostArn,
                    "PreferredInstanceType" => PreferredInstanceType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_resolver_endpoint(creator_request_id, direction, ip_addresses, security_group_ids)
    create_resolver_endpoint(creator_request_id, direction, ip_addresses, security_group_ids, params::Dict{String,<:Any})

Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound and
outbound:   An inbound Resolver endpoint forwards DNS queries to the DNS service for a VPC
from your network.   An outbound Resolver endpoint forwards DNS queries from the DNS
service for a VPC to your network.

# Arguments
- `creator_request_id`: A unique string that identifies the request and that allows failed
  requests to be retried without the risk of running the operation twice. CreatorRequestId
  can be any unique string, for example, a date/time stamp.
- `direction`: Specify the applicable value:    INBOUND: Resolver forwards DNS queries to
  the DNS service for a VPC from your network    OUTBOUND: Resolver forwards DNS queries from
  the DNS service for a VPC to your network
- `ip_addresses`: The subnets and IP addresses in your VPC that DNS queries originate from
  (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). The
  subnet ID uniquely identifies a VPC.   Even though the minimum is 1, Route 53 requires
  that you create at least two.
- `security_group_ids`: The ID of one or more security groups that you want to use to
  control access to this VPC. The security group that you specify must include one or more
  inbound rules (for inbound Resolver endpoints) or outbound rules (for outbound Resolver
  endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access,
  open port 53. For outbound access, open the port that you're using for DNS queries on your
  network. Some security group rules will cause your connection to be tracked. For outbound
  resolver endpoint, it can potentially impact the maximum queries per second from outbound
  endpoint to your target name server. For inbound resolver endpoint, it can bring down the
  overall maximum queries per second per IP address to as low as 1500. To avoid connection
  tracking caused by security group, see Untracked connections.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Name"`: A friendly name that lets you easily find a configuration in the Resolver
  dashboard in the Route 53 console.
- `"OutpostArn"`: The Amazon Resource Name (ARN) of the Outpost. If you specify this, you
  must also specify a value for the PreferredInstanceType.
- `"PreferredInstanceType"`: The instance type. If you specify this, you must also specify
  a value for the OutpostArn.
- `"Protocols"`:  The protocols you want to use for the endpoint. DoH-FIPS is applicable
  for inbound endpoints only.  For an inbound endpoint you can apply the protocols as
  follows:    Do53 and DoH in combination.   Do53 and DoH-FIPS in combination.   Do53 alone.
   DoH alone.   DoH-FIPS alone.   None, which is treated as Do53.   For an outbound endpoint
  you can apply the protocols as follows:    Do53 and DoH in combination.   Do53 alone.   DoH
  alone.   None, which is treated as Do53.
- `"ResolverEndpointType"`:  For the endpoint type you can choose either IPv4, IPv6, or
  dual-stack. A dual-stack endpoint means that it will resolve via both IPv4 and IPv6. This
  endpoint type is applied to all IP addresses.
- `"Tags"`: A list of the tag keys and values that you want to associate with the endpoint.
"""
function create_resolver_endpoint(
    CreatorRequestId,
    Direction,
    IpAddresses,
    SecurityGroupIds;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "CreateResolverEndpoint",
        Dict{String,Any}(
            "CreatorRequestId" => CreatorRequestId,
            "Direction" => Direction,
            "IpAddresses" => IpAddresses,
            "SecurityGroupIds" => SecurityGroupIds,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_resolver_endpoint(
    CreatorRequestId,
    Direction,
    IpAddresses,
    SecurityGroupIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "CreateResolverEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CreatorRequestId" => CreatorRequestId,
                    "Direction" => Direction,
                    "IpAddresses" => IpAddresses,
                    "SecurityGroupIds" => SecurityGroupIds,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_resolver_query_log_config(creator_request_id, destination_arn, name)
    create_resolver_query_log_config(creator_request_id, destination_arn, name, params::Dict{String,<:Any})

Creates a Resolver query logging configuration, which defines where you want Resolver to
save DNS query logs that originate in your VPCs. Resolver can log queries only for VPCs
that are in the same Region as the query logging configuration. To specify which VPCs you
want to log queries for, you use AssociateResolverQueryLogConfig. For more information, see
AssociateResolverQueryLogConfig.  You can optionally use Resource Access Manager (RAM) to
share a query logging configuration with other Amazon Web Services accounts. The other
accounts can then associate VPCs with the configuration. The query logs that Resolver
creates for a configuration include all DNS queries that originate in all VPCs that are
associated with the configuration.

# Arguments
- `creator_request_id`: A unique string that identifies the request and that allows failed
  requests to be retried without the risk of running the operation twice. CreatorRequestId
  can be any unique string, for example, a date/time stamp.
- `destination_arn`: The ARN of the resource that you want Resolver to send query logs. You
  can send query logs to an S3 bucket, a CloudWatch Logs log group, or a Kinesis Data
  Firehose delivery stream. Examples of valid values include the following:    S3 bucket:
  arn:aws:s3:::examplebucket  You can optionally append a file prefix to the end of the ARN.
  arn:aws:s3:::examplebucket/development/     CloudWatch Logs log group:
  arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*     Kinesis
  Data Firehose delivery stream:  arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name
  
- `name`: The name that you want to give the query logging configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of the tag keys and values that you want to associate with the query
  logging configuration.
"""
function create_resolver_query_log_config(
    CreatorRequestId,
    DestinationArn,
    Name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "CreateResolverQueryLogConfig",
        Dict{String,Any}(
            "CreatorRequestId" => CreatorRequestId,
            "DestinationArn" => DestinationArn,
            "Name" => Name,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_resolver_query_log_config(
    CreatorRequestId,
    DestinationArn,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "CreateResolverQueryLogConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CreatorRequestId" => CreatorRequestId,
                    "DestinationArn" => DestinationArn,
                    "Name" => Name,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_resolver_rule(creator_request_id, rule_type)
    create_resolver_rule(creator_request_id, rule_type, params::Dict{String,<:Any})

For DNS queries that originate in your VPCs, specifies which Resolver endpoint the queries
pass through, one domain name that you want to forward to your network, and the IP
addresses of the DNS resolvers in your network.

# Arguments
- `creator_request_id`: A unique string that identifies the request and that allows failed
  requests to be retried without the risk of running the operation twice. CreatorRequestId
  can be any unique string, for example, a date/time stamp.
- `rule_type`: When you want to forward DNS queries for specified domain name to resolvers
  on your network, specify FORWARD. When you have a forwarding rule to forward DNS queries
  for a domain to your network and you want Resolver to process queries for a subdomain of
  that domain, specify SYSTEM. For example, to forward DNS queries for example.com to
  resolvers on your network, you create a rule and specify FORWARD for RuleType. To then have
  Resolver process queries for apex.example.com, you create a rule and specify SYSTEM for
  RuleType. Currently, only Resolver can create rules that have a value of RECURSIVE for
  RuleType.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DomainName"`: DNS queries for this domain name are forwarded to the IP addresses that
  you specify in TargetIps. If a query matches multiple Resolver rules (example.com and
  www.example.com), outbound DNS queries are routed using the Resolver rule that contains the
  most specific domain name (www.example.com).
- `"Name"`: A friendly name that lets you easily find a rule in the Resolver dashboard in
  the Route 53 console.
- `"ResolverEndpointId"`: The ID of the outbound Resolver endpoint that you want to use to
  route DNS queries to the IP addresses that you specify in TargetIps.
- `"Tags"`: A list of the tag keys and values that you want to associate with the endpoint.
- `"TargetIps"`: The IPs that you want Resolver to forward DNS queries to. You can specify
  either Ipv4 or Ipv6 addresses but not both in the same rule. Separate IP addresses with a
  space.  TargetIps is available only when the value of Rule type is FORWARD.
"""
function create_resolver_rule(
    CreatorRequestId, RuleType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "CreateResolverRule",
        Dict{String,Any}("CreatorRequestId" => CreatorRequestId, "RuleType" => RuleType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_resolver_rule(
    CreatorRequestId,
    RuleType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "CreateResolverRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CreatorRequestId" => CreatorRequestId, "RuleType" => RuleType
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_firewall_domain_list(firewall_domain_list_id)
    delete_firewall_domain_list(firewall_domain_list_id, params::Dict{String,<:Any})

Deletes the specified domain list.

# Arguments
- `firewall_domain_list_id`: The ID of the domain list that you want to delete.

"""
function delete_firewall_domain_list(
    FirewallDomainListId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "DeleteFirewallDomainList",
        Dict{String,Any}("FirewallDomainListId" => FirewallDomainListId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_firewall_domain_list(
    FirewallDomainListId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "DeleteFirewallDomainList",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("FirewallDomainListId" => FirewallDomainListId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_firewall_rule(firewall_domain_list_id, firewall_rule_group_id)
    delete_firewall_rule(firewall_domain_list_id, firewall_rule_group_id, params::Dict{String,<:Any})

Deletes the specified firewall rule.

# Arguments
- `firewall_domain_list_id`: The ID of the domain list that's used in the rule.
- `firewall_rule_group_id`: The unique identifier of the firewall rule group that you want
  to delete the rule from.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Qtype"`:  The DNS query type that the rule you are deleting evaluates. Allowed values
  are;     A: Returns an IPv4 address.   AAAA: Returns an Ipv6 address.   CAA: Restricts CAs
  that can create SSL/TLS certifications for the domain.   CNAME: Returns another domain
  name.   DS: Record that identifies the DNSSEC signing key of a delegated zone.   MX:
  Specifies mail servers.   NAPTR: Regular-expression-based rewriting of domain names.   NS:
  Authoritative name servers.   PTR: Maps an IP address to a domain name.   SOA: Start of
  authority record for the zone.   SPF: Lists the servers authorized to send emails from a
  domain.   SRV: Application specific values that identify servers.   TXT: Verifies email
  senders and application-specific values.   A query type you define by using the DNS type
  ID, for example 28 for AAAA. The values must be defined as TYPENUMBER, where the NUMBER can
  be 1-65334, for example, TYPE28. For more information, see List of DNS record types.
"""
function delete_firewall_rule(
    FirewallDomainListId,
    FirewallRuleGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "DeleteFirewallRule",
        Dict{String,Any}(
            "FirewallDomainListId" => FirewallDomainListId,
            "FirewallRuleGroupId" => FirewallRuleGroupId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_firewall_rule(
    FirewallDomainListId,
    FirewallRuleGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "DeleteFirewallRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FirewallDomainListId" => FirewallDomainListId,
                    "FirewallRuleGroupId" => FirewallRuleGroupId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_firewall_rule_group(firewall_rule_group_id)
    delete_firewall_rule_group(firewall_rule_group_id, params::Dict{String,<:Any})

Deletes the specified firewall rule group.

# Arguments
- `firewall_rule_group_id`: The unique identifier of the firewall rule group that you want
  to delete.

"""
function delete_firewall_rule_group(
    FirewallRuleGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "DeleteFirewallRuleGroup",
        Dict{String,Any}("FirewallRuleGroupId" => FirewallRuleGroupId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_firewall_rule_group(
    FirewallRuleGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "DeleteFirewallRuleGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("FirewallRuleGroupId" => FirewallRuleGroupId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_outpost_resolver(id)
    delete_outpost_resolver(id, params::Dict{String,<:Any})

Deletes a Resolver on the Outpost.

# Arguments
- `id`: A unique string that identifies the Resolver on the Outpost.

"""
function delete_outpost_resolver(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return route53resolver(
        "DeleteOutpostResolver",
        Dict{String,Any}("Id" => Id);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_outpost_resolver(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "DeleteOutpostResolver",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Id" => Id), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resolver_endpoint(resolver_endpoint_id)
    delete_resolver_endpoint(resolver_endpoint_id, params::Dict{String,<:Any})

Deletes a Resolver endpoint. The effect of deleting a Resolver endpoint depends on whether
it's an inbound or an outbound Resolver endpoint:    Inbound: DNS queries from your network
are no longer routed to the DNS service for the specified VPC.    Outbound: DNS queries
from a VPC are no longer routed to your network.

# Arguments
- `resolver_endpoint_id`: The ID of the Resolver endpoint that you want to delete.

"""
function delete_resolver_endpoint(
    ResolverEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "DeleteResolverEndpoint",
        Dict{String,Any}("ResolverEndpointId" => ResolverEndpointId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resolver_endpoint(
    ResolverEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "DeleteResolverEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ResolverEndpointId" => ResolverEndpointId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resolver_query_log_config(resolver_query_log_config_id)
    delete_resolver_query_log_config(resolver_query_log_config_id, params::Dict{String,<:Any})

Deletes a query logging configuration. When you delete a configuration, Resolver stops
logging DNS queries for all of the Amazon VPCs that are associated with the configuration.
This also applies if the query logging configuration is shared with other Amazon Web
Services accounts, and the other accounts have associated VPCs with the shared
configuration. Before you can delete a query logging configuration, you must first
disassociate all VPCs from the configuration. See DisassociateResolverQueryLogConfig. If
you used Resource Access Manager (RAM) to share a query logging configuration with other
accounts, you must stop sharing the configuration before you can delete a configuration.
The accounts that you shared the configuration with can first disassociate VPCs that they
associated with the configuration, but that's not necessary. If you stop sharing the
configuration, those VPCs are automatically disassociated from the configuration.

# Arguments
- `resolver_query_log_config_id`: The ID of the query logging configuration that you want
  to delete.

"""
function delete_resolver_query_log_config(
    ResolverQueryLogConfigId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "DeleteResolverQueryLogConfig",
        Dict{String,Any}("ResolverQueryLogConfigId" => ResolverQueryLogConfigId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resolver_query_log_config(
    ResolverQueryLogConfigId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "DeleteResolverQueryLogConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResolverQueryLogConfigId" => ResolverQueryLogConfigId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resolver_rule(resolver_rule_id)
    delete_resolver_rule(resolver_rule_id, params::Dict{String,<:Any})

Deletes a Resolver rule. Before you can delete a Resolver rule, you must disassociate it
from all the VPCs that you associated the Resolver rule with. For more information, see
DisassociateResolverRule.

# Arguments
- `resolver_rule_id`: The ID of the Resolver rule that you want to delete.

"""
function delete_resolver_rule(
    ResolverRuleId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "DeleteResolverRule",
        Dict{String,Any}("ResolverRuleId" => ResolverRuleId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resolver_rule(
    ResolverRuleId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "DeleteResolverRule",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResolverRuleId" => ResolverRuleId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_firewall_rule_group(firewall_rule_group_association_id)
    disassociate_firewall_rule_group(firewall_rule_group_association_id, params::Dict{String,<:Any})

Disassociates a FirewallRuleGroup from a VPC, to remove DNS filtering from the VPC.

# Arguments
- `firewall_rule_group_association_id`: The identifier of the FirewallRuleGroupAssociation.

"""
function disassociate_firewall_rule_group(
    FirewallRuleGroupAssociationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "DisassociateFirewallRuleGroup",
        Dict{String,Any}(
            "FirewallRuleGroupAssociationId" => FirewallRuleGroupAssociationId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_firewall_rule_group(
    FirewallRuleGroupAssociationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "DisassociateFirewallRuleGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FirewallRuleGroupAssociationId" => FirewallRuleGroupAssociationId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_resolver_endpoint_ip_address(ip_address, resolver_endpoint_id)
    disassociate_resolver_endpoint_ip_address(ip_address, resolver_endpoint_id, params::Dict{String,<:Any})

Removes IP addresses from an inbound or an outbound Resolver endpoint. If you want to
remove more than one IP address, submit one DisassociateResolverEndpointIpAddress request
for each IP address. To add an IP address to an endpoint, see
AssociateResolverEndpointIpAddress.

# Arguments
- `ip_address`: The IPv4 address that you want to remove from a Resolver endpoint.
- `resolver_endpoint_id`: The ID of the Resolver endpoint that you want to disassociate an
  IP address from.

"""
function disassociate_resolver_endpoint_ip_address(
    IpAddress, ResolverEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "DisassociateResolverEndpointIpAddress",
        Dict{String,Any}(
            "IpAddress" => IpAddress, "ResolverEndpointId" => ResolverEndpointId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_resolver_endpoint_ip_address(
    IpAddress,
    ResolverEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "DisassociateResolverEndpointIpAddress",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IpAddress" => IpAddress, "ResolverEndpointId" => ResolverEndpointId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_resolver_query_log_config(resolver_query_log_config_id, resource_id)
    disassociate_resolver_query_log_config(resolver_query_log_config_id, resource_id, params::Dict{String,<:Any})

Disassociates a VPC from a query logging configuration.  Before you can delete a query
logging configuration, you must first disassociate all VPCs from the configuration. If you
used Resource Access Manager (RAM) to share a query logging configuration with other
accounts, VPCs can be disassociated from the configuration in the following ways:   The
accounts that you shared the configuration with can disassociate VPCs from the
configuration.   You can stop sharing the configuration.

# Arguments
- `resolver_query_log_config_id`: The ID of the query logging configuration that you want
  to disassociate a specified VPC from.
- `resource_id`: The ID of the Amazon VPC that you want to disassociate from a specified
  query logging configuration.

"""
function disassociate_resolver_query_log_config(
    ResolverQueryLogConfigId, ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "DisassociateResolverQueryLogConfig",
        Dict{String,Any}(
            "ResolverQueryLogConfigId" => ResolverQueryLogConfigId,
            "ResourceId" => ResourceId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_resolver_query_log_config(
    ResolverQueryLogConfigId,
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "DisassociateResolverQueryLogConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResolverQueryLogConfigId" => ResolverQueryLogConfigId,
                    "ResourceId" => ResourceId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_resolver_rule(resolver_rule_id, vpcid)
    disassociate_resolver_rule(resolver_rule_id, vpcid, params::Dict{String,<:Any})

Removes the association between a specified Resolver rule and a specified VPC.  If you
disassociate a Resolver rule from a VPC, Resolver stops forwarding DNS queries for the
domain name that you specified in the Resolver rule.

# Arguments
- `resolver_rule_id`: The ID of the Resolver rule that you want to disassociate from the
  specified VPC.
- `vpcid`: The ID of the VPC that you want to disassociate the Resolver rule from.

"""
function disassociate_resolver_rule(
    ResolverRuleId, VPCId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "DisassociateResolverRule",
        Dict{String,Any}("ResolverRuleId" => ResolverRuleId, "VPCId" => VPCId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_resolver_rule(
    ResolverRuleId,
    VPCId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "DisassociateResolverRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResolverRuleId" => ResolverRuleId, "VPCId" => VPCId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_firewall_config(resource_id)
    get_firewall_config(resource_id, params::Dict{String,<:Any})

Retrieves the configuration of the firewall behavior provided by DNS Firewall for a single
VPC from Amazon Virtual Private Cloud (Amazon VPC).

# Arguments
- `resource_id`: The ID of the VPC from Amazon VPC that the configuration is for.

"""
function get_firewall_config(ResourceId; aws_config::AbstractAWSConfig=current_aws_config())
    return route53resolver(
        "GetFirewallConfig",
        Dict{String,Any}("ResourceId" => ResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_firewall_config(
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "GetFirewallConfig",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceId" => ResourceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_firewall_domain_list(firewall_domain_list_id)
    get_firewall_domain_list(firewall_domain_list_id, params::Dict{String,<:Any})

Retrieves the specified firewall domain list.

# Arguments
- `firewall_domain_list_id`: The ID of the domain list.

"""
function get_firewall_domain_list(
    FirewallDomainListId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "GetFirewallDomainList",
        Dict{String,Any}("FirewallDomainListId" => FirewallDomainListId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_firewall_domain_list(
    FirewallDomainListId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "GetFirewallDomainList",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("FirewallDomainListId" => FirewallDomainListId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_firewall_rule_group(firewall_rule_group_id)
    get_firewall_rule_group(firewall_rule_group_id, params::Dict{String,<:Any})

Retrieves the specified firewall rule group.

# Arguments
- `firewall_rule_group_id`: The unique identifier of the firewall rule group.

"""
function get_firewall_rule_group(
    FirewallRuleGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "GetFirewallRuleGroup",
        Dict{String,Any}("FirewallRuleGroupId" => FirewallRuleGroupId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_firewall_rule_group(
    FirewallRuleGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "GetFirewallRuleGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("FirewallRuleGroupId" => FirewallRuleGroupId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_firewall_rule_group_association(firewall_rule_group_association_id)
    get_firewall_rule_group_association(firewall_rule_group_association_id, params::Dict{String,<:Any})

Retrieves a firewall rule group association, which enables DNS filtering for a VPC with one
rule group. A VPC can have more than one firewall rule group association, and a rule group
can be associated with more than one VPC.

# Arguments
- `firewall_rule_group_association_id`: The identifier of the FirewallRuleGroupAssociation.

"""
function get_firewall_rule_group_association(
    FirewallRuleGroupAssociationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "GetFirewallRuleGroupAssociation",
        Dict{String,Any}(
            "FirewallRuleGroupAssociationId" => FirewallRuleGroupAssociationId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_firewall_rule_group_association(
    FirewallRuleGroupAssociationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "GetFirewallRuleGroupAssociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FirewallRuleGroupAssociationId" => FirewallRuleGroupAssociationId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_firewall_rule_group_policy(arn)
    get_firewall_rule_group_policy(arn, params::Dict{String,<:Any})

Returns the Identity and Access Management (Amazon Web Services IAM) policy for sharing the
specified rule group. You can use the policy to share the rule group using Resource Access
Manager (RAM).

# Arguments
- `arn`: The ARN (Amazon Resource Name) for the rule group.

"""
function get_firewall_rule_group_policy(
    Arn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "GetFirewallRuleGroupPolicy",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_firewall_rule_group_policy(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "GetFirewallRuleGroupPolicy",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_outpost_resolver(id)
    get_outpost_resolver(id, params::Dict{String,<:Any})

Gets information about a specified Resolver on the Outpost, such as its instance count and
type, name, and the current status of the Resolver.

# Arguments
- `id`: The ID of the Resolver on the Outpost.

"""
function get_outpost_resolver(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return route53resolver(
        "GetOutpostResolver",
        Dict{String,Any}("Id" => Id);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_outpost_resolver(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "GetOutpostResolver",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Id" => Id), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resolver_config(resource_id)
    get_resolver_config(resource_id, params::Dict{String,<:Any})

Retrieves the behavior configuration of Route 53 Resolver behavior for a single VPC from
Amazon Virtual Private Cloud.

# Arguments
- `resource_id`: Resource ID of the Amazon VPC that you want to get information about.

"""
function get_resolver_config(ResourceId; aws_config::AbstractAWSConfig=current_aws_config())
    return route53resolver(
        "GetResolverConfig",
        Dict{String,Any}("ResourceId" => ResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resolver_config(
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "GetResolverConfig",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceId" => ResourceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resolver_dnssec_config(resource_id)
    get_resolver_dnssec_config(resource_id, params::Dict{String,<:Any})

Gets DNSSEC validation information for a specified resource.

# Arguments
- `resource_id`: The ID of the virtual private cloud (VPC) for the DNSSEC validation status.

"""
function get_resolver_dnssec_config(
    ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "GetResolverDnssecConfig",
        Dict{String,Any}("ResourceId" => ResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resolver_dnssec_config(
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "GetResolverDnssecConfig",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceId" => ResourceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resolver_endpoint(resolver_endpoint_id)
    get_resolver_endpoint(resolver_endpoint_id, params::Dict{String,<:Any})

Gets information about a specified Resolver endpoint, such as whether it's an inbound or an
outbound Resolver endpoint, and the current status of the endpoint.

# Arguments
- `resolver_endpoint_id`: The ID of the Resolver endpoint that you want to get information
  about.

"""
function get_resolver_endpoint(
    ResolverEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "GetResolverEndpoint",
        Dict{String,Any}("ResolverEndpointId" => ResolverEndpointId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resolver_endpoint(
    ResolverEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "GetResolverEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ResolverEndpointId" => ResolverEndpointId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resolver_query_log_config(resolver_query_log_config_id)
    get_resolver_query_log_config(resolver_query_log_config_id, params::Dict{String,<:Any})

Gets information about a specified Resolver query logging configuration, such as the number
of VPCs that the configuration is logging queries for and the location that logs are sent
to.

# Arguments
- `resolver_query_log_config_id`: The ID of the Resolver query logging configuration that
  you want to get information about.

"""
function get_resolver_query_log_config(
    ResolverQueryLogConfigId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "GetResolverQueryLogConfig",
        Dict{String,Any}("ResolverQueryLogConfigId" => ResolverQueryLogConfigId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resolver_query_log_config(
    ResolverQueryLogConfigId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "GetResolverQueryLogConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResolverQueryLogConfigId" => ResolverQueryLogConfigId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resolver_query_log_config_association(resolver_query_log_config_association_id)
    get_resolver_query_log_config_association(resolver_query_log_config_association_id, params::Dict{String,<:Any})

Gets information about a specified association between a Resolver query logging
configuration and an Amazon VPC. When you associate a VPC with a query logging
configuration, Resolver logs DNS queries that originate in that VPC.

# Arguments
- `resolver_query_log_config_association_id`: The ID of the Resolver query logging
  configuration association that you want to get information about.

"""
function get_resolver_query_log_config_association(
    ResolverQueryLogConfigAssociationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "GetResolverQueryLogConfigAssociation",
        Dict{String,Any}(
            "ResolverQueryLogConfigAssociationId" => ResolverQueryLogConfigAssociationId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resolver_query_log_config_association(
    ResolverQueryLogConfigAssociationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "GetResolverQueryLogConfigAssociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResolverQueryLogConfigAssociationId" =>
                        ResolverQueryLogConfigAssociationId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resolver_query_log_config_policy(arn)
    get_resolver_query_log_config_policy(arn, params::Dict{String,<:Any})

Gets information about a query logging policy. A query logging policy specifies the
Resolver query logging operations and resources that you want to allow another Amazon Web
Services account to be able to use.

# Arguments
- `arn`: The ARN of the query logging configuration that you want to get the query logging
  policy for.

"""
function get_resolver_query_log_config_policy(
    Arn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "GetResolverQueryLogConfigPolicy",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resolver_query_log_config_policy(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "GetResolverQueryLogConfigPolicy",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resolver_rule(resolver_rule_id)
    get_resolver_rule(resolver_rule_id, params::Dict{String,<:Any})

Gets information about a specified Resolver rule, such as the domain name that the rule
forwards DNS queries for and the ID of the outbound Resolver endpoint that the rule is
associated with.

# Arguments
- `resolver_rule_id`: The ID of the Resolver rule that you want to get information about.

"""
function get_resolver_rule(
    ResolverRuleId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "GetResolverRule",
        Dict{String,Any}("ResolverRuleId" => ResolverRuleId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resolver_rule(
    ResolverRuleId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "GetResolverRule",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResolverRuleId" => ResolverRuleId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resolver_rule_association(resolver_rule_association_id)
    get_resolver_rule_association(resolver_rule_association_id, params::Dict{String,<:Any})

Gets information about an association between a specified Resolver rule and a VPC. You
associate a Resolver rule and a VPC using AssociateResolverRule.

# Arguments
- `resolver_rule_association_id`: The ID of the Resolver rule association that you want to
  get information about.

"""
function get_resolver_rule_association(
    ResolverRuleAssociationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "GetResolverRuleAssociation",
        Dict{String,Any}("ResolverRuleAssociationId" => ResolverRuleAssociationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resolver_rule_association(
    ResolverRuleAssociationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "GetResolverRuleAssociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResolverRuleAssociationId" => ResolverRuleAssociationId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resolver_rule_policy(arn)
    get_resolver_rule_policy(arn, params::Dict{String,<:Any})

Gets information about the Resolver rule policy for a specified rule. A Resolver rule
policy includes the rule that you want to share with another account, the account that you
want to share the rule with, and the Resolver operations that you want to allow the account
to use.

# Arguments
- `arn`: The ID of the Resolver rule that you want to get the Resolver rule policy for.

"""
function get_resolver_rule_policy(Arn; aws_config::AbstractAWSConfig=current_aws_config())
    return route53resolver(
        "GetResolverRulePolicy",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resolver_rule_policy(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "GetResolverRulePolicy",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    import_firewall_domains(domain_file_url, firewall_domain_list_id, operation)
    import_firewall_domains(domain_file_url, firewall_domain_list_id, operation, params::Dict{String,<:Any})

Imports domain names from a file into a domain list, for use in a DNS firewall rule group.
Each domain specification in your domain list must satisfy the following requirements:
It can optionally start with * (asterisk).   With the exception of the optional starting
asterisk, it must only contain the following characters: A-Z, a-z, 0-9, - (hyphen).   It
must be from 1-255 characters in length.

# Arguments
- `domain_file_url`: The fully qualified URL or URI of the file stored in Amazon Simple
  Storage Service (Amazon S3) that contains the list of domains to import. The file must be
  in an S3 bucket that's in the same Region as your DNS Firewall. The file must be a text
  file and must contain a single domain per line.
- `firewall_domain_list_id`: The ID of the domain list that you want to modify with the
  import operation.
- `operation`: What you want DNS Firewall to do with the domains that are listed in the
  file. This must be set to REPLACE, which updates the domain list to exactly match the list
  in the file.

"""
function import_firewall_domains(
    DomainFileUrl,
    FirewallDomainListId,
    Operation;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "ImportFirewallDomains",
        Dict{String,Any}(
            "DomainFileUrl" => DomainFileUrl,
            "FirewallDomainListId" => FirewallDomainListId,
            "Operation" => Operation,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_firewall_domains(
    DomainFileUrl,
    FirewallDomainListId,
    Operation,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "ImportFirewallDomains",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DomainFileUrl" => DomainFileUrl,
                    "FirewallDomainListId" => FirewallDomainListId,
                    "Operation" => Operation,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_firewall_configs()
    list_firewall_configs(params::Dict{String,<:Any})

Retrieves the firewall configurations that you have defined. DNS Firewall uses the
configurations to manage firewall behavior for your VPCs.  A single call might return only
a partial list of the configurations. For information, see MaxResults.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of objects that you want Resolver to return for this
  request. If more objects are available, in the response, Resolver provides a NextToken
  value that you can use in a subsequent call to get the next batch of objects. If you don't
  specify a value for MaxResults, Resolver returns up to 100 objects.
- `"NextToken"`: For the first call to this list request, omit this value. When you request
  a list of objects, Resolver returns at most the number of objects specified in MaxResults.
  If more objects are available for retrieval, Resolver returns a NextToken value in the
  response. To retrieve the next batch of objects, use the token that was returned for the
  prior request in your next request.
"""
function list_firewall_configs(; aws_config::AbstractAWSConfig=current_aws_config())
    return route53resolver(
        "ListFirewallConfigs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_firewall_configs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListFirewallConfigs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_firewall_domain_lists()
    list_firewall_domain_lists(params::Dict{String,<:Any})

Retrieves the firewall domain lists that you have defined. For each firewall domain list,
you can retrieve the domains that are defined for a list by calling ListFirewallDomains.  A
single call to this list operation might return only a partial list of the domain lists.
For information, see MaxResults.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of objects that you want Resolver to return for this
  request. If more objects are available, in the response, Resolver provides a NextToken
  value that you can use in a subsequent call to get the next batch of objects. If you don't
  specify a value for MaxResults, Resolver returns up to 100 objects.
- `"NextToken"`: For the first call to this list request, omit this value. When you request
  a list of objects, Resolver returns at most the number of objects specified in MaxResults.
  If more objects are available for retrieval, Resolver returns a NextToken value in the
  response. To retrieve the next batch of objects, use the token that was returned for the
  prior request in your next request.
"""
function list_firewall_domain_lists(; aws_config::AbstractAWSConfig=current_aws_config())
    return route53resolver(
        "ListFirewallDomainLists"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_firewall_domain_lists(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListFirewallDomainLists",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_firewall_domains(firewall_domain_list_id)
    list_firewall_domains(firewall_domain_list_id, params::Dict{String,<:Any})

Retrieves the domains that you have defined for the specified firewall domain list.  A
single call might return only a partial list of the domains. For information, see
MaxResults.

# Arguments
- `firewall_domain_list_id`: The ID of the domain list whose domains you want to retrieve.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of objects that you want Resolver to return for this
  request. If more objects are available, in the response, Resolver provides a NextToken
  value that you can use in a subsequent call to get the next batch of objects. If you don't
  specify a value for MaxResults, Resolver returns up to 100 objects.
- `"NextToken"`: For the first call to this list request, omit this value. When you request
  a list of objects, Resolver returns at most the number of objects specified in MaxResults.
  If more objects are available for retrieval, Resolver returns a NextToken value in the
  response. To retrieve the next batch of objects, use the token that was returned for the
  prior request in your next request.
"""
function list_firewall_domains(
    FirewallDomainListId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListFirewallDomains",
        Dict{String,Any}("FirewallDomainListId" => FirewallDomainListId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_firewall_domains(
    FirewallDomainListId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "ListFirewallDomains",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("FirewallDomainListId" => FirewallDomainListId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_firewall_rule_group_associations()
    list_firewall_rule_group_associations(params::Dict{String,<:Any})

Retrieves the firewall rule group associations that you have defined. Each association
enables DNS filtering for a VPC with one rule group.  A single call might return only a
partial list of the associations. For information, see MaxResults.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FirewallRuleGroupId"`: The unique identifier of the firewall rule group that you want
  to retrieve the associations for. Leave this blank to retrieve associations for any rule
  group.
- `"MaxResults"`: The maximum number of objects that you want Resolver to return for this
  request. If more objects are available, in the response, Resolver provides a NextToken
  value that you can use in a subsequent call to get the next batch of objects. If you don't
  specify a value for MaxResults, Resolver returns up to 100 objects.
- `"NextToken"`: For the first call to this list request, omit this value. When you request
  a list of objects, Resolver returns at most the number of objects specified in MaxResults.
  If more objects are available for retrieval, Resolver returns a NextToken value in the
  response. To retrieve the next batch of objects, use the token that was returned for the
  prior request in your next request.
- `"Priority"`: The setting that determines the processing order of the rule group among
  the rule groups that are associated with a single VPC. DNS Firewall filters VPC traffic
  starting from the rule group with the lowest numeric priority setting.
- `"Status"`: The association Status setting that you want DNS Firewall to filter on for
  the list. If you don't specify this, then DNS Firewall returns all associations, regardless
  of status.
- `"VpcId"`: The unique identifier of the VPC that you want to retrieve the associations
  for. Leave this blank to retrieve associations for any VPC.
"""
function list_firewall_rule_group_associations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListFirewallRuleGroupAssociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_firewall_rule_group_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListFirewallRuleGroupAssociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_firewall_rule_groups()
    list_firewall_rule_groups(params::Dict{String,<:Any})

Retrieves the minimal high-level information for the rule groups that you have defined.  A
single call might return only a partial list of the rule groups. For information, see
MaxResults.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of objects that you want Resolver to return for this
  request. If more objects are available, in the response, Resolver provides a NextToken
  value that you can use in a subsequent call to get the next batch of objects. If you don't
  specify a value for MaxResults, Resolver returns up to 100 objects.
- `"NextToken"`: For the first call to this list request, omit this value. When you request
  a list of objects, Resolver returns at most the number of objects specified in MaxResults.
  If more objects are available for retrieval, Resolver returns a NextToken value in the
  response. To retrieve the next batch of objects, use the token that was returned for the
  prior request in your next request.
"""
function list_firewall_rule_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return route53resolver(
        "ListFirewallRuleGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_firewall_rule_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListFirewallRuleGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_firewall_rules(firewall_rule_group_id)
    list_firewall_rules(firewall_rule_group_id, params::Dict{String,<:Any})

Retrieves the firewall rules that you have defined for the specified firewall rule group.
DNS Firewall uses the rules in a rule group to filter DNS network traffic for a VPC.  A
single call might return only a partial list of the rules. For information, see MaxResults.

# Arguments
- `firewall_rule_group_id`: The unique identifier of the firewall rule group that you want
  to retrieve the rules for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Action"`: Optional additional filter for the rules to retrieve. The action that DNS
  Firewall should take on a DNS query when it matches one of the domains in the rule's domain
  list:    ALLOW - Permit the request to go through.    ALERT - Permit the request to go
  through but send an alert to the logs.    BLOCK - Disallow the request. If this is
  specified, additional handling details are provided in the rule's BlockResponse setting.
- `"MaxResults"`: The maximum number of objects that you want Resolver to return for this
  request. If more objects are available, in the response, Resolver provides a NextToken
  value that you can use in a subsequent call to get the next batch of objects. If you don't
  specify a value for MaxResults, Resolver returns up to 100 objects.
- `"NextToken"`: For the first call to this list request, omit this value. When you request
  a list of objects, Resolver returns at most the number of objects specified in MaxResults.
  If more objects are available for retrieval, Resolver returns a NextToken value in the
  response. To retrieve the next batch of objects, use the token that was returned for the
  prior request in your next request.
- `"Priority"`: Optional additional filter for the rules to retrieve. The setting that
  determines the processing order of the rules in a rule group. DNS Firewall processes the
  rules in a rule group by order of priority, starting from the lowest setting.
"""
function list_firewall_rules(
    FirewallRuleGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListFirewallRules",
        Dict{String,Any}("FirewallRuleGroupId" => FirewallRuleGroupId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_firewall_rules(
    FirewallRuleGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "ListFirewallRules",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("FirewallRuleGroupId" => FirewallRuleGroupId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_outpost_resolvers()
    list_outpost_resolvers(params::Dict{String,<:Any})

Lists all the Resolvers on Outposts that were created using the current Amazon Web Services
account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of Resolvers on the Outpost that you want to return in
  the response to a ListOutpostResolver request. If you don't specify a value for MaxResults,
  the request returns up to 100 Resolvers.
- `"NextToken"`: For the first ListOutpostResolver request, omit this value.
- `"OutpostArn"`: The Amazon Resource Name (ARN) of the Outpost.
"""
function list_outpost_resolvers(; aws_config::AbstractAWSConfig=current_aws_config())
    return route53resolver(
        "ListOutpostResolvers"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_outpost_resolvers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListOutpostResolvers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resolver_configs()
    list_resolver_configs(params::Dict{String,<:Any})

Retrieves the Resolver configurations that you have defined. Route 53 Resolver uses the
configurations to manage DNS resolution behavior for your VPCs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of Resolver configurations that you want to return in
  the response to a ListResolverConfigs request. If you don't specify a value for MaxResults,
  up to 100 Resolver configurations are returned.
- `"NextToken"`: (Optional) If the current Amazon Web Services account has more than
  MaxResults Resolver configurations, use NextToken to get the second and subsequent pages of
  results. For the first ListResolverConfigs request, omit this value. For the second and
  subsequent requests, get the value of NextToken from the previous response and specify that
  value for NextToken in the request.
"""
function list_resolver_configs(; aws_config::AbstractAWSConfig=current_aws_config())
    return route53resolver(
        "ListResolverConfigs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_resolver_configs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListResolverConfigs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resolver_dnssec_configs()
    list_resolver_dnssec_configs(params::Dict{String,<:Any})

Lists the configurations for DNSSEC validation that are associated with the current Amazon
Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An optional specification to return a subset of objects.
- `"MaxResults"`:  Optional: An integer that specifies the maximum number of DNSSEC
  configuration results that you want Amazon Route 53 to return. If you don't specify a value
  for MaxResults, Route 53 returns up to 100 configuration per page.
- `"NextToken"`: (Optional) If the current Amazon Web Services account has more than
  MaxResults DNSSEC configurations, use NextToken to get the second and subsequent pages of
  results. For the first ListResolverDnssecConfigs request, omit this value. For the second
  and subsequent requests, get the value of NextToken from the previous response and specify
  that value for NextToken in the request.
"""
function list_resolver_dnssec_configs(; aws_config::AbstractAWSConfig=current_aws_config())
    return route53resolver(
        "ListResolverDnssecConfigs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_resolver_dnssec_configs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListResolverDnssecConfigs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resolver_endpoint_ip_addresses(resolver_endpoint_id)
    list_resolver_endpoint_ip_addresses(resolver_endpoint_id, params::Dict{String,<:Any})

Gets the IP addresses for a specified Resolver endpoint.

# Arguments
- `resolver_endpoint_id`: The ID of the Resolver endpoint that you want to get IP addresses
  for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of IP addresses that you want to return in the
  response to a ListResolverEndpointIpAddresses request. If you don't specify a value for
  MaxResults, Resolver returns up to 100 IP addresses.
- `"NextToken"`: For the first ListResolverEndpointIpAddresses request, omit this value. If
  the specified Resolver endpoint has more than MaxResults IP addresses, you can submit
  another ListResolverEndpointIpAddresses request to get the next group of IP addresses. In
  the next request, specify the value of NextToken from the previous response.
"""
function list_resolver_endpoint_ip_addresses(
    ResolverEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListResolverEndpointIpAddresses",
        Dict{String,Any}("ResolverEndpointId" => ResolverEndpointId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_resolver_endpoint_ip_addresses(
    ResolverEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "ListResolverEndpointIpAddresses",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ResolverEndpointId" => ResolverEndpointId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resolver_endpoints()
    list_resolver_endpoints(params::Dict{String,<:Any})

Lists all the Resolver endpoints that were created using the current Amazon Web Services
account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An optional specification to return a subset of Resolver endpoints, such as
  all inbound Resolver endpoints.  If you submit a second or subsequent ListResolverEndpoints
  request and specify the NextToken parameter, you must use the same values for Filters, if
  any, as in the previous request.
- `"MaxResults"`: The maximum number of Resolver endpoints that you want to return in the
  response to a ListResolverEndpoints request. If you don't specify a value for MaxResults,
  Resolver returns up to 100 Resolver endpoints.
- `"NextToken"`: For the first ListResolverEndpoints request, omit this value. If you have
  more than MaxResults Resolver endpoints, you can submit another ListResolverEndpoints
  request to get the next group of Resolver endpoints. In the next request, specify the value
  of NextToken from the previous response.
"""
function list_resolver_endpoints(; aws_config::AbstractAWSConfig=current_aws_config())
    return route53resolver(
        "ListResolverEndpoints"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_resolver_endpoints(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListResolverEndpoints",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resolver_query_log_config_associations()
    list_resolver_query_log_config_associations(params::Dict{String,<:Any})

Lists information about associations between Amazon VPCs and query logging configurations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An optional specification to return a subset of query logging associations.
  If you submit a second or subsequent ListResolverQueryLogConfigAssociations request and
  specify the NextToken parameter, you must use the same values for Filters, if any, as in
  the previous request.
- `"MaxResults"`: The maximum number of query logging associations that you want to return
  in the response to a ListResolverQueryLogConfigAssociations request. If you don't specify a
  value for MaxResults, Resolver returns up to 100 query logging associations.
- `"NextToken"`: For the first ListResolverQueryLogConfigAssociations request, omit this
  value. If there are more than MaxResults query logging associations that match the values
  that you specify for Filters, you can submit another ListResolverQueryLogConfigAssociations
  request to get the next group of associations. In the next request, specify the value of
  NextToken from the previous response.
- `"SortBy"`: The element that you want Resolver to sort query logging associations by.
  If you submit a second or subsequent ListResolverQueryLogConfigAssociations request and
  specify the NextToken parameter, you must use the same value for SortBy, if any, as in the
  previous request.  Valid values include the following elements:    CreationTime: The ID of
  the query logging association.    Error: If the value of Status is FAILED, the value of
  Error indicates the cause:     DESTINATION_NOT_FOUND: The specified destination (for
  example, an Amazon S3 bucket) was deleted.    ACCESS_DENIED: Permissions don't allow
  sending logs to the destination.   If Status is a value other than FAILED, ERROR is null.
   Id: The ID of the query logging association    ResolverQueryLogConfigId: The ID of the
  query logging configuration    ResourceId: The ID of the VPC that is associated with the
  query logging configuration    Status: The current status of the configuration. Valid
  values include the following:    CREATING: Resolver is creating an association between an
  Amazon VPC and a query logging configuration.    CREATED: The association between an Amazon
  VPC and a query logging configuration was successfully created. Resolver is logging queries
  that originate in the specified VPC.    DELETING: Resolver is deleting this query logging
  association.    FAILED: Resolver either couldn't create or couldn't delete the query
  logging association. Here are two common causes:   The specified destination (for example,
  an Amazon S3 bucket) was deleted.   Permissions don't allow sending logs to the
  destination.
- `"SortOrder"`: If you specified a value for SortBy, the order that you want query logging
  associations to be listed in, ASCENDING or DESCENDING.  If you submit a second or
  subsequent ListResolverQueryLogConfigAssociations request and specify the NextToken
  parameter, you must use the same value for SortOrder, if any, as in the previous request.
"""
function list_resolver_query_log_config_associations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListResolverQueryLogConfigAssociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_resolver_query_log_config_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListResolverQueryLogConfigAssociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resolver_query_log_configs()
    list_resolver_query_log_configs(params::Dict{String,<:Any})

Lists information about the specified query logging configurations. Each configuration
defines where you want Resolver to save DNS query logs and specifies the VPCs that you want
to log queries for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An optional specification to return a subset of query logging
  configurations.  If you submit a second or subsequent ListResolverQueryLogConfigs request
  and specify the NextToken parameter, you must use the same values for Filters, if any, as
  in the previous request.
- `"MaxResults"`: The maximum number of query logging configurations that you want to
  return in the response to a ListResolverQueryLogConfigs request. If you don't specify a
  value for MaxResults, Resolver returns up to 100 query logging configurations.
- `"NextToken"`: For the first ListResolverQueryLogConfigs request, omit this value. If
  there are more than MaxResults query logging configurations that match the values that you
  specify for Filters, you can submit another ListResolverQueryLogConfigs request to get the
  next group of configurations. In the next request, specify the value of NextToken from the
  previous response.
- `"SortBy"`: The element that you want Resolver to sort query logging configurations by.
  If you submit a second or subsequent ListResolverQueryLogConfigs request and specify the
  NextToken parameter, you must use the same value for SortBy, if any, as in the previous
  request.  Valid values include the following elements:    Arn: The ARN of the query logging
  configuration    AssociationCount: The number of VPCs that are associated with the
  specified configuration     CreationTime: The date and time that Resolver returned when the
  configuration was created    CreatorRequestId: The value that was specified for
  CreatorRequestId when the configuration was created    DestinationArn: The location that
  logs are sent to    Id: The ID of the configuration    Name: The name of the configuration
    OwnerId: The Amazon Web Services account number of the account that created the
  configuration    ShareStatus: Whether the configuration is shared with other Amazon Web
  Services accounts or shared with the current account by another Amazon Web Services
  account. Sharing is configured through Resource Access Manager (RAM).    Status: The
  current status of the configuration. Valid values include the following:    CREATING:
  Resolver is creating the query logging configuration.    CREATED: The query logging
  configuration was successfully created. Resolver is logging queries that originate in the
  specified VPC.    DELETING: Resolver is deleting this query logging configuration.
  FAILED: Resolver either couldn't create or couldn't delete the query logging configuration.
  Here are two common causes:   The specified destination (for example, an Amazon S3 bucket)
  was deleted.   Permissions don't allow sending logs to the destination.
- `"SortOrder"`: If you specified a value for SortBy, the order that you want query logging
  configurations to be listed in, ASCENDING or DESCENDING.  If you submit a second or
  subsequent ListResolverQueryLogConfigs request and specify the NextToken parameter, you
  must use the same value for SortOrder, if any, as in the previous request.
"""
function list_resolver_query_log_configs(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListResolverQueryLogConfigs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_resolver_query_log_configs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListResolverQueryLogConfigs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resolver_rule_associations()
    list_resolver_rule_associations(params::Dict{String,<:Any})

Lists the associations that were created between Resolver rules and VPCs using the current
Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An optional specification to return a subset of Resolver rules, such as
  Resolver rules that are associated with the same VPC ID.  If you submit a second or
  subsequent ListResolverRuleAssociations request and specify the NextToken parameter, you
  must use the same values for Filters, if any, as in the previous request.
- `"MaxResults"`: The maximum number of rule associations that you want to return in the
  response to a ListResolverRuleAssociations request. If you don't specify a value for
  MaxResults, Resolver returns up to 100 rule associations.
- `"NextToken"`: For the first ListResolverRuleAssociation request, omit this value. If you
  have more than MaxResults rule associations, you can submit another
  ListResolverRuleAssociation request to get the next group of rule associations. In the next
  request, specify the value of NextToken from the previous response.
"""
function list_resolver_rule_associations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListResolverRuleAssociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_resolver_rule_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListResolverRuleAssociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resolver_rules()
    list_resolver_rules(params::Dict{String,<:Any})

Lists the Resolver rules that were created using the current Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: An optional specification to return a subset of Resolver rules, such as all
  Resolver rules that are associated with the same Resolver endpoint.  If you submit a second
  or subsequent ListResolverRules request and specify the NextToken parameter, you must use
  the same values for Filters, if any, as in the previous request.
- `"MaxResults"`: The maximum number of Resolver rules that you want to return in the
  response to a ListResolverRules request. If you don't specify a value for MaxResults,
  Resolver returns up to 100 Resolver rules.
- `"NextToken"`: For the first ListResolverRules request, omit this value. If you have more
  than MaxResults Resolver rules, you can submit another ListResolverRules request to get the
  next group of Resolver rules. In the next request, specify the value of NextToken from the
  previous response.
"""
function list_resolver_rules(; aws_config::AbstractAWSConfig=current_aws_config())
    return route53resolver(
        "ListResolverRules"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_resolver_rules(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListResolverRules", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags that you associated with the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) for the resource that you want to list
  tags for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of tags that you want to return in the response to a
  ListTagsForResource request. If you don't specify a value for MaxResults, Resolver returns
  up to 100 tags.
- `"NextToken"`: For the first ListTagsForResource request, omit this value. If you have
  more than MaxResults tags, you can submit another ListTagsForResource request to get the
  next group of tags for the resource. In the next request, specify the value of NextToken
  from the previous response.
"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "ListTagsForResource",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_firewall_rule_group_policy(arn, firewall_rule_group_policy)
    put_firewall_rule_group_policy(arn, firewall_rule_group_policy, params::Dict{String,<:Any})

Attaches an Identity and Access Management (Amazon Web Services IAM) policy for sharing the
rule group. You can use the policy to share the rule group using Resource Access Manager
(RAM).

# Arguments
- `arn`: The ARN (Amazon Resource Name) for the rule group that you want to share.
- `firewall_rule_group_policy`: The Identity and Access Management (Amazon Web Services
  IAM) policy to attach to the rule group.

"""
function put_firewall_rule_group_policy(
    Arn, FirewallRuleGroupPolicy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "PutFirewallRuleGroupPolicy",
        Dict{String,Any}(
            "Arn" => Arn, "FirewallRuleGroupPolicy" => FirewallRuleGroupPolicy
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_firewall_rule_group_policy(
    Arn,
    FirewallRuleGroupPolicy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "PutFirewallRuleGroupPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Arn" => Arn, "FirewallRuleGroupPolicy" => FirewallRuleGroupPolicy
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_resolver_query_log_config_policy(arn, resolver_query_log_config_policy)
    put_resolver_query_log_config_policy(arn, resolver_query_log_config_policy, params::Dict{String,<:Any})

Specifies an Amazon Web Services account that you want to share a query logging
configuration with, the query logging configuration that you want to share, and the
operations that you want the account to be able to perform on the configuration.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the account that you want to share rules with.
- `resolver_query_log_config_policy`: An Identity and Access Management policy statement
  that lists the query logging configurations that you want to share with another Amazon Web
  Services account and the operations that you want the account to be able to perform. You
  can specify the following operations in the Actions section of the statement:
  route53resolver:AssociateResolverQueryLogConfig
  route53resolver:DisassociateResolverQueryLogConfig
  route53resolver:ListResolverQueryLogConfigs    In the Resource section of the statement,
  you specify the ARNs for the query logging configurations that you want to share with the
  account that you specified in Arn.

"""
function put_resolver_query_log_config_policy(
    Arn, ResolverQueryLogConfigPolicy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "PutResolverQueryLogConfigPolicy",
        Dict{String,Any}(
            "Arn" => Arn, "ResolverQueryLogConfigPolicy" => ResolverQueryLogConfigPolicy
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_resolver_query_log_config_policy(
    Arn,
    ResolverQueryLogConfigPolicy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "PutResolverQueryLogConfigPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Arn" => Arn,
                    "ResolverQueryLogConfigPolicy" => ResolverQueryLogConfigPolicy,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_resolver_rule_policy(arn, resolver_rule_policy)
    put_resolver_rule_policy(arn, resolver_rule_policy, params::Dict{String,<:Any})

Specifies an Amazon Web Services rule that you want to share with another account, the
account that you want to share the rule with, and the operations that you want the account
to be able to perform on the rule.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the rule that you want to share with another
  account.
- `resolver_rule_policy`: An Identity and Access Management policy statement that lists the
  rules that you want to share with another Amazon Web Services account and the operations
  that you want the account to be able to perform. You can specify the following operations
  in the Action section of the statement:    route53resolver:GetResolverRule
  route53resolver:AssociateResolverRule     route53resolver:DisassociateResolverRule
  route53resolver:ListResolverRules     route53resolver:ListResolverRuleAssociations    In
  the Resource section of the statement, specify the ARN for the rule that you want to share
  with another account. Specify the same ARN that you specified in Arn.

"""
function put_resolver_rule_policy(
    Arn, ResolverRulePolicy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "PutResolverRulePolicy",
        Dict{String,Any}("Arn" => Arn, "ResolverRulePolicy" => ResolverRulePolicy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_resolver_rule_policy(
    Arn,
    ResolverRulePolicy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "PutResolverRulePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Arn" => Arn, "ResolverRulePolicy" => ResolverRulePolicy),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds one or more tags to a specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) for the resource that you want to add tags
  to. To get the ARN for a resource, use the applicable Get or List command:
  GetResolverEndpoint     GetResolverRule     GetResolverRuleAssociation
  ListResolverEndpoints     ListResolverRuleAssociations     ListResolverRules
- `tags`: The tags that you want to add to the specified resource.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return route53resolver(
        "TagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags from a specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) for the resource that you want to remove
  tags from. To get the ARN for a resource, use the applicable Get or List command:
  GetResolverEndpoint     GetResolverRule     GetResolverRuleAssociation
  ListResolverEndpoints     ListResolverRuleAssociations     ListResolverRules
- `tag_keys`: The tags that you want to remove to the specified resource.

"""
function untag_resource(
    ResourceArn, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "UntagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_firewall_config(firewall_fail_open, resource_id)
    update_firewall_config(firewall_fail_open, resource_id, params::Dict{String,<:Any})

Updates the configuration of the firewall behavior provided by DNS Firewall for a single
VPC from Amazon Virtual Private Cloud (Amazon VPC).

# Arguments
- `firewall_fail_open`: Determines how Route 53 Resolver handles queries during failures,
  for example when all traffic that is sent to DNS Firewall fails to receive a reply.    By
  default, fail open is disabled, which means the failure mode is closed. This approach
  favors security over availability. DNS Firewall blocks queries that it is unable to
  evaluate properly.    If you enable this option, the failure mode is open. This approach
  favors availability over security. DNS Firewall allows queries to proceed if it is unable
  to properly evaluate them.    This behavior is only enforced for VPCs that have at least
  one DNS Firewall rule group association.
- `resource_id`: The ID of the VPC that the configuration is for.

"""
function update_firewall_config(
    FirewallFailOpen, ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "UpdateFirewallConfig",
        Dict{String,Any}(
            "FirewallFailOpen" => FirewallFailOpen, "ResourceId" => ResourceId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_firewall_config(
    FirewallFailOpen,
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "UpdateFirewallConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FirewallFailOpen" => FirewallFailOpen, "ResourceId" => ResourceId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_firewall_domains(domains, firewall_domain_list_id, operation)
    update_firewall_domains(domains, firewall_domain_list_id, operation, params::Dict{String,<:Any})

Updates the firewall domain list from an array of domain specifications.

# Arguments
- `domains`: A list of domains to use in the update operation.  There is a limit of 1000
  domains per request.  Each domain specification in your domain list must satisfy the
  following requirements:    It can optionally start with * (asterisk).   With the exception
  of the optional starting asterisk, it must only contain the following characters: A-Z, a-z,
  0-9, - (hyphen).   It must be from 1-255 characters in length.
- `firewall_domain_list_id`: The ID of the domain list whose domains you want to update.
- `operation`: What you want DNS Firewall to do with the domains that you are providing:
   ADD - Add the domains to the ones that are already in the domain list.     REMOVE - Search
  the domain list for the domains and remove them from the list.    REPLACE - Update the
  domain list to exactly match the list that you are providing.

"""
function update_firewall_domains(
    Domains,
    FirewallDomainListId,
    Operation;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "UpdateFirewallDomains",
        Dict{String,Any}(
            "Domains" => Domains,
            "FirewallDomainListId" => FirewallDomainListId,
            "Operation" => Operation,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_firewall_domains(
    Domains,
    FirewallDomainListId,
    Operation,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "UpdateFirewallDomains",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Domains" => Domains,
                    "FirewallDomainListId" => FirewallDomainListId,
                    "Operation" => Operation,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_firewall_rule(firewall_domain_list_id, firewall_rule_group_id)
    update_firewall_rule(firewall_domain_list_id, firewall_rule_group_id, params::Dict{String,<:Any})

Updates the specified firewall rule.

# Arguments
- `firewall_domain_list_id`: The ID of the domain list to use in the rule.
- `firewall_rule_group_id`: The unique identifier of the firewall rule group for the rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Action"`: The action that DNS Firewall should take on a DNS query when it matches one
  of the domains in the rule's domain list:    ALLOW - Permit the request to go through.
  ALERT - Permit the request to go through but send an alert to the logs.    BLOCK - Disallow
  the request. This option requires additional details in the rule's BlockResponse.
- `"BlockOverrideDnsType"`: The DNS record's type. This determines the format of the record
  value that you provided in BlockOverrideDomain. Used for the rule action BLOCK with a
  BlockResponse setting of OVERRIDE.
- `"BlockOverrideDomain"`: The custom DNS record to send back in response to the query.
  Used for the rule action BLOCK with a BlockResponse setting of OVERRIDE.
- `"BlockOverrideTtl"`: The recommended amount of time, in seconds, for the DNS resolver or
  web browser to cache the provided override record. Used for the rule action BLOCK with a
  BlockResponse setting of OVERRIDE.
- `"BlockResponse"`: The way that you want DNS Firewall to block the request. Used for the
  rule action setting BLOCK.    NODATA - Respond indicating that the query was successful,
  but no response is available for it.    NXDOMAIN - Respond indicating that the domain name
  that's in the query doesn't exist.    OVERRIDE - Provide a custom override in the response.
  This option requires custom handling details in the rule's BlockOverride* settings.
- `"FirewallDomainRedirectionAction"`:  How you want the the rule to evaluate DNS
  redirection in the DNS redirection chain, such as CNAME or DNAME.
  Inspect_Redirection_Domain (Default) inspects all domains in the redirection chain. The
  individual domains in the redirection chain must be added to the domain list.
  Trust_Redirection_Domain  inspects only the first domain in the redirection chain. You
  don't need to add the subsequent domains in the domain in the redirection list to the
  domain list.
- `"Name"`: The name of the rule.
- `"Priority"`: The setting that determines the processing order of the rule in the rule
  group. DNS Firewall processes the rules in a rule group by order of priority, starting from
  the lowest setting. You must specify a unique priority for each rule in a rule group. To
  make it easier to insert rules later, leave space between the numbers, for example, use
  100, 200, and so on. You can change the priority setting for the rules in a rule group at
  any time.
- `"Qtype"`:  The DNS query type you want the rule to evaluate. Allowed values are;     A:
  Returns an IPv4 address.   AAAA: Returns an Ipv6 address.   CAA: Restricts CAs that can
  create SSL/TLS certifications for the domain.   CNAME: Returns another domain name.   DS:
  Record that identifies the DNSSEC signing key of a delegated zone.   MX: Specifies mail
  servers.   NAPTR: Regular-expression-based rewriting of domain names.   NS: Authoritative
  name servers.   PTR: Maps an IP address to a domain name.   SOA: Start of authority record
  for the zone.   SPF: Lists the servers authorized to send emails from a domain.   SRV:
  Application specific values that identify servers.   TXT: Verifies email senders and
  application-specific values.   A query type you define by using the DNS type ID, for
  example 28 for AAAA. The values must be defined as TYPENUMBER, where the NUMBER can be
  1-65334, for example, TYPE28. For more information, see List of DNS record types.
"""
function update_firewall_rule(
    FirewallDomainListId,
    FirewallRuleGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "UpdateFirewallRule",
        Dict{String,Any}(
            "FirewallDomainListId" => FirewallDomainListId,
            "FirewallRuleGroupId" => FirewallRuleGroupId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_firewall_rule(
    FirewallDomainListId,
    FirewallRuleGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "UpdateFirewallRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FirewallDomainListId" => FirewallDomainListId,
                    "FirewallRuleGroupId" => FirewallRuleGroupId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_firewall_rule_group_association(firewall_rule_group_association_id)
    update_firewall_rule_group_association(firewall_rule_group_association_id, params::Dict{String,<:Any})

Changes the association of a FirewallRuleGroup with a VPC. The association enables DNS
filtering for the VPC.

# Arguments
- `firewall_rule_group_association_id`: The identifier of the FirewallRuleGroupAssociation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MutationProtection"`: If enabled, this setting disallows modification or removal of the
  association, to help prevent against accidentally altering DNS firewall protections.
- `"Name"`: The name of the rule group association.
- `"Priority"`: The setting that determines the processing order of the rule group among
  the rule groups that you associate with the specified VPC. DNS Firewall filters VPC traffic
  starting from the rule group with the lowest numeric priority setting.  You must specify a
  unique priority for each rule group that you associate with a single VPC. To make it easier
  to insert rule groups later, leave space between the numbers, for example, use 100, 200,
  and so on. You can change the priority setting for a rule group association after you
  create it.
"""
function update_firewall_rule_group_association(
    FirewallRuleGroupAssociationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "UpdateFirewallRuleGroupAssociation",
        Dict{String,Any}(
            "FirewallRuleGroupAssociationId" => FirewallRuleGroupAssociationId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_firewall_rule_group_association(
    FirewallRuleGroupAssociationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "UpdateFirewallRuleGroupAssociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FirewallRuleGroupAssociationId" => FirewallRuleGroupAssociationId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_outpost_resolver(id)
    update_outpost_resolver(id, params::Dict{String,<:Any})

You can use UpdateOutpostResolver to update the instance count, type, or name of a Resolver
on an Outpost.

# Arguments
- `id`: A unique string that identifies Resolver on an Outpost.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"InstanceCount"`: The Amazon EC2 instance count for a Resolver on the Outpost.
- `"Name"`: Name of the Resolver on the Outpost.
- `"PreferredInstanceType"`:  Amazon EC2 instance type.
"""
function update_outpost_resolver(Id; aws_config::AbstractAWSConfig=current_aws_config())
    return route53resolver(
        "UpdateOutpostResolver",
        Dict{String,Any}("Id" => Id);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_outpost_resolver(
    Id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "UpdateOutpostResolver",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Id" => Id), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_resolver_config(autodefined_reverse_flag, resource_id)
    update_resolver_config(autodefined_reverse_flag, resource_id, params::Dict{String,<:Any})

Updates the behavior configuration of Route 53 Resolver behavior for a single VPC from
Amazon Virtual Private Cloud.

# Arguments
- `autodefined_reverse_flag`: Indicates whether or not the Resolver will create autodefined
  rules for reverse DNS lookups. This is enabled by default. Disabling this option will also
  affect EC2-Classic instances using ClassicLink. For more information, see ClassicLink in
  the Amazon EC2 guide.  We are retiring EC2-Classic on August 15, 2022. We recommend that
  you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic
  to a VPC in the Amazon EC2 guide and the blog EC2-Classic Networking is Retiring –
  Here’s How to Prepare.   It can take some time for the status change to be completed.
- `resource_id`: Resource ID of the Amazon VPC that you want to update the Resolver
  configuration for.

"""
function update_resolver_config(
    AutodefinedReverseFlag, ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "UpdateResolverConfig",
        Dict{String,Any}(
            "AutodefinedReverseFlag" => AutodefinedReverseFlag, "ResourceId" => ResourceId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_resolver_config(
    AutodefinedReverseFlag,
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "UpdateResolverConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AutodefinedReverseFlag" => AutodefinedReverseFlag,
                    "ResourceId" => ResourceId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_resolver_dnssec_config(resource_id, validation)
    update_resolver_dnssec_config(resource_id, validation, params::Dict{String,<:Any})

Updates an existing DNSSEC validation configuration. If there is no existing DNSSEC
validation configuration, one is created.

# Arguments
- `resource_id`: The ID of the virtual private cloud (VPC) that you're updating the DNSSEC
  validation status for.
- `validation`: The new value that you are specifying for DNSSEC validation for the VPC.
  The value can be ENABLE or DISABLE. Be aware that it can take time for a validation status
  change to be completed.

"""
function update_resolver_dnssec_config(
    ResourceId, Validation; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "UpdateResolverDnssecConfig",
        Dict{String,Any}("ResourceId" => ResourceId, "Validation" => Validation);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_resolver_dnssec_config(
    ResourceId,
    Validation,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "UpdateResolverDnssecConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceId" => ResourceId, "Validation" => Validation),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_resolver_endpoint(resolver_endpoint_id)
    update_resolver_endpoint(resolver_endpoint_id, params::Dict{String,<:Any})

Updates the name, or endpoint type for an inbound or an outbound Resolver endpoint. You can
only update between IPV4 and DUALSTACK, IPV6 endpoint type can't be updated to other type.

# Arguments
- `resolver_endpoint_id`: The ID of the Resolver endpoint that you want to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Name"`: The name of the Resolver endpoint that you want to update.
- `"Protocols"`:  The protocols you want to use for the endpoint. DoH-FIPS is applicable
  for inbound endpoints only.  For an inbound endpoint you can apply the protocols as
  follows:    Do53 and DoH in combination.   Do53 and DoH-FIPS in combination.   Do53 alone.
   DoH alone.   DoH-FIPS alone.   None, which is treated as Do53.   For an outbound endpoint
  you can apply the protocols as follows:    Do53 and DoH in combination.   Do53 alone.   DoH
  alone.   None, which is treated as Do53.     You can't change the protocol of an inbound
  endpoint directly from only Do53 to only DoH, or DoH-FIPS. This is to prevent a sudden
  disruption to incoming traffic that relies on Do53. To change the protocol from Do53 to
  DoH, or DoH-FIPS, you must first enable both Do53 and DoH, or Do53 and DoH-FIPS, to make
  sure that all incoming traffic has transferred to using the DoH protocol, or DoH-FIPS, and
  then remove the Do53.
- `"ResolverEndpointType"`:  Specifies the endpoint type for what type of IP address the
  endpoint uses to forward DNS queries.  Updating to IPV6 type isn't currently supported.
- `"UpdateIpAddresses"`:  Specifies the IPv6 address when you update the Resolver endpoint
  from IPv4 to dual-stack. If you don't specify an IPv6 address, one will be automatically
  chosen from your subnet.
"""
function update_resolver_endpoint(
    ResolverEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "UpdateResolverEndpoint",
        Dict{String,Any}("ResolverEndpointId" => ResolverEndpointId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_resolver_endpoint(
    ResolverEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "UpdateResolverEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ResolverEndpointId" => ResolverEndpointId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_resolver_rule(config, resolver_rule_id)
    update_resolver_rule(config, resolver_rule_id, params::Dict{String,<:Any})

Updates settings for a specified Resolver rule. ResolverRuleId is required, and all other
parameters are optional. If you don't specify a parameter, it retains its current value.

# Arguments
- `config`: The new settings for the Resolver rule.
- `resolver_rule_id`: The ID of the Resolver rule that you want to update.

"""
function update_resolver_rule(
    Config, ResolverRuleId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53resolver(
        "UpdateResolverRule",
        Dict{String,Any}("Config" => Config, "ResolverRuleId" => ResolverRuleId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_resolver_rule(
    Config,
    ResolverRuleId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53resolver(
        "UpdateResolverRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Config" => Config, "ResolverRuleId" => ResolverRuleId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
