# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: route_53_domains
using AWS.Compat
using AWS.UUIDs

"""
    accept_domain_transfer_from_another_aws_account(domain_name, password)
    accept_domain_transfer_from_another_aws_account(domain_name, password, params::Dict{String,<:Any})

Accepts the transfer of a domain from another Amazon Web Services account to the
currentAmazon Web Services account. You initiate a transfer between Amazon Web Services
accounts using TransferDomainToAnotherAwsAccount. If you use the CLI command at
accept-domain-transfer-from-another-aws-account, use JSON format as input instead of text
because otherwise CLI will throw an error from domain transfer input that includes single
quotes. Use either ListOperations or GetOperationDetail to determine whether the operation
succeeded. GetOperationDetail provides additional information, for example, Domain Transfer
from Aws Account 111122223333 has been cancelled.

# Arguments
- `domain_name`: The name of the domain that was specified when another Amazon Web Services
  account submitted a TransferDomainToAnotherAwsAccount request.
- `password`: The password that was returned by the TransferDomainToAnotherAwsAccount
  request.

"""
function accept_domain_transfer_from_another_aws_account(
    DomainName, Password; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "AcceptDomainTransferFromAnotherAwsAccount",
        Dict{String,Any}("DomainName" => DomainName, "Password" => Password);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_domain_transfer_from_another_aws_account(
    DomainName,
    Password,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "AcceptDomainTransferFromAnotherAwsAccount",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DomainName" => DomainName, "Password" => Password),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_delegation_signer_to_domain(domain_name, signing_attributes)
    associate_delegation_signer_to_domain(domain_name, signing_attributes, params::Dict{String,<:Any})

 Creates a delegation signer (DS) record in the registry zone for this domain name. Note
that creating DS record at the registry impacts DNSSEC validation of your DNS records. This
action may render your domain name unavailable on the internet if the steps are completed
in the wrong order, or with incorrect timing. For more information about DNSSEC signing,
see Configuring DNSSEC signing in the Route 53 developer guide.

# Arguments
- `domain_name`: The name of the domain.
- `signing_attributes`: The information about a key, including the algorithm, public
  key-value, and flags.

"""
function associate_delegation_signer_to_domain(
    DomainName, SigningAttributes; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "AssociateDelegationSignerToDomain",
        Dict{String,Any}(
            "DomainName" => DomainName, "SigningAttributes" => SigningAttributes
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_delegation_signer_to_domain(
    DomainName,
    SigningAttributes,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "AssociateDelegationSignerToDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DomainName" => DomainName, "SigningAttributes" => SigningAttributes
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_domain_transfer_to_another_aws_account(domain_name)
    cancel_domain_transfer_to_another_aws_account(domain_name, params::Dict{String,<:Any})

Cancels the transfer of a domain from the current Amazon Web Services account to another
Amazon Web Services account. You initiate a transfer betweenAmazon Web Services accounts
using TransferDomainToAnotherAwsAccount.   You must cancel the transfer before the other
Amazon Web Services account accepts the transfer using
AcceptDomainTransferFromAnotherAwsAccount.  Use either ListOperations or GetOperationDetail
to determine whether the operation succeeded. GetOperationDetail provides additional
information, for example, Domain Transfer from Aws Account 111122223333 has been cancelled.

# Arguments
- `domain_name`: The name of the domain for which you want to cancel the transfer to
  another Amazon Web Services account.

"""
function cancel_domain_transfer_to_another_aws_account(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "CancelDomainTransferToAnotherAwsAccount",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_domain_transfer_to_another_aws_account(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "CancelDomainTransferToAnotherAwsAccount",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    check_domain_availability(domain_name)
    check_domain_availability(domain_name, params::Dict{String,<:Any})

This operation checks the availability of one domain name. Note that if the availability
status of a domain is pending, you must submit another request to determine the
availability of the domain name.

# Arguments
- `domain_name`: The name of the domain that you want to get availability for. The
  top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of
  supported TLDs, see Domains that You Can Register with Amazon Route 53 in the Amazon Route
  53 Developer Guide. The domain name can contain only the following characters:   Letters a
  through z. Domain names are not case sensitive.   Numbers 0 through 9.   Hyphen (-). You
  can't specify a hyphen at the beginning or end of a label.    Period (.) to separate the
  labels in the name, such as the . in example.com.   Internationalized domain names are not
  supported for some top-level domains. To determine whether the TLD that you want to use
  supports internationalized domain names, see Domains that You Can Register with Amazon
  Route 53. For more information, see Formatting Internationalized Domain Names.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IdnLangCode"`: Reserved for future use.
"""
function check_domain_availability(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "CheckDomainAvailability",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function check_domain_availability(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "CheckDomainAvailability",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    check_domain_transferability(domain_name)
    check_domain_transferability(domain_name, params::Dict{String,<:Any})

Checks whether a domain name can be transferred to Amazon Route 53.

# Arguments
- `domain_name`: The name of the domain that you want to transfer to Route 53. The
  top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of
  supported TLDs, see Domains that You Can Register with Amazon Route 53 in the Amazon Route
  53 Developer Guide. The domain name can contain only the following characters:   Letters a
  through z. Domain names are not case sensitive.   Numbers 0 through 9.   Hyphen (-). You
  can't specify a hyphen at the beginning or end of a label.    Period (.) to separate the
  labels in the name, such as the . in example.com.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuthCode"`: If the registrar for the top-level domain (TLD) requires an authorization
  code to transfer the domain, the code that you got from the current registrar for the
  domain.
"""
function check_domain_transferability(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "CheckDomainTransferability",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function check_domain_transferability(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "CheckDomainTransferability",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_domain(domain_name)
    delete_domain(domain_name, params::Dict{String,<:Any})

This operation deletes the specified domain. This action is permanent. For more
information, see Deleting a domain name registration. To transfer the domain registration
to another registrar, use the transfer process that’s provided by the registrar to which
you want to transfer the registration. Otherwise, the following apply:   You can’t get a
refund for the cost of a deleted domain registration.   The registry for the top-level
domain might hold the domain name for a brief time before releasing it for other users to
register (varies by registry).    When the registration has been deleted, we'll send you a
confirmation to the registrant contact. The email will come from
noreply@domainnameverification.net or noreply@registrar.amazon.com.

# Arguments
- `domain_name`: Name of the domain to be deleted.

"""
function delete_domain(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return route_53_domains(
        "DeleteDomain",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_domain(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "DeleteDomain",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_tags_for_domain(domain_name, tags_to_delete)
    delete_tags_for_domain(domain_name, tags_to_delete, params::Dict{String,<:Any})

This operation deletes the specified tags for a domain. All tag operations are eventually
consistent; subsequent operations might not immediately represent all issued operations.

# Arguments
- `domain_name`: The domain for which you want to delete one or more tags.
- `tags_to_delete`: A list of tag keys to delete.

"""
function delete_tags_for_domain(
    DomainName, TagsToDelete; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "DeleteTagsForDomain",
        Dict{String,Any}("DomainName" => DomainName, "TagsToDelete" => TagsToDelete);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_tags_for_domain(
    DomainName,
    TagsToDelete,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "DeleteTagsForDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DomainName" => DomainName, "TagsToDelete" => TagsToDelete
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_domain_auto_renew(domain_name)
    disable_domain_auto_renew(domain_name, params::Dict{String,<:Any})

This operation disables automatic renewal of domain registration for the specified domain.

# Arguments
- `domain_name`: The name of the domain that you want to disable automatic renewal for.

"""
function disable_domain_auto_renew(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "DisableDomainAutoRenew",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_domain_auto_renew(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "DisableDomainAutoRenew",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_domain_transfer_lock(domain_name)
    disable_domain_transfer_lock(domain_name, params::Dict{String,<:Any})

This operation removes the transfer lock on the domain (specifically the
clientTransferProhibited status) to allow domain transfers. We recommend you refrain from
performing this action unless you intend to transfer the domain to a different registrar.
Successful submission returns an operation ID that you can use to track the progress and
completion of the action. If the request is not completed successfully, the domain
registrant will be notified by email.

# Arguments
- `domain_name`: The name of the domain that you want to remove the transfer lock for.

"""
function disable_domain_transfer_lock(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "DisableDomainTransferLock",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_domain_transfer_lock(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "DisableDomainTransferLock",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_delegation_signer_from_domain(domain_name, id)
    disassociate_delegation_signer_from_domain(domain_name, id, params::Dict{String,<:Any})

Deletes a delegation signer (DS) record in the registry zone for this domain name.

# Arguments
- `domain_name`: Name of the domain.
- `id`: An internal identification number assigned to each DS record after it’s created.
  You can retrieve it as part of DNSSEC information returned by GetDomainDetail.

"""
function disassociate_delegation_signer_from_domain(
    DomainName, Id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "DisassociateDelegationSignerFromDomain",
        Dict{String,Any}("DomainName" => DomainName, "Id" => Id);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_delegation_signer_from_domain(
    DomainName,
    Id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "DisassociateDelegationSignerFromDomain",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("DomainName" => DomainName, "Id" => Id), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_domain_auto_renew(domain_name)
    enable_domain_auto_renew(domain_name, params::Dict{String,<:Any})

This operation configures Amazon Route 53 to automatically renew the specified domain
before the domain registration expires. The cost of renewing your domain registration is
billed to your Amazon Web Services account. The period during which you can renew a domain
name varies by TLD. For a list of TLDs and their renewal policies, see Domains That You Can
Register with Amazon Route 53 in the Amazon Route 53 Developer Guide. Route 53 requires
that you renew before the end of the renewal period so we can complete processing before
the deadline.

# Arguments
- `domain_name`: The name of the domain that you want to enable automatic renewal for.

"""
function enable_domain_auto_renew(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "EnableDomainAutoRenew",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_domain_auto_renew(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "EnableDomainAutoRenew",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_domain_transfer_lock(domain_name)
    enable_domain_transfer_lock(domain_name, params::Dict{String,<:Any})

This operation sets the transfer lock on the domain (specifically the
clientTransferProhibited status) to prevent domain transfers. Successful submission returns
an operation ID that you can use to track the progress and completion of the action. If the
request is not completed successfully, the domain registrant will be notified by email.

# Arguments
- `domain_name`: The name of the domain that you want to set the transfer lock for.

"""
function enable_domain_transfer_lock(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "EnableDomainTransferLock",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_domain_transfer_lock(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "EnableDomainTransferLock",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_contact_reachability_status()
    get_contact_reachability_status(params::Dict{String,<:Any})

For operations that require confirmation that the email address for the registrant contact
is valid, such as registering a new domain, this operation returns information about
whether the registrant contact has responded. If you want us to resend the email, use the
ResendContactReachabilityEmail operation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"domainName"`: The name of the domain for which you want to know whether the registrant
  contact has confirmed that the email address is valid.
"""
function get_contact_reachability_status(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "GetContactReachabilityStatus";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_contact_reachability_status(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "GetContactReachabilityStatus",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_domain_detail(domain_name)
    get_domain_detail(domain_name, params::Dict{String,<:Any})

This operation returns detailed information about a specified domain that is associated
with the current Amazon Web Services account. Contact information for the domain is also
returned as part of the output.

# Arguments
- `domain_name`: The name of the domain that you want to get detailed information about.

"""
function get_domain_detail(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return route_53_domains(
        "GetDomainDetail",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_domain_detail(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "GetDomainDetail",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_domain_suggestions(domain_name, only_available, suggestion_count)
    get_domain_suggestions(domain_name, only_available, suggestion_count, params::Dict{String,<:Any})

The GetDomainSuggestions operation returns a list of suggested domain names.

# Arguments
- `domain_name`: A domain name that you want to use as the basis for a list of possible
  domain names. The top-level domain (TLD), such as .com, must be a TLD that Route 53
  supports. For a list of supported TLDs, see Domains that You Can Register with Amazon Route
  53 in the Amazon Route 53 Developer Guide. The domain name can contain only the following
  characters:   Letters a through z. Domain names are not case sensitive.   Numbers 0 through
  9.   Hyphen (-). You can't specify a hyphen at the beginning or end of a label.    Period
  (.) to separate the labels in the name, such as the . in example.com.   Internationalized
  domain names are not supported for some top-level domains. To determine whether the TLD
  that you want to use supports internationalized domain names, see Domains that You Can
  Register with Amazon Route 53.
- `only_available`: If OnlyAvailable is true, Route 53 returns only domain names that are
  available. If OnlyAvailable is false, Route 53 returns domain names without checking
  whether they're available to be registered. To determine whether the domain is available,
  you can call checkDomainAvailability for each suggestion.
- `suggestion_count`: The number of suggested domain names that you want Route 53 to
  return. Specify a value between 1 and 50.

"""
function get_domain_suggestions(
    DomainName,
    OnlyAvailable,
    SuggestionCount;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "GetDomainSuggestions",
        Dict{String,Any}(
            "DomainName" => DomainName,
            "OnlyAvailable" => OnlyAvailable,
            "SuggestionCount" => SuggestionCount,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_domain_suggestions(
    DomainName,
    OnlyAvailable,
    SuggestionCount,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "GetDomainSuggestions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DomainName" => DomainName,
                    "OnlyAvailable" => OnlyAvailable,
                    "SuggestionCount" => SuggestionCount,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_operation_detail(operation_id)
    get_operation_detail(operation_id, params::Dict{String,<:Any})

This operation returns the current status of an operation that is not completed.

# Arguments
- `operation_id`: The identifier for the operation for which you want to get the status.
  Route 53 returned the identifier in the response to the original request.

"""
function get_operation_detail(
    OperationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "GetOperationDetail",
        Dict{String,Any}("OperationId" => OperationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_operation_detail(
    OperationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "GetOperationDetail",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("OperationId" => OperationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_domains()
    list_domains(params::Dict{String,<:Any})

This operation returns all the domain names registered with Amazon Route 53 for the current
Amazon Web Services account if no filtering conditions are used.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FilterConditions"`: A complex type that contains information about the filters applied
  during the ListDomains request. The filter conditions can include domain name and domain
  expiration.
- `"Marker"`: For an initial request for a list of domains, omit this element. If the
  number of domains that are associated with the current Amazon Web Services account is
  greater than the value that you specified for MaxItems, you can use Marker to return
  additional domains. Get the value of NextPageMarker from the previous response, and submit
  another request that includes the value of NextPageMarker in the Marker element.
  Constraints: The marker must match the value specified in the previous request.
- `"MaxItems"`: Number of domains to be returned. Default: 20
- `"SortCondition"`: A complex type that contains information about the requested ordering
  of domains in the returned list.
"""
function list_domains(; aws_config::AbstractAWSConfig=current_aws_config())
    return route_53_domains(
        "ListDomains"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_domains(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "ListDomains", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_operations()
    list_operations(params::Dict{String,<:Any})

Returns information about all of the operations that return an operation ID and that have
ever been performed on domains that were registered by the current account.  This command
runs only in the us-east-1 Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: For an initial request for a list of operations, omit this element. If the
  number of operations that are not yet complete is greater than the value that you specified
  for MaxItems, you can use Marker to return additional operations. Get the value of
  NextPageMarker from the previous response, and submit another request that includes the
  value of NextPageMarker in the Marker element.
- `"MaxItems"`: Number of domains to be returned. Default: 20
- `"SortBy"`:  The sort type for returned values.
- `"SortOrder"`:  The sort order for returned values, either ascending or descending.
- `"Status"`:  The status of the operations.
- `"SubmittedSince"`: An optional parameter that lets you get information about all the
  operations that you submitted after a specified date and time. Specify the date and time in
  Unix time format and Coordinated Universal time (UTC).
- `"Type"`:  An arrays of the domains operation types.
"""
function list_operations(; aws_config::AbstractAWSConfig=current_aws_config())
    return route_53_domains(
        "ListOperations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_operations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "ListOperations", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_prices()
    list_prices(params::Dict{String,<:Any})

Lists the following prices for either all the TLDs supported by Route 53, or the specified
TLD:   Registration   Transfer   Owner change   Domain renewal   Domain restoration

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: For an initial request for a list of prices, omit this element. If the number
  of prices that are not yet complete is greater than the value that you specified for
  MaxItems, you can use Marker to return additional prices. Get the value of NextPageMarker
  from the previous response, and submit another request that includes the value of
  NextPageMarker in the Marker element.  Used only for all TLDs. If you specify a TLD, don't
  specify a Marker.
- `"MaxItems"`: Number of Prices to be returned. Used only for all TLDs. If you specify a
  TLD, don't specify a MaxItems.
- `"Tld"`: The TLD for which you want to receive the pricing information. For example.
  .net. If a Tld value is not provided, a list of prices for all TLDs supported by Route 53
  is returned.
"""
function list_prices(; aws_config::AbstractAWSConfig=current_aws_config())
    return route_53_domains(
        "ListPrices"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_prices(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "ListPrices", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_domain(domain_name)
    list_tags_for_domain(domain_name, params::Dict{String,<:Any})

This operation returns all of the tags that are associated with the specified domain. All
tag operations are eventually consistent; subsequent operations might not immediately
represent all issued operations.

# Arguments
- `domain_name`: The domain for which you want to get a list of tags.

"""
function list_tags_for_domain(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "ListTagsForDomain",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_domain(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "ListTagsForDomain",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    push_domain(domain_name, target)
    push_domain(domain_name, target, params::Dict{String,<:Any})

 Moves a domain from Amazon Web Services to another registrar.  Supported actions:
Changes the IPS tags of a .uk domain, and pushes it to transit. Transit means that the
domain is ready to be transferred to another registrar.

# Arguments
- `domain_name`:  Name of the domain.
- `target`:  New IPS tag for the domain.

"""
function push_domain(DomainName, Target; aws_config::AbstractAWSConfig=current_aws_config())
    return route_53_domains(
        "PushDomain",
        Dict{String,Any}("DomainName" => DomainName, "Target" => Target);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function push_domain(
    DomainName,
    Target,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "PushDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DomainName" => DomainName, "Target" => Target),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_domain(admin_contact, domain_name, duration_in_years, registrant_contact, tech_contact)
    register_domain(admin_contact, domain_name, duration_in_years, registrant_contact, tech_contact, params::Dict{String,<:Any})

This operation registers a domain. For some top-level domains (TLDs), this operation
requires extra parameters. When you register a domain, Amazon Route 53 does the following:
 Creates a Route 53 hosted zone that has the same name as the domain. Route 53 assigns four
name servers to your hosted zone and automatically updates your domain registration with
the names of these name servers.   Enables auto renew, so your domain registration will
renew automatically each year. We'll notify you in advance of the renewal date so you can
choose whether to renew the registration.   Optionally enables privacy protection, so WHOIS
queries return contact for the registrar or the phrase \"REDACTED FOR PRIVACY\", or \"On
behalf of &lt;domain name&gt; owner.\" If you don't enable privacy protection, WHOIS
queries return the information that you entered for the administrative, registrant, and
technical contacts.  While some domains may allow different privacy settings per contact,
we recommend specifying the same privacy setting for all contacts.    If registration is
successful, returns an operation ID that you can use to track the progress and completion
of the action. If the request is not completed successfully, the domain registrant is
notified by email.   Charges your Amazon Web Services account an amount based on the
top-level domain. For more information, see Amazon Route 53 Pricing.

# Arguments
- `admin_contact`: Provides detailed contact information. For information about the values
  that you specify for each element, see ContactDetail.
- `domain_name`: The domain name that you want to register. The top-level domain (TLD),
  such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see
  Domains that You Can Register with Amazon Route 53 in the Amazon Route 53 Developer Guide.
  The domain name can contain only the following characters:   Letters a through z. Domain
  names are not case sensitive.   Numbers 0 through 9.   Hyphen (-). You can't specify a
  hyphen at the beginning or end of a label.    Period (.) to separate the labels in the
  name, such as the . in example.com.   Internationalized domain names are not supported for
  some top-level domains. To determine whether the TLD that you want to use supports
  internationalized domain names, see Domains that You Can Register with Amazon Route 53. For
  more information, see Formatting Internationalized Domain Names.
- `duration_in_years`: The number of years that you want to register the domain for.
  Domains are registered for a minimum of one year. The maximum period depends on the
  top-level domain. For the range of valid values for your domain, see Domains that You Can
  Register with Amazon Route 53 in the Amazon Route 53 Developer Guide. Default: 1
- `registrant_contact`: Provides detailed contact information. For information about the
  values that you specify for each element, see ContactDetail.
- `tech_contact`: Provides detailed contact information. For information about the values
  that you specify for each element, see ContactDetail.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AutoRenew"`: Indicates whether the domain will be automatically renewed (true) or not
  (false). Auto renewal only takes effect after the account is charged. Default: true
- `"BillingContact"`: Provides detailed contact information. For information about the
  values that you specify for each element, see ContactDetail.
- `"IdnLangCode"`: Reserved for future use.
- `"PrivacyProtectAdminContact"`: Whether you want to conceal contact information from
  WHOIS queries. If you specify true, WHOIS (\"who is\") queries return contact information
  either for Amazon Registrar or for our registrar associate, Gandi. If you specify false,
  WHOIS queries return the information that you entered for the admin contact.  You must
  specify the same privacy setting for the administrative, billing, registrant, and technical
  contacts.  Default: true
- `"PrivacyProtectBillingContact"`: Whether you want to conceal contact information from
  WHOIS queries. If you specify true, WHOIS (\"who is\") queries return contact information
  either for Amazon Registrar or for our registrar associate, Gandi. If you specify false,
  WHOIS queries return the information that you entered for the billing contact.  You must
  specify the same privacy setting for the administrative, billing, registrant, and technical
  contacts.
- `"PrivacyProtectRegistrantContact"`: Whether you want to conceal contact information from
  WHOIS queries. If you specify true, WHOIS (\"who is\") queries return contact information
  either for Amazon Registrar or for our registrar associate, Gandi. If you specify false,
  WHOIS queries return the information that you entered for the registrant contact (the
  domain owner).  You must specify the same privacy setting for the administrative, billing,
  registrant, and technical contacts.  Default: true
- `"PrivacyProtectTechContact"`: Whether you want to conceal contact information from WHOIS
  queries. If you specify true, WHOIS (\"who is\") queries return contact information either
  for Amazon Registrar or for our registrar associate, Gandi. If you specify false, WHOIS
  queries return the information that you entered for the technical contact.  You must
  specify the same privacy setting for the administrative, billing, registrant, and technical
  contacts.  Default: true
"""
function register_domain(
    AdminContact,
    DomainName,
    DurationInYears,
    RegistrantContact,
    TechContact;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "RegisterDomain",
        Dict{String,Any}(
            "AdminContact" => AdminContact,
            "DomainName" => DomainName,
            "DurationInYears" => DurationInYears,
            "RegistrantContact" => RegistrantContact,
            "TechContact" => TechContact,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_domain(
    AdminContact,
    DomainName,
    DurationInYears,
    RegistrantContact,
    TechContact,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "RegisterDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AdminContact" => AdminContact,
                    "DomainName" => DomainName,
                    "DurationInYears" => DurationInYears,
                    "RegistrantContact" => RegistrantContact,
                    "TechContact" => TechContact,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reject_domain_transfer_from_another_aws_account(domain_name)
    reject_domain_transfer_from_another_aws_account(domain_name, params::Dict{String,<:Any})

Rejects the transfer of a domain from another Amazon Web Services account to the current
Amazon Web Services account. You initiate a transfer betweenAmazon Web Services accounts
using TransferDomainToAnotherAwsAccount.  Use either ListOperations or GetOperationDetail
to determine whether the operation succeeded. GetOperationDetail provides additional
information, for example, Domain Transfer from Aws Account 111122223333 has been cancelled.

# Arguments
- `domain_name`: The name of the domain that was specified when another Amazon Web Services
  account submitted a TransferDomainToAnotherAwsAccount request.

"""
function reject_domain_transfer_from_another_aws_account(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "RejectDomainTransferFromAnotherAwsAccount",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reject_domain_transfer_from_another_aws_account(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "RejectDomainTransferFromAnotherAwsAccount",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    renew_domain(current_expiry_year, domain_name)
    renew_domain(current_expiry_year, domain_name, params::Dict{String,<:Any})

This operation renews a domain for the specified number of years. The cost of renewing your
domain is billed to your Amazon Web Services account. We recommend that you renew your
domain several weeks before the expiration date. Some TLD registries delete domains before
the expiration date if you haven't renewed far enough in advance. For more information
about renewing domain registration, see Renewing Registration for a Domain in the Amazon
Route 53 Developer Guide.

# Arguments
- `current_expiry_year`: The year when the registration for the domain is set to expire.
  This value must match the current expiration date for the domain.
- `domain_name`: The name of the domain that you want to renew.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DurationInYears"`: The number of years that you want to renew the domain for. The
  maximum number of years depends on the top-level domain. For the range of valid values for
  your domain, see Domains that You Can Register with Amazon Route 53 in the Amazon Route 53
  Developer Guide. Default: 1
"""
function renew_domain(
    CurrentExpiryYear, DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "RenewDomain",
        Dict{String,Any}(
            "CurrentExpiryYear" => CurrentExpiryYear, "DomainName" => DomainName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function renew_domain(
    CurrentExpiryYear,
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "RenewDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CurrentExpiryYear" => CurrentExpiryYear, "DomainName" => DomainName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    resend_contact_reachability_email()
    resend_contact_reachability_email(params::Dict{String,<:Any})

For operations that require confirmation that the email address for the registrant contact
is valid, such as registering a new domain, this operation resends the confirmation email
to the current email address for the registrant contact.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"domainName"`: The name of the domain for which you want Route 53 to resend a
  confirmation email to the registrant contact.
"""
function resend_contact_reachability_email(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "ResendContactReachabilityEmail";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function resend_contact_reachability_email(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "ResendContactReachabilityEmail",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    resend_operation_authorization(operation_id)
    resend_operation_authorization(operation_id, params::Dict{String,<:Any})

 Resend the form of authorization email for this operation.

# Arguments
- `operation_id`:  Operation ID.

"""
function resend_operation_authorization(
    OperationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "ResendOperationAuthorization",
        Dict{String,Any}("OperationId" => OperationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function resend_operation_authorization(
    OperationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "ResendOperationAuthorization",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("OperationId" => OperationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    retrieve_domain_auth_code(domain_name)
    retrieve_domain_auth_code(domain_name, params::Dict{String,<:Any})

This operation returns the authorization code for the domain. To transfer a domain to
another registrar, you provide this value to the new registrar.

# Arguments
- `domain_name`: The name of the domain that you want to get an authorization code for.

"""
function retrieve_domain_auth_code(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "RetrieveDomainAuthCode",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function retrieve_domain_auth_code(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "RetrieveDomainAuthCode",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    transfer_domain(admin_contact, domain_name, duration_in_years, registrant_contact, tech_contact)
    transfer_domain(admin_contact, domain_name, duration_in_years, registrant_contact, tech_contact, params::Dict{String,<:Any})

Transfers a domain from another registrar to Amazon Route 53.  For more information about
transferring domains, see the following topics:   For transfer requirements, a detailed
procedure, and information about viewing the status of a domain that you're transferring to
Route 53, see Transferring Registration for a Domain to Amazon Route 53 in the Amazon Route
53 Developer Guide.   For information about how to transfer a domain from one Amazon Web
Services account to another, see TransferDomainToAnotherAwsAccount.    For information
about how to transfer a domain to another domain registrar, see Transferring a Domain from
Amazon Route 53 to Another Registrar in the Amazon Route 53 Developer Guide.    During the
transfer of any country code top-level domains (ccTLDs) to Route 53, except for .cc and
.tv, updates to the owner contact are ignored and the owner contact data from the registry
is used. You can update the owner contact after the transfer is complete. For more
information, see UpdateDomainContact.  If the registrar for your domain is also the DNS
service provider for the domain, we highly recommend that you transfer your DNS service to
Route 53 or to another DNS service provider before you transfer your registration. Some
registrars provide free DNS service when you purchase a domain registration. When you
transfer the registration, the previous registrar will not renew your domain registration
and could end your DNS service at any time.  If the registrar for your domain is also the
DNS service provider for the domain and you don't transfer DNS service to another provider,
your website, email, and the web applications associated with the domain might become
unavailable.  If the transfer is successful, this method returns an operation ID that you
can use to track the progress and completion of the action. If the transfer doesn't
complete successfully, the domain registrant will be notified by email.

# Arguments
- `admin_contact`: Provides detailed contact information.
- `domain_name`: The name of the domain that you want to transfer to Route 53. The
  top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of
  supported TLDs, see Domains that You Can Register with Amazon Route 53 in the Amazon Route
  53 Developer Guide. The domain name can contain only the following characters:   Letters a
  through z. Domain names are not case sensitive.   Numbers 0 through 9.   Hyphen (-). You
  can't specify a hyphen at the beginning or end of a label.    Period (.) to separate the
  labels in the name, such as the . in example.com.
- `duration_in_years`: The number of years that you want to register the domain for.
  Domains are registered for a minimum of one year. The maximum period depends on the
  top-level domain. Default: 1
- `registrant_contact`: Provides detailed contact information.
- `tech_contact`: Provides detailed contact information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuthCode"`: The authorization code for the domain. You get this value from the current
  registrar.
- `"AutoRenew"`: Indicates whether the domain will be automatically renewed (true) or not
  (false). Auto renewal only takes effect after the account is charged. Default: true
- `"BillingContact"`: Provides detailed contact information.
- `"IdnLangCode"`: Reserved for future use.
- `"Nameservers"`: Contains details for the host and glue IP addresses.
- `"PrivacyProtectAdminContact"`: Whether you want to conceal contact information from
  WHOIS queries. If you specify true, WHOIS (\"who is\") queries return contact information
  for the registrar, the phrase \"REDACTED FOR PRIVACY\", or \"On behalf of &lt;domain
  name&gt; owner.\".  While some domains may allow different privacy settings per contact, we
  recommend specifying the same privacy setting for all contacts.  Default: true
- `"PrivacyProtectBillingContact"`:  Whether you want to conceal contact information from
  WHOIS queries. If you specify true, WHOIS (\"who is\") queries return contact information
  either for Amazon Registrar or for our registrar associate, Gandi. If you specify false,
  WHOIS queries return the information that you entered for the billing contact.   You must
  specify the same privacy setting for the administrative, billing, registrant, and technical
  contacts.
- `"PrivacyProtectRegistrantContact"`: Whether you want to conceal contact information from
  WHOIS queries. If you specify true, WHOIS (\"who is\") queries return contact information
  either for Amazon Registrar or for our registrar associate, Gandi. If you specify false,
  WHOIS queries return the information that you entered for the registrant contact (domain
  owner).  You must specify the same privacy setting for the administrative, billing,
  registrant, and technical contacts.  Default: true
- `"PrivacyProtectTechContact"`: Whether you want to conceal contact information from WHOIS
  queries. If you specify true, WHOIS (\"who is\") queries return contact information either
  for Amazon Registrar or for our registrar associate, Gandi. If you specify false, WHOIS
  queries return the information that you entered for the technical contact.  You must
  specify the same privacy setting for the administrative, billing, registrant, and technical
  contacts.  Default: true
"""
function transfer_domain(
    AdminContact,
    DomainName,
    DurationInYears,
    RegistrantContact,
    TechContact;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "TransferDomain",
        Dict{String,Any}(
            "AdminContact" => AdminContact,
            "DomainName" => DomainName,
            "DurationInYears" => DurationInYears,
            "RegistrantContact" => RegistrantContact,
            "TechContact" => TechContact,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function transfer_domain(
    AdminContact,
    DomainName,
    DurationInYears,
    RegistrantContact,
    TechContact,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "TransferDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AdminContact" => AdminContact,
                    "DomainName" => DomainName,
                    "DurationInYears" => DurationInYears,
                    "RegistrantContact" => RegistrantContact,
                    "TechContact" => TechContact,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    transfer_domain_to_another_aws_account(account_id, domain_name)
    transfer_domain_to_another_aws_account(account_id, domain_name, params::Dict{String,<:Any})

Transfers a domain from the current Amazon Web Services account to another Amazon Web
Services account. Note the following:   The Amazon Web Services account that you're
transferring the domain to must accept the transfer. If the other account doesn't accept
the transfer within 3 days, we cancel the transfer. See
AcceptDomainTransferFromAnotherAwsAccount.    You can cancel the transfer before the other
account accepts it. See CancelDomainTransferToAnotherAwsAccount.    The other account can
reject the transfer. See RejectDomainTransferFromAnotherAwsAccount.     When you transfer a
domain from one Amazon Web Services account to another, Route 53 doesn't transfer the
hosted zone that is associated with the domain. DNS resolution isn't affected if the domain
and the hosted zone are owned by separate accounts, so transferring the hosted zone is
optional. For information about transferring the hosted zone to another Amazon Web Services
account, see Migrating a Hosted Zone to a Different Amazon Web Services Account in the
Amazon Route 53 Developer Guide.  Use either ListOperations or GetOperationDetail to
determine whether the operation succeeded. GetOperationDetail provides additional
information, for example, Domain Transfer from Aws Account 111122223333 has been cancelled.

# Arguments
- `account_id`: The account ID of the Amazon Web Services account that you want to transfer
  the domain to, for example, 111122223333.
- `domain_name`: The name of the domain that you want to transfer from the current Amazon
  Web Services account to another account.

"""
function transfer_domain_to_another_aws_account(
    AccountId, DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "TransferDomainToAnotherAwsAccount",
        Dict{String,Any}("AccountId" => AccountId, "DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function transfer_domain_to_another_aws_account(
    AccountId,
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "TransferDomainToAnotherAwsAccount",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccountId" => AccountId, "DomainName" => DomainName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_domain_contact(domain_name)
    update_domain_contact(domain_name, params::Dict{String,<:Any})

This operation updates the contact information for a particular domain. You must specify
information for at least one contact: registrant, administrator, or technical. If the
update is successful, this method returns an operation ID that you can use to track the
progress and completion of the operation. If the request is not completed successfully, the
domain registrant will be notified by email.

# Arguments
- `domain_name`: The name of the domain that you want to update contact information for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AdminContact"`: Provides detailed contact information.
- `"BillingContact"`: Provides detailed contact information.
- `"Consent"`:  Customer's consent for the owner change request. Required if the domain is
  not free (consent price is more than 0.00).
- `"RegistrantContact"`: Provides detailed contact information.
- `"TechContact"`: Provides detailed contact information.
"""
function update_domain_contact(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "UpdateDomainContact",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_domain_contact(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "UpdateDomainContact",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_domain_contact_privacy(domain_name)
    update_domain_contact_privacy(domain_name, params::Dict{String,<:Any})

This operation updates the specified domain contact's privacy setting. When privacy
protection is enabled, your contact information is replaced with contact information for
the registrar or with the phrase \"REDACTED FOR PRIVACY\", or \"On behalf of &lt;domain
name&gt; owner.\"  While some domains may allow different privacy settings per contact, we
recommend specifying the same privacy setting for all contacts.  This operation affects
only the contact information for the specified contact type (administrative, registrant, or
technical). If the request succeeds, Amazon Route 53 returns an operation ID that you can
use with GetOperationDetail to track the progress and completion of the action. If the
request doesn't complete successfully, the domain registrant will be notified by email.  By
disabling the privacy service via API, you consent to the publication of the contact
information provided for this domain via the public WHOIS database. You certify that you
are the registrant of this domain name and have the authority to make this decision. You
may withdraw your consent at any time by enabling privacy protection using either
UpdateDomainContactPrivacy or the Route 53 console. Enabling privacy protection removes the
contact information provided for this domain from the WHOIS database. For more information
on our privacy practices, see https://aws.amazon.com/privacy/.

# Arguments
- `domain_name`: The name of the domain that you want to update the privacy setting for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AdminPrivacy"`: Whether you want to conceal contact information from WHOIS queries. If
  you specify true, WHOIS (\"who is\") queries return contact information either for Amazon
  Registrar or for our registrar associate, Gandi. If you specify false, WHOIS queries return
  the information that you entered for the admin contact.  You must specify the same privacy
  setting for the administrative, billing, registrant, and technical contacts.
- `"BillingPrivacy"`:  Whether you want to conceal contact information from WHOIS queries.
  If you specify true, WHOIS (\"who is\") queries return contact information either for
  Amazon Registrar or for our registrar associate, Gandi. If you specify false, WHOIS queries
  return the information that you entered for the billing contact.   You must specify the
  same privacy setting for the administrative, billing, registrant, and technical contacts.
- `"RegistrantPrivacy"`: Whether you want to conceal contact information from WHOIS
  queries. If you specify true, WHOIS (\"who is\") queries return contact information either
  for Amazon Registrar or for our registrar associate, Gandi. If you specify false, WHOIS
  queries return the information that you entered for the registrant contact (domain owner).
  You must specify the same privacy setting for the administrative, billing, registrant, and
  technical contacts.
- `"TechPrivacy"`: Whether you want to conceal contact information from WHOIS queries. If
  you specify true, WHOIS (\"who is\") queries return contact information either for Amazon
  Registrar or for our registrar associate, Gandi. If you specify false, WHOIS queries return
  the information that you entered for the technical contact.  You must specify the same
  privacy setting for the administrative, billing, registrant, and technical contacts.
"""
function update_domain_contact_privacy(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "UpdateDomainContactPrivacy",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_domain_contact_privacy(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "UpdateDomainContactPrivacy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_domain_nameservers(domain_name, nameservers)
    update_domain_nameservers(domain_name, nameservers, params::Dict{String,<:Any})

This operation replaces the current set of name servers for the domain with the specified
set of name servers. If you use Amazon Route 53 as your DNS service, specify the four name
servers in the delegation set for the hosted zone for the domain. If successful, this
operation returns an operation ID that you can use to track the progress and completion of
the action. If the request is not completed successfully, the domain registrant will be
notified by email.

# Arguments
- `domain_name`: The name of the domain that you want to change name servers for.
- `nameservers`: A list of new name servers for the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FIAuthKey"`: The authorization key for .fi domains
"""
function update_domain_nameservers(
    DomainName, Nameservers; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "UpdateDomainNameservers",
        Dict{String,Any}("DomainName" => DomainName, "Nameservers" => Nameservers);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_domain_nameservers(
    DomainName,
    Nameservers,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "UpdateDomainNameservers",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DomainName" => DomainName, "Nameservers" => Nameservers),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_tags_for_domain(domain_name)
    update_tags_for_domain(domain_name, params::Dict{String,<:Any})

This operation adds or updates tags for a specified domain. All tag operations are
eventually consistent; subsequent operations might not immediately represent all issued
operations.

# Arguments
- `domain_name`: The domain for which you want to add or update tags.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TagsToUpdate"`: A list of the tag keys and values that you want to add or update. If
  you specify a key that already exists, the corresponding value will be replaced.
"""
function update_tags_for_domain(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "UpdateTagsForDomain",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_tags_for_domain(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route_53_domains(
        "UpdateTagsForDomain",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    view_billing()
    view_billing(params::Dict{String,<:Any})

Returns all the domain-related billing records for the current Amazon Web Services account
for a specified period

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"End"`: The end date and time for the time period for which you want a list of billing
  records. Specify the date and time in Unix time format and Coordinated Universal time (UTC).
- `"Marker"`: For an initial request for a list of billing records, omit this element. If
  the number of billing records that are associated with the current Amazon Web Services
  account during the specified period is greater than the value that you specified for
  MaxItems, you can use Marker to return additional billing records. Get the value of
  NextPageMarker from the previous response, and submit another request that includes the
  value of NextPageMarker in the Marker element.  Constraints: The marker must match the
  value of NextPageMarker that was returned in the previous response.
- `"MaxItems"`: The number of billing records to be returned. Default: 20
- `"Start"`: The beginning date and time for the time period for which you want a list of
  billing records. Specify the date and time in Unix time format and Coordinated Universal
  time (UTC).
"""
function view_billing(; aws_config::AbstractAWSConfig=current_aws_config())
    return route_53_domains(
        "ViewBilling"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function view_billing(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route_53_domains(
        "ViewBilling", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
