# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: secrets_manager
using AWS.Compat
using AWS.UUIDs

"""
    batch_get_secret_value()
    batch_get_secret_value(params::Dict{String,<:Any})

Retrieves the contents of the encrypted fields SecretString or SecretBinary for up to 20
secrets. To retrieve a single secret, call GetSecretValue.  To choose which secrets to
retrieve, you can specify a list of secrets by name or ARN, or you can use filters. If
Secrets Manager encounters errors such as AccessDeniedException while attempting to
retrieve any of the secrets, you can see the errors in Errors in the response. Secrets
Manager generates CloudTrail GetSecretValue log entries for each secret you request when
you call this action. Do not include sensitive information in request parameters because it
might be logged. For more information, see Logging Secrets Manager events with CloudTrail.
Required permissions:  secretsmanager:BatchGetSecretValue, and you must have
secretsmanager:GetSecretValue for each secret. If you use filters, you must also have
secretsmanager:ListSecrets. If the secrets are encrypted using customer-managed keys
instead of the Amazon Web Services managed key aws/secretsmanager, then you also need
kms:Decrypt permissions for the keys. For more information, see  IAM policy actions for
Secrets Manager and Authentication and access control in Secrets Manager.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: The filters to choose which secrets to retrieve. You must include Filters or
  SecretIdList, but not both.
- `"MaxResults"`: The number of results to include in the response. If there are more
  results available, in the response, Secrets Manager includes NextToken. To get the next
  results, call BatchGetSecretValue again with the value from NextToken. To use this
  parameter, you must also use the Filters parameter.
- `"NextToken"`: A token that indicates where the output should continue from, if a
  previous call did not show all results. To get the next results, call BatchGetSecretValue
  again with this value.
- `"SecretIdList"`: The ARN or names of the secrets to retrieve. You must include Filters
  or SecretIdList, but not both.
"""
function batch_get_secret_value(; aws_config::AbstractAWSConfig=current_aws_config())
    return secrets_manager(
        "BatchGetSecretValue"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function batch_get_secret_value(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return secrets_manager(
        "BatchGetSecretValue",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_rotate_secret(secret_id)
    cancel_rotate_secret(secret_id, params::Dict{String,<:Any})

Turns off automatic rotation, and if a rotation is currently in progress, cancels the
rotation. If you cancel a rotation in progress, it can leave the VersionStage labels in an
unexpected state. You might need to remove the staging label AWSPENDING from the partially
created version. You also need to determine whether to roll back to the previous version of
the secret by moving the staging label AWSCURRENT to the version that has AWSPENDING. To
determine which version has a specific staging label, call ListSecretVersionIds. Then use
UpdateSecretVersionStage to change staging labels. For more information, see How rotation
works. To turn on automatic rotation again, call RotateSecret. Secrets Manager generates a
CloudTrail log entry when you call this action. Do not include sensitive information in
request parameters because it might be logged. For more information, see Logging Secrets
Manager events with CloudTrail.  Required permissions:  secretsmanager:CancelRotateSecret.
For more information, see  IAM policy actions for Secrets Manager and Authentication and
access control in Secrets Manager.

# Arguments
- `secret_id`: The ARN or name of the secret. For an ARN, we recommend that you specify a
  complete ARN rather than a partial ARN. See Finding a secret from a partial ARN.

"""
function cancel_rotate_secret(SecretId; aws_config::AbstractAWSConfig=current_aws_config())
    return secrets_manager(
        "CancelRotateSecret",
        Dict{String,Any}("SecretId" => SecretId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_rotate_secret(
    SecretId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "CancelRotateSecret",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SecretId" => SecretId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_secret(name)
    create_secret(name, params::Dict{String,<:Any})

Creates a new secret. A secret can be a password, a set of credentials such as a user name
and password, an OAuth token, or other secret information that you store in an encrypted
form in Secrets Manager. The secret also includes the connection information to access a
database or other service, which Secrets Manager doesn't encrypt. A secret in Secrets
Manager consists of both the protected secret data and the important information needed to
manage the secret. For secrets that use managed rotation, you need to create the secret
through the managing service. For more information, see Secrets Manager secrets managed by
other Amazon Web Services services.  For information about creating a secret in the
console, see Create a secret. To create a secret, you can provide the secret value to be
encrypted in either the SecretString parameter or the SecretBinary parameter, but not both.
If you include SecretString or SecretBinary then Secrets Manager creates an initial secret
version and automatically attaches the staging label AWSCURRENT to it. For database
credentials you want to rotate, for Secrets Manager to be able to rotate the secret, you
must make sure the JSON you store in the SecretString matches the JSON structure of a
database secret. If you don't specify an KMS encryption key, Secrets Manager uses the
Amazon Web Services managed key aws/secretsmanager. If this key doesn't already exist in
your account, then Secrets Manager creates it for you automatically. All users and roles in
the Amazon Web Services account automatically have access to use aws/secretsmanager.
Creating aws/secretsmanager can result in a one-time significant delay in returning the
result. If the secret is in a different Amazon Web Services account from the credentials
calling the API, then you can't use aws/secretsmanager to encrypt the secret, and you must
create and use a customer managed KMS key.  Secrets Manager generates a CloudTrail log
entry when you call this action. Do not include sensitive information in request parameters
except SecretBinary or SecretString because it might be logged. For more information, see
Logging Secrets Manager events with CloudTrail.  Required permissions:
secretsmanager:CreateSecret. If you include tags in the secret, you also need
secretsmanager:TagResource. To add replica Regions, you must also have
secretsmanager:ReplicateSecretToRegions. For more information, see  IAM policy actions for
Secrets Manager and Authentication and access control in Secrets Manager.  To encrypt the
secret with a KMS key other than aws/secretsmanager, you need kms:GenerateDataKey and
kms:Decrypt permission to the key.

# Arguments
- `name`: The name of the new secret. The secret name can contain ASCII letters, numbers,
  and the following characters: /_+=.@- Do not end your secret name with a hyphen followed by
  six characters. If you do so, you risk confusion and unexpected results when searching for
  a secret by partial ARN. Secrets Manager automatically adds a hyphen and six random
  characters after the secret name at the end of the ARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AddReplicaRegions"`: A list of Regions and KMS keys to replicate secrets.
- `"ClientRequestToken"`: If you include SecretString or SecretBinary, then Secrets Manager
  creates an initial version for the secret, and this parameter specifies the unique
  identifier for the new version.   If you use the Amazon Web Services CLI or one of the
  Amazon Web Services SDKs to call this operation, then you can leave this parameter empty.
  The CLI or SDK generates a random UUID for you and includes it as the value for this
  parameter in the request.   If you generate a raw HTTP request to the Secrets Manager
  service endpoint, then you must generate a ClientRequestToken and include it in the
  request. This value helps ensure idempotency. Secrets Manager uses this value to prevent
  the accidental creation of duplicate versions if there are failures and retries during a
  rotation. We recommend that you generate a UUID-type value to ensure uniqueness of your
  versions within the specified secret.    If the ClientRequestToken value isn't already
  associated with a version of the secret then a new version of the secret is created.    If
  a version with this value already exists and the version SecretString and SecretBinary
  values are the same as those in the request, then the request is ignored.   If a version
  with this value already exists and that version's SecretString and SecretBinary values are
  different from those in the request, then the request fails because you cannot modify an
  existing version. Instead, use PutSecretValue to create a new version.   This value becomes
  the VersionId of the new version.
- `"Description"`: The description of the secret.
- `"ForceOverwriteReplicaSecret"`: Specifies whether to overwrite a secret with the same
  name in the destination Region. By default, secrets aren't overwritten.
- `"KmsKeyId"`: The ARN, key ID, or alias of the KMS key that Secrets Manager uses to
  encrypt the secret value in the secret. An alias is always prefixed by alias/, for example
  alias/aws/secretsmanager. For more information, see About aliases. To use a KMS key in a
  different account, use the key ARN or the alias ARN. If you don't specify this value, then
  Secrets Manager uses the key aws/secretsmanager. If that key doesn't yet exist, then
  Secrets Manager creates it for you automatically the first time it encrypts the secret
  value. If the secret is in a different Amazon Web Services account from the credentials
  calling the API, then you can't use aws/secretsmanager to encrypt the secret, and you must
  create and use a customer managed KMS key.
- `"SecretBinary"`: The binary data to encrypt and store in the new version of the secret.
  We recommend that you store your binary data in a file and then pass the contents of the
  file as a parameter. Either SecretString or SecretBinary must have a value, but not both.
  This parameter is not available in the Secrets Manager console. Sensitive: This field
  contains sensitive information, so the service does not include it in CloudTrail log
  entries. If you create your own log entries, you must also avoid logging the information in
  this field.
- `"SecretString"`: The text data to encrypt and store in this new version of the secret.
  We recommend you use a JSON structure of key/value pairs for your secret value. Either
  SecretString or SecretBinary must have a value, but not both. If you create a secret by
  using the Secrets Manager console then Secrets Manager puts the protected secret text in
  only the SecretString parameter. The Secrets Manager console stores the information as a
  JSON structure of key/value pairs that a Lambda rotation function can parse. Sensitive:
  This field contains sensitive information, so the service does not include it in CloudTrail
  log entries. If you create your own log entries, you must also avoid logging the
  information in this field.
- `"Tags"`: A list of tags to attach to the secret. Each tag is a key and value pair of
  strings in a JSON text string, for example:
  [{\"Key\":\"CostCenter\",\"Value\":\"12345\"},{\"Key\":\"environment\",\"Value\":\"productio
  n\"}]  Secrets Manager tag key names are case sensitive. A tag with the key \"ABC\" is a
  different tag from one with key \"abc\". If you check tags in permissions policies as part
  of your security strategy, then adding or removing a tag can change permissions. If the
  completion of this operation would result in you losing your permissions for this secret,
  then Secrets Manager blocks the operation and returns an Access Denied error. For more
  information, see Control access to secrets using tags and Limit access to identities with
  tags that match secrets' tags. For information about how to format a JSON parameter for the
  various command line tool environments, see Using JSON for Parameters. If your command-line
  tool or SDK requires quotation marks around the parameter, you should use single quotes to
  avoid confusion with the double quotes required in the JSON text. For tag quotas and naming
  restrictions, see Service quotas for Tagging in the Amazon Web Services General Reference
  guide.
"""
function create_secret(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return secrets_manager(
        "CreateSecret",
        Dict{String,Any}("Name" => Name, "ClientRequestToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_secret(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return secrets_manager(
        "CreateSecret",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Name" => Name, "ClientRequestToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resource_policy(secret_id)
    delete_resource_policy(secret_id, params::Dict{String,<:Any})

Deletes the resource-based permission policy attached to the secret. To attach a policy to
a secret, use PutResourcePolicy. Secrets Manager generates a CloudTrail log entry when you
call this action. Do not include sensitive information in request parameters because it
might be logged. For more information, see Logging Secrets Manager events with CloudTrail.
Required permissions:  secretsmanager:DeleteResourcePolicy. For more information, see  IAM
policy actions for Secrets Manager and Authentication and access control in Secrets
Manager.

# Arguments
- `secret_id`: The ARN or name of the secret to delete the attached resource-based policy
  for. For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.
  See Finding a secret from a partial ARN.

"""
function delete_resource_policy(
    SecretId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return secrets_manager(
        "DeleteResourcePolicy",
        Dict{String,Any}("SecretId" => SecretId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resource_policy(
    SecretId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "DeleteResourcePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SecretId" => SecretId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_secret(secret_id)
    delete_secret(secret_id, params::Dict{String,<:Any})

Deletes a secret and all of its versions. You can specify a recovery window during which
you can restore the secret. The minimum recovery window is 7 days. The default recovery
window is 30 days. Secrets Manager attaches a DeletionDate stamp to the secret that
specifies the end of the recovery window. At the end of the recovery window, Secrets
Manager deletes the secret permanently. You can't delete a primary secret that is
replicated to other Regions. You must first delete the replicas using
RemoveRegionsFromReplication, and then delete the primary secret. When you delete a
replica, it is deleted immediately. You can't directly delete a version of a secret.
Instead, you remove all staging labels from the version using UpdateSecretVersionStage.
This marks the version as deprecated, and then Secrets Manager can automatically delete the
version in the background. To determine whether an application still uses a secret, you can
create an Amazon CloudWatch alarm to alert you to any attempts to access a secret during
the recovery window. For more information, see  Monitor secrets scheduled for deletion.
Secrets Manager performs the permanent secret deletion at the end of the waiting period as
a background task with low priority. There is no guarantee of a specific time after the
recovery window for the permanent delete to occur. At any time before recovery window ends,
you can use RestoreSecret to remove the DeletionDate and cancel the deletion of the secret.
When a secret is scheduled for deletion, you cannot retrieve the secret value. You must
first cancel the deletion with RestoreSecret and then you can retrieve the secret. Secrets
Manager generates a CloudTrail log entry when you call this action. Do not include
sensitive information in request parameters because it might be logged. For more
information, see Logging Secrets Manager events with CloudTrail.  Required permissions:
secretsmanager:DeleteSecret. For more information, see  IAM policy actions for Secrets
Manager and Authentication and access control in Secrets Manager.

# Arguments
- `secret_id`: The ARN or name of the secret to delete. For an ARN, we recommend that you
  specify a complete ARN rather than a partial ARN. See Finding a secret from a partial ARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ForceDeleteWithoutRecovery"`: Specifies whether to delete the secret without any
  recovery window. You can't use both this parameter and RecoveryWindowInDays in the same
  call. If you don't use either, then by default Secrets Manager uses a 30 day recovery
  window. Secrets Manager performs the actual deletion with an asynchronous background
  process, so there might be a short delay before the secret is permanently deleted. If you
  delete a secret and then immediately create a secret with the same name, use appropriate
  back off and retry logic. If you forcibly delete an already deleted or nonexistent secret,
  the operation does not return ResourceNotFoundException.  Use this parameter with caution.
  This parameter causes the operation to skip the normal recovery window before the permanent
  deletion that Secrets Manager would normally impose with the RecoveryWindowInDays
  parameter. If you delete a secret with the ForceDeleteWithoutRecovery parameter, then you
  have no opportunity to recover the secret. You lose the secret permanently.
- `"RecoveryWindowInDays"`: The number of days from 7 to 30 that Secrets Manager waits
  before permanently deleting the secret. You can't use both this parameter and
  ForceDeleteWithoutRecovery in the same call. If you don't use either, then by default
  Secrets Manager uses a 30 day recovery window.
"""
function delete_secret(SecretId; aws_config::AbstractAWSConfig=current_aws_config())
    return secrets_manager(
        "DeleteSecret",
        Dict{String,Any}("SecretId" => SecretId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_secret(
    SecretId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "DeleteSecret",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SecretId" => SecretId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_secret(secret_id)
    describe_secret(secret_id, params::Dict{String,<:Any})

Retrieves the details of a secret. It does not include the encrypted secret value. Secrets
Manager only returns fields that have a value in the response.  Secrets Manager generates a
CloudTrail log entry when you call this action. Do not include sensitive information in
request parameters because it might be logged. For more information, see Logging Secrets
Manager events with CloudTrail.  Required permissions:  secretsmanager:DescribeSecret. For
more information, see  IAM policy actions for Secrets Manager and Authentication and access
control in Secrets Manager.

# Arguments
- `secret_id`: The ARN or name of the secret.  For an ARN, we recommend that you specify a
  complete ARN rather than a partial ARN. See Finding a secret from a partial ARN.

"""
function describe_secret(SecretId; aws_config::AbstractAWSConfig=current_aws_config())
    return secrets_manager(
        "DescribeSecret",
        Dict{String,Any}("SecretId" => SecretId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_secret(
    SecretId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "DescribeSecret",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SecretId" => SecretId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_random_password()
    get_random_password(params::Dict{String,<:Any})

Generates a random password. We recommend that you specify the maximum length and include
every character type that the system you are generating a password for can support. By
default, Secrets Manager uses uppercase and lowercase letters, numbers, and the following
characters in passwords: !\"#%&amp;'()*+,-./:;&lt;=&gt;?@[]^_`{|}~  Secrets Manager
generates a CloudTrail log entry when you call this action.  Required permissions:
secretsmanager:GetRandomPassword. For more information, see  IAM policy actions for Secrets
Manager and Authentication and access control in Secrets Manager.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExcludeCharacters"`: A string of the characters that you don't want in the password.
- `"ExcludeLowercase"`: Specifies whether to exclude lowercase letters from the password.
  If you don't include this switch, the password can contain lowercase letters.
- `"ExcludeNumbers"`: Specifies whether to exclude numbers from the password. If you don't
  include this switch, the password can contain numbers.
- `"ExcludePunctuation"`: Specifies whether to exclude the following punctuation characters
  from the password: ! \" #  % &amp; ' ( ) * + , - . / : ; &lt; = &gt; ? @ [  ] ^ _ ` { | }
  ~. If you don't include this switch, the password can contain punctuation.
- `"ExcludeUppercase"`: Specifies whether to exclude uppercase letters from the password.
  If you don't include this switch, the password can contain uppercase letters.
- `"IncludeSpace"`: Specifies whether to include the space character. If you include this
  switch, the password can contain space characters.
- `"PasswordLength"`: The length of the password. If you don't include this parameter, the
  default length is 32 characters.
- `"RequireEachIncludedType"`: Specifies whether to include at least one upper and
  lowercase letter, one number, and one punctuation. If you don't include this switch, the
  password contains at least one of every character type.
"""
function get_random_password(; aws_config::AbstractAWSConfig=current_aws_config())
    return secrets_manager(
        "GetRandomPassword"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_random_password(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return secrets_manager(
        "GetRandomPassword", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_resource_policy(secret_id)
    get_resource_policy(secret_id, params::Dict{String,<:Any})

Retrieves the JSON text of the resource-based policy document attached to the secret. For
more information about permissions policies attached to a secret, see Permissions policies
attached to a secret. Secrets Manager generates a CloudTrail log entry when you call this
action. Do not include sensitive information in request parameters because it might be
logged. For more information, see Logging Secrets Manager events with CloudTrail.  Required
permissions:  secretsmanager:GetResourcePolicy. For more information, see  IAM policy
actions for Secrets Manager and Authentication and access control in Secrets Manager.

# Arguments
- `secret_id`: The ARN or name of the secret to retrieve the attached resource-based policy
  for. For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.
  See Finding a secret from a partial ARN.

"""
function get_resource_policy(SecretId; aws_config::AbstractAWSConfig=current_aws_config())
    return secrets_manager(
        "GetResourcePolicy",
        Dict{String,Any}("SecretId" => SecretId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resource_policy(
    SecretId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "GetResourcePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SecretId" => SecretId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_secret_value(secret_id)
    get_secret_value(secret_id, params::Dict{String,<:Any})

Retrieves the contents of the encrypted fields SecretString or SecretBinary from the
specified version of a secret, whichever contains content. To retrieve the values for a
group of secrets, call BatchGetSecretValue. We recommend that you cache your secret values
by using client-side caching. Caching secrets improves speed and reduces your costs. For
more information, see Cache secrets for your applications. To retrieve the previous version
of a secret, use VersionStage and specify AWSPREVIOUS. To revert to the previous version of
a secret, call UpdateSecretVersionStage. Secrets Manager generates a CloudTrail log entry
when you call this action. Do not include sensitive information in request parameters
because it might be logged. For more information, see Logging Secrets Manager events with
CloudTrail.  Required permissions:  secretsmanager:GetSecretValue. If the secret is
encrypted using a customer-managed key instead of the Amazon Web Services managed key
aws/secretsmanager, then you also need kms:Decrypt permissions for that key. For more
information, see  IAM policy actions for Secrets Manager and Authentication and access
control in Secrets Manager.

# Arguments
- `secret_id`: The ARN or name of the secret to retrieve. To retrieve a secret from another
  account, you must use an ARN. For an ARN, we recommend that you specify a complete ARN
  rather than a partial ARN. See Finding a secret from a partial ARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"VersionId"`: The unique identifier of the version of the secret to retrieve. If you
  include both this parameter and VersionStage, the two parameters must refer to the same
  secret version. If you don't specify either a VersionStage or VersionId, then Secrets
  Manager returns the AWSCURRENT version. This value is typically a UUID-type value with 32
  hexadecimal digits.
- `"VersionStage"`: The staging label of the version of the secret to retrieve.  Secrets
  Manager uses staging labels to keep track of different versions during the rotation
  process. If you include both this parameter and VersionId, the two parameters must refer to
  the same secret version. If you don't specify either a VersionStage or VersionId, Secrets
  Manager returns the AWSCURRENT version.
"""
function get_secret_value(SecretId; aws_config::AbstractAWSConfig=current_aws_config())
    return secrets_manager(
        "GetSecretValue",
        Dict{String,Any}("SecretId" => SecretId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_secret_value(
    SecretId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "GetSecretValue",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SecretId" => SecretId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_secret_version_ids(secret_id)
    list_secret_version_ids(secret_id, params::Dict{String,<:Any})

Lists the versions of a secret. Secrets Manager uses staging labels to indicate the
different versions of a secret. For more information, see  Secrets Manager concepts:
Versions. To list the secrets in the account, use ListSecrets. Secrets Manager generates a
CloudTrail log entry when you call this action. Do not include sensitive information in
request parameters because it might be logged. For more information, see Logging Secrets
Manager events with CloudTrail.  Required permissions:
secretsmanager:ListSecretVersionIds. For more information, see  IAM policy actions for
Secrets Manager and Authentication and access control in Secrets Manager.

# Arguments
- `secret_id`: The ARN or name of the secret whose versions you want to list. For an ARN,
  we recommend that you specify a complete ARN rather than a partial ARN. See Finding a
  secret from a partial ARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IncludeDeprecated"`: Specifies whether to include versions of secrets that don't have
  any staging labels attached to them. Versions without staging labels are considered
  deprecated and are subject to deletion by Secrets Manager. By default, versions without
  staging labels aren't included.
- `"MaxResults"`: The number of results to include in the response. If there are more
  results available, in the response, Secrets Manager includes NextToken. To get the next
  results, call ListSecretVersionIds again with the value from NextToken.
- `"NextToken"`: A token that indicates where the output should continue from, if a
  previous call did not show all results. To get the next results, call ListSecretVersionIds
  again with this value.
"""
function list_secret_version_ids(
    SecretId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return secrets_manager(
        "ListSecretVersionIds",
        Dict{String,Any}("SecretId" => SecretId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_secret_version_ids(
    SecretId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "ListSecretVersionIds",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SecretId" => SecretId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_secrets()
    list_secrets(params::Dict{String,<:Any})

Lists the secrets that are stored by Secrets Manager in the Amazon Web Services account,
not including secrets that are marked for deletion. To see secrets marked for deletion, use
the Secrets Manager console. All Secrets Manager operations are eventually consistent.
ListSecrets might not reflect changes from the last five minutes. You can get more recent
information for a specific secret by calling DescribeSecret. To list the versions of a
secret, use ListSecretVersionIds. To retrieve the values for the secrets, call
BatchGetSecretValue or GetSecretValue. For information about finding secrets in the
console, see Find secrets in Secrets Manager. Secrets Manager generates a CloudTrail log
entry when you call this action. Do not include sensitive information in request parameters
because it might be logged. For more information, see Logging Secrets Manager events with
CloudTrail.  Required permissions:  secretsmanager:ListSecrets. For more information, see
IAM policy actions for Secrets Manager and Authentication and access control in Secrets
Manager.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: The filters to apply to the list of secrets.
- `"IncludePlannedDeletion"`: Specifies whether to include secrets scheduled for deletion.
  By default, secrets scheduled for deletion aren't included.
- `"MaxResults"`: The number of results to include in the response. If there are more
  results available, in the response, Secrets Manager includes NextToken. To get the next
  results, call ListSecrets again with the value from NextToken.
- `"NextToken"`: A token that indicates where the output should continue from, if a
  previous call did not show all results. To get the next results, call ListSecrets again
  with this value.
- `"SortOrder"`: Secrets are listed by CreatedDate.
"""
function list_secrets(; aws_config::AbstractAWSConfig=current_aws_config())
    return secrets_manager(
        "ListSecrets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_secrets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return secrets_manager(
        "ListSecrets", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    put_resource_policy(resource_policy, secret_id)
    put_resource_policy(resource_policy, secret_id, params::Dict{String,<:Any})

Attaches a resource-based permission policy to a secret. A resource-based policy is
optional. For more information, see Authentication and access control for Secrets Manager
For information about attaching a policy in the console, see Attach a permissions policy to
a secret. Secrets Manager generates a CloudTrail log entry when you call this action. Do
not include sensitive information in request parameters because it might be logged. For
more information, see Logging Secrets Manager events with CloudTrail.  Required
permissions:  secretsmanager:PutResourcePolicy. For more information, see  IAM policy
actions for Secrets Manager and Authentication and access control in Secrets Manager.

# Arguments
- `resource_policy`: A JSON-formatted string for an Amazon Web Services resource-based
  policy. For example policies, see Permissions policy examples.
- `secret_id`: The ARN or name of the secret to attach the resource-based policy. For an
  ARN, we recommend that you specify a complete ARN rather than a partial ARN. See Finding a
  secret from a partial ARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BlockPublicPolicy"`: Specifies whether to block resource-based policies that allow
  broad access to the secret, for example those that use a wildcard for the principal. By
  default, public policies aren't blocked.  Resource policy validation and the
  BlockPublicPolicy parameter help protect your resources by preventing public access from
  being granted through the resource policies that are directly attached to your secrets. In
  addition to using these features, carefully inspect the following policies to confirm that
  they do not grant public access:   Identity-based policies attached to associated Amazon
  Web Services principals (for example, IAM roles)   Resource-based policies attached to
  associated Amazon Web Services resources (for example, Key Management Service (KMS) keys)
  To review permissions to your secrets, see Determine who has permissions to your secrets.
"""
function put_resource_policy(
    ResourcePolicy, SecretId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return secrets_manager(
        "PutResourcePolicy",
        Dict{String,Any}("ResourcePolicy" => ResourcePolicy, "SecretId" => SecretId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_resource_policy(
    ResourcePolicy,
    SecretId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "PutResourcePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourcePolicy" => ResourcePolicy, "SecretId" => SecretId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_secret_value(secret_id)
    put_secret_value(secret_id, params::Dict{String,<:Any})

Creates a new version with a new encrypted secret value and attaches it to the secret. The
version can contain a new SecretString value or a new SecretBinary value.  We recommend you
avoid calling PutSecretValue at a sustained rate of more than once every 10 minutes. When
you update the secret value, Secrets Manager creates a new version of the secret. Secrets
Manager removes outdated versions when there are more than 100, but it does not remove
versions created less than 24 hours ago. If you call PutSecretValue more than once every 10
minutes, you create more versions than Secrets Manager removes, and you will reach the
quota for secret versions. You can specify the staging labels to attach to the new version
in VersionStages. If you don't include VersionStages, then Secrets Manager automatically
moves the staging label AWSCURRENT to this version. If this operation creates the first
version for the secret, then Secrets Manager automatically attaches the staging label
AWSCURRENT to it. If this operation moves the staging label AWSCURRENT from another version
to this version, then Secrets Manager also automatically moves the staging label
AWSPREVIOUS to the version that AWSCURRENT was removed from. This operation is idempotent.
If you call this operation with a ClientRequestToken that matches an existing version's
VersionId, and you specify the same secret data, the operation succeeds but does nothing.
However, if the secret data is different, then the operation fails because you can't modify
an existing version; you can only create new ones. Secrets Manager generates a CloudTrail
log entry when you call this action. Do not include sensitive information in request
parameters except SecretBinary, SecretString, or RotationToken because it might be logged.
For more information, see Logging Secrets Manager events with CloudTrail.  Required
permissions:  secretsmanager:PutSecretValue. For more information, see  IAM policy actions
for Secrets Manager and Authentication and access control in Secrets Manager.

# Arguments
- `secret_id`: The ARN or name of the secret to add a new version to. For an ARN, we
  recommend that you specify a complete ARN rather than a partial ARN. See Finding a secret
  from a partial ARN. If the secret doesn't already exist, use CreateSecret instead.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: A unique identifier for the new version of the secret.   If you
  use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this
  operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID
  for you and includes it as the value for this parameter in the request.   If you generate a
  raw HTTP request to the Secrets Manager service endpoint, then you must generate a
  ClientRequestToken and include it in the request. This value helps ensure idempotency.
  Secrets Manager uses this value to prevent the accidental creation of duplicate versions if
  there are failures and retries during a rotation. We recommend that you generate a
  UUID-type value to ensure uniqueness of your versions within the specified secret.    If
  the ClientRequestToken value isn't already associated with a version of the secret then a
  new version of the secret is created.    If a version with this value already exists and
  that version's SecretString or SecretBinary values are the same as those in the request
  then the request is ignored. The operation is idempotent.    If a version with this value
  already exists and the version of the SecretString and SecretBinary values are different
  from those in the request, then the request fails because you can't modify a secret
  version. You can only create new versions to store new secret values.   This value becomes
  the VersionId of the new version.
- `"RotationToken"`: A unique identifier that indicates the source of the request. For
  cross-account rotation (when you rotate a secret in one account by using a Lambda rotation
  function in another account) and the Lambda rotation function assumes an IAM role to call
  Secrets Manager, Secrets Manager validates the identity with the rotation token. For more
  information, see How rotation works. Sensitive: This field contains sensitive information,
  so the service does not include it in CloudTrail log entries. If you create your own log
  entries, you must also avoid logging the information in this field.
- `"SecretBinary"`: The binary data to encrypt and store in the new version of the secret.
  To use this parameter in the command-line tools, we recommend that you store your binary
  data in a file and then pass the contents of the file as a parameter.  You must include
  SecretBinary or SecretString, but not both. You can't access this value from the Secrets
  Manager console. Sensitive: This field contains sensitive information, so the service does
  not include it in CloudTrail log entries. If you create your own log entries, you must also
  avoid logging the information in this field.
- `"SecretString"`: The text to encrypt and store in the new version of the secret.  You
  must include SecretBinary or SecretString, but not both. We recommend you create the secret
  string as JSON key/value pairs, as shown in the example. Sensitive: This field contains
  sensitive information, so the service does not include it in CloudTrail log entries. If you
  create your own log entries, you must also avoid logging the information in this field.
- `"VersionStages"`: A list of staging labels to attach to this version of the secret.
  Secrets Manager uses staging labels to track versions of a secret through the rotation
  process. If you specify a staging label that's already associated with a different version
  of the same secret, then Secrets Manager removes the label from the other version and
  attaches it to this version. If you specify AWSCURRENT, and it is already attached to
  another version, then Secrets Manager also moves the staging label AWSPREVIOUS to the
  version that AWSCURRENT was removed from. If you don't include VersionStages, then Secrets
  Manager automatically moves the staging label AWSCURRENT to this version.
"""
function put_secret_value(SecretId; aws_config::AbstractAWSConfig=current_aws_config())
    return secrets_manager(
        "PutSecretValue",
        Dict{String,Any}("SecretId" => SecretId, "ClientRequestToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_secret_value(
    SecretId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "PutSecretValue",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SecretId" => SecretId, "ClientRequestToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_regions_from_replication(remove_replica_regions, secret_id)
    remove_regions_from_replication(remove_replica_regions, secret_id, params::Dict{String,<:Any})

For a secret that is replicated to other Regions, deletes the secret replicas from the
Regions you specify. Secrets Manager generates a CloudTrail log entry when you call this
action. Do not include sensitive information in request parameters because it might be
logged. For more information, see Logging Secrets Manager events with CloudTrail.  Required
permissions:  secretsmanager:RemoveRegionsFromReplication. For more information, see  IAM
policy actions for Secrets Manager and Authentication and access control in Secrets
Manager.

# Arguments
- `remove_replica_regions`: The Regions of the replicas to remove.
- `secret_id`: The ARN or name of the secret.

"""
function remove_regions_from_replication(
    RemoveReplicaRegions, SecretId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return secrets_manager(
        "RemoveRegionsFromReplication",
        Dict{String,Any}(
            "RemoveReplicaRegions" => RemoveReplicaRegions, "SecretId" => SecretId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_regions_from_replication(
    RemoveReplicaRegions,
    SecretId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "RemoveRegionsFromReplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "RemoveReplicaRegions" => RemoveReplicaRegions, "SecretId" => SecretId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    replicate_secret_to_regions(add_replica_regions, secret_id)
    replicate_secret_to_regions(add_replica_regions, secret_id, params::Dict{String,<:Any})

Replicates the secret to a new Regions. See Multi-Region secrets. Secrets Manager generates
a CloudTrail log entry when you call this action. Do not include sensitive information in
request parameters because it might be logged. For more information, see Logging Secrets
Manager events with CloudTrail.  Required permissions:
secretsmanager:ReplicateSecretToRegions. If the primary secret is encrypted with a KMS key
other than aws/secretsmanager, you also need kms:Decrypt permission to the key. To encrypt
the replicated secret with a KMS key other than aws/secretsmanager, you need
kms:GenerateDataKey and kms:Encrypt to the key. For more information, see  IAM policy
actions for Secrets Manager and Authentication and access control in Secrets Manager.

# Arguments
- `add_replica_regions`: A list of Regions in which to replicate the secret.
- `secret_id`: The ARN or name of the secret to replicate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ForceOverwriteReplicaSecret"`: Specifies whether to overwrite a secret with the same
  name in the destination Region. By default, secrets aren't overwritten.
"""
function replicate_secret_to_regions(
    AddReplicaRegions, SecretId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return secrets_manager(
        "ReplicateSecretToRegions",
        Dict{String,Any}("AddReplicaRegions" => AddReplicaRegions, "SecretId" => SecretId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function replicate_secret_to_regions(
    AddReplicaRegions,
    SecretId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "ReplicateSecretToRegions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AddReplicaRegions" => AddReplicaRegions, "SecretId" => SecretId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_secret(secret_id)
    restore_secret(secret_id, params::Dict{String,<:Any})

Cancels the scheduled deletion of a secret by removing the DeletedDate time stamp. You can
access a secret again after it has been restored. Secrets Manager generates a CloudTrail
log entry when you call this action. Do not include sensitive information in request
parameters because it might be logged. For more information, see Logging Secrets Manager
events with CloudTrail.  Required permissions:  secretsmanager:RestoreSecret. For more
information, see  IAM policy actions for Secrets Manager and Authentication and access
control in Secrets Manager.

# Arguments
- `secret_id`: The ARN or name of the secret to restore. For an ARN, we recommend that you
  specify a complete ARN rather than a partial ARN. See Finding a secret from a partial ARN.

"""
function restore_secret(SecretId; aws_config::AbstractAWSConfig=current_aws_config())
    return secrets_manager(
        "RestoreSecret",
        Dict{String,Any}("SecretId" => SecretId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_secret(
    SecretId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "RestoreSecret",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SecretId" => SecretId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    rotate_secret(secret_id)
    rotate_secret(secret_id, params::Dict{String,<:Any})

Configures and starts the asynchronous process of rotating the secret. For information
about rotation, see Rotate secrets in the Secrets Manager User Guide. If you include the
configuration parameters, the operation sets the values for the secret and then immediately
starts a rotation. If you don't include the configuration parameters, the operation starts
a rotation with the values already stored in the secret.  When rotation is successful, the
AWSPENDING staging label might be attached to the same version as the AWSCURRENT version,
or it might not be attached to any version. If the AWSPENDING staging label is present but
not attached to the same version as AWSCURRENT, then any later invocation of RotateSecret
assumes that a previous rotation request is still in progress and returns an error. When
rotation is unsuccessful, the AWSPENDING staging label might be attached to an empty secret
version. For more information, see Troubleshoot rotation in the Secrets Manager User Guide.
Secrets Manager generates a CloudTrail log entry when you call this action. Do not include
sensitive information in request parameters because it might be logged. For more
information, see Logging Secrets Manager events with CloudTrail.  Required permissions:
secretsmanager:RotateSecret. For more information, see  IAM policy actions for Secrets
Manager and Authentication and access control in Secrets Manager. You also need
lambda:InvokeFunction permissions on the rotation function. For more information, see
Permissions for rotation.

# Arguments
- `secret_id`: The ARN or name of the secret to rotate. For an ARN, we recommend that you
  specify a complete ARN rather than a partial ARN. See Finding a secret from a partial ARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: A unique identifier for the new version of the secret. You only
  need to specify this value if you implement your own retry logic and you want to ensure
  that Secrets Manager doesn't attempt to create a secret version twice.  If you use the
  Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then
  you can leave this parameter empty. The CLI or SDK generates a random UUID for you and
  includes it as the value for this parameter in the request.   If you generate a raw HTTP
  request to the Secrets Manager service endpoint, then you must generate a
  ClientRequestToken and include it in the request. This value helps ensure idempotency.
  Secrets Manager uses this value to prevent the accidental creation of duplicate versions if
  there are failures and retries during a rotation. We recommend that you generate a
  UUID-type value to ensure uniqueness of your versions within the specified secret.
- `"RotateImmediately"`: Specifies whether to rotate the secret immediately or wait until
  the next scheduled rotation window. The rotation schedule is defined in
  RotateSecretRequestRotationRules. For secrets that use a Lambda rotation function to
  rotate, if you don't immediately rotate the secret, Secrets Manager tests the rotation
  configuration by running the  testSecret step of the Lambda rotation function. The test
  creates an AWSPENDING version of the secret and then removes it. By default, Secrets
  Manager rotates the secret immediately.
- `"RotationLambdaARN"`: For secrets that use a Lambda rotation function to rotate, the ARN
  of the Lambda rotation function.  For secrets that use managed rotation, omit this field.
  For more information, see Managed rotation in the Secrets Manager User Guide.
- `"RotationRules"`: A structure that defines the rotation configuration for this secret.
"""
function rotate_secret(SecretId; aws_config::AbstractAWSConfig=current_aws_config())
    return secrets_manager(
        "RotateSecret",
        Dict{String,Any}("SecretId" => SecretId, "ClientRequestToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function rotate_secret(
    SecretId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "RotateSecret",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SecretId" => SecretId, "ClientRequestToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_replication_to_replica(secret_id)
    stop_replication_to_replica(secret_id, params::Dict{String,<:Any})

Removes the link between the replica secret and the primary secret and promotes the replica
to a primary secret in the replica Region. You must call this operation from the Region in
which you want to promote the replica to a primary secret. Secrets Manager generates a
CloudTrail log entry when you call this action. Do not include sensitive information in
request parameters because it might be logged. For more information, see Logging Secrets
Manager events with CloudTrail.  Required permissions:
secretsmanager:StopReplicationToReplica. For more information, see  IAM policy actions for
Secrets Manager and Authentication and access control in Secrets Manager.

# Arguments
- `secret_id`: The ARN of the primary secret.

"""
function stop_replication_to_replica(
    SecretId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return secrets_manager(
        "StopReplicationToReplica",
        Dict{String,Any}("SecretId" => SecretId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_replication_to_replica(
    SecretId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "StopReplicationToReplica",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SecretId" => SecretId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(secret_id, tags)
    tag_resource(secret_id, tags, params::Dict{String,<:Any})

Attaches tags to a secret. Tags consist of a key name and a value. Tags are part of the
secret's metadata. They are not associated with specific versions of the secret. This
operation appends tags to the existing list of tags. For tag quotas and naming
restrictions, see Service quotas for Tagging in the Amazon Web Services General Reference
guide.  If you use tags as part of your security strategy, then adding or removing a tag
can change permissions. If successfully completing this operation would result in you
losing your permissions for this secret, then the operation is blocked and returns an
Access Denied error.  Secrets Manager generates a CloudTrail log entry when you call this
action. Do not include sensitive information in request parameters because it might be
logged. For more information, see Logging Secrets Manager events with CloudTrail.  Required
permissions:  secretsmanager:TagResource. For more information, see  IAM policy actions for
Secrets Manager and Authentication and access control in Secrets Manager.

# Arguments
- `secret_id`: The identifier for the secret to attach tags to. You can specify either the
  Amazon Resource Name (ARN) or the friendly name of the secret. For an ARN, we recommend
  that you specify a complete ARN rather than a partial ARN. See Finding a secret from a
  partial ARN.
- `tags`: The tags to attach to the secret as a JSON text string argument. Each element in
  the list consists of a Key and a Value. For storing multiple values, we recommend that you
  use a JSON text string argument and specify key/value pairs. For more information, see
  Specifying parameter values for the Amazon Web Services CLI in the Amazon Web Services CLI
  User Guide.

"""
function tag_resource(SecretId, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return secrets_manager(
        "TagResource",
        Dict{String,Any}("SecretId" => SecretId, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    SecretId,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("SecretId" => SecretId, "Tags" => Tags), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(secret_id, tag_keys)
    untag_resource(secret_id, tag_keys, params::Dict{String,<:Any})

Removes specific tags from a secret. This operation is idempotent. If a requested tag is
not attached to the secret, no error is returned and the secret metadata is unchanged.  If
you use tags as part of your security strategy, then removing a tag can change permissions.
If successfully completing this operation would result in you losing your permissions for
this secret, then the operation is blocked and returns an Access Denied error.  Secrets
Manager generates a CloudTrail log entry when you call this action. Do not include
sensitive information in request parameters because it might be logged. For more
information, see Logging Secrets Manager events with CloudTrail.  Required permissions:
secretsmanager:UntagResource. For more information, see  IAM policy actions for Secrets
Manager and Authentication and access control in Secrets Manager.

# Arguments
- `secret_id`: The ARN or name of the secret. For an ARN, we recommend that you specify a
  complete ARN rather than a partial ARN. See Finding a secret from a partial ARN.
- `tag_keys`: A list of tag key names to remove from the secret. You don't specify the
  value. Both the key and its associated value are removed. This parameter requires a JSON
  text string argument. For storing multiple values, we recommend that you use a JSON text
  string argument and specify key/value pairs. For more information, see Specifying parameter
  values for the Amazon Web Services CLI in the Amazon Web Services CLI User Guide.

"""
function untag_resource(
    SecretId, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return secrets_manager(
        "UntagResource",
        Dict{String,Any}("SecretId" => SecretId, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    SecretId,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SecretId" => SecretId, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_secret(secret_id)
    update_secret(secret_id, params::Dict{String,<:Any})

Modifies the details of a secret, including metadata and the secret value. To change the
secret value, you can also use PutSecretValue. To change the rotation configuration of a
secret, use RotateSecret instead. To change a secret so that it is managed by another
service, you need to recreate the secret in that service. See Secrets Manager secrets
managed by other Amazon Web Services services. We recommend you avoid calling UpdateSecret
at a sustained rate of more than once every 10 minutes. When you call UpdateSecret to
update the secret value, Secrets Manager creates a new version of the secret. Secrets
Manager removes outdated versions when there are more than 100, but it does not remove
versions created less than 24 hours ago. If you update the secret value more than once
every 10 minutes, you create more versions than Secrets Manager removes, and you will reach
the quota for secret versions. If you include SecretString or SecretBinary to create a new
secret version, Secrets Manager automatically moves the staging label AWSCURRENT to the new
version. Then it attaches the label AWSPREVIOUS to the version that AWSCURRENT was removed
from. If you call this operation with a ClientRequestToken that matches an existing
version's VersionId, the operation results in an error. You can't modify an existing
version, you can only create a new version. To remove a version, remove all staging labels
from it. See UpdateSecretVersionStage. Secrets Manager generates a CloudTrail log entry
when you call this action. Do not include sensitive information in request parameters
except SecretBinary or SecretString because it might be logged. For more information, see
Logging Secrets Manager events with CloudTrail.  Required permissions:
secretsmanager:UpdateSecret. For more information, see  IAM policy actions for Secrets
Manager and Authentication and access control in Secrets Manager. If you use a customer
managed key, you must also have kms:GenerateDataKey, kms:Encrypt, and kms:Decrypt
permissions on the key. If you change the KMS key and you don't have kms:Encrypt permission
to the new key, Secrets Manager does not re-ecrypt existing secret versions with the new
key. For more information, see  Secret encryption and decryption.

# Arguments
- `secret_id`: The ARN or name of the secret. For an ARN, we recommend that you specify a
  complete ARN rather than a partial ARN. See Finding a secret from a partial ARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: If you include SecretString or SecretBinary, then Secrets Manager
  creates a new version for the secret, and this parameter specifies the unique identifier
  for the new version.  If you use the Amazon Web Services CLI or one of the Amazon Web
  Services SDKs to call this operation, then you can leave this parameter empty. The CLI or
  SDK generates a random UUID for you and includes it as the value for this parameter in the
  request.   If you generate a raw HTTP request to the Secrets Manager service endpoint, then
  you must generate a ClientRequestToken and include it in the request. This value helps
  ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of
  duplicate versions if there are failures and retries during a rotation. We recommend that
  you generate a UUID-type value to ensure uniqueness of your versions within the specified
  secret.
- `"Description"`: The description of the secret.
- `"KmsKeyId"`: The ARN, key ID, or alias of the KMS key that Secrets Manager uses to
  encrypt new secret versions as well as any existing versions with the staging labels
  AWSCURRENT, AWSPENDING, or AWSPREVIOUS. If you don't have kms:Encrypt permission to the new
  key, Secrets Manager does not re-ecrypt existing secret versions with the new key. For more
  information about versions and staging labels, see Concepts: Version. A key alias is always
  prefixed by alias/, for example alias/aws/secretsmanager. For more information, see About
  aliases. If you set this to an empty string, Secrets Manager uses the Amazon Web Services
  managed key aws/secretsmanager. If this key doesn't already exist in your account, then
  Secrets Manager creates it for you automatically. All users and roles in the Amazon Web
  Services account automatically have access to use aws/secretsmanager. Creating
  aws/secretsmanager can result in a one-time significant delay in returning the result.
  You can only use the Amazon Web Services managed key aws/secretsmanager if you call this
  operation using credentials from the same Amazon Web Services account that owns the secret.
  If the secret is in a different account, then you must use a customer managed key and
  provide the ARN of that KMS key in this field. The user making the call must have
  permissions to both the secret and the KMS key in their respective accounts.
- `"SecretBinary"`: The binary data to encrypt and store in the new version of the secret.
  We recommend that you store your binary data in a file and then pass the contents of the
  file as a parameter.  Either SecretBinary or SecretString must have a value, but not both.
  You can't access this parameter in the Secrets Manager console. Sensitive: This field
  contains sensitive information, so the service does not include it in CloudTrail log
  entries. If you create your own log entries, you must also avoid logging the information in
  this field.
- `"SecretString"`: The text data to encrypt and store in the new version of the secret. We
  recommend you use a JSON structure of key/value pairs for your secret value.  Either
  SecretBinary or SecretString must have a value, but not both.  Sensitive: This field
  contains sensitive information, so the service does not include it in CloudTrail log
  entries. If you create your own log entries, you must also avoid logging the information in
  this field.
"""
function update_secret(SecretId; aws_config::AbstractAWSConfig=current_aws_config())
    return secrets_manager(
        "UpdateSecret",
        Dict{String,Any}("SecretId" => SecretId, "ClientRequestToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_secret(
    SecretId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "UpdateSecret",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SecretId" => SecretId, "ClientRequestToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_secret_version_stage(secret_id, version_stage)
    update_secret_version_stage(secret_id, version_stage, params::Dict{String,<:Any})

Modifies the staging labels attached to a version of a secret. Secrets Manager uses staging
labels to track a version as it progresses through the secret rotation process. Each
staging label can be attached to only one version at a time. To add a staging label to a
version when it is already attached to another version, Secrets Manager first removes it
from the other version first and then attaches it to this one. For more information about
versions and staging labels, see Concepts: Version.  The staging labels that you specify in
the VersionStage parameter are added to the existing list of staging labels for the
version.  You can move the AWSCURRENT staging label to this version by including it in this
call.  Whenever you move AWSCURRENT, Secrets Manager automatically moves the label
AWSPREVIOUS to the version that AWSCURRENT was removed from.  If this action results in the
last label being removed from a version, then the version is considered to be 'deprecated'
and can be deleted by Secrets Manager. Secrets Manager generates a CloudTrail log entry
when you call this action. Do not include sensitive information in request parameters
because it might be logged. For more information, see Logging Secrets Manager events with
CloudTrail.  Required permissions:  secretsmanager:UpdateSecretVersionStage. For more
information, see  IAM policy actions for Secrets Manager and Authentication and access
control in Secrets Manager.

# Arguments
- `secret_id`: The ARN or the name of the secret with the version and staging labelsto
  modify. For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.
  See Finding a secret from a partial ARN.
- `version_stage`: The staging label to add to this version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MoveToVersionId"`: The ID of the version to add the staging label to. To remove a label
  from a version, then do not specify this parameter. If the staging label is already
  attached to a different version of the secret, then you must also specify the
  RemoveFromVersionId parameter.
- `"RemoveFromVersionId"`: The ID of the version that the staging label is to be removed
  from. If the staging label you are trying to attach to one version is already attached to a
  different version, then you must include this parameter and specify the version that the
  label is to be removed from. If the label is attached and you either do not specify this
  parameter, or the version ID does not match, then the operation fails.
"""
function update_secret_version_stage(
    SecretId, VersionStage; aws_config::AbstractAWSConfig=current_aws_config()
)
    return secrets_manager(
        "UpdateSecretVersionStage",
        Dict{String,Any}("SecretId" => SecretId, "VersionStage" => VersionStage);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_secret_version_stage(
    SecretId,
    VersionStage,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "UpdateSecretVersionStage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SecretId" => SecretId, "VersionStage" => VersionStage),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    validate_resource_policy(resource_policy)
    validate_resource_policy(resource_policy, params::Dict{String,<:Any})

Validates that a resource policy does not grant a wide range of principals access to your
secret. A resource-based policy is optional for secrets. The API performs three checks when
validating the policy:   Sends a call to Zelkova, an automated reasoning engine, to ensure
your resource policy does not allow broad access to your secret, for example policies that
use a wildcard for the principal.   Checks for correct syntax in a policy.   Verifies the
policy does not lock out a caller.   Secrets Manager generates a CloudTrail log entry when
you call this action. Do not include sensitive information in request parameters because it
might be logged. For more information, see Logging Secrets Manager events with CloudTrail.
Required permissions:  secretsmanager:ValidateResourcePolicy and
secretsmanager:PutResourcePolicy. For more information, see  IAM policy actions for Secrets
Manager and Authentication and access control in Secrets Manager.

# Arguments
- `resource_policy`: A JSON-formatted string that contains an Amazon Web Services
  resource-based policy. The policy in the string identifies who can access or manage this
  secret and its versions. For example policies, see Permissions policy examples.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SecretId"`: The ARN or name of the secret with the resource-based policy you want to
  validate.
"""
function validate_resource_policy(
    ResourcePolicy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return secrets_manager(
        "ValidateResourcePolicy",
        Dict{String,Any}("ResourcePolicy" => ResourcePolicy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function validate_resource_policy(
    ResourcePolicy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return secrets_manager(
        "ValidateResourcePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourcePolicy" => ResourcePolicy), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
