using Documenter, Krylov

makedocs(
  modules = [Krylov],
  doctest = true,
  linkcheck = true,
  linkcheck_ignore = [r"https://www.emis.de/.*"],
  format = Documenter.HTML(assets = ["assets/style.css"],
                           ansicolor = true,
                           prettyurls = get(ENV, "CI", nothing) == "true",
                           collapselevel = 1),
  sitename = "Krylov.jl",
  pages = ["Home" => "index.md",
           "API" => "api.md",
           "Krylov processes" => "processes.md",
           "Block Krylov processes" => "block_processes.md",
           "Krylov methods" => ["Hermitian positive definite linear systems" => "solvers/spd.md",
                                "Hermitian indefinite linear systems" => "solvers/sid.md",
                                "Non-Hermitian square linear systems" => "solvers/unsymmetric.md",
                                "Least-norm problems" => "solvers/ln.md",
                                "Least-squares problems" => "solvers/ls.md",
                                "Adjoint systems" => "solvers/as.md",
                                "Saddle-point and Hermitian quasi-definite systems" => "solvers/sp_sqd.md",
                                "Generalized saddle-point and non-Hermitian partitioned systems" => "solvers/gsp.md"],
           "Block Krylov methods" => "block_krylov.md",
           "In-place methods" => "inplace.md",
           "Generic interface" => "generic_interface.md",
           "Storage requirements" => "storage.md",
           "Preconditioners" => "preconditioners.md",
           "GPU support" => "gpu.md",
           "Warm-start" => "warm-start.md",
           "Matrix-free operators" => "matrix_free.md",
           "Callbacks" => "callbacks.md",
           "Custom workspaces" => "custom_workspaces.md",
           "Performance tips" => "tips.md",
           "Tutorials" => ["CG" => "examples/cg.md",
                           "CAR" => "examples/car.md",
                           "CG-LANCZOS-SHIFT" => "examples/cg_lanczos_shift.md",
                           "SYMMLQ" => "examples/symmlq.md",
                           "MINRES-QLP" => "examples/minres_qlp.md",
                           "MINARES" => "examples/minares.md",
                           "TriCG" => "examples/tricg.md",
                           "TriMR" => "examples/trimr.md",
                           "BICGSTAB" => "examples/bicgstab.md",
                           "DQGMRES" => "examples/dqgmres.md",
                           "BLOCK-GMRES" => "examples/block_gmres.md",
                           "CGNE" => "examples/cgne.md",
                           "CRMR" => "examples/crmr.md",
                           "CRAIG" => "examples/craig.md",
                           "CRAIGMR" => "examples/craigmr.md",
                           "CGLS" => "examples/cgls.md",
                           "CGLS-LANCZOS-SHIFT" => "examples/cgls_lanczos_shift.md",
                           "CRLS" => "examples/crls.md",
                           "LSQR" => "examples/lsqr.md",
                           "LSMR" => "examples/lsmr.md"],
           "Reference" => "reference.md"
          ]
)

deploydocs(
  repo = "github.com/JuliaSmoothOptimizers/Krylov.jl.git",
  push_preview = true,
  devbranch = "main",
)
