# Orthogonal and Unitary matrices

Both [`OrthogonalMatrices`](@ref) and [`UnitaryMatrices`](@ref) have similar formulae and implementations, as are [`Rotations`](@ref), as well as unitary matrices with determinant equal to one. These share a [common implementation](@ref Manifolds.GeneralUnitaryMatrices).

## Orthogonal matrices

```@autodocs
Modules = [Manifolds]
Pages = ["manifolds/Orthogonal.jl"]
Order = [:constant, :type, :function]
```

## Unitary matrices

```@autodocs
Modules = [Manifolds]
Pages = ["manifolds/Unitary.jl"]
Order = [:constant, :type, :function]
```

## Special Unitary matrices

```@autodocs
Modules = [Manifolds]
Pages = ["manifolds/SpecialUnitary.jl"]
Order = [:constant, :type, :function]
```

## [Common functions](@id generalunitarymatrices)

```@autodocs
Modules = [Manifolds]
Pages = ["manifolds/GeneralUnitaryMatrices.jl"]
Order = [:constant, :type, :function]
```
## Footnotes and References