# Copyright (c) 2017: Miles Lubin and contributors
# Copyright (c) 2017: Google Inc.
#
# Use of this source code is governed by an MIT-style license that can be found
# in the LICENSE.md file or at https://opensource.org/licenses/MIT.

#! format:off

# This file is machine generated by running univariate_expressions_generator.jl

const SYMBOLIC_UNIVARIATE_EXPRESSIONS = Tuple{Symbol,Expr,Any}[
    (:+, :(one(x)), :(zero(x))),
    (:-, :(-one(x)), :(zero(x))),
    (:abs, :(ifelse(x >= 0, one(x), -one(x))), :(zero(x))),
    (:sign, :(zero(x)), :(zero(x))),
    (:sqrt, :(0.5 / sqrt(x)), :((0.5 * -(0.5 / sqrt(x))) / sqrt(x) ^ 2)),
    (:cbrt, :(0.3333333333333333 / cbrt(x) ^ 2), :((0.3333333333333333 * -(2 * (0.3333333333333333 / cbrt(x) ^ 2) * cbrt(x))) / (cbrt(x) ^ 2) ^ 2)),
    (:abs2, :(2x), :((typeof(x))(2))),
    (:inv, :(-(abs2(inv(x)))), :(-(-(abs2(inv(x))) * (2 * inv(x))))),
    (:log, :(1 / x), :(-1 / x ^ 2)),
    (:log10, :((1 / x) / 2.302585092994046), :((-1 / x ^ 2) / 2.302585092994046)),
    (:log2, :((1 / x) / 0.6931471805599453), :((-1 / x ^ 2) / 0.6931471805599453)),
    (:log1p, :(1 / (1 + x)), :(-1 / (1 + x) ^ 2)),
    (:exp, :(exp(x)), :(exp(x))),
    (:exp2, :(0.6931471805599453 * exp2(x)), :(0.6931471805599453 * (0.6931471805599453 * exp2(x)))),
    (:expm1, :(exp(x)), :(exp(x))),
    (:sin, :(cos(x)), :(-(sin(x)))),
    (:cos, :(-(sin(x))), :(-(cos(x)))),
    (:tan, :(1 + tan(x) ^ 2), :(2 * (1 + tan(x) ^ 2) * tan(x))),
    (:sec, :(sec(x) * tan(x)), :((sec(x) * tan(x)) * tan(x) + sec(x) * (1 + tan(x) ^ 2))),
    (:csc, :(-(csc(x)) * cot(x)), :(-(-(csc(x)) * cot(x)) * cot(x) + -(csc(x)) * -((1 + cot(x) ^ 2)))),
    (:cot, :(-((1 + cot(x) ^ 2))), :(-(2 * -((1 + cot(x) ^ 2)) * cot(x)))),
    (:sind, :(0.017453292519943295 * cosd(x)), :(0.017453292519943295 * (-0.017453292519943295 * sind(x)))),
    (:cosd, :(-0.017453292519943295 * sind(x)), :(-0.017453292519943295 * (0.017453292519943295 * cosd(x)))),
    (:tand, :(0.017453292519943295 * (1 + tand(x) ^ 2)), :(0.017453292519943295 * (2 * (0.017453292519943295 * (1 + tand(x) ^ 2)) * tand(x)))),
    (:secd, :(0.017453292519943295 * secd(x) * tand(x)), :(0.017453292519943295 * (0.017453292519943295 * secd(x) * tand(x)) * tand(x) + 0.017453292519943295 * secd(x) * (0.017453292519943295 * (1 + tand(x) ^ 2)))),
    (:cscd, :(-0.017453292519943295 * cscd(x) * cotd(x)), :(-0.017453292519943295 * (-0.017453292519943295 * cscd(x) * cotd(x)) * cotd(x) + -0.017453292519943295 * cscd(x) * (-0.017453292519943295 * (1 + cotd(x) ^ 2)))),
    (:cotd, :(-0.017453292519943295 * (1 + cotd(x) ^ 2)), :(-0.017453292519943295 * (2 * (-0.017453292519943295 * (1 + cotd(x) ^ 2)) * cotd(x)))),
    (:asin, :(1 / sqrt(1 - x ^ 2)), :(-(-(2x) * (0.5 / sqrt(1 - x ^ 2))) / sqrt(1 - x ^ 2) ^ 2)),
    (:acos, :(-1 / sqrt(1 - x ^ 2)), :(-(-(-(2x) * (0.5 / sqrt(1 - x ^ 2)))) / sqrt(1 - x ^ 2) ^ 2)),
    (:atan, :(1 / (1 + x ^ 2)), :(-(2x) / (1 + x ^ 2) ^ 2)),
    (:asec, :((1 / abs(x)) / sqrt(x ^ 2 - 1)), :(nothing)),
    (:acsc, :((-1 / abs(x)) / sqrt(x ^ 2 - 1)), :(nothing)),
    (:acot, :(-1 / (1 + x ^ 2)), :(-(-(2x)) / (1 + x ^ 2) ^ 2)),
    (:asind, :(57.29577951308232 / sqrt(1 - x ^ 2)), :((57.29577951308232 * -(-(2x) * (0.5 / sqrt(1 - x ^ 2)))) / sqrt(1 - x ^ 2) ^ 2)),
    (:acosd, :(-57.29577951308232 / sqrt(1 - x ^ 2)), :((-57.29577951308232 * -(-(2x) * (0.5 / sqrt(1 - x ^ 2)))) / sqrt(1 - x ^ 2) ^ 2)),
    (:atand, :(57.29577951308232 / (1 + x ^ 2)), :((57.29577951308232 * -(2x)) / (1 + x ^ 2) ^ 2)),
    (:asecd, :((57.29577951308232 / abs(x)) / sqrt(x ^ 2 - 1)), :(nothing)),
    (:acscd, :((-57.29577951308232 / abs(x)) / sqrt(x ^ 2 - 1)), :(nothing)),
    (:acotd, :(-57.29577951308232 / (1 + x ^ 2)), :((-57.29577951308232 * -(2x)) / (1 + x ^ 2) ^ 2)),
    (:sinh, :(cosh(x)), :(sinh(x))),
    (:cosh, :(sinh(x)), :(cosh(x))),
    (:tanh, :(sech(x) ^ 2), :(2 * (-(tanh(x)) * sech(x)) * sech(x))),
    (:sech, :(-(tanh(x)) * sech(x)), :(-(sech(x) ^ 2) * sech(x) + -(tanh(x)) * (-(tanh(x)) * sech(x)))),
    (:csch, :(-(coth(x)) * csch(x)), :(-(-(csch(x) ^ 2)) * csch(x) + -(coth(x)) * (-(coth(x)) * csch(x)))),
    (:coth, :(-(csch(x) ^ 2)), :(-(2 * (-(coth(x)) * csch(x)) * csch(x)))),
    (:asinh, :(1 / sqrt(1 + x ^ 2)), :(-((2x) * (0.5 / sqrt(1 + x ^ 2))) / sqrt(1 + x ^ 2) ^ 2)),
    (:acosh, :(1 / sqrt(x ^ 2 - 1)), :(-((2x) * (0.5 / sqrt(x ^ 2 - 1))) / sqrt(x ^ 2 - 1) ^ 2)),
    (:atanh, :(1 / (1 - x ^ 2)), :(-(-(2x)) / (1 - x ^ 2) ^ 2)),
    (:asech, :((-1 / x) / sqrt(1 - x ^ 2)), :(((1 / x ^ 2) * sqrt(1 - x ^ 2) - (-1 / x) * (-(2x) * (0.5 / sqrt(1 - x ^ 2)))) / sqrt(1 - x ^ 2) ^ 2)),
    (:acsch, :((-1 / abs(x)) / sqrt(1 + x ^ 2)), :(nothing)),
    (:acoth, :(1 / (1 - x ^ 2)), :(-(-(2x)) / (1 - x ^ 2) ^ 2)),
    (:deg2rad, :((typeof(x))(0.017453292519943295)), :((typeof(x))(0))),
    (:rad2deg, :((typeof(x))(57.29577951308232)), :((typeof(x))(0))),
    (:erf, :((2 * exp(-x * x)) / 1.7724538509055159), :((2 * ((-x + -x) * exp(-x * x))) / 1.7724538509055159)),
    (:erfinv, :(0.8862269254527579 * exp(erfinv(x) * erfinv(x))), :(0.8862269254527579 * (((0.8862269254527579 * exp(erfinv(x) * erfinv(x))) * erfinv(x) + erfinv(x) * (0.8862269254527579 * exp(erfinv(x) * erfinv(x)))) * exp(erfinv(x) * erfinv(x))))),
    (:erfc, :((-2 * exp(-x * x)) / 1.7724538509055159), :((-2 * ((-x + -x) * exp(-x * x))) / 1.7724538509055159)),
    (:erfcinv, :(-0.8862269254527579 * exp(erfcinv(x) * erfcinv(x))), :(-0.8862269254527579 * (((-0.8862269254527579 * exp(erfcinv(x) * erfcinv(x))) * erfcinv(x) + erfcinv(x) * (-0.8862269254527579 * exp(erfcinv(x) * erfcinv(x)))) * exp(erfcinv(x) * erfcinv(x))))),
    (:erfi, :((2 * exp(x * x)) / 1.7724538509055159), :((2 * ((x + x) * exp(x * x))) / 1.7724538509055159)),
    (:gamma, :(digamma(x) * gamma(x)), :(trigamma(x) * gamma(x) + digamma(x) * (digamma(x) * gamma(x)))),
    (:lgamma, :(digamma(x)), :(trigamma(x))),
    (:digamma, :(trigamma(x)), :(polygamma(2, x))),
    (:invdigamma, :(inv(trigamma(invdigamma(x)))), :((inv(trigamma(invdigamma(x))) * polygamma(2, invdigamma(x))) * -(abs2(inv(trigamma(invdigamma(x))))))),
    (:trigamma, :(polygamma(2, x)), :(nothing)),
    (:airyai, :(airyaiprime(x)), :(x * airyai(x))),
    (:airybi, :(airybiprime(x)), :(x * airybi(x))),
    (:airyaiprime, :(x * airyai(x)), :(airyai(x) + x * airyaiprime(x))),
    (:airybiprime, :(x * airybi(x)), :(airybi(x) + x * airybiprime(x))),
    (:besselj0, :(-(besselj1(x))), :(-((besselj0(x) - besselj(2, x)) / 2))),
    (:besselj1, :((besselj0(x) - besselj(2, x)) / 2), :((-(besselj1(x)) - (besselj(1, x) - besselj(3, x)) / 2) / 2)),
    (:bessely0, :(-(bessely1(x))), :(-((bessely0(x) - bessely(2, x)) / 2))),
    (:bessely1, :((bessely0(x) - bessely(2, x)) / 2), :((-(bessely1(x)) - (bessely(1, x) - bessely(3, x)) / 2) / 2)),
    (:erfcx, :(2 * x * erfcx(x) - 1.1283791670955126), :(2 * erfcx(x) + 2 * x * (2 * x * erfcx(x) - 1.1283791670955126))),
    (:dawson, :(1 - (2x) * dawson(x)), :(-((2 * dawson(x) + (2x) * (1 - (2x) * dawson(x)))))),
]
