# Tutorials

- [Start with the tutorial](@ref tutorial)
- [Section from Chris Rackauckas' awesome earlier tutorial](https://ucidatascienceinitiative.github.io/IntroToJulia/Html/PlotsJL)
- [Machine Learning and Visualization in Julia](https://www.breloff.com/JuliaML-and-Plots/)
- [Quant Econ tutorial](https://lectures.quantecon.org/jl/julia_plots.html#plotsjl-jl)
- [Plotting section of a Julia wiki](https://en.wikibooks.org/wiki/Introducing_Julia/Plotting)
- [How do Recipes actually work?](https://daschw.github.io/recipes/)

# Demos, Examples and Notebooks

- [Visualizing Graphs in Julia using Plots and PlotRecipes](https://www.breloff.com/Graphs/)
- [ExamplePlots](https://github.com/JuliaPlots/ExamplePlots.jl)
- [Some notebooks](https://github.com/tbreloff/notebooks)

# Reference sheets

- [A one-page Plots.jl cheatsheet](https://github.com/sswatson/cheatsheets/blob/master/plotsjl-cheatsheet.pdf)

# Video tutorials

### Plots with Plots - JuliaCon 2016

```@raw html
<iframe width="560" height="315" src="https://www.youtube.com/embed/LGB8GvAL4HA" frameborder="0" allowfullscreen></iframe>
```
### Ecosystem and Pipeline

https://www.breloff.com/plots-video/

```@raw html
<iframe width="560" height="315" src="https://www.youtube.com/embed/Iof7Ccm8UiM" frameborder="0" allowfullscreen></iframe>
```
