
@noinline __throw_absent_groebner_engine() = throw(
    """Groebner bases engine is required. Execute `using Groebner` to enable this functionality.""")

"""
    groebner_basis(polynomials; kwargs...)

Computes a Groebner basis of the ideal generated by the given `polynomials`
using Groebner.jl as the backend.

!!! note
    This function requires a Groebner bases backend (such as Groebner.jl) to be loaded.

The basis is guaranteed to be unique.
The algorithm is randomized, and the output is correct with high probability.

If a coefficient in the resulting basis becomes too large to be represented
exactly, `DomainError` is thrown.

## Optional Arguments

The Groebner.jl backend provides a number of useful keyword arguments, which are
also available for this function. See `?Groebner.groebner`.

## Example

```jldoctest
julia> using Symbolics, Groebner

julia> @variables x y;

julia> groebner_basis([x*y^2 + x, x^2*y + y])
```
"""
function groebner_basis(args; kwargs...)
    __throw_absent_groebner_engine()
end

"""
    groebner_basis(polynomials)

Checks whether the given `polynomials` forms a Groebner basis.

This function requires a Groebner bases backend (such as Groebner.jl) to be loaded.
"""
function is_groebner_basis(args; kwargs...)
    __throw_absent_groebner_engine()
end
