// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    ffi, PageSetup, PrintContext, PrintOperationAction, PrintOperationPreview,
    PrintOperationResult, PrintSettings, PrintStatus, Unit, Widget, Window,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkPrintOperation")]
    pub struct PrintOperation(Object<ffi::GtkPrintOperation, ffi::GtkPrintOperationClass>) @implements PrintOperationPreview;

    match fn {
        type_ => || ffi::gtk_print_operation_get_type(),
    }
}

impl PrintOperation {
    pub const NONE: Option<&'static PrintOperation> = None;

    #[doc(alias = "gtk_print_operation_new")]
    pub fn new() -> PrintOperation {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_print_operation_new()) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`PrintOperation`] objects.
    ///
    /// This method returns an instance of [`PrintOperationBuilder`](crate::builders::PrintOperationBuilder) which can be used to create [`PrintOperation`] objects.
    pub fn builder() -> PrintOperationBuilder {
        PrintOperationBuilder::new()
    }
}

impl Default for PrintOperation {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`PrintOperation`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct PrintOperationBuilder {
    builder: glib::object::ObjectBuilder<'static, PrintOperation>,
}

impl PrintOperationBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn allow_async(self, allow_async: bool) -> Self {
        Self {
            builder: self.builder.property("allow-async", allow_async),
        }
    }

    pub fn current_page(self, current_page: i32) -> Self {
        Self {
            builder: self.builder.property("current-page", current_page),
        }
    }

    pub fn custom_tab_label(self, custom_tab_label: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("custom-tab-label", custom_tab_label.into()),
        }
    }

    pub fn default_page_setup(self, default_page_setup: &PageSetup) -> Self {
        Self {
            builder: self
                .builder
                .property("default-page-setup", default_page_setup.clone()),
        }
    }

    pub fn embed_page_setup(self, embed_page_setup: bool) -> Self {
        Self {
            builder: self.builder.property("embed-page-setup", embed_page_setup),
        }
    }

    pub fn export_filename(self, export_filename: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("export-filename", export_filename.into()),
        }
    }

    pub fn has_selection(self, has_selection: bool) -> Self {
        Self {
            builder: self.builder.property("has-selection", has_selection),
        }
    }

    pub fn job_name(self, job_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("job-name", job_name.into()),
        }
    }

    pub fn n_pages(self, n_pages: i32) -> Self {
        Self {
            builder: self.builder.property("n-pages", n_pages),
        }
    }

    pub fn print_settings(self, print_settings: &PrintSettings) -> Self {
        Self {
            builder: self
                .builder
                .property("print-settings", print_settings.clone()),
        }
    }

    pub fn show_progress(self, show_progress: bool) -> Self {
        Self {
            builder: self.builder.property("show-progress", show_progress),
        }
    }

    pub fn support_selection(self, support_selection: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("support-selection", support_selection),
        }
    }

    pub fn track_print_status(self, track_print_status: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("track-print-status", track_print_status),
        }
    }

    pub fn unit(self, unit: Unit) -> Self {
        Self {
            builder: self.builder.property("unit", unit),
        }
    }

    pub fn use_full_page(self, use_full_page: bool) -> Self {
        Self {
            builder: self.builder.property("use-full-page", use_full_page),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`PrintOperation`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> PrintOperation {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::PrintOperation>> Sealed for T {}
}

pub trait PrintOperationExt: IsA<PrintOperation> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_print_operation_cancel")]
    fn cancel(&self) {
        unsafe {
            ffi::gtk_print_operation_cancel(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_print_operation_draw_page_finish")]
    fn draw_page_finish(&self) {
        unsafe {
            ffi::gtk_print_operation_draw_page_finish(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_print_operation_get_default_page_setup")]
    #[doc(alias = "get_default_page_setup")]
    #[doc(alias = "default-page-setup")]
    fn default_page_setup(&self) -> PageSetup {
        unsafe {
            from_glib_none(ffi::gtk_print_operation_get_default_page_setup(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_print_operation_get_embed_page_setup")]
    #[doc(alias = "get_embed_page_setup")]
    #[doc(alias = "embed-page-setup")]
    fn embeds_page_setup(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_print_operation_get_embed_page_setup(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_print_operation_get_has_selection")]
    #[doc(alias = "get_has_selection")]
    #[doc(alias = "has-selection")]
    fn has_selection(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_print_operation_get_has_selection(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_print_operation_get_n_pages_to_print")]
    #[doc(alias = "get_n_pages_to_print")]
    #[doc(alias = "n-pages-to-print")]
    fn n_pages_to_print(&self) -> i32 {
        unsafe { ffi::gtk_print_operation_get_n_pages_to_print(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_print_operation_get_print_settings")]
    #[doc(alias = "get_print_settings")]
    #[doc(alias = "print-settings")]
    fn print_settings(&self) -> Option<PrintSettings> {
        unsafe {
            from_glib_none(ffi::gtk_print_operation_get_print_settings(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_print_operation_get_status")]
    #[doc(alias = "get_status")]
    fn status(&self) -> PrintStatus {
        unsafe {
            from_glib(ffi::gtk_print_operation_get_status(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_print_operation_get_status_string")]
    #[doc(alias = "get_status_string")]
    #[doc(alias = "status-string")]
    fn status_string(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::gtk_print_operation_get_status_string(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_print_operation_get_support_selection")]
    #[doc(alias = "get_support_selection")]
    #[doc(alias = "support-selection")]
    fn supports_selection(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_print_operation_get_support_selection(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_print_operation_is_finished")]
    fn is_finished(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_print_operation_is_finished(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_print_operation_run")]
    fn run(
        &self,
        action: PrintOperationAction,
        parent: Option<&impl IsA<Window>>,
    ) -> Result<PrintOperationResult, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::gtk_print_operation_run(
                self.as_ref().to_glib_none().0,
                action.into_glib(),
                parent.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gtk_print_operation_set_allow_async")]
    #[doc(alias = "allow-async")]
    fn set_allow_async(&self, allow_async: bool) {
        unsafe {
            ffi::gtk_print_operation_set_allow_async(
                self.as_ref().to_glib_none().0,
                allow_async.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_print_operation_set_current_page")]
    #[doc(alias = "current-page")]
    fn set_current_page(&self, current_page: i32) {
        unsafe {
            ffi::gtk_print_operation_set_current_page(self.as_ref().to_glib_none().0, current_page);
        }
    }

    #[doc(alias = "gtk_print_operation_set_custom_tab_label")]
    #[doc(alias = "custom-tab-label")]
    fn set_custom_tab_label(&self, label: Option<&str>) {
        unsafe {
            ffi::gtk_print_operation_set_custom_tab_label(
                self.as_ref().to_glib_none().0,
                label.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_print_operation_set_default_page_setup")]
    #[doc(alias = "default-page-setup")]
    fn set_default_page_setup(&self, default_page_setup: Option<&PageSetup>) {
        unsafe {
            ffi::gtk_print_operation_set_default_page_setup(
                self.as_ref().to_glib_none().0,
                default_page_setup.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_print_operation_set_defer_drawing")]
    fn set_defer_drawing(&self) {
        unsafe {
            ffi::gtk_print_operation_set_defer_drawing(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_print_operation_set_embed_page_setup")]
    #[doc(alias = "embed-page-setup")]
    fn set_embed_page_setup(&self, embed: bool) {
        unsafe {
            ffi::gtk_print_operation_set_embed_page_setup(
                self.as_ref().to_glib_none().0,
                embed.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_print_operation_set_export_filename")]
    #[doc(alias = "export-filename")]
    fn set_export_filename(&self, filename: impl AsRef<std::path::Path>) {
        unsafe {
            ffi::gtk_print_operation_set_export_filename(
                self.as_ref().to_glib_none().0,
                filename.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_print_operation_set_has_selection")]
    #[doc(alias = "has-selection")]
    fn set_has_selection(&self, has_selection: bool) {
        unsafe {
            ffi::gtk_print_operation_set_has_selection(
                self.as_ref().to_glib_none().0,
                has_selection.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_print_operation_set_job_name")]
    #[doc(alias = "job-name")]
    fn set_job_name(&self, job_name: &str) {
        unsafe {
            ffi::gtk_print_operation_set_job_name(
                self.as_ref().to_glib_none().0,
                job_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_print_operation_set_n_pages")]
    #[doc(alias = "n-pages")]
    fn set_n_pages(&self, n_pages: i32) {
        unsafe {
            ffi::gtk_print_operation_set_n_pages(self.as_ref().to_glib_none().0, n_pages);
        }
    }

    #[doc(alias = "gtk_print_operation_set_print_settings")]
    #[doc(alias = "print-settings")]
    fn set_print_settings(&self, print_settings: Option<&PrintSettings>) {
        unsafe {
            ffi::gtk_print_operation_set_print_settings(
                self.as_ref().to_glib_none().0,
                print_settings.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_print_operation_set_show_progress")]
    #[doc(alias = "show-progress")]
    fn set_show_progress(&self, show_progress: bool) {
        unsafe {
            ffi::gtk_print_operation_set_show_progress(
                self.as_ref().to_glib_none().0,
                show_progress.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_print_operation_set_support_selection")]
    #[doc(alias = "support-selection")]
    fn set_support_selection(&self, support_selection: bool) {
        unsafe {
            ffi::gtk_print_operation_set_support_selection(
                self.as_ref().to_glib_none().0,
                support_selection.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_print_operation_set_track_print_status")]
    #[doc(alias = "track-print-status")]
    fn set_track_print_status(&self, track_status: bool) {
        unsafe {
            ffi::gtk_print_operation_set_track_print_status(
                self.as_ref().to_glib_none().0,
                track_status.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_print_operation_set_unit")]
    #[doc(alias = "unit")]
    fn set_unit(&self, unit: Unit) {
        unsafe {
            ffi::gtk_print_operation_set_unit(self.as_ref().to_glib_none().0, unit.into_glib());
        }
    }

    #[doc(alias = "gtk_print_operation_set_use_full_page")]
    #[doc(alias = "use-full-page")]
    fn set_use_full_page(&self, full_page: bool) {
        unsafe {
            ffi::gtk_print_operation_set_use_full_page(
                self.as_ref().to_glib_none().0,
                full_page.into_glib(),
            );
        }
    }

    #[doc(alias = "allow-async")]
    fn allows_async(&self) -> bool {
        ObjectExt::property(self.as_ref(), "allow-async")
    }

    #[doc(alias = "current-page")]
    fn current_page(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "current-page")
    }

    #[doc(alias = "custom-tab-label")]
    fn custom_tab_label(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "custom-tab-label")
    }

    #[doc(alias = "export-filename")]
    fn export_filename(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "export-filename")
    }

    #[doc(alias = "job-name")]
    fn job_name(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "job-name")
    }

    #[doc(alias = "n-pages")]
    fn n_pages(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "n-pages")
    }

    #[doc(alias = "show-progress")]
    fn shows_progress(&self) -> bool {
        ObjectExt::property(self.as_ref(), "show-progress")
    }

    #[doc(alias = "track-print-status")]
    fn tracks_print_status(&self) -> bool {
        ObjectExt::property(self.as_ref(), "track-print-status")
    }

    fn unit(&self) -> Unit {
        ObjectExt::property(self.as_ref(), "unit")
    }

    #[doc(alias = "use-full-page")]
    fn uses_full_page(&self) -> bool {
        ObjectExt::property(self.as_ref(), "use-full-page")
    }

    #[doc(alias = "begin-print")]
    fn connect_begin_print<F: Fn(&Self, &PrintContext) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn begin_print_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P, &PrintContext) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            context: *mut ffi::GtkPrintContext,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                PrintOperation::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(context),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"begin-print\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    begin_print_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "create-custom-widget")]
    fn connect_create_custom_widget<F: Fn(&Self) -> Option<glib::Object> + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn create_custom_widget_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) -> Option<glib::Object> + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            f: glib::ffi::gpointer,
        ) -> *mut glib::gobject_ffi::GObject {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref()) /*Not checked*/
                .to_glib_none()
                .0
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"create-custom-widget\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    create_custom_widget_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "custom-widget-apply")]
    fn connect_custom_widget_apply<F: Fn(&Self, &Widget) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn custom_widget_apply_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P, &Widget) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            widget: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                PrintOperation::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(widget),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"custom-widget-apply\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    custom_widget_apply_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "done")]
    fn connect_done<F: Fn(&Self, PrintOperationResult) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn done_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P, PrintOperationResult) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            result: ffi::GtkPrintOperationResult,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                PrintOperation::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(result),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"done\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    done_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "draw-page")]
    fn connect_draw_page<F: Fn(&Self, &PrintContext, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn draw_page_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P, &PrintContext, i32) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            context: *mut ffi::GtkPrintContext,
            page_nr: std::ffi::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                PrintOperation::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(context),
                page_nr,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"draw-page\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    draw_page_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "end-print")]
    fn connect_end_print<F: Fn(&Self, &PrintContext) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn end_print_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P, &PrintContext) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            context: *mut ffi::GtkPrintContext,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                PrintOperation::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(context),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"end-print\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    end_print_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "paginate")]
    fn connect_paginate<F: Fn(&Self, &PrintContext) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn paginate_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P, &PrintContext) -> bool + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            context: *mut ffi::GtkPrintContext,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                PrintOperation::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(context),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"paginate\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    paginate_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "preview")]
    fn connect_preview<
        F: Fn(&Self, &PrintOperationPreview, &PrintContext, Option<&Window>) -> bool + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn preview_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P, &PrintOperationPreview, &PrintContext, Option<&Window>) -> bool + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            preview: *mut ffi::GtkPrintOperationPreview,
            context: *mut ffi::GtkPrintContext,
            parent: *mut ffi::GtkWindow,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                PrintOperation::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(preview),
                &from_glib_borrow(context),
                Option::<Window>::from_glib_borrow(parent).as_ref().as_ref(),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"preview\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    preview_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "request-page-setup")]
    fn connect_request_page_setup<F: Fn(&Self, &PrintContext, i32, &PageSetup) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn request_page_setup_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P, &PrintContext, i32, &PageSetup) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            context: *mut ffi::GtkPrintContext,
            page_nr: std::ffi::c_int,
            setup: *mut ffi::GtkPageSetup,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                PrintOperation::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(context),
                page_nr,
                &from_glib_borrow(setup),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"request-page-setup\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    request_page_setup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "status-changed")]
    fn connect_status_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn status_changed_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"status-changed\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    status_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "update-custom-widget")]
    fn connect_update_custom_widget<F: Fn(&Self, &Widget, &PageSetup, &PrintSettings) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn update_custom_widget_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P, &Widget, &PageSetup, &PrintSettings) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            widget: *mut ffi::GtkWidget,
            setup: *mut ffi::GtkPageSetup,
            settings: *mut ffi::GtkPrintSettings,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                PrintOperation::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(widget),
                &from_glib_borrow(setup),
                &from_glib_borrow(settings),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"update-custom-widget\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    update_custom_widget_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "allow-async")]
    fn connect_allow_async_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_allow_async_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::allow-async\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_allow_async_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "current-page")]
    fn connect_current_page_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_current_page_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::current-page\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_current_page_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "custom-tab-label")]
    fn connect_custom_tab_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_custom_tab_label_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::custom-tab-label\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_custom_tab_label_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "default-page-setup")]
    fn connect_default_page_setup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_page_setup_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-page-setup\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_default_page_setup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "embed-page-setup")]
    fn connect_embed_page_setup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_embed_page_setup_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::embed-page-setup\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_embed_page_setup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "export-filename")]
    fn connect_export_filename_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_export_filename_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::export-filename\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_export_filename_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "has-selection")]
    fn connect_has_selection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_selection_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::has-selection\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_has_selection_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "job-name")]
    fn connect_job_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_job_name_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::job-name\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_job_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "n-pages")]
    fn connect_n_pages_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_n_pages_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::n-pages\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_n_pages_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "n-pages-to-print")]
    fn connect_n_pages_to_print_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_n_pages_to_print_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::n-pages-to-print\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_n_pages_to_print_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "print-settings")]
    fn connect_print_settings_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_print_settings_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::print-settings\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_print_settings_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "show-progress")]
    fn connect_show_progress_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_progress_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-progress\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_show_progress_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "status")]
    fn connect_status_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_status_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::status\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_status_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "status-string")]
    fn connect_status_string_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_status_string_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::status-string\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_status_string_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "support-selection")]
    fn connect_support_selection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_support_selection_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::support-selection\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_support_selection_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "track-print-status")]
    fn connect_track_print_status_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_track_print_status_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::track-print-status\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_track_print_status_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "unit")]
    fn connect_unit_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_unit_trampoline<P: IsA<PrintOperation>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::unit\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_unit_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "use-full-page")]
    fn connect_use_full_page_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_use_full_page_trampoline<
            P: IsA<PrintOperation>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::use-full-page\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_use_full_page_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<PrintOperation>> PrintOperationExt for O {}
