/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2025 Ethan Chien <liangtie.qian@gmail.com>
 * Copyright (C) 2025 KiCad Developers, see AUTHORS.txt for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#include <common/copilot_dialog.h>
#include <settings/dialog_geometry.h>

#include <settings/webview_settings_manager.h>
#include <wx/event.h>
#include <wx/log.h>
#include <wx/sizer.h>
#include <fmt/format.h>
#include <wx/display.h>
COPILOT_DIALOG::COPILOT_DIALOG( wxWindow* aParent, const wxString& title, const wxString& settingKey,
                                const wxSize& size, const wxPoint& pt, wxWindowID id ) :
        wxDialog( aParent, id, title, wxDefaultPosition, wxDefaultSize, wxDEFAULT_FRAME_STYLE | wxRESIZE_BORDER,
                  settingKey )
{
    const auto geometry = WEBVIEW_SETTINGS_MANAGER::get_instance().get_dialog_geometry( settingKey.ToStdString() );

    if( geometry )
    {
        wxDisplay display( wxDisplay::GetFromWindow( this ) );
        wxRect    screenRect = display.GetClientArea();

        if( geometry->x + geometry->width <= screenRect.GetRight()
            && geometry->y + geometry->height <= screenRect.GetBottom() && geometry->x >= screenRect.GetLeft()
            && geometry->y >= screenRect.GetTop() )
        {
            SetPosition( { geometry->x, geometry->y } );
            SetSize( { geometry->width, geometry->height } );
        }
        else
        {
            SetSize( size );
        }
    }
    else
    {
        SetSize( size );
        SetPosition( pt );
    }


    Bind( wxEVT_CLOSE_WINDOW,
          [=, this]( wxCloseEvent& event )
          {
              const auto pos = GetPosition();
              const auto size = GetSize();
              WEBVIEW_SETTINGS_MANAGER::get_instance().set_dialog_viewer_geometry(
                      settingKey.ToStdString(), DIALOG_GEOMETRY{ pos.x, pos.y, size.x, size.y

                                                } );
              event.Skip();
          } );
}

COPILOT_DIALOG::~COPILOT_DIALOG()
{
}

void COPILOT_DIALOG::Init( wxWindow* aContent )
{
    auto top_sizer = new wxBoxSizer( wxVERTICAL );
    top_sizer->Add( aContent, wxSizerFlags().Expand().Proportion( 1 ) );
    SetSizer( top_sizer );
}