/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2025 Ethan Chien <liangtie.qian@gmail.com>
 * Copyright (C) 2025 KiCad Developers, see AUTHORS.txt for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#include "panel_add_design_block.h"
#include "panel_add_component.h"
#include <webview/webview_controller.h>
#include <fmt/format.h>
#include <utils/base64.hpp>

PANEL_ADD_DESIGN_BLOCK::PANEL_ADD_DESIGN_BLOCK( HOST_VERSION_INFO const& host_version_info, wxDialog* parent,
                                                std::optional<std::string> url, std::string design_block ) :
        PANEL_ADD_COMPONENT( host_version_info, parent, url ), _design_block( std::move( design_block ) )
{
}

PANEL_ADD_DESIGN_BLOCK::~PANEL_ADD_DESIGN_BLOCK()
{
}

void PANEL_ADD_DESIGN_BLOCK::OnNavigationComplete( wxWebViewEvent& evt )
{
    PANEL_ADD_COMPONENT::OnNavigationComplete( evt );
    const auto encoded = base64::to_base64( _design_block );
    RunScriptAsync( fmt::format( "load_design_block(\"{}\");", encoded ) );
    RunScriptAsync( fmt::format( "console.log(\"{}\");", encoded ) );
}
