#ifndef API_CPP_SDK_TYPE_H
#define API_CPP_SDK_TYPE_H

enum class API_CPP_SDK_TYPE : int
{

    drawWire,
    drawMutiLine,
    drawMultiWire,
    drawBus,
    drawCircle,
    drawArc,
    drawBezier,
    drawTextbox,
    drawTable,
    drawRectangle,
    drawSchematicText,
    drawHierSheet,
    placeLocalLabel,
    placeGlobalLabel,
    placeHierLabel,
    placeClassLabel,
    placeSymbolPinLabel,
    querySymbolPin,
    addSymbolLibrary,
    addLibSymbolPin,

    // Symbol API
    getSymbolLibrary,
    placeSymbol,
    getSymbolReference,
    setSymbolReference,
    getSymbolValue,
    setSymbolValue,
    getSymbolFootprint,
    setSymbolFootprint,
    getSymbolDataSheet,
    setSymbolDataSheet,
    getSymbolDescription,
    setSymbolDescription,
    getSymbolFields,
    addSymbolField,
    removeSymbolField,
    getSymbolPins,
    getSymbolPinPosition,
    getSymbolPinOrientation,
    getSymbolPinType,
    highlightSymbolPin,
    unhighlightSymbolPin,
    moveSymbol,
    rotateSymbol,
    modifySymbolValue,
    modifySymbolReference,
    // Sheet API
    createSheetPin,
    getRootSheet,
    getSheetPathList,
    getSheetPageNumber,
    getSheetByPageNumber,
    getCurrentSheet,
    // Marker API
    addMarker,
    clearMarker,
    getAllMarkers,
    findMarkerByPosition,
    // Line API
    createBusWireEntry,
    createJunction,
    getAllLinesKIID,
    getLineWidth,
    getWireNetName,
    getWireDriver,
    setLineColor,
    setLineWidth,
    moveLine,
    setLineStart,
    setLineEnd,

    //PCB track
    drawPcbTrack,
    placePcbVia,
    createPcbPad,
    movePcbPad,
    rotatePcbPad,
    modifyPadNumber,
    modifyPadSize,
    modifyPadDrillSize,
    modifyPadDrillShape,
    setPadPosition,
    queryLayerNames,
    queryAllFootprintInfo,
    queryFootprintInfo,
    moveFootprint,
    modifyFootprintReference,
    setFootprintPosition,
    rotateFootprint,

    //frame
    queryCurrentFrameType,
    closeFrame,
    closeCurrentFrame,
    openFrame,
    saveFrame,
    saveAs,
    importNonKicadSch,
    importVectorGraphic,
    exportNetlist,
    schematicSetup,
    pageSetting,
    print,
    plot,
    find,
    findReplace,
    deleteTool,
    selectAll,
    unselectAll,
    editTextGraphicProperty,
    propertyPanel,
    searchPanel,
    hierarchyPanel,
    netNavigatorPanel,
    designBlockPanel,
    symbolLibraryBrowser,
    zoomInCenter,
    zoomOutCenter,
    zoomFitScreen,
    zoomFitObjects,
    showBusSyntaxHelp,
    runERC,
    showSimulator,
    configurePaths,
    managerSymbolLibrary,
    mangerDesignBlockLibarary,
    Preference,
};


#endif 