/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright The KiCad Developers, see AUTHORS.txt for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#ifndef KIFACE_IDS_H
#define KIFACE_IDS_H

/**
 * IDs of objects that may be returned by KIFACE::IfaceOrAddress.
 */
enum KIFACE_ADDR_ID : int
{
    KIFACE_ID_INVALID,

    /**
     * Return a pointer to the global instance of FOOTPRINT_LIST from pcbnew.
     * Type is FOOTPRINT_LIST*
     * Caller does NOT own.
     */
    KIFACE_FOOTPRINT_LIST,

    /**
     * Return a new FP_LIB_TABLE with the global table installed as a fallback.
     * Type is FP_LIB_TABLE*
     * Caller takes ownership
     */
    KIFACE_NEW_FOOTPRINT_TABLE,

    /**
     * Return a function ptr for insert row in the FP_LIB_TABLE corresponding to the given
.    * KIFACE_NEW_FOOTPRINT_TABLE
     */
    KIFACE_INSERT_ROW_FOOTPRINT_TABLE,

    /**
     * Return a function ptr for updating the 3D model path of a footprint
     */
    KIFACE_UPDATE_FOOTPRINT_MODEL_PATH,

    /**
     * Return the global FP_LIB_TABLE.
     * Type is FP_LIB_TABLE*
     * Caller does NOT own.
     */
    KIFACE_GLOBAL_FOOTPRINT_TABLE,

    KIFACE_LOAD_SCHEMATIC,
    KIFACE_NETLIST_SCHEMATIC,
    KIFACE_SCRIPTING_LEGACY,
    KIFACE_SCRIPTING,

    KIFACE_TEST_FOOTPRINT_LINK,
    KIFACE_TEST_FOOTPRINT_LINK_NO_LIBRARY,
    KIFACE_TEST_FOOTPRINT_LINK_LIBRARY_NOT_ENABLED,
    KIFACE_TEST_FOOTPRINT_LINK_NO_FOOTPRINT
};

#endif // KIFACE_IDS
