const clientModeEnum = {
    ONLINE: 'ONLINE',
    HALF_OFFLINE: 'HALF_OFFLINE',
    OFFLINE: 'OFFLINE',
};
const runModeSettingTemplate = (data) => {
    return `
          <div class="display-flex flex-main-axis-start flex-nowrap" style="margin: 0 0 16px 0; line-height: 24px;">
              <div style="flex: 0 0 184px; text-align: left; word-break: break-word;">
                  <span class="i18n" 
                      title="${translateText('runningSetting')}" 
                      >${translateText('runningSetting')}:</span>
              </div>
              <div style="width: 70%;">
                  <label style="min-width: 112px; position: relative; margin-bottom: 16px; display: block;">
                      <input data-input-type="radio" 
                      data-attritem-input="clientMode" 
                      name="clientMode" type="radio" 
                      value="ONLINE" 
                      style="vertical-align: middle; cursor: pointer;"  
                      ${data.clientMode === clientModeEnum.ONLINE ? 'checked=""' : ''}
                      >
                      <span style="cursor: pointer;">${translateText('online')}</span>
                  </label>
                  <label style="min-width: 112px; position: relative; margin-bottom: 16px; display: block;">
                      <input data-input-type="radio" 
                      data-attritem-input="clientMode" 
                      name="clientMode" type="radio" 
                      value="HALF_OFFLINE" 
                      style="vertical-align: middle; cursor: pointer;"
                      ${data.clientMode === clientModeEnum.HALF_OFFLINE ? 'checked=""' : ''}
                      >
                      <span style="cursor: pointer;">${translateText('halfOffline')}</span>
                  </label>
                  <label style="min-width: 112px; position: relative; display: block;">
                      <input data-input-type="radio" 
                      data-attritem-input="clientMode" 
                      name="clientMode" type="radio" 
                      value="OFFLINE" 
                      style="vertical-align: middle; cursor: pointer;"
                      ${data.clientMode === clientModeEnum.OFFLINE ? 'checked=""' : ''}
                      >
                      <span style="cursor: pointer;">${translateText('offline')}</span>
                  </label>
              </div>
          </div>
      `;
};
const librariesPathTemplate = (data) => {
    let libList = '';
    const list = data.libraryDir;
    libList = list.reduce((pre, next) => {
        return pre + setLibItemPath(next);
    }, '');
    return `
          <div class="display-flex flex-main-axis-start flex-nowrap lib-path-content" style="margin: 0 0 16px 0; line-height: 24px; ${
              data.clientMode === clientModeEnum.ONLINE ? 'display: none;' : ''
          }">
            <div style="flex: 0 0 184px; text-align: left; word-break: break-word;">
              <span 
                class="i18n" 
                title="${translateText('libPath')}" 
                i18n="libPath"
              >
                ${translateText('libPath')}:
              </span>
            </div>
            <div class="libPath" style="width: 70%;">
              <div data-tagitem="op-btn-wrapper" class="display-flex flex-lateral-axis-center flex-nowrap" style="margin-bottom: 8px; height: 24px; flex: 0 0 24px;">
                  <span data-tagitem="addOne" cmd="libAddOne" class="icon_operate icon_operate_add attr_setting_btn" style="margin-left: 0;" title="新增"></span>
                  <span data-tagitem="delOne" cmd="libDelOne" class="icon_operate icon_operate_delete attr_setting_btn ${
                      list.length <= 1 ? 'disabled pointer-events-none' : ''
                  }" title="删除"></span>							
              </div>
              <ul
                class="libList comm-ulist"
                style="border: 1px solid #e9e9e9;
                  height: 125px;
                  box-sizing: border-box;
                  overflow-y: auto;
                  line-height: 30px;
                  "
              >
               ${libList}
              </ul>
            </div>
          </div>`;
};

const projectsPathTemplate = (data) => {
    let projectPathList = '';
    const list = data.projectDir;
    projectPathList = list.reduce((pre, next) => {
        return pre + setProjectListItemPath(next);
    }, '');
    return `
  <div class="display-flex flex-lateral-axis-center flex-main-axis-start flex-nowrap margin-btn input-wrapper-line prj-path-content" style="height: 30px; margin-bottom: 16px; ${
      data.clientMode === clientModeEnum.ONLINE ? 'display: none;' : ''
  }">
    <div style="flex: 0 0 184px; text-align: left; padding-right: 16px;">
      <span 
        class="i18n" 
        title="${translateText('projectPath')}" 
        i18n="projectPath"
      >
        ${translateText('projectPath')}:
      </span>
    </div>
    <div class="projectListPath" style="width: 70%;margin-top:120px;margin-bottom:20px">
      <div data-tagitem="op-btn-wrapper" class="display-flex flex-lateral-axis-center flex-nowrap" style="margin-bottom: 8px; height: 24px; flex: 0 0 24px;">
          <span data-tagitem="addOne" cmd="projectPathAddOne" class="icon_operate icon_operate_add attr_setting_btn" style="margin-left: 0;" title="${translateText(
              'Add'
          )}"></span>
          <span data-tagitem="upMove" cmd='projectPathMoveUp' class="project_list icon_operate icon_operate_up attr_setting_btn ${
              list.length <= 1 ? 'disabled pointer-events-none' : ''
          }" title="${translateText('MoveUp')}"></span>
          <span data-tagitem="downMove" cmd='projectPathMoveDown' class="project_list icon_operate icon_operate_down attr_setting_btn ${
              list.length <= 1 ? 'disabled pointer-events-none' : ''
          }" title="${translateText('MoveDown')}"></span>
          <span data-tagitem="delOne" cmd="projectPathDelOne" class="icon_operate icon_operate_delete attr_setting_btn ${
              list.length <= 1 ? 'disabled pointer-events-none' : ''
          }" title= ${translateText('Delete')}></span>							
      </div>
      <ul
        class="projectPathList comm-ulist"
        style="border: 1px solid #e9e9e9;
          height: 125px;
          box-sizing: border-box;
          overflow-y: auto;
          line-height: 30px;
          "
      >
        ${projectPathList}
      </ul>
    </div>
  </div>`;
};

const onlineProjectsBackupPathTemplate = (data) => {
    return `
      <div class="display-flex flex-lateral-axis-center flex-main-axis-start flex-nowrap margin-btn input-wrapper-line online-prj-path-content" style="height: 30px; margin-bottom: 16px; ${
          data.clientMode !== clientModeEnum.ONLINE ? 'display: none;' : ''
      }">
        <div style="flex: 0 0  184px; text-align: left; padding-right: 16px;">
          <span 
            class="i18n" 
            title="${translateText('backupPath')}" 
            i18n="backupPath"
          >
            ${translateText('backupPath')}:
          </span>
        </div>
        <div 
            data-inputline="Online projects backup path" 
            class="display-flex flex-lateral-axis-center flex-main-axis-start flex-nowrap" 
            style="width: 70%; color: #333; border-radius: 2px; border: 1px solid #d9d9d9; position: relative;
            height: 30px; padding-left: 5px;"
        >
          <input 
          data-attritem-input="backupPath" 
            class="backupPath" 
            cmd="backupPath"
            type="text" 
            class="comm-btn-height" 
            value="${data.appOnlineBackupDir || ''}" 
            style="width: 100%; border: 0; border-radius: 0; cursor: pointer;"
            readonly  
          />
          <span 
            class="input-dot"
            cmd="backupPath" 
            style="height: 100%; margin-right: 8px; cursor: pointer; font-weight: bolder; line-height: 30px;"
          >
            ···
          </span>
        </div>
      </div>`;
};

const setLibItemPath = (data) => {
    return `<li class="comm-list-item" style='position: relative; cursor: default; padding-left: 5px;'>
      <input data-attritem-input="libPath" name="libPath" style="width: 100%; border: 0; background: transparent;color: inherit; border-radius: 0; cursor: pointer;" 
      readonly value="${data || ''}"/>
    <span 
      class="input-dot"
      style="height: 100%; margin-right: 8px; cursor: pointer; font-weight: bolder;
      position: absolute;
      right: 0px; top: 3px;
      "
    >
      ···
    </span>
</li>`;
};
const setProjectListItemPath = (data) => {
    return `<li class="comm-list-item" style='position: relative; cursor: default; padding-left: 5px;'>
      <input data-attritem-input="projectPath" name="projectPath" style="width: 100%; border: 0; background: transparent;color: inherit; border-radius: 0; cursor: pointer;" 
      readonly value="${data || ''}"/>
    <span 
      class="input-dot"
      style="height: 100%; margin-right: 8px; cursor: pointer; font-weight: bolder;
      position: absolute;
      right: 0px; top: 3px;
      "
    >
      ···
    </span>
</li>`;
};

const warnTemplate = (data) => {
    return `
          <div class="panel-header panel-header-noborder window-header" style="width: 398px;">
            <div class="panel-title i18n" i18n="Warning">${translateText(data.title)}</div>
              <div class="panel-tool">
                <div class="panel-tool-close" cmd="close"></div>
              </div>
          </div>
          <div class="messager-body alert-dialog panel-body panel-body-noborder window-body" title="" style="width: 398px; height: auto;">
            <div style="position:relative; height: 100px; display: flex;">
              <div class="messager-icon icon-${data.icon}"></div>
                <div class="i18n content" i18n="${translateText(data.content)}" style="line-height: 20px">
                ${translateText(data.content)} ${data.path ? `: ${data.path}` : ''}</div>
            </div>
            <div class="messager-button">
            ${
                data.confirm
                    ? `<a href="javascript:void(0)" iconcls="" cmd="Confirm" class="l-btn">
                ${translateText('Confirm')}
                  </a>
                  <a href="javascript:void(0)" iconcls="" cmd="Cancel" class="l-btn">
                      ${translateText('Cancel')}
                  </a>`
                    : `<a href="javascript:void(0)" iconcls="" cmd="close" class="l-btn">
                  ${translateText('Confirm')}
              </a>`
            }
            </div>
          </div>
`;
};
var search = decodeURI(window.location.search).substring(1).split('&');
var param = {};
for (let item of search) {
    var arr = item.split('=');
    if (param[arr[0]]) {
        if (Array.isArray(param[arr[0]])) {
            param[arr[0]].push(arr[1]);
        } else {
            param[arr[0]] = [param[arr[0]], arr[1]];
        }
    } else {
        if (arr[0] === 'libraryDir' || arr[0] === 'projectDir') {
            param[arr[0]] = [arr[1]];
        } else {
            param[arr[0]] = arr[1];
        }
    }
}

var lang = navigator.userAgent.indexOf('EasyEDAPro') > 0 ? 'en' : 'zh';
const translateText = translate[lang];
document.getElementById('clientSettingDialogContainer').innerHTML = `
<div class="panel" style="left: 0px; top: 0px; width: 666px; display: block;"><div class="dialog-content panel-body panel-body-noheader panel-body-noborder" title="" style="width: 666px; height: 498px;">
        <div class="pop-content-container">
          <div class="pop-content-wrapper" style="padding: 16px; border: 1px solid #e9e9e9;">
					<div style="padding-bottom: 16px;">${translateText('settingTips')}</div>
          ${runModeSettingTemplate(param)}
          ${librariesPathTemplate(param)}
          ${projectsPathTemplate(param)}
          ${onlineProjectsBackupPathTemplate(param)}
          </div>
          <div class="pop-footer-wrapper">
            <a class="comm-btn comm-btn-primary" data-pop-tagitem="confirm" href="#" cmd="changeLaunchType" data-popbtn-normal="${translateText(
                'Confirm'
            )}" >${translateText('Confirm')}</a>
            <a class="comm-btn comm-btn-default" data-pop-tagitem="cancel" href="#" cmd="Cancel" data-popbtn-normal="${translateText(
                'Cancel'
            )}" >${translateText('Cancel')}</a>
          </div>
        </div>
        </div></div>
`;
document.getElementsByClassName('clientSetting')[0].innerHTML = translateText('clientSetting');
