const en = {
    warn: 'Warning',
    error: 'Error',
    warningText: '10 library paths at most can be saved！',
    errorText: 'The path cannot be empty!',
    invalidPath: 'Invalid Path!',
    settingTips: 'Tip: After switching the operating mode and changing the path, you need to restart the software',
    runningSetting: 'Running mode setting',
    clientSetting: 'Client Setting',
    online: 'Full online mode (projects and libraries are saved on the server)',
    halfOffline: 'Half offline mode (projects and libraries are saved on the local, support to use the online system libraries)',
    offline: "Full offline mode (projects and libraries are saved on the local, doesn't support to use the online system libraries)",
    libPath: 'Libraries path',
    projectPath: 'Project Path',
    backupPath: 'Online projects backup path',
    Confirm: 'Confirm',
    Cancel: 'Cancel',
    switchMode:
        'After changing the operating mode and changing the path, you need to restart the program. Whether to restart the program immediately?',
    LCEDA: 'LCEDA(Professional)',
    title: 'JLCEDA Pro',
    EasyEDATitle: 'EasyEDA Pro',
    version: 'Version',
    time: 'Compile time',
    activated: 'Activated',
    notActivated: 'Not activated',
    username: 'Username',
    customerCode: 'Customer code',
    phone: 'Phone',
    company: 'Company',
    email: 'Email',
    tips: 'Lightweight, Powerful, Easier',
    loading: 'Loading',
    initDB: 'Init DataBase',
    updateFTS: 'Update File Path',
    copyStdLib: 'Copy system lib',
    Complete: 'Load Complete',
    Add: 'Add',
    MoveUp: 'Move Up',
    MoveDown: 'Move Down',
    Delete: 'Delete',
};
const zh = {
    warn: '警告',
    error: '错误',
    warningText: '最多允许保存10个库路径！',
    invalidPath: '非法路径',
    errorText: '路径不能为空！',
    settingTips: '提示：切换运行模式和改变路径后，需要重新启动本软件',
    runningSetting: '运行模式设置',
    clientSetting: '客户端设置',
    online: '全在线模式（工程和库均保存在服务器）',
    halfOffline: '半离线模式（工程和库均保存在本地，支持使用在线系统库）',
    offline: '全离线模式（工程和库均保存在本地，不支持使用在线系统库）',
    libPath: '库路径',
    projectPath: '工程路径',
    backupPath: '在线工程备份路径',
    Confirm: '确定',
    Cancel: '取消',
    switchMode: '切换运行模式和改变路径后，需要重新启动程序。是否立即重新启动程序？',
    LCEDA: '立创EDA(专业版)',
    title: '嘉立创EDA专业版',
    EasyEDATitle: 'EasyEDA专业版',
    version: '版本',
    time: '编译日期',
    activated: '授权于',
    notActivated: '未激活',
    username: '用&nbsp;&#8197;户&#8197;&nbsp;名',
    customerCode: '客户编号',
    phone: '电&nbsp; &nbsp; &nbsp; &nbsp;话',
    company: '公&nbsp; &nbsp; &nbsp; &nbsp;司',
    email: '邮&nbsp; &nbsp; &nbsp; &nbsp;箱',
    tips: '轻量、强大、易用',
    loading: '正在加载',
    initDB: '初始化数据库',
    updateFTS: '更新文件路径',
    copyStdLib: '复制系统库',
    Complete: '加载完成',
    Add: '新增',
    MoveUp: '上移',
    MoveDown: '下移',
    Delete: '删除',
};

const translate = {
    en: (key) => {
        return en[key] ? en[key] : key;
    },
    zh: (key) => {
        return zh[key] ? zh[key] : key;
    },
};
