//  拖拽
class Drag {
    drag(ele) {
        const self = this;
        ele.getElementsByClassName('panel-header')[0].onmousedown = function (e) {
            self.mousedown(e, self, this, ele);
        };
        ele.getElementsByClassName('panel-header')[0].onmouseup = function () {
            self.mouseup(this);
        };
    }
    mousedown(e, self, _this, ele) {
        const offX = e.clientX - ele.offsetLeft;
        const offY = e.clientY - ele.offsetTop;
        ele.style.position = 'absolute';
        document.onmousemove = function (e) {
            self.mousemove(e, ele, offX, offY);
        };
        document.onmouseup = function () {
            self.mouseup(_this);
        };
    }
    mousemove(e, ele, offX, offY) {
        let left = e.clientX - offX;
        let top = e.clientY - offY;
        let height = window.innerHeight - ele.offsetHeight;
        let width = window.innerWidth - ele.offsetWidth;
        // 防止对话框拖拽出可视窗口
        if (top < 32) {
            top = 32;
        }
        if (top > height) {
            top = height;
        }
        if (left < 0) {
            left = 0;
        }
        if (left > width) {
            left = width;
        }
        ele.style.left = left + 'px';
        ele.style.top = top + 'px';
    }
    mouseup(_this) {
        document.onmousemove = null;
    }
}
