/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-2-Clause) */
/*
 * Copyright (c) 2025 SpacemiT Technology Co. Ltd
 */

#ifndef _DT_BINDINGS_RESET_SPACEMIT_K3_RESETS_H_
#define _DT_BINDINGS_RESET_SPACEMIT_K3_RESETS_H_

/* MPMU resets */
#define RESET_MPMU_WDT           0
#define RESET_MPMU_RIPC          1

/* APBC resets */
#define RESET_APBC_UART0         0
#define RESET_APBC_UART2         1
#define RESET_APBC_UART3         2
#define RESET_APBC_UART4         3
#define RESET_APBC_UART5         4
#define RESET_APBC_UART6         5
#define RESET_APBC_UART7         6
#define RESET_APBC_UART8         7
#define RESET_APBC_UART9         8
#define RESET_APBC_UART10        9
#define RESET_APBC_GPIO          10
#define RESET_APBC_PWM0          11
#define RESET_APBC_PWM1          12
#define RESET_APBC_PWM2          13
#define RESET_APBC_PWM3          14
#define RESET_APBC_PWM4          15
#define RESET_APBC_PWM5          16
#define RESET_APBC_PWM6          17
#define RESET_APBC_PWM7          18
#define RESET_APBC_PWM8          19
#define RESET_APBC_PWM9          20
#define RESET_APBC_PWM10         21
#define RESET_APBC_PWM11         22
#define RESET_APBC_PWM12         23
#define RESET_APBC_PWM13         24
#define RESET_APBC_PWM14         25
#define RESET_APBC_PWM15         26
#define RESET_APBC_PWM16         27
#define RESET_APBC_PWM17         28
#define RESET_APBC_PWM18         29
#define RESET_APBC_PWM19         30
#define RESET_APBC_SPI0          31
#define RESET_APBC_SPI1          32
#define RESET_APBC_SPI3          33
#define RESET_APBC_RTC           34
#define RESET_APBC_TWSI0         35
#define RESET_APBC_TWSI1         36
#define RESET_APBC_TWSI2         37
#define RESET_APBC_TWSI4         38
#define RESET_APBC_TWSI5         39
#define RESET_APBC_TWSI6         40
#define RESET_APBC_TWSI8         41
#define RESET_APBC_TIMERS0       42
#define RESET_APBC_TIMERS1       43
#define RESET_APBC_TIMERS2       44
#define RESET_APBC_TIMERS3       45
#define RESET_APBC_TIMERS4       46
#define RESET_APBC_TIMERS5       47
#define RESET_APBC_TIMERS6       48
#define RESET_APBC_TIMERS7       49
#define RESET_APBC_AIB           50
#define RESET_APBC_ONEWIRE       51
#define RESET_APBC_I2S0          52
#define RESET_APBC_I2S1          53
#define RESET_APBC_I2S2          54
#define RESET_APBC_I2S3          55
#define RESET_APBC_I2S4          56
#define RESET_APBC_I2S5          57
#define RESET_APBC_DRO           58
#define RESET_APBC_IR0           59
#define RESET_APBC_IR1           60
#define RESET_APBC_TSEN          61
#define RESET_IPC_AP2AUD         62
#define RESET_APBC_CAN0          63
#define RESET_APBC_CAN1          64
#define RESET_APBC_CAN2          65
#define RESET_APBC_CAN3          66
#define RESET_APBC_CAN4          67

/* APMU resets */
#define RESET_APMU_CSI           0
#define RESET_APMU_CCIC2PHY      1
#define RESET_APMU_CCIC3PHY      2
#define RESET_APMU_ISP_CIBUS     3
#define RESET_APMU_DSI_ESC       4
#define RESET_APMU_LCD           5
#define RESET_APMU_V2D           6
#define RESET_APMU_LCD_MCLK      7
#define RESET_APMU_LCD_DSCCLK    8
#define RESET_APMU_SC2_HCLK      9
#define RESET_APMU_CCIC_4X       10
#define RESET_APMU_CCIC1_PHY     11
#define RESET_APMU_SDH_AXI       12
#define RESET_APMU_SDH0          13
#define RESET_APMU_SDH1          14
#define RESET_APMU_SDH2          15
#define RESET_APMU_USB2          16
#define RESET_APMU_USB3_PORTA    17
#define RESET_APMU_USB3_PORTB    18
#define RESET_APMU_USB3_PORTC    19
#define RESET_APMU_USB3_PORTD    20
#define RESET_APMU_QSPI          21
#define RESET_APMU_QSPI_BUS      22
#define RESET_APMU_DMA           23
#define RESET_APMU_AES_WTM       24
#define RESET_APMU_MCB_DCLK      25
#define RESET_APMU_MCB_ACLK      26
#define RESET_APMU_VPU           27
#define RESET_APMU_DTC           28
#define RESET_APMU_GPU           29
#define RESET_APMU_ALZO          30
#define RESET_APMU_MC            31
#define RESET_APMU_CPU0_POP      32
#define RESET_APMU_CPU0_SW       33
#define RESET_APMU_CPU1_POP      34
#define RESET_APMU_CPU1_SW       35
#define RESET_APMU_CPU2_POP      36
#define RESET_APMU_CPU2_SW       37
#define RESET_APMU_CPU3_POP      38
#define RESET_APMU_CPU3_SW       39
#define RESET_APMU_C0_MPSUB_SW   40
#define RESET_APMU_CPU4_POP      41
#define RESET_APMU_CPU4_SW       42
#define RESET_APMU_CPU5_POP      43
#define RESET_APMU_CPU5_SW       44
#define RESET_APMU_CPU6_POP      45
#define RESET_APMU_CPU6_SW       46
#define RESET_APMU_CPU7_POP      47
#define RESET_APMU_CPU7_SW       48
#define RESET_APMU_C1_MPSUB_SW   49
#define RESET_APMU_MPSUB_DBG     50
#define RESET_APMU_UCIE          51
#define RESET_APMU_RCPU          52
#define RESET_APMU_DSI4LN2_ESCCLK     53
#define RESET_APMU_DSI4LN2_LCD_SW     54
#define RESET_APMU_DSI4LN2_LCD_MCLK   55
#define RESET_APMU_DSI4LN2_LCD_DSCCLK 56
#define RESET_APMU_DSI4LN2_DPU_ACLK   57
#define RESET_APMU_DPU_ACLK      58
#define RESET_APMU_UFS_ACLK      59
#define RESET_APMU_EDP0          60
#define RESET_APMU_EDP1          61
#define RESET_APMU_PCIE_PORTA    62
#define RESET_APMU_PCIE_PORTB    63
#define RESET_APMU_PCIE_PORTC    64
#define RESET_APMU_PCIE_PORTD    65
#define RESET_APMU_PCIE_PORTE    66
#define RESET_APMU_EMAC0         67
#define RESET_APMU_EMAC1         68
#define RESET_APMU_EMAC2         69
#define RESET_APMU_ESPI_MCLK     70
#define RESET_APMU_ESPI_SCLK     71

/* DCIU resets*/
#define RESET_DCIU_HDMA          0
#define RESET_DCIU_DMA350        1
#define RESET_DCIU_DMA350_0      2
#define RESET_DCIU_DMA350_1      3
#define RESET_DCIU_AXIDMA0       4
#define RESET_DCIU_AXIDMA1       5
#define RESET_DCIU_AXIDMA2       6
#define RESET_DCIU_AXIDMA3       7
#define RESET_DCIU_AXIDMA4       8
#define RESET_DCIU_AXIDMA5       9
#define RESET_DCIU_AXIDMA6       10
#define RESET_DCIU_AXIDMA7       11

#endif /* _DT_BINDINGS_RESET_SPACEMIT_K3_H_ */
