/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright 2015 Samsung Electronics
 * Copyright 2020 Google Inc
 * Copyright 2025 Linaro Ltd.
 */

#ifndef __LINUX_MFD_S2MPG10_H
#define __LINUX_MFD_S2MPG10_H

/* Common registers (type 0x000) */
enum s2mpg10_common_reg {
	S2MPG10_COMMON_CHIPID,
	S2MPG10_COMMON_INT,
	S2MPG10_COMMON_INT_MASK,
	S2MPG10_COMMON_SPD_CTRL1 = 0x0a,
	S2MPG10_COMMON_SPD_CTRL2,
	S2MPG10_COMMON_SPD_CTRL3,
	S2MPG10_COMMON_MON1SEL = 0x1a,
	S2MPG10_COMMON_MON2SEL,
	S2MPG10_COMMON_MONR,
	S2MPG10_COMMON_DEBUG_CTRL1,
	S2MPG10_COMMON_DEBUG_CTRL2,
	S2MPG10_COMMON_DEBUG_CTRL3,
	S2MPG10_COMMON_DEBUG_CTRL4,
	S2MPG10_COMMON_DEBUG_CTRL5,
	S2MPG10_COMMON_DEBUG_CTRL6,
	S2MPG10_COMMON_DEBUG_CTRL7,
	S2MPG10_COMMON_DEBUG_CTRL8,
	S2MPG10_COMMON_TEST_MODE1,
	S2MPG10_COMMON_TEST_MODE2,
	S2MPG10_COMMON_SPD_DEBUG1,
	S2MPG10_COMMON_SPD_DEBUG2,
	S2MPG10_COMMON_SPD_DEBUG3,
	S2MPG10_COMMON_SPD_DEBUG4,
};

/* For S2MPG10_COMMON_INT and S2MPG10_COMMON_INT_MASK */
#define S2MPG10_COMMON_INT_SRC       GENMASK(7, 0)
#define S2MPG10_COMMON_INT_SRC_PMIC  BIT(0)

/* PMIC registers (type 0x100) */
enum s2mpg10_pmic_reg {
	S2MPG10_PMIC_INT1,
	S2MPG10_PMIC_INT2,
	S2MPG10_PMIC_INT3,
	S2MPG10_PMIC_INT4,
	S2MPG10_PMIC_INT5,
	S2MPG10_PMIC_INT6,
	S2MPG10_PMIC_INT1M,
	S2MPG10_PMIC_INT2M,
	S2MPG10_PMIC_INT3M,
	S2MPG10_PMIC_INT4M,
	S2MPG10_PMIC_INT5M,
	S2MPG10_PMIC_INT6M,
	S2MPG10_PMIC_STATUS1,
	S2MPG10_PMIC_STATUS2,
	S2MPG10_PMIC_PWRONSRC,
	S2MPG10_PMIC_OFFSRC,
	S2MPG10_PMIC_BU_CHG,
	S2MPG10_PMIC_RTCBUF,
	S2MPG10_PMIC_COMMON_CTRL1,
	S2MPG10_PMIC_COMMON_CTRL2,
	S2MPG10_PMIC_COMMON_CTRL3,
	S2MPG10_PMIC_COMMON_CTRL4,
	S2MPG10_PMIC_SMPL_WARN_CTRL,
	S2MPG10_PMIC_MIMICKING_CTRL,
	S2MPG10_PMIC_B1M_CTRL,
	S2MPG10_PMIC_B1M_OUT1,
	S2MPG10_PMIC_B1M_OUT2,
	S2MPG10_PMIC_B2M_CTRL,
	S2MPG10_PMIC_B2M_OUT1,
	S2MPG10_PMIC_B2M_OUT2,
	S2MPG10_PMIC_B3M_CTRL,
	S2MPG10_PMIC_B3M_OUT1,
	S2MPG10_PMIC_B3M_OUT2,
	S2MPG10_PMIC_B4M_CTRL,
	S2MPG10_PMIC_B4M_OUT1,
	S2MPG10_PMIC_B4M_OUT2,
	S2MPG10_PMIC_B5M_CTRL,
	S2MPG10_PMIC_B5M_OUT1,
	S2MPG10_PMIC_B5M_OUT2,
	S2MPG10_PMIC_B6M_CTRL,
	S2MPG10_PMIC_B6M_OUT1,
	S2MPG10_PMIC_B6M_OUT2,
	S2MPG10_PMIC_B7M_CTRL,
	S2MPG10_PMIC_B7M_OUT1,
	S2MPG10_PMIC_B7M_OUT2,
	S2MPG10_PMIC_B8M_CTRL,
	S2MPG10_PMIC_B8M_OUT1,
	S2MPG10_PMIC_B8M_OUT2,
	S2MPG10_PMIC_B9M_CTRL,
	S2MPG10_PMIC_B9M_OUT1,
	S2MPG10_PMIC_B9M_OUT2,
	S2MPG10_PMIC_B10M_CTRL,
	S2MPG10_PMIC_B10M_OUT1,
	S2MPG10_PMIC_B10M_OUT2,
	S2MPG10_PMIC_BUCK1M_USONIC,
	S2MPG10_PMIC_BUCK2M_USONIC,
	S2MPG10_PMIC_BUCK3M_USONIC,
	S2MPG10_PMIC_BUCK4M_USONIC,
	S2MPG10_PMIC_BUCK5M_USONIC,
	S2MPG10_PMIC_BUCK6M_USONIC,
	S2MPG10_PMIC_BUCK7M_USONIC,
	S2MPG10_PMIC_BUCK8M_USONIC,
	S2MPG10_PMIC_BUCK9M_USONIC,
	S2MPG10_PMIC_BUCK10M_USONIC,
	S2MPG10_PMIC_L1M_CTRL,
	S2MPG10_PMIC_L2M_CTRL,
	S2MPG10_PMIC_L3M_CTRL,
	S2MPG10_PMIC_L4M_CTRL,
	S2MPG10_PMIC_L5M_CTRL,
	S2MPG10_PMIC_L6M_CTRL,
	S2MPG10_PMIC_L7M_CTRL,
	S2MPG10_PMIC_L8M_CTRL,
	S2MPG10_PMIC_L9M_CTRL,
	S2MPG10_PMIC_L10M_CTRL,
	S2MPG10_PMIC_L11M_CTRL1,
	S2MPG10_PMIC_L11M_CTRL2,
	S2MPG10_PMIC_L12M_CTRL1,
	S2MPG10_PMIC_L12M_CTRL2,
	S2MPG10_PMIC_L13M_CTRL1,
	S2MPG10_PMIC_L13M_CTRL2,
	S2MPG10_PMIC_L14M_CTRL,
	S2MPG10_PMIC_L15M_CTRL1,
	S2MPG10_PMIC_L15M_CTRL2,
	S2MPG10_PMIC_L16M_CTRL,
	S2MPG10_PMIC_L17M_CTRL,
	S2MPG10_PMIC_L18M_CTRL,
	S2MPG10_PMIC_L19M_CTRL,
	S2MPG10_PMIC_L20M_CTRL,
	S2MPG10_PMIC_L21M_CTRL,
	S2MPG10_PMIC_L22M_CTRL,
	S2MPG10_PMIC_L23M_CTRL,
	S2MPG10_PMIC_L24M_CTRL,
	S2MPG10_PMIC_L25M_CTRL,
	S2MPG10_PMIC_L26M_CTRL,
	S2MPG10_PMIC_L27M_CTRL,
	S2MPG10_PMIC_L28M_CTRL,
	S2MPG10_PMIC_L29M_CTRL,
	S2MPG10_PMIC_L30M_CTRL,
	S2MPG10_PMIC_L31M_CTRL,
	S2MPG10_PMIC_LDO_CTRL1,
	S2MPG10_PMIC_LDO_CTRL2,
	S2MPG10_PMIC_LDO_DSCH1,
	S2MPG10_PMIC_LDO_DSCH2,
	S2MPG10_PMIC_LDO_DSCH3,
	S2MPG10_PMIC_LDO_DSCH4,
	S2MPG10_PMIC_LDO_BUCK7M_HLIMIT,
	S2MPG10_PMIC_LDO_BUCK7M_LLIMIT,
	S2MPG10_PMIC_LDO_LDO21M_HLIMIT,
	S2MPG10_PMIC_LDO_LDO21M_LLIMIT,
	S2MPG10_PMIC_LDO_LDO11M_HLIMIT,
	S2MPG10_PMIC_DVS_RAMP1,
	S2MPG10_PMIC_DVS_RAMP2,
	S2MPG10_PMIC_DVS_RAMP3,
	S2MPG10_PMIC_DVS_RAMP4,
	S2MPG10_PMIC_DVS_RAMP5,
	S2MPG10_PMIC_DVS_RAMP6,
	S2MPG10_PMIC_DVS_SYNC_CTRL1,
	S2MPG10_PMIC_DVS_SYNC_CTRL2,
	S2MPG10_PMIC_DVS_SYNC_CTRL3,
	S2MPG10_PMIC_DVS_SYNC_CTRL4,
	S2MPG10_PMIC_DVS_SYNC_CTRL5,
	S2MPG10_PMIC_DVS_SYNC_CTRL6,
	S2MPG10_PMIC_OFF_CTRL1,
	S2MPG10_PMIC_OFF_CTRL2,
	S2MPG10_PMIC_OFF_CTRL3,
	S2MPG10_PMIC_OFF_CTRL4,
	S2MPG10_PMIC_SEQ_CTRL1,
	S2MPG10_PMIC_SEQ_CTRL2,
	S2MPG10_PMIC_SEQ_CTRL3,
	S2MPG10_PMIC_SEQ_CTRL4,
	S2MPG10_PMIC_SEQ_CTRL5,
	S2MPG10_PMIC_SEQ_CTRL6,
	S2MPG10_PMIC_SEQ_CTRL7,
	S2MPG10_PMIC_SEQ_CTRL8,
	S2MPG10_PMIC_SEQ_CTRL9,
	S2MPG10_PMIC_SEQ_CTRL10,
	S2MPG10_PMIC_SEQ_CTRL11,
	S2MPG10_PMIC_SEQ_CTRL12,
	S2MPG10_PMIC_SEQ_CTRL13,
	S2MPG10_PMIC_SEQ_CTRL14,
	S2MPG10_PMIC_SEQ_CTRL15,
	S2MPG10_PMIC_SEQ_CTRL16,
	S2MPG10_PMIC_SEQ_CTRL17,
	S2MPG10_PMIC_SEQ_CTRL18,
	S2MPG10_PMIC_SEQ_CTRL19,
	S2MPG10_PMIC_SEQ_CTRL20,
	S2MPG10_PMIC_SEQ_CTRL21,
	S2MPG10_PMIC_SEQ_CTRL22,
	S2MPG10_PMIC_SEQ_CTRL23,
	S2MPG10_PMIC_SEQ_CTRL24,
	S2MPG10_PMIC_SEQ_CTRL25,
	S2MPG10_PMIC_SEQ_CTRL26,
	S2MPG10_PMIC_SEQ_CTRL27,
	S2MPG10_PMIC_SEQ_CTRL28,
	S2MPG10_PMIC_SEQ_CTRL29,
	S2MPG10_PMIC_SEQ_CTRL30,
	S2MPG10_PMIC_SEQ_CTRL31,
	S2MPG10_PMIC_SEQ_CTRL32,
	S2MPG10_PMIC_SEQ_CTRL33,
	S2MPG10_PMIC_SEQ_CTRL34,
	S2MPG10_PMIC_SEQ_CTRL35,
	S2MPG10_PMIC_OFF_SEQ_CTRL1,
	S2MPG10_PMIC_OFF_SEQ_CTRL2,
	S2MPG10_PMIC_OFF_SEQ_CTRL3,
	S2MPG10_PMIC_OFF_SEQ_CTRL4,
	S2MPG10_PMIC_OFF_SEQ_CTRL5,
	S2MPG10_PMIC_OFF_SEQ_CTRL6,
	S2MPG10_PMIC_OFF_SEQ_CTRL7,
	S2MPG10_PMIC_OFF_SEQ_CTRL8,
	S2MPG10_PMIC_OFF_SEQ_CTRL9,
	S2MPG10_PMIC_OFF_SEQ_CTRL10,
	S2MPG10_PMIC_OFF_SEQ_CTRL11,
	S2MPG10_PMIC_OFF_SEQ_CTRL12,
	S2MPG10_PMIC_OFF_SEQ_CTRL13,
	S2MPG10_PMIC_OFF_SEQ_CTRL14,
	S2MPG10_PMIC_OFF_SEQ_CTRL15,
	S2MPG10_PMIC_OFF_SEQ_CTRL16,
	S2MPG10_PMIC_OFF_SEQ_CTRL17,
	S2MPG10_PMIC_OFF_SEQ_CTRL18,
	S2MPG10_PMIC_PCTRLSEL1,
	S2MPG10_PMIC_PCTRLSEL2,
	S2MPG10_PMIC_PCTRLSEL3,
	S2MPG10_PMIC_PCTRLSEL4,
	S2MPG10_PMIC_PCTRLSEL5,
	S2MPG10_PMIC_PCTRLSEL6,
	S2MPG10_PMIC_PCTRLSEL7,
	S2MPG10_PMIC_PCTRLSEL8,
	S2MPG10_PMIC_PCTRLSEL9,
	S2MPG10_PMIC_PCTRLSEL10,
	S2MPG10_PMIC_PCTRLSEL11,
	S2MPG10_PMIC_PCTRLSEL12,
	S2MPG10_PMIC_PCTRLSEL13,
	S2MPG10_PMIC_DCTRLSEL1,
	S2MPG10_PMIC_DCTRLSEL2,
	S2MPG10_PMIC_DCTRLSEL3,
	S2MPG10_PMIC_DCTRLSEL4,
	S2MPG10_PMIC_DCTRLSEL5,
	S2MPG10_PMIC_DCTRLSEL6,
	S2MPG10_PMIC_DCTRLSEL7,
	S2MPG10_PMIC_GPIO_CTRL1,
	S2MPG10_PMIC_GPIO_CTRL2,
	S2MPG10_PMIC_GPIO_CTRL3,
	S2MPG10_PMIC_GPIO_CTRL4,
	S2MPG10_PMIC_GPIO_CTRL5,
	S2MPG10_PMIC_GPIO_CTRL6,
	S2MPG10_PMIC_GPIO_CTRL7,
	S2MPG10_PMIC_B2M_OCP_WARN,
	S2MPG10_PMIC_B2M_OCP_WARN_X,
	S2MPG10_PMIC_B2M_OCP_WARN_Y,
	S2MPG10_PMIC_B2M_OCP_WARN_Z,
	S2MPG10_PMIC_B3M_OCP_WARN,
	S2MPG10_PMIC_B3M_OCP_WARN_X,
	S2MPG10_PMIC_B3M_OCP_WARN_Y,
	S2MPG10_PMIC_B3M_OCP_WARN_Z,
	S2MPG10_PMIC_B10M_OCP_WARN,
	S2MPG10_PMIC_B10M_OCP_WARN_X,
	S2MPG10_PMIC_B10M_OCP_WARN_Y,
	S2MPG10_PMIC_B10M_OCP_WARN_Z,
	S2MPG10_PMIC_B2M_SOFT_OCP_WARN,
	S2MPG10_PMIC_B2M_SOFT_OCP_WARN_X,
	S2MPG10_PMIC_B2M_SOFT_OCP_WARN_Y,
	S2MPG10_PMIC_B2M_SOFT_OCP_WARN_Z,
	S2MPG10_PMIC_B3M_SOFT_OCP_WARN,
	S2MPG10_PMIC_B3M_SOFT_OCP_WARN_X,
	S2MPG10_PMIC_B3M_SOFT_OCP_WARN_Y,
	S2MPG10_PMIC_B3M_SOFT_OCP_WARN_Z,
	S2MPG10_PMIC_B10M_SOFT_OCP_WARN,
	S2MPG10_PMIC_B10M_SOFT_OCP_WARN_X,
	S2MPG10_PMIC_B10M_SOFT_OCP_WARN_Y,
	S2MPG10_PMIC_B10M_SOFT_OCP_WARN_Z,
	S2MPG10_PMIC_BUCK_OCP_EN1,
	S2MPG10_PMIC_BUCK_OCP_EN2,
	S2MPG10_PMIC_BUCK_OCP_PD_EN1,
	S2MPG10_PMIC_BUCK_OCP_PD_EN2,
	S2MPG10_PMIC_BUCK_OCP_CTRL1,
	S2MPG10_PMIC_BUCK_OCP_CTRL2,
	S2MPG10_PMIC_BUCK_OCP_CTRL3,
	S2MPG10_PMIC_BUCK_OCP_CTRL4,
	S2MPG10_PMIC_BUCK_OCP_CTRL5,
	S2MPG10_PMIC_PIF_CTRL,
	S2MPG10_PMIC_BUCK_HR_MODE1,
	S2MPG10_PMIC_BUCK_HR_MODE2,
	S2MPG10_PMIC_FAULTOUT_CTRL,
	S2MPG10_PMIC_LDO_SENSE1,
	S2MPG10_PMIC_LDO_SENSE2,
	S2MPG10_PMIC_LDO_SENSE3,
	S2MPG10_PMIC_LDO_SENSE4,
};

/* Rail controlled externally, based on PCTRLSELx */
#define S2MPG10_PMIC_CTRL_ENABLE_EXT BIT(0)

/* For S2MPG10_PMIC_PCTRLSELx */
#define S2MPG10_PCTRLSEL_PWREN           0x1 /* PWREN pin */
#define S2MPG10_PCTRLSEL_PWREN_TRG       0x2 /* PWREN_TRG bit in MIMICKING_CTRL */
#define S2MPG10_PCTRLSEL_PWREN_MIF       0x3 /* PWREN_MIF pin */
#define S2MPG10_PCTRLSEL_PWREN_MIF_TRG   0x4 /* PWREN_MIF_TRG bit in MIMICKING_CTRL */
#define S2MPG10_PCTRLSEL_AP_ACTIVE_N     0x5 /* ~AP_ACTIVE_N pin */
#define S2MPG10_PCTRLSEL_AP_ACTIVE_N_TRG 0x6 /* ~AP_ACTIVE_N_TRG bit in MIMICKING_CTRL */
#define S2MPG10_PCTRLSEL_CPUCL1_EN       0x7 /* CPUCL1_EN pin */
#define S2MPG10_PCTRLSEL_CPUCL1_EN2      0x8 /* CPUCL1_EN & PWREN pins */
#define S2MPG10_PCTRLSEL_CPUCL2_EN       0x9 /* CPUCL2_EN pin */
#define S2MPG10_PCTRLSEL_CPUCL2_EN2      0xa /* CPUCL2_E2 & PWREN pins */
#define S2MPG10_PCTRLSEL_TPU_EN          0xb /* TPU_EN pin */
#define S2MPG10_PCTRLSEL_TPU_EN2         0xc /* TPU_EN & ~AP_ACTIVE_N pins */
#define S2MPG10_PCTRLSEL_TCXO_ON         0xd /* TCXO_ON pin */
#define S2MPG10_PCTRLSEL_TCXO_ON2        0xe /* TCXO_ON & ~AP_ACTIVE_N pins */

/* For S2MPG10_PMIC_PCTRLSELx of LDO20M */
#define S2MPG10_PCTRLSEL_LDO20M_EN2      0x1 /* VLDO20M_EN & LDO20M_SFR */
#define S2MPG10_PCTRLSEL_LDO20M_EN       0x2 /* VLDO20M_EN pin */
#define S2MPG10_PCTRLSEL_LDO20M_SFR      0x3 /* LDO20M_SFR bit in LDO_CTRL1 register */

/* Meter registers (type 0xa00) */
enum s2mpg10_meter_reg {
	S2MPG10_METER_CTRL1,
	S2MPG10_METER_CTRL2,
	S2MPG10_METER_CTRL3,
	S2MPG10_METER_CTRL4,
	S2MPG10_METER_BUCKEN1,
	S2MPG10_METER_BUCKEN2,
	S2MPG10_METER_MUXSEL0,
	S2MPG10_METER_MUXSEL1,
	S2MPG10_METER_MUXSEL2,
	S2MPG10_METER_MUXSEL3,
	S2MPG10_METER_MUXSEL4,
	S2MPG10_METER_MUXSEL5,
	S2MPG10_METER_MUXSEL6,
	S2MPG10_METER_MUXSEL7,
	S2MPG10_METER_LPF_C0_0,
	S2MPG10_METER_LPF_C0_1,
	S2MPG10_METER_LPF_C0_2,
	S2MPG10_METER_LPF_C0_3,
	S2MPG10_METER_LPF_C0_4,
	S2MPG10_METER_LPF_C0_5,
	S2MPG10_METER_LPF_C0_6,
	S2MPG10_METER_LPF_C0_7,
	S2MPG10_METER_PWR_WARN0,
	S2MPG10_METER_PWR_WARN1,
	S2MPG10_METER_PWR_WARN2,
	S2MPG10_METER_PWR_WARN3,
	S2MPG10_METER_PWR_WARN4,
	S2MPG10_METER_PWR_WARN5,
	S2MPG10_METER_PWR_WARN6,
	S2MPG10_METER_PWR_WARN7,
	S2MPG10_METER_PWR_HYS1,
	S2MPG10_METER_PWR_HYS2,
	S2MPG10_METER_PWR_HYS3,
	S2MPG10_METER_PWR_HYS4,
	S2MPG10_METER_ACC_DATA_CH0_1 = 0x40,
	S2MPG10_METER_ACC_DATA_CH0_2,
	S2MPG10_METER_ACC_DATA_CH0_3,
	S2MPG10_METER_ACC_DATA_CH0_4,
	S2MPG10_METER_ACC_DATA_CH0_5,
	S2MPG10_METER_ACC_DATA_CH0_6,
	S2MPG10_METER_ACC_DATA_CH1_1,
	S2MPG10_METER_ACC_DATA_CH1_2,
	S2MPG10_METER_ACC_DATA_CH1_3,
	S2MPG10_METER_ACC_DATA_CH1_4,
	S2MPG10_METER_ACC_DATA_CH1_5,
	S2MPG10_METER_ACC_DATA_CH1_6,
	S2MPG10_METER_ACC_DATA_CH2_1,
	S2MPG10_METER_ACC_DATA_CH2_2,
	S2MPG10_METER_ACC_DATA_CH2_3,
	S2MPG10_METER_ACC_DATA_CH2_4,
	S2MPG10_METER_ACC_DATA_CH2_5,
	S2MPG10_METER_ACC_DATA_CH2_6,
	S2MPG10_METER_ACC_DATA_CH3_1,
	S2MPG10_METER_ACC_DATA_CH3_2,
	S2MPG10_METER_ACC_DATA_CH3_3,
	S2MPG10_METER_ACC_DATA_CH3_4,
	S2MPG10_METER_ACC_DATA_CH3_5,
	S2MPG10_METER_ACC_DATA_CH3_6,
	S2MPG10_METER_ACC_DATA_CH4_1,
	S2MPG10_METER_ACC_DATA_CH4_2,
	S2MPG10_METER_ACC_DATA_CH4_3,
	S2MPG10_METER_ACC_DATA_CH4_4,
	S2MPG10_METER_ACC_DATA_CH4_5,
	S2MPG10_METER_ACC_DATA_CH4_6,
	S2MPG10_METER_ACC_DATA_CH5_1,
	S2MPG10_METER_ACC_DATA_CH5_2,
	S2MPG10_METER_ACC_DATA_CH5_3,
	S2MPG10_METER_ACC_DATA_CH5_4,
	S2MPG10_METER_ACC_DATA_CH5_5,
	S2MPG10_METER_ACC_DATA_CH5_6,
	S2MPG10_METER_ACC_DATA_CH6_1,
	S2MPG10_METER_ACC_DATA_CH6_2,
	S2MPG10_METER_ACC_DATA_CH6_3,
	S2MPG10_METER_ACC_DATA_CH6_4,
	S2MPG10_METER_ACC_DATA_CH6_5,
	S2MPG10_METER_ACC_DATA_CH6_6,
	S2MPG10_METER_ACC_DATA_CH7_1,
	S2MPG10_METER_ACC_DATA_CH7_2,
	S2MPG10_METER_ACC_DATA_CH7_3,
	S2MPG10_METER_ACC_DATA_CH7_4,
	S2MPG10_METER_ACC_DATA_CH7_5,
	S2MPG10_METER_ACC_DATA_CH7_6,
	S2MPG10_METER_ACC_COUNT_1,
	S2MPG10_METER_ACC_COUNT_2,
	S2MPG10_METER_ACC_COUNT_3,
	S2MPG10_METER_LPF_DATA_CH0_1,
	S2MPG10_METER_LPF_DATA_CH0_2,
	S2MPG10_METER_LPF_DATA_CH0_3,
	S2MPG10_METER_LPF_DATA_CH1_1,
	S2MPG10_METER_LPF_DATA_CH1_2,
	S2MPG10_METER_LPF_DATA_CH1_3,
	S2MPG10_METER_LPF_DATA_CH2_1,
	S2MPG10_METER_LPF_DATA_CH2_2,
	S2MPG10_METER_LPF_DATA_CH2_3,
	S2MPG10_METER_LPF_DATA_CH3_1,
	S2MPG10_METER_LPF_DATA_CH3_2,
	S2MPG10_METER_LPF_DATA_CH3_3,
	S2MPG10_METER_LPF_DATA_CH4_1,
	S2MPG10_METER_LPF_DATA_CH4_2,
	S2MPG10_METER_LPF_DATA_CH4_3,
	S2MPG10_METER_LPF_DATA_CH5_1,
	S2MPG10_METER_LPF_DATA_CH5_2,
	S2MPG10_METER_LPF_DATA_CH5_3,
	S2MPG10_METER_LPF_DATA_CH6_1,
	S2MPG10_METER_LPF_DATA_CH6_2,
	S2MPG10_METER_LPF_DATA_CH6_3,
	S2MPG10_METER_LPF_DATA_CH7_1,
	S2MPG10_METER_LPF_DATA_CH7_2,
	S2MPG10_METER_LPF_DATA_CH7_3,
	S2MPG10_METER_DSM_TRIM_OFFSET = 0xee,
	S2MPG10_METER_BUCK_METER_TRIM3 = 0xf1,
};

/* S2MPG10 regulator IDs */
enum s2mpg10_regulators {
	S2MPG10_BUCK1,
	S2MPG10_BUCK2,
	S2MPG10_BUCK3,
	S2MPG10_BUCK4,
	S2MPG10_BUCK5,
	S2MPG10_BUCK6,
	S2MPG10_BUCK7,
	S2MPG10_BUCK8,
	S2MPG10_BUCK9,
	S2MPG10_BUCK10,
	S2MPG10_LDO1,
	S2MPG10_LDO2,
	S2MPG10_LDO3,
	S2MPG10_LDO4,
	S2MPG10_LDO5,
	S2MPG10_LDO6,
	S2MPG10_LDO7,
	S2MPG10_LDO8,
	S2MPG10_LDO9,
	S2MPG10_LDO10,
	S2MPG10_LDO11,
	S2MPG10_LDO12,
	S2MPG10_LDO13,
	S2MPG10_LDO14,
	S2MPG10_LDO15,
	S2MPG10_LDO16,
	S2MPG10_LDO17,
	S2MPG10_LDO18,
	S2MPG10_LDO19,
	S2MPG10_LDO20,
	S2MPG10_LDO21,
	S2MPG10_LDO22,
	S2MPG10_LDO23,
	S2MPG10_LDO24,
	S2MPG10_LDO25,
	S2MPG10_LDO26,
	S2MPG10_LDO27,
	S2MPG10_LDO28,
	S2MPG10_LDO29,
	S2MPG10_LDO30,
	S2MPG10_LDO31,
	S2MPG10_REGULATOR_MAX,
};

#endif /* __LINUX_MFD_S2MPG10_H */
