#ifndef __VMLINUX_H__
#define __VMLINUX_H__

#ifndef BPF_NO_PRESERVE_ACCESS_INDEX
#pragma clang attribute push (__attribute__((preserve_access_index)), apply_to = record)
#endif

#ifndef __ksym
#define __ksym __attribute__((section(".ksyms")))
#endif

#ifndef __weak
#define __weak __attribute__((weak))
#endif

#ifndef __bpf_fastcall
#if __has_attribute(bpf_fastcall)
#define __bpf_fastcall __attribute__((bpf_fastcall))
#else
#define __bpf_fastcall
#endif
#endif

enum {
	ACOMP_WALK_SLEEP = 1,
	ACOMP_WALK_SRC_LINEAR = 2,
	ACOMP_WALK_DST_LINEAR = 4,
};

enum {
	ACPI_BATTERY_ALARM_PRESENT = 0,
	ACPI_BATTERY_XINFO_PRESENT = 1,
	ACPI_BATTERY_QUIRK_PERCENTAGE_CAPACITY = 2,
	ACPI_BATTERY_QUIRK_THINKPAD_MAH = 3,
	ACPI_BATTERY_QUIRK_DEGRADED_FULL_CHARGE = 4,
};

enum {
	ACPI_BUTTON_LID_INIT_IGNORE = 0,
	ACPI_BUTTON_LID_INIT_OPEN = 1,
	ACPI_BUTTON_LID_INIT_METHOD = 2,
	ACPI_BUTTON_LID_INIT_DISABLED = 3,
};

enum {
	ACPI_GENL_ATTR_UNSPEC = 0,
	ACPI_GENL_ATTR_EVENT = 1,
	__ACPI_GENL_ATTR_MAX = 2,
};

enum {
	ACPI_GENL_CMD_UNSPEC = 0,
	ACPI_GENL_CMD_EVENT = 1,
	__ACPI_GENL_CMD_MAX = 2,
};

enum {
	ACPI_REFCLASS_LOCAL = 0,
	ACPI_REFCLASS_ARG = 1,
	ACPI_REFCLASS_REFOF = 2,
	ACPI_REFCLASS_INDEX = 3,
	ACPI_REFCLASS_TABLE = 4,
	ACPI_REFCLASS_NAME = 5,
	ACPI_REFCLASS_DEBUG = 6,
	ACPI_REFCLASS_MAX = 6,
};

enum {
	ACPI_RSC_INITGET = 0,
	ACPI_RSC_INITSET = 1,
	ACPI_RSC_FLAGINIT = 2,
	ACPI_RSC_1BITFLAG = 3,
	ACPI_RSC_2BITFLAG = 4,
	ACPI_RSC_3BITFLAG = 5,
	ACPI_RSC_6BITFLAG = 6,
	ACPI_RSC_ADDRESS = 7,
	ACPI_RSC_BITMASK = 8,
	ACPI_RSC_BITMASK16 = 9,
	ACPI_RSC_COUNT = 10,
	ACPI_RSC_COUNT16 = 11,
	ACPI_RSC_COUNT_GPIO_PIN = 12,
	ACPI_RSC_COUNT_GPIO_RES = 13,
	ACPI_RSC_COUNT_GPIO_VEN = 14,
	ACPI_RSC_COUNT_SERIAL_RES = 15,
	ACPI_RSC_COUNT_SERIAL_VEN = 16,
	ACPI_RSC_DATA8 = 17,
	ACPI_RSC_EXIT_EQ = 18,
	ACPI_RSC_EXIT_LE = 19,
	ACPI_RSC_EXIT_NE = 20,
	ACPI_RSC_LENGTH = 21,
	ACPI_RSC_MOVE_GPIO_PIN = 22,
	ACPI_RSC_MOVE_GPIO_RES = 23,
	ACPI_RSC_MOVE_SERIAL_RES = 24,
	ACPI_RSC_MOVE_SERIAL_VEN = 25,
	ACPI_RSC_MOVE8 = 26,
	ACPI_RSC_MOVE16 = 27,
	ACPI_RSC_MOVE32 = 28,
	ACPI_RSC_MOVE64 = 29,
	ACPI_RSC_SET8 = 30,
	ACPI_RSC_SOURCE = 31,
	ACPI_RSC_SOURCEX = 32,
};

enum {
	ACPI_RSD_TITLE = 0,
	ACPI_RSD_1BITFLAG = 1,
	ACPI_RSD_2BITFLAG = 2,
	ACPI_RSD_3BITFLAG = 3,
	ACPI_RSD_6BITFLAG = 4,
	ACPI_RSD_ADDRESS = 5,
	ACPI_RSD_DWORDLIST = 6,
	ACPI_RSD_LITERAL = 7,
	ACPI_RSD_LONGLIST = 8,
	ACPI_RSD_SHORTLIST = 9,
	ACPI_RSD_SHORTLISTX = 10,
	ACPI_RSD_SOURCE = 11,
	ACPI_RSD_STRING = 12,
	ACPI_RSD_UINT8 = 13,
	ACPI_RSD_UINT16 = 14,
	ACPI_RSD_UINT32 = 15,
	ACPI_RSD_UINT64 = 16,
	ACPI_RSD_WORDLIST = 17,
	ACPI_RSD_LABEL = 18,
	ACPI_RSD_SOURCE_LABEL = 19,
};

enum {
	ACTION_FAIL = 0,
	ACTION_REPREP = 1,
	ACTION_DELAYED_REPREP = 2,
	ACTION_RETRY = 3,
	ACTION_DELAYED_RETRY = 4,
};

enum {
	AFFINITY = 0,
	AFFINITY_LIST = 1,
	EFFECTIVE = 2,
	EFFECTIVE_LIST = 3,
};

enum {
	AHCI_MAX_PORTS = 32,
	AHCI_MAX_SG = 168,
	AHCI_DMA_BOUNDARY = 4294967295,
	AHCI_MAX_CMDS = 32,
	AHCI_CMD_SZ = 32,
	AHCI_CMD_SLOT_SZ = 1024,
	AHCI_RX_FIS_SZ = 256,
	AHCI_CMD_TBL_CDB = 64,
	AHCI_CMD_TBL_HDR_SZ = 128,
	AHCI_CMD_TBL_SZ = 2816,
	AHCI_CMD_TBL_AR_SZ = 90112,
	AHCI_PORT_PRIV_DMA_SZ = 91392,
	AHCI_PORT_PRIV_FBS_DMA_SZ = 95232,
	AHCI_IRQ_ON_SG = 2147483648,
	AHCI_CMD_ATAPI = 32,
	AHCI_CMD_WRITE = 64,
	AHCI_CMD_PREFETCH = 128,
	AHCI_CMD_RESET = 256,
	AHCI_CMD_CLR_BUSY = 1024,
	RX_FIS_PIO_SETUP = 32,
	RX_FIS_D2H_REG = 64,
	RX_FIS_SDB = 88,
	RX_FIS_UNK = 96,
	HOST_CAP = 0,
	HOST_CTL = 4,
	HOST_IRQ_STAT = 8,
	HOST_PORTS_IMPL = 12,
	HOST_VERSION = 16,
	HOST_EM_LOC = 28,
	HOST_EM_CTL = 32,
	HOST_CAP2 = 36,
	HOST_RESET = 1,
	HOST_IRQ_EN = 2,
	HOST_MRSM = 4,
	HOST_AHCI_EN = 2147483648,
	HOST_CAP_SXS = 32,
	HOST_CAP_EMS = 64,
	HOST_CAP_CCC = 128,
	HOST_CAP_PART = 8192,
	HOST_CAP_SSC = 16384,
	HOST_CAP_PIO_MULTI = 32768,
	HOST_CAP_FBS = 65536,
	HOST_CAP_PMP = 131072,
	HOST_CAP_ONLY = 262144,
	HOST_CAP_CLO = 16777216,
	HOST_CAP_LED = 33554432,
	HOST_CAP_ALPM = 67108864,
	HOST_CAP_SSS = 134217728,
	HOST_CAP_MPS = 268435456,
	HOST_CAP_SNTF = 536870912,
	HOST_CAP_NCQ = 1073741824,
	HOST_CAP_64 = 2147483648,
	HOST_CAP2_BOH = 1,
	HOST_CAP2_NVMHCI = 2,
	HOST_CAP2_APST = 4,
	HOST_CAP2_SDS = 8,
	HOST_CAP2_SADM = 16,
	HOST_CAP2_DESO = 32,
	PORT_LST_ADDR = 0,
	PORT_LST_ADDR_HI = 4,
	PORT_FIS_ADDR = 8,
	PORT_FIS_ADDR_HI = 12,
	PORT_IRQ_STAT = 16,
	PORT_IRQ_MASK = 20,
	PORT_CMD = 24,
	PORT_TFDATA = 32,
	PORT_SIG = 36,
	PORT_CMD_ISSUE = 56,
	PORT_SCR_STAT = 40,
	PORT_SCR_CTL = 44,
	PORT_SCR_ERR = 48,
	PORT_SCR_ACT = 52,
	PORT_SCR_NTF = 60,
	PORT_FBS = 64,
	PORT_DEVSLP = 68,
	PORT_IRQ_COLD_PRES = 2147483648,
	PORT_IRQ_TF_ERR = 1073741824,
	PORT_IRQ_HBUS_ERR = 536870912,
	PORT_IRQ_HBUS_DATA_ERR = 268435456,
	PORT_IRQ_IF_ERR = 134217728,
	PORT_IRQ_IF_NONFATAL = 67108864,
	PORT_IRQ_OVERFLOW = 16777216,
	PORT_IRQ_BAD_PMP = 8388608,
	PORT_IRQ_PHYRDY = 4194304,
	PORT_IRQ_DMPS = 128,
	PORT_IRQ_CONNECT = 64,
	PORT_IRQ_SG_DONE = 32,
	PORT_IRQ_UNK_FIS = 16,
	PORT_IRQ_SDB_FIS = 8,
	PORT_IRQ_DMAS_FIS = 4,
	PORT_IRQ_PIOS_FIS = 2,
	PORT_IRQ_D2H_REG_FIS = 1,
	PORT_IRQ_FREEZE = 683671632,
	PORT_IRQ_ERROR = 2025848912,
	DEF_PORT_IRQ = 2025848959,
	PORT_CMD_ASP = 134217728,
	PORT_CMD_ALPE = 67108864,
	PORT_CMD_ATAPI = 16777216,
	PORT_CMD_FBSCP = 4194304,
	PORT_CMD_ESP = 2097152,
	PORT_CMD_CPD = 1048576,
	PORT_CMD_MPSP = 524288,
	PORT_CMD_HPCP = 262144,
	PORT_CMD_PMP = 131072,
	PORT_CMD_LIST_ON = 32768,
	PORT_CMD_FIS_ON = 16384,
	PORT_CMD_FIS_RX = 16,
	PORT_CMD_CLO = 8,
	PORT_CMD_POWER_ON = 4,
	PORT_CMD_SPIN_UP = 2,
	PORT_CMD_START = 1,
	PORT_CMD_ICC_MASK = 4026531840,
	PORT_CMD_ICC_ACTIVE = 268435456,
	PORT_CMD_ICC_PARTIAL = 536870912,
	PORT_CMD_ICC_SLUMBER = 1610612736,
	PORT_CMD_CAP = 8126464,
	PORT_FBS_DWE_OFFSET = 16,
	PORT_FBS_ADO_OFFSET = 12,
	PORT_FBS_DEV_OFFSET = 8,
	PORT_FBS_DEV_MASK = 3840,
	PORT_FBS_SDE = 4,
	PORT_FBS_DEC = 2,
	PORT_FBS_EN = 1,
	PORT_DEVSLP_DM_OFFSET = 25,
	PORT_DEVSLP_DM_MASK = 503316480,
	PORT_DEVSLP_DITO_OFFSET = 15,
	PORT_DEVSLP_MDAT_OFFSET = 10,
	PORT_DEVSLP_DETO_OFFSET = 2,
	PORT_DEVSLP_DSP = 2,
	PORT_DEVSLP_ADSE = 1,
	AHCI_HFLAG_NO_NCQ = 1,
	AHCI_HFLAG_IGN_IRQ_IF_ERR = 2,
	AHCI_HFLAG_IGN_SERR_INTERNAL = 4,
	AHCI_HFLAG_32BIT_ONLY = 8,
	AHCI_HFLAG_MV_PATA = 16,
	AHCI_HFLAG_NO_MSI = 32,
	AHCI_HFLAG_NO_PMP = 64,
	AHCI_HFLAG_SECT255 = 256,
	AHCI_HFLAG_YES_NCQ = 512,
	AHCI_HFLAG_NO_SUSPEND = 1024,
	AHCI_HFLAG_SRST_TOUT_IS_OFFLINE = 2048,
	AHCI_HFLAG_NO_SNTF = 4096,
	AHCI_HFLAG_NO_FPDMA_AA = 8192,
	AHCI_HFLAG_YES_FBS = 16384,
	AHCI_HFLAG_DELAY_ENGINE = 32768,
	AHCI_HFLAG_NO_DEVSLP = 131072,
	AHCI_HFLAG_NO_FBS = 262144,
	AHCI_HFLAG_MULTI_MSI = 1048576,
	AHCI_HFLAG_WAKE_BEFORE_STOP = 4194304,
	AHCI_HFLAG_YES_ALPM = 8388608,
	AHCI_HFLAG_NO_WRITE_TO_RO = 16777216,
	AHCI_HFLAG_SUSPEND_PHYS = 33554432,
	AHCI_HFLAG_NO_SXS = 67108864,
	AHCI_HFLAG_43BIT_ONLY = 134217728,
	AHCI_HFLAG_INTEL_PCS_QUIRK = 268435456,
	AHCI_HFLAG_ATAPI_DMA_QUIRK = 536870912,
	AHCI_FLAG_COMMON = 393346,
	ICH_MAP = 144,
	PCS_6 = 146,
	PCS_7 = 148,
	EM_MAX_SLOTS = 15,
	EM_MAX_RETRY = 5,
	EM_CTL_RST = 512,
	EM_CTL_TM = 256,
	EM_CTL_MR = 1,
	EM_CTL_ALHD = 67108864,
	EM_CTL_XMT = 33554432,
	EM_CTL_SMB = 16777216,
	EM_CTL_SGPIO = 524288,
	EM_CTL_SES = 262144,
	EM_CTL_SAFTE = 131072,
	EM_CTL_LED = 65536,
	EM_MSG_TYPE_LED = 1,
	EM_MSG_TYPE_SAFTE = 2,
	EM_MSG_TYPE_SES2 = 4,
	EM_MSG_TYPE_SGPIO = 8,
};

enum {
	AHCI_PCI_BAR_STA2X11 = 0,
	AHCI_PCI_BAR_CAVIUM = 0,
	AHCI_PCI_BAR_LOONGSON = 0,
	AHCI_PCI_BAR_ENMOTUS = 2,
	AHCI_PCI_BAR_CAVIUM_GEN5 = 4,
	AHCI_PCI_BAR_STANDARD = 5,
};

enum {
	AML_FIELD_ACCESS_ANY = 0,
	AML_FIELD_ACCESS_BYTE = 1,
	AML_FIELD_ACCESS_WORD = 2,
	AML_FIELD_ACCESS_DWORD = 3,
	AML_FIELD_ACCESS_QWORD = 4,
	AML_FIELD_ACCESS_BUFFER = 5,
};

enum {
	AML_FIELD_ATTRIB_QUICK = 2,
	AML_FIELD_ATTRIB_SEND_RECEIVE = 4,
	AML_FIELD_ATTRIB_BYTE = 6,
	AML_FIELD_ATTRIB_WORD = 8,
	AML_FIELD_ATTRIB_BLOCK = 10,
	AML_FIELD_ATTRIB_BYTES = 11,
	AML_FIELD_ATTRIB_PROCESS_CALL = 12,
	AML_FIELD_ATTRIB_BLOCK_PROCESS_CALL = 13,
	AML_FIELD_ATTRIB_RAW_BYTES = 14,
	AML_FIELD_ATTRIB_RAW_PROCESS_BYTES = 15,
};

enum {
	AML_FIELD_UPDATE_PRESERVE = 0,
	AML_FIELD_UPDATE_WRITE_AS_ONES = 32,
	AML_FIELD_UPDATE_WRITE_AS_ZEROS = 64,
};

enum {
	ARCH_LBR_BR_TYPE_JCC = 0,
	ARCH_LBR_BR_TYPE_NEAR_IND_JMP = 1,
	ARCH_LBR_BR_TYPE_NEAR_REL_JMP = 2,
	ARCH_LBR_BR_TYPE_NEAR_IND_CALL = 3,
	ARCH_LBR_BR_TYPE_NEAR_REL_CALL = 4,
	ARCH_LBR_BR_TYPE_NEAR_RET = 5,
	ARCH_LBR_BR_TYPE_KNOWN_MAX = 5,
	ARCH_LBR_BR_TYPE_MAP_MAX = 16,
};

enum {
	AS3711_REGULATOR = 0,
	AS3711_BACKLIGHT = 1,
};

enum {
	ASCII_NULL = 0,
	ASCII_BELL = 7,
	ASCII_BACKSPACE = 8,
	ASCII_IGNORE_FIRST = 8,
	ASCII_HTAB = 9,
	ASCII_LINEFEED = 10,
	ASCII_VTAB = 11,
	ASCII_FORMFEED = 12,
	ASCII_CAR_RET = 13,
	ASCII_IGNORE_LAST = 13,
	ASCII_SHIFTOUT = 14,
	ASCII_SHIFTIN = 15,
	ASCII_CANCEL = 24,
	ASCII_SUBSTITUTE = 26,
	ASCII_ESCAPE = 27,
	ASCII_CSI_IGNORE_FIRST = 32,
	ASCII_CSI_IGNORE_LAST = 63,
	ASCII_DEL = 127,
	ASCII_EXT_CSI = 155,
};

enum {
	ASSUME_PERFECT = 255,
	ASSUME_VALID_DTB = 1,
	ASSUME_VALID_INPUT = 2,
	ASSUME_LATEST = 4,
	ASSUME_NO_ROLLBACK = 8,
	ASSUME_LIBFDT_ORDER = 16,
	ASSUME_LIBFDT_FLAWLESS = 32,
};

enum {
	ATA_EH_SPDN_NCQ_OFF = 1,
	ATA_EH_SPDN_SPEED_DOWN = 2,
	ATA_EH_SPDN_FALLBACK_TO_PIO = 4,
	ATA_EH_SPDN_KEEP_ERRORS = 8,
	ATA_EFLAG_IS_IO = 1,
	ATA_EFLAG_DUBIOUS_XFER = 2,
	ATA_EFLAG_OLD_ER = -2147483648,
	ATA_ECAT_NONE = 0,
	ATA_ECAT_ATA_BUS = 1,
	ATA_ECAT_TOUT_HSM = 2,
	ATA_ECAT_UNK_DEV = 3,
	ATA_ECAT_DUBIOUS_NONE = 4,
	ATA_ECAT_DUBIOUS_ATA_BUS = 5,
	ATA_ECAT_DUBIOUS_TOUT_HSM = 6,
	ATA_ECAT_DUBIOUS_UNK_DEV = 7,
	ATA_ECAT_NR = 8,
	ATA_EH_CMD_DFL_TIMEOUT = 5000,
	ATA_EH_RESET_COOL_DOWN = 5000,
	ATA_EH_PRERESET_TIMEOUT = 10000,
	ATA_EH_FASTDRAIN_INTERVAL = 3000,
	ATA_EH_UA_TRIES = 5,
	ATA_EH_PROBE_TRIAL_INTERVAL = 60000,
	ATA_EH_PROBE_TRIALS = 2,
};

enum {
	ATA_MAX_DEVICES = 2,
	ATA_MAX_PRD = 256,
	ATA_SECT_SIZE = 512,
	ATA_MAX_SECTORS_128 = 128,
	ATA_MAX_SECTORS = 256,
	ATA_MAX_SECTORS_1024 = 1024,
	ATA_MAX_SECTORS_LBA48 = 65535,
	ATA_MAX_SECTORS_TAPE = 65535,
	ATA_MAX_TRIM_RNUM = 64,
	ATA_ID_WORDS = 256,
	ATA_ID_CONFIG = 0,
	ATA_ID_CYLS = 1,
	ATA_ID_HEADS = 3,
	ATA_ID_SECTORS = 6,
	ATA_ID_SERNO = 10,
	ATA_ID_BUF_SIZE = 21,
	ATA_ID_FW_REV = 23,
	ATA_ID_PROD = 27,
	ATA_ID_MAX_MULTSECT = 47,
	ATA_ID_DWORD_IO = 48,
	ATA_ID_TRUSTED = 48,
	ATA_ID_CAPABILITY = 49,
	ATA_ID_OLD_PIO_MODES = 51,
	ATA_ID_OLD_DMA_MODES = 52,
	ATA_ID_FIELD_VALID = 53,
	ATA_ID_CUR_CYLS = 54,
	ATA_ID_CUR_HEADS = 55,
	ATA_ID_CUR_SECTORS = 56,
	ATA_ID_MULTSECT = 59,
	ATA_ID_LBA_CAPACITY = 60,
	ATA_ID_SWDMA_MODES = 62,
	ATA_ID_MWDMA_MODES = 63,
	ATA_ID_PIO_MODES = 64,
	ATA_ID_EIDE_DMA_MIN = 65,
	ATA_ID_EIDE_DMA_TIME = 66,
	ATA_ID_EIDE_PIO = 67,
	ATA_ID_EIDE_PIO_IORDY = 68,
	ATA_ID_ADDITIONAL_SUPP = 69,
	ATA_ID_QUEUE_DEPTH = 75,
	ATA_ID_SATA_CAPABILITY = 76,
	ATA_ID_SATA_CAPABILITY_2 = 77,
	ATA_ID_FEATURE_SUPP = 78,
	ATA_ID_MAJOR_VER = 80,
	ATA_ID_COMMAND_SET_1 = 82,
	ATA_ID_COMMAND_SET_2 = 83,
	ATA_ID_CFSSE = 84,
	ATA_ID_CFS_ENABLE_1 = 85,
	ATA_ID_CFS_ENABLE_2 = 86,
	ATA_ID_CSF_DEFAULT = 87,
	ATA_ID_UDMA_MODES = 88,
	ATA_ID_HW_CONFIG = 93,
	ATA_ID_SPG = 98,
	ATA_ID_LBA_CAPACITY_2 = 100,
	ATA_ID_SECTOR_SIZE = 106,
	ATA_ID_WWN = 108,
	ATA_ID_LOGICAL_SECTOR_SIZE = 117,
	ATA_ID_COMMAND_SET_3 = 119,
	ATA_ID_COMMAND_SET_4 = 120,
	ATA_ID_LAST_LUN = 126,
	ATA_ID_DLF = 128,
	ATA_ID_CSFO = 129,
	ATA_ID_CFA_POWER = 160,
	ATA_ID_CFA_KEY_MGMT = 162,
	ATA_ID_CFA_MODES = 163,
	ATA_ID_DATA_SET_MGMT = 169,
	ATA_ID_SCT_CMD_XPORT = 206,
	ATA_ID_ROT_SPEED = 217,
	ATA_ID_PIO4 = 2,
	ATA_ID_SERNO_LEN = 20,
	ATA_ID_FW_REV_LEN = 8,
	ATA_ID_PROD_LEN = 40,
	ATA_ID_WWN_LEN = 8,
	ATA_PCI_CTL_OFS = 2,
	ATA_PIO0 = 1,
	ATA_PIO1 = 3,
	ATA_PIO2 = 7,
	ATA_PIO3 = 15,
	ATA_PIO4 = 31,
	ATA_PIO5 = 63,
	ATA_PIO6 = 127,
	ATA_PIO4_ONLY = 16,
	ATA_SWDMA0 = 1,
	ATA_SWDMA1 = 3,
	ATA_SWDMA2 = 7,
	ATA_SWDMA2_ONLY = 4,
	ATA_MWDMA0 = 1,
	ATA_MWDMA1 = 3,
	ATA_MWDMA2 = 7,
	ATA_MWDMA3 = 15,
	ATA_MWDMA4 = 31,
	ATA_MWDMA12_ONLY = 6,
	ATA_MWDMA2_ONLY = 4,
	ATA_UDMA0 = 1,
	ATA_UDMA1 = 3,
	ATA_UDMA2 = 7,
	ATA_UDMA3 = 15,
	ATA_UDMA4 = 31,
	ATA_UDMA5 = 63,
	ATA_UDMA6 = 127,
	ATA_UDMA7 = 255,
	ATA_UDMA24_ONLY = 20,
	ATA_UDMA_MASK_40C = 7,
	ATA_PRD_SZ = 8,
	ATA_PRD_TBL_SZ = 2048,
	ATA_PRD_EOT = -2147483648,
	ATA_DMA_TABLE_OFS = 4,
	ATA_DMA_STATUS = 2,
	ATA_DMA_CMD = 0,
	ATA_DMA_WR = 8,
	ATA_DMA_START = 1,
	ATA_DMA_INTR = 4,
	ATA_DMA_ERR = 2,
	ATA_DMA_ACTIVE = 1,
	ATA_HOB = 128,
	ATA_NIEN = 2,
	ATA_LBA = 64,
	ATA_DEV1 = 16,
	ATA_DEVICE_OBS = 160,
	ATA_DEVCTL_OBS = 8,
	ATA_BUSY = 128,
	ATA_DRDY = 64,
	ATA_DF = 32,
	ATA_DSC = 16,
	ATA_DRQ = 8,
	ATA_CORR = 4,
	ATA_SENSE = 2,
	ATA_ERR = 1,
	ATA_SRST = 4,
	ATA_ICRC = 128,
	ATA_BBK = 128,
	ATA_UNC = 64,
	ATA_MC = 32,
	ATA_IDNF = 16,
	ATA_MCR = 8,
	ATA_ABORTED = 4,
	ATA_TRK0NF = 2,
	ATA_AMNF = 1,
	ATAPI_LFS = 240,
	ATAPI_EOM = 2,
	ATAPI_ILI = 1,
	ATAPI_IO = 2,
	ATAPI_COD = 1,
	ATA_REG_DATA = 0,
	ATA_REG_ERR = 1,
	ATA_REG_NSECT = 2,
	ATA_REG_LBAL = 3,
	ATA_REG_LBAM = 4,
	ATA_REG_LBAH = 5,
	ATA_REG_DEVICE = 6,
	ATA_REG_STATUS = 7,
	ATA_REG_FEATURE = 1,
	ATA_REG_CMD = 7,
	ATA_REG_BYTEL = 4,
	ATA_REG_BYTEH = 5,
	ATA_REG_DEVSEL = 6,
	ATA_REG_IRQ = 2,
	ATA_CMD_DEV_RESET = 8,
	ATA_CMD_CHK_POWER = 229,
	ATA_CMD_STANDBY = 226,
	ATA_CMD_IDLE = 227,
	ATA_CMD_EDD = 144,
	ATA_CMD_DOWNLOAD_MICRO = 146,
	ATA_CMD_DOWNLOAD_MICRO_DMA = 147,
	ATA_CMD_NOP = 0,
	ATA_CMD_FLUSH = 231,
	ATA_CMD_FLUSH_EXT = 234,
	ATA_CMD_ID_ATA = 236,
	ATA_CMD_ID_ATAPI = 161,
	ATA_CMD_SERVICE = 162,
	ATA_CMD_READ = 200,
	ATA_CMD_READ_EXT = 37,
	ATA_CMD_READ_QUEUED = 38,
	ATA_CMD_READ_STREAM_EXT = 43,
	ATA_CMD_READ_STREAM_DMA_EXT = 42,
	ATA_CMD_WRITE = 202,
	ATA_CMD_WRITE_EXT = 53,
	ATA_CMD_WRITE_QUEUED = 54,
	ATA_CMD_WRITE_STREAM_EXT = 59,
	ATA_CMD_WRITE_STREAM_DMA_EXT = 58,
	ATA_CMD_WRITE_FUA_EXT = 61,
	ATA_CMD_WRITE_QUEUED_FUA_EXT = 62,
	ATA_CMD_FPDMA_READ = 96,
	ATA_CMD_FPDMA_WRITE = 97,
	ATA_CMD_NCQ_NON_DATA = 99,
	ATA_CMD_FPDMA_SEND = 100,
	ATA_CMD_FPDMA_RECV = 101,
	ATA_CMD_PIO_READ = 32,
	ATA_CMD_PIO_READ_EXT = 36,
	ATA_CMD_PIO_WRITE = 48,
	ATA_CMD_PIO_WRITE_EXT = 52,
	ATA_CMD_READ_MULTI = 196,
	ATA_CMD_READ_MULTI_EXT = 41,
	ATA_CMD_WRITE_MULTI = 197,
	ATA_CMD_WRITE_MULTI_EXT = 57,
	ATA_CMD_WRITE_MULTI_FUA_EXT = 206,
	ATA_CMD_SET_FEATURES = 239,
	ATA_CMD_SET_MULTI = 198,
	ATA_CMD_PACKET = 160,
	ATA_CMD_VERIFY = 64,
	ATA_CMD_VERIFY_EXT = 66,
	ATA_CMD_WRITE_UNCORR_EXT = 69,
	ATA_CMD_STANDBYNOW1 = 224,
	ATA_CMD_IDLEIMMEDIATE = 225,
	ATA_CMD_SLEEP = 230,
	ATA_CMD_INIT_DEV_PARAMS = 145,
	ATA_CMD_READ_NATIVE_MAX = 248,
	ATA_CMD_READ_NATIVE_MAX_EXT = 39,
	ATA_CMD_SET_MAX = 249,
	ATA_CMD_SET_MAX_EXT = 55,
	ATA_CMD_READ_LOG_EXT = 47,
	ATA_CMD_WRITE_LOG_EXT = 63,
	ATA_CMD_READ_LOG_DMA_EXT = 71,
	ATA_CMD_WRITE_LOG_DMA_EXT = 87,
	ATA_CMD_TRUSTED_NONDATA = 91,
	ATA_CMD_TRUSTED_RCV = 92,
	ATA_CMD_TRUSTED_RCV_DMA = 93,
	ATA_CMD_TRUSTED_SND = 94,
	ATA_CMD_TRUSTED_SND_DMA = 95,
	ATA_CMD_PMP_READ = 228,
	ATA_CMD_PMP_READ_DMA = 233,
	ATA_CMD_PMP_WRITE = 232,
	ATA_CMD_PMP_WRITE_DMA = 235,
	ATA_CMD_CONF_OVERLAY = 177,
	ATA_CMD_SEC_SET_PASS = 241,
	ATA_CMD_SEC_UNLOCK = 242,
	ATA_CMD_SEC_ERASE_PREP = 243,
	ATA_CMD_SEC_ERASE_UNIT = 244,
	ATA_CMD_SEC_FREEZE_LOCK = 245,
	ATA_CMD_SEC_DISABLE_PASS = 246,
	ATA_CMD_CONFIG_STREAM = 81,
	ATA_CMD_SMART = 176,
	ATA_CMD_MEDIA_LOCK = 222,
	ATA_CMD_MEDIA_UNLOCK = 223,
	ATA_CMD_DSM = 6,
	ATA_CMD_CHK_MED_CRD_TYP = 209,
	ATA_CMD_CFA_REQ_EXT_ERR = 3,
	ATA_CMD_CFA_WRITE_NE = 56,
	ATA_CMD_CFA_TRANS_SECT = 135,
	ATA_CMD_CFA_ERASE = 192,
	ATA_CMD_CFA_WRITE_MULT_NE = 205,
	ATA_CMD_REQ_SENSE_DATA = 11,
	ATA_CMD_SANITIZE_DEVICE = 180,
	ATA_CMD_ZAC_MGMT_IN = 74,
	ATA_CMD_ZAC_MGMT_OUT = 159,
	ATA_CMD_RESTORE = 16,
	ATA_SUBCMD_FPDMA_RECV_RD_LOG_DMA_EXT = 1,
	ATA_SUBCMD_FPDMA_RECV_ZAC_MGMT_IN = 2,
	ATA_SUBCMD_FPDMA_SEND_DSM = 0,
	ATA_SUBCMD_FPDMA_SEND_WR_LOG_DMA_EXT = 2,
	ATA_SUBCMD_NCQ_NON_DATA_ABORT_QUEUE = 0,
	ATA_SUBCMD_NCQ_NON_DATA_SET_FEATURES = 5,
	ATA_SUBCMD_NCQ_NON_DATA_ZERO_EXT = 6,
	ATA_SUBCMD_NCQ_NON_DATA_ZAC_MGMT_OUT = 7,
	ATA_SUBCMD_ZAC_MGMT_IN_REPORT_ZONES = 0,
	ATA_SUBCMD_ZAC_MGMT_OUT_CLOSE_ZONE = 1,
	ATA_SUBCMD_ZAC_MGMT_OUT_FINISH_ZONE = 2,
	ATA_SUBCMD_ZAC_MGMT_OUT_OPEN_ZONE = 3,
	ATA_SUBCMD_ZAC_MGMT_OUT_RESET_WRITE_POINTER = 4,
	ATA_LOG_DIRECTORY = 0,
	ATA_LOG_SATA_NCQ = 16,
	ATA_LOG_NCQ_NON_DATA = 18,
	ATA_LOG_NCQ_SEND_RECV = 19,
	ATA_LOG_CDL = 24,
	ATA_LOG_CDL_SIZE = 512,
	ATA_LOG_IDENTIFY_DEVICE = 48,
	ATA_LOG_SENSE_NCQ = 15,
	ATA_LOG_SENSE_NCQ_SIZE = 1024,
	ATA_LOG_CONCURRENT_POSITIONING_RANGES = 71,
	ATA_LOG_SUPPORTED_CAPABILITIES = 3,
	ATA_LOG_CURRENT_SETTINGS = 4,
	ATA_LOG_SECURITY = 6,
	ATA_LOG_SATA_SETTINGS = 8,
	ATA_LOG_ZONED_INFORMATION = 9,
	ATA_LOG_DEVSLP_OFFSET = 48,
	ATA_LOG_DEVSLP_SIZE = 8,
	ATA_LOG_DEVSLP_MDAT = 0,
	ATA_LOG_DEVSLP_MDAT_MASK = 31,
	ATA_LOG_DEVSLP_DETO = 1,
	ATA_LOG_DEVSLP_VALID = 7,
	ATA_LOG_DEVSLP_VALID_MASK = 128,
	ATA_LOG_NCQ_PRIO_OFFSET = 9,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_DSM = 1,
	ATA_LOG_NCQ_SEND_RECV_DSM_OFFSET = 4,
	ATA_LOG_NCQ_SEND_RECV_DSM_TRIM = 1,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_OFFSET = 8,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_OFFSET = 12,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OFFSET = 16,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OUT_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_IN_SUPPORTED = 2,
	ATA_LOG_NCQ_SEND_RECV_SIZE = 20,
	ATA_LOG_NCQ_NON_DATA_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_NCQ = 1,
	ATA_LOG_NCQ_NON_DATA_ABORT_ALL = 2,
	ATA_LOG_NCQ_NON_DATA_ABORT_STREAMING = 4,
	ATA_LOG_NCQ_NON_DATA_ABORT_NON_STREAMING = 8,
	ATA_LOG_NCQ_NON_DATA_ABORT_SELECTED = 16,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OFFSET = 28,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OUT = 1,
	ATA_LOG_NCQ_NON_DATA_SIZE = 64,
	ATA_CMD_READ_LONG = 34,
	ATA_CMD_READ_LONG_ONCE = 35,
	ATA_CMD_WRITE_LONG = 50,
	ATA_CMD_WRITE_LONG_ONCE = 51,
	SETFEATURES_XFER = 3,
	XFER_UDMA_7 = 71,
	XFER_UDMA_6 = 70,
	XFER_UDMA_5 = 69,
	XFER_UDMA_4 = 68,
	XFER_UDMA_3 = 67,
	XFER_UDMA_2 = 66,
	XFER_UDMA_1 = 65,
	XFER_UDMA_0 = 64,
	XFER_MW_DMA_4 = 36,
	XFER_MW_DMA_3 = 35,
	XFER_MW_DMA_2 = 34,
	XFER_MW_DMA_1 = 33,
	XFER_MW_DMA_0 = 32,
	XFER_SW_DMA_2 = 18,
	XFER_SW_DMA_1 = 17,
	XFER_SW_DMA_0 = 16,
	XFER_PIO_6 = 14,
	XFER_PIO_5 = 13,
	XFER_PIO_4 = 12,
	XFER_PIO_3 = 11,
	XFER_PIO_2 = 10,
	XFER_PIO_1 = 9,
	XFER_PIO_0 = 8,
	XFER_PIO_SLOW = 0,
	SETFEATURES_WC_ON = 2,
	SETFEATURES_WC_OFF = 130,
	SETFEATURES_RA_ON = 170,
	SETFEATURES_RA_OFF = 85,
	SETFEATURES_AAM_ON = 66,
	SETFEATURES_AAM_OFF = 194,
	SETFEATURES_SPINUP = 7,
	SETFEATURES_SPINUP_TIMEOUT = 30000,
	SETFEATURES_SATA_ENABLE = 16,
	SETFEATURES_SATA_DISABLE = 144,
	SETFEATURES_CDL = 13,
	SATA_FPDMA_OFFSET = 1,
	SATA_FPDMA_AA = 2,
	SATA_DIPM = 3,
	SATA_FPDMA_IN_ORDER = 4,
	SATA_AN = 5,
	SATA_SSP = 6,
	SATA_DEVSLP = 9,
	SETFEATURE_SENSE_DATA = 195,
	SETFEATURE_SENSE_DATA_SUCC_NCQ = 196,
	ATA_SET_MAX_ADDR = 0,
	ATA_SET_MAX_PASSWD = 1,
	ATA_SET_MAX_LOCK = 2,
	ATA_SET_MAX_UNLOCK = 3,
	ATA_SET_MAX_FREEZE_LOCK = 4,
	ATA_SET_MAX_PASSWD_DMA = 5,
	ATA_SET_MAX_UNLOCK_DMA = 6,
	ATA_DCO_RESTORE = 192,
	ATA_DCO_FREEZE_LOCK = 193,
	ATA_DCO_IDENTIFY = 194,
	ATA_DCO_SET = 195,
	ATA_SMART_ENABLE = 216,
	ATA_SMART_READ_VALUES = 208,
	ATA_SMART_READ_THRESHOLDS = 209,
	ATA_DSM_TRIM = 1,
	ATA_SMART_LBAM_PASS = 79,
	ATA_SMART_LBAH_PASS = 194,
	ATAPI_PKT_DMA = 1,
	ATAPI_DMADIR = 4,
	ATAPI_CDB_LEN = 16,
	SATA_PMP_MAX_PORTS = 15,
	SATA_PMP_CTRL_PORT = 15,
	SATA_PMP_GSCR_DWORDS = 128,
	SATA_PMP_GSCR_PROD_ID = 0,
	SATA_PMP_GSCR_REV = 1,
	SATA_PMP_GSCR_PORT_INFO = 2,
	SATA_PMP_GSCR_ERROR = 32,
	SATA_PMP_GSCR_ERROR_EN = 33,
	SATA_PMP_GSCR_FEAT = 64,
	SATA_PMP_GSCR_FEAT_EN = 96,
	SATA_PMP_PSCR_STATUS = 0,
	SATA_PMP_PSCR_ERROR = 1,
	SATA_PMP_PSCR_CONTROL = 2,
	SATA_PMP_FEAT_BIST = 1,
	SATA_PMP_FEAT_PMREQ = 2,
	SATA_PMP_FEAT_DYNSSC = 4,
	SATA_PMP_FEAT_NOTIFY = 8,
	ATA_CBL_NONE = 0,
	ATA_CBL_PATA40 = 1,
	ATA_CBL_PATA80 = 2,
	ATA_CBL_PATA40_SHORT = 3,
	ATA_CBL_PATA_UNK = 4,
	ATA_CBL_PATA_IGN = 5,
	ATA_CBL_SATA = 6,
	SCR_STATUS = 0,
	SCR_ERROR = 1,
	SCR_CONTROL = 2,
	SCR_ACTIVE = 3,
	SCR_NOTIFICATION = 4,
	SERR_DATA_RECOVERED = 1,
	SERR_COMM_RECOVERED = 2,
	SERR_DATA = 256,
	SERR_PERSISTENT = 512,
	SERR_PROTOCOL = 1024,
	SERR_INTERNAL = 2048,
	SERR_PHYRDY_CHG = 65536,
	SERR_PHY_INT_ERR = 131072,
	SERR_COMM_WAKE = 262144,
	SERR_10B_8B_ERR = 524288,
	SERR_DISPARITY = 1048576,
	SERR_CRC = 2097152,
	SERR_HANDSHAKE = 4194304,
	SERR_LINK_SEQ_ERR = 8388608,
	SERR_TRANS_ST_ERROR = 16777216,
	SERR_UNRECOG_FIS = 33554432,
	SERR_DEV_XCHG = 67108864,
};

enum {
	ATA_READID_POSTRESET = 1,
	ATA_DNXFER_PIO = 0,
	ATA_DNXFER_DMA = 1,
	ATA_DNXFER_40C = 2,
	ATA_DNXFER_FORCE_PIO = 3,
	ATA_DNXFER_FORCE_PIO0 = 4,
	ATA_DNXFER_QUIET = -2147483648,
};

enum {
	AT_PKT_END = -1,
	BEYOND_PKT_END = -2,
};

enum {
	AUTOFS_DEV_IOCTL_VERSION_CMD = 113,
	AUTOFS_DEV_IOCTL_PROTOVER_CMD = 114,
	AUTOFS_DEV_IOCTL_PROTOSUBVER_CMD = 115,
	AUTOFS_DEV_IOCTL_OPENMOUNT_CMD = 116,
	AUTOFS_DEV_IOCTL_CLOSEMOUNT_CMD = 117,
	AUTOFS_DEV_IOCTL_READY_CMD = 118,
	AUTOFS_DEV_IOCTL_FAIL_CMD = 119,
	AUTOFS_DEV_IOCTL_SETPIPEFD_CMD = 120,
	AUTOFS_DEV_IOCTL_CATATONIC_CMD = 121,
	AUTOFS_DEV_IOCTL_TIMEOUT_CMD = 122,
	AUTOFS_DEV_IOCTL_REQUESTER_CMD = 123,
	AUTOFS_DEV_IOCTL_EXPIRE_CMD = 124,
	AUTOFS_DEV_IOCTL_ASKUMOUNT_CMD = 125,
	AUTOFS_DEV_IOCTL_ISMOUNTPOINT_CMD = 126,
};

enum {
	AUTOFS_IOC_EXPIRE_MULTI_CMD = 102,
	AUTOFS_IOC_PROTOSUBVER_CMD = 103,
	AUTOFS_IOC_ASKUMOUNT_CMD = 112,
};

enum {
	AUTOFS_IOC_READY_CMD = 96,
	AUTOFS_IOC_FAIL_CMD = 97,
	AUTOFS_IOC_CATATONIC_CMD = 98,
	AUTOFS_IOC_PROTOVER_CMD = 99,
	AUTOFS_IOC_SETTIMEOUT_CMD = 100,
	AUTOFS_IOC_EXPIRE_CMD = 101,
};

enum {
	AUTOP_INVALID = 0,
	AUTOP_HDD = 1,
	AUTOP_SSD_QD1 = 2,
	AUTOP_SSD_DFL = 3,
	AUTOP_SSD_FAST = 4,
};

enum {
	AX25_VALUES_IPDEFMODE = 0,
	AX25_VALUES_AXDEFMODE = 1,
	AX25_VALUES_BACKOFF = 2,
	AX25_VALUES_CONMODE = 3,
	AX25_VALUES_WINDOW = 4,
	AX25_VALUES_EWINDOW = 5,
	AX25_VALUES_T1 = 6,
	AX25_VALUES_T2 = 7,
	AX25_VALUES_T3 = 8,
	AX25_VALUES_IDLE = 9,
	AX25_VALUES_N2 = 10,
	AX25_VALUES_PACLEN = 11,
	AX25_VALUES_PROTOCOL = 12,
	AX25_VALUES_DS_TIMEOUT = 13,
	AX25_MAX_VALUES = 14,
};

enum {
	Audit_equal = 0,
	Audit_not_equal = 1,
	Audit_bitmask = 2,
	Audit_bittest = 3,
	Audit_lt = 4,
	Audit_gt = 5,
	Audit_le = 6,
	Audit_ge = 7,
	Audit_bad = 8,
};

enum {
	BAD_STACK = -1,
	NOT_STACK = 0,
	GOOD_FRAME = 1,
	GOOD_STACK = 2,
};

enum {
	BIAS = 2147483648,
};

enum {
	BINDER_BUFFER_FLAG_HAS_PARENT = 1,
};

enum {
	BINDER_DEBUG_USER_ERROR = 1,
	BINDER_DEBUG_FAILED_TRANSACTION = 2,
	BINDER_DEBUG_DEAD_TRANSACTION = 4,
	BINDER_DEBUG_OPEN_CLOSE = 8,
	BINDER_DEBUG_DEAD_BINDER = 16,
	BINDER_DEBUG_DEATH_NOTIFICATION = 32,
	BINDER_DEBUG_READ_WRITE = 64,
	BINDER_DEBUG_USER_REFS = 128,
	BINDER_DEBUG_THREADS = 256,
	BINDER_DEBUG_TRANSACTION = 512,
	BINDER_DEBUG_TRANSACTION_COMPLETE = 1024,
	BINDER_DEBUG_FREE_BUFFER = 2048,
	BINDER_DEBUG_INTERNAL_REFS = 4096,
	BINDER_DEBUG_PRIORITY_CAP = 8192,
	BINDER_DEBUG_SPINLOCKS = 16384,
};

enum {
	BINDER_DEBUG_USER_ERROR___2 = 1,
	BINDER_DEBUG_OPEN_CLOSE___2 = 2,
	BINDER_DEBUG_BUFFER_ALLOC = 4,
	BINDER_DEBUG_BUFFER_ALLOC_ASYNC = 8,
};

enum {
	BINDER_LOOPER_STATE_REGISTERED = 1,
	BINDER_LOOPER_STATE_ENTERED = 2,
	BINDER_LOOPER_STATE_EXITED = 4,
	BINDER_LOOPER_STATE_INVALID = 8,
	BINDER_LOOPER_STATE_WAITING = 16,
	BINDER_LOOPER_STATE_POLL = 32,
};

enum {
	BINDER_TYPE_BINDER = 1935813253,
	BINDER_TYPE_WEAK_BINDER = 2002922117,
	BINDER_TYPE_HANDLE = 1936206469,
	BINDER_TYPE_WEAK_HANDLE = 2003315333,
	BINDER_TYPE_FD = 1717840517,
	BINDER_TYPE_FDA = 1717854597,
	BINDER_TYPE_PTR = 1886661253,
};

enum {
	BINDER_WRITE_READ = 3224396289,
	BINDER_SET_IDLE_TIMEOUT = 1074291203,
	BINDER_SET_MAX_THREADS = 1074029061,
	BINDER_SET_IDLE_PRIORITY = 1074029062,
	BINDER_SET_CONTEXT_MGR = 1074029063,
	BINDER_THREAD_EXIT = 1074029064,
	BINDER_VERSION = 3221512713,
	BINDER_GET_NODE_DEBUG_INFO = 3222823435,
	BINDER_GET_NODE_INFO_FOR_REF = 3222823436,
	BINDER_SET_CONTEXT_MGR_EXT = 1075339789,
	BINDER_FREEZE = 1074553358,
	BINDER_GET_FROZEN_INFO = 3222037007,
	BINDER_ENABLE_ONEWAY_SPAM_DETECTION = 1074029072,
	BINDER_GET_EXTENDED_ERROR = 3222037009,
};

enum {
	BIOSET_NEED_BVECS = 1,
	BIOSET_NEED_RESCUER = 2,
	BIOSET_PERCPU_CACHE = 4,
};

enum {
	BIO_PAGE_PINNED = 0,
	BIO_CLONED = 1,
	BIO_QUIET = 2,
	BIO_CHAIN = 3,
	BIO_REFFED = 4,
	BIO_BPS_THROTTLED = 5,
	BIO_TRACE_COMPLETION = 6,
	BIO_CGROUP_ACCT = 7,
	BIO_QOS_THROTTLED = 8,
	BIO_TG_BPS_THROTTLED = 8,
	BIO_QOS_MERGED = 9,
	BIO_REMAPPED = 10,
	BIO_ZONE_WRITE_PLUGGING = 11,
	BIO_EMULATES_ZONE_APPEND = 12,
	BIO_FLAG_LAST = 13,
};

enum {
	BLK_MQ_F_TAG_QUEUE_SHARED = 2,
	BLK_MQ_F_STACKING = 4,
	BLK_MQ_F_TAG_HCTX_SHARED = 8,
	BLK_MQ_F_BLOCKING = 16,
	BLK_MQ_F_TAG_RR = 32,
	BLK_MQ_F_NO_SCHED_BY_DEFAULT = 64,
	BLK_MQ_F_MAX = 128,
};

enum {
	BLK_MQ_NO_TAG = 4294967295,
	BLK_MQ_TAG_MIN = 1,
	BLK_MQ_TAG_MAX = 4294967294,
};

enum {
	BLK_MQ_REQ_NOWAIT = 1,
	BLK_MQ_REQ_RESERVED = 2,
	BLK_MQ_REQ_PM = 4,
};

enum {
	BLK_MQ_S_STOPPED = 0,
	BLK_MQ_S_TAG_ACTIVE = 1,
	BLK_MQ_S_SCHED_RESTART = 2,
	BLK_MQ_S_INACTIVE = 3,
	BLK_MQ_S_MAX = 4,
};

enum {
	BLK_MQ_UNIQUE_TAG_BITS = 16,
	BLK_MQ_UNIQUE_TAG_MASK = 65535,
};

enum {
	BPF_ADJ_ROOM_ENCAP_L2_MASK = 255,
	BPF_ADJ_ROOM_ENCAP_L2_SHIFT = 56,
};

enum {
	BPF_ANY = 0,
	BPF_NOEXIST = 1,
	BPF_EXIST = 2,
	BPF_F_LOCK = 4,
};

enum {
	BPF_CSUM_LEVEL_QUERY = 0,
	BPF_CSUM_LEVEL_INC = 1,
	BPF_CSUM_LEVEL_DEC = 2,
	BPF_CSUM_LEVEL_RESET = 3,
};

enum {
	BPF_FIB_LKUP_RET_SUCCESS = 0,
	BPF_FIB_LKUP_RET_BLACKHOLE = 1,
	BPF_FIB_LKUP_RET_UNREACHABLE = 2,
	BPF_FIB_LKUP_RET_PROHIBIT = 3,
	BPF_FIB_LKUP_RET_NOT_FWDED = 4,
	BPF_FIB_LKUP_RET_FWD_DISABLED = 5,
	BPF_FIB_LKUP_RET_UNSUPP_LWT = 6,
	BPF_FIB_LKUP_RET_NO_NEIGH = 7,
	BPF_FIB_LKUP_RET_FRAG_NEEDED = 8,
	BPF_FIB_LKUP_RET_NO_SRC_ADDR = 9,
};

enum {
	BPF_FIB_LOOKUP_DIRECT = 1,
	BPF_FIB_LOOKUP_OUTPUT = 2,
	BPF_FIB_LOOKUP_SKIP_NEIGH = 4,
	BPF_FIB_LOOKUP_TBID = 8,
	BPF_FIB_LOOKUP_SRC = 16,
	BPF_FIB_LOOKUP_MARK = 32,
};

enum {
	BPF_FLOW_DISSECTOR_F_PARSE_1ST_FRAG = 1,
	BPF_FLOW_DISSECTOR_F_STOP_AT_FLOW_LABEL = 2,
	BPF_FLOW_DISSECTOR_F_STOP_AT_ENCAP = 4,
};

enum {
	BPF_F_ADJ_ROOM_FIXED_GSO = 1,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV4 = 2,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV6 = 4,
	BPF_F_ADJ_ROOM_ENCAP_L4_GRE = 8,
	BPF_F_ADJ_ROOM_ENCAP_L4_UDP = 16,
	BPF_F_ADJ_ROOM_NO_CSUM_RESET = 32,
	BPF_F_ADJ_ROOM_ENCAP_L2_ETH = 64,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV4 = 128,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV6 = 256,
};

enum {
	BPF_F_BPRM_SECUREEXEC = 1,
};

enum {
	BPF_F_CURRENT_NETNS = -1,
};

enum {
	BPF_F_GET_BRANCH_RECORDS_SIZE = 1,
};

enum {
	BPF_F_HDR_FIELD_MASK = 15,
};

enum {
	BPF_F_INDEX_MASK = 4294967295ULL,
	BPF_F_CURRENT_CPU = 4294967295ULL,
	BPF_F_CTXLEN_MASK = 4503595332403200ULL,
};

enum {
	BPF_F_INGRESS = 1,
	BPF_F_BROADCAST = 8,
	BPF_F_EXCLUDE_INGRESS = 16,
};

enum {
	BPF_F_KPROBE_MULTI_RETURN = 1,
};

enum {
	BPF_F_NEIGH = 65536,
	BPF_F_PEER = 131072,
	BPF_F_NEXTHOP = 262144,
};

enum {
	BPF_F_NO_PREALLOC = 1,
	BPF_F_NO_COMMON_LRU = 2,
	BPF_F_NUMA_NODE = 4,
	BPF_F_RDONLY = 8,
	BPF_F_WRONLY = 16,
	BPF_F_STACK_BUILD_ID = 32,
	BPF_F_ZERO_SEED = 64,
	BPF_F_RDONLY_PROG = 128,
	BPF_F_WRONLY_PROG = 256,
	BPF_F_CLONE = 512,
	BPF_F_MMAPABLE = 1024,
	BPF_F_PRESERVE_ELEMS = 2048,
	BPF_F_INNER_MAP = 4096,
	BPF_F_LINK = 8192,
	BPF_F_PATH_FD = 16384,
	BPF_F_VTYPE_BTF_OBJ_FD = 32768,
	BPF_F_TOKEN_FD = 65536,
	BPF_F_SEGV_ON_FAULT = 131072,
	BPF_F_NO_USER_CONV = 262144,
};

enum {
	BPF_F_PSEUDO_HDR = 16,
	BPF_F_MARK_MANGLED_0 = 32,
	BPF_F_MARK_ENFORCE = 64,
	BPF_F_IPV6 = 128,
};

enum {
	BPF_F_RECOMPUTE_CSUM = 1,
	BPF_F_INVALIDATE_HASH = 2,
};

enum {
	BPF_F_SKIP_FIELD_MASK = 255,
	BPF_F_USER_STACK = 256,
	BPF_F_FAST_STACK_CMP = 512,
	BPF_F_REUSE_STACKID = 1024,
	BPF_F_USER_BUILD_ID = 2048,
};

enum {
	BPF_F_SYSCTL_BASE_NAME = 1,
};

enum {
	BPF_F_TIMER_ABS = 1,
	BPF_F_TIMER_CPU_PIN = 2,
};

enum {
	BPF_F_TUNINFO_FLAGS = 16,
};

enum {
	BPF_F_TUNINFO_IPV6 = 1,
};

enum {
	BPF_F_UPROBE_MULTI_RETURN = 1,
};

enum {
	BPF_F_ZERO_CSUM_TX = 2,
	BPF_F_DONT_FRAGMENT = 4,
	BPF_F_SEQ_NUMBER = 8,
	BPF_F_NO_TUNNEL_KEY = 16,
};

enum {
	BPF_LOAD_HDR_OPT_TCP_SYN = 1,
};

enum {
	BPF_LOCAL_STORAGE_GET_F_CREATE = 1,
	BPF_SK_STORAGE_GET_F_CREATE = 1,
};

enum {
	BPF_MAX_LOOPS = 8388608,
	BPF_MAX_TIMED_LOOPS = 65535,
};

enum {
	BPF_MAX_TRAMP_LINKS = 38,
};

enum {
	BPF_RB_AVAIL_DATA = 0,
	BPF_RB_RING_SIZE = 1,
	BPF_RB_CONS_POS = 2,
	BPF_RB_PROD_POS = 3,
};

enum {
	BPF_RB_NO_WAKEUP = 1,
	BPF_RB_FORCE_WAKEUP = 2,
};

enum {
	BPF_REG_0 = 0,
	BPF_REG_1 = 1,
	BPF_REG_2 = 2,
	BPF_REG_3 = 3,
	BPF_REG_4 = 4,
	BPF_REG_5 = 5,
	BPF_REG_6 = 6,
	BPF_REG_7 = 7,
	BPF_REG_8 = 8,
	BPF_REG_9 = 9,
	BPF_REG_10 = 10,
	__MAX_BPF_REG = 11,
};

enum {
	BPF_RINGBUF_BUSY_BIT = 2147483648,
	BPF_RINGBUF_DISCARD_BIT = 1073741824,
	BPF_RINGBUF_HDR_SZ = 8,
};

enum {
	BPF_SKB_TSTAMP_UNSPEC = 0,
	BPF_SKB_TSTAMP_DELIVERY_MONO = 1,
	BPF_SKB_CLOCK_REALTIME = 0,
	BPF_SKB_CLOCK_MONOTONIC = 1,
	BPF_SKB_CLOCK_TAI = 2,
};

enum {
	BPF_SK_LOOKUP_F_REPLACE = 1,
	BPF_SK_LOOKUP_F_NO_REUSEPORT = 2,
};

enum {
	BPF_SOCK_OPS_RTO_CB_FLAG = 1,
	BPF_SOCK_OPS_RETRANS_CB_FLAG = 2,
	BPF_SOCK_OPS_STATE_CB_FLAG = 4,
	BPF_SOCK_OPS_RTT_CB_FLAG = 8,
	BPF_SOCK_OPS_PARSE_ALL_HDR_OPT_CB_FLAG = 16,
	BPF_SOCK_OPS_PARSE_UNKNOWN_HDR_OPT_CB_FLAG = 32,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB_FLAG = 64,
	BPF_SOCK_OPS_ALL_CB_FLAGS = 127,
};

enum {
	BPF_SOCK_OPS_VOID = 0,
	BPF_SOCK_OPS_TIMEOUT_INIT = 1,
	BPF_SOCK_OPS_RWND_INIT = 2,
	BPF_SOCK_OPS_TCP_CONNECT_CB = 3,
	BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB = 4,
	BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB = 5,
	BPF_SOCK_OPS_NEEDS_ECN = 6,
	BPF_SOCK_OPS_BASE_RTT = 7,
	BPF_SOCK_OPS_RTO_CB = 8,
	BPF_SOCK_OPS_RETRANS_CB = 9,
	BPF_SOCK_OPS_STATE_CB = 10,
	BPF_SOCK_OPS_TCP_LISTEN_CB = 11,
	BPF_SOCK_OPS_RTT_CB = 12,
	BPF_SOCK_OPS_PARSE_HDR_OPT_CB = 13,
	BPF_SOCK_OPS_HDR_OPT_LEN_CB = 14,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB = 15,
	BPF_SOCK_OPS_TSTAMP_SCHED_CB = 16,
	BPF_SOCK_OPS_TSTAMP_SND_SW_CB = 17,
	BPF_SOCK_OPS_TSTAMP_SND_HW_CB = 18,
	BPF_SOCK_OPS_TSTAMP_ACK_CB = 19,
	BPF_SOCK_OPS_TSTAMP_SENDMSG_CB = 20,
};

enum {
	BPF_STREAM_MAX_CAPACITY = 100000,
};

enum {
	BPF_TASK_ITER_ALL_PROCS = 0,
	BPF_TASK_ITER_ALL_THREADS = 1,
	BPF_TASK_ITER_PROC_THREADS = 2,
};

enum {
	BPF_TCP_ESTABLISHED = 1,
	BPF_TCP_SYN_SENT = 2,
	BPF_TCP_SYN_RECV = 3,
	BPF_TCP_FIN_WAIT1 = 4,
	BPF_TCP_FIN_WAIT2 = 5,
	BPF_TCP_TIME_WAIT = 6,
	BPF_TCP_CLOSE = 7,
	BPF_TCP_CLOSE_WAIT = 8,
	BPF_TCP_LAST_ACK = 9,
	BPF_TCP_LISTEN = 10,
	BPF_TCP_CLOSING = 11,
	BPF_TCP_NEW_SYN_RECV = 12,
	BPF_TCP_BOUND_INACTIVE = 13,
	BPF_TCP_MAX_STATES = 14,
};

enum {
	BPF_WRITE_HDR_TCP_CURRENT_MSS = 1,
	BPF_WRITE_HDR_TCP_SYNACK_COOKIE = 2,
};

enum {
	BPF_XFRM_STATE_OPTS_SZ = 36,
};

enum {
	BR_MCAST_DIR_RX = 0,
	BR_MCAST_DIR_TX = 1,
	BR_MCAST_DIR_SIZE = 2,
};

enum {
	BTF_FIELDS_MAX = 11,
};

enum {
	BTF_FIELD_IGNORE = 0,
	BTF_FIELD_FOUND = 1,
};

enum {
	BTF_F_COMPACT = 1,
	BTF_F_NONAME = 2,
	BTF_F_PTR_RAW = 4,
	BTF_F_ZERO = 8,
};

enum {
	BTF_KFUNC_SET_MAX_CNT = 256,
	BTF_DTOR_KFUNC_MAX_CNT = 256,
	BTF_KFUNC_FILTER_MAX_CNT = 16,
};

enum {
	BTF_KIND_UNKN = 0,
	BTF_KIND_INT = 1,
	BTF_KIND_PTR = 2,
	BTF_KIND_ARRAY = 3,
	BTF_KIND_STRUCT = 4,
	BTF_KIND_UNION = 5,
	BTF_KIND_ENUM = 6,
	BTF_KIND_FWD = 7,
	BTF_KIND_TYPEDEF = 8,
	BTF_KIND_VOLATILE = 9,
	BTF_KIND_CONST = 10,
	BTF_KIND_RESTRICT = 11,
	BTF_KIND_FUNC = 12,
	BTF_KIND_FUNC_PROTO = 13,
	BTF_KIND_VAR = 14,
	BTF_KIND_DATASEC = 15,
	BTF_KIND_FLOAT = 16,
	BTF_KIND_DECL_TAG = 17,
	BTF_KIND_TYPE_TAG = 18,
	BTF_KIND_ENUM64 = 19,
	NR_BTF_KINDS = 20,
	BTF_KIND_MAX = 19,
};

enum {
	BTF_MODULE_F_LIVE = 1,
};

enum {
	BTF_SOCK_TYPE_INET = 0,
	BTF_SOCK_TYPE_INET_CONN = 1,
	BTF_SOCK_TYPE_INET_REQ = 2,
	BTF_SOCK_TYPE_INET_TW = 3,
	BTF_SOCK_TYPE_REQ = 4,
	BTF_SOCK_TYPE_SOCK = 5,
	BTF_SOCK_TYPE_SOCK_COMMON = 6,
	BTF_SOCK_TYPE_TCP = 7,
	BTF_SOCK_TYPE_TCP_REQ = 8,
	BTF_SOCK_TYPE_TCP_TW = 9,
	BTF_SOCK_TYPE_TCP6 = 10,
	BTF_SOCK_TYPE_UDP = 11,
	BTF_SOCK_TYPE_UDP6 = 12,
	BTF_SOCK_TYPE_UNIX = 13,
	BTF_SOCK_TYPE_MPTCP = 14,
	BTF_SOCK_TYPE_SOCKET = 15,
	MAX_BTF_SOCK_TYPE = 16,
};

enum {
	BTF_TRACING_TYPE_TASK = 0,
	BTF_TRACING_TYPE_FILE = 1,
	BTF_TRACING_TYPE_VMA = 2,
	MAX_BTF_TRACING_TYPE = 3,
};

enum {
	BTF_VAR_STATIC = 0,
	BTF_VAR_GLOBAL_ALLOCATED = 1,
	BTF_VAR_GLOBAL_EXTERN = 2,
};

enum {
	BTS_STATE_STOPPED = 0,
	BTS_STATE_INACTIVE = 1,
	BTS_STATE_ACTIVE = 2,
};

enum {
	Blktrace_setup = 1,
	Blktrace_running = 2,
	Blktrace_stopped = 3,
};

enum {
	C1E_PROMOTION_PRESERVE = 0,
	C1E_PROMOTION_ENABLE = 1,
	C1E_PROMOTION_DISABLE = 2,
};

enum {
	CFTYPE_ONLY_ON_ROOT = 1,
	CFTYPE_NOT_ON_ROOT = 2,
	CFTYPE_NS_DELEGATABLE = 4,
	CFTYPE_NO_PREFIX = 8,
	CFTYPE_WORLD_WRITABLE = 16,
	CFTYPE_DEBUG = 32,
	__CFTYPE_ONLY_ON_DFL = 65536,
	__CFTYPE_NOT_ON_DFL = 131072,
	__CFTYPE_ADDED = 262144,
};

enum {
	CGROUPSTATS_CMD_ATTR_UNSPEC = 0,
	CGROUPSTATS_CMD_ATTR_FD = 1,
	__CGROUPSTATS_CMD_ATTR_MAX = 2,
};

enum {
	CGROUPSTATS_CMD_UNSPEC = 3,
	CGROUPSTATS_CMD_GET = 4,
	CGROUPSTATS_CMD_NEW = 5,
	__CGROUPSTATS_CMD_MAX = 6,
};

enum {
	CGROUPSTATS_TYPE_UNSPEC = 0,
	CGROUPSTATS_TYPE_CGROUP_STATS = 1,
	__CGROUPSTATS_TYPE_MAX = 2,
};

enum {
	CGRP_NOTIFY_ON_RELEASE = 0,
	CGRP_CPUSET_CLONE_CHILDREN = 1,
	CGRP_FREEZE = 2,
	CGRP_FROZEN = 3,
};

enum {
	CGRP_ROOT_NOPREFIX = 2,
	CGRP_ROOT_XATTR = 4,
	CGRP_ROOT_NS_DELEGATE = 8,
	CGRP_ROOT_FAVOR_DYNMODS = 16,
	CGRP_ROOT_CPUSET_V2_MODE = 65536,
	CGRP_ROOT_MEMORY_LOCAL_EVENTS = 131072,
	CGRP_ROOT_MEMORY_RECURSIVE_PROT = 262144,
	CGRP_ROOT_MEMORY_HUGETLB_ACCOUNTING = 524288,
	CGRP_ROOT_PIDS_LOCAL_EVENTS = 1048576,
};

enum {
	CHIP_INVALID = 0,
	CHIP_PM8606 = 1,
	CHIP_PM8607 = 2,
	CHIP_MAX = 3,
};

enum {
	CHT_WC_PWRSRC_IRQ = 0,
	CHT_WC_THRM_IRQ = 1,
	CHT_WC_BCU_IRQ = 2,
	CHT_WC_ADC_IRQ = 3,
	CHT_WC_EXT_CHGR_IRQ = 4,
	CHT_WC_GPIO_IRQ = 5,
	CHT_WC_CRIT_IRQ = 7,
};

enum {
	CMIS_MODULE_LOW_PWR = 1,
	CMIS_MODULE_READY = 3,
};

enum {
	COREDUMP_ACK_SIZE_VER0 = 16,
};

enum {
	COREDUMP_KERNEL = 1,
	COREDUMP_USERSPACE = 2,
	COREDUMP_REJECT = 4,
	COREDUMP_WAIT = 8,
};

enum {
	COST_CTRL = 0,
	COST_MODEL = 1,
	NR_COST_CTRL_PARAMS = 2,
};

enum {
	CPER_SEV_RECOVERABLE = 0,
	CPER_SEV_FATAL = 1,
	CPER_SEV_CORRECTED = 2,
	CPER_SEV_INFORMATIONAL = 3,
};

enum {
	CRNG_EMPTY = 0,
	CRNG_EARLY = 1,
	CRNG_READY = 2,
};

enum {
	CRNG_RESEED_START_INTERVAL = 1000,
	CRNG_RESEED_INTERVAL = 60000,
};

enum {
	CRYPTOA_UNSPEC = 0,
	CRYPTOA_ALG = 1,
	CRYPTOA_TYPE = 2,
	__CRYPTOA_MAX = 3,
};

enum {
	CRYPTO_KPP_SECRET_TYPE_UNKNOWN = 0,
	CRYPTO_KPP_SECRET_TYPE_DH = 1,
	CRYPTO_KPP_SECRET_TYPE_ECDH = 2,
};

enum {
	CRYPTO_MSG_ALG_REQUEST = 0,
	CRYPTO_MSG_ALG_REGISTER = 1,
	CRYPTO_MSG_ALG_LOADED = 2,
};

enum {
	CSD_FLAG_LOCK = 1,
	IRQ_WORK_PENDING = 1,
	IRQ_WORK_BUSY = 2,
	IRQ_WORK_LAZY = 4,
	IRQ_WORK_HARD_IRQ = 8,
	IRQ_WORK_CLAIMED = 3,
	CSD_TYPE_ASYNC = 0,
	CSD_TYPE_SYNC = 16,
	CSD_TYPE_IRQ_WORK = 32,
	CSD_TYPE_TTWU = 48,
	CSD_FLAG_TYPE_MASK = 240,
};

enum {
	CSI_DEC_hl_CURSOR_KEYS = 1,
	CSI_DEC_hl_132_COLUMNS = 3,
	CSI_DEC_hl_REVERSE_VIDEO = 5,
	CSI_DEC_hl_ORIGIN_MODE = 6,
	CSI_DEC_hl_AUTOWRAP = 7,
	CSI_DEC_hl_AUTOREPEAT = 8,
	CSI_DEC_hl_MOUSE_X10 = 9,
	CSI_DEC_hl_SHOW_CURSOR = 25,
	CSI_DEC_hl_MOUSE_VT200 = 1000,
	CSI_DEC_hl_BRACKETED_PASTE = 2004,
};

enum {
	CSI_K_CURSOR_TO_LINEEND = 0,
	CSI_K_LINESTART_TO_CURSOR = 1,
	CSI_K_LINE = 2,
};

enum {
	CSI_hl_DISPLAY_CTRL = 3,
	CSI_hl_INSERT = 4,
	CSI_hl_AUTO_NL = 20,
};

enum {
	CSI_m_DEFAULT = 0,
	CSI_m_BOLD = 1,
	CSI_m_HALF_BRIGHT = 2,
	CSI_m_ITALIC = 3,
	CSI_m_UNDERLINE = 4,
	CSI_m_BLINK = 5,
	CSI_m_REVERSE = 7,
	CSI_m_PRI_FONT = 10,
	CSI_m_ALT_FONT1 = 11,
	CSI_m_ALT_FONT2 = 12,
	CSI_m_DOUBLE_UNDERLINE = 21,
	CSI_m_NORMAL_INTENSITY = 22,
	CSI_m_NO_ITALIC = 23,
	CSI_m_NO_UNDERLINE = 24,
	CSI_m_NO_BLINK = 25,
	CSI_m_NO_REVERSE = 27,
	CSI_m_FG_COLOR_BEG = 30,
	CSI_m_FG_COLOR_END = 37,
	CSI_m_FG_COLOR = 38,
	CSI_m_DEFAULT_FG_COLOR = 39,
	CSI_m_BG_COLOR_BEG = 40,
	CSI_m_BG_COLOR_END = 47,
	CSI_m_BG_COLOR = 48,
	CSI_m_DEFAULT_BG_COLOR = 49,
	CSI_m_BRIGHT_FG_COLOR_BEG = 90,
	CSI_m_BRIGHT_FG_COLOR_END = 97,
	CSI_m_BRIGHT_FG_COLOR_OFF = 60,
	CSI_m_BRIGHT_BG_COLOR_BEG = 100,
	CSI_m_BRIGHT_BG_COLOR_END = 107,
	CSI_m_BRIGHT_BG_COLOR_OFF = 60,
};

enum {
	CSS_NO_REF = 1,
	CSS_ONLINE = 2,
	CSS_RELEASED = 4,
	CSS_VISIBLE = 8,
	CSS_DYING = 16,
};

enum {
	CTRL_ATTR_MCAST_GRP_UNSPEC = 0,
	CTRL_ATTR_MCAST_GRP_NAME = 1,
	CTRL_ATTR_MCAST_GRP_ID = 2,
	__CTRL_ATTR_MCAST_GRP_MAX = 3,
};

enum {
	CTRL_ATTR_OP_UNSPEC = 0,
	CTRL_ATTR_OP_ID = 1,
	CTRL_ATTR_OP_FLAGS = 2,
	__CTRL_ATTR_OP_MAX = 3,
};

enum {
	CTRL_ATTR_POLICY_UNSPEC = 0,
	CTRL_ATTR_POLICY_DO = 1,
	CTRL_ATTR_POLICY_DUMP = 2,
	__CTRL_ATTR_POLICY_DUMP_MAX = 3,
	CTRL_ATTR_POLICY_DUMP_MAX = 2,
};

enum {
	CTRL_ATTR_UNSPEC = 0,
	CTRL_ATTR_FAMILY_ID = 1,
	CTRL_ATTR_FAMILY_NAME = 2,
	CTRL_ATTR_VERSION = 3,
	CTRL_ATTR_HDRSIZE = 4,
	CTRL_ATTR_MAXATTR = 5,
	CTRL_ATTR_OPS = 6,
	CTRL_ATTR_MCAST_GROUPS = 7,
	CTRL_ATTR_POLICY = 8,
	CTRL_ATTR_OP_POLICY = 9,
	CTRL_ATTR_OP = 10,
	__CTRL_ATTR_MAX = 11,
};

enum {
	CTRL_CMD_UNSPEC = 0,
	CTRL_CMD_NEWFAMILY = 1,
	CTRL_CMD_DELFAMILY = 2,
	CTRL_CMD_GETFAMILY = 3,
	CTRL_CMD_NEWOPS = 4,
	CTRL_CMD_DELOPS = 5,
	CTRL_CMD_GETOPS = 6,
	CTRL_CMD_NEWMCAST_GRP = 7,
	CTRL_CMD_DELMCAST_GRP = 8,
	CTRL_CMD_GETMCAST_GRP = 9,
	CTRL_CMD_GETPOLICY = 10,
	__CTRL_CMD_MAX = 11,
};

enum {
	DAD_PROCESS = 0,
	DAD_BEGIN = 1,
	DAD_ABORT = 2,
};

enum {
	DD_DIR_COUNT = 2,
};

enum {
	DD_PRIO_COUNT = 3,
};

enum {
	DELL_INSPIRON_7375 = 0,
	DELL_LATITUDE_5495 = 1,
	LENOVO_IDEAPAD_330S_15ARR = 2,
};

enum {
	DESC_TSS = 9,
	DESC_LDT = 2,
	DESCTYPE_S = 16,
};

enum {
	DEVCONF_FORWARDING = 0,
	DEVCONF_HOPLIMIT = 1,
	DEVCONF_MTU6 = 2,
	DEVCONF_ACCEPT_RA = 3,
	DEVCONF_ACCEPT_REDIRECTS = 4,
	DEVCONF_AUTOCONF = 5,
	DEVCONF_DAD_TRANSMITS = 6,
	DEVCONF_RTR_SOLICITS = 7,
	DEVCONF_RTR_SOLICIT_INTERVAL = 8,
	DEVCONF_RTR_SOLICIT_DELAY = 9,
	DEVCONF_USE_TEMPADDR = 10,
	DEVCONF_TEMP_VALID_LFT = 11,
	DEVCONF_TEMP_PREFERED_LFT = 12,
	DEVCONF_REGEN_MAX_RETRY = 13,
	DEVCONF_MAX_DESYNC_FACTOR = 14,
	DEVCONF_MAX_ADDRESSES = 15,
	DEVCONF_FORCE_MLD_VERSION = 16,
	DEVCONF_ACCEPT_RA_DEFRTR = 17,
	DEVCONF_ACCEPT_RA_PINFO = 18,
	DEVCONF_ACCEPT_RA_RTR_PREF = 19,
	DEVCONF_RTR_PROBE_INTERVAL = 20,
	DEVCONF_ACCEPT_RA_RT_INFO_MAX_PLEN = 21,
	DEVCONF_PROXY_NDP = 22,
	DEVCONF_OPTIMISTIC_DAD = 23,
	DEVCONF_ACCEPT_SOURCE_ROUTE = 24,
	DEVCONF_MC_FORWARDING = 25,
	DEVCONF_DISABLE_IPV6 = 26,
	DEVCONF_ACCEPT_DAD = 27,
	DEVCONF_FORCE_TLLAO = 28,
	DEVCONF_NDISC_NOTIFY = 29,
	DEVCONF_MLDV1_UNSOLICITED_REPORT_INTERVAL = 30,
	DEVCONF_MLDV2_UNSOLICITED_REPORT_INTERVAL = 31,
	DEVCONF_SUPPRESS_FRAG_NDISC = 32,
	DEVCONF_ACCEPT_RA_FROM_LOCAL = 33,
	DEVCONF_USE_OPTIMISTIC = 34,
	DEVCONF_ACCEPT_RA_MTU = 35,
	DEVCONF_STABLE_SECRET = 36,
	DEVCONF_USE_OIF_ADDRS_ONLY = 37,
	DEVCONF_ACCEPT_RA_MIN_HOP_LIMIT = 38,
	DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 39,
	DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 40,
	DEVCONF_DROP_UNSOLICITED_NA = 41,
	DEVCONF_KEEP_ADDR_ON_DOWN = 42,
	DEVCONF_RTR_SOLICIT_MAX_INTERVAL = 43,
	DEVCONF_SEG6_ENABLED = 44,
	DEVCONF_SEG6_REQUIRE_HMAC = 45,
	DEVCONF_ENHANCED_DAD = 46,
	DEVCONF_ADDR_GEN_MODE = 47,
	DEVCONF_DISABLE_POLICY = 48,
	DEVCONF_ACCEPT_RA_RT_INFO_MIN_PLEN = 49,
	DEVCONF_NDISC_TCLASS = 50,
	DEVCONF_RPL_SEG_ENABLED = 51,
	DEVCONF_RA_DEFRTR_METRIC = 52,
	DEVCONF_IOAM6_ENABLED = 53,
	DEVCONF_IOAM6_ID = 54,
	DEVCONF_IOAM6_ID_WIDE = 55,
	DEVCONF_NDISC_EVICT_NOCARRIER = 56,
	DEVCONF_ACCEPT_UNTRACKED_NA = 57,
	DEVCONF_ACCEPT_RA_MIN_LFT = 58,
	DEVCONF_FORCE_FORWARDING = 59,
	DEVCONF_MAX = 60,
};

enum {
	DEVLINK_ATTR_STATS_RX_PACKETS = 0,
	DEVLINK_ATTR_STATS_RX_BYTES = 1,
	DEVLINK_ATTR_STATS_RX_DROPPED = 2,
	__DEVLINK_ATTR_STATS_MAX = 3,
	DEVLINK_ATTR_STATS_MAX = 2,
};

enum {
	DEVLINK_ATTR_TRAP_METADATA_TYPE_IN_PORT = 0,
	DEVLINK_ATTR_TRAP_METADATA_TYPE_FA_COOKIE = 1,
};

enum {
	DIO_LOCKING = 1,
	DIO_SKIP_HOLES = 2,
};

enum {
	DIO_SHOULD_DIRTY = 1,
	DIO_IS_SYNC = 2,
};

enum {
	DIR_OFFSET_FIRST = 2,
	DIR_OFFSET_EOD = 2147483647,
};

enum {
	DIR_OFFSET_MIN = 3,
	DIR_OFFSET_MAX = 2147483646,
};

enum {
	DISCOVERED = 16,
	EXPLORED = 32,
	FALLTHROUGH = 1,
	BRANCH = 2,
};

enum {
	DISK_EVENT_FLAG_POLL = 1,
	DISK_EVENT_FLAG_UEVENT = 2,
	DISK_EVENT_FLAG_BLOCK_ON_EXCL_WRITE = 4,
};

enum {
	DISK_EVENT_MEDIA_CHANGE = 1,
	DISK_EVENT_EJECT_REQUEST = 2,
};

enum {
	DMA_TYPE_TX = 0,
	DMA_TYPE_RX = 1,
	DMA_TYPE_MCPY = 2,
};

enum {
	DONE_EXPLORING = 0,
	KEEP_EXPLORING = 1,
};

enum {
	DPLL_NLGRP_MONITOR = 0,
};

enum {
	DQF_INFO_DIRTY_B = 17,
};

enum {
	DQF_ROOT_SQUASH_B = 0,
	DQF_SYS_FILE_B = 16,
	DQF_PRIVATE = 17,
};

enum {
	DQST_LOOKUPS = 0,
	DQST_DROPS = 1,
	DQST_READS = 2,
	DQST_WRITES = 3,
	DQST_CACHE_HITS = 4,
	DQST_ALLOC_DQUOTS = 5,
	DQST_FREE_DQUOTS = 6,
	DQST_SYNCS = 7,
	_DQST_DQSTAT_LAST = 8,
};

enum {
	DUMP_PREFIX_NONE = 0,
	DUMP_PREFIX_ADDRESS = 1,
	DUMP_PREFIX_OFFSET = 2,
};

enum {
	EC_FLAGS_QUERY_ENABLED = 0,
	EC_FLAGS_EVENT_HANDLER_INSTALLED = 1,
	EC_FLAGS_EC_HANDLER_INSTALLED = 2,
	EC_FLAGS_EC_REG_CALLED = 3,
	EC_FLAGS_QUERY_METHODS_INSTALLED = 4,
	EC_FLAGS_STARTED = 5,
	EC_FLAGS_STOPPED = 6,
	EC_FLAGS_EVENTS_MASKED = 7,
};

enum {
	EI_ETYPE_NULL = 0,
	EI_ETYPE_ERRNO = 1,
	EI_ETYPE_ERRNO_NULL = 2,
	EI_ETYPE_TRUE = 3,
};

enum {
	EMULATE = 0,
	XONLY = 1,
	NONE = 2,
};

enum {
	EPecma = 0,
	EPdec = 1,
	EPeq = 2,
	EPgt = 3,
	EPlt = 4,
};

enum {
	ERASE = 0,
	WERASE = 1,
	KILL = 2,
};

enum {
	ETHTOOL_A_BITSET_BITS_UNSPEC = 0,
	ETHTOOL_A_BITSET_BITS_BIT = 1,
	__ETHTOOL_A_BITSET_BITS_CNT = 2,
	ETHTOOL_A_BITSET_BITS_MAX = 1,
};

enum {
	ETHTOOL_A_BITSET_BIT_UNSPEC = 0,
	ETHTOOL_A_BITSET_BIT_INDEX = 1,
	ETHTOOL_A_BITSET_BIT_NAME = 2,
	ETHTOOL_A_BITSET_BIT_VALUE = 3,
	__ETHTOOL_A_BITSET_BIT_CNT = 4,
	ETHTOOL_A_BITSET_BIT_MAX = 3,
};

enum {
	ETHTOOL_A_BITSET_UNSPEC = 0,
	ETHTOOL_A_BITSET_NOMASK = 1,
	ETHTOOL_A_BITSET_SIZE = 2,
	ETHTOOL_A_BITSET_BITS = 3,
	ETHTOOL_A_BITSET_VALUE = 4,
	ETHTOOL_A_BITSET_MASK = 5,
	__ETHTOOL_A_BITSET_CNT = 6,
	ETHTOOL_A_BITSET_MAX = 5,
};

enum {
	ETHTOOL_A_C33_PSE_PW_LIMIT_UNSPEC = 0,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MIN = 1,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
	__ETHTOOL_A_C33_PSE_PW_LIMIT_CNT = 3,
	__ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_AMPLITUDE_UNSPEC = 0,
	ETHTOOL_A_CABLE_AMPLITUDE_PAIR = 1,
	ETHTOOL_A_CABLE_AMPLITUDE_mV = 2,
	__ETHTOOL_A_CABLE_AMPLITUDE_CNT = 3,
	ETHTOOL_A_CABLE_AMPLITUDE_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_FAULT_LENGTH_UNSPEC = 0,
	ETHTOOL_A_CABLE_FAULT_LENGTH_PAIR = 1,
	ETHTOOL_A_CABLE_FAULT_LENGTH_CM = 2,
	ETHTOOL_A_CABLE_FAULT_LENGTH_SRC = 3,
	__ETHTOOL_A_CABLE_FAULT_LENGTH_CNT = 4,
	ETHTOOL_A_CABLE_FAULT_LENGTH_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_INF_SRC_UNSPEC = 0,
	ETHTOOL_A_CABLE_INF_SRC_TDR = 1,
	ETHTOOL_A_CABLE_INF_SRC_ALCD = 2,
};

enum {
	ETHTOOL_A_CABLE_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_NEST_RESULT = 1,
	ETHTOOL_A_CABLE_NEST_FAULT_LENGTH = 2,
	__ETHTOOL_A_CABLE_NEST_CNT = 3,
	ETHTOOL_A_CABLE_NEST_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_PAIR_A = 0,
	ETHTOOL_A_CABLE_PAIR_B = 1,
	ETHTOOL_A_CABLE_PAIR_C = 2,
	ETHTOOL_A_CABLE_PAIR_D = 3,
};

enum {
	ETHTOOL_A_CABLE_PULSE_UNSPEC = 0,
	ETHTOOL_A_CABLE_PULSE_mV = 1,
	__ETHTOOL_A_CABLE_PULSE_CNT = 2,
	ETHTOOL_A_CABLE_PULSE_MAX = 1,
};

enum {
	ETHTOOL_A_CABLE_RESULT_UNSPEC = 0,
	ETHTOOL_A_CABLE_RESULT_PAIR = 1,
	ETHTOOL_A_CABLE_RESULT_CODE = 2,
	ETHTOOL_A_CABLE_RESULT_SRC = 3,
	__ETHTOOL_A_CABLE_RESULT_CNT = 4,
	ETHTOOL_A_CABLE_RESULT_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_STEP_UNSPEC = 0,
	ETHTOOL_A_CABLE_STEP_FIRST_DISTANCE = 1,
	ETHTOOL_A_CABLE_STEP_LAST_DISTANCE = 2,
	ETHTOOL_A_CABLE_STEP_STEP_DISTANCE = 3,
	__ETHTOOL_A_CABLE_STEP_CNT = 4,
	ETHTOOL_A_CABLE_STEP_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TDR_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TDR_NEST_STEP = 1,
	ETHTOOL_A_CABLE_TDR_NEST_AMPLITUDE = 2,
	ETHTOOL_A_CABLE_TDR_NEST_PULSE = 3,
	__ETHTOOL_A_CABLE_TDR_NEST_CNT = 4,
	ETHTOOL_A_CABLE_TDR_NEST_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_STARTED = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_COMPLETED = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS = 2,
	ETHTOOL_A_CABLE_TEST_NTF_NEST = 3,
	__ETHTOOL_A_CABLE_TEST_NTF_CNT = 4,
	ETHTOOL_A_CABLE_TEST_NTF_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_CFG_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_FIRST = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_LAST = 2,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_STEP = 3,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_PAIR = 4,
	__ETHTOOL_A_CABLE_TEST_TDR_CFG_CNT = 5,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_MAX = 4,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG = 2,
	__ETHTOOL_A_CABLE_TEST_TDR_CNT = 3,
	ETHTOOL_A_CABLE_TEST_TDR_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_HEADER = 1,
	__ETHTOOL_A_CABLE_TEST_CNT = 2,
	ETHTOOL_A_CABLE_TEST_MAX = 1,
};

enum {
	ETHTOOL_A_CHANNELS_UNSPEC = 0,
	ETHTOOL_A_CHANNELS_HEADER = 1,
	ETHTOOL_A_CHANNELS_RX_MAX = 2,
	ETHTOOL_A_CHANNELS_TX_MAX = 3,
	ETHTOOL_A_CHANNELS_OTHER_MAX = 4,
	ETHTOOL_A_CHANNELS_COMBINED_MAX = 5,
	ETHTOOL_A_CHANNELS_RX_COUNT = 6,
	ETHTOOL_A_CHANNELS_TX_COUNT = 7,
	ETHTOOL_A_CHANNELS_OTHER_COUNT = 8,
	ETHTOOL_A_CHANNELS_COMBINED_COUNT = 9,
	__ETHTOOL_A_CHANNELS_CNT = 10,
	ETHTOOL_A_CHANNELS_MAX = 9,
};

enum {
	ETHTOOL_A_COALESCE_UNSPEC = 0,
	ETHTOOL_A_COALESCE_HEADER = 1,
	ETHTOOL_A_COALESCE_RX_USECS = 2,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES = 3,
	ETHTOOL_A_COALESCE_RX_USECS_IRQ = 4,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_IRQ = 5,
	ETHTOOL_A_COALESCE_TX_USECS = 6,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES = 7,
	ETHTOOL_A_COALESCE_TX_USECS_IRQ = 8,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_IRQ = 9,
	ETHTOOL_A_COALESCE_STATS_BLOCK_USECS = 10,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_RX = 11,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_TX = 12,
	ETHTOOL_A_COALESCE_PKT_RATE_LOW = 13,
	ETHTOOL_A_COALESCE_RX_USECS_LOW = 14,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_LOW = 15,
	ETHTOOL_A_COALESCE_TX_USECS_LOW = 16,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_LOW = 17,
	ETHTOOL_A_COALESCE_PKT_RATE_HIGH = 18,
	ETHTOOL_A_COALESCE_RX_USECS_HIGH = 19,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_HIGH = 20,
	ETHTOOL_A_COALESCE_TX_USECS_HIGH = 21,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_HIGH = 22,
	ETHTOOL_A_COALESCE_RATE_SAMPLE_INTERVAL = 23,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_TX = 24,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_RX = 25,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_BYTES = 26,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_FRAMES = 27,
	ETHTOOL_A_COALESCE_TX_AGGR_TIME_USECS = 28,
	ETHTOOL_A_COALESCE_RX_PROFILE = 29,
	ETHTOOL_A_COALESCE_TX_PROFILE = 30,
	__ETHTOOL_A_COALESCE_CNT = 31,
	ETHTOOL_A_COALESCE_MAX = 30,
};

enum {
	ETHTOOL_A_DEBUG_UNSPEC = 0,
	ETHTOOL_A_DEBUG_HEADER = 1,
	ETHTOOL_A_DEBUG_MSGMASK = 2,
	__ETHTOOL_A_DEBUG_CNT = 3,
	ETHTOOL_A_DEBUG_MAX = 2,
};

enum {
	ETHTOOL_A_EEE_UNSPEC = 0,
	ETHTOOL_A_EEE_HEADER = 1,
	ETHTOOL_A_EEE_MODES_OURS = 2,
	ETHTOOL_A_EEE_MODES_PEER = 3,
	ETHTOOL_A_EEE_ACTIVE = 4,
	ETHTOOL_A_EEE_ENABLED = 5,
	ETHTOOL_A_EEE_TX_LPI_ENABLED = 6,
	ETHTOOL_A_EEE_TX_LPI_TIMER = 7,
	__ETHTOOL_A_EEE_CNT = 8,
	ETHTOOL_A_EEE_MAX = 7,
};

enum {
	ETHTOOL_A_FEATURES_UNSPEC = 0,
	ETHTOOL_A_FEATURES_HEADER = 1,
	ETHTOOL_A_FEATURES_HW = 2,
	ETHTOOL_A_FEATURES_WANTED = 3,
	ETHTOOL_A_FEATURES_ACTIVE = 4,
	ETHTOOL_A_FEATURES_NOCHANGE = 5,
	__ETHTOOL_A_FEATURES_CNT = 6,
	ETHTOOL_A_FEATURES_MAX = 5,
};

enum {
	ETHTOOL_A_FEC_STAT_UNSPEC = 0,
	ETHTOOL_A_FEC_STAT_PAD = 1,
	ETHTOOL_A_FEC_STAT_CORRECTED = 2,
	ETHTOOL_A_FEC_STAT_UNCORR = 3,
	ETHTOOL_A_FEC_STAT_CORR_BITS = 4,
	__ETHTOOL_A_FEC_STAT_CNT = 5,
	ETHTOOL_A_FEC_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_FEC_UNSPEC = 0,
	ETHTOOL_A_FEC_HEADER = 1,
	ETHTOOL_A_FEC_MODES = 2,
	ETHTOOL_A_FEC_AUTO = 3,
	ETHTOOL_A_FEC_ACTIVE = 4,
	ETHTOOL_A_FEC_STATS = 5,
	__ETHTOOL_A_FEC_CNT = 6,
	ETHTOOL_A_FEC_MAX = 5,
};

enum {
	ETHTOOL_A_FLOW_ETHER = 1,
	ETHTOOL_A_FLOW_IP4 = 2,
	ETHTOOL_A_FLOW_IP6 = 3,
	ETHTOOL_A_FLOW_TCP4 = 4,
	ETHTOOL_A_FLOW_TCP6 = 5,
	ETHTOOL_A_FLOW_UDP4 = 6,
	ETHTOOL_A_FLOW_UDP6 = 7,
	ETHTOOL_A_FLOW_SCTP4 = 8,
	ETHTOOL_A_FLOW_SCTP6 = 9,
	ETHTOOL_A_FLOW_AH4 = 10,
	ETHTOOL_A_FLOW_AH6 = 11,
	ETHTOOL_A_FLOW_ESP4 = 12,
	ETHTOOL_A_FLOW_ESP6 = 13,
	ETHTOOL_A_FLOW_AH_ESP4 = 14,
	ETHTOOL_A_FLOW_AH_ESP6 = 15,
	ETHTOOL_A_FLOW_GTPU4 = 16,
	ETHTOOL_A_FLOW_GTPU6 = 17,
	ETHTOOL_A_FLOW_GTPC4 = 18,
	ETHTOOL_A_FLOW_GTPC6 = 19,
	ETHTOOL_A_FLOW_GTPC_TEID4 = 20,
	ETHTOOL_A_FLOW_GTPC_TEID6 = 21,
	ETHTOOL_A_FLOW_GTPU_EH4 = 22,
	ETHTOOL_A_FLOW_GTPU_EH6 = 23,
	ETHTOOL_A_FLOW_GTPU_UL4 = 24,
	ETHTOOL_A_FLOW_GTPU_UL6 = 25,
	ETHTOOL_A_FLOW_GTPU_DL4 = 26,
	ETHTOOL_A_FLOW_GTPU_DL6 = 27,
	__ETHTOOL_A_FLOW_CNT = 28,
	ETHTOOL_A_FLOW_MAX = 27,
};

enum {
	ETHTOOL_A_HEADER_UNSPEC = 0,
	ETHTOOL_A_HEADER_DEV_INDEX = 1,
	ETHTOOL_A_HEADER_DEV_NAME = 2,
	ETHTOOL_A_HEADER_FLAGS = 3,
	ETHTOOL_A_HEADER_PHY_INDEX = 4,
	__ETHTOOL_A_HEADER_CNT = 5,
	ETHTOOL_A_HEADER_MAX = 4,
};

enum {
	ETHTOOL_A_IRQ_MODERATION_UNSPEC = 0,
	ETHTOOL_A_IRQ_MODERATION_USEC = 1,
	ETHTOOL_A_IRQ_MODERATION_PKTS = 2,
	ETHTOOL_A_IRQ_MODERATION_COMPS = 3,
	__ETHTOOL_A_IRQ_MODERATION_CNT = 4,
	ETHTOOL_A_IRQ_MODERATION_MAX = 3,
};

enum {
	ETHTOOL_A_LINKINFO_UNSPEC = 0,
	ETHTOOL_A_LINKINFO_HEADER = 1,
	ETHTOOL_A_LINKINFO_PORT = 2,
	ETHTOOL_A_LINKINFO_PHYADDR = 3,
	ETHTOOL_A_LINKINFO_TP_MDIX = 4,
	ETHTOOL_A_LINKINFO_TP_MDIX_CTRL = 5,
	ETHTOOL_A_LINKINFO_TRANSCEIVER = 6,
	__ETHTOOL_A_LINKINFO_CNT = 7,
	ETHTOOL_A_LINKINFO_MAX = 6,
};

enum {
	ETHTOOL_A_LINKMODES_UNSPEC = 0,
	ETHTOOL_A_LINKMODES_HEADER = 1,
	ETHTOOL_A_LINKMODES_AUTONEG = 2,
	ETHTOOL_A_LINKMODES_OURS = 3,
	ETHTOOL_A_LINKMODES_PEER = 4,
	ETHTOOL_A_LINKMODES_SPEED = 5,
	ETHTOOL_A_LINKMODES_DUPLEX = 6,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_CFG = 7,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_STATE = 8,
	ETHTOOL_A_LINKMODES_LANES = 9,
	ETHTOOL_A_LINKMODES_RATE_MATCHING = 10,
	__ETHTOOL_A_LINKMODES_CNT = 11,
	ETHTOOL_A_LINKMODES_MAX = 10,
};

enum {
	ETHTOOL_A_LINKSTATE_UNSPEC = 0,
	ETHTOOL_A_LINKSTATE_HEADER = 1,
	ETHTOOL_A_LINKSTATE_LINK = 2,
	ETHTOOL_A_LINKSTATE_SQI = 3,
	ETHTOOL_A_LINKSTATE_SQI_MAX = 4,
	ETHTOOL_A_LINKSTATE_EXT_STATE = 5,
	ETHTOOL_A_LINKSTATE_EXT_SUBSTATE = 6,
	ETHTOOL_A_LINKSTATE_EXT_DOWN_CNT = 7,
	__ETHTOOL_A_LINKSTATE_CNT = 8,
	ETHTOOL_A_LINKSTATE_MAX = 7,
};

enum {
	ETHTOOL_A_MM_STAT_UNSPEC = 0,
	ETHTOOL_A_MM_STAT_PAD = 1,
	ETHTOOL_A_MM_STAT_REASSEMBLY_ERRORS = 2,
	ETHTOOL_A_MM_STAT_SMD_ERRORS = 3,
	ETHTOOL_A_MM_STAT_REASSEMBLY_OK = 4,
	ETHTOOL_A_MM_STAT_RX_FRAG_COUNT = 5,
	ETHTOOL_A_MM_STAT_TX_FRAG_COUNT = 6,
	ETHTOOL_A_MM_STAT_HOLD_COUNT = 7,
	__ETHTOOL_A_MM_STAT_CNT = 8,
	ETHTOOL_A_MM_STAT_MAX = 7,
};

enum {
	ETHTOOL_A_MM_UNSPEC = 0,
	ETHTOOL_A_MM_HEADER = 1,
	ETHTOOL_A_MM_PMAC_ENABLED = 2,
	ETHTOOL_A_MM_TX_ENABLED = 3,
	ETHTOOL_A_MM_TX_ACTIVE = 4,
	ETHTOOL_A_MM_TX_MIN_FRAG_SIZE = 5,
	ETHTOOL_A_MM_RX_MIN_FRAG_SIZE = 6,
	ETHTOOL_A_MM_VERIFY_ENABLED = 7,
	ETHTOOL_A_MM_VERIFY_STATUS = 8,
	ETHTOOL_A_MM_VERIFY_TIME = 9,
	ETHTOOL_A_MM_MAX_VERIFY_TIME = 10,
	ETHTOOL_A_MM_STATS = 11,
	__ETHTOOL_A_MM_CNT = 12,
	ETHTOOL_A_MM_MAX = 11,
};

enum {
	ETHTOOL_A_MODULE_EEPROM_UNSPEC = 0,
	ETHTOOL_A_MODULE_EEPROM_HEADER = 1,
	ETHTOOL_A_MODULE_EEPROM_OFFSET = 2,
	ETHTOOL_A_MODULE_EEPROM_LENGTH = 3,
	ETHTOOL_A_MODULE_EEPROM_PAGE = 4,
	ETHTOOL_A_MODULE_EEPROM_BANK = 5,
	ETHTOOL_A_MODULE_EEPROM_I2C_ADDRESS = 6,
	ETHTOOL_A_MODULE_EEPROM_DATA = 7,
	__ETHTOOL_A_MODULE_EEPROM_CNT = 8,
	ETHTOOL_A_MODULE_EEPROM_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_FW_FLASH_UNSPEC = 0,
	ETHTOOL_A_MODULE_FW_FLASH_HEADER = 1,
	ETHTOOL_A_MODULE_FW_FLASH_FILE_NAME = 2,
	ETHTOOL_A_MODULE_FW_FLASH_PASSWORD = 3,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS = 4,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS_MSG = 5,
	ETHTOOL_A_MODULE_FW_FLASH_DONE = 6,
	ETHTOOL_A_MODULE_FW_FLASH_TOTAL = 7,
	__ETHTOOL_A_MODULE_FW_FLASH_CNT = 8,
	ETHTOOL_A_MODULE_FW_FLASH_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_UNSPEC = 0,
	ETHTOOL_A_MODULE_HEADER = 1,
	ETHTOOL_A_MODULE_POWER_MODE_POLICY = 2,
	ETHTOOL_A_MODULE_POWER_MODE = 3,
	__ETHTOOL_A_MODULE_CNT = 4,
	ETHTOOL_A_MODULE_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_STAT_UNSPEC = 0,
	ETHTOOL_A_PAUSE_STAT_PAD = 1,
	ETHTOOL_A_PAUSE_STAT_TX_FRAMES = 2,
	ETHTOOL_A_PAUSE_STAT_RX_FRAMES = 3,
	__ETHTOOL_A_PAUSE_STAT_CNT = 4,
	ETHTOOL_A_PAUSE_STAT_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_UNSPEC = 0,
	ETHTOOL_A_PAUSE_HEADER = 1,
	ETHTOOL_A_PAUSE_AUTONEG = 2,
	ETHTOOL_A_PAUSE_RX = 3,
	ETHTOOL_A_PAUSE_TX = 4,
	ETHTOOL_A_PAUSE_STATS = 5,
	ETHTOOL_A_PAUSE_STATS_SRC = 6,
	__ETHTOOL_A_PAUSE_CNT = 7,
	ETHTOOL_A_PAUSE_MAX = 6,
};

enum {
	ETHTOOL_A_PHC_VCLOCKS_UNSPEC = 0,
	ETHTOOL_A_PHC_VCLOCKS_HEADER = 1,
	ETHTOOL_A_PHC_VCLOCKS_NUM = 2,
	ETHTOOL_A_PHC_VCLOCKS_INDEX = 3,
	__ETHTOOL_A_PHC_VCLOCKS_CNT = 4,
	ETHTOOL_A_PHC_VCLOCKS_MAX = 3,
};

enum {
	ETHTOOL_A_PHY_UNSPEC = 0,
	ETHTOOL_A_PHY_HEADER = 1,
	ETHTOOL_A_PHY_INDEX = 2,
	ETHTOOL_A_PHY_DRVNAME = 3,
	ETHTOOL_A_PHY_NAME = 4,
	ETHTOOL_A_PHY_UPSTREAM_TYPE = 5,
	ETHTOOL_A_PHY_UPSTREAM_INDEX = 6,
	ETHTOOL_A_PHY_UPSTREAM_SFP_NAME = 7,
	ETHTOOL_A_PHY_DOWNSTREAM_SFP_NAME = 8,
	__ETHTOOL_A_PHY_CNT = 9,
	ETHTOOL_A_PHY_MAX = 8,
};

enum {
	ETHTOOL_A_PLCA_UNSPEC = 0,
	ETHTOOL_A_PLCA_HEADER = 1,
	ETHTOOL_A_PLCA_VERSION = 2,
	ETHTOOL_A_PLCA_ENABLED = 3,
	ETHTOOL_A_PLCA_STATUS = 4,
	ETHTOOL_A_PLCA_NODE_CNT = 5,
	ETHTOOL_A_PLCA_NODE_ID = 6,
	ETHTOOL_A_PLCA_TO_TMR = 7,
	ETHTOOL_A_PLCA_BURST_CNT = 8,
	ETHTOOL_A_PLCA_BURST_TMR = 9,
	__ETHTOOL_A_PLCA_CNT = 10,
	ETHTOOL_A_PLCA_MAX = 9,
};

enum {
	ETHTOOL_A_PRIVFLAGS_UNSPEC = 0,
	ETHTOOL_A_PRIVFLAGS_HEADER = 1,
	ETHTOOL_A_PRIVFLAGS_FLAGS = 2,
	__ETHTOOL_A_PRIVFLAGS_CNT = 3,
	ETHTOOL_A_PRIVFLAGS_MAX = 2,
};

enum {
	ETHTOOL_A_PROFILE_UNSPEC = 0,
	ETHTOOL_A_PROFILE_IRQ_MODERATION = 1,
	__ETHTOOL_A_PROFILE_CNT = 2,
	ETHTOOL_A_PROFILE_MAX = 1,
};

enum {
	ETHTOOL_A_PSE_NTF_HEADER = 1,
	ETHTOOL_A_PSE_NTF_EVENTS = 2,
	__ETHTOOL_A_PSE_NTF_CNT = 3,
	ETHTOOL_A_PSE_NTF_MAX = 2,
};

enum {
	ETHTOOL_A_PSE_UNSPEC = 0,
	ETHTOOL_A_PSE_HEADER = 1,
	ETHTOOL_A_PODL_PSE_ADMIN_STATE = 2,
	ETHTOOL_A_PODL_PSE_ADMIN_CONTROL = 3,
	ETHTOOL_A_PODL_PSE_PW_D_STATUS = 4,
	ETHTOOL_A_C33_PSE_ADMIN_STATE = 5,
	ETHTOOL_A_C33_PSE_ADMIN_CONTROL = 6,
	ETHTOOL_A_C33_PSE_PW_D_STATUS = 7,
	ETHTOOL_A_C33_PSE_PW_CLASS = 8,
	ETHTOOL_A_C33_PSE_ACTUAL_PW = 9,
	ETHTOOL_A_C33_PSE_EXT_STATE = 10,
	ETHTOOL_A_C33_PSE_EXT_SUBSTATE = 11,
	ETHTOOL_A_C33_PSE_AVAIL_PW_LIMIT = 12,
	ETHTOOL_A_C33_PSE_PW_LIMIT_RANGES = 13,
	ETHTOOL_A_PSE_PW_D_ID = 14,
	ETHTOOL_A_PSE_PRIO_MAX = 15,
	ETHTOOL_A_PSE_PRIO = 16,
	__ETHTOOL_A_PSE_CNT = 17,
	ETHTOOL_A_PSE_MAX = 16,
};

enum {
	ETHTOOL_A_RINGS_UNSPEC = 0,
	ETHTOOL_A_RINGS_HEADER = 1,
	ETHTOOL_A_RINGS_RX_MAX = 2,
	ETHTOOL_A_RINGS_RX_MINI_MAX = 3,
	ETHTOOL_A_RINGS_RX_JUMBO_MAX = 4,
	ETHTOOL_A_RINGS_TX_MAX = 5,
	ETHTOOL_A_RINGS_RX = 6,
	ETHTOOL_A_RINGS_RX_MINI = 7,
	ETHTOOL_A_RINGS_RX_JUMBO = 8,
	ETHTOOL_A_RINGS_TX = 9,
	ETHTOOL_A_RINGS_RX_BUF_LEN = 10,
	ETHTOOL_A_RINGS_TCP_DATA_SPLIT = 11,
	ETHTOOL_A_RINGS_CQE_SIZE = 12,
	ETHTOOL_A_RINGS_TX_PUSH = 13,
	ETHTOOL_A_RINGS_RX_PUSH = 14,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN = 15,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN_MAX = 16,
	ETHTOOL_A_RINGS_HDS_THRESH = 17,
	ETHTOOL_A_RINGS_HDS_THRESH_MAX = 18,
	__ETHTOOL_A_RINGS_CNT = 19,
	ETHTOOL_A_RINGS_MAX = 18,
};

enum {
	ETHTOOL_A_RSS_UNSPEC = 0,
	ETHTOOL_A_RSS_HEADER = 1,
	ETHTOOL_A_RSS_CONTEXT = 2,
	ETHTOOL_A_RSS_HFUNC = 3,
	ETHTOOL_A_RSS_INDIR = 4,
	ETHTOOL_A_RSS_HKEY = 5,
	ETHTOOL_A_RSS_INPUT_XFRM = 6,
	ETHTOOL_A_RSS_START_CONTEXT = 7,
	ETHTOOL_A_RSS_FLOW_HASH = 8,
	__ETHTOOL_A_RSS_CNT = 9,
	ETHTOOL_A_RSS_MAX = 8,
};

enum {
	ETHTOOL_A_STATS_ETH_CTRL_3_TX = 0,
	ETHTOOL_A_STATS_ETH_CTRL_4_RX = 1,
	ETHTOOL_A_STATS_ETH_CTRL_5_RX_UNSUP = 2,
	__ETHTOOL_A_STATS_ETH_CTRL_CNT = 3,
	ETHTOOL_A_STATS_ETH_CTRL_MAX = 2,
};

enum {
	ETHTOOL_A_STATS_ETH_MAC_2_TX_PKT = 0,
	ETHTOOL_A_STATS_ETH_MAC_3_SINGLE_COL = 1,
	ETHTOOL_A_STATS_ETH_MAC_4_MULTI_COL = 2,
	ETHTOOL_A_STATS_ETH_MAC_5_RX_PKT = 3,
	ETHTOOL_A_STATS_ETH_MAC_6_FCS_ERR = 4,
	ETHTOOL_A_STATS_ETH_MAC_7_ALIGN_ERR = 5,
	ETHTOOL_A_STATS_ETH_MAC_8_TX_BYTES = 6,
	ETHTOOL_A_STATS_ETH_MAC_9_TX_DEFER = 7,
	ETHTOOL_A_STATS_ETH_MAC_10_LATE_COL = 8,
	ETHTOOL_A_STATS_ETH_MAC_11_XS_COL = 9,
	ETHTOOL_A_STATS_ETH_MAC_12_TX_INT_ERR = 10,
	ETHTOOL_A_STATS_ETH_MAC_13_CS_ERR = 11,
	ETHTOOL_A_STATS_ETH_MAC_14_RX_BYTES = 12,
	ETHTOOL_A_STATS_ETH_MAC_15_RX_INT_ERR = 13,
	ETHTOOL_A_STATS_ETH_MAC_18_TX_MCAST = 14,
	ETHTOOL_A_STATS_ETH_MAC_19_TX_BCAST = 15,
	ETHTOOL_A_STATS_ETH_MAC_20_XS_DEFER = 16,
	ETHTOOL_A_STATS_ETH_MAC_21_RX_MCAST = 17,
	ETHTOOL_A_STATS_ETH_MAC_22_RX_BCAST = 18,
	ETHTOOL_A_STATS_ETH_MAC_23_IR_LEN_ERR = 19,
	ETHTOOL_A_STATS_ETH_MAC_24_OOR_LEN = 20,
	ETHTOOL_A_STATS_ETH_MAC_25_TOO_LONG_ERR = 21,
	__ETHTOOL_A_STATS_ETH_MAC_CNT = 22,
	ETHTOOL_A_STATS_ETH_MAC_MAX = 21,
};

enum {
	ETHTOOL_A_STATS_ETH_PHY_5_SYM_ERR = 0,
	__ETHTOOL_A_STATS_ETH_PHY_CNT = 1,
	ETHTOOL_A_STATS_ETH_PHY_MAX = 0,
};

enum {
	ETHTOOL_A_STATS_GRP_UNSPEC = 0,
	ETHTOOL_A_STATS_GRP_PAD = 1,
	ETHTOOL_A_STATS_GRP_ID = 2,
	ETHTOOL_A_STATS_GRP_SS_ID = 3,
	ETHTOOL_A_STATS_GRP_STAT = 4,
	ETHTOOL_A_STATS_GRP_HIST_RX = 5,
	ETHTOOL_A_STATS_GRP_HIST_TX = 6,
	ETHTOOL_A_STATS_GRP_HIST_BKT_LOW = 7,
	ETHTOOL_A_STATS_GRP_HIST_BKT_HI = 8,
	ETHTOOL_A_STATS_GRP_HIST_VAL = 9,
	__ETHTOOL_A_STATS_GRP_CNT = 10,
	ETHTOOL_A_STATS_GRP_MAX = 9,
};

enum {
	ETHTOOL_A_STATS_PHY_RX_PKTS = 0,
	ETHTOOL_A_STATS_PHY_RX_BYTES = 1,
	ETHTOOL_A_STATS_PHY_RX_ERRORS = 2,
	ETHTOOL_A_STATS_PHY_TX_PKTS = 3,
	ETHTOOL_A_STATS_PHY_TX_BYTES = 4,
	ETHTOOL_A_STATS_PHY_TX_ERRORS = 5,
	__ETHTOOL_A_STATS_PHY_CNT = 6,
	ETHTOOL_A_STATS_PHY_MAX = 5,
};

enum {
	ETHTOOL_A_STATS_RMON_UNDERSIZE = 0,
	ETHTOOL_A_STATS_RMON_OVERSIZE = 1,
	ETHTOOL_A_STATS_RMON_FRAG = 2,
	ETHTOOL_A_STATS_RMON_JABBER = 3,
	__ETHTOOL_A_STATS_RMON_CNT = 4,
	ETHTOOL_A_STATS_RMON_MAX = 3,
};

enum {
	ETHTOOL_A_STATS_UNSPEC = 0,
	ETHTOOL_A_STATS_PAD = 1,
	ETHTOOL_A_STATS_HEADER = 2,
	ETHTOOL_A_STATS_GROUPS = 3,
	ETHTOOL_A_STATS_GRP = 4,
	ETHTOOL_A_STATS_SRC = 5,
	__ETHTOOL_A_STATS_CNT = 6,
	ETHTOOL_A_STATS_MAX = 5,
};

enum {
	ETHTOOL_A_STRINGSETS_UNSPEC = 0,
	ETHTOOL_A_STRINGSETS_STRINGSET = 1,
	__ETHTOOL_A_STRINGSETS_CNT = 2,
	ETHTOOL_A_STRINGSETS_MAX = 1,
};

enum {
	ETHTOOL_A_STRINGSET_UNSPEC = 0,
	ETHTOOL_A_STRINGSET_ID = 1,
	ETHTOOL_A_STRINGSET_COUNT = 2,
	ETHTOOL_A_STRINGSET_STRINGS = 3,
	__ETHTOOL_A_STRINGSET_CNT = 4,
	ETHTOOL_A_STRINGSET_MAX = 3,
};

enum {
	ETHTOOL_A_STRINGS_UNSPEC = 0,
	ETHTOOL_A_STRINGS_STRING = 1,
	__ETHTOOL_A_STRINGS_CNT = 2,
	ETHTOOL_A_STRINGS_MAX = 1,
};

enum {
	ETHTOOL_A_STRING_UNSPEC = 0,
	ETHTOOL_A_STRING_INDEX = 1,
	ETHTOOL_A_STRING_VALUE = 2,
	__ETHTOOL_A_STRING_CNT = 3,
	ETHTOOL_A_STRING_MAX = 2,
};

enum {
	ETHTOOL_A_STRSET_UNSPEC = 0,
	ETHTOOL_A_STRSET_HEADER = 1,
	ETHTOOL_A_STRSET_STRINGSETS = 2,
	ETHTOOL_A_STRSET_COUNTS_ONLY = 3,
	__ETHTOOL_A_STRSET_CNT = 4,
	ETHTOOL_A_STRSET_MAX = 3,
};

enum {
	ETHTOOL_A_TSCONFIG_UNSPEC = 0,
	ETHTOOL_A_TSCONFIG_HEADER = 1,
	ETHTOOL_A_TSCONFIG_HWTSTAMP_PROVIDER = 2,
	ETHTOOL_A_TSCONFIG_TX_TYPES = 3,
	ETHTOOL_A_TSCONFIG_RX_FILTERS = 4,
	ETHTOOL_A_TSCONFIG_HWTSTAMP_FLAGS = 5,
	__ETHTOOL_A_TSCONFIG_CNT = 6,
	ETHTOOL_A_TSCONFIG_MAX = 5,
};

enum {
	ETHTOOL_A_TSINFO_UNSPEC = 0,
	ETHTOOL_A_TSINFO_HEADER = 1,
	ETHTOOL_A_TSINFO_TIMESTAMPING = 2,
	ETHTOOL_A_TSINFO_TX_TYPES = 3,
	ETHTOOL_A_TSINFO_RX_FILTERS = 4,
	ETHTOOL_A_TSINFO_PHC_INDEX = 5,
	ETHTOOL_A_TSINFO_STATS = 6,
	ETHTOOL_A_TSINFO_HWTSTAMP_PROVIDER = 7,
	ETHTOOL_A_TSINFO_HWTSTAMP_SOURCE = 8,
	ETHTOOL_A_TSINFO_HWTSTAMP_PHYINDEX = 9,
	__ETHTOOL_A_TSINFO_CNT = 10,
	ETHTOOL_A_TSINFO_MAX = 9,
};

enum {
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_UNSPEC = 0,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_INDEX = 1,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_QUALIFIER = 2,
	__ETHTOOL_A_TS_HWTSTAMP_PROVIDER_CNT = 3,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_MAX = 2,
};

enum {
	ETHTOOL_A_TS_STAT_UNSPEC = 0,
	ETHTOOL_A_TS_STAT_TX_PKTS = 1,
	ETHTOOL_A_TS_STAT_TX_LOST = 2,
	ETHTOOL_A_TS_STAT_TX_ERR = 3,
	ETHTOOL_A_TS_STAT_TX_ONESTEP_PKTS_UNCONFIRMED = 4,
	__ETHTOOL_A_TS_STAT_CNT = 5,
	ETHTOOL_A_TS_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_TUNNEL_INFO_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_INFO_HEADER = 1,
	ETHTOOL_A_TUNNEL_INFO_UDP_PORTS = 2,
	__ETHTOOL_A_TUNNEL_INFO_CNT = 3,
	ETHTOOL_A_TUNNEL_INFO_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_ENTRY_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_PORT = 1,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_TYPE = 2,
	__ETHTOOL_A_TUNNEL_UDP_ENTRY_CNT = 3,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_TABLE_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE_SIZE = 1,
	ETHTOOL_A_TUNNEL_UDP_TABLE_TYPES = 2,
	ETHTOOL_A_TUNNEL_UDP_TABLE_ENTRY = 3,
	__ETHTOOL_A_TUNNEL_UDP_TABLE_CNT = 4,
	ETHTOOL_A_TUNNEL_UDP_TABLE_MAX = 3,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE = 1,
	__ETHTOOL_A_TUNNEL_UDP_CNT = 2,
	ETHTOOL_A_TUNNEL_UDP_MAX = 1,
};

enum {
	ETHTOOL_A_WOL_UNSPEC = 0,
	ETHTOOL_A_WOL_HEADER = 1,
	ETHTOOL_A_WOL_MODES = 2,
	ETHTOOL_A_WOL_SOPASS = 3,
	__ETHTOOL_A_WOL_CNT = 4,
	ETHTOOL_A_WOL_MAX = 3,
};

enum {
	ETHTOOL_MSG_KERNEL_NONE = 0,
	ETHTOOL_MSG_STRSET_GET_REPLY = 1,
	ETHTOOL_MSG_LINKINFO_GET_REPLY = 2,
	ETHTOOL_MSG_LINKINFO_NTF = 3,
	ETHTOOL_MSG_LINKMODES_GET_REPLY = 4,
	ETHTOOL_MSG_LINKMODES_NTF = 5,
	ETHTOOL_MSG_LINKSTATE_GET_REPLY = 6,
	ETHTOOL_MSG_DEBUG_GET_REPLY = 7,
	ETHTOOL_MSG_DEBUG_NTF = 8,
	ETHTOOL_MSG_WOL_GET_REPLY = 9,
	ETHTOOL_MSG_WOL_NTF = 10,
	ETHTOOL_MSG_FEATURES_GET_REPLY = 11,
	ETHTOOL_MSG_FEATURES_SET_REPLY = 12,
	ETHTOOL_MSG_FEATURES_NTF = 13,
	ETHTOOL_MSG_PRIVFLAGS_GET_REPLY = 14,
	ETHTOOL_MSG_PRIVFLAGS_NTF = 15,
	ETHTOOL_MSG_RINGS_GET_REPLY = 16,
	ETHTOOL_MSG_RINGS_NTF = 17,
	ETHTOOL_MSG_CHANNELS_GET_REPLY = 18,
	ETHTOOL_MSG_CHANNELS_NTF = 19,
	ETHTOOL_MSG_COALESCE_GET_REPLY = 20,
	ETHTOOL_MSG_COALESCE_NTF = 21,
	ETHTOOL_MSG_PAUSE_GET_REPLY = 22,
	ETHTOOL_MSG_PAUSE_NTF = 23,
	ETHTOOL_MSG_EEE_GET_REPLY = 24,
	ETHTOOL_MSG_EEE_NTF = 25,
	ETHTOOL_MSG_TSINFO_GET_REPLY = 26,
	ETHTOOL_MSG_CABLE_TEST_NTF = 27,
	ETHTOOL_MSG_CABLE_TEST_TDR_NTF = 28,
	ETHTOOL_MSG_TUNNEL_INFO_GET_REPLY = 29,
	ETHTOOL_MSG_FEC_GET_REPLY = 30,
	ETHTOOL_MSG_FEC_NTF = 31,
	ETHTOOL_MSG_MODULE_EEPROM_GET_REPLY = 32,
	ETHTOOL_MSG_STATS_GET_REPLY = 33,
	ETHTOOL_MSG_PHC_VCLOCKS_GET_REPLY = 34,
	ETHTOOL_MSG_MODULE_GET_REPLY = 35,
	ETHTOOL_MSG_MODULE_NTF = 36,
	ETHTOOL_MSG_PSE_GET_REPLY = 37,
	ETHTOOL_MSG_RSS_GET_REPLY = 38,
	ETHTOOL_MSG_PLCA_GET_CFG_REPLY = 39,
	ETHTOOL_MSG_PLCA_GET_STATUS_REPLY = 40,
	ETHTOOL_MSG_PLCA_NTF = 41,
	ETHTOOL_MSG_MM_GET_REPLY = 42,
	ETHTOOL_MSG_MM_NTF = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_NTF = 44,
	ETHTOOL_MSG_PHY_GET_REPLY = 45,
	ETHTOOL_MSG_PHY_NTF = 46,
	ETHTOOL_MSG_TSCONFIG_GET_REPLY = 47,
	ETHTOOL_MSG_TSCONFIG_SET_REPLY = 48,
	ETHTOOL_MSG_PSE_NTF = 49,
	ETHTOOL_MSG_RSS_NTF = 50,
	ETHTOOL_MSG_RSS_CREATE_ACT_REPLY = 51,
	ETHTOOL_MSG_RSS_CREATE_NTF = 52,
	ETHTOOL_MSG_RSS_DELETE_NTF = 53,
	__ETHTOOL_MSG_KERNEL_CNT = 54,
	ETHTOOL_MSG_KERNEL_MAX = 53,
};

enum {
	ETHTOOL_MSG_USER_NONE = 0,
	ETHTOOL_MSG_STRSET_GET = 1,
	ETHTOOL_MSG_LINKINFO_GET = 2,
	ETHTOOL_MSG_LINKINFO_SET = 3,
	ETHTOOL_MSG_LINKMODES_GET = 4,
	ETHTOOL_MSG_LINKMODES_SET = 5,
	ETHTOOL_MSG_LINKSTATE_GET = 6,
	ETHTOOL_MSG_DEBUG_GET = 7,
	ETHTOOL_MSG_DEBUG_SET = 8,
	ETHTOOL_MSG_WOL_GET = 9,
	ETHTOOL_MSG_WOL_SET = 10,
	ETHTOOL_MSG_FEATURES_GET = 11,
	ETHTOOL_MSG_FEATURES_SET = 12,
	ETHTOOL_MSG_PRIVFLAGS_GET = 13,
	ETHTOOL_MSG_PRIVFLAGS_SET = 14,
	ETHTOOL_MSG_RINGS_GET = 15,
	ETHTOOL_MSG_RINGS_SET = 16,
	ETHTOOL_MSG_CHANNELS_GET = 17,
	ETHTOOL_MSG_CHANNELS_SET = 18,
	ETHTOOL_MSG_COALESCE_GET = 19,
	ETHTOOL_MSG_COALESCE_SET = 20,
	ETHTOOL_MSG_PAUSE_GET = 21,
	ETHTOOL_MSG_PAUSE_SET = 22,
	ETHTOOL_MSG_EEE_GET = 23,
	ETHTOOL_MSG_EEE_SET = 24,
	ETHTOOL_MSG_TSINFO_GET = 25,
	ETHTOOL_MSG_CABLE_TEST_ACT = 26,
	ETHTOOL_MSG_CABLE_TEST_TDR_ACT = 27,
	ETHTOOL_MSG_TUNNEL_INFO_GET = 28,
	ETHTOOL_MSG_FEC_GET = 29,
	ETHTOOL_MSG_FEC_SET = 30,
	ETHTOOL_MSG_MODULE_EEPROM_GET = 31,
	ETHTOOL_MSG_STATS_GET = 32,
	ETHTOOL_MSG_PHC_VCLOCKS_GET = 33,
	ETHTOOL_MSG_MODULE_GET = 34,
	ETHTOOL_MSG_MODULE_SET = 35,
	ETHTOOL_MSG_PSE_GET = 36,
	ETHTOOL_MSG_PSE_SET = 37,
	ETHTOOL_MSG_RSS_GET = 38,
	ETHTOOL_MSG_PLCA_GET_CFG = 39,
	ETHTOOL_MSG_PLCA_SET_CFG = 40,
	ETHTOOL_MSG_PLCA_GET_STATUS = 41,
	ETHTOOL_MSG_MM_GET = 42,
	ETHTOOL_MSG_MM_SET = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_ACT = 44,
	ETHTOOL_MSG_PHY_GET = 45,
	ETHTOOL_MSG_TSCONFIG_GET = 46,
	ETHTOOL_MSG_TSCONFIG_SET = 47,
	ETHTOOL_MSG_RSS_SET = 48,
	ETHTOOL_MSG_RSS_CREATE_ACT = 49,
	ETHTOOL_MSG_RSS_DELETE_ACT = 50,
	__ETHTOOL_MSG_USER_CNT = 51,
	ETHTOOL_MSG_USER_MAX = 50,
};

enum {
	ETHTOOL_STATS_ETH_PHY = 0,
	ETHTOOL_STATS_ETH_MAC = 1,
	ETHTOOL_STATS_ETH_CTRL = 2,
	ETHTOOL_STATS_RMON = 3,
	ETHTOOL_STATS_PHY = 4,
	__ETHTOOL_STATS_CNT = 5,
};

enum {
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN = 0,
	ETHTOOL_UDP_TUNNEL_TYPE_GENEVE = 1,
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN_GPE = 2,
	__ETHTOOL_UDP_TUNNEL_TYPE_CNT = 3,
	ETHTOOL_UDP_TUNNEL_TYPE_MAX = 2,
};

enum {
	ETH_RSS_HASH_TOP_BIT = 0,
	ETH_RSS_HASH_XOR_BIT = 1,
	ETH_RSS_HASH_CRC32_BIT = 2,
	ETH_RSS_HASH_FUNCS_COUNT = 3,
};

enum {
	EVENTFS_SAVE_MODE = 65536,
	EVENTFS_SAVE_UID = 131072,
	EVENTFS_SAVE_GID = 262144,
};

enum {
	EVENT_FILE_FL_ENABLED = 1,
	EVENT_FILE_FL_RECORDED_CMD = 2,
	EVENT_FILE_FL_RECORDED_TGID = 4,
	EVENT_FILE_FL_FILTERED = 8,
	EVENT_FILE_FL_NO_SET_FILTER = 16,
	EVENT_FILE_FL_SOFT_DISABLED = 32,
	EVENT_FILE_FL_TRIGGER_MODE = 64,
	EVENT_FILE_FL_TRIGGER_COND = 128,
	EVENT_FILE_FL_PID_FILTER = 256,
	EVENT_FILE_FL_WAS_ENABLED = 512,
	EVENT_FILE_FL_FREED = 1024,
};

enum {
	EVENT_FILE_FL_ENABLED_BIT = 0,
	EVENT_FILE_FL_RECORDED_CMD_BIT = 1,
	EVENT_FILE_FL_RECORDED_TGID_BIT = 2,
	EVENT_FILE_FL_FILTERED_BIT = 3,
	EVENT_FILE_FL_NO_SET_FILTER_BIT = 4,
	EVENT_FILE_FL_SOFT_DISABLED_BIT = 5,
	EVENT_FILE_FL_TRIGGER_MODE_BIT = 6,
	EVENT_FILE_FL_TRIGGER_COND_BIT = 7,
	EVENT_FILE_FL_PID_FILTER_BIT = 8,
	EVENT_FILE_FL_WAS_ENABLED_BIT = 9,
	EVENT_FILE_FL_FREED_BIT = 10,
};

enum {
	EVENT_TRIGGER_FL_PROBE = 1,
};

enum {
	Enabled = 0,
	Magic = 1,
};

enum {
	FAN_EVENT_INIT = 0,
	FAN_EVENT_REPORTED = 1,
	FAN_EVENT_ANSWERED = 2,
	FAN_EVENT_CANCELED = 3,
};

enum {
	FBCON_LOGO_CANSHOW = -1,
	FBCON_LOGO_DRAW = -2,
	FBCON_LOGO_DONTSHOW = -3,
};

enum {
	FB_BLANK_UNBLANK = 0,
	FB_BLANK_NORMAL = 1,
	FB_BLANK_VSYNC_SUSPEND = 2,
	FB_BLANK_HSYNC_SUSPEND = 3,
	FB_BLANK_POWERDOWN = 4,
};

enum {
	FGRAPH_TYPE_RESERVED = 0,
	FGRAPH_TYPE_BITMAP = 1,
	FGRAPH_TYPE_DATA = 2,
};

enum {
	FIB6_NO_SERNUM_CHANGE = 0,
};

enum {
	FILTER_OTHER = 0,
	FILTER_STATIC_STRING = 1,
	FILTER_DYN_STRING = 2,
	FILTER_RDYN_STRING = 3,
	FILTER_PTR_STRING = 4,
	FILTER_TRACE_FN = 5,
	FILTER_CPUMASK = 6,
	FILTER_COMM = 7,
	FILTER_CPU = 8,
	FILTER_STACKTRACE = 9,
};

enum {
	FILT_ERR_NONE = 0,
	FILT_ERR_INVALID_OP = 1,
	FILT_ERR_TOO_MANY_OPEN = 2,
	FILT_ERR_TOO_MANY_CLOSE = 3,
	FILT_ERR_MISSING_QUOTE = 4,
	FILT_ERR_MISSING_BRACE_OPEN = 5,
	FILT_ERR_MISSING_BRACE_CLOSE = 6,
	FILT_ERR_OPERAND_TOO_LONG = 7,
	FILT_ERR_EXPECT_STRING = 8,
	FILT_ERR_EXPECT_DIGIT = 9,
	FILT_ERR_ILLEGAL_FIELD_OP = 10,
	FILT_ERR_FIELD_NOT_FOUND = 11,
	FILT_ERR_ILLEGAL_INTVAL = 12,
	FILT_ERR_BAD_SUBSYS_FILTER = 13,
	FILT_ERR_TOO_MANY_PREDS = 14,
	FILT_ERR_INVALID_FILTER = 15,
	FILT_ERR_INVALID_CPULIST = 16,
	FILT_ERR_IP_FIELD_ONLY = 17,
	FILT_ERR_INVALID_VALUE = 18,
	FILT_ERR_NO_FUNCTION = 19,
	FILT_ERR_ERRNO = 20,
	FILT_ERR_NO_FILTER = 21,
};

enum {
	FLAGS_ADC = 1,
	FLAGS_RTC = 2,
};

enum {
	FLAGS_FILL_FULL = 268435456,
	FLAGS_FILL_START = 536870912,
	FLAGS_FILL_END = 805306368,
};

enum {
	FLAT_BINDER_FLAG_PRIORITY_MASK = 255,
	FLAT_BINDER_FLAG_ACCEPTS_FDS = 256,
	FLAT_BINDER_FLAG_TXN_SECURITY_CTX = 4096,
};

enum {
	FOLL_TOUCH = 65536,
	FOLL_TRIED = 131072,
	FOLL_REMOTE = 262144,
	FOLL_PIN = 524288,
	FOLL_FAST_ONLY = 1048576,
	FOLL_UNLOCKABLE = 2097152,
	FOLL_MADV_POPULATE = 4194304,
};

enum {
	FOLL_WRITE = 1,
	FOLL_GET = 2,
	FOLL_DUMP = 4,
	FOLL_FORCE = 8,
	FOLL_NOWAIT = 16,
	FOLL_NOFAULT = 32,
	FOLL_HWPOISON = 64,
	FOLL_ANON = 128,
	FOLL_LONGTERM = 256,
	FOLL_SPLIT_PMD = 512,
	FOLL_PCI_P2PDMA = 1024,
	FOLL_INTERRUPTIBLE = 2048,
	FOLL_HONOR_NUMA_FAULT = 4096,
};

enum {
	FORMAT_HEADER = 1,
	FORMAT_FIELD_SEPERATOR = 2,
	FORMAT_PRINTFMT = 3,
};

enum {
	FRA_UNSPEC = 0,
	FRA_DST = 1,
	FRA_SRC = 2,
	FRA_IIFNAME = 3,
	FRA_GOTO = 4,
	FRA_UNUSED2 = 5,
	FRA_PRIORITY = 6,
	FRA_UNUSED3 = 7,
	FRA_UNUSED4 = 8,
	FRA_UNUSED5 = 9,
	FRA_FWMARK = 10,
	FRA_FLOW = 11,
	FRA_TUN_ID = 12,
	FRA_SUPPRESS_IFGROUP = 13,
	FRA_SUPPRESS_PREFIXLEN = 14,
	FRA_TABLE = 15,
	FRA_FWMASK = 16,
	FRA_OIFNAME = 17,
	FRA_PAD = 18,
	FRA_L3MDEV = 19,
	FRA_UID_RANGE = 20,
	FRA_PROTOCOL = 21,
	FRA_IP_PROTO = 22,
	FRA_SPORT_RANGE = 23,
	FRA_DPORT_RANGE = 24,
	FRA_DSCP = 25,
	FRA_FLOWLABEL = 26,
	FRA_FLOWLABEL_MASK = 27,
	FRA_SPORT_MASK = 28,
	FRA_DPORT_MASK = 29,
	FRA_DSCP_MASK = 30,
	__FRA_MAX = 31,
};

enum {
	FR_ACT_UNSPEC = 0,
	FR_ACT_TO_TBL = 1,
	FR_ACT_GOTO = 2,
	FR_ACT_NOP = 3,
	FR_ACT_RES3 = 4,
	FR_ACT_RES4 = 5,
	FR_ACT_BLACKHOLE = 6,
	FR_ACT_UNREACHABLE = 7,
	FR_ACT_PROHIBIT = 8,
	__FR_ACT_MAX = 9,
};

enum {
	FR_PERCPU = 0,
	FR_ATOMIC = 1,
};

enum {
	FTRACE_FL_ENABLED = 2147483648,
	FTRACE_FL_REGS = 1073741824,
	FTRACE_FL_REGS_EN = 536870912,
	FTRACE_FL_TRAMP = 268435456,
	FTRACE_FL_TRAMP_EN = 134217728,
	FTRACE_FL_IPMODIFY = 67108864,
	FTRACE_FL_DISABLED = 33554432,
	FTRACE_FL_DIRECT = 16777216,
	FTRACE_FL_DIRECT_EN = 8388608,
	FTRACE_FL_CALL_OPS = 4194304,
	FTRACE_FL_CALL_OPS_EN = 2097152,
	FTRACE_FL_TOUCHED = 1048576,
	FTRACE_FL_MODIFIED = 524288,
};

enum {
	FTRACE_HASH_FL_MOD = 1,
};

enum {
	FTRACE_ITER_FILTER = 1,
	FTRACE_ITER_NOTRACE = 2,
	FTRACE_ITER_PRINTALL = 4,
	FTRACE_ITER_DO_PROBES = 8,
	FTRACE_ITER_PROBE = 16,
	FTRACE_ITER_MOD = 32,
	FTRACE_ITER_ENABLED = 64,
	FTRACE_ITER_TOUCHED = 128,
	FTRACE_ITER_ADDRS = 256,
};

enum {
	FTRACE_MODIFY_ENABLE_FL = 1,
	FTRACE_MODIFY_MAY_SLEEP_FL = 2,
};

enum {
	FTRACE_OPS_FL_ENABLED = 1,
	FTRACE_OPS_FL_DYNAMIC = 2,
	FTRACE_OPS_FL_SAVE_REGS = 4,
	FTRACE_OPS_FL_SAVE_REGS_IF_SUPPORTED = 8,
	FTRACE_OPS_FL_RECURSION = 16,
	FTRACE_OPS_FL_STUB = 32,
	FTRACE_OPS_FL_INITIALIZED = 64,
	FTRACE_OPS_FL_DELETED = 128,
	FTRACE_OPS_FL_ADDING = 256,
	FTRACE_OPS_FL_REMOVING = 512,
	FTRACE_OPS_FL_MODIFYING = 1024,
	FTRACE_OPS_FL_ALLOC_TRAMP = 2048,
	FTRACE_OPS_FL_IPMODIFY = 4096,
	FTRACE_OPS_FL_PID = 8192,
	FTRACE_OPS_FL_RCU = 16384,
	FTRACE_OPS_FL_TRACE_ARRAY = 32768,
	FTRACE_OPS_FL_PERMANENT = 65536,
	FTRACE_OPS_FL_DIRECT = 131072,
	FTRACE_OPS_FL_SUBOP = 262144,
	FTRACE_OPS_FL_GRAPH = 524288,
};

enum {
	FTRACE_UPDATE_CALLS = 1,
	FTRACE_DISABLE_CALLS = 2,
	FTRACE_UPDATE_TRACE_FUNC = 4,
	FTRACE_START_FUNC_RET = 8,
	FTRACE_STOP_FUNC_RET = 16,
	FTRACE_MAY_SLEEP = 32,
};

enum {
	FTRACE_UPDATE_IGNORE = 0,
	FTRACE_UPDATE_MAKE_CALL = 1,
	FTRACE_UPDATE_MODIFY_CALL = 2,
	FTRACE_UPDATE_MAKE_NOP = 3,
};

enum {
	FUSE_I_ADVISE_RDPLUS = 0,
	FUSE_I_INIT_RDPLUS = 1,
	FUSE_I_SIZE_UNSTABLE = 2,
	FUSE_I_BAD = 3,
	FUSE_I_BTIME = 4,
	FUSE_I_CACHE_IO_MODE = 5,
};

enum {
	FUTEX_STATE_OK = 0,
	FUTEX_STATE_EXITING = 1,
	FUTEX_STATE_DEAD = 2,
};

enum {
	GATE_INTERRUPT = 14,
	GATE_TRAP = 15,
	GATE_CALL = 12,
	GATE_TASK = 5,
};

enum {
	GENHD_FL_REMOVABLE = 1,
	GENHD_FL_HIDDEN = 2,
	GENHD_FL_NO_PART = 4,
};

enum {
	GHES_SEV_NO = 0,
	GHES_SEV_CORRECTED = 1,
	GHES_SEV_RECOVERABLE = 2,
	GHES_SEV_PANIC = 3,
};

enum {
	GI2C_PORT = 0,
	PI2C_PORT = 1,
};

enum {
	GP_IDLE = 0,
	GP_ENTER = 1,
	GP_PASSED = 2,
	GP_EXIT = 3,
	GP_REPLAY = 4,
};

enum {
	HANDSHAKE_A_ACCEPT_SOCKFD = 1,
	HANDSHAKE_A_ACCEPT_HANDLER_CLASS = 2,
	HANDSHAKE_A_ACCEPT_MESSAGE_TYPE = 3,
	HANDSHAKE_A_ACCEPT_TIMEOUT = 4,
	HANDSHAKE_A_ACCEPT_AUTH_MODE = 5,
	HANDSHAKE_A_ACCEPT_PEER_IDENTITY = 6,
	HANDSHAKE_A_ACCEPT_CERTIFICATE = 7,
	HANDSHAKE_A_ACCEPT_PEERNAME = 8,
	HANDSHAKE_A_ACCEPT_KEYRING = 9,
	__HANDSHAKE_A_ACCEPT_MAX = 10,
	HANDSHAKE_A_ACCEPT_MAX = 9,
};

enum {
	HANDSHAKE_A_DONE_STATUS = 1,
	HANDSHAKE_A_DONE_SOCKFD = 2,
	HANDSHAKE_A_DONE_REMOTE_AUTH = 3,
	__HANDSHAKE_A_DONE_MAX = 4,
	HANDSHAKE_A_DONE_MAX = 3,
};

enum {
	HANDSHAKE_A_X509_CERT = 1,
	HANDSHAKE_A_X509_PRIVKEY = 2,
	__HANDSHAKE_A_X509_MAX = 3,
	HANDSHAKE_A_X509_MAX = 2,
};

enum {
	HANDSHAKE_CMD_READY = 1,
	HANDSHAKE_CMD_ACCEPT = 2,
	HANDSHAKE_CMD_DONE = 3,
	__HANDSHAKE_CMD_MAX = 4,
	HANDSHAKE_CMD_MAX = 3,
};

enum {
	HANDSHAKE_NLGRP_NONE = 0,
	HANDSHAKE_NLGRP_TLSHD = 1,
};

enum {
	HASH_SIZE = 128,
};

enum {
	HAS_READ = 1,
	HAS_WRITE = 2,
	HAS_LSEEK = 4,
	HAS_POLL = 8,
	HAS_IOCTL = 16,
};

enum {
	HIBERNATION_INVALID = 0,
	HIBERNATION_PLATFORM = 1,
	HIBERNATION_SHUTDOWN = 2,
	HIBERNATION_REBOOT = 3,
	HIBERNATION_SUSPEND = 4,
	HIBERNATION_TEST_RESUME = 5,
	__HIBERNATION_AFTER_LAST = 6,
};

enum {
	HIST_ERR_NONE = 0,
	HIST_ERR_DUPLICATE_VAR = 1,
	HIST_ERR_VAR_NOT_UNIQUE = 2,
	HIST_ERR_TOO_MANY_VARS = 3,
	HIST_ERR_MALFORMED_ASSIGNMENT = 4,
	HIST_ERR_NAMED_MISMATCH = 5,
	HIST_ERR_TRIGGER_EEXIST = 6,
	HIST_ERR_TRIGGER_ENOENT_CLEAR = 7,
	HIST_ERR_SET_CLOCK_FAIL = 8,
	HIST_ERR_BAD_FIELD_MODIFIER = 9,
	HIST_ERR_TOO_MANY_SUBEXPR = 10,
	HIST_ERR_TIMESTAMP_MISMATCH = 11,
	HIST_ERR_TOO_MANY_FIELD_VARS = 12,
	HIST_ERR_EVENT_FILE_NOT_FOUND = 13,
	HIST_ERR_HIST_NOT_FOUND = 14,
	HIST_ERR_HIST_CREATE_FAIL = 15,
	HIST_ERR_SYNTH_VAR_NOT_FOUND = 16,
	HIST_ERR_SYNTH_EVENT_NOT_FOUND = 17,
	HIST_ERR_SYNTH_TYPE_MISMATCH = 18,
	HIST_ERR_SYNTH_COUNT_MISMATCH = 19,
	HIST_ERR_FIELD_VAR_PARSE_FAIL = 20,
	HIST_ERR_VAR_CREATE_FIND_FAIL = 21,
	HIST_ERR_ONX_NOT_VAR = 22,
	HIST_ERR_ONX_VAR_NOT_FOUND = 23,
	HIST_ERR_ONX_VAR_CREATE_FAIL = 24,
	HIST_ERR_FIELD_VAR_CREATE_FAIL = 25,
	HIST_ERR_TOO_MANY_PARAMS = 26,
	HIST_ERR_PARAM_NOT_FOUND = 27,
	HIST_ERR_INVALID_PARAM = 28,
	HIST_ERR_ACTION_NOT_FOUND = 29,
	HIST_ERR_NO_SAVE_PARAMS = 30,
	HIST_ERR_TOO_MANY_SAVE_ACTIONS = 31,
	HIST_ERR_ACTION_MISMATCH = 32,
	HIST_ERR_NO_CLOSING_PAREN = 33,
	HIST_ERR_SUBSYS_NOT_FOUND = 34,
	HIST_ERR_INVALID_SUBSYS_EVENT = 35,
	HIST_ERR_INVALID_REF_KEY = 36,
	HIST_ERR_VAR_NOT_FOUND = 37,
	HIST_ERR_FIELD_NOT_FOUND = 38,
	HIST_ERR_EMPTY_ASSIGNMENT = 39,
	HIST_ERR_INVALID_SORT_MODIFIER = 40,
	HIST_ERR_EMPTY_SORT_FIELD = 41,
	HIST_ERR_TOO_MANY_SORT_FIELDS = 42,
	HIST_ERR_INVALID_SORT_FIELD = 43,
	HIST_ERR_INVALID_STR_OPERAND = 44,
	HIST_ERR_EXPECT_NUMBER = 45,
	HIST_ERR_UNARY_MINUS_SUBEXPR = 46,
	HIST_ERR_DIVISION_BY_ZERO = 47,
	HIST_ERR_NEED_NOHC_VAL = 48,
};

enum {
	HI_SOFTIRQ = 0,
	TIMER_SOFTIRQ = 1,
	NET_TX_SOFTIRQ = 2,
	NET_RX_SOFTIRQ = 3,
	BLOCK_SOFTIRQ = 4,
	IRQ_POLL_SOFTIRQ = 5,
	TASKLET_SOFTIRQ = 6,
	SCHED_SOFTIRQ = 7,
	HRTIMER_SOFTIRQ = 8,
	RCU_SOFTIRQ = 9,
	NR_SOFTIRQS = 10,
};

enum {
	HMM_NEED_FAULT = 1,
	HMM_NEED_WRITE_FAULT = 2,
	HMM_NEED_ALL_BITS = 3,
};

enum {
	HMM_PFN_INOUT_FLAGS = 2017612633061982208ULL,
};

enum {
	HP_THREAD_NONE = 0,
	HP_THREAD_ACTIVE = 1,
	HP_THREAD_PARKED = 2,
};

enum {
	HTE_TS_REGISTERED = 0,
	HTE_TS_REQ = 1,
	HTE_TS_DISABLE = 2,
	HTE_TS_QUEUE_WK = 3,
};

enum {
	HUF_flags_bmi2 = 1,
	HUF_flags_optimalDepth = 2,
	HUF_flags_preferRepeat = 4,
	HUF_flags_suspectUncompressible = 8,
	HUF_flags_disableAsm = 16,
	HUF_flags_disableFast = 32,
};

enum {
	HUGETLB_SHMFS_INODE = 1,
	HUGETLB_ANONHUGE_INODE = 2,
};

enum {
	HV_SUBNODE_ANY = 0,
	HV_SUBNODE_SOCKET = 1,
	HV_SUBNODE_CLUSTER = 2,
	HV_SUBNODE_L3 = 3,
	HV_SUBNODE_COUNT = 4,
	HV_SUBNODE_INVALID = -1,
};

enum {
	HW_BREAKPOINT_EMPTY = 0,
	HW_BREAKPOINT_R = 1,
	HW_BREAKPOINT_W = 2,
	HW_BREAKPOINT_RW = 3,
	HW_BREAKPOINT_X = 4,
	HW_BREAKPOINT_INVALID = 7,
};

enum {
	HW_BREAKPOINT_LEN_1 = 1,
	HW_BREAKPOINT_LEN_2 = 2,
	HW_BREAKPOINT_LEN_3 = 3,
	HW_BREAKPOINT_LEN_4 = 4,
	HW_BREAKPOINT_LEN_5 = 5,
	HW_BREAKPOINT_LEN_6 = 6,
	HW_BREAKPOINT_LEN_7 = 7,
	HW_BREAKPOINT_LEN_8 = 8,
};

enum {
	ICMP6_MIB_NUM = 0,
	ICMP6_MIB_INMSGS = 1,
	ICMP6_MIB_INERRORS = 2,
	ICMP6_MIB_OUTMSGS = 3,
	ICMP6_MIB_OUTERRORS = 4,
	ICMP6_MIB_CSUMERRORS = 5,
	ICMP6_MIB_RATELIMITHOST = 6,
	__ICMP6_MIB_MAX = 7,
};

enum {
	ICMP_MIB_NUM = 0,
	ICMP_MIB_INMSGS = 1,
	ICMP_MIB_INERRORS = 2,
	ICMP_MIB_INDESTUNREACHS = 3,
	ICMP_MIB_INTIMEEXCDS = 4,
	ICMP_MIB_INPARMPROBS = 5,
	ICMP_MIB_INSRCQUENCHS = 6,
	ICMP_MIB_INREDIRECTS = 7,
	ICMP_MIB_INECHOS = 8,
	ICMP_MIB_INECHOREPS = 9,
	ICMP_MIB_INTIMESTAMPS = 10,
	ICMP_MIB_INTIMESTAMPREPS = 11,
	ICMP_MIB_INADDRMASKS = 12,
	ICMP_MIB_INADDRMASKREPS = 13,
	ICMP_MIB_OUTMSGS = 14,
	ICMP_MIB_OUTERRORS = 15,
	ICMP_MIB_OUTDESTUNREACHS = 16,
	ICMP_MIB_OUTTIMEEXCDS = 17,
	ICMP_MIB_OUTPARMPROBS = 18,
	ICMP_MIB_OUTSRCQUENCHS = 19,
	ICMP_MIB_OUTREDIRECTS = 20,
	ICMP_MIB_OUTECHOS = 21,
	ICMP_MIB_OUTECHOREPS = 22,
	ICMP_MIB_OUTTIMESTAMPS = 23,
	ICMP_MIB_OUTTIMESTAMPREPS = 24,
	ICMP_MIB_OUTADDRMASKS = 25,
	ICMP_MIB_OUTADDRMASKREPS = 26,
	ICMP_MIB_CSUMERRORS = 27,
	ICMP_MIB_RATELIMITGLOBAL = 28,
	ICMP_MIB_RATELIMITHOST = 29,
	__ICMP_MIB_MAX = 30,
};

enum {
	ICQ_EXITED = 4,
	ICQ_DESTROYED = 8,
};

enum {
	IDX_MODULE_ID = 0,
	IDX_ST_OPS_COMMON_VALUE_ID = 1,
};

enum {
	IFAL_ADDRESS = 1,
	IFAL_LABEL = 2,
	__IFAL_MAX = 3,
};

enum {
	IFA_UNSPEC = 0,
	IFA_ADDRESS = 1,
	IFA_LOCAL = 2,
	IFA_LABEL = 3,
	IFA_BROADCAST = 4,
	IFA_ANYCAST = 5,
	IFA_CACHEINFO = 6,
	IFA_MULTICAST = 7,
	IFA_FLAGS = 8,
	IFA_RT_PRIORITY = 9,
	IFA_TARGET_NETNSID = 10,
	IFA_PROTO = 11,
	__IFA_MAX = 12,
};

enum {
	IFLA_BRIDGE_FLAGS = 0,
	IFLA_BRIDGE_MODE = 1,
	IFLA_BRIDGE_VLAN_INFO = 2,
	IFLA_BRIDGE_VLAN_TUNNEL_INFO = 3,
	IFLA_BRIDGE_MRP = 4,
	IFLA_BRIDGE_CFM = 5,
	IFLA_BRIDGE_MST = 6,
	__IFLA_BRIDGE_MAX = 7,
};

enum {
	IFLA_BRPORT_UNSPEC = 0,
	IFLA_BRPORT_STATE = 1,
	IFLA_BRPORT_PRIORITY = 2,
	IFLA_BRPORT_COST = 3,
	IFLA_BRPORT_MODE = 4,
	IFLA_BRPORT_GUARD = 5,
	IFLA_BRPORT_PROTECT = 6,
	IFLA_BRPORT_FAST_LEAVE = 7,
	IFLA_BRPORT_LEARNING = 8,
	IFLA_BRPORT_UNICAST_FLOOD = 9,
	IFLA_BRPORT_PROXYARP = 10,
	IFLA_BRPORT_LEARNING_SYNC = 11,
	IFLA_BRPORT_PROXYARP_WIFI = 12,
	IFLA_BRPORT_ROOT_ID = 13,
	IFLA_BRPORT_BRIDGE_ID = 14,
	IFLA_BRPORT_DESIGNATED_PORT = 15,
	IFLA_BRPORT_DESIGNATED_COST = 16,
	IFLA_BRPORT_ID = 17,
	IFLA_BRPORT_NO = 18,
	IFLA_BRPORT_TOPOLOGY_CHANGE_ACK = 19,
	IFLA_BRPORT_CONFIG_PENDING = 20,
	IFLA_BRPORT_MESSAGE_AGE_TIMER = 21,
	IFLA_BRPORT_FORWARD_DELAY_TIMER = 22,
	IFLA_BRPORT_HOLD_TIMER = 23,
	IFLA_BRPORT_FLUSH = 24,
	IFLA_BRPORT_MULTICAST_ROUTER = 25,
	IFLA_BRPORT_PAD = 26,
	IFLA_BRPORT_MCAST_FLOOD = 27,
	IFLA_BRPORT_MCAST_TO_UCAST = 28,
	IFLA_BRPORT_VLAN_TUNNEL = 29,
	IFLA_BRPORT_BCAST_FLOOD = 30,
	IFLA_BRPORT_GROUP_FWD_MASK = 31,
	IFLA_BRPORT_NEIGH_SUPPRESS = 32,
	IFLA_BRPORT_ISOLATED = 33,
	IFLA_BRPORT_BACKUP_PORT = 34,
	IFLA_BRPORT_MRP_RING_OPEN = 35,
	IFLA_BRPORT_MRP_IN_OPEN = 36,
	IFLA_BRPORT_MCAST_EHT_HOSTS_LIMIT = 37,
	IFLA_BRPORT_MCAST_EHT_HOSTS_CNT = 38,
	IFLA_BRPORT_LOCKED = 39,
	IFLA_BRPORT_MAB = 40,
	IFLA_BRPORT_MCAST_N_GROUPS = 41,
	IFLA_BRPORT_MCAST_MAX_GROUPS = 42,
	IFLA_BRPORT_NEIGH_VLAN_SUPPRESS = 43,
	IFLA_BRPORT_BACKUP_NHID = 44,
	__IFLA_BRPORT_MAX = 45,
};

enum {
	IFLA_EVENT_NONE = 0,
	IFLA_EVENT_REBOOT = 1,
	IFLA_EVENT_FEATURES = 2,
	IFLA_EVENT_BONDING_FAILOVER = 3,
	IFLA_EVENT_NOTIFY_PEERS = 4,
	IFLA_EVENT_IGMP_RESEND = 5,
	IFLA_EVENT_BONDING_OPTIONS = 6,
};

enum {
	IFLA_INET6_UNSPEC = 0,
	IFLA_INET6_FLAGS = 1,
	IFLA_INET6_CONF = 2,
	IFLA_INET6_STATS = 3,
	IFLA_INET6_MCAST = 4,
	IFLA_INET6_CACHEINFO = 5,
	IFLA_INET6_ICMP6STATS = 6,
	IFLA_INET6_TOKEN = 7,
	IFLA_INET6_ADDR_GEN_MODE = 8,
	IFLA_INET6_RA_MTU = 9,
	__IFLA_INET6_MAX = 10,
};

enum {
	IFLA_INET_UNSPEC = 0,
	IFLA_INET_CONF = 1,
	__IFLA_INET_MAX = 2,
};

enum {
	IFLA_INFO_UNSPEC = 0,
	IFLA_INFO_KIND = 1,
	IFLA_INFO_DATA = 2,
	IFLA_INFO_XSTATS = 3,
	IFLA_INFO_SLAVE_KIND = 4,
	IFLA_INFO_SLAVE_DATA = 5,
	__IFLA_INFO_MAX = 6,
};

enum {
	IFLA_IPTUN_UNSPEC = 0,
	IFLA_IPTUN_LINK = 1,
	IFLA_IPTUN_LOCAL = 2,
	IFLA_IPTUN_REMOTE = 3,
	IFLA_IPTUN_TTL = 4,
	IFLA_IPTUN_TOS = 5,
	IFLA_IPTUN_ENCAP_LIMIT = 6,
	IFLA_IPTUN_FLOWINFO = 7,
	IFLA_IPTUN_FLAGS = 8,
	IFLA_IPTUN_PROTO = 9,
	IFLA_IPTUN_PMTUDISC = 10,
	IFLA_IPTUN_6RD_PREFIX = 11,
	IFLA_IPTUN_6RD_RELAY_PREFIX = 12,
	IFLA_IPTUN_6RD_PREFIXLEN = 13,
	IFLA_IPTUN_6RD_RELAY_PREFIXLEN = 14,
	IFLA_IPTUN_ENCAP_TYPE = 15,
	IFLA_IPTUN_ENCAP_FLAGS = 16,
	IFLA_IPTUN_ENCAP_SPORT = 17,
	IFLA_IPTUN_ENCAP_DPORT = 18,
	IFLA_IPTUN_COLLECT_METADATA = 19,
	IFLA_IPTUN_FWMARK = 20,
	__IFLA_IPTUN_MAX = 21,
};

enum {
	IFLA_MCTP_UNSPEC = 0,
	IFLA_MCTP_NET = 1,
	IFLA_MCTP_PHYS_BINDING = 2,
	__IFLA_MCTP_MAX = 3,
};

enum {
	IFLA_NETKIT_UNSPEC = 0,
	IFLA_NETKIT_PEER_INFO = 1,
	IFLA_NETKIT_PRIMARY = 2,
	IFLA_NETKIT_POLICY = 3,
	IFLA_NETKIT_PEER_POLICY = 4,
	IFLA_NETKIT_MODE = 5,
	IFLA_NETKIT_SCRUB = 6,
	IFLA_NETKIT_PEER_SCRUB = 7,
	IFLA_NETKIT_HEADROOM = 8,
	IFLA_NETKIT_TAILROOM = 9,
	__IFLA_NETKIT_MAX = 10,
};

enum {
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_REQUEST = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_USED = 2,
	__IFLA_OFFLOAD_XSTATS_HW_S_INFO_MAX = 3,
};

enum {
	IFLA_OFFLOAD_XSTATS_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_CPU_HIT = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO = 2,
	IFLA_OFFLOAD_XSTATS_L3_STATS = 3,
	__IFLA_OFFLOAD_XSTATS_MAX = 4,
};

enum {
	IFLA_PORT_UNSPEC = 0,
	IFLA_PORT_VF = 1,
	IFLA_PORT_PROFILE = 2,
	IFLA_PORT_VSI_TYPE = 3,
	IFLA_PORT_INSTANCE_UUID = 4,
	IFLA_PORT_HOST_UUID = 5,
	IFLA_PORT_REQUEST = 6,
	IFLA_PORT_RESPONSE = 7,
	__IFLA_PORT_MAX = 8,
};

enum {
	IFLA_PROTO_DOWN_REASON_UNSPEC = 0,
	IFLA_PROTO_DOWN_REASON_MASK = 1,
	IFLA_PROTO_DOWN_REASON_VALUE = 2,
	__IFLA_PROTO_DOWN_REASON_CNT = 3,
	IFLA_PROTO_DOWN_REASON_MAX = 2,
};

enum {
	IFLA_STATS_GETSET_UNSPEC = 0,
	IFLA_STATS_GET_FILTERS = 1,
	IFLA_STATS_SET_OFFLOAD_XSTATS_L3_STATS = 2,
	__IFLA_STATS_GETSET_MAX = 3,
};

enum {
	IFLA_STATS_UNSPEC = 0,
	IFLA_STATS_LINK_64 = 1,
	IFLA_STATS_LINK_XSTATS = 2,
	IFLA_STATS_LINK_XSTATS_SLAVE = 3,
	IFLA_STATS_LINK_OFFLOAD_XSTATS = 4,
	IFLA_STATS_AF_SPEC = 5,
	__IFLA_STATS_MAX = 6,
};

enum {
	IFLA_UNSPEC = 0,
	IFLA_ADDRESS = 1,
	IFLA_BROADCAST = 2,
	IFLA_IFNAME = 3,
	IFLA_MTU = 4,
	IFLA_LINK = 5,
	IFLA_QDISC = 6,
	IFLA_STATS = 7,
	IFLA_COST = 8,
	IFLA_PRIORITY = 9,
	IFLA_MASTER = 10,
	IFLA_WIRELESS = 11,
	IFLA_PROTINFO = 12,
	IFLA_TXQLEN = 13,
	IFLA_MAP = 14,
	IFLA_WEIGHT = 15,
	IFLA_OPERSTATE = 16,
	IFLA_LINKMODE = 17,
	IFLA_LINKINFO = 18,
	IFLA_NET_NS_PID = 19,
	IFLA_IFALIAS = 20,
	IFLA_NUM_VF = 21,
	IFLA_VFINFO_LIST = 22,
	IFLA_STATS64 = 23,
	IFLA_VF_PORTS = 24,
	IFLA_PORT_SELF = 25,
	IFLA_AF_SPEC = 26,
	IFLA_GROUP = 27,
	IFLA_NET_NS_FD = 28,
	IFLA_EXT_MASK = 29,
	IFLA_PROMISCUITY = 30,
	IFLA_NUM_TX_QUEUES = 31,
	IFLA_NUM_RX_QUEUES = 32,
	IFLA_CARRIER = 33,
	IFLA_PHYS_PORT_ID = 34,
	IFLA_CARRIER_CHANGES = 35,
	IFLA_PHYS_SWITCH_ID = 36,
	IFLA_LINK_NETNSID = 37,
	IFLA_PHYS_PORT_NAME = 38,
	IFLA_PROTO_DOWN = 39,
	IFLA_GSO_MAX_SEGS = 40,
	IFLA_GSO_MAX_SIZE = 41,
	IFLA_PAD = 42,
	IFLA_XDP = 43,
	IFLA_EVENT = 44,
	IFLA_NEW_NETNSID = 45,
	IFLA_IF_NETNSID = 46,
	IFLA_TARGET_NETNSID = 46,
	IFLA_CARRIER_UP_COUNT = 47,
	IFLA_CARRIER_DOWN_COUNT = 48,
	IFLA_NEW_IFINDEX = 49,
	IFLA_MIN_MTU = 50,
	IFLA_MAX_MTU = 51,
	IFLA_PROP_LIST = 52,
	IFLA_ALT_IFNAME = 53,
	IFLA_PERM_ADDRESS = 54,
	IFLA_PROTO_DOWN_REASON = 55,
	IFLA_PARENT_DEV_NAME = 56,
	IFLA_PARENT_DEV_BUS_NAME = 57,
	IFLA_GRO_MAX_SIZE = 58,
	IFLA_TSO_MAX_SIZE = 59,
	IFLA_TSO_MAX_SEGS = 60,
	IFLA_ALLMULTI = 61,
	IFLA_DEVLINK_PORT = 62,
	IFLA_GSO_IPV4_MAX_SIZE = 63,
	IFLA_GRO_IPV4_MAX_SIZE = 64,
	IFLA_DPLL_PIN = 65,
	IFLA_MAX_PACING_OFFLOAD_HORIZON = 66,
	IFLA_NETNS_IMMUTABLE = 67,
	__IFLA_MAX = 68,
};

enum {
	IFLA_VF_INFO_UNSPEC = 0,
	IFLA_VF_INFO = 1,
	__IFLA_VF_INFO_MAX = 2,
};

enum {
	IFLA_VF_PORT_UNSPEC = 0,
	IFLA_VF_PORT = 1,
	__IFLA_VF_PORT_MAX = 2,
};

enum {
	IFLA_VF_STATS_RX_PACKETS = 0,
	IFLA_VF_STATS_TX_PACKETS = 1,
	IFLA_VF_STATS_RX_BYTES = 2,
	IFLA_VF_STATS_TX_BYTES = 3,
	IFLA_VF_STATS_BROADCAST = 4,
	IFLA_VF_STATS_MULTICAST = 5,
	IFLA_VF_STATS_PAD = 6,
	IFLA_VF_STATS_RX_DROPPED = 7,
	IFLA_VF_STATS_TX_DROPPED = 8,
	__IFLA_VF_STATS_MAX = 9,
};

enum {
	IFLA_VF_UNSPEC = 0,
	IFLA_VF_MAC = 1,
	IFLA_VF_VLAN = 2,
	IFLA_VF_TX_RATE = 3,
	IFLA_VF_SPOOFCHK = 4,
	IFLA_VF_LINK_STATE = 5,
	IFLA_VF_RATE = 6,
	IFLA_VF_RSS_QUERY_EN = 7,
	IFLA_VF_STATS = 8,
	IFLA_VF_TRUST = 9,
	IFLA_VF_IB_NODE_GUID = 10,
	IFLA_VF_IB_PORT_GUID = 11,
	IFLA_VF_VLAN_LIST = 12,
	IFLA_VF_BROADCAST = 13,
	__IFLA_VF_MAX = 14,
};

enum {
	IFLA_VF_VLAN_INFO_UNSPEC = 0,
	IFLA_VF_VLAN_INFO = 1,
	__IFLA_VF_VLAN_INFO_MAX = 2,
};

enum {
	IFLA_XDP_UNSPEC = 0,
	IFLA_XDP_FD = 1,
	IFLA_XDP_ATTACHED = 2,
	IFLA_XDP_FLAGS = 3,
	IFLA_XDP_PROG_ID = 4,
	IFLA_XDP_DRV_PROG_ID = 5,
	IFLA_XDP_SKB_PROG_ID = 6,
	IFLA_XDP_HW_PROG_ID = 7,
	IFLA_XDP_EXPECTED_FD = 8,
	__IFLA_XDP_MAX = 9,
};

enum {
	IF_ACT_NONE = -1,
	IF_ACT_FILTER = 0,
	IF_ACT_START = 1,
	IF_ACT_STOP = 2,
	IF_SRC_FILE = 3,
	IF_SRC_KERNEL = 4,
	IF_SRC_FILEADDR = 5,
	IF_SRC_KERNELADDR = 6,
};

enum {
	IF_LINK_MODE_DEFAULT = 0,
	IF_LINK_MODE_DORMANT = 1,
	IF_LINK_MODE_TESTING = 2,
};

enum {
	IF_OPER_UNKNOWN = 0,
	IF_OPER_NOTPRESENT = 1,
	IF_OPER_DOWN = 2,
	IF_OPER_LOWERLAYERDOWN = 3,
	IF_OPER_TESTING = 4,
	IF_OPER_DORMANT = 5,
	IF_OPER_UP = 6,
};

enum {
	IF_STATE_ACTION = 0,
	IF_STATE_SOURCE = 1,
	IF_STATE_END = 2,
};

enum {
	INET6_IFADDR_STATE_PREDAD = 0,
	INET6_IFADDR_STATE_DAD = 1,
	INET6_IFADDR_STATE_POSTDAD = 2,
	INET6_IFADDR_STATE_ERRDAD = 3,
	INET6_IFADDR_STATE_DEAD = 4,
};

enum {
	INET_DIAG_NONE = 0,
	INET_DIAG_MEMINFO = 1,
	INET_DIAG_INFO = 2,
	INET_DIAG_VEGASINFO = 3,
	INET_DIAG_CONG = 4,
	INET_DIAG_TOS = 5,
	INET_DIAG_TCLASS = 6,
	INET_DIAG_SKMEMINFO = 7,
	INET_DIAG_SHUTDOWN = 8,
	INET_DIAG_DCTCPINFO = 9,
	INET_DIAG_PROTOCOL = 10,
	INET_DIAG_SKV6ONLY = 11,
	INET_DIAG_LOCALS = 12,
	INET_DIAG_PEERS = 13,
	INET_DIAG_PAD = 14,
	INET_DIAG_MARK = 15,
	INET_DIAG_BBRINFO = 16,
	INET_DIAG_CLASS_ID = 17,
	INET_DIAG_MD5SIG = 18,
	INET_DIAG_ULP_INFO = 19,
	INET_DIAG_SK_BPF_STORAGES = 20,
	INET_DIAG_CGROUP_ID = 21,
	INET_DIAG_SOCKOPT = 22,
	__INET_DIAG_MAX = 23,
};

enum {
	INET_DIAG_REQ_NONE = 0,
	INET_DIAG_REQ_BYTECODE = 1,
	INET_DIAG_REQ_SK_BPF_STORAGES = 2,
	INET_DIAG_REQ_PROTOCOL = 3,
	__INET_DIAG_REQ_MAX = 4,
};

enum {
	INET_ECN_NOT_ECT = 0,
	INET_ECN_ECT_1 = 1,
	INET_ECN_ECT_0 = 2,
	INET_ECN_CE = 3,
	INET_ECN_MASK = 3,
};

enum {
	INET_FLAGS_PKTINFO = 0,
	INET_FLAGS_TTL = 1,
	INET_FLAGS_TOS = 2,
	INET_FLAGS_RECVOPTS = 3,
	INET_FLAGS_RETOPTS = 4,
	INET_FLAGS_PASSSEC = 5,
	INET_FLAGS_ORIGDSTADDR = 6,
	INET_FLAGS_CHECKSUM = 7,
	INET_FLAGS_RECVFRAGSIZE = 8,
	INET_FLAGS_RECVERR = 9,
	INET_FLAGS_RECVERR_RFC4884 = 10,
	INET_FLAGS_FREEBIND = 11,
	INET_FLAGS_HDRINCL = 12,
	INET_FLAGS_MC_LOOP = 13,
	INET_FLAGS_MC_ALL = 14,
	INET_FLAGS_TRANSPARENT = 15,
	INET_FLAGS_IS_ICSK = 16,
	INET_FLAGS_NODEFRAG = 17,
	INET_FLAGS_BIND_ADDRESS_NO_PORT = 18,
	INET_FLAGS_DEFER_CONNECT = 19,
	INET_FLAGS_MC6_LOOP = 20,
	INET_FLAGS_RECVERR6_RFC4884 = 21,
	INET_FLAGS_MC6_ALL = 22,
	INET_FLAGS_AUTOFLOWLABEL_SET = 23,
	INET_FLAGS_AUTOFLOWLABEL = 24,
	INET_FLAGS_DONTFRAG = 25,
	INET_FLAGS_RECVERR6 = 26,
	INET_FLAGS_REPFLOW = 27,
	INET_FLAGS_RTALERT_ISOLATE = 28,
	INET_FLAGS_SNDFLOW = 29,
	INET_FLAGS_RTALERT = 30,
};

enum {
	INET_FRAG_FIRST_IN = 1,
	INET_FRAG_LAST_IN = 2,
	INET_FRAG_COMPLETE = 4,
	INET_FRAG_HASH_DEAD = 8,
	INET_FRAG_DROP = 16,
};

enum {
	INET_ULP_INFO_UNSPEC = 0,
	INET_ULP_INFO_NAME = 1,
	INET_ULP_INFO_TLS = 2,
	INET_ULP_INFO_MPTCP = 3,
	__INET_ULP_INFO_MAX = 4,
};

enum {
	INSN_F_FRAMENO_MASK = 7,
	INSN_F_SPI_MASK = 63,
	INSN_F_SPI_SHIFT = 3,
	INSN_F_STACK_ACCESS = 512,
	INSN_F_DST_REG_STACK = 1024,
	INSN_F_SRC_REG_STACK = 2048,
};

enum {
	INTEL_GPIO_BASE_ZERO = -2,
	INTEL_GPIO_BASE_NOMAP = -1,
	INTEL_GPIO_BASE_MATCH = 0,
};

enum {
	INVERT = 1,
	PROCESS_AND = 2,
	PROCESS_OR = 4,
};

enum {
	IOAM6_ATTR_UNSPEC = 0,
	IOAM6_ATTR_NS_ID = 1,
	IOAM6_ATTR_NS_DATA = 2,
	IOAM6_ATTR_NS_DATA_WIDE = 3,
	IOAM6_ATTR_SC_ID = 4,
	IOAM6_ATTR_SC_DATA = 5,
	IOAM6_ATTR_SC_NONE = 6,
	IOAM6_ATTR_PAD = 7,
	__IOAM6_ATTR_MAX = 8,
};

enum {
	IOAM6_CMD_UNSPEC = 0,
	IOAM6_CMD_ADD_NAMESPACE = 1,
	IOAM6_CMD_DEL_NAMESPACE = 2,
	IOAM6_CMD_DUMP_NAMESPACES = 3,
	IOAM6_CMD_ADD_SCHEMA = 4,
	IOAM6_CMD_DEL_SCHEMA = 5,
	IOAM6_CMD_DUMP_SCHEMAS = 6,
	IOAM6_CMD_NS_SET_SCHEMA = 7,
	__IOAM6_CMD_MAX = 8,
};

enum {
	IOAM6_IPTUNNEL_UNSPEC = 0,
	IOAM6_IPTUNNEL_MODE = 1,
	IOAM6_IPTUNNEL_DST = 2,
	IOAM6_IPTUNNEL_TRACE = 3,
	IOAM6_IPTUNNEL_FREQ_K = 4,
	IOAM6_IPTUNNEL_FREQ_N = 5,
	IOAM6_IPTUNNEL_SRC = 6,
	__IOAM6_IPTUNNEL_MAX = 7,
};

enum {
	IOBL_BUF_RING = 1,
	IOBL_INC = 2,
};

enum {
	IOCB_CMD_PREAD = 0,
	IOCB_CMD_PWRITE = 1,
	IOCB_CMD_FSYNC = 2,
	IOCB_CMD_FDSYNC = 3,
	IOCB_CMD_POLL = 5,
	IOCB_CMD_NOOP = 6,
	IOCB_CMD_PREADV = 7,
	IOCB_CMD_PWRITEV = 8,
};

enum {
	IOMMU_PASID_ARRAY_DOMAIN = 0,
	IOMMU_PASID_ARRAY_HANDLE = 1,
};

enum {
	IOMMU_SET_DOMAIN_MUST_SUCCEED = 1,
};

enum {
	IOPRIO_CLASS_NONE = 0,
	IOPRIO_CLASS_RT = 1,
	IOPRIO_CLASS_BE = 2,
	IOPRIO_CLASS_IDLE = 3,
	IOPRIO_CLASS_INVALID = 7,
};

enum {
	IOPRIO_HINT_NONE = 0,
	IOPRIO_HINT_DEV_DURATION_LIMIT_1 = 1,
	IOPRIO_HINT_DEV_DURATION_LIMIT_2 = 2,
	IOPRIO_HINT_DEV_DURATION_LIMIT_3 = 3,
	IOPRIO_HINT_DEV_DURATION_LIMIT_4 = 4,
	IOPRIO_HINT_DEV_DURATION_LIMIT_5 = 5,
	IOPRIO_HINT_DEV_DURATION_LIMIT_6 = 6,
	IOPRIO_HINT_DEV_DURATION_LIMIT_7 = 7,
};

enum {
	IOPRIO_WHO_PROCESS = 1,
	IOPRIO_WHO_PGRP = 2,
	IOPRIO_WHO_USER = 3,
};

enum {
	IORES_DESC_NONE = 0,
	IORES_DESC_CRASH_KERNEL = 1,
	IORES_DESC_ACPI_TABLES = 2,
	IORES_DESC_ACPI_NV_STORAGE = 3,
	IORES_DESC_PERSISTENT_MEMORY = 4,
	IORES_DESC_PERSISTENT_MEMORY_LEGACY = 5,
	IORES_DESC_DEVICE_PRIVATE_MEMORY = 6,
	IORES_DESC_RESERVED = 7,
	IORES_DESC_SOFT_RESERVED = 8,
	IORES_DESC_CXL = 9,
};

enum {
	IORES_MAP_SYSTEM_RAM = 1,
	IORES_MAP_ENCRYPTED = 2,
};

enum {
	IORING_MEM_REGION_REG_WAIT_ARG = 1,
};

enum {
	IORING_MEM_REGION_TYPE_USER = 1,
};

enum {
	IORING_REGISTER_SRC_REGISTERED = 1,
	IORING_REGISTER_DST_REPLACE = 2,
};

enum {
	IORING_REG_WAIT_TS = 1,
};

enum {
	IORING_RSRC_FILE = 0,
	IORING_RSRC_BUFFER = 1,
};

enum {
	IOU_COMPLETE = 0,
	IOU_ISSUE_SKIP_COMPLETE = -529,
	IOU_RETRY = -11,
	IOU_REQUEUE = -3072,
};

enum {
	IOU_F_TWQ_LAZY_WAKE = 1,
};

enum {
	IOU_POLL_DONE = 0,
	IOU_POLL_NO_ACTION = 1,
	IOU_POLL_REMOVE_POLL_USE_RES = 2,
	IOU_POLL_REISSUE = 3,
	IOU_POLL_REQUEUE = 4,
};

enum {
	IO_ACCT_STALLED_BIT = 0,
};

enum {
	IO_APOLL_OK = 0,
	IO_APOLL_ABORTED = 1,
	IO_APOLL_READY = 2,
};

enum {
	IO_CHECK_CQ_OVERFLOW_BIT = 0,
	IO_CHECK_CQ_DROPPED_BIT = 1,
};

enum {
	IO_EVENTFD_OP_SIGNAL_BIT = 0,
};

enum {
	IO_IMU_DEST = 1,
	IO_IMU_SOURCE = 2,
};

enum {
	IO_REGION_F_VMAP = 1,
	IO_REGION_F_USER_PROVIDED = 2,
	IO_REGION_F_SINGLE_REF = 4,
};

enum {
	IO_SQ_THREAD_SHOULD_STOP = 0,
	IO_SQ_THREAD_SHOULD_PARK = 1,
};

enum {
	IO_WORKER_F_UP = 0,
	IO_WORKER_F_RUNNING = 1,
	IO_WORKER_F_FREE = 2,
};

enum {
	IO_WQ_ACCT_BOUND = 0,
	IO_WQ_ACCT_UNBOUND = 1,
	IO_WQ_ACCT_NR = 2,
};

enum {
	IO_WQ_BIT_EXIT = 0,
};

enum {
	IO_WQ_WORK_CANCEL = 1,
	IO_WQ_WORK_HASHED = 2,
	IO_WQ_WORK_UNBOUND = 4,
	IO_WQ_WORK_CONCURRENT = 16,
	IO_WQ_HASH_SHIFT = 24,
};

enum {
	IP6MRA_CREPORT_UNSPEC = 0,
	IP6MRA_CREPORT_MSGTYPE = 1,
	IP6MRA_CREPORT_MIF_ID = 2,
	IP6MRA_CREPORT_SRC_ADDR = 3,
	IP6MRA_CREPORT_DST_ADDR = 4,
	IP6MRA_CREPORT_PKT = 5,
	__IP6MRA_CREPORT_MAX = 6,
};

enum {
	IP6_FH_F_FRAG = 1,
	IP6_FH_F_AUTH = 2,
	IP6_FH_F_SKIP_RH = 4,
};

enum {
	IPMRA_CREPORT_UNSPEC = 0,
	IPMRA_CREPORT_MSGTYPE = 1,
	IPMRA_CREPORT_VIF_ID = 2,
	IPMRA_CREPORT_SRC_ADDR = 3,
	IPMRA_CREPORT_DST_ADDR = 4,
	IPMRA_CREPORT_PKT = 5,
	IPMRA_CREPORT_TABLE = 6,
	__IPMRA_CREPORT_MAX = 7,
};

enum {
	IPMRA_TABLE_UNSPEC = 0,
	IPMRA_TABLE_ID = 1,
	IPMRA_TABLE_CACHE_RES_QUEUE_LEN = 2,
	IPMRA_TABLE_MROUTE_REG_VIF_NUM = 3,
	IPMRA_TABLE_MROUTE_DO_ASSERT = 4,
	IPMRA_TABLE_MROUTE_DO_PIM = 5,
	IPMRA_TABLE_VIFS = 6,
	IPMRA_TABLE_MROUTE_DO_WRVIFWHOLE = 7,
	__IPMRA_TABLE_MAX = 8,
};

enum {
	IPMRA_VIFA_UNSPEC = 0,
	IPMRA_VIFA_IFINDEX = 1,
	IPMRA_VIFA_VIF_ID = 2,
	IPMRA_VIFA_FLAGS = 3,
	IPMRA_VIFA_BYTES_IN = 4,
	IPMRA_VIFA_BYTES_OUT = 5,
	IPMRA_VIFA_PACKETS_IN = 6,
	IPMRA_VIFA_PACKETS_OUT = 7,
	IPMRA_VIFA_LOCAL_ADDR = 8,
	IPMRA_VIFA_REMOTE_ADDR = 9,
	IPMRA_VIFA_PAD = 10,
	__IPMRA_VIFA_MAX = 11,
};

enum {
	IPMRA_VIF_UNSPEC = 0,
	IPMRA_VIF = 1,
	__IPMRA_VIF_MAX = 2,
};

enum {
	IPPROTO_IP = 0,
	IPPROTO_ICMP = 1,
	IPPROTO_IGMP = 2,
	IPPROTO_IPIP = 4,
	IPPROTO_TCP = 6,
	IPPROTO_EGP = 8,
	IPPROTO_PUP = 12,
	IPPROTO_UDP = 17,
	IPPROTO_IDP = 22,
	IPPROTO_TP = 29,
	IPPROTO_DCCP = 33,
	IPPROTO_IPV6 = 41,
	IPPROTO_RSVP = 46,
	IPPROTO_GRE = 47,
	IPPROTO_ESP = 50,
	IPPROTO_AH = 51,
	IPPROTO_MTP = 92,
	IPPROTO_BEETPH = 94,
	IPPROTO_ENCAP = 98,
	IPPROTO_PIM = 103,
	IPPROTO_COMP = 108,
	IPPROTO_L2TP = 115,
	IPPROTO_SCTP = 132,
	IPPROTO_UDPLITE = 136,
	IPPROTO_MPLS = 137,
	IPPROTO_ETHERNET = 143,
	IPPROTO_AGGFRAG = 144,
	IPPROTO_RAW = 255,
	IPPROTO_SMC = 256,
	IPPROTO_MPTCP = 262,
	IPPROTO_MAX = 263,
};

enum {
	IPSTATS_MIB_NUM = 0,
	IPSTATS_MIB_INPKTS = 1,
	IPSTATS_MIB_INOCTETS = 2,
	IPSTATS_MIB_INDELIVERS = 3,
	IPSTATS_MIB_NOECTPKTS = 4,
	IPSTATS_MIB_ECT1PKTS = 5,
	IPSTATS_MIB_ECT0PKTS = 6,
	IPSTATS_MIB_CEPKTS = 7,
	IPSTATS_MIB_OUTREQUESTS = 8,
	IPSTATS_MIB_OUTPKTS = 9,
	IPSTATS_MIB_OUTOCTETS = 10,
	IPSTATS_MIB_OUTFORWDATAGRAMS = 11,
	IPSTATS_MIB_INHDRERRORS = 12,
	IPSTATS_MIB_INTOOBIGERRORS = 13,
	IPSTATS_MIB_INNOROUTES = 14,
	IPSTATS_MIB_INADDRERRORS = 15,
	IPSTATS_MIB_INUNKNOWNPROTOS = 16,
	IPSTATS_MIB_INTRUNCATEDPKTS = 17,
	IPSTATS_MIB_INDISCARDS = 18,
	IPSTATS_MIB_OUTDISCARDS = 19,
	IPSTATS_MIB_OUTNOROUTES = 20,
	IPSTATS_MIB_REASMTIMEOUT = 21,
	IPSTATS_MIB_REASMREQDS = 22,
	IPSTATS_MIB_REASMOKS = 23,
	IPSTATS_MIB_REASMFAILS = 24,
	IPSTATS_MIB_FRAGOKS = 25,
	IPSTATS_MIB_FRAGFAILS = 26,
	IPSTATS_MIB_FRAGCREATES = 27,
	IPSTATS_MIB_INMCASTPKTS = 28,
	IPSTATS_MIB_OUTMCASTPKTS = 29,
	IPSTATS_MIB_INBCASTPKTS = 30,
	IPSTATS_MIB_OUTBCASTPKTS = 31,
	IPSTATS_MIB_INMCASTOCTETS = 32,
	IPSTATS_MIB_OUTMCASTOCTETS = 33,
	IPSTATS_MIB_INBCASTOCTETS = 34,
	IPSTATS_MIB_OUTBCASTOCTETS = 35,
	IPSTATS_MIB_CSUMERRORS = 36,
	IPSTATS_MIB_REASM_OVERLAPS = 37,
	__IPSTATS_MIB_MAX = 38,
};

enum {
	IPV4_DEVCONF_FORWARDING = 1,
	IPV4_DEVCONF_MC_FORWARDING = 2,
	IPV4_DEVCONF_PROXY_ARP = 3,
	IPV4_DEVCONF_ACCEPT_REDIRECTS = 4,
	IPV4_DEVCONF_SECURE_REDIRECTS = 5,
	IPV4_DEVCONF_SEND_REDIRECTS = 6,
	IPV4_DEVCONF_SHARED_MEDIA = 7,
	IPV4_DEVCONF_RP_FILTER = 8,
	IPV4_DEVCONF_ACCEPT_SOURCE_ROUTE = 9,
	IPV4_DEVCONF_BOOTP_RELAY = 10,
	IPV4_DEVCONF_LOG_MARTIANS = 11,
	IPV4_DEVCONF_TAG = 12,
	IPV4_DEVCONF_ARPFILTER = 13,
	IPV4_DEVCONF_MEDIUM_ID = 14,
	IPV4_DEVCONF_NOXFRM = 15,
	IPV4_DEVCONF_NOPOLICY = 16,
	IPV4_DEVCONF_FORCE_IGMP_VERSION = 17,
	IPV4_DEVCONF_ARP_ANNOUNCE = 18,
	IPV4_DEVCONF_ARP_IGNORE = 19,
	IPV4_DEVCONF_PROMOTE_SECONDARIES = 20,
	IPV4_DEVCONF_ARP_ACCEPT = 21,
	IPV4_DEVCONF_ARP_NOTIFY = 22,
	IPV4_DEVCONF_ACCEPT_LOCAL = 23,
	IPV4_DEVCONF_SRC_VMARK = 24,
	IPV4_DEVCONF_PROXY_ARP_PVLAN = 25,
	IPV4_DEVCONF_ROUTE_LOCALNET = 26,
	IPV4_DEVCONF_IGMPV2_UNSOLICITED_REPORT_INTERVAL = 27,
	IPV4_DEVCONF_IGMPV3_UNSOLICITED_REPORT_INTERVAL = 28,
	IPV4_DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 29,
	IPV4_DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 30,
	IPV4_DEVCONF_DROP_GRATUITOUS_ARP = 31,
	IPV4_DEVCONF_BC_FORWARDING = 32,
	IPV4_DEVCONF_ARP_EVICT_NOCARRIER = 33,
	__IPV4_DEVCONF_MAX = 34,
};

enum {
	IPV6_SADDR_RULE_INIT = 0,
	IPV6_SADDR_RULE_LOCAL = 1,
	IPV6_SADDR_RULE_SCOPE = 2,
	IPV6_SADDR_RULE_PREFERRED = 3,
	IPV6_SADDR_RULE_OIF = 4,
	IPV6_SADDR_RULE_LABEL = 5,
	IPV6_SADDR_RULE_PRIVACY = 6,
	IPV6_SADDR_RULE_ORCHID = 7,
	IPV6_SADDR_RULE_PREFIX = 8,
	IPV6_SADDR_RULE_NOT_OPTIMISTIC = 9,
	IPV6_SADDR_RULE_MAX = 10,
};

enum {
	IP_TUNNEL_CSUM_BIT = 0,
	IP_TUNNEL_ROUTING_BIT = 1,
	IP_TUNNEL_KEY_BIT = 2,
	IP_TUNNEL_SEQ_BIT = 3,
	IP_TUNNEL_STRICT_BIT = 4,
	IP_TUNNEL_REC_BIT = 5,
	IP_TUNNEL_VERSION_BIT = 6,
	IP_TUNNEL_NO_KEY_BIT = 7,
	IP_TUNNEL_DONT_FRAGMENT_BIT = 8,
	IP_TUNNEL_OAM_BIT = 9,
	IP_TUNNEL_CRIT_OPT_BIT = 10,
	IP_TUNNEL_GENEVE_OPT_BIT = 11,
	IP_TUNNEL_VXLAN_OPT_BIT = 12,
	IP_TUNNEL_NOCACHE_BIT = 13,
	IP_TUNNEL_ERSPAN_OPT_BIT = 14,
	IP_TUNNEL_GTP_OPT_BIT = 15,
	IP_TUNNEL_VTI_BIT = 16,
	IP_TUNNEL_SIT_ISATAP_BIT = 16,
	IP_TUNNEL_PFCP_OPT_BIT = 17,
	__IP_TUNNEL_FLAG_NUM = 18,
};

enum {
	IRQCHIP_FWNODE_REAL = 0,
	IRQCHIP_FWNODE_NAMED = 1,
	IRQCHIP_FWNODE_NAMED_ID = 2,
};

enum {
	IRQCHIP_SET_TYPE_MASKED = 1,
	IRQCHIP_EOI_IF_HANDLED = 2,
	IRQCHIP_MASK_ON_SUSPEND = 4,
	IRQCHIP_ONOFFLINE_ENABLED = 8,
	IRQCHIP_SKIP_SET_WAKE = 16,
	IRQCHIP_ONESHOT_SAFE = 32,
	IRQCHIP_EOI_THREADED = 64,
	IRQCHIP_SUPPORTS_LEVEL_MSI = 128,
	IRQCHIP_SUPPORTS_NMI = 256,
	IRQCHIP_ENABLE_WAKEUP_ON_SUSPEND = 512,
	IRQCHIP_AFFINITY_PRE_STARTUP = 1024,
	IRQCHIP_IMMUTABLE = 2048,
	IRQCHIP_MOVE_DEFERRED = 4096,
};

enum {
	IRQC_IS_HARDIRQ = 0,
	IRQC_IS_NESTED = 1,
};

enum {
	IRQD_TRIGGER_MASK = 15,
	IRQD_SETAFFINITY_PENDING = 256,
	IRQD_ACTIVATED = 512,
	IRQD_NO_BALANCING = 1024,
	IRQD_PER_CPU = 2048,
	IRQD_AFFINITY_SET = 4096,
	IRQD_LEVEL = 8192,
	IRQD_WAKEUP_STATE = 16384,
	IRQD_IRQ_DISABLED = 65536,
	IRQD_IRQ_MASKED = 131072,
	IRQD_IRQ_INPROGRESS = 262144,
	IRQD_WAKEUP_ARMED = 524288,
	IRQD_FORWARDED_TO_VCPU = 1048576,
	IRQD_AFFINITY_MANAGED = 2097152,
	IRQD_IRQ_STARTED = 4194304,
	IRQD_MANAGED_SHUTDOWN = 8388608,
	IRQD_SINGLE_TARGET = 16777216,
	IRQD_DEFAULT_TRIGGER_SET = 33554432,
	IRQD_CAN_RESERVE = 67108864,
	IRQD_HANDLE_ENFORCE_IRQCTX = 134217728,
	IRQD_AFFINITY_ON_ACTIVATE = 268435456,
	IRQD_IRQ_ENABLED_ON_SUSPEND = 536870912,
	IRQD_RESEND_WHEN_IN_PROGRESS = 1073741824,
};

enum {
	IRQS_AUTODETECT = 1,
	IRQS_SPURIOUS_DISABLED = 2,
	IRQS_POLL_INPROGRESS = 8,
	IRQS_ONESHOT = 32,
	IRQS_REPLAY = 64,
	IRQS_WAITING = 128,
	IRQS_PENDING = 512,
	IRQS_SUSPENDED = 2048,
	IRQS_TIMINGS = 4096,
	IRQS_NMI = 8192,
	IRQS_SYSFS = 16384,
};

enum {
	IRQTF_RUNTHREAD = 0,
	IRQTF_WARNED = 1,
	IRQTF_AFFINITY = 2,
	IRQTF_FORCED_THREAD = 3,
	IRQTF_READY = 4,
};

enum {
	IRQ_DOMAIN_FLAG_HIERARCHY = 1,
	IRQ_DOMAIN_NAME_ALLOCATED = 2,
	IRQ_DOMAIN_FLAG_IPI_PER_CPU = 4,
	IRQ_DOMAIN_FLAG_IPI_SINGLE = 8,
	IRQ_DOMAIN_FLAG_MSI = 16,
	IRQ_DOMAIN_FLAG_ISOLATED_MSI = 32,
	IRQ_DOMAIN_FLAG_NO_MAP = 64,
	IRQ_DOMAIN_FLAG_MSI_PARENT = 256,
	IRQ_DOMAIN_FLAG_MSI_DEVICE = 512,
	IRQ_DOMAIN_FLAG_DESTROY_GC = 1024,
	IRQ_DOMAIN_FLAG_MSI_IMMUTABLE = 2048,
	IRQ_DOMAIN_FLAG_FWNODE_PARENT = 4096,
	IRQ_DOMAIN_FLAG_NONCORE = 65536,
};

enum {
	IRQ_POLL_F_SCHED = 0,
	IRQ_POLL_F_DISABLE = 1,
};

enum {
	IRQ_REMAP_XAPIC_MODE = 0,
	IRQ_REMAP_X2APIC_MODE = 1,
};

enum {
	IRQ_SET_MASK_OK = 0,
	IRQ_SET_MASK_OK_NOCOPY = 1,
	IRQ_SET_MASK_OK_DONE = 2,
};

enum {
	IRQ_STARTUP_NORMAL = 0,
	IRQ_STARTUP_MANAGED = 1,
	IRQ_STARTUP_ABORT = 2,
};

enum {
	IRQ_TYPE_NONE = 0,
	IRQ_TYPE_EDGE_RISING = 1,
	IRQ_TYPE_EDGE_FALLING = 2,
	IRQ_TYPE_EDGE_BOTH = 3,
	IRQ_TYPE_LEVEL_HIGH = 4,
	IRQ_TYPE_LEVEL_LOW = 8,
	IRQ_TYPE_LEVEL_MASK = 12,
	IRQ_TYPE_SENSE_MASK = 15,
	IRQ_TYPE_DEFAULT = 15,
	IRQ_TYPE_PROBE = 16,
	IRQ_LEVEL = 256,
	IRQ_PER_CPU = 512,
	IRQ_NOPROBE = 1024,
	IRQ_NOREQUEST = 2048,
	IRQ_NOAUTOEN = 4096,
	IRQ_NO_BALANCING = 8192,
	IRQ_NESTED_THREAD = 32768,
	IRQ_NOTHREAD = 65536,
	IRQ_PER_CPU_DEVID = 131072,
	IRQ_IS_POLLED = 262144,
	IRQ_DISABLE_UNLAZY = 524288,
	IRQ_HIDDEN = 1048576,
	IRQ_NO_DEBUG = 2097152,
};

enum {
	I_LCOEF_RBPS = 0,
	I_LCOEF_RSEQIOPS = 1,
	I_LCOEF_RRANDIOPS = 2,
	I_LCOEF_WBPS = 3,
	I_LCOEF_WSEQIOPS = 4,
	I_LCOEF_WRANDIOPS = 5,
	NR_I_LCOEFS = 6,
};

enum {
	KBUF_MODE_EXPAND = 1,
	KBUF_MODE_FREE = 2,
};

enum {
	KERNEL_PARAM_FL_UNSAFE = 1,
	KERNEL_PARAM_FL_HWPARAM = 2,
};

enum {
	KERNEL_PARAM_OPS_FL_NOARG = 1,
};

enum {
	KF_ARG_DYNPTR_ID = 0,
	KF_ARG_LIST_HEAD_ID = 1,
	KF_ARG_LIST_NODE_ID = 2,
	KF_ARG_RB_ROOT_ID = 3,
	KF_ARG_RB_NODE_ID = 4,
	KF_ARG_WORKQUEUE_ID = 5,
	KF_ARG_RES_SPIN_LOCK_ID = 6,
};

enum {
	KTW_FREEZABLE = 1,
};

enum {
	KYBER_ASYNC_PERCENT = 75,
};

enum {
	KYBER_LATENCY_SHIFT = 2,
	KYBER_GOOD_BUCKETS = 4,
	KYBER_LATENCY_BUCKETS = 8,
};

enum {
	KYBER_READ = 0,
	KYBER_WRITE = 1,
	KYBER_DISCARD = 2,
	KYBER_OTHER = 3,
	KYBER_NUM_DOMAINS = 4,
};

enum {
	KYBER_TOTAL_LATENCY = 0,
	KYBER_IO_LATENCY = 1,
};

enum {
	LAST_NORM = 0,
	LAST_ROOT = 1,
	LAST_DOT = 2,
	LAST_DOTDOT = 3,
};

enum {
	LAT_OK = 1,
	LAT_UNKNOWN = 2,
	LAT_UNKNOWN_WRITES = 3,
	LAT_EXCEEDED = 4,
};

enum {
	LBR_FORMAT_32 = 0,
	LBR_FORMAT_LIP = 1,
	LBR_FORMAT_EIP = 2,
	LBR_FORMAT_EIP_FLAGS = 3,
	LBR_FORMAT_EIP_FLAGS2 = 4,
	LBR_FORMAT_INFO = 5,
	LBR_FORMAT_TIME = 6,
	LBR_FORMAT_INFO2 = 7,
	LBR_FORMAT_MAX_KNOWN = 7,
};

enum {
	LBR_NONE = 0,
	LBR_VALID = 1,
};

enum {
	LCOEF_RPAGE = 0,
	LCOEF_RSEQIO = 1,
	LCOEF_RRANDIO = 2,
	LCOEF_WPAGE = 3,
	LCOEF_WSEQIO = 4,
	LCOEF_WRANDIO = 5,
	NR_LCOEFS = 6,
};

enum {
	LIBATA_MAX_PRD = 128,
	LIBATA_DUMB_MAX_PRD = 64,
	ATA_DEF_QUEUE = 1,
	ATA_MAX_QUEUE = 32,
	ATA_TAG_INTERNAL = 32,
	ATA_SHORT_PAUSE = 16,
	ATAPI_MAX_DRAIN = 16384,
	ATA_ALL_DEVICES = 3,
	ATA_SHT_EMULATED = 1,
	ATA_SHT_THIS_ID = -1,
	ATA_TFLAG_LBA48 = 1,
	ATA_TFLAG_ISADDR = 2,
	ATA_TFLAG_DEVICE = 4,
	ATA_TFLAG_WRITE = 8,
	ATA_TFLAG_LBA = 16,
	ATA_TFLAG_FUA = 32,
	ATA_TFLAG_POLLING = 64,
	ATA_DFLAG_LBA = 1,
	ATA_DFLAG_LBA48 = 2,
	ATA_DFLAG_CDB_INTR = 4,
	ATA_DFLAG_NCQ = 8,
	ATA_DFLAG_FLUSH_EXT = 16,
	ATA_DFLAG_ACPI_PENDING = 32,
	ATA_DFLAG_ACPI_FAILED = 64,
	ATA_DFLAG_AN = 128,
	ATA_DFLAG_TRUSTED = 256,
	ATA_DFLAG_FUA = 512,
	ATA_DFLAG_DMADIR = 1024,
	ATA_DFLAG_NCQ_SEND_RECV = 2048,
	ATA_DFLAG_NCQ_PRIO = 4096,
	ATA_DFLAG_CDL = 8192,
	ATA_DFLAG_CFG_MASK = 16383,
	ATA_DFLAG_PIO = 16384,
	ATA_DFLAG_NCQ_OFF = 32768,
	ATA_DFLAG_SLEEPING = 65536,
	ATA_DFLAG_DUBIOUS_XFER = 131072,
	ATA_DFLAG_NO_UNLOAD = 262144,
	ATA_DFLAG_UNLOCK_HPA = 524288,
	ATA_DFLAG_INIT_MASK = 1048575,
	ATA_DFLAG_NCQ_PRIO_ENABLED = 1048576,
	ATA_DFLAG_CDL_ENABLED = 2097152,
	ATA_DFLAG_RESUMING = 4194304,
	ATA_DFLAG_DETACH = 16777216,
	ATA_DFLAG_DETACHED = 33554432,
	ATA_DFLAG_DA = 67108864,
	ATA_DFLAG_DEVSLP = 134217728,
	ATA_DFLAG_ACPI_DISABLED = 268435456,
	ATA_DFLAG_D_SENSE = 536870912,
	ATA_DFLAG_FEATURES_MASK = 201341696,
	ATA_DEV_UNKNOWN = 0,
	ATA_DEV_ATA = 1,
	ATA_DEV_ATA_UNSUP = 2,
	ATA_DEV_ATAPI = 3,
	ATA_DEV_ATAPI_UNSUP = 4,
	ATA_DEV_PMP = 5,
	ATA_DEV_PMP_UNSUP = 6,
	ATA_DEV_SEMB = 7,
	ATA_DEV_SEMB_UNSUP = 8,
	ATA_DEV_ZAC = 9,
	ATA_DEV_ZAC_UNSUP = 10,
	ATA_DEV_NONE = 11,
	ATA_LFLAG_NO_HRST = 2,
	ATA_LFLAG_NO_SRST = 4,
	ATA_LFLAG_ASSUME_ATA = 8,
	ATA_LFLAG_ASSUME_SEMB = 16,
	ATA_LFLAG_ASSUME_CLASS = 24,
	ATA_LFLAG_NO_RETRY = 32,
	ATA_LFLAG_DISABLED = 64,
	ATA_LFLAG_SW_ACTIVITY = 128,
	ATA_LFLAG_NO_LPM = 256,
	ATA_LFLAG_RST_ONCE = 512,
	ATA_LFLAG_CHANGED = 1024,
	ATA_LFLAG_NO_DEBOUNCE_DELAY = 2048,
	ATA_FLAG_SLAVE_POSS = 1,
	ATA_FLAG_SATA = 2,
	ATA_FLAG_NO_LPM = 4,
	ATA_FLAG_NO_LOG_PAGE = 32,
	ATA_FLAG_NO_ATAPI = 64,
	ATA_FLAG_PIO_DMA = 128,
	ATA_FLAG_PIO_LBA48 = 256,
	ATA_FLAG_PIO_POLLING = 512,
	ATA_FLAG_NCQ = 1024,
	ATA_FLAG_NO_POWEROFF_SPINDOWN = 2048,
	ATA_FLAG_NO_HIBERNATE_SPINDOWN = 4096,
	ATA_FLAG_DEBUGMSG = 8192,
	ATA_FLAG_FPDMA_AA = 16384,
	ATA_FLAG_IGN_SIMPLEX = 32768,
	ATA_FLAG_NO_IORDY = 65536,
	ATA_FLAG_ACPI_SATA = 131072,
	ATA_FLAG_AN = 262144,
	ATA_FLAG_PMP = 524288,
	ATA_FLAG_FPDMA_AUX = 1048576,
	ATA_FLAG_EM = 2097152,
	ATA_FLAG_SW_ACTIVITY = 4194304,
	ATA_FLAG_NO_DIPM = 8388608,
	ATA_FLAG_SAS_HOST = 16777216,
	ATA_PFLAG_EH_PENDING = 1,
	ATA_PFLAG_EH_IN_PROGRESS = 2,
	ATA_PFLAG_FROZEN = 4,
	ATA_PFLAG_RECOVERED = 8,
	ATA_PFLAG_LOADING = 16,
	ATA_PFLAG_SCSI_HOTPLUG = 64,
	ATA_PFLAG_INITIALIZING = 128,
	ATA_PFLAG_RESETTING = 256,
	ATA_PFLAG_UNLOADING = 512,
	ATA_PFLAG_UNLOADED = 1024,
	ATA_PFLAG_RESUMING = 65536,
	ATA_PFLAG_SUSPENDED = 131072,
	ATA_PFLAG_PM_PENDING = 262144,
	ATA_PFLAG_INIT_GTM_VALID = 524288,
	ATA_PFLAG_PIO32 = 1048576,
	ATA_PFLAG_PIO32CHANGE = 2097152,
	ATA_PFLAG_EXTERNAL = 4194304,
	ATA_QCFLAG_ACTIVE = 1,
	ATA_QCFLAG_DMAMAP = 2,
	ATA_QCFLAG_RTF_FILLED = 4,
	ATA_QCFLAG_IO = 8,
	ATA_QCFLAG_RESULT_TF = 16,
	ATA_QCFLAG_CLEAR_EXCL = 32,
	ATA_QCFLAG_QUIET = 64,
	ATA_QCFLAG_RETRY = 128,
	ATA_QCFLAG_HAS_CDL = 256,
	ATA_QCFLAG_EH = 65536,
	ATA_QCFLAG_SENSE_VALID = 131072,
	ATA_QCFLAG_EH_SCHEDULED = 262144,
	ATA_QCFLAG_EH_SUCCESS_CMD = 524288,
	ATA_HOST_SIMPLEX = 1,
	ATA_HOST_STARTED = 2,
	ATA_HOST_PARALLEL_SCAN = 4,
	ATA_HOST_IGNORE_ATA = 8,
	ATA_HOST_NO_PART = 16,
	ATA_HOST_NO_SSC = 32,
	ATA_HOST_NO_DEVSLP = 64,
	ATA_TMOUT_INTERNAL_QUICK = 5000,
	ATA_TMOUT_MAX_PARK = 30000,
	ATA_TMOUT_FF_WAIT_LONG = 2000,
	ATA_TMOUT_FF_WAIT = 800,
	ATA_WAIT_AFTER_RESET = 150,
	ATA_TMOUT_PMP_SRST_WAIT = 10000,
	ATA_TMOUT_SPURIOUS_PHY = 10000,
	BUS_UNKNOWN = 0,
	BUS_DMA = 1,
	BUS_IDLE = 2,
	BUS_NOINTR = 3,
	BUS_NODATA = 4,
	BUS_TIMER = 5,
	BUS_PIO = 6,
	BUS_EDD = 7,
	BUS_IDENTIFY = 8,
	BUS_PACKET = 9,
	PORT_UNKNOWN = 0,
	PORT_ENABLED = 1,
	PORT_DISABLED = 2,
	ATA_NR_PIO_MODES = 7,
	ATA_NR_MWDMA_MODES = 5,
	ATA_NR_UDMA_MODES = 8,
	ATA_SHIFT_PIO = 0,
	ATA_SHIFT_MWDMA = 7,
	ATA_SHIFT_UDMA = 12,
	ATA_SHIFT_PRIO = 6,
	ATA_PRIO_HIGH = 2,
	ATA_DMA_PAD_SZ = 4,
	ATA_ERING_SIZE = 32,
	ATA_DEFER_LINK = 1,
	ATA_DEFER_PORT = 2,
	ATA_EH_DESC_LEN = 80,
	ATA_EH_REVALIDATE = 1,
	ATA_EH_SOFTRESET = 2,
	ATA_EH_HARDRESET = 4,
	ATA_EH_RESET = 6,
	ATA_EH_ENABLE_LINK = 8,
	ATA_EH_PARK = 32,
	ATA_EH_GET_SUCCESS_SENSE = 64,
	ATA_EH_SET_ACTIVE = 128,
	ATA_EH_PERDEV_MASK = 225,
	ATA_EH_ALL_ACTIONS = 15,
	ATA_EHI_HOTPLUGGED = 1,
	ATA_EHI_NO_AUTOPSY = 4,
	ATA_EHI_QUIET = 8,
	ATA_EHI_NO_RECOVERY = 16,
	ATA_EHI_DID_SOFTRESET = 65536,
	ATA_EHI_DID_HARDRESET = 131072,
	ATA_EHI_PRINTINFO = 262144,
	ATA_EHI_SETMODE = 524288,
	ATA_EHI_POST_SETMODE = 1048576,
	ATA_EHI_DID_PRINT_QUIRKS = 2097152,
	ATA_EHI_DID_RESET = 196608,
	ATA_EHI_TO_SLAVE_MASK = 12,
	ATA_EH_MAX_TRIES = 5,
	ATA_LINK_RESUME_TRIES = 5,
	ATA_EH_DEV_TRIES = 3,
	ATA_EH_PMP_TRIES = 5,
	ATA_EH_PMP_LINK_TRIES = 3,
	SATA_PMP_RW_TIMEOUT = 3000,
	ATA_EH_CMD_TIMEOUT_TABLE_SIZE = 8,
	ATA_QUIRK_DIAGNOSTIC = 1,
	ATA_QUIRK_NODMA = 2,
	ATA_QUIRK_NONCQ = 4,
	ATA_QUIRK_MAX_SEC_128 = 8,
	ATA_QUIRK_BROKEN_HPA = 16,
	ATA_QUIRK_DISABLE = 32,
	ATA_QUIRK_HPA_SIZE = 64,
	ATA_QUIRK_IVB = 128,
	ATA_QUIRK_STUCK_ERR = 256,
	ATA_QUIRK_BRIDGE_OK = 512,
	ATA_QUIRK_ATAPI_MOD16_DMA = 1024,
	ATA_QUIRK_FIRMWARE_WARN = 2048,
	ATA_QUIRK_1_5_GBPS = 4096,
	ATA_QUIRK_NOSETXFER = 8192,
	ATA_QUIRK_BROKEN_FPDMA_AA = 16384,
	ATA_QUIRK_DUMP_ID = 32768,
	ATA_QUIRK_MAX_SEC_LBA48 = 65536,
	ATA_QUIRK_ATAPI_DMADIR = 131072,
	ATA_QUIRK_NO_NCQ_TRIM = 262144,
	ATA_QUIRK_NOLPM = 524288,
	ATA_QUIRK_WD_BROKEN_LPM = 1048576,
	ATA_QUIRK_ZERO_AFTER_TRIM = 2097152,
	ATA_QUIRK_NO_DMA_LOG = 4194304,
	ATA_QUIRK_NOTRIM = 8388608,
	ATA_QUIRK_MAX_SEC_1024 = 16777216,
	ATA_QUIRK_MAX_TRIM_128M = 33554432,
	ATA_QUIRK_NO_NCQ_ON_ATI = 67108864,
	ATA_QUIRK_NO_LPM_ON_ATI = 134217728,
	ATA_QUIRK_NO_ID_DEV_LOG = 268435456,
	ATA_QUIRK_NO_LOG_DIR = 536870912,
	ATA_QUIRK_NO_FUA = 1073741824,
	ATA_DMA_MASK_ATA = 1,
	ATA_DMA_MASK_ATAPI = 2,
	ATA_DMA_MASK_CFA = 4,
	ATAPI_READ = 0,
	ATAPI_WRITE = 1,
	ATAPI_READ_CD = 2,
	ATAPI_PASS_THRU = 3,
	ATAPI_MISC = 4,
	ATA_TIMING_SETUP = 1,
	ATA_TIMING_ACT8B = 2,
	ATA_TIMING_REC8B = 4,
	ATA_TIMING_CYC8B = 8,
	ATA_TIMING_8BIT = 14,
	ATA_TIMING_ACTIVE = 16,
	ATA_TIMING_RECOVER = 32,
	ATA_TIMING_DMACK_HOLD = 64,
	ATA_TIMING_CYCLE = 128,
	ATA_TIMING_UDMA = 256,
	ATA_TIMING_ALL = 511,
	ATA_ACPI_FILTER_SETXFER = 1,
	ATA_ACPI_FILTER_LOCK = 2,
	ATA_ACPI_FILTER_DIPM = 4,
	ATA_ACPI_FILTER_FPDMA_OFFSET = 8,
	ATA_ACPI_FILTER_FPDMA_AA = 16,
	ATA_ACPI_FILTER_DEFAULT = 7,
};

enum {
	LINUX_MIB_NUM = 0,
	LINUX_MIB_SYNCOOKIESSENT = 1,
	LINUX_MIB_SYNCOOKIESRECV = 2,
	LINUX_MIB_SYNCOOKIESFAILED = 3,
	LINUX_MIB_EMBRYONICRSTS = 4,
	LINUX_MIB_PRUNECALLED = 5,
	LINUX_MIB_RCVPRUNED = 6,
	LINUX_MIB_OFOPRUNED = 7,
	LINUX_MIB_OUTOFWINDOWICMPS = 8,
	LINUX_MIB_LOCKDROPPEDICMPS = 9,
	LINUX_MIB_ARPFILTER = 10,
	LINUX_MIB_TIMEWAITED = 11,
	LINUX_MIB_TIMEWAITRECYCLED = 12,
	LINUX_MIB_TIMEWAITKILLED = 13,
	LINUX_MIB_PAWSACTIVEREJECTED = 14,
	LINUX_MIB_PAWSESTABREJECTED = 15,
	LINUX_MIB_BEYOND_WINDOW = 16,
	LINUX_MIB_TSECRREJECTED = 17,
	LINUX_MIB_PAWS_OLD_ACK = 18,
	LINUX_MIB_PAWS_TW_REJECTED = 19,
	LINUX_MIB_DELAYEDACKS = 20,
	LINUX_MIB_DELAYEDACKLOCKED = 21,
	LINUX_MIB_DELAYEDACKLOST = 22,
	LINUX_MIB_LISTENOVERFLOWS = 23,
	LINUX_MIB_LISTENDROPS = 24,
	LINUX_MIB_TCPHPHITS = 25,
	LINUX_MIB_TCPPUREACKS = 26,
	LINUX_MIB_TCPHPACKS = 27,
	LINUX_MIB_TCPRENORECOVERY = 28,
	LINUX_MIB_TCPSACKRECOVERY = 29,
	LINUX_MIB_TCPSACKRENEGING = 30,
	LINUX_MIB_TCPSACKREORDER = 31,
	LINUX_MIB_TCPRENOREORDER = 32,
	LINUX_MIB_TCPTSREORDER = 33,
	LINUX_MIB_TCPFULLUNDO = 34,
	LINUX_MIB_TCPPARTIALUNDO = 35,
	LINUX_MIB_TCPDSACKUNDO = 36,
	LINUX_MIB_TCPLOSSUNDO = 37,
	LINUX_MIB_TCPLOSTRETRANSMIT = 38,
	LINUX_MIB_TCPRENOFAILURES = 39,
	LINUX_MIB_TCPSACKFAILURES = 40,
	LINUX_MIB_TCPLOSSFAILURES = 41,
	LINUX_MIB_TCPFASTRETRANS = 42,
	LINUX_MIB_TCPSLOWSTARTRETRANS = 43,
	LINUX_MIB_TCPTIMEOUTS = 44,
	LINUX_MIB_TCPLOSSPROBES = 45,
	LINUX_MIB_TCPLOSSPROBERECOVERY = 46,
	LINUX_MIB_TCPRENORECOVERYFAIL = 47,
	LINUX_MIB_TCPSACKRECOVERYFAIL = 48,
	LINUX_MIB_TCPRCVCOLLAPSED = 49,
	LINUX_MIB_TCPDSACKOLDSENT = 50,
	LINUX_MIB_TCPDSACKOFOSENT = 51,
	LINUX_MIB_TCPDSACKRECV = 52,
	LINUX_MIB_TCPDSACKOFORECV = 53,
	LINUX_MIB_TCPABORTONDATA = 54,
	LINUX_MIB_TCPABORTONCLOSE = 55,
	LINUX_MIB_TCPABORTONMEMORY = 56,
	LINUX_MIB_TCPABORTONTIMEOUT = 57,
	LINUX_MIB_TCPABORTONLINGER = 58,
	LINUX_MIB_TCPABORTFAILED = 59,
	LINUX_MIB_TCPMEMORYPRESSURES = 60,
	LINUX_MIB_TCPMEMORYPRESSURESCHRONO = 61,
	LINUX_MIB_TCPSACKDISCARD = 62,
	LINUX_MIB_TCPDSACKIGNOREDOLD = 63,
	LINUX_MIB_TCPDSACKIGNOREDNOUNDO = 64,
	LINUX_MIB_TCPSPURIOUSRTOS = 65,
	LINUX_MIB_TCPMD5NOTFOUND = 66,
	LINUX_MIB_TCPMD5UNEXPECTED = 67,
	LINUX_MIB_TCPMD5FAILURE = 68,
	LINUX_MIB_SACKSHIFTED = 69,
	LINUX_MIB_SACKMERGED = 70,
	LINUX_MIB_SACKSHIFTFALLBACK = 71,
	LINUX_MIB_TCPBACKLOGDROP = 72,
	LINUX_MIB_PFMEMALLOCDROP = 73,
	LINUX_MIB_TCPMINTTLDROP = 74,
	LINUX_MIB_TCPDEFERACCEPTDROP = 75,
	LINUX_MIB_IPRPFILTER = 76,
	LINUX_MIB_TCPTIMEWAITOVERFLOW = 77,
	LINUX_MIB_TCPREQQFULLDOCOOKIES = 78,
	LINUX_MIB_TCPREQQFULLDROP = 79,
	LINUX_MIB_TCPRETRANSFAIL = 80,
	LINUX_MIB_TCPRCVCOALESCE = 81,
	LINUX_MIB_TCPBACKLOGCOALESCE = 82,
	LINUX_MIB_TCPOFOQUEUE = 83,
	LINUX_MIB_TCPOFODROP = 84,
	LINUX_MIB_TCPOFOMERGE = 85,
	LINUX_MIB_TCPCHALLENGEACK = 86,
	LINUX_MIB_TCPSYNCHALLENGE = 87,
	LINUX_MIB_TCPFASTOPENACTIVE = 88,
	LINUX_MIB_TCPFASTOPENACTIVEFAIL = 89,
	LINUX_MIB_TCPFASTOPENPASSIVE = 90,
	LINUX_MIB_TCPFASTOPENPASSIVEFAIL = 91,
	LINUX_MIB_TCPFASTOPENLISTENOVERFLOW = 92,
	LINUX_MIB_TCPFASTOPENCOOKIEREQD = 93,
	LINUX_MIB_TCPFASTOPENBLACKHOLE = 94,
	LINUX_MIB_TCPSPURIOUS_RTX_HOSTQUEUES = 95,
	LINUX_MIB_BUSYPOLLRXPACKETS = 96,
	LINUX_MIB_TCPAUTOCORKING = 97,
	LINUX_MIB_TCPFROMZEROWINDOWADV = 98,
	LINUX_MIB_TCPTOZEROWINDOWADV = 99,
	LINUX_MIB_TCPWANTZEROWINDOWADV = 100,
	LINUX_MIB_TCPSYNRETRANS = 101,
	LINUX_MIB_TCPORIGDATASENT = 102,
	LINUX_MIB_TCPHYSTARTTRAINDETECT = 103,
	LINUX_MIB_TCPHYSTARTTRAINCWND = 104,
	LINUX_MIB_TCPHYSTARTDELAYDETECT = 105,
	LINUX_MIB_TCPHYSTARTDELAYCWND = 106,
	LINUX_MIB_TCPACKSKIPPEDSYNRECV = 107,
	LINUX_MIB_TCPACKSKIPPEDPAWS = 108,
	LINUX_MIB_TCPACKSKIPPEDSEQ = 109,
	LINUX_MIB_TCPACKSKIPPEDFINWAIT2 = 110,
	LINUX_MIB_TCPACKSKIPPEDTIMEWAIT = 111,
	LINUX_MIB_TCPACKSKIPPEDCHALLENGE = 112,
	LINUX_MIB_TCPWINPROBE = 113,
	LINUX_MIB_TCPKEEPALIVE = 114,
	LINUX_MIB_TCPMTUPFAIL = 115,
	LINUX_MIB_TCPMTUPSUCCESS = 116,
	LINUX_MIB_TCPDELIVERED = 117,
	LINUX_MIB_TCPDELIVEREDCE = 118,
	LINUX_MIB_TCPACKCOMPRESSED = 119,
	LINUX_MIB_TCPZEROWINDOWDROP = 120,
	LINUX_MIB_TCPRCVQDROP = 121,
	LINUX_MIB_TCPWQUEUETOOBIG = 122,
	LINUX_MIB_TCPFASTOPENPASSIVEALTKEY = 123,
	LINUX_MIB_TCPTIMEOUTREHASH = 124,
	LINUX_MIB_TCPDUPLICATEDATAREHASH = 125,
	LINUX_MIB_TCPDSACKRECVSEGS = 126,
	LINUX_MIB_TCPDSACKIGNOREDDUBIOUS = 127,
	LINUX_MIB_TCPMIGRATEREQSUCCESS = 128,
	LINUX_MIB_TCPMIGRATEREQFAILURE = 129,
	LINUX_MIB_TCPPLBREHASH = 130,
	LINUX_MIB_TCPAOREQUIRED = 131,
	LINUX_MIB_TCPAOBAD = 132,
	LINUX_MIB_TCPAOKEYNOTFOUND = 133,
	LINUX_MIB_TCPAOGOOD = 134,
	LINUX_MIB_TCPAODROPPEDICMPS = 135,
	__LINUX_MIB_MAX = 136,
};

enum {
	LINUX_MIB_TLSNUM = 0,
	LINUX_MIB_TLSCURRTXSW = 1,
	LINUX_MIB_TLSCURRRXSW = 2,
	LINUX_MIB_TLSCURRTXDEVICE = 3,
	LINUX_MIB_TLSCURRRXDEVICE = 4,
	LINUX_MIB_TLSTXSW = 5,
	LINUX_MIB_TLSRXSW = 6,
	LINUX_MIB_TLSTXDEVICE = 7,
	LINUX_MIB_TLSRXDEVICE = 8,
	LINUX_MIB_TLSDECRYPTERROR = 9,
	LINUX_MIB_TLSRXDEVICERESYNC = 10,
	LINUX_MIB_TLSDECRYPTRETRY = 11,
	LINUX_MIB_TLSRXNOPADVIOL = 12,
	LINUX_MIB_TLSRXREKEYOK = 13,
	LINUX_MIB_TLSRXREKEYERROR = 14,
	LINUX_MIB_TLSTXREKEYOK = 15,
	LINUX_MIB_TLSTXREKEYERROR = 16,
	LINUX_MIB_TLSRXREKEYRECEIVED = 17,
	__LINUX_MIB_TLSMAX = 18,
};

enum {
	LINUX_MIB_XFRMNUM = 0,
	LINUX_MIB_XFRMINERROR = 1,
	LINUX_MIB_XFRMINBUFFERERROR = 2,
	LINUX_MIB_XFRMINHDRERROR = 3,
	LINUX_MIB_XFRMINNOSTATES = 4,
	LINUX_MIB_XFRMINSTATEPROTOERROR = 5,
	LINUX_MIB_XFRMINSTATEMODEERROR = 6,
	LINUX_MIB_XFRMINSTATESEQERROR = 7,
	LINUX_MIB_XFRMINSTATEEXPIRED = 8,
	LINUX_MIB_XFRMINSTATEMISMATCH = 9,
	LINUX_MIB_XFRMINSTATEINVALID = 10,
	LINUX_MIB_XFRMINTMPLMISMATCH = 11,
	LINUX_MIB_XFRMINNOPOLS = 12,
	LINUX_MIB_XFRMINPOLBLOCK = 13,
	LINUX_MIB_XFRMINPOLERROR = 14,
	LINUX_MIB_XFRMOUTERROR = 15,
	LINUX_MIB_XFRMOUTBUNDLEGENERROR = 16,
	LINUX_MIB_XFRMOUTBUNDLECHECKERROR = 17,
	LINUX_MIB_XFRMOUTNOSTATES = 18,
	LINUX_MIB_XFRMOUTSTATEPROTOERROR = 19,
	LINUX_MIB_XFRMOUTSTATEMODEERROR = 20,
	LINUX_MIB_XFRMOUTSTATESEQERROR = 21,
	LINUX_MIB_XFRMOUTSTATEEXPIRED = 22,
	LINUX_MIB_XFRMOUTPOLBLOCK = 23,
	LINUX_MIB_XFRMOUTPOLDEAD = 24,
	LINUX_MIB_XFRMOUTPOLERROR = 25,
	LINUX_MIB_XFRMFWDHDRERROR = 26,
	LINUX_MIB_XFRMOUTSTATEINVALID = 27,
	LINUX_MIB_XFRMACQUIREERROR = 28,
	LINUX_MIB_XFRMOUTSTATEDIRERROR = 29,
	LINUX_MIB_XFRMINSTATEDIRERROR = 30,
	LINUX_MIB_XFRMINIPTFSERROR = 31,
	LINUX_MIB_XFRMOUTNOQSPACE = 32,
	__LINUX_MIB_XFRMMAX = 33,
};

enum {
	LOGIC_PIO_INDIRECT = 0,
	LOGIC_PIO_CPU_MMIO = 1,
};

enum {
	LRU_GEN_ANON = 0,
	LRU_GEN_FILE = 1,
};

enum {
	LRU_GEN_CORE = 0,
	LRU_GEN_MM_WALK = 1,
	LRU_GEN_NONLEAF_YOUNG = 2,
	NR_LRU_GEN_CAPS = 3,
};

enum {
	LWTUNNEL_IP_OPTS_UNSPEC = 0,
	LWTUNNEL_IP_OPTS_GENEVE = 1,
	LWTUNNEL_IP_OPTS_VXLAN = 2,
	LWTUNNEL_IP_OPTS_ERSPAN = 3,
	__LWTUNNEL_IP_OPTS_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_ERSPAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_ERSPAN_VER = 1,
	LWTUNNEL_IP_OPT_ERSPAN_INDEX = 2,
	LWTUNNEL_IP_OPT_ERSPAN_DIR = 3,
	LWTUNNEL_IP_OPT_ERSPAN_HWID = 4,
	__LWTUNNEL_IP_OPT_ERSPAN_MAX = 5,
};

enum {
	LWTUNNEL_IP_OPT_GENEVE_UNSPEC = 0,
	LWTUNNEL_IP_OPT_GENEVE_CLASS = 1,
	LWTUNNEL_IP_OPT_GENEVE_TYPE = 2,
	LWTUNNEL_IP_OPT_GENEVE_DATA = 3,
	__LWTUNNEL_IP_OPT_GENEVE_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_VXLAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_VXLAN_GBP = 1,
	__LWTUNNEL_IP_OPT_VXLAN_MAX = 2,
};

enum {
	LWTUNNEL_XMIT_DONE = 0,
	LWTUNNEL_XMIT_CONTINUE = 256,
};

enum {
	LWT_BPF_PROG_UNSPEC = 0,
	LWT_BPF_PROG_FD = 1,
	LWT_BPF_PROG_NAME = 2,
	__LWT_BPF_PROG_MAX = 3,
};

enum {
	LWT_BPF_UNSPEC = 0,
	LWT_BPF_IN = 1,
	LWT_BPF_OUT = 2,
	LWT_BPF_XMIT = 3,
	LWT_BPF_XMIT_HEADROOM = 4,
	__LWT_BPF_MAX = 5,
};

enum {
	MATCH_MTR = 0,
	MATCH_MEQ = 1,
	MATCH_MLE = 2,
	MATCH_MLT = 3,
	MATCH_MGE = 4,
	MATCH_MGT = 5,
};

enum {
	MAX8925_IRQ_VCHG_DC_OVP = 0,
	MAX8925_IRQ_VCHG_DC_F = 1,
	MAX8925_IRQ_VCHG_DC_R = 2,
	MAX8925_IRQ_VCHG_THM_OK_R = 3,
	MAX8925_IRQ_VCHG_THM_OK_F = 4,
	MAX8925_IRQ_VCHG_SYSLOW_F = 5,
	MAX8925_IRQ_VCHG_SYSLOW_R = 6,
	MAX8925_IRQ_VCHG_RST = 7,
	MAX8925_IRQ_VCHG_DONE = 8,
	MAX8925_IRQ_VCHG_TOPOFF = 9,
	MAX8925_IRQ_VCHG_TMR_FAULT = 10,
	MAX8925_IRQ_GPM_RSTIN = 11,
	MAX8925_IRQ_GPM_MPL = 12,
	MAX8925_IRQ_GPM_SW_3SEC = 13,
	MAX8925_IRQ_GPM_EXTON_F = 14,
	MAX8925_IRQ_GPM_EXTON_R = 15,
	MAX8925_IRQ_GPM_SW_1SEC = 16,
	MAX8925_IRQ_GPM_SW_F = 17,
	MAX8925_IRQ_GPM_SW_R = 18,
	MAX8925_IRQ_GPM_SYSCKEN_F = 19,
	MAX8925_IRQ_GPM_SYSCKEN_R = 20,
	MAX8925_IRQ_RTC_ALARM1 = 21,
	MAX8925_IRQ_RTC_ALARM0 = 22,
	MAX8925_IRQ_TSC_STICK = 23,
	MAX8925_IRQ_TSC_NSTICK = 24,
	MAX8925_NR_IRQS = 25,
};

enum {
	MAX8998_IRQ_DCINF = 0,
	MAX8998_IRQ_DCINR = 1,
	MAX8998_IRQ_JIGF = 2,
	MAX8998_IRQ_JIGR = 3,
	MAX8998_IRQ_PWRONF = 4,
	MAX8998_IRQ_PWRONR = 5,
	MAX8998_IRQ_WTSREVNT = 6,
	MAX8998_IRQ_SMPLEVNT = 7,
	MAX8998_IRQ_ALARM1 = 8,
	MAX8998_IRQ_ALARM0 = 9,
	MAX8998_IRQ_ONKEY1S = 10,
	MAX8998_IRQ_TOPOFFR = 11,
	MAX8998_IRQ_DCINOVPR = 12,
	MAX8998_IRQ_CHGRSTF = 13,
	MAX8998_IRQ_DONER = 14,
	MAX8998_IRQ_CHGFAULT = 15,
	MAX8998_IRQ_LOBAT1 = 16,
	MAX8998_IRQ_LOBAT2 = 17,
	MAX8998_IRQ_NR = 18,
};

enum {
	MAX8998_REG_IRQ1 = 0,
	MAX8998_REG_IRQ2 = 1,
	MAX8998_REG_IRQ3 = 2,
	MAX8998_REG_IRQ4 = 3,
	MAX8998_REG_IRQM1 = 4,
	MAX8998_REG_IRQM2 = 5,
	MAX8998_REG_IRQM3 = 6,
	MAX8998_REG_IRQM4 = 7,
	MAX8998_REG_STATUS1 = 8,
	MAX8998_REG_STATUS2 = 9,
	MAX8998_REG_STATUSM1 = 10,
	MAX8998_REG_STATUSM2 = 11,
	MAX8998_REG_CHGR1 = 12,
	MAX8998_REG_CHGR2 = 13,
	MAX8998_REG_LDO_ACTIVE_DISCHARGE1 = 14,
	MAX8998_REG_LDO_ACTIVE_DISCHARGE2 = 15,
	MAX8998_REG_BUCK_ACTIVE_DISCHARGE3 = 16,
	MAX8998_REG_ONOFF1 = 17,
	MAX8998_REG_ONOFF2 = 18,
	MAX8998_REG_ONOFF3 = 19,
	MAX8998_REG_ONOFF4 = 20,
	MAX8998_REG_BUCK1_VOLTAGE1 = 21,
	MAX8998_REG_BUCK1_VOLTAGE2 = 22,
	MAX8998_REG_BUCK1_VOLTAGE3 = 23,
	MAX8998_REG_BUCK1_VOLTAGE4 = 24,
	MAX8998_REG_BUCK2_VOLTAGE1 = 25,
	MAX8998_REG_BUCK2_VOLTAGE2 = 26,
	MAX8998_REG_BUCK3 = 27,
	MAX8998_REG_BUCK4 = 28,
	MAX8998_REG_LDO2_LDO3 = 29,
	MAX8998_REG_LDO4 = 30,
	MAX8998_REG_LDO5 = 31,
	MAX8998_REG_LDO6 = 32,
	MAX8998_REG_LDO7 = 33,
	MAX8998_REG_LDO8_LDO9 = 34,
	MAX8998_REG_LDO10_LDO11 = 35,
	MAX8998_REG_LDO12 = 36,
	MAX8998_REG_LDO13 = 37,
	MAX8998_REG_LDO14 = 38,
	MAX8998_REG_LDO15 = 39,
	MAX8998_REG_LDO16 = 40,
	MAX8998_REG_LDO17 = 41,
	MAX8998_REG_BKCHR = 42,
	MAX8998_REG_LBCNFG1 = 43,
	MAX8998_REG_LBCNFG2 = 44,
};

enum {
	MAX_IORES_LEVEL = 5,
};

enum {
	MAX_OPT_ARGS = 3,
};

enum {
	MCTP_TRACE_KEY_TIMEOUT = 0,
	MCTP_TRACE_KEY_REPLIED = 1,
	MCTP_TRACE_KEY_INVALIDATED = 2,
	MCTP_TRACE_KEY_CLOSED = 3,
	MCTP_TRACE_KEY_DROPPED = 4,
};

enum {
	MDBA_GET_ENTRY_UNSPEC = 0,
	MDBA_GET_ENTRY = 1,
	MDBA_GET_ENTRY_ATTRS = 2,
	__MDBA_GET_ENTRY_MAX = 3,
};

enum {
	MDBA_SET_ENTRY_UNSPEC = 0,
	MDBA_SET_ENTRY = 1,
	MDBA_SET_ENTRY_ATTRS = 2,
	__MDBA_SET_ENTRY_MAX = 3,
};

enum {
	MEMBARRIER_FLAG_SYNC_CORE = 1,
	MEMBARRIER_FLAG_RSEQ = 2,
};

enum {
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_READY = 1,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED = 2,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED_READY = 4,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED = 8,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE_READY = 16,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ_READY = 64,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ = 128,
};

enum {
	MEMCG_LRU_NOP = 0,
	MEMCG_LRU_HEAD = 1,
	MEMCG_LRU_TAIL = 2,
	MEMCG_LRU_OLD = 3,
	MEMCG_LRU_YOUNG = 4,
};

enum {
	MEMMAP_ON_MEMORY_DISABLE = 0,
	MEMMAP_ON_MEMORY_ENABLE = 1,
	MEMMAP_ON_MEMORY_FORCE = 2,
};

enum {
	MEMORY_RECLAIM_SWAPPINESS = 0,
	MEMORY_RECLAIM_SWAPPINESS_MAX = 1,
	MEMORY_RECLAIM_NULL = 2,
};

enum {
	MEMREMAP_WB = 1,
	MEMREMAP_WT = 2,
	MEMREMAP_WC = 4,
	MEMREMAP_ENC = 8,
	MEMREMAP_DEC = 16,
};

enum {
	MFC_STATIC = 1,
	MFC_OFFLOAD = 2,
};

enum {
	MILLION = 1000000,
	MIN_PERIOD = 1000,
	MAX_PERIOD = 1000000,
	MARGIN_MIN_PCT = 10,
	MARGIN_LOW_PCT = 20,
	MARGIN_TARGET_PCT = 50,
	INUSE_ADJ_STEP_PCT = 25,
	TIMER_SLACK_PCT = 1,
	WEIGHT_ONE = 65536,
};

enum {
	MIPI_DCS_NOP = 0,
	MIPI_DCS_SOFT_RESET = 1,
	MIPI_DCS_GET_COMPRESSION_MODE = 3,
	MIPI_DCS_GET_DISPLAY_ID = 4,
	MIPI_DCS_GET_ERROR_COUNT_ON_DSI = 5,
	MIPI_DCS_GET_RED_CHANNEL = 6,
	MIPI_DCS_GET_GREEN_CHANNEL = 7,
	MIPI_DCS_GET_BLUE_CHANNEL = 8,
	MIPI_DCS_GET_DISPLAY_STATUS = 9,
	MIPI_DCS_GET_POWER_MODE = 10,
	MIPI_DCS_GET_ADDRESS_MODE = 11,
	MIPI_DCS_GET_PIXEL_FORMAT = 12,
	MIPI_DCS_GET_DISPLAY_MODE = 13,
	MIPI_DCS_GET_SIGNAL_MODE = 14,
	MIPI_DCS_GET_DIAGNOSTIC_RESULT = 15,
	MIPI_DCS_ENTER_SLEEP_MODE = 16,
	MIPI_DCS_EXIT_SLEEP_MODE = 17,
	MIPI_DCS_ENTER_PARTIAL_MODE = 18,
	MIPI_DCS_ENTER_NORMAL_MODE = 19,
	MIPI_DCS_GET_IMAGE_CHECKSUM_RGB = 20,
	MIPI_DCS_GET_IMAGE_CHECKSUM_CT = 21,
	MIPI_DCS_EXIT_INVERT_MODE = 32,
	MIPI_DCS_ENTER_INVERT_MODE = 33,
	MIPI_DCS_SET_GAMMA_CURVE = 38,
	MIPI_DCS_SET_DISPLAY_OFF = 40,
	MIPI_DCS_SET_DISPLAY_ON = 41,
	MIPI_DCS_SET_COLUMN_ADDRESS = 42,
	MIPI_DCS_SET_PAGE_ADDRESS = 43,
	MIPI_DCS_WRITE_MEMORY_START = 44,
	MIPI_DCS_WRITE_LUT = 45,
	MIPI_DCS_READ_MEMORY_START = 46,
	MIPI_DCS_SET_PARTIAL_ROWS = 48,
	MIPI_DCS_SET_PARTIAL_COLUMNS = 49,
	MIPI_DCS_SET_SCROLL_AREA = 51,
	MIPI_DCS_SET_TEAR_OFF = 52,
	MIPI_DCS_SET_TEAR_ON = 53,
	MIPI_DCS_SET_ADDRESS_MODE = 54,
	MIPI_DCS_SET_SCROLL_START = 55,
	MIPI_DCS_EXIT_IDLE_MODE = 56,
	MIPI_DCS_ENTER_IDLE_MODE = 57,
	MIPI_DCS_SET_PIXEL_FORMAT = 58,
	MIPI_DCS_WRITE_MEMORY_CONTINUE = 60,
	MIPI_DCS_SET_3D_CONTROL = 61,
	MIPI_DCS_READ_MEMORY_CONTINUE = 62,
	MIPI_DCS_GET_3D_CONTROL = 63,
	MIPI_DCS_SET_VSYNC_TIMING = 64,
	MIPI_DCS_SET_TEAR_SCANLINE = 68,
	MIPI_DCS_GET_SCANLINE = 69,
	MIPI_DCS_SET_DISPLAY_BRIGHTNESS = 81,
	MIPI_DCS_GET_DISPLAY_BRIGHTNESS = 82,
	MIPI_DCS_WRITE_CONTROL_DISPLAY = 83,
	MIPI_DCS_GET_CONTROL_DISPLAY = 84,
	MIPI_DCS_WRITE_POWER_SAVE = 85,
	MIPI_DCS_GET_POWER_SAVE = 86,
	MIPI_DCS_SET_CABC_MIN_BRIGHTNESS = 94,
	MIPI_DCS_GET_CABC_MIN_BRIGHTNESS = 95,
	MIPI_DCS_READ_DDB_START = 161,
	MIPI_DCS_READ_PPS_START = 162,
	MIPI_DCS_READ_DDB_CONTINUE = 168,
	MIPI_DCS_READ_PPS_CONTINUE = 169,
};

enum {
	MIPI_DSI_V_SYNC_START = 1,
	MIPI_DSI_V_SYNC_END = 17,
	MIPI_DSI_H_SYNC_START = 33,
	MIPI_DSI_H_SYNC_END = 49,
	MIPI_DSI_COMPRESSION_MODE = 7,
	MIPI_DSI_END_OF_TRANSMISSION = 8,
	MIPI_DSI_COLOR_MODE_OFF = 2,
	MIPI_DSI_COLOR_MODE_ON = 18,
	MIPI_DSI_SHUTDOWN_PERIPHERAL = 34,
	MIPI_DSI_TURN_ON_PERIPHERAL = 50,
	MIPI_DSI_GENERIC_SHORT_WRITE_0_PARAM = 3,
	MIPI_DSI_GENERIC_SHORT_WRITE_1_PARAM = 19,
	MIPI_DSI_GENERIC_SHORT_WRITE_2_PARAM = 35,
	MIPI_DSI_GENERIC_READ_REQUEST_0_PARAM = 4,
	MIPI_DSI_GENERIC_READ_REQUEST_1_PARAM = 20,
	MIPI_DSI_GENERIC_READ_REQUEST_2_PARAM = 36,
	MIPI_DSI_DCS_SHORT_WRITE = 5,
	MIPI_DSI_DCS_SHORT_WRITE_PARAM = 21,
	MIPI_DSI_DCS_READ = 6,
	MIPI_DSI_EXECUTE_QUEUE = 22,
	MIPI_DSI_SET_MAXIMUM_RETURN_PACKET_SIZE = 55,
	MIPI_DSI_NULL_PACKET = 9,
	MIPI_DSI_BLANKING_PACKET = 25,
	MIPI_DSI_GENERIC_LONG_WRITE = 41,
	MIPI_DSI_DCS_LONG_WRITE = 57,
	MIPI_DSI_PICTURE_PARAMETER_SET = 10,
	MIPI_DSI_COMPRESSED_PIXEL_STREAM = 11,
	MIPI_DSI_LOOSELY_PACKED_PIXEL_STREAM_YCBCR20 = 12,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR24 = 28,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR16 = 44,
	MIPI_DSI_PACKED_PIXEL_STREAM_30 = 13,
	MIPI_DSI_PACKED_PIXEL_STREAM_36 = 29,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR12 = 61,
	MIPI_DSI_PACKED_PIXEL_STREAM_16 = 14,
	MIPI_DSI_PACKED_PIXEL_STREAM_18 = 30,
	MIPI_DSI_PIXEL_STREAM_3BYTE_18 = 46,
	MIPI_DSI_PACKED_PIXEL_STREAM_24 = 62,
};

enum {
	MIX_INFLIGHT = 2147483648,
};

enum {
	MLX_MC_RBT_SUPPORT = 1,
	MLX_MC_RBT_AVL = 8,
};

enum {
	MMOP_OFFLINE = 0,
	MMOP_ONLINE = 1,
	MMOP_ONLINE_KERNEL = 2,
	MMOP_ONLINE_MOVABLE = 3,
};

enum {
	MM_FILEPAGES = 0,
	MM_ANONPAGES = 1,
	MM_SWAPENTS = 2,
	MM_SHMEMPAGES = 3,
	NR_MM_COUNTERS = 4,
};

enum {
	MM_LEAF_TOTAL = 0,
	MM_LEAF_YOUNG = 1,
	MM_NONLEAF_FOUND = 2,
	MM_NONLEAF_ADDED = 3,
	NR_MM_STATS = 4,
};

enum {
	MODE_NONE = 0,
	MODE_ROUND_ROBIN = 1,
	MODE_PER_CPU = 2,
	MODE_MAX = 3,
};

enum {
	MOXA_SUPP_RS232 = 1,
	MOXA_SUPP_RS422 = 2,
	MOXA_SUPP_RS485 = 4,
};

enum {
	MPOL_DEFAULT = 0,
	MPOL_PREFERRED = 1,
	MPOL_BIND = 2,
	MPOL_INTERLEAVE = 3,
	MPOL_LOCAL = 4,
	MPOL_PREFERRED_MANY = 5,
	MPOL_WEIGHTED_INTERLEAVE = 6,
	MPOL_MAX = 7,
};

enum {
	MPTCP_CMSG_TS = 1,
	MPTCP_CMSG_INQ = 2,
};

enum {
	MPTCP_PM_ADDR_ATTR_UNSPEC = 0,
	MPTCP_PM_ADDR_ATTR_FAMILY = 1,
	MPTCP_PM_ADDR_ATTR_ID = 2,
	MPTCP_PM_ADDR_ATTR_ADDR4 = 3,
	MPTCP_PM_ADDR_ATTR_ADDR6 = 4,
	MPTCP_PM_ADDR_ATTR_PORT = 5,
	MPTCP_PM_ADDR_ATTR_FLAGS = 6,
	MPTCP_PM_ADDR_ATTR_IF_IDX = 7,
	__MPTCP_PM_ADDR_ATTR_MAX = 8,
};

enum {
	MPTCP_PM_ATTR_UNSPEC = 0,
	MPTCP_PM_ATTR_ADDR = 1,
	MPTCP_PM_ATTR_RCV_ADD_ADDRS = 2,
	MPTCP_PM_ATTR_SUBFLOWS = 3,
	MPTCP_PM_ATTR_TOKEN = 4,
	MPTCP_PM_ATTR_LOC_ID = 5,
	MPTCP_PM_ATTR_ADDR_REMOTE = 6,
	__MPTCP_ATTR_AFTER_LAST = 7,
};

enum {
	MPTCP_PM_CMD_UNSPEC = 0,
	MPTCP_PM_CMD_ADD_ADDR = 1,
	MPTCP_PM_CMD_DEL_ADDR = 2,
	MPTCP_PM_CMD_GET_ADDR = 3,
	MPTCP_PM_CMD_FLUSH_ADDRS = 4,
	MPTCP_PM_CMD_SET_LIMITS = 5,
	MPTCP_PM_CMD_GET_LIMITS = 6,
	MPTCP_PM_CMD_SET_FLAGS = 7,
	MPTCP_PM_CMD_ANNOUNCE = 8,
	MPTCP_PM_CMD_REMOVE = 9,
	MPTCP_PM_CMD_SUBFLOW_CREATE = 10,
	MPTCP_PM_CMD_SUBFLOW_DESTROY = 11,
	__MPTCP_PM_CMD_AFTER_LAST = 12,
};

enum {
	MPTCP_PM_ENDPOINT_ADDR = 1,
	__MPTCP_PM_ENDPOINT_MAX = 2,
};

enum {
	MPTCP_SUBFLOW_ATTR_UNSPEC = 0,
	MPTCP_SUBFLOW_ATTR_TOKEN_REM = 1,
	MPTCP_SUBFLOW_ATTR_TOKEN_LOC = 2,
	MPTCP_SUBFLOW_ATTR_RELWRITE_SEQ = 3,
	MPTCP_SUBFLOW_ATTR_MAP_SEQ = 4,
	MPTCP_SUBFLOW_ATTR_MAP_SFSEQ = 5,
	MPTCP_SUBFLOW_ATTR_SSN_OFFSET = 6,
	MPTCP_SUBFLOW_ATTR_MAP_DATALEN = 7,
	MPTCP_SUBFLOW_ATTR_FLAGS = 8,
	MPTCP_SUBFLOW_ATTR_ID_REM = 9,
	MPTCP_SUBFLOW_ATTR_ID_LOC = 10,
	MPTCP_SUBFLOW_ATTR_PAD = 11,
	__MPTCP_SUBFLOW_ATTR_MAX = 12,
};

enum {
	MSI_CHIP_FLAG_SET_EOI = 1,
	MSI_CHIP_FLAG_SET_ACK = 2,
};

enum {
	MSI_FLAG_USE_DEF_DOM_OPS = 1,
	MSI_FLAG_USE_DEF_CHIP_OPS = 2,
	MSI_FLAG_ACTIVATE_EARLY = 4,
	MSI_FLAG_MUST_REACTIVATE = 8,
	MSI_FLAG_DEV_SYSFS = 16,
	MSI_FLAG_ALLOC_SIMPLE_MSI_DESCS = 32,
	MSI_FLAG_FREE_MSI_DESCS = 64,
	MSI_FLAG_USE_DEV_FWNODE = 128,
	MSI_FLAG_PARENT_PM_DEV = 256,
	MSI_FLAG_PCI_MSI_MASK_PARENT = 512,
	MSI_FLAG_PCI_MSI_STARTUP_PARENT = 1024,
	MSI_GENERIC_FLAGS_MASK = 65535,
	MSI_DOMAIN_FLAGS_MASK = 4294901760,
	MSI_FLAG_MULTI_PCI_MSI = 65536,
	MSI_FLAG_PCI_MSIX = 131072,
	MSI_FLAG_LEVEL_CAPABLE = 262144,
	MSI_FLAG_MSIX_CONTIGUOUS = 524288,
	MSI_FLAG_PCI_MSIX_ALLOC_DYN = 1048576,
	MSI_FLAG_NO_AFFINITY = 2097152,
	MSI_FLAG_NO_MASK = 4194304,
};

enum {
	M_I17 = 0,
	M_I20 = 1,
	M_I20_SR = 2,
	M_I24 = 3,
	M_I24_8_1 = 4,
	M_I24_10_1 = 5,
	M_I27_11_1 = 6,
	M_MINI = 7,
	M_MINI_3_1 = 8,
	M_MINI_4_1 = 9,
	M_MB = 10,
	M_MB_2 = 11,
	M_MB_3 = 12,
	M_MB_5_1 = 13,
	M_MB_6_1 = 14,
	M_MB_7_1 = 15,
	M_MB_SR = 16,
	M_MBA = 17,
	M_MBA_3 = 18,
	M_MBP = 19,
	M_MBP_2 = 20,
	M_MBP_2_2 = 21,
	M_MBP_SR = 22,
	M_MBP_4 = 23,
	M_MBP_5_1 = 24,
	M_MBP_5_2 = 25,
	M_MBP_5_3 = 26,
	M_MBP_6_1 = 27,
	M_MBP_6_2 = 28,
	M_MBP_7_1 = 29,
	M_MBP_8_2 = 30,
	M_UNKNOWN = 31,
};

enum {
	NAPIF_STATE_SCHED = 1,
	NAPIF_STATE_MISSED = 2,
	NAPIF_STATE_DISABLE = 4,
	NAPIF_STATE_NPSVC = 8,
	NAPIF_STATE_LISTED = 16,
	NAPIF_STATE_NO_BUSY_POLL = 32,
	NAPIF_STATE_IN_BUSY_POLL = 64,
	NAPIF_STATE_PREFER_BUSY_POLL = 128,
	NAPIF_STATE_THREADED = 256,
	NAPIF_STATE_SCHED_THREADED = 512,
	NAPIF_STATE_HAS_NOTIFIER = 1024,
};

enum {
	NAPI_F_PREFER_BUSY_POLL = 1,
	NAPI_F_END_ON_RESCHED = 2,
};

enum {
	NAPI_STATE_SCHED = 0,
	NAPI_STATE_MISSED = 1,
	NAPI_STATE_DISABLE = 2,
	NAPI_STATE_NPSVC = 3,
	NAPI_STATE_LISTED = 4,
	NAPI_STATE_NO_BUSY_POLL = 5,
	NAPI_STATE_IN_BUSY_POLL = 6,
	NAPI_STATE_PREFER_BUSY_POLL = 7,
	NAPI_STATE_THREADED = 8,
	NAPI_STATE_SCHED_THREADED = 9,
	NAPI_STATE_HAS_NOTIFIER = 10,
};

enum {
	NCSI_CAP_BASE = 0,
	NCSI_CAP_GENERIC = 0,
	NCSI_CAP_BC = 1,
	NCSI_CAP_MC = 2,
	NCSI_CAP_BUFFER = 3,
	NCSI_CAP_AEN = 4,
	NCSI_CAP_VLAN = 5,
	NCSI_CAP_MAX = 6,
};

enum {
	NCSI_CAP_GENERIC_HWA = 1,
	NCSI_CAP_GENERIC_HDS = 2,
	NCSI_CAP_GENERIC_FC = 4,
	NCSI_CAP_GENERIC_FC1 = 8,
	NCSI_CAP_GENERIC_MC = 16,
	NCSI_CAP_GENERIC_HWA_UNKNOWN = 0,
	NCSI_CAP_GENERIC_HWA_SUPPORT = 32,
	NCSI_CAP_GENERIC_HWA_NOT_SUPPORT = 64,
	NCSI_CAP_GENERIC_HWA_RESERVED = 96,
	NCSI_CAP_GENERIC_HWA_MASK = 96,
	NCSI_CAP_GENERIC_MASK = 127,
	NCSI_CAP_BC_ARP = 1,
	NCSI_CAP_BC_DHCPC = 2,
	NCSI_CAP_BC_DHCPS = 4,
	NCSI_CAP_BC_NETBIOS = 8,
	NCSI_CAP_BC_MASK = 15,
	NCSI_CAP_MC_IPV6_NEIGHBOR = 1,
	NCSI_CAP_MC_IPV6_ROUTER = 2,
	NCSI_CAP_MC_DHCPV6_RELAY = 4,
	NCSI_CAP_MC_DHCPV6_WELL_KNOWN = 8,
	NCSI_CAP_MC_IPV6_MLD = 16,
	NCSI_CAP_MC_IPV6_NEIGHBOR_S = 32,
	NCSI_CAP_MC_MASK = 63,
	NCSI_CAP_AEN_LSC = 1,
	NCSI_CAP_AEN_CR = 2,
	NCSI_CAP_AEN_HDS = 4,
	NCSI_CAP_AEN_MASK = 7,
	NCSI_CAP_VLAN_ONLY = 1,
	NCSI_CAP_VLAN_NO = 2,
	NCSI_CAP_VLAN_ANY = 4,
	NCSI_CAP_VLAN_MASK = 7,
};

enum {
	NCSI_MODE_BASE = 0,
	NCSI_MODE_ENABLE = 0,
	NCSI_MODE_TX_ENABLE = 1,
	NCSI_MODE_LINK = 2,
	NCSI_MODE_VLAN = 3,
	NCSI_MODE_BC = 4,
	NCSI_MODE_MC = 5,
	NCSI_MODE_AEN = 6,
	NCSI_MODE_FC = 7,
	NCSI_MODE_MAX = 8,
};

enum {
	NDA_UNSPEC = 0,
	NDA_DST = 1,
	NDA_LLADDR = 2,
	NDA_CACHEINFO = 3,
	NDA_PROBES = 4,
	NDA_VLAN = 5,
	NDA_PORT = 6,
	NDA_VNI = 7,
	NDA_IFINDEX = 8,
	NDA_MASTER = 9,
	NDA_LINK_NETNSID = 10,
	NDA_SRC_VNI = 11,
	NDA_PROTOCOL = 12,
	NDA_NH_ID = 13,
	NDA_FDB_EXT_ATTRS = 14,
	NDA_FLAGS_EXT = 15,
	NDA_NDM_STATE_MASK = 16,
	NDA_NDM_FLAGS_MASK = 17,
	__NDA_MAX = 18,
};

enum {
	NDD_UNARMED = 1,
	NDD_LOCKED = 2,
	NDD_SECURITY_OVERWRITE = 3,
	NDD_WORK_PENDING = 4,
	NDD_LABELING = 6,
	NDD_INCOHERENT = 7,
	NDD_REGISTER_SYNC = 8,
	ND_IOCTL_MAX_BUFLEN = 4194304,
	ND_CMD_MAX_ELEM = 5,
	ND_CMD_MAX_ENVELOPE = 256,
	ND_MAX_MAPPINGS = 32,
	ND_REGION_PAGEMAP = 0,
	ND_REGION_PERSIST_CACHE = 1,
	ND_REGION_PERSIST_MEMCTRL = 2,
	ND_REGION_ASYNC = 3,
	ND_REGION_CXL = 4,
	DPA_RESOURCE_ADJUSTED = 1,
};

enum {
	NDTA_UNSPEC = 0,
	NDTA_NAME = 1,
	NDTA_THRESH1 = 2,
	NDTA_THRESH2 = 3,
	NDTA_THRESH3 = 4,
	NDTA_CONFIG = 5,
	NDTA_PARMS = 6,
	NDTA_STATS = 7,
	NDTA_GC_INTERVAL = 8,
	NDTA_PAD = 9,
	__NDTA_MAX = 10,
};

enum {
	NDTPA_UNSPEC = 0,
	NDTPA_IFINDEX = 1,
	NDTPA_REFCNT = 2,
	NDTPA_REACHABLE_TIME = 3,
	NDTPA_BASE_REACHABLE_TIME = 4,
	NDTPA_RETRANS_TIME = 5,
	NDTPA_GC_STALETIME = 6,
	NDTPA_DELAY_PROBE_TIME = 7,
	NDTPA_QUEUE_LEN = 8,
	NDTPA_APP_PROBES = 9,
	NDTPA_UCAST_PROBES = 10,
	NDTPA_MCAST_PROBES = 11,
	NDTPA_ANYCAST_DELAY = 12,
	NDTPA_PROXY_DELAY = 13,
	NDTPA_PROXY_QLEN = 14,
	NDTPA_LOCKTIME = 15,
	NDTPA_QUEUE_LENBYTES = 16,
	NDTPA_MCAST_REPROBES = 17,
	NDTPA_PAD = 18,
	NDTPA_INTERVAL_PROBE_TIME_MS = 19,
	__NDTPA_MAX = 20,
};

enum {
	NDUSEROPT_UNSPEC = 0,
	NDUSEROPT_SRCADDR = 1,
	__NDUSEROPT_MAX = 2,
};

enum {
	NEIGH_ARP_TABLE = 0,
	NEIGH_ND_TABLE = 1,
	NEIGH_NR_TABLES = 2,
	NEIGH_LINK_TABLE = 2,
};

enum {
	NEIGH_VAR_MCAST_PROBES = 0,
	NEIGH_VAR_UCAST_PROBES = 1,
	NEIGH_VAR_APP_PROBES = 2,
	NEIGH_VAR_MCAST_REPROBES = 3,
	NEIGH_VAR_RETRANS_TIME = 4,
	NEIGH_VAR_BASE_REACHABLE_TIME = 5,
	NEIGH_VAR_DELAY_PROBE_TIME = 6,
	NEIGH_VAR_INTERVAL_PROBE_TIME_MS = 7,
	NEIGH_VAR_GC_STALETIME = 8,
	NEIGH_VAR_QUEUE_LEN_BYTES = 9,
	NEIGH_VAR_PROXY_QLEN = 10,
	NEIGH_VAR_ANYCAST_DELAY = 11,
	NEIGH_VAR_PROXY_DELAY = 12,
	NEIGH_VAR_LOCKTIME = 13,
	NEIGH_VAR_QUEUE_LEN = 14,
	NEIGH_VAR_RETRANS_TIME_MS = 15,
	NEIGH_VAR_BASE_REACHABLE_TIME_MS = 16,
	NEIGH_VAR_GC_INTERVAL = 17,
	NEIGH_VAR_GC_THRESH1 = 18,
	NEIGH_VAR_GC_THRESH2 = 19,
	NEIGH_VAR_GC_THRESH3 = 20,
	NEIGH_VAR_MAX = 21,
};

enum {
	NESTED_SYNC_IMM_BIT = 0,
	NESTED_SYNC_TODO_BIT = 1,
};

enum {
	NETCONFA_UNSPEC = 0,
	NETCONFA_IFINDEX = 1,
	NETCONFA_FORWARDING = 2,
	NETCONFA_RP_FILTER = 3,
	NETCONFA_MC_FORWARDING = 4,
	NETCONFA_PROXY_NEIGH = 5,
	NETCONFA_IGNORE_ROUTES_WITH_LINKDOWN = 6,
	NETCONFA_INPUT = 7,
	NETCONFA_BC_FORWARDING = 8,
	NETCONFA_FORCE_FORWARDING = 9,
	__NETCONFA_MAX = 10,
};

enum {
	NETDEV_A_DEV_IFINDEX = 1,
	NETDEV_A_DEV_PAD = 2,
	NETDEV_A_DEV_XDP_FEATURES = 3,
	NETDEV_A_DEV_XDP_ZC_MAX_SEGS = 4,
	NETDEV_A_DEV_XDP_RX_METADATA_FEATURES = 5,
	NETDEV_A_DEV_XSK_FEATURES = 6,
	__NETDEV_A_DEV_MAX = 7,
	NETDEV_A_DEV_MAX = 6,
};

enum {
	NETDEV_A_DMABUF_IFINDEX = 1,
	NETDEV_A_DMABUF_QUEUES = 2,
	NETDEV_A_DMABUF_FD = 3,
	NETDEV_A_DMABUF_ID = 4,
	__NETDEV_A_DMABUF_MAX = 5,
	NETDEV_A_DMABUF_MAX = 4,
};

enum {
	NETDEV_A_NAPI_IFINDEX = 1,
	NETDEV_A_NAPI_ID = 2,
	NETDEV_A_NAPI_IRQ = 3,
	NETDEV_A_NAPI_PID = 4,
	NETDEV_A_NAPI_DEFER_HARD_IRQS = 5,
	NETDEV_A_NAPI_GRO_FLUSH_TIMEOUT = 6,
	NETDEV_A_NAPI_IRQ_SUSPEND_TIMEOUT = 7,
	NETDEV_A_NAPI_THREADED = 8,
	__NETDEV_A_NAPI_MAX = 9,
	NETDEV_A_NAPI_MAX = 8,
};

enum {
	NETDEV_A_PAGE_POOL_ID = 1,
	NETDEV_A_PAGE_POOL_IFINDEX = 2,
	NETDEV_A_PAGE_POOL_NAPI_ID = 3,
	NETDEV_A_PAGE_POOL_INFLIGHT = 4,
	NETDEV_A_PAGE_POOL_INFLIGHT_MEM = 5,
	NETDEV_A_PAGE_POOL_DETACH_TIME = 6,
	NETDEV_A_PAGE_POOL_DMABUF = 7,
	NETDEV_A_PAGE_POOL_IO_URING = 8,
	__NETDEV_A_PAGE_POOL_MAX = 9,
	NETDEV_A_PAGE_POOL_MAX = 8,
};

enum {
	NETDEV_A_PAGE_POOL_STATS_INFO = 1,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_FAST = 8,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW = 9,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW_HIGH_ORDER = 10,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_EMPTY = 11,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_REFILL = 12,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_WAIVE = 13,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHED = 14,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHE_FULL = 15,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING = 16,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING_FULL = 17,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RELEASED_REFCNT = 18,
	__NETDEV_A_PAGE_POOL_STATS_MAX = 19,
	NETDEV_A_PAGE_POOL_STATS_MAX = 18,
};

enum {
	NETDEV_A_QSTATS_IFINDEX = 1,
	NETDEV_A_QSTATS_QUEUE_TYPE = 2,
	NETDEV_A_QSTATS_QUEUE_ID = 3,
	NETDEV_A_QSTATS_SCOPE = 4,
	NETDEV_A_QSTATS_RX_PACKETS = 8,
	NETDEV_A_QSTATS_RX_BYTES = 9,
	NETDEV_A_QSTATS_TX_PACKETS = 10,
	NETDEV_A_QSTATS_TX_BYTES = 11,
	NETDEV_A_QSTATS_RX_ALLOC_FAIL = 12,
	NETDEV_A_QSTATS_RX_HW_DROPS = 13,
	NETDEV_A_QSTATS_RX_HW_DROP_OVERRUNS = 14,
	NETDEV_A_QSTATS_RX_CSUM_COMPLETE = 15,
	NETDEV_A_QSTATS_RX_CSUM_UNNECESSARY = 16,
	NETDEV_A_QSTATS_RX_CSUM_NONE = 17,
	NETDEV_A_QSTATS_RX_CSUM_BAD = 18,
	NETDEV_A_QSTATS_RX_HW_GRO_PACKETS = 19,
	NETDEV_A_QSTATS_RX_HW_GRO_BYTES = 20,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_PACKETS = 21,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_BYTES = 22,
	NETDEV_A_QSTATS_RX_HW_DROP_RATELIMITS = 23,
	NETDEV_A_QSTATS_TX_HW_DROPS = 24,
	NETDEV_A_QSTATS_TX_HW_DROP_ERRORS = 25,
	NETDEV_A_QSTATS_TX_CSUM_NONE = 26,
	NETDEV_A_QSTATS_TX_NEEDS_CSUM = 27,
	NETDEV_A_QSTATS_TX_HW_GSO_PACKETS = 28,
	NETDEV_A_QSTATS_TX_HW_GSO_BYTES = 29,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_PACKETS = 30,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_BYTES = 31,
	NETDEV_A_QSTATS_TX_HW_DROP_RATELIMITS = 32,
	NETDEV_A_QSTATS_TX_STOP = 33,
	NETDEV_A_QSTATS_TX_WAKE = 34,
	__NETDEV_A_QSTATS_MAX = 35,
	NETDEV_A_QSTATS_MAX = 34,
};

enum {
	NETDEV_A_QUEUE_ID = 1,
	NETDEV_A_QUEUE_IFINDEX = 2,
	NETDEV_A_QUEUE_TYPE = 3,
	NETDEV_A_QUEUE_NAPI_ID = 4,
	NETDEV_A_QUEUE_DMABUF = 5,
	NETDEV_A_QUEUE_IO_URING = 6,
	NETDEV_A_QUEUE_XSK = 7,
	__NETDEV_A_QUEUE_MAX = 8,
	NETDEV_A_QUEUE_MAX = 7,
};

enum {
	NETDEV_CMD_DEV_GET = 1,
	NETDEV_CMD_DEV_ADD_NTF = 2,
	NETDEV_CMD_DEV_DEL_NTF = 3,
	NETDEV_CMD_DEV_CHANGE_NTF = 4,
	NETDEV_CMD_PAGE_POOL_GET = 5,
	NETDEV_CMD_PAGE_POOL_ADD_NTF = 6,
	NETDEV_CMD_PAGE_POOL_DEL_NTF = 7,
	NETDEV_CMD_PAGE_POOL_CHANGE_NTF = 8,
	NETDEV_CMD_PAGE_POOL_STATS_GET = 9,
	NETDEV_CMD_QUEUE_GET = 10,
	NETDEV_CMD_NAPI_GET = 11,
	NETDEV_CMD_QSTATS_GET = 12,
	NETDEV_CMD_BIND_RX = 13,
	NETDEV_CMD_NAPI_SET = 14,
	NETDEV_CMD_BIND_TX = 15,
	__NETDEV_CMD_MAX = 16,
	NETDEV_CMD_MAX = 15,
};

enum {
	NETDEV_NLGRP_MGMT = 0,
	NETDEV_NLGRP_PAGE_POOL = 1,
};

enum {
	NETIF_F_SG_BIT = 0,
	NETIF_F_IP_CSUM_BIT = 1,
	__UNUSED_NETIF_F_1 = 2,
	NETIF_F_HW_CSUM_BIT = 3,
	NETIF_F_IPV6_CSUM_BIT = 4,
	NETIF_F_HIGHDMA_BIT = 5,
	NETIF_F_FRAGLIST_BIT = 6,
	NETIF_F_HW_VLAN_CTAG_TX_BIT = 7,
	NETIF_F_HW_VLAN_CTAG_RX_BIT = 8,
	NETIF_F_HW_VLAN_CTAG_FILTER_BIT = 9,
	NETIF_F_VLAN_CHALLENGED_BIT = 10,
	NETIF_F_GSO_BIT = 11,
	__UNUSED_NETIF_F_12 = 12,
	__UNUSED_NETIF_F_13 = 13,
	NETIF_F_GRO_BIT = 14,
	NETIF_F_LRO_BIT = 15,
	NETIF_F_GSO_SHIFT = 16,
	NETIF_F_TSO_BIT = 16,
	NETIF_F_GSO_ROBUST_BIT = 17,
	NETIF_F_TSO_ECN_BIT = 18,
	NETIF_F_TSO_MANGLEID_BIT = 19,
	NETIF_F_TSO6_BIT = 20,
	NETIF_F_FSO_BIT = 21,
	NETIF_F_GSO_GRE_BIT = 22,
	NETIF_F_GSO_GRE_CSUM_BIT = 23,
	NETIF_F_GSO_IPXIP4_BIT = 24,
	NETIF_F_GSO_IPXIP6_BIT = 25,
	NETIF_F_GSO_UDP_TUNNEL_BIT = 26,
	NETIF_F_GSO_UDP_TUNNEL_CSUM_BIT = 27,
	NETIF_F_GSO_PARTIAL_BIT = 28,
	NETIF_F_GSO_TUNNEL_REMCSUM_BIT = 29,
	NETIF_F_GSO_SCTP_BIT = 30,
	NETIF_F_GSO_ESP_BIT = 31,
	NETIF_F_GSO_UDP_BIT = 32,
	NETIF_F_GSO_UDP_L4_BIT = 33,
	NETIF_F_GSO_FRAGLIST_BIT = 34,
	NETIF_F_GSO_ACCECN_BIT = 35,
	NETIF_F_GSO_LAST = 35,
	NETIF_F_FCOE_CRC_BIT = 36,
	NETIF_F_SCTP_CRC_BIT = 37,
	NETIF_F_NTUPLE_BIT = 38,
	NETIF_F_RXHASH_BIT = 39,
	NETIF_F_RXCSUM_BIT = 40,
	NETIF_F_NOCACHE_COPY_BIT = 41,
	NETIF_F_LOOPBACK_BIT = 42,
	NETIF_F_RXFCS_BIT = 43,
	NETIF_F_RXALL_BIT = 44,
	NETIF_F_HW_VLAN_STAG_TX_BIT = 45,
	NETIF_F_HW_VLAN_STAG_RX_BIT = 46,
	NETIF_F_HW_VLAN_STAG_FILTER_BIT = 47,
	NETIF_F_HW_L2FW_DOFFLOAD_BIT = 48,
	NETIF_F_HW_TC_BIT = 49,
	NETIF_F_HW_ESP_BIT = 50,
	NETIF_F_HW_ESP_TX_CSUM_BIT = 51,
	NETIF_F_RX_UDP_TUNNEL_PORT_BIT = 52,
	NETIF_F_HW_TLS_TX_BIT = 53,
	NETIF_F_HW_TLS_RX_BIT = 54,
	NETIF_F_GRO_HW_BIT = 55,
	NETIF_F_HW_TLS_RECORD_BIT = 56,
	NETIF_F_GRO_FRAGLIST_BIT = 57,
	NETIF_F_HW_MACSEC_BIT = 58,
	NETIF_F_GRO_UDP_FWD_BIT = 59,
	NETIF_F_HW_HSR_TAG_INS_BIT = 60,
	NETIF_F_HW_HSR_TAG_RM_BIT = 61,
	NETIF_F_HW_HSR_FWD_BIT = 62,
	NETIF_F_HW_HSR_DUP_BIT = 63,
	NETDEV_FEATURE_COUNT = 64,
};

enum {
	NETIF_MSG_DRV_BIT = 0,
	NETIF_MSG_PROBE_BIT = 1,
	NETIF_MSG_LINK_BIT = 2,
	NETIF_MSG_TIMER_BIT = 3,
	NETIF_MSG_IFDOWN_BIT = 4,
	NETIF_MSG_IFUP_BIT = 5,
	NETIF_MSG_RX_ERR_BIT = 6,
	NETIF_MSG_TX_ERR_BIT = 7,
	NETIF_MSG_TX_QUEUED_BIT = 8,
	NETIF_MSG_INTR_BIT = 9,
	NETIF_MSG_TX_DONE_BIT = 10,
	NETIF_MSG_RX_STATUS_BIT = 11,
	NETIF_MSG_PKTDATA_BIT = 12,
	NETIF_MSG_HW_BIT = 13,
	NETIF_MSG_WOL_BIT = 14,
	NETIF_MSG_CLASS_COUNT = 15,
};

enum {
	NETLINK_F_KERNEL_SOCKET = 0,
	NETLINK_F_RECV_PKTINFO = 1,
	NETLINK_F_BROADCAST_SEND_ERROR = 2,
	NETLINK_F_RECV_NO_ENOBUFS = 3,
	NETLINK_F_LISTEN_ALL_NSID = 4,
	NETLINK_F_CAP_ACK = 5,
	NETLINK_F_EXT_ACK = 6,
	NETLINK_F_STRICT_CHK = 7,
};

enum {
	NETLINK_UNCONNECTED = 0,
	NETLINK_CONNECTED = 1,
};

enum {
	NETNSA_NONE = 0,
	NETNSA_NSID = 1,
	NETNSA_PID = 2,
	NETNSA_FD = 3,
	NETNSA_TARGET_NSID = 4,
	NETNSA_CURRENT_NSID = 5,
	__NETNSA_MAX = 6,
};

enum {
	NET_DM_ATTR_PORT_NETDEV_IFINDEX = 0,
	NET_DM_ATTR_PORT_NETDEV_NAME = 1,
	__NET_DM_ATTR_PORT_MAX = 2,
	NET_DM_ATTR_PORT_MAX = 1,
};

enum {
	NET_DM_ATTR_STATS_DROPPED = 0,
	__NET_DM_ATTR_STATS_MAX = 1,
	NET_DM_ATTR_STATS_MAX = 0,
};

enum {
	NET_DM_CMD_UNSPEC = 0,
	NET_DM_CMD_ALERT = 1,
	NET_DM_CMD_CONFIG = 2,
	NET_DM_CMD_START = 3,
	NET_DM_CMD_STOP = 4,
	NET_DM_CMD_PACKET_ALERT = 5,
	NET_DM_CMD_CONFIG_GET = 6,
	NET_DM_CMD_CONFIG_NEW = 7,
	NET_DM_CMD_STATS_GET = 8,
	NET_DM_CMD_STATS_NEW = 9,
	_NET_DM_CMD_MAX = 10,
};

enum {
	NET_NS_INDEX = 0,
	UTS_NS_INDEX = 1,
	IPC_NS_INDEX = 2,
	PID_NS_INDEX = 3,
	USER_NS_INDEX = 4,
	MNT_NS_INDEX = 5,
	CGROUP_NS_INDEX = 6,
	NR_NAMESPACES = 7,
};

enum {
	NET_SHAPER_A_CAPS_IFINDEX = 1,
	NET_SHAPER_A_CAPS_SCOPE = 2,
	NET_SHAPER_A_CAPS_SUPPORT_METRIC_BPS = 3,
	NET_SHAPER_A_CAPS_SUPPORT_METRIC_PPS = 4,
	NET_SHAPER_A_CAPS_SUPPORT_NESTING = 5,
	NET_SHAPER_A_CAPS_SUPPORT_BW_MIN = 6,
	NET_SHAPER_A_CAPS_SUPPORT_BW_MAX = 7,
	NET_SHAPER_A_CAPS_SUPPORT_BURST = 8,
	NET_SHAPER_A_CAPS_SUPPORT_PRIORITY = 9,
	NET_SHAPER_A_CAPS_SUPPORT_WEIGHT = 10,
	__NET_SHAPER_A_CAPS_MAX = 11,
	NET_SHAPER_A_CAPS_MAX = 10,
};

enum {
	NET_SHAPER_A_HANDLE = 1,
	NET_SHAPER_A_METRIC = 2,
	NET_SHAPER_A_BW_MIN = 3,
	NET_SHAPER_A_BW_MAX = 4,
	NET_SHAPER_A_BURST = 5,
	NET_SHAPER_A_PRIORITY = 6,
	NET_SHAPER_A_WEIGHT = 7,
	NET_SHAPER_A_IFINDEX = 8,
	NET_SHAPER_A_PARENT = 9,
	NET_SHAPER_A_LEAVES = 10,
	__NET_SHAPER_A_MAX = 11,
	NET_SHAPER_A_MAX = 10,
};

enum {
	NET_SHAPER_A_HANDLE_SCOPE = 1,
	NET_SHAPER_A_HANDLE_ID = 2,
	__NET_SHAPER_A_HANDLE_MAX = 3,
	NET_SHAPER_A_HANDLE_MAX = 2,
};

enum {
	NET_SHAPER_CMD_GET = 1,
	NET_SHAPER_CMD_SET = 2,
	NET_SHAPER_CMD_DELETE = 3,
	NET_SHAPER_CMD_GROUP = 4,
	NET_SHAPER_CMD_CAP_GET = 5,
	__NET_SHAPER_CMD_MAX = 6,
	NET_SHAPER_CMD_MAX = 5,
};

enum {
	NEXTHOP_GRP_TYPE_MPATH = 0,
	NEXTHOP_GRP_TYPE_RES = 1,
	__NEXTHOP_GRP_TYPE_MAX = 2,
};

enum {
	NFPROTO_UNSPEC = 0,
	NFPROTO_INET = 1,
	NFPROTO_IPV4 = 2,
	NFPROTO_ARP = 3,
	NFPROTO_NETDEV = 5,
	NFPROTO_BRIDGE = 7,
	NFPROTO_IPV6 = 10,
	NFPROTO_NUMPROTO = 11,
};

enum {
	NHA_GROUP_STATS_ENTRY_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY_ID = 1,
	NHA_GROUP_STATS_ENTRY_PACKETS = 2,
	NHA_GROUP_STATS_ENTRY_PACKETS_HW = 3,
	__NHA_GROUP_STATS_ENTRY_MAX = 4,
};

enum {
	NHA_GROUP_STATS_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY = 1,
	__NHA_GROUP_STATS_MAX = 2,
};

enum {
	NHA_RES_BUCKET_UNSPEC = 0,
	NHA_RES_BUCKET_PAD = 0,
	NHA_RES_BUCKET_INDEX = 1,
	NHA_RES_BUCKET_IDLE_TIME = 2,
	NHA_RES_BUCKET_NH_ID = 3,
	__NHA_RES_BUCKET_MAX = 4,
};

enum {
	NHA_RES_GROUP_UNSPEC = 0,
	NHA_RES_GROUP_PAD = 0,
	NHA_RES_GROUP_BUCKETS = 1,
	NHA_RES_GROUP_IDLE_TIMER = 2,
	NHA_RES_GROUP_UNBALANCED_TIMER = 3,
	NHA_RES_GROUP_UNBALANCED_TIME = 4,
	__NHA_RES_GROUP_MAX = 5,
};

enum {
	NHA_UNSPEC = 0,
	NHA_ID = 1,
	NHA_GROUP = 2,
	NHA_GROUP_TYPE = 3,
	NHA_BLACKHOLE = 4,
	NHA_OIF = 5,
	NHA_GATEWAY = 6,
	NHA_ENCAP_TYPE = 7,
	NHA_ENCAP = 8,
	NHA_GROUPS = 9,
	NHA_MASTER = 10,
	NHA_FDB = 11,
	NHA_RES_GROUP = 12,
	NHA_RES_BUCKET = 13,
	NHA_OP_FLAGS = 14,
	NHA_GROUP_STATS = 15,
	NHA_HW_STATS_ENABLE = 16,
	NHA_HW_STATS_USED = 17,
	__NHA_MAX = 18,
};

enum {
	NLA_UNSPEC = 0,
	NLA_U8 = 1,
	NLA_U16 = 2,
	NLA_U32 = 3,
	NLA_U64 = 4,
	NLA_STRING = 5,
	NLA_FLAG = 6,
	NLA_MSECS = 7,
	NLA_NESTED = 8,
	NLA_NESTED_ARRAY = 9,
	NLA_NUL_STRING = 10,
	NLA_BINARY = 11,
	NLA_S8 = 12,
	NLA_S16 = 13,
	NLA_S32 = 14,
	NLA_S64 = 15,
	NLA_BITFIELD32 = 16,
	NLA_REJECT = 17,
	NLA_BE16 = 18,
	NLA_BE32 = 19,
	NLA_SINT = 20,
	NLA_UINT = 21,
	__NLA_TYPE_MAX = 22,
};

enum {
	NLBL_CALIPSO_A_UNSPEC = 0,
	NLBL_CALIPSO_A_DOI = 1,
	NLBL_CALIPSO_A_MTYPE = 2,
	__NLBL_CALIPSO_A_MAX = 3,
};

enum {
	NLBL_CALIPSO_C_UNSPEC = 0,
	NLBL_CALIPSO_C_ADD = 1,
	NLBL_CALIPSO_C_REMOVE = 2,
	NLBL_CALIPSO_C_LIST = 3,
	NLBL_CALIPSO_C_LISTALL = 4,
	__NLBL_CALIPSO_C_MAX = 5,
};

enum {
	NLBL_CIPSOV4_A_UNSPEC = 0,
	NLBL_CIPSOV4_A_DOI = 1,
	NLBL_CIPSOV4_A_MTYPE = 2,
	NLBL_CIPSOV4_A_TAG = 3,
	NLBL_CIPSOV4_A_TAGLST = 4,
	NLBL_CIPSOV4_A_MLSLVLLOC = 5,
	NLBL_CIPSOV4_A_MLSLVLREM = 6,
	NLBL_CIPSOV4_A_MLSLVL = 7,
	NLBL_CIPSOV4_A_MLSLVLLST = 8,
	NLBL_CIPSOV4_A_MLSCATLOC = 9,
	NLBL_CIPSOV4_A_MLSCATREM = 10,
	NLBL_CIPSOV4_A_MLSCAT = 11,
	NLBL_CIPSOV4_A_MLSCATLST = 12,
	__NLBL_CIPSOV4_A_MAX = 13,
};

enum {
	NLBL_CIPSOV4_C_UNSPEC = 0,
	NLBL_CIPSOV4_C_ADD = 1,
	NLBL_CIPSOV4_C_REMOVE = 2,
	NLBL_CIPSOV4_C_LIST = 3,
	NLBL_CIPSOV4_C_LISTALL = 4,
	__NLBL_CIPSOV4_C_MAX = 5,
};

enum {
	NLBL_MGMT_A_UNSPEC = 0,
	NLBL_MGMT_A_DOMAIN = 1,
	NLBL_MGMT_A_PROTOCOL = 2,
	NLBL_MGMT_A_VERSION = 3,
	NLBL_MGMT_A_CV4DOI = 4,
	NLBL_MGMT_A_IPV6ADDR = 5,
	NLBL_MGMT_A_IPV6MASK = 6,
	NLBL_MGMT_A_IPV4ADDR = 7,
	NLBL_MGMT_A_IPV4MASK = 8,
	NLBL_MGMT_A_ADDRSELECTOR = 9,
	NLBL_MGMT_A_SELECTORLIST = 10,
	NLBL_MGMT_A_FAMILY = 11,
	NLBL_MGMT_A_CLPDOI = 12,
	__NLBL_MGMT_A_MAX = 13,
};

enum {
	NLBL_MGMT_C_UNSPEC = 0,
	NLBL_MGMT_C_ADD = 1,
	NLBL_MGMT_C_REMOVE = 2,
	NLBL_MGMT_C_LISTALL = 3,
	NLBL_MGMT_C_ADDDEF = 4,
	NLBL_MGMT_C_REMOVEDEF = 5,
	NLBL_MGMT_C_LISTDEF = 6,
	NLBL_MGMT_C_PROTOCOLS = 7,
	NLBL_MGMT_C_VERSION = 8,
	__NLBL_MGMT_C_MAX = 9,
};

enum {
	NLBL_UNLABEL_A_UNSPEC = 0,
	NLBL_UNLABEL_A_ACPTFLG = 1,
	NLBL_UNLABEL_A_IPV6ADDR = 2,
	NLBL_UNLABEL_A_IPV6MASK = 3,
	NLBL_UNLABEL_A_IPV4ADDR = 4,
	NLBL_UNLABEL_A_IPV4MASK = 5,
	NLBL_UNLABEL_A_IFACE = 6,
	NLBL_UNLABEL_A_SECCTX = 7,
	__NLBL_UNLABEL_A_MAX = 8,
};

enum {
	NLBL_UNLABEL_C_UNSPEC = 0,
	NLBL_UNLABEL_C_ACCEPT = 1,
	NLBL_UNLABEL_C_LIST = 2,
	NLBL_UNLABEL_C_STATICADD = 3,
	NLBL_UNLABEL_C_STATICREMOVE = 4,
	NLBL_UNLABEL_C_STATICLIST = 5,
	NLBL_UNLABEL_C_STATICADDDEF = 6,
	NLBL_UNLABEL_C_STATICREMOVEDEF = 7,
	NLBL_UNLABEL_C_STATICLISTDEF = 8,
	__NLBL_UNLABEL_C_MAX = 9,
};

enum {
	NMI_LOCAL = 0,
	NMI_UNKNOWN = 1,
	NMI_SERR = 2,
	NMI_IO_CHECK = 3,
	NMI_MAX = 4,
};

enum {
	NODE_ACCESS_CLASS_GENPORT_SINK_LOCAL = 2,
	NODE_ACCESS_CLASS_GENPORT_SINK_CPU = 3,
	NODE_ACCESS_CLASS_MAX = 4,
};

enum {
	NONE_FORCE_HPET_RESUME = 0,
	OLD_ICH_FORCE_HPET_RESUME = 1,
	ICH_FORCE_HPET_RESUME = 2,
	VT8237_FORCE_HPET_RESUME = 3,
	NVIDIA_FORCE_HPET_RESUME = 4,
	ATI_FORCE_HPET_RESUME = 5,
};

enum {
	NO_USER_KERNEL = 0,
	NO_USER_USER = 1,
	NO_GUEST_HOST = 2,
	NO_GUEST_GUEST = 3,
	NO_CROSS_THREAD = 4,
	NR_VECTOR_PARAMS = 5,
};

enum {
	NUM_TRIAL_SAMPLES = 8192,
	MAX_SAMPLES_PER_BIT = 66,
};

enum {
	NVMEM_ADD = 1,
	NVMEM_REMOVE = 2,
	NVMEM_CELL_ADD = 3,
	NVMEM_CELL_REMOVE = 4,
	NVMEM_LAYOUT_ADD = 5,
	NVMEM_LAYOUT_REMOVE = 6,
};

enum {
	NVME_AEN_BIT_NS_ATTR = 8,
	NVME_AEN_BIT_FW_ACT = 9,
	NVME_AEN_BIT_ANA_CHANGE = 11,
	NVME_AEN_BIT_DISC_CHANGE = 31,
};

enum {
	NVME_CC_ENABLE = 1,
	NVME_CC_EN_SHIFT = 0,
	NVME_CC_CSS_SHIFT = 4,
	NVME_CC_CSS_MASK = 112,
	NVME_CC_CSS_NVM = 0,
	NVME_CC_CSS_CSI = 96,
	NVME_CC_MPS_SHIFT = 7,
	NVME_CC_MPS_MASK = 1920,
	NVME_CC_AMS_SHIFT = 11,
	NVME_CC_AMS_MASK = 14336,
	NVME_CC_AMS_RR = 0,
	NVME_CC_AMS_WRRU = 2048,
	NVME_CC_AMS_VS = 14336,
	NVME_CC_SHN_SHIFT = 14,
	NVME_CC_SHN_MASK = 49152,
	NVME_CC_SHN_NONE = 0,
	NVME_CC_SHN_NORMAL = 16384,
	NVME_CC_SHN_ABRUPT = 32768,
	NVME_CC_IOSQES_SHIFT = 16,
	NVME_CC_IOSQES_MASK = 983040,
	NVME_CC_IOSQES = 393216,
	NVME_CC_IOCQES_SHIFT = 20,
	NVME_CC_IOCQES_MASK = 15728640,
	NVME_CC_IOCQES = 4194304,
	NVME_CC_CRIME = 16777216,
};

enum {
	NVME_CSTS_RDY = 1,
	NVME_CSTS_CFS = 2,
	NVME_CSTS_NSSRO = 16,
	NVME_CSTS_PP = 32,
	NVME_CSTS_SHST_NORMAL = 0,
	NVME_CSTS_SHST_OCCUR = 4,
	NVME_CSTS_SHST_CMPLT = 8,
	NVME_CSTS_SHST_MASK = 12,
};

enum {
	NVME_REG_CAP = 0,
	NVME_REG_VS = 8,
	NVME_REG_INTMS = 12,
	NVME_REG_INTMC = 16,
	NVME_REG_CC = 20,
	NVME_REG_CSTS = 28,
	NVME_REG_NSSR = 32,
	NVME_REG_AQA = 36,
	NVME_REG_ASQ = 40,
	NVME_REG_ACQ = 48,
	NVME_REG_CMBLOC = 56,
	NVME_REG_CMBSZ = 60,
	NVME_REG_BPINFO = 64,
	NVME_REG_BPRSEL = 68,
	NVME_REG_BPMBL = 72,
	NVME_REG_CMBMSC = 80,
	NVME_REG_CRTO = 104,
	NVME_REG_PMRCAP = 3584,
	NVME_REG_PMRCTL = 3588,
	NVME_REG_PMRSTS = 3592,
	NVME_REG_PMREBS = 3596,
	NVME_REG_PMRSWTP = 3600,
	NVME_REG_DBS = 4096,
};

enum {
	OD_NORMAL_SAMPLE = 0,
	OD_SUB_SAMPLE = 1,
};

enum {
	ONLINE_POLICY_CONTIG_ZONES = 0,
	ONLINE_POLICY_AUTO_MOVABLE = 1,
};

enum {
	OPT_DAX = 0,
	OPT_DAX_ENUM = 1,
};

enum {
	OPT_SOURCE = 0,
	OPT_SUBTYPE = 1,
	OPT_FD = 2,
	OPT_ROOTMODE = 3,
	OPT_USER_ID = 4,
	OPT_GROUP_ID = 5,
	OPT_DEFAULT_PERMISSIONS = 6,
	OPT_ALLOW_OTHER = 7,
	OPT_MAX_READ = 8,
	OPT_BLKSIZE = 9,
	OPT_ERR = 10,
};

enum {
	OPT_UID = 0,
	OPT_GID = 1,
	OPT_MODE = 2,
	OPT_DELEGATE_CMDS = 3,
	OPT_DELEGATE_MAPS = 4,
	OPT_DELEGATE_PROGS = 5,
	OPT_DELEGATE_ATTACHS = 6,
};

enum {
	OVERRIDE_NONE = 0,
	OVERRIDE_BASE = 1,
	OVERRIDE_STRIDE = 2,
	OVERRIDE_HEIGHT = 4,
	OVERRIDE_WIDTH = 8,
};

enum {
	Opt_direct = 0,
	Opt_fd = 1,
	Opt_gid = 2,
	Opt_ignore = 3,
	Opt_indirect = 4,
	Opt_maxproto = 5,
	Opt_minproto = 6,
	Opt_offset = 7,
	Opt_pgrp = 8,
	Opt_strictexpire = 9,
	Opt_uid = 10,
};

enum {
	Opt_err = 0,
	Opt_enc = 1,
	Opt_hash = 2,
};

enum {
	Opt_error = -1,
	Opt_fsdefault = 0,
	Opt_fsfloor = 1,
	Opt_fshat = 2,
	Opt_fsroot = 3,
	Opt_fstransmute = 4,
};

enum {
	Opt_error___2 = -1,
	Opt_context = 0,
	Opt_defcontext = 1,
	Opt_fscontext = 2,
	Opt_rootcontext = 3,
	Opt_seclabel = 4,
};

enum {
	Opt_kmsg_bytes = 0,
};

enum {
	Opt_uid___2 = 0,
	Opt_gid___2 = 1,
};

enum {
	Opt_uid___3 = 0,
	Opt_gid___3 = 1,
	Opt_mode = 2,
};

enum {
	Opt_uid___4 = 0,
	Opt_gid___4 = 1,
	Opt_mode___2 = 2,
	Opt_source = 3,
};

enum {
	Opt_uid___5 = 0,
	Opt_gid___5 = 1,
	Opt_mode___3 = 2,
	Opt_ptmxmode = 3,
	Opt_newinstance = 4,
	Opt_max = 5,
	Opt_err___2 = 6,
};

enum {
	PAD_CONNECT_NONE = 0,
	PAD_CONNECT_INPUT = 1,
	PAD_CONNECT_OUTPUT = 2,
	PAD_CONNECT_FULL = 3,
};

enum {
	PAD_UNLOCKED = 0,
	PAD_LOCKED = 1,
	PAD_LOCKED_TX = 2,
	PAD_LOCKED_FULL = 3,
};

enum {
	PAGE_REPORTING_IDLE = 0,
	PAGE_REPORTING_REQUESTED = 1,
	PAGE_REPORTING_ACTIVE = 2,
};

enum {
	PAGE_WAS_MAPPED = 1,
	PAGE_WAS_MLOCKED = 2,
	PAGE_OLD_STATES = 3,
};

enum {
	PCI_REASSIGN_ALL_RSRC = 1,
	PCI_REASSIGN_ALL_BUS = 2,
	PCI_PROBE_ONLY = 4,
	PCI_CAN_SKIP_ISA_ALIGN = 8,
	PCI_ENABLE_PROC_DOMAINS = 16,
	PCI_COMPAT_DOMAIN_0 = 32,
	PCI_SCAN_ALL_PCIE_DEVS = 64,
};

enum {
	PCI_STD_RESOURCES = 0,
	PCI_STD_RESOURCE_END = 5,
	PCI_ROM_RESOURCE = 6,
	PCI_IOV_RESOURCES = 7,
	PCI_IOV_RESOURCE_END = 12,
	PCI_BRIDGE_RESOURCES = 13,
	PCI_BRIDGE_RESOURCE_END = 16,
	PCI_NUM_RESOURCES = 17,
	DEVICE_COUNT_RESOURCE = 17,
};

enum {
	PERCPU_REF_INIT_ATOMIC = 1,
	PERCPU_REF_INIT_DEAD = 2,
	PERCPU_REF_ALLOW_REINIT = 4,
};

enum {
	PERF_BR_SPEC_NA = 0,
	PERF_BR_SPEC_WRONG_PATH = 1,
	PERF_BR_NON_SPEC_CORRECT_PATH = 2,
	PERF_BR_SPEC_CORRECT_PATH = 3,
	PERF_BR_SPEC_MAX = 4,
};

enum {
	PERF_BR_UNKNOWN = 0,
	PERF_BR_COND = 1,
	PERF_BR_UNCOND = 2,
	PERF_BR_IND = 3,
	PERF_BR_CALL = 4,
	PERF_BR_IND_CALL = 5,
	PERF_BR_RET = 6,
	PERF_BR_SYSCALL = 7,
	PERF_BR_SYSRET = 8,
	PERF_BR_COND_CALL = 9,
	PERF_BR_COND_RET = 10,
	PERF_BR_ERET = 11,
	PERF_BR_IRQ = 12,
	PERF_BR_SERROR = 13,
	PERF_BR_NO_TX = 14,
	PERF_BR_EXTEND_ABI = 15,
	PERF_BR_MAX = 16,
};

enum {
	PERF_TXN_ELISION = 1ULL,
	PERF_TXN_TRANSACTION = 2ULL,
	PERF_TXN_SYNC = 4ULL,
	PERF_TXN_ASYNC = 8ULL,
	PERF_TXN_RETRY = 16ULL,
	PERF_TXN_CONFLICT = 32ULL,
	PERF_TXN_CAPACITY_WRITE = 64ULL,
	PERF_TXN_CAPACITY_READ = 128ULL,
	PERF_TXN_MAX = 256ULL,
	PERF_TXN_ABORT_MASK = 18446744069414584320ULL,
	PERF_TXN_ABORT_SHIFT = 32ULL,
};

enum {
	PERF_X86_EVENT_PEBS_LDLAT = 1,
	PERF_X86_EVENT_PEBS_ST = 2,
	PERF_X86_EVENT_PEBS_ST_HSW = 4,
	PERF_X86_EVENT_PEBS_LD_HSW = 8,
	PERF_X86_EVENT_PEBS_NA_HSW = 16,
	PERF_X86_EVENT_EXCL = 32,
	PERF_X86_EVENT_DYNAMIC = 64,
	PERF_X86_EVENT_PEBS_CNTR = 128,
	PERF_X86_EVENT_EXCL_ACCT = 256,
	PERF_X86_EVENT_AUTO_RELOAD = 512,
	PERF_X86_EVENT_LARGE_PEBS = 1024,
	PERF_X86_EVENT_PEBS_VIA_PT = 2048,
	PERF_X86_EVENT_PAIR = 4096,
	PERF_X86_EVENT_LBR_SELECT = 8192,
	PERF_X86_EVENT_TOPDOWN = 16384,
	PERF_X86_EVENT_PEBS_STLAT = 32768,
	PERF_X86_EVENT_AMD_BRS = 65536,
	PERF_X86_EVENT_PEBS_LAT_HYBRID = 131072,
	PERF_X86_EVENT_NEEDS_BRANCH_STACK = 262144,
	PERF_X86_EVENT_BRANCH_COUNTERS = 524288,
	PERF_X86_EVENT_ACR = 1048576,
};

enum {
	PER_LINUX = 0,
	PER_LINUX_32BIT = 8388608,
	PER_LINUX_FDPIC = 524288,
	PER_SVR4 = 68157441,
	PER_SVR3 = 83886082,
	PER_SCOSVR3 = 117440515,
	PER_OSR5 = 100663299,
	PER_WYSEV386 = 83886084,
	PER_ISCR4 = 67108869,
	PER_BSD = 6,
	PER_SUNOS = 67108870,
	PER_XENIX = 83886087,
	PER_LINUX32 = 8,
	PER_LINUX32_3GB = 134217736,
	PER_IRIX32 = 67108873,
	PER_IRIXN32 = 67108874,
	PER_IRIX64 = 67108875,
	PER_RISCOS = 12,
	PER_SOLARIS = 67108877,
	PER_UW7 = 68157454,
	PER_OSF4 = 15,
	PER_HPUX = 16,
	PER_MASK = 255,
};

enum {
	PIM_TYPE_HELLO = 0,
	PIM_TYPE_REGISTER = 1,
	PIM_TYPE_REGISTER_STOP = 2,
	PIM_TYPE_JOIN_PRUNE = 3,
	PIM_TYPE_BOOTSTRAP = 4,
	PIM_TYPE_ASSERT = 5,
	PIM_TYPE_GRAFT = 6,
	PIM_TYPE_GRAFT_ACK = 7,
	PIM_TYPE_CANDIDATE_RP_ADV = 8,
};

enum {
	PLAT8250_DEV_LEGACY = -1,
	PLAT8250_DEV_PLATFORM = 0,
	PLAT8250_DEV_PLATFORM1 = 1,
	PLAT8250_DEV_PLATFORM2 = 2,
	PLAT8250_DEV_FOURPORT = 3,
	PLAT8250_DEV_ACCENT = 4,
	PLAT8250_DEV_BOCA = 5,
	PLAT8250_DEV_EXAR_ST16C554 = 6,
	PLAT8250_DEV_HUB6 = 7,
	PLAT8250_DEV_AU1X00 = 8,
	PLAT8250_DEV_SM501 = 9,
};

enum {
	PM8607_IRQ_ONKEY = 0,
	PM8607_IRQ_EXTON = 1,
	PM8607_IRQ_CHG = 2,
	PM8607_IRQ_BAT = 3,
	PM8607_IRQ_RTC = 4,
	PM8607_IRQ_CC = 5,
	PM8607_IRQ_VBAT = 6,
	PM8607_IRQ_VCHG = 7,
	PM8607_IRQ_VSYS = 8,
	PM8607_IRQ_TINT = 9,
	PM8607_IRQ_GPADC0 = 10,
	PM8607_IRQ_GPADC1 = 11,
	PM8607_IRQ_GPADC2 = 12,
	PM8607_IRQ_GPADC3 = 13,
	PM8607_IRQ_AUDIO_SHORT = 14,
	PM8607_IRQ_PEN = 15,
	PM8607_IRQ_HEADSET = 16,
	PM8607_IRQ_HOOK = 17,
	PM8607_IRQ_MICIN = 18,
	PM8607_IRQ_CHG_FAIL = 19,
	PM8607_IRQ_CHG_DONE = 20,
	PM8607_IRQ_CHG_FAULT = 21,
};

enum {
	POLICYDB_CAP_NETPEER = 0,
	POLICYDB_CAP_OPENPERM = 1,
	POLICYDB_CAP_EXTSOCKCLASS = 2,
	POLICYDB_CAP_ALWAYSNETWORK = 3,
	POLICYDB_CAP_CGROUPSECLABEL = 4,
	POLICYDB_CAP_NNP_NOSUID_TRANSITION = 5,
	POLICYDB_CAP_GENFS_SECLABEL_SYMLINKS = 6,
	POLICYDB_CAP_IOCTL_SKIP_CLOEXEC = 7,
	POLICYDB_CAP_USERSPACE_INITIAL_CONTEXT = 8,
	POLICYDB_CAP_NETLINK_XPERM = 9,
	POLICYDB_CAP_NETIF_WILDCARD = 10,
	POLICYDB_CAP_GENFS_SECLABEL_WILDCARD = 11,
	__POLICYDB_CAP_MAX = 12,
};

enum {
	POOL_BITS = 256,
	POOL_READY_BITS = 256,
	POOL_EARLY_BITS = 128,
};

enum {
	POWER_SUPPLY_CAPACITY_LEVEL_UNKNOWN = 0,
	POWER_SUPPLY_CAPACITY_LEVEL_CRITICAL = 1,
	POWER_SUPPLY_CAPACITY_LEVEL_LOW = 2,
	POWER_SUPPLY_CAPACITY_LEVEL_NORMAL = 3,
	POWER_SUPPLY_CAPACITY_LEVEL_HIGH = 4,
	POWER_SUPPLY_CAPACITY_LEVEL_FULL = 5,
};

enum {
	POWER_SUPPLY_HEALTH_UNKNOWN = 0,
	POWER_SUPPLY_HEALTH_GOOD = 1,
	POWER_SUPPLY_HEALTH_OVERHEAT = 2,
	POWER_SUPPLY_HEALTH_DEAD = 3,
	POWER_SUPPLY_HEALTH_OVERVOLTAGE = 4,
	POWER_SUPPLY_HEALTH_UNDERVOLTAGE = 5,
	POWER_SUPPLY_HEALTH_UNSPEC_FAILURE = 6,
	POWER_SUPPLY_HEALTH_COLD = 7,
	POWER_SUPPLY_HEALTH_WATCHDOG_TIMER_EXPIRE = 8,
	POWER_SUPPLY_HEALTH_SAFETY_TIMER_EXPIRE = 9,
	POWER_SUPPLY_HEALTH_OVERCURRENT = 10,
	POWER_SUPPLY_HEALTH_CALIBRATION_REQUIRED = 11,
	POWER_SUPPLY_HEALTH_WARM = 12,
	POWER_SUPPLY_HEALTH_COOL = 13,
	POWER_SUPPLY_HEALTH_HOT = 14,
	POWER_SUPPLY_HEALTH_NO_BATTERY = 15,
	POWER_SUPPLY_HEALTH_BLOWN_FUSE = 16,
	POWER_SUPPLY_HEALTH_CELL_IMBALANCE = 17,
};

enum {
	POWER_SUPPLY_SCOPE_UNKNOWN = 0,
	POWER_SUPPLY_SCOPE_SYSTEM = 1,
	POWER_SUPPLY_SCOPE_DEVICE = 2,
};

enum {
	POWER_SUPPLY_STATUS_UNKNOWN = 0,
	POWER_SUPPLY_STATUS_CHARGING = 1,
	POWER_SUPPLY_STATUS_DISCHARGING = 2,
	POWER_SUPPLY_STATUS_NOT_CHARGING = 3,
	POWER_SUPPLY_STATUS_FULL = 4,
};

enum {
	POWER_SUPPLY_TECHNOLOGY_UNKNOWN = 0,
	POWER_SUPPLY_TECHNOLOGY_NiMH = 1,
	POWER_SUPPLY_TECHNOLOGY_LION = 2,
	POWER_SUPPLY_TECHNOLOGY_LIPO = 3,
	POWER_SUPPLY_TECHNOLOGY_LiFe = 4,
	POWER_SUPPLY_TECHNOLOGY_NiCd = 5,
	POWER_SUPPLY_TECHNOLOGY_LiMn = 6,
};

enum {
	PREFIX_UNSPEC = 0,
	PREFIX_ADDRESS = 1,
	PREFIX_CACHEINFO = 2,
	__PREFIX_MAX = 3,
};

enum {
	PROCESS_BPF_EXIT = 1,
};

enum {
	PROCESS_SPIN_LOCK = 1,
	PROCESS_RES_LOCK = 2,
	PROCESS_LOCK_IRQ = 4,
};

enum {
	PROC_ENTRY_PERMANENT = 1,
	PROC_ENTRY_proc_read_iter = 2,
	PROC_ENTRY_proc_compat_ioctl = 4,
	PROC_ENTRY_proc_lseek = 8,
	PROC_ENTRY_FORCE_LOOKUP = 128,
};

enum {
	PROC_IPC_INIT_INO = 4026531839,
	PROC_UTS_INIT_INO = 4026531838,
	PROC_USER_INIT_INO = 4026531837,
	PROC_PID_INIT_INO = 4026531836,
	PROC_CGROUP_INIT_INO = 4026531835,
	PROC_TIME_INIT_INO = 4026531834,
	PROC_NET_INIT_INO = 4026531833,
	PROC_MNT_INIT_INO = 4026531832,
};

enum {
	PSS = 0,
	PPC = 1,
};

enum {
	PWMF_REQUESTED = 0,
	PWMF_EXPORTED = 1,
};

enum {
	QIF_BLIMITS_B = 0,
	QIF_SPACE_B = 1,
	QIF_ILIMITS_B = 2,
	QIF_INODES_B = 3,
	QIF_BTIME_B = 4,
	QIF_ITIME_B = 5,
};

enum {
	QI_FREE = 0,
	QI_IN_USE = 1,
	QI_DONE = 2,
	QI_ABORT = 3,
};

enum {
	QOS_ENABLE = 0,
	QOS_CTRL = 1,
	NR_QOS_CTRL_PARAMS = 2,
};

enum {
	QOS_RPPM = 0,
	QOS_RLAT = 1,
	QOS_WPPM = 2,
	QOS_WLAT = 3,
	QOS_MIN = 4,
	QOS_MAX = 5,
	NR_QOS_PARAMS = 6,
};

enum {
	QUEUE_FLAG_DYING = 0,
	QUEUE_FLAG_NOMERGES = 1,
	QUEUE_FLAG_SAME_COMP = 2,
	QUEUE_FLAG_FAIL_IO = 3,
	QUEUE_FLAG_NOXMERGES = 4,
	QUEUE_FLAG_SAME_FORCE = 5,
	QUEUE_FLAG_INIT_DONE = 6,
	QUEUE_FLAG_STATS = 7,
	QUEUE_FLAG_REGISTERED = 8,
	QUEUE_FLAG_QUIESCED = 9,
	QUEUE_FLAG_RQ_ALLOC_TIME = 10,
	QUEUE_FLAG_HCTX_ACTIVE = 11,
	QUEUE_FLAG_SQ_SCHED = 12,
	QUEUE_FLAG_DISABLE_WBT_DEF = 13,
	QUEUE_FLAG_NO_ELV_SWITCH = 14,
	QUEUE_FLAG_QOS_ENABLED = 15,
	QUEUE_FLAG_MAX = 16,
};

enum {
	QUOTA_NL_A_UNSPEC = 0,
	QUOTA_NL_A_QTYPE = 1,
	QUOTA_NL_A_EXCESS_ID = 2,
	QUOTA_NL_A_WARNING = 3,
	QUOTA_NL_A_DEV_MAJOR = 4,
	QUOTA_NL_A_DEV_MINOR = 5,
	QUOTA_NL_A_CAUSED_ID = 6,
	QUOTA_NL_A_PAD = 7,
	__QUOTA_NL_A_MAX = 8,
};

enum {
	QUOTA_NL_C_UNSPEC = 0,
	QUOTA_NL_C_WARNING = 1,
	__QUOTA_NL_C_MAX = 2,
};

enum {
	Q_REQUEUE_PI_NONE = 0,
	Q_REQUEUE_PI_IGNORE = 1,
	Q_REQUEUE_PI_IN_PROGRESS = 2,
	Q_REQUEUE_PI_WAIT = 3,
	Q_REQUEUE_PI_DONE = 4,
	Q_REQUEUE_PI_LOCKED = 5,
};

enum {
	RADIX_TREE_ITER_TAG_MASK = 15,
	RADIX_TREE_ITER_TAGGED = 16,
	RADIX_TREE_ITER_CONTIG = 32,
};

enum {
	RB_ADD_STAMP_NONE = 0,
	RB_ADD_STAMP_EXTEND = 2,
	RB_ADD_STAMP_ABSOLUTE = 4,
	RB_ADD_STAMP_FORCE = 8,
};

enum {
	RB_CTX_TRANSITION = 0,
	RB_CTX_NMI = 1,
	RB_CTX_IRQ = 2,
	RB_CTX_SOFTIRQ = 3,
	RB_CTX_NORMAL = 4,
	RB_CTX_MAX = 5,
};

enum {
	RB_LEN_TIME_EXTEND = 8,
	RB_LEN_TIME_STAMP = 8,
};

enum {
	RC5T583_DS_NONE = 0,
	RC5T583_DS_DC0 = 1,
	RC5T583_DS_DC1 = 2,
	RC5T583_DS_DC2 = 3,
	RC5T583_DS_DC3 = 4,
	RC5T583_DS_LDO0 = 5,
	RC5T583_DS_LDO1 = 6,
	RC5T583_DS_LDO2 = 7,
	RC5T583_DS_LDO3 = 8,
	RC5T583_DS_LDO4 = 9,
	RC5T583_DS_LDO5 = 10,
	RC5T583_DS_LDO6 = 11,
	RC5T583_DS_LDO7 = 12,
	RC5T583_DS_LDO8 = 13,
	RC5T583_DS_LDO9 = 14,
	RC5T583_DS_PSO0 = 15,
	RC5T583_DS_PSO1 = 16,
	RC5T583_DS_PSO2 = 17,
	RC5T583_DS_PSO3 = 18,
	RC5T583_DS_PSO4 = 19,
	RC5T583_DS_PSO5 = 20,
	RC5T583_DS_PSO6 = 21,
	RC5T583_DS_PSO7 = 22,
	RC5T583_DS_MAX = 23,
};

enum {
	RC5T583_EXT_PWRREQ1_CONTROL = 1,
	RC5T583_EXT_PWRREQ2_CONTROL = 2,
};

enum {
	RC5T583_GPIO0 = 0,
	RC5T583_GPIO1 = 1,
	RC5T583_GPIO2 = 2,
	RC5T583_GPIO3 = 3,
	RC5T583_GPIO4 = 4,
	RC5T583_GPIO5 = 5,
	RC5T583_GPIO6 = 6,
	RC5T583_GPIO7 = 7,
	RC5T583_MAX_GPIO = 8,
};

enum {
	RC5T583_IRQ_ONKEY = 0,
	RC5T583_IRQ_ACOK = 1,
	RC5T583_IRQ_LIDOPEN = 2,
	RC5T583_IRQ_PREOT = 3,
	RC5T583_IRQ_CLKSTP = 4,
	RC5T583_IRQ_ONKEY_OFF = 5,
	RC5T583_IRQ_WD = 6,
	RC5T583_IRQ_EN_PWRREQ1 = 7,
	RC5T583_IRQ_EN_PWRREQ2 = 8,
	RC5T583_IRQ_PRE_VINDET = 9,
	RC5T583_IRQ_DC0LIM = 10,
	RC5T583_IRQ_DC1LIM = 11,
	RC5T583_IRQ_DC2LIM = 12,
	RC5T583_IRQ_DC3LIM = 13,
	RC5T583_IRQ_CTC = 14,
	RC5T583_IRQ_YALE = 15,
	RC5T583_IRQ_DALE = 16,
	RC5T583_IRQ_WALE = 17,
	RC5T583_IRQ_AIN1L = 18,
	RC5T583_IRQ_AIN2L = 19,
	RC5T583_IRQ_AIN3L = 20,
	RC5T583_IRQ_VBATL = 21,
	RC5T583_IRQ_VIN3L = 22,
	RC5T583_IRQ_VIN8L = 23,
	RC5T583_IRQ_AIN1H = 24,
	RC5T583_IRQ_AIN2H = 25,
	RC5T583_IRQ_AIN3H = 26,
	RC5T583_IRQ_VBATH = 27,
	RC5T583_IRQ_VIN3H = 28,
	RC5T583_IRQ_VIN8H = 29,
	RC5T583_IRQ_ADCEND = 30,
	RC5T583_IRQ_GPIO0 = 31,
	RC5T583_IRQ_GPIO1 = 32,
	RC5T583_IRQ_GPIO2 = 33,
	RC5T583_IRQ_GPIO3 = 34,
	RC5T583_IRQ_GPIO4 = 35,
	RC5T583_IRQ_GPIO5 = 36,
	RC5T583_IRQ_GPIO6 = 37,
	RC5T583_IRQ_GPIO7 = 38,
	RC5T583_MAX_IRQS = 39,
};

enum {
	RC5T583_REGULATOR_DC0 = 0,
	RC5T583_REGULATOR_DC1 = 1,
	RC5T583_REGULATOR_DC2 = 2,
	RC5T583_REGULATOR_DC3 = 3,
	RC5T583_REGULATOR_LDO0 = 4,
	RC5T583_REGULATOR_LDO1 = 5,
	RC5T583_REGULATOR_LDO2 = 6,
	RC5T583_REGULATOR_LDO3 = 7,
	RC5T583_REGULATOR_LDO4 = 8,
	RC5T583_REGULATOR_LDO5 = 9,
	RC5T583_REGULATOR_LDO6 = 10,
	RC5T583_REGULATOR_LDO7 = 11,
	RC5T583_REGULATOR_LDO8 = 12,
	RC5T583_REGULATOR_LDO9 = 13,
	RC5T583_REGULATOR_MAX = 14,
};

enum {
	RCD = 0,
	RCH_DP = 1,
	DEVICE = 2,
	LD = 3,
	FMLD = 4,
	RP = 5,
	DSP = 6,
	USP = 7,
};

enum {
	RDT_FLAG_CMT = 0,
	RDT_FLAG_MBM_TOTAL = 1,
	RDT_FLAG_MBM_LOCAL = 2,
	RDT_FLAG_L3_CAT = 3,
	RDT_FLAG_L3_CDP = 4,
	RDT_FLAG_L2_CAT = 5,
	RDT_FLAG_L2_CDP = 6,
	RDT_FLAG_MBA = 7,
	RDT_FLAG_SMBA = 8,
	RDT_FLAG_BMEC = 9,
};

enum {
	REASON_BOUNDS = -1,
	REASON_TYPE = -2,
	REASON_PATHS = -3,
	REASON_LIMIT = -4,
	REASON_STACK = -5,
};

enum {
	REGION_INTERSECTS = 0,
	REGION_DISJOINT = 1,
	REGION_MIXED = 2,
};

enum {
	REGULATOR_ERROR_CLEARED = 0,
	REGULATOR_FAILED_RETRY = 1,
	REGULATOR_ERROR_ON = 2,
};

enum {
	REG_GENL_ATTR_UNSPEC = 0,
	REG_GENL_ATTR_EVENT = 1,
	__REG_GENL_ATTR_MAX = 2,
};

enum {
	REG_GENL_CMD_UNSPEC = 0,
	REG_GENL_CMD_EVENT = 1,
	__REG_GENL_CMD_MAX = 2,
};

enum {
	RELAY_STATS_BUF_FULL = 1,
	RELAY_STATS_WRT_BIG = 2,
	RELAY_STATS_LAST = 2,
};

enum {
	REQ_FSEQ_PREFLUSH = 1,
	REQ_FSEQ_DATA = 2,
	REQ_FSEQ_POSTFLUSH = 4,
	REQ_FSEQ_DONE = 8,
	REQ_FSEQ_ACTIONS = 7,
	FLUSH_PENDING_TIMEOUT = 5000,
};

enum {
	REQ_F_FIXED_FILE = 1ULL,
	REQ_F_IO_DRAIN = 2ULL,
	REQ_F_LINK = 4ULL,
	REQ_F_HARDLINK = 8ULL,
	REQ_F_FORCE_ASYNC = 16ULL,
	REQ_F_BUFFER_SELECT = 32ULL,
	REQ_F_CQE_SKIP = 64ULL,
	REQ_F_FAIL = 256ULL,
	REQ_F_INFLIGHT = 512ULL,
	REQ_F_CUR_POS = 1024ULL,
	REQ_F_NOWAIT = 2048ULL,
	REQ_F_LINK_TIMEOUT = 4096ULL,
	REQ_F_NEED_CLEANUP = 8192ULL,
	REQ_F_POLLED = 16384ULL,
	REQ_F_IOPOLL_STATE = 32768ULL,
	REQ_F_BUFFER_SELECTED = 65536ULL,
	REQ_F_BUFFER_RING = 131072ULL,
	REQ_F_REISSUE = 262144ULL,
	REQ_F_SUPPORT_NOWAIT = 536870912ULL,
	REQ_F_ISREG = 1073741824ULL,
	REQ_F_CREDS = 524288ULL,
	REQ_F_REFCOUNT = 1048576ULL,
	REQ_F_ARM_LTIMEOUT = 2097152ULL,
	REQ_F_ASYNC_DATA = 4194304ULL,
	REQ_F_SKIP_LINK_CQES = 8388608ULL,
	REQ_F_SINGLE_POLL = 16777216ULL,
	REQ_F_DOUBLE_POLL = 33554432ULL,
	REQ_F_MULTISHOT = 67108864ULL,
	REQ_F_APOLL_MULTISHOT = 134217728ULL,
	REQ_F_CLEAR_POLLIN = 268435456ULL,
	REQ_F_POLL_NO_LAZY = 2147483648ULL,
	REQ_F_CAN_POLL = 4294967296ULL,
	REQ_F_BL_EMPTY = 8589934592ULL,
	REQ_F_BL_NO_RECYCLE = 17179869184ULL,
	REQ_F_BUFFERS_COMMIT = 34359738368ULL,
	REQ_F_BUF_NODE = 68719476736ULL,
	REQ_F_HAS_METADATA = 137438953472ULL,
	REQ_F_IMPORT_BUFFER = 274877906944ULL,
	REQ_F_SQE_COPIED = 549755813888ULL,
};

enum {
	REQ_F_FIXED_FILE_BIT = 0,
	REQ_F_IO_DRAIN_BIT = 1,
	REQ_F_LINK_BIT = 2,
	REQ_F_HARDLINK_BIT = 3,
	REQ_F_FORCE_ASYNC_BIT = 4,
	REQ_F_BUFFER_SELECT_BIT = 5,
	REQ_F_CQE_SKIP_BIT = 6,
	REQ_F_FAIL_BIT = 8,
	REQ_F_INFLIGHT_BIT = 9,
	REQ_F_CUR_POS_BIT = 10,
	REQ_F_NOWAIT_BIT = 11,
	REQ_F_LINK_TIMEOUT_BIT = 12,
	REQ_F_NEED_CLEANUP_BIT = 13,
	REQ_F_POLLED_BIT = 14,
	REQ_F_HYBRID_IOPOLL_STATE_BIT = 15,
	REQ_F_BUFFER_SELECTED_BIT = 16,
	REQ_F_BUFFER_RING_BIT = 17,
	REQ_F_REISSUE_BIT = 18,
	REQ_F_CREDS_BIT = 19,
	REQ_F_REFCOUNT_BIT = 20,
	REQ_F_ARM_LTIMEOUT_BIT = 21,
	REQ_F_ASYNC_DATA_BIT = 22,
	REQ_F_SKIP_LINK_CQES_BIT = 23,
	REQ_F_SINGLE_POLL_BIT = 24,
	REQ_F_DOUBLE_POLL_BIT = 25,
	REQ_F_MULTISHOT_BIT = 26,
	REQ_F_APOLL_MULTISHOT_BIT = 27,
	REQ_F_CLEAR_POLLIN_BIT = 28,
	REQ_F_SUPPORT_NOWAIT_BIT = 29,
	REQ_F_ISREG_BIT = 30,
	REQ_F_POLL_NO_LAZY_BIT = 31,
	REQ_F_CAN_POLL_BIT = 32,
	REQ_F_BL_EMPTY_BIT = 33,
	REQ_F_BL_NO_RECYCLE_BIT = 34,
	REQ_F_BUFFERS_COMMIT_BIT = 35,
	REQ_F_BUF_NODE_BIT = 36,
	REQ_F_HAS_METADATA_BIT = 37,
	REQ_F_IMPORT_BUFFER_BIT = 38,
	REQ_F_SQE_COPIED_BIT = 39,
	__REQ_F_LAST_BIT = 40,
};

enum {
	RES_USAGE = 0,
	RES_RSVD_USAGE = 1,
	RES_LIMIT = 2,
	RES_RSVD_LIMIT = 3,
	RES_MAX_USAGE = 4,
	RES_RSVD_MAX_USAGE = 5,
	RES_FAILCNT = 6,
	RES_RSVD_FAILCNT = 7,
};

enum {
	RNG_SEED_LENGTH = 32,
};

enum {
	RPL_IPTUNNEL_UNSPEC = 0,
	RPL_IPTUNNEL_SRH = 1,
	__RPL_IPTUNNEL_MAX = 2,
};

enum {
	RQ_WAIT_BUSY_PCT = 5,
	UNBUSY_THR_PCT = 75,
	MIN_DELAY_THR_PCT = 500,
	MAX_DELAY_THR_PCT = 25000,
	MIN_DELAY = 250,
	MAX_DELAY = 250000,
	DFGV_USAGE_PCT = 50,
	DFGV_PERIOD = 100000,
	MAX_LAGGING_PERIODS = 10,
	IOC_PAGE_SHIFT = 12,
	IOC_PAGE_SIZE = 4096,
	IOC_SECT_TO_PAGE_SHIFT = 3,
	LCOEF_RANDIO_PAGES = 4096,
};

enum {
	RTAX_UNSPEC = 0,
	RTAX_LOCK = 1,
	RTAX_MTU = 2,
	RTAX_WINDOW = 3,
	RTAX_RTT = 4,
	RTAX_RTTVAR = 5,
	RTAX_SSTHRESH = 6,
	RTAX_CWND = 7,
	RTAX_ADVMSS = 8,
	RTAX_REORDERING = 9,
	RTAX_HOPLIMIT = 10,
	RTAX_INITCWND = 11,
	RTAX_FEATURES = 12,
	RTAX_RTO_MIN = 13,
	RTAX_INITRWND = 14,
	RTAX_QUICKACK = 15,
	RTAX_CC_ALGO = 16,
	RTAX_FASTOPEN_NO_COOKIE = 17,
	__RTAX_MAX = 18,
};

enum {
	RTM_BASE = 16,
	RTM_NEWLINK = 16,
	RTM_DELLINK = 17,
	RTM_GETLINK = 18,
	RTM_SETLINK = 19,
	RTM_NEWADDR = 20,
	RTM_DELADDR = 21,
	RTM_GETADDR = 22,
	RTM_NEWROUTE = 24,
	RTM_DELROUTE = 25,
	RTM_GETROUTE = 26,
	RTM_NEWNEIGH = 28,
	RTM_DELNEIGH = 29,
	RTM_GETNEIGH = 30,
	RTM_NEWRULE = 32,
	RTM_DELRULE = 33,
	RTM_GETRULE = 34,
	RTM_NEWQDISC = 36,
	RTM_DELQDISC = 37,
	RTM_GETQDISC = 38,
	RTM_NEWTCLASS = 40,
	RTM_DELTCLASS = 41,
	RTM_GETTCLASS = 42,
	RTM_NEWTFILTER = 44,
	RTM_DELTFILTER = 45,
	RTM_GETTFILTER = 46,
	RTM_NEWACTION = 48,
	RTM_DELACTION = 49,
	RTM_GETACTION = 50,
	RTM_NEWPREFIX = 52,
	RTM_NEWMULTICAST = 56,
	RTM_DELMULTICAST = 57,
	RTM_GETMULTICAST = 58,
	RTM_NEWANYCAST = 60,
	RTM_DELANYCAST = 61,
	RTM_GETANYCAST = 62,
	RTM_NEWNEIGHTBL = 64,
	RTM_GETNEIGHTBL = 66,
	RTM_SETNEIGHTBL = 67,
	RTM_NEWNDUSEROPT = 68,
	RTM_NEWADDRLABEL = 72,
	RTM_DELADDRLABEL = 73,
	RTM_GETADDRLABEL = 74,
	RTM_GETDCB = 78,
	RTM_SETDCB = 79,
	RTM_NEWNETCONF = 80,
	RTM_DELNETCONF = 81,
	RTM_GETNETCONF = 82,
	RTM_NEWMDB = 84,
	RTM_DELMDB = 85,
	RTM_GETMDB = 86,
	RTM_NEWNSID = 88,
	RTM_DELNSID = 89,
	RTM_GETNSID = 90,
	RTM_NEWSTATS = 92,
	RTM_GETSTATS = 94,
	RTM_SETSTATS = 95,
	RTM_NEWCACHEREPORT = 96,
	RTM_NEWCHAIN = 100,
	RTM_DELCHAIN = 101,
	RTM_GETCHAIN = 102,
	RTM_NEWNEXTHOP = 104,
	RTM_DELNEXTHOP = 105,
	RTM_GETNEXTHOP = 106,
	RTM_NEWLINKPROP = 108,
	RTM_DELLINKPROP = 109,
	RTM_GETLINKPROP = 110,
	RTM_NEWVLAN = 112,
	RTM_DELVLAN = 113,
	RTM_GETVLAN = 114,
	RTM_NEWNEXTHOPBUCKET = 116,
	RTM_DELNEXTHOPBUCKET = 117,
	RTM_GETNEXTHOPBUCKET = 118,
	RTM_NEWTUNNEL = 120,
	RTM_DELTUNNEL = 121,
	RTM_GETTUNNEL = 122,
	__RTM_MAX = 123,
};

enum {
	RTN_UNSPEC = 0,
	RTN_UNICAST = 1,
	RTN_LOCAL = 2,
	RTN_BROADCAST = 3,
	RTN_ANYCAST = 4,
	RTN_MULTICAST = 5,
	RTN_BLACKHOLE = 6,
	RTN_UNREACHABLE = 7,
	RTN_PROHIBIT = 8,
	RTN_THROW = 9,
	RTN_NAT = 10,
	RTN_XRESOLVE = 11,
	__RTN_MAX = 12,
};

enum {
	RWB_DEF_DEPTH = 16,
	RWB_WINDOW_NSEC = 100000000,
	RWB_MIN_WRITE_SAMPLES = 3,
	RWB_UNKNOWN_BUMP = 5,
};

enum {
	Root_NFS = 255,
	Root_CIFS = 254,
	Root_Generic = 253,
	Root_RAM0 = 1048576,
};

enum {
	SAMPLES = 8,
	MIN_CHANGE = 5,
};

enum {
	SB_UNFROZEN = 0,
	SB_FREEZE_WRITE = 1,
	SB_FREEZE_PAGEFAULT = 2,
	SB_FREEZE_FS = 3,
	SB_FREEZE_COMPLETE = 4,
};

enum {
	SCM_TSTAMP_SND = 0,
	SCM_TSTAMP_SCHED = 1,
	SCM_TSTAMP_ACK = 2,
	SCM_TSTAMP_COMPLETION = 3,
};

enum {
	SCSI_DH_OK = 0,
	SCSI_DH_DEV_FAILED = 1,
	SCSI_DH_DEV_TEMP_BUSY = 2,
	SCSI_DH_DEV_UNSUPP = 3,
	SCSI_DH_DEVICE_MAX = 4,
	SCSI_DH_NOTCONN = 5,
	SCSI_DH_CONN_FAILURE = 6,
	SCSI_DH_TRANSPORT_MAX = 7,
	SCSI_DH_IO = 8,
	SCSI_DH_INVALID_IO = 9,
	SCSI_DH_RETRY = 10,
	SCSI_DH_IMM_RETRY = 11,
	SCSI_DH_TIMED_OUT = 12,
	SCSI_DH_RES_TEMP_UNAVAIL = 13,
	SCSI_DH_DEV_OFFLINED = 14,
	SCSI_DH_NOMEM = 15,
	SCSI_DH_NOSYS = 16,
	SCSI_DH_DRIVER_MAX = 17,
};

enum {
	SCTP_AUTH_HMAC_ID_RESERVED_0 = 0,
	SCTP_AUTH_HMAC_ID_SHA1 = 1,
	SCTP_AUTH_HMAC_ID_RESERVED_2 = 2,
	SCTP_AUTH_HMAC_ID_SHA256 = 3,
	__SCTP_AUTH_HMAC_MAX = 4,
};

enum {
	SCTP_MAX_DUP_TSNS = 16,
};

enum {
	SCTP_MAX_STREAM = 65535,
};

enum {
	SD_BALANCE_NEWIDLE = 1,
	SD_BALANCE_EXEC = 2,
	SD_BALANCE_FORK = 4,
	SD_BALANCE_WAKE = 8,
	SD_WAKE_AFFINE = 16,
	SD_ASYM_CPUCAPACITY = 32,
	SD_ASYM_CPUCAPACITY_FULL = 64,
	SD_SHARE_CPUCAPACITY = 128,
	SD_CLUSTER = 256,
	SD_SHARE_LLC = 512,
	SD_SERIALIZE = 1024,
	SD_ASYM_PACKING = 2048,
	SD_PREFER_SIBLING = 4096,
	SD_NUMA = 8192,
};

enum {
	SD_DEF_XFER_BLOCKS = 65535,
	SD_MAX_XFER_BLOCKS = 4294967295,
	SD_MAX_WS10_BLOCKS = 65535,
	SD_MAX_WS16_BLOCKS = 8388607,
};

enum {
	SD_EXT_CDB_SIZE = 32,
	SD_MEMPOOL_SIZE = 2,
};

enum {
	SD_LBP_FULL = 0,
	SD_LBP_UNMAP = 1,
	SD_LBP_WS16 = 2,
	SD_LBP_WS10 = 3,
	SD_LBP_ZERO = 4,
	SD_LBP_DISABLE = 5,
};

enum {
	SD_ZERO_WRITE = 0,
	SD_ZERO_WS = 1,
	SD_ZERO_WS16_UNMAP = 2,
	SD_ZERO_WS10_UNMAP = 3,
};

enum {
	SECTION_MARKED_PRESENT_BIT = 0,
	SECTION_HAS_MEM_MAP_BIT = 1,
	SECTION_IS_ONLINE_BIT = 2,
	SECTION_IS_EARLY_BIT = 3,
	SECTION_TAINT_ZONE_DEVICE_BIT = 4,
	SECTION_IS_VMEMMAP_PREINIT_BIT = 5,
	SECTION_MAP_LAST_BIT = 6,
};

enum {
	SEG6_ATTR_UNSPEC = 0,
	SEG6_ATTR_DST = 1,
	SEG6_ATTR_DSTLEN = 2,
	SEG6_ATTR_HMACKEYID = 3,
	SEG6_ATTR_SECRET = 4,
	SEG6_ATTR_SECRETLEN = 5,
	SEG6_ATTR_ALGID = 6,
	SEG6_ATTR_HMACINFO = 7,
	__SEG6_ATTR_MAX = 8,
};

enum {
	SEG6_CMD_UNSPEC = 0,
	SEG6_CMD_SETHMAC = 1,
	SEG6_CMD_DUMPHMAC = 2,
	SEG6_CMD_SET_TUNSRC = 3,
	SEG6_CMD_GET_TUNSRC = 4,
	__SEG6_CMD_MAX = 5,
};

enum {
	SEG6_HMAC_ALGO_SHA1 = 1,
	SEG6_HMAC_ALGO_SHA256 = 2,
};

enum {
	SEG6_IPTUNNEL_UNSPEC = 0,
	SEG6_IPTUNNEL_SRH = 1,
	__SEG6_IPTUNNEL_MAX = 2,
};

enum {
	SEG6_IPTUN_MODE_INLINE = 0,
	SEG6_IPTUN_MODE_ENCAP = 1,
	SEG6_IPTUN_MODE_L2ENCAP = 2,
	SEG6_IPTUN_MODE_ENCAP_RED = 3,
	SEG6_IPTUN_MODE_L2ENCAP_RED = 4,
};

enum {
	SEG6_LOCAL_ACTION_UNSPEC = 0,
	SEG6_LOCAL_ACTION_END = 1,
	SEG6_LOCAL_ACTION_END_X = 2,
	SEG6_LOCAL_ACTION_END_T = 3,
	SEG6_LOCAL_ACTION_END_DX2 = 4,
	SEG6_LOCAL_ACTION_END_DX6 = 5,
	SEG6_LOCAL_ACTION_END_DX4 = 6,
	SEG6_LOCAL_ACTION_END_DT6 = 7,
	SEG6_LOCAL_ACTION_END_DT4 = 8,
	SEG6_LOCAL_ACTION_END_B6 = 9,
	SEG6_LOCAL_ACTION_END_B6_ENCAP = 10,
	SEG6_LOCAL_ACTION_END_BM = 11,
	SEG6_LOCAL_ACTION_END_S = 12,
	SEG6_LOCAL_ACTION_END_AS = 13,
	SEG6_LOCAL_ACTION_END_AM = 14,
	SEG6_LOCAL_ACTION_END_BPF = 15,
	SEG6_LOCAL_ACTION_END_DT46 = 16,
	__SEG6_LOCAL_ACTION_MAX = 17,
};

enum {
	SEG6_LOCAL_BPF_PROG_UNSPEC = 0,
	SEG6_LOCAL_BPF_PROG = 1,
	SEG6_LOCAL_BPF_PROG_NAME = 2,
	__SEG6_LOCAL_BPF_PROG_MAX = 3,
};

enum {
	SEG6_LOCAL_CNT_UNSPEC = 0,
	SEG6_LOCAL_CNT_PAD = 1,
	SEG6_LOCAL_CNT_PACKETS = 2,
	SEG6_LOCAL_CNT_BYTES = 3,
	SEG6_LOCAL_CNT_ERRORS = 4,
	__SEG6_LOCAL_CNT_MAX = 5,
};

enum {
	SEG6_LOCAL_FLV_OP_UNSPEC = 0,
	SEG6_LOCAL_FLV_OP_PSP = 1,
	SEG6_LOCAL_FLV_OP_USP = 2,
	SEG6_LOCAL_FLV_OP_USD = 3,
	SEG6_LOCAL_FLV_OP_NEXT_CSID = 4,
	__SEG6_LOCAL_FLV_OP_MAX = 5,
};

enum {
	SEG6_LOCAL_FLV_UNSPEC = 0,
	SEG6_LOCAL_FLV_OPERATION = 1,
	SEG6_LOCAL_FLV_LCBLOCK_BITS = 2,
	SEG6_LOCAL_FLV_LCNODE_FN_BITS = 3,
	__SEG6_LOCAL_FLV_MAX = 4,
};

enum {
	SEG6_LOCAL_UNSPEC = 0,
	SEG6_LOCAL_ACTION = 1,
	SEG6_LOCAL_SRH = 2,
	SEG6_LOCAL_TABLE = 3,
	SEG6_LOCAL_NH4 = 4,
	SEG6_LOCAL_NH6 = 5,
	SEG6_LOCAL_IIF = 6,
	SEG6_LOCAL_OIF = 7,
	SEG6_LOCAL_BPF = 8,
	SEG6_LOCAL_VRFTABLE = 9,
	SEG6_LOCAL_COUNTERS = 10,
	SEG6_LOCAL_FLAVORS = 11,
	__SEG6_LOCAL_MAX = 12,
};

enum {
	SELNL_MSG_SETENFORCE = 16,
	SELNL_MSG_POLICYLOAD = 17,
	SELNL_MSG_MAX = 18,
};

enum {
	SEV_RET_NO_FW_CALL = -1,
	SEV_RET_SUCCESS = 0,
	SEV_RET_INVALID_PLATFORM_STATE = 1,
	SEV_RET_INVALID_GUEST_STATE = 2,
	SEV_RET_INAVLID_CONFIG = 3,
	SEV_RET_INVALID_CONFIG = 3,
	SEV_RET_INVALID_LEN = 4,
	SEV_RET_ALREADY_OWNED = 5,
	SEV_RET_INVALID_CERTIFICATE = 6,
	SEV_RET_POLICY_FAILURE = 7,
	SEV_RET_INACTIVE = 8,
	SEV_RET_INVALID_ADDRESS = 9,
	SEV_RET_BAD_SIGNATURE = 10,
	SEV_RET_BAD_MEASUREMENT = 11,
	SEV_RET_ASID_OWNED = 12,
	SEV_RET_INVALID_ASID = 13,
	SEV_RET_WBINVD_REQUIRED = 14,
	SEV_RET_DFFLUSH_REQUIRED = 15,
	SEV_RET_INVALID_GUEST = 16,
	SEV_RET_INVALID_COMMAND = 17,
	SEV_RET_ACTIVE = 18,
	SEV_RET_HWSEV_RET_PLATFORM = 19,
	SEV_RET_HWSEV_RET_UNSAFE = 20,
	SEV_RET_UNSUPPORTED = 21,
	SEV_RET_INVALID_PARAM = 22,
	SEV_RET_RESOURCE_LIMIT = 23,
	SEV_RET_SECURE_DATA_INVALID = 24,
	SEV_RET_INVALID_PAGE_SIZE = 25,
	SEV_RET_INVALID_PAGE_STATE = 26,
	SEV_RET_INVALID_MDATA_ENTRY = 27,
	SEV_RET_INVALID_PAGE_OWNER = 28,
	SEV_RET_AEAD_OFLOW = 29,
	SEV_RET_EXIT_RING_BUFFER = 31,
	SEV_RET_RMP_INIT_REQUIRED = 32,
	SEV_RET_BAD_SVN = 33,
	SEV_RET_BAD_VERSION = 34,
	SEV_RET_SHUTDOWN_REQUIRED = 35,
	SEV_RET_UPDATE_FAILED = 36,
	SEV_RET_RESTORE_REQUIRED = 37,
	SEV_RET_RMP_INITIALIZATION_FAILED = 38,
	SEV_RET_INVALID_KEY = 39,
	SEV_RET_MAX = 40,
};

enum {
	SFF8024_ID_UNK = 0,
	SFF8024_ID_SFF_8472 = 2,
	SFF8024_ID_SFP = 3,
	SFF8024_ID_DWDM_SFP = 11,
	SFF8024_ID_QSFP_8438 = 12,
	SFF8024_ID_QSFP_8436_8636 = 13,
	SFF8024_ID_QSFP28_8636 = 17,
	SFF8024_ID_QSFP_DD = 24,
	SFF8024_ID_OSFP = 25,
	SFF8024_ID_DSFP = 27,
	SFF8024_ID_QSFP_PLUS_CMIS = 30,
	SFF8024_ID_SFP_DD_CMIS = 31,
	SFF8024_ID_SFP_PLUS_CMIS = 32,
	SFF8024_ENCODING_UNSPEC = 0,
	SFF8024_ENCODING_8B10B = 1,
	SFF8024_ENCODING_4B5B = 2,
	SFF8024_ENCODING_NRZ = 3,
	SFF8024_ENCODING_8472_MANCHESTER = 4,
	SFF8024_ENCODING_8472_SONET = 5,
	SFF8024_ENCODING_8472_64B66B = 6,
	SFF8024_ENCODING_8436_MANCHESTER = 6,
	SFF8024_ENCODING_8436_SONET = 4,
	SFF8024_ENCODING_8436_64B66B = 5,
	SFF8024_ENCODING_256B257B = 7,
	SFF8024_ENCODING_PAM4 = 8,
	SFF8024_CONNECTOR_UNSPEC = 0,
	SFF8024_CONNECTOR_SC = 1,
	SFF8024_CONNECTOR_FIBERJACK = 6,
	SFF8024_CONNECTOR_LC = 7,
	SFF8024_CONNECTOR_MT_RJ = 8,
	SFF8024_CONNECTOR_MU = 9,
	SFF8024_CONNECTOR_SG = 10,
	SFF8024_CONNECTOR_OPTICAL_PIGTAIL = 11,
	SFF8024_CONNECTOR_MPO_1X12 = 12,
	SFF8024_CONNECTOR_MPO_2X16 = 13,
	SFF8024_CONNECTOR_HSSDC_II = 32,
	SFF8024_CONNECTOR_COPPER_PIGTAIL = 33,
	SFF8024_CONNECTOR_RJ45 = 34,
	SFF8024_CONNECTOR_NOSEPARATE = 35,
	SFF8024_CONNECTOR_MXC_2X16 = 36,
	SFF8024_ECC_UNSPEC = 0,
	SFF8024_ECC_100G_25GAUI_C2M_AOC = 1,
	SFF8024_ECC_100GBASE_SR4_25GBASE_SR = 2,
	SFF8024_ECC_100GBASE_LR4_25GBASE_LR = 3,
	SFF8024_ECC_100GBASE_ER4_25GBASE_ER = 4,
	SFF8024_ECC_100GBASE_SR10 = 5,
	SFF8024_ECC_100GBASE_CR4 = 11,
	SFF8024_ECC_25GBASE_CR_S = 12,
	SFF8024_ECC_25GBASE_CR_N = 13,
	SFF8024_ECC_10GBASE_T_SFI = 22,
	SFF8024_ECC_10GBASE_T_SR = 28,
	SFF8024_ECC_5GBASE_T = 29,
	SFF8024_ECC_2_5GBASE_T = 30,
};

enum {
	SFP_PHYS_ID = 0,
	SFP_PHYS_EXT_ID = 1,
	SFP_PHYS_EXT_ID_SFP = 4,
	SFP_CONNECTOR = 2,
	SFP_COMPLIANCE = 3,
	SFP_ENCODING = 11,
	SFP_BR_NOMINAL = 12,
	SFP_RATE_ID = 13,
	SFF_RID_8079 = 1,
	SFF_RID_8431_RX_ONLY = 2,
	SFF_RID_8431_TX_ONLY = 4,
	SFF_RID_8431 = 6,
	SFF_RID_10G8G = 14,
	SFP_LINK_LEN_SM_KM = 14,
	SFP_LINK_LEN_SM_100M = 15,
	SFP_LINK_LEN_50UM_OM2_10M = 16,
	SFP_LINK_LEN_62_5UM_OM1_10M = 17,
	SFP_LINK_LEN_COPPER_1M = 18,
	SFP_LINK_LEN_50UM_OM4_10M = 18,
	SFP_LINK_LEN_50UM_OM3_10M = 19,
	SFP_VENDOR_NAME = 20,
	SFP_VENDOR_OUI = 37,
	SFP_VENDOR_PN = 40,
	SFP_VENDOR_REV = 56,
	SFP_OPTICAL_WAVELENGTH_MSB = 60,
	SFP_OPTICAL_WAVELENGTH_LSB = 61,
	SFP_CABLE_SPEC = 60,
	SFP_CC_BASE = 63,
	SFP_OPTIONS = 64,
	SFP_OPTIONS_HIGH_POWER_LEVEL = 8192,
	SFP_OPTIONS_PAGING_A2 = 4096,
	SFP_OPTIONS_RETIMER = 2048,
	SFP_OPTIONS_COOLED_XCVR = 1024,
	SFP_OPTIONS_POWER_DECL = 512,
	SFP_OPTIONS_RX_LINEAR_OUT = 256,
	SFP_OPTIONS_RX_DECISION_THRESH = 128,
	SFP_OPTIONS_TUNABLE_TX = 64,
	SFP_OPTIONS_RATE_SELECT = 32,
	SFP_OPTIONS_TX_DISABLE = 16,
	SFP_OPTIONS_TX_FAULT = 8,
	SFP_OPTIONS_LOS_INVERTED = 4,
	SFP_OPTIONS_LOS_NORMAL = 2,
	SFP_BR_MAX = 66,
	SFP_BR_MIN = 67,
	SFP_VENDOR_SN = 68,
	SFP_DATECODE = 84,
	SFP_DIAGMON = 92,
	SFP_DIAGMON_DDM = 64,
	SFP_DIAGMON_INT_CAL = 32,
	SFP_DIAGMON_EXT_CAL = 16,
	SFP_DIAGMON_RXPWR_AVG = 8,
	SFP_DIAGMON_ADDRMODE = 4,
	SFP_ENHOPTS = 93,
	SFP_ENHOPTS_ALARMWARN = 128,
	SFP_ENHOPTS_SOFT_TX_DISABLE = 64,
	SFP_ENHOPTS_SOFT_TX_FAULT = 32,
	SFP_ENHOPTS_SOFT_RX_LOS = 16,
	SFP_ENHOPTS_SOFT_RATE_SELECT = 8,
	SFP_ENHOPTS_APP_SELECT_SFF8079 = 4,
	SFP_ENHOPTS_SOFT_RATE_SFF8431 = 2,
	SFP_SFF8472_COMPLIANCE = 94,
	SFP_SFF8472_COMPLIANCE_NONE = 0,
	SFP_SFF8472_COMPLIANCE_REV9_3 = 1,
	SFP_SFF8472_COMPLIANCE_REV9_5 = 2,
	SFP_SFF8472_COMPLIANCE_REV10_2 = 3,
	SFP_SFF8472_COMPLIANCE_REV10_4 = 4,
	SFP_SFF8472_COMPLIANCE_REV11_0 = 5,
	SFP_SFF8472_COMPLIANCE_REV11_3 = 6,
	SFP_SFF8472_COMPLIANCE_REV11_4 = 7,
	SFP_SFF8472_COMPLIANCE_REV12_0 = 8,
	SFP_CC_EXT = 95,
};

enum {
	SKBFL_ZEROCOPY_ENABLE = 1,
	SKBFL_SHARED_FRAG = 2,
	SKBFL_PURE_ZEROCOPY = 4,
	SKBFL_DONT_ORPHAN = 8,
	SKBFL_MANAGED_FRAG_REFS = 16,
};

enum {
	SKBTX_HW_TSTAMP_NOBPF = 1,
	SKBTX_SW_TSTAMP = 2,
	SKBTX_IN_PROGRESS = 4,
	SKBTX_COMPLETION_TSTAMP = 8,
	SKBTX_HW_TSTAMP_NETDEV = 32,
	SKBTX_SCHED_TSTAMP = 64,
	SKBTX_BPF = 128,
};

enum {
	SKB_FCLONE_UNAVAILABLE = 0,
	SKB_FCLONE_ORIG = 1,
	SKB_FCLONE_CLONE = 2,
};

enum {
	SKB_GSO_TCPV4 = 1,
	SKB_GSO_DODGY = 2,
	SKB_GSO_TCP_ECN = 4,
	SKB_GSO_TCP_FIXEDID = 8,
	SKB_GSO_TCPV6 = 16,
	SKB_GSO_FCOE = 32,
	SKB_GSO_GRE = 64,
	SKB_GSO_GRE_CSUM = 128,
	SKB_GSO_IPXIP4 = 256,
	SKB_GSO_IPXIP6 = 512,
	SKB_GSO_UDP_TUNNEL = 1024,
	SKB_GSO_UDP_TUNNEL_CSUM = 2048,
	SKB_GSO_PARTIAL = 4096,
	SKB_GSO_TUNNEL_REMCSUM = 8192,
	SKB_GSO_SCTP = 16384,
	SKB_GSO_ESP = 32768,
	SKB_GSO_UDP = 65536,
	SKB_GSO_UDP_L4 = 131072,
	SKB_GSO_FRAGLIST = 262144,
	SKB_GSO_TCP_ACCECN = 524288,
};

enum {
	SKCIPHER_WALK_SLOW = 1,
	SKCIPHER_WALK_COPY = 2,
	SKCIPHER_WALK_DIFF = 4,
	SKCIPHER_WALK_SLEEP = 8,
};

enum {
	SK_BPF_CB_TX_TIMESTAMPING = 1,
	SK_BPF_CB_MASK = 1,
};

enum {
	SK_DIAG_BPF_STORAGE_NONE = 0,
	SK_DIAG_BPF_STORAGE_PAD = 1,
	SK_DIAG_BPF_STORAGE_MAP_ID = 2,
	SK_DIAG_BPF_STORAGE_MAP_VALUE = 3,
	__SK_DIAG_BPF_STORAGE_MAX = 4,
};

enum {
	SK_DIAG_BPF_STORAGE_REP_NONE = 0,
	SK_DIAG_BPF_STORAGE = 1,
	__SK_DIAG_BPF_STORAGE_REP_MAX = 2,
};

enum {
	SK_DIAG_BPF_STORAGE_REQ_NONE = 0,
	SK_DIAG_BPF_STORAGE_REQ_MAP_FD = 1,
	__SK_DIAG_BPF_STORAGE_REQ_MAX = 2,
};

enum {
	SK_MEMINFO_RMEM_ALLOC = 0,
	SK_MEMINFO_RCVBUF = 1,
	SK_MEMINFO_WMEM_ALLOC = 2,
	SK_MEMINFO_SNDBUF = 3,
	SK_MEMINFO_FWD_ALLOC = 4,
	SK_MEMINFO_WMEM_QUEUED = 5,
	SK_MEMINFO_OPTMEM = 6,
	SK_MEMINFO_BACKLOG = 7,
	SK_MEMINFO_DROPS = 8,
	SK_MEMINFO_VARS = 9,
};

enum {
	SOCK_WAKE_IO = 0,
	SOCK_WAKE_WAITD = 1,
	SOCK_WAKE_SPACE = 2,
	SOCK_WAKE_URG = 3,
};

enum {
	SOF_TIMESTAMPING_TX_HARDWARE = 1,
	SOF_TIMESTAMPING_TX_SOFTWARE = 2,
	SOF_TIMESTAMPING_RX_HARDWARE = 4,
	SOF_TIMESTAMPING_RX_SOFTWARE = 8,
	SOF_TIMESTAMPING_SOFTWARE = 16,
	SOF_TIMESTAMPING_SYS_HARDWARE = 32,
	SOF_TIMESTAMPING_RAW_HARDWARE = 64,
	SOF_TIMESTAMPING_OPT_ID = 128,
	SOF_TIMESTAMPING_TX_SCHED = 256,
	SOF_TIMESTAMPING_TX_ACK = 512,
	SOF_TIMESTAMPING_OPT_CMSG = 1024,
	SOF_TIMESTAMPING_OPT_TSONLY = 2048,
	SOF_TIMESTAMPING_OPT_STATS = 4096,
	SOF_TIMESTAMPING_OPT_PKTINFO = 8192,
	SOF_TIMESTAMPING_OPT_TX_SWHW = 16384,
	SOF_TIMESTAMPING_BIND_PHC = 32768,
	SOF_TIMESTAMPING_OPT_ID_TCP = 65536,
	SOF_TIMESTAMPING_OPT_RX_FILTER = 131072,
	SOF_TIMESTAMPING_TX_COMPLETION = 262144,
	SOF_TIMESTAMPING_LAST = 262144,
	SOF_TIMESTAMPING_MASK = 524287,
};

enum {
	SR_DMAR_FECTL_REG = 0,
	SR_DMAR_FEDATA_REG = 1,
	SR_DMAR_FEADDR_REG = 2,
	SR_DMAR_FEUADDR_REG = 3,
	MAX_SR_DMAR_REGS = 4,
};

enum {
	SWITCHTEC_GAS_MRPC_OFFSET = 0,
	SWITCHTEC_GAS_TOP_CFG_OFFSET = 4096,
	SWITCHTEC_GAS_SW_EVENT_OFFSET = 6144,
	SWITCHTEC_GAS_SYS_INFO_OFFSET = 8192,
	SWITCHTEC_GAS_FLASH_INFO_OFFSET = 8704,
	SWITCHTEC_GAS_PART_CFG_OFFSET = 16384,
	SWITCHTEC_GAS_NTB_OFFSET = 65536,
	SWITCHTEC_GAS_PFF_CSR_OFFSET = 1261568,
};

enum {
	SWITCHTEC_NTB_REG_INFO_OFFSET = 0,
	SWITCHTEC_NTB_REG_CTRL_OFFSET = 16384,
	SWITCHTEC_NTB_REG_DBMSG_OFFSET = 409600,
};

enum {
	SWP_USED = 1,
	SWP_WRITEOK = 2,
	SWP_DISCARDABLE = 4,
	SWP_DISCARDING = 8,
	SWP_SOLIDSTATE = 16,
	SWP_CONTINUED = 32,
	SWP_BLKDEV = 64,
	SWP_ACTIVATED = 128,
	SWP_FS_OPS = 256,
	SWP_AREA_DISCARD = 512,
	SWP_PAGE_DISCARD = 1024,
	SWP_STABLE_WRITES = 2048,
	SWP_SYNCHRONOUS_IO = 4096,
};

enum {
	SX150X_123 = 0,
	SX150X_456 = 1,
	SX150X_789 = 2,
};

enum {
	SX150X_789_REG_MISC_AUTOCLEAR_OFF = 1,
	SX150X_MAX_REGISTER = 173,
	SX150X_IRQ_TYPE_EDGE_RISING = 1,
	SX150X_IRQ_TYPE_EDGE_FALLING = 2,
	SX150X_789_RESET_KEY1 = 18,
	SX150X_789_RESET_KEY2 = 52,
};

enum {
	SYNTH_ERR_BAD_NAME = 0,
	SYNTH_ERR_INVALID_CMD = 1,
	SYNTH_ERR_INVALID_DYN_CMD = 2,
	SYNTH_ERR_EVENT_EXISTS = 3,
	SYNTH_ERR_TOO_MANY_FIELDS = 4,
	SYNTH_ERR_INCOMPLETE_TYPE = 5,
	SYNTH_ERR_INVALID_TYPE = 6,
	SYNTH_ERR_INVALID_FIELD = 7,
	SYNTH_ERR_INVALID_ARRAY_SPEC = 8,
};

enum {
	TASKLET_STATE_SCHED = 0,
	TASKLET_STATE_RUN = 1,
};

enum {
	TASKSTATS_CMD_ATTR_UNSPEC = 0,
	TASKSTATS_CMD_ATTR_PID = 1,
	TASKSTATS_CMD_ATTR_TGID = 2,
	TASKSTATS_CMD_ATTR_REGISTER_CPUMASK = 3,
	TASKSTATS_CMD_ATTR_DEREGISTER_CPUMASK = 4,
	__TASKSTATS_CMD_ATTR_MAX = 5,
};

enum {
	TASKSTATS_CMD_UNSPEC = 0,
	TASKSTATS_CMD_GET = 1,
	TASKSTATS_CMD_NEW = 2,
	__TASKSTATS_CMD_MAX = 3,
};

enum {
	TASKSTATS_TYPE_UNSPEC = 0,
	TASKSTATS_TYPE_PID = 1,
	TASKSTATS_TYPE_TGID = 2,
	TASKSTATS_TYPE_STATS = 3,
	TASKSTATS_TYPE_AGGR_PID = 4,
	TASKSTATS_TYPE_AGGR_TGID = 5,
	TASKSTATS_TYPE_NULL = 6,
	__TASKSTATS_TYPE_MAX = 7,
};

enum {
	TASK_COMM_LEN = 16,
};

enum {
	TCA_ACT_UNSPEC = 0,
	TCA_ACT_KIND = 1,
	TCA_ACT_OPTIONS = 2,
	TCA_ACT_INDEX = 3,
	TCA_ACT_STATS = 4,
	TCA_ACT_PAD = 5,
	TCA_ACT_COOKIE = 6,
	TCA_ACT_FLAGS = 7,
	TCA_ACT_HW_STATS = 8,
	TCA_ACT_USED_HW_STATS = 9,
	TCA_ACT_IN_HW_COUNT = 10,
	__TCA_ACT_MAX = 11,
};

enum {
	TCA_EMATCH_TREE_UNSPEC = 0,
	TCA_EMATCH_TREE_HDR = 1,
	TCA_EMATCH_TREE_LIST = 2,
	__TCA_EMATCH_TREE_MAX = 3,
};

enum {
	TCA_FLOWER_KEY_CT_FLAGS_NEW = 1,
	TCA_FLOWER_KEY_CT_FLAGS_ESTABLISHED = 2,
	TCA_FLOWER_KEY_CT_FLAGS_RELATED = 4,
	TCA_FLOWER_KEY_CT_FLAGS_TRACKED = 8,
	TCA_FLOWER_KEY_CT_FLAGS_INVALID = 16,
	TCA_FLOWER_KEY_CT_FLAGS_REPLY = 32,
	__TCA_FLOWER_KEY_CT_FLAGS_MAX = 33,
};

enum {
	TCA_FLOWER_KEY_FLAGS_IS_FRAGMENT = 1,
	TCA_FLOWER_KEY_FLAGS_FRAG_IS_FIRST = 2,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_CSUM = 4,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_DONT_FRAGMENT = 8,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_OAM = 16,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_CRIT_OPT = 32,
	__TCA_FLOWER_KEY_FLAGS_MAX = 33,
};

enum {
	TCA_FQ_CODEL_UNSPEC = 0,
	TCA_FQ_CODEL_TARGET = 1,
	TCA_FQ_CODEL_LIMIT = 2,
	TCA_FQ_CODEL_INTERVAL = 3,
	TCA_FQ_CODEL_ECN = 4,
	TCA_FQ_CODEL_FLOWS = 5,
	TCA_FQ_CODEL_QUANTUM = 6,
	TCA_FQ_CODEL_CE_THRESHOLD = 7,
	TCA_FQ_CODEL_DROP_BATCH_SIZE = 8,
	TCA_FQ_CODEL_MEMORY_LIMIT = 9,
	TCA_FQ_CODEL_CE_THRESHOLD_SELECTOR = 10,
	TCA_FQ_CODEL_CE_THRESHOLD_MASK = 11,
	__TCA_FQ_CODEL_MAX = 12,
};

enum {
	TCA_FQ_CODEL_XSTATS_QDISC = 0,
	TCA_FQ_CODEL_XSTATS_CLASS = 1,
};

enum {
	TCA_ROOT_UNSPEC = 0,
	TCA_ROOT_TAB = 1,
	TCA_ROOT_FLAGS = 2,
	TCA_ROOT_COUNT = 3,
	TCA_ROOT_TIME_DELTA = 4,
	TCA_ROOT_EXT_WARN_MSG = 5,
	__TCA_ROOT_MAX = 6,
};

enum {
	TCA_STAB_UNSPEC = 0,
	TCA_STAB_BASE = 1,
	TCA_STAB_DATA = 2,
	__TCA_STAB_MAX = 3,
};

enum {
	TCA_STATS_UNSPEC = 0,
	TCA_STATS_BASIC = 1,
	TCA_STATS_RATE_EST = 2,
	TCA_STATS_QUEUE = 3,
	TCA_STATS_APP = 4,
	TCA_STATS_RATE_EST64 = 5,
	TCA_STATS_PAD = 6,
	TCA_STATS_BASIC_HW = 7,
	TCA_STATS_PKT64 = 8,
	__TCA_STATS_MAX = 9,
};

enum {
	TCA_UNSPEC = 0,
	TCA_KIND = 1,
	TCA_OPTIONS = 2,
	TCA_STATS = 3,
	TCA_XSTATS = 4,
	TCA_RATE = 5,
	TCA_FCNT = 6,
	TCA_STATS2 = 7,
	TCA_STAB = 8,
	TCA_PAD = 9,
	TCA_DUMP_INVISIBLE = 10,
	TCA_CHAIN = 11,
	TCA_HW_OFFLOAD = 12,
	TCA_INGRESS_BLOCK = 13,
	TCA_EGRESS_BLOCK = 14,
	TCA_DUMP_FLAGS = 15,
	TCA_EXT_WARN_MSG = 16,
	__TCA_MAX = 17,
};

enum {
	TCG_SECP_00 = 0,
	TCG_SECP_01 = 1,
};

enum {
	TCPF_ESTABLISHED = 2,
	TCPF_SYN_SENT = 4,
	TCPF_SYN_RECV = 8,
	TCPF_FIN_WAIT1 = 16,
	TCPF_FIN_WAIT2 = 32,
	TCPF_TIME_WAIT = 64,
	TCPF_CLOSE = 128,
	TCPF_CLOSE_WAIT = 256,
	TCPF_LAST_ACK = 512,
	TCPF_LISTEN = 1024,
	TCPF_CLOSING = 2048,
	TCPF_NEW_SYN_RECV = 4096,
	TCPF_BOUND_INACTIVE = 8192,
};

enum {
	TCP_BPF_BASE = 0,
	TCP_BPF_TX = 1,
	TCP_BPF_RX = 2,
	TCP_BPF_TXRX = 3,
	TCP_BPF_NUM_CFGS = 4,
};

enum {
	TCP_BPF_IPV4 = 0,
	TCP_BPF_IPV6 = 1,
	TCP_BPF_NUM_PROTS = 2,
};

enum {
	TCP_BPF_IW = 1001,
	TCP_BPF_SNDCWND_CLAMP = 1002,
	TCP_BPF_DELACK_MAX = 1003,
	TCP_BPF_RTO_MIN = 1004,
	TCP_BPF_SYN = 1005,
	TCP_BPF_SYN_IP = 1006,
	TCP_BPF_SYN_MAC = 1007,
	TCP_BPF_SOCK_OPS_CB_FLAGS = 1008,
	SK_BPF_CB_FLAGS = 1009,
};

enum {
	TCP_CMSG_INQ = 1,
	TCP_CMSG_TS = 2,
};

enum {
	TCP_ESTABLISHED = 1,
	TCP_SYN_SENT = 2,
	TCP_SYN_RECV = 3,
	TCP_FIN_WAIT1 = 4,
	TCP_FIN_WAIT2 = 5,
	TCP_TIME_WAIT = 6,
	TCP_CLOSE = 7,
	TCP_CLOSE_WAIT = 8,
	TCP_LAST_ACK = 9,
	TCP_LISTEN = 10,
	TCP_CLOSING = 11,
	TCP_NEW_SYN_RECV = 12,
	TCP_BOUND_INACTIVE = 13,
	TCP_MAX_STATES = 14,
};

enum {
	TCP_FLAG_AE = 1,
	TCP_FLAG_CWR = 32768,
	TCP_FLAG_ECE = 16384,
	TCP_FLAG_URG = 8192,
	TCP_FLAG_ACK = 4096,
	TCP_FLAG_PSH = 2048,
	TCP_FLAG_RST = 1024,
	TCP_FLAG_SYN = 512,
	TCP_FLAG_FIN = 256,
	TCP_RESERVED_BITS = 14,
	TCP_DATA_OFFSET = 240,
};

enum {
	TCP_METRICS_ATTR_UNSPEC = 0,
	TCP_METRICS_ATTR_ADDR_IPV4 = 1,
	TCP_METRICS_ATTR_ADDR_IPV6 = 2,
	TCP_METRICS_ATTR_AGE = 3,
	TCP_METRICS_ATTR_TW_TSVAL = 4,
	TCP_METRICS_ATTR_TW_TS_STAMP = 5,
	TCP_METRICS_ATTR_VALS = 6,
	TCP_METRICS_ATTR_FOPEN_MSS = 7,
	TCP_METRICS_ATTR_FOPEN_SYN_DROPS = 8,
	TCP_METRICS_ATTR_FOPEN_SYN_DROP_TS = 9,
	TCP_METRICS_ATTR_FOPEN_COOKIE = 10,
	TCP_METRICS_ATTR_SADDR_IPV4 = 11,
	TCP_METRICS_ATTR_SADDR_IPV6 = 12,
	TCP_METRICS_ATTR_PAD = 13,
	__TCP_METRICS_ATTR_MAX = 14,
};

enum {
	TCP_METRICS_CMD_UNSPEC = 0,
	TCP_METRICS_CMD_GET = 1,
	TCP_METRICS_CMD_DEL = 2,
	__TCP_METRICS_CMD_MAX = 3,
};

enum {
	TCP_MIB_NUM = 0,
	TCP_MIB_RTOALGORITHM = 1,
	TCP_MIB_RTOMIN = 2,
	TCP_MIB_RTOMAX = 3,
	TCP_MIB_MAXCONN = 4,
	TCP_MIB_ACTIVEOPENS = 5,
	TCP_MIB_PASSIVEOPENS = 6,
	TCP_MIB_ATTEMPTFAILS = 7,
	TCP_MIB_ESTABRESETS = 8,
	TCP_MIB_CURRESTAB = 9,
	TCP_MIB_INSEGS = 10,
	TCP_MIB_OUTSEGS = 11,
	TCP_MIB_RETRANSSEGS = 12,
	TCP_MIB_INERRS = 13,
	TCP_MIB_OUTRSTS = 14,
	TCP_MIB_CSUMERRORS = 15,
	__TCP_MIB_MAX = 16,
};

enum {
	TCP_NLA_PAD = 0,
	TCP_NLA_BUSY = 1,
	TCP_NLA_RWND_LIMITED = 2,
	TCP_NLA_SNDBUF_LIMITED = 3,
	TCP_NLA_DATA_SEGS_OUT = 4,
	TCP_NLA_TOTAL_RETRANS = 5,
	TCP_NLA_PACING_RATE = 6,
	TCP_NLA_DELIVERY_RATE = 7,
	TCP_NLA_SND_CWND = 8,
	TCP_NLA_REORDERING = 9,
	TCP_NLA_MIN_RTT = 10,
	TCP_NLA_RECUR_RETRANS = 11,
	TCP_NLA_DELIVERY_RATE_APP_LMT = 12,
	TCP_NLA_SNDQ_SIZE = 13,
	TCP_NLA_CA_STATE = 14,
	TCP_NLA_SND_SSTHRESH = 15,
	TCP_NLA_DELIVERED = 16,
	TCP_NLA_DELIVERED_CE = 17,
	TCP_NLA_BYTES_SENT = 18,
	TCP_NLA_BYTES_RETRANS = 19,
	TCP_NLA_DSACK_DUPS = 20,
	TCP_NLA_REORD_SEEN = 21,
	TCP_NLA_SRTT = 22,
	TCP_NLA_TIMEOUT_REHASH = 23,
	TCP_NLA_BYTES_NOTSENT = 24,
	TCP_NLA_EDT = 25,
	TCP_NLA_TTL = 26,
	TCP_NLA_REHASH = 27,
};

enum {
	TCP_NO_QUEUE = 0,
	TCP_RECV_QUEUE = 1,
	TCP_SEND_QUEUE = 2,
	TCP_QUEUES_NR = 3,
};

enum {
	TCP_V4_FLOW = 1,
	UDP_V4_FLOW = 2,
	SCTP_V4_FLOW = 3,
	AH_ESP_V4_FLOW = 4,
	TCP_V6_FLOW = 5,
	UDP_V6_FLOW = 6,
	SCTP_V6_FLOW = 7,
	AH_ESP_V6_FLOW = 8,
	AH_V4_FLOW = 9,
	ESP_V4_FLOW = 10,
	AH_V6_FLOW = 11,
	ESP_V6_FLOW = 12,
	IPV4_USER_FLOW = 13,
	IP_USER_FLOW = 13,
	IPV6_USER_FLOW = 14,
	IPV4_FLOW = 16,
	IPV6_FLOW = 17,
	ETHER_FLOW = 18,
	GTPU_V4_FLOW = 19,
	GTPU_V6_FLOW = 20,
	GTPC_V4_FLOW = 21,
	GTPC_V6_FLOW = 22,
	GTPC_TEID_V4_FLOW = 23,
	GTPC_TEID_V6_FLOW = 24,
	GTPU_EH_V4_FLOW = 25,
	GTPU_EH_V6_FLOW = 26,
	GTPU_UL_V4_FLOW = 27,
	GTPU_UL_V6_FLOW = 28,
	GTPU_DL_V4_FLOW = 29,
	GTPU_DL_V6_FLOW = 30,
	__FLOW_TYPE_COUNT = 31,
};

enum {
	TEST_NONE = 0,
	TEST_CORE = 1,
	TEST_CPUS = 2,
	TEST_PLATFORM = 3,
	TEST_DEVICES = 4,
	TEST_FREEZER = 5,
	__TEST_AFTER_LAST = 6,
};

enum {
	TLS_ALERT_DESC_CLOSE_NOTIFY = 0,
	TLS_ALERT_DESC_UNEXPECTED_MESSAGE = 10,
	TLS_ALERT_DESC_BAD_RECORD_MAC = 20,
	TLS_ALERT_DESC_RECORD_OVERFLOW = 22,
	TLS_ALERT_DESC_HANDSHAKE_FAILURE = 40,
	TLS_ALERT_DESC_BAD_CERTIFICATE = 42,
	TLS_ALERT_DESC_UNSUPPORTED_CERTIFICATE = 43,
	TLS_ALERT_DESC_CERTIFICATE_REVOKED = 44,
	TLS_ALERT_DESC_CERTIFICATE_EXPIRED = 45,
	TLS_ALERT_DESC_CERTIFICATE_UNKNOWN = 46,
	TLS_ALERT_DESC_ILLEGAL_PARAMETER = 47,
	TLS_ALERT_DESC_UNKNOWN_CA = 48,
	TLS_ALERT_DESC_ACCESS_DENIED = 49,
	TLS_ALERT_DESC_DECODE_ERROR = 50,
	TLS_ALERT_DESC_DECRYPT_ERROR = 51,
	TLS_ALERT_DESC_TOO_MANY_CIDS_REQUESTED = 52,
	TLS_ALERT_DESC_PROTOCOL_VERSION = 70,
	TLS_ALERT_DESC_INSUFFICIENT_SECURITY = 71,
	TLS_ALERT_DESC_INTERNAL_ERROR = 80,
	TLS_ALERT_DESC_INAPPROPRIATE_FALLBACK = 86,
	TLS_ALERT_DESC_USER_CANCELED = 90,
	TLS_ALERT_DESC_MISSING_EXTENSION = 109,
	TLS_ALERT_DESC_UNSUPPORTED_EXTENSION = 110,
	TLS_ALERT_DESC_UNRECOGNIZED_NAME = 112,
	TLS_ALERT_DESC_BAD_CERTIFICATE_STATUS_RESPONSE = 113,
	TLS_ALERT_DESC_UNKNOWN_PSK_IDENTITY = 115,
	TLS_ALERT_DESC_CERTIFICATE_REQUIRED = 116,
	TLS_ALERT_DESC_NO_APPLICATION_PROTOCOL = 120,
};

enum {
	TLS_ALERT_LEVEL_WARNING = 1,
	TLS_ALERT_LEVEL_FATAL = 2,
};

enum {
	TLS_NO_KEYRING = 0,
	TLS_NO_PEERID = 0,
	TLS_NO_CERT = 0,
	TLS_NO_PRIVKEY = 0,
};

enum {
	TLS_RECORD_TYPE_CHANGE_CIPHER_SPEC = 20,
	TLS_RECORD_TYPE_ALERT = 21,
	TLS_RECORD_TYPE_HANDSHAKE = 22,
	TLS_RECORD_TYPE_DATA = 23,
	TLS_RECORD_TYPE_HEARTBEAT = 24,
	TLS_RECORD_TYPE_TLS12_CID = 25,
	TLS_RECORD_TYPE_ACK = 26,
};

enum {
	TOO_MANY_CLOSE = -1,
	TOO_MANY_OPEN = -2,
	MISSING_QUOTE = -3,
};

enum {
	TPS65090_IRQ_INTERRUPT = 0,
	TPS65090_IRQ_VAC_STATUS_CHANGE = 1,
	TPS65090_IRQ_VSYS_STATUS_CHANGE = 2,
	TPS65090_IRQ_BAT_STATUS_CHANGE = 3,
	TPS65090_IRQ_CHARGING_STATUS_CHANGE = 4,
	TPS65090_IRQ_CHARGING_COMPLETE = 5,
	TPS65090_IRQ_OVERLOAD_DCDC1 = 6,
	TPS65090_IRQ_OVERLOAD_DCDC2 = 7,
	TPS65090_IRQ_OVERLOAD_DCDC3 = 8,
	TPS65090_IRQ_OVERLOAD_FET1 = 9,
	TPS65090_IRQ_OVERLOAD_FET2 = 10,
	TPS65090_IRQ_OVERLOAD_FET3 = 11,
	TPS65090_IRQ_OVERLOAD_FET4 = 12,
	TPS65090_IRQ_OVERLOAD_FET5 = 13,
	TPS65090_IRQ_OVERLOAD_FET6 = 14,
	TPS65090_IRQ_OVERLOAD_FET7 = 15,
};

enum {
	TPS65090_REGULATOR_DCDC1 = 0,
	TPS65090_REGULATOR_DCDC2 = 1,
	TPS65090_REGULATOR_DCDC3 = 2,
	TPS65090_REGULATOR_FET1 = 3,
	TPS65090_REGULATOR_FET2 = 4,
	TPS65090_REGULATOR_FET3 = 5,
	TPS65090_REGULATOR_FET4 = 6,
	TPS65090_REGULATOR_FET5 = 7,
	TPS65090_REGULATOR_FET6 = 8,
	TPS65090_REGULATOR_FET7 = 9,
	TPS65090_REGULATOR_LDO1 = 10,
	TPS65090_REGULATOR_LDO2 = 11,
	TPS65090_REGULATOR_MAX = 12,
};

enum {
	TPS6586X_ID_SYS = 0,
	TPS6586X_ID_SM_0 = 1,
	TPS6586X_ID_SM_1 = 2,
	TPS6586X_ID_SM_2 = 3,
	TPS6586X_ID_LDO_0 = 4,
	TPS6586X_ID_LDO_1 = 5,
	TPS6586X_ID_LDO_2 = 6,
	TPS6586X_ID_LDO_3 = 7,
	TPS6586X_ID_LDO_4 = 8,
	TPS6586X_ID_LDO_5 = 9,
	TPS6586X_ID_LDO_6 = 10,
	TPS6586X_ID_LDO_7 = 11,
	TPS6586X_ID_LDO_8 = 12,
	TPS6586X_ID_LDO_9 = 13,
	TPS6586X_ID_LDO_RTC = 14,
	TPS6586X_ID_MAX_REGULATOR = 15,
};

enum {
	TPS6586X_INT_PLDO_0 = 0,
	TPS6586X_INT_PLDO_1 = 1,
	TPS6586X_INT_PLDO_2 = 2,
	TPS6586X_INT_PLDO_3 = 3,
	TPS6586X_INT_PLDO_4 = 4,
	TPS6586X_INT_PLDO_5 = 5,
	TPS6586X_INT_PLDO_6 = 6,
	TPS6586X_INT_PLDO_7 = 7,
	TPS6586X_INT_COMP_DET = 8,
	TPS6586X_INT_ADC = 9,
	TPS6586X_INT_PLDO_8 = 10,
	TPS6586X_INT_PLDO_9 = 11,
	TPS6586X_INT_PSM_0 = 12,
	TPS6586X_INT_PSM_1 = 13,
	TPS6586X_INT_PSM_2 = 14,
	TPS6586X_INT_PSM_3 = 15,
	TPS6586X_INT_RTC_ALM1 = 16,
	TPS6586X_INT_ACUSB_OVP = 17,
	TPS6586X_INT_USB_DET = 18,
	TPS6586X_INT_AC_DET = 19,
	TPS6586X_INT_BAT_DET = 20,
	TPS6586X_INT_CHG_STAT = 21,
	TPS6586X_INT_CHG_TEMP = 22,
	TPS6586X_INT_PP = 23,
	TPS6586X_INT_RESUME = 24,
	TPS6586X_INT_LOW_SYS = 25,
	TPS6586X_INT_RTC_ALM2 = 26,
};

enum {
	TP_ERR_FILE_NOT_FOUND = 0,
	TP_ERR_NO_REGULAR_FILE = 1,
	TP_ERR_BAD_REFCNT = 2,
	TP_ERR_REFCNT_OPEN_BRACE = 3,
	TP_ERR_BAD_REFCNT_SUFFIX = 4,
	TP_ERR_BAD_UPROBE_OFFS = 5,
	TP_ERR_BAD_MAXACT_TYPE = 6,
	TP_ERR_BAD_MAXACT = 7,
	TP_ERR_MAXACT_TOO_BIG = 8,
	TP_ERR_BAD_PROBE_ADDR = 9,
	TP_ERR_NON_UNIQ_SYMBOL = 10,
	TP_ERR_BAD_RETPROBE = 11,
	TP_ERR_NO_TRACEPOINT = 12,
	TP_ERR_BAD_TP_NAME = 13,
	TP_ERR_BAD_ADDR_SUFFIX = 14,
	TP_ERR_NO_GROUP_NAME = 15,
	TP_ERR_GROUP_TOO_LONG = 16,
	TP_ERR_BAD_GROUP_NAME = 17,
	TP_ERR_NO_EVENT_NAME = 18,
	TP_ERR_EVENT_TOO_LONG = 19,
	TP_ERR_BAD_EVENT_NAME = 20,
	TP_ERR_EVENT_EXIST = 21,
	TP_ERR_RETVAL_ON_PROBE = 22,
	TP_ERR_NO_RETVAL = 23,
	TP_ERR_BAD_STACK_NUM = 24,
	TP_ERR_BAD_ARG_NUM = 25,
	TP_ERR_BAD_VAR = 26,
	TP_ERR_BAD_REG_NAME = 27,
	TP_ERR_BAD_MEM_ADDR = 28,
	TP_ERR_BAD_IMM = 29,
	TP_ERR_IMMSTR_NO_CLOSE = 30,
	TP_ERR_FILE_ON_KPROBE = 31,
	TP_ERR_BAD_FILE_OFFS = 32,
	TP_ERR_SYM_ON_UPROBE = 33,
	TP_ERR_TOO_MANY_OPS = 34,
	TP_ERR_DEREF_NEED_BRACE = 35,
	TP_ERR_BAD_DEREF_OFFS = 36,
	TP_ERR_DEREF_OPEN_BRACE = 37,
	TP_ERR_COMM_CANT_DEREF = 38,
	TP_ERR_BAD_FETCH_ARG = 39,
	TP_ERR_ARRAY_NO_CLOSE = 40,
	TP_ERR_BAD_ARRAY_SUFFIX = 41,
	TP_ERR_BAD_ARRAY_NUM = 42,
	TP_ERR_ARRAY_TOO_BIG = 43,
	TP_ERR_BAD_TYPE = 44,
	TP_ERR_BAD_STRING = 45,
	TP_ERR_BAD_SYMSTRING = 46,
	TP_ERR_BAD_BITFIELD = 47,
	TP_ERR_ARG_NAME_TOO_LONG = 48,
	TP_ERR_NO_ARG_NAME = 49,
	TP_ERR_BAD_ARG_NAME = 50,
	TP_ERR_USED_ARG_NAME = 51,
	TP_ERR_ARG_TOO_LONG = 52,
	TP_ERR_NO_ARG_BODY = 53,
	TP_ERR_BAD_INSN_BNDRY = 54,
	TP_ERR_FAIL_REG_PROBE = 55,
	TP_ERR_DIFF_PROBE_TYPE = 56,
	TP_ERR_DIFF_ARG_TYPE = 57,
	TP_ERR_SAME_PROBE = 58,
	TP_ERR_NO_EVENT_INFO = 59,
	TP_ERR_BAD_ATTACH_EVENT = 60,
	TP_ERR_BAD_ATTACH_ARG = 61,
	TP_ERR_NO_EP_FILTER = 62,
	TP_ERR_NOSUP_BTFARG = 63,
	TP_ERR_NO_BTFARG = 64,
	TP_ERR_NO_BTF_ENTRY = 65,
	TP_ERR_BAD_VAR_ARGS = 66,
	TP_ERR_NOFENTRY_ARGS = 67,
	TP_ERR_DOUBLE_ARGS = 68,
	TP_ERR_ARGS_2LONG = 69,
	TP_ERR_ARGIDX_2BIG = 70,
	TP_ERR_NO_PTR_STRCT = 71,
	TP_ERR_NOSUP_DAT_ARG = 72,
	TP_ERR_BAD_HYPHEN = 73,
	TP_ERR_NO_BTF_FIELD = 74,
	TP_ERR_BAD_BTF_TID = 75,
	TP_ERR_BAD_TYPE4STR = 76,
	TP_ERR_NEED_STRING_TYPE = 77,
	TP_ERR_TOO_MANY_ARGS = 78,
	TP_ERR_TOO_MANY_EARGS = 79,
};

enum {
	TRACEFS_EVENT_INODE = 2,
	TRACEFS_GID_PERM_SET = 4,
	TRACEFS_UID_PERM_SET = 8,
	TRACEFS_INSTANCE_INODE = 16,
};

enum {
	TRACE_ARRAY_FL_GLOBAL = 1,
	TRACE_ARRAY_FL_BOOT = 2,
	TRACE_ARRAY_FL_LAST_BOOT = 4,
	TRACE_ARRAY_FL_MOD_INIT = 8,
	TRACE_ARRAY_FL_MEMMAP = 16,
};

enum {
	TRACE_CTX_NMI = 0,
	TRACE_CTX_IRQ = 1,
	TRACE_CTX_SOFTIRQ = 2,
	TRACE_CTX_NORMAL = 3,
	TRACE_CTX_TRANSITION = 4,
};

enum {
	TRACE_EVENT_FL_CAP_ANY = 1,
	TRACE_EVENT_FL_NO_SET_FILTER = 2,
	TRACE_EVENT_FL_IGNORE_ENABLE = 4,
	TRACE_EVENT_FL_TRACEPOINT = 8,
	TRACE_EVENT_FL_DYNAMIC = 16,
	TRACE_EVENT_FL_KPROBE = 32,
	TRACE_EVENT_FL_UPROBE = 64,
	TRACE_EVENT_FL_EPROBE = 128,
	TRACE_EVENT_FL_FPROBE = 256,
	TRACE_EVENT_FL_CUSTOM = 512,
	TRACE_EVENT_FL_TEST_STR = 1024,
};

enum {
	TRACE_EVENT_FL_CAP_ANY_BIT = 0,
	TRACE_EVENT_FL_NO_SET_FILTER_BIT = 1,
	TRACE_EVENT_FL_IGNORE_ENABLE_BIT = 2,
	TRACE_EVENT_FL_TRACEPOINT_BIT = 3,
	TRACE_EVENT_FL_DYNAMIC_BIT = 4,
	TRACE_EVENT_FL_KPROBE_BIT = 5,
	TRACE_EVENT_FL_UPROBE_BIT = 6,
	TRACE_EVENT_FL_EPROBE_BIT = 7,
	TRACE_EVENT_FL_FPROBE_BIT = 8,
	TRACE_EVENT_FL_CUSTOM_BIT = 9,
	TRACE_EVENT_FL_TEST_STR_BIT = 10,
};

enum {
	TRACE_FTRACE_BIT = 0,
	TRACE_FTRACE_NMI_BIT = 1,
	TRACE_FTRACE_IRQ_BIT = 2,
	TRACE_FTRACE_SIRQ_BIT = 3,
	TRACE_FTRACE_TRANSITION_BIT = 4,
	TRACE_INTERNAL_BIT = 5,
	TRACE_INTERNAL_NMI_BIT = 6,
	TRACE_INTERNAL_IRQ_BIT = 7,
	TRACE_INTERNAL_SIRQ_BIT = 8,
	TRACE_INTERNAL_TRANSITION_BIT = 9,
	TRACE_BRANCH_BIT = 10,
	TRACE_IRQ_BIT = 11,
	TRACE_RECORD_RECURSION_BIT = 12,
};

enum {
	TRACE_FUNC_NO_OPTS = 0,
	TRACE_FUNC_OPT_STACK = 1,
	TRACE_FUNC_OPT_NO_REPEATS = 2,
	TRACE_FUNC_OPT_ARGS = 4,
	TRACE_FUNC_OPT_HIGHEST_BIT = 8,
};

enum {
	TRACE_GRAPH_FL = 1,
	TRACE_GRAPH_DEPTH_START_BIT = 2,
	TRACE_GRAPH_DEPTH_END_BIT = 3,
	TRACE_GRAPH_NOTRACE_BIT = 4,
};

enum {
	TRACE_NOP_OPT_ACCEPT = 1,
	TRACE_NOP_OPT_REFUSE = 2,
};

enum {
	TRACE_PIDS = 1,
	TRACE_NO_PIDS = 2,
};

enum {
	TRACE_SIGNAL_DELIVERED = 0,
	TRACE_SIGNAL_IGNORED = 1,
	TRACE_SIGNAL_ALREADY_PENDING = 2,
	TRACE_SIGNAL_OVERFLOW_FAIL = 3,
	TRACE_SIGNAL_LOSE_INFO = 4,
};

enum {
	TYPE_MAX8998 = 0,
	TYPE_LP3974 = 1,
	TYPE_LP3979 = 2,
};

enum {
	T_SHARED = 1,
	T_UNBINDABLE = 2,
	T_MARKED = 4,
	T_UMOUNT_CANDIDATE = 8,
	T_SHARED_MASK = 2,
};

enum {
	UDP_BPF_IPV4 = 0,
	UDP_BPF_IPV6 = 1,
	UDP_BPF_NUM_PROTS = 2,
};

enum {
	UDP_FLAGS_CORK = 0,
	UDP_FLAGS_NO_CHECK6_TX = 1,
	UDP_FLAGS_NO_CHECK6_RX = 2,
	UDP_FLAGS_GRO_ENABLED = 3,
	UDP_FLAGS_ACCEPT_FRAGLIST = 4,
	UDP_FLAGS_ACCEPT_L4 = 5,
	UDP_FLAGS_ENCAP_ENABLED = 6,
	UDP_FLAGS_UDPLITE_SEND_CC = 7,
	UDP_FLAGS_UDPLITE_RECV_CC = 8,
};

enum {
	UDP_MIB_NUM = 0,
	UDP_MIB_INDATAGRAMS = 1,
	UDP_MIB_NOPORTS = 2,
	UDP_MIB_INERRORS = 3,
	UDP_MIB_OUTDATAGRAMS = 4,
	UDP_MIB_RCVBUFERRORS = 5,
	UDP_MIB_SNDBUFERRORS = 6,
	UDP_MIB_CSUMERRORS = 7,
	UDP_MIB_IGNOREDMULTI = 8,
	UDP_MIB_MEMERRORS = 9,
	__UDP_MIB_MAX = 10,
};

enum {
	UNAME26 = 131072,
	ADDR_NO_RANDOMIZE = 262144,
	FDPIC_FUNCPTRS = 524288,
	MMAP_PAGE_ZERO = 1048576,
	ADDR_COMPAT_LAYOUT = 2097152,
	READ_IMPLIES_EXEC = 4194304,
	ADDR_LIMIT_32BIT = 8388608,
	SHORT_INODE = 16777216,
	WHOLE_SECONDS = 33554432,
	STICKY_TIMEOUTS = 67108864,
	ADDR_LIMIT_3GB = 134217728,
};

enum {
	VERBOSE_STATUS = 1,
};

enum {
	VMGENID_SIZE = 16,
};

enum {
	VP_MSIX_CONFIG_VECTOR = 0,
	VP_MSIX_VQ_VECTOR = 1,
};

enum {
	VQ_HIPRIO = 0,
	VQ_REQUEST = 1,
};

enum {
	VTIME_PER_SEC_SHIFT = 37ULL,
	VTIME_PER_SEC = 137438953472ULL,
	VTIME_PER_USEC = 137438ULL,
	VTIME_PER_NSEC = 137ULL,
	VRATE_MIN_PPM = 10000ULL,
	VRATE_MAX_PPM = 100000000ULL,
	VRATE_MIN = 1374ULL,
	VRATE_CLAMP_ADJ_PCT = 4ULL,
	AUTOP_CYCLE_NSEC = 10000000000ULL,
};

enum {
	WALK_TRAILING = 1,
	WALK_MORE = 2,
	WALK_NOFOLLOW = 4,
};

enum {
	WBT_RWQ_BG = 0,
	WBT_RWQ_SWAP = 1,
	WBT_RWQ_DISCARD = 2,
	WBT_NUM_RWQ = 3,
};

enum {
	WBT_STATE_ON_DEFAULT = 1,
	WBT_STATE_ON_MANUAL = 2,
	WBT_STATE_OFF_DEFAULT = 3,
	WBT_STATE_OFF_MANUAL = 4,
};

enum {
	X2APIC_OFF = 0,
	X2APIC_DISABLED = 1,
	X2APIC_ON = 2,
	X2APIC_ON_LOCKED = 3,
};

enum {
	X86_BR_NONE = 0,
	X86_BR_USER = 1,
	X86_BR_KERNEL = 2,
	X86_BR_CALL = 4,
	X86_BR_RET = 8,
	X86_BR_SYSCALL = 16,
	X86_BR_SYSRET = 32,
	X86_BR_INT = 64,
	X86_BR_IRET = 128,
	X86_BR_JCC = 256,
	X86_BR_JMP = 512,
	X86_BR_IRQ = 1024,
	X86_BR_IND_CALL = 2048,
	X86_BR_ABORT = 4096,
	X86_BR_IN_TX = 8192,
	X86_BR_NO_TX = 16384,
	X86_BR_ZERO_CALL = 32768,
	X86_BR_CALL_STACK = 65536,
	X86_BR_IND_JMP = 131072,
	X86_BR_TYPE_SAVE = 262144,
};

enum {
	X86_IRQ_ALLOC_LEGACY = 1,
};

enum {
	X86_PERF_KFREE_SHARED = 0,
	X86_PERF_KFREE_EXCL = 1,
	X86_PERF_KFREE_MAX = 2,
};

enum {
	XA_CHECK_SCHED = 4096,
};

enum {
	XDP_ATTACHED_NONE = 0,
	XDP_ATTACHED_DRV = 1,
	XDP_ATTACHED_SKB = 2,
	XDP_ATTACHED_HW = 3,
	XDP_ATTACHED_MULTI = 4,
};

enum {
	XFRM_DEV_OFFLOAD_FLAG_ACQ = 1,
};

enum {
	XFRM_DEV_OFFLOAD_IN = 1,
	XFRM_DEV_OFFLOAD_OUT = 2,
	XFRM_DEV_OFFLOAD_FWD = 3,
};

enum {
	XFRM_DEV_OFFLOAD_UNSPECIFIED = 0,
	XFRM_DEV_OFFLOAD_CRYPTO = 1,
	XFRM_DEV_OFFLOAD_PACKET = 2,
};

enum {
	XFRM_LOOKUP_ICMP = 1,
	XFRM_LOOKUP_QUEUE = 2,
	XFRM_LOOKUP_KEEP_DST_REF = 4,
};

enum {
	XFRM_MODE_FLAG_TUNNEL = 1,
};

enum {
	XFRM_MSG_BASE = 16,
	XFRM_MSG_NEWSA = 16,
	XFRM_MSG_DELSA = 17,
	XFRM_MSG_GETSA = 18,
	XFRM_MSG_NEWPOLICY = 19,
	XFRM_MSG_DELPOLICY = 20,
	XFRM_MSG_GETPOLICY = 21,
	XFRM_MSG_ALLOCSPI = 22,
	XFRM_MSG_ACQUIRE = 23,
	XFRM_MSG_EXPIRE = 24,
	XFRM_MSG_UPDPOLICY = 25,
	XFRM_MSG_UPDSA = 26,
	XFRM_MSG_POLEXPIRE = 27,
	XFRM_MSG_FLUSHSA = 28,
	XFRM_MSG_FLUSHPOLICY = 29,
	XFRM_MSG_NEWAE = 30,
	XFRM_MSG_GETAE = 31,
	XFRM_MSG_REPORT = 32,
	XFRM_MSG_MIGRATE = 33,
	XFRM_MSG_NEWSADINFO = 34,
	XFRM_MSG_GETSADINFO = 35,
	XFRM_MSG_NEWSPDINFO = 36,
	XFRM_MSG_GETSPDINFO = 37,
	XFRM_MSG_MAPPING = 38,
	XFRM_MSG_SETDEFAULT = 39,
	XFRM_MSG_GETDEFAULT = 40,
	__XFRM_MSG_MAX = 41,
};

enum {
	XFRM_POLICY_IN = 0,
	XFRM_POLICY_OUT = 1,
	XFRM_POLICY_FWD = 2,
	XFRM_POLICY_MASK = 3,
	XFRM_POLICY_MAX = 3,
};

enum {
	XFRM_POLICY_TYPE_MAIN = 0,
	XFRM_POLICY_TYPE_SUB = 1,
	XFRM_POLICY_TYPE_MAX = 2,
	XFRM_POLICY_TYPE_ANY = 255,
};

enum {
	XFRM_STATE_VOID = 0,
	XFRM_STATE_ACQ = 1,
	XFRM_STATE_VALID = 2,
	XFRM_STATE_ERROR = 3,
	XFRM_STATE_EXPIRED = 4,
	XFRM_STATE_DEAD = 5,
};

enum {
	ZONELIST_FALLBACK = 0,
	ZONELIST_NOFALLBACK = 1,
	MAX_ZONELISTS = 2,
};

enum {
	ZSTDbss_compress = 0,
	ZSTDbss_noCompress = 1,
};

enum {
	_DQUOT_USAGE_ENABLED = 0,
	_DQUOT_LIMITS_ENABLED = 1,
	_DQUOT_SUSPENDED = 2,
	_DQUOT_STATE_FLAGS = 3,
};

enum {
	_IRQ_DEFAULT_INIT_FLAGS = 0,
	_IRQ_PER_CPU = 512,
	_IRQ_LEVEL = 256,
	_IRQ_NOPROBE = 1024,
	_IRQ_NOREQUEST = 2048,
	_IRQ_NOTHREAD = 65536,
	_IRQ_NOAUTOEN = 4096,
	_IRQ_NO_BALANCING = 8192,
	_IRQ_NESTED_THREAD = 32768,
	_IRQ_PER_CPU_DEVID = 131072,
	_IRQ_IS_POLLED = 262144,
	_IRQ_DISABLE_UNLAZY = 524288,
	_IRQ_HIDDEN = 1048576,
	_IRQ_NO_DEBUG = 2097152,
	_IRQF_MODIFY_MASK = 2080527,
};

enum {
	__IOAM6_IPTUNNEL_MODE_MIN = 0,
	IOAM6_IPTUNNEL_MODE_INLINE = 1,
	IOAM6_IPTUNNEL_MODE_ENCAP = 2,
	IOAM6_IPTUNNEL_MODE_AUTO = 3,
	__IOAM6_IPTUNNEL_MODE_MAX = 4,
};

enum {
	__ND_OPT_PREFIX_INFO_END = 0,
	ND_OPT_SOURCE_LL_ADDR = 1,
	ND_OPT_TARGET_LL_ADDR = 2,
	ND_OPT_PREFIX_INFO = 3,
	ND_OPT_REDIRECT_HDR = 4,
	ND_OPT_MTU = 5,
	ND_OPT_NONCE = 14,
	__ND_OPT_ARRAY_MAX = 15,
	ND_OPT_ROUTE_INFO = 24,
	ND_OPT_RDNSS = 25,
	ND_OPT_DNSSL = 31,
	ND_OPT_6CO = 34,
	ND_OPT_CAPTIVE_PORTAL = 37,
	ND_OPT_PREF64 = 38,
	__ND_OPT_MAX = 39,
};

enum {
	__PERCPU_REF_ATOMIC = 1,
	__PERCPU_REF_DEAD = 2,
	__PERCPU_REF_ATOMIC_DEAD = 3,
	__PERCPU_REF_FLAG_BITS = 2,
};

enum {
	__SCHED_FEAT_PLACE_LAG = 0,
	__SCHED_FEAT_PLACE_DEADLINE_INITIAL = 1,
	__SCHED_FEAT_PLACE_REL_DEADLINE = 2,
	__SCHED_FEAT_RUN_TO_PARITY = 3,
	__SCHED_FEAT_PREEMPT_SHORT = 4,
	__SCHED_FEAT_NEXT_BUDDY = 5,
	__SCHED_FEAT_PICK_BUDDY = 6,
	__SCHED_FEAT_CACHE_HOT_BUDDY = 7,
	__SCHED_FEAT_DELAY_DEQUEUE = 8,
	__SCHED_FEAT_DELAY_ZERO = 9,
	__SCHED_FEAT_WAKEUP_PREEMPTION = 10,
	__SCHED_FEAT_HRTICK = 11,
	__SCHED_FEAT_HRTICK_DL = 12,
	__SCHED_FEAT_NONTASK_CAPACITY = 13,
	__SCHED_FEAT_TTWU_QUEUE = 14,
	__SCHED_FEAT_SIS_UTIL = 15,
	__SCHED_FEAT_WARN_DOUBLE_CLOCK = 16,
	__SCHED_FEAT_RT_PUSH_IPI = 17,
	__SCHED_FEAT_RT_RUNTIME_SHARE = 18,
	__SCHED_FEAT_LB_MIN = 19,
	__SCHED_FEAT_ATTACH_AGE_LOAD = 20,
	__SCHED_FEAT_WA_IDLE = 21,
	__SCHED_FEAT_WA_WEIGHT = 22,
	__SCHED_FEAT_WA_BIAS = 23,
	__SCHED_FEAT_UTIL_EST = 24,
	__SCHED_FEAT_LATENCY_WARN = 25,
	__SCHED_FEAT_NR = 26,
};

enum {
	__SD_BALANCE_NEWIDLE = 0,
	__SD_BALANCE_EXEC = 1,
	__SD_BALANCE_FORK = 2,
	__SD_BALANCE_WAKE = 3,
	__SD_WAKE_AFFINE = 4,
	__SD_ASYM_CPUCAPACITY = 5,
	__SD_ASYM_CPUCAPACITY_FULL = 6,
	__SD_SHARE_CPUCAPACITY = 7,
	__SD_CLUSTER = 8,
	__SD_SHARE_LLC = 9,
	__SD_SERIALIZE = 10,
	__SD_ASYM_PACKING = 11,
	__SD_PREFER_SIBLING = 12,
	__SD_NUMA = 13,
	__SD_FLAG_CNT = 14,
};

enum {
	___GFP_DMA_BIT = 0,
	___GFP_HIGHMEM_BIT = 1,
	___GFP_DMA32_BIT = 2,
	___GFP_MOVABLE_BIT = 3,
	___GFP_RECLAIMABLE_BIT = 4,
	___GFP_HIGH_BIT = 5,
	___GFP_IO_BIT = 6,
	___GFP_FS_BIT = 7,
	___GFP_ZERO_BIT = 8,
	___GFP_UNUSED_BIT = 9,
	___GFP_DIRECT_RECLAIM_BIT = 10,
	___GFP_KSWAPD_RECLAIM_BIT = 11,
	___GFP_WRITE_BIT = 12,
	___GFP_NOWARN_BIT = 13,
	___GFP_RETRY_MAYFAIL_BIT = 14,
	___GFP_NOFAIL_BIT = 15,
	___GFP_NORETRY_BIT = 16,
	___GFP_MEMALLOC_BIT = 17,
	___GFP_COMP_BIT = 18,
	___GFP_NOMEMALLOC_BIT = 19,
	___GFP_HARDWALL_BIT = 20,
	___GFP_THISNODE_BIT = 21,
	___GFP_ACCOUNT_BIT = 22,
	___GFP_ZEROTAGS_BIT = 23,
	___GFP_NO_OBJ_EXT_BIT = 24,
	___GFP_LAST_BIT = 25,
};

enum {
	__ctx_convertBPF_PROG_TYPE_SOCKET_FILTER = 0,
	__ctx_convertBPF_PROG_TYPE_SCHED_CLS = 1,
	__ctx_convertBPF_PROG_TYPE_SCHED_ACT = 2,
	__ctx_convertBPF_PROG_TYPE_XDP = 3,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SKB = 4,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK = 5,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK_ADDR = 6,
	__ctx_convertBPF_PROG_TYPE_LWT_IN = 7,
	__ctx_convertBPF_PROG_TYPE_LWT_OUT = 8,
	__ctx_convertBPF_PROG_TYPE_LWT_XMIT = 9,
	__ctx_convertBPF_PROG_TYPE_LWT_SEG6LOCAL = 10,
	__ctx_convertBPF_PROG_TYPE_SOCK_OPS = 11,
	__ctx_convertBPF_PROG_TYPE_SK_SKB = 12,
	__ctx_convertBPF_PROG_TYPE_SK_MSG = 13,
	__ctx_convertBPF_PROG_TYPE_FLOW_DISSECTOR = 14,
	__ctx_convertBPF_PROG_TYPE_KPROBE = 15,
	__ctx_convertBPF_PROG_TYPE_TRACEPOINT = 16,
	__ctx_convertBPF_PROG_TYPE_PERF_EVENT = 17,
	__ctx_convertBPF_PROG_TYPE_RAW_TRACEPOINT = 18,
	__ctx_convertBPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 19,
	__ctx_convertBPF_PROG_TYPE_TRACING = 20,
	__ctx_convertBPF_PROG_TYPE_CGROUP_DEVICE = 21,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SYSCTL = 22,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCKOPT = 23,
	__ctx_convertBPF_PROG_TYPE_LIRC_MODE2 = 24,
	__ctx_convertBPF_PROG_TYPE_SK_REUSEPORT = 25,
	__ctx_convertBPF_PROG_TYPE_SK_LOOKUP = 26,
	__ctx_convertBPF_PROG_TYPE_STRUCT_OPS = 27,
	__ctx_convertBPF_PROG_TYPE_EXT = 28,
	__ctx_convertBPF_PROG_TYPE_LSM = 29,
	__ctx_convertBPF_PROG_TYPE_SYSCALL = 30,
	__ctx_convertBPF_PROG_TYPE_NETFILTER = 31,
	__ctx_convert_unused = 32,
};

enum {
	arg_AL = 0,
	arg_CL = 1,
	arg_DL = 2,
	arg_BL = 3,
	arg_AH = 4,
	arg_CH = 5,
	arg_DH = 6,
	arg_BH = 7,
	arg_AX = 0,
	arg_CX = 1,
	arg_DX = 2,
	arg_BX = 3,
	arg_SP = 4,
	arg_BP = 5,
	arg_SI = 6,
	arg_DI = 7,
	arg_R8 = 8,
	arg_R9 = 9,
	arg_R10 = 10,
	arg_R11 = 11,
	arg_R12 = 12,
	arg_R13 = 13,
	arg_R14 = 14,
	arg_R15 = 15,
};

enum {
	blank_off = 0,
	blank_normal_wait = 1,
	blank_vesa_wait = 2,
};

enum {
	cpuset = 0,
	possible = 1,
	fail = 2,
};

enum {
	false = 0,
	true = 1,
};

enum {
	ncsi_dev_state_major = 65280,
	ncsi_dev_state_minor = 255,
	ncsi_dev_state_probe_deselect = 513,
	ncsi_dev_state_probe_package = 514,
	ncsi_dev_state_probe_channel = 515,
	ncsi_dev_state_probe_mlx_gma = 516,
	ncsi_dev_state_probe_mlx_smaf = 517,
	ncsi_dev_state_probe_cis = 518,
	ncsi_dev_state_probe_keep_phy = 519,
	ncsi_dev_state_probe_gvi = 520,
	ncsi_dev_state_probe_gc = 521,
	ncsi_dev_state_probe_gls = 522,
	ncsi_dev_state_probe_dp = 523,
	ncsi_dev_state_config_sp = 769,
	ncsi_dev_state_config_cis = 770,
	ncsi_dev_state_config_oem_gma = 771,
	ncsi_dev_state_config_apply_mac = 772,
	ncsi_dev_state_config_clear_vids = 773,
	ncsi_dev_state_config_svf = 774,
	ncsi_dev_state_config_ev = 775,
	ncsi_dev_state_config_sma = 776,
	ncsi_dev_state_config_ebf = 777,
	ncsi_dev_state_config_dgmf = 778,
	ncsi_dev_state_config_ecnt = 779,
	ncsi_dev_state_config_ec = 780,
	ncsi_dev_state_config_ae = 781,
	ncsi_dev_state_config_gls = 782,
	ncsi_dev_state_config_done = 783,
	ncsi_dev_state_suspend_select = 1025,
	ncsi_dev_state_suspend_gls = 1026,
	ncsi_dev_state_suspend_dcnt = 1027,
	ncsi_dev_state_suspend_dc = 1028,
	ncsi_dev_state_suspend_deselect = 1029,
	ncsi_dev_state_suspend_done = 1030,
};

enum {
	ncsi_dev_state_registered = 0,
	ncsi_dev_state_functional = 256,
	ncsi_dev_state_probe = 512,
	ncsi_dev_state_config = 768,
	ncsi_dev_state_suspend = 1024,
};

enum {
	none = 0,
	day = 1,
	month = 2,
	year = 3,
};

enum {
	pci_channel_io_normal = 1,
	pci_channel_io_frozen = 2,
	pci_channel_io_perm_failure = 3,
};

enum {
	preempt_dynamic_undefined = -1,
	preempt_dynamic_none = 0,
	preempt_dynamic_voluntary = 1,
	preempt_dynamic_full = 2,
	preempt_dynamic_lazy = 3,
};

enum {
	st_wordstart = 0,
	st_wordcmp = 1,
	st_wordskip = 2,
	st_bufcpy = 3,
};

enum {
	st_wordstart___2 = 0,
	st_wordcmp___2 = 1,
	st_wordskip___2 = 2,
};

enum {
	x86_lbr_exclusive_lbr = 0,
	x86_lbr_exclusive_bts = 1,
	x86_lbr_exclusive_pt = 2,
	x86_lbr_exclusive_max = 3,
};

typedef enum {
	BIT_DStream_unfinished = 0,
	BIT_DStream_endOfBuffer = 1,
	BIT_DStream_completed = 2,
	BIT_DStream_overflow = 3,
} BIT_DStream_status;

typedef enum {
	ZSTD_error_no_error = 0,
	ZSTD_error_GENERIC = 1,
	ZSTD_error_prefix_unknown = 10,
	ZSTD_error_version_unsupported = 12,
	ZSTD_error_frameParameter_unsupported = 14,
	ZSTD_error_frameParameter_windowTooLarge = 16,
	ZSTD_error_corruption_detected = 20,
	ZSTD_error_checksum_wrong = 22,
	ZSTD_error_literals_headerWrong = 24,
	ZSTD_error_dictionary_corrupted = 30,
	ZSTD_error_dictionary_wrong = 32,
	ZSTD_error_dictionaryCreation_failed = 34,
	ZSTD_error_parameter_unsupported = 40,
	ZSTD_error_parameter_combination_unsupported = 41,
	ZSTD_error_parameter_outOfBound = 42,
	ZSTD_error_tableLog_tooLarge = 44,
	ZSTD_error_maxSymbolValue_tooLarge = 46,
	ZSTD_error_maxSymbolValue_tooSmall = 48,
	ZSTD_error_cannotProduce_uncompressedBlock = 49,
	ZSTD_error_stabilityCondition_notRespected = 50,
	ZSTD_error_stage_wrong = 60,
	ZSTD_error_init_missing = 62,
	ZSTD_error_memory_allocation = 64,
	ZSTD_error_workSpace_tooSmall = 66,
	ZSTD_error_dstSize_tooSmall = 70,
	ZSTD_error_srcSize_wrong = 72,
	ZSTD_error_dstBuffer_null = 74,
	ZSTD_error_noForwardProgress_destFull = 80,
	ZSTD_error_noForwardProgress_inputEmpty = 82,
	ZSTD_error_frameIndex_tooLarge = 100,
	ZSTD_error_seekableIO = 102,
	ZSTD_error_dstBuffer_wrong = 104,
	ZSTD_error_srcBuffer_wrong = 105,
	ZSTD_error_sequenceProducer_failed = 106,
	ZSTD_error_externalSequences_invalid = 107,
	ZSTD_error_maxCode = 120,
} ZSTD_ErrorCode;

typedef ZSTD_ErrorCode ERR_enum;

typedef enum {
	FSE_repeat_none = 0,
	FSE_repeat_check = 1,
	FSE_repeat_valid = 2,
} FSE_repeat;

typedef enum {
	trustInput = 0,
	checkMaxSymbolValue = 1,
} HIST_checkInput_e;

typedef enum {
	HUF_singleStream = 0,
	HUF_fourStreams = 1,
} HUF_nbStreams_e;

typedef enum {
	HUF_repeat_none = 0,
	HUF_repeat_check = 1,
	HUF_repeat_valid = 2,
} HUF_repeat;

typedef enum {
	set_basic = 0,
	set_rle = 1,
	set_compressed = 2,
	set_repeat = 3,
} SymbolEncodingType_e;

typedef enum {
	ZSTD_cpm_noAttachDict = 0,
	ZSTD_cpm_attachDict = 1,
	ZSTD_cpm_createCDict = 2,
	ZSTD_cpm_unknown = 3,
} ZSTD_CParamMode_e;

typedef enum {
	ZSTD_defaultDisallowed = 0,
	ZSTD_defaultAllowed = 1,
} ZSTD_DefaultPolicy_e;

typedef enum {
	ZSTD_e_continue = 0,
	ZSTD_e_flush = 1,
	ZSTD_e_end = 2,
} ZSTD_EndDirective;

typedef enum {
	ZSTD_frame = 0,
	ZSTD_skippableFrame = 1,
} ZSTD_FrameType_e;

typedef enum {
	zop_dynamic = 0,
	zop_predef = 1,
} ZSTD_OptPrice_e;

typedef enum {
	ZSTD_ps_auto = 0,
	ZSTD_ps_enable = 1,
	ZSTD_ps_disable = 2,
} ZSTD_ParamSwitch_e;

typedef enum {
	ZSTD_reset_session_only = 1,
	ZSTD_reset_parameters = 2,
	ZSTD_reset_session_and_parameters = 3,
} ZSTD_ResetDirective;

typedef enum {
	ZSTD_sf_noBlockDelimiters = 0,
	ZSTD_sf_explicitBlockDelimiters = 1,
} ZSTD_SequenceFormat_e;

typedef enum {
	ZSTD_bm_buffered = 0,
	ZSTD_bm_stable = 1,
} ZSTD_bufferMode_e;

typedef enum {
	ZSTDb_not_buffered = 0,
	ZSTDb_buffered = 1,
} ZSTD_buffered_policy_e;

typedef enum {
	ZSTD_c_compressionLevel = 100,
	ZSTD_c_windowLog = 101,
	ZSTD_c_hashLog = 102,
	ZSTD_c_chainLog = 103,
	ZSTD_c_searchLog = 104,
	ZSTD_c_minMatch = 105,
	ZSTD_c_targetLength = 106,
	ZSTD_c_strategy = 107,
	ZSTD_c_targetCBlockSize = 130,
	ZSTD_c_enableLongDistanceMatching = 160,
	ZSTD_c_ldmHashLog = 161,
	ZSTD_c_ldmMinMatch = 162,
	ZSTD_c_ldmBucketSizeLog = 163,
	ZSTD_c_ldmHashRateLog = 164,
	ZSTD_c_contentSizeFlag = 200,
	ZSTD_c_checksumFlag = 201,
	ZSTD_c_dictIDFlag = 202,
	ZSTD_c_nbWorkers = 400,
	ZSTD_c_jobSize = 401,
	ZSTD_c_overlapLog = 402,
	ZSTD_c_experimentalParam1 = 500,
	ZSTD_c_experimentalParam2 = 10,
	ZSTD_c_experimentalParam3 = 1000,
	ZSTD_c_experimentalParam4 = 1001,
	ZSTD_c_experimentalParam5 = 1002,
	ZSTD_c_experimentalParam7 = 1004,
	ZSTD_c_experimentalParam8 = 1005,
	ZSTD_c_experimentalParam9 = 1006,
	ZSTD_c_experimentalParam10 = 1007,
	ZSTD_c_experimentalParam11 = 1008,
	ZSTD_c_experimentalParam12 = 1009,
	ZSTD_c_experimentalParam13 = 1010,
	ZSTD_c_experimentalParam14 = 1011,
	ZSTD_c_experimentalParam15 = 1012,
	ZSTD_c_experimentalParam16 = 1013,
	ZSTD_c_experimentalParam17 = 1014,
	ZSTD_c_experimentalParam18 = 1015,
	ZSTD_c_experimentalParam19 = 1016,
	ZSTD_c_experimentalParam20 = 1017,
} ZSTD_cParameter;

typedef enum {
	zcss_init = 0,
	zcss_load = 1,
	zcss_flush = 2,
} ZSTD_cStreamStage;

typedef enum {
	ZSTDcrp_makeClean = 0,
	ZSTDcrp_leaveDirty = 1,
} ZSTD_compResetPolicy_e;

typedef enum {
	ZSTDcs_created = 0,
	ZSTDcs_init = 1,
	ZSTDcs_ongoing = 2,
	ZSTDcs_ending = 3,
} ZSTD_compressionStage_e;

typedef enum {
	ZSTD_cwksp_alloc_objects = 0,
	ZSTD_cwksp_alloc_aligned_init_once = 1,
	ZSTD_cwksp_alloc_aligned = 2,
	ZSTD_cwksp_alloc_buffers = 3,
} ZSTD_cwksp_alloc_phase_e;

typedef enum {
	ZSTD_cwksp_dynamic_alloc = 0,
	ZSTD_cwksp_static_alloc = 1,
} ZSTD_cwksp_static_alloc_e;

typedef enum {
	ZSTD_d_windowLogMax = 100,
	ZSTD_d_experimentalParam1 = 1000,
	ZSTD_d_experimentalParam2 = 1001,
	ZSTD_d_experimentalParam3 = 1002,
	ZSTD_d_experimentalParam4 = 1003,
	ZSTD_d_experimentalParam5 = 1004,
	ZSTD_d_experimentalParam6 = 1005,
} ZSTD_dParameter;

typedef enum {
	ZSTDds_getFrameHeaderSize = 0,
	ZSTDds_decodeFrameHeader = 1,
	ZSTDds_decodeBlockHeader = 2,
	ZSTDds_decompressBlock = 3,
	ZSTDds_decompressLastBlock = 4,
	ZSTDds_checkChecksum = 5,
	ZSTDds_decodeSkippableHeader = 6,
	ZSTDds_skipFrame = 7,
} ZSTD_dStage;

typedef enum {
	zdss_init = 0,
	zdss_loadHeader = 1,
	zdss_read = 2,
	zdss_load = 3,
	zdss_flush = 4,
} ZSTD_dStreamStage;

typedef enum {
	ZSTD_dictDefaultAttach = 0,
	ZSTD_dictForceAttach = 1,
	ZSTD_dictForceCopy = 2,
	ZSTD_dictForceLoad = 3,
} ZSTD_dictAttachPref_e;

typedef enum {
	ZSTD_dct_auto = 0,
	ZSTD_dct_rawContent = 1,
	ZSTD_dct_fullDict = 2,
} ZSTD_dictContentType_e;

typedef enum {
	ZSTD_dlm_byCopy = 0,
	ZSTD_dlm_byRef = 1,
} ZSTD_dictLoadMethod_e;

typedef enum {
	ZSTD_noDict = 0,
	ZSTD_extDict = 1,
	ZSTD_dictMatchState = 2,
	ZSTD_dedicatedDictSearch = 3,
} ZSTD_dictMode_e;

typedef enum {
	ZSTD_dtlm_fast = 0,
	ZSTD_dtlm_full = 1,
} ZSTD_dictTableLoadMethod_e;

typedef enum {
	ZSTD_use_indefinitely = -1,
	ZSTD_dont_use = 0,
	ZSTD_use_once = 1,
} ZSTD_dictUses_e;

typedef enum {
	ZSTD_d_validateChecksum = 0,
	ZSTD_d_ignoreChecksum = 1,
} ZSTD_forceIgnoreChecksum_e;

typedef enum {
	ZSTD_f_zstd1 = 0,
	ZSTD_f_zstd1_magicless = 1,
} ZSTD_format_e;

typedef enum {
	ZSTDirp_continue = 0,
	ZSTDirp_reset = 1,
} ZSTD_indexResetPolicy_e;

typedef enum {
	ZSTD_not_in_dst = 0,
	ZSTD_in_dst = 1,
	ZSTD_split = 2,
} ZSTD_litLocation_e;

typedef enum {
	ZSTD_llt_none = 0,
	ZSTD_llt_literalLength = 1,
	ZSTD_llt_matchLength = 2,
} ZSTD_longLengthType_e;

typedef enum {
	ZSTD_lo_isRegularOffset = 0,
	ZSTD_lo_isLongOffset = 1,
} ZSTD_longOffset_e;

typedef enum {
	ZSTDnit_frameHeader = 0,
	ZSTDnit_blockHeader = 1,
	ZSTDnit_block = 2,
	ZSTDnit_lastBlock = 3,
	ZSTDnit_checksum = 4,
	ZSTDnit_skippableFrame = 5,
} ZSTD_nextInputType_e;

typedef enum {
	ZSTD_no_overlap = 0,
	ZSTD_overlap_src_before_dst = 1,
} ZSTD_overlap_e;

typedef enum {
	ZSTD_rmd_refSingleDDict = 0,
	ZSTD_rmd_refMultipleDDicts = 1,
} ZSTD_refMultipleDDicts_e;

typedef enum {
	ZSTD_resetTarget_CDict = 0,
	ZSTD_resetTarget_CCtx = 1,
} ZSTD_resetTarget_e;

typedef enum {
	ZSTD_fast = 1,
	ZSTD_dfast = 2,
	ZSTD_greedy = 3,
	ZSTD_lazy = 4,
	ZSTD_lazy2 = 5,
	ZSTD_btlazy2 = 6,
	ZSTD_btopt = 7,
	ZSTD_btultra = 8,
	ZSTD_btultra2 = 9,
} ZSTD_strategy;

typedef enum {
	ZSTD_tfp_forCCtx = 0,
	ZSTD_tfp_forCDict = 1,
} ZSTD_tableFillPurpose_e;

typedef enum {
	OSL_GLOBAL_LOCK_HANDLER = 0,
	OSL_NOTIFY_HANDLER = 1,
	OSL_GPE_HANDLER = 2,
	OSL_DEBUGGER_MAIN_THREAD = 3,
	OSL_DEBUGGER_EXEC_THREAD = 4,
	OSL_EC_POLL_HANDLER = 5,
	OSL_EC_BURST_HANDLER = 6,
} acpi_execute_type;

typedef enum {
	ACPI_IMODE_LOAD_PASS1 = 1,
	ACPI_IMODE_LOAD_PASS2 = 2,
	ACPI_IMODE_EXECUTE = 3,
} acpi_interpreter_mode;

typedef enum {
	ACPI_TRACE_AML_METHOD = 0,
	ACPI_TRACE_AML_OPCODE = 1,
	ACPI_TRACE_AML_REGION = 2,
} acpi_trace_event_type;

typedef enum {
	base_0possible = 0,
	base_1guaranteed = 1,
} base_directive_e;

typedef enum {
	bt_raw = 0,
	bt_rle = 1,
	bt_compressed = 2,
	bt_reserved = 3,
} blockType_e;

typedef enum {
	need_more = 0,
	block_done = 1,
	finish_started = 2,
	finish_done = 3,
} block_state;

typedef enum {
	CODES = 0,
	LENS = 1,
	DISTS = 2,
} codetype;

typedef enum {
	FILE_MEMORY_MIGRATE = 0,
	FILE_CPULIST = 1,
	FILE_MEMLIST = 2,
	FILE_EFFECTIVE_CPULIST = 3,
	FILE_EFFECTIVE_MEMLIST = 4,
	FILE_SUBPARTS_CPULIST = 5,
	FILE_EXCLUSIVE_CPULIST = 6,
	FILE_EFFECTIVE_XCPULIST = 7,
	FILE_ISOLATED_CPULIST = 8,
	FILE_CPU_EXCLUSIVE = 9,
	FILE_MEM_EXCLUSIVE = 10,
	FILE_MEM_HARDWALL = 11,
	FILE_SCHED_LOAD_BALANCE = 12,
	FILE_PARTITION_ROOT = 13,
	FILE_SCHED_RELAX_DOMAIN_LEVEL = 14,
	FILE_MEMORY_PRESSURE_ENABLED = 15,
	FILE_MEMORY_PRESSURE = 16,
	FILE_SPREAD_PAGE = 17,
	FILE_SPREAD_SLAB = 18,
} cpuset_filetype_t;

typedef enum {
	CS_ONLINE = 0,
	CS_CPU_EXCLUSIVE = 1,
	CS_MEM_EXCLUSIVE = 2,
	CS_MEM_HARDWALL = 3,
	CS_MEMORY_MIGRATE = 4,
	CS_SCHED_LOAD_BALANCE = 5,
	CS_SPREAD_PAGE = 6,
	CS_SPREAD_SLAB = 7,
} cpuset_flagbits_t;

typedef enum {
	noDict = 0,
	withPrefix64k = 1,
	usingExtDict = 2,
} dict_directive;

typedef enum {
	decode_full_block = 0,
	partial_decode = 1,
} earlyEnd_directive;

typedef enum {
	endOnOutputSize = 0,
	endOnInputSize = 1,
} endCondition_directive;

typedef enum {
	FS_DECRYPT = 0,
	FS_ENCRYPT = 1,
} fscrypt_direction_t;

typedef enum {
	HEAD = 0,
	FLAGS = 1,
	TIME = 2,
	OS = 3,
	EXLEN = 4,
	EXTRA = 5,
	NAME = 6,
	COMMENT = 7,
	HCRC = 8,
	DICTID = 9,
	DICT = 10,
	TYPE = 11,
	TYPEDO = 12,
	STORED = 13,
	COPY = 14,
	TABLE = 15,
	LENLENS = 16,
	CODELENS = 17,
	LEN = 18,
	LENEXT = 19,
	DIST = 20,
	DISTEXT = 21,
	MATCH = 22,
	LIT = 23,
	CHECK = 24,
	LENGTH = 25,
	DONE = 26,
	BAD = 27,
	MEM = 28,
	SYNC = 29,
} inflate_mode;

typedef enum {
	ISOLATE_ABORT = 0,
	ISOLATE_NONE = 1,
	ISOLATE_SUCCESS = 2,
} isolate_migrate_t;

typedef enum {
	MAP_CHG_REUSE = 0,
	MAP_CHG_NEEDED = 1,
	MAP_CHG_ENFORCED = 2,
} map_chg_state;

typedef enum {
	PAGE_KEEP = 0,
	PAGE_ACTIVATE = 1,
	PAGE_SUCCESS = 2,
	PAGE_CLEAN = 3,
} pageout_t;

typedef enum {
	PHY_INTERFACE_MODE_NA = 0,
	PHY_INTERFACE_MODE_INTERNAL = 1,
	PHY_INTERFACE_MODE_MII = 2,
	PHY_INTERFACE_MODE_GMII = 3,
	PHY_INTERFACE_MODE_SGMII = 4,
	PHY_INTERFACE_MODE_TBI = 5,
	PHY_INTERFACE_MODE_REVMII = 6,
	PHY_INTERFACE_MODE_RMII = 7,
	PHY_INTERFACE_MODE_REVRMII = 8,
	PHY_INTERFACE_MODE_RGMII = 9,
	PHY_INTERFACE_MODE_RGMII_ID = 10,
	PHY_INTERFACE_MODE_RGMII_RXID = 11,
	PHY_INTERFACE_MODE_RGMII_TXID = 12,
	PHY_INTERFACE_MODE_RTBI = 13,
	PHY_INTERFACE_MODE_SMII = 14,
	PHY_INTERFACE_MODE_XGMII = 15,
	PHY_INTERFACE_MODE_XLGMII = 16,
	PHY_INTERFACE_MODE_MOCA = 17,
	PHY_INTERFACE_MODE_PSGMII = 18,
	PHY_INTERFACE_MODE_QSGMII = 19,
	PHY_INTERFACE_MODE_TRGMII = 20,
	PHY_INTERFACE_MODE_100BASEX = 21,
	PHY_INTERFACE_MODE_1000BASEX = 22,
	PHY_INTERFACE_MODE_2500BASEX = 23,
	PHY_INTERFACE_MODE_5GBASER = 24,
	PHY_INTERFACE_MODE_RXAUI = 25,
	PHY_INTERFACE_MODE_XAUI = 26,
	PHY_INTERFACE_MODE_10GBASER = 27,
	PHY_INTERFACE_MODE_25GBASER = 28,
	PHY_INTERFACE_MODE_USXGMII = 29,
	PHY_INTERFACE_MODE_10GKR = 30,
	PHY_INTERFACE_MODE_QUSGMII = 31,
	PHY_INTERFACE_MODE_1000BASEKX = 32,
	PHY_INTERFACE_MODE_10G_QXGMII = 33,
	PHY_INTERFACE_MODE_50GBASER = 34,
	PHY_INTERFACE_MODE_LAUI = 35,
	PHY_INTERFACE_MODE_100GBASEP = 36,
	PHY_INTERFACE_MODE_MIILITE = 37,
	PHY_INTERFACE_MODE_MAX = 38,
} phy_interface_t;

typedef enum {
	search_hashChain = 0,
	search_binaryTree = 1,
	search_rowHash = 2,
} searchMethod_e;

typedef enum {
	SS_FREE = 0,
	SS_UNCONNECTED = 1,
	SS_CONNECTING = 2,
	SS_CONNECTED = 3,
	SS_DISCONNECTING = 4,
} socket_state;

typedef enum {
	not_streaming = 0,
	is_streaming = 1,
} streaming_operation;

typedef ZSTD_ErrorCode zstd_error_code;

enum CSI_J {
	CSI_J_CURSOR_TO_END = 0,
	CSI_J_START_TO_CURSOR = 1,
	CSI_J_VISIBLE = 2,
	CSI_J_FULL = 3,
};

enum CSI_right_square_bracket {
	CSI_RSB_COLOR_FOR_UNDERLINE = 1,
	CSI_RSB_COLOR_FOR_HALF_BRIGHT = 2,
	CSI_RSB_MAKE_CUR_COLOR_DEFAULT = 8,
	CSI_RSB_BLANKING_INTERVAL = 9,
	CSI_RSB_BELL_FREQUENCY = 10,
	CSI_RSB_BELL_DURATION = 11,
	CSI_RSB_BRING_CONSOLE_TO_FRONT = 12,
	CSI_RSB_UNBLANK = 13,
	CSI_RSB_VESA_OFF_INTERVAL = 14,
	CSI_RSB_BRING_PREV_CONSOLE_TO_FRONT = 15,
	CSI_RSB_CURSOR_BLINK_INTERVAL = 16,
};

enum KTHREAD_BITS {
	KTHREAD_IS_PER_CPU = 0,
	KTHREAD_SHOULD_STOP = 1,
	KTHREAD_SHOULD_PARK = 2,
};

enum OID {
	OID_id_dsa_with_sha1 = 0,
	OID_id_dsa = 1,
	OID_id_ecPublicKey = 2,
	OID_id_prime192v1 = 3,
	OID_id_prime256v1 = 4,
	OID_id_ecdsa_with_sha1 = 5,
	OID_id_ecdsa_with_sha224 = 6,
	OID_id_ecdsa_with_sha256 = 7,
	OID_id_ecdsa_with_sha384 = 8,
	OID_id_ecdsa_with_sha512 = 9,
	OID_rsaEncryption = 10,
	OID_sha1WithRSAEncryption = 11,
	OID_sha256WithRSAEncryption = 12,
	OID_sha384WithRSAEncryption = 13,
	OID_sha512WithRSAEncryption = 14,
	OID_sha224WithRSAEncryption = 15,
	OID_data = 16,
	OID_signed_data = 17,
	OID_email_address = 18,
	OID_contentType = 19,
	OID_messageDigest = 20,
	OID_signingTime = 21,
	OID_smimeCapabilites = 22,
	OID_smimeAuthenticatedAttrs = 23,
	OID_mskrb5 = 24,
	OID_krb5 = 25,
	OID_krb5u2u = 26,
	OID_msIndirectData = 27,
	OID_msStatementType = 28,
	OID_msSpOpusInfo = 29,
	OID_msPeImageDataObjId = 30,
	OID_msIndividualSPKeyPurpose = 31,
	OID_msOutlookExpress = 32,
	OID_ntlmssp = 33,
	OID_negoex = 34,
	OID_spnego = 35,
	OID_IAKerb = 36,
	OID_PKU2U = 37,
	OID_Scram = 38,
	OID_certAuthInfoAccess = 39,
	OID_sha1 = 40,
	OID_id_ansip384r1 = 41,
	OID_id_ansip521r1 = 42,
	OID_sha256 = 43,
	OID_sha384 = 44,
	OID_sha512 = 45,
	OID_sha224 = 46,
	OID_commonName = 47,
	OID_surname = 48,
	OID_countryName = 49,
	OID_locality = 50,
	OID_stateOrProvinceName = 51,
	OID_organizationName = 52,
	OID_organizationUnitName = 53,
	OID_title = 54,
	OID_description = 55,
	OID_name = 56,
	OID_givenName = 57,
	OID_initials = 58,
	OID_generationalQualifier = 59,
	OID_subjectKeyIdentifier = 60,
	OID_keyUsage = 61,
	OID_subjectAltName = 62,
	OID_issuerAltName = 63,
	OID_basicConstraints = 64,
	OID_crlDistributionPoints = 65,
	OID_certPolicies = 66,
	OID_authorityKeyIdentifier = 67,
	OID_extKeyUsage = 68,
	OID_NetlogonMechanism = 69,
	OID_appleLocalKdcSupported = 70,
	OID_gostCPSignA = 71,
	OID_gostCPSignB = 72,
	OID_gostCPSignC = 73,
	OID_gost2012PKey256 = 74,
	OID_gost2012PKey512 = 75,
	OID_gost2012Digest256 = 76,
	OID_gost2012Digest512 = 77,
	OID_gost2012Signature256 = 78,
	OID_gost2012Signature512 = 79,
	OID_gostTC26Sign256A = 80,
	OID_gostTC26Sign256B = 81,
	OID_gostTC26Sign256C = 82,
	OID_gostTC26Sign256D = 83,
	OID_gostTC26Sign512A = 84,
	OID_gostTC26Sign512B = 85,
	OID_gostTC26Sign512C = 86,
	OID_sm2 = 87,
	OID_sm3 = 88,
	OID_SM2_with_SM3 = 89,
	OID_sm3WithRSAEncryption = 90,
	OID_TPMLoadableKey = 91,
	OID_TPMImportableKey = 92,
	OID_TPMSealedData = 93,
	OID_sha3_256 = 94,
	OID_sha3_384 = 95,
	OID_sha3_512 = 96,
	OID_id_ecdsa_with_sha3_256 = 97,
	OID_id_ecdsa_with_sha3_384 = 98,
	OID_id_ecdsa_with_sha3_512 = 99,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_256 = 100,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_384 = 101,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_512 = 102,
	OID__NR = 103,
};

enum P4_ESCR_EMASKS {
	P4_EVENT_TC_DELIVER_MODE__DD = 512,
	P4_EVENT_TC_DELIVER_MODE__DB = 1024,
	P4_EVENT_TC_DELIVER_MODE__DI = 2048,
	P4_EVENT_TC_DELIVER_MODE__BD = 4096,
	P4_EVENT_TC_DELIVER_MODE__BB = 8192,
	P4_EVENT_TC_DELIVER_MODE__BI = 16384,
	P4_EVENT_TC_DELIVER_MODE__ID = 32768,
	P4_EVENT_BPU_FETCH_REQUEST__TCMISS = 512,
	P4_EVENT_ITLB_REFERENCE__HIT = 512,
	P4_EVENT_ITLB_REFERENCE__MISS = 1024,
	P4_EVENT_ITLB_REFERENCE__HIT_UK = 2048,
	P4_EVENT_MEMORY_CANCEL__ST_RB_FULL = 2048,
	P4_EVENT_MEMORY_CANCEL__64K_CONF = 4096,
	P4_EVENT_MEMORY_COMPLETE__LSC = 512,
	P4_EVENT_MEMORY_COMPLETE__SSC = 1024,
	P4_EVENT_LOAD_PORT_REPLAY__SPLIT_LD = 1024,
	P4_EVENT_STORE_PORT_REPLAY__SPLIT_ST = 1024,
	P4_EVENT_MOB_LOAD_REPLAY__NO_STA = 1024,
	P4_EVENT_MOB_LOAD_REPLAY__NO_STD = 4096,
	P4_EVENT_MOB_LOAD_REPLAY__PARTIAL_DATA = 8192,
	P4_EVENT_MOB_LOAD_REPLAY__UNALGN_ADDR = 16384,
	P4_EVENT_PAGE_WALK_TYPE__DTMISS = 512,
	P4_EVENT_PAGE_WALK_TYPE__ITMISS = 1024,
	P4_EVENT_BSQ_CACHE_REFERENCE__RD_2ndL_HITS = 512,
	P4_EVENT_BSQ_CACHE_REFERENCE__RD_2ndL_HITE = 1024,
	P4_EVENT_BSQ_CACHE_REFERENCE__RD_2ndL_HITM = 2048,
	P4_EVENT_BSQ_CACHE_REFERENCE__RD_3rdL_HITS = 4096,
	P4_EVENT_BSQ_CACHE_REFERENCE__RD_3rdL_HITE = 8192,
	P4_EVENT_BSQ_CACHE_REFERENCE__RD_3rdL_HITM = 16384,
	P4_EVENT_BSQ_CACHE_REFERENCE__RD_2ndL_MISS = 131072,
	P4_EVENT_BSQ_CACHE_REFERENCE__RD_3rdL_MISS = 262144,
	P4_EVENT_BSQ_CACHE_REFERENCE__WR_2ndL_MISS = 524288,
	P4_EVENT_IOQ_ALLOCATION__DEFAULT = 512,
	P4_EVENT_IOQ_ALLOCATION__ALL_READ = 16384,
	P4_EVENT_IOQ_ALLOCATION__ALL_WRITE = 32768,
	P4_EVENT_IOQ_ALLOCATION__MEM_UC = 65536,
	P4_EVENT_IOQ_ALLOCATION__MEM_WC = 131072,
	P4_EVENT_IOQ_ALLOCATION__MEM_WT = 262144,
	P4_EVENT_IOQ_ALLOCATION__MEM_WP = 524288,
	P4_EVENT_IOQ_ALLOCATION__MEM_WB = 1048576,
	P4_EVENT_IOQ_ALLOCATION__OWN = 4194304,
	P4_EVENT_IOQ_ALLOCATION__OTHER = 8388608,
	P4_EVENT_IOQ_ALLOCATION__PREFETCH = 16777216,
	P4_EVENT_IOQ_ACTIVE_ENTRIES__DEFAULT = 512,
	P4_EVENT_IOQ_ACTIVE_ENTRIES__ALL_READ = 16384,
	P4_EVENT_IOQ_ACTIVE_ENTRIES__ALL_WRITE = 32768,
	P4_EVENT_IOQ_ACTIVE_ENTRIES__MEM_UC = 65536,
	P4_EVENT_IOQ_ACTIVE_ENTRIES__MEM_WC = 131072,
	P4_EVENT_IOQ_ACTIVE_ENTRIES__MEM_WT = 262144,
	P4_EVENT_IOQ_ACTIVE_ENTRIES__MEM_WP = 524288,
	P4_EVENT_IOQ_ACTIVE_ENTRIES__MEM_WB = 1048576,
	P4_EVENT_IOQ_ACTIVE_ENTRIES__OWN = 4194304,
	P4_EVENT_IOQ_ACTIVE_ENTRIES__OTHER = 8388608,
	P4_EVENT_IOQ_ACTIVE_ENTRIES__PREFETCH = 16777216,
	P4_EVENT_FSB_DATA_ACTIVITY__DRDY_DRV = 512,
	P4_EVENT_FSB_DATA_ACTIVITY__DRDY_OWN = 1024,
	P4_EVENT_FSB_DATA_ACTIVITY__DRDY_OTHER = 2048,
	P4_EVENT_FSB_DATA_ACTIVITY__DBSY_DRV = 4096,
	P4_EVENT_FSB_DATA_ACTIVITY__DBSY_OWN = 8192,
	P4_EVENT_FSB_DATA_ACTIVITY__DBSY_OTHER = 16384,
	P4_EVENT_BSQ_ALLOCATION__REQ_TYPE0 = 512,
	P4_EVENT_BSQ_ALLOCATION__REQ_TYPE1 = 1024,
	P4_EVENT_BSQ_ALLOCATION__REQ_LEN0 = 2048,
	P4_EVENT_BSQ_ALLOCATION__REQ_LEN1 = 4096,
	P4_EVENT_BSQ_ALLOCATION__REQ_IO_TYPE = 16384,
	P4_EVENT_BSQ_ALLOCATION__REQ_LOCK_TYPE = 32768,
	P4_EVENT_BSQ_ALLOCATION__REQ_CACHE_TYPE = 65536,
	P4_EVENT_BSQ_ALLOCATION__REQ_SPLIT_TYPE = 131072,
	P4_EVENT_BSQ_ALLOCATION__REQ_DEM_TYPE = 262144,
	P4_EVENT_BSQ_ALLOCATION__REQ_ORD_TYPE = 524288,
	P4_EVENT_BSQ_ALLOCATION__MEM_TYPE0 = 1048576,
	P4_EVENT_BSQ_ALLOCATION__MEM_TYPE1 = 2097152,
	P4_EVENT_BSQ_ALLOCATION__MEM_TYPE2 = 4194304,
	P4_EVENT_BSQ_ACTIVE_ENTRIES__REQ_TYPE0 = 512,
	P4_EVENT_BSQ_ACTIVE_ENTRIES__REQ_TYPE1 = 1024,
	P4_EVENT_BSQ_ACTIVE_ENTRIES__REQ_LEN0 = 2048,
	P4_EVENT_BSQ_ACTIVE_ENTRIES__REQ_LEN1 = 4096,
	P4_EVENT_BSQ_ACTIVE_ENTRIES__REQ_IO_TYPE = 16384,
	P4_EVENT_BSQ_ACTIVE_ENTRIES__REQ_LOCK_TYPE = 32768,
	P4_EVENT_BSQ_ACTIVE_ENTRIES__REQ_CACHE_TYPE = 65536,
	P4_EVENT_BSQ_ACTIVE_ENTRIES__REQ_SPLIT_TYPE = 131072,
	P4_EVENT_BSQ_ACTIVE_ENTRIES__REQ_DEM_TYPE = 262144,
	P4_EVENT_BSQ_ACTIVE_ENTRIES__REQ_ORD_TYPE = 524288,
	P4_EVENT_BSQ_ACTIVE_ENTRIES__MEM_TYPE0 = 1048576,
	P4_EVENT_BSQ_ACTIVE_ENTRIES__MEM_TYPE1 = 2097152,
	P4_EVENT_BSQ_ACTIVE_ENTRIES__MEM_TYPE2 = 4194304,
	P4_EVENT_SSE_INPUT_ASSIST__ALL = 16777216,
	P4_EVENT_PACKED_SP_UOP__ALL = 16777216,
	P4_EVENT_PACKED_DP_UOP__ALL = 16777216,
	P4_EVENT_SCALAR_SP_UOP__ALL = 16777216,
	P4_EVENT_SCALAR_DP_UOP__ALL = 16777216,
	P4_EVENT_64BIT_MMX_UOP__ALL = 16777216,
	P4_EVENT_128BIT_MMX_UOP__ALL = 16777216,
	P4_EVENT_X87_FP_UOP__ALL = 16777216,
	P4_EVENT_TC_MISC__FLUSH = 8192,
	P4_EVENT_GLOBAL_POWER_EVENTS__RUNNING = 512,
	P4_EVENT_TC_MS_XFER__CISC = 512,
	P4_EVENT_UOP_QUEUE_WRITES__FROM_TC_BUILD = 512,
	P4_EVENT_UOP_QUEUE_WRITES__FROM_TC_DELIVER = 1024,
	P4_EVENT_UOP_QUEUE_WRITES__FROM_ROM = 2048,
	P4_EVENT_RETIRED_MISPRED_BRANCH_TYPE__CONDITIONAL = 1024,
	P4_EVENT_RETIRED_MISPRED_BRANCH_TYPE__CALL = 2048,
	P4_EVENT_RETIRED_MISPRED_BRANCH_TYPE__RETURN = 4096,
	P4_EVENT_RETIRED_MISPRED_BRANCH_TYPE__INDIRECT = 8192,
	P4_EVENT_RETIRED_BRANCH_TYPE__CONDITIONAL = 1024,
	P4_EVENT_RETIRED_BRANCH_TYPE__CALL = 2048,
	P4_EVENT_RETIRED_BRANCH_TYPE__RETURN = 4096,
	P4_EVENT_RETIRED_BRANCH_TYPE__INDIRECT = 8192,
	P4_EVENT_RESOURCE_STALL__SBFULL = 16384,
	P4_EVENT_WC_BUFFER__WCB_EVICTS = 512,
	P4_EVENT_WC_BUFFER__WCB_FULL_EVICTS = 1024,
	P4_EVENT_FRONT_END_EVENT__NBOGUS = 512,
	P4_EVENT_FRONT_END_EVENT__BOGUS = 1024,
	P4_EVENT_EXECUTION_EVENT__NBOGUS0 = 512,
	P4_EVENT_EXECUTION_EVENT__NBOGUS1 = 1024,
	P4_EVENT_EXECUTION_EVENT__NBOGUS2 = 2048,
	P4_EVENT_EXECUTION_EVENT__NBOGUS3 = 4096,
	P4_EVENT_EXECUTION_EVENT__BOGUS0 = 8192,
	P4_EVENT_EXECUTION_EVENT__BOGUS1 = 16384,
	P4_EVENT_EXECUTION_EVENT__BOGUS2 = 32768,
	P4_EVENT_EXECUTION_EVENT__BOGUS3 = 65536,
	P4_EVENT_REPLAY_EVENT__NBOGUS = 512,
	P4_EVENT_REPLAY_EVENT__BOGUS = 1024,
	P4_EVENT_INSTR_RETIRED__NBOGUSNTAG = 512,
	P4_EVENT_INSTR_RETIRED__NBOGUSTAG = 1024,
	P4_EVENT_INSTR_RETIRED__BOGUSNTAG = 2048,
	P4_EVENT_INSTR_RETIRED__BOGUSTAG = 4096,
	P4_EVENT_UOPS_RETIRED__NBOGUS = 512,
	P4_EVENT_UOPS_RETIRED__BOGUS = 1024,
	P4_EVENT_UOP_TYPE__TAGLOADS = 1024,
	P4_EVENT_UOP_TYPE__TAGSTORES = 2048,
	P4_EVENT_BRANCH_RETIRED__MMNP = 512,
	P4_EVENT_BRANCH_RETIRED__MMNM = 1024,
	P4_EVENT_BRANCH_RETIRED__MMTP = 2048,
	P4_EVENT_BRANCH_RETIRED__MMTM = 4096,
	P4_EVENT_MISPRED_BRANCH_RETIRED__NBOGUS = 512,
	P4_EVENT_X87_ASSIST__FPSU = 512,
	P4_EVENT_X87_ASSIST__FPSO = 1024,
	P4_EVENT_X87_ASSIST__POAO = 2048,
	P4_EVENT_X87_ASSIST__POAU = 4096,
	P4_EVENT_X87_ASSIST__PREA = 8192,
	P4_EVENT_MACHINE_CLEAR__CLEAR = 512,
	P4_EVENT_MACHINE_CLEAR__MOCLEAR = 1024,
	P4_EVENT_MACHINE_CLEAR__SMCLEAR = 2048,
	P4_EVENT_INSTR_COMPLETED__NBOGUS = 512,
	P4_EVENT_INSTR_COMPLETED__BOGUS = 1024,
};

enum P4_EVENTS {
	P4_EVENT_TC_DELIVER_MODE = 0,
	P4_EVENT_BPU_FETCH_REQUEST = 1,
	P4_EVENT_ITLB_REFERENCE = 2,
	P4_EVENT_MEMORY_CANCEL = 3,
	P4_EVENT_MEMORY_COMPLETE = 4,
	P4_EVENT_LOAD_PORT_REPLAY = 5,
	P4_EVENT_STORE_PORT_REPLAY = 6,
	P4_EVENT_MOB_LOAD_REPLAY = 7,
	P4_EVENT_PAGE_WALK_TYPE = 8,
	P4_EVENT_BSQ_CACHE_REFERENCE = 9,
	P4_EVENT_IOQ_ALLOCATION = 10,
	P4_EVENT_IOQ_ACTIVE_ENTRIES = 11,
	P4_EVENT_FSB_DATA_ACTIVITY = 12,
	P4_EVENT_BSQ_ALLOCATION = 13,
	P4_EVENT_BSQ_ACTIVE_ENTRIES = 14,
	P4_EVENT_SSE_INPUT_ASSIST = 15,
	P4_EVENT_PACKED_SP_UOP = 16,
	P4_EVENT_PACKED_DP_UOP = 17,
	P4_EVENT_SCALAR_SP_UOP = 18,
	P4_EVENT_SCALAR_DP_UOP = 19,
	P4_EVENT_64BIT_MMX_UOP = 20,
	P4_EVENT_128BIT_MMX_UOP = 21,
	P4_EVENT_X87_FP_UOP = 22,
	P4_EVENT_TC_MISC = 23,
	P4_EVENT_GLOBAL_POWER_EVENTS = 24,
	P4_EVENT_TC_MS_XFER = 25,
	P4_EVENT_UOP_QUEUE_WRITES = 26,
	P4_EVENT_RETIRED_MISPRED_BRANCH_TYPE = 27,
	P4_EVENT_RETIRED_BRANCH_TYPE = 28,
	P4_EVENT_RESOURCE_STALL = 29,
	P4_EVENT_WC_BUFFER = 30,
	P4_EVENT_B2B_CYCLES = 31,
	P4_EVENT_BNR = 32,
	P4_EVENT_SNOOP = 33,
	P4_EVENT_RESPONSE = 34,
	P4_EVENT_FRONT_END_EVENT = 35,
	P4_EVENT_EXECUTION_EVENT = 36,
	P4_EVENT_REPLAY_EVENT = 37,
	P4_EVENT_INSTR_RETIRED = 38,
	P4_EVENT_UOPS_RETIRED = 39,
	P4_EVENT_UOP_TYPE = 40,
	P4_EVENT_BRANCH_RETIRED = 41,
	P4_EVENT_MISPRED_BRANCH_RETIRED = 42,
	P4_EVENT_X87_ASSIST = 43,
	P4_EVENT_MACHINE_CLEAR = 44,
	P4_EVENT_INSTR_COMPLETED = 45,
};

enum P4_EVENT_OPCODES {
	P4_EVENT_TC_DELIVER_MODE_OPCODE = 257,
	P4_EVENT_BPU_FETCH_REQUEST_OPCODE = 768,
	P4_EVENT_ITLB_REFERENCE_OPCODE = 6147,
	P4_EVENT_MEMORY_CANCEL_OPCODE = 517,
	P4_EVENT_MEMORY_COMPLETE_OPCODE = 2050,
	P4_EVENT_LOAD_PORT_REPLAY_OPCODE = 1026,
	P4_EVENT_STORE_PORT_REPLAY_OPCODE = 1282,
	P4_EVENT_MOB_LOAD_REPLAY_OPCODE = 770,
	P4_EVENT_PAGE_WALK_TYPE_OPCODE = 260,
	P4_EVENT_BSQ_CACHE_REFERENCE_OPCODE = 3079,
	P4_EVENT_IOQ_ALLOCATION_OPCODE = 774,
	P4_EVENT_IOQ_ACTIVE_ENTRIES_OPCODE = 6662,
	P4_EVENT_FSB_DATA_ACTIVITY_OPCODE = 5894,
	P4_EVENT_BSQ_ALLOCATION_OPCODE = 1287,
	P4_EVENT_BSQ_ACTIVE_ENTRIES_OPCODE = 1543,
	P4_EVENT_SSE_INPUT_ASSIST_OPCODE = 13313,
	P4_EVENT_PACKED_SP_UOP_OPCODE = 2049,
	P4_EVENT_PACKED_DP_UOP_OPCODE = 3073,
	P4_EVENT_SCALAR_SP_UOP_OPCODE = 2561,
	P4_EVENT_SCALAR_DP_UOP_OPCODE = 3585,
	P4_EVENT_64BIT_MMX_UOP_OPCODE = 513,
	P4_EVENT_128BIT_MMX_UOP_OPCODE = 6657,
	P4_EVENT_X87_FP_UOP_OPCODE = 1025,
	P4_EVENT_TC_MISC_OPCODE = 1537,
	P4_EVENT_GLOBAL_POWER_EVENTS_OPCODE = 4870,
	P4_EVENT_TC_MS_XFER_OPCODE = 1280,
	P4_EVENT_UOP_QUEUE_WRITES_OPCODE = 2304,
	P4_EVENT_RETIRED_MISPRED_BRANCH_TYPE_OPCODE = 1282,
	P4_EVENT_RETIRED_BRANCH_TYPE_OPCODE = 1026,
	P4_EVENT_RESOURCE_STALL_OPCODE = 257,
	P4_EVENT_WC_BUFFER_OPCODE = 1285,
	P4_EVENT_B2B_CYCLES_OPCODE = 5635,
	P4_EVENT_BNR_OPCODE = 2051,
	P4_EVENT_SNOOP_OPCODE = 1539,
	P4_EVENT_RESPONSE_OPCODE = 1027,
	P4_EVENT_FRONT_END_EVENT_OPCODE = 2053,
	P4_EVENT_EXECUTION_EVENT_OPCODE = 3077,
	P4_EVENT_REPLAY_EVENT_OPCODE = 2309,
	P4_EVENT_INSTR_RETIRED_OPCODE = 516,
	P4_EVENT_UOPS_RETIRED_OPCODE = 260,
	P4_EVENT_UOP_TYPE_OPCODE = 514,
	P4_EVENT_BRANCH_RETIRED_OPCODE = 1541,
	P4_EVENT_MISPRED_BRANCH_RETIRED_OPCODE = 772,
	P4_EVENT_X87_ASSIST_OPCODE = 773,
	P4_EVENT_MACHINE_CLEAR_OPCODE = 517,
	P4_EVENT_INSTR_COMPLETED_OPCODE = 1796,
};

enum P4_PEBS_METRIC {
	P4_PEBS_METRIC__none = 0,
	P4_PEBS_METRIC__1stl_cache_load_miss_retired = 1,
	P4_PEBS_METRIC__2ndl_cache_load_miss_retired = 2,
	P4_PEBS_METRIC__dtlb_load_miss_retired = 3,
	P4_PEBS_METRIC__dtlb_store_miss_retired = 4,
	P4_PEBS_METRIC__dtlb_all_miss_retired = 5,
	P4_PEBS_METRIC__tagged_mispred_branch = 6,
	P4_PEBS_METRIC__mob_load_replay_retired = 7,
	P4_PEBS_METRIC__split_load_retired = 8,
	P4_PEBS_METRIC__split_store_retired = 9,
	P4_PEBS_METRIC__max = 10,
};

enum TPM_OPS_FLAGS {
	TPM_OPS_AUTO_STARTUP = 1,
};

enum __sk_action {
	__SK_DROP = 0,
	__SK_PASS = 1,
	__SK_REDIRECT = 2,
	__SK_NONE = 3,
};

enum _cache_table_type {
	CACHE_L1_INST = 1,
	CACHE_L1_DATA = 2,
	CACHE_L2 = 3,
	CACHE_L3 = 4,
} __attribute__((mode(byte)));

enum _cache_type {
	CTYPE_NULL = 0,
	CTYPE_DATA = 1,
	CTYPE_INST = 2,
	CTYPE_UNIFIED = 3,
};

enum _slab_flag_bits {
	_SLAB_CONSISTENCY_CHECKS = 0,
	_SLAB_RED_ZONE = 1,
	_SLAB_POISON = 2,
	_SLAB_KMALLOC = 3,
	_SLAB_HWCACHE_ALIGN = 4,
	_SLAB_CACHE_DMA = 5,
	_SLAB_CACHE_DMA32 = 6,
	_SLAB_STORE_USER = 7,
	_SLAB_PANIC = 8,
	_SLAB_TYPESAFE_BY_RCU = 9,
	_SLAB_TRACE = 10,
	_SLAB_NOLEAKTRACE = 11,
	_SLAB_NO_MERGE = 12,
	_SLAB_ACCOUNT = 13,
	_SLAB_NO_USER_FLAGS = 14,
	_SLAB_SKIP_KFENCE = 15,
	_SLAB_RECLAIM_ACCOUNT = 16,
	_SLAB_OBJECT_POISON = 17,
	_SLAB_CMPXCHG_DOUBLE = 18,
	_SLAB_NO_OBJ_EXT = 19,
	_SLAB_FLAGS_LAST_BIT = 20,
};

enum _tlb_table_type {
	TLB_INST_4K = 5,
	TLB_INST_4M = 6,
	TLB_INST_2M_4M = 7,
	TLB_INST_ALL = 8,
	TLB_DATA_4K = 9,
	TLB_DATA_4M = 10,
	TLB_DATA_2M_4M = 11,
	TLB_DATA_4K_4M = 12,
	TLB_DATA_1G = 13,
	TLB_DATA_1G_2M_4M = 14,
	TLB_DATA0_4K = 15,
	TLB_DATA0_4M = 16,
	TLB_DATA0_2M_4M = 17,
	STLB_4K = 18,
	STLB_4K_2M = 19,
} __attribute__((mode(byte)));

enum aa_code {
	AA_U8 = 0,
	AA_U16 = 1,
	AA_U32 = 2,
	AA_U64 = 3,
	AA_NAME = 4,
	AA_STRING = 5,
	AA_BLOB = 6,
	AA_STRUCT = 7,
	AA_STRUCTEND = 8,
	AA_LIST = 9,
	AA_LISTEND = 10,
	AA_ARRAY = 11,
	AA_ARRAYEND = 12,
};

enum aa_sfs_type {
	AA_SFS_TYPE_BOOLEAN = 0,
	AA_SFS_TYPE_STRING = 1,
	AA_SFS_TYPE_U64 = 2,
	AA_SFS_TYPE_FOPS = 3,
	AA_SFS_TYPE_DIR = 4,
};

enum aafs_ns_type {
	AAFS_NS_DIR = 0,
	AAFS_NS_PROFS = 1,
	AAFS_NS_NS = 2,
	AAFS_NS_RAW_DATA = 3,
	AAFS_NS_LOAD = 4,
	AAFS_NS_REPLACE = 5,
	AAFS_NS_REMOVE = 6,
	AAFS_NS_REVISION = 7,
	AAFS_NS_COUNT = 8,
	AAFS_NS_MAX_COUNT = 9,
	AAFS_NS_SIZE = 10,
	AAFS_NS_MAX_SIZE = 11,
	AAFS_NS_OWNER = 12,
	AAFS_NS_SIZEOF = 13,
};

enum aafs_prof_type {
	AAFS_PROF_DIR = 0,
	AAFS_PROF_PROFS = 1,
	AAFS_PROF_NAME = 2,
	AAFS_PROF_MODE = 3,
	AAFS_PROF_ATTACH = 4,
	AAFS_PROF_HASH = 5,
	AAFS_PROF_RAW_DATA = 6,
	AAFS_PROF_RAW_HASH = 7,
	AAFS_PROF_RAW_ABI = 8,
	AAFS_PROF_SIZEOF = 9,
};

enum aat2870_id {
	AAT2870_ID_BL = 0,
	AAT2870_ID_LDOA = 1,
	AAT2870_ID_LDOB = 2,
	AAT2870_ID_LDOC = 3,
	AAT2870_ID_LDOD = 4,
};

enum access_coordinate_class {
	ACCESS_COORDINATE_LOCAL = 0,
	ACCESS_COORDINATE_CPU = 1,
	ACCESS_COORDINATE_MAX = 2,
};

enum acpi_attr_enum {
	ACPI_ATTR_LABEL_SHOW = 0,
	ACPI_ATTR_INDEX_SHOW = 1,
};

enum acpi_bridge_type {
	ACPI_BRIDGE_TYPE_PCIE = 1,
	ACPI_BRIDGE_TYPE_CXL = 2,
};

enum acpi_bus_device_type {
	ACPI_BUS_TYPE_DEVICE = 0,
	ACPI_BUS_TYPE_POWER = 1,
	ACPI_BUS_TYPE_PROCESSOR = 2,
	ACPI_BUS_TYPE_THERMAL = 3,
	ACPI_BUS_TYPE_POWER_BUTTON = 4,
	ACPI_BUS_TYPE_SLEEP_BUTTON = 5,
	ACPI_BUS_TYPE_ECDT_EC = 6,
	ACPI_BUS_DEVICE_TYPE_COUNT = 7,
};

enum acpi_cdat_type {
	ACPI_CDAT_TYPE_DSMAS = 0,
	ACPI_CDAT_TYPE_DSLBIS = 1,
	ACPI_CDAT_TYPE_DSMSCIS = 2,
	ACPI_CDAT_TYPE_DSIS = 3,
	ACPI_CDAT_TYPE_DSEMTS = 4,
	ACPI_CDAT_TYPE_SSLBIS = 5,
	ACPI_CDAT_TYPE_RESERVED = 6,
};

enum acpi_cedt_type {
	ACPI_CEDT_TYPE_CHBS = 0,
	ACPI_CEDT_TYPE_CFMWS = 1,
	ACPI_CEDT_TYPE_CXIMS = 2,
	ACPI_CEDT_TYPE_RDPAS = 3,
	ACPI_CEDT_TYPE_RESERVED = 4,
};

enum acpi_device_swnode_dev_props {
	ACPI_DEVICE_SWNODE_DEV_ROTATION = 0,
	ACPI_DEVICE_SWNODE_DEV_CLOCK_FREQUENCY = 1,
	ACPI_DEVICE_SWNODE_DEV_LED_MAX_MICROAMP = 2,
	ACPI_DEVICE_SWNODE_DEV_FLASH_MAX_MICROAMP = 3,
	ACPI_DEVICE_SWNODE_DEV_FLASH_MAX_TIMEOUT_US = 4,
	ACPI_DEVICE_SWNODE_DEV_NUM_OF = 5,
	ACPI_DEVICE_SWNODE_DEV_NUM_ENTRIES = 6,
};

enum acpi_device_swnode_ep_props {
	ACPI_DEVICE_SWNODE_EP_REMOTE_EP = 0,
	ACPI_DEVICE_SWNODE_EP_BUS_TYPE = 1,
	ACPI_DEVICE_SWNODE_EP_REG = 2,
	ACPI_DEVICE_SWNODE_EP_CLOCK_LANES = 3,
	ACPI_DEVICE_SWNODE_EP_DATA_LANES = 4,
	ACPI_DEVICE_SWNODE_EP_LANE_POLARITIES = 5,
	ACPI_DEVICE_SWNODE_EP_LINK_FREQUENCIES = 6,
	ACPI_DEVICE_SWNODE_EP_NUM_OF = 7,
	ACPI_DEVICE_SWNODE_EP_NUM_ENTRIES = 8,
};

enum acpi_device_swnode_port_props {
	ACPI_DEVICE_SWNODE_PORT_REG = 0,
	ACPI_DEVICE_SWNODE_PORT_NUM_OF = 1,
	ACPI_DEVICE_SWNODE_PORT_NUM_ENTRIES = 2,
};

enum acpi_dmar_scope_type {
	ACPI_DMAR_SCOPE_TYPE_NOT_USED = 0,
	ACPI_DMAR_SCOPE_TYPE_ENDPOINT = 1,
	ACPI_DMAR_SCOPE_TYPE_BRIDGE = 2,
	ACPI_DMAR_SCOPE_TYPE_IOAPIC = 3,
	ACPI_DMAR_SCOPE_TYPE_HPET = 4,
	ACPI_DMAR_SCOPE_TYPE_NAMESPACE = 5,
	ACPI_DMAR_SCOPE_TYPE_RESERVED = 6,
};

enum acpi_dmar_type {
	ACPI_DMAR_TYPE_HARDWARE_UNIT = 0,
	ACPI_DMAR_TYPE_RESERVED_MEMORY = 1,
	ACPI_DMAR_TYPE_ROOT_ATS = 2,
	ACPI_DMAR_TYPE_HARDWARE_AFFINITY = 3,
	ACPI_DMAR_TYPE_NAMESPACE = 4,
	ACPI_DMAR_TYPE_SATC = 5,
	ACPI_DMAR_TYPE_SIDP = 6,
	ACPI_DMAR_TYPE_RESERVED = 7,
};

enum acpi_ec_event_state {
	EC_EVENT_READY = 0,
	EC_EVENT_IN_PROGRESS = 1,
	EC_EVENT_COMPLETE = 2,
};

enum acpi_erst_actions {
	ACPI_ERST_BEGIN_WRITE = 0,
	ACPI_ERST_BEGIN_READ = 1,
	ACPI_ERST_BEGIN_CLEAR = 2,
	ACPI_ERST_END = 3,
	ACPI_ERST_SET_RECORD_OFFSET = 4,
	ACPI_ERST_EXECUTE_OPERATION = 5,
	ACPI_ERST_CHECK_BUSY_STATUS = 6,
	ACPI_ERST_GET_COMMAND_STATUS = 7,
	ACPI_ERST_GET_RECORD_ID = 8,
	ACPI_ERST_SET_RECORD_ID = 9,
	ACPI_ERST_GET_RECORD_COUNT = 10,
	ACPI_ERST_BEGIN_DUMMY_WRIITE = 11,
	ACPI_ERST_NOT_USED = 12,
	ACPI_ERST_GET_ERROR_RANGE = 13,
	ACPI_ERST_GET_ERROR_LENGTH = 14,
	ACPI_ERST_GET_ERROR_ATTRIBUTES = 15,
	ACPI_ERST_EXECUTE_TIMINGS = 16,
	ACPI_ERST_ACTION_RESERVED = 17,
};

enum acpi_erst_instructions {
	ACPI_ERST_READ_REGISTER = 0,
	ACPI_ERST_READ_REGISTER_VALUE = 1,
	ACPI_ERST_WRITE_REGISTER = 2,
	ACPI_ERST_WRITE_REGISTER_VALUE = 3,
	ACPI_ERST_NOOP = 4,
	ACPI_ERST_LOAD_VAR1 = 5,
	ACPI_ERST_LOAD_VAR2 = 6,
	ACPI_ERST_STORE_VAR1 = 7,
	ACPI_ERST_ADD = 8,
	ACPI_ERST_SUBTRACT = 9,
	ACPI_ERST_ADD_VALUE = 10,
	ACPI_ERST_SUBTRACT_VALUE = 11,
	ACPI_ERST_STALL = 12,
	ACPI_ERST_STALL_WHILE_TRUE = 13,
	ACPI_ERST_SKIP_NEXT_IF_TRUE = 14,
	ACPI_ERST_GOTO = 15,
	ACPI_ERST_SET_SRC_ADDRESS_BASE = 16,
	ACPI_ERST_SET_DST_ADDRESS_BASE = 17,
	ACPI_ERST_MOVE_DATA = 18,
	ACPI_ERST_INSTRUCTION_RESERVED = 19,
};

enum acpi_gpio_ignore_list {
	ACPI_GPIO_IGNORE_WAKE = 0,
	ACPI_GPIO_IGNORE_INTERRUPT = 1,
};

enum acpi_hest_notify_types {
	ACPI_HEST_NOTIFY_POLLED = 0,
	ACPI_HEST_NOTIFY_EXTERNAL = 1,
	ACPI_HEST_NOTIFY_LOCAL = 2,
	ACPI_HEST_NOTIFY_SCI = 3,
	ACPI_HEST_NOTIFY_NMI = 4,
	ACPI_HEST_NOTIFY_CMCI = 5,
	ACPI_HEST_NOTIFY_MCE = 6,
	ACPI_HEST_NOTIFY_GPIO = 7,
	ACPI_HEST_NOTIFY_SEA = 8,
	ACPI_HEST_NOTIFY_SEI = 9,
	ACPI_HEST_NOTIFY_GSIV = 10,
	ACPI_HEST_NOTIFY_SOFTWARE_DELEGATED = 11,
	ACPI_HEST_NOTIFY_RESERVED = 12,
};

enum acpi_hest_types {
	ACPI_HEST_TYPE_IA32_CHECK = 0,
	ACPI_HEST_TYPE_IA32_CORRECTED_CHECK = 1,
	ACPI_HEST_TYPE_IA32_NMI = 2,
	ACPI_HEST_TYPE_NOT_USED3 = 3,
	ACPI_HEST_TYPE_NOT_USED4 = 4,
	ACPI_HEST_TYPE_NOT_USED5 = 5,
	ACPI_HEST_TYPE_AER_ROOT_PORT = 6,
	ACPI_HEST_TYPE_AER_ENDPOINT = 7,
	ACPI_HEST_TYPE_AER_BRIDGE = 8,
	ACPI_HEST_TYPE_GENERIC_ERROR = 9,
	ACPI_HEST_TYPE_GENERIC_ERROR_V2 = 10,
	ACPI_HEST_TYPE_IA32_DEFERRED_CHECK = 11,
	ACPI_HEST_TYPE_RESERVED = 12,
};

enum acpi_hmat_type {
	ACPI_HMAT_TYPE_PROXIMITY = 0,
	ACPI_HMAT_TYPE_LOCALITY = 1,
	ACPI_HMAT_TYPE_CACHE = 2,
	ACPI_HMAT_TYPE_RESERVED = 3,
};

enum acpi_irq_model_id {
	ACPI_IRQ_MODEL_PIC = 0,
	ACPI_IRQ_MODEL_IOAPIC = 1,
	ACPI_IRQ_MODEL_IOSAPIC = 2,
	ACPI_IRQ_MODEL_PLATFORM = 3,
	ACPI_IRQ_MODEL_GIC = 4,
	ACPI_IRQ_MODEL_LPIC = 5,
	ACPI_IRQ_MODEL_RINTC = 6,
	ACPI_IRQ_MODEL_COUNT = 7,
};

enum acpi_madt_multiproc_wakeup_version {
	ACPI_MADT_MP_WAKEUP_VERSION_NONE = 0,
	ACPI_MADT_MP_WAKEUP_VERSION_V1 = 1,
	ACPI_MADT_MP_WAKEUP_VERSION_RESERVED = 2,
};

enum acpi_madt_type {
	ACPI_MADT_TYPE_LOCAL_APIC = 0,
	ACPI_MADT_TYPE_IO_APIC = 1,
	ACPI_MADT_TYPE_INTERRUPT_OVERRIDE = 2,
	ACPI_MADT_TYPE_NMI_SOURCE = 3,
	ACPI_MADT_TYPE_LOCAL_APIC_NMI = 4,
	ACPI_MADT_TYPE_LOCAL_APIC_OVERRIDE = 5,
	ACPI_MADT_TYPE_IO_SAPIC = 6,
	ACPI_MADT_TYPE_LOCAL_SAPIC = 7,
	ACPI_MADT_TYPE_INTERRUPT_SOURCE = 8,
	ACPI_MADT_TYPE_LOCAL_X2APIC = 9,
	ACPI_MADT_TYPE_LOCAL_X2APIC_NMI = 10,
	ACPI_MADT_TYPE_GENERIC_INTERRUPT = 11,
	ACPI_MADT_TYPE_GENERIC_DISTRIBUTOR = 12,
	ACPI_MADT_TYPE_GENERIC_MSI_FRAME = 13,
	ACPI_MADT_TYPE_GENERIC_REDISTRIBUTOR = 14,
	ACPI_MADT_TYPE_GENERIC_TRANSLATOR = 15,
	ACPI_MADT_TYPE_MULTIPROC_WAKEUP = 16,
	ACPI_MADT_TYPE_CORE_PIC = 17,
	ACPI_MADT_TYPE_LIO_PIC = 18,
	ACPI_MADT_TYPE_HT_PIC = 19,
	ACPI_MADT_TYPE_EIO_PIC = 20,
	ACPI_MADT_TYPE_MSI_PIC = 21,
	ACPI_MADT_TYPE_BIO_PIC = 22,
	ACPI_MADT_TYPE_LPC_PIC = 23,
	ACPI_MADT_TYPE_RINTC = 24,
	ACPI_MADT_TYPE_IMSIC = 25,
	ACPI_MADT_TYPE_APLIC = 26,
	ACPI_MADT_TYPE_PLIC = 27,
	ACPI_MADT_TYPE_RESERVED = 28,
	ACPI_MADT_TYPE_OEM_RESERVED = 128,
};

enum acpi_pcct_type {
	ACPI_PCCT_TYPE_GENERIC_SUBSPACE = 0,
	ACPI_PCCT_TYPE_HW_REDUCED_SUBSPACE = 1,
	ACPI_PCCT_TYPE_HW_REDUCED_SUBSPACE_TYPE2 = 2,
	ACPI_PCCT_TYPE_EXT_PCC_MASTER_SUBSPACE = 3,
	ACPI_PCCT_TYPE_EXT_PCC_SLAVE_SUBSPACE = 4,
	ACPI_PCCT_TYPE_HW_REG_COMM_SUBSPACE = 5,
	ACPI_PCCT_TYPE_RESERVED = 6,
};

enum acpi_predicate {
	all_versions = 0,
	less_than_or_equal = 1,
	equal = 2,
	greater_than_or_equal = 3,
};

enum acpi_preferred_pm_profiles {
	PM_UNSPECIFIED = 0,
	PM_DESKTOP = 1,
	PM_MOBILE = 2,
	PM_WORKSTATION = 3,
	PM_ENTERPRISE_SERVER = 4,
	PM_SOHO_SERVER = 5,
	PM_APPLIANCE_PC = 6,
	PM_PERFORMANCE_SERVER = 7,
	PM_TABLET = 8,
	NR_PM_PROFILES = 9,
};

enum acpi_reconfig_event {
	ACPI_RECONFIG_DEVICE_ADD = 0,
	ACPI_RECONFIG_DEVICE_REMOVE = 1,
};

enum acpi_return_package_types {
	ACPI_PTYPE1_FIXED = 1,
	ACPI_PTYPE1_VAR = 2,
	ACPI_PTYPE1_OPTION = 3,
	ACPI_PTYPE2 = 4,
	ACPI_PTYPE2_COUNT = 5,
	ACPI_PTYPE2_PKG_COUNT = 6,
	ACPI_PTYPE2_FIXED = 7,
	ACPI_PTYPE2_MIN = 8,
	ACPI_PTYPE2_REV_FIXED = 9,
	ACPI_PTYPE2_FIX_VAR = 10,
	ACPI_PTYPE2_VAR_VAR = 11,
	ACPI_PTYPE2_UUID_PAIR = 12,
	ACPI_PTYPE_CUSTOM = 13,
};

enum acpi_srat_type {
	ACPI_SRAT_TYPE_CPU_AFFINITY = 0,
	ACPI_SRAT_TYPE_MEMORY_AFFINITY = 1,
	ACPI_SRAT_TYPE_X2APIC_CPU_AFFINITY = 2,
	ACPI_SRAT_TYPE_GICC_AFFINITY = 3,
	ACPI_SRAT_TYPE_GIC_ITS_AFFINITY = 4,
	ACPI_SRAT_TYPE_GENERIC_AFFINITY = 5,
	ACPI_SRAT_TYPE_GENERIC_PORT_AFFINITY = 6,
	ACPI_SRAT_TYPE_RINTC_AFFINITY = 7,
	ACPI_SRAT_TYPE_RESERVED = 8,
};

enum acpi_subtable_type {
	ACPI_SUBTABLE_COMMON = 0,
	ACPI_SUBTABLE_HMAT = 1,
	ACPI_SUBTABLE_PRMT = 2,
	ACPI_SUBTABLE_CEDT = 3,
	CDAT_SUBTABLE = 4,
};

enum acpi_viot_node_type {
	ACPI_VIOT_NODE_PCI_RANGE = 1,
	ACPI_VIOT_NODE_MMIO = 2,
	ACPI_VIOT_NODE_VIRTIO_IOMMU_PCI = 3,
	ACPI_VIOT_NODE_VIRTIO_IOMMU_MMIO = 4,
	ACPI_VIOT_RESERVED = 5,
};

enum action_id {
	ACTION_SAVE = 1,
	ACTION_TRACE = 2,
	ACTION_SNAPSHOT = 3,
};

enum actions {
	REGISTER = 0,
	DEREGISTER = 1,
	CPU_DONT_CARE = 2,
};

enum addr_stride {
	PTE_STRIDE = 0,
	PMD_STRIDE = 1,
};

enum addr_type_t {
	UNICAST_ADDR = 0,
	MULTICAST_ADDR = 1,
	ANYCAST_ADDR = 2,
};

enum address_markers_idx {
	USER_SPACE_NR = 0,
	KERNEL_SPACE_NR = 1,
	LDT_NR = 2,
	LOW_KERNEL_NR = 3,
	VMALLOC_START_NR = 4,
	VMEMMAP_START_NR = 5,
	CPU_ENTRY_AREA_NR = 6,
	ESPFIX_START_NR = 7,
	EFI_END_NR = 8,
	HIGH_KERNEL_NR = 9,
	MODULES_VADDR_NR = 10,
	MODULES_END_NR = 11,
	FIXADDR_START_NR = 12,
	END_OF_SPACE_NR = 13,
};

enum aead_algo {
	SNP_AEAD_INVALID = 0,
	SNP_AEAD_AES_256_GCM = 1,
};

enum alarmtimer_type {
	ALARM_REALTIME = 0,
	ALARM_BOOTTIME = 1,
	ALARM_NUMTYPE = 2,
	ALARM_REALTIME_FREEZER = 3,
	ALARM_BOOTTIME_FREEZER = 4,
};

enum align_flags {
	ALIGN_VA_32 = 1,
	ALIGN_VA_64 = 2,
};

enum allow_write_msrs {
	MSR_WRITES_ON = 0,
	MSR_WRITES_OFF = 1,
	MSR_WRITES_DEFAULT = 2,
};

enum amd_chipset_gen {
	NOT_AMD_CHIPSET = 0,
	AMD_CHIPSET_SB600 = 1,
	AMD_CHIPSET_SB700 = 2,
	AMD_CHIPSET_SB800 = 3,
	AMD_CHIPSET_HUDSON2 = 4,
	AMD_CHIPSET_BOLTON = 5,
	AMD_CHIPSET_YANGTZE = 6,
	AMD_CHIPSET_TAISHAN = 7,
	AMD_CHIPSET_UNKNOWN = 8,
};

enum amd_functions {
	IMX_F0_GPIO0 = 0,
	IMX_F1_GPIO0 = 1,
	IMX_F2_GPIO0 = 2,
	IMX_F3_GPIO0 = 3,
	IMX_F0_GPIO1 = 4,
	IMX_F1_GPIO1 = 5,
	IMX_F2_GPIO1 = 6,
	IMX_F3_GPIO1 = 7,
	IMX_F0_GPIO2 = 8,
	IMX_F1_GPIO2 = 9,
	IMX_F2_GPIO2 = 10,
	IMX_F3_GPIO2 = 11,
	IMX_F0_GPIO3 = 12,
	IMX_F1_GPIO3 = 13,
	IMX_F2_GPIO3 = 14,
	IMX_F3_GPIO3 = 15,
	IMX_F0_GPIO4 = 16,
	IMX_F1_GPIO4 = 17,
	IMX_F2_GPIO4 = 18,
	IMX_F3_GPIO4 = 19,
	IMX_F0_GPIO5 = 20,
	IMX_F1_GPIO5 = 21,
	IMX_F2_GPIO5 = 22,
	IMX_F3_GPIO5 = 23,
	IMX_F0_GPIO6 = 24,
	IMX_F1_GPIO6 = 25,
	IMX_F2_GPIO6 = 26,
	IMX_F3_GPIO6 = 27,
	IMX_F0_GPIO7 = 28,
	IMX_F1_GPIO7 = 29,
	IMX_F2_GPIO7 = 30,
	IMX_F3_GPIO7 = 31,
	IMX_F0_GPIO8 = 32,
	IMX_F1_GPIO8 = 33,
	IMX_F2_GPIO8 = 34,
	IMX_F3_GPIO8 = 35,
	IMX_F0_GPIO9 = 36,
	IMX_F1_GPIO9 = 37,
	IMX_F2_GPIO9 = 38,
	IMX_F3_GPIO9 = 39,
	IMX_F0_GPIO10 = 40,
	IMX_F1_GPIO10 = 41,
	IMX_F2_GPIO10 = 42,
	IMX_F3_GPIO10 = 43,
	IMX_F0_GPIO11 = 44,
	IMX_F1_GPIO11 = 45,
	IMX_F2_GPIO11 = 46,
	IMX_F3_GPIO11 = 47,
	IMX_F0_GPIO12 = 48,
	IMX_F1_GPIO12 = 49,
	IMX_F2_GPIO12 = 50,
	IMX_F3_GPIO12 = 51,
	IMX_F0_GPIO13 = 52,
	IMX_F1_GPIO13 = 53,
	IMX_F2_GPIO13 = 54,
	IMX_F3_GPIO13 = 55,
	IMX_F0_GPIO14 = 56,
	IMX_F1_GPIO14 = 57,
	IMX_F2_GPIO14 = 58,
	IMX_F3_GPIO14 = 59,
	IMX_F0_GPIO15 = 60,
	IMX_F1_GPIO15 = 61,
	IMX_F2_GPIO15 = 62,
	IMX_F3_GPIO15 = 63,
	IMX_F0_GPIO16 = 64,
	IMX_F1_GPIO16 = 65,
	IMX_F2_GPIO16 = 66,
	IMX_F3_GPIO16 = 67,
	IMX_F0_GPIO17 = 68,
	IMX_F1_GPIO17 = 69,
	IMX_F2_GPIO17 = 70,
	IMX_F3_GPIO17 = 71,
	IMX_F0_GPIO18 = 72,
	IMX_F1_GPIO18 = 73,
	IMX_F2_GPIO18 = 74,
	IMX_F3_GPIO18 = 75,
	IMX_F0_GPIO19 = 76,
	IMX_F1_GPIO19 = 77,
	IMX_F2_GPIO19 = 78,
	IMX_F3_GPIO19 = 79,
	IMX_F0_GPIO20 = 80,
	IMX_F1_GPIO20 = 81,
	IMX_F2_GPIO20 = 82,
	IMX_F3_GPIO20 = 83,
	IMX_F0_GPIO21 = 84,
	IMX_F1_GPIO21 = 85,
	IMX_F2_GPIO21 = 86,
	IMX_F3_GPIO21 = 87,
	IMX_F0_GPIO22 = 88,
	IMX_F1_GPIO22 = 89,
	IMX_F2_GPIO22 = 90,
	IMX_F3_GPIO22 = 91,
	IMX_F0_GPIO23 = 92,
	IMX_F1_GPIO23 = 93,
	IMX_F2_GPIO23 = 94,
	IMX_F3_GPIO23 = 95,
	IMX_F0_GPIO24 = 96,
	IMX_F1_GPIO24 = 97,
	IMX_F2_GPIO24 = 98,
	IMX_F3_GPIO24 = 99,
	IMX_F0_GPIO25 = 100,
	IMX_F1_GPIO25 = 101,
	IMX_F2_GPIO25 = 102,
	IMX_F3_GPIO25 = 103,
	IMX_F0_GPIO26 = 104,
	IMX_F1_GPIO26 = 105,
	IMX_F2_GPIO26 = 106,
	IMX_F3_GPIO26 = 107,
	IMX_F0_GPIO27 = 108,
	IMX_F1_GPIO27 = 109,
	IMX_F2_GPIO27 = 110,
	IMX_F3_GPIO27 = 111,
	IMX_F0_GPIO28 = 112,
	IMX_F1_GPIO28 = 113,
	IMX_F2_GPIO28 = 114,
	IMX_F3_GPIO28 = 115,
	IMX_F0_GPIO29 = 116,
	IMX_F1_GPIO29 = 117,
	IMX_F2_GPIO29 = 118,
	IMX_F3_GPIO29 = 119,
	IMX_F0_GPIO30 = 120,
	IMX_F1_GPIO30 = 121,
	IMX_F2_GPIO30 = 122,
	IMX_F3_GPIO30 = 123,
	IMX_F0_GPIO31 = 124,
	IMX_F1_GPIO31 = 125,
	IMX_F2_GPIO31 = 126,
	IMX_F3_GPIO31 = 127,
	IMX_F0_GPIO32 = 128,
	IMX_F1_GPIO32 = 129,
	IMX_F2_GPIO32 = 130,
	IMX_F3_GPIO32 = 131,
	IMX_F0_GPIO33 = 132,
	IMX_F1_GPIO33 = 133,
	IMX_F2_GPIO33 = 134,
	IMX_F3_GPIO33 = 135,
	IMX_F0_GPIO34 = 136,
	IMX_F1_GPIO34 = 137,
	IMX_F2_GPIO34 = 138,
	IMX_F3_GPIO34 = 139,
	IMX_F0_GPIO35 = 140,
	IMX_F1_GPIO35 = 141,
	IMX_F2_GPIO35 = 142,
	IMX_F3_GPIO35 = 143,
	IMX_F0_GPIO36 = 144,
	IMX_F1_GPIO36 = 145,
	IMX_F2_GPIO36 = 146,
	IMX_F3_GPIO36 = 147,
	IMX_F0_GPIO37 = 148,
	IMX_F1_GPIO37 = 149,
	IMX_F2_GPIO37 = 150,
	IMX_F3_GPIO37 = 151,
	IMX_F0_GPIO38 = 152,
	IMX_F1_GPIO38 = 153,
	IMX_F2_GPIO38 = 154,
	IMX_F3_GPIO38 = 155,
	IMX_F0_GPIO39 = 156,
	IMX_F1_GPIO39 = 157,
	IMX_F2_GPIO39 = 158,
	IMX_F3_GPIO39 = 159,
	IMX_F0_GPIO40 = 160,
	IMX_F1_GPIO40 = 161,
	IMX_F2_GPIO40 = 162,
	IMX_F3_GPIO40 = 163,
	IMX_F0_GPIO41 = 164,
	IMX_F1_GPIO41 = 165,
	IMX_F2_GPIO41 = 166,
	IMX_F3_GPIO41 = 167,
	IMX_F0_GPIO42 = 168,
	IMX_F1_GPIO42 = 169,
	IMX_F2_GPIO42 = 170,
	IMX_F3_GPIO42 = 171,
	IMX_F0_GPIO43 = 172,
	IMX_F1_GPIO43 = 173,
	IMX_F2_GPIO43 = 174,
	IMX_F3_GPIO43 = 175,
	IMX_F0_GPIO44 = 176,
	IMX_F1_GPIO44 = 177,
	IMX_F2_GPIO44 = 178,
	IMX_F3_GPIO44 = 179,
	IMX_F0_GPIO45 = 180,
	IMX_F1_GPIO45 = 181,
	IMX_F2_GPIO45 = 182,
	IMX_F3_GPIO45 = 183,
	IMX_F0_GPIO46 = 184,
	IMX_F1_GPIO46 = 185,
	IMX_F2_GPIO46 = 186,
	IMX_F3_GPIO46 = 187,
	IMX_F0_GPIO47 = 188,
	IMX_F1_GPIO47 = 189,
	IMX_F2_GPIO47 = 190,
	IMX_F3_GPIO47 = 191,
	IMX_F0_GPIO48 = 192,
	IMX_F1_GPIO48 = 193,
	IMX_F2_GPIO48 = 194,
	IMX_F3_GPIO48 = 195,
	IMX_F0_GPIO49 = 196,
	IMX_F1_GPIO49 = 197,
	IMX_F2_GPIO49 = 198,
	IMX_F3_GPIO49 = 199,
	IMX_F0_GPIO50 = 200,
	IMX_F1_GPIO50 = 201,
	IMX_F2_GPIO50 = 202,
	IMX_F3_GPIO50 = 203,
	IMX_F0_GPIO51 = 204,
	IMX_F1_GPIO51 = 205,
	IMX_F2_GPIO51 = 206,
	IMX_F3_GPIO51 = 207,
	IMX_F0_GPIO52 = 208,
	IMX_F1_GPIO52 = 209,
	IMX_F2_GPIO52 = 210,
	IMX_F3_GPIO52 = 211,
	IMX_F0_GPIO53 = 212,
	IMX_F1_GPIO53 = 213,
	IMX_F2_GPIO53 = 214,
	IMX_F3_GPIO53 = 215,
	IMX_F0_GPIO54 = 216,
	IMX_F1_GPIO54 = 217,
	IMX_F2_GPIO54 = 218,
	IMX_F3_GPIO54 = 219,
	IMX_F0_GPIO55 = 220,
	IMX_F1_GPIO55 = 221,
	IMX_F2_GPIO55 = 222,
	IMX_F3_GPIO55 = 223,
	IMX_F0_GPIO56 = 224,
	IMX_F1_GPIO56 = 225,
	IMX_F2_GPIO56 = 226,
	IMX_F3_GPIO56 = 227,
	IMX_F0_GPIO57 = 228,
	IMX_F1_GPIO57 = 229,
	IMX_F2_GPIO57 = 230,
	IMX_F3_GPIO57 = 231,
	IMX_F0_GPIO58 = 232,
	IMX_F1_GPIO58 = 233,
	IMX_F2_GPIO58 = 234,
	IMX_F3_GPIO58 = 235,
	IMX_F0_GPIO59 = 236,
	IMX_F1_GPIO59 = 237,
	IMX_F2_GPIO59 = 238,
	IMX_F3_GPIO59 = 239,
	IMX_F0_GPIO60 = 240,
	IMX_F1_GPIO60 = 241,
	IMX_F2_GPIO60 = 242,
	IMX_F3_GPIO60 = 243,
	IMX_F0_GPIO61 = 244,
	IMX_F1_GPIO61 = 245,
	IMX_F2_GPIO61 = 246,
	IMX_F3_GPIO61 = 247,
	IMX_F0_GPIO62 = 248,
	IMX_F1_GPIO62 = 249,
	IMX_F2_GPIO62 = 250,
	IMX_F3_GPIO62 = 251,
	IMX_F0_GPIO64 = 252,
	IMX_F1_GPIO64 = 253,
	IMX_F2_GPIO64 = 254,
	IMX_F3_GPIO64 = 255,
	IMX_F0_GPIO65 = 256,
	IMX_F1_GPIO65 = 257,
	IMX_F2_GPIO65 = 258,
	IMX_F3_GPIO65 = 259,
	IMX_F0_GPIO66 = 260,
	IMX_F1_GPIO66 = 261,
	IMX_F2_GPIO66 = 262,
	IMX_F3_GPIO66 = 263,
	IMX_F0_GPIO67 = 264,
	IMX_F1_GPIO67 = 265,
	IMX_F2_GPIO67 = 266,
	IMX_F3_GPIO67 = 267,
	IMX_F0_GPIO68 = 268,
	IMX_F1_GPIO68 = 269,
	IMX_F2_GPIO68 = 270,
	IMX_F3_GPIO68 = 271,
	IMX_F0_GPIO69 = 272,
	IMX_F1_GPIO69 = 273,
	IMX_F2_GPIO69 = 274,
	IMX_F3_GPIO69 = 275,
	IMX_F0_GPIO70 = 276,
	IMX_F1_GPIO70 = 277,
	IMX_F2_GPIO70 = 278,
	IMX_F3_GPIO70 = 279,
	IMX_F0_GPIO71 = 280,
	IMX_F1_GPIO71 = 281,
	IMX_F2_GPIO71 = 282,
	IMX_F3_GPIO71 = 283,
	IMX_F0_GPIO72 = 284,
	IMX_F1_GPIO72 = 285,
	IMX_F2_GPIO72 = 286,
	IMX_F3_GPIO72 = 287,
	IMX_F0_GPIO73 = 288,
	IMX_F1_GPIO73 = 289,
	IMX_F2_GPIO73 = 290,
	IMX_F3_GPIO73 = 291,
	IMX_F0_GPIO74 = 292,
	IMX_F1_GPIO74 = 293,
	IMX_F2_GPIO74 = 294,
	IMX_F3_GPIO74 = 295,
	IMX_F0_GPIO75 = 296,
	IMX_F1_GPIO75 = 297,
	IMX_F2_GPIO75 = 298,
	IMX_F3_GPIO75 = 299,
	IMX_F0_GPIO76 = 300,
	IMX_F1_GPIO76 = 301,
	IMX_F2_GPIO76 = 302,
	IMX_F3_GPIO76 = 303,
	IMX_F0_GPIO77 = 304,
	IMX_F1_GPIO77 = 305,
	IMX_F2_GPIO77 = 306,
	IMX_F3_GPIO77 = 307,
	IMX_F0_GPIO78 = 308,
	IMX_F1_GPIO78 = 309,
	IMX_F2_GPIO78 = 310,
	IMX_F3_GPIO78 = 311,
	IMX_F0_GPIO79 = 312,
	IMX_F1_GPIO79 = 313,
	IMX_F2_GPIO79 = 314,
	IMX_F3_GPIO79 = 315,
	IMX_F0_GPIO80 = 316,
	IMX_F1_GPIO80 = 317,
	IMX_F2_GPIO80 = 318,
	IMX_F3_GPIO80 = 319,
	IMX_F0_GPIO81 = 320,
	IMX_F1_GPIO81 = 321,
	IMX_F2_GPIO81 = 322,
	IMX_F3_GPIO81 = 323,
	IMX_F0_GPIO82 = 324,
	IMX_F1_GPIO82 = 325,
	IMX_F2_GPIO82 = 326,
	IMX_F3_GPIO82 = 327,
	IMX_F0_GPIO83 = 328,
	IMX_F1_GPIO83 = 329,
	IMX_F2_GPIO83 = 330,
	IMX_F3_GPIO83 = 331,
	IMX_F0_GPIO84 = 332,
	IMX_F1_GPIO84 = 333,
	IMX_F2_GPIO84 = 334,
	IMX_F3_GPIO84 = 335,
	IMX_F0_GPIO85 = 336,
	IMX_F1_GPIO85 = 337,
	IMX_F2_GPIO85 = 338,
	IMX_F3_GPIO85 = 339,
	IMX_F0_GPIO86 = 340,
	IMX_F1_GPIO86 = 341,
	IMX_F2_GPIO86 = 342,
	IMX_F3_GPIO86 = 343,
	IMX_F0_GPIO87 = 344,
	IMX_F1_GPIO87 = 345,
	IMX_F2_GPIO87 = 346,
	IMX_F3_GPIO87 = 347,
	IMX_F0_GPIO88 = 348,
	IMX_F1_GPIO88 = 349,
	IMX_F2_GPIO88 = 350,
	IMX_F3_GPIO88 = 351,
	IMX_F0_GPIO89 = 352,
	IMX_F1_GPIO89 = 353,
	IMX_F2_GPIO89 = 354,
	IMX_F3_GPIO89 = 355,
	IMX_F0_GPIO90 = 356,
	IMX_F1_GPIO90 = 357,
	IMX_F2_GPIO90 = 358,
	IMX_F3_GPIO90 = 359,
	IMX_F0_GPIO91 = 360,
	IMX_F1_GPIO91 = 361,
	IMX_F2_GPIO91 = 362,
	IMX_F3_GPIO91 = 363,
	IMX_F0_GPIO92 = 364,
	IMX_F1_GPIO92 = 365,
	IMX_F2_GPIO92 = 366,
	IMX_F3_GPIO92 = 367,
	IMX_F0_GPIO93 = 368,
	IMX_F1_GPIO93 = 369,
	IMX_F2_GPIO93 = 370,
	IMX_F3_GPIO93 = 371,
	IMX_F0_GPIO94 = 372,
	IMX_F1_GPIO94 = 373,
	IMX_F2_GPIO94 = 374,
	IMX_F3_GPIO94 = 375,
	IMX_F0_GPIO95 = 376,
	IMX_F1_GPIO95 = 377,
	IMX_F2_GPIO95 = 378,
	IMX_F3_GPIO95 = 379,
	IMX_F0_GPIO96 = 380,
	IMX_F1_GPIO96 = 381,
	IMX_F2_GPIO96 = 382,
	IMX_F3_GPIO96 = 383,
	IMX_F0_GPIO97 = 384,
	IMX_F1_GPIO97 = 385,
	IMX_F2_GPIO97 = 386,
	IMX_F3_GPIO97 = 387,
	IMX_F0_GPIO98 = 388,
	IMX_F1_GPIO98 = 389,
	IMX_F2_GPIO98 = 390,
	IMX_F3_GPIO98 = 391,
	IMX_F0_GPIO99 = 392,
	IMX_F1_GPIO99 = 393,
	IMX_F2_GPIO99 = 394,
	IMX_F3_GPIO99 = 395,
	IMX_F0_GPIO100 = 396,
	IMX_F1_GPIO100 = 397,
	IMX_F2_GPIO100 = 398,
	IMX_F3_GPIO100 = 399,
	IMX_F0_GPIO101 = 400,
	IMX_F1_GPIO101 = 401,
	IMX_F2_GPIO101 = 402,
	IMX_F3_GPIO101 = 403,
	IMX_F0_GPIO102 = 404,
	IMX_F1_GPIO102 = 405,
	IMX_F2_GPIO102 = 406,
	IMX_F3_GPIO102 = 407,
	IMX_F0_GPIO103 = 408,
	IMX_F1_GPIO103 = 409,
	IMX_F2_GPIO103 = 410,
	IMX_F3_GPIO103 = 411,
	IMX_F0_GPIO104 = 412,
	IMX_F1_GPIO104 = 413,
	IMX_F2_GPIO104 = 414,
	IMX_F3_GPIO104 = 415,
	IMX_F0_GPIO105 = 416,
	IMX_F1_GPIO105 = 417,
	IMX_F2_GPIO105 = 418,
	IMX_F3_GPIO105 = 419,
	IMX_F0_GPIO106 = 420,
	IMX_F1_GPIO106 = 421,
	IMX_F2_GPIO106 = 422,
	IMX_F3_GPIO106 = 423,
	IMX_F0_GPIO107 = 424,
	IMX_F1_GPIO107 = 425,
	IMX_F2_GPIO107 = 426,
	IMX_F3_GPIO107 = 427,
	IMX_F0_GPIO108 = 428,
	IMX_F1_GPIO108 = 429,
	IMX_F2_GPIO108 = 430,
	IMX_F3_GPIO108 = 431,
	IMX_F0_GPIO109 = 432,
	IMX_F1_GPIO109 = 433,
	IMX_F2_GPIO109 = 434,
	IMX_F3_GPIO109 = 435,
	IMX_F0_GPIO110 = 436,
	IMX_F1_GPIO110 = 437,
	IMX_F2_GPIO110 = 438,
	IMX_F3_GPIO110 = 439,
	IMX_F0_GPIO111 = 440,
	IMX_F1_GPIO111 = 441,
	IMX_F2_GPIO111 = 442,
	IMX_F3_GPIO111 = 443,
	IMX_F0_GPIO112 = 444,
	IMX_F1_GPIO112 = 445,
	IMX_F2_GPIO112 = 446,
	IMX_F3_GPIO112 = 447,
	IMX_F0_GPIO113 = 448,
	IMX_F1_GPIO113 = 449,
	IMX_F2_GPIO113 = 450,
	IMX_F3_GPIO113 = 451,
	IMX_F0_GPIO114 = 452,
	IMX_F1_GPIO114 = 453,
	IMX_F2_GPIO114 = 454,
	IMX_F3_GPIO114 = 455,
	IMX_F0_GPIO115 = 456,
	IMX_F1_GPIO115 = 457,
	IMX_F2_GPIO115 = 458,
	IMX_F3_GPIO115 = 459,
	IMX_F0_GPIO116 = 460,
	IMX_F1_GPIO116 = 461,
	IMX_F2_GPIO116 = 462,
	IMX_F3_GPIO116 = 463,
	IMX_F0_GPIO117 = 464,
	IMX_F1_GPIO117 = 465,
	IMX_F2_GPIO117 = 466,
	IMX_F3_GPIO117 = 467,
	IMX_F0_GPIO118 = 468,
	IMX_F1_GPIO118 = 469,
	IMX_F2_GPIO118 = 470,
	IMX_F3_GPIO118 = 471,
	IMX_F0_GPIO119 = 472,
	IMX_F1_GPIO119 = 473,
	IMX_F2_GPIO119 = 474,
	IMX_F3_GPIO119 = 475,
	IMX_F0_GPIO120 = 476,
	IMX_F1_GPIO120 = 477,
	IMX_F2_GPIO120 = 478,
	IMX_F3_GPIO120 = 479,
	IMX_F0_GPIO121 = 480,
	IMX_F1_GPIO121 = 481,
	IMX_F2_GPIO121 = 482,
	IMX_F3_GPIO121 = 483,
	IMX_F0_GPIO122 = 484,
	IMX_F1_GPIO122 = 485,
	IMX_F2_GPIO122 = 486,
	IMX_F3_GPIO122 = 487,
	IMX_F0_GPIO123 = 488,
	IMX_F1_GPIO123 = 489,
	IMX_F2_GPIO123 = 490,
	IMX_F3_GPIO123 = 491,
	IMX_F0_GPIO124 = 492,
	IMX_F1_GPIO124 = 493,
	IMX_F2_GPIO124 = 494,
	IMX_F3_GPIO124 = 495,
	IMX_F0_GPIO125 = 496,
	IMX_F1_GPIO125 = 497,
	IMX_F2_GPIO125 = 498,
	IMX_F3_GPIO125 = 499,
	IMX_F0_GPIO126 = 500,
	IMX_F1_GPIO126 = 501,
	IMX_F2_GPIO126 = 502,
	IMX_F3_GPIO126 = 503,
	IMX_F0_GPIO127 = 504,
	IMX_F1_GPIO127 = 505,
	IMX_F2_GPIO127 = 506,
	IMX_F3_GPIO127 = 507,
	IMX_F0_GPIO128 = 508,
	IMX_F1_GPIO128 = 509,
	IMX_F2_GPIO128 = 510,
	IMX_F3_GPIO128 = 511,
	IMX_F0_GPIO129 = 512,
	IMX_F1_GPIO129 = 513,
	IMX_F2_GPIO129 = 514,
	IMX_F3_GPIO129 = 515,
	IMX_F0_GPIO130 = 516,
	IMX_F1_GPIO130 = 517,
	IMX_F2_GPIO130 = 518,
	IMX_F3_GPIO130 = 519,
	IMX_F0_GPIO131 = 520,
	IMX_F1_GPIO131 = 521,
	IMX_F2_GPIO131 = 522,
	IMX_F3_GPIO131 = 523,
	IMX_F0_GPIO132 = 524,
	IMX_F1_GPIO132 = 525,
	IMX_F2_GPIO132 = 526,
	IMX_F3_GPIO132 = 527,
	IMX_F0_GPIO133 = 528,
	IMX_F1_GPIO133 = 529,
	IMX_F2_GPIO133 = 530,
	IMX_F3_GPIO133 = 531,
	IMX_F0_GPIO134 = 532,
	IMX_F1_GPIO134 = 533,
	IMX_F2_GPIO134 = 534,
	IMX_F3_GPIO134 = 535,
	IMX_F0_GPIO135 = 536,
	IMX_F1_GPIO135 = 537,
	IMX_F2_GPIO135 = 538,
	IMX_F3_GPIO135 = 539,
	IMX_F0_GPIO136 = 540,
	IMX_F1_GPIO136 = 541,
	IMX_F2_GPIO136 = 542,
	IMX_F3_GPIO136 = 543,
	IMX_F0_GPIO137 = 544,
	IMX_F1_GPIO137 = 545,
	IMX_F2_GPIO137 = 546,
	IMX_F3_GPIO137 = 547,
	IMX_F0_GPIO138 = 548,
	IMX_F1_GPIO138 = 549,
	IMX_F2_GPIO138 = 550,
	IMX_F3_GPIO138 = 551,
	IMX_F0_GPIO139 = 552,
	IMX_F1_GPIO139 = 553,
	IMX_F2_GPIO139 = 554,
	IMX_F3_GPIO139 = 555,
	IMX_F0_GPIO140 = 556,
	IMX_F1_GPIO140 = 557,
	IMX_F2_GPIO140 = 558,
	IMX_F3_GPIO140 = 559,
	IMX_F0_GPIO141 = 560,
	IMX_F1_GPIO141 = 561,
	IMX_F2_GPIO141 = 562,
	IMX_F3_GPIO141 = 563,
	IMX_F0_GPIO142 = 564,
	IMX_F1_GPIO142 = 565,
	IMX_F2_GPIO142 = 566,
	IMX_F3_GPIO142 = 567,
	IMX_F0_GPIO143 = 568,
	IMX_F1_GPIO143 = 569,
	IMX_F2_GPIO143 = 570,
	IMX_F3_GPIO143 = 571,
	IMX_F0_GPIO144 = 572,
	IMX_F1_GPIO144 = 573,
	IMX_F2_GPIO144 = 574,
	IMX_F3_GPIO144 = 575,
};

enum amd_iommu_intr_mode_type {
	AMD_IOMMU_GUEST_IR_LEGACY = 0,
	AMD_IOMMU_GUEST_IR_LEGACY_GA = 1,
	AMD_IOMMU_GUEST_IR_VAPIC = 2,
};

enum amd_pref_core {
	AMD_PREF_CORE_UNKNOWN = 0,
	AMD_PREF_CORE_SUPPORTED = 1,
	AMD_PREF_CORE_UNSUPPORTED = 2,
};

enum amd_pstate_mode {
	AMD_PSTATE_UNDEFINED = 0,
	AMD_PSTATE_DISABLE = 1,
	AMD_PSTATE_PASSIVE = 2,
	AMD_PSTATE_ACTIVE = 3,
	AMD_PSTATE_GUIDED = 4,
	AMD_PSTATE_MAX = 5,
};

enum aper_size_type {
	U8_APER_SIZE = 0,
	U16_APER_SIZE = 1,
	U32_APER_SIZE = 2,
	LVL2_APER_SIZE = 3,
	FIXED_APER_SIZE = 4,
};

enum apic_intr_mode_id {
	APIC_PIC = 0,
	APIC_VIRTUAL_WIRE = 1,
	APIC_VIRTUAL_WIRE_NO_CONFIG = 2,
	APIC_SYMMETRIC_IO = 3,
	APIC_SYMMETRIC_IO_NO_ROUTING = 4,
};

enum as3711_su2_fbprot {
	AS3711_SU2_LX_SD4 = 0,
	AS3711_SU2_GPIO2 = 1,
	AS3711_SU2_GPIO3 = 2,
	AS3711_SU2_GPIO4 = 3,
};

enum as3711_su2_feedback {
	AS3711_SU2_VOLTAGE = 0,
	AS3711_SU2_CURR1 = 1,
	AS3711_SU2_CURR2 = 2,
	AS3711_SU2_CURR3 = 3,
	AS3711_SU2_CURR_AUTO = 4,
};

enum asn1_class {
	ASN1_UNIV = 0,
	ASN1_APPL = 1,
	ASN1_CONT = 2,
	ASN1_PRIV = 3,
};

enum asn1_method {
	ASN1_PRIM = 0,
	ASN1_CONS = 1,
};

enum asn1_opcode {
	ASN1_OP_MATCH = 0,
	ASN1_OP_MATCH_OR_SKIP = 1,
	ASN1_OP_MATCH_ACT = 2,
	ASN1_OP_MATCH_ACT_OR_SKIP = 3,
	ASN1_OP_MATCH_JUMP = 4,
	ASN1_OP_MATCH_JUMP_OR_SKIP = 5,
	ASN1_OP_MATCH_ANY = 8,
	ASN1_OP_MATCH_ANY_OR_SKIP = 9,
	ASN1_OP_MATCH_ANY_ACT = 10,
	ASN1_OP_MATCH_ANY_ACT_OR_SKIP = 11,
	ASN1_OP_COND_MATCH_OR_SKIP = 17,
	ASN1_OP_COND_MATCH_ACT_OR_SKIP = 19,
	ASN1_OP_COND_MATCH_JUMP_OR_SKIP = 21,
	ASN1_OP_COND_MATCH_ANY = 24,
	ASN1_OP_COND_MATCH_ANY_OR_SKIP = 25,
	ASN1_OP_COND_MATCH_ANY_ACT = 26,
	ASN1_OP_COND_MATCH_ANY_ACT_OR_SKIP = 27,
	ASN1_OP_COND_FAIL = 28,
	ASN1_OP_COMPLETE = 29,
	ASN1_OP_ACT = 30,
	ASN1_OP_MAYBE_ACT = 31,
	ASN1_OP_END_SEQ = 32,
	ASN1_OP_END_SET = 33,
	ASN1_OP_END_SEQ_OF = 34,
	ASN1_OP_END_SET_OF = 35,
	ASN1_OP_END_SEQ_ACT = 36,
	ASN1_OP_END_SET_ACT = 37,
	ASN1_OP_END_SEQ_OF_ACT = 38,
	ASN1_OP_END_SET_OF_ACT = 39,
	ASN1_OP_RETURN = 40,
	ASN1_OP__NR = 41,
};

enum asn1_tag {
	ASN1_EOC = 0,
	ASN1_BOOL = 1,
	ASN1_INT = 2,
	ASN1_BTS = 3,
	ASN1_OTS = 4,
	ASN1_NULL = 5,
	ASN1_OID = 6,
	ASN1_ODE = 7,
	ASN1_EXT = 8,
	ASN1_REAL = 9,
	ASN1_ENUM = 10,
	ASN1_EPDV = 11,
	ASN1_UTF8STR = 12,
	ASN1_RELOID = 13,
	ASN1_SEQ = 16,
	ASN1_SET = 17,
	ASN1_NUMSTR = 18,
	ASN1_PRNSTR = 19,
	ASN1_TEXSTR = 20,
	ASN1_VIDSTR = 21,
	ASN1_IA5STR = 22,
	ASN1_UNITIM = 23,
	ASN1_GENTIM = 24,
	ASN1_GRASTR = 25,
	ASN1_VISSTR = 26,
	ASN1_GENSTR = 27,
	ASN1_UNISTR = 28,
	ASN1_CHRSTR = 29,
	ASN1_BMPSTR = 30,
	ASN1_LONG_TAG = 31,
};

enum assoc_array_walk_status {
	assoc_array_walk_tree_empty = 0,
	assoc_array_walk_found_terminal_node = 1,
	assoc_array_walk_found_wrong_shortcut = 2,
};

enum asymmetric_payload_bits {
	asym_crypto = 0,
	asym_subtype = 1,
	asym_key_ids = 2,
	asym_auth = 3,
};

enum ata_completion_errors {
	AC_ERR_OK = 0,
	AC_ERR_DEV = 1,
	AC_ERR_HSM = 2,
	AC_ERR_TIMEOUT = 4,
	AC_ERR_MEDIA = 8,
	AC_ERR_ATA_BUS = 16,
	AC_ERR_HOST_BUS = 32,
	AC_ERR_SYSTEM = 64,
	AC_ERR_INVALID = 128,
	AC_ERR_OTHER = 256,
	AC_ERR_NODEV_HINT = 512,
	AC_ERR_NCQ = 1024,
};

enum ata_dev_iter_mode {
	ATA_DITER_ENABLED = 0,
	ATA_DITER_ENABLED_REVERSE = 1,
	ATA_DITER_ALL = 2,
	ATA_DITER_ALL_REVERSE = 3,
};

enum ata_link_iter_mode {
	ATA_LITER_EDGE = 0,
	ATA_LITER_HOST_FIRST = 1,
	ATA_LITER_PMP_FIRST = 2,
};

enum ata_lpm_hints {
	ATA_LPM_EMPTY = 1,
	ATA_LPM_HIPM = 2,
	ATA_LPM_WAKE_ONLY = 4,
};

enum ata_lpm_policy {
	ATA_LPM_UNKNOWN = 0,
	ATA_LPM_MAX_POWER = 1,
	ATA_LPM_MED_POWER = 2,
	ATA_LPM_MED_POWER_WITH_DIPM = 3,
	ATA_LPM_MIN_POWER_WITH_PARTIAL = 4,
	ATA_LPM_MIN_POWER = 5,
};

enum ata_prot_flags {
	ATA_PROT_FLAG_PIO = 1,
	ATA_PROT_FLAG_DMA = 2,
	ATA_PROT_FLAG_NCQ = 4,
	ATA_PROT_FLAG_ATAPI = 8,
	ATA_PROT_UNKNOWN = 255,
	ATA_PROT_NODATA = 0,
	ATA_PROT_PIO = 1,
	ATA_PROT_DMA = 2,
	ATA_PROT_NCQ_NODATA = 4,
	ATA_PROT_NCQ = 6,
	ATAPI_PROT_NODATA = 8,
	ATAPI_PROT_PIO = 9,
	ATAPI_PROT_DMA = 10,
};

enum ata_quirks {
	__ATA_QUIRK_DIAGNOSTIC = 0,
	__ATA_QUIRK_NODMA = 1,
	__ATA_QUIRK_NONCQ = 2,
	__ATA_QUIRK_MAX_SEC_128 = 3,
	__ATA_QUIRK_BROKEN_HPA = 4,
	__ATA_QUIRK_DISABLE = 5,
	__ATA_QUIRK_HPA_SIZE = 6,
	__ATA_QUIRK_IVB = 7,
	__ATA_QUIRK_STUCK_ERR = 8,
	__ATA_QUIRK_BRIDGE_OK = 9,
	__ATA_QUIRK_ATAPI_MOD16_DMA = 10,
	__ATA_QUIRK_FIRMWARE_WARN = 11,
	__ATA_QUIRK_1_5_GBPS = 12,
	__ATA_QUIRK_NOSETXFER = 13,
	__ATA_QUIRK_BROKEN_FPDMA_AA = 14,
	__ATA_QUIRK_DUMP_ID = 15,
	__ATA_QUIRK_MAX_SEC_LBA48 = 16,
	__ATA_QUIRK_ATAPI_DMADIR = 17,
	__ATA_QUIRK_NO_NCQ_TRIM = 18,
	__ATA_QUIRK_NOLPM = 19,
	__ATA_QUIRK_WD_BROKEN_LPM = 20,
	__ATA_QUIRK_ZERO_AFTER_TRIM = 21,
	__ATA_QUIRK_NO_DMA_LOG = 22,
	__ATA_QUIRK_NOTRIM = 23,
	__ATA_QUIRK_MAX_SEC_1024 = 24,
	__ATA_QUIRK_MAX_TRIM_128M = 25,
	__ATA_QUIRK_NO_NCQ_ON_ATI = 26,
	__ATA_QUIRK_NO_LPM_ON_ATI = 27,
	__ATA_QUIRK_NO_ID_DEV_LOG = 28,
	__ATA_QUIRK_NO_LOG_DIR = 29,
	__ATA_QUIRK_NO_FUA = 30,
	__ATA_QUIRK_MAX = 31,
};

enum ata_xfer_mask {
	ATA_MASK_PIO = 127,
	ATA_MASK_MWDMA = 3968,
	ATA_MASK_UDMA = 1044480,
};

enum audit_mode {
	AUDIT_NORMAL = 0,
	AUDIT_QUIET_DENIED = 1,
	AUDIT_QUIET = 2,
	AUDIT_NOQUIET = 3,
	AUDIT_ALL = 4,
};

enum audit_nfcfgop {
	AUDIT_XT_OP_REGISTER = 0,
	AUDIT_XT_OP_REPLACE = 1,
	AUDIT_XT_OP_UNREGISTER = 2,
	AUDIT_NFT_OP_TABLE_REGISTER = 3,
	AUDIT_NFT_OP_TABLE_UNREGISTER = 4,
	AUDIT_NFT_OP_CHAIN_REGISTER = 5,
	AUDIT_NFT_OP_CHAIN_UNREGISTER = 6,
	AUDIT_NFT_OP_RULE_REGISTER = 7,
	AUDIT_NFT_OP_RULE_UNREGISTER = 8,
	AUDIT_NFT_OP_SET_REGISTER = 9,
	AUDIT_NFT_OP_SET_UNREGISTER = 10,
	AUDIT_NFT_OP_SETELEM_REGISTER = 11,
	AUDIT_NFT_OP_SETELEM_UNREGISTER = 12,
	AUDIT_NFT_OP_GEN_REGISTER = 13,
	AUDIT_NFT_OP_OBJ_REGISTER = 14,
	AUDIT_NFT_OP_OBJ_UNREGISTER = 15,
	AUDIT_NFT_OP_OBJ_RESET = 16,
	AUDIT_NFT_OP_FLOWTABLE_REGISTER = 17,
	AUDIT_NFT_OP_FLOWTABLE_UNREGISTER = 18,
	AUDIT_NFT_OP_SETELEM_RESET = 19,
	AUDIT_NFT_OP_RULE_RESET = 20,
	AUDIT_NFT_OP_INVALID = 21,
};

enum audit_nlgrps {
	AUDIT_NLGRP_NONE = 0,
	AUDIT_NLGRP_READLOG = 1,
	__AUDIT_NLGRP_MAX = 2,
};

enum audit_ntp_type {
	AUDIT_NTP_OFFSET = 0,
	AUDIT_NTP_FREQ = 1,
	AUDIT_NTP_STATUS = 2,
	AUDIT_NTP_TAI = 3,
	AUDIT_NTP_TICK = 4,
	AUDIT_NTP_ADJUST = 5,
	AUDIT_NTP_NVALS = 6,
};

enum audit_state {
	AUDIT_STATE_DISABLED = 0,
	AUDIT_STATE_BUILD = 1,
	AUDIT_STATE_RECORD = 2,
};

enum audit_type {
	AUDIT_APPARMOR_AUDIT = 0,
	AUDIT_APPARMOR_ALLOWED = 1,
	AUDIT_APPARMOR_DENIED = 2,
	AUDIT_APPARMOR_HINT = 3,
	AUDIT_APPARMOR_STATUS = 4,
	AUDIT_APPARMOR_ERROR = 5,
	AUDIT_APPARMOR_KILL = 6,
	AUDIT_APPARMOR_AUTO = 7,
};

enum auditsc_class_t {
	AUDITSC_NATIVE = 0,
	AUDITSC_COMPAT = 1,
	AUDITSC_OPEN = 2,
	AUDITSC_OPENAT = 3,
	AUDITSC_SOCKETCALL = 4,
	AUDITSC_EXECVE = 5,
	AUDITSC_OPENAT2 = 6,
	AUDITSC_NVALS = 7,
};

enum autofs_notify {
	NFY_NONE = 0,
	NFY_MOUNT = 1,
	NFY_EXPIRE = 2,
};

enum axp20x_variants {
	AXP152_ID = 0,
	AXP192_ID = 1,
	AXP202_ID = 2,
	AXP209_ID = 3,
	AXP221_ID = 4,
	AXP223_ID = 5,
	AXP288_ID = 6,
	AXP313A_ID = 7,
	AXP323_ID = 8,
	AXP717_ID = 9,
	AXP803_ID = 10,
	AXP806_ID = 11,
	AXP809_ID = 12,
	AXP813_ID = 13,
	AXP15060_ID = 14,
	NR_AXP20X_VARIANTS = 15,
};

enum backlight_scale {
	BACKLIGHT_SCALE_UNKNOWN = 0,
	BACKLIGHT_SCALE_LINEAR = 1,
	BACKLIGHT_SCALE_NON_LINEAR = 2,
};

enum backlight_type {
	BACKLIGHT_RAW = 1,
	BACKLIGHT_PLATFORM = 2,
	BACKLIGHT_FIRMWARE = 3,
	BACKLIGHT_TYPE_MAX = 4,
};

enum backlight_update_reason {
	BACKLIGHT_UPDATE_HOTKEY = 0,
	BACKLIGHT_UPDATE_SYSFS = 1,
};

enum batadv_packettype {
	BATADV_IV_OGM = 0,
	BATADV_BCAST = 1,
	BATADV_CODED = 2,
	BATADV_ELP = 3,
	BATADV_OGM2 = 4,
	BATADV_MCAST = 5,
	BATADV_UNICAST = 64,
	BATADV_UNICAST_FRAG = 65,
	BATADV_UNICAST_4ADDR = 66,
	BATADV_ICMP = 67,
	BATADV_UNICAST_TVLV = 68,
};

enum bbr_mode {
	BBR_STARTUP = 0,
	BBR_DRAIN = 1,
	BBR_PROBE_BW = 2,
	BBR_PROBE_RTT = 3,
};

enum behavior {
	EXCLUSIVE = 0,
	SHARED = 1,
	DROP = 2,
};

enum bfqq_expiration {
	BFQQE_TOO_IDLE = 0,
	BFQQE_BUDGET_TIMEOUT = 1,
	BFQQE_BUDGET_EXHAUSTED = 2,
	BFQQE_NO_MORE_REQUESTS = 3,
	BFQQE_PREEMPTED = 4,
};

enum bfqq_state_flags {
	BFQQF_just_created = 0,
	BFQQF_busy = 1,
	BFQQF_wait_request = 2,
	BFQQF_non_blocking_wait_rq = 3,
	BFQQF_fifo_expire = 4,
	BFQQF_has_short_ttime = 5,
	BFQQF_sync = 6,
	BFQQF_IO_bound = 7,
	BFQQF_in_large_burst = 8,
	BFQQF_softrt_update = 9,
	BFQQF_coop = 10,
	BFQQF_split_coop = 11,
};

enum bh_state_bits {
	BH_Uptodate = 0,
	BH_Dirty = 1,
	BH_Lock = 2,
	BH_Req = 3,
	BH_Mapped = 4,
	BH_New = 5,
	BH_Async_Read = 6,
	BH_Async_Write = 7,
	BH_Delay = 8,
	BH_Boundary = 9,
	BH_Write_EIO = 10,
	BH_Unwritten = 11,
	BH_Quiet = 12,
	BH_Meta = 13,
	BH_Prio = 14,
	BH_Defer_Completion = 15,
	BH_Migrate = 16,
	BH_PrivateStart = 17,
};

enum bhi_mitigations {
	BHI_MITIGATION_OFF = 0,
	BHI_MITIGATION_AUTO = 1,
	BHI_MITIGATION_ON = 2,
	BHI_MITIGATION_VMEXIT_ONLY = 3,
};

enum binder_deferred_state {
	BINDER_DEFERRED_FLUSH = 1,
	BINDER_DEFERRED_RELEASE = 2,
};

enum binder_driver_command_protocol {
	BC_TRANSACTION = 1077961472,
	BC_REPLY = 1077961473,
	BC_ACQUIRE_RESULT = 1074029314,
	BC_FREE_BUFFER = 1074291459,
	BC_INCREFS = 1074029316,
	BC_ACQUIRE = 1074029317,
	BC_RELEASE = 1074029318,
	BC_DECREFS = 1074029319,
	BC_INCREFS_DONE = 1074815752,
	BC_ACQUIRE_DONE = 1074815753,
	BC_ATTEMPT_ACQUIRE = 1074291466,
	BC_REGISTER_LOOPER = 25355,
	BC_ENTER_LOOPER = 25356,
	BC_EXIT_LOOPER = 25357,
	BC_REQUEST_DEATH_NOTIFICATION = 1074553614,
	BC_CLEAR_DEATH_NOTIFICATION = 1074553615,
	BC_DEAD_BINDER_DONE = 1074291472,
	BC_TRANSACTION_SG = 1078485777,
	BC_REPLY_SG = 1078485778,
	BC_REQUEST_FREEZE_NOTIFICATION = 1074553619,
	BC_CLEAR_FREEZE_NOTIFICATION = 1074553620,
	BC_FREEZE_NOTIFICATION_DONE = 1074291477,
};

enum binder_driver_return_protocol {
	BR_ERROR = 2147774976,
	BR_OK = 29185,
	BR_TRANSACTION_SEC_CTX = 2152231426,
	BR_TRANSACTION = 2151707138,
	BR_REPLY = 2151707139,
	BR_ACQUIRE_RESULT = 2147774980,
	BR_DEAD_REPLY = 29189,
	BR_TRANSACTION_COMPLETE = 29190,
	BR_INCREFS = 2148561415,
	BR_ACQUIRE = 2148561416,
	BR_RELEASE = 2148561417,
	BR_DECREFS = 2148561418,
	BR_ATTEMPT_ACQUIRE = 2149085707,
	BR_NOOP = 29196,
	BR_SPAWN_LOOPER = 29197,
	BR_FINISHED = 29198,
	BR_DEAD_BINDER = 2148037135,
	BR_CLEAR_DEATH_NOTIFICATION_DONE = 2148037136,
	BR_FAILED_REPLY = 29201,
	BR_FROZEN_REPLY = 29202,
	BR_ONEWAY_SPAM_SUSPECT = 29203,
	BR_TRANSACTION_PENDING_FROZEN = 29204,
	BR_FROZEN_BINDER = 2148561429,
	BR_CLEAR_FREEZE_NOTIFICATION_DONE = 2148037142,
};

enum binder_stat_types {
	BINDER_STAT_PROC = 0,
	BINDER_STAT_THREAD = 1,
	BINDER_STAT_NODE = 2,
	BINDER_STAT_REF = 3,
	BINDER_STAT_DEATH = 4,
	BINDER_STAT_TRANSACTION = 5,
	BINDER_STAT_TRANSACTION_COMPLETE = 6,
	BINDER_STAT_FREEZE = 7,
	BINDER_STAT_COUNT = 8,
};

enum binder_work_type {
	BINDER_WORK_TRANSACTION = 1,
	BINDER_WORK_TRANSACTION_COMPLETE = 2,
	BINDER_WORK_TRANSACTION_PENDING = 3,
	BINDER_WORK_TRANSACTION_ONEWAY_SPAM_SUSPECT = 4,
	BINDER_WORK_RETURN_ERROR = 5,
	BINDER_WORK_NODE = 6,
	BINDER_WORK_DEAD_BINDER = 7,
	BINDER_WORK_DEAD_BINDER_AND_CLEAR = 8,
	BINDER_WORK_CLEAR_DEATH_NOTIFICATION = 9,
	BINDER_WORK_FROZEN_BINDER = 10,
	BINDER_WORK_CLEAR_FREEZE_NOTIFICATION = 11,
};

enum binderfs_param {
	Opt_max___2 = 0,
	Opt_stats_mode = 1,
};

enum binderfs_stats_mode {
	binderfs_stats_mode_unset = 0,
	binderfs_stats_mode_global = 1,
};

enum bio_merge_status {
	BIO_MERGE_OK = 0,
	BIO_MERGE_NONE = 1,
	BIO_MERGE_FAILED = 2,
};

enum bios_platform_class {
	BIOS_CLIENT = 0,
	BIOS_SERVER = 1,
};

enum bip_flags {
	BIP_BLOCK_INTEGRITY = 1,
	BIP_MAPPED_INTEGRITY = 2,
	BIP_DISK_NOCHECK = 4,
	BIP_IP_CHECKSUM = 8,
	BIP_COPY_USER = 16,
	BIP_CHECK_GUARD = 32,
	BIP_CHECK_REFTAG = 64,
	BIP_CHECK_APPTAG = 128,
};

enum blacklist_hash_type {
	BLACKLIST_HASH_X509_TBS = 1,
	BLACKLIST_HASH_BINARY = 2,
};

enum blake2s_iv {
	BLAKE2S_IV0 = 1779033703,
	BLAKE2S_IV1 = 3144134277,
	BLAKE2S_IV2 = 1013904242,
	BLAKE2S_IV3 = 2773480762,
	BLAKE2S_IV4 = 1359893119,
	BLAKE2S_IV5 = 2600822924,
	BLAKE2S_IV6 = 528734635,
	BLAKE2S_IV7 = 1541459225,
};

enum blake2s_lengths {
	BLAKE2S_BLOCK_SIZE = 64,
	BLAKE2S_HASH_SIZE = 32,
	BLAKE2S_KEY_SIZE = 32,
	BLAKE2S_128_HASH_SIZE = 16,
	BLAKE2S_160_HASH_SIZE = 20,
	BLAKE2S_224_HASH_SIZE = 28,
	BLAKE2S_256_HASH_SIZE = 32,
};

enum blk_crypto_key_type {
	BLK_CRYPTO_KEY_TYPE_RAW = 1,
	BLK_CRYPTO_KEY_TYPE_HW_WRAPPED = 2,
};

enum blk_crypto_mode_num {
	BLK_ENCRYPTION_MODE_INVALID = 0,
	BLK_ENCRYPTION_MODE_AES_256_XTS = 1,
	BLK_ENCRYPTION_MODE_AES_128_CBC_ESSIV = 2,
	BLK_ENCRYPTION_MODE_ADIANTUM = 3,
	BLK_ENCRYPTION_MODE_SM4_XTS = 4,
	BLK_ENCRYPTION_MODE_MAX = 5,
};

enum blk_default_limits {
	BLK_MAX_SEGMENTS = 128,
	BLK_SAFE_MAX_SECTORS = 255,
	BLK_MAX_SEGMENT_SIZE = 65536,
	BLK_SEG_BOUNDARY_MASK = 4294967295,
};

enum blk_eh_timer_return {
	BLK_EH_DONE = 0,
	BLK_EH_RESET_TIMER = 1,
};

enum blk_integrity_checksum {
	BLK_INTEGRITY_CSUM_NONE = 0,
	BLK_INTEGRITY_CSUM_IP = 1,
	BLK_INTEGRITY_CSUM_CRC = 2,
	BLK_INTEGRITY_CSUM_CRC64 = 3,
} __attribute__((mode(byte)));

enum blk_integrity_flags {
	BLK_INTEGRITY_NOVERIFY = 1,
	BLK_INTEGRITY_NOGENERATE = 2,
	BLK_INTEGRITY_DEVICE_CAPABLE = 4,
	BLK_INTEGRITY_REF_TAG = 8,
	BLK_INTEGRITY_STACKED = 16,
};

enum blk_unique_id {
	BLK_UID_T10 = 1,
	BLK_UID_EUI64 = 2,
	BLK_UID_NAA = 3,
};

enum blk_zone_cond {
	BLK_ZONE_COND_NOT_WP = 0,
	BLK_ZONE_COND_EMPTY = 1,
	BLK_ZONE_COND_IMP_OPEN = 2,
	BLK_ZONE_COND_EXP_OPEN = 3,
	BLK_ZONE_COND_CLOSED = 4,
	BLK_ZONE_COND_READONLY = 13,
	BLK_ZONE_COND_FULL = 14,
	BLK_ZONE_COND_OFFLINE = 15,
};

enum blk_zone_report_flags {
	BLK_ZONE_REP_CAPACITY = 1,
};

enum blk_zone_type {
	BLK_ZONE_TYPE_CONVENTIONAL = 1,
	BLK_ZONE_TYPE_SEQWRITE_REQ = 2,
	BLK_ZONE_TYPE_SEQWRITE_PREF = 3,
};

enum blkg_iostat_type {
	BLKG_IOSTAT_READ = 0,
	BLKG_IOSTAT_WRITE = 1,
	BLKG_IOSTAT_DISCARD = 2,
	BLKG_IOSTAT_NR = 3,
};

enum blkg_rwstat_type {
	BLKG_RWSTAT_READ = 0,
	BLKG_RWSTAT_WRITE = 1,
	BLKG_RWSTAT_SYNC = 2,
	BLKG_RWSTAT_ASYNC = 3,
	BLKG_RWSTAT_DISCARD = 4,
	BLKG_RWSTAT_NR = 5,
	BLKG_RWSTAT_TOTAL = 5,
};

enum blktrace_act {
	__BLK_TA_QUEUE = 1,
	__BLK_TA_BACKMERGE = 2,
	__BLK_TA_FRONTMERGE = 3,
	__BLK_TA_GETRQ = 4,
	__BLK_TA_SLEEPRQ = 5,
	__BLK_TA_REQUEUE = 6,
	__BLK_TA_ISSUE = 7,
	__BLK_TA_COMPLETE = 8,
	__BLK_TA_PLUG = 9,
	__BLK_TA_UNPLUG_IO = 10,
	__BLK_TA_UNPLUG_TIMER = 11,
	__BLK_TA_INSERT = 12,
	__BLK_TA_SPLIT = 13,
	__BLK_TA_BOUNCE = 14,
	__BLK_TA_REMAP = 15,
	__BLK_TA_ABORT = 16,
	__BLK_TA_DRV_DATA = 17,
	__BLK_TA_CGROUP = 256,
};

enum blktrace_cat {
	BLK_TC_READ = 1,
	BLK_TC_WRITE = 2,
	BLK_TC_FLUSH = 4,
	BLK_TC_SYNC = 8,
	BLK_TC_SYNCIO = 8,
	BLK_TC_QUEUE = 16,
	BLK_TC_REQUEUE = 32,
	BLK_TC_ISSUE = 64,
	BLK_TC_COMPLETE = 128,
	BLK_TC_FS = 256,
	BLK_TC_PC = 512,
	BLK_TC_NOTIFY = 1024,
	BLK_TC_AHEAD = 2048,
	BLK_TC_META = 4096,
	BLK_TC_DISCARD = 8192,
	BLK_TC_DRV_DATA = 16384,
	BLK_TC_FUA = 32768,
	BLK_TC_END = 32768,
};

enum blktrace_notify {
	__BLK_TN_PROCESS = 0,
	__BLK_TN_TIMESTAMP = 1,
	__BLK_TN_MESSAGE = 2,
	__BLK_TN_CGROUP = 256,
};

enum board_ids {
	board_ahci = 0,
	board_ahci_43bit_dma = 1,
	board_ahci_ign_iferr = 2,
	board_ahci_no_debounce_delay = 3,
	board_ahci_no_msi = 4,
	board_ahci_pcs_quirk = 5,
	board_ahci_pcs_quirk_no_devslp = 6,
	board_ahci_pcs_quirk_no_sntf = 7,
	board_ahci_yes_fbs = 8,
	board_ahci_yes_fbs_atapi_dma = 9,
	board_ahci_al = 10,
	board_ahci_avn = 11,
	board_ahci_mcp65 = 12,
	board_ahci_mcp77 = 13,
	board_ahci_mcp89 = 14,
	board_ahci_mv = 15,
	board_ahci_sb600 = 16,
	board_ahci_sb700 = 17,
	board_ahci_vt8251 = 18,
	board_ahci_mcp_linux = 12,
	board_ahci_mcp67 = 12,
	board_ahci_mcp73 = 12,
	board_ahci_mcp79 = 13,
};

enum bootmem_type {
	MEMORY_HOTPLUG_MIN_BOOTMEM_TYPE = 1,
	SECTION_INFO = 1,
	MIX_SECTION_INFO = 2,
	NODE_INFO = 3,
	MEMORY_HOTPLUG_MAX_BOOTMEM_TYPE = 3,
};

enum bp_state {
	BP_DONE = 0,
	BP_WAIT = 1,
	BP_EAGAIN = 2,
	BP_ECANCELED = 3,
};

enum bp_type_idx {
	TYPE_INST = 0,
	TYPE_DATA = 0,
	TYPE_MAX = 1,
};

enum bpf_access_src {
	ACCESS_DIRECT = 1,
	ACCESS_HELPER = 2,
};

enum bpf_access_type {
	BPF_READ = 1,
	BPF_WRITE = 2,
};

enum bpf_addr_space_cast {
	BPF_ADDR_SPACE_CAST = 1,
};

enum bpf_adj_room_mode {
	BPF_ADJ_ROOM_NET = 0,
	BPF_ADJ_ROOM_MAC = 1,
};

enum bpf_arg_type {
	ARG_DONTCARE = 0,
	ARG_CONST_MAP_PTR = 1,
	ARG_PTR_TO_MAP_KEY = 2,
	ARG_PTR_TO_MAP_VALUE = 3,
	ARG_PTR_TO_MEM = 4,
	ARG_PTR_TO_ARENA = 5,
	ARG_CONST_SIZE = 6,
	ARG_CONST_SIZE_OR_ZERO = 7,
	ARG_PTR_TO_CTX = 8,
	ARG_ANYTHING = 9,
	ARG_PTR_TO_SPIN_LOCK = 10,
	ARG_PTR_TO_SOCK_COMMON = 11,
	ARG_PTR_TO_SOCKET = 12,
	ARG_PTR_TO_BTF_ID = 13,
	ARG_PTR_TO_RINGBUF_MEM = 14,
	ARG_CONST_ALLOC_SIZE_OR_ZERO = 15,
	ARG_PTR_TO_BTF_ID_SOCK_COMMON = 16,
	ARG_PTR_TO_PERCPU_BTF_ID = 17,
	ARG_PTR_TO_FUNC = 18,
	ARG_PTR_TO_STACK = 19,
	ARG_PTR_TO_CONST_STR = 20,
	ARG_PTR_TO_TIMER = 21,
	ARG_KPTR_XCHG_DEST = 22,
	ARG_PTR_TO_DYNPTR = 23,
	__BPF_ARG_TYPE_MAX = 24,
	ARG_PTR_TO_MAP_VALUE_OR_NULL = 259,
	ARG_PTR_TO_MEM_OR_NULL = 260,
	ARG_PTR_TO_CTX_OR_NULL = 264,
	ARG_PTR_TO_SOCKET_OR_NULL = 268,
	ARG_PTR_TO_STACK_OR_NULL = 275,
	ARG_PTR_TO_BTF_ID_OR_NULL = 269,
	ARG_PTR_TO_UNINIT_MEM = 67141636,
	ARG_PTR_TO_FIXED_SIZE_MEM = 262148,
	__BPF_ARG_TYPE_LIMIT = 134217727,
};

enum bpf_async_type {
	BPF_ASYNC_TYPE_TIMER = 0,
	BPF_ASYNC_TYPE_WQ = 1,
};

enum bpf_attach_type {
	BPF_CGROUP_INET_INGRESS = 0,
	BPF_CGROUP_INET_EGRESS = 1,
	BPF_CGROUP_INET_SOCK_CREATE = 2,
	BPF_CGROUP_SOCK_OPS = 3,
	BPF_SK_SKB_STREAM_PARSER = 4,
	BPF_SK_SKB_STREAM_VERDICT = 5,
	BPF_CGROUP_DEVICE = 6,
	BPF_SK_MSG_VERDICT = 7,
	BPF_CGROUP_INET4_BIND = 8,
	BPF_CGROUP_INET6_BIND = 9,
	BPF_CGROUP_INET4_CONNECT = 10,
	BPF_CGROUP_INET6_CONNECT = 11,
	BPF_CGROUP_INET4_POST_BIND = 12,
	BPF_CGROUP_INET6_POST_BIND = 13,
	BPF_CGROUP_UDP4_SENDMSG = 14,
	BPF_CGROUP_UDP6_SENDMSG = 15,
	BPF_LIRC_MODE2 = 16,
	BPF_FLOW_DISSECTOR = 17,
	BPF_CGROUP_SYSCTL = 18,
	BPF_CGROUP_UDP4_RECVMSG = 19,
	BPF_CGROUP_UDP6_RECVMSG = 20,
	BPF_CGROUP_GETSOCKOPT = 21,
	BPF_CGROUP_SETSOCKOPT = 22,
	BPF_TRACE_RAW_TP = 23,
	BPF_TRACE_FENTRY = 24,
	BPF_TRACE_FEXIT = 25,
	BPF_MODIFY_RETURN = 26,
	BPF_LSM_MAC = 27,
	BPF_TRACE_ITER = 28,
	BPF_CGROUP_INET4_GETPEERNAME = 29,
	BPF_CGROUP_INET6_GETPEERNAME = 30,
	BPF_CGROUP_INET4_GETSOCKNAME = 31,
	BPF_CGROUP_INET6_GETSOCKNAME = 32,
	BPF_XDP_DEVMAP = 33,
	BPF_CGROUP_INET_SOCK_RELEASE = 34,
	BPF_XDP_CPUMAP = 35,
	BPF_SK_LOOKUP = 36,
	BPF_XDP = 37,
	BPF_SK_SKB_VERDICT = 38,
	BPF_SK_REUSEPORT_SELECT = 39,
	BPF_SK_REUSEPORT_SELECT_OR_MIGRATE = 40,
	BPF_PERF_EVENT = 41,
	BPF_TRACE_KPROBE_MULTI = 42,
	BPF_LSM_CGROUP = 43,
	BPF_STRUCT_OPS = 44,
	BPF_NETFILTER = 45,
	BPF_TCX_INGRESS = 46,
	BPF_TCX_EGRESS = 47,
	BPF_TRACE_UPROBE_MULTI = 48,
	BPF_CGROUP_UNIX_CONNECT = 49,
	BPF_CGROUP_UNIX_SENDMSG = 50,
	BPF_CGROUP_UNIX_RECVMSG = 51,
	BPF_CGROUP_UNIX_GETPEERNAME = 52,
	BPF_CGROUP_UNIX_GETSOCKNAME = 53,
	BPF_NETKIT_PRIMARY = 54,
	BPF_NETKIT_PEER = 55,
	BPF_TRACE_KPROBE_SESSION = 56,
	BPF_TRACE_UPROBE_SESSION = 57,
	__MAX_BPF_ATTACH_TYPE = 58,
};

enum bpf_audit {
	BPF_AUDIT_LOAD = 0,
	BPF_AUDIT_UNLOAD = 1,
	BPF_AUDIT_MAX = 2,
};

enum bpf_cgroup_iter_order {
	BPF_CGROUP_ITER_ORDER_UNSPEC = 0,
	BPF_CGROUP_ITER_SELF_ONLY = 1,
	BPF_CGROUP_ITER_DESCENDANTS_PRE = 2,
	BPF_CGROUP_ITER_DESCENDANTS_POST = 3,
	BPF_CGROUP_ITER_ANCESTORS_UP = 4,
};

enum bpf_cgroup_storage_type {
	BPF_CGROUP_STORAGE_SHARED = 0,
	BPF_CGROUP_STORAGE_PERCPU = 1,
	__BPF_CGROUP_STORAGE_MAX = 2,
};

enum bpf_check_mtu_flags {
	BPF_MTU_CHK_SEGS = 1,
};

enum bpf_check_mtu_ret {
	BPF_MTU_CHK_RET_SUCCESS = 0,
	BPF_MTU_CHK_RET_FRAG_NEEDED = 1,
	BPF_MTU_CHK_RET_SEGS_TOOBIG = 2,
};

enum bpf_cmd {
	BPF_MAP_CREATE = 0,
	BPF_MAP_LOOKUP_ELEM = 1,
	BPF_MAP_UPDATE_ELEM = 2,
	BPF_MAP_DELETE_ELEM = 3,
	BPF_MAP_GET_NEXT_KEY = 4,
	BPF_PROG_LOAD = 5,
	BPF_OBJ_PIN = 6,
	BPF_OBJ_GET = 7,
	BPF_PROG_ATTACH = 8,
	BPF_PROG_DETACH = 9,
	BPF_PROG_TEST_RUN = 10,
	BPF_PROG_RUN = 10,
	BPF_PROG_GET_NEXT_ID = 11,
	BPF_MAP_GET_NEXT_ID = 12,
	BPF_PROG_GET_FD_BY_ID = 13,
	BPF_MAP_GET_FD_BY_ID = 14,
	BPF_OBJ_GET_INFO_BY_FD = 15,
	BPF_PROG_QUERY = 16,
	BPF_RAW_TRACEPOINT_OPEN = 17,
	BPF_BTF_LOAD = 18,
	BPF_BTF_GET_FD_BY_ID = 19,
	BPF_TASK_FD_QUERY = 20,
	BPF_MAP_LOOKUP_AND_DELETE_ELEM = 21,
	BPF_MAP_FREEZE = 22,
	BPF_BTF_GET_NEXT_ID = 23,
	BPF_MAP_LOOKUP_BATCH = 24,
	BPF_MAP_LOOKUP_AND_DELETE_BATCH = 25,
	BPF_MAP_UPDATE_BATCH = 26,
	BPF_MAP_DELETE_BATCH = 27,
	BPF_LINK_CREATE = 28,
	BPF_LINK_UPDATE = 29,
	BPF_LINK_GET_FD_BY_ID = 30,
	BPF_LINK_GET_NEXT_ID = 31,
	BPF_ENABLE_STATS = 32,
	BPF_ITER_CREATE = 33,
	BPF_LINK_DETACH = 34,
	BPF_PROG_BIND_MAP = 35,
	BPF_TOKEN_CREATE = 36,
	BPF_PROG_STREAM_READ_BY_FD = 37,
	__MAX_BPF_CMD = 38,
};

enum bpf_cond_pseudo_jmp {
	BPF_MAY_GOTO = 0,
};

enum bpf_core_relo_kind {
	BPF_CORE_FIELD_BYTE_OFFSET = 0,
	BPF_CORE_FIELD_BYTE_SIZE = 1,
	BPF_CORE_FIELD_EXISTS = 2,
	BPF_CORE_FIELD_SIGNED = 3,
	BPF_CORE_FIELD_LSHIFT_U64 = 4,
	BPF_CORE_FIELD_RSHIFT_U64 = 5,
	BPF_CORE_TYPE_ID_LOCAL = 6,
	BPF_CORE_TYPE_ID_TARGET = 7,
	BPF_CORE_TYPE_EXISTS = 8,
	BPF_CORE_TYPE_SIZE = 9,
	BPF_CORE_ENUMVAL_EXISTS = 10,
	BPF_CORE_ENUMVAL_VALUE = 11,
	BPF_CORE_TYPE_MATCHES = 12,
};

enum bpf_dynptr_type {
	BPF_DYNPTR_TYPE_INVALID = 0,
	BPF_DYNPTR_TYPE_LOCAL = 1,
	BPF_DYNPTR_TYPE_RINGBUF = 2,
	BPF_DYNPTR_TYPE_SKB = 3,
	BPF_DYNPTR_TYPE_XDP = 4,
};

enum bpf_features {
	BPF_FEAT_RDONLY_CAST_TO_VOID = 0,
	BPF_FEAT_STREAMS = 1,
	__MAX_BPF_FEAT = 2,
};

enum bpf_func_id {
	BPF_FUNC_unspec = 0,
	BPF_FUNC_map_lookup_elem = 1,
	BPF_FUNC_map_update_elem = 2,
	BPF_FUNC_map_delete_elem = 3,
	BPF_FUNC_probe_read = 4,
	BPF_FUNC_ktime_get_ns = 5,
	BPF_FUNC_trace_printk = 6,
	BPF_FUNC_get_prandom_u32 = 7,
	BPF_FUNC_get_smp_processor_id = 8,
	BPF_FUNC_skb_store_bytes = 9,
	BPF_FUNC_l3_csum_replace = 10,
	BPF_FUNC_l4_csum_replace = 11,
	BPF_FUNC_tail_call = 12,
	BPF_FUNC_clone_redirect = 13,
	BPF_FUNC_get_current_pid_tgid = 14,
	BPF_FUNC_get_current_uid_gid = 15,
	BPF_FUNC_get_current_comm = 16,
	BPF_FUNC_get_cgroup_classid = 17,
	BPF_FUNC_skb_vlan_push = 18,
	BPF_FUNC_skb_vlan_pop = 19,
	BPF_FUNC_skb_get_tunnel_key = 20,
	BPF_FUNC_skb_set_tunnel_key = 21,
	BPF_FUNC_perf_event_read = 22,
	BPF_FUNC_redirect = 23,
	BPF_FUNC_get_route_realm = 24,
	BPF_FUNC_perf_event_output = 25,
	BPF_FUNC_skb_load_bytes = 26,
	BPF_FUNC_get_stackid = 27,
	BPF_FUNC_csum_diff = 28,
	BPF_FUNC_skb_get_tunnel_opt = 29,
	BPF_FUNC_skb_set_tunnel_opt = 30,
	BPF_FUNC_skb_change_proto = 31,
	BPF_FUNC_skb_change_type = 32,
	BPF_FUNC_skb_under_cgroup = 33,
	BPF_FUNC_get_hash_recalc = 34,
	BPF_FUNC_get_current_task = 35,
	BPF_FUNC_probe_write_user = 36,
	BPF_FUNC_current_task_under_cgroup = 37,
	BPF_FUNC_skb_change_tail = 38,
	BPF_FUNC_skb_pull_data = 39,
	BPF_FUNC_csum_update = 40,
	BPF_FUNC_set_hash_invalid = 41,
	BPF_FUNC_get_numa_node_id = 42,
	BPF_FUNC_skb_change_head = 43,
	BPF_FUNC_xdp_adjust_head = 44,
	BPF_FUNC_probe_read_str = 45,
	BPF_FUNC_get_socket_cookie = 46,
	BPF_FUNC_get_socket_uid = 47,
	BPF_FUNC_set_hash = 48,
	BPF_FUNC_setsockopt = 49,
	BPF_FUNC_skb_adjust_room = 50,
	BPF_FUNC_redirect_map = 51,
	BPF_FUNC_sk_redirect_map = 52,
	BPF_FUNC_sock_map_update = 53,
	BPF_FUNC_xdp_adjust_meta = 54,
	BPF_FUNC_perf_event_read_value = 55,
	BPF_FUNC_perf_prog_read_value = 56,
	BPF_FUNC_getsockopt = 57,
	BPF_FUNC_override_return = 58,
	BPF_FUNC_sock_ops_cb_flags_set = 59,
	BPF_FUNC_msg_redirect_map = 60,
	BPF_FUNC_msg_apply_bytes = 61,
	BPF_FUNC_msg_cork_bytes = 62,
	BPF_FUNC_msg_pull_data = 63,
	BPF_FUNC_bind = 64,
	BPF_FUNC_xdp_adjust_tail = 65,
	BPF_FUNC_skb_get_xfrm_state = 66,
	BPF_FUNC_get_stack = 67,
	BPF_FUNC_skb_load_bytes_relative = 68,
	BPF_FUNC_fib_lookup = 69,
	BPF_FUNC_sock_hash_update = 70,
	BPF_FUNC_msg_redirect_hash = 71,
	BPF_FUNC_sk_redirect_hash = 72,
	BPF_FUNC_lwt_push_encap = 73,
	BPF_FUNC_lwt_seg6_store_bytes = 74,
	BPF_FUNC_lwt_seg6_adjust_srh = 75,
	BPF_FUNC_lwt_seg6_action = 76,
	BPF_FUNC_rc_repeat = 77,
	BPF_FUNC_rc_keydown = 78,
	BPF_FUNC_skb_cgroup_id = 79,
	BPF_FUNC_get_current_cgroup_id = 80,
	BPF_FUNC_get_local_storage = 81,
	BPF_FUNC_sk_select_reuseport = 82,
	BPF_FUNC_skb_ancestor_cgroup_id = 83,
	BPF_FUNC_sk_lookup_tcp = 84,
	BPF_FUNC_sk_lookup_udp = 85,
	BPF_FUNC_sk_release = 86,
	BPF_FUNC_map_push_elem = 87,
	BPF_FUNC_map_pop_elem = 88,
	BPF_FUNC_map_peek_elem = 89,
	BPF_FUNC_msg_push_data = 90,
	BPF_FUNC_msg_pop_data = 91,
	BPF_FUNC_rc_pointer_rel = 92,
	BPF_FUNC_spin_lock = 93,
	BPF_FUNC_spin_unlock = 94,
	BPF_FUNC_sk_fullsock = 95,
	BPF_FUNC_tcp_sock = 96,
	BPF_FUNC_skb_ecn_set_ce = 97,
	BPF_FUNC_get_listener_sock = 98,
	BPF_FUNC_skc_lookup_tcp = 99,
	BPF_FUNC_tcp_check_syncookie = 100,
	BPF_FUNC_sysctl_get_name = 101,
	BPF_FUNC_sysctl_get_current_value = 102,
	BPF_FUNC_sysctl_get_new_value = 103,
	BPF_FUNC_sysctl_set_new_value = 104,
	BPF_FUNC_strtol = 105,
	BPF_FUNC_strtoul = 106,
	BPF_FUNC_sk_storage_get = 107,
	BPF_FUNC_sk_storage_delete = 108,
	BPF_FUNC_send_signal = 109,
	BPF_FUNC_tcp_gen_syncookie = 110,
	BPF_FUNC_skb_output = 111,
	BPF_FUNC_probe_read_user = 112,
	BPF_FUNC_probe_read_kernel = 113,
	BPF_FUNC_probe_read_user_str = 114,
	BPF_FUNC_probe_read_kernel_str = 115,
	BPF_FUNC_tcp_send_ack = 116,
	BPF_FUNC_send_signal_thread = 117,
	BPF_FUNC_jiffies64 = 118,
	BPF_FUNC_read_branch_records = 119,
	BPF_FUNC_get_ns_current_pid_tgid = 120,
	BPF_FUNC_xdp_output = 121,
	BPF_FUNC_get_netns_cookie = 122,
	BPF_FUNC_get_current_ancestor_cgroup_id = 123,
	BPF_FUNC_sk_assign = 124,
	BPF_FUNC_ktime_get_boot_ns = 125,
	BPF_FUNC_seq_printf = 126,
	BPF_FUNC_seq_write = 127,
	BPF_FUNC_sk_cgroup_id = 128,
	BPF_FUNC_sk_ancestor_cgroup_id = 129,
	BPF_FUNC_ringbuf_output = 130,
	BPF_FUNC_ringbuf_reserve = 131,
	BPF_FUNC_ringbuf_submit = 132,
	BPF_FUNC_ringbuf_discard = 133,
	BPF_FUNC_ringbuf_query = 134,
	BPF_FUNC_csum_level = 135,
	BPF_FUNC_skc_to_tcp6_sock = 136,
	BPF_FUNC_skc_to_tcp_sock = 137,
	BPF_FUNC_skc_to_tcp_timewait_sock = 138,
	BPF_FUNC_skc_to_tcp_request_sock = 139,
	BPF_FUNC_skc_to_udp6_sock = 140,
	BPF_FUNC_get_task_stack = 141,
	BPF_FUNC_load_hdr_opt = 142,
	BPF_FUNC_store_hdr_opt = 143,
	BPF_FUNC_reserve_hdr_opt = 144,
	BPF_FUNC_inode_storage_get = 145,
	BPF_FUNC_inode_storage_delete = 146,
	BPF_FUNC_d_path = 147,
	BPF_FUNC_copy_from_user = 148,
	BPF_FUNC_snprintf_btf = 149,
	BPF_FUNC_seq_printf_btf = 150,
	BPF_FUNC_skb_cgroup_classid = 151,
	BPF_FUNC_redirect_neigh = 152,
	BPF_FUNC_per_cpu_ptr = 153,
	BPF_FUNC_this_cpu_ptr = 154,
	BPF_FUNC_redirect_peer = 155,
	BPF_FUNC_task_storage_get = 156,
	BPF_FUNC_task_storage_delete = 157,
	BPF_FUNC_get_current_task_btf = 158,
	BPF_FUNC_bprm_opts_set = 159,
	BPF_FUNC_ktime_get_coarse_ns = 160,
	BPF_FUNC_ima_inode_hash = 161,
	BPF_FUNC_sock_from_file = 162,
	BPF_FUNC_check_mtu = 163,
	BPF_FUNC_for_each_map_elem = 164,
	BPF_FUNC_snprintf = 165,
	BPF_FUNC_sys_bpf = 166,
	BPF_FUNC_btf_find_by_name_kind = 167,
	BPF_FUNC_sys_close = 168,
	BPF_FUNC_timer_init = 169,
	BPF_FUNC_timer_set_callback = 170,
	BPF_FUNC_timer_start = 171,
	BPF_FUNC_timer_cancel = 172,
	BPF_FUNC_get_func_ip = 173,
	BPF_FUNC_get_attach_cookie = 174,
	BPF_FUNC_task_pt_regs = 175,
	BPF_FUNC_get_branch_snapshot = 176,
	BPF_FUNC_trace_vprintk = 177,
	BPF_FUNC_skc_to_unix_sock = 178,
	BPF_FUNC_kallsyms_lookup_name = 179,
	BPF_FUNC_find_vma = 180,
	BPF_FUNC_loop = 181,
	BPF_FUNC_strncmp = 182,
	BPF_FUNC_get_func_arg = 183,
	BPF_FUNC_get_func_ret = 184,
	BPF_FUNC_get_func_arg_cnt = 185,
	BPF_FUNC_get_retval = 186,
	BPF_FUNC_set_retval = 187,
	BPF_FUNC_xdp_get_buff_len = 188,
	BPF_FUNC_xdp_load_bytes = 189,
	BPF_FUNC_xdp_store_bytes = 190,
	BPF_FUNC_copy_from_user_task = 191,
	BPF_FUNC_skb_set_tstamp = 192,
	BPF_FUNC_ima_file_hash = 193,
	BPF_FUNC_kptr_xchg = 194,
	BPF_FUNC_map_lookup_percpu_elem = 195,
	BPF_FUNC_skc_to_mptcp_sock = 196,
	BPF_FUNC_dynptr_from_mem = 197,
	BPF_FUNC_ringbuf_reserve_dynptr = 198,
	BPF_FUNC_ringbuf_submit_dynptr = 199,
	BPF_FUNC_ringbuf_discard_dynptr = 200,
	BPF_FUNC_dynptr_read = 201,
	BPF_FUNC_dynptr_write = 202,
	BPF_FUNC_dynptr_data = 203,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv4 = 204,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv6 = 205,
	BPF_FUNC_tcp_raw_check_syncookie_ipv4 = 206,
	BPF_FUNC_tcp_raw_check_syncookie_ipv6 = 207,
	BPF_FUNC_ktime_get_tai_ns = 208,
	BPF_FUNC_user_ringbuf_drain = 209,
	BPF_FUNC_cgrp_storage_get = 210,
	BPF_FUNC_cgrp_storage_delete = 211,
	__BPF_FUNC_MAX_ID = 212,
};

enum bpf_hdr_start_off {
	BPF_HDR_START_MAC = 0,
	BPF_HDR_START_NET = 1,
};

enum bpf_iter_feature {
	BPF_ITER_RESCHED = 1,
};

enum bpf_iter_state {
	BPF_ITER_STATE_INVALID = 0,
	BPF_ITER_STATE_ACTIVE = 1,
	BPF_ITER_STATE_DRAINED = 2,
};

enum bpf_iter_task_type {
	BPF_TASK_ITER_ALL = 0,
	BPF_TASK_ITER_TID = 1,
	BPF_TASK_ITER_TGID = 2,
};

enum bpf_jit_poke_reason {
	BPF_POKE_REASON_TAIL_CALL = 0,
};

enum bpf_kfunc_flags {
	BPF_F_PAD_ZEROS = 1,
};

enum bpf_link_type {
	BPF_LINK_TYPE_UNSPEC = 0,
	BPF_LINK_TYPE_RAW_TRACEPOINT = 1,
	BPF_LINK_TYPE_TRACING = 2,
	BPF_LINK_TYPE_CGROUP = 3,
	BPF_LINK_TYPE_ITER = 4,
	BPF_LINK_TYPE_NETNS = 5,
	BPF_LINK_TYPE_XDP = 6,
	BPF_LINK_TYPE_PERF_EVENT = 7,
	BPF_LINK_TYPE_KPROBE_MULTI = 8,
	BPF_LINK_TYPE_STRUCT_OPS = 9,
	BPF_LINK_TYPE_NETFILTER = 10,
	BPF_LINK_TYPE_TCX = 11,
	BPF_LINK_TYPE_UPROBE_MULTI = 12,
	BPF_LINK_TYPE_NETKIT = 13,
	BPF_LINK_TYPE_SOCKMAP = 14,
	__MAX_BPF_LINK_TYPE = 15,
};

enum bpf_lru_list_type {
	BPF_LRU_LIST_T_ACTIVE = 0,
	BPF_LRU_LIST_T_INACTIVE = 1,
	BPF_LRU_LIST_T_FREE = 2,
	BPF_LRU_LOCAL_LIST_T_FREE = 3,
	BPF_LRU_LOCAL_LIST_T_PENDING = 4,
};

enum bpf_lwt_encap_mode {
	BPF_LWT_ENCAP_SEG6 = 0,
	BPF_LWT_ENCAP_SEG6_INLINE = 1,
	BPF_LWT_ENCAP_IP = 2,
};

enum bpf_map_type {
	BPF_MAP_TYPE_UNSPEC = 0,
	BPF_MAP_TYPE_HASH = 1,
	BPF_MAP_TYPE_ARRAY = 2,
	BPF_MAP_TYPE_PROG_ARRAY = 3,
	BPF_MAP_TYPE_PERF_EVENT_ARRAY = 4,
	BPF_MAP_TYPE_PERCPU_HASH = 5,
	BPF_MAP_TYPE_PERCPU_ARRAY = 6,
	BPF_MAP_TYPE_STACK_TRACE = 7,
	BPF_MAP_TYPE_CGROUP_ARRAY = 8,
	BPF_MAP_TYPE_LRU_HASH = 9,
	BPF_MAP_TYPE_LRU_PERCPU_HASH = 10,
	BPF_MAP_TYPE_LPM_TRIE = 11,
	BPF_MAP_TYPE_ARRAY_OF_MAPS = 12,
	BPF_MAP_TYPE_HASH_OF_MAPS = 13,
	BPF_MAP_TYPE_DEVMAP = 14,
	BPF_MAP_TYPE_SOCKMAP = 15,
	BPF_MAP_TYPE_CPUMAP = 16,
	BPF_MAP_TYPE_XSKMAP = 17,
	BPF_MAP_TYPE_SOCKHASH = 18,
	BPF_MAP_TYPE_CGROUP_STORAGE_DEPRECATED = 19,
	BPF_MAP_TYPE_CGROUP_STORAGE = 19,
	BPF_MAP_TYPE_REUSEPORT_SOCKARRAY = 20,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE_DEPRECATED = 21,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE = 21,
	BPF_MAP_TYPE_QUEUE = 22,
	BPF_MAP_TYPE_STACK = 23,
	BPF_MAP_TYPE_SK_STORAGE = 24,
	BPF_MAP_TYPE_DEVMAP_HASH = 25,
	BPF_MAP_TYPE_STRUCT_OPS = 26,
	BPF_MAP_TYPE_RINGBUF = 27,
	BPF_MAP_TYPE_INODE_STORAGE = 28,
	BPF_MAP_TYPE_TASK_STORAGE = 29,
	BPF_MAP_TYPE_BLOOM_FILTER = 30,
	BPF_MAP_TYPE_USER_RINGBUF = 31,
	BPF_MAP_TYPE_CGRP_STORAGE = 32,
	BPF_MAP_TYPE_ARENA = 33,
	__MAX_BPF_MAP_TYPE = 34,
};

enum bpf_netdev_command {
	XDP_SETUP_PROG = 0,
	XDP_SETUP_PROG_HW = 1,
	BPF_OFFLOAD_MAP_ALLOC = 2,
	BPF_OFFLOAD_MAP_FREE = 3,
	XDP_SETUP_XSK_POOL = 4,
};

enum bpf_perf_event_type {
	BPF_PERF_EVENT_UNSPEC = 0,
	BPF_PERF_EVENT_UPROBE = 1,
	BPF_PERF_EVENT_URETPROBE = 2,
	BPF_PERF_EVENT_KPROBE = 3,
	BPF_PERF_EVENT_KRETPROBE = 4,
	BPF_PERF_EVENT_TRACEPOINT = 5,
	BPF_PERF_EVENT_EVENT = 6,
};

enum bpf_prog_type {
	BPF_PROG_TYPE_UNSPEC = 0,
	BPF_PROG_TYPE_SOCKET_FILTER = 1,
	BPF_PROG_TYPE_KPROBE = 2,
	BPF_PROG_TYPE_SCHED_CLS = 3,
	BPF_PROG_TYPE_SCHED_ACT = 4,
	BPF_PROG_TYPE_TRACEPOINT = 5,
	BPF_PROG_TYPE_XDP = 6,
	BPF_PROG_TYPE_PERF_EVENT = 7,
	BPF_PROG_TYPE_CGROUP_SKB = 8,
	BPF_PROG_TYPE_CGROUP_SOCK = 9,
	BPF_PROG_TYPE_LWT_IN = 10,
	BPF_PROG_TYPE_LWT_OUT = 11,
	BPF_PROG_TYPE_LWT_XMIT = 12,
	BPF_PROG_TYPE_SOCK_OPS = 13,
	BPF_PROG_TYPE_SK_SKB = 14,
	BPF_PROG_TYPE_CGROUP_DEVICE = 15,
	BPF_PROG_TYPE_SK_MSG = 16,
	BPF_PROG_TYPE_RAW_TRACEPOINT = 17,
	BPF_PROG_TYPE_CGROUP_SOCK_ADDR = 18,
	BPF_PROG_TYPE_LWT_SEG6LOCAL = 19,
	BPF_PROG_TYPE_LIRC_MODE2 = 20,
	BPF_PROG_TYPE_SK_REUSEPORT = 21,
	BPF_PROG_TYPE_FLOW_DISSECTOR = 22,
	BPF_PROG_TYPE_CGROUP_SYSCTL = 23,
	BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 24,
	BPF_PROG_TYPE_CGROUP_SOCKOPT = 25,
	BPF_PROG_TYPE_TRACING = 26,
	BPF_PROG_TYPE_STRUCT_OPS = 27,
	BPF_PROG_TYPE_EXT = 28,
	BPF_PROG_TYPE_LSM = 29,
	BPF_PROG_TYPE_SK_LOOKUP = 30,
	BPF_PROG_TYPE_SYSCALL = 31,
	BPF_PROG_TYPE_NETFILTER = 32,
	__MAX_BPF_PROG_TYPE = 33,
};

enum bpf_reg_liveness {
	REG_LIVE_NONE = 0,
	REG_LIVE_READ32 = 1,
	REG_LIVE_READ64 = 2,
	REG_LIVE_READ = 3,
	REG_LIVE_WRITTEN = 4,
	REG_LIVE_DONE = 8,
};

enum bpf_reg_type {
	NOT_INIT = 0,
	SCALAR_VALUE = 1,
	PTR_TO_CTX = 2,
	CONST_PTR_TO_MAP = 3,
	PTR_TO_MAP_VALUE = 4,
	PTR_TO_MAP_KEY = 5,
	PTR_TO_STACK = 6,
	PTR_TO_PACKET_META = 7,
	PTR_TO_PACKET = 8,
	PTR_TO_PACKET_END = 9,
	PTR_TO_FLOW_KEYS = 10,
	PTR_TO_SOCKET = 11,
	PTR_TO_SOCK_COMMON = 12,
	PTR_TO_TCP_SOCK = 13,
	PTR_TO_TP_BUFFER = 14,
	PTR_TO_XDP_SOCK = 15,
	PTR_TO_BTF_ID = 16,
	PTR_TO_MEM = 17,
	PTR_TO_ARENA = 18,
	PTR_TO_BUF = 19,
	PTR_TO_FUNC = 20,
	CONST_PTR_TO_DYNPTR = 21,
	__BPF_REG_TYPE_MAX = 22,
	PTR_TO_MAP_VALUE_OR_NULL = 260,
	PTR_TO_SOCKET_OR_NULL = 267,
	PTR_TO_SOCK_COMMON_OR_NULL = 268,
	PTR_TO_TCP_SOCK_OR_NULL = 269,
	PTR_TO_BTF_ID_OR_NULL = 272,
	__BPF_REG_TYPE_LIMIT = 134217727,
};

enum bpf_ret_code {
	BPF_OK = 0,
	BPF_DROP = 2,
	BPF_REDIRECT = 7,
	BPF_LWT_REROUTE = 128,
	BPF_FLOW_DISSECTOR_CONTINUE = 129,
};

enum bpf_return_type {
	RET_INTEGER = 0,
	RET_VOID = 1,
	RET_PTR_TO_MAP_VALUE = 2,
	RET_PTR_TO_SOCKET = 3,
	RET_PTR_TO_TCP_SOCK = 4,
	RET_PTR_TO_SOCK_COMMON = 5,
	RET_PTR_TO_MEM = 6,
	RET_PTR_TO_MEM_OR_BTF_ID = 7,
	RET_PTR_TO_BTF_ID = 8,
	__BPF_RET_TYPE_MAX = 9,
	RET_PTR_TO_MAP_VALUE_OR_NULL = 258,
	RET_PTR_TO_SOCKET_OR_NULL = 259,
	RET_PTR_TO_TCP_SOCK_OR_NULL = 260,
	RET_PTR_TO_SOCK_COMMON_OR_NULL = 261,
	RET_PTR_TO_RINGBUF_MEM_OR_NULL = 1286,
	RET_PTR_TO_DYNPTR_MEM_OR_NULL = 262,
	RET_PTR_TO_BTF_ID_OR_NULL = 264,
	RET_PTR_TO_BTF_ID_TRUSTED = 1048584,
	__BPF_RET_TYPE_LIMIT = 134217727,
};

enum bpf_stack_build_id_status {
	BPF_STACK_BUILD_ID_EMPTY = 0,
	BPF_STACK_BUILD_ID_VALID = 1,
	BPF_STACK_BUILD_ID_IP = 2,
};

enum bpf_stack_slot_type {
	STACK_INVALID = 0,
	STACK_SPILL = 1,
	STACK_MISC = 2,
	STACK_ZERO = 3,
	STACK_DYNPTR = 4,
	STACK_ITER = 5,
	STACK_IRQ_FLAG = 6,
};

enum bpf_stats_type {
	BPF_STATS_RUN_TIME = 0,
};

enum bpf_stream_id {
	BPF_STDOUT = 1,
	BPF_STDERR = 2,
};

enum bpf_struct_ops_state {
	BPF_STRUCT_OPS_STATE_INIT = 0,
	BPF_STRUCT_OPS_STATE_INUSE = 1,
	BPF_STRUCT_OPS_STATE_TOBEFREE = 2,
	BPF_STRUCT_OPS_STATE_READY = 3,
};

enum bpf_struct_walk_result {
	WALK_SCALAR = 0,
	WALK_PTR = 1,
	WALK_PTR_UNTRUSTED = 2,
	WALK_STRUCT = 3,
};

enum bpf_task_fd_type {
	BPF_FD_TYPE_RAW_TRACEPOINT = 0,
	BPF_FD_TYPE_TRACEPOINT = 1,
	BPF_FD_TYPE_KPROBE = 2,
	BPF_FD_TYPE_KRETPROBE = 3,
	BPF_FD_TYPE_UPROBE = 4,
	BPF_FD_TYPE_URETPROBE = 5,
};

enum bpf_task_vma_iter_find_op {
	task_vma_iter_first_vma = 0,
	task_vma_iter_next_vma = 1,
	task_vma_iter_find_vma = 2,
};

enum bpf_text_poke_type {
	BPF_MOD_CALL = 0,
	BPF_MOD_JUMP = 1,
};

enum bpf_tramp_prog_type {
	BPF_TRAMP_FENTRY = 0,
	BPF_TRAMP_FEXIT = 1,
	BPF_TRAMP_MODIFY_RETURN = 2,
	BPF_TRAMP_MAX = 3,
	BPF_TRAMP_REPLACE = 4,
};

enum bpf_type {
	BPF_TYPE_UNSPEC = 0,
	BPF_TYPE_PROG = 1,
	BPF_TYPE_MAP = 2,
	BPF_TYPE_LINK = 3,
};

enum bpf_type_flag {
	PTR_MAYBE_NULL = 256,
	MEM_RDONLY = 512,
	MEM_RINGBUF = 1024,
	MEM_USER = 2048,
	MEM_PERCPU = 4096,
	OBJ_RELEASE = 8192,
	PTR_UNTRUSTED = 16384,
	MEM_UNINIT = 32768,
	DYNPTR_TYPE_LOCAL = 65536,
	DYNPTR_TYPE_RINGBUF = 131072,
	MEM_FIXED_SIZE = 262144,
	MEM_ALLOC = 524288,
	PTR_TRUSTED = 1048576,
	MEM_RCU = 2097152,
	NON_OWN_REF = 4194304,
	DYNPTR_TYPE_SKB = 8388608,
	DYNPTR_TYPE_XDP = 16777216,
	MEM_ALIGNED = 33554432,
	MEM_WRITE = 67108864,
	__BPF_TYPE_FLAG_MAX = 67108865,
	__BPF_TYPE_LAST_FLAG = 67108864,
};

enum bpf_xdp_mode {
	XDP_MODE_SKB = 0,
	XDP_MODE_DRV = 1,
	XDP_MODE_HW = 2,
	__MAX_XDP_MODE = 3,
};

enum btf_arg_tag {
	ARG_TAG_CTX = 1,
	ARG_TAG_NONNULL = 2,
	ARG_TAG_TRUSTED = 4,
	ARG_TAG_UNTRUSTED = 8,
	ARG_TAG_NULLABLE = 16,
	ARG_TAG_ARENA = 32,
};

enum btf_field_iter_kind {
	BTF_FIELD_ITER_IDS = 0,
	BTF_FIELD_ITER_STRS = 1,
};

enum btf_field_type {
	BPF_SPIN_LOCK = 1,
	BPF_TIMER = 2,
	BPF_KPTR_UNREF = 4,
	BPF_KPTR_REF = 8,
	BPF_KPTR_PERCPU = 16,
	BPF_KPTR = 28,
	BPF_LIST_HEAD = 32,
	BPF_LIST_NODE = 64,
	BPF_RB_ROOT = 128,
	BPF_RB_NODE = 256,
	BPF_GRAPH_NODE = 320,
	BPF_GRAPH_ROOT = 160,
	BPF_REFCOUNT = 512,
	BPF_WORKQUEUE = 1024,
	BPF_UPTR = 2048,
	BPF_RES_SPIN_LOCK = 4096,
};

enum btf_func_linkage {
	BTF_FUNC_STATIC = 0,
	BTF_FUNC_GLOBAL = 1,
	BTF_FUNC_EXTERN = 2,
};

enum btf_kfunc_hook {
	BTF_KFUNC_HOOK_COMMON = 0,
	BTF_KFUNC_HOOK_XDP = 1,
	BTF_KFUNC_HOOK_TC = 2,
	BTF_KFUNC_HOOK_STRUCT_OPS = 3,
	BTF_KFUNC_HOOK_TRACING = 4,
	BTF_KFUNC_HOOK_SYSCALL = 5,
	BTF_KFUNC_HOOK_FMODRET = 6,
	BTF_KFUNC_HOOK_CGROUP = 7,
	BTF_KFUNC_HOOK_SCHED_ACT = 8,
	BTF_KFUNC_HOOK_SK_SKB = 9,
	BTF_KFUNC_HOOK_SOCKET_FILTER = 10,
	BTF_KFUNC_HOOK_LWT = 11,
	BTF_KFUNC_HOOK_NETFILTER = 12,
	BTF_KFUNC_HOOK_KPROBE = 13,
	BTF_KFUNC_HOOK_MAX = 14,
};

enum bug_trap_type {
	BUG_TRAP_TYPE_NONE = 0,
	BUG_TRAP_TYPE_WARN = 1,
	BUG_TRAP_TYPE_BUG = 2,
};

enum bus_notifier_event {
	BUS_NOTIFY_ADD_DEVICE = 0,
	BUS_NOTIFY_DEL_DEVICE = 1,
	BUS_NOTIFY_REMOVED_DEVICE = 2,
	BUS_NOTIFY_BIND_DRIVER = 3,
	BUS_NOTIFY_BOUND_DRIVER = 4,
	BUS_NOTIFY_UNBIND_DRIVER = 5,
	BUS_NOTIFY_UNBOUND_DRIVER = 6,
	BUS_NOTIFY_DRIVER_NOT_BOUND = 7,
};

enum cache_indexing {
	NODE_CACHE_DIRECT_MAP = 0,
	NODE_CACHE_INDEXED = 1,
	NODE_CACHE_OTHER = 2,
};

enum cache_mode {
	NODE_CACHE_ADDR_MODE_RESERVED = 0,
	NODE_CACHE_ADDR_MODE_EXTENDED_LINEAR = 1,
};

enum cache_tag_type {
	CACHE_TAG_IOTLB = 0,
	CACHE_TAG_DEVTLB = 1,
	CACHE_TAG_NESTING_IOTLB = 2,
	CACHE_TAG_NESTING_DEVTLB = 3,
};

enum cache_type {
	CACHE_TYPE_NOCACHE = 0,
	CACHE_TYPE_INST = 1,
	CACHE_TYPE_DATA = 2,
	CACHE_TYPE_SEPARATE = 3,
	CACHE_TYPE_UNIFIED = 4,
};

enum cache_write_policy {
	NODE_CACHE_WRITE_BACK = 0,
	NODE_CACHE_WRITE_THROUGH = 1,
	NODE_CACHE_WRITE_OTHER = 2,
};

enum cc_attr {
	CC_ATTR_MEM_ENCRYPT = 0,
	CC_ATTR_HOST_MEM_ENCRYPT = 1,
	CC_ATTR_GUEST_MEM_ENCRYPT = 2,
	CC_ATTR_GUEST_STATE_ENCRYPT = 3,
	CC_ATTR_GUEST_UNROLL_STRING_IO = 4,
	CC_ATTR_GUEST_SEV_SNP = 5,
	CC_ATTR_GUEST_SNP_SECURE_TSC = 6,
	CC_ATTR_HOST_SEV_SNP = 7,
};

enum cc_vendor {
	CC_VENDOR_NONE = 0,
	CC_VENDOR_AMD = 1,
	CC_VENDOR_INTEL = 2,
};

enum cee_attrs {
	DCB_ATTR_CEE_UNSPEC = 0,
	DCB_ATTR_CEE_PEER_PG = 1,
	DCB_ATTR_CEE_PEER_PFC = 2,
	DCB_ATTR_CEE_PEER_APP_TABLE = 3,
	DCB_ATTR_CEE_TX_PG = 4,
	DCB_ATTR_CEE_RX_PG = 5,
	DCB_ATTR_CEE_PFC = 6,
	DCB_ATTR_CEE_APP_TABLE = 7,
	DCB_ATTR_CEE_FEAT = 8,
	__DCB_ATTR_CEE_MAX = 9,
};

enum cfg80211_signal_type {
	CFG80211_SIGNAL_TYPE_NONE = 0,
	CFG80211_SIGNAL_TYPE_MBM = 1,
	CFG80211_SIGNAL_TYPE_UNSPEC = 2,
};

enum cfi_mode {
	CFI_AUTO = 0,
	CFI_OFF = 1,
	CFI_KCFI = 2,
	CFI_FINEIBT = 3,
};

enum cgroup1_param {
	Opt_all = 0,
	Opt_clone_children = 1,
	Opt_cpuset_v2_mode = 2,
	Opt_name = 3,
	Opt_none = 4,
	Opt_noprefix = 5,
	Opt_release_agent = 6,
	Opt_xattr = 7,
	Opt_favordynmods = 8,
	Opt_nofavordynmods = 9,
};

enum cgroup2_param {
	Opt_nsdelegate = 0,
	Opt_favordynmods___2 = 1,
	Opt_memory_localevents = 2,
	Opt_memory_recursiveprot = 3,
	Opt_memory_hugetlb_accounting = 4,
	Opt_pids_localevents = 5,
	nr__cgroup2_params = 6,
};

enum cgroup_bpf_attach_type {
	CGROUP_BPF_ATTACH_TYPE_INVALID = -1,
	CGROUP_INET_INGRESS = 0,
	CGROUP_INET_EGRESS = 1,
	CGROUP_INET_SOCK_CREATE = 2,
	CGROUP_SOCK_OPS = 3,
	CGROUP_DEVICE = 4,
	CGROUP_INET4_BIND = 5,
	CGROUP_INET6_BIND = 6,
	CGROUP_INET4_CONNECT = 7,
	CGROUP_INET6_CONNECT = 8,
	CGROUP_UNIX_CONNECT = 9,
	CGROUP_INET4_POST_BIND = 10,
	CGROUP_INET6_POST_BIND = 11,
	CGROUP_UDP4_SENDMSG = 12,
	CGROUP_UDP6_SENDMSG = 13,
	CGROUP_UNIX_SENDMSG = 14,
	CGROUP_SYSCTL = 15,
	CGROUP_UDP4_RECVMSG = 16,
	CGROUP_UDP6_RECVMSG = 17,
	CGROUP_UNIX_RECVMSG = 18,
	CGROUP_GETSOCKOPT = 19,
	CGROUP_SETSOCKOPT = 20,
	CGROUP_INET4_GETPEERNAME = 21,
	CGROUP_INET6_GETPEERNAME = 22,
	CGROUP_UNIX_GETPEERNAME = 23,
	CGROUP_INET4_GETSOCKNAME = 24,
	CGROUP_INET6_GETSOCKNAME = 25,
	CGROUP_UNIX_GETSOCKNAME = 26,
	CGROUP_INET_SOCK_RELEASE = 27,
	CGROUP_LSM_START = 28,
	CGROUP_LSM_END = 37,
	MAX_CGROUP_BPF_ATTACH_TYPE = 38,
};

enum cgroup_filetype {
	CGROUP_FILE_PROCS = 0,
	CGROUP_FILE_TASKS = 1,
};

enum cgroup_lifetime_events {
	CGROUP_LIFETIME_ONLINE = 0,
	CGROUP_LIFETIME_OFFLINE = 1,
};

enum cgroup_opt_features {
	OPT_FEATURE_PRESSURE = 0,
	OPT_FEATURE_COUNT = 1,
};

enum cgroup_subsys_id {
	cpuset_cgrp_id = 0,
	cpu_cgrp_id = 1,
	cpuacct_cgrp_id = 2,
	io_cgrp_id = 3,
	memory_cgrp_id = 4,
	devices_cgrp_id = 5,
	freezer_cgrp_id = 6,
	net_cls_cgrp_id = 7,
	perf_event_cgrp_id = 8,
	net_prio_cgrp_id = 9,
	hugetlb_cgrp_id = 10,
	pids_cgrp_id = 11,
	rdma_cgrp_id = 12,
	misc_cgrp_id = 13,
	dmem_cgrp_id = 14,
	CGROUP_SUBSYS_COUNT = 15,
};

enum chacha20poly1305_lengths {
	XCHACHA20POLY1305_NONCE_SIZE = 24,
	CHACHA20POLY1305_KEY_SIZE = 32,
	CHACHA20POLY1305_AUTHTAG_SIZE = 16,
};

enum chacha_constants {
	CHACHA_CONSTANT_EXPA = 1634760805,
	CHACHA_CONSTANT_ND_3 = 857760878,
	CHACHA_CONSTANT_2_BY = 2036477234,
	CHACHA_CONSTANT_TE_K = 1797285236,
};

enum chipset_type {
	NOT_SUPPORTED = 0,
	SUPPORTED = 1,
};

enum class_map_type {
	DD_CLASS_TYPE_DISJOINT_BITS = 0,
	DD_CLASS_TYPE_LEVEL_NUM = 1,
	DD_CLASS_TYPE_DISJOINT_NAMES = 2,
	DD_CLASS_TYPE_LEVEL_NAMES = 3,
};

enum class_stat_type {
	ZS_OBJS_ALLOCATED = 12,
	ZS_OBJS_INUSE = 13,
	NR_CLASS_STAT_TYPES = 14,
};

enum cleanup_prefix_rt_t {
	CLEANUP_PREFIX_RT_NOP = 0,
	CLEANUP_PREFIX_RT_DEL = 1,
	CLEANUP_PREFIX_RT_EXPIRE = 2,
};

enum clear_refs_types {
	CLEAR_REFS_ALL = 1,
	CLEAR_REFS_ANON = 2,
	CLEAR_REFS_MAPPED = 3,
	CLEAR_REFS_SOFT_DIRTY = 4,
	CLEAR_REFS_MM_HIWATER_RSS = 5,
	CLEAR_REFS_LAST = 6,
};

enum clock_event_state {
	CLOCK_EVT_STATE_DETACHED = 0,
	CLOCK_EVT_STATE_SHUTDOWN = 1,
	CLOCK_EVT_STATE_PERIODIC = 2,
	CLOCK_EVT_STATE_ONESHOT = 3,
	CLOCK_EVT_STATE_ONESHOT_STOPPED = 4,
};

enum clocksource_ids {
	CSID_GENERIC = 0,
	CSID_ARM_ARCH_COUNTER = 1,
	CSID_S390_TOD = 2,
	CSID_X86_TSC_EARLY = 3,
	CSID_X86_TSC = 4,
	CSID_X86_KVM_CLK = 5,
	CSID_X86_ART = 6,
	CSID_MAX = 7,
};

enum closure_state {
	CLOSURE_BITS_START = 67108864,
	CLOSURE_DESTRUCTOR = 67108864,
	CLOSURE_WAITING = 268435456,
	CLOSURE_RUNNING = 1073741824,
};

enum cma_flags {
	CMA_RESERVE_PAGES_ON_ERROR = 0,
	CMA_ZONES_VALID = 1,
	CMA_ZONES_INVALID = 2,
	CMA_ACTIVATED = 3,
};

enum cmis_cdb_fw_write_mechanism {
	CMIS_CDB_FW_WRITE_MECHANISM_NONE = 0,
	CMIS_CDB_FW_WRITE_MECHANISM_LPL = 1,
	CMIS_CDB_FW_WRITE_MECHANISM_EPL = 16,
	CMIS_CDB_FW_WRITE_MECHANISM_BOTH = 17,
};

enum compact_priority {
	COMPACT_PRIO_SYNC_FULL = 0,
	MIN_COMPACT_PRIORITY = 0,
	COMPACT_PRIO_SYNC_LIGHT = 1,
	MIN_COMPACT_COSTLY_PRIORITY = 1,
	DEF_COMPACT_PRIORITY = 1,
	COMPACT_PRIO_ASYNC = 2,
	INIT_COMPACT_PRIORITY = 2,
};

enum compact_result {
	COMPACT_NOT_SUITABLE_ZONE = 0,
	COMPACT_SKIPPED = 1,
	COMPACT_DEFERRED = 2,
	COMPACT_NO_SUITABLE_PAGE = 3,
	COMPACT_CONTINUE = 4,
	COMPACT_COMPLETE = 5,
	COMPACT_PARTIAL_SKIPPED = 6,
	COMPACT_CONTENDED = 7,
	COMPACT_SUCCESS = 8,
};

enum con_flush_mode {
	CONSOLE_FLUSH_PENDING = 0,
	CONSOLE_REPLAY_ALL = 1,
};

enum con_msg_format_flags {
	MSG_FORMAT_DEFAULT = 0,
	MSG_FORMAT_SYSLOG = 1,
};

enum con_scroll {
	SM_UP = 0,
	SM_DOWN = 1,
};

enum cons_flags {
	CON_PRINTBUFFER = 1,
	CON_CONSDEV = 2,
	CON_ENABLED = 4,
	CON_BOOT = 8,
	CON_ANYTIME = 16,
	CON_BRL = 32,
	CON_EXTENDED = 64,
	CON_SUSPENDED = 128,
	CON_NBCON = 256,
};

enum context {
	IN_KERNEL = 1,
	IN_USER = 2,
	IN_KERNEL_RECOV = 3,
};

enum coredump_mark {
	COREDUMP_MARK_REQACK = 0,
	COREDUMP_MARK_MINSIZE = 1,
	COREDUMP_MARK_MAXSIZE = 2,
	COREDUMP_MARK_UNSUPPORTED = 3,
	COREDUMP_MARK_CONFLICTING = 4,
	__COREDUMP_MARK_MAX = 2147483648,
};

enum coredump_type_t {
	COREDUMP_FILE = 1,
	COREDUMP_PIPE = 2,
	COREDUMP_SOCK = 3,
	COREDUMP_SOCK_REQ = 4,
};

enum cp_error_code {
	CP_EC = 32767,
	CP_RET = 1,
	CP_IRET = 2,
	CP_ENDBR = 3,
	CP_RSTRORSSP = 4,
	CP_SETSSBSY = 5,
	CP_ENCL = 32768,
};

enum cpa_warn {
	CPA_CONFLICT = 0,
	CPA_PROTECT = 1,
	CPA_DETECT = 2,
};

enum cpio_fields {
	C_MAGIC = 0,
	C_INO = 1,
	C_MODE = 2,
	C_UID = 3,
	C_GID = 4,
	C_NLINK = 5,
	C_MTIME = 6,
	C_FILESIZE = 7,
	C_MAJ = 8,
	C_MIN = 9,
	C_RMAJ = 10,
	C_RMIN = 11,
	C_NAMESIZE = 12,
	C_CHKSUM = 13,
	C_NFIELDS = 14,
};

enum cppc_regs {
	HIGHEST_PERF = 0,
	NOMINAL_PERF = 1,
	LOW_NON_LINEAR_PERF = 2,
	LOWEST_PERF = 3,
	GUARANTEED_PERF = 4,
	DESIRED_PERF = 5,
	MIN_PERF = 6,
	MAX_PERF = 7,
	PERF_REDUC_TOLERANCE = 8,
	TIME_WINDOW = 9,
	CTR_WRAP_TIME = 10,
	REFERENCE_CTR = 11,
	DELIVERED_CTR = 12,
	PERF_LIMITED = 13,
	ENABLE = 14,
	AUTO_SEL_ENABLE = 15,
	AUTO_ACT_WINDOW = 16,
	ENERGY_PERF = 17,
	REFERENCE_PERF = 18,
	LOWEST_FREQ = 19,
	NOMINAL_FREQ = 20,
};

enum cpu_attack_vectors {
	CPU_MITIGATE_USER_KERNEL = 0,
	CPU_MITIGATE_USER_USER = 1,
	CPU_MITIGATE_GUEST_HOST = 2,
	CPU_MITIGATE_GUEST_GUEST = 3,
	NR_CPU_ATTACK_VECTORS = 4,
};

enum cpu_idle_type {
	__CPU_NOT_IDLE = 0,
	CPU_IDLE = 1,
	CPU_NEWLY_IDLE = 2,
	CPU_MAX_IDLE_TYPES = 3,
};

enum cpu_led_event {
	CPU_LED_IDLE_START = 0,
	CPU_LED_IDLE_END = 1,
	CPU_LED_START = 2,
	CPU_LED_STOP = 3,
	CPU_LED_HALTED = 4,
};

enum cpu_mitigations {
	CPU_MITIGATIONS_OFF = 0,
	CPU_MITIGATIONS_AUTO = 1,
	CPU_MITIGATIONS_AUTO_NOSMT = 2,
};

enum cpu_usage_stat {
	CPUTIME_USER = 0,
	CPUTIME_NICE = 1,
	CPUTIME_SYSTEM = 2,
	CPUTIME_SOFTIRQ = 3,
	CPUTIME_IRQ = 4,
	CPUTIME_IDLE = 5,
	CPUTIME_IOWAIT = 6,
	CPUTIME_STEAL = 7,
	CPUTIME_GUEST = 8,
	CPUTIME_GUEST_NICE = 9,
	CPUTIME_FORCEIDLE = 10,
	NR_STATS = 11,
};

enum cpuacct_stat_index {
	CPUACCT_STAT_USER = 0,
	CPUACCT_STAT_SYSTEM = 1,
	CPUACCT_STAT_NSTATS = 2,
};

enum cpufreq_table_sorting {
	CPUFREQ_TABLE_UNSORTED = 0,
	CPUFREQ_TABLE_SORTED_ASCENDING = 1,
	CPUFREQ_TABLE_SORTED_DESCENDING = 2,
};

enum cpuhp_smt_control {
	CPU_SMT_ENABLED = 0,
	CPU_SMT_DISABLED = 1,
	CPU_SMT_FORCE_DISABLED = 2,
	CPU_SMT_NOT_SUPPORTED = 3,
	CPU_SMT_NOT_IMPLEMENTED = 4,
};

enum cpuhp_state {
	CPUHP_INVALID = -1,
	CPUHP_OFFLINE = 0,
	CPUHP_CREATE_THREADS = 1,
	CPUHP_PERF_X86_PREPARE = 2,
	CPUHP_PERF_X86_AMD_UNCORE_PREP = 3,
	CPUHP_PERF_POWER = 4,
	CPUHP_PERF_SUPERH = 5,
	CPUHP_X86_HPET_DEAD = 6,
	CPUHP_X86_MCE_DEAD = 7,
	CPUHP_VIRT_NET_DEAD = 8,
	CPUHP_IBMVNIC_DEAD = 9,
	CPUHP_SLUB_DEAD = 10,
	CPUHP_DEBUG_OBJ_DEAD = 11,
	CPUHP_MM_WRITEBACK_DEAD = 12,
	CPUHP_MM_VMSTAT_DEAD = 13,
	CPUHP_SOFTIRQ_DEAD = 14,
	CPUHP_NET_MVNETA_DEAD = 15,
	CPUHP_CPUIDLE_DEAD = 16,
	CPUHP_ARM64_FPSIMD_DEAD = 17,
	CPUHP_ARM_OMAP_WAKE_DEAD = 18,
	CPUHP_IRQ_POLL_DEAD = 19,
	CPUHP_BLOCK_SOFTIRQ_DEAD = 20,
	CPUHP_BIO_DEAD = 21,
	CPUHP_ACPI_CPUDRV_DEAD = 22,
	CPUHP_S390_PFAULT_DEAD = 23,
	CPUHP_BLK_MQ_DEAD = 24,
	CPUHP_FS_BUFF_DEAD = 25,
	CPUHP_PRINTK_DEAD = 26,
	CPUHP_MM_MEMCQ_DEAD = 27,
	CPUHP_PERCPU_CNT_DEAD = 28,
	CPUHP_RADIX_DEAD = 29,
	CPUHP_PAGE_ALLOC = 30,
	CPUHP_NET_DEV_DEAD = 31,
	CPUHP_IOMMU_IOVA_DEAD = 32,
	CPUHP_AP_ARM_CACHE_B15_RAC_DEAD = 33,
	CPUHP_PADATA_DEAD = 34,
	CPUHP_AP_DTPM_CPU_DEAD = 35,
	CPUHP_RANDOM_PREPARE = 36,
	CPUHP_WORKQUEUE_PREP = 37,
	CPUHP_POWER_NUMA_PREPARE = 38,
	CPUHP_HRTIMERS_PREPARE = 39,
	CPUHP_X2APIC_PREPARE = 40,
	CPUHP_SMPCFD_PREPARE = 41,
	CPUHP_RELAY_PREPARE = 42,
	CPUHP_MD_RAID5_PREPARE = 43,
	CPUHP_RCUTREE_PREP = 44,
	CPUHP_CPUIDLE_COUPLED_PREPARE = 45,
	CPUHP_POWERPC_PMAC_PREPARE = 46,
	CPUHP_POWERPC_MMU_CTX_PREPARE = 47,
	CPUHP_XEN_PREPARE = 48,
	CPUHP_XEN_EVTCHN_PREPARE = 49,
	CPUHP_ARM_SHMOBILE_SCU_PREPARE = 50,
	CPUHP_SH_SH3X_PREPARE = 51,
	CPUHP_TOPOLOGY_PREPARE = 52,
	CPUHP_NET_IUCV_PREPARE = 53,
	CPUHP_ARM_BL_PREPARE = 54,
	CPUHP_TRACE_RB_PREPARE = 55,
	CPUHP_MM_ZSWP_POOL_PREPARE = 56,
	CPUHP_KVM_PPC_BOOK3S_PREPARE = 57,
	CPUHP_ZCOMP_PREPARE = 58,
	CPUHP_TIMERS_PREPARE = 59,
	CPUHP_TMIGR_PREPARE = 60,
	CPUHP_MIPS_SOC_PREPARE = 61,
	CPUHP_BP_PREPARE_DYN = 62,
	CPUHP_BP_PREPARE_DYN_END = 82,
	CPUHP_BP_KICK_AP = 83,
	CPUHP_BRINGUP_CPU = 84,
	CPUHP_AP_IDLE_DEAD = 85,
	CPUHP_AP_OFFLINE = 86,
	CPUHP_AP_CACHECTRL_STARTING = 87,
	CPUHP_AP_SCHED_STARTING = 88,
	CPUHP_AP_RCUTREE_DYING = 89,
	CPUHP_AP_CPU_PM_STARTING = 90,
	CPUHP_AP_IRQ_GIC_STARTING = 91,
	CPUHP_AP_IRQ_HIP04_STARTING = 92,
	CPUHP_AP_IRQ_APPLE_AIC_STARTING = 93,
	CPUHP_AP_IRQ_ARMADA_XP_STARTING = 94,
	CPUHP_AP_IRQ_BCM2836_STARTING = 95,
	CPUHP_AP_IRQ_MIPS_GIC_STARTING = 96,
	CPUHP_AP_IRQ_EIOINTC_STARTING = 97,
	CPUHP_AP_IRQ_AVECINTC_STARTING = 98,
	CPUHP_AP_IRQ_SIFIVE_PLIC_STARTING = 99,
	CPUHP_AP_IRQ_ACLINT_SSWI_STARTING = 100,
	CPUHP_AP_IRQ_RISCV_IMSIC_STARTING = 101,
	CPUHP_AP_IRQ_RISCV_SBI_IPI_STARTING = 102,
	CPUHP_AP_ARM_MVEBU_COHERENCY = 103,
	CPUHP_AP_PERF_X86_AMD_UNCORE_STARTING = 104,
	CPUHP_AP_PERF_X86_STARTING = 105,
	CPUHP_AP_PERF_X86_AMD_IBS_STARTING = 106,
	CPUHP_AP_PERF_XTENSA_STARTING = 107,
	CPUHP_AP_ARM_VFP_STARTING = 108,
	CPUHP_AP_ARM64_DEBUG_MONITORS_STARTING = 109,
	CPUHP_AP_PERF_ARM_HW_BREAKPOINT_STARTING = 110,
	CPUHP_AP_PERF_ARM_ACPI_STARTING = 111,
	CPUHP_AP_PERF_ARM_STARTING = 112,
	CPUHP_AP_PERF_RISCV_STARTING = 113,
	CPUHP_AP_ARM_L2X0_STARTING = 114,
	CPUHP_AP_EXYNOS4_MCT_TIMER_STARTING = 115,
	CPUHP_AP_ARM_ARCH_TIMER_STARTING = 116,
	CPUHP_AP_ARM_ARCH_TIMER_EVTSTRM_STARTING = 117,
	CPUHP_AP_ARM_GLOBAL_TIMER_STARTING = 118,
	CPUHP_AP_JCORE_TIMER_STARTING = 119,
	CPUHP_AP_ARM_TWD_STARTING = 120,
	CPUHP_AP_QCOM_TIMER_STARTING = 121,
	CPUHP_AP_TEGRA_TIMER_STARTING = 122,
	CPUHP_AP_ARMADA_TIMER_STARTING = 123,
	CPUHP_AP_LOONGARCH_ARCH_TIMER_STARTING = 124,
	CPUHP_AP_MIPS_GIC_TIMER_STARTING = 125,
	CPUHP_AP_ARC_TIMER_STARTING = 126,
	CPUHP_AP_REALTEK_TIMER_STARTING = 127,
	CPUHP_AP_RISCV_TIMER_STARTING = 128,
	CPUHP_AP_CLINT_TIMER_STARTING = 129,
	CPUHP_AP_CSKY_TIMER_STARTING = 130,
	CPUHP_AP_TI_GP_TIMER_STARTING = 131,
	CPUHP_AP_HYPERV_TIMER_STARTING = 132,
	CPUHP_AP_DUMMY_TIMER_STARTING = 133,
	CPUHP_AP_ARM_XEN_STARTING = 134,
	CPUHP_AP_ARM_XEN_RUNSTATE_STARTING = 135,
	CPUHP_AP_ARM_CORESIGHT_STARTING = 136,
	CPUHP_AP_ARM_CORESIGHT_CTI_STARTING = 137,
	CPUHP_AP_ARM64_ISNDEP_STARTING = 138,
	CPUHP_AP_SMPCFD_DYING = 139,
	CPUHP_AP_HRTIMERS_DYING = 140,
	CPUHP_AP_TICK_DYING = 141,
	CPUHP_AP_X86_TBOOT_DYING = 142,
	CPUHP_AP_ARM_CACHE_B15_RAC_DYING = 143,
	CPUHP_AP_ONLINE = 144,
	CPUHP_TEARDOWN_CPU = 145,
	CPUHP_AP_ONLINE_IDLE = 146,
	CPUHP_AP_HYPERV_ONLINE = 147,
	CPUHP_AP_KVM_ONLINE = 148,
	CPUHP_AP_SCHED_WAIT_EMPTY = 149,
	CPUHP_AP_SMPBOOT_THREADS = 150,
	CPUHP_AP_IRQ_AFFINITY_ONLINE = 151,
	CPUHP_AP_BLK_MQ_ONLINE = 152,
	CPUHP_AP_ARM_MVEBU_SYNC_CLOCKS = 153,
	CPUHP_AP_X86_INTEL_EPB_ONLINE = 154,
	CPUHP_AP_PERF_ONLINE = 155,
	CPUHP_AP_PERF_X86_ONLINE = 156,
	CPUHP_AP_PERF_X86_UNCORE_ONLINE = 157,
	CPUHP_AP_PERF_X86_AMD_UNCORE_ONLINE = 158,
	CPUHP_AP_PERF_X86_AMD_POWER_ONLINE = 159,
	CPUHP_AP_PERF_S390_CF_ONLINE = 160,
	CPUHP_AP_PERF_S390_SF_ONLINE = 161,
	CPUHP_AP_PERF_ARM_CCI_ONLINE = 162,
	CPUHP_AP_PERF_ARM_CCN_ONLINE = 163,
	CPUHP_AP_PERF_ARM_HISI_CPA_ONLINE = 164,
	CPUHP_AP_PERF_ARM_HISI_DDRC_ONLINE = 165,
	CPUHP_AP_PERF_ARM_HISI_HHA_ONLINE = 166,
	CPUHP_AP_PERF_ARM_HISI_L3_ONLINE = 167,
	CPUHP_AP_PERF_ARM_HISI_PA_ONLINE = 168,
	CPUHP_AP_PERF_ARM_HISI_SLLC_ONLINE = 169,
	CPUHP_AP_PERF_ARM_HISI_PCIE_PMU_ONLINE = 170,
	CPUHP_AP_PERF_ARM_HNS3_PMU_ONLINE = 171,
	CPUHP_AP_PERF_ARM_L2X0_ONLINE = 172,
	CPUHP_AP_PERF_ARM_QCOM_L2_ONLINE = 173,
	CPUHP_AP_PERF_ARM_QCOM_L3_ONLINE = 174,
	CPUHP_AP_PERF_ARM_APM_XGENE_ONLINE = 175,
	CPUHP_AP_PERF_ARM_CAVIUM_TX2_UNCORE_ONLINE = 176,
	CPUHP_AP_PERF_ARM_MARVELL_CN10K_DDR_ONLINE = 177,
	CPUHP_AP_PERF_ARM_MRVL_PEM_ONLINE = 178,
	CPUHP_AP_PERF_POWERPC_NEST_IMC_ONLINE = 179,
	CPUHP_AP_PERF_POWERPC_CORE_IMC_ONLINE = 180,
	CPUHP_AP_PERF_POWERPC_THREAD_IMC_ONLINE = 181,
	CPUHP_AP_PERF_POWERPC_TRACE_IMC_ONLINE = 182,
	CPUHP_AP_PERF_POWERPC_HV_24x7_ONLINE = 183,
	CPUHP_AP_PERF_POWERPC_HV_GPCI_ONLINE = 184,
	CPUHP_AP_PERF_CSKY_ONLINE = 185,
	CPUHP_AP_TMIGR_ONLINE = 186,
	CPUHP_AP_WATCHDOG_ONLINE = 187,
	CPUHP_AP_WORKQUEUE_ONLINE = 188,
	CPUHP_AP_RANDOM_ONLINE = 189,
	CPUHP_AP_RCUTREE_ONLINE = 190,
	CPUHP_AP_KTHREADS_ONLINE = 191,
	CPUHP_AP_BASE_CACHEINFO_ONLINE = 192,
	CPUHP_AP_ONLINE_DYN = 193,
	CPUHP_AP_ONLINE_DYN_END = 233,
	CPUHP_AP_X86_HPET_ONLINE = 234,
	CPUHP_AP_X86_KVM_CLK_ONLINE = 235,
	CPUHP_AP_ACTIVE = 236,
	CPUHP_ONLINE = 237,
};

enum cpuhp_sync_state {
	SYNC_STATE_DEAD = 0,
	SYNC_STATE_KICKED = 1,
	SYNC_STATE_SHOULD_DIE = 2,
	SYNC_STATE_ALIVE = 3,
	SYNC_STATE_SHOULD_ONLINE = 4,
	SYNC_STATE_ONLINE = 5,
};

enum cpuid_leafs {
	CPUID_1_EDX = 0,
	CPUID_8000_0001_EDX = 1,
	CPUID_8086_0001_EDX = 2,
	CPUID_LNX_1 = 3,
	CPUID_1_ECX = 4,
	CPUID_C000_0001_EDX = 5,
	CPUID_8000_0001_ECX = 6,
	CPUID_LNX_2 = 7,
	CPUID_LNX_3 = 8,
	CPUID_7_0_EBX = 9,
	CPUID_D_1_EAX = 10,
	CPUID_LNX_4 = 11,
	CPUID_7_1_EAX = 12,
	CPUID_8000_0008_EBX = 13,
	CPUID_6_EAX = 14,
	CPUID_8000_000A_EDX = 15,
	CPUID_7_ECX = 16,
	CPUID_8000_0007_EBX = 17,
	CPUID_7_EDX = 18,
	CPUID_8000_001F_EAX = 19,
	CPUID_8000_0021_EAX = 20,
	CPUID_LNX_5 = 21,
	NR_CPUID_WORDS = 22,
};

enum cpuid_regs_idx {
	CPUID_EAX = 0,
	CPUID_EBX = 1,
	CPUID_ECX = 2,
	CPUID_EDX = 3,
};

enum crb_cancel {
	CRB_CANCEL_INVOKE = 1,
};

enum crb_ctrl_req {
	CRB_CTRL_REQ_CMD_READY = 1,
	CRB_CTRL_REQ_GO_IDLE = 2,
};

enum crb_ctrl_sts {
	CRB_CTRL_STS_ERROR = 1,
	CRB_CTRL_STS_TPM_IDLE = 2,
};

enum crb_defaults {
	CRB_ACPI_START_REVISION_ID = 1,
	CRB_ACPI_START_INDEX = 1,
};

enum crb_loc_ctrl {
	CRB_LOC_CTRL_REQUEST_ACCESS = 1,
	CRB_LOC_CTRL_RELINQUISH = 2,
};

enum crb_loc_state {
	CRB_LOC_STATE_LOC_ASSIGNED = 2,
	CRB_LOC_STATE_TPM_REG_VALID_STS = 128,
};

enum crb_start {
	CRB_START_INVOKE = 1,
};

enum crb_status {
	CRB_DRV_STS_COMPLETE = 1,
};

enum crypto_attr_type_t {
	CRYPTOCFGA_UNSPEC = 0,
	CRYPTOCFGA_PRIORITY_VAL = 1,
	CRYPTOCFGA_REPORT_LARVAL = 2,
	CRYPTOCFGA_REPORT_HASH = 3,
	CRYPTOCFGA_REPORT_BLKCIPHER = 4,
	CRYPTOCFGA_REPORT_AEAD = 5,
	CRYPTOCFGA_REPORT_COMPRESS = 6,
	CRYPTOCFGA_REPORT_RNG = 7,
	CRYPTOCFGA_REPORT_CIPHER = 8,
	CRYPTOCFGA_REPORT_AKCIPHER = 9,
	CRYPTOCFGA_REPORT_KPP = 10,
	CRYPTOCFGA_REPORT_ACOMP = 11,
	CRYPTOCFGA_STAT_LARVAL = 12,
	CRYPTOCFGA_STAT_HASH = 13,
	CRYPTOCFGA_STAT_BLKCIPHER = 14,
	CRYPTOCFGA_STAT_AEAD = 15,
	CRYPTOCFGA_STAT_COMPRESS = 16,
	CRYPTOCFGA_STAT_RNG = 17,
	CRYPTOCFGA_STAT_CIPHER = 18,
	CRYPTOCFGA_STAT_AKCIPHER = 19,
	CRYPTOCFGA_STAT_KPP = 20,
	CRYPTOCFGA_STAT_ACOMP = 21,
	CRYPTOCFGA_REPORT_SIG = 22,
	__CRYPTOCFGA_MAX = 23,
};

enum css_task_iter_flags {
	CSS_TASK_ITER_PROCS = 1,
	CSS_TASK_ITER_THREADED = 2,
	CSS_TASK_ITER_SKIPPED = 65536,
};

enum ctrl_offsets {
	BASE_OFFSET = 0,
	SLOT_AVAIL1 = 4,
	SLOT_AVAIL2 = 8,
	SLOT_CONFIG = 12,
	SEC_BUS_CONFIG = 16,
	MSI_CTRL = 18,
	PROG_INTERFACE = 19,
	CMD = 20,
	CMD_STATUS = 22,
	INTR_LOC = 24,
	SERR_LOC = 28,
	SERR_INTR_ENABLE = 32,
	SLOT1 = 36,
};

enum ctrl_register {
	CTRL_IN = 0,
	CTRL_OUT = 1,
};

enum ctx_state {
	CT_STATE_DISABLED = -1,
	CT_STATE_KERNEL = 0,
	CT_STATE_IDLE = 1,
	CT_STATE_USER = 2,
	CT_STATE_GUEST = 3,
	CT_STATE_MAX = 4,
};

enum cxl_event_type {
	CXL_CPER_EVENT_GENERIC = 0,
	CXL_CPER_EVENT_GEN_MEDIA = 1,
	CXL_CPER_EVENT_DRAM = 2,
	CXL_CPER_EVENT_MEM_MODULE = 3,
	CXL_CPER_EVENT_MEM_SPARING = 4,
};

enum d_real_type {
	D_REAL_DATA = 0,
	D_REAL_METADATA = 1,
};

enum d_walk_ret {
	D_WALK_CONTINUE = 0,
	D_WALK_QUIT = 1,
	D_WALK_NORETRY = 2,
	D_WALK_SKIP = 3,
};

enum da9052_chip_id {
	DA9052 = 0,
	DA9053_AA = 1,
	DA9053_BA = 2,
	DA9053_BB = 3,
	DA9053_BC = 4,
};

enum damon_ops_id {
	DAMON_OPS_VADDR = 0,
	DAMON_OPS_FVADDR = 1,
	DAMON_OPS_PADDR = 2,
	NR_DAMON_OPS = 3,
};

enum damon_sysfs_cmd {
	DAMON_SYSFS_CMD_ON = 0,
	DAMON_SYSFS_CMD_OFF = 1,
	DAMON_SYSFS_CMD_COMMIT = 2,
	DAMON_SYSFS_CMD_COMMIT_SCHEMES_QUOTA_GOALS = 3,
	DAMON_SYSFS_CMD_UPDATE_SCHEMES_STATS = 4,
	DAMON_SYSFS_CMD_UPDATE_SCHEMES_TRIED_BYTES = 5,
	DAMON_SYSFS_CMD_UPDATE_SCHEMES_TRIED_REGIONS = 6,
	DAMON_SYSFS_CMD_CLEAR_SCHEMES_TRIED_REGIONS = 7,
	DAMON_SYSFS_CMD_UPDATE_SCHEMES_EFFECTIVE_QUOTAS = 8,
	DAMON_SYSFS_CMD_UPDATE_TUNED_INTERVALS = 9,
	NR_DAMON_SYSFS_CMDS = 10,
};

enum damos_action {
	DAMOS_WILLNEED = 0,
	DAMOS_COLD = 1,
	DAMOS_PAGEOUT = 2,
	DAMOS_HUGEPAGE = 3,
	DAMOS_NOHUGEPAGE = 4,
	DAMOS_LRU_PRIO = 5,
	DAMOS_LRU_DEPRIO = 6,
	DAMOS_MIGRATE_HOT = 7,
	DAMOS_MIGRATE_COLD = 8,
	DAMOS_STAT = 9,
	NR_DAMOS_ACTIONS = 10,
};

enum damos_filter_type {
	DAMOS_FILTER_TYPE_ANON = 0,
	DAMOS_FILTER_TYPE_ACTIVE = 1,
	DAMOS_FILTER_TYPE_MEMCG = 2,
	DAMOS_FILTER_TYPE_YOUNG = 3,
	DAMOS_FILTER_TYPE_HUGEPAGE_SIZE = 4,
	DAMOS_FILTER_TYPE_UNMAPPED = 5,
	DAMOS_FILTER_TYPE_ADDR = 6,
	DAMOS_FILTER_TYPE_TARGET = 7,
	NR_DAMOS_FILTER_TYPES = 8,
};

enum damos_quota_goal_metric {
	DAMOS_QUOTA_USER_INPUT = 0,
	DAMOS_QUOTA_SOME_MEM_PSI_US = 1,
	DAMOS_QUOTA_NODE_MEM_USED_BP = 2,
	DAMOS_QUOTA_NODE_MEM_FREE_BP = 3,
	NR_DAMOS_QUOTA_GOAL_METRICS = 4,
};

enum damos_sysfs_filter_handle_layer {
	DAMOS_SYSFS_FILTER_HANDLE_LAYER_CORE = 0,
	DAMOS_SYSFS_FILTER_HANDLE_LAYER_OPS = 1,
	DAMOS_SYSFS_FILTER_HANDLE_LAYER_BOTH = 2,
};

enum damos_wmark_metric {
	DAMOS_WMARK_NONE = 0,
	DAMOS_WMARK_FREE_MEM_RATE = 1,
	NR_DAMOS_WMARK_METRICS = 2,
};

enum data_source {
	CM_BATTERY_PRESENT = 0,
	CM_NO_BATTERY = 1,
	CM_FUEL_GAUGE = 2,
	CM_CHARGER_STAT = 3,
};

enum dax_access_mode {
	DAX_ACCESS = 0,
	DAX_RECOVERY_WRITE = 1,
};

enum dax_device_flags {
	DAXDEV_ALIVE = 0,
	DAXDEV_WRITE_CACHE = 1,
	DAXDEV_SYNC = 2,
	DAXDEV_NOCACHE = 3,
	DAXDEV_NOMC = 4,
};

enum dax_driver_type {
	DAXDRV_KMEM_TYPE = 0,
	DAXDRV_DEVICE_TYPE = 1,
};

enum dax_wake_mode {
	WAKE_ALL = 0,
	WAKE_NEXT = 1,
};

enum dbc_state {
	DS_DISABLED = 0,
	DS_INITIALIZED = 1,
	DS_ENABLED = 2,
	DS_CONNECTED = 3,
	DS_CONFIGURED = 4,
	DS_MAX = 5,
};

enum dbgfs_get_mode {
	DBGFS_GET_ALREADY = 0,
	DBGFS_GET_REGULAR = 1,
	DBGFS_GET_SHORT = 2,
};

enum dcb_general_attr_values {
	DCB_ATTR_VALUE_UNDEFINED = 255,
};

enum dcbevent_notif_type {
	DCB_APP_EVENT = 1,
};

enum dcbnl_app_attrs {
	DCB_APP_ATTR_UNDEFINED = 0,
	DCB_APP_ATTR_IDTYPE = 1,
	DCB_APP_ATTR_ID = 2,
	DCB_APP_ATTR_PRIORITY = 3,
	__DCB_APP_ATTR_ENUM_MAX = 4,
	DCB_APP_ATTR_MAX = 3,
};

enum dcbnl_attrs {
	DCB_ATTR_UNDEFINED = 0,
	DCB_ATTR_IFNAME = 1,
	DCB_ATTR_STATE = 2,
	DCB_ATTR_PFC_STATE = 3,
	DCB_ATTR_PFC_CFG = 4,
	DCB_ATTR_NUM_TC = 5,
	DCB_ATTR_PG_CFG = 6,
	DCB_ATTR_SET_ALL = 7,
	DCB_ATTR_PERM_HWADDR = 8,
	DCB_ATTR_CAP = 9,
	DCB_ATTR_NUMTCS = 10,
	DCB_ATTR_BCN = 11,
	DCB_ATTR_APP = 12,
	DCB_ATTR_IEEE = 13,
	DCB_ATTR_DCBX = 14,
	DCB_ATTR_FEATCFG = 15,
	DCB_ATTR_CEE = 16,
	__DCB_ATTR_ENUM_MAX = 17,
	DCB_ATTR_MAX = 16,
};

enum dcbnl_bcn_attrs {
	DCB_BCN_ATTR_UNDEFINED = 0,
	DCB_BCN_ATTR_RP_0 = 1,
	DCB_BCN_ATTR_RP_1 = 2,
	DCB_BCN_ATTR_RP_2 = 3,
	DCB_BCN_ATTR_RP_3 = 4,
	DCB_BCN_ATTR_RP_4 = 5,
	DCB_BCN_ATTR_RP_5 = 6,
	DCB_BCN_ATTR_RP_6 = 7,
	DCB_BCN_ATTR_RP_7 = 8,
	DCB_BCN_ATTR_RP_ALL = 9,
	DCB_BCN_ATTR_BCNA_0 = 10,
	DCB_BCN_ATTR_BCNA_1 = 11,
	DCB_BCN_ATTR_ALPHA = 12,
	DCB_BCN_ATTR_BETA = 13,
	DCB_BCN_ATTR_GD = 14,
	DCB_BCN_ATTR_GI = 15,
	DCB_BCN_ATTR_TMAX = 16,
	DCB_BCN_ATTR_TD = 17,
	DCB_BCN_ATTR_RMIN = 18,
	DCB_BCN_ATTR_W = 19,
	DCB_BCN_ATTR_RD = 20,
	DCB_BCN_ATTR_RU = 21,
	DCB_BCN_ATTR_WRTT = 22,
	DCB_BCN_ATTR_RI = 23,
	DCB_BCN_ATTR_C = 24,
	DCB_BCN_ATTR_ALL = 25,
	__DCB_BCN_ATTR_ENUM_MAX = 26,
	DCB_BCN_ATTR_MAX = 25,
};

enum dcbnl_cap_attrs {
	DCB_CAP_ATTR_UNDEFINED = 0,
	DCB_CAP_ATTR_ALL = 1,
	DCB_CAP_ATTR_PG = 2,
	DCB_CAP_ATTR_PFC = 3,
	DCB_CAP_ATTR_UP2TC = 4,
	DCB_CAP_ATTR_PG_TCS = 5,
	DCB_CAP_ATTR_PFC_TCS = 6,
	DCB_CAP_ATTR_GSP = 7,
	DCB_CAP_ATTR_BCN = 8,
	DCB_CAP_ATTR_DCBX = 9,
	__DCB_CAP_ATTR_ENUM_MAX = 10,
	DCB_CAP_ATTR_MAX = 9,
};

enum dcbnl_commands {
	DCB_CMD_UNDEFINED = 0,
	DCB_CMD_GSTATE = 1,
	DCB_CMD_SSTATE = 2,
	DCB_CMD_PGTX_GCFG = 3,
	DCB_CMD_PGTX_SCFG = 4,
	DCB_CMD_PGRX_GCFG = 5,
	DCB_CMD_PGRX_SCFG = 6,
	DCB_CMD_PFC_GCFG = 7,
	DCB_CMD_PFC_SCFG = 8,
	DCB_CMD_SET_ALL = 9,
	DCB_CMD_GPERM_HWADDR = 10,
	DCB_CMD_GCAP = 11,
	DCB_CMD_GNUMTCS = 12,
	DCB_CMD_SNUMTCS = 13,
	DCB_CMD_PFC_GSTATE = 14,
	DCB_CMD_PFC_SSTATE = 15,
	DCB_CMD_BCN_GCFG = 16,
	DCB_CMD_BCN_SCFG = 17,
	DCB_CMD_GAPP = 18,
	DCB_CMD_SAPP = 19,
	DCB_CMD_IEEE_SET = 20,
	DCB_CMD_IEEE_GET = 21,
	DCB_CMD_GDCBX = 22,
	DCB_CMD_SDCBX = 23,
	DCB_CMD_GFEATCFG = 24,
	DCB_CMD_SFEATCFG = 25,
	DCB_CMD_CEE_GET = 26,
	DCB_CMD_IEEE_DEL = 27,
	__DCB_CMD_ENUM_MAX = 28,
	DCB_CMD_MAX = 27,
};

enum dcbnl_featcfg_attrs {
	DCB_FEATCFG_ATTR_UNDEFINED = 0,
	DCB_FEATCFG_ATTR_ALL = 1,
	DCB_FEATCFG_ATTR_PG = 2,
	DCB_FEATCFG_ATTR_PFC = 3,
	DCB_FEATCFG_ATTR_APP = 4,
	__DCB_FEATCFG_ATTR_ENUM_MAX = 5,
	DCB_FEATCFG_ATTR_MAX = 4,
};

enum dcbnl_numtcs_attrs {
	DCB_NUMTCS_ATTR_UNDEFINED = 0,
	DCB_NUMTCS_ATTR_ALL = 1,
	DCB_NUMTCS_ATTR_PG = 2,
	DCB_NUMTCS_ATTR_PFC = 3,
	__DCB_NUMTCS_ATTR_ENUM_MAX = 4,
	DCB_NUMTCS_ATTR_MAX = 3,
};

enum dcbnl_pfc_up_attrs {
	DCB_PFC_UP_ATTR_UNDEFINED = 0,
	DCB_PFC_UP_ATTR_0 = 1,
	DCB_PFC_UP_ATTR_1 = 2,
	DCB_PFC_UP_ATTR_2 = 3,
	DCB_PFC_UP_ATTR_3 = 4,
	DCB_PFC_UP_ATTR_4 = 5,
	DCB_PFC_UP_ATTR_5 = 6,
	DCB_PFC_UP_ATTR_6 = 7,
	DCB_PFC_UP_ATTR_7 = 8,
	DCB_PFC_UP_ATTR_ALL = 9,
	__DCB_PFC_UP_ATTR_ENUM_MAX = 10,
	DCB_PFC_UP_ATTR_MAX = 9,
};

enum dcbnl_pg_attrs {
	DCB_PG_ATTR_UNDEFINED = 0,
	DCB_PG_ATTR_TC_0 = 1,
	DCB_PG_ATTR_TC_1 = 2,
	DCB_PG_ATTR_TC_2 = 3,
	DCB_PG_ATTR_TC_3 = 4,
	DCB_PG_ATTR_TC_4 = 5,
	DCB_PG_ATTR_TC_5 = 6,
	DCB_PG_ATTR_TC_6 = 7,
	DCB_PG_ATTR_TC_7 = 8,
	DCB_PG_ATTR_TC_MAX = 9,
	DCB_PG_ATTR_TC_ALL = 10,
	DCB_PG_ATTR_BW_ID_0 = 11,
	DCB_PG_ATTR_BW_ID_1 = 12,
	DCB_PG_ATTR_BW_ID_2 = 13,
	DCB_PG_ATTR_BW_ID_3 = 14,
	DCB_PG_ATTR_BW_ID_4 = 15,
	DCB_PG_ATTR_BW_ID_5 = 16,
	DCB_PG_ATTR_BW_ID_6 = 17,
	DCB_PG_ATTR_BW_ID_7 = 18,
	DCB_PG_ATTR_BW_ID_MAX = 19,
	DCB_PG_ATTR_BW_ID_ALL = 20,
	__DCB_PG_ATTR_ENUM_MAX = 21,
	DCB_PG_ATTR_MAX = 20,
};

enum dcbnl_tc_attrs {
	DCB_TC_ATTR_PARAM_UNDEFINED = 0,
	DCB_TC_ATTR_PARAM_PGID = 1,
	DCB_TC_ATTR_PARAM_UP_MAPPING = 2,
	DCB_TC_ATTR_PARAM_STRICT_PRIO = 3,
	DCB_TC_ATTR_PARAM_BW_PCT = 4,
	DCB_TC_ATTR_PARAM_ALL = 5,
	__DCB_TC_ATTR_PARAM_ENUM_MAX = 6,
	DCB_TC_ATTR_PARAM_MAX = 5,
};

enum dd_data_dir {
	DD_READ = 0,
	DD_WRITE = 1,
};

enum dd_prio {
	DD_RT_PRIO = 0,
	DD_BE_PRIO = 1,
	DD_IDLE_PRIO = 2,
	DD_PRIO_MAX = 2,
};

enum dentry_d_lock_class {
	DENTRY_D_LOCK_NORMAL = 0,
	DENTRY_D_LOCK_NESTED = 1,
};

enum dentry_flags {
	DCACHE_OP_HASH = 1,
	DCACHE_OP_COMPARE = 2,
	DCACHE_OP_REVALIDATE = 4,
	DCACHE_OP_DELETE = 8,
	DCACHE_OP_PRUNE = 16,
	DCACHE_DISCONNECTED = 32,
	DCACHE_REFERENCED = 64,
	DCACHE_DONTCACHE = 128,
	DCACHE_CANT_MOUNT = 256,
	DCACHE_GENOCIDE = 512,
	DCACHE_SHRINK_LIST = 1024,
	DCACHE_OP_WEAK_REVALIDATE = 2048,
	DCACHE_NFSFS_RENAMED = 4096,
	DCACHE_FSNOTIFY_PARENT_WATCHED = 8192,
	DCACHE_DENTRY_KILLED = 16384,
	DCACHE_MOUNTED = 32768,
	DCACHE_NEED_AUTOMOUNT = 65536,
	DCACHE_MANAGE_TRANSIT = 131072,
	DCACHE_LRU_LIST = 262144,
	DCACHE_ENTRY_TYPE = 3670016,
	DCACHE_MISS_TYPE = 0,
	DCACHE_WHITEOUT_TYPE = 524288,
	DCACHE_DIRECTORY_TYPE = 1048576,
	DCACHE_AUTODIR_TYPE = 1572864,
	DCACHE_REGULAR_TYPE = 2097152,
	DCACHE_SPECIAL_TYPE = 2621440,
	DCACHE_SYMLINK_TYPE = 3145728,
	DCACHE_NOKEY_NAME = 4194304,
	DCACHE_OP_REAL = 8388608,
	DCACHE_PAR_LOOKUP = 16777216,
	DCACHE_DENTRY_CURSOR = 33554432,
	DCACHE_NORCU = 67108864,
};

enum depot_counter_id {
	DEPOT_COUNTER_REFD_ALLOCS = 0,
	DEPOT_COUNTER_REFD_FREES = 1,
	DEPOT_COUNTER_REFD_INUSE = 2,
	DEPOT_COUNTER_FREELIST_SIZE = 3,
	DEPOT_COUNTER_PERSIST_COUNT = 4,
	DEPOT_COUNTER_PERSIST_BYTES = 5,
	DEPOT_COUNTER_COUNT = 6,
};

enum desc_state {
	desc_miss = -1,
	desc_reserved = 0,
	desc_committed = 1,
	desc_finalized = 2,
	desc_reusable = 3,
};

enum dev_dma_attr {
	DEV_DMA_NOT_SUPPORTED = 0,
	DEV_DMA_NON_COHERENT = 1,
	DEV_DMA_COHERENT = 2,
};

enum dev_pm_opp_event {
	OPP_EVENT_ADD = 0,
	OPP_EVENT_REMOVE = 1,
	OPP_EVENT_ENABLE = 2,
	OPP_EVENT_DISABLE = 3,
	OPP_EVENT_ADJUST_VOLTAGE = 4,
};

enum dev_pm_qos_req_type {
	DEV_PM_QOS_RESUME_LATENCY = 1,
	DEV_PM_QOS_LATENCY_TOLERANCE = 2,
	DEV_PM_QOS_MIN_FREQUENCY = 3,
	DEV_PM_QOS_MAX_FREQUENCY = 4,
	DEV_PM_QOS_FLAGS = 5,
};

enum dev_prop_type {
	DEV_PROP_U8 = 0,
	DEV_PROP_U16 = 1,
	DEV_PROP_U32 = 2,
	DEV_PROP_U64 = 3,
	DEV_PROP_STRING = 4,
	DEV_PROP_REF = 5,
};

enum dev_type {
	DEV_UNKNOWN = 0,
	DEV_X1 = 1,
	DEV_X2 = 2,
	DEV_X4 = 3,
	DEV_X8 = 4,
	DEV_X16 = 5,
	DEV_X32 = 6,
	DEV_X64 = 7,
};

enum devcg_behavior {
	DEVCG_DEFAULT_NONE = 0,
	DEVCG_DEFAULT_ALLOW = 1,
	DEVCG_DEFAULT_DENY = 2,
};

enum devfreq_parent_dev_type {
	DEVFREQ_PARENT_DEV = 0,
	CPUFREQ_PARENT_DEV = 1,
};

enum devfreq_timer {
	DEVFREQ_TIMER_DEFERRABLE = 0,
	DEVFREQ_TIMER_DELAYED = 1,
	DEVFREQ_TIMER_NUM = 2,
};

enum device_link_state {
	DL_STATE_NONE = -1,
	DL_STATE_DORMANT = 0,
	DL_STATE_AVAILABLE = 1,
	DL_STATE_CONSUMER_PROBE = 2,
	DL_STATE_ACTIVE = 3,
	DL_STATE_SUPPLIER_UNBIND = 4,
};

enum device_physical_location_horizontal_position {
	DEVICE_HORI_POS_LEFT = 0,
	DEVICE_HORI_POS_CENTER = 1,
	DEVICE_HORI_POS_RIGHT = 2,
};

enum device_physical_location_panel {
	DEVICE_PANEL_TOP = 0,
	DEVICE_PANEL_BOTTOM = 1,
	DEVICE_PANEL_LEFT = 2,
	DEVICE_PANEL_RIGHT = 3,
	DEVICE_PANEL_FRONT = 4,
	DEVICE_PANEL_BACK = 5,
	DEVICE_PANEL_UNKNOWN = 6,
};

enum device_physical_location_vertical_position {
	DEVICE_VERT_POS_UPPER = 0,
	DEVICE_VERT_POS_CENTER = 1,
	DEVICE_VERT_POS_LOWER = 2,
};

enum device_removable {
	DEVICE_REMOVABLE_NOT_SUPPORTED = 0,
	DEVICE_REMOVABLE_UNKNOWN = 1,
	DEVICE_FIXED = 2,
	DEVICE_REMOVABLE = 3,
};

enum devkmsg_log_bits {
	__DEVKMSG_LOG_BIT_ON = 0,
	__DEVKMSG_LOG_BIT_OFF = 1,
	__DEVKMSG_LOG_BIT_LOCK = 2,
};

enum devkmsg_log_masks {
	DEVKMSG_LOG_MASK_ON = 1,
	DEVKMSG_LOG_MASK_OFF = 2,
	DEVKMSG_LOG_MASK_LOCK = 4,
};

enum devlink_attr {
	DEVLINK_ATTR_UNSPEC = 0,
	DEVLINK_ATTR_BUS_NAME = 1,
	DEVLINK_ATTR_DEV_NAME = 2,
	DEVLINK_ATTR_PORT_INDEX = 3,
	DEVLINK_ATTR_PORT_TYPE = 4,
	DEVLINK_ATTR_PORT_DESIRED_TYPE = 5,
	DEVLINK_ATTR_PORT_NETDEV_IFINDEX = 6,
	DEVLINK_ATTR_PORT_NETDEV_NAME = 7,
	DEVLINK_ATTR_PORT_IBDEV_NAME = 8,
	DEVLINK_ATTR_PORT_SPLIT_COUNT = 9,
	DEVLINK_ATTR_PORT_SPLIT_GROUP = 10,
	DEVLINK_ATTR_SB_INDEX = 11,
	DEVLINK_ATTR_SB_SIZE = 12,
	DEVLINK_ATTR_SB_INGRESS_POOL_COUNT = 13,
	DEVLINK_ATTR_SB_EGRESS_POOL_COUNT = 14,
	DEVLINK_ATTR_SB_INGRESS_TC_COUNT = 15,
	DEVLINK_ATTR_SB_EGRESS_TC_COUNT = 16,
	DEVLINK_ATTR_SB_POOL_INDEX = 17,
	DEVLINK_ATTR_SB_POOL_TYPE = 18,
	DEVLINK_ATTR_SB_POOL_SIZE = 19,
	DEVLINK_ATTR_SB_POOL_THRESHOLD_TYPE = 20,
	DEVLINK_ATTR_SB_THRESHOLD = 21,
	DEVLINK_ATTR_SB_TC_INDEX = 22,
	DEVLINK_ATTR_SB_OCC_CUR = 23,
	DEVLINK_ATTR_SB_OCC_MAX = 24,
	DEVLINK_ATTR_ESWITCH_MODE = 25,
	DEVLINK_ATTR_ESWITCH_INLINE_MODE = 26,
	DEVLINK_ATTR_DPIPE_TABLES = 27,
	DEVLINK_ATTR_DPIPE_TABLE = 28,
	DEVLINK_ATTR_DPIPE_TABLE_NAME = 29,
	DEVLINK_ATTR_DPIPE_TABLE_SIZE = 30,
	DEVLINK_ATTR_DPIPE_TABLE_MATCHES = 31,
	DEVLINK_ATTR_DPIPE_TABLE_ACTIONS = 32,
	DEVLINK_ATTR_DPIPE_TABLE_COUNTERS_ENABLED = 33,
	DEVLINK_ATTR_DPIPE_ENTRIES = 34,
	DEVLINK_ATTR_DPIPE_ENTRY = 35,
	DEVLINK_ATTR_DPIPE_ENTRY_INDEX = 36,
	DEVLINK_ATTR_DPIPE_ENTRY_MATCH_VALUES = 37,
	DEVLINK_ATTR_DPIPE_ENTRY_ACTION_VALUES = 38,
	DEVLINK_ATTR_DPIPE_ENTRY_COUNTER = 39,
	DEVLINK_ATTR_DPIPE_MATCH = 40,
	DEVLINK_ATTR_DPIPE_MATCH_VALUE = 41,
	DEVLINK_ATTR_DPIPE_MATCH_TYPE = 42,
	DEVLINK_ATTR_DPIPE_ACTION = 43,
	DEVLINK_ATTR_DPIPE_ACTION_VALUE = 44,
	DEVLINK_ATTR_DPIPE_ACTION_TYPE = 45,
	DEVLINK_ATTR_DPIPE_VALUE = 46,
	DEVLINK_ATTR_DPIPE_VALUE_MASK = 47,
	DEVLINK_ATTR_DPIPE_VALUE_MAPPING = 48,
	DEVLINK_ATTR_DPIPE_HEADERS = 49,
	DEVLINK_ATTR_DPIPE_HEADER = 50,
	DEVLINK_ATTR_DPIPE_HEADER_NAME = 51,
	DEVLINK_ATTR_DPIPE_HEADER_ID = 52,
	DEVLINK_ATTR_DPIPE_HEADER_FIELDS = 53,
	DEVLINK_ATTR_DPIPE_HEADER_GLOBAL = 54,
	DEVLINK_ATTR_DPIPE_HEADER_INDEX = 55,
	DEVLINK_ATTR_DPIPE_FIELD = 56,
	DEVLINK_ATTR_DPIPE_FIELD_NAME = 57,
	DEVLINK_ATTR_DPIPE_FIELD_ID = 58,
	DEVLINK_ATTR_DPIPE_FIELD_BITWIDTH = 59,
	DEVLINK_ATTR_DPIPE_FIELD_MAPPING_TYPE = 60,
	DEVLINK_ATTR_PAD = 61,
	DEVLINK_ATTR_ESWITCH_ENCAP_MODE = 62,
	DEVLINK_ATTR_RESOURCE_LIST = 63,
	DEVLINK_ATTR_RESOURCE = 64,
	DEVLINK_ATTR_RESOURCE_NAME = 65,
	DEVLINK_ATTR_RESOURCE_ID = 66,
	DEVLINK_ATTR_RESOURCE_SIZE = 67,
	DEVLINK_ATTR_RESOURCE_SIZE_NEW = 68,
	DEVLINK_ATTR_RESOURCE_SIZE_VALID = 69,
	DEVLINK_ATTR_RESOURCE_SIZE_MIN = 70,
	DEVLINK_ATTR_RESOURCE_SIZE_MAX = 71,
	DEVLINK_ATTR_RESOURCE_SIZE_GRAN = 72,
	DEVLINK_ATTR_RESOURCE_UNIT = 73,
	DEVLINK_ATTR_RESOURCE_OCC = 74,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_ID = 75,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_UNITS = 76,
	DEVLINK_ATTR_PORT_FLAVOUR = 77,
	DEVLINK_ATTR_PORT_NUMBER = 78,
	DEVLINK_ATTR_PORT_SPLIT_SUBPORT_NUMBER = 79,
	DEVLINK_ATTR_PARAM = 80,
	DEVLINK_ATTR_PARAM_NAME = 81,
	DEVLINK_ATTR_PARAM_GENERIC = 82,
	DEVLINK_ATTR_PARAM_TYPE = 83,
	DEVLINK_ATTR_PARAM_VALUES_LIST = 84,
	DEVLINK_ATTR_PARAM_VALUE = 85,
	DEVLINK_ATTR_PARAM_VALUE_DATA = 86,
	DEVLINK_ATTR_PARAM_VALUE_CMODE = 87,
	DEVLINK_ATTR_REGION_NAME = 88,
	DEVLINK_ATTR_REGION_SIZE = 89,
	DEVLINK_ATTR_REGION_SNAPSHOTS = 90,
	DEVLINK_ATTR_REGION_SNAPSHOT = 91,
	DEVLINK_ATTR_REGION_SNAPSHOT_ID = 92,
	DEVLINK_ATTR_REGION_CHUNKS = 93,
	DEVLINK_ATTR_REGION_CHUNK = 94,
	DEVLINK_ATTR_REGION_CHUNK_DATA = 95,
	DEVLINK_ATTR_REGION_CHUNK_ADDR = 96,
	DEVLINK_ATTR_REGION_CHUNK_LEN = 97,
	DEVLINK_ATTR_INFO_DRIVER_NAME = 98,
	DEVLINK_ATTR_INFO_SERIAL_NUMBER = 99,
	DEVLINK_ATTR_INFO_VERSION_FIXED = 100,
	DEVLINK_ATTR_INFO_VERSION_RUNNING = 101,
	DEVLINK_ATTR_INFO_VERSION_STORED = 102,
	DEVLINK_ATTR_INFO_VERSION_NAME = 103,
	DEVLINK_ATTR_INFO_VERSION_VALUE = 104,
	DEVLINK_ATTR_SB_POOL_CELL_SIZE = 105,
	DEVLINK_ATTR_FMSG = 106,
	DEVLINK_ATTR_FMSG_OBJ_NEST_START = 107,
	DEVLINK_ATTR_FMSG_PAIR_NEST_START = 108,
	DEVLINK_ATTR_FMSG_ARR_NEST_START = 109,
	DEVLINK_ATTR_FMSG_NEST_END = 110,
	DEVLINK_ATTR_FMSG_OBJ_NAME = 111,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_TYPE = 112,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_DATA = 113,
	DEVLINK_ATTR_HEALTH_REPORTER = 114,
	DEVLINK_ATTR_HEALTH_REPORTER_NAME = 115,
	DEVLINK_ATTR_HEALTH_REPORTER_STATE = 116,
	DEVLINK_ATTR_HEALTH_REPORTER_ERR_COUNT = 117,
	DEVLINK_ATTR_HEALTH_REPORTER_RECOVER_COUNT = 118,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS = 119,
	DEVLINK_ATTR_HEALTH_REPORTER_GRACEFUL_PERIOD = 120,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_RECOVER = 121,
	DEVLINK_ATTR_FLASH_UPDATE_FILE_NAME = 122,
	DEVLINK_ATTR_FLASH_UPDATE_COMPONENT = 123,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_MSG = 124,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_DONE = 125,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TOTAL = 126,
	DEVLINK_ATTR_PORT_PCI_PF_NUMBER = 127,
	DEVLINK_ATTR_PORT_PCI_VF_NUMBER = 128,
	DEVLINK_ATTR_STATS = 129,
	DEVLINK_ATTR_TRAP_NAME = 130,
	DEVLINK_ATTR_TRAP_ACTION = 131,
	DEVLINK_ATTR_TRAP_TYPE = 132,
	DEVLINK_ATTR_TRAP_GENERIC = 133,
	DEVLINK_ATTR_TRAP_METADATA = 134,
	DEVLINK_ATTR_TRAP_GROUP_NAME = 135,
	DEVLINK_ATTR_RELOAD_FAILED = 136,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS_NS = 137,
	DEVLINK_ATTR_NETNS_FD = 138,
	DEVLINK_ATTR_NETNS_PID = 139,
	DEVLINK_ATTR_NETNS_ID = 140,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_DUMP = 141,
	DEVLINK_ATTR_TRAP_POLICER_ID = 142,
	DEVLINK_ATTR_TRAP_POLICER_RATE = 143,
	DEVLINK_ATTR_TRAP_POLICER_BURST = 144,
	DEVLINK_ATTR_PORT_FUNCTION = 145,
	DEVLINK_ATTR_INFO_BOARD_SERIAL_NUMBER = 146,
	DEVLINK_ATTR_PORT_LANES = 147,
	DEVLINK_ATTR_PORT_SPLITTABLE = 148,
	DEVLINK_ATTR_PORT_EXTERNAL = 149,
	DEVLINK_ATTR_PORT_CONTROLLER_NUMBER = 150,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TIMEOUT = 151,
	DEVLINK_ATTR_FLASH_UPDATE_OVERWRITE_MASK = 152,
	DEVLINK_ATTR_RELOAD_ACTION = 153,
	DEVLINK_ATTR_RELOAD_ACTIONS_PERFORMED = 154,
	DEVLINK_ATTR_RELOAD_LIMITS = 155,
	DEVLINK_ATTR_DEV_STATS = 156,
	DEVLINK_ATTR_RELOAD_STATS = 157,
	DEVLINK_ATTR_RELOAD_STATS_ENTRY = 158,
	DEVLINK_ATTR_RELOAD_STATS_LIMIT = 159,
	DEVLINK_ATTR_RELOAD_STATS_VALUE = 160,
	DEVLINK_ATTR_REMOTE_RELOAD_STATS = 161,
	DEVLINK_ATTR_RELOAD_ACTION_INFO = 162,
	DEVLINK_ATTR_RELOAD_ACTION_STATS = 163,
	DEVLINK_ATTR_PORT_PCI_SF_NUMBER = 164,
	DEVLINK_ATTR_RATE_TYPE = 165,
	DEVLINK_ATTR_RATE_TX_SHARE = 166,
	DEVLINK_ATTR_RATE_TX_MAX = 167,
	DEVLINK_ATTR_RATE_NODE_NAME = 168,
	DEVLINK_ATTR_RATE_PARENT_NODE_NAME = 169,
	DEVLINK_ATTR_REGION_MAX_SNAPSHOTS = 170,
	DEVLINK_ATTR_LINECARD_INDEX = 171,
	DEVLINK_ATTR_LINECARD_STATE = 172,
	DEVLINK_ATTR_LINECARD_TYPE = 173,
	DEVLINK_ATTR_LINECARD_SUPPORTED_TYPES = 174,
	DEVLINK_ATTR_NESTED_DEVLINK = 175,
	DEVLINK_ATTR_SELFTESTS = 176,
	DEVLINK_ATTR_RATE_TX_PRIORITY = 177,
	DEVLINK_ATTR_RATE_TX_WEIGHT = 178,
	DEVLINK_ATTR_REGION_DIRECT = 179,
	DEVLINK_ATTR_RATE_TC_BWS = 180,
	__DEVLINK_ATTR_MAX = 181,
	DEVLINK_ATTR_MAX = 180,
};

enum devlink_attr_selftest_id {
	DEVLINK_ATTR_SELFTEST_ID_UNSPEC = 0,
	DEVLINK_ATTR_SELFTEST_ID_FLASH = 1,
	__DEVLINK_ATTR_SELFTEST_ID_MAX = 2,
	DEVLINK_ATTR_SELFTEST_ID_MAX = 1,
};

enum devlink_attr_selftest_result {
	DEVLINK_ATTR_SELFTEST_RESULT_UNSPEC = 0,
	DEVLINK_ATTR_SELFTEST_RESULT = 1,
	DEVLINK_ATTR_SELFTEST_RESULT_ID = 2,
	DEVLINK_ATTR_SELFTEST_RESULT_STATUS = 3,
	__DEVLINK_ATTR_SELFTEST_RESULT_MAX = 4,
	DEVLINK_ATTR_SELFTEST_RESULT_MAX = 3,
};

enum devlink_command {
	DEVLINK_CMD_UNSPEC = 0,
	DEVLINK_CMD_GET = 1,
	DEVLINK_CMD_SET = 2,
	DEVLINK_CMD_NEW = 3,
	DEVLINK_CMD_DEL = 4,
	DEVLINK_CMD_PORT_GET = 5,
	DEVLINK_CMD_PORT_SET = 6,
	DEVLINK_CMD_PORT_NEW = 7,
	DEVLINK_CMD_PORT_DEL = 8,
	DEVLINK_CMD_PORT_SPLIT = 9,
	DEVLINK_CMD_PORT_UNSPLIT = 10,
	DEVLINK_CMD_SB_GET = 11,
	DEVLINK_CMD_SB_SET = 12,
	DEVLINK_CMD_SB_NEW = 13,
	DEVLINK_CMD_SB_DEL = 14,
	DEVLINK_CMD_SB_POOL_GET = 15,
	DEVLINK_CMD_SB_POOL_SET = 16,
	DEVLINK_CMD_SB_POOL_NEW = 17,
	DEVLINK_CMD_SB_POOL_DEL = 18,
	DEVLINK_CMD_SB_PORT_POOL_GET = 19,
	DEVLINK_CMD_SB_PORT_POOL_SET = 20,
	DEVLINK_CMD_SB_PORT_POOL_NEW = 21,
	DEVLINK_CMD_SB_PORT_POOL_DEL = 22,
	DEVLINK_CMD_SB_TC_POOL_BIND_GET = 23,
	DEVLINK_CMD_SB_TC_POOL_BIND_SET = 24,
	DEVLINK_CMD_SB_TC_POOL_BIND_NEW = 25,
	DEVLINK_CMD_SB_TC_POOL_BIND_DEL = 26,
	DEVLINK_CMD_SB_OCC_SNAPSHOT = 27,
	DEVLINK_CMD_SB_OCC_MAX_CLEAR = 28,
	DEVLINK_CMD_ESWITCH_GET = 29,
	DEVLINK_CMD_ESWITCH_SET = 30,
	DEVLINK_CMD_DPIPE_TABLE_GET = 31,
	DEVLINK_CMD_DPIPE_ENTRIES_GET = 32,
	DEVLINK_CMD_DPIPE_HEADERS_GET = 33,
	DEVLINK_CMD_DPIPE_TABLE_COUNTERS_SET = 34,
	DEVLINK_CMD_RESOURCE_SET = 35,
	DEVLINK_CMD_RESOURCE_DUMP = 36,
	DEVLINK_CMD_RELOAD = 37,
	DEVLINK_CMD_PARAM_GET = 38,
	DEVLINK_CMD_PARAM_SET = 39,
	DEVLINK_CMD_PARAM_NEW = 40,
	DEVLINK_CMD_PARAM_DEL = 41,
	DEVLINK_CMD_REGION_GET = 42,
	DEVLINK_CMD_REGION_SET = 43,
	DEVLINK_CMD_REGION_NEW = 44,
	DEVLINK_CMD_REGION_DEL = 45,
	DEVLINK_CMD_REGION_READ = 46,
	DEVLINK_CMD_PORT_PARAM_GET = 47,
	DEVLINK_CMD_PORT_PARAM_SET = 48,
	DEVLINK_CMD_PORT_PARAM_NEW = 49,
	DEVLINK_CMD_PORT_PARAM_DEL = 50,
	DEVLINK_CMD_INFO_GET = 51,
	DEVLINK_CMD_HEALTH_REPORTER_GET = 52,
	DEVLINK_CMD_HEALTH_REPORTER_SET = 53,
	DEVLINK_CMD_HEALTH_REPORTER_RECOVER = 54,
	DEVLINK_CMD_HEALTH_REPORTER_DIAGNOSE = 55,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_GET = 56,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_CLEAR = 57,
	DEVLINK_CMD_FLASH_UPDATE = 58,
	DEVLINK_CMD_FLASH_UPDATE_END = 59,
	DEVLINK_CMD_FLASH_UPDATE_STATUS = 60,
	DEVLINK_CMD_TRAP_GET = 61,
	DEVLINK_CMD_TRAP_SET = 62,
	DEVLINK_CMD_TRAP_NEW = 63,
	DEVLINK_CMD_TRAP_DEL = 64,
	DEVLINK_CMD_TRAP_GROUP_GET = 65,
	DEVLINK_CMD_TRAP_GROUP_SET = 66,
	DEVLINK_CMD_TRAP_GROUP_NEW = 67,
	DEVLINK_CMD_TRAP_GROUP_DEL = 68,
	DEVLINK_CMD_TRAP_POLICER_GET = 69,
	DEVLINK_CMD_TRAP_POLICER_SET = 70,
	DEVLINK_CMD_TRAP_POLICER_NEW = 71,
	DEVLINK_CMD_TRAP_POLICER_DEL = 72,
	DEVLINK_CMD_HEALTH_REPORTER_TEST = 73,
	DEVLINK_CMD_RATE_GET = 74,
	DEVLINK_CMD_RATE_SET = 75,
	DEVLINK_CMD_RATE_NEW = 76,
	DEVLINK_CMD_RATE_DEL = 77,
	DEVLINK_CMD_LINECARD_GET = 78,
	DEVLINK_CMD_LINECARD_SET = 79,
	DEVLINK_CMD_LINECARD_NEW = 80,
	DEVLINK_CMD_LINECARD_DEL = 81,
	DEVLINK_CMD_SELFTESTS_GET = 82,
	DEVLINK_CMD_SELFTESTS_RUN = 83,
	DEVLINK_CMD_NOTIFY_FILTER_SET = 84,
	__DEVLINK_CMD_MAX = 85,
	DEVLINK_CMD_MAX = 84,
};

enum devlink_dpipe_action_type {
	DEVLINK_DPIPE_ACTION_TYPE_FIELD_MODIFY = 0,
};

enum devlink_dpipe_field_ethernet_id {
	DEVLINK_DPIPE_FIELD_ETHERNET_DST_MAC = 0,
};

enum devlink_dpipe_field_ipv4_id {
	DEVLINK_DPIPE_FIELD_IPV4_DST_IP = 0,
};

enum devlink_dpipe_field_ipv6_id {
	DEVLINK_DPIPE_FIELD_IPV6_DST_IP = 0,
};

enum devlink_dpipe_field_mapping_type {
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_NONE = 0,
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_IFINDEX = 1,
};

enum devlink_dpipe_header_id {
	DEVLINK_DPIPE_HEADER_ETHERNET = 0,
	DEVLINK_DPIPE_HEADER_IPV4 = 1,
	DEVLINK_DPIPE_HEADER_IPV6 = 2,
};

enum devlink_dpipe_match_type {
	DEVLINK_DPIPE_MATCH_TYPE_FIELD_EXACT = 0,
};

enum devlink_eswitch_encap_mode {
	DEVLINK_ESWITCH_ENCAP_MODE_NONE = 0,
	DEVLINK_ESWITCH_ENCAP_MODE_BASIC = 1,
};

enum devlink_health_reporter_state {
	DEVLINK_HEALTH_REPORTER_STATE_HEALTHY = 0,
	DEVLINK_HEALTH_REPORTER_STATE_ERROR = 1,
};

enum devlink_info_version_type {
	DEVLINK_INFO_VERSION_TYPE_NONE = 0,
	DEVLINK_INFO_VERSION_TYPE_COMPONENT = 1,
};

enum devlink_linecard_state {
	DEVLINK_LINECARD_STATE_UNSPEC = 0,
	DEVLINK_LINECARD_STATE_UNPROVISIONED = 1,
	DEVLINK_LINECARD_STATE_UNPROVISIONING = 2,
	DEVLINK_LINECARD_STATE_PROVISIONING = 3,
	DEVLINK_LINECARD_STATE_PROVISIONING_FAILED = 4,
	DEVLINK_LINECARD_STATE_PROVISIONED = 5,
	DEVLINK_LINECARD_STATE_ACTIVE = 6,
	__DEVLINK_LINECARD_STATE_MAX = 7,
	DEVLINK_LINECARD_STATE_MAX = 6,
};

enum devlink_multicast_groups {
	DEVLINK_MCGRP_CONFIG = 0,
};

enum devlink_param_cmode {
	DEVLINK_PARAM_CMODE_RUNTIME = 0,
	DEVLINK_PARAM_CMODE_DRIVERINIT = 1,
	DEVLINK_PARAM_CMODE_PERMANENT = 2,
	__DEVLINK_PARAM_CMODE_MAX = 3,
	DEVLINK_PARAM_CMODE_MAX = 2,
};

enum devlink_param_generic_id {
	DEVLINK_PARAM_GENERIC_ID_INT_ERR_RESET = 0,
	DEVLINK_PARAM_GENERIC_ID_MAX_MACS = 1,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_SRIOV = 2,
	DEVLINK_PARAM_GENERIC_ID_REGION_SNAPSHOT = 3,
	DEVLINK_PARAM_GENERIC_ID_IGNORE_ARI = 4,
	DEVLINK_PARAM_GENERIC_ID_MSIX_VEC_PER_PF_MAX = 5,
	DEVLINK_PARAM_GENERIC_ID_MSIX_VEC_PER_PF_MIN = 6,
	DEVLINK_PARAM_GENERIC_ID_FW_LOAD_POLICY = 7,
	DEVLINK_PARAM_GENERIC_ID_RESET_DEV_ON_DRV_PROBE = 8,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_ROCE = 9,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_REMOTE_DEV_RESET = 10,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_ETH = 11,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_RDMA = 12,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_VNET = 13,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_IWARP = 14,
	DEVLINK_PARAM_GENERIC_ID_IO_EQ_SIZE = 15,
	DEVLINK_PARAM_GENERIC_ID_EVENT_EQ_SIZE = 16,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_PHC = 17,
	DEVLINK_PARAM_GENERIC_ID_CLOCK_ID = 18,
	__DEVLINK_PARAM_GENERIC_ID_MAX = 19,
	DEVLINK_PARAM_GENERIC_ID_MAX = 18,
};

enum devlink_param_type {
	DEVLINK_PARAM_TYPE_U8 = 1,
	DEVLINK_PARAM_TYPE_U16 = 2,
	DEVLINK_PARAM_TYPE_U32 = 3,
	DEVLINK_PARAM_TYPE_U64 = 4,
	DEVLINK_PARAM_TYPE_STRING = 5,
	DEVLINK_PARAM_TYPE_BOOL = 6,
};

enum devlink_port_flavour {
	DEVLINK_PORT_FLAVOUR_PHYSICAL = 0,
	DEVLINK_PORT_FLAVOUR_CPU = 1,
	DEVLINK_PORT_FLAVOUR_DSA = 2,
	DEVLINK_PORT_FLAVOUR_PCI_PF = 3,
	DEVLINK_PORT_FLAVOUR_PCI_VF = 4,
	DEVLINK_PORT_FLAVOUR_VIRTUAL = 5,
	DEVLINK_PORT_FLAVOUR_UNUSED = 6,
	DEVLINK_PORT_FLAVOUR_PCI_SF = 7,
};

enum devlink_port_fn_attr_cap {
	DEVLINK_PORT_FN_ATTR_CAP_ROCE_BIT = 0,
	DEVLINK_PORT_FN_ATTR_CAP_MIGRATABLE_BIT = 1,
	DEVLINK_PORT_FN_ATTR_CAP_IPSEC_CRYPTO_BIT = 2,
	DEVLINK_PORT_FN_ATTR_CAP_IPSEC_PACKET_BIT = 3,
	__DEVLINK_PORT_FN_ATTR_CAPS_MAX = 4,
};

enum devlink_port_fn_opstate {
	DEVLINK_PORT_FN_OPSTATE_DETACHED = 0,
	DEVLINK_PORT_FN_OPSTATE_ATTACHED = 1,
};

enum devlink_port_fn_state {
	DEVLINK_PORT_FN_STATE_INACTIVE = 0,
	DEVLINK_PORT_FN_STATE_ACTIVE = 1,
};

enum devlink_port_function_attr {
	DEVLINK_PORT_FUNCTION_ATTR_UNSPEC = 0,
	DEVLINK_PORT_FUNCTION_ATTR_HW_ADDR = 1,
	DEVLINK_PORT_FN_ATTR_STATE = 2,
	DEVLINK_PORT_FN_ATTR_OPSTATE = 3,
	DEVLINK_PORT_FN_ATTR_CAPS = 4,
	DEVLINK_PORT_FN_ATTR_DEVLINK = 5,
	DEVLINK_PORT_FN_ATTR_MAX_IO_EQS = 6,
	__DEVLINK_PORT_FUNCTION_ATTR_MAX = 7,
	DEVLINK_PORT_FUNCTION_ATTR_MAX = 6,
};

enum devlink_port_type {
	DEVLINK_PORT_TYPE_NOTSET = 0,
	DEVLINK_PORT_TYPE_AUTO = 1,
	DEVLINK_PORT_TYPE_ETH = 2,
	DEVLINK_PORT_TYPE_IB = 3,
};

enum devlink_rate_tc_attr {
	DEVLINK_RATE_TC_ATTR_UNSPEC = 0,
	DEVLINK_RATE_TC_ATTR_INDEX = 1,
	DEVLINK_RATE_TC_ATTR_BW = 2,
	__DEVLINK_RATE_TC_ATTR_MAX = 3,
	DEVLINK_RATE_TC_ATTR_MAX = 2,
};

enum devlink_rate_type {
	DEVLINK_RATE_TYPE_LEAF = 0,
	DEVLINK_RATE_TYPE_NODE = 1,
};

enum devlink_reload_action {
	DEVLINK_RELOAD_ACTION_UNSPEC = 0,
	DEVLINK_RELOAD_ACTION_DRIVER_REINIT = 1,
	DEVLINK_RELOAD_ACTION_FW_ACTIVATE = 2,
	__DEVLINK_RELOAD_ACTION_MAX = 3,
	DEVLINK_RELOAD_ACTION_MAX = 2,
};

enum devlink_reload_limit {
	DEVLINK_RELOAD_LIMIT_UNSPEC = 0,
	DEVLINK_RELOAD_LIMIT_NO_RESET = 1,
	__DEVLINK_RELOAD_LIMIT_MAX = 2,
	DEVLINK_RELOAD_LIMIT_MAX = 1,
};

enum devlink_resource_unit {
	DEVLINK_RESOURCE_UNIT_ENTRY = 0,
};

enum devlink_sb_pool_type {
	DEVLINK_SB_POOL_TYPE_INGRESS = 0,
	DEVLINK_SB_POOL_TYPE_EGRESS = 1,
};

enum devlink_sb_threshold_type {
	DEVLINK_SB_THRESHOLD_TYPE_STATIC = 0,
	DEVLINK_SB_THRESHOLD_TYPE_DYNAMIC = 1,
};

enum devlink_selftest_status {
	DEVLINK_SELFTEST_STATUS_SKIP = 0,
	DEVLINK_SELFTEST_STATUS_PASS = 1,
	DEVLINK_SELFTEST_STATUS_FAIL = 2,
};

enum devlink_trap_action {
	DEVLINK_TRAP_ACTION_DROP = 0,
	DEVLINK_TRAP_ACTION_TRAP = 1,
	DEVLINK_TRAP_ACTION_MIRROR = 2,
};

enum devlink_trap_generic_id {
	DEVLINK_TRAP_GENERIC_ID_SMAC_MC = 0,
	DEVLINK_TRAP_GENERIC_ID_VLAN_TAG_MISMATCH = 1,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_VLAN_FILTER = 2,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_STP_FILTER = 3,
	DEVLINK_TRAP_GENERIC_ID_EMPTY_TX_LIST = 4,
	DEVLINK_TRAP_GENERIC_ID_PORT_LOOPBACK_FILTER = 5,
	DEVLINK_TRAP_GENERIC_ID_BLACKHOLE_ROUTE = 6,
	DEVLINK_TRAP_GENERIC_ID_TTL_ERROR = 7,
	DEVLINK_TRAP_GENERIC_ID_TAIL_DROP = 8,
	DEVLINK_TRAP_GENERIC_ID_NON_IP_PACKET = 9,
	DEVLINK_TRAP_GENERIC_ID_UC_DIP_MC_DMAC = 10,
	DEVLINK_TRAP_GENERIC_ID_DIP_LB = 11,
	DEVLINK_TRAP_GENERIC_ID_SIP_MC = 12,
	DEVLINK_TRAP_GENERIC_ID_SIP_LB = 13,
	DEVLINK_TRAP_GENERIC_ID_CORRUPTED_IP_HDR = 14,
	DEVLINK_TRAP_GENERIC_ID_IPV4_SIP_BC = 15,
	DEVLINK_TRAP_GENERIC_ID_IPV6_MC_DIP_RESERVED_SCOPE = 16,
	DEVLINK_TRAP_GENERIC_ID_IPV6_MC_DIP_INTERFACE_LOCAL_SCOPE = 17,
	DEVLINK_TRAP_GENERIC_ID_MTU_ERROR = 18,
	DEVLINK_TRAP_GENERIC_ID_UNRESOLVED_NEIGH = 19,
	DEVLINK_TRAP_GENERIC_ID_RPF = 20,
	DEVLINK_TRAP_GENERIC_ID_REJECT_ROUTE = 21,
	DEVLINK_TRAP_GENERIC_ID_IPV4_LPM_UNICAST_MISS = 22,
	DEVLINK_TRAP_GENERIC_ID_IPV6_LPM_UNICAST_MISS = 23,
	DEVLINK_TRAP_GENERIC_ID_NON_ROUTABLE = 24,
	DEVLINK_TRAP_GENERIC_ID_DECAP_ERROR = 25,
	DEVLINK_TRAP_GENERIC_ID_OVERLAY_SMAC_MC = 26,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_FLOW_ACTION_DROP = 27,
	DEVLINK_TRAP_GENERIC_ID_EGRESS_FLOW_ACTION_DROP = 28,
	DEVLINK_TRAP_GENERIC_ID_STP = 29,
	DEVLINK_TRAP_GENERIC_ID_LACP = 30,
	DEVLINK_TRAP_GENERIC_ID_LLDP = 31,
	DEVLINK_TRAP_GENERIC_ID_IGMP_QUERY = 32,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V1_REPORT = 33,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V2_REPORT = 34,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V3_REPORT = 35,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V2_LEAVE = 36,
	DEVLINK_TRAP_GENERIC_ID_MLD_QUERY = 37,
	DEVLINK_TRAP_GENERIC_ID_MLD_V1_REPORT = 38,
	DEVLINK_TRAP_GENERIC_ID_MLD_V2_REPORT = 39,
	DEVLINK_TRAP_GENERIC_ID_MLD_V1_DONE = 40,
	DEVLINK_TRAP_GENERIC_ID_IPV4_DHCP = 41,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DHCP = 42,
	DEVLINK_TRAP_GENERIC_ID_ARP_REQUEST = 43,
	DEVLINK_TRAP_GENERIC_ID_ARP_RESPONSE = 44,
	DEVLINK_TRAP_GENERIC_ID_ARP_OVERLAY = 45,
	DEVLINK_TRAP_GENERIC_ID_IPV6_NEIGH_SOLICIT = 46,
	DEVLINK_TRAP_GENERIC_ID_IPV6_NEIGH_ADVERT = 47,
	DEVLINK_TRAP_GENERIC_ID_IPV4_BFD = 48,
	DEVLINK_TRAP_GENERIC_ID_IPV6_BFD = 49,
	DEVLINK_TRAP_GENERIC_ID_IPV4_OSPF = 50,
	DEVLINK_TRAP_GENERIC_ID_IPV6_OSPF = 51,
	DEVLINK_TRAP_GENERIC_ID_IPV4_BGP = 52,
	DEVLINK_TRAP_GENERIC_ID_IPV6_BGP = 53,
	DEVLINK_TRAP_GENERIC_ID_IPV4_VRRP = 54,
	DEVLINK_TRAP_GENERIC_ID_IPV6_VRRP = 55,
	DEVLINK_TRAP_GENERIC_ID_IPV4_PIM = 56,
	DEVLINK_TRAP_GENERIC_ID_IPV6_PIM = 57,
	DEVLINK_TRAP_GENERIC_ID_UC_LB = 58,
	DEVLINK_TRAP_GENERIC_ID_LOCAL_ROUTE = 59,
	DEVLINK_TRAP_GENERIC_ID_EXTERNAL_ROUTE = 60,
	DEVLINK_TRAP_GENERIC_ID_IPV6_UC_DIP_LINK_LOCAL_SCOPE = 61,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DIP_ALL_NODES = 62,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DIP_ALL_ROUTERS = 63,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_SOLICIT = 64,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_ADVERT = 65,
	DEVLINK_TRAP_GENERIC_ID_IPV6_REDIRECT = 66,
	DEVLINK_TRAP_GENERIC_ID_IPV4_ROUTER_ALERT = 67,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_ALERT = 68,
	DEVLINK_TRAP_GENERIC_ID_PTP_EVENT = 69,
	DEVLINK_TRAP_GENERIC_ID_PTP_GENERAL = 70,
	DEVLINK_TRAP_GENERIC_ID_FLOW_ACTION_SAMPLE = 71,
	DEVLINK_TRAP_GENERIC_ID_FLOW_ACTION_TRAP = 72,
	DEVLINK_TRAP_GENERIC_ID_EARLY_DROP = 73,
	DEVLINK_TRAP_GENERIC_ID_VXLAN_PARSING = 74,
	DEVLINK_TRAP_GENERIC_ID_LLC_SNAP_PARSING = 75,
	DEVLINK_TRAP_GENERIC_ID_VLAN_PARSING = 76,
	DEVLINK_TRAP_GENERIC_ID_PPPOE_PPP_PARSING = 77,
	DEVLINK_TRAP_GENERIC_ID_MPLS_PARSING = 78,
	DEVLINK_TRAP_GENERIC_ID_ARP_PARSING = 79,
	DEVLINK_TRAP_GENERIC_ID_IP_1_PARSING = 80,
	DEVLINK_TRAP_GENERIC_ID_IP_N_PARSING = 81,
	DEVLINK_TRAP_GENERIC_ID_GRE_PARSING = 82,
	DEVLINK_TRAP_GENERIC_ID_UDP_PARSING = 83,
	DEVLINK_TRAP_GENERIC_ID_TCP_PARSING = 84,
	DEVLINK_TRAP_GENERIC_ID_IPSEC_PARSING = 85,
	DEVLINK_TRAP_GENERIC_ID_SCTP_PARSING = 86,
	DEVLINK_TRAP_GENERIC_ID_DCCP_PARSING = 87,
	DEVLINK_TRAP_GENERIC_ID_GTP_PARSING = 88,
	DEVLINK_TRAP_GENERIC_ID_ESP_PARSING = 89,
	DEVLINK_TRAP_GENERIC_ID_BLACKHOLE_NEXTHOP = 90,
	DEVLINK_TRAP_GENERIC_ID_DMAC_FILTER = 91,
	DEVLINK_TRAP_GENERIC_ID_EAPOL = 92,
	DEVLINK_TRAP_GENERIC_ID_LOCKED_PORT = 93,
	__DEVLINK_TRAP_GENERIC_ID_MAX = 94,
	DEVLINK_TRAP_GENERIC_ID_MAX = 93,
};

enum devlink_trap_group_generic_id {
	DEVLINK_TRAP_GROUP_GENERIC_ID_L2_DROPS = 0,
	DEVLINK_TRAP_GROUP_GENERIC_ID_L3_DROPS = 1,
	DEVLINK_TRAP_GROUP_GENERIC_ID_L3_EXCEPTIONS = 2,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BUFFER_DROPS = 3,
	DEVLINK_TRAP_GROUP_GENERIC_ID_TUNNEL_DROPS = 4,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_DROPS = 5,
	DEVLINK_TRAP_GROUP_GENERIC_ID_STP = 6,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LACP = 7,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LLDP = 8,
	DEVLINK_TRAP_GROUP_GENERIC_ID_MC_SNOOPING = 9,
	DEVLINK_TRAP_GROUP_GENERIC_ID_DHCP = 10,
	DEVLINK_TRAP_GROUP_GENERIC_ID_NEIGH_DISCOVERY = 11,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BFD = 12,
	DEVLINK_TRAP_GROUP_GENERIC_ID_OSPF = 13,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BGP = 14,
	DEVLINK_TRAP_GROUP_GENERIC_ID_VRRP = 15,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PIM = 16,
	DEVLINK_TRAP_GROUP_GENERIC_ID_UC_LB = 17,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LOCAL_DELIVERY = 18,
	DEVLINK_TRAP_GROUP_GENERIC_ID_EXTERNAL_DELIVERY = 19,
	DEVLINK_TRAP_GROUP_GENERIC_ID_IPV6 = 20,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PTP_EVENT = 21,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PTP_GENERAL = 22,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_SAMPLE = 23,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_TRAP = 24,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PARSER_ERROR_DROPS = 25,
	DEVLINK_TRAP_GROUP_GENERIC_ID_EAPOL = 26,
	__DEVLINK_TRAP_GROUP_GENERIC_ID_MAX = 27,
	DEVLINK_TRAP_GROUP_GENERIC_ID_MAX = 26,
};

enum devlink_trap_type {
	DEVLINK_TRAP_TYPE_DROP = 0,
	DEVLINK_TRAP_TYPE_EXCEPTION = 1,
	DEVLINK_TRAP_TYPE_CONTROL = 2,
};

enum devlink_var_attr_type {
	DEVLINK_VAR_ATTR_TYPE_U8 = 1,
	DEVLINK_VAR_ATTR_TYPE_U16 = 2,
	DEVLINK_VAR_ATTR_TYPE_U32 = 3,
	DEVLINK_VAR_ATTR_TYPE_U64 = 4,
	DEVLINK_VAR_ATTR_TYPE_STRING = 5,
	DEVLINK_VAR_ATTR_TYPE_FLAG = 6,
	DEVLINK_VAR_ATTR_TYPE_NUL_STRING = 10,
	DEVLINK_VAR_ATTR_TYPE_BINARY = 11,
	__DEVLINK_VAR_ATTR_TYPE_CUSTOM_BASE = 128,
};

enum devm_ioremap_type {
	DEVM_IOREMAP = 0,
	DEVM_IOREMAP_UC = 1,
	DEVM_IOREMAP_WC = 2,
	DEVM_IOREMAP_NP = 3,
};

enum dfa_accept_flags {
	ACCEPT_FLAG_OWNER = 1,
};

enum die_val {
	DIE_OOPS = 1,
	DIE_INT3 = 2,
	DIE_DEBUG = 3,
	DIE_PANIC = 4,
	DIE_NMI = 5,
	DIE_DIE = 6,
	DIE_KERNELDEBUG = 7,
	DIE_TRAP = 8,
	DIE_GPF = 9,
	DIE_CALL = 10,
	DIE_PAGE_FAULT = 11,
	DIE_NMIUNKNOWN = 12,
};

enum dim_cq_period_mode {
	DIM_CQ_PERIOD_MODE_START_FROM_EQE = 0,
	DIM_CQ_PERIOD_MODE_START_FROM_CQE = 1,
	DIM_CQ_PERIOD_NUM_MODES = 2,
};

enum dim_state {
	DIM_START_MEASURE = 0,
	DIM_MEASURE_IN_PROGRESS = 1,
	DIM_APPLY_NEW_PROFILE = 2,
};

enum dim_stats_state {
	DIM_STATS_WORSE = 0,
	DIM_STATS_SAME = 1,
	DIM_STATS_BETTER = 2,
};

enum dim_step_result {
	DIM_STEPPED = 0,
	DIM_TOO_TIRED = 1,
	DIM_ON_EDGE = 2,
};

enum dim_tune_state {
	DIM_PARKING_ON_TOP = 0,
	DIM_PARKING_TIRED = 1,
	DIM_GOING_RIGHT = 2,
	DIM_GOING_LEFT = 3,
};

enum display_flags {
	DISPLAY_FLAGS_HSYNC_LOW = 1,
	DISPLAY_FLAGS_HSYNC_HIGH = 2,
	DISPLAY_FLAGS_VSYNC_LOW = 4,
	DISPLAY_FLAGS_VSYNC_HIGH = 8,
	DISPLAY_FLAGS_DE_LOW = 16,
	DISPLAY_FLAGS_DE_HIGH = 32,
	DISPLAY_FLAGS_PIXDATA_POSEDGE = 64,
	DISPLAY_FLAGS_PIXDATA_NEGEDGE = 128,
	DISPLAY_FLAGS_INTERLACED = 256,
	DISPLAY_FLAGS_DOUBLESCAN = 512,
	DISPLAY_FLAGS_DOUBLECLK = 1024,
	DISPLAY_FLAGS_SYNC_POSEDGE = 2048,
	DISPLAY_FLAGS_SYNC_NEGEDGE = 4096,
};

enum dl_bw_request {
	dl_bw_req_deactivate = 0,
	dl_bw_req_alloc = 1,
	dl_bw_req_free = 2,
};

enum dl_dev_state {
	DL_DEV_NO_DRIVER = 0,
	DL_DEV_PROBING = 1,
	DL_DEV_DRIVER_BOUND = 2,
	DL_DEV_UNBINDING = 3,
};

enum dl_param {
	DL_RUNTIME = 0,
	DL_PERIOD = 1,
};

enum dma_ctrl_flags {
	DMA_PREP_INTERRUPT = 1,
	DMA_CTRL_ACK = 2,
	DMA_PREP_PQ_DISABLE_P = 4,
	DMA_PREP_PQ_DISABLE_Q = 8,
	DMA_PREP_CONTINUE = 16,
	DMA_PREP_FENCE = 32,
	DMA_CTRL_REUSE = 64,
	DMA_PREP_CMD = 128,
	DMA_PREP_REPEAT = 256,
	DMA_PREP_LOAD_EOT = 512,
};

enum dma_data_direction {
	DMA_BIDIRECTIONAL = 0,
	DMA_TO_DEVICE = 1,
	DMA_FROM_DEVICE = 2,
	DMA_NONE = 3,
};

enum dma_desc_metadata_mode {
	DESC_METADATA_NONE = 0,
	DESC_METADATA_CLIENT = 1,
	DESC_METADATA_ENGINE = 2,
};

enum dma_fence_flag_bits {
	DMA_FENCE_FLAG_SEQNO64_BIT = 0,
	DMA_FENCE_FLAG_SIGNALED_BIT = 1,
	DMA_FENCE_FLAG_TIMESTAMP_BIT = 2,
	DMA_FENCE_FLAG_ENABLE_SIGNAL_BIT = 3,
	DMA_FENCE_FLAG_USER_BITS = 4,
};

enum dma_residue_granularity {
	DMA_RESIDUE_GRANULARITY_DESCRIPTOR = 0,
	DMA_RESIDUE_GRANULARITY_SEGMENT = 1,
	DMA_RESIDUE_GRANULARITY_BURST = 2,
};

enum dma_resv_usage {
	DMA_RESV_USAGE_KERNEL = 0,
	DMA_RESV_USAGE_WRITE = 1,
	DMA_RESV_USAGE_READ = 2,
	DMA_RESV_USAGE_BOOKKEEP = 3,
};

enum dma_slave_buswidth {
	DMA_SLAVE_BUSWIDTH_UNDEFINED = 0,
	DMA_SLAVE_BUSWIDTH_1_BYTE = 1,
	DMA_SLAVE_BUSWIDTH_2_BYTES = 2,
	DMA_SLAVE_BUSWIDTH_3_BYTES = 3,
	DMA_SLAVE_BUSWIDTH_4_BYTES = 4,
	DMA_SLAVE_BUSWIDTH_8_BYTES = 8,
	DMA_SLAVE_BUSWIDTH_16_BYTES = 16,
	DMA_SLAVE_BUSWIDTH_32_BYTES = 32,
	DMA_SLAVE_BUSWIDTH_64_BYTES = 64,
	DMA_SLAVE_BUSWIDTH_128_BYTES = 128,
};

enum dma_status {
	DMA_COMPLETE = 0,
	DMA_IN_PROGRESS = 1,
	DMA_PAUSED = 2,
	DMA_ERROR = 3,
	DMA_OUT_OF_ORDER = 4,
};

enum dma_transaction_type {
	DMA_MEMCPY = 0,
	DMA_XOR = 1,
	DMA_PQ = 2,
	DMA_XOR_VAL = 3,
	DMA_PQ_VAL = 4,
	DMA_MEMSET = 5,
	DMA_MEMSET_SG = 6,
	DMA_INTERRUPT = 7,
	DMA_PRIVATE = 8,
	DMA_ASYNC_TX = 9,
	DMA_SLAVE = 10,
	DMA_CYCLIC = 11,
	DMA_INTERLEAVE = 12,
	DMA_COMPLETION_NO_ORDER = 13,
	DMA_REPEAT = 14,
	DMA_LOAD_EOT = 15,
	DMA_TX_TYPE_END = 16,
};

enum dma_transfer_direction {
	DMA_MEM_TO_MEM = 0,
	DMA_MEM_TO_DEV = 1,
	DMA_DEV_TO_MEM = 2,
	DMA_DEV_TO_DEV = 3,
	DMA_TRANS_NONE = 4,
};

enum dmaengine_alignment {
	DMAENGINE_ALIGN_1_BYTE = 0,
	DMAENGINE_ALIGN_2_BYTES = 1,
	DMAENGINE_ALIGN_4_BYTES = 2,
	DMAENGINE_ALIGN_8_BYTES = 3,
	DMAENGINE_ALIGN_16_BYTES = 4,
	DMAENGINE_ALIGN_32_BYTES = 5,
	DMAENGINE_ALIGN_64_BYTES = 6,
	DMAENGINE_ALIGN_128_BYTES = 7,
	DMAENGINE_ALIGN_256_BYTES = 8,
};

enum dmaengine_tx_result {
	DMA_TRANS_NOERROR = 0,
	DMA_TRANS_READ_FAILED = 1,
	DMA_TRANS_WRITE_FAILED = 2,
	DMA_TRANS_ABORTED = 3,
};

enum dmi_device_type {
	DMI_DEV_TYPE_ANY = 0,
	DMI_DEV_TYPE_OTHER = 1,
	DMI_DEV_TYPE_UNKNOWN = 2,
	DMI_DEV_TYPE_VIDEO = 3,
	DMI_DEV_TYPE_SCSI = 4,
	DMI_DEV_TYPE_ETHERNET = 5,
	DMI_DEV_TYPE_TOKENRING = 6,
	DMI_DEV_TYPE_SOUND = 7,
	DMI_DEV_TYPE_PATA = 8,
	DMI_DEV_TYPE_SATA = 9,
	DMI_DEV_TYPE_SAS = 10,
	DMI_DEV_TYPE_IPMI = -1,
	DMI_DEV_TYPE_OEM_STRING = -2,
	DMI_DEV_TYPE_DEV_ONBOARD = -3,
	DMI_DEV_TYPE_DEV_SLOT = -4,
};

enum dmi_entry_type {
	DMI_ENTRY_BIOS = 0,
	DMI_ENTRY_SYSTEM = 1,
	DMI_ENTRY_BASEBOARD = 2,
	DMI_ENTRY_CHASSIS = 3,
	DMI_ENTRY_PROCESSOR = 4,
	DMI_ENTRY_MEM_CONTROLLER = 5,
	DMI_ENTRY_MEM_MODULE = 6,
	DMI_ENTRY_CACHE = 7,
	DMI_ENTRY_PORT_CONNECTOR = 8,
	DMI_ENTRY_SYSTEM_SLOT = 9,
	DMI_ENTRY_ONBOARD_DEVICE = 10,
	DMI_ENTRY_OEMSTRINGS = 11,
	DMI_ENTRY_SYSCONF = 12,
	DMI_ENTRY_BIOS_LANG = 13,
	DMI_ENTRY_GROUP_ASSOC = 14,
	DMI_ENTRY_SYSTEM_EVENT_LOG = 15,
	DMI_ENTRY_PHYS_MEM_ARRAY = 16,
	DMI_ENTRY_MEM_DEVICE = 17,
	DMI_ENTRY_32_MEM_ERROR = 18,
	DMI_ENTRY_MEM_ARRAY_MAPPED_ADDR = 19,
	DMI_ENTRY_MEM_DEV_MAPPED_ADDR = 20,
	DMI_ENTRY_BUILTIN_POINTING_DEV = 21,
	DMI_ENTRY_PORTABLE_BATTERY = 22,
	DMI_ENTRY_SYSTEM_RESET = 23,
	DMI_ENTRY_HW_SECURITY = 24,
	DMI_ENTRY_SYSTEM_POWER_CONTROLS = 25,
	DMI_ENTRY_VOLTAGE_PROBE = 26,
	DMI_ENTRY_COOLING_DEV = 27,
	DMI_ENTRY_TEMP_PROBE = 28,
	DMI_ENTRY_ELECTRICAL_CURRENT_PROBE = 29,
	DMI_ENTRY_OOB_REMOTE_ACCESS = 30,
	DMI_ENTRY_BIS_ENTRY = 31,
	DMI_ENTRY_SYSTEM_BOOT = 32,
	DMI_ENTRY_MGMT_DEV = 33,
	DMI_ENTRY_MGMT_DEV_COMPONENT = 34,
	DMI_ENTRY_MGMT_DEV_THRES = 35,
	DMI_ENTRY_MEM_CHANNEL = 36,
	DMI_ENTRY_IPMI_DEV = 37,
	DMI_ENTRY_SYS_POWER_SUPPLY = 38,
	DMI_ENTRY_ADDITIONAL = 39,
	DMI_ENTRY_ONBOARD_DEV_EXT = 40,
	DMI_ENTRY_MGMT_CONTROLLER_HOST = 41,
	DMI_ENTRY_INACTIVE = 126,
	DMI_ENTRY_END_OF_TABLE = 127,
};

enum dmi_field {
	DMI_NONE = 0,
	DMI_BIOS_VENDOR = 1,
	DMI_BIOS_VERSION = 2,
	DMI_BIOS_DATE = 3,
	DMI_BIOS_RELEASE = 4,
	DMI_EC_FIRMWARE_RELEASE = 5,
	DMI_SYS_VENDOR = 6,
	DMI_PRODUCT_NAME = 7,
	DMI_PRODUCT_VERSION = 8,
	DMI_PRODUCT_SERIAL = 9,
	DMI_PRODUCT_UUID = 10,
	DMI_PRODUCT_SKU = 11,
	DMI_PRODUCT_FAMILY = 12,
	DMI_BOARD_VENDOR = 13,
	DMI_BOARD_NAME = 14,
	DMI_BOARD_VERSION = 15,
	DMI_BOARD_SERIAL = 16,
	DMI_BOARD_ASSET_TAG = 17,
	DMI_CHASSIS_VENDOR = 18,
	DMI_CHASSIS_TYPE = 19,
	DMI_CHASSIS_VERSION = 20,
	DMI_CHASSIS_SERIAL = 21,
	DMI_CHASSIS_ASSET_TAG = 22,
	DMI_STRING_MAX = 23,
	DMI_OEM_STRING = 24,
};

enum dock_callback_type {
	DOCK_CALL_HANDLER = 0,
	DOCK_CALL_FIXUP = 1,
	DOCK_CALL_UEVENT = 2,
};

enum dpll_a {
	DPLL_A_ID = 1,
	DPLL_A_MODULE_NAME = 2,
	DPLL_A_PAD = 3,
	DPLL_A_CLOCK_ID = 4,
	DPLL_A_MODE = 5,
	DPLL_A_MODE_SUPPORTED = 6,
	DPLL_A_LOCK_STATUS = 7,
	DPLL_A_TEMP = 8,
	DPLL_A_TYPE = 9,
	DPLL_A_LOCK_STATUS_ERROR = 10,
	DPLL_A_CLOCK_QUALITY_LEVEL = 11,
	DPLL_A_PHASE_OFFSET_MONITOR = 12,
	__DPLL_A_MAX = 13,
	DPLL_A_MAX = 12,
};

enum dpll_a_pin {
	DPLL_A_PIN_ID = 1,
	DPLL_A_PIN_PARENT_ID = 2,
	DPLL_A_PIN_MODULE_NAME = 3,
	DPLL_A_PIN_PAD = 4,
	DPLL_A_PIN_CLOCK_ID = 5,
	DPLL_A_PIN_BOARD_LABEL = 6,
	DPLL_A_PIN_PANEL_LABEL = 7,
	DPLL_A_PIN_PACKAGE_LABEL = 8,
	DPLL_A_PIN_TYPE = 9,
	DPLL_A_PIN_DIRECTION = 10,
	DPLL_A_PIN_FREQUENCY = 11,
	DPLL_A_PIN_FREQUENCY_SUPPORTED = 12,
	DPLL_A_PIN_FREQUENCY_MIN = 13,
	DPLL_A_PIN_FREQUENCY_MAX = 14,
	DPLL_A_PIN_PRIO = 15,
	DPLL_A_PIN_STATE = 16,
	DPLL_A_PIN_CAPABILITIES = 17,
	DPLL_A_PIN_PARENT_DEVICE = 18,
	DPLL_A_PIN_PARENT_PIN = 19,
	DPLL_A_PIN_PHASE_ADJUST_MIN = 20,
	DPLL_A_PIN_PHASE_ADJUST_MAX = 21,
	DPLL_A_PIN_PHASE_ADJUST = 22,
	DPLL_A_PIN_PHASE_OFFSET = 23,
	DPLL_A_PIN_FRACTIONAL_FREQUENCY_OFFSET = 24,
	DPLL_A_PIN_ESYNC_FREQUENCY = 25,
	DPLL_A_PIN_ESYNC_FREQUENCY_SUPPORTED = 26,
	DPLL_A_PIN_ESYNC_PULSE = 27,
	DPLL_A_PIN_REFERENCE_SYNC = 28,
	__DPLL_A_PIN_MAX = 29,
	DPLL_A_PIN_MAX = 28,
};

enum dpll_clock_quality_level {
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_PRC = 1,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_SSU_A = 2,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_SSU_B = 3,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_EEC1 = 4,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_PRTC = 5,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_EPRTC = 6,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_EEEC = 7,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_EPRC = 8,
	__DPLL_CLOCK_QUALITY_LEVEL_MAX = 9,
	DPLL_CLOCK_QUALITY_LEVEL_MAX = 8,
};

enum dpll_cmd {
	DPLL_CMD_DEVICE_ID_GET = 1,
	DPLL_CMD_DEVICE_GET = 2,
	DPLL_CMD_DEVICE_SET = 3,
	DPLL_CMD_DEVICE_CREATE_NTF = 4,
	DPLL_CMD_DEVICE_DELETE_NTF = 5,
	DPLL_CMD_DEVICE_CHANGE_NTF = 6,
	DPLL_CMD_PIN_ID_GET = 7,
	DPLL_CMD_PIN_GET = 8,
	DPLL_CMD_PIN_SET = 9,
	DPLL_CMD_PIN_CREATE_NTF = 10,
	DPLL_CMD_PIN_DELETE_NTF = 11,
	DPLL_CMD_PIN_CHANGE_NTF = 12,
	__DPLL_CMD_MAX = 13,
	DPLL_CMD_MAX = 12,
};

enum dpll_feature_state {
	DPLL_FEATURE_STATE_DISABLE = 0,
	DPLL_FEATURE_STATE_ENABLE = 1,
};

enum dpll_lock_status {
	DPLL_LOCK_STATUS_UNLOCKED = 1,
	DPLL_LOCK_STATUS_LOCKED = 2,
	DPLL_LOCK_STATUS_LOCKED_HO_ACQ = 3,
	DPLL_LOCK_STATUS_HOLDOVER = 4,
	__DPLL_LOCK_STATUS_MAX = 5,
	DPLL_LOCK_STATUS_MAX = 4,
};

enum dpll_lock_status_error {
	DPLL_LOCK_STATUS_ERROR_NONE = 1,
	DPLL_LOCK_STATUS_ERROR_UNDEFINED = 2,
	DPLL_LOCK_STATUS_ERROR_MEDIA_DOWN = 3,
	DPLL_LOCK_STATUS_ERROR_FRACTIONAL_FREQUENCY_OFFSET_TOO_HIGH = 4,
	__DPLL_LOCK_STATUS_ERROR_MAX = 5,
	DPLL_LOCK_STATUS_ERROR_MAX = 4,
};

enum dpll_mode {
	DPLL_MODE_MANUAL = 1,
	DPLL_MODE_AUTOMATIC = 2,
	__DPLL_MODE_MAX = 3,
	DPLL_MODE_MAX = 2,
};

enum dpll_pin_capabilities {
	DPLL_PIN_CAPABILITIES_DIRECTION_CAN_CHANGE = 1,
	DPLL_PIN_CAPABILITIES_PRIORITY_CAN_CHANGE = 2,
	DPLL_PIN_CAPABILITIES_STATE_CAN_CHANGE = 4,
};

enum dpll_pin_direction {
	DPLL_PIN_DIRECTION_INPUT = 1,
	DPLL_PIN_DIRECTION_OUTPUT = 2,
	__DPLL_PIN_DIRECTION_MAX = 3,
	DPLL_PIN_DIRECTION_MAX = 2,
};

enum dpll_pin_state {
	DPLL_PIN_STATE_CONNECTED = 1,
	DPLL_PIN_STATE_DISCONNECTED = 2,
	DPLL_PIN_STATE_SELECTABLE = 3,
	__DPLL_PIN_STATE_MAX = 4,
	DPLL_PIN_STATE_MAX = 3,
};

enum dpll_pin_type {
	DPLL_PIN_TYPE_MUX = 1,
	DPLL_PIN_TYPE_EXT = 2,
	DPLL_PIN_TYPE_SYNCE_ETH_PORT = 3,
	DPLL_PIN_TYPE_INT_OSCILLATOR = 4,
	DPLL_PIN_TYPE_GNSS = 5,
	__DPLL_PIN_TYPE_MAX = 6,
	DPLL_PIN_TYPE_MAX = 5,
};

enum dpll_type {
	DPLL_TYPE_PPS = 1,
	DPLL_TYPE_EEC = 2,
	__DPLL_TYPE_MAX = 3,
	DPLL_TYPE_MAX = 2,
};

enum dpm_order {
	DPM_ORDER_NONE = 0,
	DPM_ORDER_DEV_AFTER_PARENT = 1,
	DPM_ORDER_PARENT_BEFORE_DEV = 2,
	DPM_ORDER_DEV_LAST = 3,
};

enum drbg_prefixes {
	DRBG_PREFIX0 = 0,
	DRBG_PREFIX1 = 1,
	DRBG_PREFIX2 = 2,
	DRBG_PREFIX3 = 3,
};

enum drbg_seed_state {
	DRBG_SEED_STATE_UNSEEDED = 0,
	DRBG_SEED_STATE_PARTIAL = 1,
	DRBG_SEED_STATE_FULL = 2,
};

enum drm_bridge_attach_flags {
	DRM_BRIDGE_ATTACH_NO_CONNECTOR = 1,
};

enum drm_bridge_ops {
	DRM_BRIDGE_OP_DETECT = 1,
	DRM_BRIDGE_OP_EDID = 2,
	DRM_BRIDGE_OP_HPD = 4,
	DRM_BRIDGE_OP_MODES = 8,
	DRM_BRIDGE_OP_HDMI = 16,
	DRM_BRIDGE_OP_HDMI_AUDIO = 32,
	DRM_BRIDGE_OP_DP_AUDIO = 64,
	DRM_BRIDGE_OP_HDMI_CEC_NOTIFIER = 128,
	DRM_BRIDGE_OP_HDMI_CEC_ADAPTER = 256,
};

enum drm_bus_flags {
	DRM_BUS_FLAG_DE_LOW = 1,
	DRM_BUS_FLAG_DE_HIGH = 2,
	DRM_BUS_FLAG_PIXDATA_DRIVE_POSEDGE = 4,
	DRM_BUS_FLAG_PIXDATA_DRIVE_NEGEDGE = 8,
	DRM_BUS_FLAG_PIXDATA_SAMPLE_POSEDGE = 8,
	DRM_BUS_FLAG_PIXDATA_SAMPLE_NEGEDGE = 4,
	DRM_BUS_FLAG_DATA_MSB_TO_LSB = 16,
	DRM_BUS_FLAG_DATA_LSB_TO_MSB = 32,
	DRM_BUS_FLAG_SYNC_DRIVE_POSEDGE = 64,
	DRM_BUS_FLAG_SYNC_DRIVE_NEGEDGE = 128,
	DRM_BUS_FLAG_SYNC_SAMPLE_POSEDGE = 128,
	DRM_BUS_FLAG_SYNC_SAMPLE_NEGEDGE = 64,
	DRM_BUS_FLAG_SHARP_SIGNALS = 256,
};

enum drm_color_encoding {
	DRM_COLOR_YCBCR_BT601 = 0,
	DRM_COLOR_YCBCR_BT709 = 1,
	DRM_COLOR_YCBCR_BT2020 = 2,
	DRM_COLOR_ENCODING_MAX = 3,
};

enum drm_color_lut_tests {
	DRM_COLOR_LUT_EQUAL_CHANNELS = 1,
	DRM_COLOR_LUT_NON_DECREASING = 2,
};

enum drm_color_range {
	DRM_COLOR_YCBCR_LIMITED_RANGE = 0,
	DRM_COLOR_YCBCR_FULL_RANGE = 1,
	DRM_COLOR_RANGE_MAX = 2,
};

enum drm_colorspace {
	DRM_MODE_COLORIMETRY_DEFAULT = 0,
	DRM_MODE_COLORIMETRY_NO_DATA = 0,
	DRM_MODE_COLORIMETRY_SMPTE_170M_YCC = 1,
	DRM_MODE_COLORIMETRY_BT709_YCC = 2,
	DRM_MODE_COLORIMETRY_XVYCC_601 = 3,
	DRM_MODE_COLORIMETRY_XVYCC_709 = 4,
	DRM_MODE_COLORIMETRY_SYCC_601 = 5,
	DRM_MODE_COLORIMETRY_OPYCC_601 = 6,
	DRM_MODE_COLORIMETRY_OPRGB = 7,
	DRM_MODE_COLORIMETRY_BT2020_CYCC = 8,
	DRM_MODE_COLORIMETRY_BT2020_RGB = 9,
	DRM_MODE_COLORIMETRY_BT2020_YCC = 10,
	DRM_MODE_COLORIMETRY_DCI_P3_RGB_D65 = 11,
	DRM_MODE_COLORIMETRY_DCI_P3_RGB_THEATER = 12,
	DRM_MODE_COLORIMETRY_RGB_WIDE_FIXED = 13,
	DRM_MODE_COLORIMETRY_RGB_WIDE_FLOAT = 14,
	DRM_MODE_COLORIMETRY_BT601_YCC = 15,
	DRM_MODE_COLORIMETRY_COUNT = 16,
};

enum drm_connector_force {
	DRM_FORCE_UNSPECIFIED = 0,
	DRM_FORCE_OFF = 1,
	DRM_FORCE_ON = 2,
	DRM_FORCE_ON_DIGITAL = 3,
};

enum drm_connector_registration_state {
	DRM_CONNECTOR_INITIALIZING = 0,
	DRM_CONNECTOR_REGISTERED = 1,
	DRM_CONNECTOR_UNREGISTERED = 2,
};

enum drm_connector_status {
	connector_status_connected = 1,
	connector_status_disconnected = 2,
	connector_status_unknown = 3,
};

enum drm_connector_tv_mode {
	DRM_MODE_TV_MODE_NTSC = 0,
	DRM_MODE_TV_MODE_NTSC_443 = 1,
	DRM_MODE_TV_MODE_NTSC_J = 2,
	DRM_MODE_TV_MODE_PAL = 3,
	DRM_MODE_TV_MODE_PAL_M = 4,
	DRM_MODE_TV_MODE_PAL_N = 5,
	DRM_MODE_TV_MODE_SECAM = 6,
	DRM_MODE_TV_MODE_MONOCHROME = 7,
	DRM_MODE_TV_MODE_MAX = 8,
};

enum drm_debug_category {
	DRM_UT_CORE = 0,
	DRM_UT_DRIVER = 1,
	DRM_UT_KMS = 2,
	DRM_UT_PRIME = 3,
	DRM_UT_ATOMIC = 4,
	DRM_UT_VBL = 5,
	DRM_UT_STATE = 6,
	DRM_UT_LEASE = 7,
	DRM_UT_DP = 8,
	DRM_UT_DRMRES = 9,
};

enum drm_driver_feature {
	DRIVER_GEM = 1,
	DRIVER_MODESET = 2,
	DRIVER_RENDER = 8,
	DRIVER_ATOMIC = 16,
	DRIVER_SYNCOBJ = 32,
	DRIVER_SYNCOBJ_TIMELINE = 64,
	DRIVER_COMPUTE_ACCEL = 128,
	DRIVER_GEM_GPUVA = 256,
	DRIVER_CURSOR_HOTSPOT = 512,
	DRIVER_USE_AGP = 33554432,
	DRIVER_LEGACY = 67108864,
	DRIVER_PCI_DMA = 134217728,
	DRIVER_SG = 268435456,
	DRIVER_HAVE_DMA = 536870912,
	DRIVER_HAVE_IRQ = 1073741824,
};

enum drm_edid_internal_quirk {
	EDID_QUIRK_PREFER_LARGE_60 = 1,
	EDID_QUIRK_135_CLOCK_TOO_HIGH = 2,
	EDID_QUIRK_PREFER_LARGE_75 = 3,
	EDID_QUIRK_DETAILED_IN_CM = 4,
	EDID_QUIRK_DETAILED_USE_MAXIMUM_SIZE = 5,
	EDID_QUIRK_DETAILED_SYNC_PP = 6,
	EDID_QUIRK_FORCE_REDUCED_BLANKING = 7,
	EDID_QUIRK_FORCE_8BPC = 8,
	EDID_QUIRK_FORCE_12BPC = 9,
	EDID_QUIRK_FORCE_6BPC = 10,
	EDID_QUIRK_FORCE_10BPC = 11,
	EDID_QUIRK_NON_DESKTOP = 12,
	EDID_QUIRK_CAP_DSC_15BPP = 13,
};

enum drm_edid_quirk {
	DRM_EDID_QUIRK_DP_DPCD_PROBE = 0,
	DRM_EDID_QUIRK_NUM = 1,
};

enum drm_gem_object_status {
	DRM_GEM_OBJECT_RESIDENT = 1,
	DRM_GEM_OBJECT_PURGEABLE = 2,
	DRM_GEM_OBJECT_ACTIVE = 4,
};

enum drm_gpuva_flags {
	DRM_GPUVA_INVALIDATED = 1,
	DRM_GPUVA_SPARSE = 2,
	DRM_GPUVA_USERBITS = 4,
};

enum drm_gpuva_op_type {
	DRM_GPUVA_OP_MAP = 0,
	DRM_GPUVA_OP_REMAP = 1,
	DRM_GPUVA_OP_UNMAP = 2,
	DRM_GPUVA_OP_PREFETCH = 3,
	DRM_GPUVA_OP_DRIVER = 4,
};

enum drm_gpuvm_flags {
	DRM_GPUVM_RESV_PROTECTED = 1,
	DRM_GPUVM_USERBITS = 2,
};

enum drm_hdmi_broadcast_rgb {
	DRM_HDMI_BROADCAST_RGB_AUTO = 0,
	DRM_HDMI_BROADCAST_RGB_FULL = 1,
	DRM_HDMI_BROADCAST_RGB_LIMITED = 2,
};

enum drm_ioctl_flags {
	DRM_AUTH = 1,
	DRM_MASTER = 2,
	DRM_ROOT_ONLY = 4,
	DRM_RENDER_ALLOW = 32,
};

enum drm_link_status {
	DRM_LINK_STATUS_GOOD = 0,
	DRM_LINK_STATUS_BAD = 1,
};

enum drm_minor_type {
	DRM_MINOR_PRIMARY = 0,
	DRM_MINOR_CONTROL = 1,
	DRM_MINOR_RENDER = 2,
	DRM_MINOR_ACCEL = 32,
};

enum drm_mm_insert_mode {
	DRM_MM_INSERT_BEST = 0,
	DRM_MM_INSERT_LOW = 1,
	DRM_MM_INSERT_HIGH = 2,
	DRM_MM_INSERT_EVICT = 3,
	DRM_MM_INSERT_ONCE = 2147483648,
	DRM_MM_INSERT_HIGHEST = 2147483650,
	DRM_MM_INSERT_LOWEST = 2147483649,
};

enum drm_mode_analog {
	DRM_MODE_ANALOG_NTSC = 0,
	DRM_MODE_ANALOG_PAL = 1,
};

enum drm_mode_status {
	MODE_OK = 0,
	MODE_HSYNC = 1,
	MODE_VSYNC = 2,
	MODE_H_ILLEGAL = 3,
	MODE_V_ILLEGAL = 4,
	MODE_BAD_WIDTH = 5,
	MODE_NOMODE = 6,
	MODE_NO_INTERLACE = 7,
	MODE_NO_DBLESCAN = 8,
	MODE_NO_VSCAN = 9,
	MODE_MEM = 10,
	MODE_VIRTUAL_X = 11,
	MODE_VIRTUAL_Y = 12,
	MODE_MEM_VIRT = 13,
	MODE_NOCLOCK = 14,
	MODE_CLOCK_HIGH = 15,
	MODE_CLOCK_LOW = 16,
	MODE_CLOCK_RANGE = 17,
	MODE_BAD_HVALUE = 18,
	MODE_BAD_VVALUE = 19,
	MODE_BAD_VSCAN = 20,
	MODE_HSYNC_NARROW = 21,
	MODE_HSYNC_WIDE = 22,
	MODE_HBLANK_NARROW = 23,
	MODE_HBLANK_WIDE = 24,
	MODE_VSYNC_NARROW = 25,
	MODE_VSYNC_WIDE = 26,
	MODE_VBLANK_NARROW = 27,
	MODE_VBLANK_WIDE = 28,
	MODE_PANEL = 29,
	MODE_INTERLACE_WIDTH = 30,
	MODE_ONE_WIDTH = 31,
	MODE_ONE_HEIGHT = 32,
	MODE_ONE_SIZE = 33,
	MODE_NO_REDUCED = 34,
	MODE_NO_STEREO = 35,
	MODE_NO_420 = 36,
	MODE_STALE = -3,
	MODE_BAD = -2,
	MODE_ERROR = -1,
};

enum drm_mode_subconnector {
	DRM_MODE_SUBCONNECTOR_Automatic = 0,
	DRM_MODE_SUBCONNECTOR_Unknown = 0,
	DRM_MODE_SUBCONNECTOR_VGA = 1,
	DRM_MODE_SUBCONNECTOR_DVID = 3,
	DRM_MODE_SUBCONNECTOR_DVIA = 4,
	DRM_MODE_SUBCONNECTOR_Composite = 5,
	DRM_MODE_SUBCONNECTOR_SVIDEO = 6,
	DRM_MODE_SUBCONNECTOR_Component = 8,
	DRM_MODE_SUBCONNECTOR_SCART = 9,
	DRM_MODE_SUBCONNECTOR_DisplayPort = 10,
	DRM_MODE_SUBCONNECTOR_HDMIA = 11,
	DRM_MODE_SUBCONNECTOR_Native = 15,
	DRM_MODE_SUBCONNECTOR_Wireless = 18,
};

enum drm_panel_orientation {
	DRM_MODE_PANEL_ORIENTATION_UNKNOWN = -1,
	DRM_MODE_PANEL_ORIENTATION_NORMAL = 0,
	DRM_MODE_PANEL_ORIENTATION_BOTTOM_UP = 1,
	DRM_MODE_PANEL_ORIENTATION_LEFT_UP = 2,
	DRM_MODE_PANEL_ORIENTATION_RIGHT_UP = 3,
};

enum drm_plane_type {
	DRM_PLANE_TYPE_OVERLAY = 0,
	DRM_PLANE_TYPE_PRIMARY = 1,
	DRM_PLANE_TYPE_CURSOR = 2,
};

enum drm_privacy_screen_status {
	PRIVACY_SCREEN_DISABLED = 0,
	PRIVACY_SCREEN_ENABLED = 1,
	PRIVACY_SCREEN_DISABLED_LOCKED = 2,
	PRIVACY_SCREEN_ENABLED_LOCKED = 3,
};

enum drm_scaling_filter {
	DRM_SCALING_FILTER_DEFAULT = 0,
	DRM_SCALING_FILTER_NEAREST_NEIGHBOR = 1,
};

enum drm_stat_type {
	_DRM_STAT_LOCK = 0,
	_DRM_STAT_OPENS = 1,
	_DRM_STAT_CLOSES = 2,
	_DRM_STAT_IOCTLS = 3,
	_DRM_STAT_LOCKS = 4,
	_DRM_STAT_UNLOCKS = 5,
	_DRM_STAT_VALUE = 6,
	_DRM_STAT_BYTE = 7,
	_DRM_STAT_COUNT = 8,
	_DRM_STAT_IRQ = 9,
	_DRM_STAT_PRIMARY = 10,
	_DRM_STAT_SECONDARY = 11,
	_DRM_STAT_DMA = 12,
	_DRM_STAT_SPECIAL = 13,
	_DRM_STAT_MISSED = 14,
};

enum drm_vblank_seq_type {
	_DRM_VBLANK_ABSOLUTE = 0,
	_DRM_VBLANK_RELATIVE = 1,
	_DRM_VBLANK_HIGH_CRTC_MASK = 62,
	_DRM_VBLANK_EVENT = 67108864,
	_DRM_VBLANK_FLIP = 134217728,
	_DRM_VBLANK_NEXTONMISS = 268435456,
	_DRM_VBLANK_SECONDARY = 536870912,
	_DRM_VBLANK_SIGNAL = 1073741824,
};

enum dsa_db_type {
	DSA_DB_PORT = 0,
	DSA_DB_LAG = 1,
	DSA_DB_BRIDGE = 2,
};

enum dsa_tag_protocol {
	DSA_TAG_PROTO_NONE = 0,
	DSA_TAG_PROTO_BRCM = 1,
	DSA_TAG_PROTO_BRCM_LEGACY = 22,
	DSA_TAG_PROTO_BRCM_LEGACY_FCS = 29,
	DSA_TAG_PROTO_BRCM_PREPEND = 2,
	DSA_TAG_PROTO_DSA = 3,
	DSA_TAG_PROTO_EDSA = 4,
	DSA_TAG_PROTO_GSWIP = 5,
	DSA_TAG_PROTO_KSZ9477 = 6,
	DSA_TAG_PROTO_KSZ9893 = 7,
	DSA_TAG_PROTO_LAN9303 = 8,
	DSA_TAG_PROTO_MTK = 9,
	DSA_TAG_PROTO_QCA = 10,
	DSA_TAG_PROTO_TRAILER = 11,
	DSA_TAG_PROTO_8021Q = 12,
	DSA_TAG_PROTO_SJA1105 = 13,
	DSA_TAG_PROTO_KSZ8795 = 14,
	DSA_TAG_PROTO_OCELOT = 15,
	DSA_TAG_PROTO_AR9331 = 16,
	DSA_TAG_PROTO_RTL4_A = 17,
	DSA_TAG_PROTO_HELLCREEK = 18,
	DSA_TAG_PROTO_XRS700X = 19,
	DSA_TAG_PROTO_OCELOT_8021Q = 20,
	DSA_TAG_PROTO_SEVILLE = 21,
	DSA_TAG_PROTO_SJA1110 = 23,
	DSA_TAG_PROTO_RTL8_4 = 24,
	DSA_TAG_PROTO_RTL8_4T = 25,
	DSA_TAG_PROTO_RZN1_A5PSW = 26,
	DSA_TAG_PROTO_LAN937X = 27,
	DSA_TAG_PROTO_VSC73XX_8021Q = 28,
};

enum dw_dma_fc {
	DW_DMA_FC_D_M2M = 0,
	DW_DMA_FC_D_M2P = 1,
	DW_DMA_FC_D_P2M = 2,
	DW_DMA_FC_D_P2P = 3,
	DW_DMA_FC_P_P2M = 4,
	DW_DMA_FC_SP_P2P = 5,
	DW_DMA_FC_P_M2P = 6,
	DW_DMA_FC_DP_P2P = 7,
};

enum dw_dmac_flags {
	DW_DMA_IS_CYCLIC = 0,
	DW_DMA_IS_SOFT_LLP = 1,
	DW_DMA_IS_PAUSED = 2,
	DW_DMA_IS_INITIALIZED = 3,
};

enum dw_edma_chip_flags {
	DW_EDMA_CHIP_LOCAL = 1,
};

enum dw_edma_map_format {
	EDMA_MF_EDMA_LEGACY = 0,
	EDMA_MF_EDMA_UNROLL = 1,
	EDMA_MF_HDMA_COMPAT = 5,
	EDMA_MF_HDMA_NATIVE = 7,
};

enum dw_pci_ctl_id_t {
	medfield = 0,
	merrifield = 1,
	baytrail = 2,
	cherrytrail = 3,
	haswell = 4,
	elkhartlake = 5,
	navi_amd = 6,
};

enum dw_pcie_app_clk {
	DW_PCIE_DBI_CLK = 0,
	DW_PCIE_MSTR_CLK = 1,
	DW_PCIE_SLV_CLK = 2,
	DW_PCIE_NUM_APP_CLKS = 3,
};

enum dw_pcie_app_rst {
	DW_PCIE_DBI_RST = 0,
	DW_PCIE_MSTR_RST = 1,
	DW_PCIE_SLV_RST = 2,
	DW_PCIE_NUM_APP_RSTS = 3,
};

enum dw_pcie_core_clk {
	DW_PCIE_PIPE_CLK = 0,
	DW_PCIE_CORE_CLK = 1,
	DW_PCIE_AUX_CLK = 2,
	DW_PCIE_REF_CLK = 3,
	DW_PCIE_NUM_CORE_CLKS = 4,
};

enum dw_pcie_core_rst {
	DW_PCIE_NON_STICKY_RST = 0,
	DW_PCIE_STICKY_RST = 1,
	DW_PCIE_CORE_RST = 2,
	DW_PCIE_PIPE_RST = 3,
	DW_PCIE_PHY_RST = 4,
	DW_PCIE_HOT_RST = 5,
	DW_PCIE_PWR_RST = 6,
	DW_PCIE_NUM_CORE_RSTS = 7,
};

enum dw_pcie_device_mode {
	DW_PCIE_UNKNOWN_TYPE = 0,
	DW_PCIE_EP_TYPE = 1,
	DW_PCIE_LEG_EP_TYPE = 2,
	DW_PCIE_RC_TYPE = 3,
};

enum dw_pcie_ltssm {
	DW_PCIE_LTSSM_DETECT_QUIET = 0,
	DW_PCIE_LTSSM_DETECT_ACT = 1,
	DW_PCIE_LTSSM_POLL_ACTIVE = 2,
	DW_PCIE_LTSSM_POLL_COMPLIANCE = 3,
	DW_PCIE_LTSSM_POLL_CONFIG = 4,
	DW_PCIE_LTSSM_PRE_DETECT_QUIET = 5,
	DW_PCIE_LTSSM_DETECT_WAIT = 6,
	DW_PCIE_LTSSM_CFG_LINKWD_START = 7,
	DW_PCIE_LTSSM_CFG_LINKWD_ACEPT = 8,
	DW_PCIE_LTSSM_CFG_LANENUM_WAI = 9,
	DW_PCIE_LTSSM_CFG_LANENUM_ACEPT = 10,
	DW_PCIE_LTSSM_CFG_COMPLETE = 11,
	DW_PCIE_LTSSM_CFG_IDLE = 12,
	DW_PCIE_LTSSM_RCVRY_LOCK = 13,
	DW_PCIE_LTSSM_RCVRY_SPEED = 14,
	DW_PCIE_LTSSM_RCVRY_RCVRCFG = 15,
	DW_PCIE_LTSSM_RCVRY_IDLE = 16,
	DW_PCIE_LTSSM_L0 = 17,
	DW_PCIE_LTSSM_L0S = 18,
	DW_PCIE_LTSSM_L123_SEND_EIDLE = 19,
	DW_PCIE_LTSSM_L1_IDLE = 20,
	DW_PCIE_LTSSM_L2_IDLE = 21,
	DW_PCIE_LTSSM_L2_WAKE = 22,
	DW_PCIE_LTSSM_DISABLED_ENTRY = 23,
	DW_PCIE_LTSSM_DISABLED_IDLE = 24,
	DW_PCIE_LTSSM_DISABLED = 25,
	DW_PCIE_LTSSM_LPBK_ENTRY = 26,
	DW_PCIE_LTSSM_LPBK_ACTIVE = 27,
	DW_PCIE_LTSSM_LPBK_EXIT = 28,
	DW_PCIE_LTSSM_LPBK_EXIT_TIMEOUT = 29,
	DW_PCIE_LTSSM_HOT_RESET_ENTRY = 30,
	DW_PCIE_LTSSM_HOT_RESET = 31,
	DW_PCIE_LTSSM_RCVRY_EQ0 = 32,
	DW_PCIE_LTSSM_RCVRY_EQ1 = 33,
	DW_PCIE_LTSSM_RCVRY_EQ2 = 34,
	DW_PCIE_LTSSM_RCVRY_EQ3 = 35,
	DW_PCIE_LTSSM_UNKNOWN = 4294967295,
};

enum dynevent_type {
	DYNEVENT_TYPE_SYNTH = 1,
	DYNEVENT_TYPE_KPROBE = 2,
	DYNEVENT_TYPE_NONE = 3,
};

enum e820_type {
	E820_TYPE_RAM = 1,
	E820_TYPE_RESERVED = 2,
	E820_TYPE_ACPI = 3,
	E820_TYPE_NVS = 4,
	E820_TYPE_UNUSABLE = 5,
	E820_TYPE_PMEM = 7,
	E820_TYPE_PRAM = 12,
	E820_TYPE_SOFT_RESERVED = 4026531839,
};

enum ec_command {
	ACPI_EC_COMMAND_READ = 128,
	ACPI_EC_COMMAND_WRITE = 129,
	ACPI_EC_BURST_ENABLE = 130,
	ACPI_EC_BURST_DISABLE = 131,
	ACPI_EC_COMMAND_QUERY = 132,
};

enum ecdsasignature_actions {
	ACT_ecdsa_get_signature_r = 0,
	ACT_ecdsa_get_signature_s = 1,
	NR__ecdsasignature_actions = 2,
};

enum edac_dev_feat {
	RAS_FEAT_SCRUB = 0,
	RAS_FEAT_ECS = 1,
	RAS_FEAT_MEM_REPAIR = 2,
	RAS_FEAT_MAX = 3,
};

enum edac_ecs_attributes {
	ECS_LOG_ENTRY_TYPE = 0,
	ECS_MODE = 1,
	ECS_RESET = 2,
	ECS_THRESHOLD = 3,
	ECS_MAX_ATTRS = 4,
};

enum edac_mc_layer_type {
	EDAC_MC_LAYER_BRANCH = 0,
	EDAC_MC_LAYER_CHANNEL = 1,
	EDAC_MC_LAYER_SLOT = 2,
	EDAC_MC_LAYER_CHIP_SELECT = 3,
	EDAC_MC_LAYER_ALL_MEM = 4,
};

enum edac_mem_repair_attributes {
	MR_TYPE = 0,
	MR_PERSIST_MODE = 1,
	MR_SAFE_IN_USE = 2,
	MR_HPA = 3,
	MR_MIN_HPA = 4,
	MR_MAX_HPA = 5,
	MR_DPA = 6,
	MR_MIN_DPA = 7,
	MR_MAX_DPA = 8,
	MR_NIBBLE_MASK = 9,
	MR_BANK_GROUP = 10,
	MR_BANK = 11,
	MR_RANK = 12,
	MR_ROW = 13,
	MR_COLUMN = 14,
	MR_CHANNEL = 15,
	MR_SUB_CHANNEL = 16,
	MEM_DO_REPAIR = 17,
	MR_MAX_ATTRS = 18,
};

enum edac_mem_repair_type {
	EDAC_REPAIR_PPR = 0,
	EDAC_REPAIR_CACHELINE_SPARING = 1,
	EDAC_REPAIR_ROW_SPARING = 2,
	EDAC_REPAIR_BANK_SPARING = 3,
	EDAC_REPAIR_RANK_SPARING = 4,
	EDAC_REPAIR_MAX = 5,
};

enum edac_scrub_attributes {
	SCRUB_ADDRESS = 0,
	SCRUB_SIZE = 1,
	SCRUB_ENABLE_BACKGROUND = 2,
	SCRUB_MIN_CYCLE_DURATION = 3,
	SCRUB_MAX_CYCLE_DURATION = 4,
	SCRUB_CUR_CYCLE_DURATION = 5,
	SCRUB_MAX_ATTRS = 6,
};

enum edac_type {
	EDAC_UNKNOWN = 0,
	EDAC_NONE = 1,
	EDAC_RESERVED = 2,
	EDAC_PARITY = 3,
	EDAC_EC = 4,
	EDAC_SECDED = 5,
	EDAC_S2ECD2ED = 6,
	EDAC_S4ECD4ED = 7,
	EDAC_S8ECD8ED = 8,
	EDAC_S16ECD16ED = 9,
};

enum edid_block_status {
	EDID_BLOCK_OK = 0,
	EDID_BLOCK_READ_FAIL = 1,
	EDID_BLOCK_NULL = 2,
	EDID_BLOCK_ZERO = 3,
	EDID_BLOCK_HEADER_CORRUPT = 4,
	EDID_BLOCK_HEADER_REPAIR = 5,
	EDID_BLOCK_HEADER_FIXED = 6,
	EDID_BLOCK_CHECKSUM = 7,
	EDID_BLOCK_VERSION = 8,
};

enum efi_rts_ids {
	EFI_NONE = 0,
	EFI_GET_TIME = 1,
	EFI_SET_TIME = 2,
	EFI_GET_WAKEUP_TIME = 3,
	EFI_SET_WAKEUP_TIME = 4,
	EFI_GET_VARIABLE = 5,
	EFI_GET_NEXT_VARIABLE = 6,
	EFI_SET_VARIABLE = 7,
	EFI_QUERY_VARIABLE_INFO = 8,
	EFI_GET_NEXT_HIGH_MONO_COUNT = 9,
	EFI_RESET_SYSTEM = 10,
	EFI_UPDATE_CAPSULE = 11,
	EFI_QUERY_CAPSULE_CAPS = 12,
	EFI_ACPI_PRM_HANDLER = 13,
};

enum efi_secureboot_mode {
	efi_secureboot_mode_unset = 0,
	efi_secureboot_mode_unknown = 1,
	efi_secureboot_mode_disabled = 2,
	efi_secureboot_mode_enabled = 3,
};

enum ehci_hrtimer_event {
	EHCI_HRTIMER_POLL_ASS = 0,
	EHCI_HRTIMER_POLL_PSS = 1,
	EHCI_HRTIMER_POLL_DEAD = 2,
	EHCI_HRTIMER_UNLINK_INTR = 3,
	EHCI_HRTIMER_FREE_ITDS = 4,
	EHCI_HRTIMER_ACTIVE_UNLINK = 5,
	EHCI_HRTIMER_START_UNLINK_INTR = 6,
	EHCI_HRTIMER_ASYNC_UNLINKS = 7,
	EHCI_HRTIMER_IAA_WATCHDOG = 8,
	EHCI_HRTIMER_DISABLE_PERIODIC = 9,
	EHCI_HRTIMER_DISABLE_ASYNC = 10,
	EHCI_HRTIMER_IO_WATCHDOG = 11,
	EHCI_HRTIMER_NUM_EVENTS = 12,
};

enum ehci_rh_state {
	EHCI_RH_HALTED = 0,
	EHCI_RH_SUSPENDED = 1,
	EHCI_RH_RUNNING = 2,
	EHCI_RH_STOPPING = 3,
};

enum elv_merge {
	ELEVATOR_NO_MERGE = 0,
	ELEVATOR_FRONT_MERGE = 1,
	ELEVATOR_BACK_MERGE = 2,
	ELEVATOR_DISCARD_MERGE = 3,
};

enum enable_type {
	undefined = -1,
	user_disabled = 0,
	auto_disabled = 1,
	user_enabled = 2,
	auto_enabled = 3,
};

enum energy_perf_value_index {
	EPB_INDEX_PERFORMANCE = 0,
	EPB_INDEX_BALANCE_PERFORMANCE = 1,
	EPB_INDEX_NORMAL = 2,
	EPB_INDEX_BALANCE_POWERSAVE = 3,
	EPB_INDEX_POWERSAVE = 4,
};

enum energy_perf_value_index___2 {
	EPP_INDEX_DEFAULT = 0,
	EPP_INDEX_PERFORMANCE = 1,
	EPP_INDEX_BALANCE_PERFORMANCE = 2,
	EPP_INDEX_BALANCE_POWERSAVE = 3,
	EPP_INDEX_POWERSAVE = 4,
};

enum environment_cap {
	ENVIRON_ANY = 0,
	ENVIRON_INDOOR = 1,
	ENVIRON_OUTDOOR = 2,
};

enum equalization_preset_type {
	EQ_PRESET_TYPE_8GTS = 0,
	EQ_PRESET_TYPE_16GTS = 1,
	EQ_PRESET_TYPE_32GTS = 2,
	EQ_PRESET_TYPE_64GTS = 3,
	EQ_PRESET_TYPE_MAX = 4,
};

enum err_types {
	ERR_TYPE_CACHE = 0,
	ERR_TYPE_TLB = 1,
	ERR_TYPE_BUS = 2,
	ERR_TYPE_MS = 3,
	N_ERR_TYPES = 4,
};

enum error_detector {
	ERROR_DETECTOR_KFENCE = 0,
	ERROR_DETECTOR_KASAN = 1,
	ERROR_DETECTOR_WARN = 2,
};

enum es_result {
	ES_OK = 0,
	ES_UNSUPPORTED = 1,
	ES_VMM_ERROR = 2,
	ES_DECODE_FAILED = 3,
	ES_EXCEPTION = 4,
	ES_RETRY = 5,
};

enum ethnl_sock_type {
	ETHTOOL_SOCK_TYPE_MODULE_FW_FLASH = 0,
};

enum ethtool_c33_pse_admin_state {
	ETHTOOL_C33_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_C33_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_C33_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_c33_pse_ext_state {
	ETHTOOL_C33_PSE_EXT_STATE_ERROR_CONDITION = 1,
	ETHTOOL_C33_PSE_EXT_STATE_MR_MPS_VALID = 2,
	ETHTOOL_C33_PSE_EXT_STATE_MR_PSE_ENABLE = 3,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_DETECT_TED = 4,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_VPORT_LIM = 5,
	ETHTOOL_C33_PSE_EXT_STATE_OVLD_DETECTED = 6,
	ETHTOOL_C33_PSE_EXT_STATE_PD_DLL_POWER_TYPE = 7,
	ETHTOOL_C33_PSE_EXT_STATE_POWER_NOT_AVAILABLE = 8,
	ETHTOOL_C33_PSE_EXT_STATE_SHORT_DETECTED = 9,
};

enum ethtool_c33_pse_ext_substate_error_condition {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_NON_EXISTING_PORT = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNDEFINED_PORT = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_INTERNAL_HW_FAULT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_COMM_ERROR_AFTER_FORCE_ON = 4,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNKNOWN_PORT_STATUS = 5,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_TURN_OFF = 6,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_FORCE_SHUTDOWN = 7,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_CONFIG_CHANGE = 8,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_DETECTED_OVER_TEMP = 9,
};

enum ethtool_c33_pse_ext_substate_mr_pse_enable {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_MR_PSE_ENABLE_DISABLE_PIN_ACTIVE = 1,
};

enum ethtool_c33_pse_ext_substate_option_detect_ted {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_DET_IN_PROCESS = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_CONNECTION_CHECK_ERROR = 2,
};

enum ethtool_c33_pse_ext_substate_option_vport_lim {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_HIGH_VOLTAGE = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_LOW_VOLTAGE = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_VOLTAGE_INJECTION = 3,
};

enum ethtool_c33_pse_ext_substate_ovld_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OVLD_DETECTED_OVERLOAD = 1,
};

enum ethtool_c33_pse_ext_substate_power_not_available {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_BUDGET_EXCEEDED = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PORT_PW_LIMIT_EXCEEDS_CONTROLLER_BUDGET = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PD_REQUEST_EXCEEDS_PORT_LIMIT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_HW_PW_LIMIT = 4,
};

enum ethtool_c33_pse_ext_substate_short_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_SHORT_DETECTED_SHORT_CONDITION = 1,
};

enum ethtool_c33_pse_pw_d_status {
	ETHTOOL_C33_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_C33_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_C33_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_C33_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_C33_PSE_PW_D_STATUS_TEST = 5,
	ETHTOOL_C33_PSE_PW_D_STATUS_FAULT = 6,
	ETHTOOL_C33_PSE_PW_D_STATUS_OTHERFAULT = 7,
};

enum ethtool_cmis_cdb_cmd_id {
	ETHTOOL_CMIS_CDB_CMD_QUERY_STATUS = 0,
	ETHTOOL_CMIS_CDB_CMD_MODULE_FEATURES = 64,
	ETHTOOL_CMIS_CDB_CMD_FW_MANAGMENT_FEATURES = 65,
	ETHTOOL_CMIS_CDB_CMD_START_FW_DOWNLOAD = 257,
	ETHTOOL_CMIS_CDB_CMD_WRITE_FW_BLOCK_LPL = 259,
	ETHTOOL_CMIS_CDB_CMD_WRITE_FW_BLOCK_EPL = 260,
	ETHTOOL_CMIS_CDB_CMD_COMPLETE_FW_DOWNLOAD = 263,
	ETHTOOL_CMIS_CDB_CMD_RUN_FW_IMAGE = 265,
	ETHTOOL_CMIS_CDB_CMD_COMMIT_FW_IMAGE = 266,
};

enum ethtool_fec_config_bits {
	ETHTOOL_FEC_NONE_BIT = 0,
	ETHTOOL_FEC_AUTO_BIT = 1,
	ETHTOOL_FEC_OFF_BIT = 2,
	ETHTOOL_FEC_RS_BIT = 3,
	ETHTOOL_FEC_BASER_BIT = 4,
	ETHTOOL_FEC_LLRS_BIT = 5,
};

enum ethtool_flags {
	ETH_FLAG_TXVLAN = 128,
	ETH_FLAG_RXVLAN = 256,
	ETH_FLAG_LRO = 32768,
	ETH_FLAG_NTUPLE = 134217728,
	ETH_FLAG_RXHASH = 268435456,
};

enum ethtool_header_flags {
	ETHTOOL_FLAG_COMPACT_BITSETS = 1,
	ETHTOOL_FLAG_OMIT_REPLY = 2,
	ETHTOOL_FLAG_STATS = 4,
};

enum ethtool_link_ext_state {
	ETHTOOL_LINK_EXT_STATE_AUTONEG = 0,
	ETHTOOL_LINK_EXT_STATE_LINK_TRAINING_FAILURE = 1,
	ETHTOOL_LINK_EXT_STATE_LINK_LOGICAL_MISMATCH = 2,
	ETHTOOL_LINK_EXT_STATE_BAD_SIGNAL_INTEGRITY = 3,
	ETHTOOL_LINK_EXT_STATE_NO_CABLE = 4,
	ETHTOOL_LINK_EXT_STATE_CABLE_ISSUE = 5,
	ETHTOOL_LINK_EXT_STATE_EEPROM_ISSUE = 6,
	ETHTOOL_LINK_EXT_STATE_CALIBRATION_FAILURE = 7,
	ETHTOOL_LINK_EXT_STATE_POWER_BUDGET_EXCEEDED = 8,
	ETHTOOL_LINK_EXT_STATE_OVERHEAT = 9,
	ETHTOOL_LINK_EXT_STATE_MODULE = 10,
};

enum ethtool_link_ext_substate_autoneg {
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_ACK_NOT_RECEIVED = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NEXT_PAGE_EXCHANGE_FAILED = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED_FORCE_MODE = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_FEC_MISMATCH_DURING_OVERRIDE = 5,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_HCD = 6,
};

enum ethtool_link_ext_substate_bad_signal_integrity {
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_LARGE_NUMBER_OF_PHYSICAL_ERRORS = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_UNSUPPORTED_RATE = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_REFERENCE_CLOCK_LOST = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_ALOS = 4,
};

enum ethtool_link_ext_substate_cable_issue {
	ETHTOOL_LINK_EXT_SUBSTATE_CI_UNSUPPORTED_CABLE = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_CI_CABLE_TEST_FAILURE = 2,
};

enum ethtool_link_ext_substate_link_logical_mismatch {
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_BLOCK_LOCK = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_AM_LOCK = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_GET_ALIGN_STATUS = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_FC_FEC_IS_NOT_LOCKED = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_RS_FEC_IS_NOT_LOCKED = 5,
};

enum ethtool_link_ext_substate_link_training {
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_FRAME_LOCK_NOT_ACQUIRED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_INHIBIT_TIMEOUT = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_PARTNER_DID_NOT_SET_RECEIVER_READY = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_REMOTE_FAULT = 4,
};

enum ethtool_link_ext_substate_module {
	ETHTOOL_LINK_EXT_SUBSTATE_MODULE_CMIS_NOT_READY = 1,
};

enum ethtool_link_mode_bit_indices {
	ETHTOOL_LINK_MODE_10baseT_Half_BIT = 0,
	ETHTOOL_LINK_MODE_10baseT_Full_BIT = 1,
	ETHTOOL_LINK_MODE_100baseT_Half_BIT = 2,
	ETHTOOL_LINK_MODE_100baseT_Full_BIT = 3,
	ETHTOOL_LINK_MODE_1000baseT_Half_BIT = 4,
	ETHTOOL_LINK_MODE_1000baseT_Full_BIT = 5,
	ETHTOOL_LINK_MODE_Autoneg_BIT = 6,
	ETHTOOL_LINK_MODE_TP_BIT = 7,
	ETHTOOL_LINK_MODE_AUI_BIT = 8,
	ETHTOOL_LINK_MODE_MII_BIT = 9,
	ETHTOOL_LINK_MODE_FIBRE_BIT = 10,
	ETHTOOL_LINK_MODE_BNC_BIT = 11,
	ETHTOOL_LINK_MODE_10000baseT_Full_BIT = 12,
	ETHTOOL_LINK_MODE_Pause_BIT = 13,
	ETHTOOL_LINK_MODE_Asym_Pause_BIT = 14,
	ETHTOOL_LINK_MODE_2500baseX_Full_BIT = 15,
	ETHTOOL_LINK_MODE_Backplane_BIT = 16,
	ETHTOOL_LINK_MODE_1000baseKX_Full_BIT = 17,
	ETHTOOL_LINK_MODE_10000baseKX4_Full_BIT = 18,
	ETHTOOL_LINK_MODE_10000baseKR_Full_BIT = 19,
	ETHTOOL_LINK_MODE_10000baseR_FEC_BIT = 20,
	ETHTOOL_LINK_MODE_20000baseMLD2_Full_BIT = 21,
	ETHTOOL_LINK_MODE_20000baseKR2_Full_BIT = 22,
	ETHTOOL_LINK_MODE_40000baseKR4_Full_BIT = 23,
	ETHTOOL_LINK_MODE_40000baseCR4_Full_BIT = 24,
	ETHTOOL_LINK_MODE_40000baseSR4_Full_BIT = 25,
	ETHTOOL_LINK_MODE_40000baseLR4_Full_BIT = 26,
	ETHTOOL_LINK_MODE_56000baseKR4_Full_BIT = 27,
	ETHTOOL_LINK_MODE_56000baseCR4_Full_BIT = 28,
	ETHTOOL_LINK_MODE_56000baseSR4_Full_BIT = 29,
	ETHTOOL_LINK_MODE_56000baseLR4_Full_BIT = 30,
	ETHTOOL_LINK_MODE_25000baseCR_Full_BIT = 31,
	ETHTOOL_LINK_MODE_25000baseKR_Full_BIT = 32,
	ETHTOOL_LINK_MODE_25000baseSR_Full_BIT = 33,
	ETHTOOL_LINK_MODE_50000baseCR2_Full_BIT = 34,
	ETHTOOL_LINK_MODE_50000baseKR2_Full_BIT = 35,
	ETHTOOL_LINK_MODE_100000baseKR4_Full_BIT = 36,
	ETHTOOL_LINK_MODE_100000baseSR4_Full_BIT = 37,
	ETHTOOL_LINK_MODE_100000baseCR4_Full_BIT = 38,
	ETHTOOL_LINK_MODE_100000baseLR4_ER4_Full_BIT = 39,
	ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT = 40,
	ETHTOOL_LINK_MODE_1000baseX_Full_BIT = 41,
	ETHTOOL_LINK_MODE_10000baseCR_Full_BIT = 42,
	ETHTOOL_LINK_MODE_10000baseSR_Full_BIT = 43,
	ETHTOOL_LINK_MODE_10000baseLR_Full_BIT = 44,
	ETHTOOL_LINK_MODE_10000baseLRM_Full_BIT = 45,
	ETHTOOL_LINK_MODE_10000baseER_Full_BIT = 46,
	ETHTOOL_LINK_MODE_2500baseT_Full_BIT = 47,
	ETHTOOL_LINK_MODE_5000baseT_Full_BIT = 48,
	ETHTOOL_LINK_MODE_FEC_NONE_BIT = 49,
	ETHTOOL_LINK_MODE_FEC_RS_BIT = 50,
	ETHTOOL_LINK_MODE_FEC_BASER_BIT = 51,
	ETHTOOL_LINK_MODE_50000baseKR_Full_BIT = 52,
	ETHTOOL_LINK_MODE_50000baseSR_Full_BIT = 53,
	ETHTOOL_LINK_MODE_50000baseCR_Full_BIT = 54,
	ETHTOOL_LINK_MODE_50000baseLR_ER_FR_Full_BIT = 55,
	ETHTOOL_LINK_MODE_50000baseDR_Full_BIT = 56,
	ETHTOOL_LINK_MODE_100000baseKR2_Full_BIT = 57,
	ETHTOOL_LINK_MODE_100000baseSR2_Full_BIT = 58,
	ETHTOOL_LINK_MODE_100000baseCR2_Full_BIT = 59,
	ETHTOOL_LINK_MODE_100000baseLR2_ER2_FR2_Full_BIT = 60,
	ETHTOOL_LINK_MODE_100000baseDR2_Full_BIT = 61,
	ETHTOOL_LINK_MODE_200000baseKR4_Full_BIT = 62,
	ETHTOOL_LINK_MODE_200000baseSR4_Full_BIT = 63,
	ETHTOOL_LINK_MODE_200000baseLR4_ER4_FR4_Full_BIT = 64,
	ETHTOOL_LINK_MODE_200000baseDR4_Full_BIT = 65,
	ETHTOOL_LINK_MODE_200000baseCR4_Full_BIT = 66,
	ETHTOOL_LINK_MODE_100baseT1_Full_BIT = 67,
	ETHTOOL_LINK_MODE_1000baseT1_Full_BIT = 68,
	ETHTOOL_LINK_MODE_400000baseKR8_Full_BIT = 69,
	ETHTOOL_LINK_MODE_400000baseSR8_Full_BIT = 70,
	ETHTOOL_LINK_MODE_400000baseLR8_ER8_FR8_Full_BIT = 71,
	ETHTOOL_LINK_MODE_400000baseDR8_Full_BIT = 72,
	ETHTOOL_LINK_MODE_400000baseCR8_Full_BIT = 73,
	ETHTOOL_LINK_MODE_FEC_LLRS_BIT = 74,
	ETHTOOL_LINK_MODE_100000baseKR_Full_BIT = 75,
	ETHTOOL_LINK_MODE_100000baseSR_Full_BIT = 76,
	ETHTOOL_LINK_MODE_100000baseLR_ER_FR_Full_BIT = 77,
	ETHTOOL_LINK_MODE_100000baseCR_Full_BIT = 78,
	ETHTOOL_LINK_MODE_100000baseDR_Full_BIT = 79,
	ETHTOOL_LINK_MODE_200000baseKR2_Full_BIT = 80,
	ETHTOOL_LINK_MODE_200000baseSR2_Full_BIT = 81,
	ETHTOOL_LINK_MODE_200000baseLR2_ER2_FR2_Full_BIT = 82,
	ETHTOOL_LINK_MODE_200000baseDR2_Full_BIT = 83,
	ETHTOOL_LINK_MODE_200000baseCR2_Full_BIT = 84,
	ETHTOOL_LINK_MODE_400000baseKR4_Full_BIT = 85,
	ETHTOOL_LINK_MODE_400000baseSR4_Full_BIT = 86,
	ETHTOOL_LINK_MODE_400000baseLR4_ER4_FR4_Full_BIT = 87,
	ETHTOOL_LINK_MODE_400000baseDR4_Full_BIT = 88,
	ETHTOOL_LINK_MODE_400000baseCR4_Full_BIT = 89,
	ETHTOOL_LINK_MODE_100baseFX_Half_BIT = 90,
	ETHTOOL_LINK_MODE_100baseFX_Full_BIT = 91,
	ETHTOOL_LINK_MODE_10baseT1L_Full_BIT = 92,
	ETHTOOL_LINK_MODE_800000baseCR8_Full_BIT = 93,
	ETHTOOL_LINK_MODE_800000baseKR8_Full_BIT = 94,
	ETHTOOL_LINK_MODE_800000baseDR8_Full_BIT = 95,
	ETHTOOL_LINK_MODE_800000baseDR8_2_Full_BIT = 96,
	ETHTOOL_LINK_MODE_800000baseSR8_Full_BIT = 97,
	ETHTOOL_LINK_MODE_800000baseVR8_Full_BIT = 98,
	ETHTOOL_LINK_MODE_10baseT1S_Full_BIT = 99,
	ETHTOOL_LINK_MODE_10baseT1S_Half_BIT = 100,
	ETHTOOL_LINK_MODE_10baseT1S_P2MP_Half_BIT = 101,
	ETHTOOL_LINK_MODE_10baseT1BRR_Full_BIT = 102,
	ETHTOOL_LINK_MODE_200000baseCR_Full_BIT = 103,
	ETHTOOL_LINK_MODE_200000baseKR_Full_BIT = 104,
	ETHTOOL_LINK_MODE_200000baseDR_Full_BIT = 105,
	ETHTOOL_LINK_MODE_200000baseDR_2_Full_BIT = 106,
	ETHTOOL_LINK_MODE_200000baseSR_Full_BIT = 107,
	ETHTOOL_LINK_MODE_200000baseVR_Full_BIT = 108,
	ETHTOOL_LINK_MODE_400000baseCR2_Full_BIT = 109,
	ETHTOOL_LINK_MODE_400000baseKR2_Full_BIT = 110,
	ETHTOOL_LINK_MODE_400000baseDR2_Full_BIT = 111,
	ETHTOOL_LINK_MODE_400000baseDR2_2_Full_BIT = 112,
	ETHTOOL_LINK_MODE_400000baseSR2_Full_BIT = 113,
	ETHTOOL_LINK_MODE_400000baseVR2_Full_BIT = 114,
	ETHTOOL_LINK_MODE_800000baseCR4_Full_BIT = 115,
	ETHTOOL_LINK_MODE_800000baseKR4_Full_BIT = 116,
	ETHTOOL_LINK_MODE_800000baseDR4_Full_BIT = 117,
	ETHTOOL_LINK_MODE_800000baseDR4_2_Full_BIT = 118,
	ETHTOOL_LINK_MODE_800000baseSR4_Full_BIT = 119,
	ETHTOOL_LINK_MODE_800000baseVR4_Full_BIT = 120,
	__ETHTOOL_LINK_MODE_MASK_NBITS = 121,
};

enum ethtool_mac_stats_src {
	ETHTOOL_MAC_STATS_SRC_AGGREGATE = 0,
	ETHTOOL_MAC_STATS_SRC_EMAC = 1,
	ETHTOOL_MAC_STATS_SRC_PMAC = 2,
};

enum ethtool_mm_verify_status {
	ETHTOOL_MM_VERIFY_STATUS_UNKNOWN = 0,
	ETHTOOL_MM_VERIFY_STATUS_INITIAL = 1,
	ETHTOOL_MM_VERIFY_STATUS_VERIFYING = 2,
	ETHTOOL_MM_VERIFY_STATUS_SUCCEEDED = 3,
	ETHTOOL_MM_VERIFY_STATUS_FAILED = 4,
	ETHTOOL_MM_VERIFY_STATUS_DISABLED = 5,
};

enum ethtool_mmsv_event {
	ETHTOOL_MMSV_LP_SENT_VERIFY_MPACKET = 0,
	ETHTOOL_MMSV_LD_SENT_VERIFY_MPACKET = 1,
	ETHTOOL_MMSV_LP_SENT_RESPONSE_MPACKET = 2,
};

enum ethtool_module_fw_flash_status {
	ETHTOOL_MODULE_FW_FLASH_STATUS_STARTED = 1,
	ETHTOOL_MODULE_FW_FLASH_STATUS_IN_PROGRESS = 2,
	ETHTOOL_MODULE_FW_FLASH_STATUS_COMPLETED = 3,
	ETHTOOL_MODULE_FW_FLASH_STATUS_ERROR = 4,
};

enum ethtool_module_power_mode {
	ETHTOOL_MODULE_POWER_MODE_LOW = 1,
	ETHTOOL_MODULE_POWER_MODE_HIGH = 2,
};

enum ethtool_module_power_mode_policy {
	ETHTOOL_MODULE_POWER_MODE_POLICY_HIGH = 1,
	ETHTOOL_MODULE_POWER_MODE_POLICY_AUTO = 2,
};

enum ethtool_mpacket {
	ETHTOOL_MPACKET_VERIFY = 0,
	ETHTOOL_MPACKET_RESPONSE = 1,
};

enum ethtool_multicast_groups {
	ETHNL_MCGRP_MONITOR = 0,
};

enum ethtool_phys_id_state {
	ETHTOOL_ID_INACTIVE = 0,
	ETHTOOL_ID_ACTIVE = 1,
	ETHTOOL_ID_ON = 2,
	ETHTOOL_ID_OFF = 3,
};

enum ethtool_podl_pse_admin_state {
	ETHTOOL_PODL_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_PODL_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_podl_pse_pw_d_status {
	ETHTOOL_PODL_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SLEEP = 5,
	ETHTOOL_PODL_PSE_PW_D_STATUS_IDLE = 6,
	ETHTOOL_PODL_PSE_PW_D_STATUS_ERROR = 7,
};

enum ethtool_pse_event {
	ETHTOOL_PSE_EVENT_OVER_CURRENT = 1,
	ETHTOOL_PSE_EVENT_OVER_TEMP = 2,
	ETHTOOL_C33_PSE_EVENT_DETECTION = 4,
	ETHTOOL_C33_PSE_EVENT_CLASSIFICATION = 8,
	ETHTOOL_C33_PSE_EVENT_DISCONNECTION = 16,
	ETHTOOL_PSE_EVENT_OVER_BUDGET = 32,
	ETHTOOL_PSE_EVENT_SW_PW_CONTROL_ERROR = 64,
};

enum ethtool_pse_types {
	ETHTOOL_PSE_UNKNOWN = 1,
	ETHTOOL_PSE_PODL = 2,
	ETHTOOL_PSE_C33 = 4,
};

enum ethtool_reset_flags {
	ETH_RESET_MGMT = 1,
	ETH_RESET_IRQ = 2,
	ETH_RESET_DMA = 4,
	ETH_RESET_FILTER = 8,
	ETH_RESET_OFFLOAD = 16,
	ETH_RESET_MAC = 32,
	ETH_RESET_PHY = 64,
	ETH_RESET_RAM = 128,
	ETH_RESET_AP = 256,
	ETH_RESET_DEDICATED = 65535,
	ETH_RESET_ALL = 4294967295,
};

enum ethtool_sfeatures_retval_bits {
	ETHTOOL_F_UNSUPPORTED__BIT = 0,
	ETHTOOL_F_WISH__BIT = 1,
	ETHTOOL_F_COMPAT__BIT = 2,
};

enum ethtool_stringset {
	ETH_SS_TEST = 0,
	ETH_SS_STATS = 1,
	ETH_SS_PRIV_FLAGS = 2,
	ETH_SS_NTUPLE_FILTERS = 3,
	ETH_SS_FEATURES = 4,
	ETH_SS_RSS_HASH_FUNCS = 5,
	ETH_SS_TUNABLES = 6,
	ETH_SS_PHY_STATS = 7,
	ETH_SS_PHY_TUNABLES = 8,
	ETH_SS_LINK_MODES = 9,
	ETH_SS_MSG_CLASSES = 10,
	ETH_SS_WOL_MODES = 11,
	ETH_SS_SOF_TIMESTAMPING = 12,
	ETH_SS_TS_TX_TYPES = 13,
	ETH_SS_TS_RX_FILTERS = 14,
	ETH_SS_UDP_TUNNEL_TYPES = 15,
	ETH_SS_STATS_STD = 16,
	ETH_SS_STATS_ETH_PHY = 17,
	ETH_SS_STATS_ETH_MAC = 18,
	ETH_SS_STATS_ETH_CTRL = 19,
	ETH_SS_STATS_RMON = 20,
	ETH_SS_STATS_PHY = 21,
	ETH_SS_TS_FLAGS = 22,
	ETH_SS_COUNT = 23,
};

enum ethtool_supported_ring_param {
	ETHTOOL_RING_USE_RX_BUF_LEN = 1,
	ETHTOOL_RING_USE_CQE_SIZE = 2,
	ETHTOOL_RING_USE_TX_PUSH = 4,
	ETHTOOL_RING_USE_RX_PUSH = 8,
	ETHTOOL_RING_USE_TX_PUSH_BUF_LEN = 16,
	ETHTOOL_RING_USE_TCP_DATA_SPLIT = 32,
	ETHTOOL_RING_USE_HDS_THRS = 64,
};

enum ethtool_tcp_data_split {
	ETHTOOL_TCP_DATA_SPLIT_UNKNOWN = 0,
	ETHTOOL_TCP_DATA_SPLIT_DISABLED = 1,
	ETHTOOL_TCP_DATA_SPLIT_ENABLED = 2,
};

enum event_command_flags {
	EVENT_CMD_FL_POST_TRIGGER = 1,
	EVENT_CMD_FL_NEEDS_REC = 2,
};

enum event_trigger_type {
	ETT_NONE = 0,
	ETT_TRACE_ONOFF = 1,
	ETT_SNAPSHOT = 2,
	ETT_STACKTRACE = 4,
	ETT_EVENT_ENABLE = 8,
	ETT_EVENT_HIST = 16,
	ETT_HIST_ENABLE = 32,
	ETT_EVENT_EPROBE = 64,
};

enum event_type_t {
	EVENT_FLEXIBLE = 1,
	EVENT_PINNED = 2,
	EVENT_TIME = 4,
	EVENT_FROZEN = 8,
	EVENT_CPU = 16,
	EVENT_CGROUP = 32,
	EVENT_ALL = 3,
	EVENT_TIME_FROZEN = 12,
};

enum evtreturn {
	EVT_ERR = -1,
	EVT_DONE = 0,
	EVT_XFER_DONE = 1,
	EVT_GSER = 2,
	EVT_DISC = 3,
};

enum exact_level {
	NOT_EXACT = 0,
	EXACT = 1,
	RANGE_WITHIN = 2,
};

enum exception {
	EXCP_CONTEXT = 1,
	NO_EXCP = 2,
};

enum exception_stack_ordering {
	ESTACK_DF = 0,
	ESTACK_NMI = 1,
	ESTACK_DB = 2,
	ESTACK_MCE = 3,
	ESTACK_VC = 4,
	ESTACK_VC2 = 5,
	N_EXCEPTION_STACKS = 6,
};

enum execmem_range_flags {
	EXECMEM_KASAN_SHADOW = 1,
	EXECMEM_ROX_CACHE = 2,
};

enum execmem_type {
	EXECMEM_DEFAULT = 0,
	EXECMEM_MODULE_TEXT = 0,
	EXECMEM_KPROBES = 1,
	EXECMEM_FTRACE = 2,
	EXECMEM_BPF = 3,
	EXECMEM_MODULE_DATA = 4,
	EXECMEM_TYPE_MAX = 5,
};

enum exit_fastpath_completion {
	EXIT_FASTPATH_NONE = 0,
	EXIT_FASTPATH_REENTER_GUEST = 1,
	EXIT_FASTPATH_EXIT_HANDLED = 2,
	EXIT_FASTPATH_EXIT_USERSPACE = 3,
};

enum extra_reg_type {
	EXTRA_REG_NONE = -1,
	EXTRA_REG_RSP_0 = 0,
	EXTRA_REG_RSP_1 = 1,
	EXTRA_REG_LBR = 2,
	EXTRA_REG_LDLAT = 3,
	EXTRA_REG_FE = 4,
	EXTRA_REG_SNOOP_0 = 5,
	EXTRA_REG_SNOOP_1 = 6,
	EXTRA_REG_MAX = 7,
};

enum fail_dup_mod_reason {
	FAIL_DUP_MOD_BECOMING = 0,
	FAIL_DUP_MOD_LOAD = 1,
};

enum fanotify_event_type {
	FANOTIFY_EVENT_TYPE_FID = 0,
	FANOTIFY_EVENT_TYPE_FID_NAME = 1,
	FANOTIFY_EVENT_TYPE_PATH = 2,
	FANOTIFY_EVENT_TYPE_PATH_PERM = 3,
	FANOTIFY_EVENT_TYPE_OVERFLOW = 4,
	FANOTIFY_EVENT_TYPE_FS_ERROR = 5,
	FANOTIFY_EVENT_TYPE_MNT = 6,
	__FANOTIFY_EVENT_TYPE_NUM = 7,
};

enum fault_flag {
	FAULT_FLAG_WRITE = 1,
	FAULT_FLAG_MKWRITE = 2,
	FAULT_FLAG_ALLOW_RETRY = 4,
	FAULT_FLAG_RETRY_NOWAIT = 8,
	FAULT_FLAG_KILLABLE = 16,
	FAULT_FLAG_TRIED = 32,
	FAULT_FLAG_USER = 64,
	FAULT_FLAG_REMOTE = 128,
	FAULT_FLAG_INSTRUCTION = 256,
	FAULT_FLAG_INTERRUPTIBLE = 512,
	FAULT_FLAG_UNSHARE = 1024,
	FAULT_FLAG_ORIG_PTE_VALID = 2048,
	FAULT_FLAG_VMA_LOCK = 4096,
};

enum faulttype {
	DMA_REMAP = 0,
	INTR_REMAP = 1,
	UNKNOWN = 2,
};

enum fbq_type {
	regular = 0,
	remote = 1,
	all = 2,
};

enum fetch_op {
	FETCH_OP_NOP = 0,
	FETCH_OP_REG = 1,
	FETCH_OP_STACK = 2,
	FETCH_OP_STACKP = 3,
	FETCH_OP_RETVAL = 4,
	FETCH_OP_IMM = 5,
	FETCH_OP_COMM = 6,
	FETCH_OP_ARG = 7,
	FETCH_OP_FOFFS = 8,
	FETCH_OP_DATA = 9,
	FETCH_OP_EDATA = 10,
	FETCH_OP_DEREF = 11,
	FETCH_OP_UDEREF = 12,
	FETCH_OP_ST_RAW = 13,
	FETCH_OP_ST_MEM = 14,
	FETCH_OP_ST_UMEM = 15,
	FETCH_OP_ST_STRING = 16,
	FETCH_OP_ST_USTRING = 17,
	FETCH_OP_ST_SYMSTR = 18,
	FETCH_OP_ST_EDATA = 19,
	FETCH_OP_MOD_BF = 20,
	FETCH_OP_LP_ARRAY = 21,
	FETCH_OP_TP_ARG = 22,
	FETCH_OP_END = 23,
	FETCH_NOP_SYMBOL = 24,
};

enum fib6_walk_state {
	FWS_S = 0,
	FWS_L = 1,
	FWS_R = 2,
	FWS_C = 3,
	FWS_U = 4,
};

enum fib_event_type {
	FIB_EVENT_ENTRY_REPLACE = 0,
	FIB_EVENT_ENTRY_APPEND = 1,
	FIB_EVENT_ENTRY_ADD = 2,
	FIB_EVENT_ENTRY_DEL = 3,
	FIB_EVENT_RULE_ADD = 4,
	FIB_EVENT_RULE_DEL = 5,
	FIB_EVENT_NH_ADD = 6,
	FIB_EVENT_NH_DEL = 7,
	FIB_EVENT_VIF_ADD = 8,
	FIB_EVENT_VIF_DEL = 9,
};

enum fid_type {
	FILEID_ROOT = 0,
	FILEID_INO32_GEN = 1,
	FILEID_INO32_GEN_PARENT = 2,
	FILEID_BTRFS_WITHOUT_PARENT = 77,
	FILEID_BTRFS_WITH_PARENT = 78,
	FILEID_BTRFS_WITH_PARENT_ROOT = 79,
	FILEID_UDF_WITHOUT_PARENT = 81,
	FILEID_UDF_WITH_PARENT = 82,
	FILEID_NILFS_WITHOUT_PARENT = 97,
	FILEID_NILFS_WITH_PARENT = 98,
	FILEID_FAT_WITHOUT_PARENT = 113,
	FILEID_FAT_WITH_PARENT = 114,
	FILEID_INO64_GEN = 129,
	FILEID_INO64_GEN_PARENT = 130,
	FILEID_LUSTRE = 151,
	FILEID_BCACHEFS_WITHOUT_PARENT = 177,
	FILEID_BCACHEFS_WITH_PARENT = 178,
	FILEID_KERNFS = 254,
	FILEID_INVALID = 255,
};

enum field_op_id {
	FIELD_OP_NONE = 0,
	FIELD_OP_PLUS = 1,
	FIELD_OP_MINUS = 2,
	FIELD_OP_UNARY_MINUS = 3,
	FIELD_OP_DIV = 4,
	FIELD_OP_MULT = 5,
};

enum file_time_flags {
	S_ATIME = 1,
	S_MTIME = 2,
	S_CTIME = 4,
	S_VERSION = 8,
};

enum filter_op_ids {
	OP_GLOB = 0,
	OP_NE = 1,
	OP_EQ = 2,
	OP_LE = 3,
	OP_LT = 4,
	OP_GE = 5,
	OP_GT = 6,
	OP_BAND = 7,
	OP_MAX = 8,
};

enum filter_pred_fn {
	FILTER_PRED_FN_NOP = 0,
	FILTER_PRED_FN_64 = 1,
	FILTER_PRED_FN_64_CPUMASK = 2,
	FILTER_PRED_FN_S64 = 3,
	FILTER_PRED_FN_U64 = 4,
	FILTER_PRED_FN_32 = 5,
	FILTER_PRED_FN_32_CPUMASK = 6,
	FILTER_PRED_FN_S32 = 7,
	FILTER_PRED_FN_U32 = 8,
	FILTER_PRED_FN_16 = 9,
	FILTER_PRED_FN_16_CPUMASK = 10,
	FILTER_PRED_FN_S16 = 11,
	FILTER_PRED_FN_U16 = 12,
	FILTER_PRED_FN_8 = 13,
	FILTER_PRED_FN_8_CPUMASK = 14,
	FILTER_PRED_FN_S8 = 15,
	FILTER_PRED_FN_U8 = 16,
	FILTER_PRED_FN_COMM = 17,
	FILTER_PRED_FN_STRING = 18,
	FILTER_PRED_FN_STRLOC = 19,
	FILTER_PRED_FN_STRRELLOC = 20,
	FILTER_PRED_FN_PCHAR_USER = 21,
	FILTER_PRED_FN_PCHAR = 22,
	FILTER_PRED_FN_CPU = 23,
	FILTER_PRED_FN_CPU_CPUMASK = 24,
	FILTER_PRED_FN_CPUMASK = 25,
	FILTER_PRED_FN_CPUMASK_CPU = 26,
	FILTER_PRED_FN_FUNCTION = 27,
	FILTER_PRED_FN_ = 28,
	FILTER_PRED_TEST_VISITED = 29,
};

enum fit_type {
	NOTHING_FIT = 0,
	FL_FIT_TYPE = 1,
	LE_FIT_TYPE = 2,
	RE_FIT_TYPE = 3,
	NE_FIT_TYPE = 4,
};

enum fixed_addresses {
	VSYSCALL_PAGE = 511,
	FIX_DBGP_BASE = 512,
	FIX_EARLYCON_MEM_BASE = 513,
	FIX_APIC_BASE = 514,
	FIX_IO_APIC_BASE_0 = 515,
	FIX_IO_APIC_BASE_END = 642,
	FIX_PARAVIRT_BOOTMAP = 643,
	FIX_APEI_GHES_IRQ = 644,
	FIX_APEI_GHES_NMI = 645,
	__end_of_permanent_fixed_addresses = 646,
	FIX_BTMAP_END = 1024,
	FIX_BTMAP_BEGIN = 1535,
	__end_of_fixed_addresses = 1536,
};

enum flow_action_hw_stats {
	FLOW_ACTION_HW_STATS_IMMEDIATE = 1,
	FLOW_ACTION_HW_STATS_DELAYED = 2,
	FLOW_ACTION_HW_STATS_ANY = 3,
	FLOW_ACTION_HW_STATS_DISABLED = 4,
	FLOW_ACTION_HW_STATS_DONT_CARE = 7,
};

enum flow_action_hw_stats_bit {
	FLOW_ACTION_HW_STATS_IMMEDIATE_BIT = 0,
	FLOW_ACTION_HW_STATS_DELAYED_BIT = 1,
	FLOW_ACTION_HW_STATS_DISABLED_BIT = 2,
	FLOW_ACTION_HW_STATS_NUM_BITS = 3,
};

enum flow_action_id {
	FLOW_ACTION_ACCEPT = 0,
	FLOW_ACTION_DROP = 1,
	FLOW_ACTION_TRAP = 2,
	FLOW_ACTION_GOTO = 3,
	FLOW_ACTION_REDIRECT = 4,
	FLOW_ACTION_MIRRED = 5,
	FLOW_ACTION_REDIRECT_INGRESS = 6,
	FLOW_ACTION_MIRRED_INGRESS = 7,
	FLOW_ACTION_VLAN_PUSH = 8,
	FLOW_ACTION_VLAN_POP = 9,
	FLOW_ACTION_VLAN_MANGLE = 10,
	FLOW_ACTION_TUNNEL_ENCAP = 11,
	FLOW_ACTION_TUNNEL_DECAP = 12,
	FLOW_ACTION_MANGLE = 13,
	FLOW_ACTION_ADD = 14,
	FLOW_ACTION_CSUM = 15,
	FLOW_ACTION_MARK = 16,
	FLOW_ACTION_PTYPE = 17,
	FLOW_ACTION_PRIORITY = 18,
	FLOW_ACTION_RX_QUEUE_MAPPING = 19,
	FLOW_ACTION_WAKE = 20,
	FLOW_ACTION_QUEUE = 21,
	FLOW_ACTION_SAMPLE = 22,
	FLOW_ACTION_POLICE = 23,
	FLOW_ACTION_CT = 24,
	FLOW_ACTION_CT_METADATA = 25,
	FLOW_ACTION_MPLS_PUSH = 26,
	FLOW_ACTION_MPLS_POP = 27,
	FLOW_ACTION_MPLS_MANGLE = 28,
	FLOW_ACTION_GATE = 29,
	FLOW_ACTION_PPPOE_PUSH = 30,
	FLOW_ACTION_JUMP = 31,
	FLOW_ACTION_PIPE = 32,
	FLOW_ACTION_VLAN_PUSH_ETH = 33,
	FLOW_ACTION_VLAN_POP_ETH = 34,
	FLOW_ACTION_CONTINUE = 35,
	NUM_FLOW_ACTIONS = 36,
};

enum flow_action_mangle_base {
	FLOW_ACT_MANGLE_UNSPEC = 0,
	FLOW_ACT_MANGLE_HDR_TYPE_ETH = 1,
	FLOW_ACT_MANGLE_HDR_TYPE_IP4 = 2,
	FLOW_ACT_MANGLE_HDR_TYPE_IP6 = 3,
	FLOW_ACT_MANGLE_HDR_TYPE_TCP = 4,
	FLOW_ACT_MANGLE_HDR_TYPE_UDP = 5,
};

enum flow_block_binder_type {
	FLOW_BLOCK_BINDER_TYPE_UNSPEC = 0,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_INGRESS = 1,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_EGRESS = 2,
	FLOW_BLOCK_BINDER_TYPE_RED_EARLY_DROP = 3,
	FLOW_BLOCK_BINDER_TYPE_RED_MARK = 4,
};

enum flow_block_command {
	FLOW_BLOCK_BIND = 0,
	FLOW_BLOCK_UNBIND = 1,
};

enum flow_cls_command {
	FLOW_CLS_REPLACE = 0,
	FLOW_CLS_DESTROY = 1,
	FLOW_CLS_STATS = 2,
	FLOW_CLS_TMPLT_CREATE = 3,
	FLOW_CLS_TMPLT_DESTROY = 4,
};

enum flow_dissect_ret {
	FLOW_DISSECT_RET_OUT_GOOD = 0,
	FLOW_DISSECT_RET_OUT_BAD = 1,
	FLOW_DISSECT_RET_PROTO_AGAIN = 2,
	FLOW_DISSECT_RET_IPPROTO_AGAIN = 3,
	FLOW_DISSECT_RET_CONTINUE = 4,
};

enum flow_dissector_ctrl_flags {
	FLOW_DIS_IS_FRAGMENT = 1,
	FLOW_DIS_FIRST_FRAG = 2,
	FLOW_DIS_F_TUNNEL_CSUM = 4,
	FLOW_DIS_F_TUNNEL_DONT_FRAGMENT = 8,
	FLOW_DIS_F_TUNNEL_OAM = 16,
	FLOW_DIS_F_TUNNEL_CRIT_OPT = 32,
	FLOW_DIS_ENCAPSULATION = 64,
};

enum flow_dissector_key_id {
	FLOW_DISSECTOR_KEY_CONTROL = 0,
	FLOW_DISSECTOR_KEY_BASIC = 1,
	FLOW_DISSECTOR_KEY_IPV4_ADDRS = 2,
	FLOW_DISSECTOR_KEY_IPV6_ADDRS = 3,
	FLOW_DISSECTOR_KEY_PORTS = 4,
	FLOW_DISSECTOR_KEY_PORTS_RANGE = 5,
	FLOW_DISSECTOR_KEY_ICMP = 6,
	FLOW_DISSECTOR_KEY_ETH_ADDRS = 7,
	FLOW_DISSECTOR_KEY_TIPC = 8,
	FLOW_DISSECTOR_KEY_ARP = 9,
	FLOW_DISSECTOR_KEY_VLAN = 10,
	FLOW_DISSECTOR_KEY_FLOW_LABEL = 11,
	FLOW_DISSECTOR_KEY_GRE_KEYID = 12,
	FLOW_DISSECTOR_KEY_MPLS_ENTROPY = 13,
	FLOW_DISSECTOR_KEY_ENC_KEYID = 14,
	FLOW_DISSECTOR_KEY_ENC_IPV4_ADDRS = 15,
	FLOW_DISSECTOR_KEY_ENC_IPV6_ADDRS = 16,
	FLOW_DISSECTOR_KEY_ENC_CONTROL = 17,
	FLOW_DISSECTOR_KEY_ENC_PORTS = 18,
	FLOW_DISSECTOR_KEY_MPLS = 19,
	FLOW_DISSECTOR_KEY_TCP = 20,
	FLOW_DISSECTOR_KEY_IP = 21,
	FLOW_DISSECTOR_KEY_CVLAN = 22,
	FLOW_DISSECTOR_KEY_ENC_IP = 23,
	FLOW_DISSECTOR_KEY_ENC_OPTS = 24,
	FLOW_DISSECTOR_KEY_META = 25,
	FLOW_DISSECTOR_KEY_CT = 26,
	FLOW_DISSECTOR_KEY_HASH = 27,
	FLOW_DISSECTOR_KEY_NUM_OF_VLANS = 28,
	FLOW_DISSECTOR_KEY_PPPOE = 29,
	FLOW_DISSECTOR_KEY_L2TPV3 = 30,
	FLOW_DISSECTOR_KEY_CFM = 31,
	FLOW_DISSECTOR_KEY_IPSEC = 32,
	FLOW_DISSECTOR_KEY_MAX = 33,
};

enum flowlabel_reflect {
	FLOWLABEL_REFLECT_ESTABLISHED = 1,
	FLOWLABEL_REFLECT_TCP_RESET = 2,
	FLOWLABEL_REFLECT_ICMPV6_ECHO_REPLIES = 4,
};

enum folio_references {
	FOLIOREF_RECLAIM = 0,
	FOLIOREF_RECLAIM_CLEAN = 1,
	FOLIOREF_KEEP = 2,
	FOLIOREF_ACTIVATE = 3,
};

enum folio_walk_level {
	FW_LEVEL_PTE = 0,
	FW_LEVEL_PMD = 1,
	FW_LEVEL_PUD = 2,
};

enum format_state {
	FORMAT_STATE_NONE = 0,
	FORMAT_STATE_NUM = 1,
	FORMAT_STATE_WIDTH = 2,
	FORMAT_STATE_PRECISION = 3,
	FORMAT_STATE_CHAR = 4,
	FORMAT_STATE_STR = 5,
	FORMAT_STATE_PTR = 6,
	FORMAT_STATE_PERCENT_CHAR = 7,
	FORMAT_STATE_INVALID = 8,
};

enum fortify_func {
	FORTIFY_FUNC_strncpy = 0,
	FORTIFY_FUNC_strnlen = 1,
	FORTIFY_FUNC_strlen = 2,
	FORTIFY_FUNC_strscpy = 3,
	FORTIFY_FUNC_strlcat = 4,
	FORTIFY_FUNC_strcat = 5,
	FORTIFY_FUNC_strncat = 6,
	FORTIFY_FUNC_memset = 7,
	FORTIFY_FUNC_memcpy = 8,
	FORTIFY_FUNC_memmove = 9,
	FORTIFY_FUNC_memscan = 10,
	FORTIFY_FUNC_memcmp = 11,
	FORTIFY_FUNC_memchr = 12,
	FORTIFY_FUNC_memchr_inv = 13,
	FORTIFY_FUNC_kmemdup = 14,
	FORTIFY_FUNC_strcpy = 15,
	FORTIFY_FUNC_UNKNOWN = 16,
};

enum fpdt_record_type {
	RECORD_S3_RESUME = 0,
	RECORD_S3_SUSPEND = 1,
	RECORD_BOOT = 2,
};

enum fpdt_subtable_type {
	SUBTABLE_FBPT = 0,
	SUBTABLE_S3PT = 1,
};

enum freeze_holder {
	FREEZE_HOLDER_KERNEL = 1,
	FREEZE_HOLDER_USERSPACE = 2,
	FREEZE_MAY_NEST = 4,
	FREEZE_EXCL = 8,
};

enum freezer_state_flags {
	CGROUP_FREEZER_ONLINE = 1,
	CGROUP_FREEZING_SELF = 2,
	CGROUP_FREEZING_PARENT = 4,
	CGROUP_FROZEN = 8,
	CGROUP_FREEZING = 6,
};

enum freq_qos_req_type {
	FREQ_QOS_MIN = 1,
	FREQ_QOS_MAX = 2,
};

enum fs_context_phase {
	FS_CONTEXT_CREATE_PARAMS = 0,
	FS_CONTEXT_CREATING = 1,
	FS_CONTEXT_AWAITING_MOUNT = 2,
	FS_CONTEXT_AWAITING_RECONF = 3,
	FS_CONTEXT_RECONF_PARAMS = 4,
	FS_CONTEXT_RECONFIGURING = 5,
	FS_CONTEXT_FAILED = 6,
};

enum fs_context_purpose {
	FS_CONTEXT_FOR_MOUNT = 0,
	FS_CONTEXT_FOR_SUBMOUNT = 1,
	FS_CONTEXT_FOR_RECONFIGURE = 2,
};

enum fs_value_type {
	fs_value_is_undefined = 0,
	fs_value_is_flag = 1,
	fs_value_is_string = 2,
	fs_value_is_blob = 3,
	fs_value_is_filename = 4,
	fs_value_is_file = 5,
};

enum fsconfig_command {
	FSCONFIG_SET_FLAG = 0,
	FSCONFIG_SET_STRING = 1,
	FSCONFIG_SET_BINARY = 2,
	FSCONFIG_SET_PATH = 3,
	FSCONFIG_SET_PATH_EMPTY = 4,
	FSCONFIG_SET_FD = 5,
	FSCONFIG_CMD_CREATE = 6,
	FSCONFIG_CMD_RECONFIGURE = 7,
	FSCONFIG_CMD_CREATE_EXCL = 8,
};

enum fsl_mc_pool_type {
	FSL_MC_POOL_DPMCP = 0,
	FSL_MC_POOL_DPBP = 1,
	FSL_MC_POOL_DPCON = 2,
	FSL_MC_POOL_IRQ = 3,
	FSL_MC_NUM_POOL_TYPES = 4,
};

enum fsnotify_data_type {
	FSNOTIFY_EVENT_NONE = 0,
	FSNOTIFY_EVENT_FILE_RANGE = 1,
	FSNOTIFY_EVENT_PATH = 2,
	FSNOTIFY_EVENT_INODE = 3,
	FSNOTIFY_EVENT_DENTRY = 4,
	FSNOTIFY_EVENT_MNT = 5,
	FSNOTIFY_EVENT_ERROR = 6,
};

enum fsnotify_group_prio {
	FSNOTIFY_PRIO_NORMAL = 0,
	FSNOTIFY_PRIO_CONTENT = 1,
	FSNOTIFY_PRIO_PRE_CONTENT = 2,
	__FSNOTIFY_PRIO_NUM = 3,
};

enum fsnotify_iter_type {
	FSNOTIFY_ITER_TYPE_INODE = 0,
	FSNOTIFY_ITER_TYPE_VFSMOUNT = 1,
	FSNOTIFY_ITER_TYPE_SB = 2,
	FSNOTIFY_ITER_TYPE_PARENT = 3,
	FSNOTIFY_ITER_TYPE_INODE2 = 4,
	FSNOTIFY_ITER_TYPE_MNTNS = 5,
	FSNOTIFY_ITER_TYPE_COUNT = 6,
};

enum fsnotify_obj_type {
	FSNOTIFY_OBJ_TYPE_ANY = -1,
	FSNOTIFY_OBJ_TYPE_INODE = 0,
	FSNOTIFY_OBJ_TYPE_VFSMOUNT = 1,
	FSNOTIFY_OBJ_TYPE_SB = 2,
	FSNOTIFY_OBJ_TYPE_MNTNS = 3,
	FSNOTIFY_OBJ_TYPE_COUNT = 4,
	FSNOTIFY_OBJ_TYPE_DETACHED = 4,
};

enum ftrace_bug_type {
	FTRACE_BUG_UNKNOWN = 0,
	FTRACE_BUG_INIT = 1,
	FTRACE_BUG_NOP = 2,
	FTRACE_BUG_CALL = 3,
	FTRACE_BUG_UPDATE = 4,
};

enum ftrace_dump_mode {
	DUMP_NONE = 0,
	DUMP_ALL = 1,
	DUMP_ORIG = 2,
	DUMP_PARAM = 3,
};

enum ftrace_ops_cmd {
	FTRACE_OPS_CMD_ENABLE_SHARE_IPMODIFY_SELF = 0,
	FTRACE_OPS_CMD_ENABLE_SHARE_IPMODIFY_PEER = 1,
	FTRACE_OPS_CMD_DISABLE_SHARE_IPMODIFY_PEER = 2,
};

enum fullness_group {
	ZS_INUSE_RATIO_0 = 0,
	ZS_INUSE_RATIO_10 = 1,
	ZS_INUSE_RATIO_99 = 10,
	ZS_INUSE_RATIO_100 = 11,
	NR_FULLNESS_GROUPS = 12,
};

enum fuse_dax_mode {
	FUSE_DAX_INODE_DEFAULT = 0,
	FUSE_DAX_ALWAYS = 1,
	FUSE_DAX_NEVER = 2,
	FUSE_DAX_INODE_USER = 3,
};

enum fuse_ext_type {
	FUSE_MAX_NR_SECCTX = 31,
	FUSE_EXT_GROUPS = 32,
};

enum fuse_notify_code {
	FUSE_NOTIFY_POLL = 1,
	FUSE_NOTIFY_INVAL_INODE = 2,
	FUSE_NOTIFY_INVAL_ENTRY = 3,
	FUSE_NOTIFY_STORE = 4,
	FUSE_NOTIFY_RETRIEVE = 5,
	FUSE_NOTIFY_DELETE = 6,
	FUSE_NOTIFY_RESEND = 7,
	FUSE_NOTIFY_INC_EPOCH = 8,
	FUSE_NOTIFY_CODE_MAX = 9,
};

enum fuse_opcode {
	FUSE_LOOKUP = 1,
	FUSE_FORGET = 2,
	FUSE_GETATTR = 3,
	FUSE_SETATTR = 4,
	FUSE_READLINK = 5,
	FUSE_SYMLINK = 6,
	FUSE_MKNOD = 8,
	FUSE_MKDIR = 9,
	FUSE_UNLINK = 10,
	FUSE_RMDIR = 11,
	FUSE_RENAME = 12,
	FUSE_LINK = 13,
	FUSE_OPEN = 14,
	FUSE_READ = 15,
	FUSE_WRITE = 16,
	FUSE_STATFS = 17,
	FUSE_RELEASE = 18,
	FUSE_FSYNC = 20,
	FUSE_SETXATTR = 21,
	FUSE_GETXATTR = 22,
	FUSE_LISTXATTR = 23,
	FUSE_REMOVEXATTR = 24,
	FUSE_FLUSH = 25,
	FUSE_INIT = 26,
	FUSE_OPENDIR = 27,
	FUSE_READDIR = 28,
	FUSE_RELEASEDIR = 29,
	FUSE_FSYNCDIR = 30,
	FUSE_GETLK = 31,
	FUSE_SETLK = 32,
	FUSE_SETLKW = 33,
	FUSE_ACCESS = 34,
	FUSE_CREATE = 35,
	FUSE_INTERRUPT = 36,
	FUSE_BMAP = 37,
	FUSE_DESTROY = 38,
	FUSE_IOCTL = 39,
	FUSE_POLL = 40,
	FUSE_NOTIFY_REPLY = 41,
	FUSE_BATCH_FORGET = 42,
	FUSE_FALLOCATE = 43,
	FUSE_READDIRPLUS = 44,
	FUSE_RENAME2 = 45,
	FUSE_LSEEK = 46,
	FUSE_COPY_FILE_RANGE = 47,
	FUSE_SETUPMAPPING = 48,
	FUSE_REMOVEMAPPING = 49,
	FUSE_SYNCFS = 50,
	FUSE_TMPFILE = 51,
	FUSE_STATX = 52,
	CUSE_INIT = 4096,
	CUSE_INIT_BSWAP_RESERVED = 1048576,
	FUSE_INIT_BSWAP_RESERVED = 436207616,
};

enum fuse_parse_result {
	FOUND_ERR = -1,
	FOUND_NONE = 0,
	FOUND_SOME = 1,
	FOUND_ALL = 2,
};

enum fuse_req_flag {
	FR_ISREPLY = 0,
	FR_FORCE = 1,
	FR_BACKGROUND = 2,
	FR_WAITING = 3,
	FR_ABORTED = 4,
	FR_INTERRUPTED = 5,
	FR_LOCKED = 6,
	FR_PENDING = 7,
	FR_SENT = 8,
	FR_FINISHED = 9,
	FR_PRIVATE = 10,
	FR_ASYNC = 11,
	FR_URING = 12,
};

enum fuse_ring_req_state {
	FRRS_INVALID = 0,
	FRRS_COMMIT = 1,
	FRRS_AVAILABLE = 2,
	FRRS_FUSE_REQ = 3,
	FRRS_USERSPACE = 4,
	FRRS_TEARDOWN = 5,
	FRRS_RELEASED = 6,
};

enum fuse_uring_cmd {
	FUSE_IO_URING_CMD_INVALID = 0,
	FUSE_IO_URING_CMD_REGISTER = 1,
	FUSE_IO_URING_CMD_COMMIT_AND_FETCH = 2,
};

enum futex_access {
	FUTEX_READ = 0,
	FUTEX_WRITE = 1,
};

enum fw_opt {
	FW_OPT_UEVENT = 1,
	FW_OPT_NOWAIT = 2,
	FW_OPT_USERHELPER = 4,
	FW_OPT_NO_WARN = 8,
	FW_OPT_NOCACHE = 16,
	FW_OPT_NOFALLBACK_SYSFS = 32,
	FW_OPT_FALLBACK_PLATFORM = 64,
	FW_OPT_PARTIAL = 128,
};

enum fw_resource_type {
	RSC_CARVEOUT = 0,
	RSC_DEVMEM = 1,
	RSC_TRACE = 2,
	RSC_VDEV = 3,
	RSC_LAST = 4,
	RSC_VENDOR_START = 128,
	RSC_VENDOR_END = 512,
};

enum fw_status {
	FW_STATUS_UNKNOWN = 0,
	FW_STATUS_LOADING = 1,
	FW_STATUS_DONE = 2,
	FW_STATUS_ABORTED = 3,
};

enum fw_upload_err {
	FW_UPLOAD_ERR_NONE = 0,
	FW_UPLOAD_ERR_HW_ERROR = 1,
	FW_UPLOAD_ERR_TIMEOUT = 2,
	FW_UPLOAD_ERR_CANCELED = 3,
	FW_UPLOAD_ERR_BUSY = 4,
	FW_UPLOAD_ERR_INVALID_SIZE = 5,
	FW_UPLOAD_ERR_RW_ERROR = 6,
	FW_UPLOAD_ERR_WEAROUT = 7,
	FW_UPLOAD_ERR_FW_INVALID = 8,
	FW_UPLOAD_ERR_MAX = 9,
};

enum fw_upload_prog {
	FW_UPLOAD_PROG_IDLE = 0,
	FW_UPLOAD_PROG_RECEIVING = 1,
	FW_UPLOAD_PROG_PREPARING = 2,
	FW_UPLOAD_PROG_TRANSFERRING = 3,
	FW_UPLOAD_PROG_PROGRAMMING = 4,
	FW_UPLOAD_PROG_MAX = 5,
};

enum gds_mitigations {
	GDS_MITIGATION_OFF = 0,
	GDS_MITIGATION_AUTO = 1,
	GDS_MITIGATION_UCODE_NEEDED = 2,
	GDS_MITIGATION_FORCE = 3,
	GDS_MITIGATION_FULL = 4,
	GDS_MITIGATION_FULL_LOCKED = 5,
	GDS_MITIGATION_HYPERVISOR = 6,
};

enum genl_validate_flags {
	GENL_DONT_VALIDATE_STRICT = 1,
	GENL_DONT_VALIDATE_DUMP = 2,
	GENL_DONT_VALIDATE_DUMP_STRICT = 4,
};

enum genpd_notication {
	GENPD_NOTIFY_PRE_OFF = 0,
	GENPD_NOTIFY_OFF = 1,
	GENPD_NOTIFY_PRE_ON = 2,
	GENPD_NOTIFY_ON = 3,
};

enum genpd_sync_state {
	GENPD_SYNC_STATE_OFF = 0,
	GENPD_SYNC_STATE_SIMPLE = 1,
	GENPD_SYNC_STATE_ONECELL = 2,
};

enum gpd_status {
	GENPD_STATE_ON = 0,
	GENPD_STATE_OFF = 1,
};

enum gpio_lookup_flags {
	GPIO_ACTIVE_HIGH = 0,
	GPIO_ACTIVE_LOW = 1,
	GPIO_OPEN_DRAIN = 2,
	GPIO_OPEN_SOURCE = 4,
	GPIO_PERSISTENT = 0,
	GPIO_TRANSITORY = 8,
	GPIO_PULL_UP = 16,
	GPIO_PULL_DOWN = 32,
	GPIO_PULL_DISABLE = 64,
	GPIO_LOOKUP_FLAGS_DEFAULT = 0,
};

enum gpio_select {
	NO_GPIO = 0,
	GPIO_1 = 1,
	GPIO_2 = 2,
};

enum gpio_v2_line_attr_id {
	GPIO_V2_LINE_ATTR_ID_FLAGS = 1,
	GPIO_V2_LINE_ATTR_ID_OUTPUT_VALUES = 2,
	GPIO_V2_LINE_ATTR_ID_DEBOUNCE = 3,
};

enum gpio_v2_line_changed_type {
	GPIO_V2_LINE_CHANGED_REQUESTED = 1,
	GPIO_V2_LINE_CHANGED_RELEASED = 2,
	GPIO_V2_LINE_CHANGED_CONFIG = 3,
};

enum gpio_v2_line_event_id {
	GPIO_V2_LINE_EVENT_RISING_EDGE = 1,
	GPIO_V2_LINE_EVENT_FALLING_EDGE = 2,
};

enum gpio_v2_line_flag {
	GPIO_V2_LINE_FLAG_USED = 1,
	GPIO_V2_LINE_FLAG_ACTIVE_LOW = 2,
	GPIO_V2_LINE_FLAG_INPUT = 4,
	GPIO_V2_LINE_FLAG_OUTPUT = 8,
	GPIO_V2_LINE_FLAG_EDGE_RISING = 16,
	GPIO_V2_LINE_FLAG_EDGE_FALLING = 32,
	GPIO_V2_LINE_FLAG_OPEN_DRAIN = 64,
	GPIO_V2_LINE_FLAG_OPEN_SOURCE = 128,
	GPIO_V2_LINE_FLAG_BIAS_PULL_UP = 256,
	GPIO_V2_LINE_FLAG_BIAS_PULL_DOWN = 512,
	GPIO_V2_LINE_FLAG_BIAS_DISABLED = 1024,
	GPIO_V2_LINE_FLAG_EVENT_CLOCK_REALTIME = 2048,
	GPIO_V2_LINE_FLAG_EVENT_CLOCK_HTE = 4096,
};

enum gpiod_flags {
	GPIOD_ASIS = 0,
	GPIOD_IN = 1,
	GPIOD_OUT_LOW = 3,
	GPIOD_OUT_HIGH = 7,
	GPIOD_OUT_LOW_OPEN_DRAIN = 11,
	GPIOD_OUT_HIGH_OPEN_DRAIN = 15,
};

enum graph_filter_type {
	GRAPH_FILTER_NOTRACE = 0,
	GRAPH_FILTER_FUNCTION = 1,
};

enum gre_conntrack {
	GRE_CT_UNREPLIED = 0,
	GRE_CT_REPLIED = 1,
	GRE_CT_MAX = 2,
};

enum gro_result {
	GRO_MERGED = 0,
	GRO_MERGED_FREE = 1,
	GRO_HELD = 2,
	GRO_NORMAL = 3,
	GRO_CONSUMED = 4,
};

typedef enum gro_result gro_result_t;

enum group_type {
	group_has_spare = 0,
	group_fully_busy = 1,
	group_misfit_task = 2,
	group_smt_balance = 3,
	group_asym_packing = 4,
	group_imbalanced = 5,
	group_overloaded = 6,
};

enum handle_to_path_flags {
	HANDLE_CHECK_PERMS = 1,
	HANDLE_CHECK_SUBTREE = 2,
};

enum handler_id {
	HANDLER_ONMATCH = 1,
	HANDLER_ONMAX = 2,
	HANDLER_ONCHANGE = 3,
};

enum handshake_auth {
	HANDSHAKE_AUTH_UNSPEC = 0,
	HANDSHAKE_AUTH_UNAUTH = 1,
	HANDSHAKE_AUTH_PSK = 2,
	HANDSHAKE_AUTH_X509 = 3,
};

enum handshake_handler_class {
	HANDSHAKE_HANDLER_CLASS_NONE = 0,
	HANDSHAKE_HANDLER_CLASS_TLSHD = 1,
	HANDSHAKE_HANDLER_CLASS_MAX = 2,
};

enum handshake_msg_type {
	HANDSHAKE_MSG_TYPE_UNSPEC = 0,
	HANDSHAKE_MSG_TYPE_CLIENTHELLO = 1,
	HANDSHAKE_MSG_TYPE_SERVERHELLO = 2,
};

enum hash_algo {
	HASH_ALGO_MD4 = 0,
	HASH_ALGO_MD5 = 1,
	HASH_ALGO_SHA1 = 2,
	HASH_ALGO_RIPE_MD_160 = 3,
	HASH_ALGO_SHA256 = 4,
	HASH_ALGO_SHA384 = 5,
	HASH_ALGO_SHA512 = 6,
	HASH_ALGO_SHA224 = 7,
	HASH_ALGO_RIPE_MD_128 = 8,
	HASH_ALGO_RIPE_MD_256 = 9,
	HASH_ALGO_RIPE_MD_320 = 10,
	HASH_ALGO_WP_256 = 11,
	HASH_ALGO_WP_384 = 12,
	HASH_ALGO_WP_512 = 13,
	HASH_ALGO_TGR_128 = 14,
	HASH_ALGO_TGR_160 = 15,
	HASH_ALGO_TGR_192 = 16,
	HASH_ALGO_SM3_256 = 17,
	HASH_ALGO_STREEBOG_256 = 18,
	HASH_ALGO_STREEBOG_512 = 19,
	HASH_ALGO_SHA3_256 = 20,
	HASH_ALGO_SHA3_384 = 21,
	HASH_ALGO_SHA3_512 = 22,
	HASH_ALGO__LAST = 23,
};

enum hash_pointers_policy {
	HASH_PTR_AUTO = 0,
	HASH_PTR_ALWAYS = 1,
	HASH_PTR_NEVER = 2,
};

enum hctx_type {
	HCTX_TYPE_DEFAULT = 0,
	HCTX_TYPE_READ = 1,
	HCTX_TYPE_POLL = 2,
	HCTX_MAX_TYPES = 3,
};

enum hdmi_3d_structure {
	HDMI_3D_STRUCTURE_INVALID = -1,
	HDMI_3D_STRUCTURE_FRAME_PACKING = 0,
	HDMI_3D_STRUCTURE_FIELD_ALTERNATIVE = 1,
	HDMI_3D_STRUCTURE_LINE_ALTERNATIVE = 2,
	HDMI_3D_STRUCTURE_SIDE_BY_SIDE_FULL = 3,
	HDMI_3D_STRUCTURE_L_DEPTH = 4,
	HDMI_3D_STRUCTURE_L_DEPTH_GFX_GFX_DEPTH = 5,
	HDMI_3D_STRUCTURE_TOP_AND_BOTTOM = 6,
	HDMI_3D_STRUCTURE_SIDE_BY_SIDE_HALF = 8,
};

enum hdmi_active_aspect {
	HDMI_ACTIVE_ASPECT_16_9_TOP = 2,
	HDMI_ACTIVE_ASPECT_14_9_TOP = 3,
	HDMI_ACTIVE_ASPECT_16_9_CENTER = 4,
	HDMI_ACTIVE_ASPECT_PICTURE = 8,
	HDMI_ACTIVE_ASPECT_4_3 = 9,
	HDMI_ACTIVE_ASPECT_16_9 = 10,
	HDMI_ACTIVE_ASPECT_14_9 = 11,
	HDMI_ACTIVE_ASPECT_4_3_SP_14_9 = 13,
	HDMI_ACTIVE_ASPECT_16_9_SP_14_9 = 14,
	HDMI_ACTIVE_ASPECT_16_9_SP_4_3 = 15,
};

enum hdmi_audio_coding_type {
	HDMI_AUDIO_CODING_TYPE_STREAM = 0,
	HDMI_AUDIO_CODING_TYPE_PCM = 1,
	HDMI_AUDIO_CODING_TYPE_AC3 = 2,
	HDMI_AUDIO_CODING_TYPE_MPEG1 = 3,
	HDMI_AUDIO_CODING_TYPE_MP3 = 4,
	HDMI_AUDIO_CODING_TYPE_MPEG2 = 5,
	HDMI_AUDIO_CODING_TYPE_AAC_LC = 6,
	HDMI_AUDIO_CODING_TYPE_DTS = 7,
	HDMI_AUDIO_CODING_TYPE_ATRAC = 8,
	HDMI_AUDIO_CODING_TYPE_DSD = 9,
	HDMI_AUDIO_CODING_TYPE_EAC3 = 10,
	HDMI_AUDIO_CODING_TYPE_DTS_HD = 11,
	HDMI_AUDIO_CODING_TYPE_MLP = 12,
	HDMI_AUDIO_CODING_TYPE_DST = 13,
	HDMI_AUDIO_CODING_TYPE_WMA_PRO = 14,
	HDMI_AUDIO_CODING_TYPE_CXT = 15,
};

enum hdmi_audio_coding_type_ext {
	HDMI_AUDIO_CODING_TYPE_EXT_CT = 0,
	HDMI_AUDIO_CODING_TYPE_EXT_HE_AAC = 1,
	HDMI_AUDIO_CODING_TYPE_EXT_HE_AAC_V2 = 2,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG_SURROUND = 3,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC = 4,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC_V2 = 5,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_AAC_LC = 6,
	HDMI_AUDIO_CODING_TYPE_EXT_DRA = 7,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC_SURROUND = 8,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_AAC_LC_SURROUND = 10,
};

enum hdmi_audio_sample_frequency {
	HDMI_AUDIO_SAMPLE_FREQUENCY_STREAM = 0,
	HDMI_AUDIO_SAMPLE_FREQUENCY_32000 = 1,
	HDMI_AUDIO_SAMPLE_FREQUENCY_44100 = 2,
	HDMI_AUDIO_SAMPLE_FREQUENCY_48000 = 3,
	HDMI_AUDIO_SAMPLE_FREQUENCY_88200 = 4,
	HDMI_AUDIO_SAMPLE_FREQUENCY_96000 = 5,
	HDMI_AUDIO_SAMPLE_FREQUENCY_176400 = 6,
	HDMI_AUDIO_SAMPLE_FREQUENCY_192000 = 7,
};

enum hdmi_audio_sample_size {
	HDMI_AUDIO_SAMPLE_SIZE_STREAM = 0,
	HDMI_AUDIO_SAMPLE_SIZE_16 = 1,
	HDMI_AUDIO_SAMPLE_SIZE_20 = 2,
	HDMI_AUDIO_SAMPLE_SIZE_24 = 3,
};

enum hdmi_colorimetry {
	HDMI_COLORIMETRY_NONE = 0,
	HDMI_COLORIMETRY_ITU_601 = 1,
	HDMI_COLORIMETRY_ITU_709 = 2,
	HDMI_COLORIMETRY_EXTENDED = 3,
};

enum hdmi_colorspace {
	HDMI_COLORSPACE_RGB = 0,
	HDMI_COLORSPACE_YUV422 = 1,
	HDMI_COLORSPACE_YUV444 = 2,
	HDMI_COLORSPACE_YUV420 = 3,
	HDMI_COLORSPACE_RESERVED4 = 4,
	HDMI_COLORSPACE_RESERVED5 = 5,
	HDMI_COLORSPACE_RESERVED6 = 6,
	HDMI_COLORSPACE_IDO_DEFINED = 7,
};

enum hdmi_content_type {
	HDMI_CONTENT_TYPE_GRAPHICS = 0,
	HDMI_CONTENT_TYPE_PHOTO = 1,
	HDMI_CONTENT_TYPE_CINEMA = 2,
	HDMI_CONTENT_TYPE_GAME = 3,
};

enum hdmi_eotf {
	HDMI_EOTF_TRADITIONAL_GAMMA_SDR = 0,
	HDMI_EOTF_TRADITIONAL_GAMMA_HDR = 1,
	HDMI_EOTF_SMPTE_ST2084 = 2,
	HDMI_EOTF_BT_2100_HLG = 3,
};

enum hdmi_extended_colorimetry {
	HDMI_EXTENDED_COLORIMETRY_XV_YCC_601 = 0,
	HDMI_EXTENDED_COLORIMETRY_XV_YCC_709 = 1,
	HDMI_EXTENDED_COLORIMETRY_S_YCC_601 = 2,
	HDMI_EXTENDED_COLORIMETRY_OPYCC_601 = 3,
	HDMI_EXTENDED_COLORIMETRY_OPRGB = 4,
	HDMI_EXTENDED_COLORIMETRY_BT2020_CONST_LUM = 5,
	HDMI_EXTENDED_COLORIMETRY_BT2020 = 6,
	HDMI_EXTENDED_COLORIMETRY_RESERVED = 7,
};

enum hdmi_infoframe_type {
	HDMI_INFOFRAME_TYPE_VENDOR = 129,
	HDMI_INFOFRAME_TYPE_AVI = 130,
	HDMI_INFOFRAME_TYPE_SPD = 131,
	HDMI_INFOFRAME_TYPE_AUDIO = 132,
	HDMI_INFOFRAME_TYPE_DRM = 135,
};

enum hdmi_metadata_type {
	HDMI_STATIC_METADATA_TYPE1 = 0,
};

enum hdmi_nups {
	HDMI_NUPS_UNKNOWN = 0,
	HDMI_NUPS_HORIZONTAL = 1,
	HDMI_NUPS_VERTICAL = 2,
	HDMI_NUPS_BOTH = 3,
};

enum hdmi_picture_aspect {
	HDMI_PICTURE_ASPECT_NONE = 0,
	HDMI_PICTURE_ASPECT_4_3 = 1,
	HDMI_PICTURE_ASPECT_16_9 = 2,
	HDMI_PICTURE_ASPECT_64_27 = 3,
	HDMI_PICTURE_ASPECT_256_135 = 4,
	HDMI_PICTURE_ASPECT_RESERVED = 5,
};

enum hdmi_quantization_range {
	HDMI_QUANTIZATION_RANGE_DEFAULT = 0,
	HDMI_QUANTIZATION_RANGE_LIMITED = 1,
	HDMI_QUANTIZATION_RANGE_FULL = 2,
	HDMI_QUANTIZATION_RANGE_RESERVED = 3,
};

enum hdmi_scan_mode {
	HDMI_SCAN_MODE_NONE = 0,
	HDMI_SCAN_MODE_OVERSCAN = 1,
	HDMI_SCAN_MODE_UNDERSCAN = 2,
	HDMI_SCAN_MODE_RESERVED = 3,
};

enum hdmi_spd_sdi {
	HDMI_SPD_SDI_UNKNOWN = 0,
	HDMI_SPD_SDI_DSTB = 1,
	HDMI_SPD_SDI_DVDP = 2,
	HDMI_SPD_SDI_DVHS = 3,
	HDMI_SPD_SDI_HDDVR = 4,
	HDMI_SPD_SDI_DVC = 5,
	HDMI_SPD_SDI_DSC = 6,
	HDMI_SPD_SDI_VCD = 7,
	HDMI_SPD_SDI_GAME = 8,
	HDMI_SPD_SDI_PC = 9,
	HDMI_SPD_SDI_BD = 10,
	HDMI_SPD_SDI_SACD = 11,
	HDMI_SPD_SDI_HDDVD = 12,
	HDMI_SPD_SDI_PMP = 13,
};

enum hdmi_ycc_quantization_range {
	HDMI_YCC_QUANTIZATION_RANGE_LIMITED = 0,
	HDMI_YCC_QUANTIZATION_RANGE_FULL = 1,
};

enum header_opt {
	IPE_HEADER_POLICY_NAME = 0,
	IPE_HEADER_POLICY_VERSION = 1,
	__IPE_HEADER_MAX = 2,
};

enum hest_status {
	HEST_ENABLED = 0,
	HEST_DISABLED = 1,
	HEST_NOT_FOUND = 2,
};

enum hid_battery_status {
	HID_BATTERY_UNKNOWN = 0,
	HID_BATTERY_QUERIED = 1,
	HID_BATTERY_REPORTED = 2,
};

enum hid_class_request {
	HID_REQ_GET_REPORT = 1,
	HID_REQ_GET_IDLE = 2,
	HID_REQ_GET_PROTOCOL = 3,
	HID_REQ_SET_REPORT = 9,
	HID_REQ_SET_IDLE = 10,
	HID_REQ_SET_PROTOCOL = 11,
};

enum hid_report_type {
	HID_INPUT_REPORT = 0,
	HID_OUTPUT_REPORT = 1,
	HID_FEATURE_REPORT = 2,
	HID_REPORT_TYPES = 3,
};

enum hid_type {
	HID_TYPE_OTHER = 0,
	HID_TYPE_USBMOUSE = 1,
	HID_TYPE_USBNONE = 2,
};

enum hist_field_flags {
	HIST_FIELD_FL_HITCOUNT = 1,
	HIST_FIELD_FL_KEY = 2,
	HIST_FIELD_FL_STRING = 4,
	HIST_FIELD_FL_HEX = 8,
	HIST_FIELD_FL_SYM = 16,
	HIST_FIELD_FL_SYM_OFFSET = 32,
	HIST_FIELD_FL_EXECNAME = 64,
	HIST_FIELD_FL_SYSCALL = 128,
	HIST_FIELD_FL_STACKTRACE = 256,
	HIST_FIELD_FL_LOG2 = 512,
	HIST_FIELD_FL_TIMESTAMP = 1024,
	HIST_FIELD_FL_TIMESTAMP_USECS = 2048,
	HIST_FIELD_FL_VAR = 4096,
	HIST_FIELD_FL_EXPR = 8192,
	HIST_FIELD_FL_VAR_REF = 16384,
	HIST_FIELD_FL_CPU = 32768,
	HIST_FIELD_FL_ALIAS = 65536,
	HIST_FIELD_FL_BUCKET = 131072,
	HIST_FIELD_FL_CONST = 262144,
	HIST_FIELD_FL_PERCENT = 524288,
	HIST_FIELD_FL_GRAPH = 1048576,
	HIST_FIELD_FL_COMM = 2097152,
};

enum hist_field_fn {
	HIST_FIELD_FN_NOP = 0,
	HIST_FIELD_FN_VAR_REF = 1,
	HIST_FIELD_FN_COUNTER = 2,
	HIST_FIELD_FN_CONST = 3,
	HIST_FIELD_FN_LOG2 = 4,
	HIST_FIELD_FN_BUCKET = 5,
	HIST_FIELD_FN_TIMESTAMP = 6,
	HIST_FIELD_FN_CPU = 7,
	HIST_FIELD_FN_COMM = 8,
	HIST_FIELD_FN_STRING = 9,
	HIST_FIELD_FN_DYNSTRING = 10,
	HIST_FIELD_FN_RELDYNSTRING = 11,
	HIST_FIELD_FN_PSTRING = 12,
	HIST_FIELD_FN_S64 = 13,
	HIST_FIELD_FN_U64 = 14,
	HIST_FIELD_FN_S32 = 15,
	HIST_FIELD_FN_U32 = 16,
	HIST_FIELD_FN_S16 = 17,
	HIST_FIELD_FN_U16 = 18,
	HIST_FIELD_FN_S8 = 19,
	HIST_FIELD_FN_U8 = 20,
	HIST_FIELD_FN_UMINUS = 21,
	HIST_FIELD_FN_MINUS = 22,
	HIST_FIELD_FN_PLUS = 23,
	HIST_FIELD_FN_DIV = 24,
	HIST_FIELD_FN_MULT = 25,
	HIST_FIELD_FN_DIV_POWER2 = 26,
	HIST_FIELD_FN_DIV_NOT_POWER2 = 27,
	HIST_FIELD_FN_DIV_MULT_SHIFT = 28,
	HIST_FIELD_FN_EXECNAME = 29,
	HIST_FIELD_FN_STACK = 30,
};

enum hk_flags {
	HK_FLAG_DOMAIN = 1,
	HK_FLAG_MANAGED_IRQ = 2,
	HK_FLAG_KERNEL_NOISE = 4,
};

enum hk_type {
	HK_TYPE_DOMAIN = 0,
	HK_TYPE_MANAGED_IRQ = 1,
	HK_TYPE_KERNEL_NOISE = 2,
	HK_TYPE_MAX = 3,
	HK_TYPE_TICK = 2,
	HK_TYPE_TIMER = 2,
	HK_TYPE_RCU = 2,
	HK_TYPE_MISC = 2,
	HK_TYPE_WQ = 2,
	HK_TYPE_KTHREAD = 2,
};

enum hmm_pfn_flags {
	HMM_PFN_VALID = 9223372036854775808ULL,
	HMM_PFN_WRITE = 4611686018427387904ULL,
	HMM_PFN_ERROR = 2305843009213693952ULL,
	HMM_PFN_DMA_MAPPED = 1152921504606846976ULL,
	HMM_PFN_P2PDMA = 576460752303423488ULL,
	HMM_PFN_P2PDMA_BUS = 288230376151711744ULL,
	HMM_PFN_ORDER_SHIFT = 53ULL,
	HMM_PFN_REQ_FAULT = 9223372036854775808ULL,
	HMM_PFN_REQ_WRITE = 4611686018427387904ULL,
	HMM_PFN_FLAGS = 18437736874454810624ULL,
};

enum hn_flags_bits {
	HANDSHAKE_F_NET_DRAINING = 0,
};

enum hp_flags_bits {
	HANDSHAKE_F_PROTO_NOTIFY = 0,
};

enum hpet_mode {
	HPET_MODE_UNUSED = 0,
	HPET_MODE_LEGACY = 1,
	HPET_MODE_CLOCKEVT = 2,
	HPET_MODE_DEVICE = 3,
};

enum hprobe_state {
	HPROBE_LEASED = 0,
	HPROBE_STABLE = 1,
	HPROBE_GONE = 2,
	HPROBE_CONSUMED = 3,
};

enum hpx_type3_cfg_loc {
	HPX_CFG_PCICFG = 0,
	HPX_CFG_PCIE_CAP = 1,
	HPX_CFG_PCIE_CAP_EXT = 2,
	HPX_CFG_VEND_CAP = 3,
	HPX_CFG_DVSEC = 4,
	HPX_CFG_MAX = 5,
};

enum hpx_type3_dev_type {
	HPX_TYPE_ENDPOINT = 1,
	HPX_TYPE_LEG_END = 2,
	HPX_TYPE_RC_END = 4,
	HPX_TYPE_RC_EC = 8,
	HPX_TYPE_ROOT_PORT = 16,
	HPX_TYPE_UPSTREAM = 32,
	HPX_TYPE_DOWNSTREAM = 64,
	HPX_TYPE_PCI_BRIDGE = 128,
	HPX_TYPE_PCIE_BRIDGE = 256,
};

enum hpx_type3_fn_type {
	HPX_FN_NORMAL = 1,
	HPX_FN_SRIOV_PHYS = 2,
	HPX_FN_SRIOV_VIRT = 4,
};

enum hr_flags_bits {
	HANDSHAKE_F_REQ_COMPLETED = 0,
	HANDSHAKE_F_REQ_SESSION = 1,
};

enum hrtimer_base_type {
	HRTIMER_BASE_MONOTONIC = 0,
	HRTIMER_BASE_REALTIME = 1,
	HRTIMER_BASE_BOOTTIME = 2,
	HRTIMER_BASE_TAI = 3,
	HRTIMER_BASE_MONOTONIC_SOFT = 4,
	HRTIMER_BASE_REALTIME_SOFT = 5,
	HRTIMER_BASE_BOOTTIME_SOFT = 6,
	HRTIMER_BASE_TAI_SOFT = 7,
	HRTIMER_MAX_CLOCK_BASES = 8,
};

enum hrtimer_mode {
	HRTIMER_MODE_ABS = 0,
	HRTIMER_MODE_REL = 1,
	HRTIMER_MODE_PINNED = 2,
	HRTIMER_MODE_SOFT = 4,
	HRTIMER_MODE_HARD = 8,
	HRTIMER_MODE_ABS_PINNED = 2,
	HRTIMER_MODE_REL_PINNED = 3,
	HRTIMER_MODE_ABS_SOFT = 4,
	HRTIMER_MODE_REL_SOFT = 5,
	HRTIMER_MODE_ABS_PINNED_SOFT = 6,
	HRTIMER_MODE_REL_PINNED_SOFT = 7,
	HRTIMER_MODE_ABS_HARD = 8,
	HRTIMER_MODE_REL_HARD = 9,
	HRTIMER_MODE_ABS_PINNED_HARD = 10,
	HRTIMER_MODE_REL_PINNED_HARD = 11,
};

enum hrtimer_restart {
	HRTIMER_NORESTART = 0,
	HRTIMER_RESTART = 1,
};

enum hsm_task_states {
	HSM_ST_IDLE = 0,
	HSM_ST_FIRST = 1,
	HSM_ST = 2,
	HSM_ST_LAST = 3,
	HSM_ST_ERR = 4,
};

enum hte_edge {
	HTE_EDGE_NO_SETUP = 1,
	HTE_RISING_EDGE_TS = 2,
	HTE_FALLING_EDGE_TS = 4,
};

enum hte_return {
	HTE_CB_HANDLED = 0,
	HTE_RUN_SECOND_CB = 1,
};

enum hub_activation_type {
	HUB_INIT = 0,
	HUB_INIT2 = 1,
	HUB_INIT3 = 2,
	HUB_POST_RESET = 3,
	HUB_RESUME = 4,
	HUB_RESET_RESUME = 5,
};

enum hub_led_mode {
	INDICATOR_AUTO = 0,
	INDICATOR_CYCLE = 1,
	INDICATOR_GREEN_BLINK = 2,
	INDICATOR_GREEN_BLINK_OFF = 3,
	INDICATOR_AMBER_BLINK = 4,
	INDICATOR_AMBER_BLINK_OFF = 5,
	INDICATOR_ALT_BLINK = 6,
	INDICATOR_ALT_BLINK_OFF = 7,
} __attribute__((mode(byte)));

enum hub_quiescing_type {
	HUB_DISCONNECT = 0,
	HUB_PRE_RESET = 1,
	HUB_SUSPEND = 2,
};

enum hugetlb_memory_event {
	HUGETLB_MAX = 0,
	HUGETLB_NR_MEMORY_EVENTS = 1,
};

enum hugetlb_page_flags {
	HPG_restore_reserve = 0,
	HPG_migratable = 1,
	HPG_temporary = 2,
	HPG_freed = 3,
	HPG_vmemmap_optimized = 4,
	HPG_raw_hwp_unreliable = 5,
	HPG_cma = 6,
	__NR_HPAGEFLAGS = 7,
};

enum hugetlb_param {
	Opt_gid___6 = 0,
	Opt_min_size = 1,
	Opt_mode___4 = 2,
	Opt_nr_inodes = 3,
	Opt_pagesize = 4,
	Opt_size = 5,
	Opt_uid___6 = 6,
};

enum hugetlbfs_size_type {
	NO_SIZE = 0,
	SIZE_STD = 1,
	SIZE_PERCENT = 2,
};

enum hv_device_type {
	HV_DEVICE_TYPE_LOGICAL = 0,
	HV_DEVICE_TYPE_PCI = 1,
	HV_DEVICE_TYPE_IOAPIC = 2,
	HV_DEVICE_TYPE_ACPI = 3,
};

enum hv_generic_set_format {
	HV_GENERIC_SET_SPARSE_4K = 0,
	HV_GENERIC_SET_ALL = 1,
};

enum hv_interrupt_trigger_mode {
	HV_INTERRUPT_TRIGGER_MODE_EDGE = 0,
	HV_INTERRUPT_TRIGGER_MODE_LEVEL = 1,
};

enum hv_interrupt_type {
	HV_X64_INTERRUPT_TYPE_FIXED = 0,
	HV_X64_INTERRUPT_TYPE_LOWESTPRIORITY = 1,
	HV_X64_INTERRUPT_TYPE_SMI = 2,
	HV_X64_INTERRUPT_TYPE_REMOTEREAD = 3,
	HV_X64_INTERRUPT_TYPE_NMI = 4,
	HV_X64_INTERRUPT_TYPE_INIT = 5,
	HV_X64_INTERRUPT_TYPE_SIPI = 6,
	HV_X64_INTERRUPT_TYPE_EXTINT = 7,
	HV_X64_INTERRUPT_TYPE_LOCALINT0 = 8,
	HV_X64_INTERRUPT_TYPE_LOCALINT1 = 9,
	HV_X64_INTERRUPT_TYPE_MAXIMUM = 10,
};

enum hv_isolation_type {
	HV_ISOLATION_TYPE_NONE = 0,
	HV_ISOLATION_TYPE_VBS = 1,
	HV_ISOLATION_TYPE_SNP = 2,
	HV_ISOLATION_TYPE_TDX = 3,
};

enum hv_mem_host_visibility {
	VMBUS_PAGE_NOT_VISIBLE = 0,
	VMBUS_PAGE_VISIBLE_READ_ONLY = 1,
	VMBUS_PAGE_VISIBLE_READ_WRITE = 3,
};

enum hv_partition_type {
	HV_PARTITION_TYPE_GUEST = 0,
	HV_PARTITION_TYPE_ROOT = 1,
};

enum hv_tlb_flush_fifos {
	HV_L1_TLB_FLUSH_FIFO = 0,
	HV_L2_TLB_FLUSH_FIFO = 1,
	HV_NR_TLB_FLUSH_FIFOS = 2,
};

enum hv_tsc_page_status {
	HV_TSC_PAGE_UNSET = 0,
	HV_TSC_PAGE_GUEST_CHANGED = 1,
	HV_TSC_PAGE_HOST_CHANGED = 2,
	HV_TSC_PAGE_SET = 3,
	HV_TSC_PAGE_BROKEN = 4,
};

enum hvmmem_type_t {
	HVMMEM_ram_rw = 0,
	HVMMEM_ram_ro = 1,
	HVMMEM_mmio_dm = 2,
};

enum hw_event_mc_err_type {
	HW_EVENT_ERR_CORRECTED = 0,
	HW_EVENT_ERR_UNCORRECTED = 1,
	HW_EVENT_ERR_DEFERRED = 2,
	HW_EVENT_ERR_FATAL = 3,
	HW_EVENT_ERR_INFO = 4,
};

enum hw_protection_action {
	HWPROT_ACT_DEFAULT = 0,
	HWPROT_ACT_SHUTDOWN = 1,
	HWPROT_ACT_REBOOT = 2,
};

enum hwmon_chip_attributes {
	hwmon_chip_temp_reset_history = 0,
	hwmon_chip_in_reset_history = 1,
	hwmon_chip_curr_reset_history = 2,
	hwmon_chip_power_reset_history = 3,
	hwmon_chip_register_tz = 4,
	hwmon_chip_update_interval = 5,
	hwmon_chip_alarms = 6,
	hwmon_chip_samples = 7,
	hwmon_chip_curr_samples = 8,
	hwmon_chip_in_samples = 9,
	hwmon_chip_power_samples = 10,
	hwmon_chip_temp_samples = 11,
	hwmon_chip_beep_enable = 12,
	hwmon_chip_pec = 13,
};

enum hwmon_curr_attributes {
	hwmon_curr_enable = 0,
	hwmon_curr_input = 1,
	hwmon_curr_min = 2,
	hwmon_curr_max = 3,
	hwmon_curr_lcrit = 4,
	hwmon_curr_crit = 5,
	hwmon_curr_average = 6,
	hwmon_curr_lowest = 7,
	hwmon_curr_highest = 8,
	hwmon_curr_reset_history = 9,
	hwmon_curr_label = 10,
	hwmon_curr_alarm = 11,
	hwmon_curr_min_alarm = 12,
	hwmon_curr_max_alarm = 13,
	hwmon_curr_lcrit_alarm = 14,
	hwmon_curr_crit_alarm = 15,
	hwmon_curr_rated_min = 16,
	hwmon_curr_rated_max = 17,
	hwmon_curr_beep = 18,
};

enum hwmon_energy_attributes {
	hwmon_energy_enable = 0,
	hwmon_energy_input = 1,
	hwmon_energy_label = 2,
};

enum hwmon_fan_attributes {
	hwmon_fan_enable = 0,
	hwmon_fan_input = 1,
	hwmon_fan_label = 2,
	hwmon_fan_min = 3,
	hwmon_fan_max = 4,
	hwmon_fan_div = 5,
	hwmon_fan_pulses = 6,
	hwmon_fan_target = 7,
	hwmon_fan_alarm = 8,
	hwmon_fan_min_alarm = 9,
	hwmon_fan_max_alarm = 10,
	hwmon_fan_fault = 11,
	hwmon_fan_beep = 12,
};

enum hwmon_humidity_attributes {
	hwmon_humidity_enable = 0,
	hwmon_humidity_input = 1,
	hwmon_humidity_label = 2,
	hwmon_humidity_min = 3,
	hwmon_humidity_min_hyst = 4,
	hwmon_humidity_max = 5,
	hwmon_humidity_max_hyst = 6,
	hwmon_humidity_alarm = 7,
	hwmon_humidity_fault = 8,
	hwmon_humidity_rated_min = 9,
	hwmon_humidity_rated_max = 10,
	hwmon_humidity_min_alarm = 11,
	hwmon_humidity_max_alarm = 12,
};

enum hwmon_in_attributes {
	hwmon_in_enable = 0,
	hwmon_in_input = 1,
	hwmon_in_min = 2,
	hwmon_in_max = 3,
	hwmon_in_lcrit = 4,
	hwmon_in_crit = 5,
	hwmon_in_average = 6,
	hwmon_in_lowest = 7,
	hwmon_in_highest = 8,
	hwmon_in_reset_history = 9,
	hwmon_in_label = 10,
	hwmon_in_alarm = 11,
	hwmon_in_min_alarm = 12,
	hwmon_in_max_alarm = 13,
	hwmon_in_lcrit_alarm = 14,
	hwmon_in_crit_alarm = 15,
	hwmon_in_rated_min = 16,
	hwmon_in_rated_max = 17,
	hwmon_in_beep = 18,
	hwmon_in_fault = 19,
};

enum hwmon_intrusion_attributes {
	hwmon_intrusion_alarm = 0,
	hwmon_intrusion_beep = 1,
};

enum hwmon_power_attributes {
	hwmon_power_enable = 0,
	hwmon_power_average = 1,
	hwmon_power_average_interval = 2,
	hwmon_power_average_interval_max = 3,
	hwmon_power_average_interval_min = 4,
	hwmon_power_average_highest = 5,
	hwmon_power_average_lowest = 6,
	hwmon_power_average_max = 7,
	hwmon_power_average_min = 8,
	hwmon_power_input = 9,
	hwmon_power_input_highest = 10,
	hwmon_power_input_lowest = 11,
	hwmon_power_reset_history = 12,
	hwmon_power_accuracy = 13,
	hwmon_power_cap = 14,
	hwmon_power_cap_hyst = 15,
	hwmon_power_cap_max = 16,
	hwmon_power_cap_min = 17,
	hwmon_power_min = 18,
	hwmon_power_max = 19,
	hwmon_power_crit = 20,
	hwmon_power_lcrit = 21,
	hwmon_power_label = 22,
	hwmon_power_alarm = 23,
	hwmon_power_cap_alarm = 24,
	hwmon_power_min_alarm = 25,
	hwmon_power_max_alarm = 26,
	hwmon_power_lcrit_alarm = 27,
	hwmon_power_crit_alarm = 28,
	hwmon_power_rated_min = 29,
	hwmon_power_rated_max = 30,
};

enum hwmon_pwm_attributes {
	hwmon_pwm_input = 0,
	hwmon_pwm_enable = 1,
	hwmon_pwm_mode = 2,
	hwmon_pwm_freq = 3,
	hwmon_pwm_auto_channels_temp = 4,
};

enum hwmon_sensor_types {
	hwmon_chip = 0,
	hwmon_temp = 1,
	hwmon_in = 2,
	hwmon_curr = 3,
	hwmon_power = 4,
	hwmon_energy = 5,
	hwmon_humidity = 6,
	hwmon_fan = 7,
	hwmon_pwm = 8,
	hwmon_intrusion = 9,
	hwmon_max = 10,
};

enum hwmon_temp_attributes {
	hwmon_temp_enable = 0,
	hwmon_temp_input = 1,
	hwmon_temp_type = 2,
	hwmon_temp_lcrit = 3,
	hwmon_temp_lcrit_hyst = 4,
	hwmon_temp_min = 5,
	hwmon_temp_min_hyst = 6,
	hwmon_temp_max = 7,
	hwmon_temp_max_hyst = 8,
	hwmon_temp_crit = 9,
	hwmon_temp_crit_hyst = 10,
	hwmon_temp_emergency = 11,
	hwmon_temp_emergency_hyst = 12,
	hwmon_temp_alarm = 13,
	hwmon_temp_lcrit_alarm = 14,
	hwmon_temp_min_alarm = 15,
	hwmon_temp_max_alarm = 16,
	hwmon_temp_crit_alarm = 17,
	hwmon_temp_emergency_alarm = 18,
	hwmon_temp_fault = 19,
	hwmon_temp_offset = 20,
	hwmon_temp_label = 21,
	hwmon_temp_lowest = 22,
	hwmon_temp_highest = 23,
	hwmon_temp_reset_history = 24,
	hwmon_temp_rated_min = 25,
	hwmon_temp_rated_max = 26,
	hwmon_temp_beep = 27,
};

enum hwparam_type {
	hwparam_ioport = 0,
	hwparam_iomem = 1,
	hwparam_ioport_or_iomem = 2,
	hwparam_irq = 3,
	hwparam_dma = 4,
	hwparam_dma_addr = 5,
	hwparam_other = 6,
};

enum hwtstamp_flags {
	HWTSTAMP_FLAG_BONDED_PHC_INDEX = 1,
	HWTSTAMP_FLAG_LAST = 1,
	HWTSTAMP_FLAG_MASK = 1,
};

enum hwtstamp_provider_qualifier {
	HWTSTAMP_PROVIDER_QUALIFIER_PRECISE = 0,
	HWTSTAMP_PROVIDER_QUALIFIER_APPROX = 1,
	HWTSTAMP_PROVIDER_QUALIFIER_CNT = 2,
};

enum hwtstamp_rx_filters {
	HWTSTAMP_FILTER_NONE = 0,
	HWTSTAMP_FILTER_ALL = 1,
	HWTSTAMP_FILTER_SOME = 2,
	HWTSTAMP_FILTER_PTP_V1_L4_EVENT = 3,
	HWTSTAMP_FILTER_PTP_V1_L4_SYNC = 4,
	HWTSTAMP_FILTER_PTP_V1_L4_DELAY_REQ = 5,
	HWTSTAMP_FILTER_PTP_V2_L4_EVENT = 6,
	HWTSTAMP_FILTER_PTP_V2_L4_SYNC = 7,
	HWTSTAMP_FILTER_PTP_V2_L4_DELAY_REQ = 8,
	HWTSTAMP_FILTER_PTP_V2_L2_EVENT = 9,
	HWTSTAMP_FILTER_PTP_V2_L2_SYNC = 10,
	HWTSTAMP_FILTER_PTP_V2_L2_DELAY_REQ = 11,
	HWTSTAMP_FILTER_PTP_V2_EVENT = 12,
	HWTSTAMP_FILTER_PTP_V2_SYNC = 13,
	HWTSTAMP_FILTER_PTP_V2_DELAY_REQ = 14,
	HWTSTAMP_FILTER_NTP_ALL = 15,
	__HWTSTAMP_FILTER_CNT = 16,
};

enum hwtstamp_source {
	HWTSTAMP_SOURCE_NETDEV = 1,
	HWTSTAMP_SOURCE_PHYLIB = 2,
};

enum hwtstamp_tx_types {
	HWTSTAMP_TX_OFF = 0,
	HWTSTAMP_TX_ON = 1,
	HWTSTAMP_TX_ONESTEP_SYNC = 2,
	HWTSTAMP_TX_ONESTEP_P2P = 3,
	__HWTSTAMP_TX_CNT = 4,
};

enum hybrid_pmu_type {
	not_hybrid = 0,
	hybrid_small = 1,
	hybrid_big = 2,
	hybrid_tiny = 4,
	hybrid_big_small = 3,
	hybrid_small_tiny = 5,
	hybrid_big_small_tiny = 7,
};

enum i2c_alert_protocol {
	I2C_PROTOCOL_SMBUS_ALERT = 0,
	I2C_PROTOCOL_SMBUS_HOST_NOTIFY = 1,
};

enum i2c_driver_flags {
	I2C_DRV_ACPI_WAIVE_D0_PROBE = 1,
};

enum i2c_slave_event {
	I2C_SLAVE_READ_REQUESTED = 0,
	I2C_SLAVE_WRITE_REQUESTED = 1,
	I2C_SLAVE_READ_PROCESSED = 2,
	I2C_SLAVE_WRITE_RECEIVED = 3,
	I2C_SLAVE_STOP = 4,
};

enum i8042_controller_reset_mode {
	I8042_RESET_NEVER = 0,
	I8042_RESET_ALWAYS = 1,
	I8042_RESET_ON_S2RAM = 2,
};

enum ib_atomic_cap {
	IB_ATOMIC_NONE = 0,
	IB_ATOMIC_HCA = 1,
	IB_ATOMIC_GLOB = 2,
};

enum ib_cq_notify_flags {
	IB_CQ_SOLICITED = 1,
	IB_CQ_NEXT_COMP = 2,
	IB_CQ_SOLICITED_MASK = 3,
	IB_CQ_REPORT_MISSED_EVENTS = 4,
};

enum ib_event_type {
	IB_EVENT_CQ_ERR = 0,
	IB_EVENT_QP_FATAL = 1,
	IB_EVENT_QP_REQ_ERR = 2,
	IB_EVENT_QP_ACCESS_ERR = 3,
	IB_EVENT_COMM_EST = 4,
	IB_EVENT_SQ_DRAINED = 5,
	IB_EVENT_PATH_MIG = 6,
	IB_EVENT_PATH_MIG_ERR = 7,
	IB_EVENT_DEVICE_FATAL = 8,
	IB_EVENT_PORT_ACTIVE = 9,
	IB_EVENT_PORT_ERR = 10,
	IB_EVENT_LID_CHANGE = 11,
	IB_EVENT_PKEY_CHANGE = 12,
	IB_EVENT_SM_CHANGE = 13,
	IB_EVENT_SRQ_ERR = 14,
	IB_EVENT_SRQ_LIMIT_REACHED = 15,
	IB_EVENT_QP_LAST_WQE_REACHED = 16,
	IB_EVENT_CLIENT_REREGISTER = 17,
	IB_EVENT_GID_CHANGE = 18,
	IB_EVENT_WQ_FATAL = 19,
};

enum ib_flow_action_type {
	IB_FLOW_ACTION_UNSPECIFIED = 0,
	IB_FLOW_ACTION_ESP = 1,
};

enum ib_flow_attr_type {
	IB_FLOW_ATTR_NORMAL = 0,
	IB_FLOW_ATTR_ALL_DEFAULT = 1,
	IB_FLOW_ATTR_MC_DEFAULT = 2,
	IB_FLOW_ATTR_SNIFFER = 3,
};

enum ib_flow_spec_type {
	IB_FLOW_SPEC_ETH = 32,
	IB_FLOW_SPEC_IB = 34,
	IB_FLOW_SPEC_IPV4 = 48,
	IB_FLOW_SPEC_IPV6 = 49,
	IB_FLOW_SPEC_ESP = 52,
	IB_FLOW_SPEC_TCP = 64,
	IB_FLOW_SPEC_UDP = 65,
	IB_FLOW_SPEC_VXLAN_TUNNEL = 80,
	IB_FLOW_SPEC_GRE = 81,
	IB_FLOW_SPEC_MPLS = 96,
	IB_FLOW_SPEC_INNER = 256,
	IB_FLOW_SPEC_ACTION_TAG = 4096,
	IB_FLOW_SPEC_ACTION_DROP = 4097,
	IB_FLOW_SPEC_ACTION_HANDLE = 4098,
	IB_FLOW_SPEC_ACTION_COUNT = 4099,
};

enum ib_gid_type {
	IB_GID_TYPE_IB = 0,
	IB_GID_TYPE_ROCE = 1,
	IB_GID_TYPE_ROCE_UDP_ENCAP = 2,
	IB_GID_TYPE_SIZE = 3,
};

enum ib_mig_state {
	IB_MIG_MIGRATED = 0,
	IB_MIG_REARM = 1,
	IB_MIG_ARMED = 2,
};

enum ib_mr_type {
	IB_MR_TYPE_MEM_REG = 0,
	IB_MR_TYPE_SG_GAPS = 1,
	IB_MR_TYPE_DM = 2,
	IB_MR_TYPE_USER = 3,
	IB_MR_TYPE_DMA = 4,
	IB_MR_TYPE_INTEGRITY = 5,
};

enum ib_mtu {
	IB_MTU_256 = 1,
	IB_MTU_512 = 2,
	IB_MTU_1024 = 3,
	IB_MTU_2048 = 4,
	IB_MTU_4096 = 5,
};

enum ib_mw_type {
	IB_MW_TYPE_1 = 1,
	IB_MW_TYPE_2 = 2,
};

enum ib_poll_context {
	IB_POLL_SOFTIRQ = 0,
	IB_POLL_WORKQUEUE = 1,
	IB_POLL_UNBOUND_WORKQUEUE = 2,
	IB_POLL_LAST_POOL_TYPE = 2,
	IB_POLL_DIRECT = 3,
};

enum ib_port_state {
	IB_PORT_NOP = 0,
	IB_PORT_DOWN = 1,
	IB_PORT_INIT = 2,
	IB_PORT_ARMED = 3,
	IB_PORT_ACTIVE = 4,
	IB_PORT_ACTIVE_DEFER = 5,
};

enum ib_qp_state {
	IB_QPS_RESET = 0,
	IB_QPS_INIT = 1,
	IB_QPS_RTR = 2,
	IB_QPS_RTS = 3,
	IB_QPS_SQD = 4,
	IB_QPS_SQE = 5,
	IB_QPS_ERR = 6,
};

enum ib_qp_type {
	IB_QPT_SMI = 0,
	IB_QPT_GSI = 1,
	IB_QPT_RC = 2,
	IB_QPT_UC = 3,
	IB_QPT_UD = 4,
	IB_QPT_RAW_IPV6 = 5,
	IB_QPT_RAW_ETHERTYPE = 6,
	IB_QPT_RAW_PACKET = 8,
	IB_QPT_XRC_INI = 9,
	IB_QPT_XRC_TGT = 10,
	IB_QPT_MAX = 11,
	IB_QPT_DRIVER = 255,
	IB_QPT_RESERVED1 = 4096,
	IB_QPT_RESERVED2 = 4097,
	IB_QPT_RESERVED3 = 4098,
	IB_QPT_RESERVED4 = 4099,
	IB_QPT_RESERVED5 = 4100,
	IB_QPT_RESERVED6 = 4101,
	IB_QPT_RESERVED7 = 4102,
	IB_QPT_RESERVED8 = 4103,
	IB_QPT_RESERVED9 = 4104,
	IB_QPT_RESERVED10 = 4105,
};

enum ib_sig_err_type {
	IB_SIG_BAD_GUARD = 0,
	IB_SIG_BAD_REFTAG = 1,
	IB_SIG_BAD_APPTAG = 2,
};

enum ib_sig_type {
	IB_SIGNAL_ALL_WR = 0,
	IB_SIGNAL_REQ_WR = 1,
};

enum ib_signature_type {
	IB_SIG_TYPE_NONE = 0,
	IB_SIG_TYPE_T10_DIF = 1,
};

enum ib_srq_attr_mask {
	IB_SRQ_MAX_WR = 1,
	IB_SRQ_LIMIT = 2,
};

enum ib_srq_type {
	IB_SRQT_BASIC = 0,
	IB_SRQT_XRC = 1,
	IB_SRQT_TM = 2,
};

enum ib_t10_dif_bg_type {
	IB_T10DIF_CRC = 0,
	IB_T10DIF_CSUM = 1,
};

enum ib_uverbs_access_flags {
	IB_UVERBS_ACCESS_LOCAL_WRITE = 1,
	IB_UVERBS_ACCESS_REMOTE_WRITE = 2,
	IB_UVERBS_ACCESS_REMOTE_READ = 4,
	IB_UVERBS_ACCESS_REMOTE_ATOMIC = 8,
	IB_UVERBS_ACCESS_MW_BIND = 16,
	IB_UVERBS_ACCESS_ZERO_BASED = 32,
	IB_UVERBS_ACCESS_ON_DEMAND = 64,
	IB_UVERBS_ACCESS_HUGETLB = 128,
	IB_UVERBS_ACCESS_FLUSH_GLOBAL = 256,
	IB_UVERBS_ACCESS_FLUSH_PERSISTENT = 512,
	IB_UVERBS_ACCESS_RELAXED_ORDERING = 1048576,
	IB_UVERBS_ACCESS_OPTIONAL_RANGE = 1072693248,
};

enum ib_uverbs_advise_mr_advice {
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH = 0,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_WRITE = 1,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_NO_FAULT = 2,
};

enum ib_uverbs_create_qp_mask {
	IB_UVERBS_CREATE_QP_MASK_IND_TABLE = 1,
};

enum ib_uverbs_device_cap_flags {
	IB_UVERBS_DEVICE_RESIZE_MAX_WR = 1ULL,
	IB_UVERBS_DEVICE_BAD_PKEY_CNTR = 2ULL,
	IB_UVERBS_DEVICE_BAD_QKEY_CNTR = 4ULL,
	IB_UVERBS_DEVICE_RAW_MULTI = 8ULL,
	IB_UVERBS_DEVICE_AUTO_PATH_MIG = 16ULL,
	IB_UVERBS_DEVICE_CHANGE_PHY_PORT = 32ULL,
	IB_UVERBS_DEVICE_UD_AV_PORT_ENFORCE = 64ULL,
	IB_UVERBS_DEVICE_CURR_QP_STATE_MOD = 128ULL,
	IB_UVERBS_DEVICE_SHUTDOWN_PORT = 256ULL,
	IB_UVERBS_DEVICE_PORT_ACTIVE_EVENT = 1024ULL,
	IB_UVERBS_DEVICE_SYS_IMAGE_GUID = 2048ULL,
	IB_UVERBS_DEVICE_RC_RNR_NAK_GEN = 4096ULL,
	IB_UVERBS_DEVICE_SRQ_RESIZE = 8192ULL,
	IB_UVERBS_DEVICE_N_NOTIFY_CQ = 16384ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW = 131072ULL,
	IB_UVERBS_DEVICE_UD_IP_CSUM = 262144ULL,
	IB_UVERBS_DEVICE_XRC = 1048576ULL,
	IB_UVERBS_DEVICE_MEM_MGT_EXTENSIONS = 2097152ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2A = 8388608ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2B = 16777216ULL,
	IB_UVERBS_DEVICE_RC_IP_CSUM = 33554432ULL,
	IB_UVERBS_DEVICE_RAW_IP_CSUM = 67108864ULL,
	IB_UVERBS_DEVICE_MANAGED_FLOW_STEERING = 536870912ULL,
	IB_UVERBS_DEVICE_RAW_SCATTER_FCS = 17179869184ULL,
	IB_UVERBS_DEVICE_PCI_WRITE_END_PADDING = 68719476736ULL,
	IB_UVERBS_DEVICE_FLUSH_GLOBAL = 274877906944ULL,
	IB_UVERBS_DEVICE_FLUSH_PERSISTENT = 549755813888ULL,
	IB_UVERBS_DEVICE_ATOMIC_WRITE = 1099511627776ULL,
};

enum ib_uverbs_gid_type {
	IB_UVERBS_GID_TYPE_IB = 0,
	IB_UVERBS_GID_TYPE_ROCE_V1 = 1,
	IB_UVERBS_GID_TYPE_ROCE_V2 = 2,
};

enum ib_uverbs_odp_general_cap_bits {
	IB_UVERBS_ODP_SUPPORT = 1,
	IB_UVERBS_ODP_SUPPORT_IMPLICIT = 2,
};

enum ib_uverbs_odp_transport_cap_bits {
	IB_UVERBS_ODP_SUPPORT_SEND = 1,
	IB_UVERBS_ODP_SUPPORT_RECV = 2,
	IB_UVERBS_ODP_SUPPORT_WRITE = 4,
	IB_UVERBS_ODP_SUPPORT_READ = 8,
	IB_UVERBS_ODP_SUPPORT_ATOMIC = 16,
	IB_UVERBS_ODP_SUPPORT_SRQ_RECV = 32,
	IB_UVERBS_ODP_SUPPORT_FLUSH = 64,
	IB_UVERBS_ODP_SUPPORT_ATOMIC_WRITE = 128,
};

enum ib_uverbs_qp_create_flags {
	IB_UVERBS_QP_CREATE_BLOCK_MULTICAST_LOOPBACK = 2,
	IB_UVERBS_QP_CREATE_SCATTER_FCS = 256,
	IB_UVERBS_QP_CREATE_CVLAN_STRIPPING = 512,
	IB_UVERBS_QP_CREATE_PCI_WRITE_END_PADDING = 2048,
	IB_UVERBS_QP_CREATE_SQ_SIG_ALL = 4096,
};

enum ib_uverbs_qp_type {
	IB_UVERBS_QPT_RC = 2,
	IB_UVERBS_QPT_UC = 3,
	IB_UVERBS_QPT_UD = 4,
	IB_UVERBS_QPT_RAW_PACKET = 8,
	IB_UVERBS_QPT_XRC_INI = 9,
	IB_UVERBS_QPT_XRC_TGT = 10,
	IB_UVERBS_QPT_DRIVER = 255,
};

enum ib_uverbs_raw_packet_caps {
	IB_UVERBS_RAW_PACKET_CAP_CVLAN_STRIPPING = 1,
	IB_UVERBS_RAW_PACKET_CAP_SCATTER_FCS = 2,
	IB_UVERBS_RAW_PACKET_CAP_IP_CSUM = 4,
	IB_UVERBS_RAW_PACKET_CAP_DELAY_DROP = 8,
};

enum ib_uverbs_srq_type {
	IB_UVERBS_SRQT_BASIC = 0,
	IB_UVERBS_SRQT_XRC = 1,
	IB_UVERBS_SRQT_TM = 2,
};

enum ib_uverbs_wc_opcode {
	IB_UVERBS_WC_SEND = 0,
	IB_UVERBS_WC_RDMA_WRITE = 1,
	IB_UVERBS_WC_RDMA_READ = 2,
	IB_UVERBS_WC_COMP_SWAP = 3,
	IB_UVERBS_WC_FETCH_ADD = 4,
	IB_UVERBS_WC_BIND_MW = 5,
	IB_UVERBS_WC_LOCAL_INV = 6,
	IB_UVERBS_WC_TSO = 7,
	IB_UVERBS_WC_FLUSH = 8,
	IB_UVERBS_WC_ATOMIC_WRITE = 9,
};

enum ib_uverbs_wq_flags {
	IB_UVERBS_WQ_FLAGS_CVLAN_STRIPPING = 1,
	IB_UVERBS_WQ_FLAGS_SCATTER_FCS = 2,
	IB_UVERBS_WQ_FLAGS_DELAY_DROP = 4,
	IB_UVERBS_WQ_FLAGS_PCI_WRITE_END_PADDING = 8,
};

enum ib_uverbs_wq_type {
	IB_UVERBS_WQT_RQ = 0,
};

enum ib_uverbs_wr_opcode {
	IB_UVERBS_WR_RDMA_WRITE = 0,
	IB_UVERBS_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_UVERBS_WR_SEND = 2,
	IB_UVERBS_WR_SEND_WITH_IMM = 3,
	IB_UVERBS_WR_RDMA_READ = 4,
	IB_UVERBS_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_UVERBS_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_UVERBS_WR_LOCAL_INV = 7,
	IB_UVERBS_WR_BIND_MW = 8,
	IB_UVERBS_WR_SEND_WITH_INV = 9,
	IB_UVERBS_WR_TSO = 10,
	IB_UVERBS_WR_RDMA_READ_WITH_INV = 11,
	IB_UVERBS_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_UVERBS_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_UVERBS_WR_FLUSH = 14,
	IB_UVERBS_WR_ATOMIC_WRITE = 15,
};

enum ib_uverbs_write_cmds {
	IB_USER_VERBS_CMD_GET_CONTEXT = 0,
	IB_USER_VERBS_CMD_QUERY_DEVICE = 1,
	IB_USER_VERBS_CMD_QUERY_PORT = 2,
	IB_USER_VERBS_CMD_ALLOC_PD = 3,
	IB_USER_VERBS_CMD_DEALLOC_PD = 4,
	IB_USER_VERBS_CMD_CREATE_AH = 5,
	IB_USER_VERBS_CMD_MODIFY_AH = 6,
	IB_USER_VERBS_CMD_QUERY_AH = 7,
	IB_USER_VERBS_CMD_DESTROY_AH = 8,
	IB_USER_VERBS_CMD_REG_MR = 9,
	IB_USER_VERBS_CMD_REG_SMR = 10,
	IB_USER_VERBS_CMD_REREG_MR = 11,
	IB_USER_VERBS_CMD_QUERY_MR = 12,
	IB_USER_VERBS_CMD_DEREG_MR = 13,
	IB_USER_VERBS_CMD_ALLOC_MW = 14,
	IB_USER_VERBS_CMD_BIND_MW = 15,
	IB_USER_VERBS_CMD_DEALLOC_MW = 16,
	IB_USER_VERBS_CMD_CREATE_COMP_CHANNEL = 17,
	IB_USER_VERBS_CMD_CREATE_CQ = 18,
	IB_USER_VERBS_CMD_RESIZE_CQ = 19,
	IB_USER_VERBS_CMD_DESTROY_CQ = 20,
	IB_USER_VERBS_CMD_POLL_CQ = 21,
	IB_USER_VERBS_CMD_PEEK_CQ = 22,
	IB_USER_VERBS_CMD_REQ_NOTIFY_CQ = 23,
	IB_USER_VERBS_CMD_CREATE_QP = 24,
	IB_USER_VERBS_CMD_QUERY_QP = 25,
	IB_USER_VERBS_CMD_MODIFY_QP = 26,
	IB_USER_VERBS_CMD_DESTROY_QP = 27,
	IB_USER_VERBS_CMD_POST_SEND = 28,
	IB_USER_VERBS_CMD_POST_RECV = 29,
	IB_USER_VERBS_CMD_ATTACH_MCAST = 30,
	IB_USER_VERBS_CMD_DETACH_MCAST = 31,
	IB_USER_VERBS_CMD_CREATE_SRQ = 32,
	IB_USER_VERBS_CMD_MODIFY_SRQ = 33,
	IB_USER_VERBS_CMD_QUERY_SRQ = 34,
	IB_USER_VERBS_CMD_DESTROY_SRQ = 35,
	IB_USER_VERBS_CMD_POST_SRQ_RECV = 36,
	IB_USER_VERBS_CMD_OPEN_XRCD = 37,
	IB_USER_VERBS_CMD_CLOSE_XRCD = 38,
	IB_USER_VERBS_CMD_CREATE_XSRQ = 39,
	IB_USER_VERBS_CMD_OPEN_QP = 40,
};

enum ib_wc_opcode {
	IB_WC_SEND = 0,
	IB_WC_RDMA_WRITE = 1,
	IB_WC_RDMA_READ = 2,
	IB_WC_COMP_SWAP = 3,
	IB_WC_FETCH_ADD = 4,
	IB_WC_BIND_MW = 5,
	IB_WC_LOCAL_INV = 6,
	IB_WC_LSO = 7,
	IB_WC_ATOMIC_WRITE = 9,
	IB_WC_REG_MR = 10,
	IB_WC_MASKED_COMP_SWAP = 11,
	IB_WC_MASKED_FETCH_ADD = 12,
	IB_WC_FLUSH = 8,
	IB_WC_RECV = 128,
	IB_WC_RECV_RDMA_WITH_IMM = 129,
};

enum ib_wc_status {
	IB_WC_SUCCESS = 0,
	IB_WC_LOC_LEN_ERR = 1,
	IB_WC_LOC_QP_OP_ERR = 2,
	IB_WC_LOC_EEC_OP_ERR = 3,
	IB_WC_LOC_PROT_ERR = 4,
	IB_WC_WR_FLUSH_ERR = 5,
	IB_WC_MW_BIND_ERR = 6,
	IB_WC_BAD_RESP_ERR = 7,
	IB_WC_LOC_ACCESS_ERR = 8,
	IB_WC_REM_INV_REQ_ERR = 9,
	IB_WC_REM_ACCESS_ERR = 10,
	IB_WC_REM_OP_ERR = 11,
	IB_WC_RETRY_EXC_ERR = 12,
	IB_WC_RNR_RETRY_EXC_ERR = 13,
	IB_WC_LOC_RDD_VIOL_ERR = 14,
	IB_WC_REM_INV_RD_REQ_ERR = 15,
	IB_WC_REM_ABORT_ERR = 16,
	IB_WC_INV_EECN_ERR = 17,
	IB_WC_INV_EEC_STATE_ERR = 18,
	IB_WC_FATAL_ERR = 19,
	IB_WC_RESP_TIMEOUT_ERR = 20,
	IB_WC_GENERAL_ERR = 21,
};

enum ib_wq_state {
	IB_WQS_RESET = 0,
	IB_WQS_RDY = 1,
	IB_WQS_ERR = 2,
};

enum ib_wq_type {
	IB_WQT_RQ = 0,
};

enum ib_wr_opcode {
	IB_WR_RDMA_WRITE = 0,
	IB_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_WR_SEND = 2,
	IB_WR_SEND_WITH_IMM = 3,
	IB_WR_RDMA_READ = 4,
	IB_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_WR_BIND_MW = 8,
	IB_WR_LSO = 10,
	IB_WR_SEND_WITH_INV = 9,
	IB_WR_RDMA_READ_WITH_INV = 11,
	IB_WR_LOCAL_INV = 7,
	IB_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_WR_FLUSH = 14,
	IB_WR_ATOMIC_WRITE = 15,
	IB_WR_REG_MR = 32,
	IB_WR_REG_MR_INTEGRITY = 33,
	IB_WR_RESERVED1 = 240,
	IB_WR_RESERVED2 = 241,
	IB_WR_RESERVED3 = 242,
	IB_WR_RESERVED4 = 243,
	IB_WR_RESERVED5 = 244,
	IB_WR_RESERVED6 = 245,
	IB_WR_RESERVED7 = 246,
	IB_WR_RESERVED8 = 247,
	IB_WR_RESERVED9 = 248,
	IB_WR_RESERVED10 = 249,
};

enum ibs_states {
	IBS_ENABLED = 0,
	IBS_STARTED = 1,
	IBS_STOPPING = 2,
	IBS_STOPPED = 3,
	IBS_MAX_STATES = 4,
};

enum id_action {
	ID_REMOVE = 0,
	ID_ADD = 1,
};

enum idle_boot_override {
	IDLE_NO_OVERRIDE = 0,
	IDLE_HALT = 1,
	IDLE_NOMWAIT = 2,
	IDLE_POLL = 3,
};

enum ieee80211_bss_type {
	IEEE80211_BSS_TYPE_ESS = 0,
	IEEE80211_BSS_TYPE_PBSS = 1,
	IEEE80211_BSS_TYPE_IBSS = 2,
	IEEE80211_BSS_TYPE_MBSS = 3,
	IEEE80211_BSS_TYPE_ANY = 4,
};

enum ieee80211_edmg_bw_config {
	IEEE80211_EDMG_BW_CONFIG_4 = 4,
	IEEE80211_EDMG_BW_CONFIG_5 = 5,
	IEEE80211_EDMG_BW_CONFIG_6 = 6,
	IEEE80211_EDMG_BW_CONFIG_7 = 7,
	IEEE80211_EDMG_BW_CONFIG_8 = 8,
	IEEE80211_EDMG_BW_CONFIG_9 = 9,
	IEEE80211_EDMG_BW_CONFIG_10 = 10,
	IEEE80211_EDMG_BW_CONFIG_11 = 11,
	IEEE80211_EDMG_BW_CONFIG_12 = 12,
	IEEE80211_EDMG_BW_CONFIG_13 = 13,
	IEEE80211_EDMG_BW_CONFIG_14 = 14,
	IEEE80211_EDMG_BW_CONFIG_15 = 15,
};

enum ieee802154_filtering_level {
	IEEE802154_FILTERING_NONE = 0,
	IEEE802154_FILTERING_1_FCS = 1,
	IEEE802154_FILTERING_2_PROMISCUOUS = 2,
	IEEE802154_FILTERING_3_SCAN = 3,
	IEEE802154_FILTERING_4_FRAME_FIELDS = 4,
};

enum ieee8021q_traffic_type {
	IEEE8021Q_TT_BK = 0,
	IEEE8021Q_TT_BE = 1,
	IEEE8021Q_TT_EE = 2,
	IEEE8021Q_TT_CA = 3,
	IEEE8021Q_TT_VI = 4,
	IEEE8021Q_TT_VO = 5,
	IEEE8021Q_TT_IC = 6,
	IEEE8021Q_TT_NC = 7,
	IEEE8021Q_TT_MAX = 8,
};

enum ieee_attrs {
	DCB_ATTR_IEEE_UNSPEC = 0,
	DCB_ATTR_IEEE_ETS = 1,
	DCB_ATTR_IEEE_PFC = 2,
	DCB_ATTR_IEEE_APP_TABLE = 3,
	DCB_ATTR_IEEE_PEER_ETS = 4,
	DCB_ATTR_IEEE_PEER_PFC = 5,
	DCB_ATTR_IEEE_PEER_APP = 6,
	DCB_ATTR_IEEE_MAXRATE = 7,
	DCB_ATTR_IEEE_QCN = 8,
	DCB_ATTR_IEEE_QCN_STATS = 9,
	DCB_ATTR_DCB_BUFFER = 10,
	DCB_ATTR_DCB_APP_TRUST_TABLE = 11,
	DCB_ATTR_DCB_REWR_TABLE = 12,
	__DCB_ATTR_IEEE_MAX = 13,
};

enum ieee_attrs_app {
	DCB_ATTR_IEEE_APP_UNSPEC = 0,
	DCB_ATTR_IEEE_APP = 1,
	DCB_ATTR_DCB_APP = 2,
	__DCB_ATTR_IEEE_APP_MAX = 3,
};

enum ii_ids {
	II_MEM = 0,
	II_RESV = 1,
	II_IO = 2,
	II_GEN = 3,
};

enum in6_addr_gen_mode {
	IN6_ADDR_GEN_MODE_EUI64 = 0,
	IN6_ADDR_GEN_MODE_NONE = 1,
	IN6_ADDR_GEN_MODE_STABLE_PRIVACY = 2,
	IN6_ADDR_GEN_MODE_RANDOM = 3,
};

enum inet_csk_ack_state_t {
	ICSK_ACK_SCHED = 1,
	ICSK_ACK_TIMER = 2,
	ICSK_ACK_PUSHED = 4,
	ICSK_ACK_PUSHED2 = 8,
	ICSK_ACK_NOW = 16,
	ICSK_ACK_NOMEM = 32,
};

enum init_ns_ino {
	IPC_NS_INIT_INO = 4026531839,
	UTS_NS_INIT_INO = 4026531838,
	USER_NS_INIT_INO = 4026531837,
	PID_NS_INIT_INO = 4026531836,
	CGROUP_NS_INIT_INO = 4026531835,
	TIME_NS_INIT_INO = 4026531834,
	NET_NS_INIT_INO = 4026531833,
	MNT_NS_INIT_INO = 4026531832,
};

enum inode_i_mutex_lock_class {
	I_MUTEX_NORMAL = 0,
	I_MUTEX_PARENT = 1,
	I_MUTEX_CHILD = 2,
	I_MUTEX_XATTR = 3,
	I_MUTEX_NONDIR2 = 4,
	I_MUTEX_PARENT2 = 5,
};

enum input_clock_type {
	INPUT_CLK_REAL = 0,
	INPUT_CLK_MONO = 1,
	INPUT_CLK_BOOT = 2,
	INPUT_CLK_MAX = 3,
};

enum insn_mmio_type {
	INSN_MMIO_DECODE_FAILED = 0,
	INSN_MMIO_WRITE = 1,
	INSN_MMIO_WRITE_IMM = 2,
	INSN_MMIO_READ = 3,
	INSN_MMIO_READ_ZERO_EXTEND = 4,
	INSN_MMIO_READ_SIGN_EXTEND = 5,
	INSN_MMIO_MOVS = 6,
};

enum insn_mode {
	INSN_MODE_32 = 0,
	INSN_MODE_64 = 1,
	INSN_MODE_KERN = 2,
	INSN_NUM_MODES = 3,
};

enum insn_type {
	CALL = 0,
	NOP = 1,
	JMP = 2,
	RET = 3,
	JCC = 4,
};

enum int_type {
	SYS_INT = 1,
	DCDC_INT = 2,
	RTC_INT = 4,
	ADC_INT = 8,
	GPIO_INT = 16,
};

enum intel_cht_wc_models {
	INTEL_CHT_WC_UNKNOWN = 0,
	INTEL_CHT_WC_GPD_WIN_POCKET = 1,
	INTEL_CHT_WC_XIAOMI_MIPAD2 = 2,
	INTEL_CHT_WC_LENOVO_YOGABOOK1 = 3,
	INTEL_CHT_WC_LENOVO_YT3_X90 = 4,
};

enum intel_cpu_type {
	INTEL_CPU_TYPE_UNKNOWN = 0,
	INTEL_CPU_TYPE_ATOM = 32,
	INTEL_CPU_TYPE_CORE = 64,
};

enum intel_excl_state_type {
	INTEL_EXCL_UNUSED = 0,
	INTEL_EXCL_SHARED = 1,
	INTEL_EXCL_EXCLUSIVE = 2,
};

enum intel_native_id {
	INTEL_ATOM_CMT_NATIVE_ID = 2,
	INTEL_ATOM_SKT_NATIVE_ID = 3,
};

enum intercept_words {
	INTERCEPT_CR = 0,
	INTERCEPT_DR = 1,
	INTERCEPT_EXCEPTION = 2,
	INTERCEPT_WORD3 = 3,
	INTERCEPT_WORD4 = 4,
	INTERCEPT_WORD5 = 5,
	MAX_INTERCEPT = 6,
};

enum io_pgtable_caps {
	IO_PGTABLE_CAP_CUSTOM_ALLOCATOR = 1,
};

enum io_pgtable_fmt {
	ARM_32_LPAE_S1 = 0,
	ARM_32_LPAE_S2 = 1,
	ARM_64_LPAE_S1 = 2,
	ARM_64_LPAE_S2 = 3,
	ARM_V7S = 4,
	ARM_MALI_LPAE = 5,
	AMD_IOMMU_V1 = 6,
	AMD_IOMMU_V2 = 7,
	APPLE_DART = 8,
	APPLE_DART2 = 9,
	IO_PGTABLE_NUM_FMTS = 10,
};

enum io_uring_cmd_flags {
	IO_URING_F_COMPLETE_DEFER = 1,
	IO_URING_F_UNLOCKED = 2,
	IO_URING_F_MULTISHOT = 4,
	IO_URING_F_IOWQ = 8,
	IO_URING_F_INLINE = 16,
	IO_URING_F_NONBLOCK = -2147483648,
	IO_URING_F_SQE128 = 256,
	IO_URING_F_CQE32 = 512,
	IO_URING_F_IOPOLL = 1024,
	IO_URING_F_CANCEL = 2048,
	IO_URING_F_COMPAT = 4096,
	IO_URING_F_TASK_DEAD = 8192,
};

enum io_uring_msg_ring_flags {
	IORING_MSG_DATA = 0,
	IORING_MSG_SEND_FD = 1,
};

enum io_uring_napi_op {
	IO_URING_NAPI_REGISTER_OP = 0,
	IO_URING_NAPI_STATIC_ADD_ID = 1,
	IO_URING_NAPI_STATIC_DEL_ID = 2,
};

enum io_uring_napi_tracking_strategy {
	IO_URING_NAPI_TRACKING_DYNAMIC = 0,
	IO_URING_NAPI_TRACKING_STATIC = 1,
	IO_URING_NAPI_TRACKING_INACTIVE = 255,
};

enum io_uring_op {
	IORING_OP_NOP = 0,
	IORING_OP_READV = 1,
	IORING_OP_WRITEV = 2,
	IORING_OP_FSYNC = 3,
	IORING_OP_READ_FIXED = 4,
	IORING_OP_WRITE_FIXED = 5,
	IORING_OP_POLL_ADD = 6,
	IORING_OP_POLL_REMOVE = 7,
	IORING_OP_SYNC_FILE_RANGE = 8,
	IORING_OP_SENDMSG = 9,
	IORING_OP_RECVMSG = 10,
	IORING_OP_TIMEOUT = 11,
	IORING_OP_TIMEOUT_REMOVE = 12,
	IORING_OP_ACCEPT = 13,
	IORING_OP_ASYNC_CANCEL = 14,
	IORING_OP_LINK_TIMEOUT = 15,
	IORING_OP_CONNECT = 16,
	IORING_OP_FALLOCATE = 17,
	IORING_OP_OPENAT = 18,
	IORING_OP_CLOSE = 19,
	IORING_OP_FILES_UPDATE = 20,
	IORING_OP_STATX = 21,
	IORING_OP_READ = 22,
	IORING_OP_WRITE = 23,
	IORING_OP_FADVISE = 24,
	IORING_OP_MADVISE = 25,
	IORING_OP_SEND = 26,
	IORING_OP_RECV = 27,
	IORING_OP_OPENAT2 = 28,
	IORING_OP_EPOLL_CTL = 29,
	IORING_OP_SPLICE = 30,
	IORING_OP_PROVIDE_BUFFERS = 31,
	IORING_OP_REMOVE_BUFFERS = 32,
	IORING_OP_TEE = 33,
	IORING_OP_SHUTDOWN = 34,
	IORING_OP_RENAMEAT = 35,
	IORING_OP_UNLINKAT = 36,
	IORING_OP_MKDIRAT = 37,
	IORING_OP_SYMLINKAT = 38,
	IORING_OP_LINKAT = 39,
	IORING_OP_MSG_RING = 40,
	IORING_OP_FSETXATTR = 41,
	IORING_OP_SETXATTR = 42,
	IORING_OP_FGETXATTR = 43,
	IORING_OP_GETXATTR = 44,
	IORING_OP_SOCKET = 45,
	IORING_OP_URING_CMD = 46,
	IORING_OP_SEND_ZC = 47,
	IORING_OP_SENDMSG_ZC = 48,
	IORING_OP_READ_MULTISHOT = 49,
	IORING_OP_WAITID = 50,
	IORING_OP_FUTEX_WAIT = 51,
	IORING_OP_FUTEX_WAKE = 52,
	IORING_OP_FUTEX_WAITV = 53,
	IORING_OP_FIXED_FD_INSTALL = 54,
	IORING_OP_FTRUNCATE = 55,
	IORING_OP_BIND = 56,
	IORING_OP_LISTEN = 57,
	IORING_OP_RECV_ZC = 58,
	IORING_OP_EPOLL_WAIT = 59,
	IORING_OP_READV_FIXED = 60,
	IORING_OP_WRITEV_FIXED = 61,
	IORING_OP_PIPE = 62,
	IORING_OP_LAST = 63,
};

enum io_uring_register_op {
	IORING_REGISTER_BUFFERS = 0,
	IORING_UNREGISTER_BUFFERS = 1,
	IORING_REGISTER_FILES = 2,
	IORING_UNREGISTER_FILES = 3,
	IORING_REGISTER_EVENTFD = 4,
	IORING_UNREGISTER_EVENTFD = 5,
	IORING_REGISTER_FILES_UPDATE = 6,
	IORING_REGISTER_EVENTFD_ASYNC = 7,
	IORING_REGISTER_PROBE = 8,
	IORING_REGISTER_PERSONALITY = 9,
	IORING_UNREGISTER_PERSONALITY = 10,
	IORING_REGISTER_RESTRICTIONS = 11,
	IORING_REGISTER_ENABLE_RINGS = 12,
	IORING_REGISTER_FILES2 = 13,
	IORING_REGISTER_FILES_UPDATE2 = 14,
	IORING_REGISTER_BUFFERS2 = 15,
	IORING_REGISTER_BUFFERS_UPDATE = 16,
	IORING_REGISTER_IOWQ_AFF = 17,
	IORING_UNREGISTER_IOWQ_AFF = 18,
	IORING_REGISTER_IOWQ_MAX_WORKERS = 19,
	IORING_REGISTER_RING_FDS = 20,
	IORING_UNREGISTER_RING_FDS = 21,
	IORING_REGISTER_PBUF_RING = 22,
	IORING_UNREGISTER_PBUF_RING = 23,
	IORING_REGISTER_SYNC_CANCEL = 24,
	IORING_REGISTER_FILE_ALLOC_RANGE = 25,
	IORING_REGISTER_PBUF_STATUS = 26,
	IORING_REGISTER_NAPI = 27,
	IORING_UNREGISTER_NAPI = 28,
	IORING_REGISTER_CLOCK = 29,
	IORING_REGISTER_CLONE_BUFFERS = 30,
	IORING_REGISTER_SEND_MSG_RING = 31,
	IORING_REGISTER_ZCRX_IFQ = 32,
	IORING_REGISTER_RESIZE_RINGS = 33,
	IORING_REGISTER_MEM_REGION = 34,
	IORING_REGISTER_LAST = 35,
	IORING_REGISTER_USE_REGISTERED_RING = 2147483648,
};

enum io_uring_register_pbuf_ring_flags {
	IOU_PBUF_RING_MMAP = 1,
	IOU_PBUF_RING_INC = 2,
};

enum io_uring_register_restriction_op {
	IORING_RESTRICTION_REGISTER_OP = 0,
	IORING_RESTRICTION_SQE_OP = 1,
	IORING_RESTRICTION_SQE_FLAGS_ALLOWED = 2,
	IORING_RESTRICTION_SQE_FLAGS_REQUIRED = 3,
	IORING_RESTRICTION_LAST = 4,
};

enum io_uring_socket_op {
	SOCKET_URING_OP_SIOCINQ = 0,
	SOCKET_URING_OP_SIOCOUTQ = 1,
	SOCKET_URING_OP_GETSOCKOPT = 2,
	SOCKET_URING_OP_SETSOCKOPT = 3,
	SOCKET_URING_OP_TX_TIMESTAMP = 4,
};

enum io_uring_sqe_flags_bit {
	IOSQE_FIXED_FILE_BIT = 0,
	IOSQE_IO_DRAIN_BIT = 1,
	IOSQE_IO_LINK_BIT = 2,
	IOSQE_IO_HARDLINK_BIT = 3,
	IOSQE_ASYNC_BIT = 4,
	IOSQE_BUFFER_SELECT_BIT = 5,
	IOSQE_CQE_SKIP_SUCCESS_BIT = 6,
};

enum io_uring_zcrx_area_flags {
	IORING_ZCRX_AREA_DMABUF = 1,
};

enum io_wq_cancel {
	IO_WQ_CANCEL_OK = 0,
	IO_WQ_CANCEL_RUNNING = 1,
	IO_WQ_CANCEL_NOTFOUND = 2,
};

enum io_wq_type {
	IO_WQ_BOUND = 0,
	IO_WQ_UNBOUND = 1,
};

enum ioam6_event_attr {
	IOAM6_EVENT_ATTR_UNSPEC = 0,
	IOAM6_EVENT_ATTR_TRACE_NAMESPACE = 1,
	IOAM6_EVENT_ATTR_TRACE_NODELEN = 2,
	IOAM6_EVENT_ATTR_TRACE_TYPE = 3,
	IOAM6_EVENT_ATTR_TRACE_DATA = 4,
	__IOAM6_EVENT_ATTR_MAX = 5,
};

enum ioam6_event_type {
	IOAM6_EVENT_UNSPEC = 0,
	IOAM6_EVENT_TRACE = 1,
};

enum ioapic_domain_type {
	IOAPIC_DOMAIN_INVALID = 0,
	IOAPIC_DOMAIN_LEGACY = 1,
	IOAPIC_DOMAIN_STRICT = 2,
	IOAPIC_DOMAIN_DYNAMIC = 3,
};

enum ioc_running {
	IOC_IDLE = 0,
	IOC_RUNNING = 1,
	IOC_STOP = 2,
};

enum iommu_cap {
	IOMMU_CAP_CACHE_COHERENCY = 0,
	IOMMU_CAP_NOEXEC = 1,
	IOMMU_CAP_PRE_BOOT_PROTECTION = 2,
	IOMMU_CAP_ENFORCE_CACHE_COHERENCY = 3,
	IOMMU_CAP_DEFERRED_FLUSH = 4,
	IOMMU_CAP_DIRTY_TRACKING = 5,
};

enum iommu_dma_queue_type {
	IOMMU_DMA_OPTS_PER_CPU_QUEUE = 0,
	IOMMU_DMA_OPTS_SINGLE_QUEUE = 1,
};

enum iommu_domain_cookie_type {
	IOMMU_COOKIE_NONE = 0,
	IOMMU_COOKIE_DMA_IOVA = 1,
	IOMMU_COOKIE_DMA_MSI = 2,
	IOMMU_COOKIE_FAULT_HANDLER = 3,
	IOMMU_COOKIE_SVA = 4,
	IOMMU_COOKIE_IOMMUFD = 5,
};

enum iommu_fault_type {
	IOMMU_FAULT_PAGE_REQ = 1,
};

enum iommu_hw_info_type {
	IOMMU_HW_INFO_TYPE_NONE = 0,
	IOMMU_HW_INFO_TYPE_DEFAULT = 0,
	IOMMU_HW_INFO_TYPE_INTEL_VTD = 1,
	IOMMU_HW_INFO_TYPE_ARM_SMMUV3 = 2,
	IOMMU_HW_INFO_TYPE_TEGRA241_CMDQV = 3,
};

enum iommu_hw_info_vtd_flags {
	IOMMU_HW_INFO_VTD_ERRATA_772415_SPR17 = 1,
};

enum iommu_hw_queue_type {
	IOMMU_HW_QUEUE_TYPE_DEFAULT = 0,
	IOMMU_HW_QUEUE_TYPE_TEGRA241_CMDQV = 1,
};

enum iommu_hwpt_data_type {
	IOMMU_HWPT_DATA_NONE = 0,
	IOMMU_HWPT_DATA_VTD_S1 = 1,
	IOMMU_HWPT_DATA_ARM_SMMUV3 = 2,
};

enum iommu_hwpt_invalidate_data_type {
	IOMMU_HWPT_INVALIDATE_DATA_VTD_S1 = 0,
	IOMMU_VIOMMU_INVALIDATE_DATA_ARM_SMMUV3 = 1,
};

enum iommu_hwpt_vtd_s1_flags {
	IOMMU_VTD_S1_SRE = 1,
	IOMMU_VTD_S1_EAFE = 2,
	IOMMU_VTD_S1_WPE = 4,
};

enum iommu_hwpt_vtd_s1_invalidate_flags {
	IOMMU_VTD_INV_FLAGS_LEAF = 1,
};

enum iommu_init_state {
	IOMMU_START_STATE = 0,
	IOMMU_IVRS_DETECTED = 1,
	IOMMU_ACPI_FINISHED = 2,
	IOMMU_ENABLED = 3,
	IOMMU_PCI_INIT = 4,
	IOMMU_INTERRUPTS_EN = 5,
	IOMMU_INITIALIZED = 6,
	IOMMU_NOT_FOUND = 7,
	IOMMU_INIT_ERROR = 8,
	IOMMU_CMDLINE_DISABLED = 9,
};

enum iommu_page_response_code {
	IOMMU_PAGE_RESP_SUCCESS = 0,
	IOMMU_PAGE_RESP_INVALID = 1,
	IOMMU_PAGE_RESP_FAILURE = 2,
};

enum iommu_resv_type {
	IOMMU_RESV_DIRECT = 0,
	IOMMU_RESV_DIRECT_RELAXABLE = 1,
	IOMMU_RESV_RESERVED = 2,
	IOMMU_RESV_MSI = 3,
	IOMMU_RESV_SW_MSI = 4,
};

enum iommu_veventq_type {
	IOMMU_VEVENTQ_TYPE_DEFAULT = 0,
	IOMMU_VEVENTQ_TYPE_ARM_SMMUV3 = 1,
	IOMMU_VEVENTQ_TYPE_TEGRA241_CMDQV = 2,
};

enum iommu_viommu_type {
	IOMMU_VIOMMU_TYPE_DEFAULT = 0,
	IOMMU_VIOMMU_TYPE_ARM_SMMUV3 = 1,
	IOMMU_VIOMMU_TYPE_TEGRA241_CMDQV = 2,
};

enum iommufd_hwpt_alloc_flags {
	IOMMU_HWPT_ALLOC_NEST_PARENT = 1,
	IOMMU_HWPT_ALLOC_DIRTY_TRACKING = 2,
	IOMMU_HWPT_FAULT_ID_VALID = 4,
	IOMMU_HWPT_ALLOC_PASID = 8,
};

enum iommufd_object_type {
	IOMMUFD_OBJ_NONE = 0,
	IOMMUFD_OBJ_ANY = 0,
	IOMMUFD_OBJ_DEVICE = 1,
	IOMMUFD_OBJ_HWPT_PAGING = 2,
	IOMMUFD_OBJ_HWPT_NESTED = 3,
	IOMMUFD_OBJ_IOAS = 4,
	IOMMUFD_OBJ_ACCESS = 5,
	IOMMUFD_OBJ_FAULT = 6,
	IOMMUFD_OBJ_VIOMMU = 7,
	IOMMUFD_OBJ_VDEVICE = 8,
	IOMMUFD_OBJ_VEVENTQ = 9,
	IOMMUFD_OBJ_HW_QUEUE = 10,
	IOMMUFD_OBJ_MAX = 11,
};

enum ip6_defrag_users {
	IP6_DEFRAG_LOCAL_DELIVER = 0,
	IP6_DEFRAG_CONNTRACK_IN = 1,
	__IP6_DEFRAG_CONNTRACK_IN = 65536,
	IP6_DEFRAG_CONNTRACK_OUT = 65537,
	__IP6_DEFRAG_CONNTRACK_OUT = 131072,
	IP6_DEFRAG_CONNTRACK_BRIDGE_IN = 131073,
	__IP6_DEFRAG_CONNTRACK_BRIDGE_IN = 196608,
};

enum ip_conntrack_dir {
	IP_CT_DIR_ORIGINAL = 0,
	IP_CT_DIR_REPLY = 1,
	IP_CT_DIR_MAX = 2,
};

enum ip_conntrack_info {
	IP_CT_ESTABLISHED = 0,
	IP_CT_RELATED = 1,
	IP_CT_NEW = 2,
	IP_CT_IS_REPLY = 3,
	IP_CT_ESTABLISHED_REPLY = 3,
	IP_CT_RELATED_REPLY = 4,
	IP_CT_NUMBER = 5,
	IP_CT_UNTRACKED = 7,
};

enum ip_conntrack_status {
	IPS_EXPECTED_BIT = 0,
	IPS_EXPECTED = 1,
	IPS_SEEN_REPLY_BIT = 1,
	IPS_SEEN_REPLY = 2,
	IPS_ASSURED_BIT = 2,
	IPS_ASSURED = 4,
	IPS_CONFIRMED_BIT = 3,
	IPS_CONFIRMED = 8,
	IPS_SRC_NAT_BIT = 4,
	IPS_SRC_NAT = 16,
	IPS_DST_NAT_BIT = 5,
	IPS_DST_NAT = 32,
	IPS_NAT_MASK = 48,
	IPS_SEQ_ADJUST_BIT = 6,
	IPS_SEQ_ADJUST = 64,
	IPS_SRC_NAT_DONE_BIT = 7,
	IPS_SRC_NAT_DONE = 128,
	IPS_DST_NAT_DONE_BIT = 8,
	IPS_DST_NAT_DONE = 256,
	IPS_NAT_DONE_MASK = 384,
	IPS_DYING_BIT = 9,
	IPS_DYING = 512,
	IPS_FIXED_TIMEOUT_BIT = 10,
	IPS_FIXED_TIMEOUT = 1024,
	IPS_TEMPLATE_BIT = 11,
	IPS_TEMPLATE = 2048,
	IPS_UNTRACKED_BIT = 12,
	IPS_UNTRACKED = 4096,
	IPS_NAT_CLASH_BIT = 12,
	IPS_NAT_CLASH = 4096,
	IPS_HELPER_BIT = 13,
	IPS_HELPER = 8192,
	IPS_OFFLOAD_BIT = 14,
	IPS_OFFLOAD = 16384,
	IPS_HW_OFFLOAD_BIT = 15,
	IPS_HW_OFFLOAD = 32768,
	IPS_UNCHANGEABLE_MASK = 56313,
	__IPS_MAX_BIT = 16,
};

enum ip_defrag_users {
	IP_DEFRAG_LOCAL_DELIVER = 0,
	IP_DEFRAG_CALL_RA_CHAIN = 1,
	IP_DEFRAG_CONNTRACK_IN = 2,
	__IP_DEFRAG_CONNTRACK_IN_END = 65537,
	IP_DEFRAG_CONNTRACK_OUT = 65538,
	__IP_DEFRAG_CONNTRACK_OUT_END = 131073,
	IP_DEFRAG_CONNTRACK_BRIDGE_IN = 131074,
	__IP_DEFRAG_CONNTRACK_BRIDGE_IN = 196609,
	IP_DEFRAG_VS_IN = 196610,
	IP_DEFRAG_VS_OUT = 196611,
	IP_DEFRAG_VS_FWD = 196612,
	IP_DEFRAG_AF_PACKET = 196613,
	IP_DEFRAG_MACVLAN = 196614,
};

enum ipe_action_type {
	IPE_ACTION_ALLOW = 0,
	IPE_ACTION_DENY = 1,
	__IPE_ACTION_MAX = 2,
};

enum ipe_hook_type {
	IPE_HOOK_BPRM_CHECK = 0,
	IPE_HOOK_MMAP = 1,
	IPE_HOOK_MPROTECT = 2,
	IPE_HOOK_KERNEL_READ = 3,
	IPE_HOOK_KERNEL_LOAD = 4,
	__IPE_HOOK_MAX = 5,
};

enum ipe_match {
	IPE_MATCH_RULE = 0,
	IPE_MATCH_TABLE = 1,
	IPE_MATCH_GLOBAL = 2,
	__IPE_MATCH_MAX = 3,
};

enum ipe_op_type {
	IPE_OP_EXEC = 0,
	IPE_OP_FIRMWARE = 1,
	IPE_OP_KERNEL_MODULE = 2,
	IPE_OP_KEXEC_IMAGE = 3,
	IPE_OP_KEXEC_INITRAMFS = 4,
	IPE_OP_POLICY = 5,
	IPE_OP_X509 = 6,
	__IPE_OP_MAX = 7,
};

enum ipe_prop_type {
	IPE_PROP_BOOT_VERIFIED_FALSE = 0,
	IPE_PROP_BOOT_VERIFIED_TRUE = 1,
	IPE_PROP_DMV_ROOTHASH = 2,
	IPE_PROP_DMV_SIG_FALSE = 3,
	IPE_PROP_DMV_SIG_TRUE = 4,
	IPE_PROP_FSV_DIGEST = 5,
	IPE_PROP_FSV_SIG_FALSE = 6,
	IPE_PROP_FSV_SIG_TRUE = 7,
	__IPE_PROP_MAX = 8,
};

enum ipi_vector {
	XEN_RESCHEDULE_VECTOR = 0,
	XEN_CALL_FUNCTION_VECTOR = 1,
	XEN_CALL_FUNCTION_SINGLE_VECTOR = 2,
	XEN_SPIN_UNLOCK_VECTOR = 3,
	XEN_IRQ_WORK_VECTOR = 4,
	XEN_NMI_VECTOR = 5,
	XEN_NR_IPIS = 6,
};

enum ipmi_addr_space {
	IPMI_IO_ADDR_SPACE = 0,
	IPMI_MEM_ADDR_SPACE = 1,
};

enum ipmi_addr_src {
	SI_INVALID = 0,
	SI_HOTMOD = 1,
	SI_HARDCODED = 2,
	SI_SPMI = 3,
	SI_ACPI = 4,
	SI_SMBIOS = 5,
	SI_PCI = 6,
	SI_DEVICETREE = 7,
	SI_PLATFORM = 8,
	SI_LAST = 9,
};

enum ipmi_plat_interface_type {
	IPMI_PLAT_IF_SI = 0,
	IPMI_PLAT_IF_SSIF = 1,
};

enum irq_alloc_type {
	X86_IRQ_ALLOC_TYPE_IOAPIC = 1,
	X86_IRQ_ALLOC_TYPE_HPET = 2,
	X86_IRQ_ALLOC_TYPE_PCI_MSI = 3,
	X86_IRQ_ALLOC_TYPE_PCI_MSIX = 4,
	X86_IRQ_ALLOC_TYPE_DMAR = 5,
	X86_IRQ_ALLOC_TYPE_AMDVI = 6,
	X86_IRQ_ALLOC_TYPE_UV = 7,
};

enum irq_domain_bus_token {
	DOMAIN_BUS_ANY = 0,
	DOMAIN_BUS_WIRED = 1,
	DOMAIN_BUS_GENERIC_MSI = 2,
	DOMAIN_BUS_PCI_MSI = 3,
	DOMAIN_BUS_PLATFORM_MSI = 4,
	DOMAIN_BUS_NEXUS = 5,
	DOMAIN_BUS_IPI = 6,
	DOMAIN_BUS_FSL_MC_MSI = 7,
	DOMAIN_BUS_TI_SCI_INTA_MSI = 8,
	DOMAIN_BUS_WAKEUP = 9,
	DOMAIN_BUS_VMD_MSI = 10,
	DOMAIN_BUS_PCI_DEVICE_MSI = 11,
	DOMAIN_BUS_PCI_DEVICE_MSIX = 12,
	DOMAIN_BUS_DMAR = 13,
	DOMAIN_BUS_AMDVI = 14,
	DOMAIN_BUS_DEVICE_MSI = 15,
	DOMAIN_BUS_WIRED_TO_MSI = 16,
};

enum irq_gc_flags {
	IRQ_GC_INIT_MASK_CACHE = 1,
	IRQ_GC_INIT_NESTED_LOCK = 2,
	IRQ_GC_MASK_CACHE_PER_TYPE = 4,
	IRQ_GC_NO_MASK = 8,
	IRQ_GC_BE_IO = 16,
};

enum irq_remap_cap {
	IRQ_POSTING_CAP = 0,
};

enum irqchip_irq_state {
	IRQCHIP_STATE_PENDING = 0,
	IRQCHIP_STATE_ACTIVE = 1,
	IRQCHIP_STATE_MASKED = 2,
	IRQCHIP_STATE_LINE_LEVEL = 3,
};

enum irqreturn {
	IRQ_NONE = 0,
	IRQ_HANDLED = 1,
	IRQ_WAKE_THREAD = 2,
};

typedef enum irqreturn irqreturn_t;

enum iter_type {
	ITER_UBUF = 0,
	ITER_IOVEC = 1,
	ITER_BVEC = 2,
	ITER_KVEC = 3,
	ITER_FOLIOQ = 4,
	ITER_XARRAY = 5,
	ITER_DISCARD = 6,
};

enum its_mitigation {
	ITS_MITIGATION_OFF = 0,
	ITS_MITIGATION_AUTO = 1,
	ITS_MITIGATION_VMEXIT_ONLY = 2,
	ITS_MITIGATION_ALIGNED_THUNKS = 3,
	ITS_MITIGATION_RETPOLINE_STUFF = 4,
};

enum jump_label_type {
	JUMP_LABEL_NOP = 0,
	JUMP_LABEL_JMP = 1,
};

enum kcmp_type {
	KCMP_FILE = 0,
	KCMP_VM = 1,
	KCMP_FILES = 2,
	KCMP_FS = 3,
	KCMP_SIGHAND = 4,
	KCMP_IO = 5,
	KCMP_SYSVSEM = 6,
	KCMP_EPOLL_TFD = 7,
	KCMP_TYPES = 8,
};

enum kcore_type {
	KCORE_TEXT = 0,
	KCORE_VMALLOC = 1,
	KCORE_RAM = 2,
	KCORE_VMEMMAP = 3,
	KCORE_USER = 4,
};

enum kernel_gp_hint {
	GP_NO_HINT = 0,
	GP_NON_CANONICAL = 1,
	GP_CANONICAL = 2,
};

enum kernel_load_data_id {
	LOADING_UNKNOWN = 0,
	LOADING_FIRMWARE = 1,
	LOADING_MODULE = 2,
	LOADING_KEXEC_IMAGE = 3,
	LOADING_KEXEC_INITRAMFS = 4,
	LOADING_POLICY = 5,
	LOADING_X509_CERTIFICATE = 6,
	LOADING_MAX_ID = 7,
};

enum kernel_pkey_operation {
	kernel_pkey_encrypt = 0,
	kernel_pkey_decrypt = 1,
	kernel_pkey_sign = 2,
	kernel_pkey_verify = 3,
};

enum kernel_read_file_id {
	READING_UNKNOWN = 0,
	READING_FIRMWARE = 1,
	READING_MODULE = 2,
	READING_KEXEC_IMAGE = 3,
	READING_KEXEC_INITRAMFS = 4,
	READING_POLICY = 5,
	READING_X509_CERTIFICATE = 6,
	READING_MAX_ID = 7,
};

enum kernfs_node_flag {
	KERNFS_ACTIVATED = 16,
	KERNFS_NS = 32,
	KERNFS_HAS_SEQ_SHOW = 64,
	KERNFS_HAS_MMAP = 128,
	KERNFS_LOCKDEP = 256,
	KERNFS_HIDDEN = 512,
	KERNFS_SUICIDAL = 1024,
	KERNFS_SUICIDED = 2048,
	KERNFS_EMPTY_DIR = 4096,
	KERNFS_HAS_RELEASE = 8192,
	KERNFS_REMOVING = 16384,
};

enum kernfs_node_type {
	KERNFS_DIR = 1,
	KERNFS_FILE = 2,
	KERNFS_LINK = 4,
};

enum kernfs_root_flag {
	KERNFS_ROOT_CREATE_DEACTIVATED = 1,
	KERNFS_ROOT_EXTRA_OPEN_PERM_CHECK = 2,
	KERNFS_ROOT_SUPPORT_EXPORTOP = 4,
	KERNFS_ROOT_SUPPORT_USER_XATTR = 8,
	KERNFS_ROOT_INVARIANT_PARENT = 16,
};

enum key_being_used_for {
	VERIFYING_MODULE_SIGNATURE = 0,
	VERIFYING_FIRMWARE_SIGNATURE = 1,
	VERIFYING_KEXEC_PE_SIGNATURE = 2,
	VERIFYING_KEY_SIGNATURE = 3,
	VERIFYING_KEY_SELF_SIGNATURE = 4,
	VERIFYING_UNSPECIFIED_SIGNATURE = 5,
	NR__KEY_BEING_USED_FOR = 6,
};

enum key_lookup_flag {
	KEY_LOOKUP_CREATE = 1,
	KEY_LOOKUP_PARTIAL = 2,
	KEY_LOOKUP_ALL = 3,
};

enum key_need_perm {
	KEY_NEED_UNSPECIFIED = 0,
	KEY_NEED_VIEW = 1,
	KEY_NEED_READ = 2,
	KEY_NEED_WRITE = 3,
	KEY_NEED_SEARCH = 4,
	KEY_NEED_LINK = 5,
	KEY_NEED_SETATTR = 6,
	KEY_NEED_UNLINK = 7,
	KEY_SYSADMIN_OVERRIDE = 8,
	KEY_AUTHTOKEN_OVERRIDE = 9,
	KEY_DEFER_PERM_CHECK = 10,
};

enum key_notification_subtype {
	NOTIFY_KEY_INSTANTIATED = 0,
	NOTIFY_KEY_UPDATED = 1,
	NOTIFY_KEY_LINKED = 2,
	NOTIFY_KEY_UNLINKED = 3,
	NOTIFY_KEY_CLEARED = 4,
	NOTIFY_KEY_REVOKED = 5,
	NOTIFY_KEY_INVALIDATED = 6,
	NOTIFY_KEY_SETATTR = 7,
};

enum key_state {
	KEY_IS_UNINSTANTIATED = 0,
	KEY_IS_POSITIVE = 1,
};

enum kfence_counter_id {
	KFENCE_COUNTER_ALLOCATED = 0,
	KFENCE_COUNTER_ALLOCS = 1,
	KFENCE_COUNTER_FREES = 2,
	KFENCE_COUNTER_ZOMBIES = 3,
	KFENCE_COUNTER_BUGS = 4,
	KFENCE_COUNTER_SKIP_INCOMPAT = 5,
	KFENCE_COUNTER_SKIP_CAPACITY = 6,
	KFENCE_COUNTER_SKIP_COVERED = 7,
	KFENCE_COUNTER_COUNT = 8,
};

enum kfence_error_type {
	KFENCE_ERROR_OOB = 0,
	KFENCE_ERROR_UAF = 1,
	KFENCE_ERROR_CORRUPTION = 2,
	KFENCE_ERROR_INVALID = 3,
	KFENCE_ERROR_INVALID_FREE = 4,
};

enum kfence_object_state {
	KFENCE_OBJECT_UNUSED = 0,
	KFENCE_OBJECT_ALLOCATED = 1,
	KFENCE_OBJECT_RCU_FREEING = 2,
	KFENCE_OBJECT_FREED = 3,
};

enum kfunc_ptr_arg_type {
	KF_ARG_PTR_TO_CTX = 0,
	KF_ARG_PTR_TO_ALLOC_BTF_ID = 1,
	KF_ARG_PTR_TO_REFCOUNTED_KPTR = 2,
	KF_ARG_PTR_TO_DYNPTR = 3,
	KF_ARG_PTR_TO_ITER = 4,
	KF_ARG_PTR_TO_LIST_HEAD = 5,
	KF_ARG_PTR_TO_LIST_NODE = 6,
	KF_ARG_PTR_TO_BTF_ID = 7,
	KF_ARG_PTR_TO_MEM = 8,
	KF_ARG_PTR_TO_MEM_SIZE = 9,
	KF_ARG_PTR_TO_CALLBACK = 10,
	KF_ARG_PTR_TO_RB_ROOT = 11,
	KF_ARG_PTR_TO_RB_NODE = 12,
	KF_ARG_PTR_TO_NULL = 13,
	KF_ARG_PTR_TO_CONST_STR = 14,
	KF_ARG_PTR_TO_MAP = 15,
	KF_ARG_PTR_TO_WORKQUEUE = 16,
	KF_ARG_PTR_TO_IRQ_FLAG = 17,
	KF_ARG_PTR_TO_RES_SPIN_LOCK = 18,
};

enum kho_event {
	KEXEC_KHO_FINALIZE = 0,
	KEXEC_KHO_ABORT = 1,
};

enum kmalloc_cache_type {
	KMALLOC_NORMAL = 0,
	KMALLOC_RANDOM_START = 0,
	KMALLOC_RANDOM_END = 0,
	KMALLOC_RECLAIM = 1,
	KMALLOC_DMA = 2,
	KMALLOC_CGROUP = 3,
	NR_KMALLOC_TYPES = 4,
};

enum kmsg_dump_reason {
	KMSG_DUMP_UNDEF = 0,
	KMSG_DUMP_PANIC = 1,
	KMSG_DUMP_OOPS = 2,
	KMSG_DUMP_EMERG = 3,
	KMSG_DUMP_SHUTDOWN = 4,
	KMSG_DUMP_MAX = 5,
};

enum kobj_ns_type {
	KOBJ_NS_TYPE_NONE = 0,
	KOBJ_NS_TYPE_NET = 1,
	KOBJ_NS_TYPES = 2,
};

enum kobject_action {
	KOBJ_ADD = 0,
	KOBJ_REMOVE = 1,
	KOBJ_CHANGE = 2,
	KOBJ_MOVE = 3,
	KOBJ_ONLINE = 4,
	KOBJ_OFFLINE = 5,
	KOBJ_BIND = 6,
	KOBJ_UNBIND = 7,
};

enum kpage_operation {
	KPAGE_FLAGS = 0,
	KPAGE_COUNT = 1,
	KPAGE_CGROUP = 2,
};

enum kprobe_slot_state {
	SLOT_CLEAN = 0,
	SLOT_DIRTY = 1,
	SLOT_USED = 2,
};

enum ksm_advisor_type {
	KSM_ADVISOR_NONE = 0,
	KSM_ADVISOR_SCAN_TIME = 1,
};

enum ksm_get_folio_flags {
	KSM_GET_FOLIO_NOLOCK = 0,
	KSM_GET_FOLIO_LOCK = 1,
	KSM_GET_FOLIO_TRYLOCK = 2,
};

enum kvm_apic_logical_mode {
	KVM_APIC_MODE_SW_DISABLED = 0,
	KVM_APIC_MODE_XAPIC_CLUSTER = 1,
	KVM_APIC_MODE_XAPIC_FLAT = 2,
	KVM_APIC_MODE_X2APIC = 3,
	KVM_APIC_MODE_MAP_DISABLED = 4,
};

enum kvm_bus {
	KVM_MMIO_BUS = 0,
	KVM_PIO_BUS = 1,
	KVM_VIRTIO_CCW_NOTIFY_BUS = 2,
	KVM_FAST_MMIO_BUS = 3,
	KVM_IOCSR_BUS = 4,
	KVM_NR_BUSES = 5,
};

enum kvm_irqchip_mode {
	KVM_IRQCHIP_NONE = 0,
	KVM_IRQCHIP_KERNEL = 1,
	KVM_IRQCHIP_SPLIT = 2,
};

enum kvm_only_cpuid_leafs {
	CPUID_12_EAX = 22,
	CPUID_7_1_EDX = 23,
	CPUID_8000_0007_EDX = 24,
	CPUID_8000_0022_EAX = 25,
	CPUID_7_2_EDX = 26,
	CPUID_24_0_EBX = 27,
	CPUID_8000_0021_ECX = 28,
	NR_KVM_CPU_CAPS = 29,
	NKVMCAPINTS = 7,
};

enum kvm_reg {
	VCPU_REGS_RAX = 0,
	VCPU_REGS_RCX = 1,
	VCPU_REGS_RDX = 2,
	VCPU_REGS_RBX = 3,
	VCPU_REGS_RSP = 4,
	VCPU_REGS_RBP = 5,
	VCPU_REGS_RSI = 6,
	VCPU_REGS_RDI = 7,
	VCPU_REGS_R8 = 8,
	VCPU_REGS_R9 = 9,
	VCPU_REGS_R10 = 10,
	VCPU_REGS_R11 = 11,
	VCPU_REGS_R12 = 12,
	VCPU_REGS_R13 = 13,
	VCPU_REGS_R14 = 14,
	VCPU_REGS_R15 = 15,
	VCPU_REGS_RIP = 16,
	NR_VCPU_REGS = 17,
	VCPU_EXREG_PDPTR = 17,
	VCPU_EXREG_CR0 = 18,
	VCPU_EXREG_CR3 = 19,
	VCPU_EXREG_CR4 = 20,
	VCPU_EXREG_RFLAGS = 21,
	VCPU_EXREG_SEGMENTS = 22,
	VCPU_EXREG_EXIT_INFO_1 = 23,
	VCPU_EXREG_EXIT_INFO_2 = 24,
};

enum kvm_stat_kind {
	KVM_STAT_VM = 0,
	KVM_STAT_VCPU = 1,
};

enum l1d_flush_mitigations {
	L1D_FLUSH_OFF = 0,
	L1D_FLUSH_ON = 1,
};

enum l1tf_mitigations {
	L1TF_MITIGATION_OFF = 0,
	L1TF_MITIGATION_AUTO = 1,
	L1TF_MITIGATION_FLUSH_NOWARN = 2,
	L1TF_MITIGATION_FLUSH = 3,
	L1TF_MITIGATION_FLUSH_NOSMT = 4,
	L1TF_MITIGATION_FULL = 5,
	L1TF_MITIGATION_FULL_FORCE = 6,
};

enum l2tp_debug_flags {
	L2TP_MSG_DEBUG = 1,
	L2TP_MSG_CONTROL = 2,
	L2TP_MSG_SEQ = 4,
	L2TP_MSG_DATA = 8,
};

enum l3mdev_type {
	L3MDEV_TYPE_UNSPEC = 0,
	L3MDEV_TYPE_VRF = 1,
	__L3MDEV_TYPE_MAX = 2,
};

enum label_flags {
	FLAG_HAT = 1,
	FLAG_UNCONFINED = 2,
	FLAG_NULL = 4,
	FLAG_IX_ON_NAME_ERROR = 8,
	FLAG_IMMUTIBLE = 16,
	FLAG_USER_DEFINED = 32,
	FLAG_NO_LIST_REF = 64,
	FLAG_NS_COUNT = 128,
	FLAG_IN_TREE = 256,
	FLAG_PROFILE = 512,
	FLAG_EXPLICIT = 1024,
	FLAG_STALE = 2048,
	FLAG_RENAMED = 4096,
	FLAG_REVOKED = 8192,
	FLAG_DEBUG1 = 16384,
	FLAG_DEBUG2 = 32768,
};

enum label_initialized {
	LABEL_INVALID = 0,
	LABEL_INITIALIZED = 1,
	LABEL_PENDING = 2,
};

enum landlock_key_type {
	LANDLOCK_KEY_INODE = 1,
	LANDLOCK_KEY_NET_PORT = 2,
};

enum landlock_log_status {
	LANDLOCK_LOG_PENDING = 0,
	LANDLOCK_LOG_RECORDED = 1,
	LANDLOCK_LOG_DISABLED = 2,
};

enum landlock_request_type {
	LANDLOCK_REQUEST_PTRACE = 1,
	LANDLOCK_REQUEST_FS_CHANGE_TOPOLOGY = 2,
	LANDLOCK_REQUEST_FS_ACCESS = 3,
	LANDLOCK_REQUEST_NET_ACCESS = 4,
	LANDLOCK_REQUEST_SCOPE_ABSTRACT_UNIX_SOCKET = 5,
	LANDLOCK_REQUEST_SCOPE_SIGNAL = 6,
};

enum landlock_rule_type {
	LANDLOCK_RULE_PATH_BENEATH = 1,
	LANDLOCK_RULE_NET_PORT = 2,
};

enum latency_count {
	COUNTS_10e2 = 0,
	COUNTS_10e3 = 1,
	COUNTS_10e4 = 2,
	COUNTS_10e5 = 3,
	COUNTS_10e6 = 4,
	COUNTS_10e7 = 5,
	COUNTS_10e8_plus = 6,
	COUNTS_MIN = 7,
	COUNTS_MAX = 8,
	COUNTS_SUM = 9,
	COUNTS_NUM = 10,
};

enum latency_type {
	DMAR_LATENCY_INV_IOTLB = 0,
	DMAR_LATENCY_INV_DEVTLB = 1,
	DMAR_LATENCY_INV_IEC = 2,
	DMAR_LATENCY_NUM = 3,
};

enum ldma_chan_on_off {
	DMA_CH_OFF = 0,
	DMA_CH_ON = 1,
};

enum led_brightness {
	LED_OFF = 0,
	LED_ON = 1,
	LED_HALF = 127,
	LED_FULL = 255,
};

enum led_default_state {
	LEDS_DEFSTATE_OFF = 0,
	LEDS_DEFSTATE_ON = 1,
	LEDS_DEFSTATE_KEEP = 2,
};

enum legacy_fs_param {
	LEGACY_FS_UNSET_PARAMS = 0,
	LEGACY_FS_MONOLITHIC_PARAMS = 1,
	LEGACY_FS_INDIVIDUAL_PARAMS = 2,
};

enum linux_mptcp_mib_field {
	MPTCP_MIB_NUM = 0,
	MPTCP_MIB_MPCAPABLEPASSIVE = 1,
	MPTCP_MIB_MPCAPABLEACTIVE = 2,
	MPTCP_MIB_MPCAPABLEACTIVEACK = 3,
	MPTCP_MIB_MPCAPABLEPASSIVEACK = 4,
	MPTCP_MIB_MPCAPABLEPASSIVEFALLBACK = 5,
	MPTCP_MIB_MPCAPABLEACTIVEFALLBACK = 6,
	MPTCP_MIB_MPCAPABLEACTIVEDROP = 7,
	MPTCP_MIB_MPCAPABLEACTIVEDISABLED = 8,
	MPTCP_MIB_MPCAPABLEENDPATTEMPT = 9,
	MPTCP_MIB_TOKENFALLBACKINIT = 10,
	MPTCP_MIB_RETRANSSEGS = 11,
	MPTCP_MIB_JOINNOTOKEN = 12,
	MPTCP_MIB_JOINSYNRX = 13,
	MPTCP_MIB_JOINSYNBACKUPRX = 14,
	MPTCP_MIB_JOINSYNACKRX = 15,
	MPTCP_MIB_JOINSYNACKBACKUPRX = 16,
	MPTCP_MIB_JOINSYNACKMAC = 17,
	MPTCP_MIB_JOINACKRX = 18,
	MPTCP_MIB_JOINACKMAC = 19,
	MPTCP_MIB_JOINREJECTED = 20,
	MPTCP_MIB_JOINSYNTX = 21,
	MPTCP_MIB_JOINSYNTXCREATSKERR = 22,
	MPTCP_MIB_JOINSYNTXBINDERR = 23,
	MPTCP_MIB_JOINSYNTXCONNECTERR = 24,
	MPTCP_MIB_DSSNOMATCH = 25,
	MPTCP_MIB_DSSCORRUPTIONFALLBACK = 26,
	MPTCP_MIB_DSSCORRUPTIONRESET = 27,
	MPTCP_MIB_INFINITEMAPTX = 28,
	MPTCP_MIB_INFINITEMAPRX = 29,
	MPTCP_MIB_DSSTCPMISMATCH = 30,
	MPTCP_MIB_DATACSUMERR = 31,
	MPTCP_MIB_OFOQUEUETAIL = 32,
	MPTCP_MIB_OFOQUEUE = 33,
	MPTCP_MIB_OFOMERGE = 34,
	MPTCP_MIB_NODSSWINDOW = 35,
	MPTCP_MIB_DUPDATA = 36,
	MPTCP_MIB_ADDADDR = 37,
	MPTCP_MIB_ADDADDRTX = 38,
	MPTCP_MIB_ADDADDRTXDROP = 39,
	MPTCP_MIB_ECHOADD = 40,
	MPTCP_MIB_ECHOADDTX = 41,
	MPTCP_MIB_ECHOADDTXDROP = 42,
	MPTCP_MIB_PORTADD = 43,
	MPTCP_MIB_ADDADDRDROP = 44,
	MPTCP_MIB_JOINPORTSYNRX = 45,
	MPTCP_MIB_JOINPORTSYNACKRX = 46,
	MPTCP_MIB_JOINPORTACKRX = 47,
	MPTCP_MIB_MISMATCHPORTSYNRX = 48,
	MPTCP_MIB_MISMATCHPORTACKRX = 49,
	MPTCP_MIB_RMADDR = 50,
	MPTCP_MIB_RMADDRDROP = 51,
	MPTCP_MIB_RMADDRTX = 52,
	MPTCP_MIB_RMADDRTXDROP = 53,
	MPTCP_MIB_RMSUBFLOW = 54,
	MPTCP_MIB_MPPRIOTX = 55,
	MPTCP_MIB_MPPRIORX = 56,
	MPTCP_MIB_MPFAILTX = 57,
	MPTCP_MIB_MPFAILRX = 58,
	MPTCP_MIB_MPFASTCLOSETX = 59,
	MPTCP_MIB_MPFASTCLOSERX = 60,
	MPTCP_MIB_MPRSTTX = 61,
	MPTCP_MIB_MPRSTRX = 62,
	MPTCP_MIB_RCVPRUNED = 63,
	MPTCP_MIB_SUBFLOWSTALE = 64,
	MPTCP_MIB_SUBFLOWRECOVER = 65,
	MPTCP_MIB_SNDWNDSHARED = 66,
	MPTCP_MIB_RCVWNDSHARED = 67,
	MPTCP_MIB_RCVWNDCONFLICTUPDATE = 68,
	MPTCP_MIB_RCVWNDCONFLICT = 69,
	MPTCP_MIB_CURRESTAB = 70,
	MPTCP_MIB_BLACKHOLE = 71,
	MPTCP_MIB_MPCAPABLEDATAFALLBACK = 72,
	MPTCP_MIB_MD5SIGFALLBACK = 73,
	MPTCP_MIB_DSSFALLBACK = 74,
	MPTCP_MIB_SIMULTCONNFALLBACK = 75,
	MPTCP_MIB_FALLBACKFAILED = 76,
	__MPTCP_MIB_MAX = 77,
};

enum ll_ids {
	LL_RESV = 0,
	LL_L1 = 1,
	LL_L2 = 2,
	LL_LG = 3,
};

enum locality_types {
	WRITE_LATENCY = 0,
	READ_LATENCY = 1,
	WRITE_BANDWIDTH = 2,
	READ_BANDWIDTH = 3,
};

enum lock_events {
	LOCKEVENT_pv_hash_hops = 0,
	LOCKEVENT_pv_kick_unlock = 1,
	LOCKEVENT_pv_kick_wake = 2,
	LOCKEVENT_pv_latency_kick = 3,
	LOCKEVENT_pv_latency_wake = 4,
	LOCKEVENT_pv_lock_stealing = 5,
	LOCKEVENT_pv_spurious_wakeup = 6,
	LOCKEVENT_pv_wait_again = 7,
	LOCKEVENT_pv_wait_early = 8,
	LOCKEVENT_pv_wait_head = 9,
	LOCKEVENT_pv_wait_node = 10,
	LOCKEVENT_lock_pending = 11,
	LOCKEVENT_lock_slowpath = 12,
	LOCKEVENT_lock_use_node2 = 13,
	LOCKEVENT_lock_use_node3 = 14,
	LOCKEVENT_lock_use_node4 = 15,
	LOCKEVENT_lock_no_node = 16,
	LOCKEVENT_rqspinlock_lock_timeout = 17,
	LOCKEVENT_rwsem_sleep_reader = 18,
	LOCKEVENT_rwsem_sleep_writer = 19,
	LOCKEVENT_rwsem_wake_reader = 20,
	LOCKEVENT_rwsem_wake_writer = 21,
	LOCKEVENT_rwsem_opt_lock = 22,
	LOCKEVENT_rwsem_opt_fail = 23,
	LOCKEVENT_rwsem_opt_nospin = 24,
	LOCKEVENT_rwsem_rlock = 25,
	LOCKEVENT_rwsem_rlock_steal = 26,
	LOCKEVENT_rwsem_rlock_fast = 27,
	LOCKEVENT_rwsem_rlock_fail = 28,
	LOCKEVENT_rwsem_rlock_handoff = 29,
	LOCKEVENT_rwsem_wlock = 30,
	LOCKEVENT_rwsem_wlock_fail = 31,
	LOCKEVENT_rwsem_wlock_handoff = 32,
	LOCKEVENT_rtlock_slowlock = 33,
	LOCKEVENT_rtlock_slow_acq1 = 34,
	LOCKEVENT_rtlock_slow_acq2 = 35,
	LOCKEVENT_rtlock_slow_sleep = 36,
	LOCKEVENT_rtlock_slow_wake = 37,
	LOCKEVENT_rtmutex_slowlock = 38,
	LOCKEVENT_rtmutex_slow_block = 39,
	LOCKEVENT_rtmutex_slow_acq1 = 40,
	LOCKEVENT_rtmutex_slow_acq2 = 41,
	LOCKEVENT_rtmutex_slow_acq3 = 42,
	LOCKEVENT_rtmutex_slow_sleep = 43,
	LOCKEVENT_rtmutex_slow_wake = 44,
	LOCKEVENT_rtmutex_deadlock = 45,
	LOCKEVENT_lockdep_acquire = 46,
	LOCKEVENT_lockdep_lock = 47,
	LOCKEVENT_lockdep_nocheck = 48,
	lockevent_num = 49,
	LOCKEVENT_reset_cnts = 49,
};

enum lockdep_ok {
	LOCKDEP_STILL_OK = 0,
	LOCKDEP_NOW_UNRELIABLE = 1,
};

enum lockdown_reason {
	LOCKDOWN_NONE = 0,
	LOCKDOWN_MODULE_SIGNATURE = 1,
	LOCKDOWN_DEV_MEM = 2,
	LOCKDOWN_EFI_TEST = 3,
	LOCKDOWN_KEXEC = 4,
	LOCKDOWN_HIBERNATION = 5,
	LOCKDOWN_PCI_ACCESS = 6,
	LOCKDOWN_IOPORT = 7,
	LOCKDOWN_MSR = 8,
	LOCKDOWN_ACPI_TABLES = 9,
	LOCKDOWN_DEVICE_TREE = 10,
	LOCKDOWN_PCMCIA_CIS = 11,
	LOCKDOWN_TIOCSSERIAL = 12,
	LOCKDOWN_MODULE_PARAMETERS = 13,
	LOCKDOWN_MMIOTRACE = 14,
	LOCKDOWN_DEBUGFS = 15,
	LOCKDOWN_XMON_WR = 16,
	LOCKDOWN_BPF_WRITE_USER = 17,
	LOCKDOWN_DBG_WRITE_KERNEL = 18,
	LOCKDOWN_RTAS_ERROR_INJECTION = 19,
	LOCKDOWN_INTEGRITY_MAX = 20,
	LOCKDOWN_KCORE = 21,
	LOCKDOWN_KPROBES = 22,
	LOCKDOWN_BPF_READ_KERNEL = 23,
	LOCKDOWN_DBG_READ_KERNEL = 24,
	LOCKDOWN_PERF = 25,
	LOCKDOWN_TRACEFS = 26,
	LOCKDOWN_XMON_RW = 27,
	LOCKDOWN_XFRM_SECRET = 28,
	LOCKDOWN_CONFIDENTIALITY_MAX = 29,
};

enum lp8788_alarm_sel {
	LP8788_ALARM_1 = 0,
	LP8788_ALARM_2 = 1,
	LP8788_ALARM_MAX = 2,
};

enum lp8788_charger_event {
	NO_CHARGER = 0,
	CHARGER_DETECTED = 1,
};

enum lp8788_dvs_sel {
	DVS_SEL_V0 = 0,
	DVS_SEL_V1 = 1,
	DVS_SEL_V2 = 2,
	DVS_SEL_V3 = 3,
};

enum lp8788_int_id {
	LP8788_INT_TSDL = 0,
	LP8788_INT_TSDH = 1,
	LP8788_INT_UVLO = 2,
	LP8788_INT_FLAGMON = 3,
	LP8788_INT_PWRON_TIME = 4,
	LP8788_INT_PWRON = 5,
	LP8788_INT_COMP1 = 6,
	LP8788_INT_COMP2 = 7,
	LP8788_INT_CHG_INPUT_STATE = 8,
	LP8788_INT_CHG_STATE = 9,
	LP8788_INT_EOC = 10,
	LP8788_INT_CHG_RESTART = 11,
	LP8788_INT_RESTART_TIMEOUT = 12,
	LP8788_INT_FULLCHG_TIMEOUT = 13,
	LP8788_INT_PRECHG_TIMEOUT = 14,
	LP8788_INT_RTC_ALARM1 = 17,
	LP8788_INT_RTC_ALARM2 = 18,
	LP8788_INT_ENTER_SYS_SUPPORT = 19,
	LP8788_INT_EXIT_SYS_SUPPORT = 20,
	LP8788_INT_BATT_LOW = 21,
	LP8788_INT_NO_BATT = 22,
	LP8788_INT_MAX = 24,
};

enum lp8788_isink_number {
	LP8788_ISINK_1 = 0,
	LP8788_ISINK_2 = 1,
	LP8788_ISINK_3 = 2,
};

enum lp8788_isink_scale {
	LP8788_ISINK_SCALE_100mA = 0,
	LP8788_ISINK_SCALE_120mA = 1,
};

enum lru_list {
	LRU_INACTIVE_ANON = 0,
	LRU_ACTIVE_ANON = 1,
	LRU_INACTIVE_FILE = 2,
	LRU_ACTIVE_FILE = 3,
	LRU_UNEVICTABLE = 4,
	NR_LRU_LISTS = 5,
};

enum lru_status {
	LRU_REMOVED = 0,
	LRU_REMOVED_RETRY = 1,
	LRU_ROTATE = 2,
	LRU_SKIP = 3,
	LRU_RETRY = 4,
	LRU_STOP = 5,
};

enum lruvec_flags {
	LRUVEC_CGROUP_CONGESTED = 0,
	LRUVEC_NODE_CONGESTED = 1,
};

enum lsm_event {
	LSM_POLICY_CHANGE = 0,
};

enum lsm_integrity_type {
	LSM_INT_DMVERITY_SIG_VALID = 0,
	LSM_INT_DMVERITY_ROOTHASH = 1,
	LSM_INT_FSVERITY_BUILTINSIG_VALID = 2,
};

enum lsm_order {
	LSM_ORDER_FIRST = -1,
	LSM_ORDER_MUTABLE = 0,
	LSM_ORDER_LAST = 1,
};

enum lw_bits {
	LW_URGENT = 0,
};

enum lwtunnel_encap_types {
	LWTUNNEL_ENCAP_NONE = 0,
	LWTUNNEL_ENCAP_MPLS = 1,
	LWTUNNEL_ENCAP_IP = 2,
	LWTUNNEL_ENCAP_ILA = 3,
	LWTUNNEL_ENCAP_IP6 = 4,
	LWTUNNEL_ENCAP_SEG6 = 5,
	LWTUNNEL_ENCAP_BPF = 6,
	LWTUNNEL_ENCAP_SEG6_LOCAL = 7,
	LWTUNNEL_ENCAP_RPL = 8,
	LWTUNNEL_ENCAP_IOAM6 = 9,
	LWTUNNEL_ENCAP_XFRM = 10,
	__LWTUNNEL_ENCAP_MAX = 11,
};

enum lwtunnel_ip6_t {
	LWTUNNEL_IP6_UNSPEC = 0,
	LWTUNNEL_IP6_ID = 1,
	LWTUNNEL_IP6_DST = 2,
	LWTUNNEL_IP6_SRC = 3,
	LWTUNNEL_IP6_HOPLIMIT = 4,
	LWTUNNEL_IP6_TC = 5,
	LWTUNNEL_IP6_FLAGS = 6,
	LWTUNNEL_IP6_PAD = 7,
	LWTUNNEL_IP6_OPTS = 8,
	__LWTUNNEL_IP6_MAX = 9,
};

enum lwtunnel_ip_t {
	LWTUNNEL_IP_UNSPEC = 0,
	LWTUNNEL_IP_ID = 1,
	LWTUNNEL_IP_DST = 2,
	LWTUNNEL_IP_SRC = 3,
	LWTUNNEL_IP_TTL = 4,
	LWTUNNEL_IP_TOS = 5,
	LWTUNNEL_IP_FLAGS = 6,
	LWTUNNEL_IP_PAD = 7,
	LWTUNNEL_IP_OPTS = 8,
	__LWTUNNEL_IP_MAX = 9,
};

enum lzma2_seq {
	SEQ_CONTROL = 0,
	SEQ_UNCOMPRESSED_1 = 1,
	SEQ_UNCOMPRESSED_2 = 2,
	SEQ_COMPRESSED_0 = 3,
	SEQ_COMPRESSED_1 = 4,
	SEQ_PROPERTIES = 5,
	SEQ_LZMA_PREPARE = 6,
	SEQ_LZMA_RUN = 7,
	SEQ_COPY = 8,
};

enum lzma_state {
	STATE_LIT_LIT = 0,
	STATE_MATCH_LIT_LIT = 1,
	STATE_REP_LIT_LIT = 2,
	STATE_SHORTREP_LIT_LIT = 3,
	STATE_MATCH_LIT = 4,
	STATE_REP_LIT = 5,
	STATE_SHORTREP_LIT = 6,
	STATE_LIT_MATCH = 7,
	STATE_LIT_LONGREP = 8,
	STATE_LIT_SHORTREP = 9,
	STATE_NONLIT_MATCH = 10,
	STATE_NONLIT_REP = 11,
};

enum macsec_offload {
	MACSEC_OFFLOAD_OFF = 0,
	MACSEC_OFFLOAD_PHY = 1,
	MACSEC_OFFLOAD_MAC = 2,
	__MACSEC_OFFLOAD_END = 3,
	MACSEC_OFFLOAD_MAX = 2,
};

enum macsec_validation_type {
	MACSEC_VALIDATE_DISABLED = 0,
	MACSEC_VALIDATE_CHECK = 1,
	MACSEC_VALIDATE_STRICT = 2,
	__MACSEC_VALIDATE_END = 3,
	MACSEC_VALIDATE_MAX = 2,
};

enum madvise_lock_mode {
	MADVISE_NO_LOCK = 0,
	MADVISE_MMAP_READ_LOCK = 1,
	MADVISE_MMAP_WRITE_LOCK = 2,
	MADVISE_VMA_READ_LOCK = 3,
};

enum maple_status {
	ma_active = 0,
	ma_start = 1,
	ma_root = 2,
	ma_none = 3,
	ma_pause = 4,
	ma_overflow = 5,
	ma_underflow = 6,
	ma_error = 7,
};

enum maple_type {
	maple_dense = 0,
	maple_leaf_64 = 1,
	maple_range_64 = 2,
	maple_arange_64 = 3,
};

enum mapping_flags {
	AS_EIO = 0,
	AS_ENOSPC = 1,
	AS_MM_ALL_LOCKS = 2,
	AS_UNEVICTABLE = 3,
	AS_EXITING = 4,
	AS_NO_WRITEBACK_TAGS = 5,
	AS_RELEASE_ALWAYS = 6,
	AS_STABLE_WRITES = 7,
	AS_INACCESSIBLE = 8,
	AS_WRITEBACK_MAY_DEADLOCK_ON_RECLAIM = 9,
	AS_FOLIO_ORDER_BITS = 5,
	AS_FOLIO_ORDER_MIN = 16,
	AS_FOLIO_ORDER_MAX = 21,
};

enum mapping_status {
	MAPPING_OK = 0,
	MAPPING_INVALID = 1,
	MAPPING_EMPTY = 2,
	MAPPING_DATA_FIN = 3,
	MAPPING_DUMMY = 4,
	MAPPING_BAD_CSUM = 5,
	MAPPING_NODSS = 6,
};

enum max77693_types {
	TYPE_MAX77693_UNKNOWN = 0,
	TYPE_MAX77693 = 1,
	TYPE_MAX77705 = 2,
	TYPE_MAX77843 = 3,
	TYPE_MAX77693_NUM = 4,
};

enum max77843_charger_reg {
	MAX77843_CHG_REG_CHG_INT = 176,
	MAX77843_CHG_REG_CHG_INT_MASK = 177,
	MAX77843_CHG_REG_CHG_INT_OK = 178,
	MAX77843_CHG_REG_CHG_DTLS_00 = 179,
	MAX77843_CHG_REG_CHG_DTLS_01 = 180,
	MAX77843_CHG_REG_CHG_DTLS_02 = 181,
	MAX77843_CHG_REG_CHG_CNFG_00 = 183,
	MAX77843_CHG_REG_CHG_CNFG_01 = 184,
	MAX77843_CHG_REG_CHG_CNFG_02 = 185,
	MAX77843_CHG_REG_CHG_CNFG_03 = 186,
	MAX77843_CHG_REG_CHG_CNFG_04 = 187,
	MAX77843_CHG_REG_CHG_CNFG_06 = 189,
	MAX77843_CHG_REG_CHG_CNFG_07 = 190,
	MAX77843_CHG_REG_CHG_CNFG_09 = 192,
	MAX77843_CHG_REG_CHG_CNFG_10 = 193,
	MAX77843_CHG_REG_CHG_CNFG_11 = 194,
	MAX77843_CHG_REG_CHG_CNFG_12 = 195,
	MAX77843_CHG_REG_END = 196,
};

enum max77843_sys_reg {
	MAX77843_SYS_REG_PMICID = 0,
	MAX77843_SYS_REG_PMICREV = 1,
	MAX77843_SYS_REG_MAINCTRL1 = 2,
	MAX77843_SYS_REG_INTSRC = 34,
	MAX77843_SYS_REG_INTSRCMASK = 35,
	MAX77843_SYS_REG_SYSINTSRC = 36,
	MAX77843_SYS_REG_SYSINTMASK = 38,
	MAX77843_SYS_REG_TOPSYS_STAT = 40,
	MAX77843_SYS_REG_SAFEOUTCTRL = 198,
	MAX77843_SYS_REG_END = 199,
};

enum max8997_haptic_motor_type {
	MAX8997_HAPTIC_ERM = 0,
	MAX8997_HAPTIC_LRA = 1,
};

enum max8997_haptic_pulse_mode {
	MAX8997_EXTERNAL_MODE = 0,
	MAX8997_INTERNAL_MODE = 1,
};

enum max8997_haptic_pwm_divisor {
	MAX8997_PWM_DIVISOR_32 = 0,
	MAX8997_PWM_DIVISOR_64 = 1,
	MAX8997_PWM_DIVISOR_128 = 2,
	MAX8997_PWM_DIVISOR_256 = 3,
};

enum max8997_haptic_reg {
	MAX8997_HAPTIC_REG_GENERAL = 0,
	MAX8997_HAPTIC_REG_CONF1 = 1,
	MAX8997_HAPTIC_REG_CONF2 = 2,
	MAX8997_HAPTIC_REG_DRVCONF = 3,
	MAX8997_HAPTIC_REG_CYCLECONF1 = 4,
	MAX8997_HAPTIC_REG_CYCLECONF2 = 5,
	MAX8997_HAPTIC_REG_SIGCONF1 = 6,
	MAX8997_HAPTIC_REG_SIGCONF2 = 7,
	MAX8997_HAPTIC_REG_SIGCONF3 = 8,
	MAX8997_HAPTIC_REG_SIGCONF4 = 9,
	MAX8997_HAPTIC_REG_SIGDC1 = 10,
	MAX8997_HAPTIC_REG_SIGDC2 = 11,
	MAX8997_HAPTIC_REG_SIGPWMDC1 = 12,
	MAX8997_HAPTIC_REG_SIGPWMDC2 = 13,
	MAX8997_HAPTIC_REG_SIGPWMDC3 = 14,
	MAX8997_HAPTIC_REG_SIGPWMDC4 = 15,
	MAX8997_HAPTIC_REG_MTR_REV = 16,
	MAX8997_HAPTIC_REG_END = 17,
};

enum max8997_irq {
	MAX8997_PMICIRQ_PWRONR = 0,
	MAX8997_PMICIRQ_PWRONF = 1,
	MAX8997_PMICIRQ_PWRON1SEC = 2,
	MAX8997_PMICIRQ_JIGONR = 3,
	MAX8997_PMICIRQ_JIGONF = 4,
	MAX8997_PMICIRQ_LOWBAT2 = 5,
	MAX8997_PMICIRQ_LOWBAT1 = 6,
	MAX8997_PMICIRQ_JIGR = 7,
	MAX8997_PMICIRQ_JIGF = 8,
	MAX8997_PMICIRQ_MR = 9,
	MAX8997_PMICIRQ_DVS1OK = 10,
	MAX8997_PMICIRQ_DVS2OK = 11,
	MAX8997_PMICIRQ_DVS3OK = 12,
	MAX8997_PMICIRQ_DVS4OK = 13,
	MAX8997_PMICIRQ_CHGINS = 14,
	MAX8997_PMICIRQ_CHGRM = 15,
	MAX8997_PMICIRQ_DCINOVP = 16,
	MAX8997_PMICIRQ_TOPOFFR = 17,
	MAX8997_PMICIRQ_CHGRSTF = 18,
	MAX8997_PMICIRQ_MBCHGTMEXPD = 19,
	MAX8997_PMICIRQ_RTC60S = 20,
	MAX8997_PMICIRQ_RTCA1 = 21,
	MAX8997_PMICIRQ_RTCA2 = 22,
	MAX8997_PMICIRQ_SMPL_INT = 23,
	MAX8997_PMICIRQ_RTC1S = 24,
	MAX8997_PMICIRQ_WTSR = 25,
	MAX8997_MUICIRQ_ADCError = 26,
	MAX8997_MUICIRQ_ADCLow = 27,
	MAX8997_MUICIRQ_ADC = 28,
	MAX8997_MUICIRQ_VBVolt = 29,
	MAX8997_MUICIRQ_DBChg = 30,
	MAX8997_MUICIRQ_DCDTmr = 31,
	MAX8997_MUICIRQ_ChgDetRun = 32,
	MAX8997_MUICIRQ_ChgTyp = 33,
	MAX8997_MUICIRQ_OVP = 34,
	MAX8997_IRQ_NR = 35,
};

enum max8997_irq_source {
	PMIC_INT1 = 0,
	PMIC_INT2 = 1,
	PMIC_INT3 = 2,
	PMIC_INT4 = 3,
	FUEL_GAUGE = 4,
	MUIC_INT1 = 5,
	MUIC_INT2 = 6,
	MUIC_INT3 = 7,
	GPIO_LOW = 8,
	GPIO_HI = 9,
	FLASH_STATUS = 10,
	MAX8997_IRQ_GROUP_NR = 11,
};

enum max8997_led_mode {
	MAX8997_NONE = 0,
	MAX8997_FLASH_MODE = 1,
	MAX8997_MOVIE_MODE = 2,
	MAX8997_FLASH_PIN_CONTROL_MODE = 3,
	MAX8997_MOVIE_PIN_CONTROL_MODE = 4,
};

enum max8997_muic_reg {
	MAX8997_MUIC_REG_ID = 0,
	MAX8997_MUIC_REG_INT1 = 1,
	MAX8997_MUIC_REG_INT2 = 2,
	MAX8997_MUIC_REG_INT3 = 3,
	MAX8997_MUIC_REG_STATUS1 = 4,
	MAX8997_MUIC_REG_STATUS2 = 5,
	MAX8997_MUIC_REG_STATUS3 = 6,
	MAX8997_MUIC_REG_INTMASK1 = 7,
	MAX8997_MUIC_REG_INTMASK2 = 8,
	MAX8997_MUIC_REG_INTMASK3 = 9,
	MAX8997_MUIC_REG_CDETCTRL = 10,
	MAX8997_MUIC_REG_CONTROL1 = 12,
	MAX8997_MUIC_REG_CONTROL2 = 13,
	MAX8997_MUIC_REG_CONTROL3 = 14,
	MAX8997_MUIC_REG_END = 15,
};

enum max8997_pmic_reg {
	MAX8997_REG_PMIC_ID0 = 0,
	MAX8997_REG_PMIC_ID1 = 1,
	MAX8997_REG_INTSRC = 2,
	MAX8997_REG_INT1 = 3,
	MAX8997_REG_INT2 = 4,
	MAX8997_REG_INT3 = 5,
	MAX8997_REG_INT4 = 6,
	MAX8997_REG_INT1MSK = 8,
	MAX8997_REG_INT2MSK = 9,
	MAX8997_REG_INT3MSK = 10,
	MAX8997_REG_INT4MSK = 11,
	MAX8997_REG_STATUS1 = 13,
	MAX8997_REG_STATUS2 = 14,
	MAX8997_REG_STATUS3 = 15,
	MAX8997_REG_STATUS4 = 16,
	MAX8997_REG_MAINCON1 = 19,
	MAX8997_REG_MAINCON2 = 20,
	MAX8997_REG_BUCKRAMP = 21,
	MAX8997_REG_BUCK1CTRL = 24,
	MAX8997_REG_BUCK1DVS1 = 25,
	MAX8997_REG_BUCK1DVS2 = 26,
	MAX8997_REG_BUCK1DVS3 = 27,
	MAX8997_REG_BUCK1DVS4 = 28,
	MAX8997_REG_BUCK1DVS5 = 29,
	MAX8997_REG_BUCK1DVS6 = 30,
	MAX8997_REG_BUCK1DVS7 = 31,
	MAX8997_REG_BUCK1DVS8 = 32,
	MAX8997_REG_BUCK2CTRL = 33,
	MAX8997_REG_BUCK2DVS1 = 34,
	MAX8997_REG_BUCK2DVS2 = 35,
	MAX8997_REG_BUCK2DVS3 = 36,
	MAX8997_REG_BUCK2DVS4 = 37,
	MAX8997_REG_BUCK2DVS5 = 38,
	MAX8997_REG_BUCK2DVS6 = 39,
	MAX8997_REG_BUCK2DVS7 = 40,
	MAX8997_REG_BUCK2DVS8 = 41,
	MAX8997_REG_BUCK3CTRL = 42,
	MAX8997_REG_BUCK3DVS = 43,
	MAX8997_REG_BUCK4CTRL = 44,
	MAX8997_REG_BUCK4DVS = 45,
	MAX8997_REG_BUCK5CTRL = 46,
	MAX8997_REG_BUCK5DVS1 = 47,
	MAX8997_REG_BUCK5DVS2 = 48,
	MAX8997_REG_BUCK5DVS3 = 49,
	MAX8997_REG_BUCK5DVS4 = 50,
	MAX8997_REG_BUCK5DVS5 = 51,
	MAX8997_REG_BUCK5DVS6 = 52,
	MAX8997_REG_BUCK5DVS7 = 53,
	MAX8997_REG_BUCK5DVS8 = 54,
	MAX8997_REG_BUCK6CTRL = 55,
	MAX8997_REG_BUCK6BPSKIPCTRL = 56,
	MAX8997_REG_BUCK7CTRL = 57,
	MAX8997_REG_BUCK7DVS = 58,
	MAX8997_REG_LDO1CTRL = 59,
	MAX8997_REG_LDO2CTRL = 60,
	MAX8997_REG_LDO3CTRL = 61,
	MAX8997_REG_LDO4CTRL = 62,
	MAX8997_REG_LDO5CTRL = 63,
	MAX8997_REG_LDO6CTRL = 64,
	MAX8997_REG_LDO7CTRL = 65,
	MAX8997_REG_LDO8CTRL = 66,
	MAX8997_REG_LDO9CTRL = 67,
	MAX8997_REG_LDO10CTRL = 68,
	MAX8997_REG_LDO11CTRL = 69,
	MAX8997_REG_LDO12CTRL = 70,
	MAX8997_REG_LDO13CTRL = 71,
	MAX8997_REG_LDO14CTRL = 72,
	MAX8997_REG_LDO15CTRL = 73,
	MAX8997_REG_LDO16CTRL = 74,
	MAX8997_REG_LDO17CTRL = 75,
	MAX8997_REG_LDO18CTRL = 76,
	MAX8997_REG_LDO21CTRL = 77,
	MAX8997_REG_MBCCTRL1 = 80,
	MAX8997_REG_MBCCTRL2 = 81,
	MAX8997_REG_MBCCTRL3 = 82,
	MAX8997_REG_MBCCTRL4 = 83,
	MAX8997_REG_MBCCTRL5 = 84,
	MAX8997_REG_MBCCTRL6 = 85,
	MAX8997_REG_OTPCGHCVS = 86,
	MAX8997_REG_SAFEOUTCTRL = 90,
	MAX8997_REG_LBCNFG1 = 94,
	MAX8997_REG_LBCNFG2 = 95,
	MAX8997_REG_BBCCTRL = 96,
	MAX8997_REG_FLASH1_CUR = 99,
	MAX8997_REG_FLASH2_CUR = 100,
	MAX8997_REG_MOVIE_CUR = 101,
	MAX8997_REG_GSMB_CUR = 102,
	MAX8997_REG_BOOST_CNTL = 103,
	MAX8997_REG_LEN_CNTL = 104,
	MAX8997_REG_FLASH_CNTL = 105,
	MAX8997_REG_WDT_CNTL = 106,
	MAX8997_REG_MAXFLASH1 = 107,
	MAX8997_REG_MAXFLASH2 = 108,
	MAX8997_REG_FLASHSTATUS = 109,
	MAX8997_REG_FLASHSTATUSMASK = 110,
	MAX8997_REG_GPIOCNTL1 = 112,
	MAX8997_REG_GPIOCNTL2 = 113,
	MAX8997_REG_GPIOCNTL3 = 114,
	MAX8997_REG_GPIOCNTL4 = 115,
	MAX8997_REG_GPIOCNTL5 = 116,
	MAX8997_REG_GPIOCNTL6 = 117,
	MAX8997_REG_GPIOCNTL7 = 118,
	MAX8997_REG_GPIOCNTL8 = 119,
	MAX8997_REG_GPIOCNTL9 = 120,
	MAX8997_REG_GPIOCNTL10 = 121,
	MAX8997_REG_GPIOCNTL11 = 122,
	MAX8997_REG_GPIOCNTL12 = 123,
	MAX8997_REG_LDO1CONFIG = 128,
	MAX8997_REG_LDO2CONFIG = 129,
	MAX8997_REG_LDO3CONFIG = 130,
	MAX8997_REG_LDO4CONFIG = 131,
	MAX8997_REG_LDO5CONFIG = 132,
	MAX8997_REG_LDO6CONFIG = 133,
	MAX8997_REG_LDO7CONFIG = 134,
	MAX8997_REG_LDO8CONFIG = 135,
	MAX8997_REG_LDO9CONFIG = 136,
	MAX8997_REG_LDO10CONFIG = 137,
	MAX8997_REG_LDO11CONFIG = 138,
	MAX8997_REG_LDO12CONFIG = 139,
	MAX8997_REG_LDO13CONFIG = 140,
	MAX8997_REG_LDO14CONFIG = 141,
	MAX8997_REG_LDO15CONFIG = 142,
	MAX8997_REG_LDO16CONFIG = 143,
	MAX8997_REG_LDO17CONFIG = 144,
	MAX8997_REG_LDO18CONFIG = 145,
	MAX8997_REG_LDO21CONFIG = 146,
	MAX8997_REG_DVSOKTIMER1 = 151,
	MAX8997_REG_DVSOKTIMER2 = 152,
	MAX8997_REG_DVSOKTIMER4 = 153,
	MAX8997_REG_DVSOKTIMER5 = 154,
	MAX8997_REG_PMIC_END = 155,
};

enum max8997_types {
	TYPE_MAX8997 = 0,
	TYPE_MAX8966 = 1,
};

enum mca_msr {
	MCA_CTL = 0,
	MCA_STATUS = 1,
	MCA_ADDR = 2,
	MCA_MISC = 3,
};

enum mce_notifier_prios {
	MCE_PRIO_LOWEST = 0,
	MCE_PRIO_MCELOG = 1,
	MCE_PRIO_EDAC = 2,
	MCE_PRIO_NFIT = 3,
	MCE_PRIO_EXTLOG = 4,
	MCE_PRIO_UC = 5,
	MCE_PRIO_EARLY = 6,
	MCE_PRIO_CEC = 7,
	MCE_PRIO_HIGHEST = 7,
};

enum mcp_flags {
	MCP_TIMESTAMP = 1,
	MCP_UC = 2,
	MCP_DONTLOG = 4,
	MCP_QUEUE_LOG = 8,
};

enum mctp_neigh_source {
	MCTP_NEIGH_STATIC = 0,
	MCTP_NEIGH_DISCOVER = 1,
};

enum mctp_phys_binding {
	MCTP_PHYS_BINDING_UNSPEC = 0,
	MCTP_PHYS_BINDING_SMBUS = 1,
	MCTP_PHYS_BINDING_PCIE_VDM = 2,
	MCTP_PHYS_BINDING_USB = 3,
	MCTP_PHYS_BINDING_KCS = 4,
	MCTP_PHYS_BINDING_SERIAL = 5,
	MCTP_PHYS_BINDING_I3C = 6,
	MCTP_PHYS_BINDING_MMBI = 7,
	MCTP_PHYS_BINDING_PCC = 8,
	MCTP_PHYS_BINDING_UCIE = 9,
	MCTP_PHYS_BINDING_VENDOR = 255,
};

enum mctrl_gpio_idx {
	UART_GPIO_CTS = 0,
	UART_GPIO_DSR = 1,
	UART_GPIO_DCD = 2,
	UART_GPIO_RNG = 3,
	UART_GPIO_RI = 3,
	UART_GPIO_RTS = 4,
	UART_GPIO_DTR = 5,
	UART_GPIO_MAX = 6,
};

enum mds_mitigations {
	MDS_MITIGATION_OFF = 0,
	MDS_MITIGATION_AUTO = 1,
	MDS_MITIGATION_FULL = 2,
	MDS_MITIGATION_VMWERV = 3,
};

enum mem_type {
	MEM_EMPTY = 0,
	MEM_RESERVED = 1,
	MEM_UNKNOWN = 2,
	MEM_FPM = 3,
	MEM_EDO = 4,
	MEM_BEDO = 5,
	MEM_SDR = 6,
	MEM_RDR = 7,
	MEM_DDR = 8,
	MEM_RDDR = 9,
	MEM_RMBS = 10,
	MEM_DDR2 = 11,
	MEM_FB_DDR2 = 12,
	MEM_RDDR2 = 13,
	MEM_XDR = 14,
	MEM_DDR3 = 15,
	MEM_RDDR3 = 16,
	MEM_LRDDR3 = 17,
	MEM_LPDDR3 = 18,
	MEM_DDR4 = 19,
	MEM_RDDR4 = 20,
	MEM_LRDDR4 = 21,
	MEM_LPDDR4 = 22,
	MEM_DDR5 = 23,
	MEM_RDDR5 = 24,
	MEM_LRDDR5 = 25,
	MEM_NVDIMM = 26,
	MEM_WIO2 = 27,
	MEM_HBM2 = 28,
	MEM_HBM3 = 29,
};

enum membarrier_cmd {
	MEMBARRIER_CMD_QUERY = 0,
	MEMBARRIER_CMD_GLOBAL = 1,
	MEMBARRIER_CMD_GLOBAL_EXPEDITED = 2,
	MEMBARRIER_CMD_REGISTER_GLOBAL_EXPEDITED = 4,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED = 8,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED = 16,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_SYNC_CORE = 64,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_RSEQ = 128,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_RSEQ = 256,
	MEMBARRIER_CMD_GET_REGISTRATIONS = 512,
	MEMBARRIER_CMD_SHARED = 1,
};

enum membarrier_cmd_flag {
	MEMBARRIER_CMD_FLAG_CPU = 1,
};

enum memblock_flags {
	MEMBLOCK_NONE = 0,
	MEMBLOCK_HOTPLUG = 1,
	MEMBLOCK_MIRROR = 2,
	MEMBLOCK_NOMAP = 4,
	MEMBLOCK_DRIVER_MANAGED = 8,
	MEMBLOCK_RSRV_NOINIT = 16,
	MEMBLOCK_RSRV_KERN = 32,
	MEMBLOCK_KHO_SCRATCH = 64,
};

enum membw_throttle_mode {
	THREAD_THROTTLE_UNDEFINED = 0,
	THREAD_THROTTLE_MAX = 1,
	THREAD_THROTTLE_PER_THREAD = 2,
};

enum memcg_memory_event {
	MEMCG_LOW = 0,
	MEMCG_HIGH = 1,
	MEMCG_MAX = 2,
	MEMCG_OOM = 3,
	MEMCG_OOM_KILL = 4,
	MEMCG_OOM_GROUP_KILL = 5,
	MEMCG_SWAP_HIGH = 6,
	MEMCG_SWAP_MAX = 7,
	MEMCG_SWAP_FAIL = 8,
	MEMCG_NR_MEMORY_EVENTS = 9,
};

enum memcg_stat_item {
	MEMCG_SWAP = 49,
	MEMCG_SOCK = 50,
	MEMCG_PERCPU_B = 51,
	MEMCG_VMALLOC = 52,
	MEMCG_KMEM = 53,
	MEMCG_ZSWAP_B = 54,
	MEMCG_ZSWAPPED = 55,
	MEMCG_NR_STAT = 56,
};

enum meminit_context {
	MEMINIT_EARLY = 0,
	MEMINIT_HOTPLUG = 1,
};

enum memory_type {
	MEMORY_DEVICE_PRIVATE = 1,
	MEMORY_DEVICE_COHERENT = 2,
	MEMORY_DEVICE_FS_DAX = 3,
	MEMORY_DEVICE_GENERIC = 4,
	MEMORY_DEVICE_PCI_P2PDMA = 5,
};

enum metadata_type {
	METADATA_IP_TUNNEL = 0,
	METADATA_HW_PORT_MUX = 1,
	METADATA_MACSEC = 2,
	METADATA_XFRM = 3,
};

enum mf_action_page_type {
	MF_MSG_KERNEL = 0,
	MF_MSG_KERNEL_HIGH_ORDER = 1,
	MF_MSG_DIFFERENT_COMPOUND = 2,
	MF_MSG_HUGE = 3,
	MF_MSG_FREE_HUGE = 4,
	MF_MSG_GET_HWPOISON = 5,
	MF_MSG_UNMAP_FAILED = 6,
	MF_MSG_DIRTY_SWAPCACHE = 7,
	MF_MSG_CLEAN_SWAPCACHE = 8,
	MF_MSG_DIRTY_MLOCKED_LRU = 9,
	MF_MSG_CLEAN_MLOCKED_LRU = 10,
	MF_MSG_DIRTY_UNEVICTABLE_LRU = 11,
	MF_MSG_CLEAN_UNEVICTABLE_LRU = 12,
	MF_MSG_DIRTY_LRU = 13,
	MF_MSG_CLEAN_LRU = 14,
	MF_MSG_TRUNCATED_LRU = 15,
	MF_MSG_BUDDY = 16,
	MF_MSG_DAX = 17,
	MF_MSG_UNSPLIT_THP = 18,
	MF_MSG_ALREADY_POISONED = 19,
	MF_MSG_UNKNOWN = 20,
};

enum mf_flags {
	MF_COUNT_INCREASED = 1,
	MF_ACTION_REQUIRED = 2,
	MF_MUST_KILL = 4,
	MF_SOFT_OFFLINE = 8,
	MF_UNPOISON = 16,
	MF_SW_SIMULATED = 32,
	MF_NO_RETRY = 64,
	MF_MEM_PRE_REMOVE = 128,
};

enum mf_result {
	MF_IGNORED = 0,
	MF_FAILED = 1,
	MF_DELAYED = 2,
	MF_RECOVERED = 3,
};

enum mfill_atomic_mode {
	MFILL_ATOMIC_COPY = 0,
	MFILL_ATOMIC_ZEROPAGE = 1,
	MFILL_ATOMIC_CONTINUE = 2,
	MFILL_ATOMIC_POISON = 3,
	NR_MFILL_ATOMIC_MODES = 4,
};

enum migrate_mode {
	MIGRATE_ASYNC = 0,
	MIGRATE_SYNC_LIGHT = 1,
	MIGRATE_SYNC = 2,
};

enum migrate_reason {
	MR_COMPACTION = 0,
	MR_MEMORY_FAILURE = 1,
	MR_MEMORY_HOTPLUG = 2,
	MR_SYSCALL = 3,
	MR_MEMPOLICY_MBIND = 4,
	MR_NUMA_MISPLACED = 5,
	MR_CONTIG_RANGE = 6,
	MR_LONGTERM_PIN = 7,
	MR_DEMOTION = 8,
	MR_DAMON = 9,
	MR_TYPES = 10,
};

enum migrate_vma_direction {
	MIGRATE_VMA_SELECT_SYSTEM = 1,
	MIGRATE_VMA_SELECT_DEVICE_PRIVATE = 2,
	MIGRATE_VMA_SELECT_DEVICE_COHERENT = 4,
};

enum migratetype {
	MIGRATE_UNMOVABLE = 0,
	MIGRATE_MOVABLE = 1,
	MIGRATE_RECLAIMABLE = 2,
	MIGRATE_PCPTYPES = 3,
	MIGRATE_HIGHATOMIC = 3,
	MIGRATE_CMA = 4,
	__MIGRATE_TYPE_END = 4,
	MIGRATE_ISOLATE = 5,
	MIGRATE_TYPES = 6,
};

enum migration_type {
	migrate_load = 0,
	migrate_util = 1,
	migrate_task = 2,
	migrate_misfit = 3,
};

enum mipi_dsi_compression_algo {
	MIPI_DSI_COMPRESSION_DSC = 0,
	MIPI_DSI_COMPRESSION_VENDOR = 3,
};

enum mipi_dsi_dcs_tear_mode {
	MIPI_DSI_DCS_TEAR_MODE_VBLANK = 0,
	MIPI_DSI_DCS_TEAR_MODE_VHBLANK = 1,
};

enum mipi_dsi_pixel_format {
	MIPI_DSI_FMT_RGB888 = 0,
	MIPI_DSI_FMT_RGB666 = 1,
	MIPI_DSI_FMT_RGB666_PACKED = 2,
	MIPI_DSI_FMT_RGB565 = 3,
};

enum misc_res_type {
	MISC_CG_RES_SEV = 0,
	MISC_CG_RES_SEV_ES = 1,
	MISC_CG_RES_TYPES = 2,
};

enum mm_cid_state {
	MM_CID_UNSET = 4294967295,
	MM_CID_LAZY_PUT = 2147483648,
};

enum mm_io_opcode {
	MMIO_READ = 1,
	MMIO_WRITE = 2,
	MMIO_PROBE = 3,
	MMIO_UNPROBE = 4,
	MMIO_UNKNOWN_OP = 5,
};

enum mminit_level {
	MMINIT_WARNING = 0,
	MMINIT_VERIFY = 1,
	MMINIT_TRACE = 2,
};

enum mmio_mitigations {
	MMIO_MITIGATION_OFF = 0,
	MMIO_MITIGATION_AUTO = 1,
	MMIO_MITIGATION_UCODE_NEEDED = 2,
	MMIO_MITIGATION_VERW = 3,
};

enum mmu_notifier_event {
	MMU_NOTIFY_UNMAP = 0,
	MMU_NOTIFY_CLEAR = 1,
	MMU_NOTIFY_PROTECTION_VMA = 2,
	MMU_NOTIFY_PROTECTION_PAGE = 3,
	MMU_NOTIFY_SOFT_DIRTY = 4,
	MMU_NOTIFY_RELEASE = 5,
	MMU_NOTIFY_MIGRATE = 6,
	MMU_NOTIFY_EXCLUSIVE = 7,
};

enum mnt_tree_flags_t {
	MNT_TREE_BENEATH = 1,
	MNT_TREE_PROPAGATION = 2,
};

enum mod_license {
	NOT_GPL_ONLY = 0,
	GPL_ONLY = 1,
};

enum mod_mem_type {
	MOD_TEXT = 0,
	MOD_DATA = 1,
	MOD_RODATA = 2,
	MOD_RO_AFTER_INIT = 3,
	MOD_INIT_TEXT = 4,
	MOD_INIT_DATA = 5,
	MOD_INIT_RODATA = 6,
	MOD_MEM_NUM_TYPES = 7,
	MOD_INVALID = -1,
};

enum mode_set_atomic {
	LEAVE_ATOMIC_MODE_SET = 0,
	ENTER_ATOMIC_MODE_SET = 1,
};

enum module_state {
	MODULE_STATE_LIVE = 0,
	MODULE_STATE_COMING = 1,
	MODULE_STATE_GOING = 2,
	MODULE_STATE_UNFORMED = 3,
};

enum mount_flags {
	MNT_NOSUID = 1,
	MNT_NODEV = 2,
	MNT_NOEXEC = 4,
	MNT_NOATIME = 8,
	MNT_NODIRATIME = 16,
	MNT_RELATIME = 32,
	MNT_READONLY = 64,
	MNT_NOSYMFOLLOW = 128,
	MNT_SHRINKABLE = 256,
	MNT_WRITE_HOLD = 512,
	MNT_INTERNAL = 16384,
	MNT_LOCK_ATIME = 262144,
	MNT_LOCK_NOEXEC = 524288,
	MNT_LOCK_NOSUID = 1048576,
	MNT_LOCK_NODEV = 2097152,
	MNT_LOCK_READONLY = 4194304,
	MNT_LOCKED = 8388608,
	MNT_DOOMED = 16777216,
	MNT_SYNC_UMOUNT = 33554432,
	MNT_UMOUNT = 134217728,
	MNT_USER_SETTABLE_MASK = 255,
	MNT_ATIME_MASK = 56,
	MNT_INTERNAL_FLAGS = 58737152,
};

enum mount_kattr_flags_t {
	MOUNT_KATTR_RECURSE = 1,
	MOUNT_KATTR_IDMAP_REPLACE = 2,
};

enum mp_irq_source_types {
	mp_INT = 0,
	mp_NMI = 1,
	mp_SMI = 2,
	mp_ExtINT = 3,
};

enum mptcp_addr_signal_status {
	MPTCP_ADD_ADDR_SIGNAL = 0,
	MPTCP_ADD_ADDR_ECHO = 1,
	MPTCP_RM_ADDR_SIGNAL = 2,
};

enum mptcp_event_attr {
	MPTCP_ATTR_UNSPEC = 0,
	MPTCP_ATTR_TOKEN = 1,
	MPTCP_ATTR_FAMILY = 2,
	MPTCP_ATTR_LOC_ID = 3,
	MPTCP_ATTR_REM_ID = 4,
	MPTCP_ATTR_SADDR4 = 5,
	MPTCP_ATTR_SADDR6 = 6,
	MPTCP_ATTR_DADDR4 = 7,
	MPTCP_ATTR_DADDR6 = 8,
	MPTCP_ATTR_SPORT = 9,
	MPTCP_ATTR_DPORT = 10,
	MPTCP_ATTR_BACKUP = 11,
	MPTCP_ATTR_ERROR = 12,
	MPTCP_ATTR_FLAGS = 13,
	MPTCP_ATTR_TIMEOUT = 14,
	MPTCP_ATTR_IF_IDX = 15,
	MPTCP_ATTR_RESET_REASON = 16,
	MPTCP_ATTR_RESET_FLAGS = 17,
	MPTCP_ATTR_SERVER_SIDE = 18,
	__MPTCP_ATTR_MAX = 19,
};

enum mptcp_event_type {
	MPTCP_EVENT_UNSPEC = 0,
	MPTCP_EVENT_CREATED = 1,
	MPTCP_EVENT_ESTABLISHED = 2,
	MPTCP_EVENT_CLOSED = 3,
	MPTCP_EVENT_ANNOUNCED = 6,
	MPTCP_EVENT_REMOVED = 7,
	MPTCP_EVENT_SUB_ESTABLISHED = 10,
	MPTCP_EVENT_SUB_CLOSED = 11,
	MPTCP_EVENT_SUB_PRIORITY = 13,
	MPTCP_EVENT_LISTENER_CREATED = 15,
	MPTCP_EVENT_LISTENER_CLOSED = 16,
};

enum mptcp_pm_status {
	MPTCP_PM_ADD_ADDR_RECEIVED = 0,
	MPTCP_PM_ADD_ADDR_SEND_ACK = 1,
	MPTCP_PM_RM_ADDR_RECEIVED = 2,
	MPTCP_PM_ESTABLISHED = 3,
	MPTCP_PM_SUBFLOW_ESTABLISHED = 4,
	MPTCP_PM_ALREADY_ESTABLISHED = 5,
	MPTCP_PM_MPC_ENDPOINT_ACCOUNTED = 6,
};

enum mptcp_pm_type {
	MPTCP_PM_TYPE_KERNEL = 0,
	MPTCP_PM_TYPE_USERSPACE = 1,
	__MPTCP_PM_TYPE_NR = 2,
	__MPTCP_PM_TYPE_MAX = 1,
};

enum mq_rq_state {
	MQ_RQ_IDLE = 0,
	MQ_RQ_IN_FLIGHT = 1,
	MQ_RQ_COMPLETE = 2,
};

enum mremap_type {
	MREMAP_INVALID = 0,
	MREMAP_NO_RESIZE = 1,
	MREMAP_SHRINK = 2,
	MREMAP_EXPAND = 3,
};

enum mscode_actions {
	ACT_mscode_note_content_type = 0,
	ACT_mscode_note_digest = 1,
	ACT_mscode_note_digest_algo = 2,
	NR__mscode_actions = 3,
};

enum msdos_sys_ind {
	DOS_EXTENDED_PARTITION = 5,
	LINUX_EXTENDED_PARTITION = 133,
	WIN98_EXTENDED_PARTITION = 15,
	LINUX_DATA_PARTITION = 131,
	LINUX_LVM_PARTITION = 142,
	LINUX_RAID_PARTITION = 253,
	SOLARIS_X86_PARTITION = 130,
	NEW_SOLARIS_X86_PARTITION = 191,
	DM6_AUX1PARTITION = 81,
	DM6_AUX3PARTITION = 83,
	DM6_PARTITION = 84,
	EZD_PARTITION = 85,
	FREEBSD_PARTITION = 165,
	OPENBSD_PARTITION = 166,
	NETBSD_PARTITION = 169,
	BSDI_PARTITION = 183,
	MINIX_PARTITION = 129,
	UNIXWARE_PARTITION = 99,
};

enum msg_type {
	SNP_MSG_TYPE_INVALID = 0,
	SNP_MSG_CPUID_REQ = 1,
	SNP_MSG_CPUID_RSP = 2,
	SNP_MSG_KEY_REQ = 3,
	SNP_MSG_KEY_RSP = 4,
	SNP_MSG_REPORT_REQ = 5,
	SNP_MSG_REPORT_RSP = 6,
	SNP_MSG_EXPORT_REQ = 7,
	SNP_MSG_EXPORT_RSP = 8,
	SNP_MSG_IMPORT_REQ = 9,
	SNP_MSG_IMPORT_RSP = 10,
	SNP_MSG_ABSORB_REQ = 11,
	SNP_MSG_ABSORB_RSP = 12,
	SNP_MSG_VMRK_REQ = 13,
	SNP_MSG_VMRK_RSP = 14,
	SNP_MSG_TSC_INFO_REQ = 17,
	SNP_MSG_TSC_INFO_RSP = 18,
	SNP_MSG_TYPE_MAX = 19,
};

enum msi_desc_filter {
	MSI_DESC_ALL = 0,
	MSI_DESC_NOTASSOCIATED = 1,
	MSI_DESC_ASSOCIATED = 2,
};

enum msi_domain_ids {
	MSI_DEFAULT_DOMAIN = 0,
	MSI_MAX_DEVICE_IRQDOMAINS = 1,
};

enum mthp_stat_item {
	MTHP_STAT_ANON_FAULT_ALLOC = 0,
	MTHP_STAT_ANON_FAULT_FALLBACK = 1,
	MTHP_STAT_ANON_FAULT_FALLBACK_CHARGE = 2,
	MTHP_STAT_ZSWPOUT = 3,
	MTHP_STAT_SWPIN = 4,
	MTHP_STAT_SWPIN_FALLBACK = 5,
	MTHP_STAT_SWPIN_FALLBACK_CHARGE = 6,
	MTHP_STAT_SWPOUT = 7,
	MTHP_STAT_SWPOUT_FALLBACK = 8,
	MTHP_STAT_SHMEM_ALLOC = 9,
	MTHP_STAT_SHMEM_FALLBACK = 10,
	MTHP_STAT_SHMEM_FALLBACK_CHARGE = 11,
	MTHP_STAT_SPLIT = 12,
	MTHP_STAT_SPLIT_FAILED = 13,
	MTHP_STAT_SPLIT_DEFERRED = 14,
	MTHP_STAT_NR_ANON = 15,
	MTHP_STAT_NR_ANON_PARTIALLY_MAPPED = 16,
	__MTHP_STAT_COUNT = 17,
};

enum multi_stop_state {
	MULTI_STOP_NONE = 0,
	MULTI_STOP_PREPARE = 1,
	MULTI_STOP_DISABLE_IRQ = 2,
	MULTI_STOP_RUN = 3,
	MULTI_STOP_EXIT = 4,
};

enum nbcon_prio {
	NBCON_PRIO_NONE = 0,
	NBCON_PRIO_NORMAL = 1,
	NBCON_PRIO_EMERGENCY = 2,
	NBCON_PRIO_PANIC = 3,
	NBCON_PRIO_MAX = 4,
};

enum ncsi_nl_attrs {
	NCSI_ATTR_UNSPEC = 0,
	NCSI_ATTR_IFINDEX = 1,
	NCSI_ATTR_PACKAGE_LIST = 2,
	NCSI_ATTR_PACKAGE_ID = 3,
	NCSI_ATTR_CHANNEL_ID = 4,
	NCSI_ATTR_DATA = 5,
	NCSI_ATTR_MULTI_FLAG = 6,
	NCSI_ATTR_PACKAGE_MASK = 7,
	NCSI_ATTR_CHANNEL_MASK = 8,
	__NCSI_ATTR_AFTER_LAST = 9,
	NCSI_ATTR_MAX = 8,
};

enum ncsi_nl_channel_attrs {
	NCSI_CHANNEL_ATTR_UNSPEC = 0,
	NCSI_CHANNEL_ATTR = 1,
	NCSI_CHANNEL_ATTR_ID = 2,
	NCSI_CHANNEL_ATTR_VERSION_MAJOR = 3,
	NCSI_CHANNEL_ATTR_VERSION_MINOR = 4,
	NCSI_CHANNEL_ATTR_VERSION_STR = 5,
	NCSI_CHANNEL_ATTR_LINK_STATE = 6,
	NCSI_CHANNEL_ATTR_ACTIVE = 7,
	NCSI_CHANNEL_ATTR_FORCED = 8,
	NCSI_CHANNEL_ATTR_VLAN_LIST = 9,
	NCSI_CHANNEL_ATTR_VLAN_ID = 10,
	__NCSI_CHANNEL_ATTR_AFTER_LAST = 11,
	NCSI_CHANNEL_ATTR_MAX = 10,
};

enum ncsi_nl_commands {
	NCSI_CMD_UNSPEC = 0,
	NCSI_CMD_PKG_INFO = 1,
	NCSI_CMD_SET_INTERFACE = 2,
	NCSI_CMD_CLEAR_INTERFACE = 3,
	NCSI_CMD_SEND_CMD = 4,
	NCSI_CMD_SET_PACKAGE_MASK = 5,
	NCSI_CMD_SET_CHANNEL_MASK = 6,
	__NCSI_CMD_AFTER_LAST = 7,
	NCSI_CMD_MAX = 6,
};

enum ncsi_nl_pkg_attrs {
	NCSI_PKG_ATTR_UNSPEC = 0,
	NCSI_PKG_ATTR = 1,
	NCSI_PKG_ATTR_ID = 2,
	NCSI_PKG_ATTR_FORCED = 3,
	NCSI_PKG_ATTR_CHANNEL_LIST = 4,
	__NCSI_PKG_ATTR_AFTER_LAST = 5,
	NCSI_PKG_ATTR_MAX = 4,
};

enum net_device_flags {
	IFF_UP = 1,
	IFF_BROADCAST = 2,
	IFF_DEBUG = 4,
	IFF_LOOPBACK = 8,
	IFF_POINTOPOINT = 16,
	IFF_NOTRAILERS = 32,
	IFF_RUNNING = 64,
	IFF_NOARP = 128,
	IFF_PROMISC = 256,
	IFF_ALLMULTI = 512,
	IFF_MASTER = 1024,
	IFF_SLAVE = 2048,
	IFF_MULTICAST = 4096,
	IFF_PORTSEL = 8192,
	IFF_AUTOMEDIA = 16384,
	IFF_DYNAMIC = 32768,
	IFF_LOWER_UP = 65536,
	IFF_DORMANT = 131072,
	IFF_ECHO = 262144,
};

enum net_device_path_type {
	DEV_PATH_ETHERNET = 0,
	DEV_PATH_VLAN = 1,
	DEV_PATH_BRIDGE = 2,
	DEV_PATH_PPPOE = 3,
	DEV_PATH_DSA = 4,
	DEV_PATH_MTK_WDMA = 5,
};

enum net_dm_alert_mode {
	NET_DM_ALERT_MODE_SUMMARY = 0,
	NET_DM_ALERT_MODE_PACKET = 1,
};

enum net_dm_attr {
	NET_DM_ATTR_UNSPEC = 0,
	NET_DM_ATTR_ALERT_MODE = 1,
	NET_DM_ATTR_PC = 2,
	NET_DM_ATTR_SYMBOL = 3,
	NET_DM_ATTR_IN_PORT = 4,
	NET_DM_ATTR_TIMESTAMP = 5,
	NET_DM_ATTR_PROTO = 6,
	NET_DM_ATTR_PAYLOAD = 7,
	NET_DM_ATTR_PAD = 8,
	NET_DM_ATTR_TRUNC_LEN = 9,
	NET_DM_ATTR_ORIG_LEN = 10,
	NET_DM_ATTR_QUEUE_LEN = 11,
	NET_DM_ATTR_STATS = 12,
	NET_DM_ATTR_HW_STATS = 13,
	NET_DM_ATTR_ORIGIN = 14,
	NET_DM_ATTR_HW_TRAP_GROUP_NAME = 15,
	NET_DM_ATTR_HW_TRAP_NAME = 16,
	NET_DM_ATTR_HW_ENTRIES = 17,
	NET_DM_ATTR_HW_ENTRY = 18,
	NET_DM_ATTR_HW_TRAP_COUNT = 19,
	NET_DM_ATTR_SW_DROPS = 20,
	NET_DM_ATTR_HW_DROPS = 21,
	NET_DM_ATTR_FLOW_ACTION_COOKIE = 22,
	NET_DM_ATTR_REASON = 23,
	__NET_DM_ATTR_MAX = 24,
	NET_DM_ATTR_MAX = 23,
};

enum net_dm_origin {
	NET_DM_ORIGIN_SW = 0,
	NET_DM_ORIGIN_HW = 1,
};

enum net_iov_type {
	NET_IOV_DMABUF = 0ULL,
	NET_IOV_IOURING = 1ULL,
	NET_IOV_MAX = 18446744073709551615ULL,
};

enum net_shaper_binding_type {
	NET_SHAPER_BINDING_TYPE_NETDEV = 0,
};

enum net_shaper_metric {
	NET_SHAPER_METRIC_BPS = 0,
	NET_SHAPER_METRIC_PPS = 1,
};

enum net_shaper_scope {
	NET_SHAPER_SCOPE_UNSPEC = 0,
	NET_SHAPER_SCOPE_NETDEV = 1,
	NET_SHAPER_SCOPE_QUEUE = 2,
	NET_SHAPER_SCOPE_NODE = 3,
	__NET_SHAPER_SCOPE_MAX = 4,
	NET_SHAPER_SCOPE_MAX = 3,
};

enum net_xmit_qdisc_t {
	__NET_XMIT_STOLEN = 65536,
	__NET_XMIT_BYPASS = 131072,
};

enum netdev_cmd {
	NETDEV_UP = 1,
	NETDEV_DOWN = 2,
	NETDEV_REBOOT = 3,
	NETDEV_CHANGE = 4,
	NETDEV_REGISTER = 5,
	NETDEV_UNREGISTER = 6,
	NETDEV_CHANGEMTU = 7,
	NETDEV_CHANGEADDR = 8,
	NETDEV_PRE_CHANGEADDR = 9,
	NETDEV_GOING_DOWN = 10,
	NETDEV_CHANGENAME = 11,
	NETDEV_FEAT_CHANGE = 12,
	NETDEV_BONDING_FAILOVER = 13,
	NETDEV_PRE_UP = 14,
	NETDEV_PRE_TYPE_CHANGE = 15,
	NETDEV_POST_TYPE_CHANGE = 16,
	NETDEV_POST_INIT = 17,
	NETDEV_PRE_UNINIT = 18,
	NETDEV_RELEASE = 19,
	NETDEV_NOTIFY_PEERS = 20,
	NETDEV_JOIN = 21,
	NETDEV_CHANGEUPPER = 22,
	NETDEV_RESEND_IGMP = 23,
	NETDEV_PRECHANGEMTU = 24,
	NETDEV_CHANGEINFODATA = 25,
	NETDEV_BONDING_INFO = 26,
	NETDEV_PRECHANGEUPPER = 27,
	NETDEV_CHANGELOWERSTATE = 28,
	NETDEV_UDP_TUNNEL_PUSH_INFO = 29,
	NETDEV_UDP_TUNNEL_DROP_INFO = 30,
	NETDEV_CHANGE_TX_QUEUE_LEN = 31,
	NETDEV_CVLAN_FILTER_PUSH_INFO = 32,
	NETDEV_CVLAN_FILTER_DROP_INFO = 33,
	NETDEV_SVLAN_FILTER_PUSH_INFO = 34,
	NETDEV_SVLAN_FILTER_DROP_INFO = 35,
	NETDEV_OFFLOAD_XSTATS_ENABLE = 36,
	NETDEV_OFFLOAD_XSTATS_DISABLE = 37,
	NETDEV_OFFLOAD_XSTATS_REPORT_USED = 38,
	NETDEV_OFFLOAD_XSTATS_REPORT_DELTA = 39,
	NETDEV_XDP_FEAT_CHANGE = 40,
};

enum netdev_lag_hash {
	NETDEV_LAG_HASH_NONE = 0,
	NETDEV_LAG_HASH_L2 = 1,
	NETDEV_LAG_HASH_L34 = 2,
	NETDEV_LAG_HASH_L23 = 3,
	NETDEV_LAG_HASH_E23 = 4,
	NETDEV_LAG_HASH_E34 = 5,
	NETDEV_LAG_HASH_VLAN_SRCMAC = 6,
	NETDEV_LAG_HASH_UNKNOWN = 7,
};

enum netdev_lag_tx_type {
	NETDEV_LAG_TX_TYPE_UNKNOWN = 0,
	NETDEV_LAG_TX_TYPE_RANDOM = 1,
	NETDEV_LAG_TX_TYPE_BROADCAST = 2,
	NETDEV_LAG_TX_TYPE_ROUNDROBIN = 3,
	NETDEV_LAG_TX_TYPE_ACTIVEBACKUP = 4,
	NETDEV_LAG_TX_TYPE_HASH = 5,
};

enum netdev_ml_priv_type {
	ML_PRIV_NONE = 0,
	ML_PRIV_CAN = 1,
};

enum netdev_napi_threaded {
	NETDEV_NAPI_THREADED_DISABLED = 0,
	NETDEV_NAPI_THREADED_ENABLED = 1,
};

enum netdev_offload_xstats_type {
	NETDEV_OFFLOAD_XSTATS_TYPE_L3 = 1,
};

enum netdev_priv_flags {
	IFF_802_1Q_VLAN = 1,
	IFF_EBRIDGE = 2,
	IFF_BONDING = 4,
	IFF_ISATAP = 8,
	IFF_WAN_HDLC = 16,
	IFF_XMIT_DST_RELEASE = 32,
	IFF_DONT_BRIDGE = 64,
	IFF_DISABLE_NETPOLL = 128,
	IFF_MACVLAN_PORT = 256,
	IFF_BRIDGE_PORT = 512,
	IFF_OVS_DATAPATH = 1024,
	IFF_TX_SKB_SHARING = 2048,
	IFF_UNICAST_FLT = 4096,
	IFF_TEAM_PORT = 8192,
	IFF_SUPP_NOFCS = 16384,
	IFF_LIVE_ADDR_CHANGE = 32768,
	IFF_MACVLAN = 65536,
	IFF_XMIT_DST_RELEASE_PERM = 131072,
	IFF_L3MDEV_MASTER = 262144,
	IFF_NO_QUEUE = 524288,
	IFF_OPENVSWITCH = 1048576,
	IFF_L3MDEV_SLAVE = 2097152,
	IFF_TEAM = 4194304,
	IFF_RXFH_CONFIGURED = 8388608,
	IFF_PHONY_HEADROOM = 16777216,
	IFF_MACSEC = 33554432,
	IFF_NO_RX_HANDLER = 67108864,
	IFF_FAILOVER = 134217728,
	IFF_FAILOVER_SLAVE = 268435456,
	IFF_L3MDEV_RX_HANDLER = 536870912,
	IFF_NO_ADDRCONF = 1073741824,
	IFF_TX_SKB_NO_LINEAR = 2147483648,
};

enum netdev_qstats_scope {
	NETDEV_QSTATS_SCOPE_QUEUE = 1,
};

enum netdev_queue_state_t {
	__QUEUE_STATE_DRV_XOFF = 0,
	__QUEUE_STATE_STACK_XOFF = 1,
	__QUEUE_STATE_FROZEN = 2,
};

enum netdev_queue_type {
	NETDEV_QUEUE_TYPE_RX = 0,
	NETDEV_QUEUE_TYPE_TX = 1,
};

enum netdev_reg_state {
	NETREG_UNINITIALIZED = 0,
	NETREG_REGISTERED = 1,
	NETREG_UNREGISTERING = 2,
	NETREG_UNREGISTERED = 3,
	NETREG_RELEASED = 4,
	NETREG_DUMMY = 5,
};

enum netdev_stat_type {
	NETDEV_PCPU_STAT_NONE = 0,
	NETDEV_PCPU_STAT_LSTATS = 1,
	NETDEV_PCPU_STAT_TSTATS = 2,
	NETDEV_PCPU_STAT_DSTATS = 3,
};

enum netdev_state_t {
	__LINK_STATE_START = 0,
	__LINK_STATE_PRESENT = 1,
	__LINK_STATE_NOCARRIER = 2,
	__LINK_STATE_LINKWATCH_PENDING = 3,
	__LINK_STATE_DORMANT = 4,
	__LINK_STATE_TESTING = 5,
};

enum netdev_tx {
	__NETDEV_TX_MIN = -2147483648,
	NETDEV_TX_OK = 0,
	NETDEV_TX_BUSY = 16,
};

typedef enum netdev_tx netdev_tx_t;

enum netdev_xdp_act {
	NETDEV_XDP_ACT_BASIC = 1,
	NETDEV_XDP_ACT_REDIRECT = 2,
	NETDEV_XDP_ACT_NDO_XMIT = 4,
	NETDEV_XDP_ACT_XSK_ZEROCOPY = 8,
	NETDEV_XDP_ACT_HW_OFFLOAD = 16,
	NETDEV_XDP_ACT_RX_SG = 32,
	NETDEV_XDP_ACT_NDO_XMIT_SG = 64,
	NETDEV_XDP_ACT_MASK = 127,
};

enum netdev_xdp_rx_metadata {
	NETDEV_XDP_RX_METADATA_TIMESTAMP = 1,
	NETDEV_XDP_RX_METADATA_HASH = 2,
	NETDEV_XDP_RX_METADATA_VLAN_TAG = 4,
};

enum netdev_xsk_flags {
	NETDEV_XSK_FLAGS_TX_TIMESTAMP = 1,
	NETDEV_XSK_FLAGS_TX_CHECKSUM = 2,
	NETDEV_XSK_FLAGS_TX_LAUNCH_TIME_FIFO = 4,
};

enum netevent_notif_type {
	NETEVENT_NEIGH_UPDATE = 1,
	NETEVENT_REDIRECT = 2,
	NETEVENT_DELAY_PROBE_TIME_UPDATE = 3,
	NETEVENT_IPV4_MPATH_HASH_UPDATE = 4,
	NETEVENT_IPV6_MPATH_HASH_UPDATE = 5,
	NETEVENT_IPV4_FWD_UPDATE_PRIORITY_UPDATE = 6,
};

enum netkit_action {
	NETKIT_NEXT = -1,
	NETKIT_PASS = 0,
	NETKIT_DROP = 2,
	NETKIT_REDIRECT = 7,
};

enum netkit_mode {
	NETKIT_L2 = 0,
	NETKIT_L3 = 1,
};

enum netkit_scrub {
	NETKIT_SCRUB_NONE = 0,
	NETKIT_SCRUB_DEFAULT = 1,
};

enum netlink_attribute_type {
	NL_ATTR_TYPE_INVALID = 0,
	NL_ATTR_TYPE_FLAG = 1,
	NL_ATTR_TYPE_U8 = 2,
	NL_ATTR_TYPE_U16 = 3,
	NL_ATTR_TYPE_U32 = 4,
	NL_ATTR_TYPE_U64 = 5,
	NL_ATTR_TYPE_S8 = 6,
	NL_ATTR_TYPE_S16 = 7,
	NL_ATTR_TYPE_S32 = 8,
	NL_ATTR_TYPE_S64 = 9,
	NL_ATTR_TYPE_BINARY = 10,
	NL_ATTR_TYPE_STRING = 11,
	NL_ATTR_TYPE_NUL_STRING = 12,
	NL_ATTR_TYPE_NESTED = 13,
	NL_ATTR_TYPE_NESTED_ARRAY = 14,
	NL_ATTR_TYPE_BITFIELD32 = 15,
	NL_ATTR_TYPE_SINT = 16,
	NL_ATTR_TYPE_UINT = 17,
};

enum netlink_policy_type_attr {
	NL_POLICY_TYPE_ATTR_UNSPEC = 0,
	NL_POLICY_TYPE_ATTR_TYPE = 1,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_S = 2,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_S = 3,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_U = 4,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_U = 5,
	NL_POLICY_TYPE_ATTR_MIN_LENGTH = 6,
	NL_POLICY_TYPE_ATTR_MAX_LENGTH = 7,
	NL_POLICY_TYPE_ATTR_POLICY_IDX = 8,
	NL_POLICY_TYPE_ATTR_POLICY_MAXTYPE = 9,
	NL_POLICY_TYPE_ATTR_BITFIELD32_MASK = 10,
	NL_POLICY_TYPE_ATTR_PAD = 11,
	NL_POLICY_TYPE_ATTR_MASK = 12,
	__NL_POLICY_TYPE_ATTR_MAX = 13,
	NL_POLICY_TYPE_ATTR_MAX = 12,
};

enum netlink_skb_flags {
	NETLINK_SKB_DST = 8,
};

enum netlink_validation {
	NL_VALIDATE_LIBERAL = 0,
	NL_VALIDATE_TRAILING = 1,
	NL_VALIDATE_MAXTYPE = 2,
	NL_VALIDATE_UNSPEC = 4,
	NL_VALIDATE_STRICT_ATTRS = 8,
	NL_VALIDATE_NESTED = 16,
};

enum netns_bpf_attach_type {
	NETNS_BPF_INVALID = -1,
	NETNS_BPF_FLOW_DISSECTOR = 0,
	NETNS_BPF_SK_LOOKUP = 1,
	MAX_NETNS_BPF_ATTACH_TYPE = 2,
};

enum nexthop_event_type {
	NEXTHOP_EVENT_DEL = 0,
	NEXTHOP_EVENT_REPLACE = 1,
	NEXTHOP_EVENT_RES_TABLE_PRE_REPLACE = 2,
	NEXTHOP_EVENT_BUCKET_REPLACE = 3,
	NEXTHOP_EVENT_HW_STATS_REPORT_DELTA = 4,
};

enum nf_ct_ext_id {
	NF_CT_EXT_HELPER = 0,
	NF_CT_EXT_NAT = 1,
	NF_CT_EXT_SEQADJ = 2,
	NF_CT_EXT_ACCT = 3,
	NF_CT_EXT_ECACHE = 4,
	NF_CT_EXT_TSTAMP = 5,
	NF_CT_EXT_TIMEOUT = 6,
	NF_CT_EXT_LABELS = 7,
	NF_CT_EXT_SYNPROXY = 8,
	NF_CT_EXT_ACT_CT = 9,
	NF_CT_EXT_NUM = 10,
};

enum nf_dev_hooks {
	NF_NETDEV_INGRESS = 0,
	NF_NETDEV_EGRESS = 1,
	NF_NETDEV_NUMHOOKS = 2,
};

enum nf_hook_ops_type {
	NF_HOOK_OP_UNDEFINED = 0,
	NF_HOOK_OP_NF_TABLES = 1,
	NF_HOOK_OP_BPF = 2,
	NF_HOOK_OP_NFT_FT = 3,
};

enum nf_inet_hooks {
	NF_INET_PRE_ROUTING = 0,
	NF_INET_LOCAL_IN = 1,
	NF_INET_FORWARD = 2,
	NF_INET_LOCAL_OUT = 3,
	NF_INET_POST_ROUTING = 4,
	NF_INET_NUMHOOKS = 5,
	NF_INET_INGRESS = 5,
};

enum nf_ip6_hook_priorities {
	NF_IP6_PRI_FIRST = -2147483648,
	NF_IP6_PRI_RAW_BEFORE_DEFRAG = -450,
	NF_IP6_PRI_CONNTRACK_DEFRAG = -400,
	NF_IP6_PRI_RAW = -300,
	NF_IP6_PRI_SELINUX_FIRST = -225,
	NF_IP6_PRI_CONNTRACK = -200,
	NF_IP6_PRI_MANGLE = -150,
	NF_IP6_PRI_NAT_DST = -100,
	NF_IP6_PRI_FILTER = 0,
	NF_IP6_PRI_SECURITY = 50,
	NF_IP6_PRI_NAT_SRC = 100,
	NF_IP6_PRI_SELINUX_LAST = 225,
	NF_IP6_PRI_CONNTRACK_HELPER = 300,
	NF_IP6_PRI_LAST = 2147483647,
};

enum nf_ip_hook_priorities {
	NF_IP_PRI_FIRST = -2147483648,
	NF_IP_PRI_RAW_BEFORE_DEFRAG = -450,
	NF_IP_PRI_CONNTRACK_DEFRAG = -400,
	NF_IP_PRI_RAW = -300,
	NF_IP_PRI_SELINUX_FIRST = -225,
	NF_IP_PRI_CONNTRACK = -200,
	NF_IP_PRI_MANGLE = -150,
	NF_IP_PRI_NAT_DST = -100,
	NF_IP_PRI_FILTER = 0,
	NF_IP_PRI_SECURITY = 50,
	NF_IP_PRI_NAT_SRC = 100,
	NF_IP_PRI_SELINUX_LAST = 225,
	NF_IP_PRI_CONNTRACK_HELPER = 300,
	NF_IP_PRI_CONNTRACK_CONFIRM = 2147483647,
	NF_IP_PRI_LAST = 2147483647,
};

enum nf_log_type {
	NF_LOG_TYPE_LOG = 0,
	NF_LOG_TYPE_ULOG = 1,
	NF_LOG_TYPE_MAX = 2,
};

enum nf_nat_manip_type;

enum nfs3_stable_how {
	NFS_UNSTABLE = 0,
	NFS_DATA_SYNC = 1,
	NFS_FILE_SYNC = 2,
	NFS_INVALID_STABLE_HOW = -1,
};

enum nfs4_change_attr_type {
	NFS4_CHANGE_TYPE_IS_MONOTONIC_INCR = 0,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER = 1,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER_NOPNFS = 2,
	NFS4_CHANGE_TYPE_IS_TIME_METADATA = 3,
	NFS4_CHANGE_TYPE_IS_UNDEFINED = 4,
};

enum nfs_opnum4 {
	OP_ACCESS = 3,
	OP_CLOSE = 4,
	OP_COMMIT = 5,
	OP_CREATE = 6,
	OP_DELEGPURGE = 7,
	OP_DELEGRETURN = 8,
	OP_GETATTR = 9,
	OP_GETFH = 10,
	OP_LINK = 11,
	OP_LOCK = 12,
	OP_LOCKT = 13,
	OP_LOCKU = 14,
	OP_LOOKUP = 15,
	OP_LOOKUPP = 16,
	OP_NVERIFY = 17,
	OP_OPEN = 18,
	OP_OPENATTR = 19,
	OP_OPEN_CONFIRM = 20,
	OP_OPEN_DOWNGRADE = 21,
	OP_PUTFH = 22,
	OP_PUTPUBFH = 23,
	OP_PUTROOTFH = 24,
	OP_READ = 25,
	OP_READDIR = 26,
	OP_READLINK = 27,
	OP_REMOVE = 28,
	OP_RENAME = 29,
	OP_RENEW = 30,
	OP_RESTOREFH = 31,
	OP_SAVEFH = 32,
	OP_SECINFO = 33,
	OP_SETATTR = 34,
	OP_SETCLIENTID = 35,
	OP_SETCLIENTID_CONFIRM = 36,
	OP_VERIFY = 37,
	OP_WRITE = 38,
	OP_RELEASE_LOCKOWNER = 39,
	OP_BACKCHANNEL_CTL = 40,
	OP_BIND_CONN_TO_SESSION = 41,
	OP_EXCHANGE_ID = 42,
	OP_CREATE_SESSION = 43,
	OP_DESTROY_SESSION = 44,
	OP_FREE_STATEID = 45,
	OP_GET_DIR_DELEGATION = 46,
	OP_GETDEVICEINFO = 47,
	OP_GETDEVICELIST = 48,
	OP_LAYOUTCOMMIT = 49,
	OP_LAYOUTGET = 50,
	OP_LAYOUTRETURN = 51,
	OP_SECINFO_NO_NAME = 52,
	OP_SEQUENCE = 53,
	OP_SET_SSV = 54,
	OP_TEST_STATEID = 55,
	OP_WANT_DELEGATION = 56,
	OP_DESTROY_CLIENTID = 57,
	OP_RECLAIM_COMPLETE = 58,
	OP_ALLOCATE = 59,
	OP_COPY = 60,
	OP_COPY_NOTIFY = 61,
	OP_DEALLOCATE = 62,
	OP_IO_ADVISE = 63,
	OP_LAYOUTERROR = 64,
	OP_LAYOUTSTATS = 65,
	OP_OFFLOAD_CANCEL = 66,
	OP_OFFLOAD_STATUS = 67,
	OP_READ_PLUS = 68,
	OP_SEEK = 69,
	OP_WRITE_SAME = 70,
	OP_CLONE = 71,
	OP_GETXATTR = 72,
	OP_SETXATTR = 73,
	OP_LISTXATTRS = 74,
	OP_REMOVEXATTR = 75,
	OP_ILLEGAL = 10044,
};

enum nfs_stat {
	NFS_OK = 0,
	NFSERR_PERM = 1,
	NFSERR_NOENT = 2,
	NFSERR_IO = 5,
	NFSERR_NXIO = 6,
	NFSERR_EAGAIN = 11,
	NFSERR_ACCES = 13,
	NFSERR_EXIST = 17,
	NFSERR_XDEV = 18,
	NFSERR_NODEV = 19,
	NFSERR_NOTDIR = 20,
	NFSERR_ISDIR = 21,
	NFSERR_INVAL = 22,
	NFSERR_FBIG = 27,
	NFSERR_NOSPC = 28,
	NFSERR_ROFS = 30,
	NFSERR_MLINK = 31,
	NFSERR_NAMETOOLONG = 63,
	NFSERR_NOTEMPTY = 66,
	NFSERR_DQUOT = 69,
	NFSERR_STALE = 70,
	NFSERR_REMOTE = 71,
	NFSERR_WFLUSH = 99,
	NFSERR_BADHANDLE = 10001,
	NFSERR_NOT_SYNC = 10002,
	NFSERR_BAD_COOKIE = 10003,
	NFSERR_NOTSUPP = 10004,
	NFSERR_TOOSMALL = 10005,
	NFSERR_SERVERFAULT = 10006,
	NFSERR_BADTYPE = 10007,
	NFSERR_JUKEBOX = 10008,
	NFSERR_SAME = 10009,
	NFSERR_DENIED = 10010,
	NFSERR_EXPIRED = 10011,
	NFSERR_LOCKED = 10012,
	NFSERR_GRACE = 10013,
	NFSERR_FHEXPIRED = 10014,
	NFSERR_SHARE_DENIED = 10015,
	NFSERR_WRONGSEC = 10016,
	NFSERR_CLID_INUSE = 10017,
	NFSERR_RESOURCE = 10018,
	NFSERR_MOVED = 10019,
	NFSERR_NOFILEHANDLE = 10020,
	NFSERR_MINOR_VERS_MISMATCH = 10021,
	NFSERR_STALE_CLIENTID = 10022,
	NFSERR_STALE_STATEID = 10023,
	NFSERR_OLD_STATEID = 10024,
	NFSERR_BAD_STATEID = 10025,
	NFSERR_BAD_SEQID = 10026,
	NFSERR_NOT_SAME = 10027,
	NFSERR_LOCK_RANGE = 10028,
	NFSERR_SYMLINK = 10029,
	NFSERR_RESTOREFH = 10030,
	NFSERR_LEASE_MOVED = 10031,
	NFSERR_ATTRNOTSUPP = 10032,
	NFSERR_NO_GRACE = 10033,
	NFSERR_RECLAIM_BAD = 10034,
	NFSERR_RECLAIM_CONFLICT = 10035,
	NFSERR_BAD_XDR = 10036,
	NFSERR_LOCKS_HELD = 10037,
	NFSERR_OPENMODE = 10038,
	NFSERR_BADOWNER = 10039,
	NFSERR_BADCHAR = 10040,
	NFSERR_BADNAME = 10041,
	NFSERR_BAD_RANGE = 10042,
	NFSERR_LOCK_NOTSUPP = 10043,
	NFSERR_OP_ILLEGAL = 10044,
	NFSERR_DEADLOCK = 10045,
	NFSERR_FILE_OPEN = 10046,
	NFSERR_ADMIN_REVOKED = 10047,
	NFSERR_CB_PATH_DOWN = 10048,
};

enum nfsstat4 {
	NFS4_OK = 0,
	NFS4ERR_PERM = 1,
	NFS4ERR_NOENT = 2,
	NFS4ERR_IO = 5,
	NFS4ERR_NXIO = 6,
	NFS4ERR_ACCESS = 13,
	NFS4ERR_EXIST = 17,
	NFS4ERR_XDEV = 18,
	NFS4ERR_NOTDIR = 20,
	NFS4ERR_ISDIR = 21,
	NFS4ERR_INVAL = 22,
	NFS4ERR_FBIG = 27,
	NFS4ERR_NOSPC = 28,
	NFS4ERR_ROFS = 30,
	NFS4ERR_MLINK = 31,
	NFS4ERR_NAMETOOLONG = 63,
	NFS4ERR_NOTEMPTY = 66,
	NFS4ERR_DQUOT = 69,
	NFS4ERR_STALE = 70,
	NFS4ERR_BADHANDLE = 10001,
	NFS4ERR_BAD_COOKIE = 10003,
	NFS4ERR_NOTSUPP = 10004,
	NFS4ERR_TOOSMALL = 10005,
	NFS4ERR_SERVERFAULT = 10006,
	NFS4ERR_BADTYPE = 10007,
	NFS4ERR_DELAY = 10008,
	NFS4ERR_SAME = 10009,
	NFS4ERR_DENIED = 10010,
	NFS4ERR_EXPIRED = 10011,
	NFS4ERR_LOCKED = 10012,
	NFS4ERR_GRACE = 10013,
	NFS4ERR_FHEXPIRED = 10014,
	NFS4ERR_SHARE_DENIED = 10015,
	NFS4ERR_WRONGSEC = 10016,
	NFS4ERR_CLID_INUSE = 10017,
	NFS4ERR_RESOURCE = 10018,
	NFS4ERR_MOVED = 10019,
	NFS4ERR_NOFILEHANDLE = 10020,
	NFS4ERR_MINOR_VERS_MISMATCH = 10021,
	NFS4ERR_STALE_CLIENTID = 10022,
	NFS4ERR_STALE_STATEID = 10023,
	NFS4ERR_OLD_STATEID = 10024,
	NFS4ERR_BAD_STATEID = 10025,
	NFS4ERR_BAD_SEQID = 10026,
	NFS4ERR_NOT_SAME = 10027,
	NFS4ERR_LOCK_RANGE = 10028,
	NFS4ERR_SYMLINK = 10029,
	NFS4ERR_RESTOREFH = 10030,
	NFS4ERR_LEASE_MOVED = 10031,
	NFS4ERR_ATTRNOTSUPP = 10032,
	NFS4ERR_NO_GRACE = 10033,
	NFS4ERR_RECLAIM_BAD = 10034,
	NFS4ERR_RECLAIM_CONFLICT = 10035,
	NFS4ERR_BADXDR = 10036,
	NFS4ERR_LOCKS_HELD = 10037,
	NFS4ERR_OPENMODE = 10038,
	NFS4ERR_BADOWNER = 10039,
	NFS4ERR_BADCHAR = 10040,
	NFS4ERR_BADNAME = 10041,
	NFS4ERR_BAD_RANGE = 10042,
	NFS4ERR_LOCK_NOTSUPP = 10043,
	NFS4ERR_OP_ILLEGAL = 10044,
	NFS4ERR_DEADLOCK = 10045,
	NFS4ERR_FILE_OPEN = 10046,
	NFS4ERR_ADMIN_REVOKED = 10047,
	NFS4ERR_CB_PATH_DOWN = 10048,
	NFS4ERR_BADIOMODE = 10049,
	NFS4ERR_BADLAYOUT = 10050,
	NFS4ERR_BAD_SESSION_DIGEST = 10051,
	NFS4ERR_BADSESSION = 10052,
	NFS4ERR_BADSLOT = 10053,
	NFS4ERR_COMPLETE_ALREADY = 10054,
	NFS4ERR_CONN_NOT_BOUND_TO_SESSION = 10055,
	NFS4ERR_DELEG_ALREADY_WANTED = 10056,
	NFS4ERR_BACK_CHAN_BUSY = 10057,
	NFS4ERR_LAYOUTTRYLATER = 10058,
	NFS4ERR_LAYOUTUNAVAILABLE = 10059,
	NFS4ERR_NOMATCHING_LAYOUT = 10060,
	NFS4ERR_RECALLCONFLICT = 10061,
	NFS4ERR_UNKNOWN_LAYOUTTYPE = 10062,
	NFS4ERR_SEQ_MISORDERED = 10063,
	NFS4ERR_SEQUENCE_POS = 10064,
	NFS4ERR_REQ_TOO_BIG = 10065,
	NFS4ERR_REP_TOO_BIG = 10066,
	NFS4ERR_REP_TOO_BIG_TO_CACHE = 10067,
	NFS4ERR_RETRY_UNCACHED_REP = 10068,
	NFS4ERR_UNSAFE_COMPOUND = 10069,
	NFS4ERR_TOO_MANY_OPS = 10070,
	NFS4ERR_OP_NOT_IN_SESSION = 10071,
	NFS4ERR_HASH_ALG_UNSUPP = 10072,
	NFS4ERR_CLIENTID_BUSY = 10074,
	NFS4ERR_PNFS_IO_HOLE = 10075,
	NFS4ERR_SEQ_FALSE_RETRY = 10076,
	NFS4ERR_BAD_HIGH_SLOT = 10077,
	NFS4ERR_DEADSESSION = 10078,
	NFS4ERR_ENCR_ALG_UNSUPP = 10079,
	NFS4ERR_PNFS_NO_LAYOUT = 10080,
	NFS4ERR_NOT_ONLY_OP = 10081,
	NFS4ERR_WRONG_CRED = 10082,
	NFS4ERR_WRONG_TYPE = 10083,
	NFS4ERR_DIRDELEG_UNAVAIL = 10084,
	NFS4ERR_REJECT_DELEG = 10085,
	NFS4ERR_RETURNCONFLICT = 10086,
	NFS4ERR_DELEG_REVOKED = 10087,
	NFS4ERR_PARTNER_NOTSUPP = 10088,
	NFS4ERR_PARTNER_NO_AUTH = 10089,
	NFS4ERR_UNION_NOTSUPP = 10090,
	NFS4ERR_OFFLOAD_DENIED = 10091,
	NFS4ERR_WRONG_LFS = 10092,
	NFS4ERR_BADLABEL = 10093,
	NFS4ERR_OFFLOAD_NO_REQS = 10094,
	NFS4ERR_NOXATTR = 10095,
	NFS4ERR_XATTR2BIG = 10096,
	NFS4ERR_FIRST_FREE = 10097,
};

enum nh_notifier_info_type {
	NH_NOTIFIER_INFO_TYPE_SINGLE = 0,
	NH_NOTIFIER_INFO_TYPE_GRP = 1,
	NH_NOTIFIER_INFO_TYPE_RES_TABLE = 2,
	NH_NOTIFIER_INFO_TYPE_RES_BUCKET = 3,
	NH_NOTIFIER_INFO_TYPE_GRP_HW_STATS = 4,
};

enum nl80211_auth_type {
	NL80211_AUTHTYPE_OPEN_SYSTEM = 0,
	NL80211_AUTHTYPE_SHARED_KEY = 1,
	NL80211_AUTHTYPE_FT = 2,
	NL80211_AUTHTYPE_NETWORK_EAP = 3,
	NL80211_AUTHTYPE_SAE = 4,
	NL80211_AUTHTYPE_FILS_SK = 5,
	NL80211_AUTHTYPE_FILS_SK_PFS = 6,
	NL80211_AUTHTYPE_FILS_PK = 7,
	__NL80211_AUTHTYPE_NUM = 8,
	NL80211_AUTHTYPE_MAX = 7,
	NL80211_AUTHTYPE_AUTOMATIC = 8,
};

enum nl80211_band {
	NL80211_BAND_2GHZ = 0,
	NL80211_BAND_5GHZ = 1,
	NL80211_BAND_60GHZ = 2,
	NL80211_BAND_6GHZ = 3,
	NL80211_BAND_S1GHZ = 4,
	NL80211_BAND_LC = 5,
	NUM_NL80211_BANDS = 6,
};

enum nl80211_bss_select_attr {
	__NL80211_BSS_SELECT_ATTR_INVALID = 0,
	NL80211_BSS_SELECT_ATTR_RSSI = 1,
	NL80211_BSS_SELECT_ATTR_BAND_PREF = 2,
	NL80211_BSS_SELECT_ATTR_RSSI_ADJUST = 3,
	__NL80211_BSS_SELECT_ATTR_AFTER_LAST = 4,
	NL80211_BSS_SELECT_ATTR_MAX = 3,
};

enum nl80211_chan_width {
	NL80211_CHAN_WIDTH_20_NOHT = 0,
	NL80211_CHAN_WIDTH_20 = 1,
	NL80211_CHAN_WIDTH_40 = 2,
	NL80211_CHAN_WIDTH_80 = 3,
	NL80211_CHAN_WIDTH_80P80 = 4,
	NL80211_CHAN_WIDTH_160 = 5,
	NL80211_CHAN_WIDTH_5 = 6,
	NL80211_CHAN_WIDTH_10 = 7,
	NL80211_CHAN_WIDTH_1 = 8,
	NL80211_CHAN_WIDTH_2 = 9,
	NL80211_CHAN_WIDTH_4 = 10,
	NL80211_CHAN_WIDTH_8 = 11,
	NL80211_CHAN_WIDTH_16 = 12,
	NL80211_CHAN_WIDTH_320 = 13,
};

enum nl80211_dfs_regions {
	NL80211_DFS_UNSET = 0,
	NL80211_DFS_FCC = 1,
	NL80211_DFS_ETSI = 2,
	NL80211_DFS_JP = 3,
};

enum nl80211_dfs_state {
	NL80211_DFS_USABLE = 0,
	NL80211_DFS_UNAVAILABLE = 1,
	NL80211_DFS_AVAILABLE = 2,
};

enum nl80211_iftype {
	NL80211_IFTYPE_UNSPECIFIED = 0,
	NL80211_IFTYPE_ADHOC = 1,
	NL80211_IFTYPE_STATION = 2,
	NL80211_IFTYPE_AP = 3,
	NL80211_IFTYPE_AP_VLAN = 4,
	NL80211_IFTYPE_WDS = 5,
	NL80211_IFTYPE_MONITOR = 6,
	NL80211_IFTYPE_MESH_POINT = 7,
	NL80211_IFTYPE_P2P_CLIENT = 8,
	NL80211_IFTYPE_P2P_GO = 9,
	NL80211_IFTYPE_P2P_DEVICE = 10,
	NL80211_IFTYPE_OCB = 11,
	NL80211_IFTYPE_NAN = 12,
	NUM_NL80211_IFTYPES = 13,
	NL80211_IFTYPE_MAX = 12,
};

enum nl80211_key_mode {
	NL80211_KEY_RX_TX = 0,
	NL80211_KEY_NO_TX = 1,
	NL80211_KEY_SET_TX = 2,
};

enum nl80211_mfp {
	NL80211_MFP_NO = 0,
	NL80211_MFP_REQUIRED = 1,
	NL80211_MFP_OPTIONAL = 2,
};

enum nl80211_reg_initiator {
	NL80211_REGDOM_SET_BY_CORE = 0,
	NL80211_REGDOM_SET_BY_USER = 1,
	NL80211_REGDOM_SET_BY_DRIVER = 2,
	NL80211_REGDOM_SET_BY_COUNTRY_IE = 3,
};

enum nl80211_sae_pwe_mechanism {
	NL80211_SAE_PWE_UNSPECIFIED = 0,
	NL80211_SAE_PWE_HUNT_AND_PECK = 1,
	NL80211_SAE_PWE_HASH_TO_ELEMENT = 2,
	NL80211_SAE_PWE_BOTH = 3,
};

enum nl80211_sar_type {
	NL80211_SAR_TYPE_POWER = 0,
	NUM_NL80211_SAR_TYPE = 1,
};

enum nl80211_user_reg_hint_type {
	NL80211_USER_REG_HINT_USER = 0,
	NL80211_USER_REG_HINT_CELL_BASE = 1,
	NL80211_USER_REG_HINT_INDOOR = 2,
};

enum nl802154_cca_modes {
	__NL802154_CCA_INVALID = 0,
	NL802154_CCA_ENERGY = 1,
	NL802154_CCA_CARRIER = 2,
	NL802154_CCA_ENERGY_CARRIER = 3,
	NL802154_CCA_ALOHA = 4,
	NL802154_CCA_UWB_SHR = 5,
	NL802154_CCA_UWB_MULTIPLEXED = 6,
	__NL802154_CCA_ATTR_AFTER_LAST = 7,
	NL802154_CCA_ATTR_MAX = 6,
};

enum nl802154_cca_opts {
	NL802154_CCA_OPT_ENERGY_CARRIER_AND = 0,
	NL802154_CCA_OPT_ENERGY_CARRIER_OR = 1,
	__NL802154_CCA_OPT_ATTR_AFTER_LAST = 2,
	NL802154_CCA_OPT_ATTR_MAX = 1,
};

enum nl802154_supported_bool_states {
	NL802154_SUPPORTED_BOOL_FALSE = 0,
	NL802154_SUPPORTED_BOOL_TRUE = 1,
	__NL802154_SUPPORTED_BOOL_INVALD = 2,
	NL802154_SUPPORTED_BOOL_BOTH = 3,
	__NL802154_SUPPORTED_BOOL_AFTER_LAST = 4,
	NL802154_SUPPORTED_BOOL_MAX = 3,
};

enum nla_policy_validation {
	NLA_VALIDATE_NONE = 0,
	NLA_VALIDATE_RANGE = 1,
	NLA_VALIDATE_RANGE_WARN_TOO_LONG = 2,
	NLA_VALIDATE_MIN = 3,
	NLA_VALIDATE_MAX = 4,
	NLA_VALIDATE_MASK = 5,
	NLA_VALIDATE_RANGE_PTR = 6,
	NLA_VALIDATE_FUNCTION = 7,
};

enum nlmsgerr_attrs {
	NLMSGERR_ATTR_UNUSED = 0,
	NLMSGERR_ATTR_MSG = 1,
	NLMSGERR_ATTR_OFFS = 2,
	NLMSGERR_ATTR_COOKIE = 3,
	NLMSGERR_ATTR_POLICY = 4,
	NLMSGERR_ATTR_MISS_TYPE = 5,
	NLMSGERR_ATTR_MISS_NEST = 6,
	__NLMSGERR_ATTR_MAX = 7,
	NLMSGERR_ATTR_MAX = 6,
};

enum nmi_states {
	NMI_NOT_RUNNING = 0,
	NMI_EXECUTING = 1,
	NMI_LATCHED = 2,
};

enum node_stat_item {
	NR_LRU_BASE = 0,
	NR_INACTIVE_ANON = 0,
	NR_ACTIVE_ANON = 1,
	NR_INACTIVE_FILE = 2,
	NR_ACTIVE_FILE = 3,
	NR_UNEVICTABLE = 4,
	NR_SLAB_RECLAIMABLE_B = 5,
	NR_SLAB_UNRECLAIMABLE_B = 6,
	NR_ISOLATED_ANON = 7,
	NR_ISOLATED_FILE = 8,
	WORKINGSET_NODES = 9,
	WORKINGSET_REFAULT_BASE = 10,
	WORKINGSET_REFAULT_ANON = 10,
	WORKINGSET_REFAULT_FILE = 11,
	WORKINGSET_ACTIVATE_BASE = 12,
	WORKINGSET_ACTIVATE_ANON = 12,
	WORKINGSET_ACTIVATE_FILE = 13,
	WORKINGSET_RESTORE_BASE = 14,
	WORKINGSET_RESTORE_ANON = 14,
	WORKINGSET_RESTORE_FILE = 15,
	WORKINGSET_NODERECLAIM = 16,
	NR_ANON_MAPPED = 17,
	NR_FILE_MAPPED = 18,
	NR_FILE_PAGES = 19,
	NR_FILE_DIRTY = 20,
	NR_WRITEBACK = 21,
	NR_SHMEM = 22,
	NR_SHMEM_THPS = 23,
	NR_SHMEM_PMDMAPPED = 24,
	NR_FILE_THPS = 25,
	NR_FILE_PMDMAPPED = 26,
	NR_ANON_THPS = 27,
	NR_VMSCAN_WRITE = 28,
	NR_VMSCAN_IMMEDIATE = 29,
	NR_DIRTIED = 30,
	NR_WRITTEN = 31,
	NR_THROTTLED_WRITTEN = 32,
	NR_KERNEL_MISC_RECLAIMABLE = 33,
	NR_FOLL_PIN_ACQUIRED = 34,
	NR_FOLL_PIN_RELEASED = 35,
	NR_KERNEL_STACK_KB = 36,
	NR_PAGETABLE = 37,
	NR_SECONDARY_PAGETABLE = 38,
	NR_IOMMU_PAGES = 39,
	NR_SWAPCACHE = 40,
	PGPROMOTE_SUCCESS = 41,
	PGPROMOTE_CANDIDATE = 42,
	PGDEMOTE_KSWAPD = 43,
	PGDEMOTE_DIRECT = 44,
	PGDEMOTE_KHUGEPAGED = 45,
	PGDEMOTE_PROACTIVE = 46,
	NR_HUGETLB = 47,
	NR_BALLOON_PAGES = 48,
	NR_VM_NODE_STAT_ITEMS = 49,
};

enum node_states {
	N_POSSIBLE = 0,
	N_ONLINE = 1,
	N_NORMAL_MEMORY = 2,
	N_HIGH_MEMORY = 2,
	N_MEMORY = 3,
	N_CPU = 4,
	N_GENERIC_INITIATOR = 5,
	NR_NODE_STATES = 6,
};

enum notify_state {
	SECCOMP_NOTIFY_INIT = 0,
	SECCOMP_NOTIFY_SENT = 1,
	SECCOMP_NOTIFY_REPLIED = 2,
};

enum numa_faults_stats {
	NUMA_MEM = 0,
	NUMA_CPU = 1,
	NUMA_MEMBUF = 2,
	NUMA_CPUBUF = 3,
};

enum numa_stat_item {
	NUMA_HIT = 0,
	NUMA_MISS = 1,
	NUMA_FOREIGN = 2,
	NUMA_INTERLEAVE_HIT = 3,
	NUMA_LOCAL = 4,
	NUMA_OTHER = 5,
	NR_VM_NUMA_EVENT_ITEMS = 6,
};

enum numa_topology_type {
	NUMA_DIRECT = 0,
	NUMA_GLUELESS_MESH = 1,
	NUMA_BACKPLANE = 2,
};

enum numa_type {
	node_has_spare = 0,
	node_fully_busy = 1,
	node_overloaded = 2,
};

enum numa_vmaskip_reason {
	NUMAB_SKIP_UNSUITABLE = 0,
	NUMAB_SKIP_SHARED_RO = 1,
	NUMAB_SKIP_INACCESSIBLE = 2,
	NUMAB_SKIP_SCAN_DELAY = 3,
	NUMAB_SKIP_PID_INACTIVE = 4,
	NUMAB_SKIP_IGNORE_PID = 5,
	NUMAB_SKIP_SEQ_COMPLETED = 6,
};

enum nvmem_type {
	NVMEM_TYPE_UNKNOWN = 0,
	NVMEM_TYPE_EEPROM = 1,
	NVMEM_TYPE_OTP = 2,
	NVMEM_TYPE_BATTERY_BACKED = 3,
	NVMEM_TYPE_FRAM = 4,
};

enum objext_flags {
	OBJEXTS_ALLOC_FAIL = 4,
	__NR_OBJEXTS_FLAGS = 8,
};

enum odd_mech_type {
	ODD_MECH_TYPE_SLOT = 0,
	ODD_MECH_TYPE_DRAWER = 1,
	ODD_MECH_TYPE_UNSUPPORTED = 2,
};

enum offload_act_command {
	FLOW_ACT_REPLACE = 0,
	FLOW_ACT_DESTROY = 1,
	FLOW_ACT_STATS = 2,
};

enum ohci_rh_state {
	OHCI_RH_HALTED = 0,
	OHCI_RH_SUSPENDED = 1,
	OHCI_RH_RUNNING = 2,
};

enum oom_constraint {
	CONSTRAINT_NONE = 0,
	CONSTRAINT_CPUSET = 1,
	CONSTRAINT_MEMORY_POLICY = 2,
	CONSTRAINT_MEMCG = 3,
};

enum opal_atom_width {
	OPAL_WIDTH_TINY = 0,
	OPAL_WIDTH_SHORT = 1,
	OPAL_WIDTH_MEDIUM = 2,
	OPAL_WIDTH_LONG = 3,
	OPAL_WIDTH_TOKEN = 4,
};

enum opal_key_type {
	OPAL_INCLUDED = 0,
	OPAL_KEYRING = 1,
};

enum opal_lock_flags {
	OPAL_SAVE_FOR_LOCK = 1,
};

enum opal_lock_state {
	OPAL_RO = 1,
	OPAL_RW = 2,
	OPAL_LK = 4,
};

enum opal_mbr {
	OPAL_MBR_ENABLE = 0,
	OPAL_MBR_DISABLE = 1,
};

enum opal_mbr_done_flag {
	OPAL_MBR_NOT_DONE = 0,
	OPAL_MBR_DONE = 1,
};

enum opal_method {
	OPAL_PROPERTIES = 0,
	OPAL_STARTSESSION = 1,
	OPAL_REVERT = 2,
	OPAL_ACTIVATE = 3,
	OPAL_EGET = 4,
	OPAL_ESET = 5,
	OPAL_NEXT = 6,
	OPAL_EAUTHENTICATE = 7,
	OPAL_GETACL = 8,
	OPAL_GENKEY = 9,
	OPAL_REVERTSP = 10,
	OPAL_GET = 11,
	OPAL_SET = 12,
	OPAL_AUTHENTICATE = 13,
	OPAL_RANDOM = 14,
	OPAL_ERASE = 15,
};

enum opal_parameter {
	OPAL_SUM_SET_LIST = 393216,
};

enum opal_response_token {
	OPAL_DTA_TOKENID_BYTESTRING = 224,
	OPAL_DTA_TOKENID_SINT = 225,
	OPAL_DTA_TOKENID_UINT = 226,
	OPAL_DTA_TOKENID_TOKEN = 227,
	OPAL_DTA_TOKENID_INVALID = 0,
};

enum opal_revert_lsp_opts {
	OPAL_PRESERVE = 1,
};

enum opal_revertlsp {
	OPAL_KEEP_GLOBAL_RANGE_KEY = 393216,
};

enum opal_table_ops {
	OPAL_READ_TABLE = 0,
	OPAL_WRITE_TABLE = 1,
};

enum opal_token {
	OPAL_TRUE = 1,
	OPAL_FALSE = 0,
	OPAL_BOOLEAN_EXPR = 3,
	OPAL_TABLE = 0,
	OPAL_STARTROW = 1,
	OPAL_ENDROW = 2,
	OPAL_STARTCOLUMN = 3,
	OPAL_ENDCOLUMN = 4,
	OPAL_VALUES = 1,
	OPAL_TABLE_UID = 0,
	OPAL_TABLE_NAME = 1,
	OPAL_TABLE_COMMON = 2,
	OPAL_TABLE_TEMPLATE = 3,
	OPAL_TABLE_KIND = 4,
	OPAL_TABLE_COLUMN = 5,
	OPAL_TABLE_COLUMNS = 6,
	OPAL_TABLE_ROWS = 7,
	OPAL_TABLE_ROWS_FREE = 8,
	OPAL_TABLE_ROW_BYTES = 9,
	OPAL_TABLE_LASTID = 10,
	OPAL_TABLE_MIN = 11,
	OPAL_TABLE_MAX = 12,
	OPAL_PIN = 3,
	OPAL_RANGESTART = 3,
	OPAL_RANGELENGTH = 4,
	OPAL_READLOCKENABLED = 5,
	OPAL_WRITELOCKENABLED = 6,
	OPAL_READLOCKED = 7,
	OPAL_WRITELOCKED = 8,
	OPAL_ACTIVEKEY = 10,
	OPAL_LIFECYCLE = 6,
	OPAL_MAXRANGES = 4,
	OPAL_MBRENABLE = 1,
	OPAL_MBRDONE = 2,
	OPAL_HOSTPROPERTIES = 0,
	OPAL_STARTLIST = 240,
	OPAL_ENDLIST = 241,
	OPAL_STARTNAME = 242,
	OPAL_ENDNAME = 243,
	OPAL_CALL = 248,
	OPAL_ENDOFDATA = 249,
	OPAL_ENDOFSESSION = 250,
	OPAL_STARTTRANSACTON = 251,
	OPAL_ENDTRANSACTON = 252,
	OPAL_EMPTYATOM = 255,
	OPAL_WHERE = 0,
};

enum opal_uid {
	OPAL_SMUID_UID = 0,
	OPAL_THISSP_UID = 1,
	OPAL_ADMINSP_UID = 2,
	OPAL_LOCKINGSP_UID = 3,
	OPAL_ENTERPRISE_LOCKINGSP_UID = 4,
	OPAL_ANYBODY_UID = 5,
	OPAL_SID_UID = 6,
	OPAL_ADMIN1_UID = 7,
	OPAL_USER1_UID = 8,
	OPAL_USER2_UID = 9,
	OPAL_PSID_UID = 10,
	OPAL_ENTERPRISE_BANDMASTER0_UID = 11,
	OPAL_ENTERPRISE_ERASEMASTER_UID = 12,
	OPAL_TABLE_TABLE = 13,
	OPAL_LOCKINGRANGE_GLOBAL = 14,
	OPAL_LOCKINGRANGE_ACE_START_TO_KEY = 15,
	OPAL_LOCKINGRANGE_ACE_RDLOCKED = 16,
	OPAL_LOCKINGRANGE_ACE_WRLOCKED = 17,
	OPAL_MBRCONTROL = 18,
	OPAL_MBR = 19,
	OPAL_AUTHORITY_TABLE = 20,
	OPAL_C_PIN_TABLE = 21,
	OPAL_LOCKING_INFO_TABLE = 22,
	OPAL_ENTERPRISE_LOCKING_INFO_TABLE = 23,
	OPAL_DATASTORE = 24,
	OPAL_C_PIN_MSID = 25,
	OPAL_C_PIN_SID = 26,
	OPAL_C_PIN_ADMIN1 = 27,
	OPAL_HALF_UID_AUTHORITY_OBJ_REF = 28,
	OPAL_HALF_UID_BOOLEAN_ACE = 29,
	OPAL_UID_HEXFF = 30,
};

enum opal_user {
	OPAL_ADMIN1 = 0,
	OPAL_USER1 = 1,
	OPAL_USER2 = 2,
	OPAL_USER3 = 3,
	OPAL_USER4 = 4,
	OPAL_USER5 = 5,
	OPAL_USER6 = 6,
	OPAL_USER7 = 7,
	OPAL_USER8 = 8,
	OPAL_USER9 = 9,
};

enum opp_table_access {
	OPP_TABLE_ACCESS_UNKNOWN = 0,
	OPP_TABLE_ACCESS_EXCLUSIVE = 1,
	OPP_TABLE_ACCESS_SHARED = 2,
};

enum osnoise_options_index {
	OSN_DEFAULTS = 0,
	OSN_WORKLOAD = 1,
	OSN_PANIC_ON_STOP = 2,
	OSN_PREEMPT_DISABLE = 3,
	OSN_IRQ_DISABLE = 4,
	OSN_MAX = 5,
};

enum owner_state {
	OWNER_NULL = 1,
	OWNER_WRITER = 2,
	OWNER_READER = 4,
	OWNER_NONSPINNABLE = 8,
};

enum packet_sock_flags {
	PACKET_SOCK_ORIGDEV = 0,
	PACKET_SOCK_AUXDATA = 1,
	PACKET_SOCK_TX_HAS_OFF = 2,
	PACKET_SOCK_TP_LOSS = 3,
	PACKET_SOCK_RUNNING = 4,
	PACKET_SOCK_PRESSURE = 5,
	PACKET_SOCK_QDISC_BYPASS = 6,
};

enum packing_op {
	PACK = 0,
	UNPACK = 1,
};

enum page_cache_mode {
	_PAGE_CACHE_MODE_WB = 0,
	_PAGE_CACHE_MODE_WC = 1,
	_PAGE_CACHE_MODE_UC_MINUS = 2,
	_PAGE_CACHE_MODE_UC = 3,
	_PAGE_CACHE_MODE_WT = 4,
	_PAGE_CACHE_MODE_WP = 5,
	_PAGE_CACHE_MODE_NUM = 8,
};

enum page_memcg_data_flags {
	MEMCG_DATA_OBJEXTS = 1,
	MEMCG_DATA_KMEM = 2,
	__NR_MEMCG_DATA_FLAGS = 4,
};

enum page_size_enum {
	__PAGE_SIZE = 4096,
};

enum page_walk_action {
	ACTION_SUBTREE = 0,
	ACTION_CONTINUE = 1,
	ACTION_AGAIN = 2,
};

enum page_walk_lock {
	PGWALK_RDLOCK = 0,
	PGWALK_WRLOCK = 1,
	PGWALK_WRLOCK_VERIFY = 2,
	PGWALK_VMA_RDLOCK_VERIFY = 3,
};

enum pageblock_bits {
	PB_migrate = 0,
	PB_migrate_end = 2,
	PB_compact_skip = 3,
	PB_migrate_isolate = 4,
	__NR_PAGEBLOCK_BITS = 5,
};

enum pageflags {
	PG_locked = 0,
	PG_writeback = 1,
	PG_referenced = 2,
	PG_uptodate = 3,
	PG_dirty = 4,
	PG_lru = 5,
	PG_head = 6,
	PG_waiters = 7,
	PG_active = 8,
	PG_workingset = 9,
	PG_owner_priv_1 = 10,
	PG_owner_2 = 11,
	PG_arch_1 = 12,
	PG_reserved = 13,
	PG_private = 14,
	PG_private_2 = 15,
	PG_reclaim = 16,
	PG_swapbacked = 17,
	PG_unevictable = 18,
	PG_dropbehind = 19,
	PG_mlocked = 20,
	PG_hwpoison = 21,
	PG_young = 22,
	PG_idle = 23,
	PG_arch_2 = 24,
	__NR_PAGEFLAGS = 25,
	PG_readahead = 16,
	PG_swapcache = 10,
	PG_checked = 10,
	PG_anon_exclusive = 11,
	PG_mappedtodisk = 11,
	PG_fscache = 15,
	PG_pinned = 10,
	PG_savepinned = 4,
	PG_foreign = 10,
	PG_xen_remapped = 10,
	PG_movable_ops_isolated = 16,
	PG_movable_ops = 3,
	PG_reported = 3,
	PG_vmemmap_self_hosted = 10,
	PG_has_hwpoisoned = 8,
	PG_large_rmappable = 9,
	PG_partially_mapped = 16,
};

enum pagetype {
	PGTY_buddy = 240,
	PGTY_offline = 241,
	PGTY_table = 242,
	PGTY_guard = 243,
	PGTY_hugetlb = 244,
	PGTY_slab = 245,
	PGTY_zsmalloc = 246,
	PGTY_unaccepted = 247,
	PGTY_large_kmalloc = 248,
	PGTY_mapcount_underflow = 255,
};

enum partition_cmd {
	partcmd_enable = 0,
	partcmd_enablei = 1,
	partcmd_disable = 2,
	partcmd_update = 3,
	partcmd_invalidate = 4,
};

enum path_flags {
	PATH_IS_DIR = 1,
	PATH_SOCK_COND = 2,
	PATH_CONNECT_PATH = 4,
	PATH_CHROOT_REL = 8,
	PATH_CHROOT_NSCONNECT = 16,
	PATH_DELEGATE_DELETED = 65536,
	PATH_MEDIATE_DELETED = 131072,
};

enum pb_isolate_mode {
	PB_ISOLATE_MODE_MEM_OFFLINE = 0,
	PB_ISOLATE_MODE_CMA_ALLOC = 1,
	PB_ISOLATE_MODE_OTHER = 2,
};

enum pce_status {
	PCE_STATUS_NONE = 0,
	PCE_STATUS_ACQUIRED = 1,
	PCE_STATUS_PREPARED = 2,
	PCE_STATUS_ENABLED = 3,
	PCE_STATUS_ERROR = 4,
};

enum pci_bar_type {
	pci_bar_unknown = 0,
	pci_bar_io = 1,
	pci_bar_mem32 = 2,
	pci_bar_mem64 = 3,
};

enum pci_barno {
	NO_BAR = -1,
	BAR_0 = 0,
	BAR_1 = 1,
	BAR_2 = 2,
	BAR_3 = 3,
	BAR_4 = 4,
	BAR_5 = 5,
};

enum pci_bf_sort_state {
	pci_bf_sort_default = 0,
	pci_force_nobf = 1,
	pci_force_bf = 2,
	pci_dmi_bf = 3,
};

enum pci_board_num_t {
	pbn_default = 0,
	pbn_b0_1_115200 = 1,
	pbn_b0_2_115200 = 2,
	pbn_b0_4_115200 = 3,
	pbn_b0_5_115200 = 4,
	pbn_b0_8_115200 = 5,
	pbn_b0_1_921600 = 6,
	pbn_b0_2_921600 = 7,
	pbn_b0_4_921600 = 8,
	pbn_b0_2_1130000 = 9,
	pbn_b0_4_1152000 = 10,
	pbn_b0_4_1250000 = 11,
	pbn_b0_2_1843200 = 12,
	pbn_b0_4_1843200 = 13,
	pbn_b0_1_15625000 = 14,
	pbn_b0_bt_1_115200 = 15,
	pbn_b0_bt_2_115200 = 16,
	pbn_b0_bt_4_115200 = 17,
	pbn_b0_bt_8_115200 = 18,
	pbn_b0_bt_1_460800 = 19,
	pbn_b0_bt_2_460800 = 20,
	pbn_b0_bt_4_460800 = 21,
	pbn_b0_bt_1_921600 = 22,
	pbn_b0_bt_2_921600 = 23,
	pbn_b0_bt_4_921600 = 24,
	pbn_b0_bt_8_921600 = 25,
	pbn_b1_1_115200 = 26,
	pbn_b1_2_115200 = 27,
	pbn_b1_4_115200 = 28,
	pbn_b1_8_115200 = 29,
	pbn_b1_16_115200 = 30,
	pbn_b1_1_921600 = 31,
	pbn_b1_2_921600 = 32,
	pbn_b1_4_921600 = 33,
	pbn_b1_8_921600 = 34,
	pbn_b1_2_1250000 = 35,
	pbn_b1_bt_1_115200 = 36,
	pbn_b1_bt_2_115200 = 37,
	pbn_b1_bt_4_115200 = 38,
	pbn_b1_bt_2_921600 = 39,
	pbn_b1_1_1382400 = 40,
	pbn_b1_2_1382400 = 41,
	pbn_b1_4_1382400 = 42,
	pbn_b1_8_1382400 = 43,
	pbn_b2_1_115200 = 44,
	pbn_b2_2_115200 = 45,
	pbn_b2_4_115200 = 46,
	pbn_b2_8_115200 = 47,
	pbn_b2_1_460800 = 48,
	pbn_b2_4_460800 = 49,
	pbn_b2_8_460800 = 50,
	pbn_b2_16_460800 = 51,
	pbn_b2_1_921600 = 52,
	pbn_b2_4_921600 = 53,
	pbn_b2_8_921600 = 54,
	pbn_b2_8_1152000 = 55,
	pbn_b2_bt_1_115200 = 56,
	pbn_b2_bt_2_115200 = 57,
	pbn_b2_bt_4_115200 = 58,
	pbn_b2_bt_2_921600 = 59,
	pbn_b2_bt_4_921600 = 60,
	pbn_b3_2_115200 = 61,
	pbn_b3_4_115200 = 62,
	pbn_b3_8_115200 = 63,
	pbn_b4_bt_2_921600 = 64,
	pbn_b4_bt_4_921600 = 65,
	pbn_b4_bt_8_921600 = 66,
	pbn_panacom = 67,
	pbn_panacom2 = 68,
	pbn_panacom4 = 69,
	pbn_plx_romulus = 70,
	pbn_oxsemi = 71,
	pbn_oxsemi_1_15625000 = 72,
	pbn_oxsemi_2_15625000 = 73,
	pbn_oxsemi_4_15625000 = 74,
	pbn_oxsemi_8_15625000 = 75,
	pbn_intel_i960 = 76,
	pbn_sgi_ioc3 = 77,
	pbn_computone_4 = 78,
	pbn_computone_6 = 79,
	pbn_computone_8 = 80,
	pbn_sbsxrsio = 81,
	pbn_pasemi_1682M = 82,
	pbn_ni8430_2 = 83,
	pbn_ni8430_4 = 84,
	pbn_ni8430_8 = 85,
	pbn_ni8430_16 = 86,
	pbn_ADDIDATA_PCIe_1_3906250 = 87,
	pbn_ADDIDATA_PCIe_2_3906250 = 88,
	pbn_ADDIDATA_PCIe_4_3906250 = 89,
	pbn_ADDIDATA_PCIe_8_3906250 = 90,
	pbn_ce4100_1_115200 = 91,
	pbn_omegapci = 92,
	pbn_NETMOS9900_2s_115200 = 93,
	pbn_brcm_trumanage = 94,
	pbn_fintek_4 = 95,
	pbn_fintek_8 = 96,
	pbn_fintek_12 = 97,
	pbn_fintek_F81504A = 98,
	pbn_fintek_F81508A = 99,
	pbn_fintek_F81512A = 100,
	pbn_wch382_2 = 101,
	pbn_wch384_4 = 102,
	pbn_wch384_8 = 103,
	pbn_sunix_pci_1s = 104,
	pbn_sunix_pci_2s = 105,
	pbn_sunix_pci_4s = 106,
	pbn_sunix_pci_8s = 107,
	pbn_sunix_pci_16s = 108,
	pbn_titan_1_4000000 = 109,
	pbn_titan_2_4000000 = 110,
	pbn_titan_4_4000000 = 111,
	pbn_titan_8_4000000 = 112,
	pbn_moxa_2 = 113,
	pbn_moxa_4 = 114,
	pbn_moxa_8 = 115,
};

enum pci_bus_flags {
	PCI_BUS_FLAGS_NO_MSI = 1,
	PCI_BUS_FLAGS_NO_MMRBC = 2,
	PCI_BUS_FLAGS_NO_AERSID = 4,
	PCI_BUS_FLAGS_NO_EXTCFG = 8,
};

enum pci_bus_speed {
	PCI_SPEED_33MHz = 0,
	PCI_SPEED_66MHz = 1,
	PCI_SPEED_66MHz_PCIX = 2,
	PCI_SPEED_100MHz_PCIX = 3,
	PCI_SPEED_133MHz_PCIX = 4,
	PCI_SPEED_66MHz_PCIX_ECC = 5,
	PCI_SPEED_100MHz_PCIX_ECC = 6,
	PCI_SPEED_133MHz_PCIX_ECC = 7,
	PCI_SPEED_66MHz_PCIX_266 = 9,
	PCI_SPEED_100MHz_PCIX_266 = 10,
	PCI_SPEED_133MHz_PCIX_266 = 11,
	AGP_UNKNOWN = 12,
	AGP_1X = 13,
	AGP_2X = 14,
	AGP_4X = 15,
	AGP_8X = 16,
	PCI_SPEED_66MHz_PCIX_533 = 17,
	PCI_SPEED_100MHz_PCIX_533 = 18,
	PCI_SPEED_133MHz_PCIX_533 = 19,
	PCIE_SPEED_2_5GT = 20,
	PCIE_SPEED_5_0GT = 21,
	PCIE_SPEED_8_0GT = 22,
	PCIE_SPEED_16_0GT = 23,
	PCIE_SPEED_32_0GT = 24,
	PCIE_SPEED_64_0GT = 25,
	PCI_SPEED_UNKNOWN = 255,
};

enum pci_dev_flags {
	PCI_DEV_FLAGS_MSI_INTX_DISABLE_BUG = 1,
	PCI_DEV_FLAGS_NO_D3 = 2,
	PCI_DEV_FLAGS_ASSIGNED = 4,
	PCI_DEV_FLAGS_ACS_ENABLED_QUIRK = 8,
	PCI_DEV_FLAG_PCIE_BRIDGE_ALIAS = 32,
	PCI_DEV_FLAGS_NO_BUS_RESET = 64,
	PCI_DEV_FLAGS_NO_PM_RESET = 128,
	PCI_DEV_FLAGS_VPD_REF_F0 = 256,
	PCI_DEV_FLAGS_BRIDGE_XLATE_ROOT = 512,
	PCI_DEV_FLAGS_NO_FLR_RESET = 1024,
	PCI_DEV_FLAGS_NO_RELAXED_ORDERING = 2048,
	PCI_DEV_FLAGS_HAS_MSI_MASKING = 4096,
	PCI_DEV_FLAGS_MSIX_TOUCH_ENTRY_DATA_FIRST = 8192,
};

enum pci_epc_bar_type {
	BAR_PROGRAMMABLE = 0,
	BAR_FIXED = 1,
	BAR_RESIZABLE = 2,
	BAR_RESERVED = 3,
};

enum pci_ers_result {
	PCI_ERS_RESULT_NONE = 1,
	PCI_ERS_RESULT_CAN_RECOVER = 2,
	PCI_ERS_RESULT_NEED_RESET = 3,
	PCI_ERS_RESULT_DISCONNECT = 4,
	PCI_ERS_RESULT_RECOVERED = 5,
	PCI_ERS_RESULT_NO_AER_DRIVER = 6,
};

enum pci_fixup_pass {
	pci_fixup_early = 0,
	pci_fixup_header = 1,
	pci_fixup_final = 2,
	pci_fixup_enable = 3,
	pci_fixup_resume = 4,
	pci_fixup_suspend = 5,
	pci_fixup_resume_early = 6,
	pci_fixup_suspend_late = 7,
};

enum pci_interrupt_pin {
	PCI_INTERRUPT_UNKNOWN = 0,
	PCI_INTERRUPT_INTA = 1,
	PCI_INTERRUPT_INTB = 2,
	PCI_INTERRUPT_INTC = 3,
	PCI_INTERRUPT_INTD = 4,
};

enum pci_irq_reroute_variant {
	INTEL_IRQ_REROUTE_VARIANT = 1,
	MAX_IRQ_REROUTE_VARIANTS = 3,
};

enum pci_mmap_api {
	PCI_MMAP_SYSFS = 0,
	PCI_MMAP_PROCFS = 1,
};

enum pci_mmap_state {
	pci_mmap_io = 0,
	pci_mmap_mem = 1,
};

enum pci_p2pdma_map_type {
	PCI_P2PDMA_MAP_UNKNOWN = 0,
	PCI_P2PDMA_MAP_NONE = 1,
	PCI_P2PDMA_MAP_NOT_SUPPORTED = 2,
	PCI_P2PDMA_MAP_BUS_ADDR = 3,
	PCI_P2PDMA_MAP_THRU_HOST_BRIDGE = 4,
};

enum pcie_bus_config_types {
	PCIE_BUS_TUNE_OFF = 0,
	PCIE_BUS_DEFAULT = 1,
	PCIE_BUS_SAFE = 2,
	PCIE_BUS_PERFORMANCE = 3,
	PCIE_BUS_PEER2PEER = 4,
};

enum pcie_link_width {
	PCIE_LNK_WIDTH_RESRV = 0,
	PCIE_LNK_X1 = 1,
	PCIE_LNK_X2 = 2,
	PCIE_LNK_X4 = 4,
	PCIE_LNK_X8 = 8,
	PCIE_LNK_X12 = 12,
	PCIE_LNK_X16 = 16,
	PCIE_LNK_X32 = 32,
	PCIE_LNK_WIDTH_UNKNOWN = 255,
};

enum pcie_reset_state {
	pcie_deassert_reset = 1,
	pcie_warm_reset = 2,
	pcie_hot_reset = 3,
};

enum pcim_addr_devres_type {
	PCIM_ADDR_DEVRES_TYPE_INVALID = 0,
	PCIM_ADDR_DEVRES_TYPE_REGION = 1,
	PCIM_ADDR_DEVRES_TYPE_REGION_MAPPING = 2,
	PCIM_ADDR_DEVRES_TYPE_MAPPING = 3,
};

enum pcpu_fc {
	PCPU_FC_AUTO = 0,
	PCPU_FC_EMBED = 1,
	PCPU_FC_PAGE = 2,
	PCPU_FC_NR = 3,
};

enum pedit_cmd {
	TCA_PEDIT_KEY_EX_CMD_SET = 0,
	TCA_PEDIT_KEY_EX_CMD_ADD = 1,
	__PEDIT_CMD_MAX = 2,
};

enum pedit_header_type {
	TCA_PEDIT_KEY_EX_HDR_TYPE_NETWORK = 0,
	TCA_PEDIT_KEY_EX_HDR_TYPE_ETH = 1,
	TCA_PEDIT_KEY_EX_HDR_TYPE_IP4 = 2,
	TCA_PEDIT_KEY_EX_HDR_TYPE_IP6 = 3,
	TCA_PEDIT_KEY_EX_HDR_TYPE_TCP = 4,
	TCA_PEDIT_KEY_EX_HDR_TYPE_UDP = 5,
	__PEDIT_HDR_TYPE_MAX = 6,
};

enum peer_app_attr {
	DCB_ATTR_CEE_PEER_APP_UNSPEC = 0,
	DCB_ATTR_CEE_PEER_APP_INFO = 1,
	DCB_ATTR_CEE_PEER_APP = 2,
	__DCB_ATTR_CEE_PEER_APP_MAX = 3,
};

enum perf_addr_filter_action_t {
	PERF_ADDR_FILTER_ACTION_STOP = 0,
	PERF_ADDR_FILTER_ACTION_START = 1,
	PERF_ADDR_FILTER_ACTION_FILTER = 2,
};

enum perf_bpf_event_type {
	PERF_BPF_EVENT_UNKNOWN = 0,
	PERF_BPF_EVENT_PROG_LOAD = 1,
	PERF_BPF_EVENT_PROG_UNLOAD = 2,
	PERF_BPF_EVENT_MAX = 3,
};

enum perf_branch_sample_type {
	PERF_SAMPLE_BRANCH_USER = 1,
	PERF_SAMPLE_BRANCH_KERNEL = 2,
	PERF_SAMPLE_BRANCH_HV = 4,
	PERF_SAMPLE_BRANCH_ANY = 8,
	PERF_SAMPLE_BRANCH_ANY_CALL = 16,
	PERF_SAMPLE_BRANCH_ANY_RETURN = 32,
	PERF_SAMPLE_BRANCH_IND_CALL = 64,
	PERF_SAMPLE_BRANCH_ABORT_TX = 128,
	PERF_SAMPLE_BRANCH_IN_TX = 256,
	PERF_SAMPLE_BRANCH_NO_TX = 512,
	PERF_SAMPLE_BRANCH_COND = 1024,
	PERF_SAMPLE_BRANCH_CALL_STACK = 2048,
	PERF_SAMPLE_BRANCH_IND_JUMP = 4096,
	PERF_SAMPLE_BRANCH_CALL = 8192,
	PERF_SAMPLE_BRANCH_NO_FLAGS = 16384,
	PERF_SAMPLE_BRANCH_NO_CYCLES = 32768,
	PERF_SAMPLE_BRANCH_TYPE_SAVE = 65536,
	PERF_SAMPLE_BRANCH_HW_INDEX = 131072,
	PERF_SAMPLE_BRANCH_PRIV_SAVE = 262144,
	PERF_SAMPLE_BRANCH_COUNTERS = 524288,
	PERF_SAMPLE_BRANCH_MAX = 1048576,
};

enum perf_branch_sample_type_shift {
	PERF_SAMPLE_BRANCH_USER_SHIFT = 0,
	PERF_SAMPLE_BRANCH_KERNEL_SHIFT = 1,
	PERF_SAMPLE_BRANCH_HV_SHIFT = 2,
	PERF_SAMPLE_BRANCH_ANY_SHIFT = 3,
	PERF_SAMPLE_BRANCH_ANY_CALL_SHIFT = 4,
	PERF_SAMPLE_BRANCH_ANY_RETURN_SHIFT = 5,
	PERF_SAMPLE_BRANCH_IND_CALL_SHIFT = 6,
	PERF_SAMPLE_BRANCH_ABORT_TX_SHIFT = 7,
	PERF_SAMPLE_BRANCH_IN_TX_SHIFT = 8,
	PERF_SAMPLE_BRANCH_NO_TX_SHIFT = 9,
	PERF_SAMPLE_BRANCH_COND_SHIFT = 10,
	PERF_SAMPLE_BRANCH_CALL_STACK_SHIFT = 11,
	PERF_SAMPLE_BRANCH_IND_JUMP_SHIFT = 12,
	PERF_SAMPLE_BRANCH_CALL_SHIFT = 13,
	PERF_SAMPLE_BRANCH_NO_FLAGS_SHIFT = 14,
	PERF_SAMPLE_BRANCH_NO_CYCLES_SHIFT = 15,
	PERF_SAMPLE_BRANCH_TYPE_SAVE_SHIFT = 16,
	PERF_SAMPLE_BRANCH_HW_INDEX_SHIFT = 17,
	PERF_SAMPLE_BRANCH_PRIV_SAVE_SHIFT = 18,
	PERF_SAMPLE_BRANCH_COUNTERS_SHIFT = 19,
	PERF_SAMPLE_BRANCH_MAX_SHIFT = 20,
};

enum perf_callchain_context {
	PERF_CONTEXT_HV = 18446744073709551584ULL,
	PERF_CONTEXT_KERNEL = 18446744073709551488ULL,
	PERF_CONTEXT_USER = 18446744073709551104ULL,
	PERF_CONTEXT_GUEST = 18446744073709549568ULL,
	PERF_CONTEXT_GUEST_KERNEL = 18446744073709549440ULL,
	PERF_CONTEXT_GUEST_USER = 18446744073709549056ULL,
	PERF_CONTEXT_MAX = 18446744073709547521ULL,
};

enum perf_event_ioc_flags {
	PERF_IOC_FLAG_GROUP = 1,
};

enum perf_event_read_format {
	PERF_FORMAT_TOTAL_TIME_ENABLED = 1,
	PERF_FORMAT_TOTAL_TIME_RUNNING = 2,
	PERF_FORMAT_ID = 4,
	PERF_FORMAT_GROUP = 8,
	PERF_FORMAT_LOST = 16,
	PERF_FORMAT_MAX = 32,
};

enum perf_event_sample_format {
	PERF_SAMPLE_IP = 1,
	PERF_SAMPLE_TID = 2,
	PERF_SAMPLE_TIME = 4,
	PERF_SAMPLE_ADDR = 8,
	PERF_SAMPLE_READ = 16,
	PERF_SAMPLE_CALLCHAIN = 32,
	PERF_SAMPLE_ID = 64,
	PERF_SAMPLE_CPU = 128,
	PERF_SAMPLE_PERIOD = 256,
	PERF_SAMPLE_STREAM_ID = 512,
	PERF_SAMPLE_RAW = 1024,
	PERF_SAMPLE_BRANCH_STACK = 2048,
	PERF_SAMPLE_REGS_USER = 4096,
	PERF_SAMPLE_STACK_USER = 8192,
	PERF_SAMPLE_WEIGHT = 16384,
	PERF_SAMPLE_DATA_SRC = 32768,
	PERF_SAMPLE_IDENTIFIER = 65536,
	PERF_SAMPLE_TRANSACTION = 131072,
	PERF_SAMPLE_REGS_INTR = 262144,
	PERF_SAMPLE_PHYS_ADDR = 524288,
	PERF_SAMPLE_AUX = 1048576,
	PERF_SAMPLE_CGROUP = 2097152,
	PERF_SAMPLE_DATA_PAGE_SIZE = 4194304,
	PERF_SAMPLE_CODE_PAGE_SIZE = 8388608,
	PERF_SAMPLE_WEIGHT_STRUCT = 16777216,
	PERF_SAMPLE_MAX = 33554432,
};

enum perf_event_state {
	PERF_EVENT_STATE_DEAD = -5,
	PERF_EVENT_STATE_REVOKED = -4,
	PERF_EVENT_STATE_EXIT = -3,
	PERF_EVENT_STATE_ERROR = -2,
	PERF_EVENT_STATE_OFF = -1,
	PERF_EVENT_STATE_INACTIVE = 0,
	PERF_EVENT_STATE_ACTIVE = 1,
};

enum perf_event_task_context {
	perf_invalid_context = -1,
	perf_hw_context = 0,
	perf_sw_context = 1,
	perf_nr_task_contexts = 2,
};

enum perf_event_type {
	PERF_RECORD_MMAP = 1,
	PERF_RECORD_LOST = 2,
	PERF_RECORD_COMM = 3,
	PERF_RECORD_EXIT = 4,
	PERF_RECORD_THROTTLE = 5,
	PERF_RECORD_UNTHROTTLE = 6,
	PERF_RECORD_FORK = 7,
	PERF_RECORD_READ = 8,
	PERF_RECORD_SAMPLE = 9,
	PERF_RECORD_MMAP2 = 10,
	PERF_RECORD_AUX = 11,
	PERF_RECORD_ITRACE_START = 12,
	PERF_RECORD_LOST_SAMPLES = 13,
	PERF_RECORD_SWITCH = 14,
	PERF_RECORD_SWITCH_CPU_WIDE = 15,
	PERF_RECORD_NAMESPACES = 16,
	PERF_RECORD_KSYMBOL = 17,
	PERF_RECORD_BPF_EVENT = 18,
	PERF_RECORD_CGROUP = 19,
	PERF_RECORD_TEXT_POKE = 20,
	PERF_RECORD_AUX_OUTPUT_HW_ID = 21,
	PERF_RECORD_MAX = 22,
};

enum perf_event_x86_regs {
	PERF_REG_X86_AX = 0,
	PERF_REG_X86_BX = 1,
	PERF_REG_X86_CX = 2,
	PERF_REG_X86_DX = 3,
	PERF_REG_X86_SI = 4,
	PERF_REG_X86_DI = 5,
	PERF_REG_X86_BP = 6,
	PERF_REG_X86_SP = 7,
	PERF_REG_X86_IP = 8,
	PERF_REG_X86_FLAGS = 9,
	PERF_REG_X86_CS = 10,
	PERF_REG_X86_SS = 11,
	PERF_REG_X86_DS = 12,
	PERF_REG_X86_ES = 13,
	PERF_REG_X86_FS = 14,
	PERF_REG_X86_GS = 15,
	PERF_REG_X86_R8 = 16,
	PERF_REG_X86_R9 = 17,
	PERF_REG_X86_R10 = 18,
	PERF_REG_X86_R11 = 19,
	PERF_REG_X86_R12 = 20,
	PERF_REG_X86_R13 = 21,
	PERF_REG_X86_R14 = 22,
	PERF_REG_X86_R15 = 23,
	PERF_REG_X86_32_MAX = 16,
	PERF_REG_X86_64_MAX = 24,
	PERF_REG_X86_XMM0 = 32,
	PERF_REG_X86_XMM1 = 34,
	PERF_REG_X86_XMM2 = 36,
	PERF_REG_X86_XMM3 = 38,
	PERF_REG_X86_XMM4 = 40,
	PERF_REG_X86_XMM5 = 42,
	PERF_REG_X86_XMM6 = 44,
	PERF_REG_X86_XMM7 = 46,
	PERF_REG_X86_XMM8 = 48,
	PERF_REG_X86_XMM9 = 50,
	PERF_REG_X86_XMM10 = 52,
	PERF_REG_X86_XMM11 = 54,
	PERF_REG_X86_XMM12 = 56,
	PERF_REG_X86_XMM13 = 58,
	PERF_REG_X86_XMM14 = 60,
	PERF_REG_X86_XMM15 = 62,
	PERF_REG_X86_XMM_MAX = 64,
};

enum perf_hw_cache_id {
	PERF_COUNT_HW_CACHE_L1D = 0,
	PERF_COUNT_HW_CACHE_L1I = 1,
	PERF_COUNT_HW_CACHE_LL = 2,
	PERF_COUNT_HW_CACHE_DTLB = 3,
	PERF_COUNT_HW_CACHE_ITLB = 4,
	PERF_COUNT_HW_CACHE_BPU = 5,
	PERF_COUNT_HW_CACHE_NODE = 6,
	PERF_COUNT_HW_CACHE_MAX = 7,
};

enum perf_hw_cache_op_id {
	PERF_COUNT_HW_CACHE_OP_READ = 0,
	PERF_COUNT_HW_CACHE_OP_WRITE = 1,
	PERF_COUNT_HW_CACHE_OP_PREFETCH = 2,
	PERF_COUNT_HW_CACHE_OP_MAX = 3,
};

enum perf_hw_cache_op_result_id {
	PERF_COUNT_HW_CACHE_RESULT_ACCESS = 0,
	PERF_COUNT_HW_CACHE_RESULT_MISS = 1,
	PERF_COUNT_HW_CACHE_RESULT_MAX = 2,
};

enum perf_hw_id {
	PERF_COUNT_HW_CPU_CYCLES = 0,
	PERF_COUNT_HW_INSTRUCTIONS = 1,
	PERF_COUNT_HW_CACHE_REFERENCES = 2,
	PERF_COUNT_HW_CACHE_MISSES = 3,
	PERF_COUNT_HW_BRANCH_INSTRUCTIONS = 4,
	PERF_COUNT_HW_BRANCH_MISSES = 5,
	PERF_COUNT_HW_BUS_CYCLES = 6,
	PERF_COUNT_HW_STALLED_CYCLES_FRONTEND = 7,
	PERF_COUNT_HW_STALLED_CYCLES_BACKEND = 8,
	PERF_COUNT_HW_REF_CPU_CYCLES = 9,
	PERF_COUNT_HW_MAX = 10,
};

enum perf_msr_id {
	PERF_MSR_TSC = 0,
	PERF_MSR_APERF = 1,
	PERF_MSR_MPERF = 2,
	PERF_MSR_PPERF = 3,
	PERF_MSR_SMI = 4,
	PERF_MSR_PTSC = 5,
	PERF_MSR_IRPERF = 6,
	PERF_MSR_THERM = 7,
	PERF_MSR_EVENT_MAX = 8,
};

enum perf_pmu_scope {
	PERF_PMU_SCOPE_NONE = 0,
	PERF_PMU_SCOPE_CORE = 1,
	PERF_PMU_SCOPE_DIE = 2,
	PERF_PMU_SCOPE_CLUSTER = 3,
	PERF_PMU_SCOPE_PKG = 4,
	PERF_PMU_SCOPE_SYS_WIDE = 5,
	PERF_PMU_MAX_SCOPE = 6,
};

enum perf_probe_config {
	PERF_PROBE_CONFIG_IS_RETPROBE = 1,
	PERF_UPROBE_REF_CTR_OFFSET_BITS = 32,
	PERF_UPROBE_REF_CTR_OFFSET_SHIFT = 32,
};

enum perf_record_ksymbol_type {
	PERF_RECORD_KSYMBOL_TYPE_UNKNOWN = 0,
	PERF_RECORD_KSYMBOL_TYPE_BPF = 1,
	PERF_RECORD_KSYMBOL_TYPE_OOL = 2,
	PERF_RECORD_KSYMBOL_TYPE_MAX = 3,
};

enum perf_sample_regs_abi {
	PERF_SAMPLE_REGS_ABI_NONE = 0,
	PERF_SAMPLE_REGS_ABI_32 = 1,
	PERF_SAMPLE_REGS_ABI_64 = 2,
};

enum perf_sw_ids {
	PERF_COUNT_SW_CPU_CLOCK = 0,
	PERF_COUNT_SW_TASK_CLOCK = 1,
	PERF_COUNT_SW_PAGE_FAULTS = 2,
	PERF_COUNT_SW_CONTEXT_SWITCHES = 3,
	PERF_COUNT_SW_CPU_MIGRATIONS = 4,
	PERF_COUNT_SW_PAGE_FAULTS_MIN = 5,
	PERF_COUNT_SW_PAGE_FAULTS_MAJ = 6,
	PERF_COUNT_SW_ALIGNMENT_FAULTS = 7,
	PERF_COUNT_SW_EMULATION_FAULTS = 8,
	PERF_COUNT_SW_DUMMY = 9,
	PERF_COUNT_SW_BPF_OUTPUT = 10,
	PERF_COUNT_SW_CGROUP_SWITCHES = 11,
	PERF_COUNT_SW_MAX = 12,
};

enum perf_type_id {
	PERF_TYPE_HARDWARE = 0,
	PERF_TYPE_SOFTWARE = 1,
	PERF_TYPE_TRACEPOINT = 2,
	PERF_TYPE_HW_CACHE = 3,
	PERF_TYPE_RAW = 4,
	PERF_TYPE_BREAKPOINT = 5,
	PERF_TYPE_MAX = 6,
};

enum pg_level {
	PG_LEVEL_NONE = 0,
	PG_LEVEL_4K = 1,
	PG_LEVEL_2M = 2,
	PG_LEVEL_1G = 3,
	PG_LEVEL_512G = 4,
	PG_LEVEL_256T = 5,
	PG_LEVEL_NUM = 6,
};

enum pgdat_flags {
	PGDAT_DIRTY = 0,
	PGDAT_WRITEBACK = 1,
	PGDAT_RECLAIM_LOCKED = 2,
};

enum pgt_entry {
	NORMAL_PMD = 0,
	HPAGE_PMD = 1,
	NORMAL_PUD = 2,
	HPAGE_PUD = 3,
};

enum phy_media {
	PHY_MEDIA_DEFAULT = 0,
	PHY_MEDIA_SR = 1,
	PHY_MEDIA_DAC = 2,
};

enum phy_mode {
	PHY_MODE_INVALID = 0,
	PHY_MODE_USB_HOST = 1,
	PHY_MODE_USB_HOST_LS = 2,
	PHY_MODE_USB_HOST_FS = 3,
	PHY_MODE_USB_HOST_HS = 4,
	PHY_MODE_USB_HOST_SS = 5,
	PHY_MODE_USB_DEVICE = 6,
	PHY_MODE_USB_DEVICE_LS = 7,
	PHY_MODE_USB_DEVICE_FS = 8,
	PHY_MODE_USB_DEVICE_HS = 9,
	PHY_MODE_USB_DEVICE_SS = 10,
	PHY_MODE_USB_OTG = 11,
	PHY_MODE_UFS_HS_A = 12,
	PHY_MODE_UFS_HS_B = 13,
	PHY_MODE_PCIE = 14,
	PHY_MODE_ETHERNET = 15,
	PHY_MODE_MIPI_DPHY = 16,
	PHY_MODE_SATA = 17,
	PHY_MODE_LVDS = 18,
	PHY_MODE_DP = 19,
	PHY_MODE_HDMI = 20,
};

enum phy_state {
	PHY_DOWN = 0,
	PHY_READY = 1,
	PHY_HALTED = 2,
	PHY_ERROR = 3,
	PHY_UP = 4,
	PHY_RUNNING = 5,
	PHY_NOLINK = 6,
	PHY_CABLETEST = 7,
};

enum phy_tunable_id {
	ETHTOOL_PHY_ID_UNSPEC = 0,
	ETHTOOL_PHY_DOWNSHIFT = 1,
	ETHTOOL_PHY_FAST_LINK_DOWN = 2,
	ETHTOOL_PHY_EDPD = 3,
	__ETHTOOL_PHY_TUNABLE_COUNT = 4,
};

enum phy_upstream {
	PHY_UPSTREAM_MAC = 0,
	PHY_UPSTREAM_PHY = 1,
};

enum phylink_op_type {
	PHYLINK_NETDEV = 0,
	PHYLINK_DEV = 1,
};

enum pid_type {
	PIDTYPE_PID = 0,
	PIDTYPE_TGID = 1,
	PIDTYPE_PGID = 2,
	PIDTYPE_SID = 3,
	PIDTYPE_MAX = 4,
};

enum pidcg_event {
	PIDCG_MAX = 0,
	PIDCG_FORKFAIL = 1,
	NR_PIDCG_EVENTS = 2,
};

enum pin_config_param {
	PIN_CONFIG_BIAS_BUS_HOLD = 0,
	PIN_CONFIG_BIAS_DISABLE = 1,
	PIN_CONFIG_BIAS_HIGH_IMPEDANCE = 2,
	PIN_CONFIG_BIAS_PULL_DOWN = 3,
	PIN_CONFIG_BIAS_PULL_PIN_DEFAULT = 4,
	PIN_CONFIG_BIAS_PULL_UP = 5,
	PIN_CONFIG_DRIVE_OPEN_DRAIN = 6,
	PIN_CONFIG_DRIVE_OPEN_SOURCE = 7,
	PIN_CONFIG_DRIVE_PUSH_PULL = 8,
	PIN_CONFIG_DRIVE_STRENGTH = 9,
	PIN_CONFIG_DRIVE_STRENGTH_UA = 10,
	PIN_CONFIG_INPUT_DEBOUNCE = 11,
	PIN_CONFIG_INPUT_ENABLE = 12,
	PIN_CONFIG_INPUT_SCHMITT = 13,
	PIN_CONFIG_INPUT_SCHMITT_ENABLE = 14,
	PIN_CONFIG_INPUT_SCHMITT_UV = 15,
	PIN_CONFIG_MODE_LOW_POWER = 16,
	PIN_CONFIG_MODE_PWM = 17,
	PIN_CONFIG_OUTPUT = 18,
	PIN_CONFIG_OUTPUT_ENABLE = 19,
	PIN_CONFIG_OUTPUT_IMPEDANCE_OHMS = 20,
	PIN_CONFIG_PERSIST_STATE = 21,
	PIN_CONFIG_POWER_SOURCE = 22,
	PIN_CONFIG_SKEW_DELAY = 23,
	PIN_CONFIG_SLEEP_HARDWARE_STATE = 24,
	PIN_CONFIG_SLEW_RATE = 25,
	PIN_CONFIG_END = 127,
	PIN_CONFIG_MAX = 255,
};

enum pinctrl_map_type {
	PIN_MAP_TYPE_INVALID = 0,
	PIN_MAP_TYPE_DUMMY_STATE = 1,
	PIN_MAP_TYPE_MUX_GROUP = 2,
	PIN_MAP_TYPE_CONFIGS_PIN = 3,
	PIN_MAP_TYPE_CONFIGS_GROUP = 4,
};

enum pkcs7_actions {
	ACT_pkcs7_check_content_type = 0,
	ACT_pkcs7_extract_cert = 1,
	ACT_pkcs7_note_OID = 2,
	ACT_pkcs7_note_certificate_list = 3,
	ACT_pkcs7_note_content = 4,
	ACT_pkcs7_note_data = 5,
	ACT_pkcs7_note_signed_info = 6,
	ACT_pkcs7_note_signeddata_version = 7,
	ACT_pkcs7_note_signerinfo_version = 8,
	ACT_pkcs7_sig_note_authenticated_attr = 9,
	ACT_pkcs7_sig_note_digest_algo = 10,
	ACT_pkcs7_sig_note_issuer = 11,
	ACT_pkcs7_sig_note_pkey_algo = 12,
	ACT_pkcs7_sig_note_serial = 13,
	ACT_pkcs7_sig_note_set_of_authattrs = 14,
	ACT_pkcs7_sig_note_signature = 15,
	ACT_pkcs7_sig_note_skid = 16,
	NR__pkcs7_actions = 17,
};

enum pkey_id_type {
	PKEY_ID_PGP = 0,
	PKEY_ID_X509 = 1,
	PKEY_ID_PKCS7 = 2,
};

enum pkt_hash_types {
	PKT_HASH_TYPE_NONE = 0,
	PKT_HASH_TYPE_L2 = 1,
	PKT_HASH_TYPE_L3 = 2,
	PKT_HASH_TYPE_L4 = 3,
};

enum pldmfw_update_mode {
	PLDMFW_UPDATE_MODE_FULL = 0,
	PLDMFW_UPDATE_MODE_SINGLE_COMPONENT = 1,
};

enum pm8606_ref_gp_and_osc_clients {
	REF_GP_NO_CLIENTS = 0,
	WLED1_DUTY = 1,
	WLED2_DUTY = 2,
	WLED3_DUTY = 4,
	RGB1_ENABLE = 8,
	RGB2_ENABLE = 16,
	LDO_VBR_EN = 32,
	REF_GP_MAX_CLIENT = 65535,
};

enum pm_qos_flags_status {
	PM_QOS_FLAGS_UNDEFINED = -1,
	PM_QOS_FLAGS_NONE = 0,
	PM_QOS_FLAGS_SOME = 1,
	PM_QOS_FLAGS_ALL = 2,
};

enum pm_qos_req_action {
	PM_QOS_ADD_REQ = 0,
	PM_QOS_UPDATE_REQ = 1,
	PM_QOS_REMOVE_REQ = 2,
};

enum pm_qos_type {
	PM_QOS_UNITIALIZED = 0,
	PM_QOS_MAX = 1,
	PM_QOS_MIN = 2,
};

enum pmc_type {
	KVM_PMC_GP = 0,
	KVM_PMC_FIXED = 1,
};

enum poison_cmd_enabled_bits {
	CXL_POISON_ENABLED_LIST = 0,
	CXL_POISON_ENABLED_INJECT = 1,
	CXL_POISON_ENABLED_CLEAR = 2,
	CXL_POISON_ENABLED_SCAN_CAPS = 3,
	CXL_POISON_ENABLED_SCAN_MEDIA = 4,
	CXL_POISON_ENABLED_SCAN_RESULTS = 5,
	CXL_POISON_ENABLED_MAX = 6,
};

enum poll_time_type {
	PT_TIMEVAL = 0,
	PT_OLD_TIMEVAL = 1,
	PT_TIMESPEC = 2,
	PT_OLD_TIMESPEC = 3,
};

enum polling_modes {
	CM_POLL_DISABLE = 0,
	CM_POLL_ALWAYS = 1,
	CM_POLL_EXTERNAL_POWER_ONLY = 2,
	CM_POLL_CHARGING_ONLY = 3,
};

enum pool_workqueue_stats {
	PWQ_STAT_STARTED = 0,
	PWQ_STAT_COMPLETED = 1,
	PWQ_STAT_CPU_TIME = 2,
	PWQ_STAT_CPU_INTENSIVE = 3,
	PWQ_STAT_CM_WAKEUP = 4,
	PWQ_STAT_REPATRIATED = 5,
	PWQ_STAT_MAYDAY = 6,
	PWQ_STAT_RESCUED = 7,
	PWQ_NR_STATS = 8,
};

enum port_pkey_state {
	IB_PORT_PKEY_NOT_VALID = 0,
	IB_PORT_PKEY_VALID = 1,
	IB_PORT_PKEY_LISTED = 2,
};

enum positive_aop_returns {
	AOP_WRITEPAGE_ACTIVATE = 524288,
	AOP_TRUNCATED_PAGE = 524289,
};

enum posix_timer_state {
	POSIX_TIMER_DISARMED = 0,
	POSIX_TIMER_ARMED = 1,
	POSIX_TIMER_REQUEUE_PENDING = 2,
};

enum power_supply_charge_behaviour {
	POWER_SUPPLY_CHARGE_BEHAVIOUR_AUTO = 0,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_INHIBIT_CHARGE = 1,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_INHIBIT_CHARGE_AWAKE = 2,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_FORCE_DISCHARGE = 3,
};

enum power_supply_charge_type {
	POWER_SUPPLY_CHARGE_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_CHARGE_TYPE_NONE = 1,
	POWER_SUPPLY_CHARGE_TYPE_TRICKLE = 2,
	POWER_SUPPLY_CHARGE_TYPE_FAST = 3,
	POWER_SUPPLY_CHARGE_TYPE_STANDARD = 4,
	POWER_SUPPLY_CHARGE_TYPE_ADAPTIVE = 5,
	POWER_SUPPLY_CHARGE_TYPE_CUSTOM = 6,
	POWER_SUPPLY_CHARGE_TYPE_LONGLIFE = 7,
	POWER_SUPPLY_CHARGE_TYPE_BYPASS = 8,
};

enum power_supply_notifier_events {
	PSY_EVENT_PROP_CHANGED = 0,
};

enum power_supply_property {
	POWER_SUPPLY_PROP_STATUS = 0,
	POWER_SUPPLY_PROP_CHARGE_TYPE = 1,
	POWER_SUPPLY_PROP_CHARGE_TYPES = 2,
	POWER_SUPPLY_PROP_HEALTH = 3,
	POWER_SUPPLY_PROP_PRESENT = 4,
	POWER_SUPPLY_PROP_ONLINE = 5,
	POWER_SUPPLY_PROP_AUTHENTIC = 6,
	POWER_SUPPLY_PROP_TECHNOLOGY = 7,
	POWER_SUPPLY_PROP_CYCLE_COUNT = 8,
	POWER_SUPPLY_PROP_VOLTAGE_MAX = 9,
	POWER_SUPPLY_PROP_VOLTAGE_MIN = 10,
	POWER_SUPPLY_PROP_VOLTAGE_MAX_DESIGN = 11,
	POWER_SUPPLY_PROP_VOLTAGE_MIN_DESIGN = 12,
	POWER_SUPPLY_PROP_VOLTAGE_NOW = 13,
	POWER_SUPPLY_PROP_VOLTAGE_AVG = 14,
	POWER_SUPPLY_PROP_VOLTAGE_OCV = 15,
	POWER_SUPPLY_PROP_VOLTAGE_BOOT = 16,
	POWER_SUPPLY_PROP_CURRENT_MAX = 17,
	POWER_SUPPLY_PROP_CURRENT_NOW = 18,
	POWER_SUPPLY_PROP_CURRENT_AVG = 19,
	POWER_SUPPLY_PROP_CURRENT_BOOT = 20,
	POWER_SUPPLY_PROP_POWER_NOW = 21,
	POWER_SUPPLY_PROP_POWER_AVG = 22,
	POWER_SUPPLY_PROP_CHARGE_FULL_DESIGN = 23,
	POWER_SUPPLY_PROP_CHARGE_EMPTY_DESIGN = 24,
	POWER_SUPPLY_PROP_CHARGE_FULL = 25,
	POWER_SUPPLY_PROP_CHARGE_EMPTY = 26,
	POWER_SUPPLY_PROP_CHARGE_NOW = 27,
	POWER_SUPPLY_PROP_CHARGE_AVG = 28,
	POWER_SUPPLY_PROP_CHARGE_COUNTER = 29,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT = 30,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT_MAX = 31,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE = 32,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE_MAX = 33,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT = 34,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT_MAX = 35,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_START_THRESHOLD = 36,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_END_THRESHOLD = 37,
	POWER_SUPPLY_PROP_CHARGE_BEHAVIOUR = 38,
	POWER_SUPPLY_PROP_INPUT_CURRENT_LIMIT = 39,
	POWER_SUPPLY_PROP_INPUT_VOLTAGE_LIMIT = 40,
	POWER_SUPPLY_PROP_INPUT_POWER_LIMIT = 41,
	POWER_SUPPLY_PROP_ENERGY_FULL_DESIGN = 42,
	POWER_SUPPLY_PROP_ENERGY_EMPTY_DESIGN = 43,
	POWER_SUPPLY_PROP_ENERGY_FULL = 44,
	POWER_SUPPLY_PROP_ENERGY_EMPTY = 45,
	POWER_SUPPLY_PROP_ENERGY_NOW = 46,
	POWER_SUPPLY_PROP_ENERGY_AVG = 47,
	POWER_SUPPLY_PROP_CAPACITY = 48,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MIN = 49,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MAX = 50,
	POWER_SUPPLY_PROP_CAPACITY_ERROR_MARGIN = 51,
	POWER_SUPPLY_PROP_CAPACITY_LEVEL = 52,
	POWER_SUPPLY_PROP_TEMP = 53,
	POWER_SUPPLY_PROP_TEMP_MAX = 54,
	POWER_SUPPLY_PROP_TEMP_MIN = 55,
	POWER_SUPPLY_PROP_TEMP_ALERT_MIN = 56,
	POWER_SUPPLY_PROP_TEMP_ALERT_MAX = 57,
	POWER_SUPPLY_PROP_TEMP_AMBIENT = 58,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MIN = 59,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MAX = 60,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_NOW = 61,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_AVG = 62,
	POWER_SUPPLY_PROP_TIME_TO_FULL_NOW = 63,
	POWER_SUPPLY_PROP_TIME_TO_FULL_AVG = 64,
	POWER_SUPPLY_PROP_TYPE = 65,
	POWER_SUPPLY_PROP_USB_TYPE = 66,
	POWER_SUPPLY_PROP_SCOPE = 67,
	POWER_SUPPLY_PROP_PRECHARGE_CURRENT = 68,
	POWER_SUPPLY_PROP_CHARGE_TERM_CURRENT = 69,
	POWER_SUPPLY_PROP_CALIBRATE = 70,
	POWER_SUPPLY_PROP_MANUFACTURE_YEAR = 71,
	POWER_SUPPLY_PROP_MANUFACTURE_MONTH = 72,
	POWER_SUPPLY_PROP_MANUFACTURE_DAY = 73,
	POWER_SUPPLY_PROP_MODEL_NAME = 74,
	POWER_SUPPLY_PROP_MANUFACTURER = 75,
	POWER_SUPPLY_PROP_SERIAL_NUMBER = 76,
};

enum power_supply_type {
	POWER_SUPPLY_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_TYPE_BATTERY = 1,
	POWER_SUPPLY_TYPE_UPS = 2,
	POWER_SUPPLY_TYPE_MAINS = 3,
	POWER_SUPPLY_TYPE_USB = 4,
	POWER_SUPPLY_TYPE_USB_DCP = 5,
	POWER_SUPPLY_TYPE_USB_CDP = 6,
	POWER_SUPPLY_TYPE_USB_ACA = 7,
	POWER_SUPPLY_TYPE_USB_TYPE_C = 8,
	POWER_SUPPLY_TYPE_USB_PD = 9,
	POWER_SUPPLY_TYPE_USB_PD_DRP = 10,
	POWER_SUPPLY_TYPE_APPLE_BRICK_ID = 11,
	POWER_SUPPLY_TYPE_WIRELESS = 12,
};

enum power_supply_usb_type {
	POWER_SUPPLY_USB_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_USB_TYPE_SDP = 1,
	POWER_SUPPLY_USB_TYPE_DCP = 2,
	POWER_SUPPLY_USB_TYPE_CDP = 3,
	POWER_SUPPLY_USB_TYPE_ACA = 4,
	POWER_SUPPLY_USB_TYPE_C = 5,
	POWER_SUPPLY_USB_TYPE_PD = 6,
	POWER_SUPPLY_USB_TYPE_PD_DRP = 7,
	POWER_SUPPLY_USB_TYPE_PD_PPS = 8,
	POWER_SUPPLY_USB_TYPE_APPLE_BRICK_ID = 9,
};

enum pr_status {
	PR_STS_SUCCESS = 0,
	PR_STS_IOERR = 2,
	PR_STS_RESERVATION_CONFLICT = 24,
	PR_STS_RETRY_PATH_FAILURE = 917504,
	PR_STS_PATH_FAST_FAILED = 983040,
	PR_STS_PATH_FAILED = 65536,
};

enum pr_type {
	PR_WRITE_EXCLUSIVE = 1,
	PR_EXCLUSIVE_ACCESS = 2,
	PR_WRITE_EXCLUSIVE_REG_ONLY = 3,
	PR_EXCLUSIVE_ACCESS_REG_ONLY = 4,
	PR_WRITE_EXCLUSIVE_ALL_REGS = 5,
	PR_EXCLUSIVE_ACCESS_ALL_REGS = 6,
};

enum prep_dispatch {
	PREP_DISPATCH_OK = 0,
	PREP_DISPATCH_NO_TAG = 1,
	PREP_DISPATCH_NO_BUDGET = 2,
};

enum print_line_t {
	TRACE_TYPE_PARTIAL_LINE = 0,
	TRACE_TYPE_HANDLED = 1,
	TRACE_TYPE_UNHANDLED = 2,
	TRACE_TYPE_NO_CONSUME = 3,
};

enum printk_info_flags {
	LOG_FORCE_CON = 1,
	LOG_NEWLINE = 2,
	LOG_CONT = 8,
};

enum prio_policy {
	POLICY_NO_CHANGE = 0,
	POLICY_PROMOTE_TO_RT = 1,
	POLICY_RESTRICT_TO_BE = 2,
	POLICY_ALL_TO_IDLE = 3,
	POLICY_NONE_TO_RT = 4,
};

enum priv_stack_mode {
	PRIV_STACK_UNKNOWN = 0,
	NO_PRIV_STACK = 1,
	PRIV_STACK_ADAPTIVE = 2,
};

enum probe_print_type {
	PROBE_PRINT_NORMAL = 0,
	PROBE_PRINT_RETURN = 1,
	PROBE_PRINT_EVENT = 2,
};

enum probe_type {
	PROBE_DEFAULT_STRATEGY = 0,
	PROBE_PREFER_ASYNCHRONOUS = 1,
	PROBE_FORCE_SYNCHRONOUS = 2,
};

enum proc_cn_event {
	PROC_EVENT_NONE = 0,
	PROC_EVENT_FORK = 1,
	PROC_EVENT_EXEC = 2,
	PROC_EVENT_UID = 4,
	PROC_EVENT_GID = 64,
	PROC_EVENT_SID = 128,
	PROC_EVENT_PTRACE = 256,
	PROC_EVENT_COMM = 512,
	PROC_EVENT_NONZERO_EXIT = 536870912,
	PROC_EVENT_COREDUMP = 1073741824,
	PROC_EVENT_EXIT = 2147483648,
};

enum proc_cn_mcast_op {
	PROC_CN_MCAST_LISTEN = 1,
	PROC_CN_MCAST_IGNORE = 2,
};

enum proc_hidepid {
	HIDEPID_OFF = 0,
	HIDEPID_NO_ACCESS = 1,
	HIDEPID_INVISIBLE = 2,
	HIDEPID_NOT_PTRACEABLE = 4,
};

enum proc_mem_force {
	PROC_MEM_FORCE_ALWAYS = 0,
	PROC_MEM_FORCE_PTRACE = 1,
	PROC_MEM_FORCE_NEVER = 2,
};

enum proc_param {
	Opt_gid___7 = 0,
	Opt_hidepid = 1,
	Opt_subset = 2,
};

enum proc_pidonly {
	PROC_PIDONLY_OFF = 0,
	PROC_PIDONLY_ON = 1,
};

enum procfs_ino {
	PROCFS_ROOT_INO = 1,
};

enum procmap_query_flags {
	PROCMAP_QUERY_VMA_READABLE = 1,
	PROCMAP_QUERY_VMA_WRITABLE = 2,
	PROCMAP_QUERY_VMA_EXECUTABLE = 4,
	PROCMAP_QUERY_VMA_SHARED = 8,
	PROCMAP_QUERY_COVERING_OR_NEXT_VMA = 16,
	PROCMAP_QUERY_FILE_BACKED_VMA = 32,
};

enum profile_mode {
	APPARMOR_ENFORCE = 0,
	APPARMOR_COMPLAIN = 1,
	APPARMOR_KILL = 2,
	APPARMOR_UNCONFINED = 3,
	APPARMOR_USER = 4,
};

enum protection_domain_mode {
	PD_MODE_NONE = 0,
	PD_MODE_V1 = 1,
	PD_MODE_V2 = 2,
};

enum prs_errcode {
	PERR_NONE = 0,
	PERR_INVCPUS = 1,
	PERR_INVPARENT = 2,
	PERR_NOTPART = 3,
	PERR_NOTEXCL = 4,
	PERR_NOCPUS = 5,
	PERR_HOTPLUG = 6,
	PERR_CPUSEMPTY = 7,
	PERR_HKEEPING = 8,
	PERR_ACCESS = 9,
	PERR_REMOTE = 10,
};

enum ps2_disposition {
	PS2_PROCESS = 0,
	PS2_IGNORE = 1,
	PS2_ERROR = 2,
};

enum psc_op {
	SNP_PAGE_STATE_PRIVATE = 1,
	SNP_PAGE_STATE_SHARED = 2,
};

enum pse_budget_eval_strategies {
	PSE_BUDGET_EVAL_STRAT_DISABLED = 1,
	PSE_BUDGET_EVAL_STRAT_STATIC = 2,
	PSE_BUDGET_EVAL_STRAT_DYNAMIC = 4,
};

enum pse_pi_pairset_pinout {
	ALTERNATIVE_A = 0,
	ALTERNATIVE_B = 1,
};

enum psi_aggregators {
	PSI_AVGS = 0,
	PSI_POLL = 1,
	NR_PSI_AGGREGATORS = 2,
};

enum psi_res {
	PSI_IO = 0,
	PSI_MEM = 1,
	PSI_CPU = 2,
	PSI_IRQ = 3,
	NR_PSI_RESOURCES = 4,
};

enum psi_states {
	PSI_IO_SOME = 0,
	PSI_IO_FULL = 1,
	PSI_MEM_SOME = 2,
	PSI_MEM_FULL = 3,
	PSI_CPU_SOME = 4,
	PSI_CPU_FULL = 5,
	PSI_IRQ_FULL = 6,
	PSI_NONIDLE = 7,
	NR_PSI_STATES = 8,
};

enum psi_task_count {
	NR_IOWAIT = 0,
	NR_MEMSTALL = 1,
	NR_RUNNING = 2,
	NR_MEMSTALL_RUNNING = 3,
	NR_PSI_TASK_COUNTS = 4,
};

enum pstore_type_id {
	PSTORE_TYPE_DMESG = 0,
	PSTORE_TYPE_MCE = 1,
	PSTORE_TYPE_CONSOLE = 2,
	PSTORE_TYPE_FTRACE = 3,
	PSTORE_TYPE_PPC_RTAS = 4,
	PSTORE_TYPE_PPC_OF = 5,
	PSTORE_TYPE_PPC_COMMON = 6,
	PSTORE_TYPE_PMSG = 7,
	PSTORE_TYPE_PPC_OPAL = 8,
	PSTORE_TYPE_MAX = 9,
};

enum pt_capabilities {
	PT_CAP_max_subleaf = 0,
	PT_CAP_cr3_filtering = 1,
	PT_CAP_psb_cyc = 2,
	PT_CAP_ip_filtering = 3,
	PT_CAP_mtc = 4,
	PT_CAP_ptwrite = 5,
	PT_CAP_power_event_trace = 6,
	PT_CAP_event_trace = 7,
	PT_CAP_tnt_disable = 8,
	PT_CAP_topa_output = 9,
	PT_CAP_topa_multiple_entries = 10,
	PT_CAP_single_range_output = 11,
	PT_CAP_output_subsys = 12,
	PT_CAP_payloads_lip = 13,
	PT_CAP_num_address_ranges = 14,
	PT_CAP_mtc_periods = 15,
	PT_CAP_cycle_thresholds = 16,
	PT_CAP_psb_periods = 17,
};

enum pt_level {
	PT_PGD = 0,
	PT_P4D = 1,
	PT_PUD = 2,
	PT_PMD = 3,
	PT_PTE = 4,
};

enum pti_clone_level {
	PTI_CLONE_PMD = 0,
	PTI_CLONE_PTE = 1,
};

enum pti_mode {
	PTI_AUTO = 0,
	PTI_FORCE_OFF = 1,
	PTI_FORCE_ON = 2,
};

enum pubkey_algo {
	PUBKEY_ALGO_RSA = 0,
	PUBKEY_ALGO_MAX = 1,
};

enum pwm_polarity {
	PWM_POLARITY_NORMAL = 0,
	PWM_POLARITY_INVERSED = 1,
};

enum pxa_ssp_type {
	SSP_UNDEFINED = 0,
	PXA25x_SSP = 1,
	PXA25x_NSSP = 2,
	PXA27x_SSP = 3,
	PXA3xx_SSP = 4,
	PXA168_SSP = 5,
	PXA910_SSP = 6,
	CE4100_SSP = 7,
	MMP2_SSP = 8,
	MRFLD_SSP = 9,
	QUARK_X1000_SSP = 10,
	LPSS_LPT_SSP = 11,
	LPSS_BYT_SSP = 12,
	LPSS_BSW_SSP = 13,
	LPSS_SPT_SSP = 14,
	LPSS_BXT_SSP = 15,
	LPSS_CNL_SSP = 16,
	SSP_MAX = 17,
};

enum qdisc_class_ops_flags {
	QDISC_CLASS_OPS_DOIT_UNLOCKED = 1,
};

enum qdisc_ops_kf_flags {
	QDISC_OPS_KF_COMMON = 0,
	QDISC_OPS_KF_ENQUEUE = 1,
	QDISC_OPS_KF_DEQUEUE = 2,
};

enum qdisc_state2_t {
	__QDISC_STATE2_RUNNING = 0,
};

enum qdisc_state_t {
	__QDISC_STATE_SCHED = 0,
	__QDISC_STATE_DEACTIVATED = 1,
	__QDISC_STATE_MISSED = 2,
	__QDISC_STATE_DRAINING = 3,
};

enum quota_type {
	USRQUOTA = 0,
	GRPQUOTA = 1,
	PRJQUOTA = 2,
};

enum ramfs_param {
	Opt_mode___5 = 0,
};

enum rc_driver_type {
	RC_DRIVER_SCANCODE = 0,
	RC_DRIVER_IR_RAW = 1,
	RC_DRIVER_IR_RAW_TX = 2,
};

enum rc_filter_type {
	RC_FILTER_NORMAL = 0,
	RC_FILTER_WAKEUP = 1,
	RC_FILTER_MAX = 2,
};

enum rc_proto {
	RC_PROTO_UNKNOWN = 0,
	RC_PROTO_OTHER = 1,
	RC_PROTO_RC5 = 2,
	RC_PROTO_RC5X_20 = 3,
	RC_PROTO_RC5_SZ = 4,
	RC_PROTO_JVC = 5,
	RC_PROTO_SONY12 = 6,
	RC_PROTO_SONY15 = 7,
	RC_PROTO_SONY20 = 8,
	RC_PROTO_NEC = 9,
	RC_PROTO_NECX = 10,
	RC_PROTO_NEC32 = 11,
	RC_PROTO_SANYO = 12,
	RC_PROTO_MCIR2_KBD = 13,
	RC_PROTO_MCIR2_MSE = 14,
	RC_PROTO_RC6_0 = 15,
	RC_PROTO_RC6_6A_20 = 16,
	RC_PROTO_RC6_6A_24 = 17,
	RC_PROTO_RC6_6A_32 = 18,
	RC_PROTO_RC6_MCE = 19,
	RC_PROTO_SHARP = 20,
	RC_PROTO_XMP = 21,
	RC_PROTO_CEC = 22,
	RC_PROTO_IMON = 23,
	RC_PROTO_RCMM12 = 24,
	RC_PROTO_RCMM24 = 25,
	RC_PROTO_RCMM32 = 26,
	RC_PROTO_XBOX_DVD = 27,
	RC_PROTO_MAX = 27,
};

enum rdma_ah_attr_type {
	RDMA_AH_ATTR_TYPE_UNDEFINED = 0,
	RDMA_AH_ATTR_TYPE_IB = 1,
	RDMA_AH_ATTR_TYPE_ROCE = 2,
	RDMA_AH_ATTR_TYPE_OPA = 3,
};

enum rdma_driver_id {
	RDMA_DRIVER_UNKNOWN = 0,
	RDMA_DRIVER_MLX5 = 1,
	RDMA_DRIVER_MLX4 = 2,
	RDMA_DRIVER_CXGB3 = 3,
	RDMA_DRIVER_CXGB4 = 4,
	RDMA_DRIVER_MTHCA = 5,
	RDMA_DRIVER_BNXT_RE = 6,
	RDMA_DRIVER_OCRDMA = 7,
	RDMA_DRIVER_NES = 8,
	RDMA_DRIVER_I40IW = 9,
	RDMA_DRIVER_IRDMA = 9,
	RDMA_DRIVER_VMW_PVRDMA = 10,
	RDMA_DRIVER_QEDR = 11,
	RDMA_DRIVER_HNS = 12,
	RDMA_DRIVER_USNIC = 13,
	RDMA_DRIVER_RXE = 14,
	RDMA_DRIVER_HFI1 = 15,
	RDMA_DRIVER_QIB = 16,
	RDMA_DRIVER_EFA = 17,
	RDMA_DRIVER_SIW = 18,
	RDMA_DRIVER_ERDMA = 19,
	RDMA_DRIVER_MANA = 20,
};

enum rdma_link_layer {
	IB_LINK_LAYER_UNSPECIFIED = 0,
	IB_LINK_LAYER_INFINIBAND = 1,
	IB_LINK_LAYER_ETHERNET = 2,
};

enum rdma_netdev_t {
	RDMA_NETDEV_OPA_VNIC = 0,
	RDMA_NETDEV_IPOIB = 1,
};

enum rdma_nl_counter_mask {
	RDMA_COUNTER_MASK_QP_TYPE = 1,
	RDMA_COUNTER_MASK_PID = 2,
};

enum rdma_nl_counter_mode {
	RDMA_COUNTER_MODE_NONE = 0,
	RDMA_COUNTER_MODE_AUTO = 1,
	RDMA_COUNTER_MODE_MANUAL = 2,
	RDMA_COUNTER_MODE_MAX = 3,
};

enum rdma_nl_dev_type {
	RDMA_DEVICE_TYPE_SMI = 1,
};

enum rdma_nl_name_assign_type {
	RDMA_NAME_ASSIGN_TYPE_UNKNOWN = 0,
	RDMA_NAME_ASSIGN_TYPE_USER = 1,
};

enum rdma_restrack_type {
	RDMA_RESTRACK_PD = 0,
	RDMA_RESTRACK_CQ = 1,
	RDMA_RESTRACK_QP = 2,
	RDMA_RESTRACK_CM_ID = 3,
	RDMA_RESTRACK_MR = 4,
	RDMA_RESTRACK_CTX = 5,
	RDMA_RESTRACK_COUNTER = 6,
	RDMA_RESTRACK_SRQ = 7,
	RDMA_RESTRACK_DMAH = 8,
	RDMA_RESTRACK_MAX = 9,
};

enum rdmacg_file_type {
	RDMACG_RESOURCE_TYPE_MAX = 0,
	RDMACG_RESOURCE_TYPE_STAT = 1,
};

enum rdmacg_resource_type {
	RDMACG_RESOURCE_HCA_HANDLE = 0,
	RDMACG_RESOURCE_HCA_OBJECT = 1,
	RDMACG_RESOURCE_MAX = 2,
};

enum rdt_group_type {
	RDTCTRL_GROUP = 0,
	RDTMON_GROUP = 1,
	RDT_NUM_GROUP = 2,
};

enum rdt_param {
	Opt_cdp = 0,
	Opt_cdpl2 = 1,
	Opt_mba_mbps = 2,
	Opt_debug = 3,
	nr__rdt_params = 4,
};

enum rdtgrp_mode {
	RDT_MODE_SHAREABLE = 0,
	RDT_MODE_EXCLUSIVE = 1,
	RDT_MODE_PSEUDO_LOCKSETUP = 2,
	RDT_MODE_PSEUDO_LOCKED = 3,
	RDT_NUM_MODES = 4,
};

enum reason_type {
	NOT_ME = 0,
	NOTHING = 1,
	REG_READ = 2,
	REG_WRITE = 3,
	IMM_WRITE = 4,
	OTHERS = 5,
};

enum reboot_mode {
	REBOOT_UNDEFINED = -1,
	REBOOT_COLD = 0,
	REBOOT_WARM = 1,
	REBOOT_HARD = 2,
	REBOOT_SOFT = 3,
	REBOOT_GPIO = 4,
};

enum reboot_type {
	BOOT_TRIPLE = 116,
	BOOT_KBD = 107,
	BOOT_BIOS = 98,
	BOOT_ACPI = 97,
	BOOT_EFI = 101,
	BOOT_CF9_FORCE = 112,
	BOOT_CF9_SAFE = 113,
};

enum ref_state_type {
	REF_TYPE_PTR = 2,
	REF_TYPE_IRQ = 4,
	REF_TYPE_LOCK = 8,
	REF_TYPE_RES_LOCK = 16,
	REF_TYPE_RES_LOCK_IRQ = 32,
	REF_TYPE_LOCK_MASK = 56,
};

enum refcount_saturation_type {
	REFCOUNT_ADD_NOT_ZERO_OVF = 0,
	REFCOUNT_ADD_OVF = 1,
	REFCOUNT_ADD_UAF = 2,
	REFCOUNT_SUB_UAF = 3,
	REFCOUNT_DEC_LEAK = 4,
};

enum reg_arg_type {
	SRC_OP = 0,
	DST_OP = 1,
	DST_OP_NO_MARK = 2,
};

enum reg_type {
	REG_TYPE_RM = 0,
	REG_TYPE_REG = 1,
	REG_TYPE_INDEX = 2,
	REG_TYPE_BASE = 3,
};

enum regcache_type {
	REGCACHE_NONE = 0,
	REGCACHE_RBTREE = 1,
	REGCACHE_FLAT = 2,
	REGCACHE_MAPLE = 3,
};

enum regex_type {
	MATCH_FULL = 0,
	MATCH_FRONT_ONLY = 1,
	MATCH_MIDDLE_ONLY = 2,
	MATCH_END_ONLY = 3,
	MATCH_GLOB = 4,
	MATCH_INDEX = 5,
};

enum regmap_endian {
	REGMAP_ENDIAN_DEFAULT = 0,
	REGMAP_ENDIAN_BIG = 1,
	REGMAP_ENDIAN_LITTLE = 2,
	REGMAP_ENDIAN_NATIVE = 3,
};

enum regulator_active_discharge {
	REGULATOR_ACTIVE_DISCHARGE_DEFAULT = 0,
	REGULATOR_ACTIVE_DISCHARGE_DISABLE = 1,
	REGULATOR_ACTIVE_DISCHARGE_ENABLE = 2,
};

enum regulator_detection_severity {
	REGULATOR_SEVERITY_PROT = 0,
	REGULATOR_SEVERITY_ERR = 1,
	REGULATOR_SEVERITY_WARN = 2,
};

enum regulator_get_type {
	NORMAL_GET = 0,
	EXCLUSIVE_GET = 1,
	OPTIONAL_GET = 2,
	MAX_GET_TYPE = 3,
};

enum regulator_status {
	REGULATOR_STATUS_OFF = 0,
	REGULATOR_STATUS_ON = 1,
	REGULATOR_STATUS_ERROR = 2,
	REGULATOR_STATUS_FAST = 3,
	REGULATOR_STATUS_NORMAL = 4,
	REGULATOR_STATUS_IDLE = 5,
	REGULATOR_STATUS_STANDBY = 6,
	REGULATOR_STATUS_BYPASS = 7,
	REGULATOR_STATUS_UNDEFINED = 8,
};

enum regulator_type {
	REGULATOR_VOLTAGE = 0,
	REGULATOR_CURRENT = 1,
};

enum release_type {
	leaf_only = 0,
	whole_subtree = 1,
};

enum req_flag_bits {
	__REQ_FAILFAST_DEV = 8,
	__REQ_FAILFAST_TRANSPORT = 9,
	__REQ_FAILFAST_DRIVER = 10,
	__REQ_SYNC = 11,
	__REQ_META = 12,
	__REQ_PRIO = 13,
	__REQ_NOMERGE = 14,
	__REQ_IDLE = 15,
	__REQ_INTEGRITY = 16,
	__REQ_FUA = 17,
	__REQ_PREFLUSH = 18,
	__REQ_RAHEAD = 19,
	__REQ_BACKGROUND = 20,
	__REQ_NOWAIT = 21,
	__REQ_POLLED = 22,
	__REQ_ALLOC_CACHE = 23,
	__REQ_SWAP = 24,
	__REQ_DRV = 25,
	__REQ_FS_PRIVATE = 26,
	__REQ_ATOMIC = 27,
	__REQ_P2PDMA = 28,
	__REQ_NOUNMAP = 29,
	__REQ_NR_BITS = 30,
};

enum req_op {
	REQ_OP_READ = 0,
	REQ_OP_WRITE = 1,
	REQ_OP_FLUSH = 2,
	REQ_OP_DISCARD = 3,
	REQ_OP_SECURE_ERASE = 5,
	REQ_OP_ZONE_APPEND = 7,
	REQ_OP_WRITE_ZEROES = 9,
	REQ_OP_ZONE_OPEN = 10,
	REQ_OP_ZONE_CLOSE = 11,
	REQ_OP_ZONE_FINISH = 13,
	REQ_OP_ZONE_RESET = 15,
	REQ_OP_ZONE_RESET_ALL = 17,
	REQ_OP_DRV_IN = 34,
	REQ_OP_DRV_OUT = 35,
	REQ_OP_LAST = 36,
};

enum resctrl_conf_type {
	CDP_NONE = 0,
	CDP_CODE = 1,
	CDP_DATA = 2,
};

enum resctrl_domain_type {
	RESCTRL_CTRL_DOMAIN = 0,
	RESCTRL_MON_DOMAIN = 1,
};

enum resctrl_event_id {
	QOS_L3_OCCUP_EVENT_ID = 1,
	QOS_L3_MBM_TOTAL_EVENT_ID = 2,
	QOS_L3_MBM_LOCAL_EVENT_ID = 3,
	QOS_NUM_EVENTS = 4,
};

enum resctrl_res_level {
	RDT_RESOURCE_L3 = 0,
	RDT_RESOURCE_L2 = 1,
	RDT_RESOURCE_MBA = 2,
	RDT_RESOURCE_SMBA = 3,
	RDT_NUM_RESOURCES = 4,
};

enum resctrl_schema_fmt {
	RESCTRL_SCHEMA_BITMAP = 0,
	RESCTRL_SCHEMA_RANGE = 1,
};

enum resctrl_scope {
	RESCTRL_L2_CACHE = 2,
	RESCTRL_L3_CACHE = 3,
	RESCTRL_L3_NODE = 4,
};

enum reset_control_flags {
	RESET_CONTROL_EXCLUSIVE = 4,
	RESET_CONTROL_EXCLUSIVE_DEASSERTED = 12,
	RESET_CONTROL_EXCLUSIVE_RELEASED = 0,
	RESET_CONTROL_SHARED = 1,
	RESET_CONTROL_SHARED_DEASSERTED = 9,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE = 6,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE_DEASSERTED = 14,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE_RELEASED = 2,
	RESET_CONTROL_OPTIONAL_SHARED = 3,
	RESET_CONTROL_OPTIONAL_SHARED_DEASSERTED = 11,
};

enum resolve_mode {
	RESOLVE_TBD = 0,
	RESOLVE_PTR = 1,
	RESOLVE_STRUCT_OR_ARRAY = 2,
};

enum retbleed_mitigation {
	RETBLEED_MITIGATION_NONE = 0,
	RETBLEED_MITIGATION_AUTO = 1,
	RETBLEED_MITIGATION_UNRET = 2,
	RETBLEED_MITIGATION_IBPB = 3,
	RETBLEED_MITIGATION_IBRS = 4,
	RETBLEED_MITIGATION_EIBRS = 5,
	RETBLEED_MITIGATION_STUFF = 6,
};

enum rfds_mitigations {
	RFDS_MITIGATION_OFF = 0,
	RFDS_MITIGATION_AUTO = 1,
	RFDS_MITIGATION_VERW = 2,
	RFDS_MITIGATION_UCODE_NEEDED = 3,
};

enum ring_buffer_flags {
	RB_FL_OVERWRITE = 1,
};

enum ring_buffer_type {
	RINGBUF_TYPE_DATA_TYPE_LEN_MAX = 28,
	RINGBUF_TYPE_PADDING = 29,
	RINGBUF_TYPE_TIME_EXTEND = 30,
	RINGBUF_TYPE_TIME_STAMP = 31,
};

enum rlimit_type {
	UCOUNT_RLIMIT_NPROC = 0,
	UCOUNT_RLIMIT_MSGQUEUE = 1,
	UCOUNT_RLIMIT_SIGPENDING = 2,
	UCOUNT_RLIMIT_MEMLOCK = 3,
	UCOUNT_RLIMIT_COUNTS = 4,
};

enum rmap_level {
	RMAP_LEVEL_PTE = 0,
	RMAP_LEVEL_PMD = 1,
	RMAP_LEVEL_PUD = 2,
};

enum rmp_flags {
	RMP_LOCKED = 1,
	RMP_USE_SHARED_ZEROPAGE = 2,
};

enum rmqueue_mode {
	RMQUEUE_NORMAL = 0,
	RMQUEUE_CMA = 1,
	RMQUEUE_CLAIM = 2,
	RMQUEUE_STEAL = 3,
};

enum rp_check {
	RP_CHECK_CALL = 0,
	RP_CHECK_CHAIN_CALL = 1,
	RP_CHECK_RET = 2,
};

enum rpm_request {
	RPM_REQ_NONE = 0,
	RPM_REQ_IDLE = 1,
	RPM_REQ_SUSPEND = 2,
	RPM_REQ_AUTOSUSPEND = 3,
	RPM_REQ_RESUME = 4,
};

enum rpm_status {
	RPM_INVALID = -1,
	RPM_ACTIVE = 0,
	RPM_RESUMING = 1,
	RPM_SUSPENDED = 2,
	RPM_SUSPENDING = 3,
	RPM_BLOCKED = 4,
};

enum rproc_crash_type {
	RPROC_MMUFAULT = 0,
	RPROC_WATCHDOG = 1,
	RPROC_FATAL_ERROR = 2,
};

enum rproc_dump_mechanism {
	RPROC_COREDUMP_DISABLED = 0,
	RPROC_COREDUMP_ENABLED = 1,
	RPROC_COREDUMP_INLINE = 2,
};

enum rproc_features {
	RPROC_FEAT_ATTACH_ON_RECOVERY = 0,
	RPROC_MAX_FEATURES = 1,
};

enum rproc_state {
	RPROC_OFFLINE = 0,
	RPROC_SUSPENDED = 1,
	RPROC_RUNNING = 2,
	RPROC_CRASHED = 3,
	RPROC_DELETED = 4,
	RPROC_ATTACHED = 5,
	RPROC_DETACHED = 6,
	RPROC_LAST = 7,
};

enum rq_end_io_ret {
	RQ_END_IO_NONE = 0,
	RQ_END_IO_FREE = 1,
};

enum rq_qos_id {
	RQ_QOS_WBT = 0,
	RQ_QOS_LATENCY = 1,
	RQ_QOS_COST = 2,
};

enum rqf_flags {
	__RQF_STARTED = 0,
	__RQF_FLUSH_SEQ = 1,
	__RQF_MIXED_MERGE = 2,
	__RQF_DONTPREP = 3,
	__RQF_SCHED_TAGS = 4,
	__RQF_USE_SCHED = 5,
	__RQF_FAILED = 6,
	__RQF_QUIET = 7,
	__RQF_IO_STAT = 8,
	__RQF_PM = 9,
	__RQF_HASHED = 10,
	__RQF_STATS = 11,
	__RQF_SPECIAL_PAYLOAD = 12,
	__RQF_ZONE_WRITE_PLUGGING = 13,
	__RQF_TIMED_OUT = 14,
	__RQF_RESV = 15,
	__RQF_BITS = 16,
};

enum rrrr_ids {
	R4_GEN = 0,
	R4_RD = 1,
	R4_WR = 2,
	R4_DRD = 3,
	R4_DWR = 4,
	R4_IRD = 5,
	R4_PREF = 6,
	R4_EVICT = 7,
	R4_SNOOP = 8,
};

enum rsaprivkey_actions {
	ACT_rsa_get_d = 0,
	ACT_rsa_get_dp = 1,
	ACT_rsa_get_dq = 2,
	ACT_rsa_get_e = 3,
	ACT_rsa_get_n = 4,
	ACT_rsa_get_p = 5,
	ACT_rsa_get_q = 6,
	ACT_rsa_get_qinv = 7,
	NR__rsaprivkey_actions = 8,
};

enum rsapubkey_actions {
	ACT_rsa_get_e___2 = 0,
	ACT_rsa_get_n___2 = 1,
	NR__rsapubkey_actions = 2,
};

enum rsc_handling_status {
	RSC_HANDLED = 0,
	RSC_IGNORED = 1,
};

enum rseq_cpu_id_state {
	RSEQ_CPU_ID_UNINITIALIZED = -1,
	RSEQ_CPU_ID_REGISTRATION_FAILED = -2,
};

enum rseq_cs_flags {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL = 2,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE = 4,
};

enum rseq_cs_flags_bit {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT_BIT = 0,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL_BIT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE_BIT = 2,
};

enum rseq_event_mask_bits {
	RSEQ_EVENT_PREEMPT_BIT = 0,
	RSEQ_EVENT_SIGNAL_BIT = 1,
	RSEQ_EVENT_MIGRATE_BIT = 2,
};

enum rseq_flags {
	RSEQ_FLAG_UNREGISTER = 1,
};

enum rt6_nud_state {
	RT6_NUD_FAIL_HARD = -3,
	RT6_NUD_FAIL_PROBE = -2,
	RT6_NUD_FAIL_DO_RR = -1,
	RT6_NUD_SUCCEED = 1,
};

enum rt_class_t {
	RT_TABLE_UNSPEC = 0,
	RT_TABLE_COMPAT = 252,
	RT_TABLE_DEFAULT = 253,
	RT_TABLE_MAIN = 254,
	RT_TABLE_LOCAL = 255,
	RT_TABLE_MAX = 4294967295,
};

enum rt_scope_t {
	RT_SCOPE_UNIVERSE = 0,
	RT_SCOPE_SITE = 200,
	RT_SCOPE_LINK = 253,
	RT_SCOPE_HOST = 254,
	RT_SCOPE_NOWHERE = 255,
};

enum rtattr_type_t {
	RTA_UNSPEC = 0,
	RTA_DST = 1,
	RTA_SRC = 2,
	RTA_IIF = 3,
	RTA_OIF = 4,
	RTA_GATEWAY = 5,
	RTA_PRIORITY = 6,
	RTA_PREFSRC = 7,
	RTA_METRICS = 8,
	RTA_MULTIPATH = 9,
	RTA_PROTOINFO = 10,
	RTA_FLOW = 11,
	RTA_CACHEINFO = 12,
	RTA_SESSION = 13,
	RTA_MP_ALGO = 14,
	RTA_TABLE = 15,
	RTA_MARK = 16,
	RTA_MFC_STATS = 17,
	RTA_VIA = 18,
	RTA_NEWDST = 19,
	RTA_PREF = 20,
	RTA_ENCAP_TYPE = 21,
	RTA_ENCAP = 22,
	RTA_EXPIRES = 23,
	RTA_PAD = 24,
	RTA_UID = 25,
	RTA_TTL_PROPAGATE = 26,
	RTA_IP_PROTO = 27,
	RTA_SPORT = 28,
	RTA_DPORT = 29,
	RTA_NH_ID = 30,
	RTA_FLOWLABEL = 31,
	__RTA_MAX = 32,
};

enum rtmutex_chainwalk {
	RT_MUTEX_MIN_CHAINWALK = 0,
	RT_MUTEX_FULL_CHAINWALK = 1,
};

enum rtnetlink_groups {
	RTNLGRP_NONE = 0,
	RTNLGRP_LINK = 1,
	RTNLGRP_NOTIFY = 2,
	RTNLGRP_NEIGH = 3,
	RTNLGRP_TC = 4,
	RTNLGRP_IPV4_IFADDR = 5,
	RTNLGRP_IPV4_MROUTE = 6,
	RTNLGRP_IPV4_ROUTE = 7,
	RTNLGRP_IPV4_RULE = 8,
	RTNLGRP_IPV6_IFADDR = 9,
	RTNLGRP_IPV6_MROUTE = 10,
	RTNLGRP_IPV6_ROUTE = 11,
	RTNLGRP_IPV6_IFINFO = 12,
	RTNLGRP_DECnet_IFADDR = 13,
	RTNLGRP_NOP2 = 14,
	RTNLGRP_DECnet_ROUTE = 15,
	RTNLGRP_DECnet_RULE = 16,
	RTNLGRP_NOP4 = 17,
	RTNLGRP_IPV6_PREFIX = 18,
	RTNLGRP_IPV6_RULE = 19,
	RTNLGRP_ND_USEROPT = 20,
	RTNLGRP_PHONET_IFADDR = 21,
	RTNLGRP_PHONET_ROUTE = 22,
	RTNLGRP_DCB = 23,
	RTNLGRP_IPV4_NETCONF = 24,
	RTNLGRP_IPV6_NETCONF = 25,
	RTNLGRP_MDB = 26,
	RTNLGRP_MPLS_ROUTE = 27,
	RTNLGRP_NSID = 28,
	RTNLGRP_MPLS_NETCONF = 29,
	RTNLGRP_IPV4_MROUTE_R = 30,
	RTNLGRP_IPV6_MROUTE_R = 31,
	RTNLGRP_NEXTHOP = 32,
	RTNLGRP_BRVLAN = 33,
	RTNLGRP_MCTP_IFADDR = 34,
	RTNLGRP_TUNNEL = 35,
	RTNLGRP_STATS = 36,
	RTNLGRP_IPV4_MCADDR = 37,
	RTNLGRP_IPV6_MCADDR = 38,
	RTNLGRP_IPV6_ACADDR = 39,
	__RTNLGRP_MAX = 40,
};

enum rtnl_kinds {
	RTNL_KIND_NEW = 0,
	RTNL_KIND_DEL = 1,
	RTNL_KIND_GET = 2,
	RTNL_KIND_SET = 3,
};

enum rtnl_link_flags {
	RTNL_FLAG_DOIT_UNLOCKED = 1,
	RTNL_FLAG_BULK_DEL_SUPPORTED = 2,
	RTNL_FLAG_DUMP_UNLOCKED = 4,
	RTNL_FLAG_DUMP_SPLIT_NLM_DONE = 8,
};

enum rw_hint {
	WRITE_LIFE_NOT_SET = 0,
	WRITE_LIFE_NONE = 1,
	WRITE_LIFE_SHORT = 2,
	WRITE_LIFE_MEDIUM = 3,
	WRITE_LIFE_LONG = 4,
	WRITE_LIFE_EXTREME = 5,
} __attribute__((mode(byte)));

enum rwsem_waiter_type {
	RWSEM_WAITING_FOR_WRITE = 0,
	RWSEM_WAITING_FOR_READ = 1,
};

enum rwsem_wake_type {
	RWSEM_WAKE_ANY = 0,
	RWSEM_WAKE_READERS = 1,
	RWSEM_WAKE_READ_OWNED = 2,
};

enum rx_handler_result {
	RX_HANDLER_CONSUMED = 0,
	RX_HANDLER_ANOTHER = 1,
	RX_HANDLER_EXACT = 2,
	RX_HANDLER_PASS = 3,
};

typedef enum rx_handler_result rx_handler_result_t;

enum s2idle_states {
	S2IDLE_STATE_NONE = 0,
	S2IDLE_STATE_ENTER = 1,
	S2IDLE_STATE_WAKE = 2,
};

enum s_alloc {
	sa_rootdomain = 0,
	sa_sd = 1,
	sa_sd_storage = 2,
	sa_none = 3,
};

enum sam_status {
	SAM_STAT_GOOD = 0,
	SAM_STAT_CHECK_CONDITION = 2,
	SAM_STAT_CONDITION_MET = 4,
	SAM_STAT_BUSY = 8,
	SAM_STAT_INTERMEDIATE = 16,
	SAM_STAT_INTERMEDIATE_CONDITION_MET = 20,
	SAM_STAT_RESERVATION_CONFLICT = 24,
	SAM_STAT_COMMAND_TERMINATED = 34,
	SAM_STAT_TASK_SET_FULL = 40,
	SAM_STAT_ACA_ACTIVE = 48,
	SAM_STAT_TASK_ABORTED = 64,
};

enum scan_balance {
	SCAN_EQUAL = 0,
	SCAN_FRACT = 1,
	SCAN_ANON = 2,
	SCAN_FILE = 3,
};

enum scan_result {
	SCAN_FAIL = 0,
	SCAN_SUCCEED = 1,
	SCAN_PMD_NULL = 2,
	SCAN_PMD_NONE = 3,
	SCAN_PMD_MAPPED = 4,
	SCAN_EXCEED_NONE_PTE = 5,
	SCAN_EXCEED_SWAP_PTE = 6,
	SCAN_EXCEED_SHARED_PTE = 7,
	SCAN_PTE_NON_PRESENT = 8,
	SCAN_PTE_UFFD_WP = 9,
	SCAN_PTE_MAPPED_HUGEPAGE = 10,
	SCAN_PAGE_RO = 11,
	SCAN_LACK_REFERENCED_PAGE = 12,
	SCAN_PAGE_NULL = 13,
	SCAN_SCAN_ABORT = 14,
	SCAN_PAGE_COUNT = 15,
	SCAN_PAGE_LRU = 16,
	SCAN_PAGE_LOCK = 17,
	SCAN_PAGE_ANON = 18,
	SCAN_PAGE_COMPOUND = 19,
	SCAN_ANY_PROCESS = 20,
	SCAN_VMA_NULL = 21,
	SCAN_VMA_CHECK = 22,
	SCAN_ADDRESS_RANGE = 23,
	SCAN_DEL_PAGE_LRU = 24,
	SCAN_ALLOC_HUGE_PAGE_FAIL = 25,
	SCAN_CGROUP_CHARGE_FAIL = 26,
	SCAN_TRUNCATED = 27,
	SCAN_PAGE_HAS_PRIVATE = 28,
	SCAN_STORE_FAILED = 29,
	SCAN_COPY_MC = 30,
	SCAN_PAGE_FILLED = 31,
};

enum sched_tunable_scaling {
	SCHED_TUNABLESCALING_NONE = 0,
	SCHED_TUNABLESCALING_LOG = 1,
	SCHED_TUNABLESCALING_LINEAR = 2,
	SCHED_TUNABLESCALING_END = 3,
};

enum scrub_type {
	SCRUB_UNKNOWN = 0,
	SCRUB_NONE = 1,
	SCRUB_SW_PROG = 2,
	SCRUB_SW_SRC = 3,
	SCRUB_SW_PROG_SRC = 4,
	SCRUB_SW_TUNABLE = 5,
	SCRUB_HW_PROG = 6,
	SCRUB_HW_SRC = 7,
	SCRUB_HW_PROG_SRC = 8,
	SCRUB_HW_TUNABLE = 9,
};

enum scsi_cmnd_submitter {
	SUBMITTED_BY_BLOCK_LAYER = 0,
	SUBMITTED_BY_SCSI_ERROR_HANDLER = 1,
	SUBMITTED_BY_SCSI_RESET_IOCTL = 2,
} __attribute__((mode(byte)));

enum scsi_device_event {
	SDEV_EVT_MEDIA_CHANGE = 1,
	SDEV_EVT_INQUIRY_CHANGE_REPORTED = 2,
	SDEV_EVT_CAPACITY_CHANGE_REPORTED = 3,
	SDEV_EVT_SOFT_THRESHOLD_REACHED_REPORTED = 4,
	SDEV_EVT_MODE_PARAMETER_CHANGE_REPORTED = 5,
	SDEV_EVT_LUN_CHANGE_REPORTED = 6,
	SDEV_EVT_ALUA_STATE_CHANGE_REPORTED = 7,
	SDEV_EVT_POWER_ON_RESET_OCCURRED = 8,
	SDEV_EVT_FIRST = 1,
	SDEV_EVT_LAST = 8,
	SDEV_EVT_MAXBITS = 9,
};

enum scsi_device_state {
	SDEV_CREATED = 1,
	SDEV_RUNNING = 2,
	SDEV_CANCEL = 3,
	SDEV_DEL = 4,
	SDEV_QUIESCE = 5,
	SDEV_OFFLINE = 6,
	SDEV_TRANSPORT_OFFLINE = 7,
	SDEV_BLOCK = 8,
	SDEV_CREATED_BLOCK = 9,
};

enum scsi_devinfo_key {
	SCSI_DEVINFO_GLOBAL = 0,
	SCSI_DEVINFO_SPI = 1,
};

enum scsi_disposition {
	NEEDS_RETRY = 8193,
	SUCCESS = 8194,
	FAILED = 8195,
	QUEUED = 8196,
	SOFT_ERROR = 8197,
	ADD_TO_MLQUEUE = 8198,
	TIMEOUT_ERROR = 8199,
	SCSI_RETURN_NOT_HANDLED = 8200,
	FAST_IO_FAIL = 8201,
};

enum scsi_host_guard_type {
	SHOST_DIX_GUARD_CRC = 1,
	SHOST_DIX_GUARD_IP = 2,
};

enum scsi_host_prot_capabilities {
	SHOST_DIF_TYPE1_PROTECTION = 1,
	SHOST_DIF_TYPE2_PROTECTION = 2,
	SHOST_DIF_TYPE3_PROTECTION = 4,
	SHOST_DIX_TYPE0_PROTECTION = 8,
	SHOST_DIX_TYPE1_PROTECTION = 16,
	SHOST_DIX_TYPE2_PROTECTION = 32,
	SHOST_DIX_TYPE3_PROTECTION = 64,
};

enum scsi_host_state {
	SHOST_CREATED = 1,
	SHOST_RUNNING = 2,
	SHOST_CANCEL = 3,
	SHOST_DEL = 4,
	SHOST_RECOVERY = 5,
	SHOST_CANCEL_RECOVERY = 6,
	SHOST_DEL_RECOVERY = 7,
};

enum scsi_host_status {
	DID_OK = 0,
	DID_NO_CONNECT = 1,
	DID_BUS_BUSY = 2,
	DID_TIME_OUT = 3,
	DID_BAD_TARGET = 4,
	DID_ABORT = 5,
	DID_PARITY = 6,
	DID_ERROR = 7,
	DID_RESET = 8,
	DID_BAD_INTR = 9,
	DID_PASSTHROUGH = 10,
	DID_SOFT_ERROR = 11,
	DID_IMM_RETRY = 12,
	DID_REQUEUE = 13,
	DID_TRANSPORT_DISRUPTED = 14,
	DID_TRANSPORT_FAILFAST = 15,
	DID_TRANSPORT_MARGINAL = 20,
};

enum scsi_ml_status {
	SCSIML_STAT_OK = 0,
	SCSIML_STAT_RESV_CONFLICT = 1,
	SCSIML_STAT_NOSPC = 2,
	SCSIML_STAT_MED_ERROR = 3,
	SCSIML_STAT_TGT_FAILURE = 4,
	SCSIML_STAT_DL_TIMEOUT = 5,
};

enum scsi_msg_byte {
	COMMAND_COMPLETE = 0,
	EXTENDED_MESSAGE = 1,
	SAVE_POINTERS = 2,
	RESTORE_POINTERS = 3,
	DISCONNECT = 4,
	INITIATOR_ERROR = 5,
	ABORT_TASK_SET = 6,
	MESSAGE_REJECT = 7,
	NOP___2 = 8,
	MSG_PARITY_ERROR = 9,
	LINKED_CMD_COMPLETE = 10,
	LINKED_FLG_CMD_COMPLETE = 11,
	TARGET_RESET = 12,
	ABORT_TASK = 13,
	CLEAR_TASK_SET = 14,
	INITIATE_RECOVERY = 15,
	RELEASE_RECOVERY = 16,
	TERMINATE_IO_PROC = 17,
	CLEAR_ACA = 22,
	LOGICAL_UNIT_RESET = 23,
	SIMPLE_QUEUE_TAG = 32,
	HEAD_OF_QUEUE_TAG = 33,
	ORDERED_QUEUE_TAG = 34,
	IGNORE_WIDE_RESIDUE = 35,
	ACA = 36,
	QAS_REQUEST = 85,
	BUS_DEVICE_RESET = 12,
	ABORT = 6,
};

enum scsi_pr_type {
	SCSI_PR_WRITE_EXCLUSIVE = 1,
	SCSI_PR_EXCLUSIVE_ACCESS = 3,
	SCSI_PR_WRITE_EXCLUSIVE_REG_ONLY = 5,
	SCSI_PR_EXCLUSIVE_ACCESS_REG_ONLY = 6,
	SCSI_PR_WRITE_EXCLUSIVE_ALL_REGS = 7,
	SCSI_PR_EXCLUSIVE_ACCESS_ALL_REGS = 8,
};

enum scsi_prot_flags {
	SCSI_PROT_TRANSFER_PI = 1,
	SCSI_PROT_GUARD_CHECK = 2,
	SCSI_PROT_REF_CHECK = 4,
	SCSI_PROT_REF_INCREMENT = 8,
	SCSI_PROT_IP_CHECKSUM = 16,
};

enum scsi_prot_operations {
	SCSI_PROT_NORMAL = 0,
	SCSI_PROT_READ_INSERT = 1,
	SCSI_PROT_WRITE_STRIP = 2,
	SCSI_PROT_READ_STRIP = 3,
	SCSI_PROT_WRITE_INSERT = 4,
	SCSI_PROT_READ_PASS = 5,
	SCSI_PROT_WRITE_PASS = 6,
};

enum scsi_scan_mode {
	SCSI_SCAN_INITIAL = 0,
	SCSI_SCAN_RESCAN = 1,
	SCSI_SCAN_MANUAL = 2,
};

enum scsi_target_state {
	STARGET_CREATED = 1,
	STARGET_RUNNING = 2,
	STARGET_REMOVE = 3,
	STARGET_CREATED_REMOVE = 4,
	STARGET_DEL = 5,
};

enum scsi_timeout_action {
	SCSI_EH_DONE = 0,
	SCSI_EH_RESET_TIMER = 1,
	SCSI_EH_NOT_HANDLED = 2,
};

enum scsi_timeouts {
	SCSI_DEFAULT_EH_TIMEOUT = 10000,
};

enum scsi_vpd_parameters {
	SCSI_VPD_HEADER_SIZE = 4,
	SCSI_VPD_LIST_SIZE = 36,
};

enum sctp_cid {
	SCTP_CID_DATA = 0,
	SCTP_CID_INIT = 1,
	SCTP_CID_INIT_ACK = 2,
	SCTP_CID_SACK = 3,
	SCTP_CID_HEARTBEAT = 4,
	SCTP_CID_HEARTBEAT_ACK = 5,
	SCTP_CID_ABORT = 6,
	SCTP_CID_SHUTDOWN = 7,
	SCTP_CID_SHUTDOWN_ACK = 8,
	SCTP_CID_ERROR = 9,
	SCTP_CID_COOKIE_ECHO = 10,
	SCTP_CID_COOKIE_ACK = 11,
	SCTP_CID_ECN_ECNE = 12,
	SCTP_CID_ECN_CWR = 13,
	SCTP_CID_SHUTDOWN_COMPLETE = 14,
	SCTP_CID_AUTH = 15,
	SCTP_CID_I_DATA = 64,
	SCTP_CID_FWD_TSN = 192,
	SCTP_CID_ASCONF = 193,
	SCTP_CID_I_FWD_TSN = 194,
	SCTP_CID_ASCONF_ACK = 128,
	SCTP_CID_RECONF = 130,
	SCTP_CID_PAD = 132,
};

enum sctp_conntrack {
	SCTP_CONNTRACK_NONE = 0,
	SCTP_CONNTRACK_CLOSED = 1,
	SCTP_CONNTRACK_COOKIE_WAIT = 2,
	SCTP_CONNTRACK_COOKIE_ECHOED = 3,
	SCTP_CONNTRACK_ESTABLISHED = 4,
	SCTP_CONNTRACK_SHUTDOWN_SENT = 5,
	SCTP_CONNTRACK_SHUTDOWN_RECD = 6,
	SCTP_CONNTRACK_SHUTDOWN_ACK_SENT = 7,
	SCTP_CONNTRACK_HEARTBEAT_SENT = 8,
	SCTP_CONNTRACK_HEARTBEAT_ACKED = 9,
	SCTP_CONNTRACK_MAX = 10,
};

enum sctp_endpoint_type {
	SCTP_EP_TYPE_SOCKET = 0,
	SCTP_EP_TYPE_ASSOCIATION = 1,
};

enum sctp_event_timeout {
	SCTP_EVENT_TIMEOUT_NONE = 0,
	SCTP_EVENT_TIMEOUT_T1_COOKIE = 1,
	SCTP_EVENT_TIMEOUT_T1_INIT = 2,
	SCTP_EVENT_TIMEOUT_T2_SHUTDOWN = 3,
	SCTP_EVENT_TIMEOUT_T3_RTX = 4,
	SCTP_EVENT_TIMEOUT_T4_RTO = 5,
	SCTP_EVENT_TIMEOUT_T5_SHUTDOWN_GUARD = 6,
	SCTP_EVENT_TIMEOUT_HEARTBEAT = 7,
	SCTP_EVENT_TIMEOUT_RECONF = 8,
	SCTP_EVENT_TIMEOUT_PROBE = 9,
	SCTP_EVENT_TIMEOUT_SACK = 10,
	SCTP_EVENT_TIMEOUT_AUTOCLOSE = 11,
};

enum sctp_msg_flags {
	MSG_NOTIFICATION = 32768,
};

enum sctp_param {
	SCTP_PARAM_HEARTBEAT_INFO = 256,
	SCTP_PARAM_IPV4_ADDRESS = 1280,
	SCTP_PARAM_IPV6_ADDRESS = 1536,
	SCTP_PARAM_STATE_COOKIE = 1792,
	SCTP_PARAM_UNRECOGNIZED_PARAMETERS = 2048,
	SCTP_PARAM_COOKIE_PRESERVATIVE = 2304,
	SCTP_PARAM_HOST_NAME_ADDRESS = 2816,
	SCTP_PARAM_SUPPORTED_ADDRESS_TYPES = 3072,
	SCTP_PARAM_ECN_CAPABLE = 128,
	SCTP_PARAM_RANDOM = 640,
	SCTP_PARAM_CHUNKS = 896,
	SCTP_PARAM_HMAC_ALGO = 1152,
	SCTP_PARAM_SUPPORTED_EXT = 2176,
	SCTP_PARAM_FWD_TSN_SUPPORT = 192,
	SCTP_PARAM_ADD_IP = 448,
	SCTP_PARAM_DEL_IP = 704,
	SCTP_PARAM_ERR_CAUSE = 960,
	SCTP_PARAM_SET_PRIMARY = 1216,
	SCTP_PARAM_SUCCESS_REPORT = 1472,
	SCTP_PARAM_ADAPTATION_LAYER_IND = 1728,
	SCTP_PARAM_RESET_OUT_REQUEST = 3328,
	SCTP_PARAM_RESET_IN_REQUEST = 3584,
	SCTP_PARAM_RESET_TSN_REQUEST = 3840,
	SCTP_PARAM_RESET_RESPONSE = 4096,
	SCTP_PARAM_RESET_ADD_OUT_STREAMS = 4352,
	SCTP_PARAM_RESET_ADD_IN_STREAMS = 4608,
};

enum sctp_scope {
	SCTP_SCOPE_GLOBAL = 0,
	SCTP_SCOPE_PRIVATE = 1,
	SCTP_SCOPE_LINK = 2,
	SCTP_SCOPE_LOOPBACK = 3,
	SCTP_SCOPE_UNUSABLE = 4,
};

enum sctp_socket_type {
	SCTP_SOCKET_UDP = 0,
	SCTP_SOCKET_UDP_HIGH_BANDWIDTH = 1,
	SCTP_SOCKET_TCP = 2,
};

enum sctp_state {
	SCTP_STATE_CLOSED = 0,
	SCTP_STATE_COOKIE_WAIT = 1,
	SCTP_STATE_COOKIE_ECHOED = 2,
	SCTP_STATE_ESTABLISHED = 3,
	SCTP_STATE_SHUTDOWN_PENDING = 4,
	SCTP_STATE_SHUTDOWN_SENT = 5,
	SCTP_STATE_SHUTDOWN_RECEIVED = 6,
	SCTP_STATE_SHUTDOWN_ACK_SENT = 7,
};

enum scx_consts {
	SCX_DSP_DFL_MAX_BATCH = 32,
	SCX_DSP_MAX_LOOPS = 32,
	SCX_WATCHDOG_MAX_TIMEOUT = 30000,
	SCX_EXIT_BT_LEN = 64,
	SCX_EXIT_MSG_LEN = 1024,
	SCX_EXIT_DUMP_DFL_LEN = 32768,
	SCX_CPUPERF_ONE = 1024,
	SCX_TASK_ITER_BATCH = 32,
};

enum scx_cpu_preempt_reason {
	SCX_CPU_PREEMPT_RT = 0,
	SCX_CPU_PREEMPT_DL = 1,
	SCX_CPU_PREEMPT_STOP = 2,
	SCX_CPU_PREEMPT_UNKNOWN = 3,
};

enum scx_deq_flags {
	SCX_DEQ_SLEEP = 1ULL,
	SCX_DEQ_CORE_SCHED_EXEC = 4294967296ULL,
};

enum scx_dsq_id_flags {
	SCX_DSQ_FLAG_BUILTIN = 9223372036854775808ULL,
	SCX_DSQ_FLAG_LOCAL_ON = 4611686018427387904ULL,
	SCX_DSQ_INVALID = 9223372036854775808ULL,
	SCX_DSQ_GLOBAL = 9223372036854775809ULL,
	SCX_DSQ_LOCAL = 9223372036854775810ULL,
	SCX_DSQ_LOCAL_ON = 13835058055282163712ULL,
	SCX_DSQ_LOCAL_CPU_MASK = 4294967295ULL,
};

enum scx_dsq_iter_flags {
	SCX_DSQ_ITER_REV = 65536,
	__SCX_DSQ_ITER_HAS_SLICE = 1073741824,
	__SCX_DSQ_ITER_HAS_VTIME = 2147483648,
	__SCX_DSQ_ITER_USER_FLAGS = 65536,
	__SCX_DSQ_ITER_ALL_FLAGS = 3221291008,
};

enum scx_dsq_lnode_flags {
	SCX_DSQ_LNODE_ITER_CURSOR = 1,
	__SCX_DSQ_LNODE_PRIV_SHIFT = 16,
};

enum scx_enable_state {
	SCX_ENABLING = 0,
	SCX_ENABLED = 1,
	SCX_DISABLING = 2,
	SCX_DISABLED = 3,
};

enum scx_enq_flags {
	SCX_ENQ_WAKEUP = 1ULL,
	SCX_ENQ_HEAD = 16ULL,
	SCX_ENQ_CPU_SELECTED = 1024ULL,
	SCX_ENQ_PREEMPT = 4294967296ULL,
	SCX_ENQ_REENQ = 1099511627776ULL,
	SCX_ENQ_LAST = 2199023255552ULL,
	__SCX_ENQ_INTERNAL_MASK = 18374686479671623680ULL,
	SCX_ENQ_CLEAR_OPSS = 72057594037927936ULL,
	SCX_ENQ_DSQ_PRIQ = 144115188075855872ULL,
};

enum scx_ent_dsq_flags {
	SCX_TASK_DSQ_ON_PRIQ = 1,
};

enum scx_ent_flags {
	SCX_TASK_QUEUED = 1,
	SCX_TASK_RESET_RUNNABLE_AT = 4,
	SCX_TASK_DEQD_FOR_SLEEP = 8,
	SCX_TASK_STATE_SHIFT = 8,
	SCX_TASK_STATE_BITS = 2,
	SCX_TASK_STATE_MASK = 768,
	SCX_TASK_CURSOR = -2147483648,
};

enum scx_exit_code {
	SCX_ECODE_RSN_HOTPLUG = 4294967296ULL,
	SCX_ECODE_ACT_RESTART = 281474976710656ULL,
};

enum scx_exit_kind {
	SCX_EXIT_NONE = 0,
	SCX_EXIT_DONE = 1,
	SCX_EXIT_UNREG = 64,
	SCX_EXIT_UNREG_BPF = 65,
	SCX_EXIT_UNREG_KERN = 66,
	SCX_EXIT_SYSRQ = 67,
	SCX_EXIT_ERROR = 1024,
	SCX_EXIT_ERROR_BPF = 1025,
	SCX_EXIT_ERROR_STALL = 1026,
};

enum scx_kf_mask {
	SCX_KF_UNLOCKED = 0,
	SCX_KF_CPU_RELEASE = 1,
	SCX_KF_DISPATCH = 2,
	SCX_KF_ENQUEUE = 4,
	SCX_KF_SELECT_CPU = 8,
	SCX_KF_REST = 16,
	__SCX_KF_RQ_LOCKED = 31,
	__SCX_KF_TERMINAL = 28,
};

enum scx_kick_flags {
	SCX_KICK_IDLE = 1,
	SCX_KICK_PREEMPT = 2,
	SCX_KICK_WAIT = 4,
};

enum scx_opi {
	SCX_OPI_BEGIN = 0,
	SCX_OPI_NORMAL_BEGIN = 0,
	SCX_OPI_NORMAL_END = 30,
	SCX_OPI_CPU_HOTPLUG_BEGIN = 30,
	SCX_OPI_CPU_HOTPLUG_END = 32,
	SCX_OPI_END = 32,
};

enum scx_ops_flags {
	SCX_OPS_KEEP_BUILTIN_IDLE = 1ULL,
	SCX_OPS_ENQ_LAST = 2ULL,
	SCX_OPS_ENQ_EXITING = 4ULL,
	SCX_OPS_SWITCH_PARTIAL = 8ULL,
	SCX_OPS_ENQ_MIGRATION_DISABLED = 16ULL,
	SCX_OPS_ALLOW_QUEUED_WAKEUP = 32ULL,
	SCX_OPS_BUILTIN_IDLE_PER_NODE = 64ULL,
	SCX_OPS_HAS_CGROUP_WEIGHT = 65536ULL,
	SCX_OPS_ALL_FLAGS = 65663ULL,
	__SCX_OPS_INTERNAL_MASK = 18374686479671623680ULL,
	SCX_OPS_HAS_CPU_PREEMPT = 72057594037927936ULL,
};

enum scx_ops_state {
	SCX_OPSS_NONE = 0,
	SCX_OPSS_QUEUEING = 1,
	SCX_OPSS_QUEUED = 2,
	SCX_OPSS_DISPATCHING = 3,
	SCX_OPSS_QSEQ_SHIFT = 2,
};

enum scx_pick_idle_cpu_flags {
	SCX_PICK_IDLE_CORE = 1,
	SCX_PICK_IDLE_IN_NODE = 2,
};

enum scx_public_consts {
	SCX_OPS_NAME_LEN = 128ULL,
	SCX_SLICE_DFL = 20000000ULL,
	SCX_SLICE_INF = 18446744073709551615ULL,
};

enum scx_rq_flags {
	SCX_RQ_ONLINE = 1,
	SCX_RQ_CAN_STOP_TICK = 2,
	SCX_RQ_BAL_PENDING = 4,
	SCX_RQ_BAL_KEEP = 8,
	SCX_RQ_BYPASSING = 16,
	SCX_RQ_CLK_VALID = 32,
	SCX_RQ_IN_WAKEUP = 65536,
	SCX_RQ_IN_BALANCE = 131072,
};

enum scx_task_state {
	SCX_TASK_NONE = 0,
	SCX_TASK_INIT = 1,
	SCX_TASK_READY = 2,
	SCX_TASK_ENABLED = 3,
	SCX_TASK_NR_STATES = 4,
};

enum scx_tg_flags {
	SCX_TG_ONLINE = 1,
	SCX_TG_INITED = 2,
};

enum scx_wake_flags {
	SCX_WAKE_FORK = 4,
	SCX_WAKE_TTWU = 8,
	SCX_WAKE_SYNC = 16,
};

enum security_cmd_enabled_bits {
	CXL_SEC_ENABLED_SANITIZE = 0,
	CXL_SEC_ENABLED_SECURE_ERASE = 1,
	CXL_SEC_ENABLED_GET_SECURITY_STATE = 2,
	CXL_SEC_ENABLED_SET_PASSPHRASE = 3,
	CXL_SEC_ENABLED_DISABLE_PASSPHRASE = 4,
	CXL_SEC_ENABLED_UNLOCK = 5,
	CXL_SEC_ENABLED_FREEZE_SECURITY = 6,
	CXL_SEC_ENABLED_PASSPHRASE_SECURE_ERASE = 7,
	CXL_SEC_ENABLED_MAX = 8,
};

enum seg6_end_dt_mode {
	DT_INVALID_MODE = -22,
	DT_LEGACY_MODE = 0,
	DT_VRF_MODE = 1,
};

enum seg6_local_flv_action {
	SEG6_LOCAL_FLV_ACT_UNSPEC = 0,
	SEG6_LOCAL_FLV_ACT_END = 1,
	SEG6_LOCAL_FLV_ACT_PSP = 2,
	SEG6_LOCAL_FLV_ACT_USP = 3,
	SEG6_LOCAL_FLV_ACT_USD = 4,
	__SEG6_LOCAL_FLV_ACT_MAX = 5,
};

enum seg6_local_pktinfo {
	SEG6_LOCAL_PKTINFO_NOHDR = 0,
	SEG6_LOCAL_PKTINFO_SL_ZERO = 1,
	SEG6_LOCAL_PKTINFO_SL_ONE = 2,
	SEG6_LOCAL_PKTINFO_SL_MORE = 3,
	__SEG6_LOCAL_PKTINFO_MAX = 4,
};

enum sel_inos {
	SEL_ROOT_INO = 2,
	SEL_LOAD = 3,
	SEL_ENFORCE = 4,
	SEL_CONTEXT = 5,
	SEL_ACCESS = 6,
	SEL_CREATE = 7,
	SEL_RELABEL = 8,
	SEL_USER = 9,
	SEL_POLICYVERS = 10,
	SEL_COMMIT_BOOLS = 11,
	SEL_MLS = 12,
	SEL_DISABLE = 13,
	SEL_MEMBER = 14,
	SEL_CHECKREQPROT = 15,
	SEL_COMPAT_NET = 16,
	SEL_REJECT_UNKNOWN = 17,
	SEL_DENY_UNKNOWN = 18,
	SEL_STATUS = 19,
	SEL_POLICY = 20,
	SEL_VALIDATE_TRANS = 21,
	SEL_INO_NEXT = 22,
};

enum selinux_nlgroups {
	SELNLGRP_NONE = 0,
	SELNLGRP_AVC = 1,
	__SELNLGRP_MAX = 2,
};

enum ser {
	SER_REQUIRED = 1,
	NO_SER = 2,
};

enum serdev_parity {
	SERDEV_PARITY_NONE = 0,
	SERDEV_PARITY_EVEN = 1,
	SERDEV_PARITY_ODD = 2,
};

enum serio_event_type {
	SERIO_RESCAN_PORT = 0,
	SERIO_RECONNECT_PORT = 1,
	SERIO_RECONNECT_SUBTREE = 2,
	SERIO_REGISTER_PORT = 3,
	SERIO_ATTACH_DRIVER = 4,
};

enum set_event_iter_type {
	SET_EVENT_FILE = 0,
	SET_EVENT_MOD = 1,
};

enum setid_type {
	UID = 0,
	GID = 1,
};

enum severity_level {
	MCE_NO_SEVERITY = 0,
	MCE_DEFERRED_SEVERITY = 1,
	MCE_UCNA_SEVERITY = 1,
	MCE_KEEP_SEVERITY = 2,
	MCE_SOME_SEVERITY = 3,
	MCE_AO_SEVERITY = 4,
	MCE_UC_SEVERITY = 5,
	MCE_AR_SEVERITY = 6,
	MCE_PANIC_SEVERITY = 7,
};

enum sgp_type {
	SGP_READ = 0,
	SGP_NOALLOC = 1,
	SGP_CACHE = 2,
	SGP_WRITE = 3,
	SGP_FALLOC = 4,
};

enum sgx_attribute {
	SGX_ATTR_INIT = 1,
	SGX_ATTR_DEBUG = 2,
	SGX_ATTR_MODE64BIT = 4,
	SGX_ATTR_PROVISIONKEY = 16,
	SGX_ATTR_EINITTOKENKEY = 32,
	SGX_ATTR_KSS = 128,
	SGX_ATTR_ASYNC_EXIT_NOTIFY = 1024,
};

enum sgx_encl_flags {
	SGX_ENCL_IOCTL = 1,
	SGX_ENCL_DEBUG = 2,
	SGX_ENCL_CREATED = 4,
	SGX_ENCL_INITIALIZED = 8,
};

enum sgx_encls_function {
	ECREATE = 0,
	EADD = 1,
	EINIT = 2,
	EREMOVE = 3,
	EDGBRD = 4,
	EDGBWR = 5,
	EEXTEND = 6,
	ELDU = 8,
	EBLOCK = 9,
	EPA = 10,
	EWB = 11,
	ETRACK = 12,
	EAUG = 13,
	EMODPR = 14,
	EMODT = 15,
};

enum sgx_page_flags {
	SGX_PAGE_MEASURE = 1,
};

enum sgx_page_type {
	SGX_PAGE_TYPE_SECS = 0,
	SGX_PAGE_TYPE_TCS = 1,
	SGX_PAGE_TYPE_REG = 2,
	SGX_PAGE_TYPE_VA = 3,
	SGX_PAGE_TYPE_TRIM = 4,
};

enum sgx_return_code {
	SGX_EPC_PAGE_CONFLICT = 7,
	SGX_NOT_TRACKED = 11,
	SGX_CHILD_PRESENT = 13,
	SGX_INVALID_EINITTOKEN = 16,
	SGX_PAGE_NOT_MODIFIABLE = 20,
	SGX_UNMASKED_EVENT = 128,
};

enum sgx_secinfo_flags {
	SGX_SECINFO_R = 1,
	SGX_SECINFO_W = 2,
	SGX_SECINFO_X = 4,
	SGX_SECINFO_SECS = 0,
	SGX_SECINFO_TCS = 256,
	SGX_SECINFO_REG = 512,
	SGX_SECINFO_VA = 768,
	SGX_SECINFO_TRIM = 1024,
};

enum shmem_param {
	Opt_gid___8 = 0,
	Opt_huge = 1,
	Opt_mode___6 = 2,
	Opt_mpol = 3,
	Opt_nr_blocks = 4,
	Opt_nr_inodes___2 = 5,
	Opt_size___2 = 6,
	Opt_uid___7 = 7,
	Opt_inode32 = 8,
	Opt_inode64 = 9,
	Opt_noswap = 10,
	Opt_quota = 11,
	Opt_usrquota = 12,
	Opt_grpquota = 13,
	Opt_usrquota_block_hardlimit = 14,
	Opt_usrquota_inode_hardlimit = 15,
	Opt_grpquota_block_hardlimit = 16,
	Opt_grpquota_inode_hardlimit = 17,
	Opt_casefold_version = 18,
	Opt_casefold = 19,
	Opt_strict_encoding = 20,
};

enum show_regs_mode {
	SHOW_REGS_SHORT = 0,
	SHOW_REGS_USER = 1,
	SHOW_REGS_ALL = 2,
};

enum shutdown_state {
	SHUTDOWN_INVALID = -1,
	SHUTDOWN_POWEROFF = 0,
	SHUTDOWN_SUSPEND = 2,
	SHUTDOWN_HALT = 4,
};

enum si_type {
	SI_TYPE_INVALID = 0,
	SI_KCS = 1,
	SI_SMIC = 2,
	SI_BT = 3,
	SI_TYPE_MAX = 4,
};

enum sid_policy_type {
	SIDPOL_DEFAULT = 0,
	SIDPOL_CONSTRAINED = 1,
	SIDPOL_ALLOWED = 2,
};

enum sig_handler {
	HANDLER_CURRENT = 0,
	HANDLER_SIG_DFL = 1,
	HANDLER_EXIT = 2,
};

enum siginfo_layout {
	SIL_KILL = 0,
	SIL_TIMER = 1,
	SIL_POLL = 2,
	SIL_FAULT = 3,
	SIL_FAULT_TRAPNO = 4,
	SIL_FAULT_MCEERR = 5,
	SIL_FAULT_BNDERR = 6,
	SIL_FAULT_PKUERR = 7,
	SIL_FAULT_PERF_EVENT = 8,
	SIL_CHLD = 9,
	SIL_RT = 10,
	SIL_SYS = 11,
};

enum simatic_ipc_station_ids {
	SIMATIC_IPC_INVALID_STATION_ID = 0,
	SIMATIC_IPC_IPC227D = 1281,
	SIMATIC_IPC_IPC427D = 1793,
	SIMATIC_IPC_IPC227E = 2305,
	SIMATIC_IPC_IPC277E = 2306,
	SIMATIC_IPC_IPC427E = 2561,
	SIMATIC_IPC_IPC477E = 2562,
	SIMATIC_IPC_IPC127E = 3329,
	SIMATIC_IPC_IPC227G = 3841,
	SIMATIC_IPC_IPC277G = 3842,
	SIMATIC_IPC_IPCBX_39A = 4097,
	SIMATIC_IPC_IPCPX_39A = 4098,
	SIMATIC_IPC_IPCBX_21A = 4353,
	SIMATIC_IPC_IPCBX_56A = 4609,
	SIMATIC_IPC_IPCBX_59A = 4610,
};

enum sk_action {
	SK_DROP = 0,
	SK_PASS = 1,
};

enum sk_pacing {
	SK_PACING_NONE = 0,
	SK_PACING_NEEDED = 1,
	SK_PACING_FQ = 2,
};

enum sk_psock_state_bits {
	SK_PSOCK_TX_ENABLED = 0,
	SK_PSOCK_RX_STRP_ENABLED = 1,
};

enum sk_rst_reason {
	SK_RST_REASON_NOT_SPECIFIED = 0,
	SK_RST_REASON_NO_SOCKET = 1,
	SK_RST_REASON_TCP_INVALID_ACK_SEQUENCE = 2,
	SK_RST_REASON_TCP_RFC7323_PAWS = 3,
	SK_RST_REASON_TCP_TOO_OLD_ACK = 4,
	SK_RST_REASON_TCP_ACK_UNSENT_DATA = 5,
	SK_RST_REASON_TCP_FLAGS = 6,
	SK_RST_REASON_TCP_OLD_ACK = 7,
	SK_RST_REASON_TCP_ABORT_ON_DATA = 8,
	SK_RST_REASON_TCP_TIMEWAIT_SOCKET = 9,
	SK_RST_REASON_INVALID_SYN = 10,
	SK_RST_REASON_TCP_ABORT_ON_CLOSE = 11,
	SK_RST_REASON_TCP_ABORT_ON_LINGER = 12,
	SK_RST_REASON_TCP_ABORT_ON_MEMORY = 13,
	SK_RST_REASON_TCP_STATE = 14,
	SK_RST_REASON_TCP_KEEPALIVE_TIMEOUT = 15,
	SK_RST_REASON_TCP_DISCONNECT_WITH_DATA = 16,
	SK_RST_REASON_MPTCP_RST_EUNSPEC = 17,
	SK_RST_REASON_MPTCP_RST_EMPTCP = 18,
	SK_RST_REASON_MPTCP_RST_ERESOURCE = 19,
	SK_RST_REASON_MPTCP_RST_EPROHIBIT = 20,
	SK_RST_REASON_MPTCP_RST_EWQ2BIG = 21,
	SK_RST_REASON_MPTCP_RST_EBADPERF = 22,
	SK_RST_REASON_MPTCP_RST_EMIDDLEBOX = 23,
	SK_RST_REASON_ERROR = 24,
	SK_RST_REASON_MAX = 25,
};

enum skb_drop_reason {
	SKB_NOT_DROPPED_YET = 0,
	SKB_CONSUMED = 1,
	SKB_DROP_REASON_NOT_SPECIFIED = 2,
	SKB_DROP_REASON_NO_SOCKET = 3,
	SKB_DROP_REASON_SOCKET_CLOSE = 4,
	SKB_DROP_REASON_SOCKET_FILTER = 5,
	SKB_DROP_REASON_SOCKET_RCVBUFF = 6,
	SKB_DROP_REASON_UNIX_DISCONNECT = 7,
	SKB_DROP_REASON_UNIX_SKIP_OOB = 8,
	SKB_DROP_REASON_PKT_TOO_SMALL = 9,
	SKB_DROP_REASON_TCP_CSUM = 10,
	SKB_DROP_REASON_UDP_CSUM = 11,
	SKB_DROP_REASON_NETFILTER_DROP = 12,
	SKB_DROP_REASON_OTHERHOST = 13,
	SKB_DROP_REASON_IP_CSUM = 14,
	SKB_DROP_REASON_IP_INHDR = 15,
	SKB_DROP_REASON_IP_RPFILTER = 16,
	SKB_DROP_REASON_UNICAST_IN_L2_MULTICAST = 17,
	SKB_DROP_REASON_XFRM_POLICY = 18,
	SKB_DROP_REASON_IP_NOPROTO = 19,
	SKB_DROP_REASON_PROTO_MEM = 20,
	SKB_DROP_REASON_TCP_AUTH_HDR = 21,
	SKB_DROP_REASON_TCP_MD5NOTFOUND = 22,
	SKB_DROP_REASON_TCP_MD5UNEXPECTED = 23,
	SKB_DROP_REASON_TCP_MD5FAILURE = 24,
	SKB_DROP_REASON_TCP_AONOTFOUND = 25,
	SKB_DROP_REASON_TCP_AOUNEXPECTED = 26,
	SKB_DROP_REASON_TCP_AOKEYNOTFOUND = 27,
	SKB_DROP_REASON_TCP_AOFAILURE = 28,
	SKB_DROP_REASON_SOCKET_BACKLOG = 29,
	SKB_DROP_REASON_TCP_FLAGS = 30,
	SKB_DROP_REASON_TCP_ABORT_ON_DATA = 31,
	SKB_DROP_REASON_TCP_ZEROWINDOW = 32,
	SKB_DROP_REASON_TCP_OLD_DATA = 33,
	SKB_DROP_REASON_TCP_OVERWINDOW = 34,
	SKB_DROP_REASON_TCP_OFOMERGE = 35,
	SKB_DROP_REASON_TCP_RFC7323_PAWS = 36,
	SKB_DROP_REASON_TCP_RFC7323_PAWS_ACK = 37,
	SKB_DROP_REASON_TCP_RFC7323_TW_PAWS = 38,
	SKB_DROP_REASON_TCP_RFC7323_TSECR = 39,
	SKB_DROP_REASON_TCP_LISTEN_OVERFLOW = 40,
	SKB_DROP_REASON_TCP_OLD_SEQUENCE = 41,
	SKB_DROP_REASON_TCP_INVALID_SEQUENCE = 42,
	SKB_DROP_REASON_TCP_INVALID_END_SEQUENCE = 43,
	SKB_DROP_REASON_TCP_INVALID_ACK_SEQUENCE = 44,
	SKB_DROP_REASON_TCP_RESET = 45,
	SKB_DROP_REASON_TCP_INVALID_SYN = 46,
	SKB_DROP_REASON_TCP_CLOSE = 47,
	SKB_DROP_REASON_TCP_FASTOPEN = 48,
	SKB_DROP_REASON_TCP_OLD_ACK = 49,
	SKB_DROP_REASON_TCP_TOO_OLD_ACK = 50,
	SKB_DROP_REASON_TCP_ACK_UNSENT_DATA = 51,
	SKB_DROP_REASON_TCP_OFO_QUEUE_PRUNE = 52,
	SKB_DROP_REASON_TCP_OFO_DROP = 53,
	SKB_DROP_REASON_IP_OUTNOROUTES = 54,
	SKB_DROP_REASON_BPF_CGROUP_EGRESS = 55,
	SKB_DROP_REASON_IPV6DISABLED = 56,
	SKB_DROP_REASON_NEIGH_CREATEFAIL = 57,
	SKB_DROP_REASON_NEIGH_FAILED = 58,
	SKB_DROP_REASON_NEIGH_QUEUEFULL = 59,
	SKB_DROP_REASON_NEIGH_DEAD = 60,
	SKB_DROP_REASON_NEIGH_HH_FILLFAIL = 61,
	SKB_DROP_REASON_TC_EGRESS = 62,
	SKB_DROP_REASON_SECURITY_HOOK = 63,
	SKB_DROP_REASON_QDISC_DROP = 64,
	SKB_DROP_REASON_QDISC_OVERLIMIT = 65,
	SKB_DROP_REASON_QDISC_CONGESTED = 66,
	SKB_DROP_REASON_CAKE_FLOOD = 67,
	SKB_DROP_REASON_FQ_BAND_LIMIT = 68,
	SKB_DROP_REASON_FQ_HORIZON_LIMIT = 69,
	SKB_DROP_REASON_FQ_FLOW_LIMIT = 70,
	SKB_DROP_REASON_CPU_BACKLOG = 71,
	SKB_DROP_REASON_XDP = 72,
	SKB_DROP_REASON_TC_INGRESS = 73,
	SKB_DROP_REASON_UNHANDLED_PROTO = 74,
	SKB_DROP_REASON_SKB_CSUM = 75,
	SKB_DROP_REASON_SKB_GSO_SEG = 76,
	SKB_DROP_REASON_SKB_UCOPY_FAULT = 77,
	SKB_DROP_REASON_DEV_HDR = 78,
	SKB_DROP_REASON_DEV_READY = 79,
	SKB_DROP_REASON_FULL_RING = 80,
	SKB_DROP_REASON_NOMEM = 81,
	SKB_DROP_REASON_HDR_TRUNC = 82,
	SKB_DROP_REASON_TAP_FILTER = 83,
	SKB_DROP_REASON_TAP_TXFILTER = 84,
	SKB_DROP_REASON_ICMP_CSUM = 85,
	SKB_DROP_REASON_INVALID_PROTO = 86,
	SKB_DROP_REASON_IP_INADDRERRORS = 87,
	SKB_DROP_REASON_IP_INNOROUTES = 88,
	SKB_DROP_REASON_IP_LOCAL_SOURCE = 89,
	SKB_DROP_REASON_IP_INVALID_SOURCE = 90,
	SKB_DROP_REASON_IP_LOCALNET = 91,
	SKB_DROP_REASON_IP_INVALID_DEST = 92,
	SKB_DROP_REASON_PKT_TOO_BIG = 93,
	SKB_DROP_REASON_DUP_FRAG = 94,
	SKB_DROP_REASON_FRAG_REASM_TIMEOUT = 95,
	SKB_DROP_REASON_FRAG_TOO_FAR = 96,
	SKB_DROP_REASON_TCP_MINTTL = 97,
	SKB_DROP_REASON_IPV6_BAD_EXTHDR = 98,
	SKB_DROP_REASON_IPV6_NDISC_FRAG = 99,
	SKB_DROP_REASON_IPV6_NDISC_HOP_LIMIT = 100,
	SKB_DROP_REASON_IPV6_NDISC_BAD_CODE = 101,
	SKB_DROP_REASON_IPV6_NDISC_BAD_OPTIONS = 102,
	SKB_DROP_REASON_IPV6_NDISC_NS_OTHERHOST = 103,
	SKB_DROP_REASON_QUEUE_PURGE = 104,
	SKB_DROP_REASON_TC_COOKIE_ERROR = 105,
	SKB_DROP_REASON_PACKET_SOCK_ERROR = 106,
	SKB_DROP_REASON_TC_CHAIN_NOTFOUND = 107,
	SKB_DROP_REASON_TC_RECLASSIFY_LOOP = 108,
	SKB_DROP_REASON_VXLAN_INVALID_HDR = 109,
	SKB_DROP_REASON_VXLAN_VNI_NOT_FOUND = 110,
	SKB_DROP_REASON_MAC_INVALID_SOURCE = 111,
	SKB_DROP_REASON_VXLAN_ENTRY_EXISTS = 112,
	SKB_DROP_REASON_NO_TX_TARGET = 113,
	SKB_DROP_REASON_IP_TUNNEL_ECN = 114,
	SKB_DROP_REASON_TUNNEL_TXINFO = 115,
	SKB_DROP_REASON_LOCAL_MAC = 116,
	SKB_DROP_REASON_ARP_PVLAN_DISABLE = 117,
	SKB_DROP_REASON_MAC_IEEE_MAC_CONTROL = 118,
	SKB_DROP_REASON_BRIDGE_INGRESS_STP_STATE = 119,
	SKB_DROP_REASON_CAN_RX_INVALID_FRAME = 120,
	SKB_DROP_REASON_CANFD_RX_INVALID_FRAME = 121,
	SKB_DROP_REASON_CANXL_RX_INVALID_FRAME = 122,
	SKB_DROP_REASON_PFMEMALLOC = 123,
	SKB_DROP_REASON_DUALPI2_STEP_DROP = 124,
	SKB_DROP_REASON_MAX = 125,
	SKB_DROP_REASON_SUBSYS_MASK = 4294901760,
};

enum skb_drop_reason_subsys {
	SKB_DROP_REASON_SUBSYS_CORE = 0,
	SKB_DROP_REASON_SUBSYS_MAC80211_UNUSABLE = 1,
	SKB_DROP_REASON_SUBSYS_OPENVSWITCH = 2,
	SKB_DROP_REASON_SUBSYS_NUM = 3,
};

enum skb_ext_id {
	SKB_EXT_BRIDGE_NF = 0,
	SKB_EXT_SEC_PATH = 1,
	TC_SKB_EXT = 2,
	SKB_EXT_MPTCP = 3,
	SKB_EXT_MCTP = 4,
	SKB_EXT_NUM = 5,
};

enum skb_tstamp_type {
	SKB_CLOCK_REALTIME = 0,
	SKB_CLOCK_MONOTONIC = 1,
	SKB_CLOCK_TAI = 2,
	__SKB_CLOCK_MAX = 2,
};

enum sknetlink_groups {
	SKNLGRP_NONE = 0,
	SKNLGRP_INET_TCP_DESTROY = 1,
	SKNLGRP_INET_UDP_DESTROY = 2,
	SKNLGRP_INET6_TCP_DESTROY = 3,
	SKNLGRP_INET6_UDP_DESTROY = 4,
	__SKNLGRP_MAX = 5,
};

enum slab_flags {
	SL_locked = 0,
	SL_partial = 9,
	SL_pfmemalloc = 8,
};

enum slab_stat_type {
	SL_ALL = 0,
	SL_PARTIAL = 1,
	SL_CPU = 2,
	SL_OBJECTS = 3,
	SL_TOTAL = 4,
};

enum slab_state {
	DOWN = 0,
	PARTIAL = 1,
	UP = 2,
	FULL = 3,
};

enum smbios_attr_enum {
	SMBIOS_ATTR_NONE = 0,
	SMBIOS_ATTR_LABEL_SHOW = 1,
	SMBIOS_ATTR_INSTANCE_SHOW = 2,
};

enum smca_bank_types {
	SMCA_LS = 0,
	SMCA_LS_V2 = 1,
	SMCA_IF = 2,
	SMCA_L2_CACHE = 3,
	SMCA_DE = 4,
	SMCA_RESERVED = 5,
	SMCA_EX = 6,
	SMCA_FP = 7,
	SMCA_L3_CACHE = 8,
	SMCA_CS = 9,
	SMCA_CS_V2 = 10,
	SMCA_PIE = 11,
	SMCA_UMC = 12,
	SMCA_UMC_V2 = 13,
	SMCA_MA_LLC = 14,
	SMCA_PB = 15,
	SMCA_PSP = 16,
	SMCA_PSP_V2 = 17,
	SMCA_SMU = 18,
	SMCA_SMU_V2 = 19,
	SMCA_MP5 = 20,
	SMCA_MPDMA = 21,
	SMCA_NBIO = 22,
	SMCA_PCIE = 23,
	SMCA_PCIE_V2 = 24,
	SMCA_XGMI_PCS = 25,
	SMCA_NBIF = 26,
	SMCA_SHUB = 27,
	SMCA_SATA = 28,
	SMCA_USB = 29,
	SMCA_USR_DP = 30,
	SMCA_USR_CP = 31,
	SMCA_GMI_PCS = 32,
	SMCA_XGMI_PHY = 33,
	SMCA_WAFL_PHY = 34,
	SMCA_GMI_PHY = 35,
	N_SMCA_BANK_TYPES = 36,
};

enum smk_inos {
	SMK_ROOT_INO = 2,
	SMK_LOAD = 3,
	SMK_CIPSO = 4,
	SMK_DOI = 5,
	SMK_DIRECT = 6,
	SMK_AMBIENT = 7,
	SMK_NET4ADDR = 8,
	SMK_ONLYCAP = 9,
	SMK_LOGGING = 10,
	SMK_LOAD_SELF = 11,
	SMK_ACCESSES = 12,
	SMK_MAPPED = 13,
	SMK_LOAD2 = 14,
	SMK_LOAD_SELF2 = 15,
	SMK_ACCESS2 = 16,
	SMK_CIPSO2 = 17,
	SMK_REVOKE_SUBJ = 18,
	SMK_CHANGE_RULE = 19,
	SMK_SYSLOG = 20,
	SMK_PTRACE = 21,
	SMK_UNCONFINED = 22,
	SMK_NET6ADDR = 23,
	SMK_RELABEL_SELF = 24,
};

enum smt_mitigations {
	SMT_MITIGATIONS_OFF = 0,
	SMT_MITIGATIONS_AUTO = 1,
	SMT_MITIGATIONS_ON = 2,
};

enum snoop_when {
	SUBMIT = 0,
	COMPLETE = 1,
};

enum sock_flags {
	SOCK_DEAD = 0,
	SOCK_DONE = 1,
	SOCK_URGINLINE = 2,
	SOCK_KEEPOPEN = 3,
	SOCK_LINGER = 4,
	SOCK_DESTROY = 5,
	SOCK_BROADCAST = 6,
	SOCK_TIMESTAMP = 7,
	SOCK_ZAPPED = 8,
	SOCK_USE_WRITE_QUEUE = 9,
	SOCK_DBG = 10,
	SOCK_RCVTSTAMP = 11,
	SOCK_RCVTSTAMPNS = 12,
	SOCK_LOCALROUTE = 13,
	SOCK_MEMALLOC = 14,
	SOCK_TIMESTAMPING_RX_SOFTWARE = 15,
	SOCK_FASYNC = 16,
	SOCK_RXQ_OVFL = 17,
	SOCK_ZEROCOPY = 18,
	SOCK_WIFI_STATUS = 19,
	SOCK_NOFCS = 20,
	SOCK_FILTER_LOCKED = 21,
	SOCK_SELECT_ERR_QUEUE = 22,
	SOCK_RCU_FREE = 23,
	SOCK_TXTIME = 24,
	SOCK_XDP = 25,
	SOCK_TSTAMP_NEW = 26,
	SOCK_RCVMARK = 27,
	SOCK_RCVPRIORITY = 28,
	SOCK_TIMESTAMPING_ANY = 29,
};

enum sock_shutdown_cmd {
	SHUT_RD = 0,
	SHUT_WR = 1,
	SHUT_RDWR = 2,
};

enum sock_type {
	SOCK_STREAM = 1,
	SOCK_DGRAM = 2,
	SOCK_RAW = 3,
	SOCK_RDM = 4,
	SOCK_SEQPACKET = 5,
	SOCK_DCCP = 6,
	SOCK_PACKET = 10,
};

enum socket_flags {
	SOCKWQ_ASYNC_NOSPACE = 0,
	SOCKWQ_ASYNC_WAITDATA = 1,
	SOCK_NOSPACE = 2,
	SOCK_SUPPORT_ZC = 3,
	SOCK_CUSTOM_SOCKOPT = 4,
};

enum special_kfunc_type {
	KF_bpf_obj_new_impl = 0,
	KF_bpf_obj_drop_impl = 1,
	KF_bpf_refcount_acquire_impl = 2,
	KF_bpf_list_push_front_impl = 3,
	KF_bpf_list_push_back_impl = 4,
	KF_bpf_list_pop_front = 5,
	KF_bpf_list_pop_back = 6,
	KF_bpf_list_front = 7,
	KF_bpf_list_back = 8,
	KF_bpf_cast_to_kern_ctx = 9,
	KF_bpf_rdonly_cast = 10,
	KF_bpf_rcu_read_lock = 11,
	KF_bpf_rcu_read_unlock = 12,
	KF_bpf_rbtree_remove = 13,
	KF_bpf_rbtree_add_impl = 14,
	KF_bpf_rbtree_first = 15,
	KF_bpf_rbtree_root = 16,
	KF_bpf_rbtree_left = 17,
	KF_bpf_rbtree_right = 18,
	KF_bpf_dynptr_from_skb = 19,
	KF_bpf_dynptr_from_xdp = 20,
	KF_bpf_dynptr_slice = 21,
	KF_bpf_dynptr_slice_rdwr = 22,
	KF_bpf_dynptr_clone = 23,
	KF_bpf_percpu_obj_new_impl = 24,
	KF_bpf_percpu_obj_drop_impl = 25,
	KF_bpf_throw = 26,
	KF_bpf_wq_set_callback_impl = 27,
	KF_bpf_preempt_disable = 28,
	KF_bpf_preempt_enable = 29,
	KF_bpf_iter_css_task_new = 30,
	KF_bpf_session_cookie = 31,
	KF_bpf_get_kmem_cache = 32,
	KF_bpf_local_irq_save = 33,
	KF_bpf_local_irq_restore = 34,
	KF_bpf_iter_num_new = 35,
	KF_bpf_iter_num_next = 36,
	KF_bpf_iter_num_destroy = 37,
	KF_bpf_set_dentry_xattr = 38,
	KF_bpf_remove_dentry_xattr = 39,
	KF_bpf_res_spin_lock = 40,
	KF_bpf_res_spin_unlock = 41,
	KF_bpf_res_spin_lock_irqsave = 42,
	KF_bpf_res_spin_unlock_irqrestore = 43,
	KF___bpf_trap = 44,
};

enum spectre_v1_mitigation {
	SPECTRE_V1_MITIGATION_NONE = 0,
	SPECTRE_V1_MITIGATION_AUTO = 1,
};

enum spectre_v2_mitigation {
	SPECTRE_V2_NONE = 0,
	SPECTRE_V2_RETPOLINE = 1,
	SPECTRE_V2_LFENCE = 2,
	SPECTRE_V2_EIBRS = 3,
	SPECTRE_V2_EIBRS_RETPOLINE = 4,
	SPECTRE_V2_EIBRS_LFENCE = 5,
	SPECTRE_V2_IBRS = 6,
};

enum spectre_v2_mitigation_cmd {
	SPECTRE_V2_CMD_NONE = 0,
	SPECTRE_V2_CMD_AUTO = 1,
	SPECTRE_V2_CMD_FORCE = 2,
	SPECTRE_V2_CMD_RETPOLINE = 3,
	SPECTRE_V2_CMD_RETPOLINE_GENERIC = 4,
	SPECTRE_V2_CMD_RETPOLINE_LFENCE = 5,
	SPECTRE_V2_CMD_EIBRS = 6,
	SPECTRE_V2_CMD_EIBRS_RETPOLINE = 7,
	SPECTRE_V2_CMD_EIBRS_LFENCE = 8,
	SPECTRE_V2_CMD_IBRS = 9,
};

enum spectre_v2_user_cmd {
	SPECTRE_V2_USER_CMD_NONE = 0,
	SPECTRE_V2_USER_CMD_AUTO = 1,
	SPECTRE_V2_USER_CMD_FORCE = 2,
	SPECTRE_V2_USER_CMD_PRCTL = 3,
	SPECTRE_V2_USER_CMD_PRCTL_IBPB = 4,
	SPECTRE_V2_USER_CMD_SECCOMP = 5,
	SPECTRE_V2_USER_CMD_SECCOMP_IBPB = 6,
};

enum spectre_v2_user_mitigation {
	SPECTRE_V2_USER_NONE = 0,
	SPECTRE_V2_USER_STRICT = 1,
	SPECTRE_V2_USER_STRICT_PREFERRED = 2,
	SPECTRE_V2_USER_PRCTL = 3,
	SPECTRE_V2_USER_SECCOMP = 4,
};

enum spi_mem_data_dir {
	SPI_MEM_NO_DATA = 0,
	SPI_MEM_DATA_IN = 1,
	SPI_MEM_DATA_OUT = 2,
};

enum spi_offload_trigger_type {
	SPI_OFFLOAD_TRIGGER_DATA_READY = 0,
	SPI_OFFLOAD_TRIGGER_PERIODIC = 1,
};

enum split_lock_detect_state {
	sld_off = 0,
	sld_warn = 1,
	sld_fatal = 2,
	sld_ratelimit = 3,
};

enum sr_retry_flags {
	IORING_RECV_RETRY = 32768,
	IORING_RECV_PARTIAL_MAP = 16384,
	IORING_RECV_MSHOT_CAP = 8192,
	IORING_RECV_MSHOT_LIM = 4096,
	IORING_RECV_MSHOT_DONE = 2048,
	IORING_RECV_RETRY_CLEAR = 49152,
	IORING_RECV_NO_RETRY = 59392,
};

enum srbds_mitigations {
	SRBDS_MITIGATION_OFF = 0,
	SRBDS_MITIGATION_AUTO = 1,
	SRBDS_MITIGATION_UCODE_NEEDED = 2,
	SRBDS_MITIGATION_FULL = 3,
	SRBDS_MITIGATION_TSX_OFF = 4,
	SRBDS_MITIGATION_HYPERVISOR = 5,
};

enum srso_mitigation {
	SRSO_MITIGATION_NONE = 0,
	SRSO_MITIGATION_AUTO = 1,
	SRSO_MITIGATION_UCODE_NEEDED = 2,
	SRSO_MITIGATION_SAFE_RET_UCODE_NEEDED = 3,
	SRSO_MITIGATION_MICROCODE = 4,
	SRSO_MITIGATION_NOSMT = 5,
	SRSO_MITIGATION_SAFE_RET = 6,
	SRSO_MITIGATION_IBPB = 7,
	SRSO_MITIGATION_IBPB_ON_VMEXIT = 8,
	SRSO_MITIGATION_BP_SPEC_REDUCE = 9,
};

enum ssb_mitigation {
	SPEC_STORE_BYPASS_NONE = 0,
	SPEC_STORE_BYPASS_DISABLE = 1,
	SPEC_STORE_BYPASS_PRCTL = 2,
	SPEC_STORE_BYPASS_SECCOMP = 3,
};

enum ssb_mitigation_cmd {
	SPEC_STORE_BYPASS_CMD_NONE = 0,
	SPEC_STORE_BYPASS_CMD_AUTO = 1,
	SPEC_STORE_BYPASS_CMD_ON = 2,
	SPEC_STORE_BYPASS_CMD_PRCTL = 3,
	SPEC_STORE_BYPASS_CMD_SECCOMP = 4,
};

enum stack_type {
	STACK_TYPE_UNKNOWN = 0,
	STACK_TYPE_TASK = 1,
	STACK_TYPE_IRQ = 2,
	STACK_TYPE_SOFTIRQ = 3,
	STACK_TYPE_ENTRY = 4,
	STACK_TYPE_EXCEPTION = 5,
	STACK_TYPE_EXCEPTION_LAST = 10,
};

enum stat_group {
	STAT_READ = 0,
	STAT_WRITE = 1,
	STAT_DISCARD = 2,
	STAT_FLUSH = 3,
	NR_STAT_GROUPS = 4,
};

enum stat_item {
	ALLOC_FASTPATH = 0,
	ALLOC_SLOWPATH = 1,
	FREE_FASTPATH = 2,
	FREE_SLOWPATH = 3,
	FREE_FROZEN = 4,
	FREE_ADD_PARTIAL = 5,
	FREE_REMOVE_PARTIAL = 6,
	ALLOC_FROM_PARTIAL = 7,
	ALLOC_SLAB = 8,
	ALLOC_REFILL = 9,
	ALLOC_NODE_MISMATCH = 10,
	FREE_SLAB = 11,
	CPUSLAB_FLUSH = 12,
	DEACTIVATE_FULL = 13,
	DEACTIVATE_EMPTY = 14,
	DEACTIVATE_TO_HEAD = 15,
	DEACTIVATE_TO_TAIL = 16,
	DEACTIVATE_REMOTE_FREES = 17,
	DEACTIVATE_BYPASS = 18,
	ORDER_FALLBACK = 19,
	CMPXCHG_DOUBLE_CPU_FAIL = 20,
	CMPXCHG_DOUBLE_FAIL = 21,
	CPU_PARTIAL_ALLOC = 22,
	CPU_PARTIAL_FREE = 23,
	CPU_PARTIAL_NODE = 24,
	CPU_PARTIAL_DRAIN = 25,
	NR_SLUB_STAT_ITEMS = 26,
};

enum state {
	Start = 0,
	Collect = 1,
	GotHeader = 2,
	SkipIt = 3,
	GotName = 4,
	CopyFile = 5,
	GotSymlink = 6,
	Reset = 7,
};

enum stats_per_group {
	STATS_SYSTEM = 0,
	STATS_SOFTIRQ = 1,
	STATS_HARDIRQ = 2,
	STATS_IDLE = 3,
	NUM_STATS_PER_GROUP = 4,
};

enum store_type {
	wr_invalid = 0,
	wr_new_root = 1,
	wr_store_root = 2,
	wr_exact_fit = 3,
	wr_spanning_store = 4,
	wr_split_store = 5,
	wr_rebalance = 6,
	wr_append = 7,
	wr_node_store = 8,
	wr_slot_store = 9,
};

enum string_size_units {
	STRING_UNITS_10 = 0,
	STRING_UNITS_2 = 1,
	STRING_UNITS_MASK = 1,
	STRING_UNITS_NO_SPACE = 1073741824,
	STRING_UNITS_NO_BYTES = 2147483648,
};

enum subpixel_order {
	SubPixelUnknown = 0,
	SubPixelHorizontalRGB = 1,
	SubPixelHorizontalBGR = 2,
	SubPixelVerticalRGB = 3,
	SubPixelVerticalBGR = 4,
	SubPixelNone = 5,
};

enum sum_check_bits {
	SUM_CHECK_P = 0,
	SUM_CHECK_Q = 1,
};

enum sum_check_flags {
	SUM_CHECK_P_RESULT = 1,
	SUM_CHECK_Q_RESULT = 2,
};

enum super_iter_flags_t {
	SUPER_ITER_EXCL = 1,
	SUPER_ITER_UNLOCKED = 2,
	SUPER_ITER_REVERSE = 4,
};

enum support_mode {
	ALLOW_LEGACY = 0,
	DENY_LEGACY = 1,
};

enum suspend_stat_step {
	SUSPEND_WORKING = 0,
	SUSPEND_FREEZE = 1,
	SUSPEND_PREPARE = 2,
	SUSPEND_SUSPEND = 3,
	SUSPEND_SUSPEND_LATE = 4,
	SUSPEND_SUSPEND_NOIRQ = 5,
	SUSPEND_RESUME_NOIRQ = 6,
	SUSPEND_RESUME_EARLY = 7,
	SUSPEND_RESUME = 8,
};

enum svc_auth_status {
	SVC_GARBAGE = 1,
	SVC_VALID = 2,
	SVC_NEGATIVE = 3,
	SVC_OK = 4,
	SVC_DROP = 5,
	SVC_CLOSE = 6,
	SVC_DENIED = 7,
	SVC_PENDING = 8,
	SVC_COMPLETE = 9,
};

enum sw_activity {
	OFF = 0,
	BLINK_ON = 1,
	BLINK_OFF = 2,
};

enum swap_cluster_flags {
	CLUSTER_FLAG_NONE = 0,
	CLUSTER_FLAG_FREE = 1,
	CLUSTER_FLAG_NONFULL = 2,
	CLUSTER_FLAG_FRAG = 3,
	CLUSTER_FLAG_USABLE = 3,
	CLUSTER_FLAG_FULL = 4,
	CLUSTER_FLAG_DISCARD = 5,
	CLUSTER_FLAG_MAX = 6,
};

enum switch_power_state {
	DRM_SWITCH_POWER_ON = 0,
	DRM_SWITCH_POWER_OFF = 1,
	DRM_SWITCH_POWER_CHANGING = 2,
	DRM_SWITCH_POWER_DYNAMIC_OFF = 3,
};

enum switchdev_attr_id {
	SWITCHDEV_ATTR_ID_UNDEFINED = 0,
	SWITCHDEV_ATTR_ID_PORT_STP_STATE = 1,
	SWITCHDEV_ATTR_ID_PORT_MST_STATE = 2,
	SWITCHDEV_ATTR_ID_PORT_BRIDGE_FLAGS = 3,
	SWITCHDEV_ATTR_ID_PORT_PRE_BRIDGE_FLAGS = 4,
	SWITCHDEV_ATTR_ID_PORT_MROUTER = 5,
	SWITCHDEV_ATTR_ID_BRIDGE_AGEING_TIME = 6,
	SWITCHDEV_ATTR_ID_BRIDGE_VLAN_FILTERING = 7,
	SWITCHDEV_ATTR_ID_BRIDGE_VLAN_PROTOCOL = 8,
	SWITCHDEV_ATTR_ID_BRIDGE_MC_DISABLED = 9,
	SWITCHDEV_ATTR_ID_BRIDGE_MROUTER = 10,
	SWITCHDEV_ATTR_ID_BRIDGE_MST = 11,
	SWITCHDEV_ATTR_ID_MRP_PORT_ROLE = 12,
	SWITCHDEV_ATTR_ID_VLAN_MSTI = 13,
};

enum switchdev_notifier_type {
	SWITCHDEV_FDB_ADD_TO_BRIDGE = 1,
	SWITCHDEV_FDB_DEL_TO_BRIDGE = 2,
	SWITCHDEV_FDB_ADD_TO_DEVICE = 3,
	SWITCHDEV_FDB_DEL_TO_DEVICE = 4,
	SWITCHDEV_FDB_OFFLOADED = 5,
	SWITCHDEV_FDB_FLUSH_TO_BRIDGE = 6,
	SWITCHDEV_PORT_OBJ_ADD = 7,
	SWITCHDEV_PORT_OBJ_DEL = 8,
	SWITCHDEV_PORT_ATTR_SET = 9,
	SWITCHDEV_VXLAN_FDB_ADD_TO_BRIDGE = 10,
	SWITCHDEV_VXLAN_FDB_DEL_TO_BRIDGE = 11,
	SWITCHDEV_VXLAN_FDB_ADD_TO_DEVICE = 12,
	SWITCHDEV_VXLAN_FDB_DEL_TO_DEVICE = 13,
	SWITCHDEV_VXLAN_FDB_OFFLOADED = 14,
	SWITCHDEV_BRPORT_OFFLOADED = 15,
	SWITCHDEV_BRPORT_UNOFFLOADED = 16,
	SWITCHDEV_BRPORT_REPLAY = 17,
};

enum switchdev_obj_id {
	SWITCHDEV_OBJ_ID_UNDEFINED = 0,
	SWITCHDEV_OBJ_ID_PORT_VLAN = 1,
	SWITCHDEV_OBJ_ID_PORT_MDB = 2,
	SWITCHDEV_OBJ_ID_HOST_MDB = 3,
	SWITCHDEV_OBJ_ID_MRP = 4,
	SWITCHDEV_OBJ_ID_RING_TEST_MRP = 5,
	SWITCHDEV_OBJ_ID_RING_ROLE_MRP = 6,
	SWITCHDEV_OBJ_ID_RING_STATE_MRP = 7,
	SWITCHDEV_OBJ_ID_IN_TEST_MRP = 8,
	SWITCHDEV_OBJ_ID_IN_ROLE_MRP = 9,
	SWITCHDEV_OBJ_ID_IN_STATE_MRP = 10,
};

enum sys_off_mode {
	SYS_OFF_MODE_POWER_OFF_PREPARE = 0,
	SYS_OFF_MODE_POWER_OFF = 1,
	SYS_OFF_MODE_RESTART_PREPARE = 2,
	SYS_OFF_MODE_RESTART = 3,
};

enum syscall_work_bit {
	SYSCALL_WORK_BIT_SECCOMP = 0,
	SYSCALL_WORK_BIT_SYSCALL_TRACEPOINT = 1,
	SYSCALL_WORK_BIT_SYSCALL_TRACE = 2,
	SYSCALL_WORK_BIT_SYSCALL_EMU = 3,
	SYSCALL_WORK_BIT_SYSCALL_AUDIT = 4,
	SYSCALL_WORK_BIT_SYSCALL_USER_DISPATCH = 5,
	SYSCALL_WORK_BIT_SYSCALL_EXIT_TRAP = 6,
};

enum sysctl_writes_mode {
	SYSCTL_WRITES_LEGACY = -1,
	SYSCTL_WRITES_WARN = 0,
	SYSCTL_WRITES_STRICT = 1,
};

enum system_states {
	SYSTEM_BOOTING = 0,
	SYSTEM_SCHEDULING = 1,
	SYSTEM_FREEING_INITMEM = 2,
	SYSTEM_RUNNING = 3,
	SYSTEM_HALT = 4,
	SYSTEM_POWER_OFF = 5,
	SYSTEM_RESTART = 6,
	SYSTEM_SUSPEND = 7,
};

enum t10_dif_type {
	T10_PI_TYPE0_PROTECTION = 0,
	T10_PI_TYPE1_PROTECTION = 1,
	T10_PI_TYPE2_PROTECTION = 2,
	T10_PI_TYPE3_PROTECTION = 3,
};

enum taa_mitigations {
	TAA_MITIGATION_OFF = 0,
	TAA_MITIGATION_AUTO = 1,
	TAA_MITIGATION_UCODE_NEEDED = 2,
	TAA_MITIGATION_VERW = 3,
	TAA_MITIGATION_TSX_DISABLED = 4,
};

enum task_work_notify_mode {
	TWA_NONE = 0,
	TWA_RESUME = 1,
	TWA_SIGNAL = 2,
	TWA_SIGNAL_NO_IPI = 3,
	TWA_NMI_CURRENT = 4,
};

enum tc_fifo_command {
	TC_FIFO_REPLACE = 0,
	TC_FIFO_DESTROY = 1,
	TC_FIFO_STATS = 2,
};

enum tc_link_layer {
	TC_LINKLAYER_UNAWARE = 0,
	TC_LINKLAYER_ETHERNET = 1,
	TC_LINKLAYER_ATM = 2,
};

enum tc_mq_command {
	TC_MQ_CREATE = 0,
	TC_MQ_DESTROY = 1,
	TC_MQ_STATS = 2,
	TC_MQ_GRAFT = 3,
};

enum tc_root_command {
	TC_ROOT_GRAFT = 0,
};

enum tc_setup_type {
	TC_QUERY_CAPS = 0,
	TC_SETUP_QDISC_MQPRIO = 1,
	TC_SETUP_CLSU32 = 2,
	TC_SETUP_CLSFLOWER = 3,
	TC_SETUP_CLSMATCHALL = 4,
	TC_SETUP_CLSBPF = 5,
	TC_SETUP_BLOCK = 6,
	TC_SETUP_QDISC_CBS = 7,
	TC_SETUP_QDISC_RED = 8,
	TC_SETUP_QDISC_PRIO = 9,
	TC_SETUP_QDISC_MQ = 10,
	TC_SETUP_QDISC_ETF = 11,
	TC_SETUP_ROOT_QDISC = 12,
	TC_SETUP_QDISC_GRED = 13,
	TC_SETUP_QDISC_TAPRIO = 14,
	TC_SETUP_FT = 15,
	TC_SETUP_QDISC_ETS = 16,
	TC_SETUP_QDISC_TBF = 17,
	TC_SETUP_QDISC_FIFO = 18,
	TC_SETUP_QDISC_HTB = 19,
	TC_SETUP_ACT = 20,
};

enum tca_id {
	TCA_ID_UNSPEC = 0,
	TCA_ID_POLICE = 1,
	TCA_ID_GACT = 5,
	TCA_ID_IPT = 6,
	TCA_ID_PEDIT = 7,
	TCA_ID_MIRRED = 8,
	TCA_ID_NAT = 9,
	TCA_ID_XT = 10,
	TCA_ID_SKBEDIT = 11,
	TCA_ID_VLAN = 12,
	TCA_ID_BPF = 13,
	TCA_ID_CONNMARK = 14,
	TCA_ID_SKBMOD = 15,
	TCA_ID_CSUM = 16,
	TCA_ID_TUNNEL_KEY = 17,
	TCA_ID_SIMP = 22,
	TCA_ID_IFE = 25,
	TCA_ID_SAMPLE = 26,
	TCA_ID_CTINFO = 27,
	TCA_ID_MPLS = 28,
	TCA_ID_CT = 29,
	TCA_ID_GATE = 30,
	__TCA_ID_MAX = 255,
};

enum tcf_proto_ops_flags {
	TCF_PROTO_OPS_DOIT_UNLOCKED = 1,
};

enum tcp_ca_ack_event_flags {
	CA_ACK_SLOWPATH = 1,
	CA_ACK_WIN_UPDATE = 2,
	CA_ACK_ECE = 4,
};

enum tcp_ca_event {
	CA_EVENT_TX_START = 0,
	CA_EVENT_CWND_RESTART = 1,
	CA_EVENT_COMPLETE_CWR = 2,
	CA_EVENT_LOSS = 3,
	CA_EVENT_ECN_NO_CE = 4,
	CA_EVENT_ECN_IS_CE = 5,
};

enum tcp_ca_state {
	TCP_CA_Open = 0,
	TCP_CA_Disorder = 1,
	TCP_CA_CWR = 2,
	TCP_CA_Recovery = 3,
	TCP_CA_Loss = 4,
};

enum tcp_chrono {
	TCP_CHRONO_UNSPEC = 0,
	TCP_CHRONO_BUSY = 1,
	TCP_CHRONO_RWND_LIMITED = 2,
	TCP_CHRONO_SNDBUF_LIMITED = 3,
	__TCP_CHRONO_MAX = 4,
};

enum tcp_conntrack {
	TCP_CONNTRACK_NONE = 0,
	TCP_CONNTRACK_SYN_SENT = 1,
	TCP_CONNTRACK_SYN_RECV = 2,
	TCP_CONNTRACK_ESTABLISHED = 3,
	TCP_CONNTRACK_FIN_WAIT = 4,
	TCP_CONNTRACK_CLOSE_WAIT = 5,
	TCP_CONNTRACK_LAST_ACK = 6,
	TCP_CONNTRACK_TIME_WAIT = 7,
	TCP_CONNTRACK_CLOSE = 8,
	TCP_CONNTRACK_LISTEN = 9,
	TCP_CONNTRACK_MAX = 10,
	TCP_CONNTRACK_IGNORE = 11,
	TCP_CONNTRACK_RETRANS = 12,
	TCP_CONNTRACK_UNACK = 13,
	TCP_CONNTRACK_TIMEOUT_MAX = 14,
};

enum tcp_fastopen_client_fail {
	TFO_STATUS_UNSPEC = 0,
	TFO_COOKIE_UNAVAILABLE = 1,
	TFO_DATA_NOT_ACKED = 2,
	TFO_SYN_RETRANSMITTED = 3,
};

enum tcp_metric_index {
	TCP_METRIC_RTT = 0,
	TCP_METRIC_RTTVAR = 1,
	TCP_METRIC_SSTHRESH = 2,
	TCP_METRIC_CWND = 3,
	TCP_METRIC_REORDERING = 4,
	TCP_METRIC_RTT_US = 5,
	TCP_METRIC_RTTVAR_US = 6,
	__TCP_METRIC_MAX = 7,
};

enum tcp_queue {
	TCP_FRAG_IN_WRITE_QUEUE = 0,
	TCP_FRAG_IN_RTX_QUEUE = 1,
};

enum tcp_seq_states {
	TCP_SEQ_STATE_LISTENING = 0,
	TCP_SEQ_STATE_ESTABLISHED = 1,
};

enum tcp_skb_cb_sacked_flags {
	TCPCB_SACKED_ACKED = 1,
	TCPCB_SACKED_RETRANS = 2,
	TCPCB_LOST = 4,
	TCPCB_TAGBITS = 7,
	TCPCB_REPAIRED = 16,
	TCPCB_EVER_RETRANS = 128,
	TCPCB_RETRANS = 146,
};

enum tcp_synack_type {
	TCP_SYNACK_NORMAL = 0,
	TCP_SYNACK_FASTOPEN = 1,
	TCP_SYNACK_COOKIE = 2,
};

enum tcp_tw_status {
	TCP_TW_SUCCESS = 0,
	TCP_TW_RST = 1,
	TCP_TW_ACK = 2,
	TCP_TW_SYN = 3,
	TCP_TW_ACK_OOW = 4,
};

enum tcpa_event_types {
	PREBOOT = 0,
	POST_CODE = 1,
	UNUSED = 2,
	NO_ACTION = 3,
	SEPARATOR = 4,
	ACTION = 5,
	EVENT_TAG = 6,
	SCRTM_CONTENTS = 7,
	SCRTM_VERSION = 8,
	CPU_MICROCODE = 9,
	PLATFORM_CONFIG_FLAGS = 10,
	TABLE_OF_DEVICES = 11,
	COMPACT_HASH = 12,
	IPL = 13,
	IPL_PARTITION_DATA = 14,
	NONHOST_CODE = 15,
	NONHOST_CONFIG = 16,
	NONHOST_INFO = 17,
};

enum tcpa_pc_event_ids {
	SMBIOS = 1,
	BIS_CERT = 2,
	POST_BIOS_ROM = 3,
	ESCD = 4,
	CMOS = 5,
	NVRAM = 6,
	OPTION_ROM_EXEC = 7,
	OPTION_ROM_CONFIG = 8,
	OPTION_ROM_MICROCODE = 10,
	S_CRTM_VERSION = 11,
	S_CRTM_CONTENTS = 12,
	POST_CONTENTS = 13,
	HOST_TABLE_OF_DEVICES = 14,
};

enum tcx_action_base {
	TCX_NEXT = -1,
	TCX_PASS = 0,
	TCX_DROP = 2,
	TCX_REDIRECT = 7,
};

enum tg_state_flags {
	THROTL_TG_PENDING = 1,
	THROTL_TG_WAS_EMPTY = 2,
	THROTL_TG_IOPS_WAS_EMPTY = 4,
	THROTL_TG_CANCELING = 8,
};

enum thermal_device_mode {
	THERMAL_DEVICE_DISABLED = 0,
	THERMAL_DEVICE_ENABLED = 1,
};

enum thermal_genl_attr {
	THERMAL_GENL_ATTR_UNSPEC = 0,
	THERMAL_GENL_ATTR_TZ = 1,
	THERMAL_GENL_ATTR_TZ_ID = 2,
	THERMAL_GENL_ATTR_TZ_TEMP = 3,
	THERMAL_GENL_ATTR_TZ_TRIP = 4,
	THERMAL_GENL_ATTR_TZ_TRIP_ID = 5,
	THERMAL_GENL_ATTR_TZ_TRIP_TYPE = 6,
	THERMAL_GENL_ATTR_TZ_TRIP_TEMP = 7,
	THERMAL_GENL_ATTR_TZ_TRIP_HYST = 8,
	THERMAL_GENL_ATTR_TZ_MODE = 9,
	THERMAL_GENL_ATTR_TZ_NAME = 10,
	THERMAL_GENL_ATTR_TZ_CDEV_WEIGHT = 11,
	THERMAL_GENL_ATTR_TZ_GOV = 12,
	THERMAL_GENL_ATTR_TZ_GOV_NAME = 13,
	THERMAL_GENL_ATTR_CDEV = 14,
	THERMAL_GENL_ATTR_CDEV_ID = 15,
	THERMAL_GENL_ATTR_CDEV_CUR_STATE = 16,
	THERMAL_GENL_ATTR_CDEV_MAX_STATE = 17,
	THERMAL_GENL_ATTR_CDEV_NAME = 18,
	THERMAL_GENL_ATTR_GOV_NAME = 19,
	THERMAL_GENL_ATTR_CPU_CAPABILITY = 20,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_ID = 21,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_PERFORMANCE = 22,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_EFFICIENCY = 23,
	THERMAL_GENL_ATTR_THRESHOLD = 24,
	THERMAL_GENL_ATTR_THRESHOLD_TEMP = 25,
	THERMAL_GENL_ATTR_THRESHOLD_DIRECTION = 26,
	THERMAL_GENL_ATTR_TZ_PREV_TEMP = 27,
	__THERMAL_GENL_ATTR_MAX = 28,
};

enum thermal_genl_cmd {
	THERMAL_GENL_CMD_UNSPEC = 0,
	THERMAL_GENL_CMD_TZ_GET_ID = 1,
	THERMAL_GENL_CMD_TZ_GET_TRIP = 2,
	THERMAL_GENL_CMD_TZ_GET_TEMP = 3,
	THERMAL_GENL_CMD_TZ_GET_GOV = 4,
	THERMAL_GENL_CMD_TZ_GET_MODE = 5,
	THERMAL_GENL_CMD_CDEV_GET = 6,
	THERMAL_GENL_CMD_THRESHOLD_GET = 7,
	THERMAL_GENL_CMD_THRESHOLD_ADD = 8,
	THERMAL_GENL_CMD_THRESHOLD_DELETE = 9,
	THERMAL_GENL_CMD_THRESHOLD_FLUSH = 10,
	__THERMAL_GENL_CMD_MAX = 11,
};

enum thermal_genl_event {
	THERMAL_GENL_EVENT_UNSPEC = 0,
	THERMAL_GENL_EVENT_TZ_CREATE = 1,
	THERMAL_GENL_EVENT_TZ_DELETE = 2,
	THERMAL_GENL_EVENT_TZ_DISABLE = 3,
	THERMAL_GENL_EVENT_TZ_ENABLE = 4,
	THERMAL_GENL_EVENT_TZ_TRIP_UP = 5,
	THERMAL_GENL_EVENT_TZ_TRIP_DOWN = 6,
	THERMAL_GENL_EVENT_TZ_TRIP_CHANGE = 7,
	THERMAL_GENL_EVENT_TZ_TRIP_ADD = 8,
	THERMAL_GENL_EVENT_TZ_TRIP_DELETE = 9,
	THERMAL_GENL_EVENT_CDEV_ADD = 10,
	THERMAL_GENL_EVENT_CDEV_DELETE = 11,
	THERMAL_GENL_EVENT_CDEV_STATE_UPDATE = 12,
	THERMAL_GENL_EVENT_TZ_GOV_CHANGE = 13,
	THERMAL_GENL_EVENT_CPU_CAPABILITY_CHANGE = 14,
	THERMAL_GENL_EVENT_THRESHOLD_ADD = 15,
	THERMAL_GENL_EVENT_THRESHOLD_DELETE = 16,
	THERMAL_GENL_EVENT_THRESHOLD_FLUSH = 17,
	THERMAL_GENL_EVENT_THRESHOLD_UP = 18,
	THERMAL_GENL_EVENT_THRESHOLD_DOWN = 19,
	__THERMAL_GENL_EVENT_MAX = 20,
};

enum thermal_genl_multicast_groups {
	THERMAL_GENL_SAMPLING_GROUP = 0,
	THERMAL_GENL_EVENT_GROUP = 1,
	THERMAL_GENL_MAX_GROUP = 1,
};

enum thermal_genl_sampling {
	THERMAL_GENL_SAMPLING_TEMP = 0,
	__THERMAL_GENL_SAMPLING_MAX = 1,
};

enum thermal_notify_event {
	THERMAL_EVENT_UNSPECIFIED = 0,
	THERMAL_EVENT_TEMP_SAMPLE = 1,
	THERMAL_TRIP_VIOLATED = 2,
	THERMAL_TRIP_CHANGED = 3,
	THERMAL_DEVICE_DOWN = 4,
	THERMAL_DEVICE_UP = 5,
	THERMAL_DEVICE_POWER_CAPABILITY_CHANGED = 6,
	THERMAL_TABLE_CHANGED = 7,
	THERMAL_EVENT_KEEP_ALIVE = 8,
	THERMAL_TZ_BIND_CDEV = 9,
	THERMAL_TZ_UNBIND_CDEV = 10,
	THERMAL_INSTANCE_WEIGHT_CHANGED = 11,
	THERMAL_TZ_RESUME = 12,
	THERMAL_TZ_ADD_THRESHOLD = 13,
	THERMAL_TZ_DEL_THRESHOLD = 14,
	THERMAL_TZ_FLUSH_THRESHOLDS = 15,
};

enum thermal_trend {
	THERMAL_TREND_STABLE = 0,
	THERMAL_TREND_RAISING = 1,
	THERMAL_TREND_DROPPING = 2,
};

enum thermal_trip_type {
	THERMAL_TRIP_ACTIVE = 0,
	THERMAL_TRIP_PASSIVE = 1,
	THERMAL_TRIP_HOT = 2,
	THERMAL_TRIP_CRITICAL = 3,
};

enum tick_broadcast_mode {
	TICK_BROADCAST_OFF = 0,
	TICK_BROADCAST_ON = 1,
	TICK_BROADCAST_FORCE = 2,
};

enum tick_broadcast_state {
	TICK_BROADCAST_EXIT = 0,
	TICK_BROADCAST_ENTER = 1,
};

enum tick_dep_bits {
	TICK_DEP_BIT_POSIX_TIMER = 0,
	TICK_DEP_BIT_PERF_EVENTS = 1,
	TICK_DEP_BIT_SCHED = 2,
	TICK_DEP_BIT_CLOCK_UNSTABLE = 3,
	TICK_DEP_BIT_RCU = 4,
	TICK_DEP_BIT_RCU_EXP = 5,
};

enum tick_device_mode {
	TICKDEV_MODE_PERIODIC = 0,
	TICKDEV_MODE_ONESHOT = 1,
};

enum timekeeper_ids {
	TIMEKEEPER_CORE = 0,
	TIMEKEEPER_AUX_FIRST = 1,
	TIMEKEEPER_AUX_LAST = 8,
	TIMEKEEPERS_MAX = 9,
};

enum timekeeping_adv_mode {
	TK_ADV_TICK = 0,
	TK_ADV_FREQ = 1,
};

enum timespec_type {
	TT_NONE = 0,
	TT_NATIVE = 1,
	TT_COMPAT = 2,
};

enum tis_access {
	TPM_ACCESS_VALID = 128,
	TPM_ACCESS_ACTIVE_LOCALITY = 32,
	TPM_ACCESS_REQUEST_PENDING = 4,
	TPM_ACCESS_REQUEST_USE = 2,
};

enum tis_defaults {
	TIS_MEM_LEN = 20480,
	TIS_SHORT_TIMEOUT = 750,
	TIS_LONG_TIMEOUT = 4000,
	TIS_TIMEOUT_MIN_ATML = 14700,
	TIS_TIMEOUT_MAX_ATML = 15000,
};

enum tis_int_flags {
	TPM_GLOBAL_INT_ENABLE = 2147483648,
	TPM_INTF_BURST_COUNT_STATIC = 256,
	TPM_INTF_CMD_READY_INT = 128,
	TPM_INTF_INT_EDGE_FALLING = 64,
	TPM_INTF_INT_EDGE_RISING = 32,
	TPM_INTF_INT_LEVEL_LOW = 16,
	TPM_INTF_INT_LEVEL_HIGH = 8,
	TPM_INTF_LOCALITY_CHANGE_INT = 4,
	TPM_INTF_STS_VALID_INT = 2,
	TPM_INTF_DATA_AVAIL_INT = 1,
};

enum tis_status {
	TPM_STS_VALID = 128,
	TPM_STS_COMMAND_READY = 64,
	TPM_STS_GO = 32,
	TPM_STS_DATA_AVAIL = 16,
	TPM_STS_DATA_EXPECT = 8,
	TPM_STS_RESPONSE_RETRY = 2,
	TPM_STS_READ_ZERO = 35,
};

enum tk_offsets {
	TK_OFFS_REAL = 0,
	TK_OFFS_BOOT = 1,
	TK_OFFS_TAI = 2,
	TK_OFFS_MAX = 3,
};

enum tlb_flush_reason {
	TLB_FLUSH_ON_TASK_SWITCH = 0,
	TLB_REMOTE_SHOOTDOWN = 1,
	TLB_LOCAL_SHOOTDOWN = 2,
	TLB_LOCAL_MM_SHOOTDOWN = 3,
	TLB_REMOTE_SEND_IPI = 4,
	TLB_REMOTE_WRONG_CPU = 5,
	NR_TLB_FLUSH_REASONS = 6,
};

enum tls_offload_ctx_dir {
	TLS_OFFLOAD_CTX_DIR_RX = 0,
	TLS_OFFLOAD_CTX_DIR_TX = 1,
};

enum tomoyo_acl_entry_type_index {
	TOMOYO_TYPE_PATH_ACL = 0,
	TOMOYO_TYPE_PATH2_ACL = 1,
	TOMOYO_TYPE_PATH_NUMBER_ACL = 2,
	TOMOYO_TYPE_MKDEV_ACL = 3,
	TOMOYO_TYPE_MOUNT_ACL = 4,
	TOMOYO_TYPE_INET_ACL = 5,
	TOMOYO_TYPE_UNIX_ACL = 6,
	TOMOYO_TYPE_ENV_ACL = 7,
	TOMOYO_TYPE_MANUAL_TASK_ACL = 8,
};

enum tomoyo_conditions_index {
	TOMOYO_TASK_UID = 0,
	TOMOYO_TASK_EUID = 1,
	TOMOYO_TASK_SUID = 2,
	TOMOYO_TASK_FSUID = 3,
	TOMOYO_TASK_GID = 4,
	TOMOYO_TASK_EGID = 5,
	TOMOYO_TASK_SGID = 6,
	TOMOYO_TASK_FSGID = 7,
	TOMOYO_TASK_PID = 8,
	TOMOYO_TASK_PPID = 9,
	TOMOYO_EXEC_ARGC = 10,
	TOMOYO_EXEC_ENVC = 11,
	TOMOYO_TYPE_IS_SOCKET = 12,
	TOMOYO_TYPE_IS_SYMLINK = 13,
	TOMOYO_TYPE_IS_FILE = 14,
	TOMOYO_TYPE_IS_BLOCK_DEV = 15,
	TOMOYO_TYPE_IS_DIRECTORY = 16,
	TOMOYO_TYPE_IS_CHAR_DEV = 17,
	TOMOYO_TYPE_IS_FIFO = 18,
	TOMOYO_MODE_SETUID = 19,
	TOMOYO_MODE_SETGID = 20,
	TOMOYO_MODE_STICKY = 21,
	TOMOYO_MODE_OWNER_READ = 22,
	TOMOYO_MODE_OWNER_WRITE = 23,
	TOMOYO_MODE_OWNER_EXECUTE = 24,
	TOMOYO_MODE_GROUP_READ = 25,
	TOMOYO_MODE_GROUP_WRITE = 26,
	TOMOYO_MODE_GROUP_EXECUTE = 27,
	TOMOYO_MODE_OTHERS_READ = 28,
	TOMOYO_MODE_OTHERS_WRITE = 29,
	TOMOYO_MODE_OTHERS_EXECUTE = 30,
	TOMOYO_EXEC_REALPATH = 31,
	TOMOYO_SYMLINK_TARGET = 32,
	TOMOYO_PATH1_UID = 33,
	TOMOYO_PATH1_GID = 34,
	TOMOYO_PATH1_INO = 35,
	TOMOYO_PATH1_MAJOR = 36,
	TOMOYO_PATH1_MINOR = 37,
	TOMOYO_PATH1_PERM = 38,
	TOMOYO_PATH1_TYPE = 39,
	TOMOYO_PATH1_DEV_MAJOR = 40,
	TOMOYO_PATH1_DEV_MINOR = 41,
	TOMOYO_PATH2_UID = 42,
	TOMOYO_PATH2_GID = 43,
	TOMOYO_PATH2_INO = 44,
	TOMOYO_PATH2_MAJOR = 45,
	TOMOYO_PATH2_MINOR = 46,
	TOMOYO_PATH2_PERM = 47,
	TOMOYO_PATH2_TYPE = 48,
	TOMOYO_PATH2_DEV_MAJOR = 49,
	TOMOYO_PATH2_DEV_MINOR = 50,
	TOMOYO_PATH1_PARENT_UID = 51,
	TOMOYO_PATH1_PARENT_GID = 52,
	TOMOYO_PATH1_PARENT_INO = 53,
	TOMOYO_PATH1_PARENT_PERM = 54,
	TOMOYO_PATH2_PARENT_UID = 55,
	TOMOYO_PATH2_PARENT_GID = 56,
	TOMOYO_PATH2_PARENT_INO = 57,
	TOMOYO_PATH2_PARENT_PERM = 58,
	TOMOYO_MAX_CONDITION_KEYWORD = 59,
	TOMOYO_NUMBER_UNION = 60,
	TOMOYO_NAME_UNION = 61,
	TOMOYO_ARGV_ENTRY = 62,
	TOMOYO_ENVP_ENTRY = 63,
};

enum tomoyo_domain_info_flags_index {
	TOMOYO_DIF_QUOTA_WARNED = 0,
	TOMOYO_DIF_TRANSITION_FAILED = 1,
	TOMOYO_MAX_DOMAIN_INFO_FLAGS = 2,
};

enum tomoyo_grant_log {
	TOMOYO_GRANTLOG_AUTO = 0,
	TOMOYO_GRANTLOG_NO = 1,
	TOMOYO_GRANTLOG_YES = 2,
};

enum tomoyo_group_id {
	TOMOYO_PATH_GROUP = 0,
	TOMOYO_NUMBER_GROUP = 1,
	TOMOYO_ADDRESS_GROUP = 2,
	TOMOYO_MAX_GROUP = 3,
};

enum tomoyo_mac_category_index {
	TOMOYO_MAC_CATEGORY_FILE = 0,
	TOMOYO_MAC_CATEGORY_NETWORK = 1,
	TOMOYO_MAC_CATEGORY_MISC = 2,
	TOMOYO_MAX_MAC_CATEGORY_INDEX = 3,
};

enum tomoyo_mac_index {
	TOMOYO_MAC_FILE_EXECUTE = 0,
	TOMOYO_MAC_FILE_OPEN = 1,
	TOMOYO_MAC_FILE_CREATE = 2,
	TOMOYO_MAC_FILE_UNLINK = 3,
	TOMOYO_MAC_FILE_GETATTR = 4,
	TOMOYO_MAC_FILE_MKDIR = 5,
	TOMOYO_MAC_FILE_RMDIR = 6,
	TOMOYO_MAC_FILE_MKFIFO = 7,
	TOMOYO_MAC_FILE_MKSOCK = 8,
	TOMOYO_MAC_FILE_TRUNCATE = 9,
	TOMOYO_MAC_FILE_SYMLINK = 10,
	TOMOYO_MAC_FILE_MKBLOCK = 11,
	TOMOYO_MAC_FILE_MKCHAR = 12,
	TOMOYO_MAC_FILE_LINK = 13,
	TOMOYO_MAC_FILE_RENAME = 14,
	TOMOYO_MAC_FILE_CHMOD = 15,
	TOMOYO_MAC_FILE_CHOWN = 16,
	TOMOYO_MAC_FILE_CHGRP = 17,
	TOMOYO_MAC_FILE_IOCTL = 18,
	TOMOYO_MAC_FILE_CHROOT = 19,
	TOMOYO_MAC_FILE_MOUNT = 20,
	TOMOYO_MAC_FILE_UMOUNT = 21,
	TOMOYO_MAC_FILE_PIVOT_ROOT = 22,
	TOMOYO_MAC_NETWORK_INET_STREAM_BIND = 23,
	TOMOYO_MAC_NETWORK_INET_STREAM_LISTEN = 24,
	TOMOYO_MAC_NETWORK_INET_STREAM_CONNECT = 25,
	TOMOYO_MAC_NETWORK_INET_DGRAM_BIND = 26,
	TOMOYO_MAC_NETWORK_INET_DGRAM_SEND = 27,
	TOMOYO_MAC_NETWORK_INET_RAW_BIND = 28,
	TOMOYO_MAC_NETWORK_INET_RAW_SEND = 29,
	TOMOYO_MAC_NETWORK_UNIX_STREAM_BIND = 30,
	TOMOYO_MAC_NETWORK_UNIX_STREAM_LISTEN = 31,
	TOMOYO_MAC_NETWORK_UNIX_STREAM_CONNECT = 32,
	TOMOYO_MAC_NETWORK_UNIX_DGRAM_BIND = 33,
	TOMOYO_MAC_NETWORK_UNIX_DGRAM_SEND = 34,
	TOMOYO_MAC_NETWORK_UNIX_SEQPACKET_BIND = 35,
	TOMOYO_MAC_NETWORK_UNIX_SEQPACKET_LISTEN = 36,
	TOMOYO_MAC_NETWORK_UNIX_SEQPACKET_CONNECT = 37,
	TOMOYO_MAC_ENVIRON = 38,
	TOMOYO_MAX_MAC_INDEX = 39,
};

enum tomoyo_memory_stat_type {
	TOMOYO_MEMORY_POLICY = 0,
	TOMOYO_MEMORY_AUDIT = 1,
	TOMOYO_MEMORY_QUERY = 2,
	TOMOYO_MAX_MEMORY_STAT = 3,
};

enum tomoyo_mkdev_acl_index {
	TOMOYO_TYPE_MKBLOCK = 0,
	TOMOYO_TYPE_MKCHAR = 1,
	TOMOYO_MAX_MKDEV_OPERATION = 2,
};

enum tomoyo_mode_index {
	TOMOYO_CONFIG_DISABLED = 0,
	TOMOYO_CONFIG_LEARNING = 1,
	TOMOYO_CONFIG_PERMISSIVE = 2,
	TOMOYO_CONFIG_ENFORCING = 3,
	TOMOYO_CONFIG_MAX_MODE = 4,
	TOMOYO_CONFIG_WANT_REJECT_LOG = 64,
	TOMOYO_CONFIG_WANT_GRANT_LOG = 128,
	TOMOYO_CONFIG_USE_DEFAULT = 255,
};

enum tomoyo_network_acl_index {
	TOMOYO_NETWORK_BIND = 0,
	TOMOYO_NETWORK_LISTEN = 1,
	TOMOYO_NETWORK_CONNECT = 2,
	TOMOYO_NETWORK_SEND = 3,
	TOMOYO_MAX_NETWORK_OPERATION = 4,
};

enum tomoyo_path2_acl_index {
	TOMOYO_TYPE_LINK = 0,
	TOMOYO_TYPE_RENAME = 1,
	TOMOYO_TYPE_PIVOT_ROOT = 2,
	TOMOYO_MAX_PATH2_OPERATION = 3,
};

enum tomoyo_path_acl_index {
	TOMOYO_TYPE_EXECUTE = 0,
	TOMOYO_TYPE_READ = 1,
	TOMOYO_TYPE_WRITE = 2,
	TOMOYO_TYPE_APPEND = 3,
	TOMOYO_TYPE_UNLINK = 4,
	TOMOYO_TYPE_GETATTR = 5,
	TOMOYO_TYPE_RMDIR = 6,
	TOMOYO_TYPE_TRUNCATE = 7,
	TOMOYO_TYPE_SYMLINK = 8,
	TOMOYO_TYPE_CHROOT = 9,
	TOMOYO_TYPE_UMOUNT = 10,
	TOMOYO_MAX_PATH_OPERATION = 11,
};

enum tomoyo_path_number_acl_index {
	TOMOYO_TYPE_CREATE = 0,
	TOMOYO_TYPE_MKDIR = 1,
	TOMOYO_TYPE_MKFIFO = 2,
	TOMOYO_TYPE_MKSOCK = 3,
	TOMOYO_TYPE_IOCTL = 4,
	TOMOYO_TYPE_CHMOD = 5,
	TOMOYO_TYPE_CHOWN = 6,
	TOMOYO_TYPE_CHGRP = 7,
	TOMOYO_MAX_PATH_NUMBER_OPERATION = 8,
};

enum tomoyo_path_stat_index {
	TOMOYO_PATH1 = 0,
	TOMOYO_PATH1_PARENT = 1,
	TOMOYO_PATH2 = 2,
	TOMOYO_PATH2_PARENT = 3,
	TOMOYO_MAX_PATH_STAT = 4,
};

enum tomoyo_policy_id {
	TOMOYO_ID_GROUP = 0,
	TOMOYO_ID_ADDRESS_GROUP = 1,
	TOMOYO_ID_PATH_GROUP = 2,
	TOMOYO_ID_NUMBER_GROUP = 3,
	TOMOYO_ID_TRANSITION_CONTROL = 4,
	TOMOYO_ID_AGGREGATOR = 5,
	TOMOYO_ID_MANAGER = 6,
	TOMOYO_ID_CONDITION = 7,
	TOMOYO_ID_NAME = 8,
	TOMOYO_ID_ACL = 9,
	TOMOYO_ID_DOMAIN = 10,
	TOMOYO_MAX_POLICY = 11,
};

enum tomoyo_policy_stat_type {
	TOMOYO_STAT_POLICY_UPDATES = 0,
	TOMOYO_STAT_POLICY_LEARNING = 1,
	TOMOYO_STAT_POLICY_PERMISSIVE = 2,
	TOMOYO_STAT_POLICY_ENFORCING = 3,
	TOMOYO_MAX_POLICY_STAT = 4,
};

enum tomoyo_pref_index {
	TOMOYO_PREF_MAX_AUDIT_LOG = 0,
	TOMOYO_PREF_MAX_LEARNING_ENTRY = 1,
	TOMOYO_MAX_PREF = 2,
};

enum tomoyo_securityfs_interface_index {
	TOMOYO_DOMAINPOLICY = 0,
	TOMOYO_EXCEPTIONPOLICY = 1,
	TOMOYO_PROCESS_STATUS = 2,
	TOMOYO_STAT = 3,
	TOMOYO_AUDIT = 4,
	TOMOYO_VERSION = 5,
	TOMOYO_PROFILE = 6,
	TOMOYO_QUERY = 7,
	TOMOYO_MANAGER = 8,
};

enum tomoyo_special_mount {
	TOMOYO_MOUNT_BIND = 0,
	TOMOYO_MOUNT_MOVE = 1,
	TOMOYO_MOUNT_REMOUNT = 2,
	TOMOYO_MOUNT_MAKE_UNBINDABLE = 3,
	TOMOYO_MOUNT_MAKE_PRIVATE = 4,
	TOMOYO_MOUNT_MAKE_SLAVE = 5,
	TOMOYO_MOUNT_MAKE_SHARED = 6,
	TOMOYO_MAX_SPECIAL_MOUNT = 7,
};

enum tomoyo_transition_type {
	TOMOYO_TRANSITION_CONTROL_NO_RESET = 0,
	TOMOYO_TRANSITION_CONTROL_RESET = 1,
	TOMOYO_TRANSITION_CONTROL_NO_INITIALIZE = 2,
	TOMOYO_TRANSITION_CONTROL_INITIALIZE = 3,
	TOMOYO_TRANSITION_CONTROL_NO_KEEP = 4,
	TOMOYO_TRANSITION_CONTROL_KEEP = 5,
	TOMOYO_MAX_TRANSITION_TYPE = 6,
};

enum tomoyo_value_type {
	TOMOYO_VALUE_TYPE_INVALID = 0,
	TOMOYO_VALUE_TYPE_DECIMAL = 1,
	TOMOYO_VALUE_TYPE_OCTAL = 2,
	TOMOYO_VALUE_TYPE_HEXADECIMAL = 3,
};

enum topo_types {
	INVALID_TYPE = 0,
	SMT_TYPE = 1,
	CORE_TYPE = 2,
	MAX_TYPE_0B = 3,
	MODULE_TYPE = 3,
	AMD_CCD_TYPE = 3,
	TILE_TYPE = 4,
	AMD_SOCKET_TYPE = 4,
	MAX_TYPE_80000026 = 5,
	DIE_TYPE = 5,
	DIEGRP_TYPE = 6,
	MAX_TYPE_1F = 7,
};

enum tp_func_state {
	TP_FUNC_0 = 0,
	TP_FUNC_1 = 1,
	TP_FUNC_2 = 2,
	TP_FUNC_N = 3,
};

enum tp_transition_sync {
	TP_TRANSITION_SYNC_1_0_1 = 0,
	TP_TRANSITION_SYNC_N_2_1 = 1,
	_NR_TP_TRANSITION_SYNC = 2,
};

enum tpacket_versions {
	TPACKET_V1 = 0,
	TPACKET_V2 = 1,
	TPACKET_V3 = 2,
};

enum tph_mem_type {
	TPH_MEM_TYPE_VM = 0,
	TPH_MEM_TYPE_PM = 1,
};

enum tpm2_capabilities {
	TPM2_CAP_HANDLES = 1,
	TPM2_CAP_COMMANDS = 2,
	TPM2_CAP_PCRS = 5,
	TPM2_CAP_TPM_PROPERTIES = 6,
};

enum tpm2_cc_attrs {
	TPM2_CC_ATTR_CHANDLES = 25,
	TPM2_CC_ATTR_RHANDLE = 28,
	TPM2_CC_ATTR_VENDOR = 29,
};

enum tpm2_command_codes {
	TPM2_CC_FIRST = 287,
	TPM2_CC_HIERARCHY_CONTROL = 289,
	TPM2_CC_HIERARCHY_CHANGE_AUTH = 297,
	TPM2_CC_CREATE_PRIMARY = 305,
	TPM2_CC_SEQUENCE_COMPLETE = 318,
	TPM2_CC_SELF_TEST = 323,
	TPM2_CC_STARTUP = 324,
	TPM2_CC_SHUTDOWN = 325,
	TPM2_CC_NV_READ = 334,
	TPM2_CC_CREATE = 339,
	TPM2_CC_LOAD = 343,
	TPM2_CC_SEQUENCE_UPDATE = 348,
	TPM2_CC_UNSEAL = 350,
	TPM2_CC_CONTEXT_LOAD = 353,
	TPM2_CC_CONTEXT_SAVE = 354,
	TPM2_CC_FLUSH_CONTEXT = 357,
	TPM2_CC_READ_PUBLIC = 371,
	TPM2_CC_START_AUTH_SESS = 374,
	TPM2_CC_VERIFY_SIGNATURE = 375,
	TPM2_CC_GET_CAPABILITY = 378,
	TPM2_CC_GET_RANDOM = 379,
	TPM2_CC_PCR_READ = 382,
	TPM2_CC_PCR_EXTEND = 386,
	TPM2_CC_EVENT_SEQUENCE_COMPLETE = 389,
	TPM2_CC_HASH_SEQUENCE_START = 390,
	TPM2_CC_CREATE_LOADED = 401,
	TPM2_CC_LAST = 403,
};

enum tpm2_const {
	TPM2_PLATFORM_PCR = 24,
	TPM2_PCR_SELECT_MIN = 3,
};

enum tpm2_curves {
	TPM2_ECC_NONE = 0,
	TPM2_ECC_NIST_P256 = 3,
};

enum tpm2_handle_types {
	TPM2_HT_HMAC_SESSION = 33554432,
	TPM2_HT_POLICY_SESSION = 50331648,
	TPM2_HT_TRANSIENT = 2147483648,
};

enum tpm2_mso_type {
	TPM2_MSO_NVRAM = 1,
	TPM2_MSO_SESSION = 2,
	TPM2_MSO_POLICY = 3,
	TPM2_MSO_PERMANENT = 64,
	TPM2_MSO_VOLATILE = 128,
	TPM2_MSO_PERSISTENT = 129,
};

enum tpm2_object_attributes {
	TPM2_OA_FIXED_TPM = 2,
	TPM2_OA_ST_CLEAR = 4,
	TPM2_OA_FIXED_PARENT = 16,
	TPM2_OA_SENSITIVE_DATA_ORIGIN = 32,
	TPM2_OA_USER_WITH_AUTH = 64,
	TPM2_OA_ADMIN_WITH_POLICY = 128,
	TPM2_OA_NO_DA = 1024,
	TPM2_OA_ENCRYPTED_DUPLICATION = 2048,
	TPM2_OA_RESTRICTED = 65536,
	TPM2_OA_DECRYPT = 131072,
	TPM2_OA_SIGN = 262144,
};

enum tpm2_permanent_handles {
	TPM2_RH_NULL = 1073741831,
	TPM2_RS_PW = 1073741833,
};

enum tpm2_properties {
	TPM_PT_TOTAL_COMMANDS = 297,
};

enum tpm2_return_codes {
	TPM2_RC_SUCCESS = 0,
	TPM2_RC_HASH = 131,
	TPM2_RC_HANDLE = 139,
	TPM2_RC_INTEGRITY = 159,
	TPM2_RC_INITIALIZE = 256,
	TPM2_RC_FAILURE = 257,
	TPM2_RC_DISABLED = 288,
	TPM2_RC_UPGRADE = 301,
	TPM2_RC_COMMAND_CODE = 323,
	TPM2_RC_TESTING = 2314,
	TPM2_RC_REFERENCE_H0 = 2320,
	TPM2_RC_RETRY = 2338,
	TPM2_RC_SESSION_MEMORY = 2307,
};

enum tpm2_session_attributes {
	TPM2_SA_CONTINUE_SESSION = 1,
	TPM2_SA_AUDIT_EXCLUSIVE = 2,
	TPM2_SA_AUDIT_RESET = 8,
	TPM2_SA_DECRYPT = 32,
	TPM2_SA_ENCRYPT = 64,
	TPM2_SA_AUDIT = 128,
};

enum tpm2_session_types {
	TPM2_SE_HMAC = 0,
	TPM2_SE_POLICY = 1,
	TPM2_SE_TRIAL = 2,
};

enum tpm2_startup_types {
	TPM2_SU_CLEAR = 0,
	TPM2_SU_STATE = 1,
};

enum tpm2_structures {
	TPM2_ST_NO_SESSIONS = 32769,
	TPM2_ST_SESSIONS = 32770,
	TPM2_ST_CREATION = 32801,
};

enum tpm2_timeouts {
	TPM2_TIMEOUT_A = 750,
	TPM2_TIMEOUT_B = 4000,
	TPM2_TIMEOUT_C = 200,
	TPM2_TIMEOUT_D = 30,
	TPM2_DURATION_SHORT = 20,
	TPM2_DURATION_MEDIUM = 750,
	TPM2_DURATION_LONG = 2000,
	TPM2_DURATION_LONG_LONG = 300000,
	TPM2_DURATION_DEFAULT = 120000,
};

enum tpm_algorithms {
	TPM_ALG_ERROR = 0,
	TPM_ALG_SHA1 = 4,
	TPM_ALG_AES = 6,
	TPM_ALG_KEYEDHASH = 8,
	TPM_ALG_SHA256 = 11,
	TPM_ALG_SHA384 = 12,
	TPM_ALG_SHA512 = 13,
	TPM_ALG_NULL = 16,
	TPM_ALG_SM3_256 = 18,
	TPM_ALG_ECC = 35,
	TPM_ALG_CFB = 67,
};

enum tpm_buf_flags {
	TPM_BUF_OVERFLOW = 1,
	TPM_BUF_TPM2B = 2,
	TPM_BUF_BOUNDARY_ERROR = 4,
};

enum tpm_capabilities {
	TPM_CAP_FLAG = 4,
	TPM_CAP_PROP = 5,
	TPM_CAP_VERSION_1_1 = 6,
	TPM_CAP_VERSION_1_2 = 26,
};

enum tpm_chip_flags {
	TPM_CHIP_FLAG_BOOTSTRAPPED = 1,
	TPM_CHIP_FLAG_TPM2 = 2,
	TPM_CHIP_FLAG_IRQ = 4,
	TPM_CHIP_FLAG_VIRTUAL = 8,
	TPM_CHIP_FLAG_HAVE_TIMEOUTS = 16,
	TPM_CHIP_FLAG_ALWAYS_POWERED = 32,
	TPM_CHIP_FLAG_FIRMWARE_POWER_MANAGED = 64,
	TPM_CHIP_FLAG_FIRMWARE_UPGRADE = 128,
	TPM_CHIP_FLAG_SUSPENDED = 256,
	TPM_CHIP_FLAG_HWRNG_DISABLED = 512,
	TPM_CHIP_FLAG_DISABLE = 1024,
	TPM_CHIP_FLAG_SYNC = 2048,
};

enum tpm_duration {
	TPM_SHORT = 0,
	TPM_MEDIUM = 1,
	TPM_LONG = 2,
	TPM_LONG_LONG = 3,
	TPM_UNDEFINED = 4,
	TPM_NUM_DURATIONS = 4,
};

enum tpm_sub_capabilities {
	TPM_CAP_PROP_PCR = 257,
	TPM_CAP_PROP_MANUFACTURER = 259,
	TPM_CAP_FLAG_PERM = 264,
	TPM_CAP_FLAG_VOL = 265,
	TPM_CAP_PROP_OWNER = 273,
	TPM_CAP_PROP_TIS_TIMEOUT = 277,
	TPM_CAP_PROP_TIS_DURATION = 288,
};

enum tpm_timeout {
	TPM_TIMEOUT = 5,
	TPM_TIMEOUT_RETRY = 100,
	TPM_TIMEOUT_RANGE_US = 300,
	TPM_TIMEOUT_POLL = 1,
	TPM_TIMEOUT_USECS_MIN = 100,
	TPM_TIMEOUT_USECS_MAX = 500,
};

enum tpm_tis_flags {
	TPM_TIS_ITPM_WORKAROUND = 0,
	TPM_TIS_INVALID_STATUS = 1,
	TPM_TIS_DEFAULT_CANCELLATION = 2,
	TPM_TIS_IRQ_TESTED = 3,
	TPM_TIS_STATUS_VALID_RETRY = 4,
};

enum tpm_tis_io_mode {
	TPM_TIS_PHYS_8 = 0,
	TPM_TIS_PHYS_16 = 1,
	TPM_TIS_PHYS_32 = 2,
};

enum tps65090_cells {
	PMIC = 0,
	CHARGER = 1,
};

enum trace_flag_type {
	TRACE_FLAG_IRQS_OFF = 1,
	TRACE_FLAG_NEED_RESCHED_LAZY = 2,
	TRACE_FLAG_NEED_RESCHED = 4,
	TRACE_FLAG_HARDIRQ = 8,
	TRACE_FLAG_SOFTIRQ = 16,
	TRACE_FLAG_PREEMPT_RESCHED = 32,
	TRACE_FLAG_NMI = 64,
	TRACE_FLAG_BH_OFF = 128,
};

enum trace_iter_flags {
	TRACE_FILE_LAT_FMT = 1,
	TRACE_FILE_ANNOTATE = 2,
	TRACE_FILE_TIME_IN_NS = 4,
};

enum trace_iterator_bits {
	TRACE_ITER_PRINT_PARENT_BIT = 0,
	TRACE_ITER_SYM_OFFSET_BIT = 1,
	TRACE_ITER_SYM_ADDR_BIT = 2,
	TRACE_ITER_VERBOSE_BIT = 3,
	TRACE_ITER_RAW_BIT = 4,
	TRACE_ITER_HEX_BIT = 5,
	TRACE_ITER_BIN_BIT = 6,
	TRACE_ITER_BLOCK_BIT = 7,
	TRACE_ITER_FIELDS_BIT = 8,
	TRACE_ITER_PRINTK_BIT = 9,
	TRACE_ITER_ANNOTATE_BIT = 10,
	TRACE_ITER_USERSTACKTRACE_BIT = 11,
	TRACE_ITER_SYM_USEROBJ_BIT = 12,
	TRACE_ITER_PRINTK_MSGONLY_BIT = 13,
	TRACE_ITER_CONTEXT_INFO_BIT = 14,
	TRACE_ITER_LATENCY_FMT_BIT = 15,
	TRACE_ITER_RECORD_CMD_BIT = 16,
	TRACE_ITER_RECORD_TGID_BIT = 17,
	TRACE_ITER_OVERWRITE_BIT = 18,
	TRACE_ITER_STOP_ON_FREE_BIT = 19,
	TRACE_ITER_IRQ_INFO_BIT = 20,
	TRACE_ITER_MARKERS_BIT = 21,
	TRACE_ITER_EVENT_FORK_BIT = 22,
	TRACE_ITER_TRACE_PRINTK_BIT = 23,
	TRACE_ITER_COPY_MARKER_BIT = 24,
	TRACE_ITER_PAUSE_ON_TRACE_BIT = 25,
	TRACE_ITER_HASH_PTR_BIT = 26,
	TRACE_ITER_FUNCTION_BIT = 27,
	TRACE_ITER_FUNC_FORK_BIT = 28,
	TRACE_ITER_DISPLAY_GRAPH_BIT = 29,
	TRACE_ITER_STACKTRACE_BIT = 30,
	TRACE_ITER_LAST_BIT = 31,
};

enum trace_iterator_flags {
	TRACE_ITER_PRINT_PARENT = 1,
	TRACE_ITER_SYM_OFFSET = 2,
	TRACE_ITER_SYM_ADDR = 4,
	TRACE_ITER_VERBOSE = 8,
	TRACE_ITER_RAW = 16,
	TRACE_ITER_HEX = 32,
	TRACE_ITER_BIN = 64,
	TRACE_ITER_BLOCK = 128,
	TRACE_ITER_FIELDS = 256,
	TRACE_ITER_PRINTK = 512,
	TRACE_ITER_ANNOTATE = 1024,
	TRACE_ITER_USERSTACKTRACE = 2048,
	TRACE_ITER_SYM_USEROBJ = 4096,
	TRACE_ITER_PRINTK_MSGONLY = 8192,
	TRACE_ITER_CONTEXT_INFO = 16384,
	TRACE_ITER_LATENCY_FMT = 32768,
	TRACE_ITER_RECORD_CMD = 65536,
	TRACE_ITER_RECORD_TGID = 131072,
	TRACE_ITER_OVERWRITE = 262144,
	TRACE_ITER_STOP_ON_FREE = 524288,
	TRACE_ITER_IRQ_INFO = 1048576,
	TRACE_ITER_MARKERS = 2097152,
	TRACE_ITER_EVENT_FORK = 4194304,
	TRACE_ITER_TRACE_PRINTK = 8388608,
	TRACE_ITER_COPY_MARKER = 16777216,
	TRACE_ITER_PAUSE_ON_TRACE = 33554432,
	TRACE_ITER_HASH_PTR = 67108864,
	TRACE_ITER_FUNCTION = 134217728,
	TRACE_ITER_FUNC_FORK = 268435456,
	TRACE_ITER_DISPLAY_GRAPH = 536870912,
	TRACE_ITER_STACKTRACE = 1073741824,
};

enum trace_reg {
	TRACE_REG_REGISTER = 0,
	TRACE_REG_UNREGISTER = 1,
	TRACE_REG_PERF_REGISTER = 2,
	TRACE_REG_PERF_UNREGISTER = 3,
	TRACE_REG_PERF_OPEN = 4,
	TRACE_REG_PERF_CLOSE = 5,
	TRACE_REG_PERF_ADD = 6,
	TRACE_REG_PERF_DEL = 7,
};

enum trace_type {
	__TRACE_FIRST_TYPE = 0,
	TRACE_FN = 1,
	TRACE_CTX = 2,
	TRACE_WAKE = 3,
	TRACE_STACK = 4,
	TRACE_PRINT = 5,
	TRACE_BPRINT = 6,
	TRACE_MMIO_RW = 7,
	TRACE_MMIO_MAP = 8,
	TRACE_BRANCH = 9,
	TRACE_GRAPH_RET = 10,
	TRACE_GRAPH_ENT = 11,
	TRACE_GRAPH_RETADDR_ENT = 12,
	TRACE_USER_STACK = 13,
	TRACE_BLK = 14,
	TRACE_BPUTS = 15,
	TRACE_HWLAT = 16,
	TRACE_OSNOISE = 17,
	TRACE_TIMERLAT = 18,
	TRACE_RAW_DATA = 19,
	TRACE_FUNC_REPEATS = 20,
	__TRACE_LAST_TYPE = 21,
};

enum track_item {
	TRACK_ALLOC = 0,
	TRACK_FREE = 1,
};

enum transaction_flags {
	TF_ONE_WAY = 1,
	TF_ROOT_OBJECT = 4,
	TF_STATUS_CODE = 8,
	TF_ACCEPT_FDS = 16,
	TF_CLEAR_BUF = 32,
	TF_UPDATE_TXN = 64,
};

enum translation_map {
	LAT1_MAP = 0,
	GRAF_MAP = 1,
	IBMPC_MAP = 2,
	USER_MAP = 3,
	FIRST_MAP = 0,
	LAST_MAP = 3,
};

enum transparent_hugepage_flag {
	TRANSPARENT_HUGEPAGE_UNSUPPORTED = 0,
	TRANSPARENT_HUGEPAGE_FLAG = 1,
	TRANSPARENT_HUGEPAGE_REQ_MADV_FLAG = 2,
	TRANSPARENT_HUGEPAGE_DEFRAG_DIRECT_FLAG = 3,
	TRANSPARENT_HUGEPAGE_DEFRAG_KSWAPD_FLAG = 4,
	TRANSPARENT_HUGEPAGE_DEFRAG_KSWAPD_OR_MADV_FLAG = 5,
	TRANSPARENT_HUGEPAGE_DEFRAG_REQ_MADV_FLAG = 6,
	TRANSPARENT_HUGEPAGE_DEFRAG_KHUGEPAGED_FLAG = 7,
	TRANSPARENT_HUGEPAGE_USE_ZERO_PAGE_FLAG = 8,
};

enum tsa_mitigations {
	TSA_MITIGATION_NONE = 0,
	TSA_MITIGATION_AUTO = 1,
	TSA_MITIGATION_UCODE_NEEDED = 2,
	TSA_MITIGATION_USER_KERNEL = 3,
	TSA_MITIGATION_VM = 4,
	TSA_MITIGATION_FULL = 5,
};

enum tsq_enum {
	TSQ_THROTTLED = 0,
	TSQ_QUEUED = 1,
	TCP_TSQ_DEFERRED = 2,
	TCP_WRITE_TIMER_DEFERRED = 3,
	TCP_DELACK_TIMER_DEFERRED = 4,
	TCP_MTU_REDUCED_DEFERRED = 5,
	TCP_ACK_DEFERRED = 6,
};

enum tsq_flags {
	TSQF_THROTTLED = 1,
	TSQF_QUEUED = 2,
	TCPF_TSQ_DEFERRED = 4,
	TCPF_WRITE_TIMER_DEFERRED = 8,
	TCPF_DELACK_TIMER_DEFERRED = 16,
	TCPF_MTU_REDUCED_DEFERRED = 32,
	TCPF_ACK_DEFERRED = 64,
};

enum tsx_ctrl_states {
	TSX_CTRL_ENABLE = 0,
	TSX_CTRL_DISABLE = 1,
	TSX_CTRL_RTM_ALWAYS_ABORT = 2,
	TSX_CTRL_NOT_SUPPORTED = 3,
};

enum tt_ids {
	TT_INSTR = 0,
	TT_DATA = 1,
	TT_GEN = 2,
	TT_RESV = 3,
};

enum ttu_flags {
	TTU_SPLIT_HUGE_PMD = 4,
	TTU_IGNORE_MLOCK = 8,
	TTU_SYNC = 16,
	TTU_HWPOISON = 32,
	TTU_BATCH_FLUSH = 64,
	TTU_RMAP_LOCKED = 128,
};

enum tty_driver_flag {
	TTY_DRIVER_INSTALLED = 1,
	TTY_DRIVER_RESET_TERMIOS = 2,
	TTY_DRIVER_REAL_RAW = 4,
	TTY_DRIVER_DYNAMIC_DEV = 8,
	TTY_DRIVER_DEVPTS_MEM = 16,
	TTY_DRIVER_HARDWARE_BREAK = 32,
	TTY_DRIVER_DYNAMIC_ALLOC = 64,
	TTY_DRIVER_UNNUMBERED_NODE = 128,
};

enum tty_driver_subtype {
	SYSTEM_TYPE_TTY = 1,
	SYSTEM_TYPE_CONSOLE = 2,
	SYSTEM_TYPE_SYSCONS = 3,
	SYSTEM_TYPE_SYSPTMX = 4,
	PTY_TYPE_MASTER = 1,
	PTY_TYPE_SLAVE = 2,
	SERIAL_TYPE_NORMAL = 1,
};

enum tty_driver_type {
	TTY_DRIVER_TYPE_SYSTEM = 0,
	TTY_DRIVER_TYPE_CONSOLE = 1,
	TTY_DRIVER_TYPE_SERIAL = 2,
	TTY_DRIVER_TYPE_PTY = 3,
	TTY_DRIVER_TYPE_SCC = 4,
	TTY_DRIVER_TYPE_SYSCONS = 5,
};

enum tty_flow_change {
	TTY_FLOW_NO_CHANGE = 0,
	TTY_THROTTLE_SAFE = 1,
	TTY_UNTHROTTLE_SAFE = 2,
};

enum tty_struct_flags {
	TTY_THROTTLED = 0,
	TTY_IO_ERROR = 1,
	TTY_OTHER_CLOSED = 2,
	TTY_EXCLUSIVE = 3,
	TTY_DO_WRITE_WAKEUP = 4,
	TTY_LDISC_OPEN = 5,
	TTY_PTY_LOCK = 6,
	TTY_NO_WRITE_SPLIT = 7,
	TTY_HUPPED = 8,
	TTY_HUPPING = 9,
	TTY_LDISC_CHANGING = 10,
	TTY_LDISC_HALTED = 11,
};

enum tunable_id {
	ETHTOOL_ID_UNSPEC = 0,
	ETHTOOL_RX_COPYBREAK = 1,
	ETHTOOL_TX_COPYBREAK = 2,
	ETHTOOL_PFC_PREVENTION_TOUT = 3,
	ETHTOOL_TX_COPYBREAK_BUF_SIZE = 4,
	__ETHTOOL_TUNABLE_COUNT = 5,
};

enum tunable_type_id {
	ETHTOOL_TUNABLE_UNSPEC = 0,
	ETHTOOL_TUNABLE_U8 = 1,
	ETHTOOL_TUNABLE_U16 = 2,
	ETHTOOL_TUNABLE_U32 = 3,
	ETHTOOL_TUNABLE_U64 = 4,
	ETHTOOL_TUNABLE_STRING = 5,
	ETHTOOL_TUNABLE_S8 = 6,
	ETHTOOL_TUNABLE_S16 = 7,
	ETHTOOL_TUNABLE_S32 = 8,
	ETHTOOL_TUNABLE_S64 = 9,
};

enum twl4030_audio_res {
	TWL4030_AUDIO_RES_POWER = 0,
	TWL4030_AUDIO_RES_APLL = 1,
	TWL4030_AUDIO_RES_MAX = 2,
};

enum twl4030_module_ids {
	TWL4030_MODULE_AUDIO_VOICE = 9,
	TWL4030_MODULE_GPIO = 10,
	TWL4030_MODULE_INTBR = 11,
	TWL4030_MODULE_TEST = 12,
	TWL4030_MODULE_KEYPAD = 13,
	TWL4030_MODULE_MADC = 14,
	TWL4030_MODULE_INTERRUPTS = 15,
	TWL4030_MODULE_PRECHARGE = 16,
	TWL4030_MODULE_BACKUP = 17,
	TWL4030_MODULE_INT = 18,
	TWL5031_MODULE_ACCESSORY = 19,
	TWL5031_MODULE_INTERRUPTS = 20,
	TWL4030_MODULE_LAST = 21,
};

enum twl6030_module_ids {
	TWL6030_MODULE_ID0 = 9,
	TWL6030_MODULE_ID1 = 10,
	TWL6030_MODULE_ID2 = 11,
	TWL6030_MODULE_GPADC = 12,
	TWL6030_MODULE_GASGAUGE = 13,
	TWL6032_MODULE_CHARGE = 14,
	TWL6030_MODULE_LAST = 15,
};

enum twl_module_ids {
	TWL_MODULE_USB = 0,
	TWL_MODULE_PIH = 1,
	TWL_MODULE_MAIN_CHARGE = 2,
	TWL_MODULE_PM_MASTER = 3,
	TWL_MODULE_PM_RECEIVER = 4,
	TWL_MODULE_RTC = 5,
	TWL_MODULE_PWM = 6,
	TWL_MODULE_LED = 7,
	TWL_MODULE_SECURED_REG = 8,
	TWL_MODULE_LAST = 9,
};

enum txtime_flags {
	SOF_TXTIME_DEADLINE_MODE = 1,
	SOF_TXTIME_REPORT_ERRORS = 2,
	SOF_TXTIME_FLAGS_LAST = 2,
	SOF_TXTIME_FLAGS_MASK = 3,
};

enum uart_iotype {
	UPIO_UNKNOWN = -1,
	UPIO_PORT = 0,
	UPIO_HUB6 = 1,
	UPIO_MEM = 2,
	UPIO_MEM32 = 3,
	UPIO_AU = 4,
	UPIO_TSI = 5,
	UPIO_MEM32BE = 6,
	UPIO_MEM16 = 7,
};

enum uart_pm_state {
	UART_PM_STATE_ON = 0,
	UART_PM_STATE_OFF = 3,
	UART_PM_STATE_UNDEFINED = 4,
};

enum uclamp_id {
	UCLAMP_MIN = 0,
	UCLAMP_MAX = 1,
	UCLAMP_CNT = 2,
};

enum ucode_state {
	UCODE_OK = 0,
	UCODE_NEW = 1,
	UCODE_NEW_SAFE = 2,
	UCODE_UPDATED = 3,
	UCODE_NFOUND = 4,
	UCODE_ERROR = 5,
	UCODE_TIMEOUT = 6,
	UCODE_OFFLINE = 7,
};

enum ucount_type {
	UCOUNT_USER_NAMESPACES = 0,
	UCOUNT_PID_NAMESPACES = 1,
	UCOUNT_UTS_NAMESPACES = 2,
	UCOUNT_IPC_NAMESPACES = 3,
	UCOUNT_NET_NAMESPACES = 4,
	UCOUNT_MNT_NAMESPACES = 5,
	UCOUNT_CGROUP_NAMESPACES = 6,
	UCOUNT_TIME_NAMESPACES = 7,
	UCOUNT_INOTIFY_INSTANCES = 8,
	UCOUNT_INOTIFY_WATCHES = 9,
	UCOUNT_FANOTIFY_GROUPS = 10,
	UCOUNT_FANOTIFY_MARKS = 11,
	UCOUNT_COUNTS = 12,
};

enum udp_conntrack {
	UDP_CT_UNREPLIED = 0,
	UDP_CT_REPLIED = 1,
	UDP_CT_MAX = 2,
};

enum udp_parsable_tunnel_type {
	UDP_TUNNEL_TYPE_VXLAN = 1,
	UDP_TUNNEL_TYPE_GENEVE = 2,
	UDP_TUNNEL_TYPE_VXLAN_GPE = 4,
};

enum udp_tunnel_nic_info_flags {
	UDP_TUNNEL_NIC_INFO_OPEN_ONLY = 1,
	UDP_TUNNEL_NIC_INFO_IPV4_ONLY = 2,
	UDP_TUNNEL_NIC_INFO_STATIC_IANA_VXLAN = 4,
};

enum uhci_rh_state {
	UHCI_RH_RESET = 0,
	UHCI_RH_SUSPENDED = 1,
	UHCI_RH_AUTO_STOPPED = 2,
	UHCI_RH_RESUMING = 3,
	UHCI_RH_SUSPENDING = 4,
	UHCI_RH_RUNNING = 5,
	UHCI_RH_RUNNING_NODEVS = 6,
};

enum umh_disable_depth {
	UMH_ENABLED = 0,
	UMH_FREEZING = 1,
	UMH_DISABLED = 2,
};

enum umount_tree_flags {
	UMOUNT_SYNC = 1,
	UMOUNT_PROPAGATE = 2,
	UMOUNT_CONNECTED = 4,
};

enum unix_vertex_index {
	UNIX_VERTEX_INDEX_MARK1 = 0,
	UNIX_VERTEX_INDEX_MARK2 = 1,
	UNIX_VERTEX_INDEX_START = 2,
};

enum unwind_user_type_bits {
	UNWIND_USER_TYPE_FP_BIT = 0,
	NR_UNWIND_USER_TYPE_BITS = 1,
};

enum uprobe_task_state {
	UTASK_RUNNING = 0,
	UTASK_SSTEP = 1,
	UTASK_SSTEP_ACK = 2,
	UTASK_SSTEP_TRAPPED = 3,
};

enum usb3_link_state {
	USB3_LPM_U0 = 0,
	USB3_LPM_U1 = 1,
	USB3_LPM_U2 = 2,
	USB3_LPM_U3 = 3,
};

enum usb_charger_state {
	USB_CHARGER_DEFAULT = 0,
	USB_CHARGER_PRESENT = 1,
	USB_CHARGER_ABSENT = 2,
};

enum usb_charger_type {
	UNKNOWN_TYPE = 0,
	SDP_TYPE = 1,
	DCP_TYPE = 2,
	CDP_TYPE = 3,
	ACA_TYPE = 4,
};

enum usb_dev_authorize_policy {
	USB_DEVICE_AUTHORIZE_NONE = 0,
	USB_DEVICE_AUTHORIZE_ALL = 1,
	USB_DEVICE_AUTHORIZE_INTERNAL = 2,
};

enum usb_device_speed {
	USB_SPEED_UNKNOWN = 0,
	USB_SPEED_LOW = 1,
	USB_SPEED_FULL = 2,
	USB_SPEED_HIGH = 3,
	USB_SPEED_WIRELESS = 4,
	USB_SPEED_SUPER = 5,
	USB_SPEED_SUPER_PLUS = 6,
};

enum usb_device_state {
	USB_STATE_NOTATTACHED = 0,
	USB_STATE_ATTACHED = 1,
	USB_STATE_POWERED = 2,
	USB_STATE_RECONNECTING = 3,
	USB_STATE_UNAUTHENTICATED = 4,
	USB_STATE_DEFAULT = 5,
	USB_STATE_ADDRESS = 6,
	USB_STATE_CONFIGURED = 7,
	USB_STATE_SUSPENDED = 8,
};

enum usb_dr_mode {
	USB_DR_MODE_UNKNOWN = 0,
	USB_DR_MODE_HOST = 1,
	USB_DR_MODE_PERIPHERAL = 2,
	USB_DR_MODE_OTG = 3,
};

enum usb_interface_condition {
	USB_INTERFACE_UNBOUND = 0,
	USB_INTERFACE_BINDING = 1,
	USB_INTERFACE_BOUND = 2,
	USB_INTERFACE_UNBINDING = 3,
};

enum usb_led_event {
	USB_LED_EVENT_HOST = 0,
	USB_LED_EVENT_GADGET = 1,
};

enum usb_link_tunnel_mode {
	USB_LINK_UNKNOWN = 0,
	USB_LINK_NATIVE = 1,
	USB_LINK_TUNNELED = 2,
};

enum usb_otg_state {
	OTG_STATE_UNDEFINED = 0,
	OTG_STATE_B_IDLE = 1,
	OTG_STATE_B_SRP_INIT = 2,
	OTG_STATE_B_PERIPHERAL = 3,
	OTG_STATE_B_WAIT_ACON = 4,
	OTG_STATE_B_HOST = 5,
	OTG_STATE_A_IDLE = 6,
	OTG_STATE_A_WAIT_VRISE = 7,
	OTG_STATE_A_WAIT_BCON = 8,
	OTG_STATE_A_HOST = 9,
	OTG_STATE_A_SUSPEND = 10,
	OTG_STATE_A_PERIPHERAL = 11,
	OTG_STATE_A_WAIT_VFALL = 12,
	OTG_STATE_A_VBUS_ERR = 13,
};

enum usb_phy_events {
	USB_EVENT_NONE = 0,
	USB_EVENT_VBUS = 1,
	USB_EVENT_ID = 2,
	USB_EVENT_CHARGER = 3,
	USB_EVENT_ENUMERATED = 4,
};

enum usb_phy_type {
	USB_PHY_TYPE_UNDEFINED = 0,
	USB_PHY_TYPE_USB2 = 1,
	USB_PHY_TYPE_USB3 = 2,
};

enum usb_port_connect_type {
	USB_PORT_CONNECT_TYPE_UNKNOWN = 0,
	USB_PORT_CONNECT_TYPE_HOT_PLUG = 1,
	USB_PORT_CONNECT_TYPE_HARD_WIRED = 2,
	USB_PORT_NOT_USED = 3,
};

enum usb_ssp_rate {
	USB_SSP_GEN_UNKNOWN = 0,
	USB_SSP_GEN_2x1 = 1,
	USB_SSP_GEN_1x2 = 2,
	USB_SSP_GEN_2x2 = 3,
};

enum usb_wireless_status {
	USB_WIRELESS_STATUS_NA = 0,
	USB_WIRELESS_STATUS_DISCONNECTED = 1,
	USB_WIRELESS_STATUS_CONNECTED = 2,
};

enum user_reg_flag {
	USER_EVENT_REG_PERSIST = 1,
	USER_EVENT_REG_MULTI_FORMAT = 2,
	USER_EVENT_REG_MAX = 4,
};

enum utf16_endian {
	UTF16_HOST_ENDIAN = 0,
	UTF16_LITTLE_ENDIAN = 1,
	UTF16_BIG_ENDIAN = 2,
};

enum utf8_normalization {
	UTF8_NFDI = 0,
	UTF8_NFDICF = 1,
	UTF8_NMAX = 2,
};

enum uts_proc {
	UTS_PROC_ARCH = 0,
	UTS_PROC_OSTYPE = 1,
	UTS_PROC_OSRELEASE = 2,
	UTS_PROC_VERSION = 3,
	UTS_PROC_HOSTNAME = 4,
	UTS_PROC_DOMAINNAME = 5,
};

enum uv_system_type {
	UV_NONE = 0,
	UV_LEGACY_APIC = 1,
	UV_X2APIC = 2,
};

enum v4l2_av1_segment_feature {
	V4L2_AV1_SEG_LVL_ALT_Q = 0,
	V4L2_AV1_SEG_LVL_ALT_LF_Y_V = 1,
	V4L2_AV1_SEG_LVL_REF_FRAME = 5,
	V4L2_AV1_SEG_LVL_REF_SKIP = 6,
	V4L2_AV1_SEG_LVL_REF_GLOBALMV = 7,
	V4L2_AV1_SEG_LVL_MAX = 8,
};

enum v4l2_fwnode_bus_type {
	V4L2_FWNODE_BUS_TYPE_GUESS = 0,
	V4L2_FWNODE_BUS_TYPE_CSI2_CPHY = 1,
	V4L2_FWNODE_BUS_TYPE_CSI1 = 2,
	V4L2_FWNODE_BUS_TYPE_CCP2 = 3,
	V4L2_FWNODE_BUS_TYPE_CSI2_DPHY = 4,
	V4L2_FWNODE_BUS_TYPE_PARALLEL = 5,
	V4L2_FWNODE_BUS_TYPE_BT656 = 6,
	V4L2_FWNODE_BUS_TYPE_DPI = 7,
	NR_OF_V4L2_FWNODE_BUS_TYPE = 8,
};

enum v4l2_preemphasis {
	V4L2_PREEMPHASIS_DISABLED = 0,
	V4L2_PREEMPHASIS_50_uS = 1,
	V4L2_PREEMPHASIS_75_uS = 2,
};

enum vc_ctl_state {
	ESnormal = 0,
	ESesc = 1,
	ESsquare = 2,
	ESgetpars = 3,
	ESfunckey = 4,
	EShash = 5,
	ESsetG0 = 6,
	ESsetG1 = 7,
	ESpercent = 8,
	EScsiignore = 9,
	ESnonstd = 10,
	ESpalette = 11,
	ESosc = 12,
	ESANSI_first = 12,
	ESapc = 13,
	ESpm = 14,
	ESdcs = 15,
	ESANSI_last = 15,
};

enum vc_intensity {
	VCI_HALF_BRIGHT = 0,
	VCI_NORMAL = 1,
	VCI_BOLD = 2,
	VCI_MASK = 3,
};

enum vcap_action_field {
	VCAP_AF_NO_VALUE = 0,
	VCAP_AF_ACL_ID = 1,
	VCAP_AF_CLS_VID_SEL = 2,
	VCAP_AF_CNT_ID = 3,
	VCAP_AF_COPY_PORT_NUM = 4,
	VCAP_AF_COPY_QUEUE_NUM = 5,
	VCAP_AF_CPU_COPY_ENA = 6,
	VCAP_AF_CPU_QU = 7,
	VCAP_AF_CPU_QUEUE_NUM = 8,
	VCAP_AF_CUSTOM_ACE_TYPE_ENA = 9,
	VCAP_AF_DEI_A_VAL = 10,
	VCAP_AF_DEI_B_VAL = 11,
	VCAP_AF_DEI_C_VAL = 12,
	VCAP_AF_DEI_ENA = 13,
	VCAP_AF_DEI_VAL = 14,
	VCAP_AF_DLR_SEL = 15,
	VCAP_AF_DP_ENA = 16,
	VCAP_AF_DP_VAL = 17,
	VCAP_AF_DSCP_ENA = 18,
	VCAP_AF_DSCP_SEL = 19,
	VCAP_AF_DSCP_VAL = 20,
	VCAP_AF_ES2_REW_CMD = 21,
	VCAP_AF_ESDX = 22,
	VCAP_AF_FWD_KILL_ENA = 23,
	VCAP_AF_FWD_MODE = 24,
	VCAP_AF_FWD_SEL = 25,
	VCAP_AF_HIT_ME_ONCE = 26,
	VCAP_AF_HOST_MATCH = 27,
	VCAP_AF_IGNORE_PIPELINE_CTRL = 28,
	VCAP_AF_INTR_ENA = 29,
	VCAP_AF_ISDX_ADD_REPLACE_SEL = 30,
	VCAP_AF_ISDX_ADD_VAL = 31,
	VCAP_AF_ISDX_ENA = 32,
	VCAP_AF_ISDX_REPLACE_ENA = 33,
	VCAP_AF_ISDX_VAL = 34,
	VCAP_AF_LOOP_ENA = 35,
	VCAP_AF_LRN_DIS = 36,
	VCAP_AF_MAP_IDX = 37,
	VCAP_AF_MAP_KEY = 38,
	VCAP_AF_MAP_LOOKUP_SEL = 39,
	VCAP_AF_MASK_MODE = 40,
	VCAP_AF_MATCH_ID = 41,
	VCAP_AF_MATCH_ID_MASK = 42,
	VCAP_AF_MIRROR_ENA = 43,
	VCAP_AF_MIRROR_PROBE = 44,
	VCAP_AF_MIRROR_PROBE_ID = 45,
	VCAP_AF_MRP_SEL = 46,
	VCAP_AF_NXT_IDX = 47,
	VCAP_AF_NXT_IDX_CTRL = 48,
	VCAP_AF_OAM_SEL = 49,
	VCAP_AF_PAG_OVERRIDE_MASK = 50,
	VCAP_AF_PAG_VAL = 51,
	VCAP_AF_PCP_A_VAL = 52,
	VCAP_AF_PCP_B_VAL = 53,
	VCAP_AF_PCP_C_VAL = 54,
	VCAP_AF_PCP_ENA = 55,
	VCAP_AF_PCP_VAL = 56,
	VCAP_AF_PIPELINE_ACT = 57,
	VCAP_AF_PIPELINE_FORCE_ENA = 58,
	VCAP_AF_PIPELINE_PT = 59,
	VCAP_AF_POLICE_ENA = 60,
	VCAP_AF_POLICE_IDX = 61,
	VCAP_AF_POLICE_REMARK = 62,
	VCAP_AF_POLICE_VCAP_ONLY = 63,
	VCAP_AF_POP_VAL = 64,
	VCAP_AF_PORT_MASK = 65,
	VCAP_AF_PUSH_CUSTOMER_TAG = 66,
	VCAP_AF_PUSH_INNER_TAG = 67,
	VCAP_AF_PUSH_OUTER_TAG = 68,
	VCAP_AF_QOS_ENA = 69,
	VCAP_AF_QOS_VAL = 70,
	VCAP_AF_REW_OP = 71,
	VCAP_AF_RT_DIS = 72,
	VCAP_AF_SFID_ENA = 73,
	VCAP_AF_SFID_VAL = 74,
	VCAP_AF_SGID_ENA = 75,
	VCAP_AF_SGID_VAL = 76,
	VCAP_AF_SWAP_MACS_ENA = 77,
	VCAP_AF_TAG_A_DEI_SEL = 78,
	VCAP_AF_TAG_A_PCP_SEL = 79,
	VCAP_AF_TAG_A_TPID_SEL = 80,
	VCAP_AF_TAG_A_VID_SEL = 81,
	VCAP_AF_TAG_B_DEI_SEL = 82,
	VCAP_AF_TAG_B_PCP_SEL = 83,
	VCAP_AF_TAG_B_TPID_SEL = 84,
	VCAP_AF_TAG_B_VID_SEL = 85,
	VCAP_AF_TAG_C_DEI_SEL = 86,
	VCAP_AF_TAG_C_PCP_SEL = 87,
	VCAP_AF_TAG_C_TPID_SEL = 88,
	VCAP_AF_TAG_C_VID_SEL = 89,
	VCAP_AF_TYPE = 90,
	VCAP_AF_UNTAG_VID_ENA = 91,
	VCAP_AF_VID_A_VAL = 92,
	VCAP_AF_VID_B_VAL = 93,
	VCAP_AF_VID_C_VAL = 94,
	VCAP_AF_VID_REPLACE_ENA = 95,
	VCAP_AF_VID_VAL = 96,
	VCAP_AF_VLAN_POP_CNT = 97,
	VCAP_AF_VLAN_POP_CNT_ENA = 98,
};

enum vcap_actionfield_set {
	VCAP_AFS_NO_VALUE = 0,
	VCAP_AFS_BASE_TYPE = 1,
	VCAP_AFS_CLASSIFICATION = 2,
	VCAP_AFS_CLASS_REDUCED = 3,
	VCAP_AFS_ES0 = 4,
	VCAP_AFS_FULL = 5,
	VCAP_AFS_S1 = 6,
	VCAP_AFS_SMAC_SIP = 7,
	VCAP_AFS_VID = 8,
};

enum vcap_arp_opcode {
	VCAP_ARP_OP_RESERVED = 0,
	VCAP_ARP_OP_REQUEST = 1,
	VCAP_ARP_OP_REPLY = 2,
};

enum vcap_bit {
	VCAP_BIT_ANY = 0,
	VCAP_BIT_0 = 1,
	VCAP_BIT_1 = 2,
};

enum vcap_command {
	VCAP_CMD_WRITE = 0,
	VCAP_CMD_READ = 1,
	VCAP_CMD_MOVE_DOWN = 2,
	VCAP_CMD_MOVE_UP = 3,
	VCAP_CMD_INITIALIZE = 4,
};

enum vcap_field_type {
	VCAP_FIELD_BIT = 0,
	VCAP_FIELD_U32 = 1,
	VCAP_FIELD_U48 = 2,
	VCAP_FIELD_U56 = 3,
	VCAP_FIELD_U64 = 4,
	VCAP_FIELD_U72 = 5,
	VCAP_FIELD_U112 = 6,
	VCAP_FIELD_U128 = 7,
};

enum vcap_is2_arp_opcode {
	VCAP_IS2_ARP_REQUEST = 0,
	VCAP_IS2_ARP_REPLY = 1,
	VCAP_IS2_RARP_REQUEST = 2,
	VCAP_IS2_RARP_REPLY = 3,
};

enum vcap_key_field {
	VCAP_KF_NO_VALUE = 0,
	VCAP_KF_8021BR_ECID_BASE = 1,
	VCAP_KF_8021BR_ECID_EXT = 2,
	VCAP_KF_8021BR_E_TAGGED = 3,
	VCAP_KF_8021BR_GRP = 4,
	VCAP_KF_8021BR_IGR_ECID_BASE = 5,
	VCAP_KF_8021BR_IGR_ECID_EXT = 6,
	VCAP_KF_8021CB_R_TAGGED_IS = 7,
	VCAP_KF_8021Q_DEI0 = 8,
	VCAP_KF_8021Q_DEI1 = 9,
	VCAP_KF_8021Q_DEI2 = 10,
	VCAP_KF_8021Q_DEI_CLS = 11,
	VCAP_KF_8021Q_PCP0 = 12,
	VCAP_KF_8021Q_PCP1 = 13,
	VCAP_KF_8021Q_PCP2 = 14,
	VCAP_KF_8021Q_PCP_CLS = 15,
	VCAP_KF_8021Q_TPID = 16,
	VCAP_KF_8021Q_TPID0 = 17,
	VCAP_KF_8021Q_TPID1 = 18,
	VCAP_KF_8021Q_TPID2 = 19,
	VCAP_KF_8021Q_VID0 = 20,
	VCAP_KF_8021Q_VID1 = 21,
	VCAP_KF_8021Q_VID2 = 22,
	VCAP_KF_8021Q_VID_CLS = 23,
	VCAP_KF_8021Q_VLAN_DBL_TAGGED_IS = 24,
	VCAP_KF_8021Q_VLAN_TAGGED_IS = 25,
	VCAP_KF_8021Q_VLAN_TAGS = 26,
	VCAP_KF_ACL_GRP_ID = 27,
	VCAP_KF_ARP_ADDR_SPACE_OK_IS = 28,
	VCAP_KF_ARP_LEN_OK_IS = 29,
	VCAP_KF_ARP_OPCODE = 30,
	VCAP_KF_ARP_OPCODE_UNKNOWN_IS = 31,
	VCAP_KF_ARP_PROTO_SPACE_OK_IS = 32,
	VCAP_KF_ARP_SENDER_MATCH_IS = 33,
	VCAP_KF_ARP_TGT_MATCH_IS = 34,
	VCAP_KF_COSID_CLS = 35,
	VCAP_KF_ES0_ISDX_KEY_ENA = 36,
	VCAP_KF_ETYPE = 37,
	VCAP_KF_ETYPE_LEN_IS = 38,
	VCAP_KF_HOST_MATCH = 39,
	VCAP_KF_IF_EGR_PORT_MASK = 40,
	VCAP_KF_IF_EGR_PORT_MASK_RNG = 41,
	VCAP_KF_IF_EGR_PORT_NO = 42,
	VCAP_KF_IF_IGR_PORT = 43,
	VCAP_KF_IF_IGR_PORT_MASK = 44,
	VCAP_KF_IF_IGR_PORT_MASK_L3 = 45,
	VCAP_KF_IF_IGR_PORT_MASK_RNG = 46,
	VCAP_KF_IF_IGR_PORT_MASK_SEL = 47,
	VCAP_KF_IF_IGR_PORT_SEL = 48,
	VCAP_KF_IP4_IS = 49,
	VCAP_KF_IP_MC_IS = 50,
	VCAP_KF_IP_PAYLOAD_5TUPLE = 51,
	VCAP_KF_IP_PAYLOAD_S1_IP6 = 52,
	VCAP_KF_IP_SNAP_IS = 53,
	VCAP_KF_ISDX_CLS = 54,
	VCAP_KF_ISDX_GT0_IS = 55,
	VCAP_KF_L2_BC_IS = 56,
	VCAP_KF_L2_DMAC = 57,
	VCAP_KF_L2_FRM_TYPE = 58,
	VCAP_KF_L2_FWD_IS = 59,
	VCAP_KF_L2_LLC = 60,
	VCAP_KF_L2_MAC = 61,
	VCAP_KF_L2_MC_IS = 62,
	VCAP_KF_L2_PAYLOAD0 = 63,
	VCAP_KF_L2_PAYLOAD1 = 64,
	VCAP_KF_L2_PAYLOAD2 = 65,
	VCAP_KF_L2_PAYLOAD_ETYPE = 66,
	VCAP_KF_L2_SMAC = 67,
	VCAP_KF_L2_SNAP = 68,
	VCAP_KF_L3_DIP_EQ_SIP_IS = 69,
	VCAP_KF_L3_DPL_CLS = 70,
	VCAP_KF_L3_DSCP = 71,
	VCAP_KF_L3_DST_IS = 72,
	VCAP_KF_L3_FRAGMENT = 73,
	VCAP_KF_L3_FRAGMENT_TYPE = 74,
	VCAP_KF_L3_FRAG_INVLD_L4_LEN = 75,
	VCAP_KF_L3_FRAG_OFS_GT0 = 76,
	VCAP_KF_L3_IP4_DIP = 77,
	VCAP_KF_L3_IP4_SIP = 78,
	VCAP_KF_L3_IP6_DIP = 79,
	VCAP_KF_L3_IP6_DIP_MSB = 80,
	VCAP_KF_L3_IP6_SIP = 81,
	VCAP_KF_L3_IP6_SIP_MSB = 82,
	VCAP_KF_L3_IP_PROTO = 83,
	VCAP_KF_L3_OPTIONS_IS = 84,
	VCAP_KF_L3_PAYLOAD = 85,
	VCAP_KF_L3_RT_IS = 86,
	VCAP_KF_L3_TOS = 87,
	VCAP_KF_L3_TTL_GT0 = 88,
	VCAP_KF_L4_1588_DOM = 89,
	VCAP_KF_L4_1588_VER = 90,
	VCAP_KF_L4_ACK = 91,
	VCAP_KF_L4_DPORT = 92,
	VCAP_KF_L4_FIN = 93,
	VCAP_KF_L4_PAYLOAD = 94,
	VCAP_KF_L4_PSH = 95,
	VCAP_KF_L4_RNG = 96,
	VCAP_KF_L4_RST = 97,
	VCAP_KF_L4_SEQUENCE_EQ0_IS = 98,
	VCAP_KF_L4_SPORT = 99,
	VCAP_KF_L4_SPORT_EQ_DPORT_IS = 100,
	VCAP_KF_L4_SYN = 101,
	VCAP_KF_L4_URG = 102,
	VCAP_KF_LOOKUP_FIRST_IS = 103,
	VCAP_KF_LOOKUP_GEN_IDX = 104,
	VCAP_KF_LOOKUP_GEN_IDX_SEL = 105,
	VCAP_KF_LOOKUP_INDEX = 106,
	VCAP_KF_LOOKUP_PAG = 107,
	VCAP_KF_MIRROR_PROBE = 108,
	VCAP_KF_OAM_CCM_CNTS_EQ0 = 109,
	VCAP_KF_OAM_DETECTED = 110,
	VCAP_KF_OAM_FLAGS = 111,
	VCAP_KF_OAM_MEL_FLAGS = 112,
	VCAP_KF_OAM_MEPID = 113,
	VCAP_KF_OAM_OPCODE = 114,
	VCAP_KF_OAM_VER = 115,
	VCAP_KF_OAM_Y1731_IS = 116,
	VCAP_KF_PDU_TYPE = 117,
	VCAP_KF_PROT_ACTIVE = 118,
	VCAP_KF_RTP_ID = 119,
	VCAP_KF_RT_FRMID = 120,
	VCAP_KF_RT_TYPE = 121,
	VCAP_KF_RT_VLAN_IDX = 122,
	VCAP_KF_TCP_IS = 123,
	VCAP_KF_TCP_UDP_IS = 124,
	VCAP_KF_TYPE = 125,
};

enum vcap_keyfield_set {
	VCAP_KFS_NO_VALUE = 0,
	VCAP_KFS_5TUPLE_IP4 = 1,
	VCAP_KFS_5TUPLE_IP6 = 2,
	VCAP_KFS_7TUPLE = 3,
	VCAP_KFS_ARP = 4,
	VCAP_KFS_DBL_VID = 5,
	VCAP_KFS_DMAC_VID = 6,
	VCAP_KFS_ETAG = 7,
	VCAP_KFS_IP4_OTHER = 8,
	VCAP_KFS_IP4_TCP_UDP = 9,
	VCAP_KFS_IP4_VID = 10,
	VCAP_KFS_IP6_OTHER = 11,
	VCAP_KFS_IP6_STD = 12,
	VCAP_KFS_IP6_TCP_UDP = 13,
	VCAP_KFS_IP6_VID = 14,
	VCAP_KFS_IP_7TUPLE = 15,
	VCAP_KFS_ISDX = 16,
	VCAP_KFS_LL_FULL = 17,
	VCAP_KFS_MAC_ETYPE = 18,
	VCAP_KFS_MAC_LLC = 19,
	VCAP_KFS_MAC_SNAP = 20,
	VCAP_KFS_NORMAL = 21,
	VCAP_KFS_NORMAL_5TUPLE_IP4 = 22,
	VCAP_KFS_NORMAL_7TUPLE = 23,
	VCAP_KFS_NORMAL_IP6 = 24,
	VCAP_KFS_OAM = 25,
	VCAP_KFS_PURE_5TUPLE_IP4 = 26,
	VCAP_KFS_RT = 27,
	VCAP_KFS_SMAC_SIP4 = 28,
	VCAP_KFS_SMAC_SIP6 = 29,
	VCAP_KFS_VID = 30,
};

enum vcap_rule_error {
	VCAP_ERR_NONE = 0,
	VCAP_ERR_NO_ADMIN = 1,
	VCAP_ERR_NO_NETDEV = 2,
	VCAP_ERR_NO_KEYSET_MATCH = 3,
	VCAP_ERR_NO_ACTIONSET_MATCH = 4,
	VCAP_ERR_NO_PORT_KEYSET_MATCH = 5,
};

enum vcap_rule_state {
	VCAP_RS_PERMANENT = 0,
	VCAP_RS_ENABLED = 1,
	VCAP_RS_DISABLED = 2,
};

enum vcap_selection {
	VCAP_SEL_ENTRY = 1,
	VCAP_SEL_ACTION = 2,
	VCAP_SEL_COUNTER = 4,
	VCAP_SEL_ALL = 255,
};

enum vcap_type {
	VCAP_TYPE_ES0 = 0,
	VCAP_TYPE_ES2 = 1,
	VCAP_TYPE_IS0 = 2,
	VCAP_TYPE_IS1 = 3,
	VCAP_TYPE_IS2 = 4,
	VCAP_TYPE_MAX = 5,
};

enum vcap_user {
	VCAP_USER_PTP = 0,
	VCAP_USER_MRP = 1,
	VCAP_USER_CFM = 2,
	VCAP_USER_VLAN = 3,
	VCAP_USER_QOS = 4,
	VCAP_USER_VCAP_UTIL = 5,
	VCAP_USER_TC = 6,
	VCAP_USER_TC_EXTRA = 7,
	__VCAP_USER_AFTER_LAST = 8,
	VCAP_USER_MAX = 7,
};

enum vcpu_state {
	VCPU_RUNNING = 0,
	VCPU_HALTED = 1,
	VCPU_HASHED = 2,
};

enum vdso_clock_mode {
	VDSO_CLOCKMODE_NONE = 0,
	VDSO_CLOCKMODE_TSC = 1,
	VDSO_CLOCKMODE_PVCLOCK = 2,
	VDSO_CLOCKMODE_HVCLOCK = 3,
	VDSO_CLOCKMODE_MAX = 4,
	VDSO_CLOCKMODE_TIMENS = 2147483647,
};

enum vdso_pages {
	VDSO_TIME_PAGE_OFFSET = 0,
	VDSO_TIMENS_PAGE_OFFSET = 1,
	VDSO_RNG_PAGE_OFFSET = 2,
	VDSO_ARCH_PAGES_START = 3,
	VDSO_ARCH_PAGES_END = 3,
	VDSO_NR_PAGES = 4,
};

enum verifier_phase {
	CHECK_META = 0,
	CHECK_TYPE = 1,
};

enum vesa_blank_mode {
	VESA_NO_BLANKING = 0,
	VESA_VSYNC_SUSPEND = 1,
	VESA_HSYNC_SUSPEND = 2,
	VESA_POWERDOWN = 3,
	VESA_BLANK_MAX = 3,
};

enum vga_switcheroo_client_id {
	VGA_SWITCHEROO_UNKNOWN_ID = 4096,
	VGA_SWITCHEROO_IGD = 0,
	VGA_SWITCHEROO_DIS = 1,
	VGA_SWITCHEROO_MAX_CLIENTS = 2,
};

enum vga_switcheroo_handler_flags_t {
	VGA_SWITCHEROO_CAN_SWITCH_DDC = 1,
	VGA_SWITCHEROO_NEEDS_EDP_CONFIG = 2,
};

enum vga_switcheroo_state {
	VGA_SWITCHEROO_OFF = 0,
	VGA_SWITCHEROO_ON = 1,
	VGA_SWITCHEROO_NOT_FOUND = 2,
};

enum vhost_task_flags {
	VHOST_TASK_FLAGS_STOP = 0,
	VHOST_TASK_FLAGS_KILLED = 1,
};

enum visit_state {
	NOT_VISITED = 0,
	VISITED = 1,
	RESOLVED = 2,
};

enum vlan_flags {
	VLAN_FLAG_REORDER_HDR = 1,
	VLAN_FLAG_GVRP = 2,
	VLAN_FLAG_LOOSE_BINDING = 4,
	VLAN_FLAG_MVRP = 8,
	VLAN_FLAG_BRIDGE_BINDING = 16,
};

enum vlan_protos {
	VLAN_PROTO_8021Q = 0,
	VLAN_PROTO_8021AD = 1,
	VLAN_PROTO_NUM = 2,
};

enum vm_event_item {
	PGPGIN = 0,
	PGPGOUT = 1,
	PSWPIN = 2,
	PSWPOUT = 3,
	PGALLOC_DMA = 4,
	PGALLOC_DMA32 = 5,
	PGALLOC_NORMAL = 6,
	PGALLOC_MOVABLE = 7,
	PGALLOC_DEVICE = 8,
	ALLOCSTALL_DMA = 9,
	ALLOCSTALL_DMA32 = 10,
	ALLOCSTALL_NORMAL = 11,
	ALLOCSTALL_MOVABLE = 12,
	ALLOCSTALL_DEVICE = 13,
	PGSCAN_SKIP_DMA = 14,
	PGSCAN_SKIP_DMA32 = 15,
	PGSCAN_SKIP_NORMAL = 16,
	PGSCAN_SKIP_MOVABLE = 17,
	PGSCAN_SKIP_DEVICE = 18,
	PGFREE = 19,
	PGACTIVATE = 20,
	PGDEACTIVATE = 21,
	PGLAZYFREE = 22,
	PGFAULT = 23,
	PGMAJFAULT = 24,
	PGLAZYFREED = 25,
	PGREFILL = 26,
	PGREUSE = 27,
	PGSTEAL_KSWAPD = 28,
	PGSTEAL_DIRECT = 29,
	PGSTEAL_KHUGEPAGED = 30,
	PGSTEAL_PROACTIVE = 31,
	PGSCAN_KSWAPD = 32,
	PGSCAN_DIRECT = 33,
	PGSCAN_KHUGEPAGED = 34,
	PGSCAN_PROACTIVE = 35,
	PGSCAN_DIRECT_THROTTLE = 36,
	PGSCAN_ANON = 37,
	PGSCAN_FILE = 38,
	PGSTEAL_ANON = 39,
	PGSTEAL_FILE = 40,
	PGSCAN_ZONE_RECLAIM_SUCCESS = 41,
	PGSCAN_ZONE_RECLAIM_FAILED = 42,
	PGINODESTEAL = 43,
	SLABS_SCANNED = 44,
	KSWAPD_INODESTEAL = 45,
	KSWAPD_LOW_WMARK_HIT_QUICKLY = 46,
	KSWAPD_HIGH_WMARK_HIT_QUICKLY = 47,
	PAGEOUTRUN = 48,
	PGROTATED = 49,
	DROP_PAGECACHE = 50,
	DROP_SLAB = 51,
	OOM_KILL = 52,
	NUMA_PTE_UPDATES = 53,
	NUMA_HUGE_PTE_UPDATES = 54,
	NUMA_HINT_FAULTS = 55,
	NUMA_HINT_FAULTS_LOCAL = 56,
	NUMA_PAGE_MIGRATE = 57,
	PGMIGRATE_SUCCESS = 58,
	PGMIGRATE_FAIL = 59,
	THP_MIGRATION_SUCCESS = 60,
	THP_MIGRATION_FAIL = 61,
	THP_MIGRATION_SPLIT = 62,
	COMPACTMIGRATE_SCANNED = 63,
	COMPACTFREE_SCANNED = 64,
	COMPACTISOLATED = 65,
	COMPACTSTALL = 66,
	COMPACTFAIL = 67,
	COMPACTSUCCESS = 68,
	KCOMPACTD_WAKE = 69,
	KCOMPACTD_MIGRATE_SCANNED = 70,
	KCOMPACTD_FREE_SCANNED = 71,
	HTLB_BUDDY_PGALLOC = 72,
	HTLB_BUDDY_PGALLOC_FAIL = 73,
	CMA_ALLOC_SUCCESS = 74,
	CMA_ALLOC_FAIL = 75,
	UNEVICTABLE_PGCULLED = 76,
	UNEVICTABLE_PGSCANNED = 77,
	UNEVICTABLE_PGRESCUED = 78,
	UNEVICTABLE_PGMLOCKED = 79,
	UNEVICTABLE_PGMUNLOCKED = 80,
	UNEVICTABLE_PGCLEARED = 81,
	UNEVICTABLE_PGSTRANDED = 82,
	THP_FAULT_ALLOC = 83,
	THP_FAULT_FALLBACK = 84,
	THP_FAULT_FALLBACK_CHARGE = 85,
	THP_COLLAPSE_ALLOC = 86,
	THP_COLLAPSE_ALLOC_FAILED = 87,
	THP_FILE_ALLOC = 88,
	THP_FILE_FALLBACK = 89,
	THP_FILE_FALLBACK_CHARGE = 90,
	THP_FILE_MAPPED = 91,
	THP_SPLIT_PAGE = 92,
	THP_SPLIT_PAGE_FAILED = 93,
	THP_DEFERRED_SPLIT_PAGE = 94,
	THP_UNDERUSED_SPLIT_PAGE = 95,
	THP_SPLIT_PMD = 96,
	THP_SCAN_EXCEED_NONE_PTE = 97,
	THP_SCAN_EXCEED_SWAP_PTE = 98,
	THP_SCAN_EXCEED_SHARED_PTE = 99,
	THP_SPLIT_PUD = 100,
	THP_ZERO_PAGE_ALLOC = 101,
	THP_ZERO_PAGE_ALLOC_FAILED = 102,
	THP_SWPOUT = 103,
	THP_SWPOUT_FALLBACK = 104,
	BALLOON_INFLATE = 105,
	BALLOON_DEFLATE = 106,
	BALLOON_MIGRATE = 107,
	SWAP_RA = 108,
	SWAP_RA_HIT = 109,
	SWPIN_ZERO = 110,
	SWPOUT_ZERO = 111,
	KSM_SWPIN_COPY = 112,
	COW_KSM = 113,
	ZSWPIN = 114,
	ZSWPOUT = 115,
	ZSWPWB = 116,
	DIRECT_MAP_LEVEL2_SPLIT = 117,
	DIRECT_MAP_LEVEL3_SPLIT = 118,
	DIRECT_MAP_LEVEL2_COLLAPSE = 119,
	DIRECT_MAP_LEVEL3_COLLAPSE = 120,
	NR_VM_EVENT_ITEMS = 121,
};

enum vm_fault_reason {
	VM_FAULT_OOM = 1,
	VM_FAULT_SIGBUS = 2,
	VM_FAULT_MAJOR = 4,
	VM_FAULT_HWPOISON = 16,
	VM_FAULT_HWPOISON_LARGE = 32,
	VM_FAULT_SIGSEGV = 64,
	VM_FAULT_NOPAGE = 256,
	VM_FAULT_LOCKED = 512,
	VM_FAULT_RETRY = 1024,
	VM_FAULT_FALLBACK = 2048,
	VM_FAULT_DONE_COW = 4096,
	VM_FAULT_NEEDDSYNC = 8192,
	VM_FAULT_COMPLETED = 16384,
	VM_FAULT_HINDEX_MASK = 983040,
};

enum vm_stat_item {
	NR_DIRTY_THRESHOLD = 0,
	NR_DIRTY_BG_THRESHOLD = 1,
	NR_MEMMAP_PAGES = 2,
	NR_MEMMAP_BOOT_PAGES = 3,
	NR_VM_STAT_ITEMS = 4,
};

enum vma_merge_state {
	VMA_MERGE_START = 0,
	VMA_MERGE_ERROR_NOMEM = 1,
	VMA_MERGE_NOMERGE = 2,
	VMA_MERGE_SUCCESS = 3,
};

enum vma_resv_mode {
	VMA_NEEDS_RESV = 0,
	VMA_COMMIT_RESV = 1,
	VMA_END_RESV = 2,
	VMA_ADD_RESV = 3,
	VMA_DEL_RESV = 4,
};

enum vmpressure_levels {
	VMPRESSURE_LOW = 0,
	VMPRESSURE_MEDIUM = 1,
	VMPRESSURE_CRITICAL = 2,
	VMPRESSURE_NUM_LEVELS = 3,
};

enum vmpressure_modes {
	VMPRESSURE_NO_PASSTHROUGH = 0,
	VMPRESSURE_HIERARCHY = 1,
	VMPRESSURE_LOCAL = 2,
	VMPRESSURE_NUM_MODES = 3,
};

enum vmscan_throttle_state {
	VMSCAN_THROTTLE_WRITEBACK = 0,
	VMSCAN_THROTTLE_ISOLATED = 1,
	VMSCAN_THROTTLE_NOPROGRESS = 2,
	VMSCAN_THROTTLE_CONGESTED = 3,
	NR_VMSCAN_THROTTLE = 4,
};

enum vmscape_mitigations {
	VMSCAPE_MITIGATION_NONE = 0,
	VMSCAPE_MITIGATION_AUTO = 1,
	VMSCAPE_MITIGATION_IBPB_EXIT_TO_USER = 2,
	VMSCAPE_MITIGATION_IBPB_ON_VMEXIT = 3,
};

enum vmx_feature_leafs {
	MISC_FEATURES = 0,
	PRIMARY_CTLS = 1,
	SECONDARY_CTLS = 2,
	TERTIARY_CTLS_LOW = 3,
	TERTIARY_CTLS_HIGH = 4,
	NR_VMX_FEATURE_WORDS = 5,
};

enum vmx_l1d_flush_state {
	VMENTER_L1D_FLUSH_AUTO = 0,
	VMENTER_L1D_FLUSH_NEVER = 1,
	VMENTER_L1D_FLUSH_COND = 2,
	VMENTER_L1D_FLUSH_ALWAYS = 3,
	VMENTER_L1D_FLUSH_EPT_DISABLED = 4,
	VMENTER_L1D_FLUSH_NOT_REQUIRED = 5,
};

enum vp_vq_vector_policy {
	VP_VQ_VECTOR_POLICY_EACH = 0,
	VP_VQ_VECTOR_POLICY_SHARED_SLOW = 1,
	VP_VQ_VECTOR_POLICY_SHARED = 2,
};

enum vtime_state {
	VTIME_INACTIVE = 0,
	VTIME_IDLE = 1,
	VTIME_SYS = 2,
	VTIME_USER = 3,
	VTIME_GUEST = 4,
};

enum watch_meta_notification_subtype {
	WATCH_META_REMOVAL_NOTIFICATION = 0,
	WATCH_META_LOSS_NOTIFICATION = 1,
};

enum watch_notification_type {
	WATCH_TYPE_META = 0,
	WATCH_TYPE_KEY_NOTIFY = 1,
	WATCH_TYPE__NR = 2,
};

enum wb_reason {
	WB_REASON_BACKGROUND = 0,
	WB_REASON_VMSCAN = 1,
	WB_REASON_SYNC = 2,
	WB_REASON_PERIODIC = 3,
	WB_REASON_LAPTOP_TIMER = 4,
	WB_REASON_FS_FREE_SPACE = 5,
	WB_REASON_FORKER_THREAD = 6,
	WB_REASON_FOREIGN_FLUSH = 7,
	WB_REASON_MAX = 8,
};

enum wb_stat_item {
	WB_RECLAIMABLE = 0,
	WB_WRITEBACK = 1,
	WB_DIRTIED = 2,
	WB_WRITTEN = 3,
	NR_WB_STAT_ITEMS = 4,
};

enum wb_state {
	WB_registered = 0,
	WB_writeback_running = 1,
	WB_has_dirty_io = 2,
	WB_start_all = 3,
};

enum wbrf_notifier_actions {
	WBRF_CHANGED = 0,
};

enum wbt_flags {
	WBT_TRACKED = 1,
	WBT_READ = 2,
	WBT_SWAP = 4,
	WBT_DISCARD = 8,
	WBT_NR_BITS = 4,
};

enum wd_read_status {
	WD_READ_SUCCESS = 0,
	WD_READ_UNSTABLE = 1,
	WD_READ_SKIP = 2,
};

enum which_selector {
	FS = 0,
	GS = 1,
};

enum wiphy_flags {
	WIPHY_FLAG_SUPPORTS_EXT_KEK_KCK = 1,
	WIPHY_FLAG_SUPPORTS_MLO = 2,
	WIPHY_FLAG_SPLIT_SCAN_6GHZ = 4,
	WIPHY_FLAG_NETNS_OK = 8,
	WIPHY_FLAG_PS_ON_BY_DEFAULT = 16,
	WIPHY_FLAG_4ADDR_AP = 32,
	WIPHY_FLAG_4ADDR_STATION = 64,
	WIPHY_FLAG_CONTROL_PORT_PROTOCOL = 128,
	WIPHY_FLAG_IBSS_RSN = 256,
	WIPHY_FLAG_DISABLE_WEXT = 512,
	WIPHY_FLAG_MESH_AUTH = 1024,
	WIPHY_FLAG_SUPPORTS_EXT_KCK_32 = 2048,
	WIPHY_FLAG_SUPPORTS_NSTR_NONPRIMARY = 4096,
	WIPHY_FLAG_SUPPORTS_FW_ROAM = 8192,
	WIPHY_FLAG_AP_UAPSD = 16384,
	WIPHY_FLAG_SUPPORTS_TDLS = 32768,
	WIPHY_FLAG_TDLS_EXTERNAL_SETUP = 65536,
	WIPHY_FLAG_HAVE_AP_SME = 131072,
	WIPHY_FLAG_REPORTS_OBSS = 262144,
	WIPHY_FLAG_AP_PROBE_RESP_OFFLOAD = 524288,
	WIPHY_FLAG_OFFCHAN_TX = 1048576,
	WIPHY_FLAG_HAS_REMAIN_ON_CHANNEL = 2097152,
	WIPHY_FLAG_SUPPORTS_5_10_MHZ = 4194304,
	WIPHY_FLAG_HAS_CHANNEL_SWITCH = 8388608,
	WIPHY_FLAG_NOTIFY_REGDOM_BY_DRIVER = 16777216,
	WIPHY_FLAG_CHANNEL_CHANGE_ON_BEACON = 33554432,
};

enum wm831x_auxadc {
	WM831X_AUX_CAL = 15,
	WM831X_AUX_BKUP_BATT = 10,
	WM831X_AUX_WALL = 9,
	WM831X_AUX_BATT = 8,
	WM831X_AUX_USB = 7,
	WM831X_AUX_SYSVDD = 6,
	WM831X_AUX_BATT_TEMP = 5,
	WM831X_AUX_CHIP_TEMP = 4,
	WM831X_AUX_AUX4 = 3,
	WM831X_AUX_AUX3 = 2,
	WM831X_AUX_AUX2 = 1,
	WM831X_AUX_AUX1 = 0,
};

enum wm831x_parent {
	WM8310 = 33552,
	WM8311 = 33553,
	WM8312 = 33554,
	WM8320 = 33568,
	WM8321 = 33569,
	WM8325 = 33573,
	WM8326 = 33574,
};

enum wm831x_status_src {
	WM831X_STATUS_PRESERVE = 0,
	WM831X_STATUS_OTP = 1,
	WM831X_STATUS_POWER = 2,
	WM831X_STATUS_CHARGER = 3,
	WM831X_STATUS_MANUAL = 4,
};

enum wm831x_watchdog_action {
	WM831X_WDOG_NONE = 0,
	WM831X_WDOG_INTERRUPT = 1,
	WM831X_WDOG_RESET = 2,
	WM831X_WDOG_WAKE = 3,
};

enum work_bits {
	WORK_STRUCT_PENDING_BIT = 0,
	WORK_STRUCT_INACTIVE_BIT = 1,
	WORK_STRUCT_PWQ_BIT = 2,
	WORK_STRUCT_LINKED_BIT = 3,
	WORK_STRUCT_FLAG_BITS = 4,
	WORK_STRUCT_COLOR_SHIFT = 4,
	WORK_STRUCT_COLOR_BITS = 4,
	WORK_STRUCT_PWQ_SHIFT = 8,
	WORK_OFFQ_FLAG_SHIFT = 4,
	WORK_OFFQ_BH_BIT = 4,
	WORK_OFFQ_FLAG_END = 5,
	WORK_OFFQ_FLAG_BITS = 1,
	WORK_OFFQ_DISABLE_SHIFT = 5,
	WORK_OFFQ_DISABLE_BITS = 16,
	WORK_OFFQ_POOL_SHIFT = 21,
	WORK_OFFQ_LEFT = 43,
	WORK_OFFQ_POOL_BITS = 31,
};

enum work_cancel_flags {
	WORK_CANCEL_DELAYED = 1,
	WORK_CANCEL_DISABLE = 2,
};

enum work_flags {
	WORK_STRUCT_PENDING = 1,
	WORK_STRUCT_INACTIVE = 2,
	WORK_STRUCT_PWQ = 4,
	WORK_STRUCT_LINKED = 8,
	WORK_STRUCT_STATIC = 0,
};

enum worker_flags {
	WORKER_DIE = 2,
	WORKER_IDLE = 4,
	WORKER_PREP = 8,
	WORKER_CPU_INTENSIVE = 64,
	WORKER_UNBOUND = 128,
	WORKER_REBOUND = 256,
	WORKER_NOT_RUNNING = 456,
};

enum worker_pool_flags {
	POOL_BH = 1,
	POOL_MANAGER_ACTIVE = 2,
	POOL_DISASSOCIATED = 4,
	POOL_BH_DRAINING = 8,
};

enum wq_affn_scope {
	WQ_AFFN_DFL = 0,
	WQ_AFFN_CPU = 1,
	WQ_AFFN_SMT = 2,
	WQ_AFFN_CACHE = 3,
	WQ_AFFN_NUMA = 4,
	WQ_AFFN_SYSTEM = 5,
	WQ_AFFN_NR_TYPES = 6,
};

enum wq_consts {
	WQ_MAX_ACTIVE = 2048,
	WQ_UNBOUND_MAX_ACTIVE = 2048,
	WQ_DFL_ACTIVE = 1024,
	WQ_DFL_MIN_ACTIVE = 8,
};

enum wq_flags {
	WQ_BH = 1,
	WQ_UNBOUND = 2,
	WQ_FREEZABLE = 4,
	WQ_MEM_RECLAIM = 8,
	WQ_HIGHPRI = 16,
	WQ_CPU_INTENSIVE = 32,
	WQ_SYSFS = 64,
	WQ_POWER_EFFICIENT = 128,
	WQ_PERCPU = 256,
	__WQ_DESTROYING = 32768,
	__WQ_DRAINING = 65536,
	__WQ_ORDERED = 131072,
	__WQ_LEGACY = 262144,
	__WQ_BH_ALLOWS = 17,
};

enum wq_internal_consts {
	NR_STD_WORKER_POOLS = 2,
	UNBOUND_POOL_HASH_ORDER = 6,
	BUSY_WORKER_HASH_ORDER = 6,
	MAX_IDLE_WORKERS_RATIO = 4,
	IDLE_WORKER_TIMEOUT = 300000,
	MAYDAY_INITIAL_TIMEOUT = 10,
	MAYDAY_INTERVAL = 100,
	CREATE_COOLDOWN = 1000,
	RESCUER_NICE_LEVEL = -20,
	HIGHPRI_NICE_LEVEL = -20,
	WQ_NAME_LEN = 32,
	WORKER_ID_LEN = 42,
};

enum wq_misc_consts {
	WORK_NR_COLORS = 16,
	WORK_CPU_UNBOUND = 8192,
	WORK_BUSY_PENDING = 1,
	WORK_BUSY_RUNNING = 2,
	WORKER_DESC_LEN = 32,
};

enum writeback_sync_modes {
	WB_SYNC_NONE = 0,
	WB_SYNC_ALL = 1,
};

enum x509_actions {
	ACT_x509_extract_key_data = 0,
	ACT_x509_extract_name_segment = 1,
	ACT_x509_note_OID = 2,
	ACT_x509_note_issuer = 3,
	ACT_x509_note_not_after = 4,
	ACT_x509_note_not_before = 5,
	ACT_x509_note_params = 6,
	ACT_x509_note_serial = 7,
	ACT_x509_note_sig_algo = 8,
	ACT_x509_note_signature = 9,
	ACT_x509_note_subject = 10,
	ACT_x509_note_tbs_certificate = 11,
	ACT_x509_process_extension = 12,
	NR__x509_actions = 13,
};

enum x509_akid_actions {
	ACT_x509_akid_note_kid = 0,
	ACT_x509_akid_note_name = 1,
	ACT_x509_akid_note_serial = 2,
	ACT_x509_extract_name_segment___2 = 3,
	ACT_x509_note_OID___2 = 4,
	NR__x509_akid_actions = 5,
};

enum x86_hardware_subarch {
	X86_SUBARCH_PC = 0,
	X86_SUBARCH_LGUEST = 1,
	X86_SUBARCH_XEN = 2,
	X86_SUBARCH_INTEL_MID = 3,
	X86_SUBARCH_CE4100 = 4,
	X86_NR_SUBARCHS = 5,
};

enum x86_hypervisor_type {
	X86_HYPER_NATIVE = 0,
	X86_HYPER_VMWARE = 1,
	X86_HYPER_MS_HYPERV = 2,
	X86_HYPER_XEN_PV = 3,
	X86_HYPER_XEN_HVM = 4,
	X86_HYPER_KVM = 5,
	X86_HYPER_JAILHOUSE = 6,
	X86_HYPER_ACRN = 7,
};

enum x86_intercept_stage;

enum x86_legacy_i8042_state {
	X86_LEGACY_I8042_PLATFORM_ABSENT = 0,
	X86_LEGACY_I8042_FIRMWARE_ABSENT = 1,
	X86_LEGACY_I8042_EXPECTED_PRESENT = 2,
};

enum x86_pf_error_code {
	X86_PF_PROT = 1,
	X86_PF_WRITE = 2,
	X86_PF_USER = 4,
	X86_PF_RSVD = 8,
	X86_PF_INSTR = 16,
	X86_PF_PK = 32,
	X86_PF_SHSTK = 64,
	X86_PF_SGX = 32768,
	X86_PF_RMP = 2147483648,
};

enum x86_regset_32 {
	REGSET32_GENERAL = 0,
	REGSET32_FP = 1,
	REGSET32_XFP = 2,
	REGSET32_XSTATE = 3,
	REGSET32_TLS = 4,
	REGSET32_IOPERM = 5,
};

enum x86_regset_64 {
	REGSET64_GENERAL = 0,
	REGSET64_FP = 1,
	REGSET64_IOPERM = 2,
	REGSET64_XSTATE = 3,
	REGSET64_SSP = 4,
};

enum x86_topology_cpu_type {
	TOPO_CPU_TYPE_PERFORMANCE = 0,
	TOPO_CPU_TYPE_EFFICIENCY = 1,
	TOPO_CPU_TYPE_UNKNOWN = 2,
};

enum x86_topology_domains {
	TOPO_SMT_DOMAIN = 0,
	TOPO_CORE_DOMAIN = 1,
	TOPO_MODULE_DOMAIN = 2,
	TOPO_TILE_DOMAIN = 3,
	TOPO_DIE_DOMAIN = 4,
	TOPO_DIEGRP_DOMAIN = 5,
	TOPO_PKG_DOMAIN = 6,
	TOPO_MAX_DOMAIN = 7,
};

enum xa_lock_type {
	XA_LOCK_IRQ = 1,
	XA_LOCK_BH = 2,
};

enum xb_req_state {
	xb_req_state_queued = 0,
	xb_req_state_wait_reply = 1,
	xb_req_state_got_reply = 2,
	xb_req_state_aborted = 3,
};

enum xdp_action {
	XDP_ABORTED = 0,
	XDP_DROP = 1,
	XDP_PASS = 2,
	XDP_TX = 3,
	XDP_REDIRECT = 4,
};

enum xdp_buff_flags {
	XDP_FLAGS_HAS_FRAGS = 1,
	XDP_FLAGS_FRAGS_PF_MEMALLOC = 2,
};

enum xdp_mem_type {
	MEM_TYPE_PAGE_SHARED = 0,
	MEM_TYPE_PAGE_ORDER0 = 1,
	MEM_TYPE_PAGE_POOL = 2,
	MEM_TYPE_XSK_BUFF_POOL = 3,
	MEM_TYPE_MAX = 4,
};

enum xdp_rss_hash_type {
	XDP_RSS_L3_IPV4 = 1,
	XDP_RSS_L3_IPV6 = 2,
	XDP_RSS_L3_DYNHDR = 4,
	XDP_RSS_L4 = 8,
	XDP_RSS_L4_TCP = 16,
	XDP_RSS_L4_UDP = 32,
	XDP_RSS_L4_SCTP = 64,
	XDP_RSS_L4_IPSEC = 128,
	XDP_RSS_L4_ICMP = 256,
	XDP_RSS_TYPE_NONE = 0,
	XDP_RSS_TYPE_L2 = 0,
	XDP_RSS_TYPE_L3_IPV4 = 1,
	XDP_RSS_TYPE_L3_IPV6 = 2,
	XDP_RSS_TYPE_L3_IPV4_OPT = 5,
	XDP_RSS_TYPE_L3_IPV6_EX = 6,
	XDP_RSS_TYPE_L4_ANY = 8,
	XDP_RSS_TYPE_L4_IPV4_TCP = 25,
	XDP_RSS_TYPE_L4_IPV4_UDP = 41,
	XDP_RSS_TYPE_L4_IPV4_SCTP = 73,
	XDP_RSS_TYPE_L4_IPV4_IPSEC = 137,
	XDP_RSS_TYPE_L4_IPV4_ICMP = 265,
	XDP_RSS_TYPE_L4_IPV6_TCP = 26,
	XDP_RSS_TYPE_L4_IPV6_UDP = 42,
	XDP_RSS_TYPE_L4_IPV6_SCTP = 74,
	XDP_RSS_TYPE_L4_IPV6_IPSEC = 138,
	XDP_RSS_TYPE_L4_IPV6_ICMP = 266,
	XDP_RSS_TYPE_L4_IPV6_TCP_EX = 30,
	XDP_RSS_TYPE_L4_IPV6_UDP_EX = 46,
	XDP_RSS_TYPE_L4_IPV6_SCTP_EX = 78,
};

enum xdp_rx_metadata {
	XDP_METADATA_KFUNC_RX_TIMESTAMP = 0,
	XDP_METADATA_KFUNC_RX_HASH = 1,
	XDP_METADATA_KFUNC_RX_VLAN_TAG = 2,
	MAX_XDP_METADATA_KFUNC = 3,
};

enum xen_domain_type {
	XEN_NATIVE = 0,
	XEN_PV_DOMAIN = 1,
	XEN_HVM_DOMAIN = 2,
};

enum xen_irq_type {
	IRQT_UNBOUND = 0,
	IRQT_PIRQ = 1,
	IRQT_VIRQ = 2,
	IRQT_IPI = 3,
	IRQT_EVTCHN = 4,
};

enum xen_lazy_mode {
	XEN_LAZY_NONE = 0,
	XEN_LAZY_MMU = 1,
	XEN_LAZY_CPU = 2,
};

enum xen_mc_extend_args {
	XEN_MC_XE_OK = 0,
	XEN_MC_XE_BAD_OP = 1,
	XEN_MC_XE_NO_SPACE = 2,
};

enum xen_mc_flush_reason {
	XEN_MC_FL_NONE = 0,
	XEN_MC_FL_BATCH = 1,
	XEN_MC_FL_ARGS = 2,
	XEN_MC_FL_CALLBACK = 3,
};

enum xenbus_state {
	XenbusStateUnknown = 0,
	XenbusStateInitialising = 1,
	XenbusStateInitWait = 2,
	XenbusStateInitialised = 3,
	XenbusStateConnected = 4,
	XenbusStateClosing = 5,
	XenbusStateClosed = 6,
	XenbusStateReconfiguring = 7,
	XenbusStateReconfigured = 8,
};

enum xenstore_init {
	XS_UNKNOWN = 0,
	XS_PV = 1,
	XS_HVM = 2,
	XS_LOCAL = 3,
};

enum xfeature {
	XFEATURE_FP = 0,
	XFEATURE_SSE = 1,
	XFEATURE_YMM = 2,
	XFEATURE_BNDREGS = 3,
	XFEATURE_BNDCSR = 4,
	XFEATURE_OPMASK = 5,
	XFEATURE_ZMM_Hi256 = 6,
	XFEATURE_Hi16_ZMM = 7,
	XFEATURE_PT_UNIMPLEMENTED_SO_FAR = 8,
	XFEATURE_PKRU = 9,
	XFEATURE_PASID = 10,
	XFEATURE_CET_USER = 11,
	XFEATURE_CET_KERNEL = 12,
	XFEATURE_RSRVD_COMP_13 = 13,
	XFEATURE_RSRVD_COMP_14 = 14,
	XFEATURE_LBR = 15,
	XFEATURE_RSRVD_COMP_16 = 16,
	XFEATURE_XTILE_CFG = 17,
	XFEATURE_XTILE_DATA = 18,
	XFEATURE_APX = 19,
	XFEATURE_MAX = 20,
};

enum xfrm_ae_ftype_t {
	XFRM_AE_UNSPEC = 0,
	XFRM_AE_RTHR = 1,
	XFRM_AE_RVAL = 2,
	XFRM_AE_LVAL = 4,
	XFRM_AE_ETHR = 8,
	XFRM_AE_CR = 16,
	XFRM_AE_CE = 32,
	XFRM_AE_CU = 64,
	__XFRM_AE_MAX = 65,
};

enum xfrm_attr_type_t {
	XFRMA_UNSPEC = 0,
	XFRMA_ALG_AUTH = 1,
	XFRMA_ALG_CRYPT = 2,
	XFRMA_ALG_COMP = 3,
	XFRMA_ENCAP = 4,
	XFRMA_TMPL = 5,
	XFRMA_SA = 6,
	XFRMA_POLICY = 7,
	XFRMA_SEC_CTX = 8,
	XFRMA_LTIME_VAL = 9,
	XFRMA_REPLAY_VAL = 10,
	XFRMA_REPLAY_THRESH = 11,
	XFRMA_ETIMER_THRESH = 12,
	XFRMA_SRCADDR = 13,
	XFRMA_COADDR = 14,
	XFRMA_LASTUSED = 15,
	XFRMA_POLICY_TYPE = 16,
	XFRMA_MIGRATE = 17,
	XFRMA_ALG_AEAD = 18,
	XFRMA_KMADDRESS = 19,
	XFRMA_ALG_AUTH_TRUNC = 20,
	XFRMA_MARK = 21,
	XFRMA_TFCPAD = 22,
	XFRMA_REPLAY_ESN_VAL = 23,
	XFRMA_SA_EXTRA_FLAGS = 24,
	XFRMA_PROTO = 25,
	XFRMA_ADDRESS_FILTER = 26,
	XFRMA_PAD = 27,
	XFRMA_OFFLOAD_DEV = 28,
	XFRMA_SET_MARK = 29,
	XFRMA_SET_MARK_MASK = 30,
	XFRMA_IF_ID = 31,
	XFRMA_MTIMER_THRESH = 32,
	XFRMA_SA_DIR = 33,
	XFRMA_NAT_KEEPALIVE_INTERVAL = 34,
	XFRMA_SA_PCPU = 35,
	XFRMA_IPTFS_DROP_TIME = 36,
	XFRMA_IPTFS_REORDER_WINDOW = 37,
	XFRMA_IPTFS_DONT_FRAG = 38,
	XFRMA_IPTFS_INIT_DELAY = 39,
	XFRMA_IPTFS_MAX_QSIZE = 40,
	XFRMA_IPTFS_PKT_SIZE = 41,
	__XFRMA_MAX = 42,
};

enum xfrm_nlgroups {
	XFRMNLGRP_NONE = 0,
	XFRMNLGRP_ACQUIRE = 1,
	XFRMNLGRP_EXPIRE = 2,
	XFRMNLGRP_SA = 3,
	XFRMNLGRP_POLICY = 4,
	XFRMNLGRP_AEVENTS = 5,
	XFRMNLGRP_REPORT = 6,
	XFRMNLGRP_MIGRATE = 7,
	XFRMNLGRP_MAPPING = 8,
	__XFRMNLGRP_MAX = 9,
};

enum xfrm_pol_inexact_candidate_type {
	XFRM_POL_CAND_BOTH = 0,
	XFRM_POL_CAND_SADDR = 1,
	XFRM_POL_CAND_DADDR = 2,
	XFRM_POL_CAND_ANY = 3,
	XFRM_POL_CAND_MAX = 4,
};

enum xfrm_replay_mode {
	XFRM_REPLAY_MODE_LEGACY = 0,
	XFRM_REPLAY_MODE_BMP = 1,
	XFRM_REPLAY_MODE_ESN = 2,
};

enum xfrm_sa_dir {
	XFRM_SA_DIR_IN = 1,
	XFRM_SA_DIR_OUT = 2,
};

enum xhci_cancelled_td_status {
	TD_DIRTY = 0,
	TD_HALTED = 1,
	TD_CLEARING_CACHE = 2,
	TD_CLEARING_CACHE_DEFERRED = 3,
	TD_CLEARED = 4,
};

enum xhci_ep_reset_type {
	EP_HARD_RESET = 0,
	EP_SOFT_RESET = 1,
};

enum xhci_overhead_type {
	LS_OVERHEAD_TYPE = 0,
	FS_OVERHEAD_TYPE = 1,
	HS_OVERHEAD_TYPE = 2,
};

enum xhci_ring_type {
	TYPE_CTRL = 0,
	TYPE_ISOC = 1,
	TYPE_BULK = 2,
	TYPE_INTR = 3,
	TYPE_STREAM = 4,
	TYPE_COMMAND = 5,
	TYPE_EVENT = 6,
};

enum xhci_setup_dev {
	SETUP_CONTEXT_ONLY = 0,
	SETUP_CONTEXT_ADDRESS = 1,
};

enum xhci_sideband_notify_type {
	XHCI_SIDEBAND_XFER_RING_FREE = 0,
};

enum xhci_sideband_type {
	XHCI_SIDEBAND_AUDIO = 0,
	XHCI_SIDEBAND_VENDOR = 1,
};

enum xprtsec_policies {
	RPC_XPRTSEC_NONE = 0,
	RPC_XPRTSEC_TLS_ANON = 1,
	RPC_XPRTSEC_TLS_X509 = 2,
};

enum xps_map_type {
	XPS_CPUS = 0,
	XPS_RXQS = 1,
	XPS_MAPS_MAX = 2,
};

enum xsd_sockmsg_type {
	XS_CONTROL = 0,
	XS_DIRECTORY = 1,
	XS_READ = 2,
	XS_GET_PERMS = 3,
	XS_WATCH = 4,
	XS_UNWATCH = 5,
	XS_TRANSACTION_START = 6,
	XS_TRANSACTION_END = 7,
	XS_INTRODUCE = 8,
	XS_RELEASE = 9,
	XS_GET_DOMAIN_PATH = 10,
	XS_WRITE = 11,
	XS_MKDIR = 12,
	XS_RM = 13,
	XS_SET_PERMS = 14,
	XS_WATCH_EVENT = 15,
	XS_ERROR = 16,
	XS_IS_DOMAIN_INTRODUCED = 17,
	XS_RESUME = 18,
	XS_SET_TARGET = 19,
	XS_RESET_WATCHES = 21,
	XS_DIRECTORY_PART = 22,
	XS_TYPE_COUNT = 23,
	XS_INVALID = 65535,
};

enum xstate_copy_mode {
	XSTATE_COPY_FP = 0,
	XSTATE_COPY_FX = 1,
	XSTATE_COPY_XSAVE = 2,
};

enum xz_check {
	XZ_CHECK_NONE = 0,
	XZ_CHECK_CRC32 = 1,
	XZ_CHECK_CRC64 = 4,
	XZ_CHECK_SHA256 = 10,
};

enum xz_mode {
	XZ_SINGLE = 0,
	XZ_PREALLOC = 1,
	XZ_DYNALLOC = 2,
};

enum xz_ret {
	XZ_OK = 0,
	XZ_STREAM_END = 1,
	XZ_UNSUPPORTED_CHECK = 2,
	XZ_MEM_ERROR = 3,
	XZ_MEMLIMIT_ERROR = 4,
	XZ_FORMAT_ERROR = 5,
	XZ_OPTIONS_ERROR = 6,
	XZ_DATA_ERROR = 7,
	XZ_BUF_ERROR = 8,
};

enum zbc_zone_alignment_method {
	ZBC_CONSTANT_ZONE_LENGTH = 1,
	ZBC_CONSTANT_ZONE_START_OFFSET = 8,
};

enum zbc_zone_cond {
	ZBC_ZONE_COND_NO_WP = 0,
	ZBC_ZONE_COND_EMPTY = 1,
	ZBC_ZONE_COND_IMP_OPEN = 2,
	ZBC_ZONE_COND_EXP_OPEN = 3,
	ZBC_ZONE_COND_CLOSED = 4,
	ZBC_ZONE_COND_READONLY = 13,
	ZBC_ZONE_COND_FULL = 14,
	ZBC_ZONE_COND_OFFLINE = 15,
};

enum zbc_zone_type {
	ZBC_ZONE_TYPE_CONV = 1,
	ZBC_ZONE_TYPE_SEQWRITE_REQ = 2,
	ZBC_ZONE_TYPE_SEQWRITE_PREF = 3,
	ZBC_ZONE_TYPE_SEQ_OR_BEFORE_REQ = 4,
	ZBC_ZONE_TYPE_GAP = 5,
};

enum zone_flags {
	ZONE_BOOSTED_WATERMARK = 0,
	ZONE_RECLAIM_ACTIVE = 1,
	ZONE_BELOW_HIGH = 2,
};

enum zone_stat_item {
	NR_FREE_PAGES = 0,
	NR_FREE_PAGES_BLOCKS = 1,
	NR_ZONE_LRU_BASE = 2,
	NR_ZONE_INACTIVE_ANON = 2,
	NR_ZONE_ACTIVE_ANON = 3,
	NR_ZONE_INACTIVE_FILE = 4,
	NR_ZONE_ACTIVE_FILE = 5,
	NR_ZONE_UNEVICTABLE = 6,
	NR_ZONE_WRITE_PENDING = 7,
	NR_MLOCK = 8,
	NR_ZSPAGES = 9,
	NR_FREE_CMA_PAGES = 10,
	NR_UNACCEPTED = 11,
	NR_VM_ZONE_STAT_ITEMS = 12,
};

enum zone_type {
	ZONE_DMA = 0,
	ZONE_DMA32 = 1,
	ZONE_NORMAL = 2,
	ZONE_MOVABLE = 3,
	ZONE_DEVICE = 4,
	__MAX_NR_ZONES = 5,
};

enum zone_watermarks {
	WMARK_MIN = 0,
	WMARK_LOW = 1,
	WMARK_HIGH = 2,
	WMARK_PROMO = 3,
	NR_WMARK = 4,
};

enum zswap_init_type {
	ZSWAP_UNINIT = 0,
	ZSWAP_INIT_SUCCEED = 1,
	ZSWAP_INIT_FAILED = 2,
};

typedef _Bool bool;

typedef __int128 unsigned __u128;

typedef __u128 u128;

typedef u128 freelist_full_t;

typedef char *__guest_handle_char;

typedef char acpi_bus_id[8];

typedef char acpi_device_class[20];

typedef char acpi_device_name[40];

typedef char *acpi_string;

typedef const char (* const ethnl_string_array_t)[32];

typedef int *__guest_handle_int;

typedef int __kernel_clockid_t;

typedef int __kernel_daddr_t;

typedef int __kernel_ipc_pid_t;

typedef int __kernel_key_t;

typedef int __kernel_mqd_t;

typedef int __kernel_pid_t;

typedef int __kernel_rwf_t;

typedef int __kernel_timer_t;

typedef int __s32;

typedef int class_get_unused_fd_t;

typedef __kernel_clockid_t clockid_t;

typedef __s32 s32;

typedef s32 codel_tdiff_t;

typedef s32 compat_clock_t;

typedef s32 compat_daddr_t;

typedef s32 compat_int_t;

typedef s32 compat_key_t;

typedef s32 compat_long_t;

typedef s32 compat_off_t;

typedef s32 compat_pid_t;

typedef s32 compat_ssize_t;

typedef s32 compat_timer_t;

typedef int cydp_t;

typedef s32 dma_cookie_t;

typedef int folio_walk_flags_t;

typedef int fpb_t;

typedef int fpi_t;

typedef int initcall_entry_t;

typedef int insn_value_t;

typedef s32 int32_t;

typedef int32_t key_serial_t;

typedef __kernel_key_t key_t;

typedef int mhp_t;

typedef int mm_id_mapcount_t;

typedef int mpi_size_t;

typedef __kernel_mqd_t mqd_t;

typedef s32 old_time32_t;

typedef int pci_power_t;

typedef __kernel_pid_t pid_t;

typedef int rmap_t;

typedef __kernel_rwf_t rwf_t;

typedef __s32 sctp_assoc_t;

typedef int suspend_state_t;

typedef __kernel_timer_t timer_t;

typedef const int tracepoint_ptr_t;

typedef long int __kernel_long_t;

typedef __kernel_long_t __kernel_clock_t;

typedef __kernel_long_t __kernel_off_t;

typedef __kernel_long_t __kernel_old_time_t;

typedef __kernel_long_t __kernel_ptrdiff_t;

typedef __kernel_long_t __kernel_ssize_t;

typedef __kernel_long_t __kernel_suseconds_t;

typedef __kernel_clock_t clock_t;

typedef long int intptr_t;

typedef long int mpi_limb_signed_t;

typedef __kernel_off_t off_t;

typedef __kernel_ptrdiff_t ptrdiff_t;

typedef __kernel_ssize_t ssize_t;

typedef __kernel_suseconds_t suseconds_t;

typedef long int xen_long_t;

typedef long long int __s64;

typedef __s64 Elf64_Sxword;

typedef __s64 s64;

typedef s64 int64_t;

typedef int64_t S64;

typedef long long int __kernel_loff_t;

typedef long long int __kernel_time64_t;

typedef s64 compat_loff_t;

typedef s64 compat_s64;

typedef s64 ktime_t;

typedef __kernel_loff_t loff_t;

typedef long long int qsize_t;

typedef __s64 time64_t;

typedef long long unsigned int __u64;

typedef __u64 Elf64_Addr;

typedef __u64 Elf64_Off;

typedef __u64 Elf64_Xword;

typedef __u64 u64;

typedef u64 uint64_t;

typedef uint64_t U64;

typedef U64 ZSTD_VecMask;

typedef __u64 __addrpair;

typedef __u64 __be64;

typedef uint64_t *__guest_handle_uint64_t;

typedef __u64 __le64;

typedef __u64 __virtio64;

typedef u64 acpi_bus_address;

typedef u64 acpi_integer;

typedef u64 acpi_io_address;

typedef u64 acpi_physical_address;

typedef u64 acpi_size;

typedef u64 async_cookie_t;

typedef __u64 binder_size_t;

typedef __u64 binder_uintptr_t;

typedef __u64 blist_flags_t;

typedef u64 blkcnt_t;

typedef u64 compat_u64;

typedef long long unsigned int cycles_t;

typedef u64 dma_addr_t;

typedef u64 efi_physical_addr_t;

typedef __be64 fdt64_t;

typedef u64 gfn_t;

typedef u64 gpa_t;

typedef u64 hfn_t;

typedef u64 hpa_t;

typedef u64 io_req_flags_t;

typedef hfn_t kvm_pfn_t;

typedef u64 netdev_features_t;

typedef u64 pci_bus_addr_t;

typedef u64 phys_addr_t;

typedef phys_addr_t resource_size_t;

typedef u64 sci_t;

typedef u64 sector_t;

typedef __u64 timeu64_t;

typedef u64 upf_t;

typedef uint64_t vli_type;

typedef long unsigned int __kernel_ulong_t;

typedef __kernel_ulong_t __kernel_size_t;

typedef __kernel_size_t size_t;

typedef size_t BitContainerType;

typedef size_t HUF_CElt;

typedef long unsigned int mpi_limb_t;

typedef mpi_limb_t UWtype;

typedef long unsigned int xen_pfn_t;

typedef xen_pfn_t *__guest_handle_xen_pfn_t;

typedef long unsigned int xen_ulong_t;

typedef xen_ulong_t *__guest_handle_xen_ulong_t;

typedef __kernel_ulong_t aio_context_t;

typedef long unsigned int dax_entry_t;

typedef long unsigned int efi_status_t;

typedef long unsigned int elf_greg_t;

typedef elf_greg_t elf_gregset_t[27];

typedef long unsigned int gva_t;

typedef __kernel_ulong_t ino_t;

typedef long unsigned int irq_hw_number_t;

typedef long unsigned int kernel_ulong_t;

typedef long unsigned int kimage_entry_t;

typedef long unsigned int mce_banks_t[1];

typedef mpi_limb_t *mpi_ptr_t;

typedef long unsigned int netmem_ref;

typedef long unsigned int old_sigset_t;

typedef long unsigned int p4dval_t;

typedef long unsigned int perf_trace_t[1024];

typedef long unsigned int pgdval_t;

typedef long unsigned int pgprotval_t;

typedef long unsigned int pmdval_t;

typedef long unsigned int pte_marker;

typedef long unsigned int pteval_t;

typedef long unsigned int pudval_t;

typedef long unsigned int uLong;

typedef long unsigned int uintptr_t;

typedef long unsigned int ulg;

typedef long unsigned int ulong;

typedef uintptr_t uptrval;

typedef long unsigned int vm_flags_t;

typedef long unsigned int xen_callback_t;

typedef short int __s16;

typedef __s16 s16;

typedef s16 int16_t;

typedef int16_t S16;

typedef short unsigned int __u16;

typedef __u16 Elf32_Half;

typedef __u16 Elf64_Half;

typedef short unsigned int ush;

typedef ush Pos;

typedef __u16 u16;

typedef u16 uint16_t;

typedef uint16_t U16;

typedef __u16 __be16;

typedef u16 __compat_gid_t;

typedef u16 __compat_uid_t;

typedef __u16 __hc16;

typedef short unsigned int __kernel_old_gid_t;

typedef short unsigned int __kernel_old_uid_t;

typedef short unsigned int __kernel_sa_family_t;

typedef __u16 __le16;

typedef __u16 __sum16;

typedef __u16 __virtio16;

typedef u16 access_mask_t;

typedef u16 acpi_owner_id;

typedef u16 acpi_rs_length;

typedef __u16 comp_t;

typedef u16 compat_ipc_pid_t;

typedef u16 compat_mode_t;

typedef u16 compat_nlink_t;

typedef u16 compat_ushort_t;

typedef uint16_t domid_t;

typedef u16 efi_char16_t;

typedef uint16_t grant_status_t;

typedef u16 hv_pci_rid;

typedef u16 hv_pci_segment;

typedef u16 layer_mask_t;

typedef short unsigned int mifi_t;

typedef __kernel_old_gid_t old_gid_t;

typedef __kernel_old_uid_t old_uid_t;

typedef short unsigned int pci_bus_flags_t;

typedef short unsigned int pci_dev_flags_t;

typedef __u16 port_id;

typedef __kernel_sa_family_t sa_family_t;

typedef u16 u_int16_t;

typedef short unsigned int u_short;

typedef u16 ucs2_char_t;

typedef __u16 uio_meta_flags_t;

typedef short unsigned int umode_t;

typedef short unsigned int ushort;

typedef short unsigned int vifi_t;

typedef u16 wchar_t;

typedef signed char __s8;

typedef __s8 s8;

typedef s8 int8_t;

typedef unsigned char __u8;

typedef __u8 u8;

typedef u8 uint8_t;

typedef uint8_t BYTE;

typedef unsigned char Byte;

typedef uint8_t U8;

typedef unsigned char *__guest_handle_uchar;

typedef u8 acpi_adr_space_type;

typedef u8 blk_status_t;

typedef unsigned char cc_t;

typedef u8 deny_masks_t;

typedef u8 dscp_t;

typedef u8 efi_bool_t;

typedef unsigned char insn_byte_t;

typedef u8 kprobe_opcode_t;

typedef __u8 mctp_eid_t;

typedef __u8 mtrr_type;

typedef u8 retpoline_thunk_t[32];

typedef u8 rmap_age_t;

typedef unsigned char u8___2;

typedef unsigned char u_char;

typedef u8 u_int8_t;

typedef unsigned char uch;

typedef u8 uprobe_opcode_t;

typedef const unsigned char utf8leaf_t;

typedef const unsigned char utf8trie_t;

typedef uint8_t xen_domain_handle_t[16];

typedef unsigned int __u32;

typedef __u32 Elf32_Addr;

typedef __u32 Elf32_Off;

typedef __u32 Elf32_Word;

typedef __u32 Elf64_Word;

typedef unsigned int FSE_CTable;

typedef unsigned int FSE_DTable;

typedef __u32 u32;

typedef u32 uint32_t;

typedef uint32_t U32;

typedef U32 HUF_DTable;

typedef unsigned int IPos;

typedef unsigned int UHWtype;

typedef uint32_t XENCONS_RING_IDX;

typedef uint32_t XENSTORE_RING_IDX;

typedef __u32 __be32;

typedef u32 __compat_gid32_t;

typedef u32 __compat_uid32_t;

typedef uint32_t evtchn_port_t;

typedef evtchn_port_t *__guest_handle_evtchn_port_t;

typedef uint32_t *__guest_handle_uint32_t;

typedef __u32 __hc32;

typedef u32 __kernel_dev_t;

typedef unsigned int __kernel_gid32_t;

typedef unsigned int __kernel_gid_t;

typedef unsigned int __kernel_mode_t;

typedef unsigned int __kernel_uid32_t;

typedef unsigned int __kernel_uid_t;

typedef __u32 __le32;

typedef unsigned int __poll_t;

typedef __u32 __portpair;

typedef __u32 __virtio32;

typedef __u32 __wsum;

typedef u32 acpi_event_status;

typedef u32 acpi_mutex_handle;

typedef u32 acpi_name;

typedef u32 acpi_object_type;

typedef u32 acpi_rsdesc_size;

typedef u32 acpi_status;

typedef unsigned int acr_flags_t;

typedef unsigned int autofs_wqt_t;

typedef unsigned int blk_features_t;

typedef unsigned int blk_flags_t;

typedef unsigned int blk_insert_t;

typedef unsigned int blk_mode_t;

typedef __u32 blk_mq_req_flags_t;

typedef __u32 blk_opf_t;

typedef unsigned int blk_qc_t;

typedef u32 codel_time_t;

typedef u32 compat_aio_context_t;

typedef u32 compat_caddr_t;

typedef u32 compat_ino_t;

typedef u32 compat_old_sigset_t;

typedef u32 compat_sigset_word;

typedef u32 compat_size_t;

typedef u32 compat_uint_t;

typedef u32 compat_ulong_t;

typedef u32 compat_uptr_t;

typedef u32 depot_flags_t;

typedef u32 depot_stack_handle_t;

typedef __kernel_dev_t dev_t;

typedef uint32_t drbg_flag_t;

typedef unsigned int drm_magic_t;

typedef u32 errseq_t;

typedef uint32_t event_word_t;

typedef __be32 fdt32_t;

typedef unsigned int fgf_t;

typedef unsigned int fmode_t;

typedef unsigned int fop_flags_t;

typedef unsigned int gfp_t;

typedef __kernel_gid32_t gid_t;

typedef uint32_t grant_handle_t;

typedef uint32_t grant_ref_t;

typedef __u32 if_mask;

typedef unsigned int insn_attr_t;

typedef unsigned int ioasid_t;

typedef unsigned int iov_iter_extraction_t;

typedef unsigned int isolate_mode_t;

typedef unsigned int kasan_vmalloc_flags_t;

typedef uint32_t key_perm_t;

typedef unsigned int mm_id_t;

typedef u32 nlink_t;

typedef u32 note_buf_t[92];

typedef unsigned int pci_channel_state_t;

typedef unsigned int pci_ers_result_t;

typedef unsigned int pgtbl_mod_mask;

typedef u32 phandle;

typedef u32 phys_cpuid_t;

typedef unsigned int pipe_index_t;

typedef __kernel_uid32_t projid_t;

typedef __kernel_uid32_t qid_t;

typedef U32 rankValCol_t[13];

typedef __u32 req_flags_t;

typedef u32 rpc_authflavor_t;

typedef unsigned int sk_buff_data_t;

typedef unsigned int slab_flags_t;

typedef unsigned int speed_t;

typedef u32 ssci_t;

typedef unsigned int t_key;

typedef unsigned int tcflag_t;

typedef unsigned int uInt;

typedef unsigned int u_int;

typedef u32 u_int32_t;

typedef unsigned int uffd_flags_t;

typedef __kernel_uid32_t uid_t;

typedef unsigned int uint;

typedef u32 unicode_t;

typedef unsigned int upstat_t;

typedef u32 usb_port_location_t;

typedef unsigned int vm_fault_t;

typedef unsigned int xa_mark_t;

typedef u32 xdp_features_t;

typedef unsigned int zap_flags_t;

typedef struct {
	BitContainerType bitContainer;
	unsigned int bitPos;
	char *startPtr;
	char *ptr;
	char *endPtr;
} BIT_CStream_t;

typedef struct {
	BitContainerType bitContainer;
	unsigned int bitsConsumed;
	const char *ptr;
	const char *start;
	const char *limitPtr;
} BIT_DStream_t;

typedef struct {
	size_t nbSequences;
	size_t blockSize;
	size_t litSize;
} BlockSummary;

typedef struct {
	BYTE maxTableLog;
	BYTE tableType;
	BYTE tableLog;
	BYTE reserved;
} DTableDesc;

typedef struct {
	size_t estLitSize;
	size_t estBlockSize;
} EstimatedBlockSize;

typedef struct {
	unsigned int events[1024];
	size_t nbEvents;
} Fingerprint;

typedef struct {
	Fingerprint pastEvents;
	Fingerprint newEvents;
} FPStats;

typedef struct {
	ptrdiff_t value;
	const void *stateTable;
	const void *symbolTT;
	unsigned int stateLog;
} FSE_CState_t;

typedef struct {
	size_t state;
	const void *table;
} FSE_DState_t;

typedef struct {
	U16 tableLog;
	U16 fastMode;
} FSE_DTableHeader;

typedef struct {
	short int ncount[256];
} FSE_DecompressWksp;

typedef struct {
	short unsigned int newState;
	unsigned char symbol;
	unsigned char nbBits;
} FSE_decode_t;

typedef struct {
	int deltaFindState;
	U32 deltaNbBits;
} FSE_symbolCompressionTransform;

typedef struct {
	size_t bitContainer[2];
	size_t bitPos[2];
	BYTE *startPtr;
	BYTE *ptr;
	BYTE *endPtr;
} HUF_CStream_t;

typedef struct {
	BYTE tableLog;
	BYTE maxSymbolValue;
	BYTE unused[6];
} HUF_CTableHeader;

typedef struct {
	FSE_CTable CTable[59];
	U32 scratchBuffer[41];
	unsigned int count[13];
	S16 norm[13];
} HUF_CompressWeightsWksp;

typedef struct {
	BYTE nbBits;
	BYTE byte;
} HUF_DEltX1;

typedef struct {
	U16 sequence;
	BYTE nbBits;
	BYTE length;
} HUF_DEltX2;

typedef struct {
	const BYTE *ip[4];
	BYTE *op[4];
	U64 bits[4];
	const void *dt;
	const BYTE *ilowest;
	BYTE *oend;
	const BYTE *iend[4];
} HUF_DecompressFastArgs;

typedef struct {
	U32 rankVal[13];
	U32 rankStart[13];
	U32 statsWksp[219];
	BYTE symbols[256];
	BYTE huffWeight[256];
} HUF_ReadDTableX1_Workspace;

typedef struct {
	BYTE symbol;
} sortedSymbol_t;

typedef struct {
	U32 rankVal[156];
	U32 rankStats[13];
	U32 rankStart0[15];
	sortedSymbol_t sortedSymbol[256];
	BYTE weightList[256];
	U32 calleeWksp[219];
} HUF_ReadDTableX2_Workspace;

typedef struct {
	HUF_CompressWeightsWksp wksp;
	BYTE bitsToWeight[13];
	BYTE huffWeight[255];
} HUF_WriteCTableWksp;

struct nodeElt_s {
	U32 count;
	U16 parent;
	BYTE byte;
	BYTE nbBits;
};

typedef struct nodeElt_s nodeElt;

typedef nodeElt huffNodeTable[512];

typedef struct {
	U16 base;
	U16 curr;
} rankPos;

typedef struct {
	huffNodeTable huffNodeTbl;
	rankPos rankPosition[192];
} HUF_buildCTable_wksp_tables;

typedef struct {
	unsigned int count[256];
	HUF_CElt CTable[257];
	union {
		HUF_buildCTable_wksp_tables buildCTable_wksp;
		HUF_WriteCTableWksp writeCTable_wksp;
		U32 hist_wksp[1024];
	} wksps;
} HUF_compress_tables_t;

typedef struct {
	const uint8_t *externalDict;
	size_t extDictSize;
	const uint8_t *prefixEnd;
	size_t prefixSize;
} LZ4_streamDecode_t_internal;

typedef union {
	long long unsigned int table[4];
	LZ4_streamDecode_t_internal internal_donotuse;
} LZ4_streamDecode_t;

struct list_head {
	struct list_head *next;
	struct list_head *prev;
};

typedef struct {
	int counter;
} atomic_t;

struct refcount_struct {
	atomic_t refs;
};

typedef struct refcount_struct refcount_t;

struct dentry;

struct file;

typedef struct {
	struct list_head list;
	long unsigned int flags;
	int offset;
	int size;
	char *magic;
	char *mask;
	const char *interpreter;
	char *name;
	struct dentry *dentry;
	struct file *interp_file;
	refcount_t users;
} Node;

typedef struct {
	U32 offset;
	U32 litLength;
	U32 matchLength;
} rawSeq;

typedef struct {
	rawSeq *seq;
	size_t pos;
	size_t posInSequence;
	size_t size;
	size_t capacity;
} RawSeqStore_t;

struct folio;

typedef struct {
	struct folio *v;
} Sector;

typedef struct {
	unsigned int offset;
	unsigned int litLength;
	unsigned int matchLength;
	unsigned int rep;
} ZSTD_Sequence;

typedef struct {
	int collectSequences;
	ZSTD_Sequence *seqStart;
	size_t seqIndex;
	size_t maxSequences;
} SeqCollector;

struct SeqDef_s;

typedef struct SeqDef_s SeqDef;

typedef struct {
	SeqDef *sequencesStart;
	SeqDef *sequences;
	BYTE *litStart;
	BYTE *lit;
	BYTE *llCode;
	BYTE *mlCode;
	BYTE *ofCode;
	size_t maxNbSeq;
	size_t maxNbLit;
	ZSTD_longLengthType_e longLengthType;
	U32 longLengthPos;
} SeqStore_t;

typedef struct {
	S16 norm[53];
	U32 wksp[285];
} ZSTD_BuildCTableWksp;

struct ZSTD_DDict_s;

typedef struct ZSTD_DDict_s ZSTD_DDict;

typedef struct {
	const ZSTD_DDict **ddictPtrTable;
	size_t ddictPtrTableSize;
	size_t ddictPtrCount;
} ZSTD_DDictHashSet;

typedef struct {
	long long unsigned int frameContentSize;
	long long unsigned int windowSize;
	unsigned int blockSizeMax;
	ZSTD_FrameType_e frameType;
	unsigned int headerSize;
	unsigned int dictID;
	unsigned int checksumFlag;
	unsigned int _reserved1;
	unsigned int _reserved2;
} ZSTD_FrameHeader;

typedef struct {
	unsigned int longOffsetShare;
	unsigned int maxNbAdditionalBits;
} ZSTD_OffsetInfo;

typedef struct {
	U32 litLength;
	U32 matchLength;
} ZSTD_SequenceLength;

typedef struct {
	U32 idx;
	U32 posInSequence;
	size_t posInSrc;
} ZSTD_SequencePosition;

typedef struct {
	SymbolEncodingType_e hType;
	BYTE hufDesBuffer[128];
	size_t hufDesSize;
} ZSTD_hufCTablesMetadata_t;

typedef struct {
	SymbolEncodingType_e llType;
	SymbolEncodingType_e ofType;
	SymbolEncodingType_e mlType;
	BYTE fseTablesBuffer[133];
	size_t fseTablesSize;
	size_t lastCountSize;
} ZSTD_fseCTablesMetadata_t;

typedef struct {
	ZSTD_hufCTablesMetadata_t hufMetadata;
	ZSTD_fseCTablesMetadata_t fseMetadata;
} ZSTD_entropyCTablesMetadata_t;

typedef struct {
	SeqStore_t fullSeqStoreChunk;
	SeqStore_t firstHalfSeqStore;
	SeqStore_t secondHalfSeqStore;
	SeqStore_t currSeqStore;
	SeqStore_t nextSeqStore;
	U32 partitions[196];
	ZSTD_entropyCTablesMetadata_t entropyMetadata;
} ZSTD_blockSplitCtx;

typedef struct {
	HUF_CElt CTable[257];
	HUF_repeat repeatMode;
} ZSTD_hufCTables_t;

typedef struct {
	FSE_CTable offcodeCTable[193];
	FSE_CTable matchlengthCTable[363];
	FSE_CTable litlengthCTable[329];
	FSE_repeat offcode_repeatMode;
	FSE_repeat matchlength_repeatMode;
	FSE_repeat litlength_repeatMode;
} ZSTD_fseCTables_t;

typedef struct {
	ZSTD_hufCTables_t huf;
	ZSTD_fseCTables_t fse;
} ZSTD_entropyCTables_t;

typedef struct {
	ZSTD_entropyCTables_t entropy;
	U32 rep[3];
} ZSTD_compressedBlockState_t;

typedef struct {
	const BYTE *nextSrc;
	const BYTE *base;
	const BYTE *dictBase;
	U32 dictLimit;
	U32 lowLimit;
	U32 nbOverflowCorrections;
} ZSTD_window_t;

typedef struct {
	U32 off;
	U32 len;
} ZSTD_match_t;

typedef struct {
	int price;
	U32 off;
	U32 mlen;
	U32 litlen;
	U32 rep[3];
} ZSTD_optimal_t;

typedef struct {
	unsigned int *litFreq;
	unsigned int *litLengthFreq;
	unsigned int *matchLengthFreq;
	unsigned int *offCodeFreq;
	ZSTD_match_t *matchTable;
	ZSTD_optimal_t *priceTable;
	U32 litSum;
	U32 litLengthSum;
	U32 matchLengthSum;
	U32 offCodeSum;
	U32 litSumBasePrice;
	U32 litLengthSumBasePrice;
	U32 matchLengthSumBasePrice;
	U32 offCodeSumBasePrice;
	ZSTD_OptPrice_e priceType;
	const ZSTD_entropyCTables_t *symbolCosts;
	ZSTD_ParamSwitch_e literalCompressionMode;
} optState_t;

typedef struct {
	unsigned int windowLog;
	unsigned int chainLog;
	unsigned int hashLog;
	unsigned int searchLog;
	unsigned int minMatch;
	unsigned int targetLength;
	ZSTD_strategy strategy;
} ZSTD_compressionParameters;

struct ZSTD_MatchState_t;

typedef struct ZSTD_MatchState_t ZSTD_MatchState_t;

struct ZSTD_MatchState_t {
	ZSTD_window_t window;
	U32 loadedDictEnd;
	U32 nextToUpdate;
	U32 hashLog3;
	U32 rowHashLog;
	BYTE *tagTable;
	U32 hashCache[8];
	U64 hashSalt;
	U32 hashSaltEntropy;
	U32 *hashTable;
	U32 *hashTable3;
	U32 *chainTable;
	int forceNonContiguous;
	int dedicatedDictSearch;
	optState_t opt;
	const ZSTD_MatchState_t *dictMatchState;
	ZSTD_compressionParameters cParams;
	const RawSeqStore_t *ldmSeqStore;
	int prefetchCDictTables;
	int lazySkipping;
};

typedef struct {
	ZSTD_compressedBlockState_t *prevCBlock;
	ZSTD_compressedBlockState_t *nextCBlock;
	ZSTD_MatchState_t matchState;
} ZSTD_blockState_t;

typedef struct {
	size_t error;
	int lowerBound;
	int upperBound;
} ZSTD_bounds;

typedef struct {
	U32 f1c;
	U32 f1d;
	U32 f7b;
	U32 f7c;
} ZSTD_cpuid_t;

typedef void * (*ZSTD_allocFunction)(void *, size_t);

typedef void (*ZSTD_freeFunction)(void *, void *);

typedef struct {
	ZSTD_allocFunction customAlloc;
	ZSTD_freeFunction customFree;
	void *opaque;
} ZSTD_customMem;

typedef struct {
	void *workspace;
	void *workspaceEnd;
	void *objectEnd;
	void *tableEnd;
	void *tableValidEnd;
	void *allocStart;
	void *initOnceStart;
	BYTE allocFailed;
	int workspaceOversizedDuration;
	ZSTD_cwksp_alloc_phase_e phase;
	ZSTD_cwksp_static_alloc_e isStatic;
} ZSTD_cwksp;

typedef struct {
	U16 nextState;
	BYTE nbAdditionalBits;
	BYTE nbBits;
	U32 baseValue;
} ZSTD_seqSymbol;

typedef struct {
	ZSTD_seqSymbol LLTable[513];
	ZSTD_seqSymbol OFTable[257];
	ZSTD_seqSymbol MLTable[513];
	HUF_DTable hufTable[4097];
	U32 rep[3];
	U32 workspace[157];
} ZSTD_entropyDTables_t;

typedef struct {
	int contentSizeFlag;
	int checksumFlag;
	int noDictIDFlag;
} ZSTD_frameParameters;

typedef struct {
	long long unsigned int ingested;
	long long unsigned int consumed;
	long long unsigned int produced;
	long long unsigned int flushed;
	unsigned int currentJobID;
	unsigned int nbActiveWorkers;
} ZSTD_frameProgression;

typedef struct {
	size_t nbBlocks;
	size_t compressedSize;
	long long unsigned int decompressedBound;
} ZSTD_frameSizeInfo;

typedef struct {
	size_t state;
	const ZSTD_seqSymbol *table;
} ZSTD_fseState;

struct ZSTD_CDict_s;

typedef struct ZSTD_CDict_s ZSTD_CDict;

typedef struct {
	void *dictBuffer;
	const void *dict;
	size_t dictSize;
	ZSTD_dictContentType_e dictContentType;
	ZSTD_CDict *cdict;
} ZSTD_localDict;

typedef struct {
	RawSeqStore_t seqStore;
	U32 startPosInBlock;
	U32 endPosInBlock;
	U32 offset;
} ZSTD_optLdm_t;

typedef struct {
	ZSTD_compressionParameters cParams;
	ZSTD_frameParameters fParams;
} ZSTD_parameters;

typedef struct {
	U32 fastMode;
	U32 tableLog;
} ZSTD_seqSymbol_header;

typedef struct {
	U32 LLtype;
	U32 Offtype;
	U32 MLtype;
	size_t size;
	size_t lastCountSize;
	int longOffsets;
} ZSTD_symbolEncodingTypeStats_t;

typedef struct {
	long unsigned int fds_bits[16];
} __kernel_fd_set;

typedef struct {
	int val[2];
} __kernel_fsid_t;

typedef struct {
	U32 tableTime;
	U32 decode256Time;
} algo_time_t;

typedef struct {
	s64 counter;
} atomic64_t;

typedef atomic64_t atomic_long_t;

typedef struct {
	char ax25_call[7];
} ax25_address;

struct hlist_node {
	struct hlist_node *next;
	struct hlist_node **pprev;
};

struct timer_list {
	struct hlist_node entry;
	long unsigned int expires;
	void (*function)(struct timer_list *);
	u32 flags;
};

typedef struct {
	char slave;
	struct timer_list slave_timer;
	short unsigned int slave_timeout;
} ax25_dama_info;

typedef struct {
	__be64 a;
	__be64 b;
} be128;

typedef struct {
	blockType_e blockType;
	U32 lastBlock;
	U32 origSize;
} blockProperties_t;

typedef struct {
	union {
		void *kernel;
		void *user;
	};
	bool is_kernel: 1;
} sockptr_t;

typedef sockptr_t bpfptr_t;

struct permanent_flags_t {
	__be16 tag;
	u8 disable;
	u8 ownership;
	u8 deactivated;
	u8 readPubek;
	u8 disableOwnerClear;
	u8 allowMaintenance;
	u8 physicalPresenceLifetimeLock;
	u8 physicalPresenceHWEnable;
	u8 physicalPresenceCMDEnable;
	u8 CEKPUsed;
	u8 TPMpost;
	u8 TPMpostLock;
	u8 FIPS;
	u8 operator;
	u8 enableRevokeEK;
	u8 nvLocked;
	u8 readSRKPub;
	u8 tpmEstablished;
	u8 maintenanceDone;
	u8 disableFullDALogicInfo;
};

struct stclear_flags_t {
	__be16 tag;
	u8 deactivated;
	u8 disableForceClear;
	u8 physicalPresence;
	u8 physicalPresenceLock;
	u8 bGlobalLock;
} __attribute__((packed));

struct tpm1_version {
	u8 major;
	u8 minor;
	u8 rev_major;
	u8 rev_minor;
};

struct tpm1_version2 {
	__be16 tag;
	struct tpm1_version version;
};

struct timeout_t {
	__be32 a;
	__be32 b;
	__be32 c;
	__be32 d;
};

struct duration_t {
	__be32 tpm_short;
	__be32 tpm_medium;
	__be32 tpm_long;
};

typedef union {
	struct permanent_flags_t perm_flags;
	struct stclear_flags_t stclear_flags;
	__u8 owned;
	__be32 num_pcrs;
	struct tpm1_version version1;
	struct tpm1_version2 version2;
	__be32 manufacturer_id;
	struct timeout_t timeout;
	struct duration_t duration;
} cap_t;

typedef struct {
	unsigned int interval;
	unsigned int timeout;
} cisco_proto;

typedef struct {
	int *lock;
	long unsigned int flags;
} class_core_lock_t;

typedef struct {
	void *lock;
} class_cpus_read_lock_t;

struct raw_spinlock;

typedef struct raw_spinlock raw_spinlock_t;

typedef struct {
	raw_spinlock_t *lock;
	raw_spinlock_t *lock2;
} class_double_raw_spinlock_t;

struct rq;

typedef struct {
	struct rq *lock;
	struct rq *lock2;
} class_double_rq_lock_t;

typedef struct {
	void *lock;
} class_irq_t;

struct irq_desc;

typedef struct {
	struct irq_desc *lock;
	long unsigned int flags;
	bool bus;
} class_irqdesc_lock_t;

typedef struct {
	void *lock;
	long unsigned int flags;
} class_irqsave_t;

typedef struct {
	void *lock;
} class_jump_label_lock_t;

struct device;

typedef struct {
	struct device *lock;
} class_msi_descs_lock_t;

typedef struct {
	void *lock;
} class_pagefault_t;

struct perf_cpu_context;

struct perf_event_context;

typedef struct {
	struct perf_cpu_context *cpuctx;
	struct perf_event_context *ctx;
} class_perf_ctx_lock_t;

typedef struct {
	void *lock;
} class_preempt_notrace_t;

typedef struct {
	void *lock;
} class_preempt_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_irq_t;

typedef struct {
	raw_spinlock_t *lock;
	long unsigned int flags;
} class_raw_spinlock_irqsave_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_nested_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_t;

typedef struct {
	void *lock;
} class_rcu_t;

typedef struct {
	void *lock;
} class_rcu_tasks_trace_t;

struct qspinlock {
	union {
		atomic_t val;
		struct {
			u8 locked;
			u8 pending;
		};
		struct {
			u16 locked_pending;
			u16 tail;
		};
	};
};

typedef struct qspinlock arch_spinlock_t;

struct qrwlock {
	union {
		atomic_t cnts;
		struct {
			u8 wlocked;
			u8 __lstate[3];
		};
	};
	arch_spinlock_t wait_lock;
};

typedef struct qrwlock arch_rwlock_t;

typedef struct {
	arch_rwlock_t raw_lock;
} rwlock_t;

typedef struct {
	rwlock_t *lock;
	long unsigned int flags;
} class_read_lock_irqsave_t;

struct pin_cookie {};

struct rq_flags {
	long unsigned int flags;
	struct pin_cookie cookie;
	unsigned int clock_update_flags;
};

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_irq_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_irqsave_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_t;

struct spinlock;

typedef struct spinlock spinlock_t;

typedef struct {
	spinlock_t *lock;
} class_spinlock_irq_t;

typedef struct {
	spinlock_t *lock;
	long unsigned int flags;
} class_spinlock_irqsave_t;

typedef struct {
	spinlock_t *lock;
} class_spinlock_t;

struct srcu_struct;

typedef struct {
	struct srcu_struct *lock;
	int idx;
} class_srcu_t;

struct task_struct;

typedef struct {
	struct task_struct *lock;
	struct rq *rq;
	struct rq_flags rf;
} class_task_rq_lock_t;

typedef struct {
	rwlock_t *lock;
} class_write_lock_irq_t;

typedef struct {
	rwlock_t *lock;
	long unsigned int flags;
} class_write_lock_irqsave_t;

typedef struct {
	unsigned char op;
	unsigned char bits;
	short unsigned int val;
} code;

typedef __kernel_fsid_t compat_fsid_t;

typedef struct {
	compat_sigset_word sig[2];
} compat_sigset_t;

typedef struct {
	long unsigned int bits[1];
} dma_cap_mask_t;

typedef struct {
	u64 length;
	u64 data;
} efi_capsule_block_desc_t;

typedef struct {
	__u8 b[16];
} guid_t;

typedef guid_t efi_guid_t;

typedef struct {
	efi_guid_t guid;
	u32 headersize;
	u32 flags;
	u32 imagesize;
} efi_capsule_header_t;

typedef struct {
	efi_guid_t guid;
	u32 table;
} efi_config_table_32_t;

typedef struct {
	efi_guid_t guid;
	u64 table;
} efi_config_table_64_t;

typedef union {
	struct {
		efi_guid_t guid;
		void *table;
	};
	efi_config_table_32_t mixed_mode;
} efi_config_table_t;

typedef struct {
	efi_guid_t guid;
	long unsigned int *ptr;
	const char name[16];
} efi_config_table_type_t;

typedef struct {
	u32 type;
	u32 pad;
	u64 phys_addr;
	u64 virt_addr;
	u64 num_pages;
	u64 attribute;
} efi_memory_desc_t;

typedef struct {
	u32 version;
	u32 num_entries;
	u32 desc_size;
	u32 flags;
	efi_memory_desc_t entry[0];
} efi_memory_attributes_table_t;

typedef struct {
	u16 version;
	u16 length;
	u32 runtime_services_supported;
} efi_rt_properties_table_t;

typedef struct {
	u64 signature;
	u32 revision;
	u32 headersize;
	u32 crc32;
	u32 reserved;
} efi_table_hdr_t;

typedef struct {
	efi_table_hdr_t hdr;
	u32 get_time;
	u32 set_time;
	u32 get_wakeup_time;
	u32 set_wakeup_time;
	u32 set_virtual_address_map;
	u32 convert_pointer;
	u32 get_variable;
	u32 get_next_variable;
	u32 set_variable;
	u32 get_next_high_mono_count;
	u32 reset_system;
	u32 update_capsule;
	u32 query_capsule_caps;
	u32 query_variable_info;
} efi_runtime_services_32_t;

typedef struct {
	u16 year;
	u8 month;
	u8 day;
	u8 hour;
	u8 minute;
	u8 second;
	u8 pad1;
	u32 nanosecond;
	s16 timezone;
	u8 daylight;
	u8 pad2;
} efi_time_t;

typedef struct {
	u32 resolution;
	u32 accuracy;
	u8 sets_to_zero;
} efi_time_cap_t;

typedef union {
	struct {
		efi_table_hdr_t hdr;
		efi_status_t (*get_time)(efi_time_t *, efi_time_cap_t *);
		efi_status_t (*set_time)(efi_time_t *);
		efi_status_t (*get_wakeup_time)(efi_bool_t *, efi_bool_t *, efi_time_t *);
		efi_status_t (*set_wakeup_time)(efi_bool_t, efi_time_t *);
		efi_status_t (*set_virtual_address_map)(long unsigned int, long unsigned int, u32, efi_memory_desc_t *);
		void *convert_pointer;
		efi_status_t (*get_variable)(efi_char16_t *, efi_guid_t *, u32 *, long unsigned int *, void *);
		efi_status_t (*get_next_variable)(long unsigned int *, efi_char16_t *, efi_guid_t *);
		efi_status_t (*set_variable)(efi_char16_t *, efi_guid_t *, u32, long unsigned int, void *);
		efi_status_t (*get_next_high_mono_count)(u32 *);
		void (*reset_system)(int, efi_status_t, long unsigned int, efi_char16_t *);
		efi_status_t (*update_capsule)(efi_capsule_header_t **, long unsigned int, long unsigned int);
		efi_status_t (*query_capsule_caps)(efi_capsule_header_t **, long unsigned int, u64 *, int *);
		efi_status_t (*query_variable_info)(u32, u64 *, u64 *, u64 *);
	};
	efi_runtime_services_32_t mixed_mode;
} efi_runtime_services_t;

typedef struct {
	efi_guid_t signature_owner;
	u8 signature_data[0];
} efi_signature_data_t;

typedef struct {
	efi_guid_t signature_type;
	u32 signature_list_size;
	u32 signature_header_size;
	u32 signature_size;
	u8 signature_header[0];
} efi_signature_list_t;

typedef struct {
	efi_table_hdr_t hdr;
	u32 fw_vendor;
	u32 fw_revision;
	u32 con_in_handle;
	u32 con_in;
	u32 con_out_handle;
	u32 con_out;
	u32 stderr_handle;
	u32 stderr;
	u32 runtime;
	u32 boottime;
	u32 nr_tables;
	u32 tables;
} efi_system_table_32_t;

typedef struct {
	efi_table_hdr_t hdr;
	u64 fw_vendor;
	u32 fw_revision;
	u32 __pad1;
	u64 con_in_handle;
	u64 con_in;
	u64 con_out_handle;
	u64 con_out;
	u64 stderr_handle;
	u64 stderr;
	u64 runtime;
	u64 boottime;
	u32 nr_tables;
	u32 __pad2;
	u64 tables;
} efi_system_table_64_t;

union efi_simple_text_input_protocol;

typedef union efi_simple_text_input_protocol efi_simple_text_input_protocol_t;

union efi_simple_text_output_protocol;

typedef union efi_simple_text_output_protocol efi_simple_text_output_protocol_t;

union efi_boot_services;

typedef union efi_boot_services efi_boot_services_t;

typedef union {
	struct {
		efi_table_hdr_t hdr;
		long unsigned int fw_vendor;
		u32 fw_revision;
		long unsigned int con_in_handle;
		efi_simple_text_input_protocol_t *con_in;
		long unsigned int con_out_handle;
		efi_simple_text_output_protocol_t *con_out;
		long unsigned int stderr_handle;
		long unsigned int stderr;
		efi_runtime_services_t *runtime;
		efi_boot_services_t *boottime;
		long unsigned int nr_tables;
		long unsigned int tables;
	};
	efi_system_table_32_t mixed_mode;
} efi_system_table_t;

typedef __kernel_fd_set fd_set;

typedef struct {
	long unsigned int *in;
	long unsigned int *out;
	long unsigned int *ex;
	long unsigned int *res_in;
	long unsigned int *res_out;
	long unsigned int *res_ex;
} fd_set_bits;

typedef struct {
	atomic64_t refcnt;
} file_ref_t;

typedef struct {
	unsigned int t391;
	unsigned int t392;
	unsigned int n391;
	unsigned int n392;
	unsigned int n393;
	short unsigned int lmi;
	short unsigned int dce;
} fr_proto;

typedef struct {
	unsigned int dlci;
} fr_proto_pvc;

typedef struct {
	unsigned int dlci;
	char master[16];
} fr_proto_pvc_info;

typedef union {
	struct {
		void *freelist;
		long unsigned int counter;
	};
	freelist_full_t full;
} freelist_aba_t;

typedef struct {
	long unsigned int v;
} freeptr_t;

typedef struct {
	long unsigned int key[2];
} hsiphash_key_t;

typedef struct {
	u8 kvm_cpu_l1tf_flush_l1d;
	unsigned int __nmi_count;
	unsigned int apic_timer_irqs;
	unsigned int irq_spurious_count;
	unsigned int icr_read_retry_count;
	unsigned int kvm_posted_intr_ipis;
	unsigned int kvm_posted_intr_wakeup_ipis;
	unsigned int kvm_posted_intr_nested_ipis;
	unsigned int x86_platform_ipis;
	unsigned int apic_perf_irqs;
	unsigned int apic_irq_work_irqs;
	unsigned int irq_resched_count;
	unsigned int irq_call_count;
	unsigned int irq_tlb_count;
	unsigned int irq_thermal_count;
	unsigned int irq_threshold_count;
	unsigned int irq_deferred_error_count;
	unsigned int irq_hv_callback_count;
	unsigned int irq_hv_reenlightenment_count;
	unsigned int hyperv_stimer0_count;
	unsigned int posted_msi_notification_count;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
} irq_cpustat_t;

typedef struct {
	u64 val;
} kernel_cap_t;

typedef struct {
	gid_t val;
} kgid_t;

typedef struct {
	uid_t val;
} kuid_t;

typedef union {
	kuid_t uid;
	kgid_t gid;
} kid_t;

typedef struct {
	projid_t val;
} kprojid_t;

typedef struct {
	U32 offset;
	U32 checksum;
} ldmEntry_t;

typedef struct {
	const BYTE *split;
	U32 hash;
	U32 checksum;
	ldmEntry_t *bucket;
} ldmMatchCandidate_t;

typedef struct {
	ZSTD_ParamSwitch_e enableLdm;
	U32 hashLog;
	U32 bucketSizeLog;
	U32 minMatchLength;
	U32 hashRateLog;
	U32 windowLog;
} ldmParams_t;

typedef struct {
	U64 rolling;
	U64 stopMask;
} ldmRollingHashState_t;

typedef struct {
	ZSTD_window_t window;
	ldmEntry_t *hashTable;
	U32 loadedDictEnd;
	BYTE *bucketOffsets;
	size_t splitIndices[64];
	ldmMatchCandidate_t matchCandidates[64];
} ldmState_t;

typedef struct {
	__le64 b;
	__le64 a;
} le128;

typedef struct {
	atomic_long_t a;
} local_t;

typedef struct {
	local_t a;
} local64_t;

typedef struct {} local_lock_t;

typedef struct {
	local_lock_t llock;
	u8 acquired;
} local_trylock_t;

typedef struct {} lockdep_map_p;

struct optimistic_spin_queue {
	atomic_t tail;
};

struct raw_spinlock {
	arch_spinlock_t raw_lock;
};

struct rw_semaphore {
	atomic_long_t count;
	atomic_long_t owner;
	struct optimistic_spin_queue osq;
	raw_spinlock_t wait_lock;
	struct list_head wait_list;
};

struct mutex {
	atomic_long_t owner;
	raw_spinlock_t wait_lock;
	struct optimistic_spin_queue osq;
	struct list_head wait_list;
};

struct ldt_struct;

struct vdso_image;

typedef struct {
	u64 ctx_id;
	atomic64_t tlb_gen;
	long unsigned int next_trim_cpumask;
	struct rw_semaphore ldt_usr_sem;
	struct ldt_struct *ldt;
	long unsigned int flags;
	struct mutex lock;
	void *vdso;
	const struct vdso_image *vdso_image;
	atomic_t perf_rdpmc_allowed;
	u16 pkey_allocation_map;
	s16 execute_only_pkey;
	u16 global_asid;
	bool asid_transition;
} mm_context_t;

typedef struct {} netdevice_tracker;

typedef struct {} netns_tracker;

typedef struct {
	char data[8];
} nfs4_verifier;

typedef struct {
	__u8 b[16];
} uuid_t;

struct spinlock {
	union {
		struct raw_spinlock rlock;
	};
};

struct net;

struct auth_domain;

typedef struct {
	uuid_t uuid;
	unsigned int nfs3_localio_probe_count;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t lock;
	struct list_head list;
	spinlock_t *list_lock;
	struct net *net;
	struct auth_domain *dom;
	struct list_head files;
} nfs_uuid_t;

typedef struct {
	long unsigned int bits[16];
} nodemask_t;

typedef struct {
	p4dval_t p4d;
} p4d_t;

typedef struct {
	u64 pme;
} pagemap_entry_t;

typedef struct {
	pgdval_t pgd;
} pgd_t;

typedef struct {
	pmdval_t pmd;
} pmd_t;

typedef struct {
	long unsigned int bits[4];
} pnp_irq_mask_t;

typedef struct {
	struct net *net;
} possible_net_t;

typedef struct {
	pteval_t pte;
} pte_t;

typedef struct {
	pudval_t pud;
} pud_t;

typedef struct {
	short unsigned int encoding;
	short unsigned int parity;
} raw_hdlc_proto;

typedef struct {
	atomic_t refcnt;
} rcuref_t;

typedef struct {
	size_t written;
	size_t count;
	union {
		char *buf;
		void *data;
	} arg;
	int error;
} read_descriptor_t;

typedef union {
} release_pages_arg;

typedef struct {
	BIT_DStream_t DStream;
	ZSTD_fseState stateLL;
	ZSTD_fseState stateOffb;
	ZSTD_fseState stateML;
	size_t prevOffset[3];
} seqState_t;

typedef struct {
	U32 *splitLocations;
	size_t idx;
} seqStoreSplits;

typedef struct {
	size_t litLength;
	size_t matchLength;
	size_t offset;
} seq_t;

struct seqcount {
	unsigned int sequence;
};

typedef struct seqcount seqcount_t;

typedef struct {
	seqcount_t seqcount;
} seqcount_latch_t;

struct seqcount_spinlock {
	seqcount_t seqcount;
};

typedef struct seqcount_spinlock seqcount_spinlock_t;

typedef struct {
	seqcount_spinlock_t seqcount;
	spinlock_t lock;
} seqlock_t;

typedef struct {
	long unsigned int sig[1];
} sigset_t;

typedef struct {
	u64 key[2];
} siphash_key_t;

struct wait_queue_head {
	spinlock_t lock;
	struct list_head head;
};

typedef struct wait_queue_head wait_queue_head_t;

typedef struct {
	spinlock_t slock;
	int owned;
	wait_queue_head_t wq;
} socket_lock_t;

typedef struct {
	char *from;
	char *to;
} substring_t;

typedef struct {
	long unsigned int val;
} swp_entry_t;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
} sync_serial_settings;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
	unsigned int slot_map;
} te1_settings;

typedef struct {
	local64_t v;
} u64_stats_t;

typedef struct {
	u64 m_low;
	u64 m_high;
} uint128_t;

typedef struct {
	gid_t val;
} vfsgid_t;

typedef struct {
	uid_t val;
} vfsuid_t;

typedef struct {
	short unsigned int dce;
	unsigned int modulo;
	unsigned int window;
	unsigned int t1;
	unsigned int t2;
	unsigned int n2;
} x25_hdlc_proto;

struct in6_addr {
	union {
		__u8 u6_addr8[16];
		__be16 u6_addr16[8];
		__be32 u6_addr32[4];
	} in6_u;
};

typedef union {
	__be32 a4;
	__be32 a6[4];
	struct in6_addr in6;
} xfrm_address_t;

typedef ZSTD_compressionParameters zstd_compression_parameters;

typedef ZSTD_customMem zstd_custom_mem;

typedef ZSTD_FrameHeader zstd_frame_header;

typedef ZSTD_parameters zstd_parameters;

typedef ZSTD_Sequence zstd_sequence;

union IO_APIC_reg_00 {
	u32 raw;
	struct {
		u32 __reserved_2: 14;
		u32 LTS: 1;
		u32 delivery_type: 1;
		u32 __reserved_1: 8;
		u32 ID: 8;
	} bits;
};

union IO_APIC_reg_01 {
	u32 raw;
	struct {
		u32 version: 8;
		u32 __reserved_2: 7;
		u32 PRQ: 1;
		u32 entries: 8;
		u32 __reserved_1: 8;
	} bits;
};

union IO_APIC_reg_02 {
	u32 raw;
	struct {
		u32 __reserved_2: 24;
		u32 arbitration: 4;
		u32 __reserved_1: 4;
	} bits;
};

union IO_APIC_reg_03 {
	u32 raw;
	struct {
		u32 boot_DT: 1;
		u32 __reserved_1: 31;
	} bits;
};

struct IO_APIC_route_entry {
	union {
		struct {
			u64 vector: 8;
			u64 delivery_mode: 3;
			u64 dest_mode_logical: 1;
			u64 delivery_status: 1;
			u64 active_low: 1;
			u64 irr: 1;
			u64 is_level: 1;
			u64 masked: 1;
			u64 reserved_0: 15;
			u64 reserved_1: 17;
			u64 virt_destid_8_14: 7;
			u64 destid_0_7: 8;
		};
		struct {
			u64 ir_shared_0: 8;
			u64 ir_zero: 3;
			u64 ir_index_15: 1;
			u64 ir_shared_1: 5;
			u64 ir_reserved_0: 31;
			u64 ir_format: 1;
			u64 ir_index_0_14: 15;
		};
		struct {
			u64 w1: 32;
			u64 w2: 32;
		};
	};
};

struct sk_buff;

struct sk_buff_list {
	struct sk_buff *next;
	struct sk_buff *prev;
};

struct sk_buff_head {
	union {
		struct {
			struct sk_buff *next;
			struct sk_buff *prev;
		};
		struct sk_buff_list list;
	};
	__u32 qlen;
	spinlock_t lock;
};

struct qdisc_skb_head {
	struct sk_buff *head;
	struct sk_buff *tail;
	__u32 qlen;
	spinlock_t lock;
};

struct u64_stats_sync {};

struct gnet_stats_basic_sync {
	u64_stats_t bytes;
	u64_stats_t packets;
	struct u64_stats_sync syncp;
};

struct gnet_stats_queue {
	__u32 qlen;
	__u32 backlog;
	__u32 drops;
	__u32 requeues;
	__u32 overlimits;
};

struct callback_head {
	struct callback_head *next;
	void (*func)(struct callback_head *);
};

struct lock_class_key {};

struct Qdisc_ops;

struct qdisc_size_table;

struct netdev_queue;

struct net_rate_estimator;

struct Qdisc {
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	unsigned int flags;
	u32 limit;
	const struct Qdisc_ops *ops;
	struct qdisc_size_table *stab;
	struct hlist_node hash;
	u32 handle;
	u32 parent;
	struct netdev_queue *dev_queue;
	struct net_rate_estimator *rate_est;
	struct gnet_stats_basic_sync *cpu_bstats;
	struct gnet_stats_queue *cpu_qstats;
	int pad;
	refcount_t refcnt;
	long: 64;
	long: 64;
	long: 64;
	struct sk_buff_head gso_skb;
	struct qdisc_skb_head q;
	struct gnet_stats_basic_sync bstats;
	struct gnet_stats_queue qstats;
	int owner;
	long unsigned int state;
	long unsigned int state2;
	struct Qdisc *next_sched;
	struct sk_buff_head skb_bad_txq;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t busylock;
	spinlock_t seqlock;
	struct callback_head rcu;
	netdevice_tracker dev_tracker;
	struct lock_class_key root_lock_key;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long int privdata[0];
};

struct Qdisc_class_common {
	u32 classid;
	unsigned int filter_cnt;
	struct hlist_node hnode;
};

struct hlist_head;

struct Qdisc_class_hash {
	struct hlist_head *hash;
	unsigned int hashsize;
	unsigned int hashmask;
	unsigned int hashelems;
};

struct tcmsg;

struct netlink_ext_ack;

struct nlattr;

struct qdisc_walker;

struct tcf_block;

struct gnet_dump;

struct Qdisc_class_ops {
	unsigned int flags;
	struct netdev_queue * (*select_queue)(struct Qdisc *, struct tcmsg *);
	int (*graft)(struct Qdisc *, long unsigned int, struct Qdisc *, struct Qdisc **, struct netlink_ext_ack *);
	struct Qdisc * (*leaf)(struct Qdisc *, long unsigned int);
	void (*qlen_notify)(struct Qdisc *, long unsigned int);
	long unsigned int (*find)(struct Qdisc *, u32);
	int (*change)(struct Qdisc *, u32, u32, struct nlattr **, long unsigned int *, struct netlink_ext_ack *);
	int (*delete)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	void (*walk)(struct Qdisc *, struct qdisc_walker *);
	struct tcf_block * (*tcf_block)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	long unsigned int (*bind_tcf)(struct Qdisc *, long unsigned int, u32);
	void (*unbind_tcf)(struct Qdisc *, long unsigned int);
	int (*dump)(struct Qdisc *, long unsigned int, struct sk_buff *, struct tcmsg *);
	int (*dump_stats)(struct Qdisc *, long unsigned int, struct gnet_dump *);
};

struct module;

struct Qdisc_ops {
	struct Qdisc_ops *next;
	const struct Qdisc_class_ops *cl_ops;
	char id[16];
	int priv_size;
	unsigned int static_flags;
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	struct sk_buff * (*peek)(struct Qdisc *);
	int (*init)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*reset)(struct Qdisc *);
	void (*destroy)(struct Qdisc *);
	int (*change)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*attach)(struct Qdisc *);
	int (*change_tx_queue_len)(struct Qdisc *, unsigned int);
	void (*change_real_num_tx)(struct Qdisc *, unsigned int);
	int (*dump)(struct Qdisc *, struct sk_buff *);
	int (*dump_stats)(struct Qdisc *, struct gnet_dump *);
	void (*ingress_block_set)(struct Qdisc *, u32);
	void (*egress_block_set)(struct Qdisc *, u32);
	u32 (*ingress_block_get)(struct Qdisc *);
	u32 (*egress_block_get)(struct Qdisc *);
	struct module *owner;
};

struct kref {
	refcount_t refcount;
};

struct swait_queue_head {
	raw_spinlock_t lock;
	struct list_head task_list;
};

struct completion {
	unsigned int done;
	struct swait_queue_head wait;
};

struct blk_mq_queue_map {
	unsigned int *mq_map;
	unsigned int nr_queues;
	unsigned int queue_offset;
};

struct blk_mq_ops;

struct blk_mq_tags;

struct blk_mq_tag_set {
	const struct blk_mq_ops *ops;
	struct blk_mq_queue_map map[3];
	unsigned int nr_maps;
	unsigned int nr_hw_queues;
	unsigned int queue_depth;
	unsigned int reserved_tags;
	unsigned int cmd_size;
	int numa_node;
	unsigned int timeout;
	unsigned int flags;
	void *driver_data;
	struct blk_mq_tags **tags;
	struct blk_mq_tags *shared_tags;
	struct mutex tag_list_lock;
	struct list_head tag_list;
	struct srcu_struct *srcu;
	struct rw_semaphore update_nr_hwq_lock;
};

struct kset;

struct kobj_type;

struct kernfs_node;

struct kobject {
	const char *name;
	struct list_head entry;
	struct kobject *parent;
	struct kset *kset;
	const struct kobj_type *ktype;
	struct kernfs_node *sd;
	struct kref kref;
	unsigned int state_initialized: 1;
	unsigned int state_in_sysfs: 1;
	unsigned int state_add_uevent_sent: 1;
	unsigned int state_remove_uevent_sent: 1;
	unsigned int uevent_suppress: 1;
};

struct dev_links_info {
	struct list_head suppliers;
	struct list_head consumers;
	struct list_head defer_sync;
	enum dl_dev_state status;
};

struct pm_message {
	int event;
};

typedef struct pm_message pm_message_t;

struct rb_node {
	long unsigned int __rb_parent_color;
	struct rb_node *rb_right;
	struct rb_node *rb_left;
};

struct timerqueue_node {
	struct rb_node node;
	ktime_t expires;
};

struct hrtimer_clock_base;

struct hrtimer {
	struct timerqueue_node node;
	ktime_t _softexpires;
	enum hrtimer_restart (*function)(struct hrtimer *);
	struct hrtimer_clock_base *base;
	u8 state;
	u8 is_rel;
	u8 is_soft;
	u8 is_hard;
};

struct work_struct;

typedef void (*work_func_t)(struct work_struct *);

struct work_struct {
	atomic_long_t data;
	struct list_head entry;
	work_func_t func;
};

struct wakeup_source;

struct wake_irq;

struct pm_subsys_data;

struct dev_pm_qos;

struct dev_pm_info {
	pm_message_t power_state;
	bool can_wakeup: 1;
	bool async_suspend: 1;
	bool in_dpm_list: 1;
	bool is_prepared: 1;
	bool is_suspended: 1;
	bool is_noirq_suspended: 1;
	bool is_late_suspended: 1;
	bool no_pm: 1;
	bool early_init: 1;
	bool direct_complete: 1;
	u32 driver_flags;
	spinlock_t lock;
	struct list_head entry;
	struct completion completion;
	struct wakeup_source *wakeup;
	bool wakeup_path: 1;
	bool syscore: 1;
	bool no_pm_callbacks: 1;
	bool work_in_progress: 1;
	bool smart_suspend: 1;
	bool must_resume: 1;
	bool may_skip_resume: 1;
	bool strict_midlayer: 1;
	struct hrtimer suspend_timer;
	u64 timer_expires;
	struct work_struct work;
	wait_queue_head_t wait_queue;
	struct wake_irq *wakeirq;
	atomic_t usage_count;
	atomic_t child_count;
	unsigned int disable_depth: 3;
	bool idle_notification: 1;
	bool request_pending: 1;
	bool deferred_resume: 1;
	bool needs_force_resume: 1;
	bool runtime_auto: 1;
	bool ignore_children: 1;
	bool no_callbacks: 1;
	bool irq_safe: 1;
	bool use_autosuspend: 1;
	bool timer_autosuspends: 1;
	bool memalloc_noio: 1;
	unsigned int links_count;
	enum rpm_request request;
	enum rpm_status runtime_status;
	enum rpm_status last_status;
	int runtime_error;
	int autosuspend_delay;
	u64 last_busy;
	u64 active_time;
	u64 suspended_time;
	u64 accounting_timestamp;
	struct pm_subsys_data *subsys_data;
	void (*set_latency_tolerance)(struct device *, s32);
	struct dev_pm_qos *qos;
	bool detach_power_off: 1;
};

struct irq_domain;

struct msi_device_data;

struct dev_msi_info {
	struct irq_domain *domain;
	struct msi_device_data *data;
};

struct dev_archdata {};

struct device_private;

struct device_type;

struct bus_type;

struct device_driver;

struct dev_pm_domain;

struct em_perf_domain;

struct dev_pin_info;

struct dma_map_ops;

struct bus_dma_region;

struct device_dma_parameters;

struct cma;

struct io_tlb_mem;

struct device_node;

struct fwnode_handle;

struct class;

struct attribute_group;

struct iommu_group;

struct dev_iommu;

struct device_physical_location;

struct device {
	struct kobject kobj;
	struct device *parent;
	struct device_private *p;
	const char *init_name;
	const struct device_type *type;
	const struct bus_type *bus;
	struct device_driver *driver;
	void *platform_data;
	void *driver_data;
	struct mutex mutex;
	struct dev_links_info links;
	struct dev_pm_info power;
	struct dev_pm_domain *pm_domain;
	struct em_perf_domain *em_pd;
	struct dev_pin_info *pins;
	struct dev_msi_info msi;
	const struct dma_map_ops *dma_ops;
	u64 *dma_mask;
	u64 coherent_dma_mask;
	u64 bus_dma_limit;
	const struct bus_dma_region *dma_range_map;
	struct device_dma_parameters *dma_parms;
	struct list_head dma_pools;
	struct cma *cma_area;
	struct io_tlb_mem *dma_io_tlb_mem;
	struct dev_archdata archdata;
	struct device_node *of_node;
	struct fwnode_handle *fwnode;
	int numa_node;
	dev_t devt;
	u32 id;
	spinlock_t devres_lock;
	struct list_head devres_head;
	const struct class *class;
	const struct attribute_group **groups;
	void (*release)(struct device *);
	struct iommu_group *iommu_group;
	struct dev_iommu *iommu;
	struct device_physical_location *physical_location;
	enum device_removable removable;
	bool offline_disabled: 1;
	bool offline: 1;
	bool of_node_reused: 1;
	bool state_synced: 1;
	bool can_match: 1;
	bool dma_skip_sync: 1;
	bool dma_iommu: 1;
};

struct scsi_host_template;

struct scsi_transport_template;

struct workqueue_struct;

struct Scsi_Host {
	struct list_head __devices;
	struct list_head __targets;
	struct list_head starved_list;
	spinlock_t default_lock;
	spinlock_t *host_lock;
	struct mutex scan_mutex;
	struct list_head eh_abort_list;
	struct list_head eh_cmd_q;
	struct task_struct *ehandler;
	struct completion *eh_action;
	wait_queue_head_t host_wait;
	const struct scsi_host_template *hostt;
	struct scsi_transport_template *transportt;
	struct kref tagset_refcnt;
	struct completion tagset_freed;
	struct blk_mq_tag_set tag_set;
	atomic_t host_blocked;
	unsigned int host_failed;
	unsigned int host_eh_scheduled;
	unsigned int host_no;
	int eh_deadline;
	long unsigned int last_reset;
	unsigned int max_channel;
	unsigned int max_id;
	u64 max_lun;
	unsigned int unique_id;
	short unsigned int max_cmd_len;
	int this_id;
	int can_queue;
	short int cmd_per_lun;
	short unsigned int sg_tablesize;
	short unsigned int sg_prot_tablesize;
	unsigned int max_sectors;
	unsigned int opt_sectors;
	unsigned int max_segment_size;
	unsigned int dma_alignment;
	long unsigned int dma_boundary;
	long unsigned int virt_boundary_mask;
	unsigned int nr_hw_queues;
	unsigned int nr_maps;
	unsigned int active_mode: 2;
	unsigned int host_self_blocked: 1;
	unsigned int reverse_ordering: 1;
	unsigned int tmf_in_progress: 1;
	unsigned int async_scan: 1;
	unsigned int eh_noresume: 1;
	unsigned int no_write_same: 1;
	unsigned int host_tagset: 1;
	unsigned int queuecommand_may_block: 1;
	unsigned int short_inquiry: 1;
	unsigned int no_scsi2_lun_in_cdb: 1;
	struct workqueue_struct *work_q;
	struct workqueue_struct *tmf_work_q;
	unsigned int max_host_blocked;
	unsigned int prot_capabilities;
	unsigned char prot_guard_type;
	long unsigned int base;
	long unsigned int io_port;
	unsigned char n_io_port;
	unsigned char dma_channel;
	unsigned int irq;
	enum scsi_host_state shost_state;
	struct device shost_gendev;
	struct device shost_dev;
	void *shost_data;
	struct device *dma_dev;
	int rpm_autosuspend_delay;
	long unsigned int hostdata[0];
};

struct SeqDef_s {
	U32 offBase;
	U16 litLength;
	U16 mlBase;
};

typedef size_t (*ZSTD_sequenceProducer_F)(void *, ZSTD_Sequence *, size_t, const void *, size_t, const void *, size_t, int, size_t);

struct ZSTD_CCtx_params_s {
	ZSTD_format_e format;
	ZSTD_compressionParameters cParams;
	ZSTD_frameParameters fParams;
	int compressionLevel;
	int forceWindow;
	size_t targetCBlockSize;
	int srcSizeHint;
	ZSTD_dictAttachPref_e attachDictPref;
	ZSTD_ParamSwitch_e literalCompressionMode;
	int nbWorkers;
	size_t jobSize;
	int overlapLog;
	int rsyncable;
	ldmParams_t ldmParams;
	int enableDedicatedDictSearch;
	ZSTD_bufferMode_e inBufferMode;
	ZSTD_bufferMode_e outBufferMode;
	ZSTD_SequenceFormat_e blockDelimiters;
	int validateSequences;
	ZSTD_ParamSwitch_e postBlockSplitter;
	int preBlockSplitter_level;
	size_t maxBlockSize;
	ZSTD_ParamSwitch_e useRowMatchFinder;
	int deterministicRefPrefix;
	ZSTD_customMem customMem;
	ZSTD_ParamSwitch_e prefetchCDictTables;
	int enableMatchFinderFallback;
	void *extSeqProdState;
	ZSTD_sequenceProducer_F extSeqProdFunc;
	ZSTD_ParamSwitch_e searchForExternalRepcodes;
};

typedef struct ZSTD_CCtx_params_s ZSTD_CCtx_params;

struct xxh64_state {
	uint64_t total_len;
	uint64_t v1;
	uint64_t v2;
	uint64_t v3;
	uint64_t v4;
	uint64_t mem64[4];
	uint32_t memsize;
};

struct POOL_ctx_s;

typedef struct POOL_ctx_s ZSTD_threadPool;

struct ZSTD_inBuffer_s {
	const void *src;
	size_t size;
	size_t pos;
};

typedef struct ZSTD_inBuffer_s ZSTD_inBuffer;

struct ZSTD_prefixDict_s {
	const void *dict;
	size_t dictSize;
	ZSTD_dictContentType_e dictContentType;
};

typedef struct ZSTD_prefixDict_s ZSTD_prefixDict;

struct ZSTD_CCtx_s {
	ZSTD_compressionStage_e stage;
	int cParamsChanged;
	int bmi2;
	ZSTD_CCtx_params requestedParams;
	ZSTD_CCtx_params appliedParams;
	ZSTD_CCtx_params simpleApiParams;
	U32 dictID;
	size_t dictContentSize;
	ZSTD_cwksp workspace;
	size_t blockSizeMax;
	long long unsigned int pledgedSrcSizePlusOne;
	long long unsigned int consumedSrcSize;
	long long unsigned int producedCSize;
	struct xxh64_state xxhState;
	ZSTD_customMem customMem;
	ZSTD_threadPool *pool;
	size_t staticSize;
	SeqCollector seqCollector;
	int isFirstBlock;
	int initialized;
	SeqStore_t seqStore;
	ldmState_t ldmState;
	rawSeq *ldmSequences;
	size_t maxNbLdmSequences;
	RawSeqStore_t externSeqStore;
	ZSTD_blockState_t blockState;
	void *tmpWorkspace;
	size_t tmpWkspSize;
	ZSTD_buffered_policy_e bufferedPolicy;
	char *inBuff;
	size_t inBuffSize;
	size_t inToCompress;
	size_t inBuffPos;
	size_t inBuffTarget;
	char *outBuff;
	size_t outBuffSize;
	size_t outBuffContentSize;
	size_t outBuffFlushedSize;
	ZSTD_cStreamStage streamStage;
	U32 frameEnded;
	ZSTD_inBuffer expectedInBuffer;
	size_t stableIn_notConsumed;
	size_t expectedOutBufferSize;
	ZSTD_localDict localDict;
	const ZSTD_CDict *cdict;
	ZSTD_prefixDict prefixDict;
	ZSTD_blockSplitCtx blockSplitCtx;
	ZSTD_Sequence *extSeqBuf;
	size_t extSeqBufCapacity;
};

typedef struct ZSTD_CCtx_s ZSTD_CCtx;

typedef ZSTD_CCtx ZSTD_CStream;

typedef ZSTD_CCtx zstd_cctx;

typedef ZSTD_CStream zstd_cstream;

struct ZSTD_CDict_s {
	const void *dictContent;
	size_t dictContentSize;
	ZSTD_dictContentType_e dictContentType;
	U32 *entropyWorkspace;
	ZSTD_cwksp workspace;
	ZSTD_MatchState_t matchState;
	ZSTD_compressedBlockState_t cBlockState;
	ZSTD_customMem customMem;
	U32 dictID;
	int compressionLevel;
	ZSTD_ParamSwitch_e useRowMatchFinder;
};

typedef ZSTD_CDict zstd_cdict;

struct ZSTD_outBuffer_s {
	void *dst;
	size_t size;
	size_t pos;
};

typedef struct ZSTD_outBuffer_s ZSTD_outBuffer;

struct ZSTD_DCtx_s {
	const ZSTD_seqSymbol *LLTptr;
	const ZSTD_seqSymbol *MLTptr;
	const ZSTD_seqSymbol *OFTptr;
	const HUF_DTable *HUFptr;
	ZSTD_entropyDTables_t entropy;
	U32 workspace[640];
	const void *previousDstEnd;
	const void *prefixStart;
	const void *virtualStart;
	const void *dictEnd;
	size_t expected;
	ZSTD_FrameHeader fParams;
	U64 processedCSize;
	U64 decodedSize;
	blockType_e bType;
	ZSTD_dStage stage;
	U32 litEntropy;
	U32 fseEntropy;
	struct xxh64_state xxhState;
	size_t headerSize;
	ZSTD_format_e format;
	ZSTD_forceIgnoreChecksum_e forceIgnoreChecksum;
	U32 validateChecksum;
	const BYTE *litPtr;
	ZSTD_customMem customMem;
	size_t litSize;
	size_t rleSize;
	size_t staticSize;
	int isFrameDecompression;
	int bmi2;
	ZSTD_DDict *ddictLocal;
	const ZSTD_DDict *ddict;
	U32 dictID;
	int ddictIsCold;
	ZSTD_dictUses_e dictUses;
	ZSTD_DDictHashSet *ddictSet;
	ZSTD_refMultipleDDicts_e refMultipleDDicts;
	int disableHufAsm;
	int maxBlockSizeParam;
	ZSTD_dStreamStage streamStage;
	char *inBuff;
	size_t inBuffSize;
	size_t inPos;
	size_t maxWindowSize;
	char *outBuff;
	size_t outBuffSize;
	size_t outStart;
	size_t outEnd;
	size_t lhSize;
	U32 hostageByte;
	int noForwardProgress;
	ZSTD_bufferMode_e outBufferMode;
	ZSTD_outBuffer expectedOutBuffer;
	BYTE *litBuffer;
	const BYTE *litBufferEnd;
	ZSTD_litLocation_e litBufferLocation;
	BYTE litExtraBuffer[65568];
	BYTE headerBuffer[18];
	size_t oversizedDuration;
};

typedef struct ZSTD_DCtx_s ZSTD_DCtx;

typedef ZSTD_DCtx ZSTD_DStream;

typedef ZSTD_DCtx zstd_dctx;

typedef ZSTD_DStream zstd_dstream;

struct ZSTD_DDict_s {
	void *dictBuffer;
	const void *dictContent;
	size_t dictSize;
	ZSTD_entropyDTables_t entropy;
	U32 dictID;
	U32 entropyPresent;
	ZSTD_customMem cMem;
};

typedef ZSTD_DDict zstd_ddict;

typedef ZSTD_inBuffer zstd_in_buffer;

typedef ZSTD_outBuffer zstd_out_buffer;

struct __aio_sigset {
	const sigset_t *sigmask;
	size_t sigsetsize;
};

struct fred_cs {
	u64 cs: 16;
	u64 sl: 2;
	u64 wfe: 1;
};

struct fred_ss {
	u64 ss: 16;
	u64 sti: 1;
	u64 swevent: 1;
	u64 nmi: 1;
	int: 13;
	u64 vector: 8;
	short: 8;
	u64 type: 4;
	char: 4;
	u64 enclave: 1;
	u64 lm: 1;
	u64 nested: 1;
	char: 1;
	u64 insnlen: 4;
};

struct pt_regs {
	long unsigned int r15;
	long unsigned int r14;
	long unsigned int r13;
	long unsigned int r12;
	long unsigned int bp;
	long unsigned int bx;
	long unsigned int r11;
	long unsigned int r10;
	long unsigned int r9;
	long unsigned int r8;
	long unsigned int ax;
	long unsigned int cx;
	long unsigned int dx;
	long unsigned int si;
	long unsigned int di;
	long unsigned int orig_ax;
	long unsigned int ip;
	union {
		u16 cs;
		u64 csx;
		struct fred_cs fred_cs;
	};
	long unsigned int flags;
	long unsigned int sp;
	union {
		u16 ss;
		u64 ssx;
		struct fred_ss fred_ss;
	};
};

struct __arch_ftrace_regs {
	struct pt_regs regs;
};

struct __arch_relative_insn {
	u8 op;
	s32 raddr;
} __attribute__((packed));

struct llist_node {
	struct llist_node *next;
};

struct __call_single_node {
	struct llist_node llist;
	union {
		unsigned int u_flags;
		atomic_t a_flags;
	};
	u16 src;
	u16 dst;
};

typedef void (*smp_call_func_t)(void *);

struct __call_single_data {
	struct __call_single_node node;
	smp_call_func_t func;
	void *info;
};

typedef struct __call_single_data call_single_data_t;

struct idr;

struct __class_idr {
	struct idr *idr;
	int id;
};

typedef struct __class_idr class_idr_alloc_t;

struct cpumask;

struct __cmp_key {
	const struct cpumask *cpus;
	struct cpumask ***masks;
	int node;
	int cpu;
	int w;
};

struct __compat_aio_sigset {
	compat_uptr_t sigmask;
	compat_size_t sigsetsize;
};

struct __compat_iw_event {
	__u16 len;
	__u16 cmd;
	union {
		compat_caddr_t pointer;
		struct {
			struct {} __empty_ptr_bytes;
			__u8 ptr_bytes[0];
		};
	};
};

struct drm_connector;

struct drm_connector_state;

struct __drm_connnectors_state {
	struct drm_connector *ptr;
	struct drm_connector_state *state;
	struct drm_connector_state *old_state;
	struct drm_connector_state *new_state;
	s32 *out_fence_ptr;
};

struct drm_crtc;

struct drm_crtc_state;

struct drm_crtc_commit;

struct __drm_crtcs_state {
	struct drm_crtc *ptr;
	struct drm_crtc_state *state;
	struct drm_crtc_state *old_state;
	struct drm_crtc_state *new_state;
	struct drm_crtc_commit *commit;
	s32 *out_fence_ptr;
	u64 last_vblank_count;
};

struct drm_plane;

struct drm_plane_state;

struct __drm_planes_state {
	struct drm_plane *ptr;
	struct drm_plane_state *state;
	struct drm_plane_state *old_state;
	struct drm_plane_state *new_state;
};

struct drm_private_obj;

struct drm_private_state;

struct __drm_private_objs_state {
	struct drm_private_obj *ptr;
	struct drm_private_state *state;
	struct drm_private_state *old_state;
	struct drm_private_state *new_state;
};

struct __extcon_info {
	unsigned int type;
	unsigned int id;
	const char *name;
};

struct tracepoint;

struct __find_tracepoint_cb_data {
	const char *tp_name;
	struct tracepoint *tpoint;
	struct module *mod;
};

struct genradix_root;

struct __genradix {
	struct genradix_root *root;
};

struct pmu;

struct cgroup;

struct __group_key {
	int cpu;
	struct pmu *pmu;
	struct cgroup *cgroup;
};

struct sha256_block_state {
	u32 h[8];
};

struct __sha256_ctx {
	struct sha256_block_state state;
	u64 bytecount;
	u8 buf[64];
};

struct __hmac_sha256_ctx {
	struct __sha256_ctx sha_ctx;
	struct sha256_block_state ostate;
};

struct __hmac_sha256_key {
	struct sha256_block_state istate;
	struct sha256_block_state ostate;
};

struct sha512_block_state {
	u64 h[8];
};

struct __sha512_ctx {
	struct sha512_block_state state;
	u64 bytecount_lo;
	u64 bytecount_hi;
	u8 buf[128];
};

struct __hmac_sha512_ctx {
	struct __sha512_ctx sha_ctx;
	struct sha512_block_state ostate;
};

struct __hmac_sha512_key {
	struct sha512_block_state istate;
	struct sha512_block_state ostate;
};

struct __ip6_tnl_parm {
	char name[16];
	int link;
	__u8 proto;
	__u8 encap_limit;
	__u8 hop_limit;
	bool collect_md;
	__be32 flowinfo;
	__u32 flags;
	struct in6_addr laddr;
	struct in6_addr raddr;
	long unsigned int i_flags[1];
	long unsigned int o_flags[1];
	__be32 i_key;
	__be32 o_key;
	__u32 fwmark;
	__u32 index;
	__u8 erspan_ver;
	__u8 dir;
	__u16 hwid;
};

struct __kernel_timespec {
	__kernel_time64_t tv_sec;
	long long int tv_nsec;
};

struct __kernel_itimerspec {
	struct __kernel_timespec it_interval;
	struct __kernel_timespec it_value;
};

struct __kernel_old_timeval {
	__kernel_long_t tv_sec;
	__kernel_long_t tv_usec;
};

struct __kernel_old_itimerval {
	struct __kernel_old_timeval it_interval;
	struct __kernel_old_timeval it_value;
};

struct __kernel_old_timespec {
	__kernel_old_time_t tv_sec;
	long int tv_nsec;
};

struct __kernel_sock_timeval {
	__s64 tv_sec;
	__s64 tv_usec;
};

struct __kernel_sockaddr_storage {
	union {
		struct {
			__kernel_sa_family_t ss_family;
			char __data[126];
		};
		void *__align;
	};
};

struct __kernel_timex_timeval {
	__kernel_time64_t tv_sec;
	long long int tv_usec;
};

struct __kernel_timex {
	unsigned int modes;
	long long int offset;
	long long int freq;
	long long int maxerror;
	long long int esterror;
	int status;
	long long int constant;
	long long int precision;
	long long int tolerance;
	struct __kernel_timex_timeval time;
	long long int tick;
	long long int ppsfreq;
	long long int jitter;
	int shift;
	long long int stabil;
	long long int jitcnt;
	long long int calcnt;
	long long int errcnt;
	long long int stbcnt;
	int tai;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct __kfifo {
	unsigned int in;
	unsigned int out;
	unsigned int mask;
	unsigned int esize;
	void *data;
};

struct __large_struct {
	long unsigned int buf[100];
};

struct __old_kernel_stat {
	short unsigned int st_dev;
	short unsigned int st_ino;
	short unsigned int st_mode;
	short unsigned int st_nlink;
	short unsigned int st_uid;
	short unsigned int st_gid;
	short unsigned int st_rdev;
	unsigned int st_size;
	unsigned int st_atime;
	unsigned int st_mtime;
	unsigned int st_ctime;
};

struct __pldm_timestamp {
	u8 b[13];
};

struct __pldm_header {
	uuid_t id;
	u8 revision;
	__le16 size;
	struct __pldm_timestamp release_date;
	__le16 component_bitmap_len;
	u8 version_type;
	u8 version_len;
	u8 version_string[0];
} __attribute__((packed));

struct __pldmfw_component_area {
	__le16 component_image_count;
	u8 components[0];
};

struct __pldmfw_component_info {
	__le16 classification;
	__le16 identifier;
	__le32 comparison_stamp;
	__le16 options;
	__le16 activation_method;
	__le32 location_offset;
	__le32 size;
	u8 version_type;
	u8 version_len;
	u8 version_string[0];
} __attribute__((packed));

struct __pldmfw_desc_tlv {
	__le16 type;
	__le16 size;
	u8 data[0];
};

struct __pldmfw_record_area {
	u8 record_count;
	u8 records[0];
};

struct __pldmfw_record_info {
	__le16 record_len;
	u8 descriptor_count;
	__le32 device_update_flags;
	u8 version_type;
	u8 version_len;
	__le16 package_data_len;
	u8 variable_record_data[0];
} __attribute__((packed));

struct net_device;

struct __rt6_probe_work {
	struct work_struct work;
	struct in6_addr target;
	struct net_device *dev;
	netdevice_tracker dev_tracker;
};

union sigval {
	int sival_int;
	void *sival_ptr;
};

typedef union sigval sigval_t;

union __sifields {
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
	} _kill;
	struct {
		__kernel_timer_t _tid;
		int _overrun;
		sigval_t _sigval;
		int _sys_private;
	} _timer;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		sigval_t _sigval;
	} _rt;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		int _status;
		__kernel_clock_t _utime;
		__kernel_clock_t _stime;
	} _sigchld;
	struct {
		void *_addr;
		union {
			int _trapno;
			short int _addr_lsb;
			struct {
				char _dummy_bnd[8];
				void *_lower;
				void *_upper;
			} _addr_bnd;
			struct {
				char _dummy_pkey[8];
				__u32 _pkey;
			} _addr_pkey;
			struct {
				long unsigned int _data;
				__u32 _type;
				__u32 _flags;
			} _perf;
		};
	} _sigfault;
	struct {
		long int _band;
		int _fd;
	} _sigpoll;
	struct {
		void *_call_addr;
		int _syscall;
		unsigned int _arch;
	} _sigsys;
};

struct bpf_flow_keys;

struct bpf_sock;

struct __sk_buff {
	__u32 len;
	__u32 pkt_type;
	__u32 mark;
	__u32 queue_mapping;
	__u32 protocol;
	__u32 vlan_present;
	__u32 vlan_tci;
	__u32 vlan_proto;
	__u32 priority;
	__u32 ingress_ifindex;
	__u32 ifindex;
	__u32 tc_index;
	__u32 cb[5];
	__u32 hash;
	__u32 tc_classid;
	__u32 data;
	__u32 data_end;
	__u32 napi_id;
	__u32 family;
	__u32 remote_ip4;
	__u32 local_ip4;
	__u32 remote_ip6[4];
	__u32 local_ip6[4];
	__u32 remote_port;
	__u32 local_port;
	__u32 data_meta;
	union {
		struct bpf_flow_keys *flow_keys;
	};
	__u64 tstamp;
	__u32 wire_len;
	__u32 gso_segs;
	union {
		struct bpf_sock *sk;
	};
	__u32 gso_size;
	__u8 tstamp_type;
	__u64 hwtstamp;
};

union __u128_halves {
	u128 full;
	struct {
		u64 low;
		u64 high;
	};
};

struct inode;

struct __uprobe_key {
	struct inode *inode;
	loff_t offset;
};

struct __user_cap_data_struct {
	__u32 effective;
	__u32 permitted;
	__u32 inheritable;
};

typedef struct __user_cap_data_struct *cap_user_data_t;

struct __user_cap_header_struct {
	__u32 version;
	int pid;
};

typedef struct __user_cap_header_struct *cap_user_header_t;

struct __va_list_tag {
	unsigned int gp_offset;
	unsigned int fp_offset;
	void *overflow_arg_area;
	void *reg_save_area;
};

typedef __builtin_va_list va_list;

struct _bpf_dtab_netdev {
	struct net_device *dev;
};

union _cpuid4_leaf_eax {
	struct {
		enum _cache_type type: 5;
		unsigned int level: 3;
		unsigned int is_self_initializing: 1;
		unsigned int is_fully_associative: 1;
		unsigned int reserved: 4;
		unsigned int num_threads_sharing: 12;
		unsigned int num_cores_on_die: 6;
	} split;
	u32 full;
};

union _cpuid4_leaf_ebx {
	struct {
		unsigned int coherency_line_size: 12;
		unsigned int physical_line_partition: 10;
		unsigned int ways_of_associativity: 10;
	} split;
	u32 full;
};

union _cpuid4_leaf_ecx {
	struct {
		unsigned int number_of_sets: 32;
	} split;
	u32 full;
};

struct _cpuid4_info {
	union _cpuid4_leaf_eax eax;
	union _cpuid4_leaf_ebx ebx;
	union _cpuid4_leaf_ecx ecx;
	unsigned int id;
	long unsigned int size;
};

struct jump_entry;

struct static_key_mod;

struct static_key {
	atomic_t enabled;
	union {
		long unsigned int type;
		struct jump_entry *entries;
		struct static_key_mod *next;
	};
};

struct static_key_true {
	struct static_key key;
};

struct static_key_false {
	struct static_key key;
};

struct _ddebug {
	const char *modname;
	const char *function;
	const char *filename;
	const char *format;
	unsigned int lineno: 18;
	unsigned int class_id: 6;
	unsigned int flags: 8;
	union {
		struct static_key_true dd_key_true;
		struct static_key_false dd_key_false;
	} key;
};

struct ddebug_class_map;

struct _ddebug_info {
	struct _ddebug *descs;
	struct ddebug_class_map *classes;
	unsigned int num_descs;
	unsigned int num_classes;
};

struct _flow_keys_digest_data {
	__be16 n_proto;
	u8 ip_proto;
	u8 padding;
	__be32 ports;
	__be32 src;
	__be32 dst;
};

struct _fpreg {
	__u16 significand[4];
	__u16 exponent;
};

struct _fpxreg {
	__u16 significand[4];
	__u16 exponent;
	__u16 padding[3];
};

struct _xmmreg {
	__u32 element[4];
};

struct _fpx_sw_bytes {
	__u32 magic1;
	__u32 extended_size;
	__u64 xfeatures;
	__u32 xstate_size;
	__u32 padding[7];
};

struct _fpstate_32 {
	__u32 cw;
	__u32 sw;
	__u32 tag;
	__u32 ipoff;
	__u32 cssel;
	__u32 dataoff;
	__u32 datasel;
	struct _fpreg _st[8];
	__u16 status;
	__u16 magic;
	__u32 _fxsr_env[6];
	__u32 mxcsr;
	__u32 reserved;
	struct _fpxreg _fxsr_st[8];
	struct _xmmreg _xmm[8];
	union {
		__u32 padding1[44];
		__u32 padding[44];
	};
	union {
		__u32 padding2[12];
		struct _fpx_sw_bytes sw_reserved;
	};
};

struct _gpiochip_for_each_data {
	const char **label;
	unsigned int *i;
};

typedef struct _gpiochip_for_each_data class__gpiochip_for_each_data_t;

struct _gpt_entry_attributes {
	u64 required_to_function: 1;
	u64 reserved: 47;
	u64 type_guid_specific: 16;
};

typedef struct _gpt_entry_attributes gpt_entry_attributes;

struct _gpt_entry {
	efi_guid_t partition_type_guid;
	efi_guid_t unique_partition_guid;
	__le64 starting_lba;
	__le64 ending_lba;
	gpt_entry_attributes attributes;
	__le16 partition_name[36];
};

typedef struct _gpt_entry gpt_entry;

struct _gpt_header {
	__le64 signature;
	__le32 revision;
	__le32 header_size;
	__le32 header_crc32;
	__le32 reserved1;
	__le64 my_lba;
	__le64 alternate_lba;
	__le64 first_usable_lba;
	__le64 last_usable_lba;
	efi_guid_t disk_guid;
	__le64 partition_entry_lba;
	__le32 num_partition_entries;
	__le32 sizeof_partition_entry;
	__le32 partition_entry_array_crc32;
} __attribute__((packed));

typedef struct _gpt_header gpt_header;

struct _gpt_mbr_record {
	u8 boot_indicator;
	u8 start_head;
	u8 start_sector;
	u8 start_track;
	u8 os_type;
	u8 end_head;
	u8 end_sector;
	u8 end_track;
	__le32 starting_lba;
	__le32 size_in_lba;
};

typedef struct _gpt_mbr_record gpt_mbr_record;

struct kvm_stats_desc {
	__u32 flags;
	__s16 exponent;
	__u16 size;
	__u32 offset;
	__u32 bucket_size;
	char name[0];
};

struct _kvm_stats_desc {
	struct kvm_stats_desc desc;
	char name[48];
};

struct _legacy_mbr {
	u8 boot_code[440];
	__le32 unique_mbr_signature;
	__le16 unknown;
	gpt_mbr_record partition_record[4];
	__le16 signature;
} __attribute__((packed));

typedef struct _legacy_mbr legacy_mbr;

struct strp_msg {
	int full_len;
	int offset;
};

struct _strp_msg {
	struct strp_msg strp;
	int accum_len;
};

struct delayed_work {
	struct work_struct work;
	struct timer_list timer;
	struct workqueue_struct *wq;
	int cpu;
};

struct _thermal_state {
	u64 next_check;
	u64 last_interrupt_time;
	struct delayed_work therm_work;
	long unsigned int count;
	long unsigned int last_count;
	long unsigned int max_time_ms;
	long unsigned int total_time_ms;
	bool rate_control_active;
	bool new_event;
	u8 level;
	u8 sample_index;
	u8 sample_count;
	u8 average;
	u8 baseline_temp;
	u8 temp_samples[3];
};

struct aa_policydb;

struct aa_attachment {
	const char *xmatch_str;
	struct aa_policydb *xmatch;
	unsigned int xmatch_len;
	int xattr_count;
	char **xattrs;
};

struct aa_label;

struct aa_audit_rule {
	struct aa_label *label;
};

union aa_buffer {
	struct list_head list;
	struct {
		struct {} __empty_buffer;
		char buffer[0];
	};
};

struct aa_caps {
	kernel_cap_t allow;
	kernel_cap_t audit;
	kernel_cap_t denied;
	kernel_cap_t quiet;
	kernel_cap_t kill;
	kernel_cap_t extended;
};

struct rhash_head {
	struct rhash_head *next;
};

struct aa_data {
	char *key;
	u32 size;
	char *data;
	struct rhash_head head;
};

struct table_header;

struct aa_dfa {
	struct kref count;
	u16 flags;
	u32 max_oob;
	struct table_header *tables[8];
};

struct aa_ext {
	void *start;
	void *end;
	void *pos;
	u32 version;
};

struct aa_file_ctx {
	spinlock_t lock;
	struct aa_label *label;
	u32 allow;
};

struct aa_proxy;

struct aa_profile;

struct aa_ruleset;

struct aa_label {
	struct kref count;
	struct rb_node node;
	struct callback_head rcu;
	struct aa_proxy *proxy;
	char *hname;
	long int flags;
	u32 secid;
	int size;
	u64 mediates;
	union {
		struct {
			struct aa_profile *profile[2];
			struct {
				struct {} __empty_rules;
				struct aa_ruleset *rules[0];
			};
		};
		struct {
			struct {} __empty_vec;
			struct aa_profile *vec[0];
		};
	};
};

struct rb_root {
	struct rb_node *rb_node;
};

struct aa_labelset {
	rwlock_t lock;
	struct rb_root root;
};

struct aa_load_ent {
	struct list_head list;
	struct aa_profile *new;
	struct aa_profile *old;
	struct aa_profile *rename;
	const char *ns_name;
};

struct aa_ns;

struct aa_loaddata {
	struct kref count;
	struct list_head list;
	struct work_struct work;
	struct dentry *dents[6];
	struct aa_ns *ns;
	char *name;
	size_t size;
	size_t compressed_size;
	long int revision;
	int abi;
	unsigned char *hash;
	char *data;
};

struct aa_local_cache {
	unsigned int hold;
	unsigned int count;
	struct list_head head;
};

struct aa_policy {
	const char *name;
	char *hname;
	struct list_head list;
	struct list_head profiles;
};

struct aa_ns_acct {
	int max_size;
	int max_count;
	int size;
	int count;
};

struct aa_ns {
	struct aa_policy base;
	struct aa_ns *parent;
	struct mutex lock;
	struct aa_ns_acct acct;
	struct aa_profile *unconfined;
	struct list_head sub_ns;
	atomic_t uniq_null;
	long int uniq_id;
	int level;
	long int revision;
	wait_queue_head_t wait;
	struct aa_labelset labels;
	struct list_head rawdata_list;
	struct dentry *dents[13];
};

struct aa_perms {
	u32 allow;
	u32 deny;
	u32 subtree;
	u32 cond;
	u32 kill;
	u32 complain;
	u32 prompt;
	u32 audit;
	u32 quiet;
	u32 hide;
	u32 xindex;
	u32 tag;
	u32 label;
};

struct aa_str_table {
	int size;
	char **table;
};

struct aa_policydb {
	struct kref count;
	struct aa_dfa *dfa;
	struct {
		struct aa_perms *perms;
		u32 size;
	};
	struct aa_str_table trans;
	unsigned int start[33];
};

struct rhashtable;

struct aa_profile {
	struct aa_policy base;
	struct aa_profile *parent;
	struct aa_ns *ns;
	const char *rename;
	enum audit_mode audit;
	long int mode;
	u32 path_flags;
	int signal;
	const char *disconnected;
	struct aa_attachment attach;
	struct aa_loaddata *rawdata;
	unsigned char *hash;
	char *dirname;
	struct dentry *dents[9];
	struct rhashtable *data;
	int n_rules;
	struct aa_label label;
};

struct aa_proxy {
	struct kref count;
	struct aa_label *label;
};

struct aa_revision {
	struct aa_ns *ns;
	long int last_read;
};

struct rlimit {
	__kernel_ulong_t rlim_cur;
	__kernel_ulong_t rlim_max;
};

struct aa_rlimit {
	unsigned int mask;
	struct rlimit limits[16];
};

struct aa_secmark;

struct aa_ruleset {
	int size;
	struct aa_policydb *policy;
	struct aa_policydb *file;
	struct aa_caps caps;
	struct aa_rlimit rlimits;
	int secmark_count;
	struct aa_secmark *secmark;
};

struct aa_secmark {
	u8 audit;
	u8 deny;
	u32 secid;
	char *label;
};

struct file_operations;

struct aa_sfs_entry {
	const char *name;
	struct dentry *dentry;
	umode_t mode;
	enum aa_sfs_type v_type;
	union {
		bool boolean;
		char *string;
		long unsigned int u64;
		struct aa_sfs_entry *files;
	} v;
	const struct file_operations *file_ops;
};

struct aa_sk_ctx {
	struct aa_label *label;
	struct aa_label *peer;
	struct aa_label *peer_lastupdate;
};

struct aa_task_ctx {
	struct aa_label *nnp;
	struct aa_label *onexec;
	struct aa_label *previous;
	u64 token;
};

struct i2c_client;

struct aat2870_register;

struct aat2870_data {
	struct device *dev;
	struct i2c_client *client;
	struct mutex io_lock;
	struct aat2870_register *reg_cache;
	int en_pin;
	bool is_enable;
	int (*init)(struct aat2870_data *);
	void (*uninit)(struct aat2870_data *);
	int (*read)(struct aat2870_data *, u8, u8 *);
	int (*write)(struct aat2870_data *, u8, u8);
	int (*update)(struct aat2870_data *, u8, u8, u8);
};

struct aat2870_subdev_info;

struct aat2870_platform_data {
	int en_pin;
	struct aat2870_subdev_info *subdevs;
	int num_subdevs;
	int (*init)(struct aat2870_data *);
	void (*uninit)(struct aat2870_data *);
};

struct aat2870_register {
	bool readable;
	bool writeable;
	u8 value;
};

struct aat2870_subdev_info {
	int id;
	const char *name;
	void *platform_data;
};

struct seq_net_private {
	struct net *net;
	netns_tracker ns_tracker;
};

struct ac6_iter_state {
	struct seq_net_private p;
	struct net_device *dev;
};

struct accept_range {
	struct list_head list;
	long unsigned int start;
	long unsigned int end;
};

struct access_coordinate {
	unsigned int read_bandwidth;
	unsigned int write_bandwidth;
	unsigned int read_latency;
	unsigned int write_latency;
};

struct access_masks {
	access_mask_t fs: 16;
	access_mask_t net: 2;
	access_mask_t scope: 2;
};

union access_masks_all {
	struct access_masks masks;
	u32 all;
};

struct access_report_info {
	struct callback_head work;
	const char *access;
	struct task_struct *target;
	struct task_struct *agent;
};

struct acct_v3 {
	char ac_flag;
	char ac_version;
	__u16 ac_tty;
	__u32 ac_exitcode;
	__u32 ac_uid;
	__u32 ac_gid;
	__u32 ac_pid;
	__u32 ac_ppid;
	__u32 ac_btime;
	__u32 ac_etime;
	comp_t ac_utime;
	comp_t ac_stime;
	comp_t ac_mem;
	comp_t ac_io;
	comp_t ac_rw;
	comp_t ac_minflt;
	comp_t ac_majflt;
	comp_t ac_swaps;
	char ac_comm[16];
};

typedef struct acct_v3 acct_t;

struct ack_sample {
	u32 pkts_acked;
	s32 rtt_us;
	u32 in_flight;
};

struct crypto_tfm;

struct cipher_alg {
	unsigned int cia_min_keysize;
	unsigned int cia_max_keysize;
	int (*cia_setkey)(struct crypto_tfm *, const u8 *, unsigned int);
	void (*cia_encrypt)(struct crypto_tfm *, u8 *, const u8 *);
	void (*cia_decrypt)(struct crypto_tfm *, u8 *, const u8 *);
};

struct crypto_type;

struct crypto_alg {
	struct list_head cra_list;
	struct list_head cra_users;
	u32 cra_flags;
	unsigned int cra_blocksize;
	unsigned int cra_ctxsize;
	unsigned int cra_alignmask;
	unsigned int cra_reqsize;
	int cra_priority;
	refcount_t cra_refcnt;
	char cra_name[128];
	char cra_driver_name[128];
	const struct crypto_type *cra_type;
	union {
		struct cipher_alg cipher;
	} cra_u;
	int (*cra_init)(struct crypto_tfm *);
	void (*cra_exit)(struct crypto_tfm *);
	void (*cra_destroy)(struct crypto_alg *);
	struct module *cra_module;
};

struct comp_alg_common {
	struct crypto_alg base;
};

struct acomp_req;

struct crypto_acomp;

struct acomp_alg {
	int (*compress)(struct acomp_req *);
	int (*decompress)(struct acomp_req *);
	int (*init)(struct crypto_acomp *);
	void (*exit)(struct crypto_acomp *);
	union {
		struct {
			struct crypto_alg base;
		};
		struct comp_alg_common calg;
	};
};

typedef void (*crypto_completion_t)(void *, int);

struct crypto_async_request {
	struct list_head list;
	crypto_completion_t complete;
	void *data;
	struct crypto_tfm *tfm;
	u32 flags;
};

struct scatterlist {
	long unsigned int page_link;
	unsigned int offset;
	unsigned int length;
	dma_addr_t dma_address;
	unsigned int dma_length;
	unsigned int dma_flags;
};

struct acomp_req_chain {
	crypto_completion_t compl;
	void *data;
	struct scatterlist ssg;
	struct scatterlist dsg;
	union {
		const u8 *src;
		struct folio *sfolio;
	};
	union {
		u8 *dst;
		struct folio *dfolio;
	};
	u32 flags;
};

struct acomp_req {
	struct crypto_async_request base;
	union {
		struct scatterlist *src;
		const u8 *svirt;
	};
	union {
		struct scatterlist *dst;
		u8 *dvirt;
	};
	unsigned int slen;
	unsigned int dlen;
	struct acomp_req_chain chain;
	void *__ctx[0];
};

union crypto_no_such_thing;

struct scatter_walk {
	union {
		void * const addr;
		union crypto_no_such_thing *__addr;
	};
	struct scatterlist *sg;
	unsigned int offset;
};

struct acomp_walk {
	union {
		struct {
			struct {
				const void * const addr;
			} virt;
		} src;
		struct scatter_walk in;
	};
	union {
		struct {
			struct {
				void * const addr;
			} virt;
		} dst;
		struct scatter_walk out;
	};
	unsigned int slen;
	unsigned int dlen;
	int flags;
};

struct power_supply;

union power_supply_propval;

struct power_supply_desc {
	const char *name;
	enum power_supply_type type;
	u8 charge_behaviours;
	u32 charge_types;
	u32 usb_types;
	const enum power_supply_property *properties;
	size_t num_properties;
	int (*get_property)(struct power_supply *, enum power_supply_property, union power_supply_propval *);
	int (*set_property)(struct power_supply *, enum power_supply_property, const union power_supply_propval *);
	int (*property_is_writeable)(struct power_supply *, enum power_supply_property);
	void (*external_power_changed)(struct power_supply *);
	bool no_thermal;
	int use_for_apm;
};

struct notifier_block;

typedef int (*notifier_fn_t)(struct notifier_block *, long unsigned int, void *);

struct notifier_block {
	notifier_fn_t notifier_call;
	struct notifier_block *next;
	int priority;
};

struct acpi_device;

struct acpi_ac {
	struct power_supply *charger;
	struct power_supply_desc charger_desc;
	struct acpi_device *device;
	long long unsigned int state;
	struct notifier_block battery_nb;
};

struct acpi_address16_attribute {
	u16 granularity;
	u16 minimum;
	u16 maximum;
	u16 translation_offset;
	u16 address_length;
};

struct acpi_address32_attribute {
	u32 granularity;
	u32 minimum;
	u32 maximum;
	u32 translation_offset;
	u32 address_length;
};

struct acpi_address64_attribute {
	u64 granularity;
	u64 minimum;
	u64 maximum;
	u64 translation_offset;
	u64 address_length;
};

struct acpi_namespace_node;

struct acpi_address_range {
	struct acpi_address_range *next;
	struct acpi_namespace_node *region_node;
	acpi_physical_address start_address;
	acpi_physical_address end_address;
};

struct acpi_battery {
	struct mutex lock;
	struct mutex sysfs_lock;
	struct power_supply *bat;
	struct power_supply_desc bat_desc;
	struct acpi_device *device;
	struct notifier_block pm_nb;
	struct list_head list;
	long unsigned int update_time;
	int revision;
	int rate_now;
	int capacity_now;
	int voltage_now;
	int design_capacity;
	int full_charge_capacity;
	int technology;
	int design_voltage;
	int design_capacity_warning;
	int design_capacity_low;
	int cycle_count;
	int measurement_accuracy;
	int max_sampling_time;
	int min_sampling_time;
	int max_averaging_interval;
	int min_averaging_interval;
	int capacity_granularity_1;
	int capacity_granularity_2;
	int alarm;
	char model_number[64];
	char serial_number[64];
	char type[64];
	char oem_info[64];
	int state;
	int power_unit;
	long unsigned int flags;
};

struct acpi_battery_hook {
	const char *name;
	int (*add_battery)(struct power_supply *, struct acpi_battery_hook *);
	int (*remove_battery)(struct power_supply *, struct acpi_battery_hook *);
	struct list_head list;
};

struct acpi_bert_region {
	u32 block_status;
	u32 raw_data_offset;
	u32 raw_data_length;
	u32 data_length;
	u32 error_severity;
};

struct acpi_bit_register_info {
	u8 parent_register;
	u8 bit_position;
	u16 access_bit_mask;
};

struct acpi_buffer {
	acpi_size length;
	void *pointer;
};

struct acpi_bus_event {
	struct list_head node;
	acpi_device_class device_class;
	acpi_bus_id bus_id;
	u32 type;
	u32 data;
};

struct acpi_bus_type {
	struct list_head list;
	const char *name;
	bool (*match)(struct device *);
	struct acpi_device * (*find_companion)(struct device *);
	void (*setup)(struct device *);
};

struct input_dev;

struct acpi_button {
	unsigned int type;
	struct input_dev *input;
	char phys[32];
	long unsigned int pushed;
	int last_state;
	ktime_t last_time;
	bool suspended;
	bool lid_state_initialized;
};

struct acpi_cdat_header {
	u8 type;
	u8 reserved;
	u16 length;
};

struct acpi_cedt_header {
	u8 type;
	u8 reserved;
	u16 length;
};

struct acpi_cedt_cfmws {
	struct acpi_cedt_header header;
	u32 reserved1;
	u64 base_hpa;
	u64 window_size;
	u8 interleave_ways;
	u8 interleave_arithmetic;
	u16 reserved2;
	u32 granularity;
	u16 restrictions;
	u16 qtg_id;
	u32 interleave_targets[0];
} __attribute__((packed));

struct acpi_comment_node {
	char *comment;
	struct acpi_comment_node *next;
};

struct acpi_common_descriptor {
	void *common_pointer;
	u8 descriptor_type;
};

struct acpi_common_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
};

struct acpi_connection_info {
	u8 *connection;
	u16 length;
	u8 access_length;
};

union acpi_parse_object;

struct acpi_control_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u16 opcode;
	union acpi_parse_object *predicate_op;
	u8 *aml_predicate_start;
	u8 *package_end;
	u64 loop_timeout;
};

struct acpi_create_field_info {
	struct acpi_namespace_node *region_node;
	struct acpi_namespace_node *field_node;
	struct acpi_namespace_node *register_node;
	struct acpi_namespace_node *data_register_node;
	struct acpi_namespace_node *connection_node;
	u8 *resource_buffer;
	u32 bank_value;
	u32 field_bit_position;
	u32 field_bit_length;
	u16 resource_length;
	u16 pin_number_index;
	u8 field_flags;
	u8 attribute;
	u8 field_type;
	u8 access_length;
};

struct acpi_csrt_group {
	u32 length;
	u32 vendor_id;
	u32 subvendor_id;
	u16 device_id;
	u16 subdevice_id;
	u16 revision;
	u16 reserved;
	u32 shared_info_length;
};

struct acpi_csrt_shared_info {
	u16 major_version;
	u16 minor_version;
	u32 mmio_base_low;
	u32 mmio_base_high;
	u32 gsi_interrupt;
	u8 interrupt_polarity;
	u8 interrupt_mode;
	u8 num_channels;
	u8 dma_address_width;
	u16 base_request_line;
	u16 num_handshake_signals;
	u32 max_block_size;
};

struct attribute {
	const char *name;
	umode_t mode;
};

struct address_space;

struct vm_area_struct;

struct bin_attribute {
	struct attribute attr;
	size_t size;
	void *private;
	struct address_space * (*f_mapping)(void);
	ssize_t (*read)(struct file *, struct kobject *, const struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*read_new)(struct file *, struct kobject *, const struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*write)(struct file *, struct kobject *, const struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*write_new)(struct file *, struct kobject *, const struct bin_attribute *, char *, loff_t, size_t);
	loff_t (*llseek)(struct file *, struct kobject *, const struct bin_attribute *, loff_t, int);
	int (*mmap)(struct file *, struct kobject *, const struct bin_attribute *, struct vm_area_struct *);
};

struct acpi_data_attr {
	struct bin_attribute attr;
	u64 addr;
};

typedef void *acpi_handle;

struct fwnode_operations;

struct fwnode_handle {
	struct fwnode_handle *secondary;
	const struct fwnode_operations *ops;
	struct device *dev;
	struct list_head suppliers;
	struct list_head consumers;
	u8 flags;
};

union acpi_object;

struct acpi_device_data {
	const union acpi_object *pointer;
	struct list_head properties;
	const union acpi_object *of_compatible;
	struct list_head subnodes;
};

struct acpi_data_node {
	struct list_head sibling;
	const char *name;
	acpi_handle handle;
	struct fwnode_handle fwnode;
	struct fwnode_handle *parent;
	struct acpi_device_data data;
	struct kobject kobj;
	struct completion kobj_done;
};

struct acpi_data_node_attr {
	struct attribute attr;
	ssize_t (*show)(struct acpi_data_node *, char *);
	ssize_t (*store)(struct acpi_data_node *, const char *, size_t);
};

struct acpi_data_obj {
	char *name;
	int (*fn)(void *, struct acpi_data_attr *);
};

struct acpi_data_table_mapping {
	void *pointer;
};

struct acpi_dep_data {
	struct list_head node;
	acpi_handle supplier;
	acpi_handle consumer;
	bool honor_dep;
	bool met;
	bool free_when_met;
};

union acpi_operand_object;

struct acpi_object_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
};

struct acpi_object_integer {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 fill[3];
	u64 value;
};

struct acpi_object_string {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	char *pointer;
	u32 length;
};

struct acpi_object_buffer {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 *pointer;
	u32 length;
	u32 aml_length;
	u8 *aml_start;
	struct acpi_namespace_node *node;
};

struct acpi_object_package {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *node;
	union acpi_operand_object **elements;
	u8 *aml_start;
	u32 aml_length;
	u32 count;
};

struct acpi_object_event {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	void *os_semaphore;
};

struct acpi_walk_state;

typedef acpi_status (*acpi_internal_method)(struct acpi_walk_state *);

struct acpi_object_method {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 info_flags;
	u8 param_count;
	u8 sync_level;
	union acpi_operand_object *mutex;
	union acpi_operand_object *node;
	u8 *aml_start;
	union {
		acpi_internal_method implementation;
		union acpi_operand_object *handler;
	} dispatch;
	u32 aml_length;
	acpi_owner_id owner_id;
	u8 thread_count;
};

struct acpi_thread_state;

struct acpi_object_mutex {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 sync_level;
	u16 acquisition_depth;
	void *os_mutex;
	u64 thread_id;
	struct acpi_thread_state *owner_thread;
	union acpi_operand_object *prev;
	union acpi_operand_object *next;
	struct acpi_namespace_node *node;
	u8 original_sync_level;
};

struct acpi_object_region {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 space_id;
	struct acpi_namespace_node *node;
	union acpi_operand_object *handler;
	union acpi_operand_object *next;
	acpi_physical_address address;
	u32 length;
	void *pointer;
};

struct acpi_object_notify_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
};

struct acpi_gpe_block_info;

struct acpi_object_device {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	struct acpi_gpe_block_info *gpe_block;
};

struct acpi_object_power_resource {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	u32 system_level;
	u32 resource_order;
};

struct acpi_object_processor {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 proc_id;
	u8 length;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	acpi_io_address address;
};

struct acpi_object_thermal_zone {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
};

struct acpi_object_field_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *region_obj;
};

struct acpi_object_region_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	u16 resource_length;
	union acpi_operand_object *region_obj;
	u8 *resource_buffer;
	u16 pin_number_index;
	u8 *internal_pcc_buffer;
};

struct acpi_object_buffer_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	u8 is_create_field;
	union acpi_operand_object *buffer_obj;
};

struct acpi_object_bank_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *region_obj;
	union acpi_operand_object *bank_obj;
};

struct acpi_object_index_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *index_obj;
	union acpi_operand_object *data_obj;
};

typedef void (*acpi_notify_handler)(acpi_handle, u32, void *);

struct acpi_object_notify_handler {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *node;
	u32 handler_type;
	acpi_notify_handler handler;
	void *context;
	union acpi_operand_object *next[2];
};

typedef acpi_status (*acpi_adr_space_handler)(u32, acpi_physical_address, u32, u64 *, void *, void *);

typedef acpi_status (*acpi_adr_space_setup)(acpi_handle, u32, void *, void **);

struct acpi_object_addr_handler {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 space_id;
	u8 handler_flags;
	acpi_adr_space_handler handler;
	struct acpi_namespace_node *node;
	void *context;
	void *context_mutex;
	acpi_adr_space_setup setup;
	union acpi_operand_object *region_list;
	union acpi_operand_object *next;
};

struct acpi_object_reference {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 class;
	u8 target_type;
	u8 resolved;
	void *object;
	struct acpi_namespace_node *node;
	union acpi_operand_object **where;
	u8 *index_pointer;
	u8 *aml;
	u32 value;
};

struct acpi_object_extra {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *method_REG;
	struct acpi_namespace_node *scope_node;
	void *region_context;
	u8 *aml_start;
	u32 aml_length;
};

typedef void (*acpi_object_handler)(acpi_handle, void *);

struct acpi_object_data {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	acpi_object_handler handler;
	void *pointer;
};

struct acpi_object_cache_list {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *next;
};

union acpi_name_union {
	u32 integer;
	char ascii[4];
};

struct acpi_namespace_node {
	union acpi_operand_object *object;
	u8 descriptor_type;
	u8 type;
	u16 flags;
	union acpi_name_union name;
	struct acpi_namespace_node *parent;
	struct acpi_namespace_node *child;
	struct acpi_namespace_node *peer;
	acpi_owner_id owner_id;
};

union acpi_operand_object {
	struct acpi_object_common common;
	struct acpi_object_integer integer;
	struct acpi_object_string string;
	struct acpi_object_buffer buffer;
	struct acpi_object_package package;
	struct acpi_object_event event;
	struct acpi_object_method method;
	struct acpi_object_mutex mutex;
	struct acpi_object_region region;
	struct acpi_object_notify_common common_notify;
	struct acpi_object_device device;
	struct acpi_object_power_resource power_resource;
	struct acpi_object_processor processor;
	struct acpi_object_thermal_zone thermal_zone;
	struct acpi_object_field_common common_field;
	struct acpi_object_region_field field;
	struct acpi_object_buffer_field buffer_field;
	struct acpi_object_bank_field bank_field;
	struct acpi_object_index_field index_field;
	struct acpi_object_notify_handler notify;
	struct acpi_object_addr_handler address_space;
	struct acpi_object_reference reference;
	struct acpi_object_extra extra;
	struct acpi_object_data data;
	struct acpi_object_cache_list cache;
	struct acpi_namespace_node node;
};

union acpi_parse_value {
	u64 integer;
	u32 size;
	char *string;
	u8 *buffer;
	char *name;
	union acpi_parse_object *arg;
};

struct acpi_parse_obj_common {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
	u16 disasm_flags;
	u8 disasm_opcode;
	char *operator_symbol;
	char aml_op_name[16];
};

struct acpi_parse_obj_named {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
	u16 disasm_flags;
	u8 disasm_opcode;
	char *operator_symbol;
	char aml_op_name[16];
	char *path;
	u8 *data;
	u32 length;
	u32 name;
};

struct acpi_parse_obj_asl {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
	u16 disasm_flags;
	u8 disasm_opcode;
	char *operator_symbol;
	char aml_op_name[16];
	union acpi_parse_object *child;
	union acpi_parse_object *parent_method;
	char *filename;
	u8 file_changed;
	char *parent_filename;
	char *external_name;
	char *namepath;
	char name_seg[4];
	u32 extra_value;
	u32 column;
	u32 line_number;
	u32 logical_line_number;
	u32 logical_byte_offset;
	u32 end_line;
	u32 end_logical_line;
	u32 acpi_btype;
	u32 aml_length;
	u32 aml_subtree_length;
	u32 final_aml_length;
	u32 final_aml_offset;
	u32 compile_flags;
	u16 parse_opcode;
	u8 aml_opcode_length;
	u8 aml_pkg_len_bytes;
	u8 extra;
	char parse_op_name[20];
};

union acpi_parse_object {
	struct acpi_parse_obj_common common;
	struct acpi_parse_obj_named named;
	struct acpi_parse_obj_asl asl;
};

union acpi_descriptor {
	struct acpi_common_descriptor common;
	union acpi_operand_object object;
	struct acpi_namespace_node node;
	union acpi_parse_object op;
};

struct acpi_device_id {
	__u8 id[16];
	kernel_ulong_t driver_data;
	__u32 cls;
	__u32 cls_msk;
};

struct acpi_dev_match_info {
	struct acpi_device_id hid[2];
	const char *uid;
	s64 hrv;
};

struct acpi_dev_walk_context {
	int (*fn)(struct acpi_device *, void *);
	void *data;
};

struct acpi_device_status {
	u32 present: 1;
	u32 enabled: 1;
	u32 show_in_ui: 1;
	u32 functional: 1;
	u32 battery_present: 1;
	u32 reserved: 27;
};

struct acpi_device_flags {
	u32 dynamic_status: 1;
	u32 removable: 1;
	u32 ejectable: 1;
	u32 power_manageable: 1;
	u32 match_driver: 1;
	u32 initialized: 1;
	u32 visited: 1;
	u32 hotplug_notify: 1;
	u32 is_dock_station: 1;
	u32 of_compatible_ok: 1;
	u32 coherent_dma: 1;
	u32 cca_seen: 1;
	u32 enumeration_by_parent: 1;
	u32 honor_deps: 1;
	u32 reserved: 18;
};

struct acpi_pnp_type {
	u32 hardware_id: 1;
	u32 bus_address: 1;
	u32 platform_id: 1;
	u32 backlight: 1;
	u32 reserved: 28;
};

struct acpi_device_pnp {
	acpi_bus_id bus_id;
	int instance_no;
	struct acpi_pnp_type type;
	acpi_bus_address bus_address;
	char *unique_id;
	struct list_head ids;
	acpi_device_name device_name;
	acpi_device_class device_class;
};

struct acpi_device_power_flags {
	u32 explicit_get: 1;
	u32 power_resources: 1;
	u32 inrush_current: 1;
	u32 power_removed: 1;
	u32 ignore_parent: 1;
	u32 dsw_present: 1;
	u32 reserved: 26;
};

struct acpi_device_power_state {
	struct list_head resources;
	struct {
		u8 valid: 1;
		u8 explicit_set: 1;
		u8 reserved: 6;
	} flags;
	int power;
	int latency;
};

struct acpi_device_power {
	int state;
	struct acpi_device_power_flags flags;
	struct acpi_device_power_state states[5];
	u8 state_for_enumeration;
};

struct acpi_device_wakeup_flags {
	u8 valid: 1;
	u8 notifier_present: 1;
};

struct acpi_device_wakeup_context {
	void (*func)(struct acpi_device_wakeup_context *);
	struct device *dev;
};

struct acpi_device_wakeup {
	acpi_handle gpe_device;
	u64 gpe_number;
	u64 sleep_state;
	struct list_head resources;
	struct acpi_device_wakeup_flags flags;
	struct acpi_device_wakeup_context context;
	struct wakeup_source *ws;
	int prepare_count;
	int enable_count;
};

struct acpi_device_perf_flags {
	u8 reserved: 8;
};

struct acpi_device_perf_state;

struct acpi_device_perf {
	int state;
	struct acpi_device_perf_flags flags;
	int state_count;
	struct acpi_device_perf_state *states;
};

struct proc_dir_entry;

struct acpi_device_dir {
	struct proc_dir_entry *entry;
};

struct acpi_scan_handler;

struct acpi_hotplug_context;

struct acpi_device_software_nodes;

struct acpi_gpio_mapping;

struct acpi_device {
	u32 pld_crc;
	int device_type;
	acpi_handle handle;
	struct fwnode_handle fwnode;
	struct list_head wakeup_list;
	struct list_head del_list;
	struct acpi_device_status status;
	struct acpi_device_flags flags;
	struct acpi_device_pnp pnp;
	struct acpi_device_power power;
	struct acpi_device_wakeup wakeup;
	struct acpi_device_perf performance;
	struct acpi_device_dir dir;
	struct acpi_device_data data;
	struct acpi_scan_handler *handler;
	struct acpi_hotplug_context *hp;
	struct acpi_device_software_nodes *swnodes;
	const struct acpi_gpio_mapping *driver_gpios;
	void *driver_data;
	struct device dev;
	unsigned int physical_node_count;
	unsigned int dep_unmet;
	struct list_head physical_node_list;
	struct mutex physical_node_lock;
	void (*remove)(struct acpi_device *);
};

struct xarray {
	spinlock_t xa_lock;
	gfp_t xa_flags;
	void *xa_head;
};

struct ida {
	struct xarray xa;
};

struct acpi_device_bus_id {
	const char *bus_id;
	struct ida instance_ida;
	struct list_head node;
};

struct acpi_pnp_device_id {
	u32 length;
	char *string;
};

struct acpi_pnp_device_id_list {
	u32 count;
	u32 list_size;
	struct acpi_pnp_device_id ids[0];
};

struct acpi_device_info {
	u32 info_size;
	u32 name;
	acpi_object_type type;
	u8 param_count;
	u16 valid;
	u8 flags;
	u8 highest_dstates[4];
	u8 lowest_dstates[5];
	u64 address;
	struct acpi_pnp_device_id hardware_id;
	struct acpi_pnp_device_id unique_id;
	struct acpi_pnp_device_id class_code;
	struct acpi_pnp_device_id_list compatible_id_list;
};

typedef int (*acpi_op_add)(struct acpi_device *);

typedef void (*acpi_op_remove)(struct acpi_device *);

typedef void (*acpi_op_notify)(struct acpi_device *, u32);

struct acpi_device_ops {
	acpi_op_add add;
	acpi_op_remove remove;
	acpi_op_notify notify;
};

struct acpi_device_perf_state {
	struct {
		u8 valid: 1;
		u8 reserved: 7;
	} flags;
	u8 power;
	u8 performance;
	int latency;
};

struct acpi_device_physical_node {
	struct list_head node;
	struct device *dev;
	unsigned int node_id;
	bool put_online: 1;
};

struct acpi_device_properties {
	struct list_head list;
	const guid_t *guid;
	union acpi_object *properties;
	void **bufs;
};

struct property_entry {
	const char *name;
	size_t length;
	bool is_inline;
	enum dev_prop_type type;
	union {
		const void *pointer;
		union {
			u8 u8_data[8];
			u16 u16_data[4];
			u32 u32_data[2];
			u64 u64_data[1];
			const char *str[1];
		} value;
	};
};

struct software_node;

struct software_node_ref_args {
	const struct software_node *node;
	unsigned int nargs;
	u64 args[16];
};

struct acpi_device_software_node_port {
	char port_name[9];
	u32 data_lanes[8];
	u32 lane_polarities[9];
	u64 link_frequencies[8];
	unsigned int port_nr;
	bool crs_csi2_local;
	struct property_entry port_props[2];
	struct property_entry ep_props[8];
	struct software_node_ref_args remote_ep[1];
};

struct acpi_device_software_nodes {
	struct property_entry dev_props[6];
	struct software_node *nodes;
	const struct software_node **nodeptrs;
	struct acpi_device_software_node_port *ports;
	unsigned int num_ports;
};

struct acpi_table_desc;

struct acpi_evaluate_info;

struct acpi_device_walk_info {
	struct acpi_table_desc *table_desc;
	struct acpi_evaluate_info *evaluate_info;
	u32 device_count;
	u32 num_STA;
	u32 num_INI;
};

struct acpi_dlayer {
	const char *name;
	long unsigned int value;
};

struct acpi_dlevel {
	const char *name;
	long unsigned int value;
};

struct dma_chan;

struct acpi_dma_spec;

struct acpi_dma {
	struct list_head dma_controllers;
	struct device *dev;
	struct dma_chan * (*acpi_dma_xlate)(struct acpi_dma_spec *, struct acpi_dma *);
	void *data;
	short unsigned int base_request_line;
	short unsigned int end_request_line;
};

typedef bool (*dma_filter_fn)(struct dma_chan *, void *);

struct acpi_dma_filter_info {
	dma_cap_mask_t dma_cap;
	dma_filter_fn filter_fn;
};

struct acpi_dma_spec {
	int chan_id;
	int slave_id;
	struct device *dev;
};

struct acpi_dma_parser_data {
	struct acpi_dma_spec dma_spec;
	size_t index;
	size_t n;
};

struct acpi_dmar_header {
	u16 type;
	u16 length;
};

struct acpi_dmar_andd {
	struct acpi_dmar_header header;
	u8 reserved[3];
	u8 device_number;
	union {
		char __pad;
		struct {
			struct {} __Empty_device_name;
			char device_name[0];
		};
	};
} __attribute__((packed));

struct acpi_dmar_atsr {
	struct acpi_dmar_header header;
	u8 flags;
	u8 reserved;
	u16 segment;
};

struct acpi_dmar_device_scope {
	u8 entry_type;
	u8 length;
	u8 flags;
	u8 reserved;
	u8 enumeration_id;
	u8 bus;
};

struct acpi_dmar_hardware_unit {
	struct acpi_dmar_header header;
	u8 flags;
	u8 size;
	u16 segment;
	u64 address;
};

struct acpi_dmar_pci_path {
	u8 device;
	u8 function;
};

struct acpi_dmar_reserved_memory {
	struct acpi_dmar_header header;
	u16 reserved;
	u16 segment;
	u64 base_address;
	u64 end_address;
};

struct acpi_dmar_rhsa {
	struct acpi_dmar_header header;
	u32 reserved;
	u64 base_address;
	u32 proximity_domain;
} __attribute__((packed));

struct acpi_dmar_satc {
	struct acpi_dmar_header header;
	u8 flags;
	u8 reserved;
	u16 segment;
};

struct of_device_id;

struct dev_pm_ops;

struct driver_private;

struct device_driver {
	const char *name;
	const struct bus_type *bus;
	struct module *owner;
	const char *mod_name;
	bool suppress_bind_attrs;
	enum probe_type probe_type;
	const struct of_device_id *of_match_table;
	const struct acpi_device_id *acpi_match_table;
	int (*probe)(struct device *);
	void (*sync_state)(struct device *);
	int (*remove)(struct device *);
	void (*shutdown)(struct device *);
	int (*suspend)(struct device *, pm_message_t);
	int (*resume)(struct device *);
	const struct attribute_group **groups;
	const struct attribute_group **dev_groups;
	const struct dev_pm_ops *pm;
	void (*coredump)(struct device *);
	struct driver_private *p;
};

struct acpi_driver {
	char name[80];
	char class[80];
	const struct acpi_device_id *ids;
	unsigned int flags;
	struct acpi_device_ops ops;
	struct device_driver drv;
};

struct transaction;

struct acpi_ec {
	acpi_handle handle;
	int gpe;
	int irq;
	long unsigned int command_addr;
	long unsigned int data_addr;
	bool global_lock;
	long unsigned int flags;
	long unsigned int reference_count;
	struct mutex mutex;
	wait_queue_head_t wait;
	struct list_head list;
	struct transaction *curr;
	spinlock_t lock;
	struct work_struct work;
	long unsigned int timestamp;
	enum acpi_ec_event_state event_state;
	unsigned int events_to_process;
	unsigned int events_in_progress;
	unsigned int queries_in_progress;
	bool busy_polling;
	unsigned int polling_guard;
};

struct transaction {
	const u8 *wdata;
	u8 *rdata;
	short unsigned int irq_count;
	u8 command;
	u8 wi;
	u8 ri;
	u8 wlen;
	u8 rlen;
	u8 flags;
};

struct acpi_ec_query_handler;

struct acpi_ec_query {
	struct transaction transaction;
	struct work_struct work;
	struct acpi_ec_query_handler *handler;
	struct acpi_ec *ec;
};

typedef int (*acpi_ec_query_func)(void *);

struct acpi_ec_query_handler {
	struct list_head node;
	acpi_ec_query_func func;
	acpi_handle handle;
	void *data;
	u8 query_bit;
	struct kref kref;
};

union acpi_predefined_info;

struct acpi_evaluate_info {
	struct acpi_namespace_node *prefix_node;
	const char *relative_pathname;
	union acpi_operand_object **parameters;
	struct acpi_namespace_node *node;
	union acpi_operand_object *obj_desc;
	char *full_pathname;
	const union acpi_predefined_info *predefined;
	union acpi_operand_object *return_object;
	union acpi_operand_object *parent_package;
	u32 return_flags;
	u32 return_btype;
	u16 param_count;
	u16 node_flags;
	u8 pass_number;
	u8 return_object_type;
	u8 flags;
};

struct acpi_exception_info {
	char *name;
};

struct acpi_exdump_info {
	u8 opcode;
	u8 offset;
	const char *name;
} __attribute__((packed));

struct acpi_fadt_info {
	const char *name;
	u16 address64;
	u16 address32;
	u16 length;
	u8 default_length;
	u8 flags;
};

struct acpi_generic_address;

struct acpi_fadt_pm_info {
	struct acpi_generic_address *target;
	u16 source;
	u8 register_num;
};

struct acpi_fan_fif {
	u8 revision;
	u8 fine_grain_ctrl;
	u8 step_size;
	u8 low_speed_notification;
};

struct device_attribute {
	struct attribute attr;
	ssize_t (*show)(struct device *, struct device_attribute *, char *);
	ssize_t (*store)(struct device *, struct device_attribute *, const char *, size_t);
};

struct acpi_fan_fps;

struct thermal_cooling_device;

struct acpi_fan {
	bool acpi4;
	bool has_fst;
	struct acpi_fan_fif fif;
	struct acpi_fan_fps *fps;
	int fps_count;
	struct thermal_cooling_device *cdev;
	struct device_attribute fst_speed;
	struct device_attribute fine_grain_control;
};

struct acpi_fan_fps {
	u64 control;
	u64 trip_point;
	u64 speed;
	u64 noise_level;
	u64 power;
	char name[20];
	struct device_attribute dev_attr;
};

struct acpi_fan_fst {
	u64 revision;
	u64 control;
	u64 speed;
};

struct acpi_ffh_info {
	u64 offset;
	u64 length;
};

typedef u32 (*acpi_event_handler)(void *);

struct acpi_fixed_event_handler {
	acpi_event_handler handler;
	void *context;
};

struct acpi_fixed_event_info {
	u8 status_register_id;
	u8 enable_register_id;
	u16 status_bit_mask;
	u16 enable_bit_mask;
};

struct acpi_ged_device {
	struct device *dev;
	struct list_head event_list;
};

struct acpi_ged_event {
	struct list_head node;
	struct device *dev;
	unsigned int gsi;
	unsigned int irq;
	acpi_handle handle;
};

struct acpi_ged_handler_info {
	struct acpi_ged_handler_info *next;
	u32 int_id;
	struct acpi_namespace_node *evt_method;
};

struct acpi_generic_address {
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_width;
	u64 address;
} __attribute__((packed));

struct acpi_update_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	union acpi_operand_object *object;
};

struct acpi_scope_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	struct acpi_namespace_node *node;
};

struct acpi_pscope_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u32 arg_count;
	union acpi_parse_object *op;
	u8 *arg_end;
	u8 *pkg_end;
	u32 arg_list;
};

struct acpi_pkg_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u32 index;
	union acpi_operand_object *source_object;
	union acpi_operand_object *dest_object;
	struct acpi_walk_state *walk_state;
	void *this_target_obj;
	u32 num_packages;
};

struct acpi_thread_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u8 current_sync_level;
	struct acpi_walk_state *walk_state_list;
	union acpi_operand_object *acquired_mutex_list;
	u64 thread_id;
};

struct acpi_result_values {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	union acpi_operand_object *obj_desc[8];
};

struct acpi_global_notify_handler;

struct acpi_notify_info {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u8 handler_list_id;
	struct acpi_namespace_node *node;
	union acpi_operand_object *handler_list_head;
	struct acpi_global_notify_handler *global;
};

union acpi_generic_state {
	struct acpi_common_state common;
	struct acpi_control_state control;
	struct acpi_update_state update;
	struct acpi_scope_state scope;
	struct acpi_pscope_state parse_scope;
	struct acpi_pkg_state pkg;
	struct acpi_thread_state thread;
	struct acpi_result_values results;
	struct acpi_notify_info notify;
};

struct acpi_genl_event {
	acpi_device_class device_class;
	char bus_id[15];
	u32 type;
	u32 data;
};

typedef acpi_status (*acpi_walk_callback)(acpi_handle, u32, void *, void **);

struct acpi_get_devices_info {
	acpi_walk_callback user_function;
	void *context;
	const char *hid;
};

struct acpi_global_notify_handler {
	acpi_notify_handler handler;
	void *context;
};

struct acpi_gpe_address {
	u8 space_id;
	u64 address;
};

struct acpi_gpe_xrupt_info;

struct acpi_gpe_register_info;

struct acpi_gpe_event_info;

struct acpi_gpe_block_info {
	struct acpi_namespace_node *node;
	struct acpi_gpe_block_info *previous;
	struct acpi_gpe_block_info *next;
	struct acpi_gpe_xrupt_info *xrupt_block;
	struct acpi_gpe_register_info *register_info;
	struct acpi_gpe_event_info *event_info;
	u64 address;
	u32 register_count;
	u16 gpe_count;
	u16 block_base_number;
	u8 space_id;
	u8 initialized;
};

struct acpi_gpe_block_status_context {
	struct acpi_gpe_register_info *gpe_skip_register_info;
	u8 gpe_skip_mask;
	u8 retval;
};

struct acpi_gpe_device_info {
	u32 index;
	u32 next_block_base_index;
	acpi_status status;
	struct acpi_namespace_node *gpe_device;
};

struct acpi_gpe_handler_info;

struct acpi_gpe_notify_info;

union acpi_gpe_dispatch_info {
	struct acpi_namespace_node *method_node;
	struct acpi_gpe_handler_info *handler;
	struct acpi_gpe_notify_info *notify_list;
};

struct acpi_gpe_event_info {
	union acpi_gpe_dispatch_info dispatch;
	struct acpi_gpe_register_info *register_info;
	u8 flags;
	u8 gpe_number;
	u8 runtime_count;
	u8 disable_for_dispatch;
};

typedef u32 (*acpi_gpe_handler)(acpi_handle, u32, void *);

struct acpi_gpe_handler_info {
	acpi_gpe_handler address;
	void *context;
	struct acpi_namespace_node *method_node;
	u8 original_flags;
	u8 originally_enabled;
};

struct acpi_gpe_notify_info {
	struct acpi_namespace_node *device_node;
	struct acpi_gpe_notify_info *next;
};

struct acpi_gpe_register_info {
	struct acpi_gpe_address status_address;
	struct acpi_gpe_address enable_address;
	u16 base_gpe_number;
	u8 enable_for_wake;
	u8 enable_for_run;
	u8 mask_for_run;
	u8 enable_mask;
};

struct acpi_gpe_walk_info {
	struct acpi_namespace_node *gpe_device;
	struct acpi_gpe_block_info *gpe_block;
	u16 count;
	acpi_owner_id owner_id;
	u8 execute_by_owner_id;
};

struct acpi_gpe_xrupt_info {
	struct acpi_gpe_xrupt_info *previous;
	struct acpi_gpe_xrupt_info *next;
	struct acpi_gpe_block_info *gpe_block_list_head;
	u32 interrupt_number;
};

struct gpio_chip;

struct acpi_gpio_chip {
	struct acpi_connection_info conn_info;
	struct list_head conns;
	struct mutex conn_lock;
	struct gpio_chip *chip;
	struct list_head events;
	struct list_head deferred_req_irqs_list_entry;
};

struct gpio_desc;

struct acpi_gpio_connection {
	struct list_head node;
	unsigned int pin;
	struct gpio_desc *desc;
};

typedef irqreturn_t (*irq_handler_t)(int, void *);

struct acpi_gpio_event {
	struct list_head node;
	acpi_handle handle;
	irq_handler_t handler;
	unsigned int pin;
	unsigned int irq;
	long unsigned int irqflags;
	bool irq_is_wake;
	bool irq_requested;
	struct gpio_desc *desc;
};

struct acpi_gpio_info {
	struct acpi_device *adev;
	enum gpiod_flags flags;
	bool gpioint;
	bool wake_capable;
	int pin_config;
	int polarity;
	int triggering;
	unsigned int debounce;
	unsigned int quirks;
};

struct acpi_gpio_params {
	unsigned int crs_entry_index;
	short unsigned int line_index;
	bool active_low;
};

struct acpi_gpio_lookup {
	struct acpi_gpio_params params;
	struct acpi_gpio_info *info;
	struct gpio_desc *desc;
	int n;
};

struct acpi_gpio_mapping {
	const char *name;
	const struct acpi_gpio_params *data;
	unsigned int size;
	unsigned int quirks;
};

struct acpi_gpiolib_dmi_quirk {
	bool no_edge_events_on_boot;
	char *ignore_wake;
	char *ignore_interrupt;
};

struct acpi_handle_list {
	u32 count;
	acpi_handle *handles;
};

struct acpi_hardware_id {
	struct list_head list;
	const char *id;
};

struct acpi_hest_header {
	u16 type;
	u16 source_id;
};

struct acpi_hest_notify {
	u8 type;
	u8 length;
	u16 config_write_enable;
	u32 poll_interval;
	u32 vector;
	u32 polling_threshold_value;
	u32 polling_threshold_window;
	u32 error_threshold_value;
	u32 error_threshold_window;
};

struct acpi_hest_generic {
	struct acpi_hest_header header;
	u16 related_source_id;
	u8 reserved;
	u8 enabled;
	u32 records_to_preallocate;
	u32 max_sections_per_record;
	u32 max_raw_data_length;
	struct acpi_generic_address error_status_address;
	struct acpi_hest_notify notify;
	u32 error_block_length;
};

struct acpi_hest_generic_data {
	u8 section_type[16];
	u32 error_severity;
	u16 revision;
	u8 validation_bits;
	u8 flags;
	u32 error_data_length;
	u8 fru_id[16];
	u8 fru_text[20];
};

struct acpi_hest_generic_data_v300 {
	u8 section_type[16];
	u32 error_severity;
	u16 revision;
	u8 validation_bits;
	u8 flags;
	u32 error_data_length;
	u8 fru_id[16];
	u8 fru_text[20];
	u64 time_stamp;
};

struct acpi_hest_generic_status {
	u32 block_status;
	u32 raw_data_offset;
	u32 raw_data_length;
	u32 data_length;
	u32 error_severity;
};

struct acpi_hest_generic_v2 {
	struct acpi_hest_header header;
	u16 related_source_id;
	u8 reserved;
	u8 enabled;
	u32 records_to_preallocate;
	u32 max_sections_per_record;
	u32 max_raw_data_length;
	struct acpi_generic_address error_status_address;
	struct acpi_hest_notify notify;
	u32 error_block_length;
	struct acpi_generic_address read_ack_register;
	u64 read_ack_preserve;
	u64 read_ack_write;
} __attribute__((packed));

struct acpi_hest_ia_corrected {
	struct acpi_hest_header header;
	u16 reserved1;
	u8 flags;
	u8 enabled;
	u32 records_to_preallocate;
	u32 max_sections_per_record;
	struct acpi_hest_notify notify;
	u8 num_hardware_banks;
	u8 reserved2[3];
};

struct acpi_hest_ia_deferred_check {
	struct acpi_hest_header header;
	u16 reserved1;
	u8 flags;
	u8 enabled;
	u32 records_to_preallocate;
	u32 max_sections_per_record;
	struct acpi_hest_notify notify;
	u8 num_hardware_banks;
	u8 reserved2[3];
};

struct acpi_hest_ia_error_bank {
	u8 bank_number;
	u8 clear_status_on_init;
	u8 status_format;
	u8 reserved;
	u32 control_register;
	u64 control_data;
	u32 status_register;
	u32 address_register;
	u32 misc_register;
} __attribute__((packed));

struct acpi_hest_ia_machine_check {
	struct acpi_hest_header header;
	u16 reserved1;
	u8 flags;
	u8 enabled;
	u32 records_to_preallocate;
	u32 max_sections_per_record;
	u64 global_capability_data;
	u64 global_control_data;
	u8 num_hardware_banks;
	u8 reserved3[7];
};

struct acpi_hmat_structure {
	u16 type;
	u16 reserved;
	u32 length;
};

struct acpi_hmat_cache {
	struct acpi_hmat_structure header;
	u32 memory_PD;
	u32 reserved1;
	u64 cache_size;
	u32 cache_attributes;
	u16 address_mode;
	u16 number_of_SMBIOShandles;
};

struct acpi_hmat_locality {
	struct acpi_hmat_structure header;
	u8 flags;
	u8 data_type;
	u8 min_transfer_size;
	u8 reserved1;
	u32 number_of_initiator_Pds;
	u32 number_of_target_Pds;
	u32 reserved2;
	u64 entry_base_unit;
};

struct acpi_hmat_proximity_domain {
	struct acpi_hmat_structure header;
	u16 flags;
	u16 reserved1;
	u32 processor_PD;
	u32 memory_PD;
	u32 reserved2;
	u64 reserved3;
	u64 reserved4;
};

typedef int (*acpi_hp_notify)(struct acpi_device *, u32);

typedef void (*acpi_hp_uevent)(struct acpi_device *, u32);

typedef void (*acpi_hp_fixup)(struct acpi_device *);

struct acpi_hotplug_context {
	struct acpi_device *self;
	acpi_hp_notify notify;
	acpi_hp_uevent uevent;
	acpi_hp_fixup fixup;
};

struct acpi_hotplug_profile {
	struct kobject kobj;
	int (*scan_dependent)(struct acpi_device *);
	void (*notify_online)(struct acpi_device *);
	bool enabled: 1;
	bool demand_offline: 1;
};

struct acpi_hp_work {
	struct work_struct work;
	struct acpi_device *adev;
	u32 src;
};

struct acpi_init_walk_info {
	u32 table_index;
	u32 object_count;
	u32 method_count;
	u32 serial_method_count;
	u32 non_serial_method_count;
	u32 serialized_method_count;
	u32 device_count;
	u32 op_region_count;
	u32 field_count;
	u32 buffer_count;
	u32 package_count;
	u32 op_region_init;
	u32 field_init;
	u32 buffer_init;
	u32 package_init;
	acpi_owner_id owner_id;
};

struct acpi_interface_info {
	char *name;
	struct acpi_interface_info *next;
	u8 flags;
	u8 value;
};

struct acpi_io_attribute {
	u8 range_type;
	u8 translation;
	u8 translation_type;
	u8 reserved1;
};

struct rcu_work {
	struct work_struct work;
	struct callback_head rcu;
	struct workqueue_struct *wq;
};

struct acpi_ioremap {
	struct list_head list;
	void *virt;
	acpi_physical_address phys;
	acpi_size size;
	union {
		long unsigned int refcount;
		struct rcu_work rwork;
	} track;
};

struct acpi_lpat {
	int temp;
	int raw;
};

struct acpi_lpat_conversion_table {
	struct acpi_lpat *lpat;
	int lpat_count;
};

struct acpi_lpi_state {
	u32 min_residency;
	u32 wake_latency;
	u32 flags;
	u32 arch_flags;
	u32 res_cnt_freq;
	u32 enable_parent_state;
	u64 address;
	u8 index;
	u8 entry_method;
	char desc[32];
};

struct acpi_lpi_states_array {
	unsigned int size;
	unsigned int composite_states_size;
	struct acpi_lpi_state *entries;
	struct acpi_lpi_state *composite_states[8];
};

struct acpi_lpit_header {
	u32 type;
	u32 length;
	u16 unique_id;
	u16 reserved;
	u32 flags;
};

struct acpi_lpit_native {
	struct acpi_lpit_header header;
	struct acpi_generic_address entry_trigger;
	u32 residency;
	u32 latency;
	struct acpi_generic_address residency_counter;
	u64 counter_frequency;
};

struct acpi_subtable_header {
	u8 type;
	u8 length;
};

struct acpi_madt_core_pic {
	struct acpi_subtable_header header;
	u8 version;
	u32 processor_id;
	u32 core_id;
	u32 flags;
} __attribute__((packed));

struct acpi_madt_generic_distributor {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 gic_id;
	u64 base_address;
	u32 global_irq_base;
	u8 version;
	u8 reserved2[3];
};

struct acpi_madt_generic_interrupt {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 cpu_interface_number;
	u32 uid;
	u32 flags;
	u32 parking_version;
	u32 performance_interrupt;
	u64 parked_address;
	u64 base_address;
	u64 gicv_base_address;
	u64 gich_base_address;
	u32 vgic_interrupt;
	u64 gicr_base_address;
	u64 arm_mpidr;
	u8 efficiency_class;
	u8 reserved2[1];
	u16 spe_interrupt;
	u16 trbe_interrupt;
} __attribute__((packed));

struct acpi_madt_interrupt_override {
	struct acpi_subtable_header header;
	u8 bus;
	u8 source_irq;
	u32 global_irq;
	u16 inti_flags;
} __attribute__((packed));

struct acpi_madt_interrupt_source {
	struct acpi_subtable_header header;
	u16 inti_flags;
	u8 type;
	u8 id;
	u8 eid;
	u8 io_sapic_vector;
	u32 global_irq;
	u32 flags;
};

struct acpi_madt_io_apic {
	struct acpi_subtable_header header;
	u8 id;
	u8 reserved;
	u32 address;
	u32 global_irq_base;
};

struct acpi_madt_io_sapic {
	struct acpi_subtable_header header;
	u8 id;
	u8 reserved;
	u32 global_irq_base;
	u64 address;
};

struct acpi_madt_local_apic {
	struct acpi_subtable_header header;
	u8 processor_id;
	u8 id;
	u32 lapic_flags;
};

struct acpi_madt_local_apic_nmi {
	struct acpi_subtable_header header;
	u8 processor_id;
	u16 inti_flags;
	u8 lint;
} __attribute__((packed));

struct acpi_madt_local_apic_override {
	struct acpi_subtable_header header;
	u16 reserved;
	u64 address;
} __attribute__((packed));

struct acpi_madt_local_sapic {
	struct acpi_subtable_header header;
	u8 processor_id;
	u8 id;
	u8 eid;
	u8 reserved[3];
	u32 lapic_flags;
	u32 uid;
	char uid_string[0];
};

struct acpi_madt_local_x2apic {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 local_apic_id;
	u32 lapic_flags;
	u32 uid;
};

struct acpi_madt_local_x2apic_nmi {
	struct acpi_subtable_header header;
	u16 inti_flags;
	u32 uid;
	u8 lint;
	u8 reserved[3];
};

struct acpi_madt_multiproc_wakeup {
	struct acpi_subtable_header header;
	u16 version;
	u32 reserved;
	u64 mailbox_address;
	u64 reset_vector;
};

struct acpi_madt_multiproc_wakeup_mailbox {
	u16 command;
	u16 reserved;
	u32 apic_id;
	u64 wakeup_vector;
	u8 reserved_os[2032];
	u8 reserved_firmware[2048];
};

struct acpi_madt_nmi_source {
	struct acpi_subtable_header header;
	u16 inti_flags;
	u32 global_irq;
};

struct acpi_madt_rintc {
	struct acpi_subtable_header header;
	u8 version;
	u8 reserved;
	u32 flags;
	u64 hart_id;
	u32 uid;
	u32 ext_intc_id;
	u64 imsic_addr;
	u32 imsic_size;
} __attribute__((packed));

struct acpi_mcfg_allocation {
	u64 address;
	u16 pci_segment;
	u8 start_bus_number;
	u8 end_bus_number;
	u32 reserved;
};

struct acpi_mem_mapping {
	acpi_physical_address physical_address;
	u8 *logical_address;
	acpi_size length;
	struct acpi_mem_mapping *next_mm;
};

struct acpi_mem_space_context {
	u32 length;
	acpi_physical_address address;
	struct acpi_mem_mapping *cur_mm;
	struct acpi_mem_mapping *first_mm;
};

struct acpi_memory_attribute {
	u8 write_protect;
	u8 caching;
	u8 range_type;
	u8 translation;
};

struct acpi_memory_device {
	struct acpi_device *device;
	struct list_head res_list;
	int mgid;
};

struct acpi_memory_info {
	struct list_head list;
	u64 start_addr;
	u64 length;
	short unsigned int caching;
	short unsigned int write_protect;
	unsigned int enabled: 1;
};

struct acpi_subtbl_hdr_16 {
	u16 type;
	u16 length;
};

struct acpi_mrrm_mem_range_entry {
	struct acpi_subtbl_hdr_16 header;
	u32 reserved0;
	u64 addr_base;
	u64 addr_len;
	u16 region_id_flags;
	u8 local_region_id;
	u8 remote_region_id;
	u32 reserved1;
};

struct acpi_mutex_info {
	void *mutex;
	u32 use_count;
	u64 thread_id;
};

struct acpi_name_info {
	char name[4];
	u16 argument_list;
	u8 expected_btypes;
} __attribute__((packed));

struct acpi_namestring_info {
	const char *external_name;
	const char *next_external_char;
	char *internal_name;
	u32 length;
	u32 num_segments;
	u32 num_carats;
	u8 fully_qualified;
};

struct acpi_nhlt_config {
	u32 capabilities_size;
	u8 capabilities[0];
};

struct acpi_nhlt_gendevice_config {
	u8 virtual_slot;
	u8 config_type;
};

struct acpi_nhlt_micdevice_config {
	u8 virtual_slot;
	u8 config_type;
	u8 array_type;
};

struct acpi_nhlt_vendor_mic_config {
	u8 type;
	u8 panel;
	u16 speaker_position_distance;
	u16 horizontal_offset;
	u16 vertical_offset;
	u8 frequency_low_band;
	u8 frequency_high_band;
	u16 direction_angle;
	u16 elevation_angle;
	u16 work_vertical_angle_begin;
	u16 work_vertical_angle_end;
	u16 work_horizontal_angle_begin;
	u16 work_horizontal_angle_end;
};

struct acpi_nhlt_vendor_micdevice_config {
	u8 virtual_slot;
	u8 config_type;
	u8 array_type;
	u8 mics_count;
	struct acpi_nhlt_vendor_mic_config mics[0];
};

union acpi_nhlt_device_config {
	u8 virtual_slot;
	struct acpi_nhlt_gendevice_config gen;
	struct acpi_nhlt_micdevice_config mic;
	struct acpi_nhlt_vendor_micdevice_config vendor_mic;
};

struct acpi_nhlt_endpoint {
	u32 length;
	u8 link_type;
	u8 instance_id;
	u16 vendor_id;
	u16 device_id;
	u16 revision_id;
	u32 subsystem_id;
	u8 device_type;
	u8 direction;
	u8 virtual_bus_id;
} __attribute__((packed));

struct acpi_nhlt_wave_formatext {
	u16 format_tag;
	u16 channel_count;
	u32 samples_per_sec;
	u32 avg_bytes_per_sec;
	u16 block_align;
	u16 bits_per_sample;
	u16 extra_format_size;
	u16 valid_bits_per_sample;
	u32 channel_mask;
	u8 subformat[16];
};

struct acpi_nhlt_format_config {
	struct acpi_nhlt_wave_formatext format;
	struct acpi_nhlt_config config;
};

struct acpi_nhlt_formats_config {
	u8 formats_count;
	struct acpi_nhlt_format_config formats[0];
} __attribute__((packed));

union acpi_object {
	acpi_object_type type;
	struct {
		acpi_object_type type;
		u64 value;
	} integer;
	struct {
		acpi_object_type type;
		u32 length;
		char *pointer;
	} string;
	struct {
		acpi_object_type type;
		u32 length;
		u8 *pointer;
	} buffer;
	struct {
		acpi_object_type type;
		u32 count;
		union acpi_object *elements;
	} package;
	struct {
		acpi_object_type type;
		acpi_object_type actual_type;
		acpi_handle handle;
	} reference;
	struct {
		acpi_object_type type;
		u32 proc_id;
		acpi_io_address pblk_address;
		u32 pblk_length;
	} processor;
	struct {
		acpi_object_type type;
		u32 system_level;
		u32 resource_order;
	} power_resource;
};

struct acpi_object_list {
	u32 count;
	union acpi_object *pointer;
};

struct acpi_offsets {
	size_t offset;
	u8 mode;
};

struct acpi_opcode_info {
	char *name;
	u32 parse_args;
	u32 runtime_args;
	u16 flags;
	u8 object_type;
	u8 class;
	u8 type;
};

typedef void (*acpi_osd_exec_callback)(void *);

struct acpi_os_dpc {
	acpi_osd_exec_callback function;
	void *context;
	struct work_struct work;
};

struct acpi_osc_context {
	char *uuid_str;
	int rev;
	struct acpi_buffer cap;
	struct acpi_buffer ret;
};

struct acpi_osi_config {
	u8 default_disabling;
	unsigned int linux_enable: 1;
	unsigned int linux_dmi: 1;
	unsigned int linux_cmdline: 1;
	unsigned int darwin_enable: 1;
	unsigned int darwin_dmi: 1;
	unsigned int darwin_cmdline: 1;
};

struct acpi_osi_entry {
	char string[64];
	bool enable;
};

struct acpi_package_info {
	u8 type;
	u8 object_type1;
	u8 count1;
	u8 object_type2;
	u8 count2;
	u16 reserved;
} __attribute__((packed));

struct acpi_package_info2 {
	u8 type;
	u8 count;
	u8 object_type[4];
	u8 reserved;
};

struct acpi_package_info3 {
	u8 type;
	u8 count;
	u8 object_type[2];
	u8 tail_object_type;
	u16 reserved;
} __attribute__((packed));

struct acpi_package_info4 {
	u8 type;
	u8 object_type1;
	u8 count1;
	u8 sub_object_types;
	u8 pkg_count;
	u16 reserved;
} __attribute__((packed));

struct acpi_parse_state {
	u8 *aml_start;
	u8 *aml;
	u8 *aml_end;
	u8 *pkg_start;
	u8 *pkg_end;
	union acpi_parse_object *start_op;
	struct acpi_namespace_node *start_node;
	union acpi_generic_state *scope;
	union acpi_parse_object *start_scope;
	u32 aml_size;
};

struct acpi_pcc_info {
	u8 subspace_id;
	u16 length;
	u8 *internal_buffer;
};

struct acpi_pcct_ext_pcc_master {
	struct acpi_subtable_header header;
	u32 platform_interrupt;
	u8 flags;
	u8 reserved1;
	u64 base_address;
	u32 length;
	struct acpi_generic_address doorbell_register;
	u64 preserve_mask;
	u64 write_mask;
	u32 latency;
	u32 max_access_rate;
	u32 min_turnaround_time;
	struct acpi_generic_address platform_ack_register;
	u64 ack_preserve_mask;
	u64 ack_set_mask;
	u64 reserved2;
	struct acpi_generic_address cmd_complete_register;
	u64 cmd_complete_mask;
	struct acpi_generic_address cmd_update_register;
	u64 cmd_update_preserve_mask;
	u64 cmd_update_set_mask;
	struct acpi_generic_address error_status_register;
	u64 error_status_mask;
} __attribute__((packed));

struct acpi_pcct_ext_pcc_shared_memory {
	u32 signature;
	u32 flags;
	u32 length;
	u32 command;
};

struct acpi_pcct_ext_pcc_slave {
	struct acpi_subtable_header header;
	u32 platform_interrupt;
	u8 flags;
	u8 reserved1;
	u64 base_address;
	u32 length;
	struct acpi_generic_address doorbell_register;
	u64 preserve_mask;
	u64 write_mask;
	u32 latency;
	u32 max_access_rate;
	u32 min_turnaround_time;
	struct acpi_generic_address platform_ack_register;
	u64 ack_preserve_mask;
	u64 ack_set_mask;
	u64 reserved2;
	struct acpi_generic_address cmd_complete_register;
	u64 cmd_complete_mask;
	struct acpi_generic_address cmd_update_register;
	u64 cmd_update_preserve_mask;
	u64 cmd_update_set_mask;
	struct acpi_generic_address error_status_register;
	u64 error_status_mask;
} __attribute__((packed));

struct acpi_pcct_hw_reduced {
	struct acpi_subtable_header header;
	u32 platform_interrupt;
	u8 flags;
	u8 reserved;
	u64 base_address;
	u64 length;
	struct acpi_generic_address doorbell_register;
	u64 preserve_mask;
	u64 write_mask;
	u32 latency;
	u32 max_access_rate;
	u16 min_turnaround_time;
} __attribute__((packed));

struct acpi_pcct_hw_reduced_type2 {
	struct acpi_subtable_header header;
	u32 platform_interrupt;
	u8 flags;
	u8 reserved;
	u64 base_address;
	u64 length;
	struct acpi_generic_address doorbell_register;
	u64 preserve_mask;
	u64 write_mask;
	u32 latency;
	u32 max_access_rate;
	u16 min_turnaround_time;
	struct acpi_generic_address platform_ack_register;
	u64 ack_preserve_mask;
	u64 ack_write_mask;
} __attribute__((packed));

struct acpi_pcct_shared_memory {
	u32 signature;
	u16 command;
	u16 status;
};

struct acpi_pcct_subspace {
	struct acpi_subtable_header header;
	u8 reserved[6];
	u64 base_address;
	u64 length;
	struct acpi_generic_address doorbell_register;
	u64 preserve_mask;
	u64 write_mask;
	u32 latency;
	u32 max_access_rate;
	u16 min_turnaround_time;
} __attribute__((packed));

struct acpi_pci_device {
	acpi_handle device;
	struct acpi_pci_device *next;
};

struct acpi_pci_id {
	u16 segment;
	u16 bus;
	u16 device;
	u16 function;
};

struct resource {
	resource_size_t start;
	resource_size_t end;
	const char *name;
	long unsigned int flags;
	long unsigned int desc;
	struct resource *parent;
	struct resource *sibling;
	struct resource *child;
};

struct pci_dev;

struct acpi_pci_ioapic {
	acpi_handle root_handle;
	acpi_handle handle;
	u32 gsi_base;
	struct resource res;
	struct pci_dev *pdev;
	struct list_head list;
};

struct acpi_pci_link_irq {
	u32 active;
	u8 triggering;
	u8 polarity;
	u8 resource_type;
	u8 possible_count;
	u32 possible[16];
	u8 initialized: 1;
	u8 reserved: 7;
};

struct acpi_pci_link {
	struct list_head list;
	struct acpi_device *device;
	struct acpi_pci_link_irq irq;
	int refcnt;
};

struct pci_bus;

struct acpi_pci_root {
	struct acpi_device *device;
	struct pci_bus *bus;
	u16 segment;
	int bridge_type;
	struct resource secondary;
	u32 osc_support_set;
	u32 osc_control_set;
	u32 osc_ext_support_set;
	u32 osc_ext_control_set;
	phys_addr_t mcfg_addr;
};

struct acpi_pci_root_ops;

struct acpi_pci_root_info {
	struct acpi_pci_root *root;
	struct acpi_device *bridge;
	struct acpi_pci_root_ops *ops;
	struct list_head resources;
	char name[16];
};

struct pci_ops;

struct acpi_pci_root_ops {
	struct pci_ops *pci_ops;
	int (*init_info)(struct acpi_pci_root_info *);
	void (*release_info)(struct acpi_pci_root_info *);
	int (*prepare_resources)(struct acpi_pci_root_info *);
};

struct acpi_pci_routing_table {
	u32 length;
	u32 pin;
	u64 address;
	u32 source_index;
	union {
		char pad[4];
		struct {
			struct {} __Empty_source;
			char source[0];
		};
	};
};

struct pci_slot;

struct acpi_pci_slot {
	struct pci_slot *pci_slot;
	struct list_head list;
};

struct acpi_pct_register {
	u8 descriptor;
	u16 length;
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 reserved;
	u64 address;
} __attribute__((packed));

struct acpi_pkg_info {
	u8 *free_space;
	acpi_size length;
	u32 object_space;
	u32 num_packages;
};

struct acpi_platform_list {
	char oem_id[7];
	char oem_table_id[9];
	u32 oem_revision;
	char *table;
	enum acpi_predicate pred;
	char *reason;
	u32 data;
};

struct acpi_pld_info {
	u8 revision;
	u8 ignore_color;
	u8 red;
	u8 green;
	u8 blue;
	u16 width;
	u16 height;
	u8 user_visible;
	u8 dock;
	u8 lid;
	u8 panel;
	u8 vertical_position;
	u8 horizontal_position;
	u8 shape;
	u8 group_orientation;
	u8 group_token;
	u8 group_position;
	u8 bay;
	u8 ejectable;
	u8 ospm_eject_required;
	u8 cabinet_number;
	u8 card_cage_number;
	u8 reference;
	u8 rotation;
	u8 order;
	u8 reserved;
	u16 vertical_offset;
	u16 horizontal_offset;
};

struct acpi_port_info {
	char *name;
	u16 start;
	u16 end;
	u8 osi_dependency;
};

struct acpi_power_dependent_device {
	struct device *dev;
	struct list_head node;
};

struct acpi_power_register {
	u8 descriptor;
	u16 length;
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_size;
	u64 address;
} __attribute__((packed));

struct acpi_power_resource {
	struct acpi_device device;
	struct list_head list_node;
	u32 system_level;
	u32 order;
	unsigned int ref_count;
	u8 state;
	struct mutex resource_lock;
	struct list_head dependents;
};

struct acpi_power_resource_entry {
	struct list_head node;
	struct acpi_power_resource *resource;
};

union acpi_predefined_info {
	struct acpi_name_info info;
	struct acpi_package_info ret_info;
	struct acpi_package_info2 ret_info2;
	struct acpi_package_info3 ret_info3;
	struct acpi_package_info4 ret_info4;
};

struct acpi_predefined_names {
	const char *name;
	u8 type;
	char *val;
};

struct acpi_prmt_handler_info {
	u16 revision;
	u16 length;
	u8 handler_guid[16];
	u64 handler_address;
	u64 static_data_buffer_address;
	u64 acpi_param_buffer_address;
} __attribute__((packed));

struct acpi_prmt_module_header {
	u16 revision;
	u16 length;
};

struct acpi_prmt_module_info {
	u16 revision;
	u16 length;
	u8 module_guid[16];
	u16 major_rev;
	u16 minor_rev;
	u16 handler_info_count;
	u32 handler_info_offset;
	u64 mmio_list_pointer;
} __attribute__((packed));

struct acpi_probe_entry;

typedef bool (*acpi_probe_entry_validate_subtbl)(struct acpi_subtable_header *, struct acpi_probe_entry *);

struct acpi_table_header;

typedef int (*acpi_tbl_table_handler)(struct acpi_table_header *);

union acpi_subtable_headers;

typedef int (*acpi_tbl_entry_handler)(union acpi_subtable_headers *, const long unsigned int);

struct acpi_probe_entry {
	__u8 id[5];
	__u8 type;
	acpi_probe_entry_validate_subtbl subtable_valid;
	union {
		acpi_tbl_table_handler probe_table;
		acpi_tbl_entry_handler probe_subtbl;
	};
	kernel_ulong_t driver_data;
};

struct acpi_processor_flags {
	u8 power: 1;
	u8 performance: 1;
	u8 throttling: 1;
	u8 limit: 1;
	u8 bm_control: 1;
	u8 bm_check: 1;
	u8 has_cst: 1;
	u8 has_lpi: 1;
	u8 power_setup_done: 1;
	u8 bm_rld_set: 1;
	u8 previously_online: 1;
};

struct acpi_processor_cx {
	u8 valid;
	u8 type;
	u32 address;
	u8 entry_method;
	u8 index;
	u32 latency;
	u8 bm_sts_skip;
	char desc[32];
};

struct acpi_processor_power {
	int count;
	union {
		struct acpi_processor_cx states[8];
		struct acpi_lpi_state lpi_states[8];
	};
	int timer_broadcast_on_state;
};

struct acpi_tsd_package {
	u64 num_entries;
	u64 revision;
	u64 domain;
	u64 coord_type;
	u64 num_processors;
};

typedef struct cpumask *cpumask_var_t;

struct acpi_processor_tx {
	u16 power;
	u16 performance;
};

struct acpi_processor_tx_tss;

struct acpi_processor;

struct acpi_processor_throttling {
	unsigned int state;
	unsigned int platform_limit;
	struct acpi_pct_register control_register;
	struct acpi_pct_register status_register;
	unsigned int state_count;
	struct acpi_processor_tx_tss *states_tss;
	struct acpi_tsd_package domain_info;
	cpumask_var_t shared_cpu_map;
	int (*acpi_processor_get_throttling)(struct acpi_processor *);
	int (*acpi_processor_set_throttling)(struct acpi_processor *, int, bool);
	u32 address;
	u8 duty_offset;
	u8 duty_width;
	u8 tsd_valid_flag;
	unsigned int shared_type;
	struct acpi_processor_tx states[16];
};

struct acpi_processor_lx {
	int px;
	int tx;
};

struct acpi_processor_limit {
	struct acpi_processor_lx state;
	struct acpi_processor_lx thermal;
	struct acpi_processor_lx user;
};

struct plist_node {
	int prio;
	struct list_head prio_list;
	struct list_head node_list;
};

struct freq_constraints;

struct freq_qos_request {
	enum freq_qos_req_type type;
	struct plist_node pnode;
	struct freq_constraints *qos;
};

struct acpi_processor_performance;

struct acpi_processor {
	acpi_handle handle;
	u32 acpi_id;
	phys_cpuid_t phys_id;
	u32 id;
	u32 pblk;
	int performance_platform_limit;
	int throttling_platform_limit;
	struct acpi_processor_flags flags;
	struct acpi_processor_power power;
	struct acpi_processor_performance *performance;
	struct acpi_processor_throttling throttling;
	struct acpi_processor_limit limit;
	struct thermal_cooling_device *cdev;
	struct device *dev;
	struct freq_qos_request perflib_req;
	struct freq_qos_request thermal_req;
};

struct acpi_processor_errata {
	u8 smp;
	struct {
		u8 throttle: 1;
		u8 fdma: 1;
		u8 reserved: 6;
		u32 bmisx;
	} piix4;
};

struct acpi_psd_package {
	u64 num_entries;
	u64 revision;
	u64 domain;
	u64 coord_type;
	u64 num_processors;
};

struct acpi_processor_px;

struct acpi_processor_performance {
	unsigned int state;
	unsigned int platform_limit;
	struct acpi_pct_register control_register;
	struct acpi_pct_register status_register;
	unsigned int state_count;
	struct acpi_processor_px *states;
	struct acpi_psd_package domain_info;
	cpumask_var_t shared_cpu_map;
	unsigned int shared_type;
};

struct acpi_processor_px {
	u64 core_frequency;
	u64 power;
	u64 transition_latency;
	u64 bus_master_latency;
	u64 control;
	u64 status;
};

struct acpi_processor_throttling_arg {
	struct acpi_processor *pr;
	int target_state;
	bool force;
};

struct acpi_processor_tx_tss {
	u64 freqpercentage;
	u64 power;
	u64 transition_latency;
	u64 control;
	u64 status;
};

struct acpi_prt_entry {
	struct acpi_pci_id id;
	u8 pin;
	acpi_handle link;
	u32 index;
};

struct acpi_reg_walk_info {
	u32 function;
	u32 reg_run_count;
	acpi_adr_space_type space_id;
};

typedef acpi_status (*acpi_repair_function)(struct acpi_evaluate_info *, union acpi_operand_object **);

struct acpi_repair_info {
	char name[4];
	acpi_repair_function repair_function;
};

struct acpi_resource_irq {
	u8 descriptor_length;
	u8 triggering;
	u8 polarity;
	u8 shareable;
	u8 wake_capable;
	u8 interrupt_count;
	union {
		u8 interrupt;
		struct {
			struct {} __Empty_interrupts;
			u8 interrupts[0];
		};
	};
};

struct acpi_resource_dma {
	u8 type;
	u8 bus_master;
	u8 transfer;
	u8 channel_count;
	union {
		u8 channel;
		struct {
			struct {} __Empty_channels;
			u8 channels[0];
		};
	};
};

struct acpi_resource_start_dependent {
	u8 descriptor_length;
	u8 compatibility_priority;
	u8 performance_robustness;
};

struct acpi_resource_io {
	u8 io_decode;
	u8 alignment;
	u8 address_length;
	u16 minimum;
	u16 maximum;
} __attribute__((packed));

struct acpi_resource_fixed_io {
	u16 address;
	u8 address_length;
} __attribute__((packed));

struct acpi_resource_fixed_dma {
	u16 request_lines;
	u16 channels;
	u8 width;
} __attribute__((packed));

struct acpi_resource_vendor {
	u16 byte_length;
	u8 byte_data[0];
};

struct acpi_resource_vendor_typed {
	u16 byte_length;
	u8 uuid_subtype;
	u8 uuid[16];
	u8 byte_data[0];
} __attribute__((packed));

struct acpi_resource_end_tag {
	u8 checksum;
};

struct acpi_resource_memory24 {
	u8 write_protect;
	u16 minimum;
	u16 maximum;
	u16 alignment;
	u16 address_length;
} __attribute__((packed));

struct acpi_resource_memory32 {
	u8 write_protect;
	u32 minimum;
	u32 maximum;
	u32 alignment;
	u32 address_length;
} __attribute__((packed));

struct acpi_resource_fixed_memory32 {
	u8 write_protect;
	u32 address;
	u32 address_length;
} __attribute__((packed));

union acpi_resource_attribute {
	struct acpi_memory_attribute mem;
	struct acpi_io_attribute io;
	u8 type_specific;
};

struct acpi_resource_source {
	u8 index;
	u16 string_length;
	char *string_ptr;
} __attribute__((packed));

struct acpi_resource_address16 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	struct acpi_address16_attribute address;
	struct acpi_resource_source resource_source;
} __attribute__((packed));

struct acpi_resource_address32 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	struct acpi_address32_attribute address;
	struct acpi_resource_source resource_source;
} __attribute__((packed));

struct acpi_resource_address64 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	struct acpi_address64_attribute address;
	struct acpi_resource_source resource_source;
} __attribute__((packed));

struct acpi_resource_extended_address64 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	u8 revision_ID;
	struct acpi_address64_attribute address;
	u64 type_specific;
} __attribute__((packed));

struct acpi_resource_extended_irq {
	u8 producer_consumer;
	u8 triggering;
	u8 polarity;
	u8 shareable;
	u8 wake_capable;
	u8 interrupt_count;
	struct acpi_resource_source resource_source;
	union {
		u32 interrupt;
		struct {
			struct {} __Empty_interrupts;
			u32 interrupts[0];
		};
	};
} __attribute__((packed));

struct acpi_resource_generic_register {
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_size;
	u64 address;
} __attribute__((packed));

struct acpi_resource_gpio {
	u8 revision_id;
	u8 connection_type;
	u8 producer_consumer;
	u8 pin_config;
	u8 shareable;
	u8 wake_capable;
	u8 io_restriction;
	u8 triggering;
	u8 polarity;
	u16 drive_strength;
	u16 debounce_timeout;
	u16 pin_table_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u16 *pin_table;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_i2c_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 access_mode;
	u16 slave_address;
	u32 connection_speed;
} __attribute__((packed));

struct acpi_resource_spi_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 wire_mode;
	u8 device_polarity;
	u8 data_bit_length;
	u8 clock_phase;
	u8 clock_polarity;
	u16 device_selection;
	u32 connection_speed;
} __attribute__((packed));

struct acpi_resource_uart_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 endian;
	u8 data_bits;
	u8 stop_bits;
	u8 flow_control;
	u8 parity;
	u8 lines_enabled;
	u16 rx_fifo_size;
	u16 tx_fifo_size;
	u32 default_baud_rate;
} __attribute__((packed));

struct acpi_resource_csi2_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 local_port_instance;
	u8 phy_type;
} __attribute__((packed));

struct acpi_resource_common_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_pin_function {
	u8 revision_id;
	u8 pin_config;
	u8 shareable;
	u16 function_number;
	u16 pin_table_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u16 *pin_table;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_pin_config {
	u8 revision_id;
	u8 producer_consumer;
	u8 shareable;
	u8 pin_config_type;
	u32 pin_config_value;
	u16 pin_table_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u16 *pin_table;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_label {
	u16 string_length;
	char *string_ptr;
} __attribute__((packed));

struct acpi_resource_pin_group {
	u8 revision_id;
	u8 producer_consumer;
	u16 pin_table_length;
	u16 vendor_length;
	u16 *pin_table;
	struct acpi_resource_label resource_label;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_pin_group_function {
	u8 revision_id;
	u8 producer_consumer;
	u8 shareable;
	u16 function_number;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	struct acpi_resource_label resource_source_label;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_pin_group_config {
	u8 revision_id;
	u8 producer_consumer;
	u8 shareable;
	u8 pin_config_type;
	u32 pin_config_value;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	struct acpi_resource_label resource_source_label;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_clock_input {
	u8 revision_id;
	u8 mode;
	u8 scale;
	u16 frequency_divisor;
	u32 frequency_numerator;
	struct acpi_resource_source resource_source;
} __attribute__((packed));

struct acpi_resource_address {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
};

union acpi_resource_data {
	struct acpi_resource_irq irq;
	struct acpi_resource_dma dma;
	struct acpi_resource_start_dependent start_dpf;
	struct acpi_resource_io io;
	struct acpi_resource_fixed_io fixed_io;
	struct acpi_resource_fixed_dma fixed_dma;
	struct acpi_resource_vendor vendor;
	struct acpi_resource_vendor_typed vendor_typed;
	struct acpi_resource_end_tag end_tag;
	struct acpi_resource_memory24 memory24;
	struct acpi_resource_memory32 memory32;
	struct acpi_resource_fixed_memory32 fixed_memory32;
	struct acpi_resource_address16 address16;
	struct acpi_resource_address32 address32;
	struct acpi_resource_address64 address64;
	struct acpi_resource_extended_address64 ext_address64;
	struct acpi_resource_extended_irq extended_irq;
	struct acpi_resource_generic_register generic_reg;
	struct acpi_resource_gpio gpio;
	struct acpi_resource_i2c_serialbus i2c_serial_bus;
	struct acpi_resource_spi_serialbus spi_serial_bus;
	struct acpi_resource_uart_serialbus uart_serial_bus;
	struct acpi_resource_csi2_serialbus csi2_serial_bus;
	struct acpi_resource_common_serialbus common_serial_bus;
	struct acpi_resource_pin_function pin_function;
	struct acpi_resource_pin_config pin_config;
	struct acpi_resource_pin_group pin_group;
	struct acpi_resource_pin_group_function pin_group_function;
	struct acpi_resource_pin_group_config pin_group_config;
	struct acpi_resource_clock_input clock_input;
	struct acpi_resource_address address;
};

struct acpi_resource {
	u32 type;
	u32 length;
	union acpi_resource_data data;
};

struct acpi_rsconvert_info {
	u8 opcode;
	u8 resource_offset;
	u8 aml_offset;
	u8 value;
};

struct acpi_rsdump_info {
	u8 opcode;
	u8 offset;
	const char *name;
	const char **pointer;
} __attribute__((packed));

struct acpi_rw_lock {
	void *writer_mutex;
	void *reader_mutex;
	u32 num_readers;
};

struct acpi_s2idle_dev_ops {
	struct list_head list_node;
	void (*prepare)(void);
	void (*check)(void);
	void (*restore)(void);
};

struct acpi_scan_clear_dep_work {
	struct work_struct work;
	struct acpi_device *adev;
};

struct acpi_scan_handler {
	struct list_head list_node;
	const struct acpi_device_id *ids;
	bool (*match)(const char *, const struct acpi_device_id **);
	int (*attach)(struct acpi_device *, const struct acpi_device_id *);
	void (*detach)(struct acpi_device *);
	void (*post_eject)(struct acpi_device *);
	void (*bind)(struct device *);
	void (*unbind)(struct device *);
	struct acpi_hotplug_profile hotplug;
};

typedef u32 (*acpi_sci_handler)(void *);

struct acpi_sci_handler_info {
	struct acpi_sci_handler_info *next;
	acpi_sci_handler address;
	void *context;
};

struct acpi_serdev_lookup {
	acpi_handle device_handle;
	acpi_handle controller_handle;
	int n;
	int index;
};

struct acpi_signal_fatal_info {
	u32 type;
	u32 code;
	u32 argument;
};

typedef acpi_status (*acpi_object_converter)(struct acpi_namespace_node *, union acpi_operand_object *, union acpi_operand_object **);

struct acpi_simple_repair_info {
	char name[4];
	u32 unexpected_btypes;
	u32 package_index;
	acpi_object_converter object_converter;
};

struct spi_controller;

struct acpi_spi_lookup {
	struct spi_controller *ctlr;
	u32 max_speed_hz;
	u32 mode;
	int irq;
	u8 bits_per_word;
	u8 chip_select;
	int n;
	int index;
};

struct acpi_srat_cpu_affinity {
	struct acpi_subtable_header header;
	u8 proximity_domain_lo;
	u8 apic_id;
	u32 flags;
	u8 local_sapic_eid;
	u8 proximity_domain_hi[3];
	u32 clock_domain;
};

struct acpi_srat_generic_affinity {
	struct acpi_subtable_header header;
	u8 reserved;
	u8 device_handle_type;
	u32 proximity_domain;
	u8 device_handle[16];
	u32 flags;
	u32 reserved1;
};

struct acpi_srat_gicc_affinity {
	struct acpi_subtable_header header;
	u32 proximity_domain;
	u32 acpi_processor_uid;
	u32 flags;
	u32 clock_domain;
} __attribute__((packed));

struct acpi_srat_mem_affinity {
	struct acpi_subtable_header header;
	u32 proximity_domain;
	u16 reserved;
	u64 base_address;
	u64 length;
	u32 reserved1;
	u32 flags;
	u64 reserved2;
} __attribute__((packed));

struct acpi_srat_rintc_affinity {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 proximity_domain;
	u32 acpi_processor_uid;
	u32 flags;
	u32 clock_domain;
};

struct acpi_srat_x2apic_cpu_affinity {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 proximity_domain;
	u32 apic_id;
	u32 flags;
	u32 clock_domain;
	u32 reserved2;
};

struct acpi_subtable_entry {
	union acpi_subtable_headers *hdr;
	enum acpi_subtable_type type;
};

union acpi_subtable_headers {
	struct acpi_subtable_header common;
	struct acpi_hmat_structure hmat;
	struct acpi_prmt_module_header prmt;
	struct acpi_cedt_header cedt;
	struct acpi_cdat_header cdat;
};

typedef int (*acpi_tbl_entry_handler_arg)(union acpi_subtable_headers *, void *, const long unsigned int);

struct acpi_subtable_proc {
	int id;
	acpi_tbl_entry_handler handler;
	acpi_tbl_entry_handler_arg handler_arg;
	void *arg;
	int count;
};

struct acpi_table_attr {
	struct bin_attribute attr;
	char name[4];
	int instance;
	char filename[8];
	struct list_head node;
};

struct acpi_table_header {
	char signature[4];
	u32 length;
	u8 revision;
	u8 checksum;
	char oem_id[6];
	char oem_table_id[8];
	u32 oem_revision;
	char asl_compiler_id[4];
	u32 asl_compiler_revision;
};

struct acpi_table_bert {
	struct acpi_table_header header;
	u32 region_length;
	u64 address;
};

struct acpi_table_bgrt {
	struct acpi_table_header header;
	u16 version;
	u8 status;
	u8 image_type;
	u64 image_address;
	u32 image_offset_x;
	u32 image_offset_y;
};

struct acpi_table_boot {
	struct acpi_table_header header;
	u8 cmos_index;
	u8 reserved[3];
};

struct acpi_table_ccel {
	struct acpi_table_header header;
	u8 CCtype;
	u8 Ccsub_type;
	u16 reserved;
	u64 log_area_minimum_length;
	u64 log_area_start_address;
};

struct acpi_table_cdat {
	u32 length;
	u8 revision;
	u8 checksum;
	u8 reserved[6];
	u32 sequence;
};

struct acpi_table_csrt {
	struct acpi_table_header header;
};

struct acpi_table_desc {
	acpi_physical_address address;
	struct acpi_table_header *pointer;
	u32 length;
	union acpi_name_union signature;
	acpi_owner_id owner_id;
	u8 flags;
	u16 validation_count;
};

struct acpi_table_dmar {
	struct acpi_table_header header;
	u8 width;
	u8 flags;
	u8 reserved[10];
};

struct acpi_table_ecdt {
	struct acpi_table_header header;
	struct acpi_generic_address control;
	struct acpi_generic_address data;
	u32 uid;
	u8 gpe;
	u8 id[0];
} __attribute__((packed));

struct acpi_table_erst {
	struct acpi_table_header header;
	u32 header_length;
	u32 reserved;
	u32 entries;
};

struct acpi_table_facs {
	char signature[4];
	u32 length;
	u32 hardware_signature;
	u32 firmware_waking_vector;
	u32 global_lock;
	u32 flags;
	u64 xfirmware_waking_vector;
	u8 version;
	u8 reserved[3];
	u32 ospm_flags;
	u8 reserved1[24];
};

struct acpi_table_fadt {
	struct acpi_table_header header;
	u32 facs;
	u32 dsdt;
	u8 model;
	u8 preferred_profile;
	u16 sci_interrupt;
	u32 smi_command;
	u8 acpi_enable;
	u8 acpi_disable;
	u8 s4_bios_request;
	u8 pstate_control;
	u32 pm1a_event_block;
	u32 pm1b_event_block;
	u32 pm1a_control_block;
	u32 pm1b_control_block;
	u32 pm2_control_block;
	u32 pm_timer_block;
	u32 gpe0_block;
	u32 gpe1_block;
	u8 pm1_event_length;
	u8 pm1_control_length;
	u8 pm2_control_length;
	u8 pm_timer_length;
	u8 gpe0_block_length;
	u8 gpe1_block_length;
	u8 gpe1_base;
	u8 cst_control;
	u16 c2_latency;
	u16 c3_latency;
	u16 flush_size;
	u16 flush_stride;
	u8 duty_offset;
	u8 duty_width;
	u8 day_alarm;
	u8 month_alarm;
	u8 century;
	u16 boot_flags;
	u8 reserved;
	u32 flags;
	struct acpi_generic_address reset_register;
	u8 reset_value;
	u16 arm_boot_flags;
	u8 minor_revision;
	u64 Xfacs;
	u64 Xdsdt;
	struct acpi_generic_address xpm1a_event_block;
	struct acpi_generic_address xpm1b_event_block;
	struct acpi_generic_address xpm1a_control_block;
	struct acpi_generic_address xpm1b_control_block;
	struct acpi_generic_address xpm2_control_block;
	struct acpi_generic_address xpm_timer_block;
	struct acpi_generic_address xgpe0_block;
	struct acpi_generic_address xgpe1_block;
	struct acpi_generic_address sleep_control;
	struct acpi_generic_address sleep_status;
	u64 hypervisor_id;
} __attribute__((packed));

struct acpi_table_hest {
	struct acpi_table_header header;
	u32 error_source_count;
};

struct acpi_table_hpet {
	struct acpi_table_header header;
	u32 id;
	struct acpi_generic_address address;
	u8 sequence;
	u16 minimum_tick;
	u8 flags;
} __attribute__((packed));

struct acpi_table_list {
	struct acpi_table_desc *tables;
	u32 current_table_count;
	u32 max_table_count;
	u8 flags;
};

struct acpi_table_lpit {
	struct acpi_table_header header;
};

struct acpi_table_madt {
	struct acpi_table_header header;
	u32 address;
	u32 flags;
};

struct acpi_table_mcfg {
	struct acpi_table_header header;
	u8 reserved[8];
};

struct acpi_table_mrrm {
	struct acpi_table_header header;
	u8 max_mem_region;
	u8 flags;
	u8 reserved[26];
	u8 memory_range_entry[0];
};

struct acpi_table_nhlt {
	struct acpi_table_header header;
	u8 endpoints_count;
} __attribute__((packed));

struct acpi_table_pcct {
	struct acpi_table_header header;
	u32 flags;
	u64 reserved;
};

struct acpi_table_rsdp {
	char signature[8];
	u8 checksum;
	char oem_id[6];
	u8 revision;
	u32 rsdt_physical_address;
	u32 length;
	u64 xsdt_physical_address;
	u8 extended_checksum;
	u8 reserved[3];
} __attribute__((packed));

struct acpi_table_slit {
	struct acpi_table_header header;
	u64 locality_count;
	u8 entry[0];
} __attribute__((packed));

struct acpi_table_spcr {
	struct acpi_table_header header;
	u8 interface_type;
	u8 reserved[3];
	struct acpi_generic_address serial_port;
	u8 interrupt_type;
	u8 pc_interrupt;
	u32 interrupt;
	u8 baud_rate;
	u8 parity;
	u8 stop_bits;
	u8 flow_control;
	u8 terminal_type;
	u8 language;
	u16 pci_device_id;
	u16 pci_vendor_id;
	u8 pci_bus;
	u8 pci_device;
	u8 pci_function;
	u32 pci_flags;
	u8 pci_segment;
	u32 uart_clk_freq;
	u32 precise_baudrate;
	u16 name_space_string_length;
	u16 name_space_string_offset;
	char name_space_string[0];
} __attribute__((packed));

struct acpi_table_srat {
	struct acpi_table_header header;
	u32 table_revision;
	u64 reserved;
};

struct acpi_table_stao {
	struct acpi_table_header header;
	u8 ignore_uart;
} __attribute__((packed));

struct acpi_table_tpm2 {
	struct acpi_table_header header;
	u16 platform_class;
	u16 reserved;
	u64 control_address;
	u32 start_method;
} __attribute__((packed));

struct acpi_table_viot {
	struct acpi_table_header header;
	u16 node_count;
	u16 node_offset;
	u8 reserved[8];
};

struct acpi_table_wdat {
	struct acpi_table_header header;
	u32 header_length;
	u16 pci_segment;
	u8 pci_bus;
	u8 pci_device;
	u8 pci_function;
	u8 reserved[3];
	u32 timer_period;
	u32 max_count;
	u32 min_count;
	u8 flags;
	u8 reserved2[3];
	u32 entries;
};

struct client_hdr {
	u32 log_max_len;
	u64 log_start_addr;
} __attribute__((packed));

struct server_hdr {
	u16 reserved;
	u64 log_max_len;
	u64 log_start_addr;
} __attribute__((packed));

struct acpi_tcpa {
	struct acpi_table_header hdr;
	u16 platform_class;
	union {
		struct client_hdr client;
		struct server_hdr server;
	};
};

struct acpi_thermal_trip {
	long unsigned int temp_dk;
	struct acpi_handle_list devices;
};

struct acpi_thermal_passive {
	struct acpi_thermal_trip trip;
	long unsigned int tc1;
	long unsigned int tc2;
	long unsigned int delay;
};

struct acpi_thermal_active {
	struct acpi_thermal_trip trip;
};

struct acpi_thermal_trips {
	struct acpi_thermal_passive passive;
	struct acpi_thermal_active active[10];
};

struct thermal_zone_device;

struct acpi_thermal {
	struct acpi_device *device;
	acpi_bus_id name;
	long unsigned int temp_dk;
	long unsigned int last_temp_dk;
	long unsigned int polling_frequency;
	volatile u8 zombie;
	struct acpi_thermal_trips trips;
	struct thermal_zone_device *thermal_zone;
	int kelvin_offset;
	struct work_struct thermal_check_work;
	struct mutex thermal_check_lock;
	refcount_t thermal_check_count;
};

struct acpi_tpm2_phy {
	u8 start_method_specific[12];
	u32 log_area_minimum_length;
	u64 log_area_start_address;
};

struct acpi_vendor_uuid {
	u8 subtype;
	u8 data[16];
};

struct acpi_vendor_walk_info {
	struct acpi_vendor_uuid *uuid;
	struct acpi_buffer *buffer;
	acpi_status status;
};

struct acpi_viot_header {
	u8 type;
	u8 reserved;
	u16 length;
};

struct acpi_viot_mmio {
	struct acpi_viot_header header;
	u32 endpoint;
	u64 base_address;
	u16 output_node;
	u8 reserved[6];
};

struct acpi_viot_pci_range {
	struct acpi_viot_header header;
	u32 endpoint_start;
	u16 segment_start;
	u16 segment_end;
	u16 bdf_start;
	u16 bdf_end;
	u16 output_node;
	u8 reserved[6];
};

struct acpi_viot_virtio_iommu_mmio {
	struct acpi_viot_header header;
	u8 reserved[4];
	u64 base_address;
};

struct acpi_viot_virtio_iommu_pci {
	struct acpi_viot_header header;
	u16 segment;
	u16 bdf;
	u8 reserved[8];
};

struct acpi_wakeup_handler {
	struct list_head list_node;
	bool (*wakeup)(void *);
	void *context;
};

struct acpi_walk_info {
	u32 debug_level;
	u32 count;
	acpi_owner_id owner_id;
	u8 display_type;
};

typedef acpi_status (*acpi_parse_downwards)(struct acpi_walk_state *, union acpi_parse_object **);

typedef acpi_status (*acpi_parse_upwards)(struct acpi_walk_state *);

struct acpi_walk_state {
	struct acpi_walk_state *next;
	u8 descriptor_type;
	u8 walk_type;
	u16 opcode;
	u8 next_op_info;
	u8 num_operands;
	u8 operand_index;
	acpi_owner_id owner_id;
	u8 last_predicate;
	u8 current_result;
	u8 return_used;
	u8 scope_depth;
	u8 pass_number;
	u8 namespace_override;
	u8 result_size;
	u8 result_count;
	u8 *aml;
	u32 arg_types;
	u32 method_breakpoint;
	u32 user_breakpoint;
	u32 parse_flags;
	struct acpi_parse_state parser_state;
	u32 prev_arg_types;
	u32 arg_count;
	u16 method_nesting_depth;
	u8 method_is_nested;
	struct acpi_namespace_node arguments[7];
	struct acpi_namespace_node local_variables[8];
	union acpi_operand_object *operands[9];
	union acpi_operand_object **params;
	u8 *aml_last_while;
	union acpi_operand_object **caller_return_desc;
	union acpi_generic_state *control_state;
	struct acpi_namespace_node *deferred_node;
	union acpi_operand_object *implicit_return_obj;
	struct acpi_namespace_node *method_call_node;
	union acpi_parse_object *method_call_op;
	union acpi_operand_object *method_desc;
	struct acpi_namespace_node *method_node;
	char *method_pathname;
	union acpi_parse_object *op;
	const struct acpi_opcode_info *op_info;
	union acpi_parse_object *origin;
	union acpi_operand_object *result_obj;
	union acpi_generic_state *results;
	union acpi_operand_object *return_desc;
	union acpi_generic_state *scope_info;
	union acpi_parse_object *prev_op;
	union acpi_parse_object *next_op;
	struct acpi_thread_state *thread;
	acpi_parse_downwards descending_callback;
	acpi_parse_upwards ascending_callback;
};

struct acpi_wdat_entry {
	u8 action;
	u8 instruction;
	u16 reserved;
	struct acpi_generic_address register_region;
	u32 value;
	u32 mask;
};

struct acpi_whea_header {
	u8 action;
	u8 instruction;
	u8 flags;
	u8 reserved;
	struct acpi_generic_address register_region;
	u64 value;
	u64 mask;
};

struct acpihid_map_entry {
	struct list_head list;
	u8 uid[256];
	u8 hid[9];
	u32 devid;
	u32 root_devid;
	bool cmd_line;
	struct iommu_group *group;
};

struct hotplug_slot;

struct acpiphp_attention_info {
	int (*set_attn)(struct hotplug_slot *, u8);
	int (*get_attn)(struct hotplug_slot *, u8 *);
	struct module *owner;
};

struct acpiphp_context;

struct acpiphp_bridge {
	struct list_head list;
	struct list_head slots;
	struct kref ref;
	struct acpiphp_context *context;
	int nr_slots;
	struct pci_bus *pci_bus;
	struct pci_dev *pci_dev;
	bool is_going_away;
};

struct acpiphp_slot;

struct acpiphp_func {
	struct acpiphp_bridge *parent;
	struct acpiphp_slot *slot;
	struct list_head sibling;
	u8 function;
	u32 flags;
};

struct acpiphp_context {
	struct acpi_hotplug_context hp;
	struct acpiphp_func func;
	struct acpiphp_bridge *bridge;
	unsigned int refcount;
};

struct acpiphp_root_context {
	struct acpi_hotplug_context hp;
	struct acpiphp_bridge *root_bridge;
};

struct slot;

struct acpiphp_slot {
	struct list_head node;
	struct pci_bus *bus;
	struct list_head funcs;
	struct slot *slot;
	u8 device;
	u32 flags;
};

struct pnp_dev;

struct acpipnp_parse_option_s {
	struct pnp_dev *dev;
	unsigned int option_flags;
};

struct action_cache {
	long unsigned int allow_native[8];
	long unsigned int allow_compat[8];
};

struct hist_trigger_data;

struct tracing_map_elt;

struct trace_buffer;

struct ring_buffer_event;

struct action_data;

typedef void (*action_fn_t)(struct hist_trigger_data *, struct tracing_map_elt *, struct trace_buffer *, void *, struct ring_buffer_event *, void *, struct action_data *, u64 *);

typedef bool (*check_track_val_fn_t)(u64, u64);

struct synth_event;

struct hist_field;

struct action_data {
	enum handler_id handler;
	enum action_id action;
	char *action_name;
	action_fn_t fn;
	unsigned int n_params;
	char *params[64];
	unsigned int var_ref_idx[64];
	struct synth_event *synth_event;
	bool use_trace_keyword;
	char *synth_event_name;
	union {
		struct {
			char *event;
			char *event_system;
		} match_data;
		struct {
			char *var_str;
			struct hist_field *var_ref;
			struct hist_field *track_var;
			check_track_val_fn_t check_val;
			action_fn_t save_data;
		} track_data;
	};
};

struct action_devres {
	void *data;
	void (*action)(void *);
};

struct action_gate_entry {
	u8 gate_state;
	u32 interval;
	s32 ipv;
	s32 maxoctets;
};

struct addr_marker {
	long unsigned int start_address;
	const char *name;
	long unsigned int max_lines;
};

struct rb_root_cached {
	struct rb_root rb_root;
	struct rb_node *rb_leftmost;
};

struct address_space_operations;

struct address_space {
	struct inode *host;
	struct xarray i_pages;
	struct rw_semaphore invalidate_lock;
	gfp_t gfp_mask;
	atomic_t i_mmap_writable;
	atomic_t nr_thps;
	struct rb_root_cached i_mmap;
	long unsigned int nrpages;
	long unsigned int writeback_index;
	const struct address_space_operations *a_ops;
	long unsigned int flags;
	errseq_t wb_err;
	spinlock_t i_private_lock;
	struct list_head i_private_list;
	struct rw_semaphore i_mmap_rwsem;
	void *i_private_data;
};

struct writeback_control;

struct readahead_control;

struct kiocb;

struct iov_iter;

struct swap_info_struct;

struct address_space_operations {
	int (*read_folio)(struct file *, struct folio *);
	int (*writepages)(struct address_space *, struct writeback_control *);
	bool (*dirty_folio)(struct address_space *, struct folio *);
	void (*readahead)(struct readahead_control *);
	int (*write_begin)(const struct kiocb *, struct address_space *, loff_t, unsigned int, struct folio **, void **);
	int (*write_end)(const struct kiocb *, struct address_space *, loff_t, unsigned int, unsigned int, struct folio *, void *);
	sector_t (*bmap)(struct address_space *, sector_t);
	void (*invalidate_folio)(struct folio *, size_t, size_t);
	bool (*release_folio)(struct folio *, gfp_t);
	void (*free_folio)(struct folio *);
	ssize_t (*direct_IO)(struct kiocb *, struct iov_iter *);
	int (*migrate_folio)(struct address_space *, struct folio *, struct folio *, enum migrate_mode);
	int (*launder_folio)(struct folio *);
	bool (*is_partially_uptodate)(struct folio *, size_t, size_t);
	void (*is_dirty_writeback)(struct folio *, bool *, bool *);
	int (*error_remove_folio)(struct address_space *, struct folio *);
	int (*swap_activate)(struct swap_info_struct *, struct file *, sector_t *);
	void (*swap_deactivate)(struct file *);
	int (*swap_rw)(struct kiocb *, struct iov_iter *);
};

struct audit_ntp_val {
	long long int oldval;
	long long int newval;
};

struct audit_ntp_data {
	struct audit_ntp_val vals[6];
};

struct timespec64 {
	time64_t tv_sec;
	long int tv_nsec;
};

struct adjtimex_result {
	struct audit_ntp_data ad;
	struct timespec64 delta;
	bool clock_set;
};

struct adjust_trip_data {
	struct acpi_thermal *tz;
	u32 event;
};

struct adp5520_backlight_platform_data {
	u8 fade_in;
	u8 fade_out;
	u8 fade_led_law;
	u8 en_ambl_sens;
	u8 abml_filt;
	u8 l1_daylight_max;
	u8 l1_daylight_dim;
	u8 l2_office_max;
	u8 l2_office_dim;
	u8 l3_dark_max;
	u8 l3_dark_dim;
	u8 l2_trip;
	u8 l2_hyst;
	u8 l3_trip;
	u8 l3_hyst;
};

struct blocking_notifier_head {
	struct rw_semaphore rwsem;
	struct notifier_block *head;
};

struct adp5520_chip {
	struct i2c_client *client;
	struct device *dev;
	struct mutex lock;
	struct blocking_notifier_head notifier_list;
	int irq;
	long unsigned int id;
	uint8_t mode;
};

struct adp5520_gpio_platform_data {
	unsigned int gpio_start;
	u8 gpio_en_mask;
	u8 gpio_pullup_mask;
};

struct adp5520_keys_platform_data {
	int rows_en_mask;
	int cols_en_mask;
	const short unsigned int *keymap;
	short unsigned int keymapsize;
	unsigned int repeat: 1;
};

struct led_info;

struct adp5520_leds_platform_data {
	int num_leds;
	struct led_info *leds;
	u8 fade_in;
	u8 fade_out;
	u8 led_on_time;
};

struct adp5520_platform_data {
	struct adp5520_keys_platform_data *keys;
	struct adp5520_gpio_platform_data *gpio;
	struct adp5520_leds_platform_data *leds;
	struct adp5520_backlight_platform_data *backlight;
};

struct advisor_ctx {
	ktime_t start_scan;
	long unsigned int scan_time;
	long unsigned int change;
	long long unsigned int cpu_time;
};

struct crypto_aead;

struct aead_request;

struct aead_alg {
	int (*setkey)(struct crypto_aead *, const u8 *, unsigned int);
	int (*setauthsize)(struct crypto_aead *, unsigned int);
	int (*encrypt)(struct aead_request *);
	int (*decrypt)(struct aead_request *);
	int (*init)(struct crypto_aead *);
	void (*exit)(struct crypto_aead *);
	unsigned int ivsize;
	unsigned int maxauthsize;
	unsigned int chunksize;
	struct crypto_alg base;
};

struct crypto_template;

struct crypto_spawn;

struct crypto_instance {
	struct crypto_alg alg;
	struct crypto_template *tmpl;
	union {
		struct hlist_node list;
		struct crypto_spawn *spawns;
	};
	void *__ctx[0];
};

struct aead_instance {
	void (*free)(struct aead_instance *);
	union {
		struct {
			char head[64];
			struct crypto_instance base;
		} s;
		struct aead_alg alg;
	};
};

struct aead_request {
	struct crypto_async_request base;
	unsigned int assoclen;
	unsigned int cryptlen;
	u8 *iv;
	struct scatterlist *src;
	struct scatterlist *dst;
	void *__ctx[0];
};

struct pcie_tlp_log {
	union {
		u32 dw[14];
		struct {
			u32 _do_not_use[4];
			u32 prefix[4];
		};
	};
	u8 header_len;
	bool flit;
};

struct aer_capability_regs {
	u32 header;
	u32 uncor_status;
	u32 uncor_mask;
	u32 uncor_severity;
	u32 cor_status;
	u32 cor_mask;
	u32 cap_control;
	struct pcie_tlp_log header_log;
	u32 root_command;
	u32 root_status;
	u16 cor_err_source;
	u16 uncor_err_source;
};

struct aer_err_info {
	struct pci_dev *dev[5];
	int ratelimit_print[5];
	int error_dev_num;
	const char *level;
	unsigned int id: 16;
	unsigned int severity: 2;
	unsigned int root_ratelimit_print: 1;
	unsigned int __pad1: 4;
	unsigned int multi_error_valid: 1;
	unsigned int first_error: 5;
	unsigned int __pad2: 2;
	unsigned int tlp_header_valid: 1;
	unsigned int status;
	unsigned int mask;
	struct pcie_tlp_log tlp;
};

struct aer_err_source {
	u32 status;
	u32 id;
};

struct ratelimit_state {
	raw_spinlock_t lock;
	int interval;
	int burst;
	atomic_t rs_n_left;
	atomic_t missed;
	unsigned int flags;
	long unsigned int begin;
};

struct aer_info {
	u64 dev_cor_errs[16];
	u64 dev_fatal_errs[27];
	u64 dev_nonfatal_errs[27];
	u64 dev_total_cor_errs;
	u64 dev_total_fatal_errs;
	u64 dev_total_nonfatal_errs;
	u64 rootport_total_cor_errs;
	u64 rootport_total_fatal_errs;
	u64 rootport_total_nonfatal_errs;
	struct ratelimit_state correctable_ratelimit;
	struct ratelimit_state nonfatal_ratelimit;
};

struct aer_recover_entry {
	u8 bus;
	u8 devfn;
	u16 domain;
	int severity;
	struct aer_capability_regs *regs;
};

struct aer_rpc {
	struct pci_dev *rpd;
	struct {
		union {
			struct __kfifo kfifo;
			struct aer_err_source *type;
			const struct aer_err_source *const_type;
			char (*rectype)[0];
			struct aer_err_source *ptr;
			const struct aer_err_source *ptr_const;
		};
		struct aer_err_source buf[128];
	} aer_fifo;
};

struct crypto_aes_ctx {
	u32 key_enc[60];
	u32 key_dec[60];
	u32 key_length;
};

struct aesgcm_ctx {
	be128 ghash_key;
	struct crypto_aes_ctx aes_ctx;
	unsigned int authsize;
};

struct affinity_context {
	const struct cpumask *new_mask;
	struct cpumask *user_mask;
	unsigned int flags;
};

struct aggregate_control {
	long int *aggregate;
	long int *local;
	long int *pending;
	long int *ppending;
	long int *cstat;
	long int *cstat_prev;
	int size;
};

struct component_master_ops;

struct component_match;

struct aggregate_device {
	struct list_head node;
	bool bound;
	const struct component_master_ops *ops;
	struct device *parent;
	struct component_match *match;
};

struct agp_3_5_dev {
	struct list_head list;
	u8 capndx;
	u32 maxbw;
	struct pci_dev *dev;
};

struct agp_version;

struct agp_bridge_driver;

struct vm_operations_struct;

struct page;

struct agp_bridge_data {
	const struct agp_version *version;
	const struct agp_bridge_driver *driver;
	const struct vm_operations_struct *vm_ops;
	void *previous_size;
	void *current_size;
	void *dev_private_data;
	struct pci_dev *dev;
	u32 *gatt_table;
	u32 *gatt_table_real;
	long unsigned int scratch_page;
	struct page *scratch_page_page;
	dma_addr_t scratch_page_dma;
	long unsigned int gart_bus_addr;
	long unsigned int gatt_bus_addr;
	u32 mode;
	long unsigned int *key_list;
	atomic_t current_memory_agp;
	atomic_t agp_in_use;
	int max_memory_agp;
	int aperture_size_idx;
	int capndx;
	int flags;
	char major_version;
	char minor_version;
	struct list_head list;
	u32 apbase_config;
	struct list_head mapped_list;
	spinlock_t mapped_lock;
};

struct gatt_mask;

struct agp_memory;

struct agp_bridge_driver {
	struct module *owner;
	const void *aperture_sizes;
	int num_aperture_sizes;
	enum aper_size_type size_type;
	bool cant_use_aperture;
	bool needs_scratch_page;
	const struct gatt_mask *masks;
	int (*fetch_size)(void);
	int (*configure)(void);
	void (*agp_enable)(struct agp_bridge_data *, u32);
	void (*cleanup)(void);
	void (*tlb_flush)(struct agp_memory *);
	long unsigned int (*mask_memory)(struct agp_bridge_data *, dma_addr_t, int);
	void (*cache_flush)(void);
	int (*create_gatt_table)(struct agp_bridge_data *);
	int (*free_gatt_table)(struct agp_bridge_data *);
	int (*insert_memory)(struct agp_memory *, off_t, int);
	int (*remove_memory)(struct agp_memory *, off_t, int);
	struct agp_memory * (*alloc_by_type)(size_t, int);
	void (*free_by_type)(struct agp_memory *);
	struct page * (*agp_alloc_page)(struct agp_bridge_data *);
	int (*agp_alloc_pages)(struct agp_bridge_data *, struct agp_memory *, size_t);
	void (*agp_destroy_page)(struct page *, int);
	void (*agp_destroy_pages)(struct agp_memory *);
	int (*agp_type_to_mask_type)(struct agp_bridge_data *, int);
};

struct agp_version {
	u16 major;
	u16 minor;
};

struct agp_kern_info {
	struct agp_version version;
	struct pci_dev *device;
	enum chipset_type chipset;
	long unsigned int mode;
	long unsigned int aper_base;
	size_t aper_size;
	int max_memory;
	int current_memory;
	bool cant_use_aperture;
	long unsigned int page_mask;
	const struct vm_operations_struct *vm_ops;
};

struct agp_memory {
	struct agp_memory *next;
	struct agp_memory *prev;
	struct agp_bridge_data *bridge;
	struct page **pages;
	size_t page_count;
	int key;
	int num_scratch_pages;
	off_t pg_start;
	u32 type;
	u32 physical;
	bool is_bound;
	bool is_flushed;
	struct list_head mapped_list;
	struct scatterlist *sg_list;
	int num_sg;
};

struct hash_alg_common {
	unsigned int digestsize;
	unsigned int statesize;
	struct crypto_alg base;
};

struct ahash_request;

struct crypto_ahash;

struct ahash_alg {
	int (*init)(struct ahash_request *);
	int (*update)(struct ahash_request *);
	int (*final)(struct ahash_request *);
	int (*finup)(struct ahash_request *);
	int (*digest)(struct ahash_request *);
	int (*export)(struct ahash_request *, void *);
	int (*import)(struct ahash_request *, const void *);
	int (*export_core)(struct ahash_request *, void *);
	int (*import_core)(struct ahash_request *, const void *);
	int (*setkey)(struct crypto_ahash *, const u8 *, unsigned int);
	int (*init_tfm)(struct crypto_ahash *);
	void (*exit_tfm)(struct crypto_ahash *);
	int (*clone_tfm)(struct crypto_ahash *, struct crypto_ahash *);
	struct hash_alg_common halg;
};

struct ahash_hmac_ctx {
	struct crypto_ahash *hash;
	u8 pads[0];
};

struct ahash_instance {
	void (*free)(struct ahash_instance *);
	union {
		struct {
			char head[112];
			struct crypto_instance base;
		} s;
		struct ahash_alg alg;
	};
};

struct ahash_request {
	struct crypto_async_request base;
	unsigned int nbytes;
	union {
		struct scatterlist *src;
		const u8 *svirt;
	};
	u8 *result;
	struct scatterlist sg_head[2];
	crypto_completion_t saved_complete;
	void *saved_data;
	void *__ctx[0];
};

struct ahci_cmd_hdr {
	__le32 opts;
	__le32 status;
	__le32 tbl_addr;
	__le32 tbl_addr_hi;
	__le32 reserved[4];
};

struct ata_link;

struct ahci_em_priv {
	enum sw_activity blink_policy;
	struct timer_list timer;
	long unsigned int saved_activity;
	long unsigned int activity;
	long unsigned int led_state;
	struct ata_link *link;
};

struct clk_bulk_data;

struct reset_control;

struct regulator;

struct phy;

struct ata_port;

struct ata_host;

struct ahci_host_priv {
	unsigned int flags;
	u32 mask_port_map;
	u32 mask_port_ext;
	void *mmio;
	u32 cap;
	u32 cap2;
	u32 version;
	u32 port_map;
	u32 saved_cap;
	u32 saved_cap2;
	u32 saved_port_map;
	u32 saved_port_cap[32];
	u32 em_loc;
	u32 em_buf_sz;
	u32 em_msg_type;
	u32 remapped_nvme;
	bool got_runtime_pm;
	unsigned int n_clks;
	struct clk_bulk_data *clks;
	unsigned int f_rsts;
	struct reset_control *rsts;
	struct regulator **target_pwrs;
	struct regulator *ahci_regulator;
	struct regulator *phy_regulator;
	struct phy **phys;
	unsigned int nports;
	void *plat_data;
	unsigned int irq;
	void (*start_engine)(struct ata_port *);
	int (*stop_engine)(struct ata_port *);
	irqreturn_t (*irq_handler)(int, void *);
	int (*get_irq_vector)(struct ata_host *, int);
};

struct ahci_port_priv {
	struct ata_link *active_link;
	struct ahci_cmd_hdr *cmd_slot;
	dma_addr_t cmd_slot_dma;
	void *cmd_tbl;
	dma_addr_t cmd_tbl_dma;
	void *rx_fis;
	dma_addr_t rx_fis_dma;
	unsigned int ncq_saw_d2h: 1;
	unsigned int ncq_saw_dmas: 1;
	unsigned int ncq_saw_sdb: 1;
	spinlock_t lock;
	u32 intr_mask;
	bool fbs_supported;
	bool fbs_enabled;
	int fbs_last_dev;
	struct ahci_em_priv em_priv[15];
	char *irq_desc;
};

struct ahci_sg {
	__le32 addr;
	__le32 addr_hi;
	__le32 reserved;
	__le32 flags_size;
};

struct wait_page_queue;

struct kiocb {
	struct file *ki_filp;
	loff_t ki_pos;
	void (*ki_complete)(struct kiocb *, long int);
	void *private;
	int ki_flags;
	u16 ki_ioprio;
	u8 ki_write_stream;
	union {
		struct wait_page_queue *ki_waitq;
		ssize_t (*dio_complete)(void *);
	};
};

struct cred;

struct fsync_iocb {
	struct file *file;
	struct work_struct work;
	bool datasync;
	struct cred *creds;
};

struct wait_queue_entry;

typedef int (*wait_queue_func_t)(struct wait_queue_entry *, unsigned int, int, void *);

struct wait_queue_entry {
	unsigned int flags;
	void *private;
	wait_queue_func_t func;
	struct list_head entry;
};

struct poll_iocb {
	struct file *file;
	struct wait_queue_head *head;
	__poll_t events;
	bool cancelled;
	bool work_scheduled;
	bool work_need_resched;
	struct wait_queue_entry wait;
	struct work_struct work;
};

typedef int kiocb_cancel_fn(struct kiocb *);

struct io_event {
	__u64 data;
	__u64 obj;
	__s64 res;
	__s64 res2;
};

struct kioctx;

struct eventfd_ctx;

struct aio_kiocb {
	union {
		struct file *ki_filp;
		struct kiocb rw;
		struct fsync_iocb fsync;
		struct poll_iocb poll;
	};
	struct kioctx *ki_ctx;
	kiocb_cancel_fn *ki_cancel;
	struct io_event ki_res;
	struct list_head ki_list;
	refcount_t ki_refcnt;
	struct eventfd_ctx *ki_eventfd;
};

struct poll_table_struct;

typedef void (*poll_queue_proc)(struct file *, wait_queue_head_t *, struct poll_table_struct *);

struct poll_table_struct {
	poll_queue_proc _qproc;
	__poll_t _key;
};

struct aio_poll_table {
	struct poll_table_struct pt;
	struct aio_kiocb *iocb;
	bool queued;
	int error;
};

struct aio_ring {
	unsigned int id;
	unsigned int nr;
	unsigned int head;
	unsigned int tail;
	unsigned int magic;
	unsigned int compat_features;
	unsigned int incompat_features;
	unsigned int header_length;
	struct io_event io_events[0];
};

struct aio_waiter {
	struct wait_queue_entry w;
	size_t min_nr;
};

struct akcipher_request;

struct crypto_akcipher;

struct akcipher_alg {
	int (*encrypt)(struct akcipher_request *);
	int (*decrypt)(struct akcipher_request *);
	int (*set_pub_key)(struct crypto_akcipher *, const void *, unsigned int);
	int (*set_priv_key)(struct crypto_akcipher *, const void *, unsigned int);
	unsigned int (*max_size)(struct crypto_akcipher *);
	int (*init)(struct crypto_akcipher *);
	void (*exit)(struct crypto_akcipher *);
	struct crypto_alg base;
};

struct akcipher_instance {
	void (*free)(struct akcipher_instance *);
	union {
		struct {
			char head[56];
			struct crypto_instance base;
		} s;
		struct akcipher_alg alg;
	};
};

struct akcipher_request {
	struct crypto_async_request base;
	struct scatterlist *src;
	struct scatterlist *dst;
	unsigned int src_len;
	unsigned int dst_len;
	void *__ctx[0];
};

struct alarm {
	struct timerqueue_node node;
	struct hrtimer timer;
	void (*function)(struct alarm *, ktime_t);
	enum alarmtimer_type type;
	int state;
	void *data;
};

struct timerqueue_head {
	struct rb_root_cached rb_root;
};

struct alarm_base {
	spinlock_t lock;
	struct timerqueue_head timerqueue;
	ktime_t (*get_ktime)(void);
	void (*get_timespec)(struct timespec64 *);
	clockid_t base_clockid;
};

struct zonelist;

struct zoneref;

struct alloc_context {
	struct zonelist *zonelist;
	nodemask_t *nodemask;
	struct zoneref *preferred_zoneref;
	int migratetype;
	enum zone_type highest_zoneidx;
	bool spread_dirty_pages;
};

struct codetag {
	unsigned int flags;
	unsigned int lineno;
	const char *modname;
	const char *function;
	const char *filename;
};

struct alloc_tag_counters;

struct alloc_tag {
	struct codetag ct;
	struct alloc_tag_counters *counters;
};

struct alloc_tag_counters {
	u64 bytes;
	u64 calls;
};

struct alt_instr {
	s32 instr_offset;
	s32 repl_offset;
	union {
		struct {
			u32 cpuid: 16;
			u32 flags: 16;
		};
		u32 ft_flags;
	};
	u8 instrlen;
	u8 replacementlen;
} __attribute__((packed));

struct amd_aperf_mperf {
	u64 aperf;
	u64 mperf;
	u64 tsc;
};

struct amd_chipset_type {
	enum amd_chipset_gen gen;
	u8 rev;
};

struct amd_chipset_info {
	struct pci_dev *nb_dev;
	struct pci_dev *smbus_dev;
	int nb_type;
	struct amd_chipset_type sb_type;
	int isoc_reqs;
	int probe_count;
	bool need_pll_quirk;
};

union perf_cached {
	struct {
		u8 highest_perf;
		u8 nominal_perf;
		u8 lowest_nonlinear_perf;
		u8 lowest_perf;
		u8 min_limit_perf;
		u8 max_limit_perf;
		u8 bios_min_perf;
	};
	u64 val;
};

struct amd_cpudata {
	int cpu;
	struct freq_qos_request req[2];
	u64 cppc_req_cached;
	union perf_cached perf;
	u8 prefcore_ranking;
	u32 min_limit_freq;
	u32 max_limit_freq;
	u32 nominal_freq;
	u32 lowest_nonlinear_freq;
	struct amd_aperf_mperf cur;
	struct amd_aperf_mperf prev;
	u64 freq;
	bool boost_supported;
	bool hw_prefcore;
	u32 policy;
	bool suspended;
	u8 epp_default;
};

union amd_debug_extn_cfg {
	__u64 val;
	struct {
		__u64 rsvd0: 2;
		__u64 brsmen: 1;
		__u64 rsvd4_3: 2;
		__u64 vb: 1;
		__u64 rsvd2: 10;
		__u64 msroff: 4;
		__u64 rsvd3: 4;
		__u64 pmc: 3;
		__u64 rsvd4: 37;
	};
};

struct amd_decoder_ops {
	bool (*mc0_mce)(u16, u8);
	bool (*mc1_mce)(u16, u8);
	bool (*mc2_mce)(u16, u8);
};

struct amd_function {
	const char *name;
	const char * const groups[4];
	unsigned int ngroups;
	int index;
};

struct irq_fwspec;

struct irq_data;

struct irq_domain_ops {
	int (*match)(struct irq_domain *, struct device_node *, enum irq_domain_bus_token);
	int (*select)(struct irq_domain *, struct irq_fwspec *, enum irq_domain_bus_token);
	int (*map)(struct irq_domain *, unsigned int, irq_hw_number_t);
	void (*unmap)(struct irq_domain *, unsigned int);
	int (*xlate)(struct irq_domain *, struct device_node *, const u32 *, unsigned int, long unsigned int *, unsigned int *);
	int (*alloc)(struct irq_domain *, unsigned int, unsigned int, void *);
	void (*free)(struct irq_domain *, unsigned int, unsigned int);
	int (*activate)(struct irq_domain *, struct irq_data *, bool);
	void (*deactivate)(struct irq_domain *, struct irq_data *);
	int (*translate)(struct irq_domain *, struct irq_fwspec *, long unsigned int *, unsigned int *);
};

typedef void (*irq_flow_handler_t)(struct irq_desc *);

struct irq_chip;

union gpio_irq_fwspec;

struct gpio_irq_chip {
	struct irq_chip *chip;
	struct irq_domain *domain;
	struct fwnode_handle *fwnode;
	struct irq_domain *parent_domain;
	int (*child_to_parent_hwirq)(struct gpio_chip *, unsigned int, unsigned int, unsigned int *, unsigned int *);
	int (*populate_parent_alloc_arg)(struct gpio_chip *, union gpio_irq_fwspec *, unsigned int, unsigned int);
	unsigned int (*child_offset_to_irq)(struct gpio_chip *, unsigned int);
	struct irq_domain_ops child_irq_domain_ops;
	irq_flow_handler_t handler;
	unsigned int default_type;
	struct lock_class_key *lock_key;
	struct lock_class_key *request_key;
	irq_flow_handler_t parent_handler;
	union {
		void *parent_handler_data;
		void **parent_handler_data_array;
	};
	unsigned int num_parents;
	unsigned int *parents;
	unsigned int *map;
	bool threaded;
	bool per_parent_data;
	bool initialized;
	bool domain_is_allocated_externally;
	int (*init_hw)(struct gpio_chip *);
	void (*init_valid_mask)(struct gpio_chip *, long unsigned int *, unsigned int);
	long unsigned int *valid_mask;
	unsigned int first;
	void (*irq_enable)(struct irq_data *);
	void (*irq_disable)(struct irq_data *);
	void (*irq_unmask)(struct irq_data *);
	void (*irq_mask)(struct irq_data *);
};

struct gpio_device;

struct seq_file;

struct gpio_chip {
	const char *label;
	struct gpio_device *gpiodev;
	struct device *parent;
	struct fwnode_handle *fwnode;
	struct module *owner;
	int (*request)(struct gpio_chip *, unsigned int);
	void (*free)(struct gpio_chip *, unsigned int);
	int (*get_direction)(struct gpio_chip *, unsigned int);
	int (*direction_input)(struct gpio_chip *, unsigned int);
	int (*direction_output)(struct gpio_chip *, unsigned int, int);
	int (*get)(struct gpio_chip *, unsigned int);
	int (*get_multiple)(struct gpio_chip *, long unsigned int *, long unsigned int *);
	int (*set)(struct gpio_chip *, unsigned int, int);
	int (*set_multiple)(struct gpio_chip *, long unsigned int *, long unsigned int *);
	int (*set_config)(struct gpio_chip *, unsigned int, long unsigned int);
	int (*to_irq)(struct gpio_chip *, unsigned int);
	void (*dbg_show)(struct seq_file *, struct gpio_chip *);
	int (*init_valid_mask)(struct gpio_chip *, long unsigned int *, unsigned int);
	int (*add_pin_ranges)(struct gpio_chip *);
	int (*en_hw_timestamp)(struct gpio_chip *, u32, long unsigned int);
	int (*dis_hw_timestamp)(struct gpio_chip *, u32, long unsigned int);
	int base;
	u16 ngpio;
	u16 offset;
	const char * const *names;
	bool can_sleep;
	long unsigned int (*read_reg)(void *);
	void (*write_reg)(void *, long unsigned int);
	bool be_bits;
	void *reg_dat;
	void *reg_set;
	void *reg_clr;
	void *reg_dir_out;
	void *reg_dir_in;
	bool bgpio_dir_unreadable;
	bool bgpio_pinctrl;
	int bgpio_bits;
	raw_spinlock_t bgpio_lock;
	long unsigned int bgpio_data;
	long unsigned int bgpio_dir;
	struct gpio_irq_chip irq;
};

struct pingroup;

struct pinctrl_dev;

struct platform_device;

struct amd_gpio {
	raw_spinlock_t lock;
	void *base;
	void *iomux_base;
	const struct pingroup *groups;
	u32 ngroups;
	struct pinctrl_dev *pctrl;
	struct gpio_chip gc;
	unsigned int hwbank_num;
	struct resource *res;
	struct platform_device *pdev;
	u32 *saved_regs;
	int irq;
};

struct amd_hfi_classes {
	u32 perf;
	u32 eff;
};

struct amd_hfi_cpuinfo {
	int cpu;
	u32 apic_id;
	cpumask_var_t cpus;
	s16 class_index;
	u8 nr_class;
	int *ipcc_scores;
	struct amd_hfi_classes *amd_hfi_classes;
};

struct pcc_mbox_chan;

struct amd_shmem_info;

struct amd_hfi_data {
	const char *name;
	struct device *dev;
	struct pcc_mbox_chan *pcc_chan;
	void *pcc_comm_addr;
	struct acpi_subtable_header *pcct_entry;
	struct amd_shmem_info *shmem;
	struct dentry *dbgfs_dir;
};

struct amd_hostbridge {
	u32 bus;
	u32 slot;
	u32 device;
};

struct iommu_flush_ops;

struct io_pgtable_cfg {
	long unsigned int quirks;
	long unsigned int pgsize_bitmap;
	unsigned int ias;
	unsigned int oas;
	bool coherent_walk;
	const struct iommu_flush_ops *tlb;
	struct device *iommu_dev;
	void * (*alloc)(void *, size_t, gfp_t);
	void (*free)(void *, void *, size_t);
	union {
		struct {
			u64 ttbr;
			struct {
				u32 ips: 3;
				u32 tg: 2;
				u32 sh: 2;
				u32 orgn: 2;
				u32 irgn: 2;
				u32 tsz: 6;
			} tcr;
			u64 mair;
		} arm_lpae_s1_cfg;
		struct {
			u64 vttbr;
			struct {
				u32 ps: 3;
				u32 tg: 2;
				u32 sh: 2;
				u32 orgn: 2;
				u32 irgn: 2;
				u32 sl: 2;
				u32 tsz: 6;
			} vtcr;
		} arm_lpae_s2_cfg;
		struct {
			u32 ttbr;
			u32 tcr;
			u32 nmrr;
			u32 prrr;
		} arm_v7s_cfg;
		struct {
			u64 transtab;
			u64 memattr;
		} arm_mali_lpae_cfg;
		struct {
			u64 ttbr[4];
			u32 n_ttbrs;
		} apple_dart_cfg;
		struct {
			int nid;
		} amd;
	};
};

struct iommu_iotlb_gather;

struct iommu_dirty_bitmap;

struct io_pgtable_ops {
	int (*map_pages)(struct io_pgtable_ops *, long unsigned int, phys_addr_t, size_t, size_t, int, gfp_t, size_t *);
	size_t (*unmap_pages)(struct io_pgtable_ops *, long unsigned int, size_t, size_t, struct iommu_iotlb_gather *);
	phys_addr_t (*iova_to_phys)(struct io_pgtable_ops *, long unsigned int);
	int (*pgtable_walk)(struct io_pgtable_ops *, long unsigned int, void *);
	int (*read_and_clear_dirty)(struct io_pgtable_ops *, long unsigned int, size_t, long unsigned int, struct iommu_dirty_bitmap *);
};

struct io_pgtable {
	enum io_pgtable_fmt fmt;
	void *cookie;
	struct io_pgtable_cfg cfg;
	struct io_pgtable_ops ops;
};

struct amd_io_pgtable {
	seqcount_t seqcount;
	struct io_pgtable pgtbl;
	int mode;
	u64 *root;
	u64 *pgd;
};

struct iommu_ops;

struct iommu_device {
	struct list_head list;
	const struct iommu_ops *ops;
	struct fwnode_handle *fwnode;
	struct device *dev;
	struct iommu_group *singleton_group;
	u32 max_pasids;
	bool ready;
};

struct amd_iommu_pci_seg;

struct amd_irte_ops;

struct iopf_queue;

struct amd_iommu {
	struct list_head list;
	int index;
	raw_spinlock_t lock;
	struct pci_dev *dev;
	struct pci_dev *root_pdev;
	u64 mmio_phys;
	u64 mmio_phys_end;
	u8 *mmio_base;
	u32 cap;
	u8 acpi_flags;
	u64 features;
	u64 features2;
	u16 devid;
	u16 cap_ptr;
	struct amd_iommu_pci_seg *pci_seg;
	u64 exclusion_start;
	u64 exclusion_length;
	u8 *cmd_buf;
	u32 cmd_buf_head;
	u32 cmd_buf_tail;
	u8 *evt_buf;
	unsigned char evt_irq_name[16];
	u8 *ppr_log;
	unsigned char ppr_irq_name[16];
	u8 *ga_log;
	unsigned char ga_irq_name[16];
	u8 *ga_log_tail;
	bool int_enabled;
	bool need_sync;
	bool irtcachedis_enabled;
	struct iommu_device iommu;
	u32 stored_addr_lo;
	u32 stored_addr_hi;
	u32 stored_l1[108];
	u32 stored_l2[131];
	u8 max_banks;
	u8 max_counters;
	struct irq_domain *ir_domain;
	struct amd_irte_ops *irte_ops;
	u32 flags;
	volatile u64 *cmd_sem;
	atomic64_t cmd_sem_val;
	struct iopf_queue *iopf_queue;
	unsigned char iopfq_name[32];
};

struct amd_iommu_event_desc {
	struct device_attribute attr;
	const char *event;
};

struct llist_head {
	struct llist_node *first;
};

struct dev_table_entry;

struct irq_remap_table;

struct amd_iommu_pci_seg {
	struct list_head list;
	struct llist_head dev_data_list;
	u16 id;
	u16 last_bdf;
	u32 dev_table_size;
	struct dev_table_entry *dev_table;
	struct amd_iommu **rlookup_table;
	struct irq_remap_table **irq_lookup_table;
	struct dev_table_entry *old_dev_tbl_cpy;
	u16 *alias_table;
	struct list_head unity_map;
};

struct amd_iommu_pi_data {
	u64 vapic_addr;
	u32 ga_tag;
	u32 vector;
	int cpu;
	bool ga_log_intr;
	bool is_guest_mode;
	void *ir_data;
};

struct irq_2_irte {
	u16 devid;
	u16 index;
};

struct x86_msi_addr_lo {
	union {
		struct {
			u32 reserved_0: 2;
			u32 dest_mode_logical: 1;
			u32 redirect_hint: 1;
			u32 reserved_1: 1;
			u32 virt_destid_8_14: 7;
			u32 destid_0_7: 8;
			u32 base_address: 12;
		};
		struct {
			u32 dmar_reserved_0: 2;
			u32 dmar_index_15: 1;
			u32 dmar_subhandle_valid: 1;
			u32 dmar_format: 1;
			u32 dmar_index_0_14: 15;
			u32 dmar_base_address: 12;
		};
	};
};

typedef struct x86_msi_addr_lo arch_msi_msg_addr_lo_t;

struct x86_msi_addr_hi {
	u32 reserved: 8;
	u32 destid_8_31: 24;
};

typedef struct x86_msi_addr_hi arch_msi_msg_addr_hi_t;

struct x86_msi_data {
	union {
		struct {
			u32 vector: 8;
			u32 delivery_mode: 3;
			u32 dest_mode_logical: 1;
			u32 reserved: 2;
			u32 active_low: 1;
			u32 is_level: 1;
		};
		u32 dmar_subhandle;
	};
};

typedef struct x86_msi_data arch_msi_msg_data_t;

struct msi_msg {
	union {
		u32 address_lo;
		arch_msi_msg_addr_lo_t arch_addr_lo;
	};
	union {
		u32 address_hi;
		arch_msi_msg_addr_hi_t arch_addr_hi;
	};
	union {
		u32 data;
		arch_msi_msg_data_t arch_data;
	};
};

struct irq_cfg;

struct amd_ir_data {
	struct amd_iommu *iommu;
	struct irq_2_irte irq_2_irte;
	struct msi_msg msi_entry;
	void *entry;
	struct irq_cfg *cfg;
	int ga_vector;
	u64 ga_root_ptr;
	u32 ga_tag;
};

struct amd_irte_ops {
	void (*prepare)(void *, u32, bool, u8, u32, int);
	void (*activate)(struct amd_iommu *, void *, u16, u16);
	void (*deactivate)(struct amd_iommu *, void *, u16, u16);
	void (*set_affinity)(struct amd_iommu *, void *, u16, u16, u8, u32);
	void * (*get)(struct irq_remap_table *, int);
	void (*set_allocated)(struct irq_remap_table *, int);
	bool (*is_allocated)(struct irq_remap_table *, int);
	void (*clear_allocated)(struct irq_remap_table *, int);
};

struct amd_l3_cache {
	unsigned int indices;
	u8 subcaches[4];
};

struct amd_lps0_hid_device_data {
	const bool check_off_by_one;
};

struct event_constraint {
	union {
		long unsigned int idxmsk[1];
		u64 idxmsk64;
	};
	u64 code;
	u64 cmask;
	int weight;
	int overlap;
	int flags;
	unsigned int size;
};

struct perf_event;

struct amd_nb {
	int nb_id;
	int refcnt;
	struct perf_event *owners[64];
	struct event_constraint event_constraints[64];
};

struct amd_nb_bus_dev_range {
	u8 bus;
	u8 dev_base;
	u8 dev_limit;
};

struct amd_northbridge {
	struct pci_dev *misc;
	struct pci_dev *link;
	struct amd_l3_cache l3_cache;
};

struct amd_northbridge_info {
	u16 num;
	u64 flags;
	struct amd_northbridge *nb;
};

struct amd_shmem_info {
	struct acpi_pcct_ext_pcc_shared_memory header;
	u32 version_number: 8;
	u32 n_logical_processors: 8;
	u32 n_capabilities: 8;
	u32 table_update_context: 8;
	u32 n_bitmaps: 8;
	u32 reserved: 24;
	u32 table_data[0];
};

struct freq_band_range {
	u64 start;
	u64 end;
};

struct amd_wbrf_ranges_out {
	u32 num_of_ranges;
	struct freq_band_range band_list[11];
} __attribute__((packed));

struct aml_resource_small_header {
	u8 descriptor_type;
};

struct aml_resource_large_header {
	u8 descriptor_type;
	u16 resource_length;
} __attribute__((packed));

struct aml_resource_irq {
	u8 descriptor_type;
	u16 irq_mask;
	u8 flags;
} __attribute__((packed));

struct aml_resource_dma {
	u8 descriptor_type;
	u8 dma_channel_mask;
	u8 flags;
};

struct aml_resource_start_dependent {
	u8 descriptor_type;
	u8 flags;
};

struct aml_resource_end_dependent {
	u8 descriptor_type;
};

struct aml_resource_io {
	u8 descriptor_type;
	u8 flags;
	u16 minimum;
	u16 maximum;
	u8 alignment;
	u8 address_length;
};

struct aml_resource_fixed_io {
	u8 descriptor_type;
	u16 address;
	u8 address_length;
} __attribute__((packed));

struct aml_resource_fixed_dma {
	u8 descriptor_type;
	u16 request_lines;
	u16 channels;
	u8 width;
} __attribute__((packed));

struct aml_resource_vendor_small {
	u8 descriptor_type;
};

struct aml_resource_end_tag {
	u8 descriptor_type;
	u8 checksum;
};

struct aml_resource_memory24 {
	u8 descriptor_type;
	u16 resource_length;
	u8 flags;
	u16 minimum;
	u16 maximum;
	u16 alignment;
	u16 address_length;
} __attribute__((packed));

struct aml_resource_generic_register {
	u8 descriptor_type;
	u16 resource_length;
	u8 address_space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_size;
	u64 address;
} __attribute__((packed));

struct aml_resource_vendor_large {
	u8 descriptor_type;
	u16 resource_length;
} __attribute__((packed));

struct aml_resource_memory32 {
	u8 descriptor_type;
	u16 resource_length;
	u8 flags;
	u32 minimum;
	u32 maximum;
	u32 alignment;
	u32 address_length;
} __attribute__((packed));

struct aml_resource_fixed_memory32 {
	u8 descriptor_type;
	u16 resource_length;
	u8 flags;
	u32 address;
	u32 address_length;
} __attribute__((packed));

struct aml_resource_address16 {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
	u16 granularity;
	u16 minimum;
	u16 maximum;
	u16 translation_offset;
	u16 address_length;
} __attribute__((packed));

struct aml_resource_address32 {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
	u32 granularity;
	u32 minimum;
	u32 maximum;
	u32 translation_offset;
	u32 address_length;
} __attribute__((packed));

struct aml_resource_address64 {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
	u64 granularity;
	u64 minimum;
	u64 maximum;
	u64 translation_offset;
	u64 address_length;
} __attribute__((packed));

struct aml_resource_extended_address64 {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
	u8 revision_ID;
	u8 reserved;
	u64 granularity;
	u64 minimum;
	u64 maximum;
	u64 translation_offset;
	u64 address_length;
	u64 type_specific;
} __attribute__((packed));

struct aml_resource_extended_irq {
	u8 descriptor_type;
	u16 resource_length;
	u8 flags;
	u8 interrupt_count;
	union {
		u32 interrupt;
		struct {
			struct {} __Empty_interrupts;
			u32 interrupts[0];
		};
	};
} __attribute__((packed));

struct aml_resource_gpio {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 connection_type;
	u16 flags;
	u16 int_flags;
	u8 pin_config;
	u16 drive_strength;
	u16 debounce_timeout;
	u16 pin_table_offset;
	u8 res_source_index;
	u16 res_source_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_i2c_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
	u32 connection_speed;
	u16 slave_address;
} __attribute__((packed));

struct aml_resource_spi_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
	u32 connection_speed;
	u8 data_bit_length;
	u8 clock_phase;
	u8 clock_polarity;
	u16 device_selection;
} __attribute__((packed));

struct aml_resource_uart_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
	u32 default_baud_rate;
	u16 rx_fifo_size;
	u16 tx_fifo_size;
	u8 parity;
	u8 lines_enabled;
} __attribute__((packed));

struct aml_resource_csi2_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
} __attribute__((packed));

struct aml_resource_common_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
} __attribute__((packed));

struct aml_resource_pin_function {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u8 pin_config;
	u16 function_number;
	u16 pin_table_offset;
	u8 res_source_index;
	u16 res_source_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_pin_config {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u8 pin_config_type;
	u32 pin_config_value;
	u16 pin_table_offset;
	u8 res_source_index;
	u16 res_source_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_pin_group {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u16 pin_table_offset;
	u16 label_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_pin_group_function {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u16 function_number;
	u8 res_source_index;
	u16 res_source_offset;
	u16 res_source_label_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_pin_group_config {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u8 pin_config_type;
	u32 pin_config_value;
	u8 res_source_index;
	u16 res_source_offset;
	u16 res_source_label_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_clock_input {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u16 frequency_divisor;
	u32 frequency_numerator;
} __attribute__((packed));

struct aml_resource_address {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
} __attribute__((packed));

union aml_resource {
	u8 descriptor_type;
	struct aml_resource_small_header small_header;
	struct aml_resource_large_header large_header;
	struct aml_resource_irq irq;
	struct aml_resource_dma dma;
	struct aml_resource_start_dependent start_dpf;
	struct aml_resource_end_dependent end_dpf;
	struct aml_resource_io io;
	struct aml_resource_fixed_io fixed_io;
	struct aml_resource_fixed_dma fixed_dma;
	struct aml_resource_vendor_small vendor_small;
	struct aml_resource_end_tag end_tag;
	struct aml_resource_memory24 memory24;
	struct aml_resource_generic_register generic_reg;
	struct aml_resource_vendor_large vendor_large;
	struct aml_resource_memory32 memory32;
	struct aml_resource_fixed_memory32 fixed_memory32;
	struct aml_resource_address16 address16;
	struct aml_resource_address32 address32;
	struct aml_resource_address64 address64;
	struct aml_resource_extended_address64 ext_address64;
	struct aml_resource_extended_irq extended_irq;
	struct aml_resource_gpio gpio;
	struct aml_resource_i2c_serialbus i2c_serial_bus;
	struct aml_resource_spi_serialbus spi_serial_bus;
	struct aml_resource_uart_serialbus uart_serial_bus;
	struct aml_resource_csi2_serialbus csi2_serial_bus;
	struct aml_resource_common_serialbus common_serial_bus;
	struct aml_resource_pin_function pin_function;
	struct aml_resource_pin_config pin_config;
	struct aml_resource_pin_group pin_group;
	struct aml_resource_pin_group_function pin_group_function;
	struct aml_resource_pin_group_config pin_group_config;
	struct aml_resource_clock_input clock_input;
	struct aml_resource_address address;
	u32 dword_item;
	u16 word_item;
	u8 byte_item;
};

struct analog_param_field {
	unsigned int even;
	unsigned int odd;
};

struct analog_param_range {
	unsigned int min;
	unsigned int typ;
	unsigned int max;
};

struct analog_parameters {
	unsigned int num_lines;
	unsigned int line_duration_ns;
	struct analog_param_range hact_ns;
	struct analog_param_range hfp_ns;
	struct analog_param_range hslen_ns;
	struct analog_param_range hbp_ns;
	struct analog_param_range hblk_ns;
	unsigned int bt601_hfp;
	struct analog_param_field vfp_lines;
	struct analog_param_field vslen_lines;
	struct analog_param_field vbp_lines;
};

struct kobj_uevent_env;

struct kobj_ns_type_operations;

struct class {
	const char *name;
	const struct attribute_group **class_groups;
	const struct attribute_group **dev_groups;
	int (*dev_uevent)(const struct device *, struct kobj_uevent_env *);
	char * (*devnode)(const struct device *, umode_t *);
	void (*class_release)(const struct class *);
	void (*dev_release)(struct device *);
	int (*shutdown_pre)(struct device *);
	const struct kobj_ns_type_operations *ns_type;
	const void * (*namespace)(const struct device *);
	void (*get_ownership)(const struct device *, kuid_t *, kgid_t *);
	const struct dev_pm_ops *pm;
};

struct transport_container;

struct transport_class {
	struct class class;
	int (*setup)(struct transport_container *, struct device *, struct device *);
	int (*configure)(struct transport_container *, struct device *, struct device *);
	int (*remove)(struct transport_container *, struct device *, struct device *);
};

struct klist_node;

struct klist {
	spinlock_t k_lock;
	struct list_head k_list;
	void (*get)(struct klist_node *);
	void (*put)(struct klist_node *);
};

struct attribute_container {
	struct list_head node;
	struct klist containers;
	struct class *class;
	const struct attribute_group *grp;
	struct device_attribute **attrs;
	int (*match)(struct attribute_container *, struct device *);
	long unsigned int flags;
};

struct anon_transport_class {
	struct transport_class tclass;
	struct attribute_container container;
};

struct anon_vma {
	struct anon_vma *root;
	struct rw_semaphore rwsem;
	atomic_t refcount;
	long unsigned int num_children;
	long unsigned int num_active_vmas;
	struct anon_vma *parent;
	struct rb_root_cached rb_root;
};

struct anon_vma_chain {
	struct vm_area_struct *vma;
	struct anon_vma *anon_vma;
	struct list_head same_vma;
	struct rb_node rb;
	long unsigned int rb_subtree_last;
};

struct anon_vma_name {
	struct kref kref;
	char name[0];
};

struct apd_private_data;

struct apd_device_desc {
	unsigned int fixed_clk_rate;
	struct property_entry *properties;
	int (*setup)(struct apd_private_data *);
};

struct clk;

struct apd_private_data {
	struct clk *clk;
	struct acpi_device *adev;
	const struct apd_device_desc *dev_desc;
};

struct apei_exec_ins_type;

struct apei_exec_context {
	u32 ip;
	u64 value;
	u64 var1;
	u64 var2;
	u64 src_base;
	u64 dst_base;
	struct apei_exec_ins_type *ins_table;
	u32 instructions;
	struct acpi_whea_header *action_table;
	u32 entries;
};

typedef int (*apei_exec_ins_func_t)(struct apei_exec_context *, struct acpi_whea_header *);

struct apei_exec_ins_type {
	u32 flags;
	apei_exec_ins_func_t run;
};

struct apei_res {
	struct list_head list;
	long unsigned int start;
	long unsigned int end;
};

struct apei_resources {
	struct list_head iomem;
	struct list_head ioport;
};

struct aper_size_info_16 {
	int size;
	int num_entries;
	int page_order;
	u16 size_value;
};

struct aper_size_info_32 {
	int size;
	int num_entries;
	int page_order;
	u32 size_value;
};

struct aper_size_info_8 {
	int size;
	int num_entries;
	int page_order;
	u8 size_value;
};

struct aper_size_info_fixed {
	int size;
	int num_entries;
	int page_order;
};

struct aper_size_info_lvl2 {
	int size;
	int num_entries;
	u32 size_value;
};

struct aperfmperf {
	seqcount_t seq;
	long unsigned int last_update;
	u64 acnt;
	u64 mcnt;
	u64 aperf;
	u64 mperf;
};

struct aperture_range {
	struct device *dev;
	resource_size_t base;
	resource_size_t size;
	struct list_head lh;
	void (*detach)(struct device *);
};

struct api_context {
	struct completion done;
	int status;
};

struct apic {
	void (*eoi)(void);
	void (*native_eoi)(void);
	void (*write)(u32, u32);
	u32 (*read)(u32);
	void (*wait_icr_idle)(void);
	u32 (*safe_wait_icr_idle)(void);
	void (*send_IPI)(int, int);
	void (*send_IPI_mask)(const struct cpumask *, int);
	void (*send_IPI_mask_allbutself)(const struct cpumask *, int);
	void (*send_IPI_allbutself)(int);
	void (*send_IPI_all)(int);
	void (*send_IPI_self)(int);
	u32 disable_esr: 1;
	u32 dest_mode_logical: 1;
	u32 x2apic_set_max_apicid: 1;
	u32 nmi_to_offline_cpu: 1;
	u32 (*calc_dest_apicid)(unsigned int);
	u64 (*icr_read)(void);
	void (*icr_write)(u32, u32);
	u32 max_apic_id;
	int (*probe)(void);
	int (*acpi_madt_oem_check)(char *, char *);
	void (*init_apic_ldr)(void);
	u32 (*cpu_present_to_apicid)(int);
	u32 (*get_apic_id)(u32);
	int (*wakeup_secondary_cpu)(u32, long unsigned int, unsigned int);
	int (*wakeup_secondary_cpu_64)(u32, long unsigned int, unsigned int);
	char *name;
};

struct irq_cfg {
	unsigned int dest_apicid;
	unsigned int vector;
};

struct apic_chip_data {
	struct irq_cfg hw_irq_cfg;
	unsigned int vector;
	unsigned int prev_vector;
	unsigned int cpu;
	unsigned int prev_cpu;
	unsigned int irq;
	struct hlist_node clist;
	unsigned int move_in_progress: 1;
	unsigned int is_managed: 1;
	unsigned int can_reserve: 1;
	unsigned int has_reserved: 1;
};

union apic_ir {
	long unsigned int map[4];
	u32 regs[8];
};

struct apic_override {
	void (*eoi)(void);
	void (*native_eoi)(void);
	void (*write)(u32, u32);
	u32 (*read)(u32);
	void (*send_IPI)(int, int);
	void (*send_IPI_mask)(const struct cpumask *, int);
	void (*send_IPI_mask_allbutself)(const struct cpumask *, int);
	void (*send_IPI_allbutself)(int);
	void (*send_IPI_all)(int);
	void (*send_IPI_self)(int);
	u64 (*icr_read)(void);
	void (*icr_write)(u32, u32);
	int (*wakeup_secondary_cpu)(u32, long unsigned int, unsigned int);
	int (*wakeup_secondary_cpu_64)(u32, long unsigned int, unsigned int);
};

struct apm_bios_info {
	__u16 version;
	__u16 cseg;
	__u32 offset;
	__u16 cseg_16;
	__u16 dseg;
	__u16 flags;
	__u16 cseg_len;
	__u16 cseg_16_len;
	__u16 dseg_len;
};

struct vfsmount;

struct path {
	struct vfsmount *mnt;
	struct dentry *dentry;
};

struct lsm_network_audit;

struct lsm_ioctlop_audit;

struct lsm_ibpkey_audit;

struct lsm_ibendport_audit;

struct smack_audit_data;

struct selinux_audit_data;

struct apparmor_audit_data;

struct common_audit_data {
	char type;
	union {
		struct path path;
		struct dentry *dentry;
		struct inode *inode;
		struct lsm_network_audit *net;
		int cap;
		int ipc_id;
		struct task_struct *tsk;
		struct {
			key_serial_t key;
			char *key_desc;
		} key_struct;
		char *kmod_name;
		struct lsm_ioctlop_audit *op;
		struct file *file;
		struct lsm_ibpkey_audit *ibpkey;
		struct lsm_ibendport_audit *ibendport;
		int reason;
		const char *anonclass;
		u16 nlmsg_type;
	} u;
	union {
		struct smack_audit_data *smack_audit_data;
		struct selinux_audit_data *selinux_audit_data;
		struct apparmor_audit_data *apparmor_audit_data;
	};
};

struct apparmor_audit_data {
	int error;
	int type;
	u16 class;
	const char *op;
	const struct cred *subj_cred;
	struct aa_label *subj_label;
	const char *name;
	const char *info;
	u32 request;
	u32 denied;
	union {
		struct {
			struct aa_label *peer;
			union {
				struct {
					const char *target;
					kuid_t ouid;
				} fs;
				struct {
					int rlim;
					long unsigned int max;
				} rlim;
				struct {
					int signal;
					int unmappedsig;
				};
				struct {
					int type;
					int protocol;
					void *addr;
					int addrlen;
					struct {
						void *addr;
						int addrlen;
					} peer;
				} net;
			};
		};
		struct {
			struct aa_profile *profile;
			const char *ns;
			long int pos;
		} iface;
		struct {
			const char *src_name;
			const char *type;
			const char *trans;
			const char *data;
			long unsigned int flags;
		} mnt;
		struct {
			struct aa_label *target;
		} uring;
	};
	struct common_audit_data common;
};

struct workqueue_attrs;

struct pool_workqueue;

struct apply_wqattrs_ctx {
	struct workqueue_struct *wq;
	struct workqueue_attrs *attrs;
	struct list_head list;
	struct pool_workqueue *dfl_pwq;
	struct pool_workqueue *pwq_tbl[0];
};

struct arch_elf_state {};

struct arch_hw_breakpoint {
	long unsigned int address;
	long unsigned int mask;
	u8 len;
	u8 type;
};

struct arch_hybrid_cpu_scale {
	long unsigned int capacity;
	long unsigned int freq_ratio;
};

struct drm_privacy_screen_lookup {
	struct list_head list;
	const char *dev_id;
	const char *con_id;
	const char *provider;
};

struct arch_init_data {
	struct drm_privacy_screen_lookup lookup;
	bool (*detect)(void);
};

struct arch_io_reserve_memtype_wc_devres {
	resource_size_t start;
	resource_size_t size;
};

struct lbr_entry {
	u64 from;
	u64 to;
	u64 info;
};

struct arch_lbr_state {
	u64 lbr_ctl;
	u64 lbr_depth;
	u64 ler_from;
	u64 ler_to;
	u64 ler_info;
	struct lbr_entry entries[0];
};

struct arch_mbm_state {
	u64 chunks;
	u64 prev_msr;
};

struct arch_optimized_insn {
	kprobe_opcode_t copied_insn[4];
	kprobe_opcode_t *insn;
	size_t size;
};

struct arch_shared_info {
	long unsigned int max_pfn;
	xen_pfn_t pfn_to_mfn_frame_list_list;
	long unsigned int nmi_reason;
	long unsigned int p2m_cr3;
	long unsigned int p2m_vaddr;
	long unsigned int p2m_generation;
};

struct kprobe;

struct arch_specific_insn {
	kprobe_opcode_t *insn;
	unsigned int boostable: 1;
	unsigned char size;
	union {
		unsigned char opcode;
		struct {
			unsigned char type;
		} jcc;
		struct {
			unsigned char type;
			unsigned char asize;
		} loop;
		struct {
			unsigned char reg;
		} indirect;
	};
	s32 rel32;
	void (*emulate_op)(struct kprobe *, struct pt_regs *);
	int tp_len;
};

struct cpumask {
	long unsigned int bits[128];
};

struct arch_tlbflush_unmap_batch {
	struct cpumask cpumask;
	bool unmapped_pages;
};

struct uprobe_xol_ops;

struct arch_uprobe {
	union {
		u8 insn[16];
		u8 ixol[16];
	};
	const struct uprobe_xol_ops *ops;
	union {
		struct {
			s32 offs;
			u8 ilen;
			u8 opc1;
		} branch;
		struct {
			u8 fixups;
			u8 ilen;
		} defparam;
		struct {
			u8 reg_offset;
			u8 ilen;
		} push;
	};
};

struct arch_uprobe_task {
	long unsigned int saved_scratch_register;
	unsigned int saved_trap_nr;
	unsigned int saved_tf;
};

struct arch_vcpu_info {
	long unsigned int cr2;
	long unsigned int pad;
};

struct arch_vdso_time_data {};

struct arg_dev_net_ip {
	struct net *net;
	struct in6_addr *addr;
};

struct arg_netdev_event {
	const struct net_device *dev;
	union {
		unsigned char nh_flags;
		long unsigned int event;
	};
};

struct args_askumount {
	__u32 may_umount;
};

struct args_expire {
	__u32 how;
};

struct args_fail {
	__u32 token;
	__s32 status;
};

struct args_in {
	__u32 type;
};

struct args_out {
	__u32 devid;
	__u32 magic;
};

struct args_ismountpoint {
	union {
		struct args_in in;
		struct args_out out;
	};
};

struct args_openmount {
	__u32 devid;
};

struct args_protosubver {
	__u32 sub_version;
};

struct args_protover {
	__u32 version;
};

struct args_ready {
	__u32 token;
};

struct args_requester {
	__u32 uid;
	__u32 gid;
};

struct args_setpipefd {
	__s32 pipefd;
};

struct args_timeout {
	__u64 timeout;
};

struct arphdr {
	__be16 ar_hrd;
	__be16 ar_pro;
	unsigned char ar_hln;
	unsigned char ar_pln;
	__be16 ar_op;
};

struct sockaddr {
	sa_family_t sa_family;
	union {
		char sa_data_min[14];
		struct {
			struct {} __empty_sa_data;
			char sa_data[0];
		};
	};
};

struct arpreq {
	struct sockaddr arp_pa;
	struct sockaddr arp_ha;
	int arp_flags;
	struct sockaddr arp_netmask;
	char arp_dev[16];
};

struct trace_array;

struct trace_array_cpu;

struct array_buffer {
	struct trace_array *tr;
	struct trace_buffer *buffer;
	struct trace_array_cpu *data;
	u64 time_start;
	int cpu;
};

struct regmap;

struct as3711 {
	struct device *dev;
	struct regmap *regmap;
};

struct as3711_bl_pdata {
	bool su1_fb;
	int su1_max_uA;
	bool su2_fb;
	int su2_max_uA;
	enum as3711_su2_feedback su2_feedback;
	enum as3711_su2_fbprot su2_fbprot;
	bool su2_auto_curr1;
	bool su2_auto_curr2;
	bool su2_auto_curr3;
};

struct regulator_init_data;

struct as3711_regulator_pdata {
	struct regulator_init_data *init_data[12];
};

struct as3711_platform_data {
	struct as3711_regulator_pdata regulator;
	struct as3711_bl_pdata backlight;
};

typedef int (*asn1_action_t)(void *, size_t, unsigned char, const void *, size_t);

struct asn1_decoder {
	const unsigned char *machine;
	size_t machlen;
	const asn1_action_t *actions;
};

struct assoc_array_ptr;

struct assoc_array {
	struct assoc_array_ptr *root;
	long unsigned int nr_leaves_on_tree;
};

struct assoc_array_node;

struct assoc_array_delete_collapse_context {
	struct assoc_array_node *node;
	const void *skip_leaf;
	int slot;
};

struct assoc_array_ops;

struct assoc_array_edit {
	struct callback_head rcu;
	struct assoc_array *array;
	const struct assoc_array_ops *ops;
	const struct assoc_array_ops *ops_for_excised_subtree;
	struct assoc_array_ptr *leaf;
	struct assoc_array_ptr **leaf_p;
	struct assoc_array_ptr *dead_leaf;
	struct assoc_array_ptr *new_meta[3];
	struct assoc_array_ptr *excised_meta[1];
	struct assoc_array_ptr *excised_subtree;
	struct assoc_array_ptr **set_backpointers[16];
	struct assoc_array_ptr *set_backpointers_to;
	struct assoc_array_node *adjust_count_on;
	long int adjust_count_by;
	struct {
		struct assoc_array_ptr **ptr;
		struct assoc_array_ptr *to;
	} set[2];
	struct {
		u8 *p;
		u8 to;
	} set_parent_slot[1];
	u8 segment_cache[17];
};

struct assoc_array_node {
	struct assoc_array_ptr *back_pointer;
	u8 parent_slot;
	struct assoc_array_ptr *slots[16];
	long unsigned int nr_leaves_on_branch;
};

struct assoc_array_ops {
	long unsigned int (*get_key_chunk)(const void *, int);
	long unsigned int (*get_object_key_chunk)(const void *, int);
	bool (*compare_object)(const void *, const void *);
	int (*diff_objects)(const void *, const void *);
	void (*free_object)(void *);
};

struct assoc_array_shortcut {
	struct assoc_array_ptr *back_pointer;
	int parent_slot;
	int skip_to_level;
	struct assoc_array_ptr *next_node;
	long unsigned int index_key[0];
};

struct assoc_array_walk_result {
	struct {
		struct assoc_array_node *node;
		int level;
		int slot;
	} terminal_node;
	struct {
		struct assoc_array_shortcut *shortcut;
		int level;
		int sc_level;
		long unsigned int sc_segments;
		long unsigned int dissimilarity;
	} wrong_shortcut;
};

struct asym_cap_data {
	struct list_head link;
	struct callback_head rcu;
	long unsigned int capacity;
	long unsigned int cpus[0];
};

struct asymmetric_key_id {
	short unsigned int len;
	unsigned char data[0];
};

struct asymmetric_key_ids {
	void *id[3];
};

struct key_preparsed_payload;

struct asymmetric_key_parser {
	struct list_head link;
	struct module *owner;
	const char *name;
	int (*parse)(struct key_preparsed_payload *);
};

struct key;

struct kernel_pkey_params;

struct kernel_pkey_query;

struct public_key_signature;

struct asymmetric_key_subtype {
	struct module *owner;
	const char *name;
	short unsigned int name_len;
	void (*describe)(const struct key *, struct seq_file *);
	void (*destroy)(void *, void *);
	int (*query)(const struct kernel_pkey_params *, struct kernel_pkey_query *);
	int (*eds_op)(struct kernel_pkey_params *, const void *, void *);
	int (*verify_signature)(const struct key *, const struct public_key_signature *);
};

struct usb_dev_state;

struct pid;

struct urb;

struct usb_memory;

struct async {
	struct list_head asynclist;
	struct usb_dev_state *ps;
	struct pid *pid;
	const struct cred *cred;
	unsigned int signr;
	unsigned int ifnum;
	void *userbuffer;
	void *userurb;
	sigval_t userurb_sigval;
	struct urb *urb;
	struct usb_memory *usbm;
	unsigned int mem_usage;
	int status;
	u8 bulk_addr;
	u8 bulk_status;
};

struct async_domain {
	struct list_head pending;
	unsigned int registered: 1;
};

typedef void (*async_func_t)(void *, async_cookie_t);

struct async_entry {
	struct list_head domain_list;
	struct list_head global_list;
	struct work_struct work;
	async_cookie_t cookie;
	async_func_t func;
	void *data;
	struct async_domain *domain;
};

struct async_icount {
	__u32 cts;
	__u32 dsr;
	__u32 rng;
	__u32 dcd;
	__u32 tx;
	__u32 rx;
	__u32 frame;
	__u32 parity;
	__u32 overrun;
	__u32 brk;
	__u32 buf_overrun;
};

struct io_poll {
	struct file *file;
	struct wait_queue_head *head;
	__poll_t events;
	int retries;
	struct wait_queue_entry wait;
};

struct async_poll {
	struct io_poll poll;
	struct io_poll *double_poll;
};

struct async_scan_data {
	struct list_head list;
	struct Scsi_Host *shost;
	struct completion prev_finished;
};

struct ata_acpi_drive {
	u32 pio;
	u32 dma;
};

struct ata_acpi_gtf {
	u8 tf[7];
};

struct ata_acpi_gtm {
	struct ata_acpi_drive drive[2];
	u32 flags;
};

struct ata_device;

struct ata_acpi_hotplug_context {
	struct acpi_hotplug_context hp;
	union {
		struct ata_port *ap;
		struct ata_device *dev;
	} data;
};

struct ata_bmdma_prd {
	__le32 addr;
	__le32 flags_len;
};

struct ata_cdl {
	u8 desc_log_buf[512];
	u8 ncq_sense_log_buf[1024];
};

struct ata_cpr {
	u8 num;
	u8 num_storage_elements;
	u64 start_lba;
	u64 num_lbas;
};

struct ata_cpr_log {
	u8 nr_cpr;
	struct ata_cpr cpr[0];
};

struct ata_dev_quirks_entry {
	const char *model_num;
	const char *model_rev;
	unsigned int quirks;
};

struct ata_ering_entry {
	unsigned int eflags;
	unsigned int err_mask;
	u64 timestamp;
};

struct ata_ering {
	int cursor;
	struct ata_ering_entry ring[32];
};

struct scsi_device;

struct ata_device {
	struct ata_link *link;
	unsigned int devno;
	unsigned int quirks;
	long unsigned int flags;
	struct scsi_device *sdev;
	void *private_data;
	union acpi_object *gtf_cache;
	unsigned int gtf_filter;
	void *zpodd;
	struct device tdev;
	u64 n_sectors;
	u64 n_native_sectors;
	unsigned int class;
	long unsigned int unpark_deadline;
	u8 pio_mode;
	u8 dma_mode;
	u8 xfer_mode;
	unsigned int xfer_shift;
	unsigned int multi_count;
	unsigned int max_sectors;
	unsigned int cdb_len;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	u16 cylinders;
	u16 heads;
	u16 sectors;
	union {
		u16 id[256];
		u32 gscr[128];
	};
	u8 gp_log_dir[512];
	u8 devslp_timing[8];
	u8 ncq_send_recv_cmds[20];
	u8 ncq_non_data_cmds[64];
	u32 zac_zoned_cap;
	u32 zac_zones_optimal_open;
	u32 zac_zones_optimal_nonseq;
	u32 zac_zones_max_open;
	struct ata_cpr_log *cpr_log;
	struct ata_cdl *cdl;
	int spdn_cnt;
	struct ata_ering ering;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	u8 sector_buf[512];
};

struct ata_eh_cmd_timeout_ent {
	const u8 *commands;
	const unsigned int *timeouts;
};

struct ata_eh_info {
	struct ata_device *dev;
	u32 serror;
	unsigned int err_mask;
	unsigned int action;
	unsigned int dev_action[2];
	unsigned int flags;
	unsigned int probe_mask;
	char desc[80];
	int desc_len;
};

struct ata_eh_context {
	struct ata_eh_info i;
	int tries[2];
	int cmd_timeout_idx[16];
	unsigned int classes[2];
	unsigned int did_probe_mask;
	unsigned int unloaded_mask;
	unsigned int saved_ncq_enabled;
	u8 saved_xfer_mode[2];
	long unsigned int last_reset;
};

struct ata_force_param {
	const char *name;
	u8 cbl;
	u8 spd_limit;
	unsigned int xfer_mask;
	unsigned int quirk_on;
	unsigned int quirk_off;
	unsigned int pflags_on;
	u16 lflags_on;
	u16 lflags_off;
};

struct ata_force_ent {
	int port;
	int device;
	struct ata_force_param param;
};

struct ata_port_operations;

struct ata_host {
	spinlock_t lock;
	struct device *dev;
	void * const *iomap;
	unsigned int n_ports;
	unsigned int n_tags;
	void *private_data;
	struct ata_port_operations *ops;
	long unsigned int flags;
	struct kref kref;
	struct mutex eh_mutex;
	struct task_struct *eh_owner;
	struct ata_port *simplex_claimed;
	struct ata_port *ports[0];
};

struct transport_container {
	struct attribute_container ac;
	const struct attribute_group *statistics;
};

struct scsi_transport_template {
	struct transport_container host_attrs;
	struct transport_container target_attrs;
	struct transport_container device_attrs;
	int (*user_scan)(struct Scsi_Host *, uint, uint, u64);
	int device_size;
	int device_private_offset;
	int target_size;
	int target_private_offset;
	int host_size;
	unsigned int create_work_queue: 1;
	void (*eh_strategy_handler)(struct Scsi_Host *);
};

struct ata_internal {
	struct scsi_transport_template t;
	struct device_attribute private_port_attrs[3];
	struct device_attribute private_link_attrs[3];
	struct device_attribute private_dev_attrs[9];
	struct transport_container link_attr_cont;
	struct transport_container dev_attr_cont;
	struct device_attribute *link_attrs[4];
	struct device_attribute *port_attrs[4];
	struct device_attribute *dev_attrs[10];
};

struct ata_ioports {
	void *cmd_addr;
	void *data_addr;
	void *error_addr;
	void *feature_addr;
	void *nsect_addr;
	void *lbal_addr;
	void *lbam_addr;
	void *lbah_addr;
	void *device_addr;
	void *status_addr;
	void *command_addr;
	void *altstatus_addr;
	void *ctl_addr;
	void *bmdma_addr;
	void *scr_addr;
};

struct ata_link {
	struct ata_port *ap;
	int pmp;
	struct device tdev;
	unsigned int active_tag;
	u32 sactive;
	unsigned int flags;
	u32 saved_scontrol;
	unsigned int hw_sata_spd_limit;
	unsigned int sata_spd_limit;
	unsigned int sata_spd;
	enum ata_lpm_policy lpm_policy;
	struct ata_eh_info eh_info;
	struct ata_eh_context eh_context;
	struct ata_device device[2];
	long unsigned int last_lpm_change;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct ata_taskfile {
	long unsigned int flags;
	u8 protocol;
	u8 ctl;
	u8 hob_feature;
	u8 hob_nsect;
	u8 hob_lbal;
	u8 hob_lbam;
	u8 hob_lbah;
	union {
		u8 error;
		u8 feature;
	};
	u8 nsect;
	u8 lbal;
	u8 lbam;
	u8 lbah;
	u8 device;
	union {
		u8 status;
		u8 command;
	};
	u32 auxiliary;
};

struct ata_queued_cmd;

typedef void (*ata_qc_cb_t)(struct ata_queued_cmd *);

struct scsi_cmnd;

struct ata_queued_cmd {
	struct ata_port *ap;
	struct ata_device *dev;
	struct scsi_cmnd *scsicmd;
	void (*scsidone)(struct scsi_cmnd *);
	struct ata_taskfile tf;
	u8 cdb[16];
	long unsigned int flags;
	unsigned int tag;
	unsigned int hw_tag;
	unsigned int n_elem;
	unsigned int orig_n_elem;
	int dma_dir;
	unsigned int sect_size;
	unsigned int nbytes;
	unsigned int extrabytes;
	unsigned int curbytes;
	struct scatterlist sgent;
	struct scatterlist *sg;
	struct scatterlist *cursg;
	unsigned int cursg_ofs;
	unsigned int err_mask;
	struct ata_taskfile result_tf;
	ata_qc_cb_t complete_fn;
	void *private_data;
	void *lldd_task;
};

struct ata_port_stats {
	long unsigned int unhandled_irq;
	long unsigned int idle_irq;
	long unsigned int rw_reqbuf;
};

struct ata_port {
	struct Scsi_Host *scsi_host;
	struct ata_port_operations *ops;
	spinlock_t *lock;
	long unsigned int flags;
	unsigned int pflags;
	unsigned int print_id;
	unsigned int port_no;
	struct ata_ioports ioaddr;
	u8 ctl;
	u8 last_ctl;
	struct ata_link *sff_pio_task_link;
	struct delayed_work sff_pio_task;
	struct ata_bmdma_prd *bmdma_prd;
	dma_addr_t bmdma_prd_dma;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	unsigned int cbl;
	struct ata_queued_cmd qcmd[33];
	u64 qc_active;
	int nr_active_links;
	long: 64;
	long: 64;
	struct ata_link link;
	struct ata_link *slave_link;
	int nr_pmp_links;
	struct ata_link *pmp_link;
	struct ata_link *excl_link;
	struct ata_port_stats stats;
	struct ata_host *host;
	struct device *dev;
	struct device tdev;
	struct mutex scsi_scan_mutex;
	struct delayed_work hotplug_task;
	struct delayed_work scsi_rescan_task;
	unsigned int hsm_task_state;
	struct list_head eh_done_q;
	wait_queue_head_t eh_wait_q;
	int eh_tries;
	struct completion park_req_pending;
	pm_message_t pm_mesg;
	enum ata_lpm_policy target_lpm_policy;
	struct timer_list fastdrain_timer;
	unsigned int fastdrain_cnt;
	async_cookie_t cookie;
	int em_message_type;
	void *private_data;
	struct ata_acpi_gtm __acpi_init_gtm;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct ata_port_info {
	long unsigned int flags;
	long unsigned int link_flags;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	struct ata_port_operations *port_ops;
	void *private_data;
};

typedef int (*ata_prereset_fn_t)(struct ata_link *, long unsigned int);

typedef int (*ata_reset_fn_t)(struct ata_link *, unsigned int *, long unsigned int);

typedef void (*ata_postreset_fn_t)(struct ata_link *, unsigned int *);

struct ata_reset_operations {
	ata_prereset_fn_t prereset;
	ata_reset_fn_t softreset;
	ata_reset_fn_t hardreset;
	ata_postreset_fn_t postreset;
};

struct ata_port_operations {
	int (*qc_defer)(struct ata_queued_cmd *);
	int (*check_atapi_dma)(struct ata_queued_cmd *);
	enum ata_completion_errors (*qc_prep)(struct ata_queued_cmd *);
	unsigned int (*qc_issue)(struct ata_queued_cmd *);
	void (*qc_fill_rtf)(struct ata_queued_cmd *);
	void (*qc_ncq_fill_rtf)(struct ata_port *, u64);
	int (*cable_detect)(struct ata_port *);
	unsigned int (*mode_filter)(struct ata_device *, unsigned int);
	void (*set_piomode)(struct ata_port *, struct ata_device *);
	void (*set_dmamode)(struct ata_port *, struct ata_device *);
	int (*set_mode)(struct ata_link *, struct ata_device **);
	unsigned int (*read_id)(struct ata_device *, struct ata_taskfile *, __le16 *);
	void (*dev_config)(struct ata_device *);
	void (*freeze)(struct ata_port *);
	void (*thaw)(struct ata_port *);
	struct ata_reset_operations reset;
	struct ata_reset_operations pmp_reset;
	void (*error_handler)(struct ata_port *);
	void (*lost_interrupt)(struct ata_port *);
	void (*post_internal_cmd)(struct ata_queued_cmd *);
	void (*sched_eh)(struct ata_port *);
	void (*end_eh)(struct ata_port *);
	int (*scr_read)(struct ata_link *, unsigned int, u32 *);
	int (*scr_write)(struct ata_link *, unsigned int, u32);
	void (*pmp_attach)(struct ata_port *);
	void (*pmp_detach)(struct ata_port *);
	int (*set_lpm)(struct ata_link *, enum ata_lpm_policy, unsigned int);
	int (*port_suspend)(struct ata_port *, pm_message_t);
	int (*port_resume)(struct ata_port *);
	int (*port_start)(struct ata_port *);
	void (*port_stop)(struct ata_port *);
	void (*host_stop)(struct ata_host *);
	void (*sff_dev_select)(struct ata_port *, unsigned int);
	void (*sff_set_devctl)(struct ata_port *, u8);
	u8 (*sff_check_status)(struct ata_port *);
	u8 (*sff_check_altstatus)(struct ata_port *);
	void (*sff_tf_load)(struct ata_port *, const struct ata_taskfile *);
	void (*sff_tf_read)(struct ata_port *, struct ata_taskfile *);
	void (*sff_exec_command)(struct ata_port *, const struct ata_taskfile *);
	unsigned int (*sff_data_xfer)(struct ata_queued_cmd *, unsigned char *, unsigned int, int);
	void (*sff_irq_on)(struct ata_port *);
	bool (*sff_irq_check)(struct ata_port *);
	void (*sff_irq_clear)(struct ata_port *);
	void (*sff_drain_fifo)(struct ata_queued_cmd *);
	void (*bmdma_setup)(struct ata_queued_cmd *);
	void (*bmdma_start)(struct ata_queued_cmd *);
	void (*bmdma_stop)(struct ata_queued_cmd *);
	u8 (*bmdma_status)(struct ata_port *);
	ssize_t (*em_show)(struct ata_port *, char *);
	ssize_t (*em_store)(struct ata_port *, const char *, size_t);
	ssize_t (*sw_activity_show)(struct ata_device *, char *);
	ssize_t (*sw_activity_store)(struct ata_device *, enum sw_activity);
	ssize_t (*transmit_led_message)(struct ata_port *, u32, ssize_t);
	const struct ata_port_operations *inherits;
};

struct ata_show_ering_arg {
	char *buf;
	int written;
};

struct ata_timing {
	short unsigned int mode;
	short unsigned int setup;
	short unsigned int act8b;
	short unsigned int rec8b;
	short unsigned int cyc8b;
	short unsigned int active;
	short unsigned int recover;
	short unsigned int dmack_hold;
	short unsigned int cycle;
	short unsigned int udma;
};

struct ata_xfer_ent {
	int shift;
	int bits;
	u8 base;
};

struct ps2dev;

typedef enum ps2_disposition (*ps2_pre_receive_handler_t)(struct ps2dev *, u8, unsigned int);

typedef void (*ps2_receive_handler_t)(struct ps2dev *, u8);

struct serio;

struct ps2dev {
	struct serio *serio;
	struct mutex cmd_mutex;
	wait_queue_head_t wait;
	long unsigned int flags;
	u8 cmdbuf[8];
	u8 cmdcnt;
	u8 nak;
	ps2_pre_receive_handler_t pre_receive_handler;
	ps2_receive_handler_t receive_handler;
};

struct vivaldi_data {
	u32 function_row_physmap[24];
	unsigned int num_function_row_keys;
};

struct atkbd {
	struct ps2dev ps2dev;
	struct input_dev *dev;
	char name[64];
	char phys[32];
	short unsigned int id;
	short unsigned int keycode[512];
	long unsigned int force_release_mask[8];
	unsigned char set;
	bool translated;
	bool extra;
	bool write;
	bool softrepeat;
	bool softraw;
	bool scroll;
	bool enabled;
	unsigned char emul;
	bool resend;
	bool release;
	long unsigned int xl_bit;
	unsigned int last;
	long unsigned int time;
	long unsigned int err_count;
	struct delayed_work event_work;
	long unsigned int event_jiffies;
	long unsigned int event_mask;
	struct mutex mutex;
	struct vivaldi_data vdata;
};

struct atl_err {
	u64 addr;
	u64 ipid;
	u32 cpu;
};

struct atomic_notifier_head {
	spinlock_t lock;
	struct notifier_block *head;
};

struct attribute_group {
	const char *name;
	umode_t (*is_visible)(struct kobject *, struct attribute *, int);
	umode_t (*is_bin_visible)(struct kobject *, const struct bin_attribute *, int);
	size_t (*bin_size)(struct kobject *, const struct bin_attribute *, int);
	struct attribute **attrs;
	union {
		const struct bin_attribute * const *bin_attrs;
		const struct bin_attribute * const *bin_attrs_new;
	};
};

struct audit_aux_data {
	struct audit_aux_data *next;
	int type;
};

struct audit_cap_data {
	kernel_cap_t permitted;
	kernel_cap_t inheritable;
	union {
		unsigned int fE;
		kernel_cap_t effective;
	};
	kernel_cap_t ambient;
	kuid_t rootid;
};

struct audit_aux_data_bprm_fcaps {
	struct audit_aux_data d;
	struct audit_cap_data fcap;
	unsigned int fcap_ver;
	struct audit_cap_data old_pcap;
	struct audit_cap_data new_pcap;
};

struct lsm_prop_selinux {
	u32 secid;
};

struct smack_known;

struct lsm_prop_smack {
	struct smack_known *skp;
};

struct lsm_prop_apparmor {
	struct aa_label *label;
};

struct lsm_prop_bpf {
	u32 secid;
};

struct lsm_prop {
	struct lsm_prop_selinux selinux;
	struct lsm_prop_smack smack;
	struct lsm_prop_apparmor apparmor;
	struct lsm_prop_bpf bpf;
};

struct audit_aux_data_pids {
	struct audit_aux_data d;
	pid_t target_pid[16];
	kuid_t target_auid[16];
	kuid_t target_uid[16];
	unsigned int target_sessionid[16];
	struct lsm_prop target_ref[16];
	char target_comm[256];
	int pid_count;
};

struct audit_context;

struct audit_buffer {
	struct sk_buff *skb;
	struct audit_context *ctx;
	gfp_t gfp_mask;
};

struct audit_cache {
	const struct cred *ad_subj_cred;
	u64 ktime_ns_expiration[41];
};

struct audit_tree;

struct audit_node {
	struct list_head list;
	struct audit_tree *owner;
	unsigned int index;
};

struct fsnotify_mark;

struct audit_chunk {
	struct list_head hash;
	long unsigned int key;
	struct fsnotify_mark *mark;
	struct list_head trees;
	int count;
	atomic_long_t refs;
	struct callback_head head;
	struct audit_node owners[0];
};

struct filename;

struct audit_names {
	struct list_head list;
	struct filename *name;
	int name_len;
	bool hidden;
	long unsigned int ino;
	dev_t dev;
	umode_t mode;
	kuid_t uid;
	kgid_t gid;
	dev_t rdev;
	struct lsm_prop oprop;
	struct audit_cap_data fcap;
	unsigned int fcap_ver;
	unsigned char type;
	bool should_free;
};

struct mq_attr {
	__kernel_long_t mq_flags;
	__kernel_long_t mq_maxmsg;
	__kernel_long_t mq_msgsize;
	__kernel_long_t mq_curmsgs;
	__kernel_long_t __reserved[4];
};

struct open_how {
	__u64 flags;
	__u64 mode;
	__u64 resolve;
};

struct audit_proctitle {
	int len;
	char *value;
};

struct audit_tree_refs;

struct audit_context {
	int dummy;
	enum {
		AUDIT_CTX_UNUSED = 0,
		AUDIT_CTX_SYSCALL = 1,
		AUDIT_CTX_URING = 2,
	} context;
	enum audit_state state;
	enum audit_state current_state;
	unsigned int serial;
	int major;
	int uring_op;
	struct timespec64 ctime;
	long unsigned int argv[4];
	long int return_code;
	u64 prio;
	int return_valid;
	struct audit_names preallocated_names[5];
	int name_count;
	struct list_head names_list;
	char *filterkey;
	struct path pwd;
	struct audit_aux_data *aux;
	struct audit_aux_data *aux_pids;
	struct __kernel_sockaddr_storage *sockaddr;
	size_t sockaddr_len;
	pid_t ppid;
	kuid_t uid;
	kuid_t euid;
	kuid_t suid;
	kuid_t fsuid;
	kgid_t gid;
	kgid_t egid;
	kgid_t sgid;
	kgid_t fsgid;
	long unsigned int personality;
	int arch;
	pid_t target_pid;
	kuid_t target_auid;
	kuid_t target_uid;
	unsigned int target_sessionid;
	struct lsm_prop target_ref;
	char target_comm[16];
	struct audit_tree_refs *trees;
	struct audit_tree_refs *first_trees;
	struct list_head killed_trees;
	int tree_count;
	int type;
	union {
		struct {
			int nargs;
			long int args[6];
		} socketcall;
		struct {
			kuid_t uid;
			kgid_t gid;
			umode_t mode;
			struct lsm_prop oprop;
			int has_perm;
			uid_t perm_uid;
			gid_t perm_gid;
			umode_t perm_mode;
			long unsigned int qbytes;
		} ipc;
		struct {
			mqd_t mqdes;
			struct mq_attr mqstat;
		} mq_getsetattr;
		struct {
			mqd_t mqdes;
			int sigev_signo;
		} mq_notify;
		struct {
			mqd_t mqdes;
			size_t msg_len;
			unsigned int msg_prio;
			struct timespec64 abs_timeout;
		} mq_sendrecv;
		struct {
			int oflag;
			umode_t mode;
			struct mq_attr attr;
		} mq_open;
		struct {
			pid_t pid;
			struct audit_cap_data cap;
		} capset;
		struct {
			int fd;
			int flags;
		} mmap;
		struct open_how openat2;
		struct {
			int argc;
		} execve;
		struct {
			const char *name;
		} module;
		struct {
			struct audit_ntp_data ntp_data;
			struct timespec64 tk_injoffset;
		} time;
	};
	int fds[2];
	struct audit_proctitle proctitle;
};

struct audit_ctl_mutex {
	struct mutex lock;
	void *owner;
};

struct audit_field;

struct audit_watch;

struct audit_fsnotify_mark;

struct audit_krule {
	u32 pflags;
	u32 flags;
	u32 listnr;
	u32 action;
	u32 mask[64];
	u32 buflen;
	u32 field_count;
	char *filterkey;
	struct audit_field *fields;
	struct audit_field *arch_f;
	struct audit_field *inode_f;
	struct audit_watch *watch;
	struct audit_tree *tree;
	struct audit_fsnotify_mark *exe;
	struct list_head rlist;
	struct list_head list;
	u64 prio;
};

struct audit_entry {
	struct list_head list;
	struct callback_head rcu;
	struct audit_krule rule;
};

struct audit_features {
	__u32 vers;
	__u32 mask;
	__u32 features;
	__u32 lock;
};

struct audit_field {
	u32 type;
	union {
		u32 val;
		kuid_t uid;
		kgid_t gid;
		struct {
			char *lsm_str;
			void *lsm_rule;
		};
	};
	u32 op;
};

struct fsnotify_group;

struct fsnotify_mark_connector;

struct fsnotify_mark {
	__u32 mask;
	refcount_t refcnt;
	struct fsnotify_group *group;
	struct list_head g_list;
	spinlock_t lock;
	struct hlist_node obj_list;
	struct fsnotify_mark_connector *connector;
	__u32 ignore_mask;
	unsigned int flags;
};

struct audit_fsnotify_mark {
	dev_t dev;
	long unsigned int ino;
	char *path;
	struct fsnotify_mark mark;
	struct audit_krule *rule;
};

struct sock;

struct audit_net {
	struct sock *sk;
};

struct audit_netlink_list {
	__u32 portid;
	struct net *net;
	struct sk_buff_head q;
};

struct audit_nfcfgop_tab {
	enum audit_nfcfgop op;
	const char *s;
};

struct audit_parent {
	struct list_head watches;
	struct fsnotify_mark mark;
};

struct audit_reply {
	__u32 portid;
	struct net *net;
	struct sk_buff *skb;
};

struct audit_rule_data {
	__u32 flags;
	__u32 action;
	__u32 field_count;
	__u32 mask[64];
	__u32 fields[64];
	__u32 values[64];
	__u32 fieldflags[64];
	__u32 buflen;
	char buf[0];
};

struct audit_sig_info {
	uid_t uid;
	pid_t pid;
	char ctx[0];
};

struct audit_status {
	__u32 mask;
	__u32 enabled;
	__u32 failure;
	__u32 pid;
	__u32 rate_limit;
	__u32 backlog_limit;
	__u32 lost;
	__u32 backlog;
	union {
		__u32 version;
		__u32 feature_bitmap;
	};
	__u32 backlog_wait_time;
	__u32 backlog_wait_time_actual;
};

struct audit_tree {
	refcount_t count;
	int goner;
	struct audit_chunk *root;
	struct list_head chunks;
	struct list_head rules;
	struct list_head list;
	struct list_head same_root;
	struct callback_head head;
	char pathname[0];
};

struct audit_tree_mark {
	struct fsnotify_mark mark;
	struct audit_chunk *chunk;
};

struct audit_tree_refs {
	struct audit_tree_refs *next;
	struct audit_chunk *c[31];
};

struct audit_tty_status {
	__u32 enabled;
	__u32 log_passwd;
};

struct audit_watch {
	refcount_t count;
	dev_t dev;
	char *path;
	long unsigned int ino;
	struct audit_parent *parent;
	struct list_head wlist;
	struct list_head rules;
};

struct auditd_connection {
	struct pid *pid;
	u32 portid;
	struct net *net;
	struct callback_head rcu;
};

struct auth_cred {
	const struct cred *cred;
	const char *principal;
};

struct auth_ops;

struct auth_domain {
	struct kref ref;
	struct hlist_node hash;
	char *name;
	struct auth_ops *flavour;
	struct callback_head callback_head;
};

struct svc_rqst;

struct auth_ops {
	char *name;
	struct module *owner;
	int flavour;
	enum svc_auth_status (*accept)(struct svc_rqst *);
	int (*release)(struct svc_rqst *);
	void (*domain_release)(struct auth_domain *);
	enum svc_auth_status (*set_client)(struct svc_rqst *);
	rpc_authflavor_t (*pseudoflavor)(struct svc_rqst *);
};

struct auto_mode_param {
	int qp_type;
};

struct auto_movable_group_stats {
	long unsigned int movable_pages;
	long unsigned int req_kernel_early_pages;
};

struct auto_movable_stats {
	long unsigned int kernel_early_pages;
	long unsigned int movable_pages;
};

struct autofs_dev_ioctl {
	__u32 ver_major;
	__u32 ver_minor;
	__u32 size;
	__s32 ioctlfd;
	union {
		struct args_protover protover;
		struct args_protosubver protosubver;
		struct args_openmount openmount;
		struct args_ready ready;
		struct args_fail fail;
		struct args_setpipefd setpipefd;
		struct args_timeout timeout;
		struct args_requester requester;
		struct args_expire expire;
		struct args_askumount askumount;
		struct args_ismountpoint ismountpoint;
	};
	char path[0];
};

struct autofs_fs_context {
	kuid_t uid;
	kgid_t gid;
	int pgrp;
	bool pgrp_set;
};

struct autofs_sb_info;

struct autofs_info {
	struct dentry *dentry;
	int flags;
	struct completion expire_complete;
	struct list_head active;
	struct list_head expiring;
	struct autofs_sb_info *sbi;
	long unsigned int exp_timeout;
	long unsigned int last_used;
	int count;
	kuid_t uid;
	kgid_t gid;
	struct callback_head rcu;
};

struct autofs_packet_hdr {
	int proto_version;
	int type;
};

struct autofs_packet_expire {
	struct autofs_packet_hdr hdr;
	int len;
	char name[256];
};

struct autofs_packet_expire_multi {
	struct autofs_packet_hdr hdr;
	autofs_wqt_t wait_queue_token;
	int len;
	char name[256];
};

struct autofs_packet_missing {
	struct autofs_packet_hdr hdr;
	autofs_wqt_t wait_queue_token;
	int len;
	char name[256];
};

union autofs_packet_union {
	struct autofs_packet_hdr hdr;
	struct autofs_packet_missing missing;
	struct autofs_packet_expire expire;
	struct autofs_packet_expire_multi expire_multi;
};

struct super_block;

struct autofs_wait_queue;

struct autofs_sb_info {
	u32 magic;
	int pipefd;
	struct file *pipe;
	struct pid *oz_pgrp;
	int version;
	int sub_version;
	int min_proto;
	int max_proto;
	unsigned int flags;
	long unsigned int exp_timeout;
	unsigned int type;
	struct super_block *sb;
	struct mutex wq_mutex;
	struct mutex pipe_mutex;
	spinlock_t fs_lock;
	struct autofs_wait_queue *queues;
	spinlock_t lookup_lock;
	struct list_head active_list;
	struct list_head expiring_list;
	struct callback_head rcu;
};

struct autofs_v5_packet {
	struct autofs_packet_hdr hdr;
	autofs_wqt_t wait_queue_token;
	__u32 dev;
	__u64 ino;
	__u32 uid;
	__u32 gid;
	__u32 pid;
	__u32 tgid;
	__u32 len;
	char name[256];
};

typedef struct autofs_v5_packet autofs_packet_expire_direct_t;

typedef struct autofs_v5_packet autofs_packet_expire_indirect_t;

typedef struct autofs_v5_packet autofs_packet_missing_direct_t;

typedef struct autofs_v5_packet autofs_packet_missing_indirect_t;

union autofs_v5_packet_union {
	struct autofs_packet_hdr hdr;
	struct autofs_v5_packet v5_packet;
	autofs_packet_missing_indirect_t missing_indirect;
	autofs_packet_expire_indirect_t expire_indirect;
	autofs_packet_missing_direct_t missing_direct;
	autofs_packet_expire_direct_t expire_direct;
};

struct qstr {
	union {
		struct {
			u32 hash;
			u32 len;
		};
		u64 hash_len;
	};
	const unsigned char *name;
};

struct autofs_wait_queue {
	wait_queue_head_t queue;
	struct autofs_wait_queue *next;
	autofs_wqt_t wait_queue_token;
	struct qstr name;
	u32 offset;
	u32 dev;
	u64 ino;
	kuid_t uid;
	kgid_t gid;
	pid_t pid;
	pid_t tgid;
	int status;
	unsigned int wait_ctr;
};

struct task_group;

struct autogroup {
	struct kref kref;
	struct task_group *tg;
	struct rw_semaphore lock;
	long unsigned int id;
	int nice;
};

struct auxiliary_device {
	struct device dev;
	const char *name;
	u32 id;
	struct {
		struct xarray irqs;
		struct mutex lock;
		bool irq_dir_exists;
	} sysfs;
};

struct auxiliary_device_id {
	char name[32];
	kernel_ulong_t driver_data;
};

struct auxiliary_driver {
	int (*probe)(struct auxiliary_device *, const struct auxiliary_device_id *);
	void (*remove)(struct auxiliary_device *);
	void (*shutdown)(struct auxiliary_device *);
	int (*suspend)(struct auxiliary_device *, pm_message_t);
	int (*resume)(struct auxiliary_device *);
	const char *name;
	struct device_driver driver;
	const struct auxiliary_device_id *id_table;
};

struct auxiliary_irq_info {
	struct device_attribute sysfs_attr;
	char name[11];
};

struct av_decision {
	u32 allowed;
	u32 auditallow;
	u32 auditdeny;
	u32 seqno;
	u32 flags;
};

struct hlist_head {
	struct hlist_node *first;
};

struct avc_cache {
	struct hlist_head slots[512];
	spinlock_t slots_lock[512];
	atomic_t lru_hint;
	atomic_t active_nodes;
	u32 latest_notif;
};

struct avc_cache_stats {
	unsigned int lookups;
	unsigned int misses;
	unsigned int allocations;
	unsigned int reclaims;
	unsigned int frees;
};

struct avc_callback_node {
	int (*callback)(u32);
	u32 events;
	struct avc_callback_node *next;
};

struct avc_xperms_node;

struct avc_entry {
	u32 ssid;
	u32 tsid;
	u16 tclass;
	struct av_decision avd;
	struct avc_xperms_node *xp_node;
};

struct avc_node {
	struct avc_entry ae;
	struct hlist_node list;
	struct callback_head rhead;
};

struct extended_perms_data;

struct extended_perms_decision {
	u8 used;
	u8 driver;
	u8 base_perm;
	struct extended_perms_data *allowed;
	struct extended_perms_data *auditallow;
	struct extended_perms_data *dontaudit;
};

struct avc_xperms_decision_node {
	struct extended_perms_decision xpd;
	struct list_head xpd_list;
};

struct extended_perms_data {
	u32 p[8];
};

struct extended_perms {
	u16 len;
	u8 base_perms;
	struct extended_perms_data drivers;
};

struct avc_xperms_node {
	struct extended_perms xp;
	struct list_head xpd_head;
};

struct avdc_entry {
	u32 isid;
	u32 allowed;
	u32 audited;
	bool permissive;
};

struct avtab_node;

struct avtab {
	struct avtab_node **htable;
	u32 nel;
	u32 nslot;
	u32 mask;
};

struct avtab_extended_perms;

struct avtab_datum {
	union {
		u32 data;
		struct avtab_extended_perms *xperms;
	} u;
};

struct avtab_extended_perms {
	u8 specified;
	u8 driver;
	struct extended_perms_data perms;
};

struct avtab_key {
	u16 source_type;
	u16 target_type;
	u16 target_class;
	u16 specified;
};

struct avtab_node {
	struct avtab_key key;
	struct avtab_datum datum;
	struct avtab_node *next;
};

struct ctl_table_header;

struct ax25_dev {
	struct list_head list;
	struct net_device *dev;
	netdevice_tracker dev_tracker;
	struct net_device *forward;
	struct ctl_table_header *sysheader;
	int values[14];
	ax25_dama_info dama;
	refcount_t refcount;
	bool device_up;
	struct callback_head rcu;
};

struct regmap_irq_chip_data;

struct mfd_cell;

struct regmap_config;

struct regmap_irq_chip;

struct axp20x_dev {
	struct device *dev;
	int irq;
	long unsigned int irq_flags;
	struct regmap *regmap;
	struct regmap_irq_chip_data *regmap_irqc;
	enum axp20x_variants variant;
	int nr_cells;
	const struct mfd_cell *cells;
	const struct regmap_config *regmap_cfg;
	const struct regmap_irq_chip *regmap_irq_chip;
};

struct backing_aio {
	struct kiocb iocb;
	refcount_t ref;
	struct kiocb *orig_iocb;
	void (*end_write)(struct kiocb *, ssize_t);
	struct work_struct work;
	long int res;
};

struct percpu_counter {
	raw_spinlock_t lock;
	s64 count;
	struct list_head list;
	s32 *counters;
};

struct fprop_local_percpu {
	struct percpu_counter events;
	unsigned int period;
	raw_spinlock_t lock;
};

struct percpu_ref_data;

struct percpu_ref {
	long unsigned int percpu_count_ptr;
	struct percpu_ref_data *data;
};

struct backing_dev_info;

struct cgroup_subsys_state;

struct bdi_writeback {
	struct backing_dev_info *bdi;
	long unsigned int state;
	long unsigned int last_old_flush;
	struct list_head b_dirty;
	struct list_head b_io;
	struct list_head b_more_io;
	struct list_head b_dirty_time;
	spinlock_t list_lock;
	atomic_t writeback_inodes;
	struct percpu_counter stat[4];
	long unsigned int bw_time_stamp;
	long unsigned int dirtied_stamp;
	long unsigned int written_stamp;
	long unsigned int write_bandwidth;
	long unsigned int avg_write_bandwidth;
	long unsigned int dirty_ratelimit;
	long unsigned int balanced_dirty_ratelimit;
	struct fprop_local_percpu completions;
	int dirty_exceeded;
	enum wb_reason start_all_reason;
	spinlock_t work_lock;
	struct list_head work_list;
	struct delayed_work dwork;
	struct delayed_work bw_dwork;
	struct list_head bdi_node;
	struct percpu_ref refcnt;
	struct fprop_local_percpu memcg_completions;
	struct cgroup_subsys_state *memcg_css;
	struct cgroup_subsys_state *blkcg_css;
	struct list_head memcg_node;
	struct list_head blkcg_node;
	struct list_head b_attached;
	struct list_head offline_node;
	union {
		struct work_struct release_work;
		struct callback_head rcu;
	};
};

struct backing_dev_info {
	u64 id;
	struct rb_node rb_node;
	struct list_head bdi_list;
	long unsigned int ra_pages;
	long unsigned int io_pages;
	struct kref refcnt;
	unsigned int capabilities;
	unsigned int min_ratio;
	unsigned int max_ratio;
	unsigned int max_prop_frac;
	atomic_long_t tot_write_bandwidth;
	long unsigned int last_bdp_sleep;
	struct bdi_writeback wb;
	struct list_head wb_list;
	struct xarray cgwb_tree;
	struct mutex cgwb_release_mutex;
	struct rw_semaphore wb_switch_rwsem;
	wait_queue_head_t wb_waitq;
	struct device *dev;
	char dev_name[64];
	struct device *owner;
	struct timer_list laptop_mode_wb_timer;
	struct dentry *debug_dir;
};

struct file_ra_state {
	long unsigned int start;
	unsigned int size;
	unsigned int async_size;
	unsigned int ra_pages;
	short unsigned int order;
	short unsigned int mmap_miss;
	loff_t prev_pos;
};

struct fown_struct;

struct file {
	spinlock_t f_lock;
	fmode_t f_mode;
	const struct file_operations *f_op;
	struct address_space *f_mapping;
	void *private_data;
	struct inode *f_inode;
	unsigned int f_flags;
	unsigned int f_iocb_flags;
	const struct cred *f_cred;
	struct fown_struct *f_owner;
	struct path f_path;
	union {
		struct mutex f_pos_lock;
		u64 f_pipe;
	};
	loff_t f_pos;
	void *f_security;
	errseq_t f_wb_err;
	errseq_t f_sb_err;
	struct hlist_head *f_ep;
	union {
		struct callback_head f_task_work;
		struct llist_node f_llist;
		struct file_ra_state f_ra;
		freeptr_t f_freeptr;
	};
	file_ref_t f_ref;
};

struct backing_file {
	struct file file;
	union {
		struct path user_path;
		freeptr_t bf_freeptr;
	};
};

struct backing_file_ctx {
	const struct cred *cred;
	void (*accessed)(struct file *);
	void (*end_write)(struct kiocb *, ssize_t);
};

struct backlight_properties {
	int brightness;
	int max_brightness;
	int power;
	enum backlight_type type;
	unsigned int state;
	enum backlight_scale scale;
};

struct backlight_ops;

struct backlight_device {
	struct backlight_properties props;
	struct mutex update_lock;
	struct mutex ops_lock;
	const struct backlight_ops *ops;
	struct list_head entry;
	struct device dev;
	int use_count;
};

struct backlight_ops {
	unsigned int options;
	int (*update_status)(struct backlight_device *);
	int (*get_brightness)(struct backlight_device *);
	bool (*controls_device)(struct backlight_device *, struct device *);
};

struct bpf_verifier_env;

struct backtrack_state {
	struct bpf_verifier_env *env;
	u32 frame;
	u32 reg_masks[8];
	u64 stack_masks[8];
};

struct badblocks {
	struct device *dev;
	int count;
	int unacked_exist;
	int shift;
	u64 *page;
	int changed;
	seqlock_t lock;
	sector_t sector;
	sector_t size;
};

struct badblocks_context {
	sector_t start;
	sector_t len;
	int ack;
};

struct balance_callback {
	struct balance_callback *next;
	void (*func)(struct rq *);
};

struct balloon_dev_info {
	long unsigned int isolated_pages;
	spinlock_t pages_lock;
	struct list_head pages;
	int (*migratepage)(struct balloon_dev_info *, struct page *, struct page *, enum migrate_mode);
};

struct balloon_stats {
	long unsigned int current_pages;
	long unsigned int target_pages;
	long unsigned int target_unpopulated;
	long unsigned int balloon_low;
	long unsigned int balloon_high;
	long unsigned int total_pages;
	long unsigned int schedule_delay;
	long unsigned int max_schedule_delay;
	long unsigned int retry_count;
	long unsigned int max_retry_count;
};

struct batadv_unicast_packet {
	__u8 packet_type;
	__u8 version;
	__u8 ttl;
	__u8 ttvn;
	__u8 dest[6];
};

struct batch_u16 {
	u16 entropy[48];
	local_lock_t lock;
	long unsigned int generation;
	unsigned int position;
};

struct batch_u32 {
	u32 entropy[24];
	local_lock_t lock;
	long unsigned int generation;
	unsigned int position;
};

struct batch_u64 {
	u64 entropy[12];
	local_lock_t lock;
	long unsigned int generation;
	unsigned int position;
};

struct batch_u8 {
	u8 entropy[96];
	local_lock_t lock;
	long unsigned int generation;
	unsigned int position;
};

struct minmax_sample {
	u32 t;
	u32 v;
};

struct minmax {
	struct minmax_sample s[3];
};

struct bbr {
	u32 min_rtt_us;
	u32 min_rtt_stamp;
	u32 probe_rtt_done_stamp;
	struct minmax bw;
	u32 rtt_cnt;
	u32 next_rtt_delivered;
	u64 cycle_mstamp;
	u32 mode: 3;
	u32 prev_ca_state: 3;
	u32 packet_conservation: 1;
	u32 round_start: 1;
	u32 idle_restart: 1;
	u32 probe_rtt_round_done: 1;
	u32 unused: 13;
	u32 lt_is_sampling: 1;
	u32 lt_rtt_cnt: 7;
	u32 lt_use_bw: 1;
	u32 lt_bw;
	u32 lt_last_delivered;
	u32 lt_last_stamp;
	u32 lt_last_lost;
	u32 pacing_gain: 10;
	u32 cwnd_gain: 10;
	u32 full_bw_reached: 1;
	u32 full_bw_cnt: 2;
	u32 cycle_idx: 3;
	u32 has_seen_rtt: 1;
	u32 unused_b: 5;
	u32 prior_cwnd;
	u32 full_bw;
	u64 ack_epoch_mstamp;
	u16 extra_acked[2];
	u32 ack_epoch_acked: 20;
	u32 extra_acked_win_rtts: 5;
	u32 extra_acked_win_idx: 1;
	u32 unused_c: 6;
};

struct bd_holder_disk {
	struct list_head list;
	struct kobject *holder_dir;
	int refcnt;
};

struct gendisk;

struct request_queue;

struct disk_stats;

struct blk_holder_ops;

struct partition_meta_info;

struct block_device {
	sector_t bd_start_sect;
	sector_t bd_nr_sectors;
	struct gendisk *bd_disk;
	struct request_queue *bd_queue;
	struct disk_stats *bd_stats;
	long unsigned int bd_stamp;
	atomic_t __bd_flags;
	dev_t bd_dev;
	struct address_space *bd_mapping;
	atomic_t bd_openers;
	spinlock_t bd_size_lock;
	void *bd_claiming;
	void *bd_holder;
	const struct blk_holder_ops *bd_holder_ops;
	struct mutex bd_holder_lock;
	int bd_holders;
	struct kobject *bd_holder_dir;
	atomic_t bd_fsfreeze_count;
	struct mutex bd_fsfreeze_mutex;
	struct partition_meta_info *bd_meta_info;
	int bd_writers;
	void *bd_security;
	struct device bd_device;
};

struct posix_acl;

struct inode_operations;

struct file_lock_context;

struct pipe_inode_info;

struct cdev;

struct fscrypt_inode_info;

struct fsverity_info;

struct inode {
	umode_t i_mode;
	short unsigned int i_opflags;
	kuid_t i_uid;
	kgid_t i_gid;
	unsigned int i_flags;
	struct posix_acl *i_acl;
	struct posix_acl *i_default_acl;
	const struct inode_operations *i_op;
	struct super_block *i_sb;
	struct address_space *i_mapping;
	void *i_security;
	long unsigned int i_ino;
	union {
		const unsigned int i_nlink;
		unsigned int __i_nlink;
	};
	dev_t i_rdev;
	loff_t i_size;
	time64_t i_atime_sec;
	time64_t i_mtime_sec;
	time64_t i_ctime_sec;
	u32 i_atime_nsec;
	u32 i_mtime_nsec;
	u32 i_ctime_nsec;
	u32 i_generation;
	spinlock_t i_lock;
	short unsigned int i_bytes;
	u8 i_blkbits;
	enum rw_hint i_write_hint;
	blkcnt_t i_blocks;
	u32 i_state;
	struct rw_semaphore i_rwsem;
	long unsigned int dirtied_when;
	long unsigned int dirtied_time_when;
	struct hlist_node i_hash;
	struct list_head i_io_list;
	struct bdi_writeback *i_wb;
	int i_wb_frn_winner;
	u16 i_wb_frn_avg_time;
	u16 i_wb_frn_history;
	struct list_head i_lru;
	struct list_head i_sb_list;
	struct list_head i_wb_list;
	union {
		struct hlist_head i_dentry;
		struct callback_head i_rcu;
	};
	atomic64_t i_version;
	atomic64_t i_sequence;
	atomic_t i_count;
	atomic_t i_dio_count;
	atomic_t i_writecount;
	atomic_t i_readcount;
	union {
		const struct file_operations *i_fop;
		void (*free_inode)(struct inode *);
	};
	struct file_lock_context *i_flctx;
	struct address_space i_data;
	union {
		struct list_head i_devices;
		int i_linklen;
	};
	union {
		struct pipe_inode_info *i_pipe;
		struct cdev *i_cdev;
		char *i_link;
		unsigned int i_dir_seq;
	};
	__u32 i_fsnotify_mask;
	struct fsnotify_mark_connector *i_fsnotify_marks;
	struct fscrypt_inode_info *i_crypt_info;
	struct fsverity_info *i_verity_info;
	void *i_private;
};

struct bdev_inode {
	struct block_device bdev;
	struct inode vfs_inode;
};

struct bfq_sched_data;

struct bfq_queue;

struct bfq_entity {
	struct rb_node rb_node;
	bool on_st_or_in_serv;
	u64 start;
	u64 finish;
	struct rb_root *tree;
	u64 min_start;
	int service;
	int budget;
	int allocated;
	int dev_weight;
	int weight;
	int new_weight;
	int orig_weight;
	struct bfq_entity *parent;
	struct bfq_sched_data *my_sched_data;
	struct bfq_sched_data *sched_data;
	int prio_changed;
	bool in_groups_with_pending_reqs;
	struct bfq_queue *last_bfqq_created;
};

struct bfq_ttime {
	u64 last_end_request;
	u64 ttime_total;
	long unsigned int ttime_samples;
	u64 ttime_mean;
};

struct bfq_data;

struct request;

struct bfq_weight_counter;

struct bfq_io_cq;

struct bfq_queue {
	int ref;
	int stable_ref;
	struct bfq_data *bfqd;
	short unsigned int ioprio;
	short unsigned int ioprio_class;
	short unsigned int new_ioprio;
	short unsigned int new_ioprio_class;
	u64 last_serv_time_ns;
	unsigned int inject_limit;
	long unsigned int decrease_time_jif;
	struct bfq_queue *new_bfqq;
	struct rb_node pos_node;
	struct rb_root *pos_root;
	struct rb_root sort_list;
	struct request *next_rq;
	int queued[2];
	int meta_pending;
	struct list_head fifo;
	struct bfq_entity entity;
	struct bfq_weight_counter *weight_counter;
	int max_budget;
	long unsigned int budget_timeout;
	int dispatched;
	long unsigned int flags;
	struct list_head bfqq_list;
	struct bfq_ttime ttime;
	u64 io_start_time;
	u64 tot_idle_time;
	u32 seek_history;
	struct hlist_node burst_list_node;
	sector_t last_request_pos;
	unsigned int requests_within_timer;
	pid_t pid;
	struct bfq_io_cq *bic;
	long unsigned int wr_cur_max_time;
	long unsigned int soft_rt_next_start;
	long unsigned int last_wr_start_finish;
	unsigned int wr_coeff;
	long unsigned int last_idle_bklogged;
	long unsigned int service_from_backlogged;
	long unsigned int service_from_wr;
	long unsigned int wr_start_at_switch_to_srt;
	long unsigned int split_time;
	long unsigned int first_IO_time;
	long unsigned int creation_time;
	struct bfq_queue *waker_bfqq;
	struct bfq_queue *tentative_waker_bfqq;
	unsigned int num_waker_detections;
	u64 waker_detection_started;
	struct hlist_node woken_list_node;
	struct hlist_head woken_list;
	unsigned int actuator_idx;
};

struct blk_independent_access_range {
	struct kobject kobj;
	sector_t sector;
	sector_t nr_sectors;
};

struct bfq_group;

struct bfq_data {
	struct request_queue *queue;
	struct list_head dispatch;
	struct bfq_group *root_group;
	struct rb_root_cached queue_weights_tree;
	unsigned int num_groups_with_pending_reqs;
	unsigned int busy_queues[3];
	int wr_busy_queues;
	int queued;
	int tot_rq_in_driver;
	int rq_in_driver[8];
	bool nonrot_with_queueing;
	int max_rq_in_driver;
	int hw_tag_samples;
	int hw_tag;
	int budgets_assigned;
	struct hrtimer idle_slice_timer;
	struct bfq_queue *in_service_queue;
	sector_t last_position;
	sector_t in_serv_last_pos;
	u64 last_completion;
	struct bfq_queue *last_completed_rq_bfqq;
	struct bfq_queue *last_bfqq_created;
	u64 last_empty_occupied_ns;
	bool wait_dispatch;
	struct request *waited_rq;
	bool rqs_injected;
	u64 first_dispatch;
	u64 last_dispatch;
	ktime_t last_budget_start;
	ktime_t last_idling_start;
	long unsigned int last_idling_start_jiffies;
	int peak_rate_samples;
	u32 sequential_samples;
	u64 tot_sectors_dispatched;
	u32 last_rq_max_size;
	u64 delta_from_first;
	u32 peak_rate;
	int bfq_max_budget;
	struct list_head active_list[8];
	struct list_head idle_list;
	u64 bfq_fifo_expire[2];
	unsigned int bfq_back_penalty;
	unsigned int bfq_back_max;
	u32 bfq_slice_idle;
	int bfq_user_max_budget;
	unsigned int bfq_timeout;
	bool strict_guarantees;
	long unsigned int last_ins_in_burst;
	long unsigned int bfq_burst_interval;
	int burst_size;
	struct bfq_entity *burst_parent_entity;
	long unsigned int bfq_large_burst_thresh;
	bool large_burst;
	struct hlist_head burst_list;
	bool low_latency;
	unsigned int bfq_wr_coeff;
	unsigned int bfq_wr_rt_max_time;
	unsigned int bfq_wr_min_idle_time;
	long unsigned int bfq_wr_min_inter_arr_async;
	unsigned int bfq_wr_max_softrt_rate;
	u64 rate_dur_prod;
	struct bfq_queue oom_bfqq;
	spinlock_t lock;
	struct bfq_io_cq *bio_bic;
	struct bfq_queue *bio_bfqq;
	unsigned int async_depths[4];
	unsigned int num_actuators;
	sector_t sector[8];
	sector_t nr_sectors[8];
	struct blk_independent_access_range ia_ranges[8];
	unsigned int actuator_load_threshold;
};

struct blkcg_gq;

struct blkg_policy_data {
	struct blkcg_gq *blkg;
	int plid;
	bool online;
};

struct bfq_service_tree {
	struct rb_root active;
	struct rb_root idle;
	struct bfq_entity *first_idle;
	struct bfq_entity *last_idle;
	u64 vtime;
	long unsigned int wsum;
};

struct bfq_sched_data {
	struct bfq_entity *in_service_entity;
	struct bfq_entity *next_in_service;
	struct bfq_service_tree service_tree[3];
	long unsigned int bfq_class_idle_last_service;
};

struct blkg_rwstat {
	struct percpu_counter cpu_cnt[5];
	atomic64_t aux_cnt[5];
};

struct bfqg_stats {
	struct blkg_rwstat bytes;
	struct blkg_rwstat ios;
};

struct bfq_group {
	struct blkg_policy_data pd;
	refcount_t ref;
	struct bfq_entity entity;
	struct bfq_sched_data sched_data;
	struct bfq_data *bfqd;
	struct bfq_queue *async_bfqq[128];
	struct bfq_queue *async_idle_bfqq[8];
	struct bfq_entity *my_entity;
	int active_entities;
	int num_queues_with_pending_reqs;
	struct rb_root rq_pos_tree;
	struct bfqg_stats stats;
};

struct blkcg;

struct blkcg_policy_data {
	struct blkcg *blkcg;
	int plid;
};

struct bfq_group_data {
	struct blkcg_policy_data pd;
	unsigned int weight;
};

struct io_context;

struct kmem_cache;

struct io_cq {
	struct request_queue *q;
	struct io_context *ioc;
	union {
		struct list_head q_node;
		struct kmem_cache *__rcu_icq_cache;
	};
	union {
		struct hlist_node ioc_node;
		struct callback_head __rcu_head;
	};
	unsigned int flags;
};

struct bfq_iocq_bfqq_data {
	bool saved_has_short_ttime;
	bool saved_IO_bound;
	bool saved_in_large_burst;
	bool was_in_burst_list;
	unsigned int saved_weight;
	u64 saved_io_start_time;
	u64 saved_tot_idle_time;
	long unsigned int saved_wr_coeff;
	long unsigned int saved_last_wr_start_finish;
	long unsigned int saved_service_from_wr;
	long unsigned int saved_wr_start_at_switch_to_srt;
	struct bfq_ttime saved_ttime;
	unsigned int saved_wr_cur_max_time;
	unsigned int saved_inject_limit;
	long unsigned int saved_decrease_time_jif;
	u64 saved_last_serv_time_ns;
	struct bfq_queue *stable_merge_bfqq;
	bool stably_merged;
};

struct bfq_io_cq {
	struct io_cq icq;
	struct bfq_queue *bfqq[16];
	int ioprio;
	uint64_t blkcg_serial_nr;
	struct bfq_iocq_bfqq_data bfqq_data[8];
	unsigned int requests;
};

struct bfq_weight_counter {
	unsigned int weight;
	unsigned int num_active;
	struct rb_node weights_node;
};

struct bh_accounting {
	int nr;
	int ratelimit;
};

struct buffer_head;

struct bh_lru {
	struct buffer_head *bhs[16];
};

struct big_key_payload {
	u8 *data;
	struct path path;
	size_t length;
};

struct mm_struct;

struct list_lru;

struct binder_alloc {
	struct mutex mutex;
	struct mm_struct *mm;
	long unsigned int vm_start;
	struct list_head buffers;
	struct rb_root free_buffers;
	struct rb_root allocated_buffers;
	size_t free_async_space;
	struct page **pages;
	struct list_lru *freelist;
	size_t buffer_size;
	int pid;
	size_t pages_high;
	bool mapped;
	bool oneway_spam_detected;
};

struct binder_transaction;

struct binder_node;

struct binder_buffer {
	struct list_head entry;
	struct rb_node rb_node;
	unsigned int free: 1;
	unsigned int clear_on_free: 1;
	unsigned int allow_user_free: 1;
	unsigned int async_transaction: 1;
	unsigned int oneway_spam_suspect: 1;
	unsigned int debug_id: 27;
	struct binder_transaction *transaction;
	struct binder_node *target_node;
	size_t data_size;
	size_t offsets_size;
	size_t extra_buffers_size;
	long unsigned int user_data;
	int pid;
};

struct binder_object_header {
	__u32 type;
};

struct binder_buffer_object {
	struct binder_object_header hdr;
	__u32 flags;
	binder_uintptr_t buffer;
	binder_size_t length;
	binder_size_t parent;
	binder_size_t parent_offset;
};

struct binder_context {
	struct binder_node *binder_context_mgr_node;
	struct mutex context_mgr_node_lock;
	kuid_t binder_context_mgr_uid;
	const char *name;
};

struct binder_debugfs_entry {
	const char *name;
	umode_t mode;
	const struct file_operations *fops;
	void *data;
};

struct miscdevice {
	int minor;
	const char *name;
	const struct file_operations *fops;
	struct list_head list;
	struct device *parent;
	struct device *this_device;
	const struct attribute_group **groups;
	const char *nodename;
	umode_t mode;
};

struct binder_device {
	struct hlist_node hlist;
	struct miscdevice miscdev;
	struct binder_context context;
	struct inode *binderfs_inode;
	refcount_t ref;
};

struct binder_work {
	struct list_head entry;
	enum binder_work_type type;
};

struct binder_error {
	struct binder_work work;
	uint32_t cmd;
};

struct binder_extended_error {
	__u32 id;
	__u32 command;
	__s32 param;
};

struct binder_fd_array_object {
	struct binder_object_header hdr;
	__u32 pad;
	binder_size_t num_fds;
	binder_size_t parent;
	binder_size_t parent_offset;
};

struct binder_fd_object {
	struct binder_object_header hdr;
	__u32 pad_flags;
	union {
		binder_uintptr_t pad_binder;
		__u32 fd;
	};
	binder_uintptr_t cookie;
};

struct binder_features {
	bool oneway_spam_detection;
	bool extended_error;
	bool freeze_notification;
};

struct binder_freeze_info {
	__u32 pid;
	__u32 enable;
	__u32 timeout_ms;
};

struct binder_frozen_state_info {
	binder_uintptr_t cookie;
	__u32 is_frozen;
	__u32 reserved;
};

struct binder_frozen_status_info {
	__u32 pid;
	__u32 sync_recv;
	__u32 async_recv;
};

struct binder_handle_cookie {
	__u32 handle;
	binder_uintptr_t cookie;
} __attribute__((packed));

struct binder_proc;

struct binder_node {
	int debug_id;
	spinlock_t lock;
	struct binder_work work;
	union {
		struct rb_node rb_node;
		struct hlist_node dead_node;
	};
	struct binder_proc *proc;
	struct hlist_head refs;
	int internal_strong_refs;
	int local_weak_refs;
	int local_strong_refs;
	int tmp_refs;
	binder_uintptr_t ptr;
	binder_uintptr_t cookie;
	struct {
		u8 has_strong_ref: 1;
		u8 pending_strong_ref: 1;
		u8 has_weak_ref: 1;
		u8 pending_weak_ref: 1;
	};
	struct {
		u8 accept_fds: 1;
		u8 txn_security_ctx: 1;
		u8 min_priority;
	};
	bool has_async_transaction;
	struct list_head async_todo;
};

struct binder_node_debug_info {
	binder_uintptr_t ptr;
	binder_uintptr_t cookie;
	__u32 has_strong_ref;
	__u32 has_weak_ref;
};

struct binder_node_info_for_ref {
	__u32 handle;
	__u32 strong_count;
	__u32 weak_count;
	__u32 reserved1;
	__u32 reserved2;
	__u32 reserved3;
};

struct flat_binder_object {
	struct binder_object_header hdr;
	__u32 flags;
	union {
		binder_uintptr_t binder;
		__u32 handle;
	};
	binder_uintptr_t cookie;
};

struct binder_object {
	union {
		struct binder_object_header hdr;
		struct flat_binder_object fbo;
		struct binder_fd_object fdo;
		struct binder_buffer_object bbo;
		struct binder_fd_array_object fdao;
	};
};

struct dbitmap {
	unsigned int nbits;
	long unsigned int *map;
};

struct binder_stats {
	atomic_t br[23];
	atomic_t bc[22];
	atomic_t obj_created[8];
	atomic_t obj_deleted[8];
};

struct binder_proc {
	struct hlist_node proc_node;
	struct rb_root threads;
	struct rb_root nodes;
	struct rb_root refs_by_desc;
	struct rb_root refs_by_node;
	struct list_head waiting_threads;
	int pid;
	struct task_struct *tsk;
	const struct cred *cred;
	struct hlist_node deferred_work_node;
	int deferred_work;
	int outstanding_txns;
	bool is_dead;
	bool is_frozen;
	bool sync_recv;
	bool async_recv;
	wait_queue_head_t freeze_wait;
	struct dbitmap dmap;
	struct list_head todo;
	struct binder_stats stats;
	struct list_head delivered_death;
	struct list_head delivered_freeze;
	u32 max_threads;
	int requested_threads;
	int requested_threads_started;
	int tmp_ref;
	long int default_priority;
	struct dentry *debugfs_entry;
	struct binder_alloc alloc;
	struct binder_context *context;
	spinlock_t inner_lock;
	spinlock_t outer_lock;
	struct dentry *binderfs_entry;
	bool oneway_spam_detection_enabled;
};

struct binder_ptr_fixup {
	binder_size_t offset;
	size_t skip_size;
	binder_uintptr_t fixup_data;
	struct list_head node;
};

struct binder_ref_data {
	int debug_id;
	uint32_t desc;
	int strong;
	int weak;
};

struct binder_ref_death;

struct binder_ref_freeze;

struct binder_ref {
	struct binder_ref_data data;
	struct rb_node rb_node_desc;
	struct rb_node rb_node_node;
	struct hlist_node node_entry;
	struct binder_proc *proc;
	struct binder_node *node;
	struct binder_ref_death *death;
	struct binder_ref_freeze *freeze;
};

struct binder_ref_death {
	struct binder_work work;
	binder_uintptr_t cookie;
};

struct binder_ref_freeze {
	struct binder_work work;
	binder_uintptr_t cookie;
	bool is_frozen: 1;
	bool sent: 1;
	bool resend: 1;
};

struct binder_sg_copy {
	binder_size_t offset;
	const void *sender_uaddr;
	size_t length;
	struct list_head node;
};

struct binder_shrinker_mdata {
	struct list_head lru;
	struct binder_alloc *alloc;
	long unsigned int page_index;
};

struct binder_task_work_cb {
	struct callback_head twork;
	struct file *file;
};

struct binder_thread {
	struct binder_proc *proc;
	struct rb_node rb_node;
	struct list_head waiting_thread_node;
	int pid;
	int looper;
	bool looper_need_return;
	struct binder_transaction *transaction_stack;
	struct list_head todo;
	bool process_todo;
	struct binder_error return_error;
	struct binder_error reply_error;
	struct binder_extended_error ee;
	wait_queue_head_t wait;
	struct binder_stats stats;
	atomic_t tmp_ref;
	bool is_dead;
};

struct binder_transaction {
	int debug_id;
	struct binder_work work;
	struct binder_thread *from;
	pid_t from_pid;
	pid_t from_tid;
	struct binder_transaction *from_parent;
	struct binder_proc *to_proc;
	struct binder_thread *to_thread;
	struct binder_transaction *to_parent;
	unsigned int need_reply: 1;
	struct binder_buffer *buffer;
	unsigned int code;
	unsigned int flags;
	long int priority;
	long int saved_priority;
	kuid_t sender_euid;
	ktime_t start_time;
	struct list_head fd_fixups;
	binder_uintptr_t security_ctx;
	spinlock_t lock;
};

struct binder_transaction_data {
	union {
		__u32 handle;
		binder_uintptr_t ptr;
	} target;
	binder_uintptr_t cookie;
	__u32 code;
	__u32 flags;
	__kernel_pid_t sender_pid;
	__kernel_uid32_t sender_euid;
	binder_size_t data_size;
	binder_size_t offsets_size;
	union {
		struct {
			binder_uintptr_t buffer;
			binder_uintptr_t offsets;
		} ptr;
		__u8 buf[8];
	} data;
};

struct binder_transaction_data_secctx {
	struct binder_transaction_data transaction_data;
	binder_uintptr_t secctx;
};

struct binder_transaction_data_sg {
	struct binder_transaction_data transaction_data;
	binder_size_t buffers_size;
};

struct binder_transaction_log_entry {
	int debug_id;
	int debug_id_done;
	int call_type;
	int from_proc;
	int from_thread;
	int target_handle;
	int to_proc;
	int to_thread;
	int to_node;
	int data_size;
	int offsets_size;
	int return_error_line;
	uint32_t return_error;
	uint32_t return_error_param;
	char context_name[256];
};

struct binder_transaction_log {
	atomic_t cur;
	bool full;
	struct binder_transaction_log_entry entry[32];
};

struct binder_txn_fd_fixup {
	struct list_head fixup_entry;
	struct file *file;
	size_t offset;
	int target_fd;
};

struct binder_version {
	__s32 protocol_version;
};

struct binder_write_read {
	binder_size_t write_size;
	binder_size_t write_consumed;
	binder_uintptr_t write_buffer;
	binder_size_t read_size;
	binder_size_t read_consumed;
	binder_uintptr_t read_buffer;
};

struct binderfs_device {
	char name[256];
	__u32 major;
	__u32 minor;
};

struct binderfs_mount_opts {
	int max;
	int stats_mode;
};

struct ipc_namespace;

struct binderfs_info {
	struct ipc_namespace *ipc_ns;
	struct dentry *control_dentry;
	kuid_t root_uid;
	kgid_t root_gid;
	struct binderfs_mount_opts mount_opts;
	int device_count;
	struct dentry *proc_log_dir;
};

struct binfmt_misc {
	struct list_head entries;
	rwlock_t entries_lock;
	bool enabled;
};

struct bvec_iter {
	sector_t bi_sector;
	unsigned int bi_size;
	unsigned int bi_idx;
	unsigned int bi_bvec_done;
} __attribute__((packed));

struct bio;

typedef void bio_end_io_t(struct bio *);

struct bio_vec {
	struct page *bv_page;
	unsigned int bv_len;
	unsigned int bv_offset;
};

struct bio_crypt_ctx;

struct bio_integrity_payload;

struct bio_set;

struct bio {
	struct bio *bi_next;
	struct block_device *bi_bdev;
	blk_opf_t bi_opf;
	short unsigned int bi_flags;
	short unsigned int bi_ioprio;
	enum rw_hint bi_write_hint;
	u8 bi_write_stream;
	blk_status_t bi_status;
	atomic_t __bi_remaining;
	struct bvec_iter bi_iter;
	union {
		blk_qc_t bi_cookie;
		unsigned int __bi_nr_segments;
	};
	bio_end_io_t *bi_end_io;
	void *bi_private;
	struct blkcg_gq *bi_blkg;
	u64 issue_time_ns;
	u64 bi_iocost_cost;
	struct bio_crypt_ctx *bi_crypt_context;
	struct bio_integrity_payload *bi_integrity;
	short unsigned int bi_vcnt;
	short unsigned int bi_max_vecs;
	atomic_t __bi_cnt;
	struct bio_vec *bi_io_vec;
	struct bio_set *bi_pool;
	struct bio_vec bi_inline_vecs[0];
};

struct bio_alloc_cache {
	struct bio *free_list;
	struct bio *free_list_irq;
	unsigned int nr;
	unsigned int nr_irq;
};

struct blk_crypto_key;

struct bio_crypt_ctx {
	const struct blk_crypto_key *bc_key;
	u64 bc_dun[4];
};

struct bio_fallback_crypt_ctx {
	struct bio_crypt_ctx crypt_ctx;
	struct bvec_iter crypt_iter;
	union {
		struct {
			struct work_struct work;
			struct bio *bio;
		};
		struct {
			void *bi_private_orig;
			bio_end_io_t *bi_end_io_orig;
		};
	};
};

struct bio_integrity_payload {
	struct bvec_iter bip_iter;
	short unsigned int bip_vcnt;
	short unsigned int bip_max_vcnt;
	short unsigned int bip_flags;
	u16 app_tag;
	struct bio_vec *bip_vec;
};

struct bio_integrity_alloc {
	struct bio_integrity_payload bip;
	struct bio_vec bvecs[0];
};

struct bio_integrity_data {
	struct bio *bio;
	struct bvec_iter saved_bio_iter;
	struct work_struct work;
	struct bio_integrity_payload bip;
	struct bio_vec bvec;
};

struct bio_list {
	struct bio *head;
	struct bio *tail;
};

struct iovec {
	void *iov_base;
	__kernel_size_t iov_len;
};

struct kvec;

struct folio_queue;

struct iov_iter {
	u8 iter_type;
	bool nofault;
	bool data_source;
	size_t iov_offset;
	union {
		struct iovec __ubuf_iovec;
		struct {
			union {
				const struct iovec *__iov;
				const struct kvec *kvec;
				const struct bio_vec *bvec;
				const struct folio_queue *folioq;
				struct xarray *xarray;
				void *ubuf;
			};
			size_t count;
		};
	};
	union {
		long unsigned int nr_segs;
		u8 folioq_slot;
		loff_t xarray_start;
	};
};

struct bio_map_data {
	bool is_our_pages: 1;
	bool is_null_mapped: 1;
	struct iov_iter iter;
	struct iovec iov[0];
};

typedef void *mempool_alloc_t(gfp_t, void *);

typedef void mempool_free_t(void *, void *);

struct mempool_s {
	spinlock_t lock;
	int min_nr;
	int curr_nr;
	void **elements;
	void *pool_data;
	mempool_alloc_t *alloc;
	mempool_free_t *free;
	wait_queue_head_t wait;
};

typedef struct mempool_s mempool_t;

struct bio_set {
	struct kmem_cache *bio_slab;
	unsigned int front_pad;
	struct bio_alloc_cache *cache;
	mempool_t bio_pool;
	mempool_t bvec_pool;
	unsigned int back_pad;
	spinlock_t rescue_lock;
	struct bio_list rescue_list;
	struct work_struct rescue_work;
	struct workqueue_struct *rescue_workqueue;
	struct hlist_node cpuhp_dead;
};

struct bio_slab {
	struct kmem_cache *slab;
	unsigned int slab_ref;
	unsigned int slab_size;
	char name[12];
};

struct biovec_slab {
	int nr_vecs;
	char *name;
	struct kmem_cache *slab;
};

struct blacklist_entry {
	struct list_head next;
	char *buf;
};

struct blake2s_state {
	u32 h[8];
	u32 t[2];
	u32 f[2];
	u8 buf[64];
	unsigned int buflen;
	unsigned int outlen;
};

struct blk_crypto_profile;

struct blk_crypto_attr {
	struct attribute attr;
	ssize_t (*show)(struct blk_crypto_profile *, struct blk_crypto_attr *, char *);
};

struct blk_crypto_config {
	enum blk_crypto_mode_num crypto_mode;
	unsigned int data_unit_size;
	unsigned int dun_bytes;
	enum blk_crypto_key_type key_type;
};

struct crypto_skcipher;

struct blk_crypto_fallback_keyslot {
	enum blk_crypto_mode_num crypto_mode;
	struct crypto_skcipher *tfms[5];
};

struct blk_crypto_generate_key_arg {
	__u64 lt_key_ptr;
	__u64 lt_key_size;
	__u64 reserved[4];
};

struct blk_crypto_import_key_arg {
	__u64 raw_key_ptr;
	__u64 raw_key_size;
	__u64 lt_key_ptr;
	__u64 lt_key_size;
	__u64 reserved[4];
};

union blk_crypto_iv {
	__le64 dun[4];
	u8 bytes[32];
};

struct blk_crypto_key {
	struct blk_crypto_config crypto_cfg;
	unsigned int data_unit_size_bits;
	unsigned int size;
	u8 bytes[128];
};

struct blk_crypto_keyslot {
	atomic_t slot_refs;
	struct list_head idle_slot_node;
	struct hlist_node hash_node;
	const struct blk_crypto_key *key;
	struct blk_crypto_profile *profile;
};

struct blk_crypto_kobj {
	struct kobject kobj;
	struct blk_crypto_profile *profile;
};

struct blk_crypto_ll_ops {
	int (*keyslot_program)(struct blk_crypto_profile *, const struct blk_crypto_key *, unsigned int);
	int (*keyslot_evict)(struct blk_crypto_profile *, const struct blk_crypto_key *, unsigned int);
	int (*derive_sw_secret)(struct blk_crypto_profile *, const u8 *, size_t, u8 *);
	int (*import_key)(struct blk_crypto_profile *, const u8 *, size_t, u8 *);
	int (*generate_key)(struct blk_crypto_profile *, u8 *);
	int (*prepare_key)(struct blk_crypto_profile *, const u8 *, size_t, u8 *);
};

struct blk_crypto_mode {
	const char *name;
	const char *cipher_str;
	unsigned int keysize;
	unsigned int security_strength;
	unsigned int ivsize;
};

struct blk_crypto_prepare_key_arg {
	__u64 lt_key_ptr;
	__u64 lt_key_size;
	__u64 eph_key_ptr;
	__u64 eph_key_size;
	__u64 reserved[4];
};

struct blk_crypto_profile {
	struct blk_crypto_ll_ops ll_ops;
	unsigned int max_dun_bytes_supported;
	unsigned int key_types_supported;
	unsigned int modes_supported[5];
	struct device *dev;
	unsigned int num_slots;
	struct rw_semaphore lock;
	struct lock_class_key lockdep_key;
	wait_queue_head_t idle_slots_wait_queue;
	struct list_head idle_slots;
	spinlock_t idle_slots_lock;
	struct hlist_head *slot_hashtable;
	unsigned int log_slot_ht_size;
	struct blk_crypto_keyslot *slots;
};

struct req_iterator {
	struct bvec_iter iter;
	struct bio *bio;
};

struct dev_pagemap;

struct pci_p2pdma_map_state {
	struct dev_pagemap *pgmap;
	enum pci_p2pdma_map_type map;
	u64 bus_off;
};

struct blk_dma_iter {
	dma_addr_t addr;
	u32 len;
	blk_status_t status;
	struct req_iterator iter;
	struct pci_p2pdma_map_state p2pdma;
};

struct blk_expired_data {
	bool has_timedout_rq;
	long unsigned int next;
	long unsigned int timeout_start;
};

struct blk_flush_queue {
	spinlock_t mq_flush_lock;
	unsigned int flush_pending_idx: 1;
	unsigned int flush_running_idx: 1;
	blk_status_t rq_status;
	long unsigned int flush_pending_since;
	struct list_head flush_queue[2];
	long unsigned int flush_data_in_flight;
	struct request *flush_rq;
};

struct blk_holder_ops {
	void (*mark_dead)(struct block_device *, bool);
	void (*sync)(struct block_device *);
	int (*freeze)(struct block_device *);
	int (*thaw)(struct block_device *);
};

struct blk_ia_range_sysfs_entry {
	struct attribute attr;
	ssize_t (*show)(struct blk_independent_access_range *, char *);
};

struct blk_independent_access_ranges {
	struct kobject kobj;
	bool sysfs_registered;
	unsigned int nr_ia_ranges;
	struct blk_independent_access_range ia_range[0];
};

struct blk_integrity {
	unsigned char flags;
	enum blk_integrity_checksum csum_type;
	unsigned char metadata_size;
	unsigned char pi_offset;
	unsigned char interval_exp;
	unsigned char tag_size;
	unsigned char pi_tuple_size;
};

struct blk_integrity_iter {
	void *prot_buf;
	void *data_buf;
	sector_t seed;
	unsigned int data_size;
	short unsigned int interval;
	const char *disk_name;
};

struct blk_io_trace {
	__u32 magic;
	__u32 sequence;
	__u64 time;
	__u64 sector;
	__u32 bytes;
	__u32 action;
	__u32 pid;
	__u32 device;
	__u32 cpu;
	__u16 error;
	__u16 pdu_len;
};

struct blk_io_trace_remap {
	__be32 device_from;
	__be32 device_to;
	__be64 sector_from;
};

struct rq_qos_ops;

struct rq_qos {
	const struct rq_qos_ops *ops;
	struct gendisk *disk;
	enum rq_qos_id id;
	struct rq_qos *next;
	struct dentry *debugfs_dir;
};

struct blk_iolatency {
	struct rq_qos rqos;
	struct timer_list timer;
	bool enabled;
	atomic_t enable_cnt;
	struct work_struct enable_work;
};

struct blk_iou_cmd {
	int res;
	bool nowait;
};

struct blk_major_name {
	struct blk_major_name *next;
	int major;
	char name[16];
	void (*probe)(dev_t);
};

struct rq_list;

struct blk_mq_ctx;

struct blk_mq_hw_ctx;

struct blk_mq_alloc_data {
	struct request_queue *q;
	blk_mq_req_flags_t flags;
	unsigned int shallow_depth;
	blk_opf_t cmd_flags;
	req_flags_t rq_flags;
	unsigned int nr_tags;
	struct rq_list *cached_rqs;
	struct blk_mq_ctx *ctx;
	struct blk_mq_hw_ctx *hctx;
};

struct blk_mq_ctxs;

struct blk_mq_ctx {
	struct {
		spinlock_t lock;
		struct list_head rq_lists[3];
		long: 64;
	};
	unsigned int cpu;
	short unsigned int index_hw[3];
	struct blk_mq_hw_ctx *hctxs[3];
	struct request_queue *queue;
	struct blk_mq_ctxs *ctxs;
	struct kobject kobj;
	long: 64;
};

struct blk_mq_ctxs {
	struct kobject kobj;
	struct blk_mq_ctx *queue_ctx;
};

struct seq_operations;

struct blk_mq_debugfs_attr {
	const char *name;
	umode_t mode;
	int (*show)(void *, struct seq_file *);
	ssize_t (*write)(void *, const char *, size_t, loff_t *);
	const struct seq_operations *seq_ops;
};

struct sbitmap_word;

struct sbitmap {
	unsigned int depth;
	unsigned int shift;
	unsigned int map_nr;
	bool round_robin;
	struct sbitmap_word *map;
	unsigned int *alloc_hint;
};

typedef struct wait_queue_entry wait_queue_entry_t;

struct blk_mq_hw_ctx {
	struct {
		spinlock_t lock;
		struct list_head dispatch;
		long unsigned int state;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	};
	struct delayed_work run_work;
	cpumask_var_t cpumask;
	int next_cpu;
	int next_cpu_batch;
	long unsigned int flags;
	void *sched_data;
	struct request_queue *queue;
	struct blk_flush_queue *fq;
	void *driver_data;
	struct sbitmap ctx_map;
	struct blk_mq_ctx *dispatch_from;
	unsigned int dispatch_busy;
	short unsigned int type;
	short unsigned int nr_ctx;
	struct blk_mq_ctx **ctxs;
	spinlock_t dispatch_wait_lock;
	wait_queue_entry_t dispatch_wait;
	atomic_t wait_index;
	struct blk_mq_tags *tags;
	struct blk_mq_tags *sched_tags;
	unsigned int numa_node;
	unsigned int queue_num;
	atomic_t nr_active;
	struct hlist_node cpuhp_online;
	struct hlist_node cpuhp_dead;
	struct kobject kobj;
	struct dentry *debugfs_dir;
	struct dentry *sched_debugfs_dir;
	struct list_head hctx_list;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct blk_mq_hw_ctx_sysfs_entry {
	struct attribute attr;
	ssize_t (*show)(struct blk_mq_hw_ctx *, char *);
};

struct blk_mq_queue_data;

struct io_comp_batch;

struct blk_mq_ops {
	blk_status_t (*queue_rq)(struct blk_mq_hw_ctx *, const struct blk_mq_queue_data *);
	void (*commit_rqs)(struct blk_mq_hw_ctx *);
	void (*queue_rqs)(struct rq_list *);
	int (*get_budget)(struct request_queue *);
	void (*put_budget)(struct request_queue *, int);
	void (*set_rq_budget_token)(struct request *, int);
	int (*get_rq_budget_token)(struct request *);
	enum blk_eh_timer_return (*timeout)(struct request *);
	int (*poll)(struct blk_mq_hw_ctx *, struct io_comp_batch *);
	void (*complete)(struct request *);
	int (*init_hctx)(struct blk_mq_hw_ctx *, void *, unsigned int);
	void (*exit_hctx)(struct blk_mq_hw_ctx *, unsigned int);
	int (*init_request)(struct blk_mq_tag_set *, struct request *, unsigned int, unsigned int);
	void (*exit_request)(struct blk_mq_tag_set *, struct request *, unsigned int);
	void (*cleanup_rq)(struct request *);
	bool (*busy)(struct request_queue *);
	void (*map_queues)(struct blk_mq_tag_set *);
	void (*show_rq)(struct seq_file *, struct request *);
};

struct blk_mq_queue_data {
	struct request *rq;
	bool last;
};

struct sbq_wait_state;

struct sbitmap_queue {
	struct sbitmap sb;
	unsigned int wake_batch;
	atomic_t wake_index;
	struct sbq_wait_state *ws;
	atomic_t ws_active;
	unsigned int min_shallow_depth;
	atomic_t completion_cnt;
	atomic_t wakeup_cnt;
};

struct blk_mq_tags {
	unsigned int nr_tags;
	unsigned int nr_reserved_tags;
	unsigned int active_queues;
	struct sbitmap_queue bitmap_tags;
	struct sbitmap_queue breserved_tags;
	struct request **rqs;
	struct request **static_rqs;
	struct list_head page_list;
	spinlock_t lock;
};

struct rq_list {
	struct request *head;
	struct request *tail;
};

struct blk_plug {
	struct rq_list mq_list;
	struct rq_list cached_rqs;
	u64 cur_ktime;
	short unsigned int nr_ios;
	short unsigned int rq_count;
	bool multiple_queues;
	bool has_elevator;
	struct list_head cb_list;
};

struct blk_plug_cb;

typedef void (*blk_plug_cb_fn)(struct blk_plug_cb *, bool);

struct blk_plug_cb {
	struct list_head list;
	blk_plug_cb_fn callback;
	void *data;
};

struct blk_queue_stats {
	struct list_head callbacks;
	spinlock_t lock;
	int accounting;
};

struct blk_revalidate_zone_args {
	struct gendisk *disk;
	long unsigned int *conv_zones_bitmap;
	unsigned int nr_zones;
	unsigned int zone_capacity;
	unsigned int last_zone_capacity;
	sector_t sector;
};

struct blk_rq_stat {
	u64 mean;
	u64 min;
	u64 max;
	u32 nr_samples;
	u64 batch;
};

struct blk_rq_wait {
	struct completion done;
	blk_status_t ret;
};

struct blk_stat_callback {
	struct list_head list;
	struct timer_list timer;
	struct blk_rq_stat *cpu_stat;
	int (*bucket_fn)(const struct request *);
	unsigned int buckets;
	struct blk_rq_stat *stat;
	void (*timer_fn)(struct blk_stat_callback *);
	void *data;
	struct callback_head rcu;
};

struct rchan;

struct blk_trace {
	int trace_state;
	struct rchan *rchan;
	long unsigned int *sequence;
	unsigned char *msg_data;
	u16 act_mask;
	u64 start_lba;
	u64 end_lba;
	u32 pid;
	u32 dev;
	struct dentry *dir;
	struct list_head running_list;
	atomic_t dropped;
};

struct blk_user_trace_setup {
	char name[32];
	__u16 act_mask;
	__u32 buf_size;
	__u32 buf_nr;
	__u64 start_lba;
	__u64 end_lba;
	__u32 pid;
};

struct blk_zone {
	__u64 start;
	__u64 len;
	__u64 wp;
	__u8 type;
	__u8 cond;
	__u8 non_seq;
	__u8 reset;
	__u8 resv[4];
	__u64 capacity;
	__u8 reserved[24];
};

struct blk_zone_range {
	__u64 sector;
	__u64 nr_sectors;
};

struct blk_zone_report {
	__u64 sector;
	__u32 nr_zones;
	__u32 flags;
	struct blk_zone zones[0];
};

struct blk_zone_wplug {
	struct hlist_node node;
	refcount_t ref;
	spinlock_t lock;
	unsigned int flags;
	unsigned int zone_no;
	unsigned int wp_offset;
	struct bio_list bio_list;
	struct work_struct bio_work;
	struct callback_head callback_head;
	struct gendisk *disk;
};

struct cgroup_subsys;

struct css_rstat_cpu;

struct cgroup_subsys_state {
	struct cgroup *cgroup;
	struct cgroup_subsys *ss;
	struct percpu_ref refcnt;
	struct css_rstat_cpu *rstat_cpu;
	struct list_head sibling;
	struct list_head children;
	int id;
	unsigned int flags;
	u64 serial_nr;
	atomic_t online_cnt;
	struct work_struct destroy_work;
	struct rcu_work destroy_rwork;
	struct cgroup_subsys_state *parent;
	int nr_descendants;
	struct cgroup_subsys_state *rstat_flush_next;
};

struct blkcg {
	struct cgroup_subsys_state css;
	spinlock_t lock;
	refcount_t online_pin;
	atomic_t congestion_count;
	struct xarray blkg_tree;
	struct blkcg_gq *blkg_hint;
	struct hlist_head blkg_list;
	struct blkcg_policy_data *cpd[6];
	struct list_head all_blkcgs_node;
	struct llist_head *lhead;
	char fc_app_id[129];
	struct list_head cgwb_list;
};

struct blkg_iostat {
	u64 bytes[3];
	u64 ios[3];
};

struct blkg_iostat_set {
	struct u64_stats_sync sync;
	struct blkcg_gq *blkg;
	struct llist_node lnode;
	int lqueued;
	struct blkg_iostat cur;
	struct blkg_iostat last;
};

struct blkcg_gq {
	struct request_queue *q;
	struct list_head q_node;
	struct hlist_node blkcg_node;
	struct blkcg *blkcg;
	struct blkcg_gq *parent;
	struct percpu_ref refcnt;
	bool online;
	struct blkg_iostat_set *iostat_cpu;
	struct blkg_iostat_set iostat;
	struct blkg_policy_data *pd[6];
	spinlock_t async_bio_lock;
	struct bio_list async_bios;
	union {
		struct work_struct async_bio_work;
		struct work_struct free_work;
	};
	atomic_t use_delay;
	atomic64_t delay_nsec;
	atomic64_t delay_start;
	u64 last_delay;
	int last_use;
	struct callback_head callback_head;
};

typedef struct blkcg_policy_data *blkcg_pol_alloc_cpd_fn(gfp_t);

typedef void blkcg_pol_free_cpd_fn(struct blkcg_policy_data *);

typedef struct blkg_policy_data *blkcg_pol_alloc_pd_fn(struct gendisk *, struct blkcg *, gfp_t);

typedef void blkcg_pol_init_pd_fn(struct blkg_policy_data *);

typedef void blkcg_pol_online_pd_fn(struct blkg_policy_data *);

typedef void blkcg_pol_offline_pd_fn(struct blkg_policy_data *);

typedef void blkcg_pol_free_pd_fn(struct blkg_policy_data *);

typedef void blkcg_pol_reset_pd_stats_fn(struct blkg_policy_data *);

typedef void blkcg_pol_stat_pd_fn(struct blkg_policy_data *, struct seq_file *);

struct cftype;

struct blkcg_policy {
	int plid;
	struct cftype *dfl_cftypes;
	struct cftype *legacy_cftypes;
	blkcg_pol_alloc_cpd_fn *cpd_alloc_fn;
	blkcg_pol_free_cpd_fn *cpd_free_fn;
	blkcg_pol_alloc_pd_fn *pd_alloc_fn;
	blkcg_pol_init_pd_fn *pd_init_fn;
	blkcg_pol_online_pd_fn *pd_online_fn;
	blkcg_pol_offline_pd_fn *pd_offline_fn;
	blkcg_pol_free_pd_fn *pd_free_fn;
	blkcg_pol_reset_pd_stats_fn *pd_reset_stats_fn;
	blkcg_pol_stat_pd_fn *pd_stat_fn;
};

struct blkdev_dio {
	union {
		struct kiocb *iocb;
		struct task_struct *waiter;
	};
	size_t size;
	atomic_t ref;
	unsigned int flags;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct bio bio;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct blkg_conf_ctx {
	char *input;
	char *body;
	struct block_device *bdev;
	struct blkcg_gq *blkg;
};

struct blkg_rwstat_sample {
	u64 cnt[5];
};

struct blkpg_ioctl_arg {
	int op;
	int flags;
	int datalen;
	void *data;
};

struct blkpg_partition {
	long long int start;
	long long int length;
	int pno;
	char devname[64];
	char volname[64];
};

struct block_buffer {
	u32 filled;
	bool is_root_hash;
	u8 *data;
};

typedef int (*report_zones_cb)(struct blk_zone *, unsigned int, void *);

struct hd_geometry;

struct pr_ops;

struct block_device_operations {
	void (*submit_bio)(struct bio *);
	int (*poll_bio)(struct bio *, struct io_comp_batch *, unsigned int);
	int (*open)(struct gendisk *, blk_mode_t);
	void (*release)(struct gendisk *);
	int (*ioctl)(struct block_device *, blk_mode_t, unsigned int, long unsigned int);
	int (*compat_ioctl)(struct block_device *, blk_mode_t, unsigned int, long unsigned int);
	unsigned int (*check_events)(struct gendisk *, unsigned int);
	void (*unlock_native_capacity)(struct gendisk *);
	int (*getgeo)(struct block_device *, struct hd_geometry *);
	int (*set_read_only)(struct block_device *, bool);
	void (*free_disk)(struct gendisk *);
	void (*swap_slot_free_notify)(struct block_device *, long unsigned int);
	int (*report_zones)(struct gendisk *, sector_t, unsigned int, report_zones_cb, void *);
	char * (*devnode)(struct gendisk *, umode_t *);
	int (*get_unique_id)(struct gendisk *, u8 *, enum blk_unique_id);
	struct module *owner;
	const struct pr_ops *pr_ops;
	int (*alternative_gpt_sector)(struct gendisk *, sector_t *);
};

struct mem_zone_bm_rtree;

struct rtree_node;

struct bm_position {
	struct mem_zone_bm_rtree *zone;
	struct rtree_node *node;
	long unsigned int node_pfn;
	long unsigned int cur_pfn;
	int node_bit;
};

struct bmp_dib_header {
	u32 dib_header_size;
	s32 width;
	s32 height;
	u16 planes;
	u16 bpp;
	u32 compression;
	u32 bitmap_size;
	u32 horz_resolution;
	u32 vert_resolution;
	u32 colors_used;
	u32 colors_important;
};

struct bmp_file_header {
	u16 id;
	u32 file_size;
	u32 reserved;
	u32 bitmap_offset;
} __attribute__((packed));

struct bmp_header {
	u16 id;
	u32 size;
} __attribute__((packed));

struct spi_board_info {
	char modalias[32];
	const void *platform_data;
	const struct software_node *swnode;
	void *controller_data;
	int irq;
	u32 max_speed_hz;
	u16 bus_num;
	u16 chip_select;
	u32 mode;
};

struct boardinfo {
	struct list_head list;
	struct spi_board_info board_info;
};

struct boot_e820_entry {
	__u64 addr;
	__u64 size;
	__u32 type;
} __attribute__((packed));

struct screen_info {
	__u8 orig_x;
	__u8 orig_y;
	__u16 ext_mem_k;
	__u16 orig_video_page;
	__u8 orig_video_mode;
	__u8 orig_video_cols;
	__u8 flags;
	__u8 unused2;
	__u16 orig_video_ega_bx;
	__u16 unused3;
	__u8 orig_video_lines;
	__u8 orig_video_isVGA;
	__u16 orig_video_points;
	__u16 lfb_width;
	__u16 lfb_height;
	__u16 lfb_depth;
	__u32 lfb_base;
	__u32 lfb_size;
	__u16 cl_magic;
	__u16 cl_offset;
	__u16 lfb_linelength;
	__u8 red_size;
	__u8 red_pos;
	__u8 green_size;
	__u8 green_pos;
	__u8 blue_size;
	__u8 blue_pos;
	__u8 rsvd_size;
	__u8 rsvd_pos;
	__u16 vesapm_seg;
	__u16 vesapm_off;
	__u16 pages;
	__u16 vesa_attributes;
	__u32 capabilities;
	__u32 ext_lfb_base;
	__u8 _reserved[2];
} __attribute__((packed));

struct ist_info {
	__u32 signature;
	__u32 command;
	__u32 event;
	__u32 perf_level;
};

struct sys_desc_table {
	__u16 length;
	__u8 table[14];
};

struct olpc_ofw_header {
	__u32 ofw_magic;
	__u32 ofw_version;
	__u32 cif_handler;
	__u32 irq_desc_table;
};

struct edid_info {
	unsigned char dummy[128];
};

struct efi_info {
	__u32 efi_loader_signature;
	__u32 efi_systab;
	__u32 efi_memdesc_size;
	__u32 efi_memdesc_version;
	__u32 efi_memmap;
	__u32 efi_memmap_size;
	__u32 efi_systab_hi;
	__u32 efi_memmap_hi;
};

struct setup_header {
	__u8 setup_sects;
	__u16 root_flags;
	__u32 syssize;
	__u16 ram_size;
	__u16 vid_mode;
	__u16 root_dev;
	__u16 boot_flag;
	__u16 jump;
	__u32 header;
	__u16 version;
	__u32 realmode_swtch;
	__u16 start_sys_seg;
	__u16 kernel_version;
	__u8 type_of_loader;
	__u8 loadflags;
	__u16 setup_move_size;
	__u32 code32_start;
	__u32 ramdisk_image;
	__u32 ramdisk_size;
	__u32 bootsect_kludge;
	__u16 heap_end_ptr;
	__u8 ext_loader_ver;
	__u8 ext_loader_type;
	__u32 cmd_line_ptr;
	__u32 initrd_addr_max;
	__u32 kernel_alignment;
	__u8 relocatable_kernel;
	__u8 min_alignment;
	__u16 xloadflags;
	__u32 cmdline_size;
	__u32 hardware_subarch;
	__u64 hardware_subarch_data;
	__u32 payload_offset;
	__u32 payload_length;
	__u64 setup_data;
	__u64 pref_address;
	__u32 init_size;
	__u32 handover_offset;
	__u32 kernel_info_offset;
} __attribute__((packed));

struct edd_device_params {
	__u16 length;
	__u16 info_flags;
	__u32 num_default_cylinders;
	__u32 num_default_heads;
	__u32 sectors_per_track;
	__u64 number_of_sectors;
	__u16 bytes_per_sector;
	__u32 dpte_ptr;
	__u16 key;
	__u8 device_path_info_length;
	__u8 reserved2;
	__u16 reserved3;
	__u8 host_bus_type[4];
	__u8 interface_type[8];
	union {
		struct {
			__u16 base_address;
			__u16 reserved1;
			__u32 reserved2;
		} isa;
		struct {
			__u8 bus;
			__u8 slot;
			__u8 function;
			__u8 channel;
			__u32 reserved;
		} pci;
		struct {
			__u64 reserved;
		} ibnd;
		struct {
			__u64 reserved;
		} xprs;
		struct {
			__u64 reserved;
		} htpt;
		struct {
			__u64 reserved;
		} unknown;
	} interface_path;
	union {
		struct {
			__u8 device;
			__u8 reserved1;
			__u16 reserved2;
			__u32 reserved3;
			__u64 reserved4;
		} ata;
		struct {
			__u8 device;
			__u8 lun;
			__u8 reserved1;
			__u8 reserved2;
			__u32 reserved3;
			__u64 reserved4;
		} atapi;
		struct {
			__u16 id;
			__u64 lun;
			__u16 reserved1;
			__u32 reserved2;
		} __attribute__((packed)) scsi;
		struct {
			__u64 serial_number;
			__u64 reserved;
		} usb;
		struct {
			__u64 eui;
			__u64 reserved;
		} i1394;
		struct {
			__u64 wwid;
			__u64 lun;
		} fibre;
		struct {
			__u64 identity_tag;
			__u64 reserved;
		} i2o;
		struct {
			__u32 array_number;
			__u32 reserved1;
			__u64 reserved2;
		} raid;
		struct {
			__u8 device;
			__u8 reserved1;
			__u16 reserved2;
			__u32 reserved3;
			__u64 reserved4;
		} sata;
		struct {
			__u64 reserved1;
			__u64 reserved2;
		} unknown;
	} device_path;
	__u8 reserved4;
	__u8 checksum;
} __attribute__((packed));

struct edd_info {
	__u8 device;
	__u8 version;
	__u16 interface_support;
	__u16 legacy_max_cylinder;
	__u8 legacy_max_head;
	__u8 legacy_sectors_per_track;
	struct edd_device_params params;
};

struct boot_params {
	struct screen_info screen_info;
	struct apm_bios_info apm_bios_info;
	__u8 _pad2[4];
	__u64 tboot_addr;
	struct ist_info ist_info;
	__u64 acpi_rsdp_addr;
	__u8 _pad3[8];
	__u8 hd0_info[16];
	__u8 hd1_info[16];
	struct sys_desc_table sys_desc_table;
	struct olpc_ofw_header olpc_ofw_header;
	__u32 ext_ramdisk_image;
	__u32 ext_ramdisk_size;
	__u32 ext_cmd_line_ptr;
	__u8 _pad4[112];
	__u32 cc_blob_address;
	struct edid_info edid_info;
	struct efi_info efi_info;
	__u32 alt_mem_k;
	__u32 scratch;
	__u8 e820_entries;
	__u8 eddbuf_entries;
	__u8 edd_mbr_sig_buf_entries;
	__u8 kbd_status;
	__u8 secure_boot;
	__u8 _pad5[2];
	__u8 sentinel;
	__u8 _pad6[1];
	struct setup_header hdr;
	__u8 _pad7[36];
	__u32 edd_mbr_sig_buffer[16];
	struct boot_e820_entry e820_table[128];
	__u8 _pad8[48];
	struct edd_info eddbuf[6];
	__u8 _pad9[276];
};

struct boot_params_to_save {
	unsigned int start;
	unsigned int len;
};

struct fpdt_record_header {
	u16 type;
	u8 length;
	u8 revision;
};

struct boot_performance_record {
	struct fpdt_record_header header;
	u32 reserved;
	u64 firmware_start;
	u64 bootloader_load;
	u64 bootloader_launch;
	u64 exitbootservice_start;
	u64 exitbootservice_end;
};

struct boot_triggers {
	const char *event;
	char *trigger;
};

struct bp_slots_histogram {
	atomic_t count[4];
};

struct bp_cpuinfo {
	unsigned int cpu_pinned;
	struct bp_slots_histogram tsk_pinned;
};

struct bpf_map_ops;

struct btf_record;

struct btf;

struct obj_cgroup;

struct bpf_map_owner;

struct bpf_map {
	const struct bpf_map_ops *ops;
	struct bpf_map *inner_map_meta;
	void *security;
	enum bpf_map_type map_type;
	u32 key_size;
	u32 value_size;
	u32 max_entries;
	u64 map_extra;
	u32 map_flags;
	u32 id;
	struct btf_record *record;
	int numa_node;
	u32 btf_key_type_id;
	u32 btf_value_type_id;
	u32 btf_vmlinux_value_type_id;
	struct btf *btf;
	struct obj_cgroup *objcg;
	char name[16];
	struct mutex freeze_mutex;
	atomic64_t refcnt;
	atomic64_t usercnt;
	union {
		struct work_struct work;
		struct callback_head rcu;
	};
	atomic64_t writecnt;
	spinlock_t owner_lock;
	struct bpf_map_owner *owner;
	bool bypass_spec_v1;
	bool frozen;
	bool free_after_mult_rcu_gp;
	bool free_after_rcu_gp;
	atomic64_t sleepable_refcnt;
	s64 *elem_count;
	u64 cookie;
};

struct range_tree {
	struct rb_root_cached it_root;
	struct rb_root_cached range_size_root;
};

struct vm_struct;

struct bpf_arena {
	struct bpf_map map;
	u64 user_vm_start;
	u64 user_vm_end;
	struct vm_struct *kern_vm;
	struct range_tree rt;
	struct list_head vma_list;
	struct mutex lock;
};

struct bpf_array_aux;

struct bpf_array {
	struct bpf_map map;
	u32 elem_size;
	u32 index_mask;
	struct bpf_array_aux *aux;
	union {
		struct {
			struct {} __empty_value;
			char value[0];
		};
		struct {
			struct {} __empty_ptrs;
			void *ptrs[0];
		};
		struct {
			struct {} __empty_pptrs;
			void *pptrs[0];
		};
	};
};

struct bpf_array_aux {
	struct list_head poke_progs;
	struct bpf_map *map;
	struct mutex poke_mutex;
	struct work_struct work;
};

struct bpf_prog;

struct bpf_async_cb {
	struct bpf_map *map;
	struct bpf_prog *prog;
	void *callback_fn;
	void *value;
	union {
		struct callback_head rcu;
		struct work_struct delete_work;
	};
	u64 flags;
};

struct bpf_spin_lock {
	__u32 val;
};

struct bpf_hrtimer;

struct bpf_work;

struct bpf_async_kern {
	union {
		struct bpf_async_cb *cb;
		struct bpf_hrtimer *timer;
		struct bpf_work *work;
	};
	struct bpf_spin_lock lock;
};

struct btf_func_model {
	u8 ret_size;
	u8 ret_flags;
	u8 nr_args;
	u8 arg_size[12];
	u8 arg_flags[12];
};

struct btf_type;

struct bpf_attach_target_info {
	struct btf_func_model fmodel;
	long int tgt_addr;
	struct module *tgt_mod;
	const char *tgt_name;
	const struct btf_type *tgt_type;
};

union bpf_attr {
	struct {
		__u32 map_type;
		__u32 key_size;
		__u32 value_size;
		__u32 max_entries;
		__u32 map_flags;
		__u32 inner_map_fd;
		__u32 numa_node;
		char map_name[16];
		__u32 map_ifindex;
		__u32 btf_fd;
		__u32 btf_key_type_id;
		__u32 btf_value_type_id;
		__u32 btf_vmlinux_value_type_id;
		__u64 map_extra;
		__s32 value_type_btf_obj_fd;
		__s32 map_token_fd;
	};
	struct {
		__u32 map_fd;
		__u64 key;
		union {
			__u64 value;
			__u64 next_key;
		};
		__u64 flags;
	};
	struct {
		__u64 in_batch;
		__u64 out_batch;
		__u64 keys;
		__u64 values;
		__u32 count;
		__u32 map_fd;
		__u64 elem_flags;
		__u64 flags;
	} batch;
	struct {
		__u32 prog_type;
		__u32 insn_cnt;
		__u64 insns;
		__u64 license;
		__u32 log_level;
		__u32 log_size;
		__u64 log_buf;
		__u32 kern_version;
		__u32 prog_flags;
		char prog_name[16];
		__u32 prog_ifindex;
		__u32 expected_attach_type;
		__u32 prog_btf_fd;
		__u32 func_info_rec_size;
		__u64 func_info;
		__u32 func_info_cnt;
		__u32 line_info_rec_size;
		__u64 line_info;
		__u32 line_info_cnt;
		__u32 attach_btf_id;
		union {
			__u32 attach_prog_fd;
			__u32 attach_btf_obj_fd;
		};
		__u32 core_relo_cnt;
		__u64 fd_array;
		__u64 core_relos;
		__u32 core_relo_rec_size;
		__u32 log_true_size;
		__s32 prog_token_fd;
		__u32 fd_array_cnt;
	};
	struct {
		__u64 pathname;
		__u32 bpf_fd;
		__u32 file_flags;
		__s32 path_fd;
	};
	struct {
		union {
			__u32 target_fd;
			__u32 target_ifindex;
		};
		__u32 attach_bpf_fd;
		__u32 attach_type;
		__u32 attach_flags;
		__u32 replace_bpf_fd;
		union {
			__u32 relative_fd;
			__u32 relative_id;
		};
		__u64 expected_revision;
	};
	struct {
		__u32 prog_fd;
		__u32 retval;
		__u32 data_size_in;
		__u32 data_size_out;
		__u64 data_in;
		__u64 data_out;
		__u32 repeat;
		__u32 duration;
		__u32 ctx_size_in;
		__u32 ctx_size_out;
		__u64 ctx_in;
		__u64 ctx_out;
		__u32 flags;
		__u32 cpu;
		__u32 batch_size;
	} test;
	struct {
		union {
			__u32 start_id;
			__u32 prog_id;
			__u32 map_id;
			__u32 btf_id;
			__u32 link_id;
		};
		__u32 next_id;
		__u32 open_flags;
		__s32 fd_by_id_token_fd;
	};
	struct {
		__u32 bpf_fd;
		__u32 info_len;
		__u64 info;
	} info;
	struct {
		union {
			__u32 target_fd;
			__u32 target_ifindex;
		};
		__u32 attach_type;
		__u32 query_flags;
		__u32 attach_flags;
		__u64 prog_ids;
		union {
			__u32 prog_cnt;
			__u32 count;
		};
		__u64 prog_attach_flags;
		__u64 link_ids;
		__u64 link_attach_flags;
		__u64 revision;
	} query;
	struct {
		__u64 name;
		__u32 prog_fd;
		__u64 cookie;
	} raw_tracepoint;
	struct {
		__u64 btf;
		__u64 btf_log_buf;
		__u32 btf_size;
		__u32 btf_log_size;
		__u32 btf_log_level;
		__u32 btf_log_true_size;
		__u32 btf_flags;
		__s32 btf_token_fd;
	};
	struct {
		__u32 pid;
		__u32 fd;
		__u32 flags;
		__u32 buf_len;
		__u64 buf;
		__u32 prog_id;
		__u32 fd_type;
		__u64 probe_offset;
		__u64 probe_addr;
	} task_fd_query;
	struct {
		union {
			__u32 prog_fd;
			__u32 map_fd;
		};
		union {
			__u32 target_fd;
			__u32 target_ifindex;
		};
		__u32 attach_type;
		__u32 flags;
		union {
			__u32 target_btf_id;
			struct {
				__u64 iter_info;
				__u32 iter_info_len;
			};
			struct {
				__u64 bpf_cookie;
			} perf_event;
			struct {
				__u32 flags;
				__u32 cnt;
				__u64 syms;
				__u64 addrs;
				__u64 cookies;
			} kprobe_multi;
			struct {
				__u32 target_btf_id;
				__u64 cookie;
			} tracing;
			struct {
				__u32 pf;
				__u32 hooknum;
				__s32 priority;
				__u32 flags;
			} netfilter;
			struct {
				union {
					__u32 relative_fd;
					__u32 relative_id;
				};
				__u64 expected_revision;
			} tcx;
			struct {
				__u64 path;
				__u64 offsets;
				__u64 ref_ctr_offsets;
				__u64 cookies;
				__u32 cnt;
				__u32 flags;
				__u32 pid;
			} uprobe_multi;
			struct {
				union {
					__u32 relative_fd;
					__u32 relative_id;
				};
				__u64 expected_revision;
			} netkit;
			struct {
				union {
					__u32 relative_fd;
					__u32 relative_id;
				};
				__u64 expected_revision;
			} cgroup;
		};
	} link_create;
	struct {
		__u32 link_fd;
		union {
			__u32 new_prog_fd;
			__u32 new_map_fd;
		};
		__u32 flags;
		union {
			__u32 old_prog_fd;
			__u32 old_map_fd;
		};
	} link_update;
	struct {
		__u32 link_fd;
	} link_detach;
	struct {
		__u32 type;
	} enable_stats;
	struct {
		__u32 link_fd;
		__u32 flags;
	} iter_create;
	struct {
		__u32 prog_fd;
		__u32 map_fd;
		__u32 flags;
	} prog_bind_map;
	struct {
		__u32 flags;
		__u32 bpffs_fd;
	} token_create;
	struct {
		__u64 stream_buf;
		__u32 stream_buf_len;
		__u32 stream_id;
		__u32 prog_fd;
	} prog_stream_read;
};

struct bpf_binary_header {
	u32 size;
	long: 0;
	u8 image[0];
};

struct bpf_bloom_filter {
	struct bpf_map map;
	u32 bitset_mask;
	u32 hash_seed;
	u32 nr_hash_funcs;
	long unsigned int bitset[0];
};

struct bpf_bprintf_buffers {
	char bin_args[512];
	char buf[1024];
};

struct bpf_bprintf_data {
	u32 *bin_args;
	char *buf;
	bool get_bin_args;
	bool get_buf;
};

struct bpf_btf_info {
	__u64 btf;
	__u32 btf_size;
	__u32 id;
	__u64 name;
	__u32 name_len;
	__u32 kernel_btf;
};

struct btf_field;

struct bpf_call_arg_meta {
	struct bpf_map *map_ptr;
	bool raw_mode;
	bool pkt_access;
	u8 release_regno;
	int regno;
	int access_size;
	int mem_size;
	u64 msize_max_value;
	int ref_obj_id;
	int dynptr_id;
	int map_uid;
	int func_id;
	struct btf *btf;
	u32 btf_id;
	struct btf *ret_btf;
	u32 ret_btf_id;
	u32 subprogno;
	struct btf_field *kptr_field;
	s64 const_map_key;
};

struct bpf_cand_cache {
	const char *name;
	u32 name_len;
	u16 kind;
	u16 cnt;
	struct {
		const struct btf *btf;
		u32 id;
	} cands[0];
};

struct bpf_run_ctx {};

struct bpf_prog_array_item;

struct bpf_cg_run_ctx {
	struct bpf_run_ctx run_ctx;
	const struct bpf_prog_array_item *prog_item;
	int retval;
};

struct bpf_cgroup_dev_ctx {
	__u32 access_type;
	__u32 major;
	__u32 minor;
};

struct bpf_link_ops;

struct bpf_link {
	atomic64_t refcnt;
	u32 id;
	enum bpf_link_type type;
	const struct bpf_link_ops *ops;
	struct bpf_prog *prog;
	u32 flags;
	enum bpf_attach_type attach_type;
	union {
		struct callback_head rcu;
		struct work_struct work;
	};
	bool sleepable;
};

struct bpf_cgroup_link {
	struct bpf_link link;
	struct cgroup *cgroup;
};

struct bpf_cgroup_storage_key {
	__u64 cgroup_inode_id;
	__u32 attach_type;
};

struct bpf_storage_buffer;

struct bpf_cgroup_storage_map;

struct bpf_cgroup_storage {
	union {
		struct bpf_storage_buffer *buf;
		void *percpu_buf;
	};
	struct bpf_cgroup_storage_map *map;
	struct bpf_cgroup_storage_key key;
	struct list_head list_map;
	struct list_head list_cg;
	struct rb_node node;
	struct callback_head rcu;
};

struct bpf_cgroup_storage_map {
	struct bpf_map map;
	spinlock_t lock;
	struct rb_root root;
	struct list_head list;
};

struct bpf_lru_list {
	struct list_head lists[3];
	unsigned int counts[2];
	struct list_head *next_inactive_rotation;
	raw_spinlock_t lock;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct bpf_lru_locallist;

struct bpf_common_lru {
	struct bpf_lru_list lru_list;
	struct bpf_lru_locallist *local_list;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct bpf_core_accessor {
	__u32 type_id;
	__u32 idx;
	const char *name;
};

struct bpf_core_cand {
	const struct btf *btf;
	__u32 id;
};

struct bpf_core_cand_list {
	struct bpf_core_cand *cands;
	int len;
};

struct bpf_verifier_log;

struct bpf_core_ctx {
	struct bpf_verifier_log *log;
	const struct btf *btf;
};

struct bpf_core_relo {
	__u32 insn_off;
	__u32 type_id;
	__u32 access_str_off;
	enum bpf_core_relo_kind kind;
};

struct bpf_core_relo_res {
	__u64 orig_val;
	__u64 new_val;
	bool poison;
	bool validate;
	bool fail_memsz_adjust;
	__u32 orig_sz;
	__u32 orig_type_id;
	__u32 new_sz;
	__u32 new_type_id;
};

struct bpf_core_spec {
	const struct btf *btf;
	struct bpf_core_accessor spec[64];
	__u32 root_type_id;
	enum bpf_core_relo_kind relo_kind;
	int len;
	int raw_spec[64];
	int raw_len;
	__u32 bit_offset;
};

struct bpf_cpu_map_entry;

struct bpf_cpu_map {
	struct bpf_map map;
	struct bpf_cpu_map_entry **cpu_map;
};

struct bpf_cpumap_val {
	__u32 qsize;
	union {
		int fd;
		__u32 id;
	} bpf_prog;
};

struct gro_list {
	struct list_head list;
	int count;
};

struct gro_node {
	long unsigned int bitmask;
	struct gro_list hash[8];
	struct list_head rx_list;
	u32 rx_count;
	u32 cached_napi_id;
};

struct xdp_bulk_queue;

struct ptr_ring;

struct bpf_cpu_map_entry {
	u32 cpu;
	int map_id;
	struct xdp_bulk_queue *bulkq;
	struct ptr_ring *queue;
	struct task_struct *kthread;
	struct bpf_cpumap_val value;
	struct bpf_prog *prog;
	struct gro_node gro;
	struct completion kthread_running;
	struct rcu_work free_work;
};

typedef struct cpumask cpumask_t;

struct bpf_cpumask {
	cpumask_t cpumask;
	refcount_t usage;
};

struct bpf_crypto_type;

struct bpf_crypto_ctx {
	const struct bpf_crypto_type *type;
	void *tfm;
	u32 siv_len;
	struct callback_head rcu;
	refcount_t usage;
};

struct bpf_crypto_params {
	char type[14];
	u8 reserved[2];
	char algo[128];
	u8 key[256];
	u32 key_len;
	u32 authsize;
};

struct bpf_crypto_type {
	void * (*alloc_tfm)(const char *);
	void (*free_tfm)(void *);
	int (*has_algo)(const char *);
	int (*setkey)(void *, const u8 *, unsigned int);
	int (*setauthsize)(void *, unsigned int);
	int (*encrypt)(void *, const u8 *, u8 *, unsigned int, u8 *);
	int (*decrypt)(void *, const u8 *, u8 *, unsigned int, u8 *);
	unsigned int (*ivsize)(void *);
	unsigned int (*statesize)(void *);
	u32 (*get_flags)(void *);
	struct module *owner;
	char name[14];
};

struct bpf_crypto_type_list {
	const struct bpf_crypto_type *type;
	struct list_head list;
};

struct bpf_ctx_arg_aux {
	u32 offset;
	enum bpf_reg_type reg_type;
	struct btf *btf;
	u32 btf_id;
	u32 ref_obj_id;
	bool refcounted;
};

struct skb_ext;

struct sk_buff {
	union {
		struct {
			struct sk_buff *next;
			struct sk_buff *prev;
			union {
				struct net_device *dev;
				long unsigned int dev_scratch;
			};
		};
		struct rb_node rbnode;
		struct list_head list;
		struct llist_node ll_node;
	};
	struct sock *sk;
	union {
		ktime_t tstamp;
		u64 skb_mstamp_ns;
	};
	char cb[48];
	union {
		struct {
			long unsigned int _skb_refdst;
			void (*destructor)(struct sk_buff *);
		};
		struct list_head tcp_tsorted_anchor;
		long unsigned int _sk_redir;
	};
	long unsigned int _nfct;
	unsigned int len;
	unsigned int data_len;
	__u16 mac_len;
	__u16 hdr_len;
	__u16 queue_mapping;
	__u8 __cloned_offset[0];
	__u8 cloned: 1;
	__u8 nohdr: 1;
	__u8 fclone: 2;
	__u8 peeked: 1;
	__u8 head_frag: 1;
	__u8 pfmemalloc: 1;
	__u8 pp_recycle: 1;
	__u8 active_extensions;
	union {
		struct {
			__u8 __pkt_type_offset[0];
			__u8 pkt_type: 3;
			__u8 ignore_df: 1;
			__u8 dst_pending_confirm: 1;
			__u8 ip_summed: 2;
			__u8 ooo_okay: 1;
			__u8 __mono_tc_offset[0];
			__u8 tstamp_type: 2;
			__u8 tc_at_ingress: 1;
			__u8 tc_skip_classify: 1;
			__u8 remcsum_offload: 1;
			__u8 csum_complete_sw: 1;
			__u8 csum_level: 2;
			__u8 inner_protocol_type: 1;
			__u8 l4_hash: 1;
			__u8 sw_hash: 1;
			__u8 wifi_acked_valid: 1;
			__u8 wifi_acked: 1;
			__u8 no_fcs: 1;
			__u8 encapsulation: 1;
			__u8 encap_hdr_csum: 1;
			__u8 csum_valid: 1;
			__u8 ndisc_nodetype: 2;
			__u8 ipvs_property: 1;
			__u8 nf_trace: 1;
			__u8 offload_fwd_mark: 1;
			__u8 offload_l3_fwd_mark: 1;
			__u8 redirected: 1;
			__u8 from_ingress: 1;
			__u8 nf_skip_egress: 1;
			__u8 decrypted: 1;
			__u8 slow_gro: 1;
			__u8 csum_not_inet: 1;
			__u8 unreadable: 1;
			__u16 tc_index;
			u16 alloc_cpu;
			union {
				__wsum csum;
				struct {
					__u16 csum_start;
					__u16 csum_offset;
				};
			};
			__u32 priority;
			int skb_iif;
			__u32 hash;
			union {
				u32 vlan_all;
				struct {
					__be16 vlan_proto;
					__u16 vlan_tci;
				};
			};
			union {
				unsigned int napi_id;
				unsigned int sender_cpu;
			};
			__u32 secmark;
			union {
				__u32 mark;
				__u32 reserved_tailroom;
			};
			union {
				__be16 inner_protocol;
				__u8 inner_ipproto;
			};
			__u16 inner_transport_header;
			__u16 inner_network_header;
			__u16 inner_mac_header;
			__be16 protocol;
			__u16 transport_header;
			__u16 network_header;
			__u16 mac_header;
		};
		struct {
			__u8 __pkt_type_offset[0];
			__u8 pkt_type: 3;
			__u8 ignore_df: 1;
			__u8 dst_pending_confirm: 1;
			__u8 ip_summed: 2;
			__u8 ooo_okay: 1;
			__u8 __mono_tc_offset[0];
			__u8 tstamp_type: 2;
			__u8 tc_at_ingress: 1;
			__u8 tc_skip_classify: 1;
			__u8 remcsum_offload: 1;
			__u8 csum_complete_sw: 1;
			__u8 csum_level: 2;
			__u8 inner_protocol_type: 1;
			__u8 l4_hash: 1;
			__u8 sw_hash: 1;
			__u8 wifi_acked_valid: 1;
			__u8 wifi_acked: 1;
			__u8 no_fcs: 1;
			__u8 encapsulation: 1;
			__u8 encap_hdr_csum: 1;
			__u8 csum_valid: 1;
			__u8 ndisc_nodetype: 2;
			__u8 ipvs_property: 1;
			__u8 nf_trace: 1;
			__u8 offload_fwd_mark: 1;
			__u8 offload_l3_fwd_mark: 1;
			__u8 redirected: 1;
			__u8 from_ingress: 1;
			__u8 nf_skip_egress: 1;
			__u8 decrypted: 1;
			__u8 slow_gro: 1;
			__u8 csum_not_inet: 1;
			__u8 unreadable: 1;
			__u16 tc_index;
			u16 alloc_cpu;
			union {
				__wsum csum;
				struct {
					__u16 csum_start;
					__u16 csum_offset;
				};
			};
			__u32 priority;
			int skb_iif;
			__u32 hash;
			union {
				u32 vlan_all;
				struct {
					__be16 vlan_proto;
					__u16 vlan_tci;
				};
			};
			union {
				unsigned int napi_id;
				unsigned int sender_cpu;
			};
			__u32 secmark;
			union {
				__u32 mark;
				__u32 reserved_tailroom;
			};
			union {
				__be16 inner_protocol;
				__u8 inner_ipproto;
			};
			__u16 inner_transport_header;
			__u16 inner_network_header;
			__u16 inner_mac_header;
			__be16 protocol;
			__u16 transport_header;
			__u16 network_header;
			__u16 mac_header;
		} headers;
	};
	sk_buff_data_t tail;
	sk_buff_data_t end;
	unsigned char *head;
	unsigned char *data;
	unsigned int truesize;
	refcount_t users;
	struct skb_ext *extensions;
};

struct xdp_md {
	__u32 data;
	__u32 data_end;
	__u32 data_meta;
	__u32 ingress_ifindex;
	__u32 rx_queue_index;
	__u32 egress_ifindex;
};

struct xdp_rxq_info;

struct xdp_txq_info;

struct xdp_buff {
	void *data;
	void *data_end;
	void *data_meta;
	void *data_hard_start;
	struct xdp_rxq_info *rxq;
	struct xdp_txq_info *txq;
	u32 frame_sz;
	u32 flags;
};

struct bpf_sock {
	__u32 bound_dev_if;
	__u32 family;
	__u32 type;
	__u32 protocol;
	__u32 mark;
	__u32 priority;
	__u32 src_ip4;
	__u32 src_ip6[4];
	__u32 src_port;
	__be16 dst_port;
	__u32 dst_ip4;
	__u32 dst_ip6[4];
	__u32 state;
	__s32 rx_queue_mapping;
};

struct hlist_nulls_node {
	struct hlist_nulls_node *next;
	struct hlist_nulls_node **pprev;
};

struct proto;

struct inet_timewait_death_row;

struct sock_common {
	union {
		__addrpair skc_addrpair;
		struct {
			__be32 skc_daddr;
			__be32 skc_rcv_saddr;
		};
	};
	union {
		unsigned int skc_hash;
		__u16 skc_u16hashes[2];
	};
	union {
		__portpair skc_portpair;
		struct {
			__be16 skc_dport;
			__u16 skc_num;
		};
	};
	short unsigned int skc_family;
	volatile unsigned char skc_state;
	unsigned char skc_reuse: 4;
	unsigned char skc_reuseport: 1;
	unsigned char skc_ipv6only: 1;
	unsigned char skc_net_refcnt: 1;
	int skc_bound_dev_if;
	union {
		struct hlist_node skc_bind_node;
		struct hlist_node skc_portaddr_node;
	};
	struct proto *skc_prot;
	possible_net_t skc_net;
	struct in6_addr skc_v6_daddr;
	struct in6_addr skc_v6_rcv_saddr;
	atomic64_t skc_cookie;
	union {
		long unsigned int skc_flags;
		struct sock *skc_listener;
		struct inet_timewait_death_row *skc_tw_dr;
	};
	int skc_dontcopy_begin[0];
	union {
		struct hlist_node skc_node;
		struct hlist_nulls_node skc_nulls_node;
	};
	short unsigned int skc_tx_queue_mapping;
	short unsigned int skc_rx_queue_mapping;
	union {
		int skc_incoming_cpu;
		u32 skc_rcv_wnd;
		u32 skc_tw_rcv_nxt;
	};
	refcount_t skc_refcnt;
	int skc_dontcopy_end[0];
	union {
		u32 skc_rxhash;
		u32 skc_window_clamp;
		u32 skc_tw_snd_nxt;
	};
};

struct page_frag {
	struct page *page;
	__u32 offset;
	__u32 size;
};

struct sock_cgroup_data {
	struct cgroup *cgroup;
	u32 classid;
	u16 prioidx;
};

struct dst_entry;

struct sk_filter;

struct socket_wq;

struct socket;

struct mem_cgroup;

struct xfrm_policy;

struct sock_reuseport;

struct bpf_local_storage;

struct sock {
	struct sock_common __sk_common;
	__u8 __cacheline_group_begin__sock_write_rx[0];
	atomic_t sk_drops;
	__s32 sk_peek_off;
	struct sk_buff_head sk_error_queue;
	struct sk_buff_head sk_receive_queue;
	struct {
		atomic_t rmem_alloc;
		int len;
		struct sk_buff *head;
		struct sk_buff *tail;
	} sk_backlog;
	__u8 __cacheline_group_end__sock_write_rx[0];
	__u8 __cacheline_group_begin__sock_read_rx[0];
	struct dst_entry *sk_rx_dst;
	int sk_rx_dst_ifindex;
	u32 sk_rx_dst_cookie;
	unsigned int sk_ll_usec;
	unsigned int sk_napi_id;
	u16 sk_busy_poll_budget;
	u8 sk_prefer_busy_poll;
	u8 sk_userlocks;
	int sk_rcvbuf;
	struct sk_filter *sk_filter;
	union {
		struct socket_wq *sk_wq;
		struct socket_wq *sk_wq_raw;
	};
	void (*sk_data_ready)(struct sock *);
	long int sk_rcvtimeo;
	int sk_rcvlowat;
	__u8 __cacheline_group_end__sock_read_rx[0];
	__u8 __cacheline_group_begin__sock_read_rxtx[0];
	int sk_err;
	struct socket *sk_socket;
	struct mem_cgroup *sk_memcg;
	struct xfrm_policy *sk_policy[2];
	__u8 __cacheline_group_end__sock_read_rxtx[0];
	__u8 __cacheline_group_begin__sock_write_rxtx[0];
	socket_lock_t sk_lock;
	u32 sk_reserved_mem;
	int sk_forward_alloc;
	u32 sk_tsflags;
	__u8 __cacheline_group_end__sock_write_rxtx[0];
	__u8 __cacheline_group_begin__sock_write_tx[0];
	int sk_write_pending;
	atomic_t sk_omem_alloc;
	int sk_sndbuf;
	int sk_wmem_queued;
	refcount_t sk_wmem_alloc;
	long unsigned int sk_tsq_flags;
	union {
		struct sk_buff *sk_send_head;
		struct rb_root tcp_rtx_queue;
	};
	struct sk_buff_head sk_write_queue;
	u32 sk_dst_pending_confirm;
	u32 sk_pacing_status;
	struct page_frag sk_frag;
	struct timer_list sk_timer;
	long unsigned int sk_pacing_rate;
	atomic_t sk_zckey;
	atomic_t sk_tskey;
	__u8 __cacheline_group_end__sock_write_tx[0];
	__u8 __cacheline_group_begin__sock_read_tx[0];
	long unsigned int sk_max_pacing_rate;
	long int sk_sndtimeo;
	u32 sk_priority;
	u32 sk_mark;
	struct dst_entry *sk_dst_cache;
	netdev_features_t sk_route_caps;
	struct sk_buff * (*sk_validate_xmit_skb)(struct sock *, struct net_device *, struct sk_buff *);
	u16 sk_gso_type;
	u16 sk_gso_max_segs;
	unsigned int sk_gso_max_size;
	gfp_t sk_allocation;
	u32 sk_txhash;
	u8 sk_pacing_shift;
	bool sk_use_task_frag;
	__u8 __cacheline_group_end__sock_read_tx[0];
	u8 sk_gso_disabled: 1;
	u8 sk_kern_sock: 1;
	u8 sk_no_check_tx: 1;
	u8 sk_no_check_rx: 1;
	u8 sk_shutdown;
	u16 sk_type;
	u16 sk_protocol;
	long unsigned int sk_lingertime;
	struct proto *sk_prot_creator;
	rwlock_t sk_callback_lock;
	int sk_err_soft;
	u32 sk_ack_backlog;
	u32 sk_max_ack_backlog;
	kuid_t sk_uid;
	long unsigned int sk_ino;
	spinlock_t sk_peer_lock;
	int sk_bind_phc;
	struct pid *sk_peer_pid;
	const struct cred *sk_peer_cred;
	ktime_t sk_stamp;
	int sk_disconnects;
	union {
		u8 sk_txrehash;
		u8 sk_scm_recv_flags;
		struct {
			u8 sk_scm_credentials: 1;
			u8 sk_scm_security: 1;
			u8 sk_scm_pidfd: 1;
			u8 sk_scm_rights: 1;
			u8 sk_scm_unused: 4;
		};
	};
	u8 sk_clockid;
	u8 sk_txtime_deadline_mode: 1;
	u8 sk_txtime_report_errors: 1;
	u8 sk_txtime_unused: 6;
	u8 sk_bpf_cb_flags;
	void *sk_user_data;
	void *sk_security;
	struct sock_cgroup_data sk_cgrp_data;
	void (*sk_state_change)(struct sock *);
	void (*sk_write_space)(struct sock *);
	void (*sk_error_report)(struct sock *);
	int (*sk_backlog_rcv)(struct sock *, struct sk_buff *);
	void (*sk_destruct)(struct sock *);
	struct sock_reuseport *sk_reuseport_cb;
	struct bpf_local_storage *sk_bpf_storage;
	struct callback_head sk_rcu;
	netns_tracker ns_tracker;
	struct xarray sk_user_frags;
};

struct bpf_sock_addr {
	__u32 user_family;
	__u32 user_ip4;
	__u32 user_ip6[4];
	__u32 user_port;
	__u32 family;
	__u32 type;
	__u32 protocol;
	__u32 msg_src_ip4;
	__u32 msg_src_ip6[4];
	union {
		struct bpf_sock *sk;
	};
};

struct bpf_sock_addr_kern {
	struct sock *sk;
	struct sockaddr *uaddr;
	u64 tmp_reg;
	void *t_ctx;
	u32 uaddrlen;
};

struct bpf_sock_ops {
	__u32 op;
	union {
		__u32 args[4];
		__u32 reply;
		__u32 replylong[4];
	};
	__u32 family;
	__u32 remote_ip4;
	__u32 local_ip4;
	__u32 remote_ip6[4];
	__u32 local_ip6[4];
	__u32 remote_port;
	__u32 local_port;
	__u32 is_fullsock;
	__u32 snd_cwnd;
	__u32 srtt_us;
	__u32 bpf_sock_ops_cb_flags;
	__u32 state;
	__u32 rtt_min;
	__u32 snd_ssthresh;
	__u32 rcv_nxt;
	__u32 snd_nxt;
	__u32 snd_una;
	__u32 mss_cache;
	__u32 ecn_flags;
	__u32 rate_delivered;
	__u32 rate_interval_us;
	__u32 packets_out;
	__u32 retrans_out;
	__u32 total_retrans;
	__u32 segs_in;
	__u32 data_segs_in;
	__u32 segs_out;
	__u32 data_segs_out;
	__u32 lost_out;
	__u32 sacked_out;
	__u32 sk_txhash;
	__u64 bytes_received;
	__u64 bytes_acked;
	union {
		struct bpf_sock *sk;
	};
	union {
		void *skb_data;
	};
	union {
		void *skb_data_end;
	};
	__u32 skb_len;
	__u32 skb_tcp_flags;
	__u64 skb_hwtstamp;
};

struct bpf_sock_ops_kern {
	struct sock *sk;
	union {
		u32 args[4];
		u32 reply;
		u32 replylong[4];
	};
	struct sk_buff *syn_skb;
	struct sk_buff *skb;
	void *skb_data_end;
	u8 op;
	u8 is_fullsock;
	u8 is_locked_tcp_sock;
	u8 remaining_opt_len;
	u64 temp;
};

struct sk_msg_md {
	union {
		void *data;
	};
	union {
		void *data_end;
	};
	__u32 family;
	__u32 remote_ip4;
	__u32 local_ip4;
	__u32 remote_ip6[4];
	__u32 local_ip6[4];
	__u32 remote_port;
	__u32 local_port;
	__u32 size;
	union {
		struct bpf_sock *sk;
	};
};

struct sk_msg_sg {
	u32 start;
	u32 curr;
	u32 end;
	u32 size;
	u32 copybreak;
	long unsigned int copy[1];
	struct scatterlist data[19];
};

struct sk_msg {
	struct sk_msg_sg sg;
	void *data;
	void *data_end;
	u32 apply_bytes;
	u32 cork_bytes;
	u32 flags;
	struct sk_buff *skb;
	struct sock *sk_redir;
	struct sock *sk;
	struct list_head list;
};

struct bpf_flow_dissector {
	struct bpf_flow_keys *flow_keys;
	const struct sk_buff *skb;
	const void *data;
	const void *data_end;
};

typedef struct pt_regs bpf_user_pt_regs_t;

struct bpf_perf_event_data {
	bpf_user_pt_regs_t regs;
	__u64 sample_period;
	__u64 addr;
};

struct perf_sample_data;

struct bpf_perf_event_data_kern {
	bpf_user_pt_regs_t *regs;
	struct perf_sample_data *data;
	struct perf_event *event;
};

struct bpf_raw_tracepoint_args {
	__u64 args[0];
};

struct bpf_sysctl {
	__u32 write;
	__u32 file_pos;
};

struct ctl_table;

struct bpf_sysctl_kern {
	struct ctl_table_header *head;
	const struct ctl_table *table;
	void *cur_val;
	size_t cur_len;
	void *new_val;
	size_t new_len;
	int new_updated;
	int write;
	loff_t *ppos;
	u64 tmp_reg;
};

struct bpf_sockopt {
	union {
		struct bpf_sock *sk;
	};
	union {
		void *optval;
	};
	union {
		void *optval_end;
	};
	__s32 level;
	__s32 optname;
	__s32 optlen;
	__s32 retval;
};

struct bpf_sockopt_kern {
	struct sock *sk;
	u8 *optval;
	u8 *optval_end;
	s32 level;
	s32 optname;
	s32 optlen;
	struct task_struct *current_task;
	u64 tmp_reg;
};

struct sk_reuseport_md {
	union {
		void *data;
	};
	union {
		void *data_end;
	};
	__u32 len;
	__u32 eth_protocol;
	__u32 ip_protocol;
	__u32 bind_inany;
	__u32 hash;
	union {
		struct bpf_sock *sk;
	};
	union {
		struct bpf_sock *migrating_sk;
	};
};

struct sk_reuseport_kern {
	struct sk_buff *skb;
	struct sock *sk;
	struct sock *selected_sk;
	struct sock *migrating_sk;
	void *data_end;
	u32 hash;
	u32 reuseport_id;
	bool bind_inany;
};

struct bpf_sk_lookup {
	union {
		union {
			struct bpf_sock *sk;
		};
		__u64 cookie;
	};
	__u32 family;
	__u32 protocol;
	__u32 remote_ip4;
	__u32 remote_ip6[4];
	__be16 remote_port;
	__u32 local_ip4;
	__u32 local_ip6[4];
	__u32 local_port;
	__u32 ingress_ifindex;
};

struct bpf_sk_lookup_kern {
	u16 family;
	u16 protocol;
	__be16 sport;
	u16 dport;
	struct {
		__be32 saddr;
		__be32 daddr;
	} v4;
	struct {
		const struct in6_addr *saddr;
		const struct in6_addr *daddr;
	} v6;
	struct sock *selected_sk;
	u32 ingress_ifindex;
	bool no_reuseport;
};

struct nf_hook_state;

struct bpf_nf_ctx {
	const struct nf_hook_state *state;
	struct sk_buff *skb;
};

struct bpf_ctx_convert {
	struct __sk_buff BPF_PROG_TYPE_SOCKET_FILTER_prog;
	struct sk_buff BPF_PROG_TYPE_SOCKET_FILTER_kern;
	struct __sk_buff BPF_PROG_TYPE_SCHED_CLS_prog;
	struct sk_buff BPF_PROG_TYPE_SCHED_CLS_kern;
	struct __sk_buff BPF_PROG_TYPE_SCHED_ACT_prog;
	struct sk_buff BPF_PROG_TYPE_SCHED_ACT_kern;
	struct xdp_md BPF_PROG_TYPE_XDP_prog;
	struct xdp_buff BPF_PROG_TYPE_XDP_kern;
	struct __sk_buff BPF_PROG_TYPE_CGROUP_SKB_prog;
	struct sk_buff BPF_PROG_TYPE_CGROUP_SKB_kern;
	struct bpf_sock BPF_PROG_TYPE_CGROUP_SOCK_prog;
	struct sock BPF_PROG_TYPE_CGROUP_SOCK_kern;
	struct bpf_sock_addr BPF_PROG_TYPE_CGROUP_SOCK_ADDR_prog;
	struct bpf_sock_addr_kern BPF_PROG_TYPE_CGROUP_SOCK_ADDR_kern;
	struct __sk_buff BPF_PROG_TYPE_LWT_IN_prog;
	struct sk_buff BPF_PROG_TYPE_LWT_IN_kern;
	struct __sk_buff BPF_PROG_TYPE_LWT_OUT_prog;
	struct sk_buff BPF_PROG_TYPE_LWT_OUT_kern;
	struct __sk_buff BPF_PROG_TYPE_LWT_XMIT_prog;
	struct sk_buff BPF_PROG_TYPE_LWT_XMIT_kern;
	struct __sk_buff BPF_PROG_TYPE_LWT_SEG6LOCAL_prog;
	struct sk_buff BPF_PROG_TYPE_LWT_SEG6LOCAL_kern;
	struct bpf_sock_ops BPF_PROG_TYPE_SOCK_OPS_prog;
	struct bpf_sock_ops_kern BPF_PROG_TYPE_SOCK_OPS_kern;
	struct __sk_buff BPF_PROG_TYPE_SK_SKB_prog;
	struct sk_buff BPF_PROG_TYPE_SK_SKB_kern;
	struct sk_msg_md BPF_PROG_TYPE_SK_MSG_prog;
	struct sk_msg BPF_PROG_TYPE_SK_MSG_kern;
	struct __sk_buff BPF_PROG_TYPE_FLOW_DISSECTOR_prog;
	struct bpf_flow_dissector BPF_PROG_TYPE_FLOW_DISSECTOR_kern;
	bpf_user_pt_regs_t BPF_PROG_TYPE_KPROBE_prog;
	struct pt_regs BPF_PROG_TYPE_KPROBE_kern;
	__u64 BPF_PROG_TYPE_TRACEPOINT_prog;
	u64 BPF_PROG_TYPE_TRACEPOINT_kern;
	struct bpf_perf_event_data BPF_PROG_TYPE_PERF_EVENT_prog;
	struct bpf_perf_event_data_kern BPF_PROG_TYPE_PERF_EVENT_kern;
	struct bpf_raw_tracepoint_args BPF_PROG_TYPE_RAW_TRACEPOINT_prog;
	u64 BPF_PROG_TYPE_RAW_TRACEPOINT_kern;
	struct bpf_raw_tracepoint_args BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE_prog;
	u64 BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE_kern;
	void *BPF_PROG_TYPE_TRACING_prog;
	void *BPF_PROG_TYPE_TRACING_kern;
	struct bpf_cgroup_dev_ctx BPF_PROG_TYPE_CGROUP_DEVICE_prog;
	struct bpf_cgroup_dev_ctx BPF_PROG_TYPE_CGROUP_DEVICE_kern;
	struct bpf_sysctl BPF_PROG_TYPE_CGROUP_SYSCTL_prog;
	struct bpf_sysctl_kern BPF_PROG_TYPE_CGROUP_SYSCTL_kern;
	struct bpf_sockopt BPF_PROG_TYPE_CGROUP_SOCKOPT_prog;
	struct bpf_sockopt_kern BPF_PROG_TYPE_CGROUP_SOCKOPT_kern;
	__u32 BPF_PROG_TYPE_LIRC_MODE2_prog;
	u32 BPF_PROG_TYPE_LIRC_MODE2_kern;
	struct sk_reuseport_md BPF_PROG_TYPE_SK_REUSEPORT_prog;
	struct sk_reuseport_kern BPF_PROG_TYPE_SK_REUSEPORT_kern;
	struct bpf_sk_lookup BPF_PROG_TYPE_SK_LOOKUP_prog;
	struct bpf_sk_lookup_kern BPF_PROG_TYPE_SK_LOOKUP_kern;
	void *BPF_PROG_TYPE_STRUCT_OPS_prog;
	void *BPF_PROG_TYPE_STRUCT_OPS_kern;
	void *BPF_PROG_TYPE_EXT_prog;
	void *BPF_PROG_TYPE_EXT_kern;
	void *BPF_PROG_TYPE_LSM_prog;
	void *BPF_PROG_TYPE_LSM_kern;
	void *BPF_PROG_TYPE_SYSCALL_prog;
	void *BPF_PROG_TYPE_SYSCALL_kern;
	struct bpf_nf_ctx BPF_PROG_TYPE_NETFILTER_prog;
	struct bpf_nf_ctx BPF_PROG_TYPE_NETFILTER_kern;
};

struct bpf_devmap_val {
	__u32 ifindex;
	union {
		int fd;
		__u32 id;
	} bpf_prog;
};

struct bpf_dispatcher_prog {
	struct bpf_prog *prog;
	refcount_t users;
};

struct latch_tree_node {
	struct rb_node node[2];
};

struct bpf_ksym {
	long unsigned int start;
	long unsigned int end;
	char name[512];
	struct list_head lnode;
	struct latch_tree_node tnode;
	bool prog;
};

struct static_call_key;

struct bpf_dispatcher {
	struct mutex mutex;
	void *func;
	struct bpf_dispatcher_prog progs[48];
	int num_progs;
	void *image;
	void *rw_image;
	u32 image_off;
	struct bpf_ksym ksym;
	struct static_call_key *sc_key;
	void *sc_tramp;
};

struct bpf_dtab_netdev;

struct bpf_dtab {
	struct bpf_map map;
	struct bpf_dtab_netdev **netdev_map;
	struct list_head list;
	struct hlist_head *dev_index_head;
	spinlock_t index_lock;
	unsigned int items;
	u32 n_buckets;
};

struct bpf_dtab_netdev {
	struct net_device *dev;
	struct hlist_node index_hlist;
	struct bpf_prog *xdp_prog;
	struct callback_head rcu;
	unsigned int idx;
	struct bpf_devmap_val val;
};

struct bpf_dummy_ops_state;

struct bpf_dummy_ops {
	int (*test_1)(struct bpf_dummy_ops_state *);
	int (*test_2)(struct bpf_dummy_ops_state *, int, short unsigned int, char, long unsigned int);
	int (*test_sleepable)(struct bpf_dummy_ops_state *);
};

struct bpf_dummy_ops_state {
	int val;
};

struct bpf_dummy_ops_test_args {
	u64 args[12];
	struct bpf_dummy_ops_state state;
};

struct bpf_dynptr {
	__u64 __opaque[2];
};

struct bpf_dynptr_kern {
	void *data;
	u32 size;
	u32 offset;
};

struct bpf_prog_array_item {
	struct bpf_prog *prog;
	union {
		struct bpf_cgroup_storage *cgroup_storage[2];
		u64 bpf_cookie;
	};
};

struct bpf_prog_array {
	struct callback_head rcu;
	struct bpf_prog_array_item items[0];
};

struct bpf_empty_prog_array {
	struct bpf_prog_array hdr;
	struct bpf_prog *null_prog;
};

struct bpf_event_entry {
	struct perf_event *event;
	struct file *perf_file;
	struct file *map_file;
	struct callback_head rcu;
};

struct bpf_fentry_test_t {
	struct bpf_fentry_test_t *a;
};

struct bpf_fib_lookup {
	__u8 family;
	__u8 l4_protocol;
	__be16 sport;
	__be16 dport;
	union {
		__u16 tot_len;
		__u16 mtu_result;
	};
	__u32 ifindex;
	union {
		__u8 tos;
		__be32 flowinfo;
		__u32 rt_metric;
	};
	union {
		__be32 ipv4_src;
		__u32 ipv6_src[4];
	};
	union {
		__be32 ipv4_dst;
		__u32 ipv6_dst[4];
	};
	union {
		struct {
			__be16 h_vlan_proto;
			__be16 h_vlan_TCI;
		};
		__u32 tbid;
	};
	union {
		struct {
			__u32 mark;
		};
		struct {
			__u8 smac[6];
			__u8 dmac[6];
		};
	};
};

struct bpf_flow_keys {
	__u16 nhoff;
	__u16 thoff;
	__u16 addr_proto;
	__u8 is_frag;
	__u8 is_first_frag;
	__u8 is_encap;
	__u8 ip_proto;
	__be16 n_proto;
	__be16 sport;
	__be16 dport;
	union {
		struct {
			__be32 ipv4_src;
			__be32 ipv4_dst;
		};
		struct {
			__u32 ipv6_src[4];
			__u32 ipv6_dst[4];
		};
	};
	__u32 flags;
	__be32 flow_label;
};

struct bpf_func_info {
	__u32 insn_off;
	__u32 type_id;
};

struct bpf_func_info_aux {
	u16 linkage;
	bool unreliable;
	bool called: 1;
	bool verified: 1;
};

struct bpf_func_proto {
	u64 (*func)(u64, u64, u64, u64, u64);
	bool gpl_only;
	bool pkt_access;
	bool might_sleep;
	bool allow_fastcall;
	enum bpf_return_type ret_type;
	union {
		struct {
			enum bpf_arg_type arg1_type;
			enum bpf_arg_type arg2_type;
			enum bpf_arg_type arg3_type;
			enum bpf_arg_type arg4_type;
			enum bpf_arg_type arg5_type;
		};
		enum bpf_arg_type arg_type[5];
	};
	union {
		struct {
			u32 *arg1_btf_id;
			u32 *arg2_btf_id;
			u32 *arg3_btf_id;
			u32 *arg4_btf_id;
			u32 *arg5_btf_id;
		};
		u32 *arg_btf_id[5];
		struct {
			size_t arg1_size;
			size_t arg2_size;
			size_t arg3_size;
			size_t arg4_size;
			size_t arg5_size;
		};
		size_t arg_size[5];
	};
	int *ret_btf_id;
	bool (*allowed)(const struct bpf_prog *);
};

struct tnum {
	u64 value;
	u64 mask;
};

struct bpf_reg_state {
	enum bpf_reg_type type;
	s32 off;
	union {
		int range;
		struct {
			struct bpf_map *map_ptr;
			u32 map_uid;
		};
		struct {
			struct btf *btf;
			u32 btf_id;
		};
		struct {
			u32 mem_size;
			u32 dynptr_id;
		};
		struct {
			enum bpf_dynptr_type type;
			bool first_slot;
		} dynptr;
		struct {
			struct btf *btf;
			u32 btf_id;
			enum bpf_iter_state state: 2;
			int depth: 30;
		} iter;
		struct {
			enum {
				IRQ_NATIVE_KFUNC = 0,
				IRQ_LOCK_KFUNC = 1,
			} kfunc_class;
		} irq;
		struct {
			long unsigned int raw1;
			long unsigned int raw2;
		} raw;
		u32 subprogno;
	};
	struct tnum var_off;
	s64 smin_value;
	s64 smax_value;
	u64 umin_value;
	u64 umax_value;
	s32 s32_min_value;
	s32 s32_max_value;
	u32 u32_min_value;
	u32 u32_max_value;
	u32 id;
	u32 ref_obj_id;
	struct bpf_reg_state *parent;
	u32 frameno;
	s32 subreg_def;
	enum bpf_reg_liveness live;
	bool precise;
};

struct bpf_retval_range {
	s32 minval;
	s32 maxval;
};

struct bpf_stack_state;

struct bpf_func_state {
	struct bpf_reg_state regs[11];
	int callsite;
	u32 frameno;
	u32 subprogno;
	u32 async_entry_cnt;
	struct bpf_retval_range callback_ret_range;
	bool in_callback_fn;
	bool in_async_callback_fn;
	bool in_exception_callback_fn;
	u32 callback_depth;
	struct bpf_stack_state *stack;
	int allocated_stack;
};

struct bpf_hrtimer {
	struct bpf_async_cb cb;
	struct hrtimer timer;
	atomic_t cancelling;
};

struct bpf_mem_caches;

struct bpf_mem_cache;

struct bpf_mem_alloc {
	struct bpf_mem_caches *caches;
	struct bpf_mem_cache *cache;
	struct obj_cgroup *objcg;
	bool percpu;
	struct work_struct work;
};

struct pcpu_freelist_head;

struct pcpu_freelist {
	struct pcpu_freelist_head *freelist;
};

struct bpf_lru_node;

t