// Copyright (c) 2022 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "fastdeploy/vision/ocr/ppocr/utils/ocr_utils.h"

namespace fastdeploy {
namespace vision {
namespace ocr {

static inline float FastExp(float x) {
  union { uint32_t i; float f; } v{}; 
  v.i = (1 << 23) * (1.4426950409 * x + 126.93490512f);
  return v.f;
}

std::vector<float> Softmax(std::vector<float> &src) {
  int length = src.size();
  std::vector<float> dst;
  dst.resize(length);
  const float alpha = static_cast<float>(
    *std::max_element(&src[0], &src[0 + length]));
  float denominator{0};

  for (int i = 0; i < length; ++i) {
    dst[i] = FastExp(src[i] - alpha);
    denominator += dst[i];
  }

  for (int i = 0; i < length; ++i) {
    dst[i] /= denominator;
  }
  return dst;
}

}  // namespace ocr
}  // namespace vision
}  // namespace fastdeploy
