/*
  Do not edit this file, it is automatically generated from:
  <mariadb_fix_privilege_tables.sql>
*/
#include <stdlib.h>
const char* mariadb_fix_privilege_tables[]={
"set sql_mode='';\n",
"set sql_safe_updates='OFF';\n",
"set default_storage_engine=Aria;\n",
"set enforce_storage_engine=NULL;\n",
"set alter_algorithm='DEFAULT';\n",
"set use_stat_tables='NEVER';\n",
"ALTER TABLE column_stats\n"
  "  modify min_value varbinary(255) DEFAULT NULL,\n"
  "  modify max_value varbinary(255) DEFAULT NULL,\n"
  "  modify hist_type enum('SINGLE_PREC_HB','DOUBLE_PREC_HB','JSON_HB'),\n"
  "  modify histogram longblob,\n"
  "  ENGINE=Aria transactional=0;\n",
"set @have_innodb= (select count(engine) from information_schema.engines where engine='INNODB' and support != 'NO');\n",
"DELETE FROM mysql.plugin WHERE name=\"rpl_semi_sync_master\" AND NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.PLUGINS WHERE PLUGIN_NAME=\"rpl_semi_sync_master\");\n",
"DELETE FROM mysql.plugin WHERE name=\"rpl_semi_sync_slave\" AND NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.PLUGINS WHERE PLUGIN_NAME=\"rpl_semi_sync_slave\");\n",
"ALTER TABLE user ENGINE=Aria transactional=1;\n",
"ALTER TABLE db ENGINE=Aria transactional=1;\n",
"ALTER TABLE func ENGINE=Aria transactional=1;\n",
"ALTER TABLE procs_priv ENGINE=Aria transactional=1;\n",
"ALTER TABLE tables_priv ENGINE=Aria transactional=1;\n",
"ALTER TABLE columns_priv ENGINE=Aria transactional=1;\n",
"ALTER TABLE roles_mapping ENGINE=Aria transactional=1;\n",
"ALTER TABLE plugin ENGINE=Aria transactional=1;\n",
"ALTER TABLE servers ENGINE=Aria transactional=1,\n"
  "  CONVERT TO CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci;\n",
"ALTER TABLE time_zone_name ENGINE=Aria transactional=1;\n",
"ALTER TABLE time_zone ENGINE=Aria transactional=1;\n",
"ALTER TABLE time_zone_transition ENGINE=Aria transactional=1;\n",
"ALTER TABLE time_zone_transition_type ENGINE=Aria transactional=1;\n",
"ALTER TABLE time_zone_leap_second ENGINE=Aria transactional=1;\n",
"ALTER TABLE proc ENGINE=Aria transactional=1;\n",
"ALTER TABLE event ENGINE=Aria transactional=1,\n"
  "  DEFAULT CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci;\n",
"ALTER TABLE proxies_priv ENGINE=Aria transactional=1;\n",
"ALTER TABLE help_topic ENGINE=Aria transactional=0;\n",
"ALTER TABLE help_category ENGINE=Aria transactional=0;\n",
"ALTER TABLE help_relation ENGINE=Aria transactional=0;\n",
"ALTER TABLE help_keyword ENGINE=Aria transactional=0;\n",
"ALTER TABLE table_stats ENGINE=Aria transactional=0;\n",
"ALTER TABLE index_stats ENGINE=Aria transactional=0;\n",
"ALTER TABLE user add File_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL;\n",
"SET @hadGrantPriv:=0;\n",
"SELECT @hadGrantPriv:=1 FROM user WHERE Grant_priv IS NOT NULL;\n",
"ALTER TABLE user add Grant_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "                 add References_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "                 add Index_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "                 add Alter_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL;\n",
"ALTER TABLE db add Grant_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "               add References_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "               add Index_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "               add Alter_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL;\n",
"UPDATE user SET Grant_priv=File_priv,References_priv=Create_priv,Index_priv=Create_priv,Alter_priv=Create_priv WHERE @hadGrantPriv = 0;\n",
"UPDATE db SET References_priv=Create_priv,Index_priv=Create_priv,Alter_priv=Create_priv WHERE @hadGrantPriv = 0;\n",
"ALTER TABLE user\n"
  "ADD ssl_type enum('','ANY','X509', 'SPECIFIED') DEFAULT '' NOT NULL,\n"
  "ADD ssl_cipher BLOB NOT NULL,\n"
  "ADD x509_issuer BLOB NOT NULL,\n"
  "ADD x509_subject BLOB NOT NULL;\n",
"ALTER TABLE user MODIFY ssl_type enum('','ANY','X509', 'SPECIFIED') DEFAULT '' NOT NULL;\n",
"ALTER TABLE tables_priv\n"
  "  ADD KEY Grantor (Grantor);\n",
"ALTER TABLE tables_priv\n"
  "  MODIFY Host char(255) NOT NULL default '',\n"
  "  MODIFY Db char(64) NOT NULL default '',\n"
  "  MODIFY User char(128) binary NOT NULL default '',\n"
  "  MODIFY Table_name char(64) NOT NULL default '',\n"
  "  MODIFY Grantor varchar(384) COLLATE utf8mb3_bin NOT NULL default '',\n"
  "  ENGINE=Aria,\n"
  "  CONVERT TO CHARACTER SET utf8mb3 COLLATE utf8mb3_bin;\n",
"ALTER TABLE tables_priv\n"
  "  MODIFY Column_priv set('Select','Insert','Update','References')\n"
  "    COLLATE utf8mb3_general_ci DEFAULT '' NOT NULL,\n"
  "  MODIFY Table_priv set('Select','Insert','Update','Delete','Create',\n"
  "                        'Drop','Grant','References','Index','Alter',\n"
  "                        'Create View','Show view','Trigger','Delete versioning rows')\n"
  "    COLLATE utf8mb3_general_ci DEFAULT '' NOT NULL,\n"
  "  COMMENT='Table privileges';\n",
"ALTER TABLE columns_priv\n"
  "  CHANGE Type Column_priv set('Select','Insert','Update','References')\n"
  "    COLLATE utf8mb3_general_ci DEFAULT '' NOT NULL;\n",
"ALTER TABLE columns_priv\n"
  "  MODIFY Host char(255) NOT NULL default '',\n"
  "  MODIFY Db char(64) NOT NULL default '',\n"
  "  MODIFY User char(128) binary NOT NULL default '',\n"
  "  MODIFY Table_name char(64) NOT NULL default '',\n"
  "  MODIFY Column_name char(64) NOT NULL default '',\n"
  "  ENGINE=Aria,\n"
  "  CONVERT TO CHARACTER SET utf8mb3 COLLATE utf8mb3_bin,\n"
  "  COMMENT='Column privileges';\n",
"ALTER TABLE columns_priv\n"
  "  MODIFY Column_priv set('Select','Insert','Update','References')\n"
  "    COLLATE utf8mb3_general_ci DEFAULT '' NOT NULL;\n",
"ALTER TABLE func add type enum ('function','aggregate') COLLATE utf8mb3_general_ci NOT NULL;\n",
"SET @hadShowDbPriv:=0;\n",
"SELECT @hadShowDbPriv:=1 FROM user WHERE Show_db_priv IS NOT NULL;\n",
"ALTER TABLE user\n"
  "ADD Show_db_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Alter_priv,\n"
  "ADD Super_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Show_db_priv,\n"
  "ADD Create_tmp_table_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Super_priv,\n"
  "ADD Lock_tables_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Create_tmp_table_priv,\n"
  "ADD Execute_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Lock_tables_priv,\n"
  "ADD Repl_slave_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Execute_priv,\n"
  "ADD Repl_client_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Repl_slave_priv;\n",
"UPDATE user SET Show_db_priv= Select_priv, Super_priv=Process_priv, Execute_priv=Process_priv, Create_tmp_table_priv='Y', Lock_tables_priv='Y', Repl_slave_priv=file_priv, Repl_client_priv=File_priv where user<>\"\" AND @hadShowDbPriv = 0;\n",
"ALTER TABLE user\n"
  "ADD max_questions int(11) NOT NULL DEFAULT 0 AFTER x509_subject,\n"
  "ADD max_updates   int(11) unsigned NOT NULL DEFAULT 0 AFTER max_questions,\n"
  "ADD max_connections int(11) unsigned NOT NULL DEFAULT 0 AFTER max_updates;\n",
"ALTER TABLE db\n"
  "ADD Create_tmp_table_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "ADD Lock_tables_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL;\n",
"alter table user change max_questions max_questions int(11) unsigned DEFAULT 0  NOT NULL;\n",
"alter table db comment='Database privileges';\n",
"alter table user comment='Users and global privileges';\n",
"alter table func comment='User defined functions';\n",
"ALTER TABLE user\n"
  "  MODIFY Host char(255) NOT NULL default '',\n"
  "  MODIFY User char(128) binary NOT NULL default '',\n"
  "  ENGINE=Aria, CONVERT TO CHARACTER SET utf8mb3 COLLATE utf8mb3_bin;\n",
"ALTER TABLE plugin\n"
  "  MODIFY name varchar(64) COLLATE utf8mb3_general_ci NOT NULL DEFAULT '',\n"
  "  MODIFY dl varchar(128) COLLATE utf8mb3_general_ci NOT NULL DEFAULT '',\n"
  "  CONVERT TO CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci;\n",
"ALTER TABLE user\n"
  "  ADD Password char(41) character set latin1 collate latin1_bin NOT NULL default '' AFTER User;\n",
"UPDATE user\n"
  "  SET plugin='unix_socket' WHERE plugin='auth_socket';\n",
"DELETE FROM plugin\n"
  "  WHERE name='auth_socket';\n",
"DELETE plugin\n"
  "  FROM information_schema.PLUGINS is_p\n"
  "  JOIN plugin ON plugin.name = is_p.PLUGIN_NAME\n"
  "  WHERE is_p.PLUGIN_LIBRARY IS NULL;\n",
"ALTER TABLE user\n"
  "  MODIFY Password char(41) character set latin1 collate latin1_bin NOT NULL default '',\n"
  "  MODIFY Select_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Insert_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Update_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Delete_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Create_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Drop_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Reload_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Shutdown_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Process_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY File_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Grant_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY References_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Index_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Alter_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Show_db_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Super_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Create_tmp_table_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Lock_tables_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Execute_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Repl_slave_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Repl_client_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY ssl_type enum('','ANY','X509', 'SPECIFIED') COLLATE utf8mb3_general_ci DEFAULT '' NOT NULL;\n",
"ALTER TABLE db\n"
  "  MODIFY Host char(255) NOT NULL default '',\n"
  "  MODIFY Db char(64) NOT NULL default '',\n"
  "  MODIFY User char(128) binary NOT NULL default '',\n"
  "  ENGINE=Aria, CONVERT TO CHARACTER SET utf8mb3 COLLATE utf8mb3_bin;\n",
"ALTER TABLE db\n"
  "  MODIFY  Select_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Insert_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Update_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Delete_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Create_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Drop_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Grant_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  References_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Index_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Alter_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Create_tmp_table_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Lock_tables_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL;\n",
"ALTER TABLE func\n"
  "  ENGINE=Aria, CONVERT TO CHARACTER SET utf8mb3 COLLATE utf8mb3_bin;\n",
"ALTER TABLE func\n"
  "  MODIFY type enum ('function','aggregate') COLLATE utf8mb3_general_ci NOT NULL;\n",
"SET @old_log_state = @@global.general_log;\n",
"SET GLOBAL general_log = 'OFF';\n",
"ALTER TABLE general_log\n"
  "  MODIFY event_time TIMESTAMP(6) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n"
  "  MODIFY user_host MEDIUMTEXT NOT NULL,\n"
  "  MODIFY server_id INTEGER UNSIGNED NOT NULL,\n"
  "  MODIFY command_type VARCHAR(64) NOT NULL,\n"
  "  MODIFY argument MEDIUMTEXT NOT NULL,\n"
  "  MODIFY thread_id BIGINT(21) UNSIGNED NOT NULL;\n",
"SET GLOBAL general_log = @old_log_state;\n",
"SET @old_log_state = @@global.log_slow_query;\n",
"SET GLOBAL log_slow_query = 'OFF';\n",
"ALTER TABLE slow_log\n"
  "  ADD COLUMN thread_id BIGINT(21) UNSIGNED NOT NULL AFTER sql_text;\n",
"ALTER TABLE slow_log\n"
  "  ADD COLUMN rows_affected BIGINT UNSIGNED NOT NULL AFTER thread_id;\n",
"ALTER TABLE slow_log\n"
  "  MODIFY start_time TIMESTAMP(6) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n"
  "  MODIFY user_host MEDIUMTEXT NOT NULL,\n"
  "  MODIFY query_time TIME(6) NOT NULL,\n"
  "  MODIFY lock_time TIME(6) NOT NULL,\n"
  "  MODIFY rows_sent BIGINT UNSIGNED NOT NULL,\n"
  "  MODIFY rows_examined BIGINT UNSIGNED NOT NULL,\n"
  "  MODIFY db VARCHAR(512) NOT NULL,\n"
  "  MODIFY last_insert_id INTEGER NOT NULL,\n"
  "  MODIFY insert_id INTEGER NOT NULL,\n"
  "  MODIFY server_id INTEGER UNSIGNED NOT NULL,\n"
  "  MODIFY sql_text MEDIUMTEXT NOT NULL,\n"
  "  MODIFY thread_id BIGINT(21) UNSIGNED NOT NULL;\n",
"SET GLOBAL log_slow_query = @old_log_state;\n",
"SET @hadCreateViewPriv:=0;\n",
"SELECT @hadCreateViewPriv:=1 FROM user WHERE Create_view_priv IS NOT NULL;\n",
"ALTER TABLE db ADD Create_view_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Lock_tables_priv;\n",
"ALTER TABLE db MODIFY Create_view_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Lock_tables_priv;\n",
"ALTER TABLE user ADD Create_view_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Repl_client_priv;\n",
"ALTER TABLE user MODIFY Create_view_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Repl_client_priv;\n",
"ALTER TABLE db ADD Show_view_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Create_view_priv;\n",
"ALTER TABLE db MODIFY Show_view_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Create_view_priv;\n",
"ALTER TABLE user ADD Show_view_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Create_view_priv;\n",
"ALTER TABLE user MODIFY Show_view_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Create_view_priv;\n",
"UPDATE user SET Create_view_priv=Create_priv, Show_view_priv=Create_priv where user<>\"\" AND @hadCreateViewPriv = 0;\n",
"SET @hadCreateRoutinePriv:=0;\n",
"SELECT @hadCreateRoutinePriv:=1 FROM user WHERE Create_routine_priv IS NOT NULL;\n",
"ALTER TABLE db ADD Create_routine_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Show_view_priv;\n",
"ALTER TABLE db MODIFY Create_routine_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Show_view_priv;\n",
"ALTER TABLE user ADD Create_routine_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Show_view_priv;\n",
"ALTER TABLE user MODIFY Create_routine_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Show_view_priv;\n",
"ALTER TABLE db ADD Alter_routine_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Create_routine_priv;\n",
"ALTER TABLE db MODIFY Alter_routine_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Create_routine_priv;\n",
"ALTER TABLE user ADD Alter_routine_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Create_routine_priv;\n",
"ALTER TABLE user MODIFY Alter_routine_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Create_routine_priv;\n",
"ALTER TABLE db ADD Execute_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Alter_routine_priv;\n",
"ALTER TABLE db MODIFY Execute_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Alter_routine_priv;\n",
"UPDATE user SET Create_routine_priv=Create_priv, Alter_routine_priv=Alter_priv where user<>\"\" AND @hadCreateRoutinePriv = 0;\n",
"UPDATE db SET Create_routine_priv=Create_priv, Alter_routine_priv=Alter_priv, Execute_priv=Select_priv where user<>\"\" AND @hadCreateRoutinePriv = 0;\n",
"ALTER TABLE user ADD max_user_connections int(11) DEFAULT '0' NOT NULL AFTER max_connections;\n",
"ALTER TABLE user MODIFY max_user_connections int(11) DEFAULT '0' NOT NULL AFTER max_connections;\n",
"SET @hadCreateUserPriv:=0;\n",
"SELECT @hadCreateUserPriv:=1 FROM user WHERE Create_user_priv IS NOT NULL;\n",
"ALTER TABLE user ADD Create_user_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Alter_routine_priv;\n",
"ALTER TABLE user MODIFY Create_user_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Alter_routine_priv;\n",
"UPDATE user LEFT JOIN db USING (Host,User) SET Create_user_priv='Y'\n"
  "  WHERE @hadCreateUserPriv = 0 AND\n"
  "        (user.Grant_priv = 'Y' OR db.Grant_priv = 'Y');\n",
"ALTER TABLE procs_priv\n"
  "  ENGINE=Aria,\n"
  "  CONVERT TO CHARACTER SET utf8mb3 COLLATE utf8mb3_bin;\n",
"ALTER TABLE procs_priv\n"
  "  MODIFY Proc_priv set('Execute','Alter Routine','Grant','Show Create Routine')\n"
  "    COLLATE utf8mb3_general_ci DEFAULT '' NOT NULL;\n",
"ALTER IGNORE TABLE procs_priv\n"
  "  MODIFY Routine_name char(64)\n"
  "    COLLATE utf8mb3_general_ci DEFAULT '' NOT NULL;\n",
"ALTER TABLE procs_priv\n"
  "  ADD Routine_type enum('FUNCTION','PROCEDURE')\n"
  "    COLLATE utf8mb3_general_ci NOT NULL AFTER Routine_name;\n",
"ALTER TABLE procs_priv\n"
  "  MODIFY Timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP AFTER Proc_priv;\n",
"ALTER TABLE proc MODIFY name char(64) DEFAULT '' NOT NULL,\n"
  "                 MODIFY specific_name char(64) DEFAULT '' NOT NULL,\n"
  "                 MODIFY sql_data_access\n"
  "                        enum('CONTAINS_SQL',\n"
  "                             'NO_SQL',\n"
  "                             'READS_SQL_DATA',\n"
  "                             'MODIFIES_SQL_DATA'\n"
  "                            ) DEFAULT 'CONTAINS_SQL' NOT NULL,\n"
  "                 MODIFY body longblob NOT NULL,\n"
  "                 MODIFY returns longblob NOT NULL,\n"
  "                 MODIFY sql_mode\n"
  "                        set('REAL_AS_FLOAT',\n"
  "                            'PIPES_AS_CONCAT',\n"
  "                            'ANSI_QUOTES',\n"
  "                            'IGNORE_SPACE',\n"
  "                            'IGNORE_BAD_TABLE_OPTIONS',\n"
  "                            'ONLY_FULL_GROUP_BY',\n"
  "                            'NO_UNSIGNED_SUBTRACTION',\n"
  "                            'NO_DIR_IN_CREATE',\n"
  "                            'POSTGRESQL',\n"
  "                            'ORACLE',\n"
  "                            'MSSQL',\n"
  "                            'DB2',\n"
  "                            'MAXDB',\n"
  "                            'NO_KEY_OPTIONS',\n"
  "                            'NO_TABLE_OPTIONS',\n"
  "                            'NO_FIELD_OPTIONS',\n"
  "                            'MYSQL323',\n"
  "                            'MYSQL40',\n"
  "                            'ANSI',\n"
  "                            'NO_AUTO_VALUE_ON_ZERO',\n"
  "                            'NO_BACKSLASH_ESCAPES',\n"
  "                            'STRICT_TRANS_TABLES',\n"
  "                            'STRICT_ALL_TABLES',\n"
  "                            'NO_ZERO_IN_DATE',\n"
  "                            'NO_ZERO_DATE',\n"
  "                            'INVALID_DATES',\n"
  "                            'ERROR_FOR_DIVISION_BY_ZERO',\n"
  "                            'TRADITIONAL',\n"
  "                            'NO_AUTO_CREATE_USER',\n"
  "                            'HIGH_NOT_PRECEDENCE',\n"
  "                            'NO_ENGINE_SUBSTITUTION',\n"
  "                            'PAD_CHAR_TO_FULL_LENGTH',\n"
  "                            'EMPTY_STRING_IS_NULL',\n"
  "                            'SIMULTANEOUS_ASSIGNMENT',\n"
  "                            'TIME_ROUND_FRACTIONAL'\n"
  "                            ) DEFAULT '' NOT NULL,\n"
  "                 DEFAULT CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci;\n",
"ALTER TABLE proc CONVERT TO CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,\n"
  "                  MODIFY db char(64) binary DEFAULT '' NOT NULL,\n"
  "                  MODIFY definer varchar(384) binary DEFAULT '' NOT NULL,\n"
  "                  MODIFY comment text binary NOT NULL;\n",
"ALTER TABLE proc ADD character_set_client\n"
  "                     char(32) collate utf8mb3_bin DEFAULT NULL\n"
  "                     AFTER comment;\n",
"ALTER TABLE proc MODIFY character_set_client\n"
  "                        char(32) collate utf8mb3_bin DEFAULT NULL;\n",
"ALTER TABLE proc MODIFY type enum('FUNCTION',\n"
  "                                  'PROCEDURE',\n"
  "                                  'PACKAGE',\n"
  "                                  'PACKAGE BODY') NOT NULL;\n",
"ALTER TABLE procs_priv MODIFY Routine_type enum('FUNCTION',\n"
  "                                                'PROCEDURE',\n"
  "                                                'PACKAGE',\n"
  "                                                'PACKAGE BODY') NOT NULL;\n",
"SELECT CASE WHEN COUNT(*) > 0 THEN\n"
  "CONCAT (\"WARNING: NULL values of the 'character_set_client' column ('mysql.proc' table) have been updated with a default value (\", @@character_set_client, \"). Please verify if necessary.\")\n"
  "ELSE NULL\n"
  "END\n"
  "AS value FROM proc WHERE character_set_client IS NULL;\n",
"UPDATE proc SET character_set_client = @@character_set_client\n"
  "                     WHERE character_set_client IS NULL;\n",
"ALTER TABLE proc ADD collation_connection\n"
  "                     char(64) collate utf8mb3_bin DEFAULT NULL\n"
  "                     AFTER character_set_client;\n",
"ALTER TABLE proc MODIFY collation_connection\n"
  "                        char(64) collate utf8mb3_bin DEFAULT NULL;\n",
"SELECT CASE WHEN COUNT(*) > 0 THEN\n"
  "CONCAT (\"WARNING: NULL values of the 'collation_connection' column ('mysql.proc' table) have been updated with a default value (\", @@collation_connection, \"). Please verify if necessary.\")\n"
  "ELSE NULL\n"
  "END\n"
  "AS value FROM proc WHERE collation_connection IS NULL;\n",
"UPDATE proc SET collation_connection = @@collation_connection\n"
  "                     WHERE collation_connection IS NULL;\n",
"ALTER TABLE proc ADD db_collation\n"
  "                     char(64) collate utf8mb3_bin DEFAULT NULL\n"
  "                     AFTER collation_connection;\n",
"ALTER TABLE proc MODIFY db_collation\n"
  "                        char(64) collate utf8mb3_bin DEFAULT NULL;\n",
"SELECT CASE WHEN COUNT(*) > 0 THEN\n"
  "CONCAT (\"WARNING: NULL values of the 'db_collation' column ('mysql.proc' table) have been updated with default values. Please verify if necessary.\")\n"
  "ELSE NULL\n"
  "END\n"
  "AS value FROM proc WHERE db_collation IS NULL;\n",
"UPDATE proc AS p SET db_collation  =\n"
  "                     ( SELECT DEFAULT_COLLATION_NAME\n"
  "                       FROM INFORMATION_SCHEMA.SCHEMATA\n"
  "                       WHERE SCHEMA_NAME = p.db)\n"
  "                     WHERE db_collation IS NULL;\n",
"ALTER TABLE proc ADD body_utf8 longblob DEFAULT NULL\n"
  "                     AFTER db_collation;\n",
"ALTER TABLE proc MODIFY body_utf8 longblob DEFAULT NULL;\n",
"ALTER TABLE proc MODIFY comment\n"
  "                        text collate utf8mb3_bin NOT NULL;\n",
"ALTER TABLE proc ADD aggregate enum('NONE', 'GROUP') DEFAULT 'NONE' NOT NULL\n"
  "                     AFTER body_utf8;\n",
"ALTER TABLE proc ADD path text COLLATE utf8mb3_bin DEFAULT 'CURRENT_SCHEMA' NOT NULL\n"
  "                     AFTER aggregate;\n",
"ALTER TABLE proc MODIFY path TEXT COLLATE utf8mb3_bin DEFAULT 'CURRENT_SCHEMA' NOT NULL;\n",
"UPDATE proc SET Definer = 'mariadb.sys@localhost' WHERE Definer = 'root@localhost' AND Name = 'AddGeometryColumn';\n",
"UPDATE proc SET Definer = 'mariadb.sys@localhost' WHERE Definer = 'root@localhost' AND Name = 'DropGeometryColumn';\n",
"SET @hadEventPriv := 0;\n",
"SELECT @hadEventPriv :=1 FROM user WHERE Event_priv IS NOT NULL;\n",
"ALTER TABLE user ADD Event_priv enum('N','Y') character set utf8mb3 COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Create_user_priv;\n",
"ALTER TABLE user MODIFY Event_priv enum('N','Y') character set utf8mb3 COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Create_user_priv;\n",
"UPDATE user SET Event_priv=Super_priv WHERE @hadEventPriv = 0;\n",
"ALTER TABLE db ADD Event_priv enum('N','Y') character set utf8mb3 COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL;\n",
"ALTER TABLE db MODIFY Event_priv enum('N','Y') character set utf8mb3 COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL;\n",
"ALTER TABLE event DROP PRIMARY KEY, ADD PRIMARY KEY(db, name);\n",
"ALTER TABLE event ADD sql_mode set ('IGNORE_BAD_TABLE_OPTIONS') AFTER on_completion;\n",
"ALTER TABLE event MODIFY sql_mode\n"
  "                        set('REAL_AS_FLOAT',\n"
  "                            'PIPES_AS_CONCAT',\n"
  "                            'ANSI_QUOTES',\n"
  "                            'IGNORE_SPACE',\n"
  "                            'IGNORE_BAD_TABLE_OPTIONS',\n"
  "                            'ONLY_FULL_GROUP_BY',\n"
  "                            'NO_UNSIGNED_SUBTRACTION',\n"
  "                            'NO_DIR_IN_CREATE',\n"
  "                            'POSTGRESQL',\n"
  "                            'ORACLE',\n"
  "                            'MSSQL',\n"
  "                            'DB2',\n"
  "                            'MAXDB',\n"
  "                            'NO_KEY_OPTIONS',\n"
  "                            'NO_TABLE_OPTIONS',\n"
  "                            'NO_FIELD_OPTIONS',\n"
  "                            'MYSQL323',\n"
  "                            'MYSQL40',\n"
  "                            'ANSI',\n"
  "                            'NO_AUTO_VALUE_ON_ZERO',\n"
  "                            'NO_BACKSLASH_ESCAPES',\n"
  "                            'STRICT_TRANS_TABLES',\n"
  "                            'STRICT_ALL_TABLES',\n"
  "                            'NO_ZERO_IN_DATE',\n"
  "                            'NO_ZERO_DATE',\n"
  "                            'INVALID_DATES',\n"
  "                            'ERROR_FOR_DIVISION_BY_ZERO',\n"
  "                            'TRADITIONAL',\n"
  "                            'NO_AUTO_CREATE_USER',\n"
  "                            'HIGH_NOT_PRECEDENCE',\n"
  "                            'NO_ENGINE_SUBSTITUTION',\n"
  "                            'PAD_CHAR_TO_FULL_LENGTH',\n"
  "                            'EMPTY_STRING_IS_NULL',\n"
  "                            'SIMULTANEOUS_ASSIGNMENT',\n"
  "                            'TIME_ROUND_FRACTIONAL'\n"
  "                            ) DEFAULT '' NOT NULL AFTER on_completion;\n",
"ALTER TABLE event MODIFY name char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL default '';\n",
"ALTER TABLE event MODIFY db  CHAR(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL DEFAULT '';\n",
"ALTER TABLE event MODIFY interval_field\n"
  "                          enum('YEAR','QUARTER','MONTH','DAY','HOUR',\n"
  "                               'MINUTE','WEEK','SECOND','MICROSECOND',\n"
  "                               'YEAR_MONTH','DAY_HOUR','DAY_MINUTE',\n"
  "                               'DAY_SECOND','HOUR_MINUTE','HOUR_SECOND',\n"
  "                               'MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND',\n"
  "                               'MINUTE_MICROSECOND','SECOND_MICROSECOND'\n"
  "                          ) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL;\n",
"ALTER TABLE event MODIFY comment CHAR(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL DEFAULT '';\n",
"ALTER TABLE event MODIFY on_completion enum('DROP','PRESERVE')\n"
  "      CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'DROP';\n",
"ALTER TABLE event ADD COLUMN originator INT UNSIGNED NOT NULL AFTER comment;\n",
"ALTER TABLE event MODIFY COLUMN originator INT UNSIGNED NOT NULL;\n",
"ALTER TABLE event MODIFY COLUMN status ENUM('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL default 'ENABLED';\n",
"ALTER TABLE event ADD COLUMN time_zone char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci\n"
  "        NOT NULL DEFAULT 'SYSTEM' AFTER originator;\n",
"ALTER TABLE event ADD character_set_client\n"
  "                      char(32) collate utf8mb3_bin DEFAULT NULL\n"
  "                      AFTER time_zone;\n",
"ALTER TABLE event MODIFY character_set_client\n"
  "                         char(32) collate utf8mb3_bin DEFAULT NULL;\n",
"ALTER TABLE event ADD collation_connection\n"
  "                      char(64) collate utf8mb3_bin DEFAULT NULL\n"
  "                      AFTER character_set_client;\n",
"ALTER TABLE event MODIFY collation_connection\n"
  "                         char(64) collate utf8mb3_bin DEFAULT NULL;\n",
"ALTER TABLE event ADD db_collation\n"
  "                      char(64) collate utf8mb3_bin DEFAULT NULL\n"
  "                      AFTER collation_connection;\n",
"ALTER TABLE event MODIFY db_collation\n"
  "                         char(64) collate utf8mb3_bin DEFAULT NULL;\n",
"ALTER TABLE event ADD body_utf8 longblob DEFAULT NULL\n"
  "                      AFTER db_collation;\n",
"ALTER TABLE event MODIFY body_utf8 longblob DEFAULT NULL;\n",
"alter table event MODIFY definer varchar(384) collate utf8mb3_bin NOT NULL DEFAULT '';\n",
"set global event_scheduler=original;\n",
"SET @hadTriggerPriv := 0;\n",
"SELECT @hadTriggerPriv :=1 FROM user WHERE Trigger_priv IS NOT NULL;\n",
"ALTER TABLE user ADD Trigger_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Event_priv;\n",
"ALTER TABLE user MODIFY Trigger_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Event_priv;\n",
"ALTER TABLE db ADD Trigger_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL;\n",
"ALTER TABLE db MODIFY Trigger_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL;\n",
"UPDATE user SET Trigger_priv=Super_priv WHERE @hadTriggerPriv = 0;\n",
"SET @hadCreateTablespacePriv := 0;\n",
"SELECT @hadCreateTablespacePriv :=1 FROM user WHERE Create_tablespace_priv IS NOT NULL;\n",
"ALTER TABLE user ADD Create_tablespace_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Trigger_priv;\n",
"ALTER TABLE user MODIFY Create_tablespace_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER Trigger_priv;\n",
"UPDATE user SET Create_tablespace_priv = Super_priv WHERE @hadCreateTablespacePriv = 0;\n",
"ALTER TABLE user change Truncate_versioning_priv Delete_history_priv enum('N','Y') COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N';\n",
"ALTER TABLE db change Truncate_versioning_priv Delete_history_priv enum('N','Y') COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N';\n",
"SET @had_user_delete_history_priv := 0;\n",
"SELECT @had_user_delete_history_priv :=1 FROM user WHERE Delete_history_priv IS NOT NULL;\n",
"SET @had_show_create_routine := 0;\n",
"SELECT @had_show_create_routine:=1 FROM db WHERE Show_create_routine_priv IS NOT NULL;\n",
"ALTER TABLE user add Delete_history_priv enum('N','Y') COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N' after Create_tablespace_priv;\n",
"ALTER TABLE user modify Delete_history_priv enum('N','Y') COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N';\n",
"ALTER TABLE db add Delete_history_priv enum('N','Y') COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N' after Trigger_priv;\n",
"ALTER TABLE db modify Delete_history_priv enum('N','Y') COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N';\n",
"UPDATE user SET Delete_history_priv = Super_priv WHERE @had_user_delete_history_priv = 0;\n",
"ALTER TABLE db ADD    Show_create_routine_priv enum('N','Y') COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N' AFTER Delete_history_priv;\n",
"ALTER TABLE db MODIFY Show_create_routine_priv enum('N','Y') COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'N';\n",
"UPDATE db SET Show_create_routine_priv='Y' WHERE @had_show_create_routine=0\n"
  "  AND Drop_priv='Y' AND Index_priv='Y' AND Alter_priv='Y'\n"
  "  AND Event_priv='Y' AND Select_priv='Y' AND Insert_priv='Y'\n"
  "  AND Update_priv='Y' AND Delete_priv='Y' AND Create_priv='Y'\n"
  "  AND Execute_priv='Y' AND Trigger_priv='Y' AND Show_view_priv='Y'\n"
  "  AND References_priv='Y' AND Lock_tables_priv='Y' AND Create_view_priv='Y'\n"
  "  AND Alter_routine_priv='Y' AND Create_routine_priv='Y'\n"
  "  AND Delete_history_priv='Y' AND Create_tmp_table_priv='Y';\n",
"ALTER TABLE user ADD plugin char(64) CHARACTER SET latin1 DEFAULT '' NOT NULL AFTER max_user_connections,\n"
  "                 ADD authentication_string TEXT NOT NULL AFTER plugin;\n",
"ALTER TABLE user CHANGE auth_string authentication_string TEXT NOT NULL;\n",
"ALTER TABLE user ADD password_expired ENUM('N', 'Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER authentication_string;\n",
"ALTER TABLE user ADD password_last_changed timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP after password_expired;\n",
"ALTER TABLE user ADD password_lifetime smallint unsigned DEFAULT NULL after password_last_changed;\n",
"ALTER TABLE user ADD account_locked enum('N', 'Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL after password_lifetime;\n",
"ALTER TABLE user ADD is_role enum('N', 'Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER account_locked;\n",
"ALTER TABLE user ADD default_role char(128) binary DEFAULT '' NOT NULL AFTER is_role;\n",
"ALTER TABLE user ADD max_statement_time decimal(12,6) DEFAULT 0 NOT NULL AFTER default_role;\n",
"ALTER TABLE user MODIFY plugin char(64) CHARACTER SET latin1 DEFAULT '' NOT NULL AFTER max_user_connections,\n"
  "                 MODIFY authentication_string TEXT NOT NULL AFTER plugin,\n"
  "                 MODIFY password_expired ENUM('N', 'Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER authentication_string,\n"
  "                 MODIFY is_role enum('N', 'Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL AFTER password_expired,\n"
  "                 MODIFY default_role char(80) binary DEFAULT '' NOT NULL AFTER is_role,\n"
  "                 MODIFY max_statement_time decimal(12,6) DEFAULT 0 NOT NULL AFTER default_role,\n"
  "                 MODIFY IF EXISTS password_last_changed timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP AFTER max_statement_time,\n"
  "                 MODIFY IF EXISTS password_lifetime smallint unsigned DEFAULT NULL AFTER password_last_changed,\n"
  "                 MODIFY IF EXISTS account_locked enum('N', 'Y') CHARACTER SET utf8mb3 DEFAULT 'N' NOT NULL after password_lifetime;\n",
"DELIMITER //\n",
"BEGIN NOT ATOMIC\n"
  "  SET @duplicate_hosts=(SELECT count(*) FROM mysql.user GROUP BY user, lower(host) HAVING count(*) > 1 LIMIT 1);\n"
  "  IF @duplicate_hosts > 1 THEN\n"
  "    SIGNAL SQLSTATE '45000'  SET MESSAGE_TEXT = 'Multiple accounts exist for @user_name, @host_name that differ only in Host lettercase; remove all except one of them';\n"
  "  END IF;\n"
  "END //\n",
"DELIMITER ;\n",
"SHOW WARNINGS;\n",
"UPDATE user SET host=LOWER( host ) WHERE LOWER( host ) <> host;\n",
"DELIMITER //\n",
"if @have_innodb then\n"
  "  # fix bad data when upgrading from unfixed InnoDB (MDEV-13360)\n"
  "  delete from innodb_index_stats where length(table_name) > 64;\n"
  "  delete from innodb_table_stats where length(table_name) > 64;\n"
  "  # update table_name and timestamp fields in the innodb stat tables\n"
  "  alter table innodb_index_stats modify last_update timestamp not null default current_timestamp on update current_timestamp, modify table_name varchar(199);\n"
  "  alter table innodb_table_stats modify last_update timestamp not null default current_timestamp on update current_timestamp, modify table_name varchar(199);\n"
  "  alter table innodb_index_stats drop foreign key if exists innodb_index_stats_ibfk_1;\n"
  "end if //\n",
"DELIMITER ;\n",
"alter table user         modify User         char(128)  binary not null default '';\n",
"alter table db           modify User         char(128)  binary not null default '';\n",
"alter table tables_priv  modify User         char(128)  binary not null default '';\n",
"alter table columns_priv modify User         char(128)  binary not null default '';\n",
"alter table procs_priv   modify User         char(128)  binary not null default '', modify Host char(255) binary DEFAULT '';\n",
"alter table proc         modify definer      varchar(384) collate utf8mb3_bin not null default '';\n",
"alter table proxies_priv modify User         char(128)  COLLATE utf8mb3_bin not null default '', modify Host char(255) binary DEFAULT '';\n",
"alter table proxies_priv modify Proxied_user char(128)  COLLATE utf8mb3_bin not null default '';\n",
"alter table proxies_priv modify Grantor      varchar(384) COLLATE utf8mb3_bin not null default '';\n",
"alter table servers      modify Username     char(128)                   not null default '';\n",
"alter table procs_priv   modify Grantor      varchar(384) COLLATE utf8mb3_bin not null default '';\n",
"alter table tables_priv  modify Grantor      varchar(384) COLLATE utf8mb3_bin not null default '';\n",
"alter table if exists global_priv modify Host char(255) binary DEFAULT '', modify User char(128)  binary not null default '';\n",
"alter table if exists roles_mapping modify Host char(255) binary not null DEFAULT '', modify User char(128)  binary not null default '';\n",
"flush privileges;\n",
"ALTER TABLE help_category MODIFY url TEXT NOT NULL;\n",
"ALTER TABLE help_topic MODIFY url TEXT NOT NULL;\n",
"DELIMITER //\n",
"IF 'BASE TABLE' = (select table_type from information_schema.tables where table_schema=database() and table_name='user') THEN\n"
  "  CREATE TABLE IF NOT EXISTS global_priv (Host char(255) binary DEFAULT '', User char(128) binary DEFAULT '', Priv JSON NOT NULL DEFAULT '{}' CHECK(JSON_VALID(Priv)), PRIMARY KEY Host (Host,User)) engine=Aria transactional=1 CHARACTER SET utf8mb3 COLLATE utf8mb3_bin comment='Users and global privileges'\n"
  "  SELECT Host, User, JSON_COMPACT(JSON_OBJECT('access',\n"
  "                             1*('Y'=Select_priv)+\n"
  "                             2*('Y'=Insert_priv)+\n"
  "                             4*('Y'=Update_priv)+\n"
  "                             8*('Y'=Delete_priv)+\n"
  "                            16*('Y'=Create_priv)+\n"
  "                            32*('Y'=Drop_priv)+\n"
  "                            64*('Y'=Reload_priv)+\n"
  "                           128*('Y'=Shutdown_priv)+\n"
  "                           256*('Y'=Process_priv)+\n"
  "                           512*('Y'=File_priv)+\n"
  "                          1024*('Y'=Grant_priv)+\n"
  "                          2048*('Y'=References_priv)+\n"
  "                          4096*('Y'=Index_priv)+\n"
  "                          8192*('Y'=Alter_priv)+\n"
  "                         16384*('Y'=Show_db_priv)+\n"
  "                         32768*('Y'=Super_priv)+\n"
  "                         65536*('Y'=Create_tmp_table_priv)+\n"
  "                        131072*('Y'=Lock_tables_priv)+\n"
  "                        262144*('Y'=Execute_priv)+\n"
  "                        524288*('Y'=Repl_slave_priv)+\n"
  "                       1048576*('Y'=Repl_client_priv)+\n"
  "                       2097152*('Y'=Create_view_priv)+\n"
  "                       4194304*('Y'=Show_view_priv)+\n"
  "                       8388608*('Y'=Create_routine_priv)+\n"
  "                      16777216*('Y'=Alter_routine_priv)+\n"
  "                      33554432*('Y'=Create_user_priv)+\n"
  "                      67108864*('Y'=Event_priv)+\n"
  "                     134217728*('Y'=Trigger_priv)+\n"
  "                     268435456*('Y'=Create_tablespace_priv)+\n"
  "                     536870912*('Y'=Delete_history_priv),\n"
  "                    'ssl_type', ssl_type-1,\n"
  "                    'ssl_cipher', ssl_cipher,\n"
  "                    'x509_issuer', x509_issuer,\n"
  "                    'x509_subject', x509_subject,\n"
  "                    'max_questions', max_questions,\n"
  "                    'max_updates', max_updates,\n"
  "                    'max_connections', max_connections,\n"
  "                    'max_user_connections', max_user_connections,\n"
  "                    'max_statement_time', max_statement_time,\n"
  "                    'plugin', if(plugin>'',plugin,if(length(password)=16,'mysql_old_password','mysql_native_password')),\n"
  "                    'authentication_string', if(plugin>'' and authentication_string>'',authentication_string,password),\n"
  "                    'password_last_changed', if(password_expired='Y', 0, if(password_last_changed, UNIX_TIMESTAMP(password_last_changed), UNIX_TIMESTAMP())),\n"
  "                    'password_lifetime', ifnull(password_lifetime, -1),\n"
  "                    'account_locked', 'Y'=account_locked,\n"
  "                    'default_role', default_role,\n"
  "                    'is_role', 'Y'=is_role)) as Priv\n"
  "  FROM user;\n"
  "  DROP TABLE user;\n"
  "END IF//\n",
"IF 1 = (SELECT count(*) FROM information_schema.VIEWS WHERE TABLE_CATALOG = 'def' and TABLE_SCHEMA = 'mysql' and TABLE_NAME='user' and (DEFINER = 'root@localhost' or (DEFINER = 'mariadb.sys@localhost' and VIEW_DEFINITION LIKE \"%'N' AS `password_expired`%\"))) THEN\n"
  "  DROP VIEW IF EXISTS mysql.user;\n"
  "END IF//\n",
"DELIMITER ;\n",
"ALTER TABLE servers\n"
  "  MODIFY Host varchar(2048) NOT NULL DEFAULT '',\n"
  "  MODIFY Owner varchar(512) NOT NULL DEFAULT '';\n",
"ALTER TABLE servers\n"
  "  MODIFY Socket char(108) NOT NULL DEFAULT '';\n",
"SET @hadOptions:=0;\n",
"SELECT @hadOptions:=1 FROM servers WHERE options IS NOT NULL;\n",
"ALTER TABLE servers\n"
  "  ADD Options JSON NOT NULL DEFAULT '{}' CHECK(JSON_VALID(Options));\n",
"ALTER TABLE servers\n"
  "  MODIFY Options JSON  NOT NULL DEFAULT '{}' CHECK(JSON_VALID(Options));\n",
"UPDATE servers SET Options = JSON_INSERT(Options, '$.host', Host) WHERE Host <> '' AND @hadOptions = 0;\n",
"UPDATE servers SET Options = JSON_INSERT(Options, '$.database', Db) WHERE Db <> '' AND @hadOptions = 0;\n",
"UPDATE servers SET Options = JSON_INSERT(Options, '$.username', Username) WHERE Username <> '' AND @hadOptions = 0;\n",
"UPDATE servers SET Options = JSON_INSERT(Options, '$.port', CAST(Port AS VARCHAR(5))) WHERE @hadOptions = 0;\n",
"UPDATE servers SET Options = JSON_INSERT(Options, '$.socket', Socket) WHERE Socket <> '' AND @hadOptions = 0;\n",
"UPDATE servers SET Options = JSON_INSERT(Options, '$.owner', Owner) WHERE Owner <> '' AND @hadOptions = 0;\n",
"SET NAMES latin1 COLLATE latin1_swedish_ci;\n",
"set sql_mode='';\n",
"set @orig_storage_engine=@@default_storage_engine;\n",
"set default_storage_engine=Aria;\n",
"set system_versioning_alter_history=keep;\n",
"set @have_innodb= (select count(engine) from information_schema.engines where engine='INNODB' and support != 'NO');\n",
"SET @innodb_or_aria=IF(@have_innodb <> 0, 'InnoDB', 'Aria');\n",
"CREATE TABLE IF NOT EXISTS db (   Host char(255) binary DEFAULT '' NOT NULL, Db char(64) binary DEFAULT '' NOT NULL, User char(128) binary DEFAULT '' NOT NULL, Select_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Insert_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Update_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Delete_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Create_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Drop_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Grant_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, References_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Index_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Alter_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Create_tmp_table_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Lock_tables_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Create_view_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Show_view_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Create_routine_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Alter_routine_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Execute_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Event_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Trigger_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Delete_history_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, Show_create_routine_priv enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, PRIMARY KEY /*Host */(Host,Db,User), KEY User (User) ) engine=Aria transactional=1 CHARACTER SET utf8mb3 COLLATE utf8mb3_bin comment='Database privileges';\n",
"set @had_db_table= @@warning_count != 0;\n",
"CREATE TABLE IF NOT EXISTS global_priv (Host char(255) binary DEFAULT '', User char(128) binary DEFAULT '', Priv JSON NOT NULL DEFAULT '{}' CHECK(JSON_VALID(Priv)), PRIMARY KEY (Host,User)) engine=Aria transactional=1 CHARACTER SET utf8mb3 COLLATE utf8mb3_bin comment='Users and global privileges';\n",
"set @exists_user_view= EXISTS (SELECT * FROM information_schema.VIEWS WHERE TABLE_CATALOG = 'def' and TABLE_SCHEMA = 'mysql' and TABLE_NAME='user');\n",
"set @exists_user_view_by_root= EXISTS (SELECT * FROM information_schema.VIEWS WHERE TABLE_CATALOG = 'def' and TABLE_SCHEMA = 'mysql' and TABLE_NAME='user' and DEFINER = 'mariadb.sys@localhost');\n",
"set @need_sys_user_creation= (( NOT @exists_user_view) OR @exists_user_view_by_root);\n",
"CREATE TEMPORARY TABLE tmp_user_sys LIKE global_priv;\n",
"INSERT INTO tmp_user_sys (Host,User,Priv) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}');\n",
"INSERT IGNORE INTO global_priv SELECT * FROM tmp_user_sys WHERE 0 <> @need_sys_user_creation;\n",
"DROP TABLE tmp_user_sys;\n",
"CREATE DEFINER='mariadb.sys'@'localhost' SQL SECURITY DEFINER VIEW IF NOT EXISTS user AS SELECT\n"
  "  Host,\n"
  "  User,\n"
  "  IF(JSON_VALUE(Priv, '$.plugin') IN ('mysql_native_password', 'mysql_old_password'), IFNULL(JSON_VALUE(Priv, '$.authentication_string'), ''), '') AS Password,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &         1, 'Y', 'N') AS Select_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &         2, 'Y', 'N') AS Insert_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &         4, 'Y', 'N') AS Update_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &         8, 'Y', 'N') AS Delete_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &        16, 'Y', 'N') AS Create_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &        32, 'Y', 'N') AS Drop_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &        64, 'Y', 'N') AS Reload_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &       128, 'Y', 'N') AS Shutdown_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &       256, 'Y', 'N') AS Process_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &       512, 'Y', 'N') AS File_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &      1024, 'Y', 'N') AS Grant_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &      2048, 'Y', 'N') AS References_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &      4096, 'Y', 'N') AS Index_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &      8192, 'Y', 'N') AS Alter_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &     16384, 'Y', 'N') AS Show_db_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &     32768, 'Y', 'N') AS Super_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &     65536, 'Y', 'N') AS Create_tmp_table_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &    131072, 'Y', 'N') AS Lock_tables_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &    262144, 'Y', 'N') AS Execute_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &    524288, 'Y', 'N') AS Repl_slave_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &   1048576, 'Y', 'N') AS Repl_client_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &   2097152, 'Y', 'N') AS Create_view_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &   4194304, 'Y', 'N') AS Show_view_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &   8388608, 'Y', 'N') AS Create_routine_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &  16777216, 'Y', 'N') AS Alter_routine_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &  33554432, 'Y', 'N') AS Create_user_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') &  67108864, 'Y', 'N') AS Event_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') & 134217728, 'Y', 'N') AS Trigger_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') & 268435456, 'Y', 'N') AS Create_tablespace_priv,\n"
  "  IF(JSON_VALUE(Priv, '$.access') & 536870912, 'Y', 'N') AS Delete_history_priv,\n"
  "  ELT(IFNULL(JSON_VALUE(Priv, '$.ssl_type'), 0) + 1, '', 'ANY','X509', 'SPECIFIED') AS ssl_type,\n"
  "  IFNULL(JSON_VALUE(Priv, '$.ssl_cipher'), '') AS ssl_cipher,\n"
  "  IFNULL(JSON_VALUE(Priv, '$.x509_issuer'), '') AS x509_issuer,\n"
  "  IFNULL(JSON_VALUE(Priv, '$.x509_subject'), '') AS x509_subject,\n"
  "  CAST(IFNULL(JSON_VALUE(Priv, '$.max_questions'), 0) AS UNSIGNED) AS max_questions,\n"
  "  CAST(IFNULL(JSON_VALUE(Priv, '$.max_updates'), 0) AS UNSIGNED) AS max_updates,\n"
  "  CAST(IFNULL(JSON_VALUE(Priv, '$.max_connections'), 0) AS UNSIGNED) AS max_connections,\n"
  "  CAST(IFNULL(JSON_VALUE(Priv, '$.max_user_connections'), 0) AS SIGNED) AS max_user_connections,\n"
  "  IFNULL(JSON_VALUE(Priv, '$.plugin'), '') AS plugin,\n"
  "  IFNULL(JSON_VALUE(Priv, '$.authentication_string'), '') AS authentication_string,\n"
  "  IF(IFNULL(JSON_VALUE(Priv, '$.password_last_changed'), 1) = 0, 'Y', 'N') AS password_expired,\n"
  "  ELT(IFNULL(JSON_VALUE(Priv, '$.is_role'), 0) + 1, 'N', 'Y') AS is_role,\n"
  "  IFNULL(JSON_VALUE(Priv, '$.default_role'), '') AS default_role,\n"
  "  CAST(IFNULL(JSON_VALUE(Priv, '$.max_statement_time'), 0.0) AS DECIMAL(12,6)) AS max_statement_time\n"
  "  FROM global_priv;\n",
"set @had_user_table= @@warning_count != 0;\n",
"CREATE TABLE IF NOT EXISTS roles_mapping ( Host char(255) binary DEFAULT '' NOT NULL, User char(128) binary DEFAULT '' NOT NULL, Role char(128) binary DEFAULT '' NOT NULL, Admin_option enum('N','Y') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, UNIQUE (Host, User, Role)) engine=Aria transactional=1 CHARACTER SET utf8mb3 COLLATE utf8mb3_bin comment='Granted roles';\n",
"CREATE TABLE IF NOT EXISTS func (  name char(64) binary DEFAULT '' NOT NULL, ret tinyint(1) DEFAULT '0' NOT NULL, dl char(128) DEFAULT '' NOT NULL, type enum ('function','aggregate') COLLATE utf8mb3_general_ci NOT NULL, PRIMARY KEY (name) ) engine=Aria transactional=1 CHARACTER SET utf8mb3 COLLATE utf8mb3_bin   comment='User defined functions';\n",
"CREATE TABLE IF NOT EXISTS plugin ( name varchar(64) DEFAULT '' NOT NULL, dl varchar(128) DEFAULT '' NOT NULL, PRIMARY KEY (name) ) engine=Aria transactional=1 CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci comment='MySQL plugins';\n",
"CREATE TABLE IF NOT EXISTS servers ( Server_name char(64) NOT NULL DEFAULT '', Host varchar(2048) NOT NULL DEFAULT '', Db char(64) NOT NULL DEFAULT '', Username char(128) NOT NULL DEFAULT '', Password char(64) NOT NULL DEFAULT '', Port INT(4) NOT NULL DEFAULT '0', Socket char(108) NOT NULL DEFAULT '', Wrapper char(64) NOT NULL DEFAULT '', Owner varchar(512) NOT NULL DEFAULT '', PRIMARY KEY (Server_name), Options JSON NOT NULL DEFAULT '{}' CHECK(JSON_VALID(Options))) engine=Aria transactional=1 CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci comment='MySQL Foreign Servers table';\n",
"CREATE TABLE IF NOT EXISTS tables_priv ( Host char(255) binary DEFAULT '' NOT NULL, Db char(64) binary DEFAULT '' NOT NULL, User char(128) binary DEFAULT '' NOT NULL, Table_name char(64) binary DEFAULT '' NOT NULL, Grantor varchar(384) DEFAULT '' NOT NULL, Timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, Table_priv set('Select','Insert','Update','Delete','Create','Drop','Grant','References','Index','Alter','Create View','Show view','Trigger','Delete versioning rows') COLLATE utf8mb3_general_ci DEFAULT '' NOT NULL, Column_priv set('Select','Insert','Update','References') COLLATE utf8mb3_general_ci DEFAULT '' NOT NULL, PRIMARY KEY (Host,Db,User,Table_name), KEY Grantor (Grantor) ) engine=Aria transactional=1 CHARACTER SET utf8mb3 COLLATE utf8mb3_bin   comment='Table privileges';\n",
"CREATE TEMPORARY TABLE tmp_user_sys LIKE tables_priv;\n",
"INSERT INTO tmp_user_sys (Host,Db,User,Table_name,Grantor,Timestamp,Table_priv) VALUES ('localhost','mysql','mariadb.sys','global_priv','root@localhost','0','Select,Delete');\n",
"INSERT IGNORE INTO tables_priv SELECT * FROM tmp_user_sys WHERE 0 <> @need_sys_user_creation;\n",
"DROP TABLE tmp_user_sys;\n",
"CREATE TABLE IF NOT EXISTS columns_priv ( Host char(255) binary DEFAULT '' NOT NULL, Db char(64) binary DEFAULT '' NOT NULL, User char(128) binary DEFAULT '' NOT NULL, Table_name char(64) binary DEFAULT '' NOT NULL, Column_name char(64) binary DEFAULT '' NOT NULL, Timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, Column_priv set('Select','Insert','Update','References') COLLATE utf8mb3_general_ci DEFAULT '' NOT NULL, PRIMARY KEY (Host,Db,User,Table_name,Column_name) ) engine=Aria transactional=1 CHARACTER SET utf8mb3 COLLATE utf8mb3_bin   comment='Column privileges';\n",
"CREATE TABLE IF NOT EXISTS help_topic ( help_topic_id int unsigned not null, name char(64) not null, help_category_id smallint unsigned not null, description text not null, example text not null, url text not null, primary key (help_topic_id), unique index (name) ) engine=Aria transactional=0 CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci comment='help topics';\n",
"CREATE TABLE IF NOT EXISTS help_category ( help_category_id smallint unsigned not null, name  char(64) not null, parent_category_id smallint unsigned null, url text not null, primary key (help_category_id), unique index (name) ) engine=Aria transactional=0 CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci comment='help categories';\n",
"CREATE TABLE IF NOT EXISTS help_relation ( help_topic_id int unsigned not null references help_topic, help_keyword_id  int unsigned not null references help_keyword, primary key (help_keyword_id, help_topic_id) ) engine=Aria transactional=0 CHARACTER SET utf8mb3 CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci comment='keyword-topic relation';\n",
"CREATE TABLE IF NOT EXISTS help_keyword (   help_keyword_id  int unsigned not null, name char(64) not null, primary key (help_keyword_id), unique index (name) ) engine=Aria transactional=0 CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci comment='help keywords';\n",
"CREATE TABLE IF NOT EXISTS time_zone_name (   Name char(64) NOT NULL, Time_zone_id int unsigned NOT NULL, PRIMARY KEY /*Name*/ (Name) ) engine=Aria transactional=1 CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci comment='Time zone names';\n",
"CREATE TABLE IF NOT EXISTS time_zone (   Time_zone_id int unsigned NOT NULL auto_increment, Use_leap_seconds enum('Y','N') COLLATE utf8mb3_general_ci DEFAULT 'N' NOT NULL, PRIMARY KEY /*TzId*/ (Time_zone_id) ) engine=Aria transactional=1 CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci comment='Time zones';\n",
"CREATE TABLE IF NOT EXISTS time_zone_transition (   Time_zone_id int unsigned NOT NULL, Transition_time bigint signed NOT NULL, Transition_type_id int unsigned NOT NULL, PRIMARY KEY /*TzIdTranTime*/ (Time_zone_id, Transition_time) ) engine=Aria transactional=1 CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci comment='Time zone transitions';\n",
"CREATE TABLE IF NOT EXISTS time_zone_transition_type (   Time_zone_id int unsigned NOT NULL, Transition_type_id int unsigned NOT NULL, `Offset` int signed DEFAULT 0 NOT NULL, Is_DST tinyint unsigned DEFAULT 0 NOT NULL, Abbreviation char(8) DEFAULT '' NOT NULL, PRIMARY KEY /*TzIdTrTId*/ (Time_zone_id, Transition_type_id) ) engine=Aria transactional=1 CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci comment='Time zone transition types';\n",
"CREATE TABLE IF NOT EXISTS time_zone_leap_second (   Transition_time bigint signed NOT NULL, Correction int signed NOT NULL, PRIMARY KEY /*TranTime*/ (Transition_time) ) engine=Aria transactional=1 CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci  comment='Leap seconds information for time zones';\n",
"CREATE TABLE IF NOT EXISTS proc (db char(64) collate utf8mb3_bin DEFAULT '' NOT NULL, name char(64) DEFAULT '' NOT NULL, type enum('FUNCTION','PROCEDURE','PACKAGE','PACKAGE BODY') NOT NULL, specific_name char(64) DEFAULT '' NOT NULL, language enum('SQL') DEFAULT 'SQL' NOT NULL, sql_data_access enum( 'CONTAINS_SQL', 'NO_SQL', 'READS_SQL_DATA', 'MODIFIES_SQL_DATA') DEFAULT 'CONTAINS_SQL' NOT NULL, is_deterministic enum('YES','NO') DEFAULT 'NO' NOT NULL, security_type enum('INVOKER','DEFINER') DEFAULT 'DEFINER' NOT NULL, param_list blob NOT NULL, returns longblob NOT NULL, body longblob NOT NULL, definer varchar(384) collate utf8mb3_bin DEFAULT '' NOT NULL, created timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, modified timestamp NOT NULL DEFAULT '0000-00-00 00:00:00', sql_mode set( 'REAL_AS_FLOAT', 'PIPES_AS_CONCAT', 'ANSI_QUOTES', 'IGNORE_SPACE', 'IGNORE_BAD_TABLE_OPTIONS', 'ONLY_FULL_GROUP_BY', 'NO_UNSIGNED_SUBTRACTION', 'NO_DIR_IN_CREATE', 'POSTGRESQL', 'ORACLE', 'MSSQL', 'DB2', 'MAXDB', 'NO_KEY_OPTIONS', 'NO_TABLE_OPTIONS', 'NO_FIELD_OPTIONS', 'MYSQL323', 'MYSQL40', 'ANSI', 'NO_AUTO_VALUE_ON_ZERO', 'NO_BACKSLASH_ESCAPES', 'STRICT_TRANS_TABLES', 'STRICT_ALL_TABLES', 'NO_ZERO_IN_DATE', 'NO_ZERO_DATE', 'INVALID_DATES', 'ERROR_FOR_DIVISION_BY_ZERO', 'TRADITIONAL', 'NO_AUTO_CREATE_USER', 'HIGH_NOT_PRECEDENCE', 'NO_ENGINE_SUBSTITUTION', 'PAD_CHAR_TO_FULL_LENGTH', 'EMPTY_STRING_IS_NULL', 'SIMULTANEOUS_ASSIGNMENT', 'TIME_ROUND_FRACTIONAL') DEFAULT '' NOT NULL, comment text collate utf8mb3_bin NOT NULL, character_set_client char(32) collate utf8mb3_bin, collation_connection char(64) collate utf8mb3_bin, db_collation char(64) collate utf8mb3_bin, body_utf8 longblob, aggregate enum('NONE', 'GROUP') DEFAULT 'NONE' NOT NULL, path TEXT COLLATE utf8mb3_bin DEFAULT 'CURRENT_SCHEMA' NOT NULL, PRIMARY KEY (db,name,type)) engine=Aria transactional=1 character set utf8mb3 COLLATE utf8mb3_general_ci comment='Stored Procedures';\n",
"CREATE TABLE IF NOT EXISTS procs_priv ( Host char(255) binary DEFAULT '' NOT NULL, Db char(64) binary DEFAULT '' NOT NULL, User char(128) binary DEFAULT '' NOT NULL, Routine_name char(64) COLLATE utf8mb3_general_ci DEFAULT '' NOT NULL, Routine_type enum('FUNCTION','PROCEDURE','PACKAGE','PACKAGE BODY') NOT NULL, Grantor varchar(384) DEFAULT '' NOT NULL, Proc_priv set('Execute','Alter Routine','Grant','Show Create Routine') COLLATE utf8mb3_general_ci DEFAULT '' NOT NULL, Timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (Host,Db,User,Routine_name,Routine_type), KEY Grantor (Grantor) ) engine=Aria transactional=1 CHARACTER SET utf8mb3 COLLATE utf8mb3_bin   comment='Procedure privileges';\n",
"SET @have_csv = 'YES'=(SELECT support FROM information_schema.engines WHERE engine = 'CSV');\n",
"SET @str = IF (@have_csv, 'CREATE TABLE IF NOT EXISTS general_log (event_time TIMESTAMP(6) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, user_host MEDIUMTEXT NOT NULL, thread_id BIGINT(21) UNSIGNED NOT NULL, server_id INTEGER UNSIGNED NOT NULL, command_type VARCHAR(64) NOT NULL, argument MEDIUMTEXT NOT NULL) engine=CSV CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci comment=\"General log\"', 'SET @dummy = 0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @str = IF (@have_csv, 'CREATE TABLE IF NOT EXISTS slow_log (start_time TIMESTAMP(6) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, user_host MEDIUMTEXT NOT NULL, query_time TIME(6) NOT NULL, lock_time TIME(6) NOT NULL, rows_sent BIGINT UNSIGNED NOT NULL, rows_examined BIGINT UNSIGNED NOT NULL, db VARCHAR(512) NOT NULL, last_insert_id INTEGER NOT NULL, insert_id INTEGER NOT NULL, server_id INTEGER UNSIGNED NOT NULL, sql_text MEDIUMTEXT NOT NULL, thread_id BIGINT(21) UNSIGNED NOT NULL, rows_affected BIGINT UNSIGNED NOT NULL) engine=CSV CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci comment=\"Slow log\"', 'SET @dummy = 0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"CREATE TABLE IF NOT EXISTS event ( db char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL default '', name char(64) NOT NULL default '', body longblob NOT NULL, definer varchar(384) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL default '', execute_at DATETIME default NULL, interval_value int(11) default NULL, interval_field ENUM('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') default NULL, created TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, modified TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00', last_executed DATETIME default NULL, starts DATETIME default NULL, ends DATETIME default NULL, status ENUM('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL default 'ENABLED', on_completion ENUM('DROP','PRESERVE') NOT NULL default 'DROP', sql_mode  set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') DEFAULT '' NOT NULL, comment char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL default '', originator INTEGER UNSIGNED NOT NULL, time_zone char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM', character_set_client char(32) collate utf8mb3_bin, collation_connection char(64) collate utf8mb3_bin, db_collation char(64) collate utf8mb3_bin, body_utf8 longblob, PRIMARY KEY (db, name) ) engine=Aria transactional=1 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci COMMENT 'Events';\n",
"SET @create_innodb_table_stats=\"CREATE TABLE IF NOT EXISTS innodb_table_stats (\n"
  "	database_name			VARCHAR(64) NOT NULL,\n"
  "	table_name			VARCHAR(199) NOT NULL,\n"
  "	last_update			TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n"
  "	n_rows				BIGINT UNSIGNED NOT NULL,\n"
  "	clustered_index_size		BIGINT UNSIGNED NOT NULL,\n"
  "	sum_of_other_index_sizes	BIGINT UNSIGNED NOT NULL,\n"
  "	PRIMARY KEY (database_name, table_name)\n"
  ") ENGINE=INNODB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin STATS_PERSISTENT=0\";\n",
"SET @create_innodb_index_stats=\"CREATE TABLE IF NOT EXISTS innodb_index_stats (\n"
  "	database_name			VARCHAR(64) NOT NULL,\n"
  "	table_name			VARCHAR(199) NOT NULL,\n"
  "	index_name			VARCHAR(64) NOT NULL,\n"
  "	last_update			TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n"
  "	/* there are at least:\n"
  "	stat_name='size'\n"
  "	stat_name='n_leaf_pages'\n"
  "	stat_name='n_diff_pfx%' */\n"
  "	stat_name			VARCHAR(64) NOT NULL,\n"
  "	stat_value			BIGINT UNSIGNED NOT NULL,\n"
  "	sample_size			BIGINT UNSIGNED,\n"
  "	stat_description		VARCHAR(1024) NOT NULL,\n"
  "	PRIMARY KEY (database_name, table_name, index_name, stat_name)\n"
  ") ENGINE=INNODB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin STATS_PERSISTENT=0\";\n",
"SET @create_transaction_registry=\"CREATE TABLE IF NOT EXISTS transaction_registry (\n"
  "	transaction_id			BIGINT UNSIGNED NOT NULL,\n"
  "	commit_id			BIGINT UNSIGNED NOT NULL,\n"
  "	begin_timestamp			TIMESTAMP(6) NOT NULL DEFAULT '0000-00-00 00:00:00.000000',\n"
  "	commit_timestamp		TIMESTAMP(6) NOT NULL DEFAULT '0000-00-00 00:00:00.000000',\n"
  "	isolation_level			ENUM('READ-UNCOMMITTED', 'READ-COMMITTED',\n"
  "					'REPEATABLE-READ', 'SERIALIZABLE') NOT NULL,\n"
  "	PRIMARY KEY (transaction_id),\n"
  "	UNIQUE KEY (commit_id),\n"
  "	INDEX (begin_timestamp),\n"
  "	INDEX (commit_timestamp, transaction_id)\n"
  ") ENGINE=INNODB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin STATS_PERSISTENT=0\";\n",
"SET @str=IF(@have_innodb <> 0, @create_innodb_table_stats, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @str=IF(@have_innodb <> 0, @create_innodb_index_stats, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @str=IF(@have_innodb <> 0, @create_transaction_registry, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"CREATE TABLE IF NOT EXISTS slave_relay_log_info (\n"
  "  Number_of_lines INTEGER UNSIGNED NOT NULL COMMENT 'Number of lines in the file or rows in the table. Used to version table definitions.',\n"
  "  Relay_log_name TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL COMMENT 'The name of the current relay log file.',\n"
  "  Relay_log_pos BIGINT UNSIGNED NOT NULL COMMENT 'The relay log position of the last executed event.',\n"
  "  Master_log_name TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL COMMENT 'The name of the master binary log file from which the events in the relay log file were read.',\n"
  "  Master_log_pos BIGINT UNSIGNED NOT NULL COMMENT 'The master log position of the last executed event.',\n"
  "  Sql_delay INTEGER NOT NULL COMMENT 'The number of seconds that the slave must lag behind the master.',\n"
  "  Number_of_workers INTEGER UNSIGNED NOT NULL,\n"
  "  Id INTEGER UNSIGNED NOT NULL COMMENT 'Internal Id that uniquely identifies this record.',\n"
  "  PRIMARY KEY(Id)) DEFAULT CHARSET=utf8mb3 STATS_PERSISTENT=0 COMMENT 'Relay Log Information'\";\n",
"SET @str=CONCAT(@cmd, ' ENGINE=', @innodb_or_aria);\n",
"SET @cmd= \"CREATE TABLE IF NOT EXISTS slave_master_info (\n"
  "  Number_of_lines INTEGER UNSIGNED NOT NULL COMMENT 'Number of lines in the file.',\n"
  "  Master_log_name TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL COMMENT 'The name of the master binary log currently being read from the master.',\n"
  "  Master_log_pos BIGINT UNSIGNED NOT NULL COMMENT 'The master log position of the last read event.',\n"
  "  Host CHAR(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin COMMENT 'The host name of the master.',\n"
  "  User_name TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin COMMENT 'The user name used to connect to the master.',\n"
  "  User_password TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin COMMENT 'The password used to connect to the master.',\n"
  "  Port INTEGER UNSIGNED NOT NULL COMMENT 'The network port used to connect to the master.',\n"
  "  Connect_retry INTEGER UNSIGNED NOT NULL COMMENT 'The period (in seconds) that the slave will wait before trying to reconnect to the master.',\n"
  "  Enabled_ssl BOOLEAN NOT NULL COMMENT 'Indicates whether the server supports SSL connections.',\n"
  "  Ssl_ca TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin COMMENT 'The file used for the Certificate Authority (CA) certificate.',\n"
  "  Ssl_capath TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin COMMENT 'The path to the Certificate Authority (CA) certificates.',\n"
  "  Ssl_cert TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin COMMENT 'The name of the SSL certificate file.',\n"
  "  Ssl_cipher TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin COMMENT 'The name of the cipher in use for the SSL connection.',\n"
  "  Ssl_key TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin COMMENT 'The name of the SSL key file.',\n"
  "  Ssl_verify_server_cert BOOLEAN NOT NULL COMMENT 'Whether to verify the server certificate.',\n"
  "  Heartbeat FLOAT NOT NULL COMMENT '',\n"
  "  Bind TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin COMMENT 'Displays which interface is employed when connecting to the MySQL server',\n"
  "  Ignored_server_ids TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin COMMENT 'The number of server IDs to be ignored, followed by the actual server IDs',\n"
  "  Uuid TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin COMMENT 'The master server uuid.',\n"
  "  Retry_count BIGINT UNSIGNED NOT NULL COMMENT 'Number of reconnect attempts, to the master, before giving up.',\n"
  "  Ssl_crl TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin COMMENT 'The file used for the Certificate Revocation List (CRL)',\n"
  "  Ssl_crlpath TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin COMMENT 'The path used for Certificate Revocation List (CRL) files',\n"
  "  Enabled_auto_position BOOLEAN NOT NULL COMMENT 'Indicates whether GTIDs will be used to retrieve events from the master.',\n"
  "  PRIMARY KEY(Host, Port)) DEFAULT CHARSET=utf8mb3 STATS_PERSISTENT=0 COMMENT 'Master Information'\";\n",
"SET @str=CONCAT(@cmd, ' ENGINE=', @innodb_or_aria);\n",
"SET @cmd= \"CREATE TABLE IF NOT EXISTS slave_worker_info (\n"
  "  Id INTEGER UNSIGNED NOT NULL,\n"
  "  Relay_log_name TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,\n"
  "  Relay_log_pos BIGINT UNSIGNED NOT NULL,\n"
  "  Master_log_name TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,\n"
  "  Master_log_pos BIGINT UNSIGNED NOT NULL,\n"
  "  Checkpoint_relay_log_name TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,\n"
  "  Checkpoint_relay_log_pos BIGINT UNSIGNED NOT NULL,\n"
  "  Checkpoint_master_log_name TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,\n"
  "  Checkpoint_master_log_pos BIGINT UNSIGNED NOT NULL,\n"
  "  Checkpoint_seqno INT UNSIGNED NOT NULL,\n"
  "  Checkpoint_group_size INTEGER UNSIGNED NOT NULL,\n"
  "  Checkpoint_group_bitmap BLOB NOT NULL,\n"
  "  PRIMARY KEY(Id)) DEFAULT CHARSET=utf8mb3 STATS_PERSISTENT=0 COMMENT 'Worker Information'\";\n",
"SET @str=CONCAT(@cmd, ' ENGINE=', @innodb_or_aria);\n",
"CREATE TABLE IF NOT EXISTS proxies_priv (Host char(255) binary DEFAULT '' NOT NULL, User char(128) binary DEFAULT '' NOT NULL, Proxied_host char(255) binary DEFAULT '' NOT NULL, Proxied_user char(128) binary DEFAULT '' NOT NULL, With_grant BOOL DEFAULT 0 NOT NULL, Grantor varchar(384) DEFAULT '' NOT NULL, Timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY /*Host*/ (Host,User,Proxied_host,Proxied_user), KEY Grantor (Grantor) ) engine=Aria transactional=1 CHARACTER SET utf8mb3 COLLATE utf8mb3_bin comment='User proxy privileges';\n",
"set @had_proxies_priv_table= @@warning_count != 0;\n",
"CREATE TEMPORARY TABLE tmp_proxies_priv LIKE proxies_priv;\n",
"INSERT INTO tmp_proxies_priv VALUES ('localhost', 'root', '', '', TRUE, '', now());\n",
"REPLACE INTO tmp_proxies_priv SELECT 'localhost',IFNULL(@auth_root_socket, 'root'), '', '', TRUE, '', now() FROM DUAL;\n",
"INSERT INTO proxies_priv SELECT * FROM tmp_proxies_priv WHERE @had_proxies_priv_table=0;\n",
"DROP TABLE tmp_proxies_priv;\n",
"CREATE TABLE IF NOT EXISTS table_stats (db_name varchar(64) NOT NULL, table_name varchar(64) NOT NULL, cardinality bigint(21) unsigned DEFAULT NULL, PRIMARY KEY (db_name,table_name) ) engine=Aria transactional=0 CHARACTER SET utf8mb3 COLLATE utf8mb3_bin comment='Statistics on Tables';\n",
"CREATE TABLE IF NOT EXISTS column_stats (db_name varchar(64) NOT NULL, table_name varchar(64) NOT NULL, column_name varchar(64) NOT NULL, min_value varbinary(255) DEFAULT NULL, max_value varbinary(255) DEFAULT NULL, nulls_ratio decimal(12,4) DEFAULT NULL, avg_length decimal(12,4) DEFAULT NULL, avg_frequency decimal(12,4) DEFAULT NULL, hist_size tinyint unsigned, hist_type enum('SINGLE_PREC_HB','DOUBLE_PREC_HB','JSON_HB'), histogram longblob, PRIMARY KEY (db_name,table_name,column_name) ) engine=Aria transactional=0 CHARACTER SET utf8mb3 COLLATE utf8mb3_bin comment='Statistics on Columns';\n",
"CREATE TABLE IF NOT EXISTS index_stats (db_name varchar(64) NOT NULL, table_name varchar(64) NOT NULL, index_name varchar(64) NOT NULL, prefix_arity int(11) unsigned NOT NULL, avg_frequency decimal(12,4) DEFAULT NULL, PRIMARY KEY (db_name,table_name,index_name,prefix_arity) ) engine=Aria transactional=0 CHARACTER SET utf8mb3 COLLATE utf8mb3_bin comment='Statistics on Indexes';\n",
"SET @cmd= \"CREATE TABLE IF NOT EXISTS gtid_slave_pos (\n"
  "  domain_id INT UNSIGNED NOT NULL,\n"
  "  sub_id BIGINT UNSIGNED NOT NULL,\n"
  "  server_id INT UNSIGNED NOT NULL,\n"
  "  seq_no BIGINT UNSIGNED NOT NULL,\n"
  "  PRIMARY KEY (domain_id, sub_id)) CHARSET=latin1\n"
  "COMMENT='Replication slave GTID position'\";\n",
"SET @str=CONCAT(@cmd, ' ENGINE=', @innodb_or_aria);\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"set default_storage_engine=@orig_storage_engine;\n",
"drop table if exists mysql.ndb_binlog_index;\n",
"drop table if exists mysql.host;\n",
"SET NAMES latin1 COLLATE latin1_swedish_ci;\n",
"set @have_old_pfs= (select count(*) from information_schema.schemata where schema_name='performance_schema');\n",
"SET @cmd=\"SET @broken_tables = (select count(*) from information_schema.tables  where engine != 'PERFORMANCE_SCHEMA' and table_schema='performance_schema')\";\n",
"SET @str = IF(@have_old_pfs = 1, @cmd, 'SET @broken_tables = 0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"SET @broken_views = (select count(*) from information_schema.views where table_schema='performance_schema')\";\n",
"SET @str = IF(@have_old_pfs = 1, @cmd, 'SET @broken_views = 0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @broken_routines = (select count(*) from mysql.proc where db='performance_schema');\n",
"SET @broken_events = (select count(*) from mysql.event where db='performance_schema');\n",
"SET @broken_pfs= (select @broken_tables + @broken_views + @broken_routines + @broken_events);\n",
"SET @cmd= \"DROP DATABASE IF EXISTS performance_schema\";\n",
"SET @str = IF(@broken_pfs = 0, @cmd, 'SET @dummy = 0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd= \"CREATE DATABASE performance_schema character set utf8mb3 collate utf8mb3_general_ci\";\n",
"SET @str = IF(@broken_pfs = 0, @cmd, 'SET @dummy = 0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET NAMES utf8 COLLATE utf8_general_ci;\n",
"SET @sql_log_bin = @@sql_log_bin;\n",
"SET sql_log_bin = 0;\n",
"CREATE DATABASE IF NOT EXISTS sys DEFAULT CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci;\n",
"ALTER DATABASE sys CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci;\n",
"USE sys;\n",
"CREATE OR REPLACE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW version (\n"
  "  sys_version,\n"
  "  mysql_version\n"
  ") AS\n"
  "SELECT '1.5.2' AS sys_version,\n"
  "        version() AS mysql_version;\n",
"CREATE TABLE IF NOT EXISTS sys_config (\n"
  "    variable VARCHAR(128) PRIMARY KEY,\n"
  "    value VARCHAR(128),\n"
  "    set_time TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n"
  "    set_by VARCHAR(128)\n"
  ") ENGINE = Aria;\n",
"INSERT IGNORE INTO sys.sys_config (variable, value) VALUES\n"
  "    ('statement_truncate_len', 64),\n"
  "    ('statement_performance_analyzer.limit', 100),\n"
  "    ('statement_performance_analyzer.view', NULL),\n"
  "    ('diagnostics.allow_i_s_tables', 'OFF'),\n"
  "    ('diagnostics.include_raw', 'OFF'),\n"
  "    ('ps_thread_trx_info.max_length', 65535);\n",
"FLUSH TABLES sys.sys_config;\n",
"DROP TRIGGER IF EXISTS sys_config_insert_set_user;\n",
"DROP TRIGGER IF EXISTS sys_config_update_set_user;\n",
"DROP FUNCTION IF EXISTS extract_schema_from_file_name;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION extract_schema_from_file_name (\n"
  "        path VARCHAR(512)\n"
  "    )\n"
  "    RETURNS VARCHAR(64)\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Takes a raw file path, and attempts to extract the schema name from it.\n"
  "             Useful for when interacting with Performance Schema data\n"
  "             concerning IO statistics, for example.\n"
  "             Currently relies on the fact that a table data file will be within a\n"
  "             specified database directory (will not work with partitions or tables\n"
  "             that specify an individual DATA_DIRECTORY).\n"
  "             Parameters\n"
  "             path (VARCHAR(512)):\n"
  "               The full file path to a data file to extract the schema name from.\n"
  "             Returns\n"
  "             VARCHAR(64)\n"
  "             Example\n"
  "             mysql> SELECT sys.extract_schema_from_file_name(\\'/var/lib/mysql/employees/employee.ibd\\');\n"
  "             +----------------------------------------------------------------------------+\n"
  "             | sys.extract_schema_from_file_name(\\'/var/lib/mysql/employees/employee.ibd\\') |\n"
  "             +----------------------------------------------------------------------------+\n"
  "             | employees                                                                  |\n"
  "             +----------------------------------------------------------------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "    RETURN LEFT(SUBSTRING_INDEX(SUBSTRING_INDEX(REPLACE(path, '\\\\', '/'), '/', -2), '/', 1), 64);\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS extract_table_from_file_name;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION extract_table_from_file_name (\n"
  "        path VARCHAR(512)\n"
  "    )\n"
  "    RETURNS VARCHAR(64)\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Takes a raw file path, and extracts the table name from it.\n"
  "             Useful for when interacting with Performance Schema data\n"
  "             concerning IO statistics, for example.\n"
  "             Parameters\n"
  "             path (VARCHAR(512)):\n"
  "               The full file path to a data file to extract the table name from.\n"
  "             Returns\n"
  "             VARCHAR(64)\n"
  "             Example\n"
  "             mysql> SELECT sys.extract_table_from_file_name(\\'/var/lib/mysql/employees/employee.ibd\\');\n"
  "             +---------------------------------------------------------------------------+\n"
  "             | sys.extract_table_from_file_name(\\'/var/lib/mysql/employees/employee.ibd\\') |\n"
  "             +---------------------------------------------------------------------------+\n"
  "             | employee                                                                  |\n"
  "             +---------------------------------------------------------------------------+\n"
  "             1 row in set (0.02 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "    RETURN LEFT(SUBSTRING_INDEX(REPLACE(SUBSTRING_INDEX(REPLACE(path, '\\\\', '/'), '/', -1), '@0024', '$'), '.', 1), 64);\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS format_bytes;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION format_bytes (\n"
  "        bytes TEXT\n"
  "    )\n"
  "    RETURNS TEXT\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Takes a raw bytes value, and converts it to a human readable format.\n"
  "             Parameters\n"
  "             bytes (TEXT):\n"
  "               A raw bytes value.\n"
  "             Returns\n"
  "             TEXT\n"
  "             Example\n"
  "             mysql> SELECT sys.format_bytes(2348723492723746) AS size;\n"
  "             +----------+\n"
  "             | size     |\n"
  "             +----------+\n"
  "             | 2.09 PiB |\n"
  "             +----------+\n"
  "             1 row in set (0.00 sec)\n"
  "             mysql> SELECT sys.format_bytes(2348723492723) AS size;\n"
  "             +----------+\n"
  "             | size     |\n"
  "             +----------+\n"
  "             | 2.14 TiB |\n"
  "             +----------+\n"
  "             1 row in set (0.00 sec)\n"
  "             mysql> SELECT sys.format_bytes(23487234) AS size;\n"
  "             +-----------+\n"
  "             | size      |\n"
  "             +-----------+\n"
  "             | 22.40 MiB |\n"
  "             +-----------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "  IF bytes IS NULL THEN RETURN NULL;\n"
  "  ELSEIF bytes >= 1125899906842624 THEN RETURN CONCAT(ROUND(bytes / 1125899906842624, 2), ' PiB');\n"
  "  ELSEIF bytes >= 1099511627776 THEN RETURN CONCAT(ROUND(bytes / 1099511627776, 2), ' TiB');\n"
  "  ELSEIF bytes >= 1073741824 THEN RETURN CONCAT(ROUND(bytes / 1073741824, 2), ' GiB');\n"
  "  ELSEIF bytes >= 1048576 THEN RETURN CONCAT(ROUND(bytes / 1048576, 2), ' MiB');\n"
  "  ELSEIF bytes >= 1024 THEN RETURN CONCAT(ROUND(bytes / 1024, 2), ' KiB');\n"
  "  ELSE RETURN CONCAT(ROUND(bytes, 0), ' bytes');\n"
  "  END IF;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS format_path;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION format_path (\n"
  "        in_path VARCHAR(512)\n"
  "    )\n"
  "    RETURNS VARCHAR(512) CHARSET UTF8\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Takes a raw path value, and strips out the datadir or tmpdir\n"
  "             replacing with @@datadir and @@tmpdir respectively.\n"
  "             Also normalizes the paths across operating systems, so backslashes\n"
  "             on Windows are converted to forward slashes\n"
  "             Parameters\n"
  "             path (VARCHAR(512)):\n"
  "               The raw file path value to format.\n"
  "             Returns\n"
  "             VARCHAR(512) CHARSET UTF8\n"
  "             Example\n"
  "             mysql> select @@datadir;\n"
  "             +-----------------------------------------------+\n"
  "             | @@datadir                                     |\n"
  "             +-----------------------------------------------+\n"
  "             | /Users/mark/sandboxes/SmallTree/AMaster/data/ |\n"
  "             +-----------------------------------------------+\n"
  "             1 row in set (0.06 sec)\n"
  "             mysql> select format_path(\\'/Users/mark/sandboxes/SmallTree/AMaster/data/mysql/proc.MYD\\') AS path;\n"
  "             +--------------------------+\n"
  "             | path                     |\n"
  "             +--------------------------+\n"
  "             | @@datadir/mysql/proc.MYD |\n"
  "             +--------------------------+\n"
  "             1 row in set (0.03 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "  DECLARE v_dir VARCHAR(1024);\n"
  "  DECLARE v_path VARCHAR(512);\n"
  "  DECLARE path_separator CHAR(1) DEFAULT '/';\n"
  "  IF @@global.version_compile_os LIKE 'win%' THEN\n"
  "    SET path_separator = '\\\\';\n"
  "  END IF;\n"
  "  IF in_path LIKE '/private/%' THEN\n"
  "    SET v_path = REPLACE(in_path, '/private', '');\n"
  "  ELSE\n"
  "    SET v_path = in_path;\n"
  "  END IF;\n"
  "  SET v_dir= IFNULL((SELECT VARIABLE_VALUE FROM information_schema.global_variables WHERE VARIABLE_NAME = 'innodb_data_home_dir'), '');\n"
  "  IF v_path IS NULL THEN\n"
  "    RETURN NULL;\n"
  "  END IF;\n"
  "  IF v_path LIKE CONCAT(@@global.datadir, IF(SUBSTRING(@@global.datadir, -1) = path_separator, '%', CONCAT(path_separator, '%'))) ESCAPE '|' THEN\n"
  "    SET v_path = REPLACE(v_path, @@global.datadir, CONCAT('@@datadir', IF(SUBSTRING(@@global.datadir, -1) = path_separator, path_separator, '')));\n"
  "    RETURN v_path;\n"
  "  END IF;\n"
  "  IF v_path LIKE CONCAT(@@global.tmpdir, IF(SUBSTRING(@@global.tmpdir, -1) = path_separator, '%', CONCAT(path_separator, '%'))) ESCAPE '|' THEN\n"
  "    SET v_path = REPLACE(v_path, @@global.tmpdir, CONCAT('@@tmpdir', IF(SUBSTRING(@@global.tmpdir, -1) = path_separator, path_separator, '')));\n"
  "    RETURN v_path;\n"
  "  END IF;\n"
  "  SET v_dir= IFNULL((SELECT VARIABLE_VALUE FROM information_schema.global_variables WHERE VARIABLE_NAME = 'innodb_data_home_dir'), '');\n"
  "  IF v_path LIKE CONCAT(v_dir, IF(SUBSTRING(v_dir, -1) = path_separator, '%', CONCAT(path_separator, '%'))) ESCAPE '|' THEN\n"
  "    SET v_path = REPLACE(v_path, v_dir, CONCAT('@@innodb_data_home_dir', IF(SUBSTRING(v_dir, -1) = path_separator, path_separator, '')));\n"
  "    RETURN v_path;\n"
  "  END IF;\n"
  "  SET v_dir= IFNULL((SELECT VARIABLE_VALUE FROM information_schema.global_variables WHERE VARIABLE_NAME = 'innodb_log_group_home_dir'), '');\n"
  "  IF v_path LIKE CONCAT(v_dir, IF(SUBSTRING(v_dir, -1) = path_separator, '%', CONCAT(path_separator, '%'))) ESCAPE '|' THEN\n"
  "    SET v_path = REPLACE(v_path, v_dir, CONCAT('@@innodb_log_group_home_dir', IF(SUBSTRING(v_dir, -1) = path_separator, path_separator, '')));\n"
  "    RETURN v_path;\n"
  "  END IF;\n"
  "  SET v_dir= IFNULL((SELECT VARIABLE_VALUE FROM information_schema.global_variables WHERE VARIABLE_NAME = 'slave_load_tmpdir'), '');\n"
  "  IF v_path LIKE CONCAT(v_dir, IF(SUBSTRING(v_dir, -1) = path_separator, '%', CONCAT(path_separator, '%'))) ESCAPE '|' THEN\n"
  "    SET v_path = REPLACE(v_path, v_dir, CONCAT('@@slave_load_tmpdir', IF(SUBSTRING(v_dir, -1) = path_separator, path_separator, '')));\n"
  "    RETURN v_path;\n"
  "  END IF;\n"
  "  SET v_dir = IFNULL((SELECT VARIABLE_VALUE FROM information_schema.global_variables WHERE VARIABLE_NAME = 'innodb_undo_directory'), '');\n"
  "  IF v_path LIKE CONCAT(v_dir, IF(SUBSTRING(v_dir, -1) = path_separator, '%', CONCAT(path_separator, '%'))) ESCAPE '|' THEN\n"
  "    SET v_path = REPLACE(v_path, v_dir, CONCAT('@@innodb_undo_directory', IF(SUBSTRING(v_dir, -1) = path_separator, path_separator, '')));\n"
  "    RETURN v_path;\n"
  "  END IF;\n"
  "  IF v_path LIKE CONCAT(@@global.basedir, IF(SUBSTRING(@@global.basedir, -1) = path_separator, '%', CONCAT(path_separator, '%'))) ESCAPE '|' THEN\n"
  "    SET v_path = REPLACE(v_path, @@global.basedir, CONCAT('@@basedir', IF(SUBSTRING(@@global.basedir, -1) = path_separator, path_separator, '')));\n"
  "    RETURN v_path;\n"
  "  END IF;\n"
  "  RETURN v_path;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS format_statement;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION format_statement (\n"
  "        statement LONGTEXT\n"
  "    )\n"
  "    RETURNS LONGTEXT\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Formats a normalized statement, truncating it if it is > 64 characters long by default.\n"
  "             To configure the length to truncate the statement to by default, update the `statement_truncate_len`\n"
  "             variable with `sys_config` table to a different value. Alternatively, to change it just for just\n"
  "             your particular session, use `SET @sys.statement_truncate_len := <some new value>`.\n"
  "             Useful for printing statement related data from Performance Schema from\n"
  "             the command line.\n"
  "             Parameters\n"
  "             statement (LONGTEXT):\n"
  "               The statement to format.\n"
  "             Returns\n"
  "             LONGTEXT\n"
  "             Example\n"
  "             mysql> SELECT sys.format_statement(digest_text)\n"
  "                 ->   FROM performance_schema.events_statements_summary_by_digest\n"
  "                 ->  ORDER by sum_timer_wait DESC limit 5;\n"
  "             +-------------------------------------------------------------------+\n"
  "             | sys.format_statement(digest_text)                                 |\n"
  "             +-------------------------------------------------------------------+\n"
  "             | CREATE SQL SECURITY INVOKER VI ... KE ? AND `variable_value` > ?  |\n"
  "             | CREATE SQL SECURITY INVOKER VI ... ait` IS NOT NULL , `esc` . ... |\n"
  "             | CREATE SQL SECURITY INVOKER VI ... ait` IS NOT NULL , `sys` . ... |\n"
  "             | CREATE SQL SECURITY INVOKER VI ...  , `compressed_size` ) ) DESC  |\n"
  "             | CREATE SQL SECURITY INVOKER VI ... LIKE ? ORDER BY `timer_start`  |\n"
  "             +-------------------------------------------------------------------+\n"
  "             5 rows in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "  IF @sys.statement_truncate_len IS NULL THEN\n"
  "      SET @sys.statement_truncate_len = sys_get_config('statement_truncate_len', 64);\n"
  "  END IF;\n"
  "  IF CHAR_LENGTH(statement) > @sys.statement_truncate_len THEN\n"
  "      RETURN REPLACE(CONCAT(LEFT(statement, (@sys.statement_truncate_len/2)-2), ' ... ', RIGHT(statement, (@sys.statement_truncate_len/2)-2)), '\\n', ' ');\n"
  "  ELSE\n"
  "      RETURN REPLACE(statement, '\\n', ' ');\n"
  "  END IF;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS format_time;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION format_time (\n"
  "        picoseconds TEXT\n"
  "    )\n"
  "    RETURNS TEXT CHARSET UTF8\n"
  "    COMMENT '\n"
  "             Description\n"
  "             OBSOLETE. USE BUILT-IN format_pico_time() INSTEAD\n"
  "             Takes a raw picoseconds value, and converts it to a human readable form.\n"
  "             Picoseconds are the precision that all latency values are printed in\n"
  "             within Performance Schema, however are not user friendly when wanting\n"
  "             to scan output from the command line.\n"
  "             Parameters\n"
  "             picoseconds (TEXT):\n"
  "               The raw picoseconds value to convert.\n"
  "             Returns\n"
  "             TEXT\n"
  "             Example\n"
  "             mysql> select format_time(342342342342345);\n"
  "             +------------------------------+\n"
  "             | format_time(342342342342345) |\n"
  "             +------------------------------+\n"
  "             | 00:05:42                     |\n"
  "             +------------------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "             mysql> select format_time(342342342);\n"
  "             +------------------------+\n"
  "             | format_time(342342342) |\n"
  "             +------------------------+\n"
  "             | 342.34 us              |\n"
  "             +------------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "             mysql> select format_time(34234);\n"
  "              +--------------------+\n"
  "             | format_time(34234) |\n"
  "             +--------------------+\n"
  "             | 34.23 ns           |\n"
  "             +--------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "  IF picoseconds IS NULL THEN RETURN NULL;\n"
  "  ELSEIF picoseconds >= 604800000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 604800000000000000, 2), ' w');\n"
  "  ELSEIF picoseconds >= 86400000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 86400000000000000, 2), ' d');\n"
  "  ELSEIF picoseconds >= 3600000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 3600000000000000, 2), ' h');\n"
  "  ELSEIF picoseconds >= 60000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 60000000000000, 2), ' m');\n"
  "  ELSEIF picoseconds >= 1000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 1000000000000, 2), ' s');\n"
  "  ELSEIF picoseconds >= 1000000000 THEN RETURN CONCAT(ROUND(picoseconds / 1000000000, 2), ' ms');\n"
  "  ELSEIF picoseconds >= 1000000 THEN RETURN CONCAT(ROUND(picoseconds / 1000000, 2), ' us');\n"
  "  ELSEIF picoseconds >= 1000 THEN RETURN CONCAT(ROUND(picoseconds / 1000, 2), ' ns');\n"
  "  ELSE RETURN CONCAT(picoseconds, ' ps');\n"
  "  END IF;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS list_add;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION list_add (\n"
  "        in_list TEXT,\n"
  "        in_add_value TEXT\n"
  "    )\n"
  "    RETURNS TEXT\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Takes a list, and a value to add to the list, and returns the resulting list.\n"
  "             Useful for altering certain session variables, like sql_mode or optimizer_switch for instance.\n"
  "             Parameters\n"
  "             in_list (TEXT):\n"
  "               The comma separated list to add a value to\n"
  "             in_add_value (TEXT):\n"
  "               The value to add to the input list\n"
  "             Returns\n"
  "             TEXT\n"
  "             Example\n"
  "             mysql> select @@sql_mode;\n"
  "             +-----------------------------------------------------------------------------------+\n"
  "             | @@sql_mode                                                                        |\n"
  "             +-----------------------------------------------------------------------------------+\n"
  "             | ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n"
  "             +-----------------------------------------------------------------------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "             mysql> set sql_mode = sys.list_add(@@sql_mode, ''ANSI_QUOTES'');\n"
  "             Query OK, 0 rows affected (0.06 sec)\n"
  "             mysql> select @@sql_mode;\n"
  "             +-----------------------------------------------------------------------------------------------+\n"
  "             | @@sql_mode                                                                                    |\n"
  "             +-----------------------------------------------------------------------------------------------+\n"
  "             | ANSI_QUOTES,ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n"
  "             +-----------------------------------------------------------------------------------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    CONTAINS SQL\n"
  "BEGIN\n"
  "    IF (in_add_value IS NULL) THEN\n"
  "        SIGNAL SQLSTATE '02200'\n"
  "           SET MESSAGE_TEXT = 'Function sys.list_add: in_add_value input variable should not be NULL',\n"
  "               MYSQL_ERRNO = 1138;\n"
  "    END IF;\n"
  "    IF (in_list IS NULL OR LENGTH(in_list) = 0) THEN\n"
  "        RETURN in_add_value;\n"
  "    END IF;\n"
  "    RETURN (SELECT CONCAT(TRIM(BOTH ',' FROM TRIM(in_list)), ',', in_add_value));\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS list_drop;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION list_drop (\n"
  "        in_list TEXT,\n"
  "        in_drop_value TEXT\n"
  "    )\n"
  "    RETURNS TEXT\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Takes a list, and a value to attempt to remove from the list, and returns the resulting list.\n"
  "             Useful for altering certain session variables, like sql_mode or optimizer_switch for instance.\n"
  "             Parameters\n"
  "             in_list (TEXT):\n"
  "               The comma separated list to drop a value from\n"
  "             in_drop_value (TEXT):\n"
  "               The value to drop from the input list\n"
  "             Returns\n"
  "             TEXT\n"
  "             Example\n"
  "             mysql> select @@sql_mode;\n"
  "             +-----------------------------------------------------------------------------------------------+\n"
  "             | @@sql_mode                                                                                    |\n"
  "             +-----------------------------------------------------------------------------------------------+\n"
  "             | ANSI_QUOTES,ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n"
  "             +-----------------------------------------------------------------------------------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "             mysql> set sql_mode = sys.list_drop(@@sql_mode, ''ONLY_FULL_GROUP_BY'');\n"
  "             Query OK, 0 rows affected (0.03 sec)\n"
  "             mysql> select @@sql_mode;\n"
  "             +----------------------------------------------------------------------------+\n"
  "             | @@sql_mode                                                                 |\n"
  "             +----------------------------------------------------------------------------+\n"
  "             | ANSI_QUOTES,STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n"
  "             +----------------------------------------------------------------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    CONTAINS SQL\n"
  "BEGIN\n"
  "    IF (in_drop_value IS NULL) THEN\n"
  "        SIGNAL SQLSTATE '02200'\n"
  "           SET MESSAGE_TEXT = 'Function sys.list_drop: in_drop_value input variable should not be NULL',\n"
  "               MYSQL_ERRNO = 1138;\n"
  "    END IF;\n"
  "    IF (in_list IS NULL OR LENGTH(in_list) = 0) THEN\n"
  "        RETURN in_list;\n"
  "    END IF;\n"
  "    RETURN (SELECT TRIM(BOTH ',' FROM REPLACE(REPLACE(CONCAT(',', in_list), CONCAT(',', in_drop_value), ''), CONCAT(', ', in_drop_value), '')));\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS ps_is_account_enabled;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION ps_is_account_enabled (\n"
  "        in_host VARCHAR(60),\n"
  "        in_user VARCHAR(16)\n"
  "    )\n"
  "    RETURNS ENUM('YES', 'NO')\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Determines whether instrumentation of an account is enabled\n"
  "             within Performance Schema.\n"
  "             Parameters\n"
  "             in_host VARCHAR(60):\n"
  "               The hostname of the account to check.\n"
  "             in_user (VARCHAR(16)):\n"
  "               The username of the account to check.\n"
  "             Returns\n"
  "             ENUM(\\'YES\\', \\'NO\\', \\'PARTIAL\\')\n"
  "             Example\n"
  "             mysql> SELECT sys.ps_is_account_enabled(\\'localhost\\', \\'root\\');\n"
  "             +------------------------------------------------+\n"
  "             | sys.ps_is_account_enabled(\\'localhost\\', \\'root\\') |\n"
  "             +------------------------------------------------+\n"
  "             | YES                                            |\n"
  "             +------------------------------------------------+\n"
  "             1 row in set (0.01 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    RETURN IF(EXISTS(SELECT 1\n"
  "                       FROM performance_schema.setup_actors\n"
  "                      WHERE (`HOST` = '%' OR in_host LIKE `HOST`)\n"
  "                        AND (`USER` = '%' OR `USER` = in_user)\n"
  "                    ),\n"
  "              'YES', 'NO'\n"
  "           );\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS ps_is_consumer_enabled;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION ps_is_consumer_enabled (\n"
  "        in_consumer varchar(64)\n"
  "   )\n"
  "   RETURNS enum('YES', 'NO')\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Determines whether a consumer is enabled (taking the consumer hierarchy into consideration)\n"
  "             within the Performance Schema.\n"
  "             Parameters\n"
  "             in_consumer VARCHAR(64):\n"
  "               The name of the consumer to check.\n"
  "             Returns\n"
  "             ENUM(\\'YES\\', \\'NO\\')\n"
  "             Example\n"
  "             mysql> SELECT sys.ps_is_consumer_enabled(\\'events_stages_history\\');\n"
  "             +-----------------------------------------------------+\n"
  "             | sys.ps_is_consumer_enabled(\\'events_stages_history\\') |\n"
  "             +-----------------------------------------------------+\n"
  "             | NO                                                  |\n"
  "             +-----------------------------------------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    RETURN (\n"
  "        SELECT (CASE\n"
  "                   WHEN c.NAME = 'global_instrumentation' THEN c.ENABLED\n"
  "                   WHEN c.NAME = 'thread_instrumentation' THEN IF(cg.ENABLED = 'YES' AND c.ENABLED = 'YES', 'YES', 'NO')\n"
  "                   WHEN c.NAME LIKE '%\\_digest'           THEN IF(cg.ENABLED = 'YES' AND c.ENABLED = 'YES', 'YES', 'NO')\n"
  "                   WHEN c.NAME LIKE '%\\_current'          THEN IF(cg.ENABLED = 'YES' AND ct.ENABLED = 'YES' AND c.ENABLED = 'YES', 'YES', 'NO')\n"
  "                   ELSE IF(cg.ENABLED = 'YES' AND ct.ENABLED = 'YES' AND c.ENABLED = 'YES'\n"
  "                           AND ( SELECT cc.ENABLED FROM performance_schema.setup_consumers cc WHERE NAME = CONCAT(SUBSTRING_INDEX(c.NAME, '_', 2), '_current')\n"
  "                               ) = 'YES', 'YES', 'NO')\n"
  "                END) AS IsEnabled\n"
  "          FROM performance_schema.setup_consumers c\n"
  "               INNER JOIN performance_schema.setup_consumers cg\n"
  "               INNER JOIN performance_schema.setup_consumers ct\n"
  "         WHERE cg.NAME       = 'global_instrumentation'\n"
  "               AND ct.NAME   = 'thread_instrumentation'\n"
  "               AND c.NAME    = in_consumer\n"
  "       );\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS ps_is_instrument_default_enabled;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION ps_is_instrument_default_enabled (\n"
  "        in_instrument VARCHAR(128)\n"
  "    )\n"
  "    RETURNS ENUM('YES', 'NO')\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Returns whether an instrument is enabled by default in this version of MySQL.\n"
  "             Parameters\n"
  "             in_instrument VARCHAR(128):\n"
  "               The instrument to check.\n"
  "             Returns\n"
  "             ENUM(\\'YES\\', \\'NO\\')\n"
  "             Example\n"
  "             mysql> SELECT sys.ps_is_instrument_default_enabled(\\'statement/sql/select\\');\n"
  "             +--------------------------------------------------------------+\n"
  "             | sys.ps_is_instrument_default_enabled(\\'statement/sql/select\\') |\n"
  "             +--------------------------------------------------------------+\n"
  "             | YES                                                          |\n"
  "             +--------------------------------------------------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_enabled ENUM('YES', 'NO');\n"
  "    SET v_enabled = IF(in_instrument LIKE 'wait/io/file/%'\n"
  "                        OR in_instrument LIKE 'wait/io/table/%'\n"
  "                        OR in_instrument LIKE 'statement/%'\n"
  "                        OR in_instrument LIKE 'memory/performance_schema/%'\n"
  "                        OR in_instrument IN ('wait/lock/table/sql/handler', 'idle')\n"
  "               /*!50707\n"
  "                        OR in_instrument LIKE 'stage/innodb/%'\n"
  "                        OR in_instrument = 'stage/sql/copy to tmp table'\n"
  "               */\n"
  "                      ,\n"
  "                       'YES',\n"
  "                       'NO'\n"
  "                    );\n"
  "    RETURN v_enabled;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS ps_is_instrument_default_timed;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION ps_is_instrument_default_timed (\n"
  "        in_instrument VARCHAR(128)\n"
  "    )\n"
  "    RETURNS ENUM('YES', 'NO')\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Returns whether an instrument is timed by default in this version of MySQL.\n"
  "             Parameters\n"
  "             in_instrument VARCHAR(128):\n"
  "               The instrument to check.\n"
  "             Returns\n"
  "             ENUM(\\'YES\\', \\'NO\\')\n"
  "             Example\n"
  "             mysql> SELECT sys.ps_is_instrument_default_timed(\\'statement/sql/select\\');\n"
  "             +------------------------------------------------------------+\n"
  "             | sys.ps_is_instrument_default_timed(\\'statement/sql/select\\') |\n"
  "             +------------------------------------------------------------+\n"
  "             | YES                                                        |\n"
  "             +------------------------------------------------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_timed ENUM('YES', 'NO');\n"
  "    SET v_timed = IF(in_instrument LIKE 'wait/io/file/%'\n"
  "                        OR in_instrument LIKE 'wait/io/table/%'\n"
  "                        OR in_instrument LIKE 'statement/%'\n"
  "                        OR in_instrument IN ('wait/lock/table/sql/handler', 'idle')\n"
  "               /*!50707\n"
  "                        OR in_instrument LIKE 'stage/innodb/%'\n"
  "                        OR in_instrument = 'stage/sql/copy to tmp table'\n"
  "               */\n"
  "                      ,\n"
  "                       'YES',\n"
  "                       'NO'\n"
  "                    );\n"
  "    RETURN v_timed;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS ps_is_thread_instrumented;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION ps_is_thread_instrumented (\n"
  "        in_connection_id BIGINT UNSIGNED\n"
  "    ) RETURNS ENUM('YES', 'NO', 'UNKNOWN')\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Checks whether the provided connection id is instrumented within Performance Schema.\n"
  "             Parameters\n"
  "             in_connection_id (BIGINT UNSIGNED):\n"
  "               The id of the connection to check.\n"
  "             Returns\n"
  "             ENUM(\\'YES\\', \\'NO\\', \\'UNKNOWN\\')\n"
  "             Example\n"
  "             mysql> SELECT sys.ps_is_thread_instrumented(CONNECTION_ID());\n"
  "             +------------------------------------------------+\n"
  "             | sys.ps_is_thread_instrumented(CONNECTION_ID()) |\n"
  "             +------------------------------------------------+\n"
  "             | YES                                            |\n"
  "             +------------------------------------------------+\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_enabled ENUM('YES', 'NO', 'UNKNOWN');\n"
  "    IF (in_connection_id IS NULL) THEN\n"
  "        RETURN NULL;\n"
  "    END IF;\n"
  "    SELECT INSTRUMENTED INTO v_enabled\n"
  "      FROM performance_schema.threads\n"
  "     WHERE PROCESSLIST_ID = in_connection_id;\n"
  "    IF (v_enabled IS NULL) THEN\n"
  "        RETURN 'UNKNOWN';\n"
  "    ELSE\n"
  "        RETURN v_enabled;\n"
  "    END IF;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS ps_thread_id;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION ps_thread_id (\n"
  "        in_connection_id BIGINT UNSIGNED\n"
  "    ) RETURNS BIGINT UNSIGNED\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Return the Performance Schema THREAD_ID for the specified connection ID.\n"
  "             Parameters\n"
  "             in_connection_id (BIGINT UNSIGNED):\n"
  "               The id of the connection to return the thread id for. If NULL, the current\n"
  "               connection thread id is returned.\n"
  "             Example\n"
  "             mysql> SELECT sys.ps_thread_id(79);\n"
  "             +----------------------+\n"
  "             | sys.ps_thread_id(79) |\n"
  "             +----------------------+\n"
  "             |                   98 |\n"
  "             +----------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "             mysql> SELECT sys.ps_thread_id(CONNECTION_ID());\n"
  "             +-----------------------------------+\n"
  "             | sys.ps_thread_id(CONNECTION_ID()) |\n"
  "             +-----------------------------------+\n"
  "             |                                98 |\n"
  "             +-----------------------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    RETURN (SELECT THREAD_ID\n"
  "              FROM `performance_schema`.`threads`\n"
  "             WHERE PROCESSLIST_ID = IFNULL(in_connection_id, CONNECTION_ID())\n"
  "           );\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS ps_thread_account;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION ps_thread_account (\n"
  "        in_thread_id BIGINT UNSIGNED\n"
  "    ) RETURNS TEXT\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Return the user@host account for the given Performance Schema thread id.\n"
  "             Parameters\n"
  "             in_thread_id (BIGINT UNSIGNED):\n"
  "               The id of the thread to return the account for.\n"
  "             Example\n"
  "             mysql> select thread_id, processlist_user, processlist_host from performance_schema.threads where type = ''foreground'';\n"
  "              +-----------+------------------+------------------+\n"
  "              | thread_id | processlist_user | processlist_host |\n"
  "              +-----------+------------------+------------------+\n"
  "              |        23 | NULL             | NULL             |\n"
  "              |        30 | root             | localhost        |\n"
  "              |        31 | msandbox         | localhost        |\n"
  "              |        32 | msandbox         | localhost        |\n"
  "              +-----------+------------------+------------------+\n"
  "              4 rows in set (0.00 sec)\n"
  "              mysql> select sys.ps_thread_account(31);\n"
  "              +---------------------------+\n"
  "              | sys.ps_thread_account(31) |\n"
  "              +---------------------------+\n"
  "              | msandbox@localhost        |\n"
  "              +---------------------------+\n"
  "              1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    RETURN (SELECT IF(\n"
  "                      type = 'FOREGROUND',\n"
  "                      CONCAT(processlist_user, '@', processlist_host),\n"
  "                      type\n"
  "                     ) AS account\n"
  "              FROM `performance_schema`.`threads`\n"
  "             WHERE thread_id = in_thread_id);\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS ps_thread_stack;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION ps_thread_stack (\n"
  "        thd_id BIGINT UNSIGNED,\n"
  "        debug BOOLEAN\n"
  "    )\n"
  "RETURNS LONGTEXT CHARSET latin1\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Outputs a JSON formatted stack of all statements, stages and events\n"
  "             within Performance Schema for the specified thread.\n"
  "             Parameters\n"
  "             thd_id (BIGINT UNSIGNED):\n"
  "               The id of the thread to trace. This should match the thread_id\n"
  "               column from the performance_schema.threads table.\n"
  "             in_verbose (BOOLEAN):\n"
  "               Include file:lineno information in the events.\n"
  "             Example\n"
  "             (line separation added for output)\n"
  "             mysql> SELECT sys.ps_thread_stack(37, FALSE) AS thread_stack\\\\G\n"
  "             *************************** 1. row ***************************\n"
  "             thread_stack: {\"rankdir\": \"LR\",\"nodesep\": \"0.10\",\"stack_created\": \"2014-02-19 13:39:03\",\n"
  "             \"mysql_version\": \"5.7.3-m13\",\"mysql_user\": \"root@localhost\",\"events\":\n"
  "             [{\"nesting_event_id\": \"0\", \"event_id\": \"10\", \"timer_wait\": 256.35, \"event_info\":\n"
  "             \"sql/select\", \"wait_info\": \"select @@version_comment limit 1\\\\nerrors: 0\\\\nwarnings: 0\\\\nlock time:\n"
  "             ...\n"
  "            '\n"
  "SQL SECURITY INVOKER\n"
  "NOT DETERMINISTIC\n"
  "READS SQL DATA\n"
  "BEGIN\n"
  "    DECLARE json_objects LONGTEXT;\n"
  "    /*!50602\n"
  "    UPDATE performance_schema.threads\n"
  "       SET instrumented = 'NO'\n"
  "     WHERE processlist_id = CONNECTION_ID();\n"
  "    */\n"
  "    SET SESSION group_concat_max_len=@@global.max_allowed_packet;\n"
  "    SELECT GROUP_CONCAT(CONCAT( '{'\n"
  "              , CONCAT_WS( ', '\n"
  "              , CONCAT('\"nesting_event_id\": \"', IF(nesting_event_id IS NULL, '0', nesting_event_id), '\"')\n"
  "              , CONCAT('\"event_id\": \"', event_id, '\"')\n"
  "              , CONCAT( '\"timer_wait\": ', ROUND(timer_wait/1000000, 2))\n"
  "              , CONCAT( '\"event_info\": \"'\n"
  "                  , CASE\n"
  "                        WHEN event_name NOT LIKE 'wait/io%' THEN REPLACE(SUBSTRING_INDEX(event_name, '/', -2), '\\\\', '\\\\\\\\')\n"
  "                        WHEN event_name NOT LIKE 'wait/io/file%' OR event_name NOT LIKE 'wait/io/socket%' THEN REPLACE(SUBSTRING_INDEX(event_name, '/', -4), '\\\\', '\\\\\\\\')\n"
  "                        ELSE event_name\n"
  "                    END\n"
  "                  , '\"'\n"
  "              )\n"
  "              , CONCAT( '\"wait_info\": \"', IFNULL(wait_info, ''), '\"')\n"
  "              , CONCAT( '\"source\": \"', IF(true AND event_name LIKE 'wait%', IFNULL(wait_info, ''), ''), '\"')\n"
  "              , CASE\n"
  "                     WHEN event_name LIKE 'wait/io/file%'      THEN '\"event_type\": \"io/file\"'\n"
  "                     WHEN event_name LIKE 'wait/io/table%'     THEN '\"event_type\": \"io/table\"'\n"
  "                     WHEN event_name LIKE 'wait/io/socket%'    THEN '\"event_type\": \"io/socket\"'\n"
  "                     WHEN event_name LIKE 'wait/synch/mutex%'  THEN '\"event_type\": \"synch/mutex\"'\n"
  "                     WHEN event_name LIKE 'wait/synch/cond%'   THEN '\"event_type\": \"synch/cond\"'\n"
  "                     WHEN event_name LIKE 'wait/synch/rwlock%' THEN '\"event_type\": \"synch/rwlock\"'\n"
  "                     WHEN event_name LIKE 'wait/lock%'         THEN '\"event_type\": \"lock\"'\n"
  "                     WHEN event_name LIKE 'statement/%'        THEN '\"event_type\": \"stmt\"'\n"
  "                     WHEN event_name LIKE 'stage/%'            THEN '\"event_type\": \"stage\"'\n"
  "                     WHEN event_name LIKE '%idle%'             THEN '\"event_type\": \"idle\"'\n"
  "                     ELSE ''\n"
  "                END\n"
  "            )\n"
  "            , '}'\n"
  "          )\n"
  "          ORDER BY event_id ASC SEPARATOR ',') event\n"
  "    INTO json_objects\n"
  "    FROM (\n"
  "          /*!50600\n"
  "          (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id,\n"
  "                  CONCAT(sql_text, '\\\\n',\n"
  "                         'errors: ', errors, '\\\\n',\n"
  "                         'warnings: ', warnings, '\\\\n',\n"
  "                         'lock time: ', ROUND(lock_time/1000000, 2),'us\\\\n',\n"
  "                         'rows affected: ', rows_affected, '\\\\n',\n"
  "                         'rows sent: ', rows_sent, '\\\\n',\n"
  "                         'rows examined: ', rows_examined, '\\\\n',\n"
  "                         'tmp tables: ', created_tmp_tables, '\\\\n',\n"
  "                         'tmp disk tables: ', created_tmp_disk_tables, '\\\\n',\n"
  "                         'select scan: ', select_scan, '\\\\n',\n"
  "                         'select full join: ', select_full_join, '\\\\n',\n"
  "                         'select full range join: ', select_full_range_join, '\\\\n',\n"
  "                         'select range: ', select_range, '\\\\n',\n"
  "                         'select range check: ', select_range_check, '\\\\n',\n"
  "                         'sort merge passes: ', sort_merge_passes, '\\\\n',\n"
  "                         'sort rows: ', sort_rows, '\\\\n',\n"
  "                         'sort range: ', sort_range, '\\\\n',\n"
  "                         'sort scan: ', sort_scan, '\\\\n',\n"
  "                         'no index used: ', IF(no_index_used, 'TRUE', 'FALSE'), '\\\\n',\n"
  "                         'no good index used: ', IF(no_good_index_used, 'TRUE', 'FALSE'), '\\\\n'\n"
  "                         ) AS wait_info\n"
  "             FROM performance_schema.events_statements_history_long WHERE thread_id = thd_id)\n"
  "          UNION\n"
  "          (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id, null AS wait_info\n"
  "             FROM performance_schema.events_stages_history_long WHERE thread_id = thd_id)\n"
  "          UNION */\n"
  "          (SELECT thread_id, event_id,\n"
  "                  CONCAT(event_name ,\n"
  "                         IF(event_name NOT LIKE 'wait/synch/mutex%', IFNULL(CONCAT(' - ', operation), ''), ''),\n"
  "                         IF(number_of_bytes IS NOT NULL, CONCAT(' ', number_of_bytes, ' bytes'), ''),\n"
  "                         IF(event_name LIKE 'wait/io/file%', '\\\\n', ''),\n"
  "                         IF(object_schema IS NOT NULL, CONCAT('\\\\nObject: ', object_schema, '.'), ''),\n"
  "                         IF(object_name IS NOT NULL,\n"
  "                            IF (event_name LIKE 'wait/io/socket%',\n"
  "                                CONCAT(IF (object_name LIKE ':0%', @@socket, object_name)),\n"
  "                                object_name),\n"
  "                            ''),\n"
  "                         /*!50600 IF(index_name IS NOT NULL, CONCAT(' Index: ', index_name), ''),*/'\\\\n'\n"
  "                         ) AS event_name,\n"
  "                  timer_wait, timer_start, nesting_event_id, source AS wait_info\n"
  "             FROM performance_schema.events_waits_history_long WHERE thread_id = thd_id)) events\n"
  "    ORDER BY event_id;\n"
  "    RETURN CONCAT('{',\n"
  "                  CONCAT_WS(',',\n"
  "                            '\"rankdir\": \"LR\"',\n"
  "                            '\"nodesep\": \"0.10\"',\n"
  "                            CONCAT('\"stack_created\": \"', NOW(), '\"'),\n"
  "                            CONCAT('\"mysql_version\": \"', VERSION(), '\"'),\n"
  "                            CONCAT('\"mysql_user\": \"', CURRENT_USER(), '\"'),\n"
  "                            CONCAT('\"events\": [', IFNULL(json_objects,''), ']')\n"
  "                           ),\n"
  "                  '}');\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS ps_thread_trx_info;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION ps_thread_trx_info (\n"
  "        in_thread_id BIGINT UNSIGNED\n"
  "    ) RETURNS LONGTEXT\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Returns a JSON object with info on the given threads current transaction,\n"
  "             and the statements it has already executed, derived from the\n"
  "             performance_schema.events_transactions_current and\n"
  "             performance_schema.events_statements_history tables (so the consumers\n"
  "             for these also have to be enabled within Performance Schema to get full\n"
  "             data in the object).\n"
  "             When the output exceeds the default truncation length (65535), a JSON error\n"
  "             object is returned, such as:\n"
  "             { \"error\": \"Trx info truncated: Row 6 was cut by GROUP_CONCAT()\" }\n"
  "             Similar error objects are returned for other warnings/and exceptions raised\n"
  "             when calling the function.\n"
  "             The max length of the output of this function can be controlled with the\n"
  "             ps_thread_trx_info.max_length variable set via sys_config, or the\n"
  "             @sys.ps_thread_trx_info.max_length user variable, as appropriate.\n"
  "             Parameters\n"
  "             in_thread_id (BIGINT UNSIGNED):\n"
  "               The id of the thread to return the transaction info for.\n"
  "             Example\n"
  "             SELECT sys.ps_thread_trx_info(48)\\\\G\n"
  "             *************************** 1. row ***************************\n"
  "             sys.ps_thread_trx_info(48): [\n"
  "               {\n"
  "                 \"time\": \"790.70 us\",\n"
  "                 \"state\": \"COMMITTED\",\n"
  "                 \"mode\": \"READ WRITE\",\n"
  "                 \"autocommitted\": \"NO\",\n"
  "                 \"gtid\": \"AUTOMATIC\",\n"
  "                 \"isolation\": \"REPEATABLE READ\",\n"
  "                 \"statements_executed\": [\n"
  "                   {\n"
  "                     \"sql_text\": \"INSERT INTO info VALUES (1, \\'foo\\')\",\n"
  "                     \"time\": \"471.02 us\",\n"
  "                     \"schema\": \"trx\",\n"
  "                     \"rows_examined\": 0,\n"
  "                     \"rows_affected\": 1,\n"
  "                     \"rows_sent\": 0,\n"
  "                     \"tmp_tables\": 0,\n"
  "                     \"tmp_disk_tables\": 0,\n"
  "                     \"sort_rows\": 0,\n"
  "                     \"sort_merge_passes\": 0\n"
  "                   },\n"
  "                   {\n"
  "                     \"sql_text\": \"COMMIT\",\n"
  "                     \"time\": \"254.42 us\",\n"
  "                     \"schema\": \"trx\",\n"
  "                     \"rows_examined\": 0,\n"
  "                     \"rows_affected\": 0,\n"
  "                     \"rows_sent\": 0,\n"
  "                     \"tmp_tables\": 0,\n"
  "                     \"tmp_disk_tables\": 0,\n"
  "                     \"sort_rows\": 0,\n"
  "                     \"sort_merge_passes\": 0\n"
  "                   }\n"
  "                 ]\n"
  "               },\n"
  "               {\n"
  "                 \"time\": \"426.20 us\",\n"
  "                 \"state\": \"COMMITTED\",\n"
  "                 \"mode\": \"READ WRITE\",\n"
  "                 \"autocommitted\": \"NO\",\n"
  "                 \"gtid\": \"AUTOMATIC\",\n"
  "                 \"isolation\": \"REPEATABLE READ\",\n"
  "                 \"statements_executed\": [\n"
  "                   {\n"
  "                     \"sql_text\": \"INSERT INTO info VALUES (2, \\'bar\\')\",\n"
  "                     \"time\": \"107.33 us\",\n"
  "                     \"schema\": \"trx\",\n"
  "                     \"rows_examined\": 0,\n"
  "                     \"rows_affected\": 1,\n"
  "                     \"rows_sent\": 0,\n"
  "                     \"tmp_tables\": 0,\n"
  "                     \"tmp_disk_tables\": 0,\n"
  "                     \"sort_rows\": 0,\n"
  "                     \"sort_merge_passes\": 0\n"
  "                   },\n"
  "                   {\n"
  "                     \"sql_text\": \"COMMIT\",\n"
  "                     \"time\": \"213.23 us\",\n"
  "                     \"schema\": \"trx\",\n"
  "                     \"rows_examined\": 0,\n"
  "                     \"rows_affected\": 0,\n"
  "                     \"rows_sent\": 0,\n"
  "                     \"tmp_tables\": 0,\n"
  "                     \"tmp_disk_tables\": 0,\n"
  "                     \"sort_rows\": 0,\n"
  "                     \"sort_merge_passes\": 0\n"
  "                   }\n"
  "                 ]\n"
  "               }\n"
  "             ]\n"
  "             1 row in set (0.03 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_output LONGTEXT DEFAULT '{}';\n"
  "    DECLARE v_msg_text TEXT DEFAULT '';\n"
  "    DECLARE v_signal_msg TEXT DEFAULT '';\n"
  "    DECLARE v_mysql_errno INT;\n"
  "    DECLARE v_max_output_len BIGINT;\n"
  "    DECLARE EXIT HANDLER FOR SQLWARNING, SQLEXCEPTION\n"
  "    BEGIN\n"
  "        GET DIAGNOSTICS CONDITION 1\n"
  "            v_msg_text = MESSAGE_TEXT,\n"
  "            v_mysql_errno = MYSQL_ERRNO;\n"
  "        IF v_mysql_errno = 1260 THEN\n"
  "            SET v_signal_msg = CONCAT('{ \"error\": \"Trx info truncated: ', v_msg_text, '\" }');\n"
  "        ELSE\n"
  "            SET v_signal_msg = CONCAT('{ \"error\": \"', v_msg_text, '\" }');\n"
  "        END IF;\n"
  "        RETURN v_signal_msg;\n"
  "    END;\n"
  "    IF (@sys.ps_thread_trx_info.max_length IS NULL) THEN\n"
  "        SET @sys.ps_thread_trx_info.max_length = sys.sys_get_config('ps_thread_trx_info.max_length', 65535);\n"
  "    END IF;\n"
  "    IF (@sys.ps_thread_trx_info.max_length != @@session.group_concat_max_len) THEN\n"
  "        SET @old_group_concat_max_len = @@session.group_concat_max_len;\n"
  "        SET v_max_output_len = (@sys.ps_thread_trx_info.max_length - 5);\n"
  "        SET SESSION group_concat_max_len = v_max_output_len;\n"
  "    END IF;\n"
  "    SET v_output = (\n"
  "        SELECT CONCAT('[', IFNULL(GROUP_CONCAT(trx_info ORDER BY event_id), ''), '\\n]') AS trx_info\n"
  "          FROM (SELECT trxi.thread_id,\n"
  "                       trxi.event_id,\n"
  "                       GROUP_CONCAT(\n"
  "                         IFNULL(\n"
  "                           CONCAT('\\n  {\\n',\n"
  "                                  '    \"time\": \"', IFNULL(format_pico_time(trxi.timer_wait), ''), '\",\\n',\n"
  "                                  '    \"state\": \"', IFNULL(trxi.state, ''), '\",\\n',\n"
  "                                  '    \"mode\": \"', IFNULL(trxi.access_mode, ''), '\",\\n',\n"
  "                                  '    \"autocommitted\": \"', IFNULL(trxi.autocommit, ''), '\",\\n',\n"
  "                                  '    \"gtid\": \"', IFNULL(trxi.gtid, ''), '\",\\n',\n"
  "                                  '    \"isolation\": \"', IFNULL(trxi.isolation_level, ''), '\",\\n',\n"
  "                                  '    \"statements_executed\": [', IFNULL(s.stmts, ''), IF(s.stmts IS NULL, ' ]\\n', '\\n    ]\\n'),\n"
  "                                  '  }'\n"
  "                           ),\n"
  "                           '')\n"
  "                         ORDER BY event_id) AS trx_info\n"
  "                  FROM (\n"
  "                        (SELECT thread_id, event_id, timer_wait, state,access_mode, autocommit, gtid, isolation_level\n"
  "                           FROM performance_schema.events_transactions_current\n"
  "                          WHERE thread_id = in_thread_id\n"
  "                            AND end_event_id IS NULL)\n"
  "                        UNION\n"
  "                        (SELECT thread_id, event_id, timer_wait, state,access_mode, autocommit, gtid, isolation_level\n"
  "                           FROM performance_schema.events_transactions_history\n"
  "                          WHERE thread_id = in_thread_id)\n"
  "                       ) AS trxi\n"
  "                  LEFT JOIN (SELECT thread_id,\n"
  "                                    nesting_event_id,\n"
  "                                    GROUP_CONCAT(\n"
  "                                      IFNULL(\n"
  "                                        CONCAT('\\n      {\\n',\n"
  "                                               '        \"sql_text\": \"', IFNULL(sys.format_statement(REPLACE(sql_text, '\\\\', '\\\\\\\\')), ''), '\",\\n',\n"
  "                                               '        \"time\": \"', IFNULL(format_pico_time(timer_wait), ''), '\",\\n',\n"
  "                                               '        \"schema\": \"', IFNULL(current_schema, ''), '\",\\n',\n"
  "                                               '        \"rows_examined\": ', IFNULL(rows_examined, ''), ',\\n',\n"
  "                                               '        \"rows_affected\": ', IFNULL(rows_affected, ''), ',\\n',\n"
  "                                               '        \"rows_sent\": ', IFNULL(rows_sent, ''), ',\\n',\n"
  "                                               '        \"tmp_tables\": ', IFNULL(created_tmp_tables, ''), ',\\n',\n"
  "                                               '        \"tmp_disk_tables\": ', IFNULL(created_tmp_disk_tables, ''), ',\\n',\n"
  "                                               '        \"sort_rows\": ', IFNULL(sort_rows, ''), ',\\n',\n"
  "                                               '        \"sort_merge_passes\": ', IFNULL(sort_merge_passes, ''), '\\n',\n"
  "                                               '      }'), '') ORDER BY event_id) AS stmts\n"
  "                               FROM performance_schema.events_statements_history\n"
  "                              WHERE sql_text IS NOT NULL\n"
  "                                AND thread_id = in_thread_id\n"
  "                              GROUP BY thread_id, nesting_event_id\n"
  "                            ) AS s\n"
  "                    ON trxi.thread_id = s.thread_id\n"
  "                   AND trxi.event_id = s.nesting_event_id\n"
  "                 WHERE trxi.thread_id = in_thread_id\n"
  "                 GROUP BY trxi.thread_id, trxi.event_id\n"
  "                ) trxs\n"
  "          GROUP BY thread_id\n"
  "    );\n"
  "    IF (@old_group_concat_max_len IS NOT NULL) THEN\n"
  "        SET SESSION group_concat_max_len = @old_group_concat_max_len;\n"
  "    END IF;\n"
  "    RETURN v_output;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS quote_identifier;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION quote_identifier(in_identifier TEXT)\n"
  "    RETURNS TEXT CHARSET UTF8\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Takes an unquoted identifier (schema name, table name, etc.) and\n"
  "             returns the identifier quoted with backticks.\n"
  "             Parameters\n"
  "             in_identifier (TEXT):\n"
  "               The identifier to quote.\n"
  "             Returns\n"
  "             TEXT\n"
  "             Example\n"
  "             mysql> SELECT sys.quote_identifier(''my_identifier'') AS Identifier;\n"
  "             +-----------------+\n"
  "             | Identifier      |\n"
  "             +-----------------+\n"
  "             | `my_identifier` |\n"
  "             +-----------------+\n"
  "             1 row in set (0.00 sec)\n"
  "             mysql> SELECT sys.quote_identifier(''my`idenfier'') AS Identifier;\n"
  "             +----------------+\n"
  "             | Identifier     |\n"
  "             +----------------+\n"
  "             | `my``idenfier` |\n"
  "             +----------------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "    RETURN CONCAT('`', REPLACE(in_identifier, '`', '``'), '`');\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS sys_get_config;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION sys_get_config (\n"
  "        in_variable_name VARCHAR(128),\n"
  "        in_default_value VARCHAR(128)\n"
  "    )\n"
  "    RETURNS VARCHAR(128)\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Returns the value for the requested variable using the following logic:\n"
  "                1. If the option exists in sys.sys_config return the value from there.\n"
  "                2. Else fall back on the provided default value.\n"
  "             Notes for using sys_get_config():\n"
  "                * If the default value argument to sys_get_config() is NULL and case 2. is reached, NULL is returned.\n"
  "                  It is then expected that the caller is able to handle NULL for the given configuration option.\n"
  "                * The convention is to name the user variables @sys.<name of variable>. It is <name of variable> that\n"
  "                  is stored in the sys_config table and is what is expected as the argument to sys_get_config().\n"
  "                * If you want to check whether the configuration option has already been set and if not assign with\n"
  "                  the return value of sys_get_config() you can use IFNULL(...) (see example below). However this should\n"
  "                  not be done inside a loop (e.g. for each row in a result set) as for repeated calls where assignment\n"
  "                  is only needed in the first iteration using IFNULL(...) is expected to be significantly slower than\n"
  "                  using an IF (...) THEN ... END IF; block (see example below).\n"
  "             Parameters\n"
  "             in_variable_name (VARCHAR(128)):\n"
  "               The name of the config option to return the value for.\n"
  "             in_default_value (VARCHAR(128)):\n"
  "               The default value to return if the variable does not exist in sys.sys_config.\n"
  "             Returns\n"
  "             VARCHAR(128)\n"
  "             Example\n"
  "             mysql> SELECT sys.sys_get_config(''statement_truncate_len'', 128) AS Value;\n"
  "             +-------+\n"
  "             | Value |\n"
  "             +-------+\n"
  "             | 64    |\n"
  "             +-------+\n"
  "             1 row in set (0.00 sec)\n"
  "             mysql> SET @sys.statement_truncate_len = IFNULL(@sys.statement_truncate_len, sys.sys_get_config(''statement_truncate_len'', 64));\n"
  "             Query OK, 0 rows affected (0.00 sec)\n"
  "             IF (@sys.statement_truncate_len IS NULL) THEN\n"
  "                 SET @sys.statement_truncate_len = sys.sys_get_config(''statement_truncate_len'', 64);\n"
  "             END IF;\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_value VARCHAR(128) DEFAULT NULL;\n"
  "    DECLARE old_val INTEGER DEFAULT NULL;\n"
  "    SET v_value = (SELECT value FROM sys.sys_config WHERE variable = in_variable_name);\n"
  "    IF (v_value IS NULL) THEN\n"
  "        SET v_value = in_default_value;\n"
  "    END IF;\n"
  "    RETURN v_value;\n"
  "END $$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS version_major;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION version_major ()\n"
  "    RETURNS TINYINT UNSIGNED\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Returns the major version of MySQL Server.\n"
  "             Returns\n"
  "             TINYINT UNSIGNED\n"
  "             Example\n"
  "             mysql> SELECT VERSION(), sys.version_major();\n"
  "             +--------------------------------------+---------------------+\n"
  "             | VERSION()                            | sys.version_major() |\n"
  "             +--------------------------------------+---------------------+\n"
  "             | 5.7.9-enterprise-commercial-advanced | 5                   |\n"
  "             +--------------------------------------+---------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "    RETURN SUBSTRING_INDEX(SUBSTRING_INDEX(VERSION(), '-', 1), '.', 1);\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS version_minor;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION version_minor ()\n"
  "    RETURNS TINYINT UNSIGNED\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Returns the minor (release series) version of MySQL Server.\n"
  "             Returns\n"
  "             TINYINT UNSIGNED\n"
  "             Example\n"
  "             mysql> SELECT VERSION(), sys.server_minor();\n"
  "             +--------------------------------------+---------------------+\n"
  "             | VERSION()                            | sys.version_minor() |\n"
  "             +--------------------------------------+---------------------+\n"
  "             | 5.7.9-enterprise-commercial-advanced | 7                   |\n"
  "             +--------------------------------------+---------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "    RETURN SUBSTRING_INDEX(SUBSTRING_INDEX(SUBSTRING_INDEX(VERSION(), '-', 1), '.', 2), '.', -1);\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP FUNCTION IF EXISTS version_patch;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' FUNCTION version_patch ()\n"
  "    RETURNS TINYINT UNSIGNED\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Returns the patch release version of MySQL Server.\n"
  "             Returns\n"
  "             TINYINT UNSIGNED\n"
  "             Example\n"
  "             mysql> SELECT VERSION(), sys.version_patch();\n"
  "             +--------------------------------------+---------------------+\n"
  "             | VERSION()                            | sys.version_patch() |\n"
  "             +--------------------------------------+---------------------+\n"
  "             | 5.7.9-enterprise-commercial-advanced | 9                   |\n"
  "             +--------------------------------------+---------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "    RETURN SUBSTRING_INDEX(SUBSTRING_INDEX(VERSION(), '-', 1), '.', -1);\n"
  "END$$\n",
"DELIMITER ;\n",
"DELIMITER $$\n",
"BEGIN NOT ATOMIC\n"
  "  DECLARE EXIT HANDLER FOR SQLEXCEPTION\n"
  "  BEGIN\n"
  "  END;\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW innodb_buffer_stats_by_schema (\n"
  "  object_schema,\n"
  "  allocated,\n"
  "  data,\n"
  "  pages,\n"
  "  pages_hashed,\n"
  "  pages_old,\n"
  "  rows_cached\n"
  ") AS\n"
  "SELECT IF(LOCATE('.', ibp.table_name) = 0, 'InnoDB System', REPLACE(SUBSTRING_INDEX(ibp.table_name, '.', 1), '`', '')) AS object_schema,\n"
  "       format_bytes(SUM(IF(ibp.compressed_size = 0, 16384, compressed_size))) AS allocated,\n"
  "       format_bytes(SUM(ibp.data_size)) AS data,\n"
  "       COUNT(ibp.page_number) AS pages,\n"
  "       COUNT(IF(ibp.is_hashed, 1, NULL)) AS pages_hashed,\n"
  "       COUNT(IF(ibp.is_old, 1, NULL)) AS pages_old,\n"
  "       ROUND(SUM(ibp.number_records)/COUNT(DISTINCT ibp.index_name)) AS rows_cached\n"
  "  FROM information_schema.innodb_buffer_page ibp\n"
  " WHERE table_name IS NOT NULL\n"
  " GROUP BY object_schema\n"
  " ORDER BY SUM(IF(ibp.compressed_size = 0, 16384, compressed_size)) DESC;\n"
  "END$$\n",
"DELIMITER ;\n",
"DELIMITER $$\n",
"BEGIN NOT ATOMIC\n"
  "  DECLARE EXIT HANDLER FOR SQLEXCEPTION\n"
  "  BEGIN\n"
  "  END;\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$innodb_buffer_stats_by_schema (\n"
  "  object_schema,\n"
  "  allocated,\n"
  "  data,\n"
  "  pages,\n"
  "  pages_hashed,\n"
  "  pages_old,\n"
  "  rows_cached\n"
  ") AS\n"
  "SELECT IF(LOCATE('.', ibp.table_name) = 0, 'InnoDB System', REPLACE(SUBSTRING_INDEX(ibp.table_name, '.', 1), '`', '')) AS object_schema,\n"
  "       SUM(IF(ibp.compressed_size = 0, 16384, compressed_size)) AS allocated,\n"
  "       SUM(ibp.data_size) AS data,\n"
  "       COUNT(ibp.page_number) AS pages,\n"
  "       COUNT(IF(ibp.is_hashed, 1, NULL)) AS pages_hashed,\n"
  "       COUNT(IF(ibp.is_old, 1, NULL)) AS pages_old,\n"
  "       ROUND(IFNULL(SUM(ibp.number_records)/NULLIF(COUNT(DISTINCT ibp.index_name), 0), 0)) AS rows_cached\n"
  "  FROM information_schema.innodb_buffer_page ibp\n"
  " WHERE table_name IS NOT NULL\n"
  " GROUP BY object_schema\n"
  " ORDER BY SUM(IF(ibp.compressed_size = 0, 16384, compressed_size)) DESC;\n"
  "END$$\n",
"DELIMITER ;\n",
"DELIMITER $$\n",
"BEGIN NOT ATOMIC\n"
  "DECLARE EXIT HANDLER FOR SQLEXCEPTION BEGIN END;\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW innodb_buffer_stats_by_table (\n"
  "  object_schema,\n"
  "  object_name,\n"
  "  allocated,\n"
  "  data,\n"
  "  pages,\n"
  "  pages_hashed,\n"
  "  pages_old,\n"
  "  rows_cached\n"
  ") AS\n"
  "SELECT IF(LOCATE('.', ibp.table_name) = 0, 'InnoDB System', REPLACE(SUBSTRING_INDEX(ibp.table_name, '.', 1), '`', '')) AS object_schema,\n"
  "       REPLACE(SUBSTRING_INDEX(ibp.table_name, '.', -1), '`', '') AS object_name,\n"
  "       format_bytes(SUM(IF(ibp.compressed_size = 0, 16384, compressed_size))) AS allocated,\n"
  "       format_bytes(SUM(ibp.data_size)) AS data,\n"
  "       COUNT(ibp.page_number) AS pages,\n"
  "       COUNT(IF(ibp.is_hashed, 1, NULL)) AS pages_hashed,\n"
  "       COUNT(IF(ibp.is_old, 1, NULL)) AS pages_old,\n"
  "       ROUND(SUM(ibp.number_records)/COUNT(DISTINCT ibp.index_name)) AS rows_cached\n"
  "  FROM information_schema.innodb_buffer_page ibp\n"
  " WHERE table_name IS NOT NULL\n"
  " GROUP BY object_schema, object_name\n"
  " ORDER BY SUM(IF(ibp.compressed_size = 0, 16384, compressed_size)) DESC;\n"
  "END$$\n",
"DELIMITER ;\n",
"DELIMITER $$\n",
"BEGIN NOT ATOMIC\n"
  "DECLARE EXIT HANDLER FOR SQLEXCEPTION BEGIN END;\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$innodb_buffer_stats_by_table (\n"
  "  object_schema,\n"
  "  object_name,\n"
  "  allocated,\n"
  "  data,\n"
  "  pages,\n"
  "  pages_hashed,\n"
  "  pages_old,\n"
  "  rows_cached\n"
  ") AS\n"
  "SELECT IF(LOCATE('.', ibp.table_name) = 0, 'InnoDB System', REPLACE(SUBSTRING_INDEX(ibp.table_name, '.', 1), '`', '')) AS object_schema,\n"
  "       REPLACE(SUBSTRING_INDEX(ibp.table_name, '.', -1), '`', '') AS object_name,\n"
  "       SUM(IF(ibp.compressed_size = 0, 16384, compressed_size)) AS allocated,\n"
  "       SUM(ibp.data_size) AS data,\n"
  "       COUNT(ibp.page_number) AS pages,\n"
  "       COUNT(IF(ibp.is_hashed, 1, NULL)) AS pages_hashed,\n"
  "       COUNT(IF(ibp.is_old, 1, NULL)) AS pages_old,\n"
  "       ROUND(IFNULL(SUM(ibp.number_records)/NULLIF(COUNT(DISTINCT ibp.index_name), 0), 0)) AS rows_cached\n"
  "  FROM information_schema.innodb_buffer_page ibp\n"
  " WHERE table_name IS NOT NULL\n"
  " GROUP BY object_schema, object_name\n"
  " ORDER BY SUM(IF(ibp.compressed_size = 0, 16384, compressed_size)) DESC;\n"
  "END$$\n",
"DELIMITER ;\n",
"DELIMITER $$\n",
"BEGIN NOT ATOMIC\n"
  "  DECLARE EXIT HANDLER FOR SQLEXCEPTION\n"
  "  BEGIN\n"
  "  END;\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW innodb_lock_waits (\n"
  "  wait_started,\n"
  "  wait_age,\n"
  "  wait_age_secs,\n"
  "  locked_table,\n"
  "  locked_index,\n"
  "  locked_type,\n"
  "  waiting_trx_id,\n"
  "  waiting_trx_started,\n"
  "  waiting_trx_age,\n"
  "  waiting_trx_rows_locked,\n"
  "  waiting_trx_rows_modified,\n"
  "  waiting_pid,\n"
  "  waiting_query,\n"
  "  waiting_lock_id,\n"
  "  waiting_lock_mode,\n"
  "  blocking_trx_id,\n"
  "  blocking_pid,\n"
  "  blocking_query,\n"
  "  blocking_lock_id,\n"
  "  blocking_lock_mode,\n"
  "  blocking_trx_started,\n"
  "  blocking_trx_age,\n"
  "  blocking_trx_rows_locked,\n"
  "  blocking_trx_rows_modified,\n"
  "  sql_kill_blocking_query,\n"
  "  sql_kill_blocking_connection\n"
  ") AS\n"
  "SELECT r.trx_wait_started AS wait_started,\n"
  "       TIMEDIFF(NOW(), r.trx_wait_started) AS wait_age,\n"
  "       TIMESTAMPDIFF(SECOND, r.trx_wait_started, NOW()) AS wait_age_secs,\n"
  "       rl.lock_table AS locked_table,\n"
  "       rl.lock_index AS locked_index,\n"
  "       rl.lock_type AS locked_type,\n"
  "       r.trx_id AS waiting_trx_id,\n"
  "       r.trx_started as waiting_trx_started,\n"
  "       TIMEDIFF(NOW(), r.trx_started) AS waiting_trx_age,\n"
  "       r.trx_rows_locked AS waiting_trx_rows_locked,\n"
  "       r.trx_rows_modified AS waiting_trx_rows_modified,\n"
  "       r.trx_mysql_thread_id AS waiting_pid,\n"
  "       sys.format_statement(r.trx_query) AS waiting_query,\n"
  "       rl.lock_id AS waiting_lock_id,\n"
  "       rl.lock_mode AS waiting_lock_mode,\n"
  "       b.trx_id AS blocking_trx_id,\n"
  "       b.trx_mysql_thread_id AS blocking_pid,\n"
  "       sys.format_statement(b.trx_query) AS blocking_query,\n"
  "       bl.lock_id AS blocking_lock_id,\n"
  "       bl.lock_mode AS blocking_lock_mode,\n"
  "       b.trx_started AS blocking_trx_started,\n"
  "       TIMEDIFF(NOW(), b.trx_started) AS blocking_trx_age,\n"
  "       b.trx_rows_locked AS blocking_trx_rows_locked,\n"
  "       b.trx_rows_modified AS blocking_trx_rows_modified,\n"
  "       CONCAT('KILL QUERY ', b.trx_mysql_thread_id) AS sql_kill_blocking_query,\n"
  "       CONCAT('KILL ', b.trx_mysql_thread_id) AS sql_kill_blocking_connection\n"
  "  FROM information_schema.innodb_lock_waits w\n"
  "       INNER JOIN information_schema.innodb_trx b    ON b.trx_id = w.blocking_trx_id\n"
  "       INNER JOIN information_schema.innodb_trx r    ON r.trx_id = w.requesting_trx_id\n"
  "       INNER JOIN information_schema.innodb_locks bl ON bl.lock_id = w.blocking_lock_id\n"
  "       INNER JOIN information_schema.innodb_locks rl ON rl.lock_id = w.requested_lock_id\n"
  " ORDER BY r.trx_wait_started;\n"
  " END$$\n",
"DELIMITER ;\n",
"DELIMITER $$\n",
"BEGIN NOT ATOMIC\n"
  "DECLARE EXIT HANDLER FOR SQLEXCEPTION BEGIN END;\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$innodb_lock_waits (\n"
  "  wait_started,\n"
  "  wait_age,\n"
  "  wait_age_secs,\n"
  "  locked_table,\n"
  "  locked_index,\n"
  "  locked_type,\n"
  "  waiting_trx_id,\n"
  "  waiting_trx_started,\n"
  "  waiting_trx_age,\n"
  "  waiting_trx_rows_locked,\n"
  "  waiting_trx_rows_modified,\n"
  "  waiting_pid,\n"
  "  waiting_query,\n"
  "  waiting_lock_id,\n"
  "  waiting_lock_mode,\n"
  "  blocking_trx_id,\n"
  "  blocking_pid,\n"
  "  blocking_query,\n"
  "  blocking_lock_id,\n"
  "  blocking_lock_mode,\n"
  "  blocking_trx_started,\n"
  "  blocking_trx_age,\n"
  "  blocking_trx_rows_locked,\n"
  "  blocking_trx_rows_modified,\n"
  "  sql_kill_blocking_query,\n"
  "  sql_kill_blocking_connection\n"
  ") AS\n"
  "SELECT r.trx_wait_started AS wait_started,\n"
  "       TIMEDIFF(NOW(), r.trx_wait_started) AS wait_age,\n"
  "       TIMESTAMPDIFF(SECOND, r.trx_wait_started, NOW()) AS wait_age_secs,\n"
  "       rl.lock_table AS locked_table,\n"
  "       rl.lock_index AS locked_index,\n"
  "       rl.lock_type AS locked_type,\n"
  "       r.trx_id AS waiting_trx_id,\n"
  "       r.trx_started as waiting_trx_started,\n"
  "       TIMEDIFF(NOW(), r.trx_started) AS waiting_trx_age,\n"
  "       r.trx_rows_locked AS waiting_trx_rows_locked,\n"
  "       r.trx_rows_modified AS waiting_trx_rows_modified,\n"
  "       r.trx_mysql_thread_id AS waiting_pid,\n"
  "       r.trx_query AS waiting_query,\n"
  "       rl.lock_id AS waiting_lock_id,\n"
  "       rl.lock_mode AS waiting_lock_mode,\n"
  "       b.trx_id AS blocking_trx_id,\n"
  "       b.trx_mysql_thread_id AS blocking_pid,\n"
  "       b.trx_query AS blocking_query,\n"
  "       bl.lock_id AS blocking_lock_id,\n"
  "       bl.lock_mode AS blocking_lock_mode,\n"
  "       b.trx_started AS blocking_trx_started,\n"
  "       TIMEDIFF(NOW(), b.trx_started) AS blocking_trx_age,\n"
  "       b.trx_rows_locked AS blocking_trx_rows_locked,\n"
  "       b.trx_rows_modified AS blocking_trx_rows_modified,\n"
  "       CONCAT('KILL QUERY ', b.trx_mysql_thread_id) AS sql_kill_blocking_query,\n"
  "       CONCAT('KILL ', b.trx_mysql_thread_id) AS sql_kill_blocking_connection\n"
  "  FROM information_schema.innodb_lock_waits w\n"
  "       INNER JOIN information_schema.innodb_trx b    ON b.trx_id = w.blocking_trx_id\n"
  "       INNER JOIN information_schema.innodb_trx r    ON r.trx_id = w.requesting_trx_id\n"
  "       INNER JOIN information_schema.innodb_locks bl ON bl.lock_id = w.blocking_lock_id\n"
  "       INNER JOIN information_schema.innodb_locks rl ON rl.lock_id = w.requested_lock_id\n"
  " ORDER BY r.trx_wait_started;\n"
  "END$$\n",
"DELIMITER ;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW schema_object_overview (\n"
  "  db,\n"
  "  object_type,\n"
  "  count\n"
  ") AS\n"
  "SELECT ROUTINE_SCHEMA AS db, ROUTINE_TYPE AS object_type, COUNT(*) AS count FROM information_schema.routines GROUP BY ROUTINE_SCHEMA, ROUTINE_TYPE\n"
  " UNION\n"
  "SELECT TABLE_SCHEMA, TABLE_TYPE, COUNT(*) FROM information_schema.tables GROUP BY TABLE_SCHEMA, TABLE_TYPE\n"
  " UNION\n"
  "SELECT TABLE_SCHEMA, CONCAT('INDEX (', INDEX_TYPE, ')'), COUNT(*) FROM information_schema.statistics GROUP BY TABLE_SCHEMA, INDEX_TYPE\n"
  " UNION\n"
  "SELECT TRIGGER_SCHEMA, 'TRIGGER', COUNT(*) FROM information_schema.triggers GROUP BY TRIGGER_SCHEMA\n"
  " UNION\n"
  "SELECT EVENT_SCHEMA, 'EVENT', COUNT(*) FROM information_schema.events GROUP BY EVENT_SCHEMA\n"
  "ORDER BY DB, OBJECT_TYPE;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW schema_auto_increment_columns (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  column_name,\n"
  "  data_type,\n"
  "  column_type,\n"
  "  is_signed,\n"
  "  is_unsigned,\n"
  "  max_value,\n"
  "  auto_increment,\n"
  "  auto_increment_ratio\n"
  ") AS\n"
  "SELECT TABLE_SCHEMA,\n"
  "       TABLE_NAME,\n"
  "       COLUMN_NAME,\n"
  "       DATA_TYPE,\n"
  "       COLUMN_TYPE,\n"
  "       (LOCATE('unsigned', COLUMN_TYPE) = 0) AS is_signed,\n"
  "       (LOCATE('unsigned', COLUMN_TYPE) > 0) AS is_unsigned,\n"
  "       (\n"
  "          CASE DATA_TYPE\n"
  "            WHEN 'tinyint' THEN 255\n"
  "            WHEN 'smallint' THEN 65535\n"
  "            WHEN 'mediumint' THEN 16777215\n"
  "            WHEN 'int' THEN 4294967295\n"
  "            WHEN 'bigint' THEN 18446744073709551615\n"
  "          END >> IF(LOCATE('unsigned', COLUMN_TYPE) > 0, 0, 1)\n"
  "       ) AS max_value,\n"
  "       AUTO_INCREMENT,\n"
  "       AUTO_INCREMENT / (\n"
  "         CASE DATA_TYPE\n"
  "           WHEN 'tinyint' THEN 255\n"
  "           WHEN 'smallint' THEN 65535\n"
  "           WHEN 'mediumint' THEN 16777215\n"
  "           WHEN 'int' THEN 4294967295\n"
  "           WHEN 'bigint' THEN 18446744073709551615\n"
  "         END >> IF(LOCATE('unsigned', COLUMN_TYPE) > 0, 0, 1)\n"
  "       ) AS auto_increment_ratio\n"
  "  FROM INFORMATION_SCHEMA.COLUMNS\n"
  " INNER JOIN INFORMATION_SCHEMA.TABLES USING (TABLE_SCHEMA, TABLE_NAME)\n"
  " WHERE TABLE_SCHEMA NOT IN ('mysql', 'sys', 'INFORMATION_SCHEMA', 'performance_schema')\n"
  "   AND TABLE_TYPE='BASE TABLE'\n"
  "   AND EXTRA='auto_increment'\n"
  " ORDER BY auto_increment_ratio DESC, max_value;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$schema_flattened_keys (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  index_name,\n"
  "  non_unique,\n"
  "  subpart_exists,\n"
  "  index_columns\n"
  ") AS\n"
  "  SELECT\n"
  "    TABLE_SCHEMA,\n"
  "    TABLE_NAME,\n"
  "    INDEX_NAME,\n"
  "    MAX(NON_UNIQUE) AS non_unique,\n"
  "    MAX(IF(SUB_PART IS NULL, 0, 1)) AS subpart_exists,\n"
  "    GROUP_CONCAT(COLUMN_NAME ORDER BY SEQ_IN_INDEX) AS index_columns\n"
  "  FROM INFORMATION_SCHEMA.STATISTICS\n"
  "  WHERE\n"
  "    INDEX_TYPE='BTREE'\n"
  "    AND TABLE_SCHEMA NOT IN ('mysql', 'sys', 'INFORMATION_SCHEMA', 'PERFORMANCE_SCHEMA')\n"
  "  GROUP BY\n"
  "    TABLE_SCHEMA, TABLE_NAME, INDEX_NAME;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW schema_redundant_indexes (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  redundant_index_name,\n"
  "  redundant_index_columns,\n"
  "  redundant_index_non_unique,\n"
  "  dominant_index_name,\n"
  "  dominant_index_columns,\n"
  "  dominant_index_non_unique,\n"
  "  subpart_exists,\n"
  "  sql_drop_index\n"
  ") AS\n"
  "  SELECT\n"
  "    redundant_keys.table_schema,\n"
  "    redundant_keys.table_name,\n"
  "    redundant_keys.index_name AS redundant_index_name,\n"
  "    redundant_keys.index_columns AS redundant_index_columns,\n"
  "    redundant_keys.non_unique AS redundant_index_non_unique,\n"
  "    dominant_keys.index_name AS dominant_index_name,\n"
  "    dominant_keys.index_columns AS dominant_index_columns,\n"
  "    dominant_keys.non_unique AS dominant_index_non_unique,\n"
  "    IF(redundant_keys.subpart_exists OR dominant_keys.subpart_exists, 1 ,0) AS subpart_exists,\n"
  "    CONCAT(\n"
  "      'ALTER TABLE `', redundant_keys.table_schema, '`.`', redundant_keys.table_name, '` DROP INDEX `', redundant_keys.index_name, '`'\n"
  "      ) AS sql_drop_index\n"
  "  FROM\n"
  "    x$schema_flattened_keys AS redundant_keys\n"
  "    INNER JOIN x$schema_flattened_keys AS dominant_keys\n"
  "    USING (TABLE_SCHEMA, TABLE_NAME)\n"
  "  WHERE\n"
  "    redundant_keys.index_name != dominant_keys.index_name\n"
  "    AND (\n"
  "      (\n"
  "        /* Identical columns */\n"
  "        (redundant_keys.index_columns = dominant_keys.index_columns)\n"
  "        AND (\n"
  "          (redundant_keys.non_unique > dominant_keys.non_unique)\n"
  "          OR (redundant_keys.non_unique = dominant_keys.non_unique\n"
  "          	AND IF(redundant_keys.index_name='PRIMARY', '', redundant_keys.index_name) > IF(dominant_keys.index_name='PRIMARY', '', dominant_keys.index_name)\n"
  "          )\n"
  "        )\n"
  "      )\n"
  "      OR\n"
  "      (\n"
  "        /* Non-unique prefix columns */\n"
  "        LOCATE(CONCAT(redundant_keys.index_columns, ','), dominant_keys.index_columns) = 1\n"
  "        AND redundant_keys.non_unique = 1\n"
  "      )\n"
  "      OR\n"
  "      (\n"
  "        /* Unique prefix columns */\n"
  "        LOCATE(CONCAT(dominant_keys.index_columns, ','), redundant_keys.index_columns) = 1\n"
  "        AND dominant_keys.non_unique = 0\n"
  "      )\n"
  "    );\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW privileges_by_table_by_level (\n"
  "  TABLE_SCHEMA,\n"
  "  TABLE_NAME,\n"
  "  GRANTEE,\n"
  "  PRIVILEGE,\n"
  "  LEVEL\n"
  ") AS\n"
  "SELECT t.TABLE_SCHEMA,\n"
  "       t.TABLE_NAME,\n"
  "       privs.GRANTEE,\n"
  "       privs.PRIVILEGE_TYPE,\n"
  "       privs.LEVEL\n"
  "FROM INFORMATION_SCHEMA.TABLES AS t\n"
  "JOIN ( SELECT NULL AS TABLE_SCHEMA,\n"
  "              NULL AS TABLE_NAME,\n"
  "              GRANTEE,\n"
  "              PRIVILEGE_TYPE,\n"
  "             'GLOBAL' LEVEL\n"
  "           FROM INFORMATION_SCHEMA.USER_PRIVILEGES\n"
  "         UNION\n"
  "       SELECT TABLE_SCHEMA,\n"
  "              NULL AS TABLE_NAME,\n"
  "              GRANTEE,\n"
  "              PRIVILEGE_TYPE,\n"
  "              'SCHEMA' LEVEL\n"
  "           FROM INFORMATION_SCHEMA.SCHEMA_PRIVILEGES\n"
  "         UNION\n"
  "       SELECT TABLE_SCHEMA,\n"
  "              TABLE_NAME,\n"
  "              GRANTEE,\n"
  "              PRIVILEGE_TYPE,\n"
  "              'TABLE' LEVEL\n"
  "           FROM INFORMATION_SCHEMA.TABLE_PRIVILEGES\n"
  "       ) privs\n"
  "    ON (t.TABLE_SCHEMA = privs.TABLE_SCHEMA OR privs.TABLE_SCHEMA IS NULL)\n"
  "   AND (t.TABLE_NAME = privs.TABLE_NAME OR privs.TABLE_NAME IS NULL)\n"
  "   AND privs.PRIVILEGE_TYPE IN ('SELECT', 'INSERT', 'UPDATE', 'DELETE',\n"
  "                                'CREATE', 'ALTER', 'DROP', 'INDEX',\n"
  "                                'REFERENCES', 'TRIGGER', 'GRANT OPTION',\n"
  "                                'SHOW VIEW', 'DELETE HISTORY')\n"
  "WHERE t.TABLE_SCHEMA NOT IN ('sys', 'mysql','information_schema',\n"
  "                             'performance_schema');\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW ps_check_lost_instrumentation (\n"
  "  variable_name,\n"
  "  variable_value\n"
  ")\n"
  "AS\n"
  "SELECT variable_name, variable_value\n"
  "  FROM performance_schema.global_status\n"
  " WHERE variable_name LIKE 'perf%lost'\n"
  "   AND variable_value > 0;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW latest_file_io (\n"
  "  thread,\n"
  "  file,\n"
  "  latency,\n"
  "  operation,\n"
  "  requested\n"
  ") AS\n"
  "SELECT IF(id IS NULL,\n"
  "             CONCAT(SUBSTRING_INDEX(name, '/', -1), ':', thread_id),\n"
  "             CONCAT(user, '@', host, ':', id)\n"
  "          ) thread,\n"
  "       sys.format_path(object_name) file,\n"
  "       format_pico_time(timer_wait) AS latency,\n"
  "       operation,\n"
  "       format_bytes(number_of_bytes) AS requested\n"
  "  FROM performance_schema.events_waits_history_long\n"
  "  JOIN performance_schema.threads USING (thread_id)\n"
  "  LEFT JOIN information_schema.processlist ON processlist_id = id\n"
  " WHERE object_name IS NOT NULL\n"
  "   AND event_name LIKE 'wait/io/file/%'\n"
  " ORDER BY timer_start;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$latest_file_io (\n"
  "  thread,\n"
  "  file,\n"
  "  latency,\n"
  "  operation,\n"
  "  requested\n"
  ") AS\n"
  "SELECT IF(id IS NULL,\n"
  "             CONCAT(SUBSTRING_INDEX(name, '/', -1), ':', thread_id),\n"
  "             CONCAT(user, '@', host, ':', id)\n"
  "          ) thread,\n"
  "       object_name file,\n"
  "       timer_wait AS latency,\n"
  "       operation,\n"
  "       number_of_bytes AS requested\n"
  "  FROM performance_schema.events_waits_history_long\n"
  "  JOIN performance_schema.threads USING (thread_id)\n"
  "  LEFT JOIN information_schema.processlist ON processlist_id = id\n"
  " WHERE object_name IS NOT NULL\n"
  "   AND event_name LIKE 'wait/io/file/%'\n"
  " ORDER BY timer_start;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW io_by_thread_by_latency (\n"
  "  user,\n"
  "  total,\n"
  "  total_latency,\n"
  "  min_latency,\n"
  "  avg_latency,\n"
  "  max_latency,\n"
  "  thread_id,\n"
  "  processlist_id\n"
  ")\n"
  "AS\n"
  "SELECT IF(processlist_id IS NULL,\n"
  "             SUBSTRING_INDEX(name, '/', -1),\n"
  "             CONCAT(processlist_user, '@', processlist_host)\n"
  "          ) user,\n"
  "       SUM(count_star) total,\n"
  "       format_pico_time(SUM(sum_timer_wait)) total_latency,\n"
  "       format_pico_time(MIN(min_timer_wait)) min_latency,\n"
  "       format_pico_time(AVG(avg_timer_wait)) avg_latency,\n"
  "       format_pico_time(MAX(max_timer_wait)) max_latency,\n"
  "       thread_id,\n"
  "       processlist_id\n"
  "  FROM performance_schema.events_waits_summary_by_thread_by_event_name\n"
  "  LEFT JOIN performance_schema.threads USING (thread_id)\n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  "   AND sum_timer_wait > 0\n"
  " GROUP BY thread_id, processlist_id, user\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$io_by_thread_by_latency (\n"
  "  user,\n"
  "  total,\n"
  "  total_latency,\n"
  "  min_latency,\n"
  "  avg_latency,\n"
  "  max_latency,\n"
  "  thread_id,\n"
  "  processlist_id\n"
  ")\n"
  "AS\n"
  "SELECT IF(processlist_id IS NULL,\n"
  "             SUBSTRING_INDEX(name, '/', -1),\n"
  "             CONCAT(processlist_user, '@', processlist_host)\n"
  "          ) user,\n"
  "       SUM(count_star) total,\n"
  "       SUM(sum_timer_wait) total_latency,\n"
  "       MIN(min_timer_wait) min_latency,\n"
  "       AVG(avg_timer_wait) avg_latency,\n"
  "       MAX(max_timer_wait) max_latency,\n"
  "       thread_id,\n"
  "       processlist_id\n"
  "  FROM performance_schema.events_waits_summary_by_thread_by_event_name\n"
  "  LEFT JOIN performance_schema.threads USING (thread_id)\n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  "   AND sum_timer_wait > 0\n"
  " GROUP BY thread_id, processlist_id, user\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW io_global_by_file_by_bytes (\n"
  "  file,\n"
  "  count_read,\n"
  "  total_read,\n"
  "  avg_read,\n"
  "  count_write,\n"
  "  total_written,\n"
  "  avg_write,\n"
  "  total,\n"
  "  write_pct\n"
  ") AS\n"
  "SELECT sys.format_path(file_name) AS file,\n"
  "       count_read,\n"
  "       format_bytes(sum_number_of_bytes_read) AS total_read,\n"
  "       format_bytes(IFNULL(sum_number_of_bytes_read / NULLIF(count_read, 0), 0)) AS avg_read,\n"
  "       count_write,\n"
  "       format_bytes(sum_number_of_bytes_write) AS total_written,\n"
  "       format_bytes(IFNULL(sum_number_of_bytes_write / NULLIF(count_write, 0), 0.00)) AS avg_write,\n"
  "       format_bytes(sum_number_of_bytes_read + sum_number_of_bytes_write) AS total,\n"
  "       IFNULL(ROUND(100-((sum_number_of_bytes_read/ NULLIF((sum_number_of_bytes_read+sum_number_of_bytes_write), 0))*100), 2), 0.00) AS write_pct\n"
  "  FROM performance_schema.file_summary_by_instance\n"
  " ORDER BY sum_number_of_bytes_read + sum_number_of_bytes_write DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$io_global_by_file_by_bytes (\n"
  "  file,\n"
  "  count_read,\n"
  "  total_read,\n"
  "  avg_read,\n"
  "  count_write,\n"
  "  total_written,\n"
  "  avg_write,\n"
  "  total,\n"
  "  write_pct\n"
  ") AS\n"
  "SELECT file_name AS file,\n"
  "       count_read,\n"
  "       sum_number_of_bytes_read AS total_read,\n"
  "       IFNULL(sum_number_of_bytes_read / NULLIF(count_read, 0), 0) AS avg_read,\n"
  "       count_write,\n"
  "       sum_number_of_bytes_write AS total_written,\n"
  "       IFNULL(sum_number_of_bytes_write / NULLIF(count_write, 0), 0.00) AS avg_write,\n"
  "       sum_number_of_bytes_read + sum_number_of_bytes_write AS total,\n"
  "       IFNULL(ROUND(100-((sum_number_of_bytes_read/ NULLIF((sum_number_of_bytes_read+sum_number_of_bytes_write), 0))*100), 2), 0.00) AS write_pct\n"
  "  FROM performance_schema.file_summary_by_instance\n"
  " ORDER BY sum_number_of_bytes_read + sum_number_of_bytes_write DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW io_global_by_file_by_latency (\n"
  "  file,\n"
  "  total,\n"
  "  total_latency,\n"
  "  count_read,\n"
  "  read_latency,\n"
  "  count_write,\n"
  "  write_latency,\n"
  "  count_misc,\n"
  "  misc_latency\n"
  ") AS\n"
  "SELECT sys.format_path(file_name) AS file,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       count_read,\n"
  "       format_pico_time(sum_timer_read) AS read_latency,\n"
  "       count_write,\n"
  "       format_pico_time(sum_timer_write) AS write_latency,\n"
  "       count_misc,\n"
  "       format_pico_time(sum_timer_misc) AS misc_latency\n"
  "  FROM performance_schema.file_summary_by_instance\n"
  " ORDER BY sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$io_global_by_file_by_latency (\n"
  "  file,\n"
  "  total,\n"
  "  total_latency,\n"
  "  count_read,\n"
  "  read_latency,\n"
  "  count_write,\n"
  "  write_latency,\n"
  "  count_misc,\n"
  "  misc_latency\n"
  ") AS\n"
  "SELECT file_name AS file,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       count_read,\n"
  "       sum_timer_read AS read_latency,\n"
  "       count_write,\n"
  "       sum_timer_write AS write_latency,\n"
  "       count_misc,\n"
  "       sum_timer_misc AS misc_latency\n"
  "  FROM performance_schema.file_summary_by_instance\n"
  " ORDER BY sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW io_global_by_wait_by_bytes (\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  min_latency,\n"
  "  avg_latency,\n"
  "  max_latency,\n"
  "  count_read,\n"
  "  total_read,\n"
  "  avg_read,\n"
  "  count_write,\n"
  "  total_written,\n"
  "  avg_written,\n"
  "  total_requested\n"
  ") AS\n"
  "SELECT SUBSTRING_INDEX(event_name, '/', -2) event_name,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(min_timer_wait) AS min_latency,\n"
  "       format_pico_time(avg_timer_wait) AS avg_latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency,\n"
  "       count_read,\n"
  "       format_bytes(sum_number_of_bytes_read) AS total_read,\n"
  "       format_bytes(IFNULL(sum_number_of_bytes_read / NULLIF(count_read, 0), 0)) AS avg_read,\n"
  "       count_write,\n"
  "       format_bytes(sum_number_of_bytes_write) AS total_written,\n"
  "       format_bytes(IFNULL(sum_number_of_bytes_write / NULLIF(count_write, 0), 0)) AS avg_written,\n"
  "       format_bytes(sum_number_of_bytes_write + sum_number_of_bytes_read) AS total_requested\n"
  "  FROM performance_schema.file_summary_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  "   AND count_star > 0\n"
  " ORDER BY sum_number_of_bytes_write + sum_number_of_bytes_read DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$io_global_by_wait_by_bytes (\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  min_latency,\n"
  "  avg_latency,\n"
  "  max_latency,\n"
  "  count_read,\n"
  "  total_read,\n"
  "  avg_read,\n"
  "  count_write,\n"
  "  total_written,\n"
  "  avg_written,\n"
  "  total_requested\n"
  ") AS\n"
  "SELECT SUBSTRING_INDEX(event_name, '/', -2) AS event_name,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       min_timer_wait AS min_latency,\n"
  "       avg_timer_wait AS avg_latency,\n"
  "       max_timer_wait AS max_latency,\n"
  "       count_read,\n"
  "       sum_number_of_bytes_read AS total_read,\n"
  "       IFNULL(sum_number_of_bytes_read / NULLIF(count_read, 0), 0) AS avg_read,\n"
  "       count_write,\n"
  "       sum_number_of_bytes_write AS total_written,\n"
  "       IFNULL(sum_number_of_bytes_write / NULLIF(count_write, 0), 0) AS avg_written,\n"
  "       sum_number_of_bytes_write + sum_number_of_bytes_read AS total_requested\n"
  "  FROM performance_schema.file_summary_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  "   AND count_star > 0\n"
  " ORDER BY sum_number_of_bytes_write + sum_number_of_bytes_read DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW io_global_by_wait_by_latency (\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency,\n"
  "  max_latency,\n"
  "  read_latency,\n"
  "  write_latency,\n"
  "  misc_latency,\n"
  "  count_read,\n"
  "  total_read,\n"
  "  avg_read,\n"
  "  count_write,\n"
  "  total_written,\n"
  "  avg_written\n"
  ") AS\n"
  "SELECT SUBSTRING_INDEX(event_name, '/', -2) AS event_name,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(avg_timer_wait) AS avg_latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency,\n"
  "       format_pico_time(sum_timer_read) AS read_latency,\n"
  "       format_pico_time(sum_timer_write) AS write_latency,\n"
  "       format_pico_time(sum_timer_misc) AS misc_latency,\n"
  "       count_read,\n"
  "       format_bytes(sum_number_of_bytes_read) AS total_read,\n"
  "       format_bytes(IFNULL(sum_number_of_bytes_read / NULLIF(count_read, 0), 0)) AS avg_read,\n"
  "       count_write,\n"
  "       format_bytes(sum_number_of_bytes_write) AS total_written,\n"
  "       format_bytes(IFNULL(sum_number_of_bytes_write / NULLIF(count_write, 0), 0)) AS avg_written\n"
  "  FROM performance_schema.file_summary_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  "   AND count_star > 0\n"
  " ORDER BY sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$io_global_by_wait_by_latency (\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency,\n"
  "  max_latency,\n"
  "  read_latency,\n"
  "  write_latency,\n"
  "  misc_latency,\n"
  "  count_read,\n"
  "  total_read,\n"
  "  avg_read,\n"
  "  count_write,\n"
  "  total_written,\n"
  "  avg_written\n"
  ") AS\n"
  "SELECT SUBSTRING_INDEX(event_name, '/', -2) AS event_name,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       avg_timer_wait AS avg_latency,\n"
  "       max_timer_wait AS max_latency,\n"
  "       sum_timer_read AS read_latency,\n"
  "       sum_timer_write AS write_latency,\n"
  "       sum_timer_misc AS misc_latency,\n"
  "       count_read,\n"
  "       sum_number_of_bytes_read AS total_read,\n"
  "       IFNULL(sum_number_of_bytes_read / NULLIF(count_read, 0), 0) AS avg_read,\n"
  "       count_write,\n"
  "       sum_number_of_bytes_write AS total_written,\n"
  "       IFNULL(sum_number_of_bytes_write / NULLIF(count_write, 0), 0) AS avg_written\n"
  "  FROM performance_schema.file_summary_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  "   AND count_star > 0\n"
  " ORDER BY sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW memory_by_user_by_current_bytes (\n"
  "  user,\n"
  "  current_count_used,\n"
  "  current_allocated,\n"
  "  current_avg_alloc,\n"
  "  current_max_alloc,\n"
  "  total_allocated\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       SUM(current_count_used) AS current_count_used,\n"
  "       format_bytes(SUM(current_number_of_bytes_used)) AS current_allocated,\n"
  "       format_bytes(IFNULL(SUM(current_number_of_bytes_used) / NULLIF(SUM(current_count_used), 0), 0)) AS current_avg_alloc,\n"
  "       format_bytes(MAX(current_number_of_bytes_used)) AS current_max_alloc,\n"
  "       format_bytes(SUM(sum_number_of_bytes_alloc)) AS total_allocated\n"
  "  FROM performance_schema.memory_summary_by_user_by_event_name\n"
  " GROUP BY IF(user IS NULL, 'background', user)\n"
  " ORDER BY SUM(current_number_of_bytes_used) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$memory_by_user_by_current_bytes (\n"
  "  user,\n"
  "  current_count_used,\n"
  "  current_allocated,\n"
  "  current_avg_alloc,\n"
  "  current_max_alloc,\n"
  "  total_allocated\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       SUM(current_count_used) AS current_count_used,\n"
  "       SUM(current_number_of_bytes_used) AS current_allocated,\n"
  "       IFNULL(SUM(current_number_of_bytes_used) / NULLIF(SUM(current_count_used), 0), 0) AS current_avg_alloc,\n"
  "       MAX(current_number_of_bytes_used) AS current_max_alloc,\n"
  "       SUM(sum_number_of_bytes_alloc) AS total_allocated\n"
  "  FROM performance_schema.memory_summary_by_user_by_event_name\n"
  " GROUP BY IF(user IS NULL, 'background', user)\n"
  " ORDER BY SUM(current_number_of_bytes_used) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW memory_by_host_by_current_bytes (\n"
  "  host,\n"
  "  current_count_used,\n"
  "  current_allocated,\n"
  "  current_avg_alloc,\n"
  "  current_max_alloc,\n"
  "  total_allocated\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       SUM(current_count_used) AS current_count_used,\n"
  "       format_bytes(SUM(current_number_of_bytes_used)) AS current_allocated,\n"
  "       format_bytes(IFNULL(SUM(current_number_of_bytes_used) / NULLIF(SUM(current_count_used), 0), 0)) AS current_avg_alloc,\n"
  "       format_bytes(MAX(current_number_of_bytes_used)) AS current_max_alloc,\n"
  "       format_bytes(SUM(sum_number_of_bytes_alloc)) AS total_allocated\n"
  "  FROM performance_schema.memory_summary_by_host_by_event_name\n"
  " GROUP BY IF(host IS NULL, 'background', host)\n"
  " ORDER BY SUM(current_number_of_bytes_used) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$memory_by_host_by_current_bytes (\n"
  "  host,\n"
  "  current_count_used,\n"
  "  current_allocated,\n"
  "  current_avg_alloc,\n"
  "  current_max_alloc,\n"
  "  total_allocated\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       SUM(current_count_used) AS current_count_used,\n"
  "       SUM(current_number_of_bytes_used) AS current_allocated,\n"
  "       IFNULL(SUM(current_number_of_bytes_used) / NULLIF(SUM(current_count_used), 0), 0) AS current_avg_alloc,\n"
  "       MAX(current_number_of_bytes_used) AS current_max_alloc,\n"
  "       SUM(sum_number_of_bytes_alloc) AS total_allocated\n"
  "  FROM performance_schema.memory_summary_by_host_by_event_name\n"
  " GROUP BY IF(host IS NULL, 'background', host)\n"
  " ORDER BY SUM(current_number_of_bytes_used) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW memory_by_thread_by_current_bytes (\n"
  "  thread_id,\n"
  "  user,\n"
  "  current_count_used,\n"
  "  current_allocated,\n"
  "  current_avg_alloc,\n"
  "  current_max_alloc,\n"
  "  total_allocated\n"
  ") AS\n"
  "SELECT thread_id,\n"
  "       IF(t.name = 'thread/sql/one_connection',\n"
  "          CONCAT(t.processlist_user, '@', t.processlist_host),\n"
  "          REPLACE(t.name, 'thread/', '')) user,\n"
  "       SUM(mt.current_count_used) AS current_count_used,\n"
  "       format_bytes(SUM(mt.current_number_of_bytes_used)) AS current_allocated,\n"
  "       format_bytes(IFNULL(SUM(mt.current_number_of_bytes_used) / NULLIF(SUM(current_count_used), 0), 0)) AS current_avg_alloc,\n"
  "       format_bytes(MAX(mt.current_number_of_bytes_used)) AS current_max_alloc,\n"
  "       format_bytes(SUM(mt.sum_number_of_bytes_alloc)) AS total_allocated\n"
  "  FROM performance_schema.memory_summary_by_thread_by_event_name AS mt\n"
  "  JOIN performance_schema.threads AS t USING (thread_id)\n"
  " GROUP BY thread_id, IF(t.name = 'thread/sql/one_connection',\n"
  "          CONCAT(t.processlist_user, '@', t.processlist_host),\n"
  "          REPLACE(t.name, 'thread/', ''))\n"
  " ORDER BY SUM(current_number_of_bytes_used) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$memory_by_thread_by_current_bytes (\n"
  "  thread_id,\n"
  "  user,\n"
  "  current_count_used,\n"
  "  current_allocated,\n"
  "  current_avg_alloc,\n"
  "  current_max_alloc,\n"
  "  total_allocated\n"
  ") AS\n"
  "SELECT t.thread_id,\n"
  "       IF(t.name = 'thread/sql/one_connection',\n"
  "          CONCAT(t.processlist_user, '@', t.processlist_host),\n"
  "          REPLACE(t.name, 'thread/', '')) user,\n"
  "       SUM(mt.current_count_used) AS current_count_used,\n"
  "       SUM(mt.current_number_of_bytes_used) AS current_allocated,\n"
  "       IFNULL(SUM(mt.current_number_of_bytes_used) / NULLIF(SUM(current_count_used), 0), 0) AS current_avg_alloc,\n"
  "       MAX(mt.current_number_of_bytes_used) AS current_max_alloc,\n"
  "       SUM(mt.sum_number_of_bytes_alloc) AS total_allocated\n"
  "  FROM performance_schema.memory_summary_by_thread_by_event_name AS mt\n"
  "  JOIN performance_schema.threads AS t USING (thread_id)\n"
  " GROUP BY thread_id, IF(t.name = 'thread/sql/one_connection',\n"
  "          CONCAT(t.processlist_user, '@', t.processlist_host),\n"
  "          REPLACE(t.name, 'thread/', ''))\n"
  " ORDER BY SUM(mt.current_number_of_bytes_used) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW memory_global_by_current_bytes (\n"
  "  event_name,\n"
  "  current_count,\n"
  "  current_alloc,\n"
  "  current_avg_alloc,\n"
  "  high_count,\n"
  "  high_alloc,\n"
  "  high_avg_alloc\n"
  ") AS\n"
  "SELECT event_name,\n"
  "       current_count_used AS current_count,\n"
  "       format_bytes(current_number_of_bytes_used) AS current_alloc,\n"
  "       format_bytes(IFNULL(current_number_of_bytes_used / NULLIF(current_count_used, 0), 0)) AS current_avg_alloc,\n"
  "       high_count_used AS high_count,\n"
  "       format_bytes(high_number_of_bytes_used) AS high_alloc,\n"
  "       format_bytes(IFNULL(high_number_of_bytes_used / NULLIF(high_count_used, 0), 0)) AS high_avg_alloc\n"
  "  FROM performance_schema.memory_summary_global_by_event_name\n"
  " WHERE current_number_of_bytes_used > 0\n"
  " ORDER BY current_number_of_bytes_used DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$memory_global_by_current_bytes (\n"
  "  event_name,\n"
  "  current_count,\n"
  "  current_alloc,\n"
  "  current_avg_alloc,\n"
  "  high_count,\n"
  "  high_alloc,\n"
  "  high_avg_alloc\n"
  ") AS\n"
  "SELECT event_name,\n"
  "       current_count_used AS current_count,\n"
  "       current_number_of_bytes_used AS current_alloc,\n"
  "       IFNULL(current_number_of_bytes_used / NULLIF(current_count_used, 0), 0) AS current_avg_alloc,\n"
  "       high_count_used AS high_count,\n"
  "       high_number_of_bytes_used AS high_alloc,\n"
  "       IFNULL(high_number_of_bytes_used / NULLIF(high_count_used, 0), 0) AS high_avg_alloc\n"
  "  FROM performance_schema.memory_summary_global_by_event_name\n"
  " WHERE current_number_of_bytes_used > 0\n"
  " ORDER BY current_number_of_bytes_used DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW memory_global_total (\n"
  "  total_allocated\n"
  ") AS\n"
  "SELECT format_bytes(SUM(CURRENT_NUMBER_OF_BYTES_USED)) total_allocated\n"
  "  FROM performance_schema.memory_summary_global_by_event_name;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$memory_global_total (\n"
  "  total_allocated\n"
  ") AS\n"
  "SELECT SUM(CURRENT_NUMBER_OF_BYTES_USED) total_allocated\n"
  "  FROM performance_schema.memory_summary_global_by_event_name;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW schema_index_statistics (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  index_name,\n"
  "  rows_selected,\n"
  "  select_latency,\n"
  "  rows_inserted,\n"
  "  insert_latency,\n"
  "  rows_updated,\n"
  "  update_latency,\n"
  "  rows_deleted,\n"
  "  delete_latency\n"
  ") AS\n"
  "SELECT OBJECT_SCHEMA AS table_schema,\n"
  "       OBJECT_NAME AS table_name,\n"
  "       INDEX_NAME as index_name,\n"
  "       COUNT_FETCH AS rows_selected,\n"
  "       format_pico_time(SUM_TIMER_FETCH) AS select_latency,\n"
  "       COUNT_INSERT AS rows_inserted,\n"
  "       format_pico_time(SUM_TIMER_INSERT) AS insert_latency,\n"
  "       COUNT_UPDATE AS rows_updated,\n"
  "       format_pico_time(SUM_TIMER_UPDATE) AS update_latency,\n"
  "       COUNT_DELETE AS rows_deleted,\n"
  "       format_pico_time(SUM_TIMER_INSERT) AS delete_latency\n"
  "  FROM performance_schema.table_io_waits_summary_by_index_usage\n"
  " WHERE index_name IS NOT NULL\n"
  " ORDER BY sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$schema_index_statistics (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  index_name,\n"
  "  rows_selected,\n"
  "  select_latency,\n"
  "  rows_inserted,\n"
  "  insert_latency,\n"
  "  rows_updated,\n"
  "  update_latency,\n"
  "  rows_deleted,\n"
  "  delete_latency\n"
  ") AS\n"
  "SELECT OBJECT_SCHEMA AS table_schema,\n"
  "       OBJECT_NAME AS table_name,\n"
  "       INDEX_NAME as index_name,\n"
  "       COUNT_FETCH AS rows_selected,\n"
  "       SUM_TIMER_FETCH AS select_latency,\n"
  "       COUNT_INSERT AS rows_inserted,\n"
  "       SUM_TIMER_INSERT AS insert_latency,\n"
  "       COUNT_UPDATE AS rows_updated,\n"
  "       SUM_TIMER_UPDATE AS update_latency,\n"
  "       COUNT_DELETE AS rows_deleted,\n"
  "       SUM_TIMER_INSERT AS delete_latency\n"
  "  FROM performance_schema.table_io_waits_summary_by_index_usage\n"
  " WHERE index_name IS NOT NULL\n"
  " ORDER BY sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$ps_schema_table_statistics_io (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  count_read,\n"
  "  sum_number_of_bytes_read,\n"
  "  sum_timer_read,\n"
  "  count_write,\n"
  "  sum_number_of_bytes_write,\n"
  "  sum_timer_write,\n"
  "  count_misc,\n"
  "  sum_timer_misc\n"
  ") AS\n"
  "SELECT extract_schema_from_file_name(file_name) AS table_schema,\n"
  "       extract_table_from_file_name(file_name) AS table_name,\n"
  "       SUM(count_read) AS count_read,\n"
  "       SUM(sum_number_of_bytes_read) AS sum_number_of_bytes_read,\n"
  "       SUM(sum_timer_read) AS sum_timer_read,\n"
  "       SUM(count_write) AS count_write,\n"
  "       SUM(sum_number_of_bytes_write) AS sum_number_of_bytes_write,\n"
  "       SUM(sum_timer_write) AS sum_timer_write,\n"
  "       SUM(count_misc) AS count_misc,\n"
  "       SUM(sum_timer_misc) AS sum_timer_misc\n"
  "  FROM performance_schema.file_summary_by_instance\n"
  " GROUP BY table_schema, table_name;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW schema_table_statistics (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  total_latency,\n"
  "  rows_fetched,\n"
  "  fetch_latency,\n"
  "  rows_inserted,\n"
  "  insert_latency,\n"
  "  rows_updated,\n"
  "  update_latency,\n"
  "  rows_deleted,\n"
  "  delete_latency,\n"
  "  io_read_requests,\n"
  "  io_read,\n"
  "  io_read_latency,\n"
  "  io_write_requests,\n"
  "  io_write,\n"
  "  io_write_latency,\n"
  "  io_misc_requests,\n"
  "  io_misc_latency\n"
  ") AS\n"
  "SELECT pst.object_schema AS table_schema,\n"
  "       pst.object_name AS table_name,\n"
  "       format_pico_time(pst.sum_timer_wait) AS total_latency,\n"
  "       pst.count_fetch AS rows_fetched,\n"
  "       format_pico_time(pst.sum_timer_fetch) AS fetch_latency,\n"
  "       pst.count_insert AS rows_inserted,\n"
  "       format_pico_time(pst.sum_timer_insert) AS insert_latency,\n"
  "       pst.count_update AS rows_updated,\n"
  "       format_pico_time(pst.sum_timer_update) AS update_latency,\n"
  "       pst.count_delete AS rows_deleted,\n"
  "       format_pico_time(pst.sum_timer_delete) AS delete_latency,\n"
  "       fsbi.count_read AS io_read_requests,\n"
  "       format_bytes(fsbi.sum_number_of_bytes_read) AS io_read,\n"
  "       format_pico_time(fsbi.sum_timer_read) AS io_read_latency,\n"
  "       fsbi.count_write AS io_write_requests,\n"
  "       format_bytes(fsbi.sum_number_of_bytes_write) AS io_write,\n"
  "       format_pico_time(fsbi.sum_timer_write) AS io_write_latency,\n"
  "       fsbi.count_misc AS io_misc_requests,\n"
  "       format_pico_time(fsbi.sum_timer_misc) AS io_misc_latency\n"
  "  FROM performance_schema.table_io_waits_summary_by_table AS pst\n"
  "  LEFT JOIN x$ps_schema_table_statistics_io AS fsbi\n"
  "    ON pst.object_schema = fsbi.table_schema\n"
  "   AND pst.object_name = fsbi.table_name\n"
  " ORDER BY pst.sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$schema_table_statistics (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  total_latency,\n"
  "  rows_fetched,\n"
  "  fetch_latency,\n"
  "  rows_inserted,\n"
  "  insert_latency,\n"
  "  rows_updated,\n"
  "  update_latency,\n"
  "  rows_deleted,\n"
  "  delete_latency,\n"
  "  io_read_requests,\n"
  "  io_read,\n"
  "  io_read_latency,\n"
  "  io_write_requests,\n"
  "  io_write,\n"
  "  io_write_latency,\n"
  "  io_misc_requests,\n"
  "  io_misc_latency\n"
  ") AS\n"
  "SELECT pst.object_schema AS table_schema,\n"
  "       pst.object_name AS table_name,\n"
  "       pst.sum_timer_wait AS total_latency,\n"
  "       pst.count_fetch AS rows_fetched,\n"
  "       pst.sum_timer_fetch AS fetch_latency,\n"
  "       pst.count_insert AS rows_inserted,\n"
  "       pst.sum_timer_insert AS insert_latency,\n"
  "       pst.count_update AS rows_updated,\n"
  "       pst.sum_timer_update AS update_latency,\n"
  "       pst.count_delete AS rows_deleted,\n"
  "       pst.sum_timer_delete AS delete_latency,\n"
  "       fsbi.count_read AS io_read_requests,\n"
  "       fsbi.sum_number_of_bytes_read AS io_read,\n"
  "       fsbi.sum_timer_read AS io_read_latency,\n"
  "       fsbi.count_write AS io_write_requests,\n"
  "       fsbi.sum_number_of_bytes_write AS io_write,\n"
  "       fsbi.sum_timer_write AS io_write_latency,\n"
  "       fsbi.count_misc AS io_misc_requests,\n"
  "       fsbi.sum_timer_misc AS io_misc_latency\n"
  "  FROM performance_schema.table_io_waits_summary_by_table AS pst\n"
  "  LEFT JOIN x$ps_schema_table_statistics_io AS fsbi\n"
  "    ON pst.object_schema = fsbi.table_schema\n"
  "   AND pst.object_name = fsbi.table_name\n"
  " ORDER BY pst.sum_timer_wait DESC;\n",
"DELIMITER $$\n",
"BEGIN NOT ATOMIC\n"
  "DECLARE EXIT HANDLER FOR SQLEXCEPTION BEGIN END;\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW schema_table_statistics_with_buffer (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  rows_fetched,\n"
  "  fetch_latency,\n"
  "  rows_inserted,\n"
  "  insert_latency,\n"
  "  rows_updated,\n"
  "  update_latency,\n"
  "  rows_deleted,\n"
  "  delete_latency,\n"
  "  io_read_requests,\n"
  "  io_read,\n"
  "  io_read_latency,\n"
  "  io_write_requests,\n"
  "  io_write,\n"
  "  io_write_latency,\n"
  "  io_misc_requests,\n"
  "  io_misc_latency,\n"
  "  innodb_buffer_allocated,\n"
  "  innodb_buffer_data,\n"
  "  innodb_buffer_free,\n"
  "  innodb_buffer_pages,\n"
  "  innodb_buffer_pages_hashed,\n"
  "  innodb_buffer_pages_old,\n"
  "  innodb_buffer_rows_cached\n"
  ") AS\n"
  "SELECT pst.object_schema AS table_schema,\n"
  "       pst.object_name AS table_name,\n"
  "       pst.count_fetch AS rows_fetched,\n"
  "       format_pico_time(pst.sum_timer_fetch) AS fetch_latency,\n"
  "       pst.count_insert AS rows_inserted,\n"
  "       format_pico_time(pst.sum_timer_insert) AS insert_latency,\n"
  "       pst.count_update AS rows_updated,\n"
  "       format_pico_time(pst.sum_timer_update) AS update_latency,\n"
  "       pst.count_delete AS rows_deleted,\n"
  "       format_pico_time(pst.sum_timer_delete) AS delete_latency,\n"
  "       fsbi.count_read AS io_read_requests,\n"
  "       format_bytes(fsbi.sum_number_of_bytes_read) AS io_read,\n"
  "       format_pico_time(fsbi.sum_timer_read) AS io_read_latency,\n"
  "       fsbi.count_write AS io_write_requests,\n"
  "       format_bytes(fsbi.sum_number_of_bytes_write) AS io_write,\n"
  "       format_pico_time(fsbi.sum_timer_write) AS io_write_latency,\n"
  "       fsbi.count_misc AS io_misc_requests,\n"
  "       format_pico_time(fsbi.sum_timer_misc) AS io_misc_latency,\n"
  "       format_bytes(ibp.allocated) AS innodb_buffer_allocated,\n"
  "       format_bytes(ibp.data) AS innodb_buffer_data,\n"
  "       format_bytes(ibp.allocated - ibp.data) AS innodb_buffer_free,\n"
  "       ibp.pages AS innodb_buffer_pages,\n"
  "       ibp.pages_hashed AS innodb_buffer_pages_hashed,\n"
  "       ibp.pages_old AS innodb_buffer_pages_old,\n"
  "       ibp.rows_cached AS innodb_buffer_rows_cached\n"
  "  FROM performance_schema.table_io_waits_summary_by_table AS pst\n"
  "  LEFT JOIN x$ps_schema_table_statistics_io AS fsbi\n"
  "    ON pst.object_schema = fsbi.table_schema\n"
  "   AND pst.object_name = fsbi.table_name\n"
  "  LEFT JOIN sys.x$innodb_buffer_stats_by_table AS ibp\n"
  "    ON pst.object_schema = ibp.object_schema\n"
  "   AND pst.object_name = ibp.object_name\n"
  " ORDER BY pst.sum_timer_wait DESC;\n"
  "END$$\n",
"DELIMITER ;\n",
"DELIMITER $$\n",
"BEGIN NOT ATOMIC\n"
  "DECLARE EXIT HANDLER FOR SQLEXCEPTION BEGIN END;\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$schema_table_statistics_with_buffer (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  rows_fetched,\n"
  "  fetch_latency,\n"
  "  rows_inserted,\n"
  "  insert_latency,\n"
  "  rows_updated,\n"
  "  update_latency,\n"
  "  rows_deleted,\n"
  "  delete_latency,\n"
  "  io_read_requests,\n"
  "  io_read,\n"
  "  io_read_latency,\n"
  "  io_write_requests,\n"
  "  io_write,\n"
  "  io_write_latency,\n"
  "  io_misc_requests,\n"
  "  io_misc_latency,\n"
  "  innodb_buffer_allocated,\n"
  "  innodb_buffer_data,\n"
  "  innodb_buffer_free,\n"
  "  innodb_buffer_pages,\n"
  "  innodb_buffer_pages_hashed,\n"
  "  innodb_buffer_pages_old,\n"
  "  innodb_buffer_rows_cached\n"
  ") AS\n"
  "SELECT pst.object_schema AS table_schema,\n"
  "       pst.object_name AS table_name,\n"
  "       pst.count_fetch AS rows_fetched,\n"
  "       pst.sum_timer_fetch AS fetch_latency,\n"
  "       pst.count_insert AS rows_inserted,\n"
  "       pst.sum_timer_insert AS insert_latency,\n"
  "       pst.count_update AS rows_updated,\n"
  "       pst.sum_timer_update AS update_latency,\n"
  "       pst.count_delete AS rows_deleted,\n"
  "       pst.sum_timer_delete AS delete_latency,\n"
  "       fsbi.count_read AS io_read_requests,\n"
  "       fsbi.sum_number_of_bytes_read AS io_read,\n"
  "       fsbi.sum_timer_read AS io_read_latency,\n"
  "       fsbi.count_write AS io_write_requests,\n"
  "       fsbi.sum_number_of_bytes_write AS io_write,\n"
  "       fsbi.sum_timer_write AS io_write_latency,\n"
  "       fsbi.count_misc AS io_misc_requests,\n"
  "       fsbi.sum_timer_misc AS io_misc_latency,\n"
  "       ibp.allocated AS innodb_buffer_allocated,\n"
  "       ibp.data AS innodb_buffer_data,\n"
  "       (ibp.allocated - ibp.data) AS innodb_buffer_free,\n"
  "       ibp.pages AS innodb_buffer_pages,\n"
  "       ibp.pages_hashed AS innodb_buffer_pages_hashed,\n"
  "       ibp.pages_old AS innodb_buffer_pages_old,\n"
  "       ibp.rows_cached AS innodb_buffer_rows_cached\n"
  "  FROM performance_schema.table_io_waits_summary_by_table AS pst\n"
  "  LEFT JOIN x$ps_schema_table_statistics_io AS fsbi\n"
  "    ON pst.object_schema = fsbi.table_schema\n"
  "   AND pst.object_name = fsbi.table_name\n"
  "  LEFT JOIN sys.x$innodb_buffer_stats_by_table AS ibp\n"
  "    ON pst.object_schema = ibp.object_schema\n"
  "   AND pst.object_name = ibp.object_name\n"
  " ORDER BY pst.sum_timer_wait DESC;\n"
  "END$$\n",
"DELIMITER ;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW schema_tables_with_full_table_scans (\n"
  "  object_schema,\n"
  "  object_name,\n"
  "  rows_full_scanned,\n"
  "  latency\n"
  ") AS\n"
  "SELECT object_schema,\n"
  "       object_name,\n"
  "       count_read AS rows_full_scanned,\n"
  "       format_pico_time(sum_timer_wait) AS latency\n"
  "  FROM performance_schema.table_io_waits_summary_by_index_usage\n"
  " WHERE index_name IS NULL\n"
  "   AND count_read > 0\n"
  " ORDER BY count_read DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$schema_tables_with_full_table_scans (\n"
  "  object_schema,\n"
  "  object_name,\n"
  "  rows_full_scanned,\n"
  "  latency\n"
  ") AS\n"
  "SELECT object_schema,\n"
  "       object_name,\n"
  "       count_read AS rows_full_scanned,\n"
  "       sum_timer_wait AS latency\n"
  "  FROM performance_schema.table_io_waits_summary_by_index_usage\n"
  " WHERE index_name IS NULL\n"
  "   AND count_read > 0\n"
  " ORDER BY count_read DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW schema_unused_indexes (\n"
  "  object_schema,\n"
  "  object_name,\n"
  "  index_name\n"
  ") AS\n"
  "SELECT object_schema,\n"
  "       object_name,\n"
  "       index_name\n"
  "  FROM performance_schema.table_io_waits_summary_by_index_usage\n"
  " WHERE index_name IS NOT NULL\n"
  "   AND count_star = 0\n"
  "   AND object_schema != 'mysql'\n"
  "   AND index_name != 'PRIMARY'\n"
  " ORDER BY object_schema, object_name;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW schema_table_lock_waits (\n"
  "  object_schema,\n"
  "  object_name,\n"
  "  waiting_thread_id,\n"
  "  waiting_pid,\n"
  "  waiting_account,\n"
  "  waiting_lock_type,\n"
  "  waiting_lock_duration,\n"
  "  waiting_query,\n"
  "  waiting_query_secs,\n"
  "  waiting_query_rows_affected,\n"
  "  waiting_query_rows_examined,\n"
  "  blocking_thread_id,\n"
  "  blocking_pid,\n"
  "  blocking_account,\n"
  "  blocking_lock_type,\n"
  "  blocking_lock_duration,\n"
  "  sql_kill_blocking_query,\n"
  "  sql_kill_blocking_connection\n"
  ") AS\n"
  "SELECT g.object_schema AS object_schema,\n"
  "       g.object_name AS object_name,\n"
  "       pt.thread_id AS waiting_thread_id,\n"
  "       pt.processlist_id AS waiting_pid,\n"
  "       sys.ps_thread_account(p.owner_thread_id) AS waiting_account,\n"
  "       p.lock_type AS waiting_lock_type,\n"
  "       p.lock_duration AS waiting_lock_duration,\n"
  "       sys.format_statement(pt.processlist_info) AS waiting_query,\n"
  "       pt.processlist_time AS waiting_query_secs,\n"
  "       ps.rows_affected AS waiting_query_rows_affected,\n"
  "       ps.rows_examined AS waiting_query_rows_examined,\n"
  "       gt.thread_id AS blocking_thread_id,\n"
  "       gt.processlist_id AS blocking_pid,\n"
  "       sys.ps_thread_account(g.owner_thread_id) AS blocking_account,\n"
  "       g.lock_type AS blocking_lock_type,\n"
  "       g.lock_duration AS blocking_lock_duration,\n"
  "       CONCAT('KILL QUERY ', gt.processlist_id) AS sql_kill_blocking_query,\n"
  "       CONCAT('KILL ', gt.processlist_id) AS sql_kill_blocking_connection\n"
  "  FROM performance_schema.metadata_locks g\n"
  " INNER JOIN performance_schema.metadata_locks p\n"
  "    ON g.object_type = p.object_type\n"
  "   AND g.object_schema = p.object_schema\n"
  "   AND g.object_name = p.object_name\n"
  "   AND g.lock_status = 'GRANTED'\n"
  "   AND p.lock_status = 'PENDING'\n"
  " INNER JOIN performance_schema.threads gt ON g.owner_thread_id = gt.thread_id\n"
  " INNER JOIN performance_schema.threads pt ON p.owner_thread_id = pt.thread_id\n"
  "  LEFT JOIN performance_schema.events_statements_current gs ON g.owner_thread_id = gs.thread_id\n"
  "  LEFT JOIN performance_schema.events_statements_current ps ON p.owner_thread_id = ps.thread_id\n"
  " WHERE g.object_type = 'TABLE';\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$schema_table_lock_waits (\n"
  "  object_schema,\n"
  "  object_name,\n"
  "  waiting_thread_id,\n"
  "  waiting_pid,\n"
  "  waiting_account,\n"
  "  waiting_lock_type,\n"
  "  waiting_lock_duration,\n"
  "  waiting_query,\n"
  "  waiting_query_secs,\n"
  "  waiting_query_rows_affected,\n"
  "  waiting_query_rows_examined,\n"
  "  blocking_thread_id,\n"
  "  blocking_pid,\n"
  "  blocking_account,\n"
  "  blocking_lock_type,\n"
  "  blocking_lock_duration,\n"
  "  sql_kill_blocking_query,\n"
  "  sql_kill_blocking_connection\n"
  ") AS\n"
  "SELECT g.object_schema AS object_schema,\n"
  "       g.object_name AS object_name,\n"
  "       pt.thread_id AS waiting_thread_id,\n"
  "       pt.processlist_id AS waiting_pid,\n"
  "       sys.ps_thread_account(p.owner_thread_id) AS waiting_account,\n"
  "       p.lock_type AS waiting_lock_type,\n"
  "       p.lock_duration AS waiting_lock_duration,\n"
  "       pt.processlist_info AS waiting_query,\n"
  "       pt.processlist_time AS waiting_query_secs,\n"
  "       ps.rows_affected AS waiting_query_rows_affected,\n"
  "       ps.rows_examined AS waiting_query_rows_examined,\n"
  "       gt.thread_id AS blocking_thread_id,\n"
  "       gt.processlist_id AS blocking_pid,\n"
  "       sys.ps_thread_account(g.owner_thread_id) AS blocking_account,\n"
  "       g.lock_type AS blocking_lock_type,\n"
  "       g.lock_duration AS blocking_lock_duration,\n"
  "       CONCAT('KILL QUERY ', gt.processlist_id) AS sql_kill_blocking_query,\n"
  "       CONCAT('KILL ', gt.processlist_id) AS sql_kill_blocking_connection\n"
  "  FROM performance_schema.metadata_locks g\n"
  " INNER JOIN performance_schema.metadata_locks p\n"
  "    ON g.object_type = p.object_type\n"
  "   AND g.object_schema = p.object_schema\n"
  "   AND g.object_name = p.object_name\n"
  "   AND g.lock_status = 'GRANTED'\n"
  "   AND p.lock_status = 'PENDING'\n"
  " INNER JOIN performance_schema.threads gt ON g.owner_thread_id = gt.thread_id\n"
  " INNER JOIN performance_schema.threads pt ON p.owner_thread_id = pt.thread_id\n"
  "  LEFT JOIN performance_schema.events_statements_current gs ON g.owner_thread_id = gs.thread_id\n"
  "  LEFT JOIN performance_schema.events_statements_current ps ON p.owner_thread_id = ps.thread_id\n"
  " WHERE g.object_type = 'TABLE';\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW statement_analysis (\n"
  "  query,\n"
  "  db,\n"
  "  full_scan,\n"
  "  exec_count,\n"
  "  err_count,\n"
  "  warn_count,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  avg_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_sent_avg,\n"
  "  rows_examined,\n"
  "  rows_examined_avg,\n"
  "  rows_affected,\n"
  "  rows_affected_avg,\n"
  "  tmp_tables,\n"
  "  tmp_disk_tables,\n"
  "  rows_sorted,\n"
  "  sort_merge_passes,\n"
  "  digest,\n"
  "  first_seen,\n"
  "  last_seen\n"
  ") AS\n"
  "SELECT sys.format_statement(DIGEST_TEXT) AS query,\n"
  "       SCHEMA_NAME AS db,\n"
  "       IF(SUM_NO_GOOD_INDEX_USED > 0 OR SUM_NO_INDEX_USED > 0, '*', '') AS full_scan,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_ERRORS AS err_count,\n"
  "       SUM_WARNINGS AS warn_count,\n"
  "       format_pico_time(SUM_TIMER_WAIT) AS total_latency,\n"
  "       format_pico_time(MAX_TIMER_WAIT) AS max_latency,\n"
  "       format_pico_time(AVG_TIMER_WAIT) AS avg_latency,\n"
  "       format_pico_time(SUM_LOCK_TIME) AS lock_latency,\n"
  "       SUM_ROWS_SENT AS rows_sent,\n"
  "       ROUND(IFNULL(SUM_ROWS_SENT / NULLIF(COUNT_STAR, 0), 0)) AS rows_sent_avg,\n"
  "       SUM_ROWS_EXAMINED AS rows_examined,\n"
  "       ROUND(IFNULL(SUM_ROWS_EXAMINED / NULLIF(COUNT_STAR, 0), 0))  AS rows_examined_avg,\n"
  "       SUM_ROWS_AFFECTED AS rows_affected,\n"
  "       ROUND(IFNULL(SUM_ROWS_AFFECTED / NULLIF(COUNT_STAR, 0), 0))  AS rows_affected_avg,\n"
  "       SUM_CREATED_TMP_TABLES AS tmp_tables,\n"
  "       SUM_CREATED_TMP_DISK_TABLES AS tmp_disk_tables,\n"
  "       SUM_SORT_ROWS AS rows_sorted,\n"
  "       SUM_SORT_MERGE_PASSES AS sort_merge_passes,\n"
  "       DIGEST AS digest,\n"
  "       FIRST_SEEN AS first_seen,\n"
  "       LAST_SEEN as last_seen\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  "ORDER BY SUM_TIMER_WAIT DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$statement_analysis (\n"
  "  query,\n"
  "  db,\n"
  "  full_scan,\n"
  "  exec_count,\n"
  "  err_count,\n"
  "  warn_count,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  avg_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_sent_avg,\n"
  "  rows_examined,\n"
  "  rows_examined_avg,\n"
  "  rows_affected,\n"
  "  rows_affected_avg,\n"
  "  tmp_tables,\n"
  "  tmp_disk_tables,\n"
  "  rows_sorted,\n"
  "  sort_merge_passes,\n"
  "  digest,\n"
  "  first_seen,\n"
  "  last_seen\n"
  ") AS\n"
  "SELECT DIGEST_TEXT AS query,\n"
  "       SCHEMA_NAME AS db,\n"
  "       IF(SUM_NO_GOOD_INDEX_USED > 0 OR SUM_NO_INDEX_USED > 0, '*', '') AS full_scan,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_ERRORS AS err_count,\n"
  "       SUM_WARNINGS AS warn_count,\n"
  "       SUM_TIMER_WAIT AS total_latency,\n"
  "       MAX_TIMER_WAIT AS max_latency,\n"
  "       AVG_TIMER_WAIT AS avg_latency,\n"
  "       SUM_LOCK_TIME AS lock_latency,\n"
  "       SUM_ROWS_SENT AS rows_sent,\n"
  "       ROUND(IFNULL(SUM_ROWS_SENT / NULLIF(COUNT_STAR, 0), 0)) AS rows_sent_avg,\n"
  "       SUM_ROWS_EXAMINED AS rows_examined,\n"
  "       ROUND(IFNULL(SUM_ROWS_EXAMINED / NULLIF(COUNT_STAR, 0), 0))  AS rows_examined_avg,\n"
  "       SUM_ROWS_AFFECTED AS rows_affected,\n"
  "       ROUND(IFNULL(SUM_ROWS_AFFECTED / NULLIF(COUNT_STAR, 0), 0))  AS rows_affected_avg,\n"
  "       SUM_CREATED_TMP_TABLES AS tmp_tables,\n"
  "       SUM_CREATED_TMP_DISK_TABLES AS tmp_disk_tables,\n"
  "       SUM_SORT_ROWS AS rows_sorted,\n"
  "       SUM_SORT_MERGE_PASSES AS sort_merge_passes,\n"
  "       DIGEST AS digest,\n"
  "       FIRST_SEEN AS first_seen,\n"
  "       LAST_SEEN as last_seen\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  "ORDER BY SUM_TIMER_WAIT DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW statements_with_errors_or_warnings (\n"
  "  query,\n"
  "  db,\n"
  "  exec_count,\n"
  "  errors,\n"
  "  error_pct,\n"
  "  warnings,\n"
  "  warning_pct,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT sys.format_statement(DIGEST_TEXT) AS query,\n"
  "       SCHEMA_NAME as db,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_ERRORS AS errors,\n"
  "       IFNULL(SUM_ERRORS / NULLIF(COUNT_STAR, 0), 0) * 100 as error_pct,\n"
  "       SUM_WARNINGS AS warnings,\n"
  "       IFNULL(SUM_WARNINGS / NULLIF(COUNT_STAR, 0), 0) * 100 as warning_pct,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " WHERE SUM_ERRORS > 0\n"
  "    OR SUM_WARNINGS > 0\n"
  "ORDER BY SUM_ERRORS DESC, SUM_WARNINGS DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$statements_with_errors_or_warnings (\n"
  "  query,\n"
  "  db,\n"
  "  exec_count,\n"
  "  errors,\n"
  "  error_pct,\n"
  "  warnings,\n"
  "  warning_pct,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT DIGEST_TEXT AS query,\n"
  "       SCHEMA_NAME as db,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_ERRORS AS errors,\n"
  "       IFNULL(SUM_ERRORS / NULLIF(COUNT_STAR, 0), 0) * 100 as error_pct,\n"
  "       SUM_WARNINGS AS warnings,\n"
  "       IFNULL(SUM_WARNINGS / NULLIF(COUNT_STAR, 0), 0) * 100 as warning_pct,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " WHERE SUM_ERRORS > 0\n"
  "    OR SUM_WARNINGS > 0\n"
  "ORDER BY SUM_ERRORS DESC, SUM_WARNINGS DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW statements_with_full_table_scans (\n"
  "  query,\n"
  "  db,\n"
  "  exec_count,\n"
  "  total_latency,\n"
  "  no_index_used_count,\n"
  "  no_good_index_used_count,\n"
  "  no_index_used_pct,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_sent_avg,\n"
  "  rows_examined_avg,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT sys.format_statement(DIGEST_TEXT) AS query,\n"
  "       SCHEMA_NAME as db,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       format_pico_time(SUM_TIMER_WAIT) AS total_latency,\n"
  "       SUM_NO_INDEX_USED AS no_index_used_count,\n"
  "       SUM_NO_GOOD_INDEX_USED AS no_good_index_used_count,\n"
  "       ROUND(IFNULL(SUM_NO_INDEX_USED / NULLIF(COUNT_STAR, 0), 0) * 100) AS no_index_used_pct,\n"
  "       SUM_ROWS_SENT AS rows_sent,\n"
  "       SUM_ROWS_EXAMINED AS rows_examined,\n"
  "       ROUND(SUM_ROWS_SENT/COUNT_STAR) AS rows_sent_avg,\n"
  "       ROUND(SUM_ROWS_EXAMINED/COUNT_STAR) AS rows_examined_avg,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " WHERE (SUM_NO_INDEX_USED > 0\n"
  "    OR SUM_NO_GOOD_INDEX_USED > 0)\n"
  "   AND DIGEST_TEXT NOT LIKE 'SHOW%'\n"
  " ORDER BY no_index_used_pct DESC, total_latency DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$statements_with_full_table_scans (\n"
  "  query,\n"
  "  db,\n"
  "  exec_count,\n"
  "  total_latency,\n"
  "  no_index_used_count,\n"
  "  no_good_index_used_count,\n"
  "  no_index_used_pct,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_sent_avg,\n"
  "  rows_examined_avg,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT DIGEST_TEXT AS query,\n"
  "       SCHEMA_NAME as db,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_TIMER_WAIT AS total_latency,\n"
  "       SUM_NO_INDEX_USED AS no_index_used_count,\n"
  "       SUM_NO_GOOD_INDEX_USED AS no_good_index_used_count,\n"
  "       ROUND(IFNULL(SUM_NO_INDEX_USED / NULLIF(COUNT_STAR, 0), 0) * 100) AS no_index_used_pct,\n"
  "       SUM_ROWS_SENT AS rows_sent,\n"
  "       SUM_ROWS_EXAMINED AS rows_examined,\n"
  "       ROUND(SUM_ROWS_SENT/COUNT_STAR) AS rows_sent_avg,\n"
  "       ROUND(SUM_ROWS_EXAMINED/COUNT_STAR) AS rows_examined_avg,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " WHERE (SUM_NO_INDEX_USED > 0\n"
  "    OR SUM_NO_GOOD_INDEX_USED > 0)\n"
  "   AND DIGEST_TEXT NOT LIKE 'SHOW%'\n"
  " ORDER BY no_index_used_pct DESC, total_latency DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$ps_digest_avg_latency_distribution (\n"
  "  cnt,\n"
  "  avg_us\n"
  ") AS\n"
  "SELECT COUNT(*) cnt,\n"
  "       ROUND(avg_timer_wait/1000000) AS avg_us\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " GROUP BY avg_us;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$ps_digest_95th_percentile_by_avg_us (\n"
  "  avg_us,\n"
  "  percentile\n"
  ") AS\n"
  "SELECT s2.avg_us avg_us,\n"
  "       IFNULL(SUM(s1.cnt)/NULLIF((SELECT COUNT(*) FROM performance_schema.events_statements_summary_by_digest), 0), 0) percentile\n"
  "  FROM sys.x$ps_digest_avg_latency_distribution AS s1\n"
  "  JOIN sys.x$ps_digest_avg_latency_distribution AS s2\n"
  "    ON s1.avg_us <= s2.avg_us\n"
  " GROUP BY s2.avg_us\n"
  "HAVING IFNULL(SUM(s1.cnt)/NULLIF((SELECT COUNT(*) FROM performance_schema.events_statements_summary_by_digest), 0), 0) > 0.95\n"
  " ORDER BY percentile\n"
  " LIMIT 1;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW statements_with_runtimes_in_95th_percentile (\n"
  "  query,\n"
  "  db,\n"
  "  full_scan,\n"
  "  exec_count,\n"
  "  err_count,\n"
  "  warn_count,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  avg_latency,\n"
  "  rows_sent,\n"
  "  rows_sent_avg,\n"
  "  rows_examined,\n"
  "  rows_examined_avg,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT sys.format_statement(DIGEST_TEXT) AS query,\n"
  "       SCHEMA_NAME as db,\n"
  "       IF(SUM_NO_GOOD_INDEX_USED > 0 OR SUM_NO_INDEX_USED > 0, '*', '') AS full_scan,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_ERRORS AS err_count,\n"
  "       SUM_WARNINGS AS warn_count,\n"
  "       format_pico_time(SUM_TIMER_WAIT) AS total_latency,\n"
  "       format_pico_time(MAX_TIMER_WAIT) AS max_latency,\n"
  "       format_pico_time(AVG_TIMER_WAIT) AS avg_latency,\n"
  "       SUM_ROWS_SENT AS rows_sent,\n"
  "       ROUND(IFNULL(SUM_ROWS_SENT / NULLIF(COUNT_STAR, 0), 0)) AS rows_sent_avg,\n"
  "       SUM_ROWS_EXAMINED AS rows_examined,\n"
  "       ROUND(IFNULL(SUM_ROWS_EXAMINED / NULLIF(COUNT_STAR, 0), 0)) AS rows_examined_avg,\n"
  "       FIRST_SEEN AS first_seen,\n"
  "       LAST_SEEN AS last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest stmts\n"
  "  JOIN sys.x$ps_digest_95th_percentile_by_avg_us AS top_percentile\n"
  "    ON ROUND(stmts.avg_timer_wait/1000000) >= top_percentile.avg_us\n"
  " ORDER BY AVG_TIMER_WAIT DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$statements_with_runtimes_in_95th_percentile (\n"
  "  query,\n"
  "  db,\n"
  "  full_scan,\n"
  "  exec_count,\n"
  "  err_count,\n"
  "  warn_count,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  avg_latency,\n"
  "  rows_sent,\n"
  "  rows_sent_avg,\n"
  "  rows_examined,\n"
  "  rows_examined_avg,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT DIGEST_TEXT AS query,\n"
  "       SCHEMA_NAME AS db,\n"
  "       IF(SUM_NO_GOOD_INDEX_USED > 0 OR SUM_NO_INDEX_USED > 0, '*', '') AS full_scan,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_ERRORS AS err_count,\n"
  "       SUM_WARNINGS AS warn_count,\n"
  "       SUM_TIMER_WAIT AS total_latency,\n"
  "       MAX_TIMER_WAIT AS max_latency,\n"
  "       AVG_TIMER_WAIT AS avg_latency,\n"
  "       SUM_ROWS_SENT AS rows_sent,\n"
  "       ROUND(IFNULL(SUM_ROWS_SENT / NULLIF(COUNT_STAR, 0), 0)) AS rows_sent_avg,\n"
  "       SUM_ROWS_EXAMINED AS rows_examined,\n"
  "       ROUND(IFNULL(SUM_ROWS_EXAMINED / NULLIF(COUNT_STAR, 0), 0)) AS rows_examined_avg,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest stmts\n"
  "  JOIN sys.x$ps_digest_95th_percentile_by_avg_us AS top_percentile\n"
  "    ON ROUND(stmts.avg_timer_wait/1000000) >= top_percentile.avg_us\n"
  " ORDER BY AVG_TIMER_WAIT DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW statements_with_sorting (\n"
  "  query,\n"
  "  db,\n"
  "  exec_count,\n"
  "  total_latency,\n"
  "  sort_merge_passes,\n"
  "  avg_sort_merges,\n"
  "  sorts_using_scans,\n"
  "  sort_using_range,\n"
  "  rows_sorted,\n"
  "  avg_rows_sorted,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT sys.format_statement(DIGEST_TEXT) AS query,\n"
  "       SCHEMA_NAME db,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       format_pico_time(SUM_TIMER_WAIT) AS total_latency,\n"
  "       SUM_SORT_MERGE_PASSES AS sort_merge_passes,\n"
  "       ROUND(IFNULL(SUM_SORT_MERGE_PASSES / NULLIF(COUNT_STAR, 0), 0)) AS avg_sort_merges,\n"
  "       SUM_SORT_SCAN AS sorts_using_scans,\n"
  "       SUM_SORT_RANGE AS sort_using_range,\n"
  "       SUM_SORT_ROWS AS rows_sorted,\n"
  "       ROUND(IFNULL(SUM_SORT_ROWS / NULLIF(COUNT_STAR, 0), 0)) AS avg_rows_sorted,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " WHERE SUM_SORT_ROWS > 0\n"
  " ORDER BY SUM_TIMER_WAIT DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$statements_with_sorting (\n"
  "  query,\n"
  "  db,\n"
  "  exec_count,\n"
  "  total_latency,\n"
  "  sort_merge_passes,\n"
  "  avg_sort_merges,\n"
  "  sorts_using_scans,\n"
  "  sort_using_range,\n"
  "  rows_sorted,\n"
  "  avg_rows_sorted,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT DIGEST_TEXT AS query,\n"
  "       SCHEMA_NAME db,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_TIMER_WAIT AS total_latency,\n"
  "       SUM_SORT_MERGE_PASSES AS sort_merge_passes,\n"
  "       ROUND(IFNULL(SUM_SORT_MERGE_PASSES / NULLIF(COUNT_STAR, 0), 0)) AS avg_sort_merges,\n"
  "       SUM_SORT_SCAN AS sorts_using_scans,\n"
  "       SUM_SORT_RANGE AS sort_using_range,\n"
  "       SUM_SORT_ROWS AS rows_sorted,\n"
  "       ROUND(IFNULL(SUM_SORT_ROWS / NULLIF(COUNT_STAR, 0), 0)) AS avg_rows_sorted,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " WHERE SUM_SORT_ROWS > 0\n"
  " ORDER BY SUM_TIMER_WAIT DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW statements_with_temp_tables (\n"
  "  query,\n"
  "  db,\n"
  "  exec_count,\n"
  "  total_latency,\n"
  "  memory_tmp_tables,\n"
  "  disk_tmp_tables,\n"
  "  avg_tmp_tables_per_query,\n"
  "  tmp_tables_to_disk_pct,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT sys.format_statement(DIGEST_TEXT) AS query,\n"
  "       SCHEMA_NAME as db,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       format_pico_time(SUM_TIMER_WAIT) as total_latency,\n"
  "       SUM_CREATED_TMP_TABLES AS memory_tmp_tables,\n"
  "       SUM_CREATED_TMP_DISK_TABLES AS disk_tmp_tables,\n"
  "       ROUND(IFNULL(SUM_CREATED_TMP_TABLES / NULLIF(COUNT_STAR, 0), 0)) AS avg_tmp_tables_per_query,\n"
  "       ROUND(IFNULL(SUM_CREATED_TMP_DISK_TABLES / NULLIF(SUM_CREATED_TMP_TABLES, 0), 0) * 100) AS tmp_tables_to_disk_pct,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " WHERE SUM_CREATED_TMP_TABLES > 0\n"
  "ORDER BY SUM_CREATED_TMP_DISK_TABLES DESC, SUM_CREATED_TMP_TABLES DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$statements_with_temp_tables (\n"
  "  query,\n"
  "  db,\n"
  "  exec_count,\n"
  "  total_latency,\n"
  "  memory_tmp_tables,\n"
  "  disk_tmp_tables,\n"
  "  avg_tmp_tables_per_query,\n"
  "  tmp_tables_to_disk_pct,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT DIGEST_TEXT AS query,\n"
  "       SCHEMA_NAME as db,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_TIMER_WAIT as total_latency,\n"
  "       SUM_CREATED_TMP_TABLES AS memory_tmp_tables,\n"
  "       SUM_CREATED_TMP_DISK_TABLES AS disk_tmp_tables,\n"
  "       ROUND(IFNULL(SUM_CREATED_TMP_TABLES / NULLIF(COUNT_STAR, 0), 0)) AS avg_tmp_tables_per_query,\n"
  "       ROUND(IFNULL(SUM_CREATED_TMP_DISK_TABLES / NULLIF(SUM_CREATED_TMP_TABLES, 0), 0) * 100) AS tmp_tables_to_disk_pct,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " WHERE SUM_CREATED_TMP_TABLES > 0\n"
  "ORDER BY SUM_CREATED_TMP_DISK_TABLES DESC, SUM_CREATED_TMP_TABLES DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW user_summary_by_file_io_type (\n"
  "  user,\n"
  "  event_name,\n"
  "  total,\n"
  "  latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       event_name,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_by_user_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file%'\n"
  "   AND count_star > 0\n"
  " ORDER BY user, sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$user_summary_by_file_io_type (\n"
  "  user,\n"
  "  event_name,\n"
  "  total,\n"
  "  latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       event_name,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS latency,\n"
  "       max_timer_wait AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_by_user_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file%'\n"
  "   AND count_star > 0\n"
  " ORDER BY user, sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW user_summary_by_file_io (\n"
  "  user,\n"
  "  ios,\n"
  "  io_latency\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       SUM(count_star) AS ios,\n"
  "       format_pico_time(SUM(sum_timer_wait)) AS io_latency\n"
  "  FROM performance_schema.events_waits_summary_by_user_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  " GROUP BY IF(user IS NULL, 'background', user)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$user_summary_by_file_io (\n"
  "  user,\n"
  "  ios,\n"
  "  io_latency\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       SUM(count_star) AS ios,\n"
  "       SUM(sum_timer_wait) AS io_latency\n"
  "  FROM performance_schema.events_waits_summary_by_user_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  " GROUP BY IF(user IS NULL, 'background', user)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW user_summary_by_statement_type (\n"
  "  user,\n"
  "  statement,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_affected,\n"
  "  full_scans\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       SUBSTRING_INDEX(event_name, '/', -1) AS statement,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency,\n"
  "       format_pico_time(sum_lock_time) AS lock_latency,\n"
  "       sum_rows_sent AS rows_sent,\n"
  "       sum_rows_examined AS rows_examined,\n"
  "       sum_rows_affected AS rows_affected,\n"
  "       sum_no_index_used + sum_no_good_index_used AS full_scans\n"
  "  FROM performance_schema.events_statements_summary_by_user_by_event_name\n"
  " WHERE sum_timer_wait != 0\n"
  " ORDER BY user, sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$user_summary_by_statement_type (\n"
  "  user,\n"
  "  statement,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_affected,\n"
  "  full_scans\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       SUBSTRING_INDEX(event_name, '/', -1) AS statement,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       max_timer_wait AS max_latency,\n"
  "       sum_lock_time AS lock_latency,\n"
  "       sum_rows_sent AS rows_sent,\n"
  "       sum_rows_examined AS rows_examined,\n"
  "       sum_rows_affected AS rows_affected,\n"
  "       sum_no_index_used + sum_no_good_index_used AS full_scans\n"
  "  FROM performance_schema.events_statements_summary_by_user_by_event_name\n"
  " WHERE sum_timer_wait != 0\n"
  " ORDER BY user, sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW user_summary_by_statement_latency (\n"
  "  user,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_affected,\n"
  "  full_scans\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       SUM(count_star) AS total,\n"
  "       format_pico_time(SUM(sum_timer_wait)) AS total_latency,\n"
  "       format_pico_time(SUM(max_timer_wait)) AS max_latency,\n"
  "       format_pico_time(SUM(sum_lock_time)) AS lock_latency,\n"
  "       SUM(sum_rows_sent) AS rows_sent,\n"
  "       SUM(sum_rows_examined) AS rows_examined,\n"
  "       SUM(sum_rows_affected) AS rows_affected,\n"
  "       SUM(sum_no_index_used) + SUM(sum_no_good_index_used) AS full_scans\n"
  "  FROM performance_schema.events_statements_summary_by_user_by_event_name\n"
  " GROUP BY IF(user IS NULL, 'background', user)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$user_summary_by_statement_latency (\n"
  "  user,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_affected,\n"
  "  full_scans\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       SUM(count_star) AS total,\n"
  "       SUM(sum_timer_wait) AS total_latency,\n"
  "       SUM(max_timer_wait) AS max_latency,\n"
  "       SUM(sum_lock_time) AS lock_latency,\n"
  "       SUM(sum_rows_sent) AS rows_sent,\n"
  "       SUM(sum_rows_examined) AS rows_examined,\n"
  "       SUM(sum_rows_affected) AS rows_affected,\n"
  "       SUM(sum_no_index_used) + SUM(sum_no_good_index_used) AS full_scans\n"
  "  FROM performance_schema.events_statements_summary_by_user_by_event_name\n"
  " GROUP BY IF(user IS NULL, 'background', user)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW user_summary_by_stages (\n"
  "  user,\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       event_name,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(avg_timer_wait) AS avg_latency\n"
  "  FROM performance_schema.events_stages_summary_by_user_by_event_name\n"
  " WHERE sum_timer_wait != 0\n"
  " ORDER BY user, sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$user_summary_by_stages (\n"
  "  user,\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       event_name,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       avg_timer_wait AS avg_latency\n"
  "  FROM performance_schema.events_stages_summary_by_user_by_event_name\n"
  " WHERE sum_timer_wait != 0\n"
  " ORDER BY user, sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW user_summary (\n"
  "  user,\n"
  "  statements,\n"
  "  statement_latency,\n"
  "  statement_avg_latency,\n"
  "  table_scans,\n"
  "  file_ios,\n"
  "  file_io_latency,\n"
  "  current_connections,\n"
  "  total_connections,\n"
  "  unique_hosts,\n"
  "  current_memory,\n"
  "  total_memory_allocated\n"
  ") AS\n"
  "SELECT IF(accounts.user IS NULL, 'background', accounts.user) AS user,\n"
  "       SUM(stmt.total) AS statements,\n"
  "       format_pico_time(SUM(stmt.total_latency)) AS statement_latency,\n"
  "       format_pico_time(IFNULL(SUM(stmt.total_latency) / NULLIF(SUM(stmt.total), 0), 0)) AS statement_avg_latency,\n"
  "       SUM(stmt.full_scans) AS table_scans,\n"
  "       SUM(io.ios) AS file_ios,\n"
  "       format_pico_time(SUM(io.io_latency)) AS file_io_latency,\n"
  "       SUM(accounts.current_connections) AS current_connections,\n"
  "       SUM(accounts.total_connections) AS total_connections,\n"
  "       COUNT(DISTINCT host) AS unique_hosts,\n"
  "       format_bytes(SUM(mem.current_allocated)) AS current_memory,\n"
  "       format_bytes(SUM(mem.total_allocated)) AS total_memory_allocated\n"
  "  FROM performance_schema.accounts\n"
  "  LEFT JOIN sys.x$user_summary_by_statement_latency AS stmt ON IF(accounts.user IS NULL, 'background', accounts.user) = stmt.user\n"
  "  LEFT JOIN sys.x$user_summary_by_file_io AS io ON IF(accounts.user IS NULL, 'background', accounts.user) = io.user\n"
  "  LEFT JOIN sys.x$memory_by_user_by_current_bytes mem ON IF(accounts.user IS NULL, 'background', accounts.user) = mem.user\n"
  " GROUP BY IF(accounts.user IS NULL, 'background', accounts.user)\n"
  " ORDER BY SUM(stmt.total_latency) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$user_summary (\n"
  "  user,\n"
  "  statements,\n"
  "  statement_latency,\n"
  "  statement_avg_latency,\n"
  "  table_scans,\n"
  "  file_ios,\n"
  "  file_io_latency,\n"
  "  current_connections,\n"
  "  total_connections,\n"
  "  unique_hosts,\n"
  "  current_memory,\n"
  "  total_memory_allocated\n"
  ") AS\n"
  "SELECT IF(accounts.user IS NULL, 'background', accounts.user) AS user,\n"
  "       SUM(stmt.total) AS statements,\n"
  "       SUM(stmt.total_latency) AS statement_latency,\n"
  "       IFNULL(SUM(stmt.total_latency) / NULLIF(SUM(stmt.total), 0), 0) AS statement_avg_latency,\n"
  "       SUM(stmt.full_scans) AS table_scans,\n"
  "       SUM(io.ios) AS file_ios,\n"
  "       SUM(io.io_latency) AS file_io_latency,\n"
  "       SUM(accounts.current_connections) AS current_connections,\n"
  "       SUM(accounts.total_connections) AS total_connections,\n"
  "       COUNT(DISTINCT host) AS unique_hosts,\n"
  "       SUM(mem.current_allocated) AS current_memory,\n"
  "       SUM(mem.total_allocated) AS total_memory_allocated\n"
  "  FROM performance_schema.accounts\n"
  "  LEFT JOIN sys.x$user_summary_by_statement_latency AS stmt ON IF(accounts.user IS NULL, 'background', accounts.user) = stmt.user\n"
  "  LEFT JOIN sys.x$user_summary_by_file_io AS io ON IF(accounts.user IS NULL, 'background', accounts.user) = io.user\n"
  "  LEFT JOIN sys.x$memory_by_user_by_current_bytes mem ON IF(accounts.user IS NULL, 'background', accounts.user) = mem.user\n"
  " GROUP BY IF(accounts.user IS NULL, 'background', accounts.user)\n"
  " ORDER BY SUM(stmt.total_latency) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW host_summary_by_file_io_type (\n"
  "  host,\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       event_name,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_by_host_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file%'\n"
  "   AND count_star > 0\n"
  " ORDER BY IF(host IS NULL, 'background', host), sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$host_summary_by_file_io_type (\n"
  "  host,\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       event_name,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       max_timer_wait AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_by_host_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file%'\n"
  "   AND count_star > 0\n"
  " ORDER BY IF(host IS NULL, 'background', host), sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW host_summary_by_file_io (\n"
  "  host,\n"
  "  ios,\n"
  "  io_latency\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       SUM(count_star) AS ios,\n"
  "       format_pico_time(SUM(sum_timer_wait)) AS io_latency\n"
  "  FROM performance_schema.events_waits_summary_by_host_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  " GROUP BY IF(host IS NULL, 'background', host)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$host_summary_by_file_io (\n"
  "  host,\n"
  "  ios,\n"
  "  io_latency\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       SUM(count_star) AS ios,\n"
  "       SUM(sum_timer_wait) AS io_latency\n"
  "  FROM performance_schema.events_waits_summary_by_host_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  " GROUP BY IF(host IS NULL, 'background', host)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW host_summary_by_statement_type (\n"
  "  host,\n"
  "  statement,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_affected,\n"
  "  full_scans\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       SUBSTRING_INDEX(event_name, '/', -1) AS statement,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency,\n"
  "       format_pico_time(sum_lock_time) AS lock_latency,\n"
  "       sum_rows_sent AS rows_sent,\n"
  "       sum_rows_examined AS rows_examined,\n"
  "       sum_rows_affected AS rows_affected,\n"
  "       sum_no_index_used + sum_no_good_index_used AS full_scans\n"
  "  FROM performance_schema.events_statements_summary_by_host_by_event_name\n"
  " WHERE sum_timer_wait != 0\n"
  " ORDER BY IF(host IS NULL, 'background', host), sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$host_summary_by_statement_type (\n"
  "  host,\n"
  "  statement,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_affected,\n"
  "  full_scans\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       SUBSTRING_INDEX(event_name, '/', -1) AS statement,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       max_timer_wait AS max_latency,\n"
  "       sum_lock_time AS lock_latency,\n"
  "       sum_rows_sent AS rows_sent,\n"
  "       sum_rows_examined AS rows_examined,\n"
  "       sum_rows_affected AS rows_affected,\n"
  "       sum_no_index_used + sum_no_good_index_used AS full_scans\n"
  "  FROM performance_schema.events_statements_summary_by_host_by_event_name\n"
  " WHERE sum_timer_wait != 0\n"
  " ORDER BY IF(host IS NULL, 'background', host), sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW host_summary_by_statement_latency (\n"
  "  host,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_affected,\n"
  "  full_scans\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       SUM(count_star) AS total,\n"
  "       format_pico_time(SUM(sum_timer_wait)) AS total_latency,\n"
  "       format_pico_time(MAX(max_timer_wait)) AS max_latency,\n"
  "       format_pico_time(SUM(sum_lock_time)) AS lock_latency,\n"
  "       SUM(sum_rows_sent) AS rows_sent,\n"
  "       SUM(sum_rows_examined) AS rows_examined,\n"
  "       SUM(sum_rows_affected) AS rows_affected,\n"
  "       SUM(sum_no_index_used) + SUM(sum_no_good_index_used) AS full_scans\n"
  "  FROM performance_schema.events_statements_summary_by_host_by_event_name\n"
  " GROUP BY IF(host IS NULL, 'background', host)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$host_summary_by_statement_latency (\n"
  "  host,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_affected,\n"
  "  full_scans\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       SUM(count_star) AS total,\n"
  "       SUM(sum_timer_wait) AS total_latency,\n"
  "       MAX(max_timer_wait) AS max_latency,\n"
  "       SUM(sum_lock_time) AS lock_latency,\n"
  "       SUM(sum_rows_sent) AS rows_sent,\n"
  "       SUM(sum_rows_examined) AS rows_examined,\n"
  "       SUM(sum_rows_affected) AS rows_affected,\n"
  "       SUM(sum_no_index_used) + SUM(sum_no_good_index_used) AS full_scans\n"
  "  FROM performance_schema.events_statements_summary_by_host_by_event_name\n"
  " GROUP BY IF(host IS NULL, 'background', host)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW host_summary_by_stages (\n"
  "  host,\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       event_name,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(avg_timer_wait) AS avg_latency\n"
  "  FROM performance_schema.events_stages_summary_by_host_by_event_name\n"
  " WHERE sum_timer_wait != 0\n"
  " ORDER BY IF(host IS NULL, 'background', host), sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$host_summary_by_stages (\n"
  "  host,\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       event_name,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       avg_timer_wait AS avg_latency\n"
  "  FROM performance_schema.events_stages_summary_by_host_by_event_name\n"
  " WHERE sum_timer_wait != 0\n"
  " ORDER BY IF(host IS NULL, 'background', host), sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW host_summary (\n"
  "  host,\n"
  "  statements,\n"
  "  statement_latency,\n"
  "  statement_avg_latency,\n"
  "  table_scans,\n"
  "  file_ios,\n"
  "  file_io_latency,\n"
  "  current_connections,\n"
  "  total_connections,\n"
  "  unique_users,\n"
  "  current_memory,\n"
  "  total_memory_allocated\n"
  ") AS\n"
  "SELECT IF(accounts.host IS NULL, 'background', accounts.host) AS host,\n"
  "       SUM(stmt.total) AS statements,\n"
  "       format_pico_time(SUM(stmt.total_latency)) AS statement_latency,\n"
  "       format_pico_time(IFNULL(SUM(stmt.total_latency) / NULLIF(SUM(stmt.total), 0), 0)) AS statement_avg_latency,\n"
  "       SUM(stmt.full_scans) AS table_scans,\n"
  "       SUM(io.ios) AS file_ios,\n"
  "       format_pico_time(SUM(io.io_latency)) AS file_io_latency,\n"
  "       SUM(accounts.current_connections) AS current_connections,\n"
  "       SUM(accounts.total_connections) AS total_connections,\n"
  "       COUNT(DISTINCT user) AS unique_users,\n"
  "       format_bytes(SUM(mem.current_allocated)) AS current_memory,\n"
  "       format_bytes(SUM(mem.total_allocated)) AS total_memory_allocated\n"
  "  FROM performance_schema.accounts\n"
  "  JOIN sys.x$host_summary_by_statement_latency AS stmt ON accounts.host = stmt.host\n"
  "  JOIN sys.x$host_summary_by_file_io AS io ON accounts.host = io.host\n"
  "  JOIN sys.x$memory_by_host_by_current_bytes mem ON accounts.host = mem.host\n"
  " GROUP BY IF(accounts.host IS NULL, 'background', accounts.host);\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$host_summary (\n"
  "  host,\n"
  "  statements,\n"
  "  statement_latency,\n"
  "  statement_avg_latency,\n"
  "  table_scans,\n"
  "  file_ios,\n"
  "  file_io_latency,\n"
  "  current_connections,\n"
  "  total_connections,\n"
  "  unique_users,\n"
  "  current_memory,\n"
  "  total_memory_allocated\n"
  ") AS\n"
  "SELECT IF(accounts.host IS NULL, 'background', accounts.host) AS host,\n"
  "       SUM(stmt.total) AS statements,\n"
  "       SUM(stmt.total_latency) AS statement_latency,\n"
  "       SUM(stmt.total_latency) / SUM(stmt.total) AS statement_avg_latency,\n"
  "       SUM(stmt.full_scans) AS table_scans,\n"
  "       SUM(io.ios) AS file_ios,\n"
  "       SUM(io.io_latency) AS file_io_latency,\n"
  "       SUM(accounts.current_connections) AS current_connections,\n"
  "       SUM(accounts.total_connections) AS total_connections,\n"
  "       COUNT(DISTINCT accounts.user) AS unique_users,\n"
  "       SUM(mem.current_allocated) AS current_memory,\n"
  "       SUM(mem.total_allocated) AS total_memory_allocated\n"
  "  FROM performance_schema.accounts\n"
  "  JOIN sys.x$host_summary_by_statement_latency AS stmt ON accounts.host = stmt.host\n"
  "  JOIN sys.x$host_summary_by_file_io AS io ON accounts.host = io.host\n"
  "  JOIN sys.x$memory_by_host_by_current_bytes mem ON accounts.host = mem.host\n"
  " GROUP BY IF(accounts.host IS NULL, 'background', accounts.host);\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW wait_classes_global_by_avg_latency (\n"
  "  event_class,\n"
  "  total,\n"
  "  total_latency,\n"
  "  min_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT SUBSTRING_INDEX(event_name,'/', 3) AS event_class,\n"
  "       SUM(COUNT_STAR) AS total,\n"
  "       format_pico_time(CAST(SUM(sum_timer_wait) AS UNSIGNED)) AS total_latency,\n"
  "       format_pico_time(MIN(min_timer_wait)) AS min_latency,\n"
  "       format_pico_time(IFNULL(SUM(sum_timer_wait) / NULLIF(SUM(COUNT_STAR), 0), 0)) AS avg_latency,\n"
  "       format_pico_time(CAST(MAX(max_timer_wait) AS UNSIGNED)) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_global_by_event_name\n"
  " WHERE sum_timer_wait > 0\n"
  "   AND event_name != 'idle'\n"
  " GROUP BY event_class\n"
  " ORDER BY IFNULL(SUM(sum_timer_wait) / NULLIF(SUM(COUNT_STAR), 0), 0) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$wait_classes_global_by_avg_latency (\n"
  "  event_class,\n"
  "  total,\n"
  "  total_latency,\n"
  "  min_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT SUBSTRING_INDEX(event_name,'/', 3) AS event_class,\n"
  "       SUM(COUNT_STAR) AS total,\n"
  "       SUM(sum_timer_wait) AS total_latency,\n"
  "       MIN(min_timer_wait) AS min_latency,\n"
  "       IFNULL(SUM(sum_timer_wait) / NULLIF(SUM(COUNT_STAR), 0), 0) AS avg_latency,\n"
  "       MAX(max_timer_wait) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_global_by_event_name\n"
  " WHERE sum_timer_wait > 0\n"
  "   AND event_name != 'idle'\n"
  " GROUP BY event_class\n"
  " ORDER BY IFNULL(SUM(sum_timer_wait) / NULLIF(SUM(COUNT_STAR), 0), 0) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW wait_classes_global_by_latency (\n"
  "  event_class,\n"
  "  total,\n"
  "  total_latency,\n"
  "  min_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT SUBSTRING_INDEX(event_name,'/', 3) AS event_class,\n"
  "       SUM(COUNT_STAR) AS total,\n"
  "       format_pico_time(SUM(sum_timer_wait)) AS total_latency,\n"
  "       format_pico_time(MIN(min_timer_wait)) min_latency,\n"
  "       format_pico_time(IFNULL(SUM(sum_timer_wait) / NULLIF(SUM(COUNT_STAR), 0), 0)) AS avg_latency,\n"
  "       format_pico_time(MAX(max_timer_wait)) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_global_by_event_name\n"
  " WHERE sum_timer_wait > 0\n"
  "   AND event_name != 'idle'\n"
  " GROUP BY SUBSTRING_INDEX(event_name,'/', 3)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$wait_classes_global_by_latency (\n"
  "  event_class,\n"
  "  total,\n"
  "  total_latency,\n"
  "  min_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT SUBSTRING_INDEX(event_name,'/', 3) AS event_class,\n"
  "       SUM(COUNT_STAR) AS total,\n"
  "       SUM(sum_timer_wait) AS total_latency,\n"
  "       MIN(min_timer_wait) AS min_latency,\n"
  "       IFNULL(SUM(sum_timer_wait) / NULLIF(SUM(COUNT_STAR), 0), 0) AS avg_latency,\n"
  "       MAX(max_timer_wait) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_global_by_event_name\n"
  " WHERE sum_timer_wait > 0\n"
  "   AND event_name != 'idle'\n"
  " GROUP BY SUBSTRING_INDEX(event_name,'/', 3)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW waits_by_user_by_latency (\n"
  "  user,\n"
  "  event,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       event_name AS event,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(avg_timer_wait) AS avg_latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_by_user_by_event_name\n"
  " WHERE event_name != 'idle'\n"
  "   AND user IS NOT NULL\n"
  "   AND sum_timer_wait > 0\n"
  " ORDER BY user, sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$waits_by_user_by_latency (\n"
  "  user,\n"
  "  event,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       event_name AS event,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       avg_timer_wait AS avg_latency,\n"
  "       max_timer_wait AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_by_user_by_event_name\n"
  " WHERE event_name != 'idle'\n"
  "   AND user IS NOT NULL\n"
  "   AND sum_timer_wait > 0\n"
  " ORDER BY user, sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW waits_by_host_by_latency (\n"
  "  host,\n"
  "  event,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       event_name AS event,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(avg_timer_wait) AS avg_latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_by_host_by_event_name\n"
  " WHERE event_name != 'idle'\n"
  "   AND sum_timer_wait > 0\n"
  " ORDER BY host, sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$waits_by_host_by_latency (\n"
  "  host,\n"
  "  event,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       event_name AS event,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       avg_timer_wait AS avg_latency,\n"
  "       max_timer_wait AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_by_host_by_event_name\n"
  " WHERE event_name != 'idle'\n"
  "   AND sum_timer_wait > 0\n"
  " ORDER BY host, sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW waits_global_by_latency (\n"
  "  events,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT event_name AS event,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(avg_timer_wait) AS avg_latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_global_by_event_name\n"
  " WHERE event_name != 'idle'\n"
  "   AND sum_timer_wait > 0\n"
  " ORDER BY sum_timer_wait DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$waits_global_by_latency (\n"
  "  events,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT event_name AS event,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       avg_timer_wait AS avg_latency,\n"
  "       max_timer_wait AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_global_by_event_name\n"
  " WHERE event_name != 'idle'\n"
  "   AND sum_timer_wait > 0\n"
  " ORDER BY sum_timer_wait DESC;\n",
"DELIMITER $$\n",
"BEGIN NOT ATOMIC\n"
  "DECLARE EXIT HANDLER FOR SQLEXCEPTION BEGIN END;\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW metrics (\n"
  "  Variable_name,\n"
  "  Variable_value,\n"
  "  Type,\n"
  "  Enabled\n"
  ") AS\n"
  "(\n"
  "SELECT LOWER(VARIABLE_NAME) AS Variable_name, VARIABLE_VALUE AS Variable_value, 'Global Status' AS Type, 'YES' AS Enabled\n"
  "  FROM performance_schema.global_status\n"
  ") UNION ALL (\n"
  "SELECT NAME AS Variable_name, COUNT AS Variable_value,\n"
  "       CONCAT('InnoDB Metrics - ', SUBSYSTEM) AS Type,\n"
  "      'YES' AS Enabled\n"
  "  FROM information_schema.INNODB_METRICS\n"
  " WHERE NAME NOT IN (\n"
  "     'lock_row_lock_time', 'lock_row_lock_time_avg', 'lock_row_lock_time_max', 'lock_row_lock_waits',\n"
  "     'buffer_pool_reads', 'buffer_pool_read_requests', 'buffer_pool_write_requests', 'buffer_pool_wait_free',\n"
  "     'buffer_pool_read_ahead', 'buffer_pool_read_ahead_evicted', 'buffer_pool_pages_total', 'buffer_pool_pages_misc',\n"
  "     'buffer_pool_pages_data', 'buffer_pool_bytes_data', 'buffer_pool_pages_dirty', 'buffer_pool_bytes_dirty',\n"
  "     'buffer_pool_pages_free', 'buffer_pages_created', 'buffer_pages_written', 'buffer_pages_read',\n"
  "     'buffer_data_reads', 'buffer_data_written', 'file_num_open_files',\n"
  "     'os_log_bytes_written', 'os_log_fsyncs', 'os_log_pending_fsyncs', 'os_log_pending_writes',\n"
  "     'log_waits', 'log_write_requests', 'log_writes', 'innodb_dblwr_writes', 'innodb_dblwr_pages_written', 'innodb_page_size')\n"
  ") /*!50702\n"
  "  UNION ALL (\n"
  "SELECT 'memory_current_allocated' AS Variable_name, SUM(CURRENT_NUMBER_OF_BYTES_USED) AS Variable_value, 'Performance Schema' AS Type,\n"
  "        IF((SELECT COUNT(*) FROM performance_schema.setup_instruments WHERE NAME LIKE 'memory/%' AND ENABLED = 'YES') = 0, 'NO',\n"
  "        IF((SELECT COUNT(*) FROM performance_schema.setup_instruments WHERE NAME LIKE 'memory/%' AND ENABLED = 'YES') = (SELECT COUNT(*) FROM performance_schema.setup_instruments WHERE NAME LIKE 'memory/%'), 'YES',\n"
  "            'PARTIAL')) AS Enabled\n"
  "  FROM performance_schema.memory_summary_global_by_event_name\n"
  ") UNION ALL (\n"
  "SELECT 'memory_total_allocated' AS Variable_name, SUM(SUM_NUMBER_OF_BYTES_ALLOC) AS Variable_value, 'Performance Schema' AS Type,\n"
  "        IF((SELECT COUNT(*) FROM performance_schema.setup_instruments WHERE NAME LIKE 'memory/%' AND ENABLED = 'YES') = 0, 'NO',\n"
  "        IF((SELECT COUNT(*) FROM performance_schema.setup_instruments WHERE NAME LIKE 'memory/%' AND ENABLED = 'YES') = (SELECT COUNT(*) FROM performance_schema.setup_instruments WHERE NAME LIKE 'memory/%'), 'YES',\n"
  "            'PARTIAL')) AS Enabled\n"
  "  FROM performance_schema.memory_summary_global_by_event_name\n"
  ") */\n"
  "  UNION ALL (\n"
  "SELECT 'NOW()' AS Variable_name, NOW(3) AS Variable_value, 'System Time' AS Type, 'YES' AS Enabled\n"
  ") UNION ALL (\n"
  "SELECT 'UNIX_TIMESTAMP()' AS Variable_name, ROUND(UNIX_TIMESTAMP(NOW(3)), 3) AS Variable_value, 'System Time' AS Type, 'YES' AS Enabled\n"
  ")\n"
  " ORDER BY Type, Variable_name;\n"
  "END$$\n",
"DELIMITER ;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW processlist (\n"
  "  thd_id,\n"
  "  conn_id,\n"
  "  user,\n"
  "  db,\n"
  "  command,\n"
  "  state,\n"
  "  time,\n"
  "  current_statement,\n"
  "  statement_latency,\n"
  "  progress,\n"
  "  lock_latency,\n"
  "  rows_examined,\n"
  "  rows_sent,\n"
  "  rows_affected,\n"
  "  tmp_tables,\n"
  "  tmp_disk_tables,\n"
  "  full_scan,\n"
  "  last_statement,\n"
  "  last_statement_latency,\n"
  "  current_memory,\n"
  "  last_wait,\n"
  "  last_wait_latency,\n"
  "  source,\n"
  "  trx_latency,\n"
  "  trx_state,\n"
  "  trx_autocommit,\n"
  "  pid,\n"
  "  program_name\n"
  ") AS\n"
  "SELECT pps.thread_id AS thd_id,\n"
  "       pps.processlist_id AS conn_id,\n"
  "       IF(pps.name = 'thread/sql/one_connection',\n"
  "          CONCAT(pps.processlist_user, '@', pps.processlist_host),\n"
  "          REPLACE(pps.name, 'thread/', '')) user,\n"
  "       pps.processlist_db AS db,\n"
  "       pps.processlist_command AS command,\n"
  "       pps.processlist_state AS state,\n"
  "       pps.processlist_time AS time,\n"
  "       sys.format_statement(pps.processlist_info) AS current_statement,\n"
  "       IF(esc.end_event_id IS NULL,\n"
  "          format_pico_time(esc.timer_wait),\n"
  "          NULL) AS statement_latency,\n"
  "       IF(esc.end_event_id IS NULL,\n"
  "          ROUND(100 * (estc.work_completed / estc.work_estimated), 2),\n"
  "          NULL) AS progress,\n"
  "       format_pico_time(esc.lock_time) AS lock_latency,\n"
  "       esc.rows_examined AS rows_examined,\n"
  "       esc.rows_sent AS rows_sent,\n"
  "       esc.rows_affected AS rows_affected,\n"
  "       esc.created_tmp_tables AS tmp_tables,\n"
  "       esc.created_tmp_disk_tables AS tmp_disk_tables,\n"
  "       IF(esc.no_good_index_used > 0 OR esc.no_index_used > 0, 'YES', 'NO') AS full_scan,\n"
  "       IF(esc.end_event_id IS NOT NULL,\n"
  "          sys.format_statement(esc.sql_text),\n"
  "          NULL) AS last_statement,\n"
  "       IF(esc.end_event_id IS NOT NULL,\n"
  "          format_pico_time(esc.timer_wait),\n"
  "          NULL) AS last_statement_latency,\n"
  "       format_bytes(mem.current_allocated) AS current_memory,\n"
  "       ewc.event_name AS last_wait,\n"
  "       IF(ewc.end_event_id IS NULL AND ewc.event_name IS NOT NULL,\n"
  "          'Still Waiting',\n"
  "          format_pico_time(ewc.timer_wait)) last_wait_latency,\n"
  "       ewc.source,\n"
  "       format_pico_time(etc.timer_wait) AS trx_latency,\n"
  "       etc.state AS trx_state,\n"
  "       etc.autocommit AS trx_autocommit,\n"
  "       conattr_pid.attr_value as pid,\n"
  "       conattr_progname.attr_value as program_name\n"
  "  FROM performance_schema.threads AS pps\n"
  "  LEFT JOIN performance_schema.events_waits_current AS ewc USING (thread_id)\n"
  "  LEFT JOIN performance_schema.events_stages_current AS estc USING (thread_id)\n"
  "  LEFT JOIN performance_schema.events_statements_current AS esc USING (thread_id)\n"
  "  LEFT JOIN performance_schema.events_transactions_current AS etc USING (thread_id)\n"
  "  LEFT JOIN sys.x$memory_by_thread_by_current_bytes AS mem USING (thread_id)\n"
  "  LEFT JOIN performance_schema.session_connect_attrs AS conattr_pid\n"
  "    ON conattr_pid.processlist_id=pps.processlist_id and conattr_pid.attr_name='_pid'\n"
  "  LEFT JOIN performance_schema.session_connect_attrs AS conattr_progname\n"
  "    ON conattr_progname.processlist_id=pps.processlist_id and conattr_progname.attr_name='program_name'\n"
  " ORDER BY pps.processlist_time DESC, last_wait_latency DESC;\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$processlist (\n"
  "  thd_id,\n"
  "  conn_id,\n"
  "  user,\n"
  "  db,\n"
  "  command,\n"
  "  state,\n"
  "  time,\n"
  "  current_statement,\n"
  "  statement_latency,\n"
  "  progress,\n"
  "  lock_latency,\n"
  "  rows_examined,\n"
  "  rows_sent,\n"
  "  rows_affected,\n"
  "  tmp_tables,\n"
  "  tmp_disk_tables,\n"
  "  full_scan,\n"
  "  last_statement,\n"
  "  last_statement_latency,\n"
  "  current_memory,\n"
  "  last_wait,\n"
  "  last_wait_latency,\n"
  "  source,\n"
  "  trx_latency,\n"
  "  trx_state,\n"
  "  trx_autocommit,\n"
  "  pid,\n"
  "  program_name\n"
  ") AS\n"
  "SELECT pps.thread_id AS thd_id,\n"
  "       pps.processlist_id AS conn_id,\n"
  "       IF(pps.name = 'thread/sql/one_connection',\n"
  "          CONCAT(pps.processlist_user, '@', pps.processlist_host),\n"
  "          REPLACE(pps.name, 'thread/', '')) user,\n"
  "       pps.processlist_db AS db,\n"
  "       pps.processlist_command AS command,\n"
  "       pps.processlist_state AS state,\n"
  "       pps.processlist_time AS time,\n"
  "       pps.processlist_info AS current_statement,\n"
  "       IF(esc.end_event_id IS NULL,\n"
  "          esc.timer_wait,\n"
  "          NULL) AS statement_latency,\n"
  "       IF(esc.end_event_id IS NULL,\n"
  "          ROUND(100 * (estc.work_completed / estc.work_estimated), 2),\n"
  "          NULL) AS progress,\n"
  "       esc.lock_time AS lock_latency,\n"
  "       esc.rows_examined AS rows_examined,\n"
  "       esc.rows_sent AS rows_sent,\n"
  "       esc.rows_affected AS rows_affected,\n"
  "       esc.created_tmp_tables AS tmp_tables,\n"
  "       esc.created_tmp_disk_tables AS tmp_disk_tables,\n"
  "       IF(esc.no_good_index_used > 0 OR esc.no_index_used > 0, 'YES', 'NO') AS full_scan,\n"
  "       IF(esc.end_event_id IS NOT NULL,\n"
  "          esc.sql_text,\n"
  "          NULL) AS last_statement,\n"
  "       IF(esc.end_event_id IS NOT NULL,\n"
  "          esc.timer_wait,\n"
  "          NULL) AS last_statement_latency,\n"
  "       mem.current_allocated AS current_memory,\n"
  "       ewc.event_name AS last_wait,\n"
  "       IF(ewc.end_event_id IS NULL AND ewc.event_name IS NOT NULL,\n"
  "          'Still Waiting',\n"
  "          ewc.timer_wait) last_wait_latency,\n"
  "       ewc.source,\n"
  "       etc.timer_wait AS trx_latency,\n"
  "       etc.state AS trx_state,\n"
  "       etc.autocommit AS trx_autocommit,\n"
  "       conattr_pid.attr_value as pid,\n"
  "       conattr_progname.attr_value as program_name\n"
  "  FROM performance_schema.threads AS pps\n"
  "  LEFT JOIN performance_schema.events_waits_current AS ewc USING (thread_id)\n"
  "  LEFT JOIN performance_schema.events_stages_current AS estc USING (thread_id)\n"
  "  LEFT JOIN performance_schema.events_statements_current AS esc USING (thread_id)\n"
  "  LEFT JOIN performance_schema.events_transactions_current AS etc USING (thread_id)\n"
  "  LEFT JOIN sys.x$memory_by_thread_by_current_bytes AS mem USING (thread_id)\n"
  "  LEFT JOIN performance_schema.session_connect_attrs AS conattr_pid\n"
  "    ON conattr_pid.processlist_id=pps.processlist_id and conattr_pid.attr_name='_pid'\n"
  "  LEFT JOIN performance_schema.session_connect_attrs AS conattr_progname\n"
  "    ON conattr_progname.processlist_id=pps.processlist_id and conattr_progname.attr_name='program_name'\n"
  " ORDER BY pps.processlist_time DESC, last_wait_latency DESC;\n",
"CREATE OR REPLACE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW session\n"
  " AS\n"
  "SELECT * FROM sys.processlist\n"
  "WHERE conn_id IS NOT NULL AND command != 'Daemon';\n",
"CREATE OR REPLACE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$session\n"
  " AS\n"
  "SELECT * FROM sys.x$processlist\n"
  "WHERE conn_id IS NOT NULL AND command != 'Daemon';\n",
"CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mariadb.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW session_ssl_status (\n"
  "  thread_id,\n"
  "  ssl_version,\n"
  "  ssl_cipher,\n"
  "  ssl_sessions_reused\n"
  ") AS\n"
  "SELECT sslver.thread_id,\n"
  "       sslver.variable_value ssl_version,\n"
  "       sslcip.variable_value ssl_cipher,\n"
  "       sslreuse.variable_value ssl_sessions_reused\n"
  "  FROM performance_schema.status_by_thread sslver\n"
  "  LEFT JOIN performance_schema.status_by_thread sslcip\n"
  "    ON (sslcip.thread_id=sslver.thread_id and sslcip.variable_name='Ssl_cipher')\n"
  "  LEFT JOIN performance_schema.status_by_thread sslreuse\n"
  "    ON (sslreuse.thread_id=sslver.thread_id and sslreuse.variable_name='Ssl_sessions_reused')\n"
  " WHERE sslver.variable_name='Ssl_version';\n",
"DROP PROCEDURE IF EXISTS create_synonym_db;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE create_synonym_db (\n"
  "        IN in_db_name VARCHAR(64),\n"
  "        IN in_synonym VARCHAR(64)\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Takes a source database name and synonym name, and then creates the\n"
  "             synonym database with views that point to all of the tables within\n"
  "             the source database.\n"
  "             Useful for creating a \"ps\" synonym for \"performance_schema\",\n"
  "             or \"is\" instead of \"information_schema\", for example.\n"
  "             Parameters\n"
  "             in_db_name (VARCHAR(64)):\n"
  "               The database name that you would like to create a synonym for.\n"
  "             in_synonym (VARCHAR(64)):\n"
  "               The database synonym name.\n"
  "             Example\n"
  "             mysql> SHOW DATABASES;\n"
  "             +--------------------+\n"
  "             | Database           |\n"
  "             +--------------------+\n"
  "             | information_schema |\n"
  "             | mysql              |\n"
  "             | performance_schema |\n"
  "             | sys                |\n"
  "             | test               |\n"
  "             +--------------------+\n"
  "             5 rows in set (0.00 sec)\n"
  "             mysql> CALL sys.create_synonym_db(\\'performance_schema\\', \\'ps\\');\n"
  "             +---------------------------------------+\n"
  "             | summary                               |\n"
  "             +---------------------------------------+\n"
  "             | Created 74 views in the `ps` database |\n"
  "             +---------------------------------------+\n"
  "             1 row in set (8.57 sec)\n"
  "             Query OK, 0 rows affected (8.57 sec)\n"
  "             mysql> SHOW DATABASES;\n"
  "             +--------------------+\n"
  "             | Database           |\n"
  "             +--------------------+\n"
  "             | information_schema |\n"
  "             | mysql              |\n"
  "             | performance_schema |\n"
  "             | ps                 |\n"
  "             | sys                |\n"
  "             | test               |\n"
  "             +--------------------+\n"
  "             6 rows in set (0.00 sec)\n"
  "             mysql> SHOW FULL TABLES FROM ps;\n"
  "             +------------------------------------------------------+------------+\n"
  "             | Tables_in_ps                                         | Table_type |\n"
  "             +------------------------------------------------------+------------+\n"
  "             | accounts                                             | VIEW       |\n"
  "             | cond_instances                                       | VIEW       |\n"
  "             | events_stages_current                                | VIEW       |\n"
  "             | events_stages_history                                | VIEW       |\n"
  "             ...\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_done bool DEFAULT FALSE;\n"
  "    DECLARE v_db_name_check VARCHAR(64);\n"
  "    DECLARE v_db_err_msg TEXT;\n"
  "    DECLARE v_table VARCHAR(64);\n"
  "    DECLARE v_views_created INT DEFAULT 0;\n"
  "    DECLARE v_table_exists ENUM('', 'BASE TABLE', 'VIEW', 'TEMPORARY') DEFAULT '';\n"
  "    DECLARE db_doesnt_exist CONDITION FOR SQLSTATE '42000';\n"
  "    DECLARE db_name_exists CONDITION FOR SQLSTATE 'HY000';\n"
  "    DECLARE c_table_names CURSOR FOR\n"
  "        SELECT TABLE_NAME\n"
  "          FROM INFORMATION_SCHEMA.TABLES\n"
  "         WHERE TABLE_SCHEMA = in_db_name;\n"
  "    DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;\n"
  "    SELECT SCHEMA_NAME INTO v_db_name_check\n"
  "      FROM INFORMATION_SCHEMA.SCHEMATA\n"
  "     WHERE SCHEMA_NAME = in_db_name;\n"
  "    IF v_db_name_check IS NULL THEN\n"
  "        SET v_db_err_msg = CONCAT('Unknown database ', in_db_name);\n"
  "        SIGNAL SQLSTATE 'HY000'\n"
  "            SET MESSAGE_TEXT = v_db_err_msg;\n"
  "    END IF;\n"
  "    SELECT SCHEMA_NAME INTO v_db_name_check\n"
  "      FROM INFORMATION_SCHEMA.SCHEMATA\n"
  "     WHERE SCHEMA_NAME = in_synonym;\n"
  "    IF v_db_name_check = in_synonym THEN\n"
  "        SET v_db_err_msg = CONCAT('Can\\'t create database ', in_synonym, '; database exists');\n"
  "        SIGNAL SQLSTATE 'HY000'\n"
  "            SET MESSAGE_TEXT = v_db_err_msg;\n"
  "    END IF;\n"
  "    SET @create_db_stmt := CONCAT('CREATE DATABASE ', sys.quote_identifier(in_synonym));\n"
  "    PREPARE create_db_stmt FROM @create_db_stmt;\n"
  "    EXECUTE create_db_stmt;\n"
  "    DEALLOCATE PREPARE create_db_stmt;\n"
  "    SET v_done = FALSE;\n"
  "    OPEN c_table_names;\n"
  "    c_table_names: LOOP\n"
  "        FETCH c_table_names INTO v_table;\n"
  "        IF v_done THEN\n"
  "            LEAVE c_table_names;\n"
  "        END IF;\n"
  "        CALL sys.table_exists(in_db_name, v_table, v_table_exists);\n"
  "        IF (v_table_exists <> 'TEMPORARY') THEN\n"
  "            SET @create_view_stmt = CONCAT(\n"
  "                'CREATE SQL SECURITY INVOKER VIEW ',\n"
  "                sys.quote_identifier(in_synonym),\n"
  "                '.',\n"
  "                sys.quote_identifier(v_table),\n"
  "                ' AS SELECT * FROM ',\n"
  "                sys.quote_identifier(in_db_name),\n"
  "                '.',\n"
  "                sys.quote_identifier(v_table)\n"
  "            );\n"
  "            PREPARE create_view_stmt FROM @create_view_stmt;\n"
  "            EXECUTE create_view_stmt;\n"
  "            DEALLOCATE PREPARE create_view_stmt;\n"
  "            SET v_views_created = v_views_created + 1;\n"
  "        END IF;\n"
  "    END LOOP;\n"
  "    CLOSE c_table_names;\n"
  "    SELECT CONCAT(\n"
  "        'Created ', v_views_created, ' view',\n"
  "        IF(v_views_created != 1, 's', ''), ' in the ',\n"
  "        sys.quote_identifier(in_synonym), ' database'\n"
  "    ) AS summary;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS execute_prepared_stmt;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE execute_prepared_stmt (\n"
  "        IN in_query longtext CHARACTER SET UTF8\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Takes the query in the argument and executes it using a prepared statement. The prepared statement is deallocated,\n"
  "             so the procedure is mainly useful for executing one off dynamically created queries.\n"
  "             The sys_execute_prepared_stmt prepared statement name is used for the query and is required not to exist.\n"
  "             Parameters\n"
  "             in_query (longtext CHARACTER SET UTF8):\n"
  "               The query to execute.\n"
  "             Configuration Options\n"
  "             sys.debug\n"
  "               Whether to provide debugging output.\n"
  "               Default is ''OFF''. Set to ''ON'' to include.\n"
  "             Example\n"
  "             mysql> CALL sys.execute_prepared_stmt(''SELECT * FROM sys.sys_config'');\n"
  "             +------------------------+-------+---------------------+--------+\n"
  "             | variable               | value | set_time            | set_by |\n"
  "             +------------------------+-------+---------------------+--------+\n"
  "             | statement_truncate_len | 64    | 2015-06-30 13:06:00 | NULL   |\n"
  "             +------------------------+-------+---------------------+--------+\n"
  "             1 row in set (0.00 sec)\n"
  "             Query OK, 0 rows affected (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    IF (@sys.debug IS NULL) THEN\n"
  "        SET @sys.debug = sys.sys_get_config('debug', 'OFF');\n"
  "    END IF;\n"
  "    IF (in_query IS NULL OR LENGTH(in_query) < 4) THEN\n"
  "       SIGNAL SQLSTATE '45000'\n"
  "          SET MESSAGE_TEXT = \"The @sys.execute_prepared_stmt.sql must contain a query\";\n"
  "    END IF;\n"
  "    SET @sys.execute_prepared_stmt.sql = in_query;\n"
  "    IF (@sys.debug = 'ON') THEN\n"
  "        SELECT @sys.execute_prepared_stmt.sql AS 'Debug';\n"
  "    END IF;\n"
  "    PREPARE sys_execute_prepared_stmt FROM @sys.execute_prepared_stmt.sql;\n"
  "    EXECUTE sys_execute_prepared_stmt;\n"
  "    DEALLOCATE PREPARE sys_execute_prepared_stmt;\n"
  "    SET @sys.execute_prepared_stmt.sql = NULL;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS diagnostics;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE diagnostics (\n"
  "        IN in_max_runtime int unsigned, IN in_interval int unsigned,\n"
  "        IN in_auto_config enum ('current', 'medium', 'full')\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Create a report of the current status of the server for diagnostics purposes. Data collected includes (some items depends on versions and settings):\n"
  "                * The GLOBAL VARIABLES\n"
  "                * Several sys schema views including metrics or equivalent (depending on version and settings)\n"
  "                * Queries in the 95th percentile\n"
  "                * Several ndbinfo views for MySQL Cluster\n"
  "                * Replication (both master and slave) information.\n"
  "             Some of the sys schema views are calculated as initial (optional), overall, delta:\n"
  "                * The initial view is the content of the view at the start of this procedure.\n"
  "                  This output will be the same as the the start values used for the delta view.\n"
  "                  The initial view is included if @sys.diagnostics.include_raw = ''ON''.\n"
  "                * The overall view is the content of the view at the end of this procedure.\n"
  "                  This output is the same as the end values used for the delta view.\n"
  "                  The overall view is always included.\n"
  "                * The delta view is the difference from the beginning to the end. Note that for min and max values\n"
  "                  they are simply the min or max value from the end view respectively, so does not necessarily reflect\n"
  "                  the minimum/maximum value in the monitored period.\n"
  "                  Note: except for the metrics views the delta is only calculation between the first and last outputs.\n"
  "             Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n"
  "             Versions supported:\n"
  "                * MySQL 5.6: 5.6.10 and later\n"
  "                * MySQL 5.7: 5.7.9 and later\n"
  "             Parameters\n"
  "             in_max_runtime (INT UNSIGNED):\n"
  "               The maximum time to keep collecting data.\n"
  "               Use NULL to get the default which is 60 seconds, otherwise enter a value greater than 0.\n"
  "             in_interval (INT UNSIGNED):\n"
  "               How long to sleep between data collections.\n"
  "               Use NULL to get the default which is 30 seconds, otherwise enter a value greater than 0.\n"
  "             in_auto_config (ENUM(''current'', ''medium'', ''full''))\n"
  "               Automatically enable Performance Schema instruments and consumers.\n"
  "               NOTE: The more that are enabled, the more impact on the performance.\n"
  "               Supported values are:\n"
  "                  * current - use the current settings.\n"
  "                  * medium - enable some settings.\n"
  "                  * full - enables all settings. This will have a big impact on the\n"
  "                           performance - be careful using this option.\n"
  "               If another setting the ''current'' is chosen, the current settings\n"
  "               are restored at the end of the procedure.\n"
  "             Configuration Options\n"
  "             sys.diagnostics.allow_i_s_tables\n"
  "               Specifies whether it is allowed to do table scan queries on information_schema.TABLES. This can be expensive if there\n"
  "               are many tables. Set to ''ON'' to allow, ''OFF'' to not allow.\n"
  "               Default is ''OFF''.\n"
  "             sys.diagnostics.include_raw\n"
  "               Set to ''ON'' to include the raw data (e.g. the original output of \"SELECT * FROM sys.metrics\").\n"
  "               Use this to get the initial values of the various views.\n"
  "               Default is ''OFF''.\n"
  "             sys.statement_truncate_len\n"
  "               How much of queries in the process list output to include.\n"
  "               Default is 64.\n"
  "             sys.debug\n"
  "               Whether to provide debugging output.\n"
  "               Default is ''OFF''. Set to ''ON'' to include.\n"
  "             Example\n"
  "             To create a report and append it to the file diag.out:\n"
  "             mysql> TEE diag.out;\n"
  "             mysql> CALL sys.diagnostics(120, 30, ''current'');\n"
  "             ...\n"
  "             mysql> NOTEE;\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_start, v_runtime, v_iter_start, v_sleep DECIMAL(20,2) DEFAULT 0.0;\n"
  "    DECLARE v_has_innodb, v_has_ndb, v_has_ps, v_has_replication, v_has_ps_replication VARCHAR(8) CHARSET utf8 COLLATE utf8_general_ci DEFAULT 'NO';\n"
  "    DECLARE v_this_thread_enabled, v_has_ps_vars, v_has_metrics ENUM('YES', 'NO');\n"
  "    DECLARE v_table_name, v_banner VARCHAR(64) CHARSET utf8 COLLATE utf8_general_ci;\n"
  "    DECLARE v_sql_status_summary_select, v_sql_status_summary_delta, v_sql_status_summary_from, v_no_delta_names TEXT;\n"
  "    DECLARE v_output_time, v_output_time_prev DECIMAL(20,3) UNSIGNED;\n"
  "    DECLARE v_output_count, v_count, v_old_group_concat_max_len INT UNSIGNED DEFAULT 0;\n"
  "    DECLARE v_status_summary_width TINYINT UNSIGNED DEFAULT 50;\n"
  "    DECLARE v_done BOOLEAN DEFAULT FALSE;\n"
  "    DECLARE c_ndbinfo CURSOR FOR\n"
  "        SELECT TABLE_NAME\n"
  "          FROM information_schema.TABLES\n"
  "         WHERE TABLE_SCHEMA = 'ndbinfo'\n"
  "               AND TABLE_NAME NOT IN (\n"
  "                  'blocks',\n"
  "                  'config_params',\n"
  "                  'dict_obj_types',\n"
  "                  'disk_write_speed_base',\n"
  "                  'memory_per_fragment',\n"
  "                  'memoryusage',\n"
  "                  'operations_per_fragment',\n"
  "                  'threadblocks'\n"
  "               );\n"
  "    DECLARE c_sysviews_w_delta CURSOR FOR\n"
  "        SELECT table_name\n"
  "          FROM tmp_sys_views_delta\n"
  "         ORDER BY table_name;\n"
  "    DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;\n"
  "    SELECT INSTRUMENTED INTO v_this_thread_enabled FROM performance_schema.threads WHERE PROCESSLIST_ID = CONNECTION_ID();\n"
  "    IF (v_this_thread_enabled = 'YES') THEN\n"
  "        CALL sys.ps_setup_disable_thread(CONNECTION_ID());\n"
  "    END IF;\n"
  "    IF (in_max_runtime < in_interval) THEN\n"
  "        SIGNAL SQLSTATE '45000'\n"
  "           SET MESSAGE_TEXT = 'in_max_runtime must be greater than or equal to in_interval';\n"
  "    END IF;\n"
  "    IF (in_max_runtime = 0) THEN\n"
  "        SIGNAL SQLSTATE '45000'\n"
  "           SET MESSAGE_TEXT = 'in_max_runtime must be greater than 0';\n"
  "    END IF;\n"
  "    IF (in_interval = 0) THEN\n"
  "        SIGNAL SQLSTATE '45000'\n"
  "           SET MESSAGE_TEXT = 'in_interval must be greater than 0';\n"
  "    END IF;\n"
  "    IF (@sys.diagnostics.allow_i_s_tables IS NULL) THEN\n"
  "        SET @sys.diagnostics.allow_i_s_tables = sys.sys_get_config('diagnostics.allow_i_s_tables', 'OFF');\n"
  "    END IF;\n"
  "    IF (@sys.diagnostics.include_raw IS NULL) THEN\n"
  "        SET @sys.diagnostics.include_raw      = sys.sys_get_config('diagnostics.include_raw'     , 'OFF');\n"
  "    END IF;\n"
  "    IF (@sys.debug IS NULL) THEN\n"
  "        SET @sys.debug                        = sys.sys_get_config('debug'                       , 'OFF');\n"
  "    END IF;\n"
  "    IF (@sys.statement_truncate_len IS NULL) THEN\n"
  "        SET @sys.statement_truncate_len       = sys.sys_get_config('statement_truncate_len'      , '64' );\n"
  "    END IF;\n"
  "    SET @log_bin := @@sql_log_bin;\n"
  "    IF (@log_bin = 1) THEN\n"
  "        SET sql_log_bin = 0;\n"
  "    END IF;\n"
  "    SET v_no_delta_names = CONCAT('s%{COUNT}.Variable_name NOT IN (',\n"
  "        '''innodb_buffer_pool_pages_total'', ',\n"
  "        '''innodb_page_size'', ',\n"
  "        '''last_query_cost'', ',\n"
  "        '''last_query_partial_plans'', ',\n"
  "        '''qcache_total_blocks'', ',\n"
  "        '''slave_last_heartbeat'', ',\n"
  "        '''ssl_ctx_verify_depth'', ',\n"
  "        '''ssl_ctx_verify_mode'', ',\n"
  "        '''ssl_session_cache_size'', ',\n"
  "        '''ssl_verify_depth'', ',\n"
  "        '''ssl_verify_mode'', ',\n"
  "        '''ssl_version'', ',\n"
  "        '''buffer_flush_lsn_avg_rate'', ',\n"
  "        '''buffer_flush_pct_for_dirty'', ',\n"
  "        '''buffer_flush_pct_for_lsn'', ',\n"
  "        '''buffer_pool_pages_total'', ',\n"
  "        '''lock_row_lock_time_avg'', ',\n"
  "        '''lock_row_lock_time_max'', ',\n"
  "        '''innodb_page_size''',\n"
  "    ')');\n"
  "    IF (in_auto_config <> 'current') THEN\n"
  "        IF (@sys.debug = 'ON') THEN\n"
  "            SELECT CONCAT('Updating Performance Schema configuration to ', in_auto_config) AS 'Debug';\n"
  "        END IF;\n"
  "        CALL sys.ps_setup_save(0);\n"
  "        IF (in_auto_config = 'medium') THEN\n"
  "            UPDATE performance_schema.setup_consumers\n"
  "                SET ENABLED = 'YES'\n"
  "            WHERE NAME NOT LIKE '%\\_history%';\n"
  "            UPDATE performance_schema.setup_instruments\n"
  "                SET ENABLED = 'YES',\n"
  "                    TIMED   = 'YES'\n"
  "            WHERE NAME NOT LIKE 'wait/synch/%';\n"
  "        ELSEIF (in_auto_config = 'full') THEN\n"
  "            UPDATE performance_schema.setup_consumers\n"
  "                SET ENABLED = 'YES';\n"
  "            UPDATE performance_schema.setup_instruments\n"
  "                SET ENABLED = 'YES',\n"
  "                    TIMED   = 'YES';\n"
  "        END IF;\n"
  "        UPDATE performance_schema.threads\n"
  "           SET INSTRUMENTED = 'YES'\n"
  "         WHERE PROCESSLIST_ID <> CONNECTION_ID();\n"
  "    END IF;\n"
  "    SET v_start        = UNIX_TIMESTAMP(NOW(2)),\n"
  "        in_interval    = IFNULL(in_interval, 30),\n"
  "        in_max_runtime = IFNULL(in_max_runtime, 60);\n"
  "    SET v_banner = REPEAT(\n"
  "                      '-',\n"
  "                      LEAST(\n"
  "                         GREATEST(\n"
  "                            36,\n"
  "                            CHAR_LENGTH(VERSION()),\n"
  "                            CHAR_LENGTH(@@global.version_comment),\n"
  "                            CHAR_LENGTH(@@global.version_compile_os),\n"
  "                            CHAR_LENGTH(@@global.version_compile_machine),\n"
  "                            CHAR_LENGTH(@@global.socket),\n"
  "                            CHAR_LENGTH(@@global.datadir)\n"
  "                         ),\n"
  "                         64\n"
  "                      )\n"
  "                   );\n"
  "    SELECT 'Hostname' AS 'Name', @@global.hostname AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Port' AS 'Name', @@global.port AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Socket' AS 'Name', @@global.socket AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Datadir' AS 'Name', @@global.datadir AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT REPEAT('-', 23) AS 'Name', v_banner AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'MySQL Version' AS 'Name', VERSION() AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Sys Schema Version' AS 'Name', (SELECT sys_version FROM sys.version) AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Version Comment' AS 'Name', @@global.version_comment AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Version Compile OS' AS 'Name', @@global.version_compile_os AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Version Compile Machine' AS 'Name', @@global.version_compile_machine AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT REPEAT('-', 23) AS 'Name', v_banner AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'UTC Time' AS 'Name', UTC_TIMESTAMP() AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Local Time' AS 'Name', NOW() AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Time Zone' AS 'Name', @@global.time_zone AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'System Time Zone' AS 'Name', @@global.system_time_zone AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Time Zone Offset' AS 'Name', TIMEDIFF(NOW(), UTC_TIMESTAMP()) AS 'Value';\n"
  "    SET v_has_innodb         = IFNULL((SELECT SUPPORT FROM information_schema.ENGINES WHERE ENGINE = 'InnoDB'), 'NO'),\n"
  "        v_has_ndb            = IFNULL((SELECT SUPPORT FROM information_schema.ENGINES WHERE ENGINE = 'NDBCluster'), 'NO'),\n"
  "        v_has_ps             = IFNULL((SELECT SUPPORT FROM information_schema.ENGINES WHERE ENGINE = 'PERFORMANCE_SCHEMA'), 'NO'),\n"
  "        v_has_ps_replication = IF(v_has_ps = 'YES'\n"
  "                                   AND EXISTS(SELECT 1 FROM information_schema.TABLES WHERE TABLE_SCHEMA = 'performance_schema' AND TABLE_NAME = 'replication_applier_status'),\n"
  "                                   'YES',\n"
  "                                   'NO'\n"
  "                               ),\n"
  "        v_has_replication    = 'MAYBE',\n"
  "        v_has_metrics        = IF(v_has_ps = 'YES' OR (sys.version_major() = 5 AND sys.version_minor() = 6), 'YES', 'NO'),\n"
  "        v_has_ps_vars        = 'NO';\n"
  "    /*!50707 SET v_has_ps_vars = IF(@@global.show_compatibility_56, 'NO', 'YES');*/\n"
  "    /*!50709 SET v_has_ps_vars = 'YES';*/\n"
  "    IF (@sys.debug = 'ON') THEN\n"
  "       SELECT v_has_innodb AS 'Has_InnoDB', v_has_ndb AS 'Has_NDBCluster',\n"
  "              v_has_ps AS 'Has_Performance_Schema', v_has_ps_vars AS 'Has_P_S_SHOW_Variables',\n"
  "              v_has_metrics AS 'Has_metrics',\n"
  "              v_has_ps_replication 'AS Has_P_S_Replication', v_has_replication AS 'Has_Replication';\n"
  "    END IF;\n"
  "    IF (v_has_innodb IN ('DEFAULT', 'YES')) THEN\n"
  "        SET @sys.diagnostics.sql = 'SHOW ENGINE InnoDB STATUS';\n"
  "        PREPARE stmt_innodb_status FROM @sys.diagnostics.sql;\n"
  "    END IF;\n"
  "    IF (v_has_ps = 'YES') THEN\n"
  "        SET @sys.diagnostics.sql = 'SHOW ENGINE PERFORMANCE_SCHEMA STATUS';\n"
  "        PREPARE stmt_ps_status FROM @sys.diagnostics.sql;\n"
  "    END IF;\n"
  "    IF (v_has_ndb IN ('DEFAULT', 'YES')) THEN\n"
  "        SET @sys.diagnostics.sql = 'SHOW ENGINE NDBCLUSTER STATUS';\n"
  "        PREPARE stmt_ndbcluster_status FROM @sys.diagnostics.sql;\n"
  "    END IF;\n"
  "    SET @sys.diagnostics.sql_gen_query_template = 'SELECT CONCAT(\n"
  "           ''SELECT '',\n"
  "           GROUP_CONCAT(\n"
  "               CASE WHEN (SUBSTRING(TABLE_NAME, 3), COLUMN_NAME) IN (\n"
  "                                (''io_global_by_file_by_bytes'', ''total''),\n"
  "                                (''io_global_by_wait_by_bytes'', ''total_requested'')\n"
  "                         )\n"
  "                         THEN CONCAT(''format_bytes('', COLUMN_NAME, '') AS '', COLUMN_NAME)\n"
  "                    WHEN SUBSTRING(COLUMN_NAME, -8) = ''_latency''\n"
  "                         THEN CONCAT(''format_pico_time('', COLUMN_NAME, '') AS '', COLUMN_NAME)\n"
  "                    WHEN SUBSTRING(COLUMN_NAME, -7) = ''_memory'' OR SUBSTRING(COLUMN_NAME, -17) = ''_memory_allocated''\n"
  "                         OR ((SUBSTRING(COLUMN_NAME, -5) = ''_read'' OR SUBSTRING(COLUMN_NAME, -8) = ''_written'' OR SUBSTRING(COLUMN_NAME, -6) = ''_write'') AND SUBSTRING(COLUMN_NAME, 1, 6) <> ''COUNT_'')\n"
  "                         THEN CONCAT(''format_bytes('', COLUMN_NAME, '') AS '', COLUMN_NAME)\n"
  "                    ELSE COLUMN_NAME\n"
  "               END\n"
  "               ORDER BY ORDINAL_POSITION\n"
  "               SEPARATOR '',\\n       ''\n"
  "           ),\n"
  "           ''\\n  FROM tmp_'', SUBSTRING(TABLE_NAME FROM 3), ''_%{OUTPUT}''\n"
  "       ) AS Query INTO @sys.diagnostics.sql_select\n"
  "  FROM information_schema.COLUMNS\n"
  " WHERE TABLE_SCHEMA = ''sys'' AND TABLE_NAME = ?\n"
  " GROUP BY TABLE_NAME';\n"
  "    SET @sys.diagnostics.sql_gen_query_delta = 'SELECT CONCAT(\n"
  "           ''SELECT '',\n"
  "           GROUP_CONCAT(\n"
  "               CASE WHEN FIND_IN_SET(COLUMN_NAME, diag.pk)\n"
  "                         THEN COLUMN_NAME\n"
  "                    WHEN diag.TABLE_NAME = ''io_global_by_file_by_bytes'' AND COLUMN_NAME = ''write_pct''\n"
  "                         THEN CONCAT(''IFNULL(ROUND(100-(((e.total_read-IFNULL(s.total_read, 0))'',\n"
  "                                     ''/NULLIF(((e.total_read-IFNULL(s.total_read, 0))+(e.total_written-IFNULL(s.total_written, 0))), 0))*100), 2), 0.00) AS '',\n"
  "                                     COLUMN_NAME)\n"
  "                    WHEN (diag.TABLE_NAME, COLUMN_NAME) IN (\n"
  "                                (''io_global_by_file_by_bytes'', ''total''),\n"
  "                                (''io_global_by_wait_by_bytes'', ''total_requested'')\n"
  "                         )\n"
  "                         THEN CONCAT(''format_bytes(e.'', COLUMN_NAME, ''-IFNULL(s.'', COLUMN_NAME, '', 0)) AS '', COLUMN_NAME)\n"
  "                    WHEN SUBSTRING(COLUMN_NAME, 1, 4) IN (''max_'', ''min_'') AND SUBSTRING(COLUMN_NAME, -8) = ''_latency''\n"
  "                         THEN CONCAT(''format_pico_time(e.'', COLUMN_NAME, '') AS '', COLUMN_NAME)\n"
  "                    WHEN COLUMN_NAME = ''avg_latency''\n"
  "                         THEN CONCAT(''format_pico_time((e.total_latency - IFNULL(s.total_latency, 0))'',\n"
  "                                     ''/NULLIF(e.total - IFNULL(s.total, 0), 0)) AS '', COLUMN_NAME)\n"
  "                    WHEN SUBSTRING(COLUMN_NAME, -12) = ''_avg_latency''\n"
  "                         THEN CONCAT(''format_pico_time((e.'', SUBSTRING(COLUMN_NAME FROM 1 FOR CHAR_LENGTH(COLUMN_NAME)-12), ''_latency - IFNULL(s.'', SUBSTRING(COLUMN_NAME FROM 1 FOR CHAR_LENGTH(COLUMN_NAME)-12), ''_latency, 0))'',\n"
  "                                     ''/NULLIF(e.'', SUBSTRING(COLUMN_NAME FROM 1 FOR CHAR_LENGTH(COLUMN_NAME)-12), ''s - IFNULL(s.'', SUBSTRING(COLUMN_NAME FROM 1 FOR CHAR_LENGTH(COLUMN_NAME)-12), ''s, 0), 0)) AS '', COLUMN_NAME)\n"
  "                    WHEN SUBSTRING(COLUMN_NAME, -8) = ''_latency''\n"
  "                         THEN CONCAT(''format_pico_time(e.'', COLUMN_NAME, '' - IFNULL(s.'', COLUMN_NAME, '', 0)) AS '', COLUMN_NAME)\n"
  "                    WHEN COLUMN_NAME IN (''avg_read'', ''avg_write'', ''avg_written'')\n"
  "                         THEN CONCAT(''format_bytes(IFNULL((e.total_'', IF(COLUMN_NAME = ''avg_read'', ''read'', ''written''), ''-IFNULL(s.total_'', IF(COLUMN_NAME = ''avg_read'', ''read'', ''written''), '', 0))'',\n"
  "                                     ''/NULLIF(e.count_'', IF(COLUMN_NAME = ''avg_read'', ''read'', ''write''), ''-IFNULL(s.count_'', IF(COLUMN_NAME = ''avg_read'', ''read'', ''write''), '', 0), 0), 0)) AS '',\n"
  "                                     COLUMN_NAME)\n"
  "                    WHEN SUBSTRING(COLUMN_NAME, -7) = ''_memory'' OR SUBSTRING(COLUMN_NAME, -17) = ''_memory_allocated''\n"
  "                         OR ((SUBSTRING(COLUMN_NAME, -5) = ''_read'' OR SUBSTRING(COLUMN_NAME, -8) = ''_written'' OR SUBSTRING(COLUMN_NAME, -6) = ''_write'') AND SUBSTRING(COLUMN_NAME, 1, 6) <> ''COUNT_'')\n"
  "                         THEN CONCAT(''format_bytes(e.'', COLUMN_NAME, '' - IFNULL(s.'', COLUMN_NAME, '', 0)) AS '', COLUMN_NAME)\n"
  "                    ELSE CONCAT(''(e.'', COLUMN_NAME, '' - IFNULL(s.'', COLUMN_NAME, '', 0)) AS '', COLUMN_NAME)\n"
  "               END\n"
  "               ORDER BY ORDINAL_POSITION\n"
  "               SEPARATOR '',\\n       ''\n"
  "           ),\n"
  "           ''\\n  FROM tmp_'', diag.TABLE_NAME, ''_end e\n"
  "       LEFT OUTER JOIN tmp_'', diag.TABLE_NAME, ''_start s USING ('', diag.pk, '')''\n"
  "       ) AS Query INTO @sys.diagnostics.sql_select\n"
  "  FROM tmp_sys_views_delta diag\n"
  "       INNER JOIN information_schema.COLUMNS c ON c.TABLE_NAME = CONCAT(''x$'', diag.TABLE_NAME)\n"
  " WHERE c.TABLE_SCHEMA = ''sys'' AND diag.TABLE_NAME = ?\n"
  " GROUP BY diag.TABLE_NAME';\n"
  "    IF (v_has_ps = 'YES') THEN\n"
  "        DROP TEMPORARY TABLE IF EXISTS tmp_sys_views_delta;\n"
  "        CREATE TEMPORARY TABLE tmp_sys_views_delta (\n"
  "            TABLE_NAME varchar(64) NOT NULL,\n"
  "            order_by text COMMENT 'ORDER BY clause for the initial and overall views',\n"
  "            order_by_delta text COMMENT 'ORDER BY clause for the delta views',\n"
  "            where_delta text COMMENT 'WHERE clause to use for delta views to only include rows with a \"count\" > 0',\n"
  "            limit_rows int unsigned COMMENT 'The maximum number of rows to include for the view',\n"
  "            pk varchar(128) COMMENT 'Used with the FIND_IN_SET() function so use comma separated list without whitespace',\n"
  "            PRIMARY KEY (TABLE_NAME)\n"
  "        );\n"
  "        IF (@sys.debug = 'ON') THEN\n"
  "            SELECT 'Populating tmp_sys_views_delta' AS 'Debug';\n"
  "        END IF;\n"
  "        INSERT INTO tmp_sys_views_delta\n"
  "        VALUES ('host_summary'                       , '%{TABLE}.statement_latency DESC',\n"
  "                                                       '(e.statement_latency-IFNULL(s.statement_latency, 0)) DESC',\n"
  "                                                       '(e.statements - IFNULL(s.statements, 0)) > 0', NULL, 'host'),\n"
  "               ('host_summary_by_file_io'            , '%{TABLE}.io_latency DESC',\n"
  "                                                       '(e.io_latency-IFNULL(s.io_latency, 0)) DESC',\n"
  "                                                       '(e.ios - IFNULL(s.ios, 0)) > 0', NULL, 'host'),\n"
  "               ('host_summary_by_file_io_type'       , '%{TABLE}.host, %{TABLE}.total_latency DESC',\n"
  "                                                       'e.host, (e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'host,event_name'),\n"
  "               ('host_summary_by_stages'             , '%{TABLE}.host, %{TABLE}.total_latency DESC',\n"
  "                                                       'e.host, (e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'host,event_name'),\n"
  "               ('host_summary_by_statement_latency'  , '%{TABLE}.total_latency DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'host'),\n"
  "               ('host_summary_by_statement_type'     , '%{TABLE}.host, %{TABLE}.total_latency DESC',\n"
  "                                                       'e.host, (e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'host,statement'),\n"
  "               ('io_by_thread_by_latency'            , '%{TABLE}.total_latency DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'user,thread_id,processlist_id'),\n"
  "               ('io_global_by_file_by_bytes'         , '%{TABLE}.total DESC',\n"
  "                                                       '(e.total-IFNULL(s.total, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', 100, 'file'),\n"
  "               ('io_global_by_file_by_latency'       , '%{TABLE}.total_latency DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', 100, 'file'),\n"
  "               ('io_global_by_wait_by_bytes'         , '%{TABLE}.total_requested DESC',\n"
  "                                                       '(e.total_requested-IFNULL(s.total_requested, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'event_name'),\n"
  "               ('io_global_by_wait_by_latency'       , '%{TABLE}.total_latency DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'event_name'),\n"
  "               ('schema_index_statistics'            , '(%{TABLE}.select_latency+%{TABLE}.insert_latency+%{TABLE}.update_latency+%{TABLE}.delete_latency) DESC',\n"
  "                                                       '((e.select_latency+e.insert_latency+e.update_latency+e.delete_latency)-IFNULL(s.select_latency+s.insert_latency+s.update_latency+s.delete_latency, 0)) DESC',\n"
  "                                                       '((e.rows_selected+e.insert_latency+e.rows_updated+e.rows_deleted)-IFNULL(s.rows_selected+s.rows_inserted+s.rows_updated+s.rows_deleted, 0)) > 0',\n"
  "                                                       100, 'table_schema,table_name,index_name'),\n"
  "               ('schema_table_statistics'            , '%{TABLE}.total_latency DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) > 0', 100, 'table_schema,table_name'),\n"
  "               ('schema_tables_with_full_table_scans', '%{TABLE}.rows_full_scanned DESC',\n"
  "                                                       '(e.rows_full_scanned-IFNULL(s.rows_full_scanned, 0)) DESC',\n"
  "                                                       '(e.rows_full_scanned-IFNULL(s.rows_full_scanned, 0)) > 0', 100, 'object_schema,object_name'),\n"
  "               ('user_summary'                       , '%{TABLE}.statement_latency DESC',\n"
  "                                                       '(e.statement_latency-IFNULL(s.statement_latency, 0)) DESC',\n"
  "                                                       '(e.statements - IFNULL(s.statements, 0)) > 0', NULL, 'user'),\n"
  "               ('user_summary_by_file_io'            , '%{TABLE}.io_latency DESC',\n"
  "                                                       '(e.io_latency-IFNULL(s.io_latency, 0)) DESC',\n"
  "                                                       '(e.ios - IFNULL(s.ios, 0)) > 0', NULL, 'user'),\n"
  "               ('user_summary_by_file_io_type'       , '%{TABLE}.user, %{TABLE}.latency DESC',\n"
  "                                                       'e.user, (e.latency-IFNULL(s.latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'user,event_name'),\n"
  "               ('user_summary_by_stages'             , '%{TABLE}.user, %{TABLE}.total_latency DESC',\n"
  "                                                       'e.user, (e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'user,event_name'),\n"
  "               ('user_summary_by_statement_latency'  , '%{TABLE}.total_latency DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'user'),\n"
  "               ('user_summary_by_statement_type'     , '%{TABLE}.user, %{TABLE}.total_latency DESC',\n"
  "                                                       'e.user, (e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'user,statement'),\n"
  "               ('wait_classes_global_by_avg_latency' , 'IFNULL(%{TABLE}.total_latency / NULLIF(%{TABLE}.total, 0), 0) DESC',\n"
  "                                                       'IFNULL((e.total_latency-IFNULL(s.total_latency, 0)) / NULLIF((e.total - IFNULL(s.total, 0)), 0), 0) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'event_class'),\n"
  "               ('wait_classes_global_by_latency'     , '%{TABLE}.total_latency DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'event_class'),\n"
  "               ('waits_by_host_by_latency'           , '%{TABLE}.host, %{TABLE}.total_latency DESC',\n"
  "                                                       'e.host, (e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'host,event'),\n"
  "               ('waits_by_user_by_latency'           , '%{TABLE}.user, %{TABLE}.total_latency DESC',\n"
  "                                                       'e.user, (e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'user,event'),\n"
  "               ('waits_global_by_latency'            , '%{TABLE}.total_latency DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'events')\n"
  "        ;\n"
  "    END IF;\n"
  "    SELECT '\n"
  "=======================\n"
  "     Configuration\n"
  "=======================\n"
  "' AS '';\n"
  "    SELECT 'GLOBAL VARIABLES' AS 'The following output is:';\n"
  "    IF (v_has_ps_vars = 'YES') THEN\n"
  "        SELECT LOWER(VARIABLE_NAME) AS Variable_name, VARIABLE_VALUE AS Variable_value FROM performance_schema.global_variables ORDER BY VARIABLE_NAME;\n"
  "    ELSE\n"
  "        SELECT LOWER(VARIABLE_NAME) AS Variable_name, VARIABLE_VALUE AS Variable_value FROM information_schema.GLOBAL_VARIABLES ORDER BY VARIABLE_NAME;\n"
  "    END IF;\n"
  "    IF (v_has_ps = 'YES') THEN\n"
  "        SELECT 'Performance Schema Setup - Actors' AS 'The following output is:';\n"
  "        SELECT * FROM performance_schema.setup_actors;\n"
  "        SELECT 'Performance Schema Setup - Consumers' AS 'The following output is:';\n"
  "        SELECT NAME AS Consumer, ENABLED, sys.ps_is_consumer_enabled(NAME) AS COLLECTS\n"
  "          FROM performance_schema.setup_consumers;\n"
  "        SELECT 'Performance Schema Setup - Instruments' AS 'The following output is:';\n"
  "        SELECT SUBSTRING_INDEX(NAME, '/', 2) AS 'InstrumentClass',\n"
  "               ROUND(100*SUM(IF(ENABLED = 'YES', 1, 0))/COUNT(*), 2) AS 'EnabledPct',\n"
  "               ROUND(100*SUM(IF(TIMED = 'YES', 1, 0))/COUNT(*), 2) AS 'TimedPct'\n"
  "          FROM performance_schema.setup_instruments\n"
  "         GROUP BY SUBSTRING_INDEX(NAME, '/', 2)\n"
  "         ORDER BY SUBSTRING_INDEX(NAME, '/', 2);\n"
  "        SELECT 'Performance Schema Setup - Objects' AS 'The following output is:';\n"
  "        SELECT * FROM performance_schema.setup_objects;\n"
  "        SELECT 'Performance Schema Setup - Threads' AS 'The following output is:';\n"
  "        SELECT `TYPE` AS ThreadType, COUNT(*) AS 'Total', ROUND(100*SUM(IF(INSTRUMENTED = 'YES', 1, 0))/COUNT(*), 2) AS 'InstrumentedPct'\n"
  "          FROM performance_schema.threads\n"
  "        GROUP BY TYPE;\n"
  "    END IF;\n"
  "    IF (v_has_replication = 'NO') THEN\n"
  "        SELECT 'No Replication Configured' AS 'Replication Status';\n"
  "    ELSE\n"
  "        SELECT CONCAT('Replication Configured: ', v_has_replication, ' - Performance Schema Replication Tables: ', v_has_ps_replication) AS 'Replication Status';\n"
  "        IF (v_has_ps_replication = 'YES') THEN\n"
  "            SELECT 'Replication - Connection Configuration' AS 'The following output is:';\n"
  "            SELECT * FROM performance_schema.replication_connection_configuration/*!50706 ORDER BY CHANNEL_NAME*/;\n"
  "        END IF;\n"
  "        IF (v_has_ps_replication = 'YES') THEN\n"
  "            SELECT 'Replication - Applier Configuration' AS 'The following output is:';\n"
  "            SELECT * FROM performance_schema.replication_applier_configuration ORDER BY CHANNEL_NAME;\n"
  "        END IF;\n"
  "    END IF;\n"
  "    IF (v_has_ndb IN ('DEFAULT', 'YES')) THEN\n"
  "       SELECT 'Cluster Thread Blocks' AS 'The following output is:';\n"
  "       SELECT * FROM ndbinfo.threadblocks;\n"
  "    END IF;\n"
  "    IF (v_has_ps = 'YES') THEN\n"
  "        IF (@sys.diagnostics.include_raw = 'ON') THEN\n"
  "            SELECT '\n"
  "========================\n"
  "     Initial Status\n"
  "========================\n"
  "' AS '';\n"
  "        END IF;\n"
  "        DROP TEMPORARY TABLE IF EXISTS tmp_digests_start;\n"
  "        CALL sys.statement_performance_analyzer('create_tmp', 'tmp_digests_start', NULL);\n"
  "        CALL sys.statement_performance_analyzer('snapshot', NULL, NULL);\n"
  "        CALL sys.statement_performance_analyzer('save', 'tmp_digests_start', NULL);\n"
  "        IF (@sys.diagnostics.include_raw = 'ON') THEN\n"
  "            SET @sys.diagnostics.sql = REPLACE(@sys.diagnostics.sql_gen_query_template, '%{OUTPUT}', 'start');\n"
  "            IF (@sys.debug = 'ON') THEN\n"
  "                SELECT 'The following query will be used to generate the query for each sys view' AS 'Debug';\n"
  "                SELECT @sys.diagnostics.sql AS 'Debug';\n"
  "            END IF;\n"
  "            PREPARE stmt_gen_query FROM @sys.diagnostics.sql;\n"
  "        END IF;\n"
  "        SET v_done = FALSE;\n"
  "        OPEN c_sysviews_w_delta;\n"
  "        c_sysviews_w_delta_loop: LOOP\n"
  "            FETCH c_sysviews_w_delta INTO v_table_name;\n"
  "            IF v_done THEN\n"
  "                LEAVE c_sysviews_w_delta_loop;\n"
  "            END IF;\n"
  "            IF (@sys.debug = 'ON') THEN\n"
  "                SELECT CONCAT('The following queries are for storing the initial content of ', v_table_name) AS 'Debug';\n"
  "            END IF;\n"
  "            CALL sys.execute_prepared_stmt(CONCAT('DROP TEMPORARY TABLE IF EXISTS `tmp_', v_table_name, '_start`'));\n"
  "            CALL sys.execute_prepared_stmt(CONCAT('CREATE TEMPORARY TABLE `tmp_', v_table_name, '_start` SELECT * FROM `sys`.`x$', v_table_name, '`'));\n"
  "            IF (@sys.diagnostics.include_raw = 'ON') THEN\n"
  "                SET @sys.diagnostics.table_name = CONCAT('x$', v_table_name);\n"
  "                EXECUTE stmt_gen_query USING @sys.diagnostics.table_name;\n"
  "                SELECT CONCAT(@sys.diagnostics.sql_select,\n"
  "                              IF(order_by IS NOT NULL, CONCAT('\\n ORDER BY ', REPLACE(order_by, '%{TABLE}', CONCAT('tmp_', v_table_name, '_start'))), ''),\n"
  "                              IF(limit_rows IS NOT NULL, CONCAT('\\n LIMIT ', limit_rows), '')\n"
  "                       )\n"
  "                  INTO @sys.diagnostics.sql_select\n"
  "                  FROM tmp_sys_views_delta\n"
  "                 WHERE TABLE_NAME = v_table_name;\n"
  "                SELECT CONCAT('Initial ', v_table_name) AS 'The following output is:';\n"
  "                CALL sys.execute_prepared_stmt(@sys.diagnostics.sql_select);\n"
  "            END IF;\n"
  "        END LOOP;\n"
  "        CLOSE c_sysviews_w_delta;\n"
  "        IF (@sys.diagnostics.include_raw = 'ON') THEN\n"
  "            DEALLOCATE PREPARE stmt_gen_query;\n"
  "        END IF;\n"
  "    END IF;\n"
  "    SET v_sql_status_summary_select = 'SELECT Variable_name',\n"
  "        v_sql_status_summary_delta  = '',\n"
  "        v_sql_status_summary_from   = '';\n"
  "    REPEAT\n"
  "        SET v_output_count = v_output_count + 1;\n"
  "        IF (v_output_count > 1) THEN\n"
  "            SET v_sleep = in_interval-(UNIX_TIMESTAMP(NOW(2))-v_iter_start);\n"
  "            SELECT NOW() AS 'Time', CONCAT('Going to sleep for ', v_sleep, ' seconds. Please do not interrupt') AS 'The following output is:';\n"
  "            DO SLEEP(in_interval);\n"
  "        END IF;\n"
  "        SET v_iter_start = UNIX_TIMESTAMP(NOW(2));\n"
  "        SELECT NOW(), CONCAT('Iteration Number ', IFNULL(v_output_count, 'NULL')) AS 'The following output is:';\n"
  "        IF (@@log_bin = 1) THEN\n"
  "            SELECT 'SHOW MASTER STATUS' AS 'The following output is:';\n"
  "            SHOW MASTER STATUS;\n"
  "        END IF;\n"
  "        IF (v_has_replication <> 'NO') THEN\n"
  "            SELECT 'SHOW SLAVE STATUS' AS 'The following output is:';\n"
  "            SHOW SLAVE STATUS;\n"
  "        END IF;\n"
  "        SET v_table_name = CONCAT('tmp_metrics_', v_output_count);\n"
  "        CALL sys.execute_prepared_stmt(CONCAT('DROP TEMPORARY TABLE IF EXISTS ', v_table_name));\n"
  "        CALL sys.execute_prepared_stmt(CONCAT('CREATE TEMPORARY TABLE ', v_table_name, ' (\n"
  "  Variable_name VARCHAR(193) NOT NULL,\n"
  "  Variable_value VARCHAR(1024),\n"
  "  Type VARCHAR(100) NOT NULL,\n"
  "  Enabled ENUM(''YES'', ''NO'', ''PARTIAL'') NOT NULL,\n"
  "  PRIMARY KEY (Type, Variable_name)\n"
  ") ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE utf8_general_ci'));\n"
  "        IF (v_has_metrics) THEN\n"
  "            SET @sys.diagnostics.sql = CONCAT(\n"
  "                'INSERT INTO ', v_table_name,\n"
  "                ' SELECT Variable_name, REPLACE(Variable_value, ''\\n'', ''\\\\\\\\n'') AS Variable_value, Type, Enabled FROM sys.metrics'\n"
  "            );\n"
  "        ELSE\n"
  "            SET @sys.diagnostics.sql = CONCAT(\n"
  "                'INSERT INTO ', v_table_name,\n"
  "                '(SELECT LOWER(VARIABLE_NAME) AS Variable_name, REPLACE(VARIABLE_VALUE, ''\\n'', ''\\\\\\\\n'') AS Variable_value,\n"
  "                         ''Global Status'' AS Type, ''YES'' AS Enabled\n"
  "  FROM performance_schema.global_status\n"
  ") UNION ALL (\n"
  "SELECT NAME AS Variable_name, COUNT AS Variable_value,\n"
  "       CONCAT(''InnoDB Metrics - '', SUBSYSTEM) AS Type,\n"
  "       IF(STATUS = ''enabled'', ''YES'', ''NO'') AS Enabled\n"
  "  FROM information_schema.INNODB_METRICS\n"
  " WHERE NAME NOT IN (\n"
  "     ''lock_row_lock_time'', ''lock_row_lock_time_avg'', ''lock_row_lock_time_max'', ''lock_row_lock_waits'',\n"
  "     ''buffer_pool_reads'', ''buffer_pool_read_requests'', ''buffer_pool_write_requests'', ''buffer_pool_wait_free'',\n"
  "     ''buffer_pool_read_ahead'', ''buffer_pool_read_ahead_evicted'', ''buffer_pool_pages_total'', ''buffer_pool_pages_misc'',\n"
  "     ''buffer_pool_pages_data'', ''buffer_pool_bytes_data'', ''buffer_pool_pages_dirty'', ''buffer_pool_bytes_dirty'',\n"
  "     ''buffer_pool_pages_free'', ''buffer_pages_created'', ''buffer_pages_written'', ''buffer_pages_read'',\n"
  "     ''buffer_data_reads'', ''buffer_data_written'', ''file_num_open_files'',\n"
  "     ''os_log_bytes_written'', ''os_log_fsyncs'', ''os_log_pending_fsyncs'', ''os_log_pending_writes'',\n"
  "     ''log_waits'', ''log_write_requests'', ''log_writes'', ''innodb_dblwr_writes'', ''innodb_dblwr_pages_written'', ''innodb_page_size'')\n"
  ") UNION ALL (\n"
  "SELECT ''NOW()'' AS Variable_name, NOW(3) AS Variable_value, ''System Time'' AS Type, ''YES'' AS Enabled\n"
  ") UNION ALL (\n"
  "SELECT ''UNIX_TIMESTAMP()'' AS Variable_name, ROUND(UNIX_TIMESTAMP(NOW(3)), 3) AS Variable_value, ''System Time'' AS Type, ''YES'' AS Enabled\n"
  ")\n"
  " ORDER BY Type, Variable_name;'\n"
  "            );\n"
  "        END IF;\n"
  "        CALL sys.execute_prepared_stmt(@sys.diagnostics.sql);\n"
  "        CALL sys.execute_prepared_stmt(\n"
  "            CONCAT('SELECT Variable_value INTO @sys.diagnostics.output_time FROM ', v_table_name, ' WHERE Type = ''System Time'' AND Variable_name = ''UNIX_TIMESTAMP()''')\n"
  "        );\n"
  "        SET v_output_time = @sys.diagnostics.output_time;\n"
  "        SET v_sql_status_summary_select = CONCAT(v_sql_status_summary_select, ',\n"
  "       CONCAT(\n"
  "           LEFT(s', v_output_count, '.Variable_value, ', v_status_summary_width, '),\n"
  "           IF(', REPLACE(v_no_delta_names, '%{COUNT}', v_output_count), ' AND s', v_output_count, '.Variable_value REGEXP ''^[0-9]+(\\\\\\\\.[0-9]+)?$'', CONCAT('' ('', ROUND(s', v_output_count, '.Variable_value/', v_output_time, ', 2), ''/sec)''), '''')\n"
  "       ) AS ''Output ', v_output_count, ''''),\n"
  "            v_sql_status_summary_from   = CONCAT(v_sql_status_summary_from, '\n"
  "',\n"
  "                                                    IF(v_output_count = 1, '  FROM ', '       INNER JOIN '),\n"
  "                                                    v_table_name, ' s', v_output_count,\n"
  "                                                    IF (v_output_count = 1, '', ' USING (Type, Variable_name)'));\n"
  "        IF (v_output_count > 1) THEN\n"
  "            SET v_sql_status_summary_delta  = CONCAT(v_sql_status_summary_delta, ',\n"
  "       IF(', REPLACE(v_no_delta_names, '%{COUNT}', v_output_count), ' AND s', (v_output_count-1), '.Variable_value REGEXP ''^[0-9]+(\\\\\\\\.[0-9]+)?$'' AND s', v_output_count, '.Variable_value REGEXP ''^[0-9]+(\\\\\\\\.[0-9]+)?$'',\n"
  "          CONCAT(IF(s', (v_output_count-1), '.Variable_value REGEXP ''^[0-9]+\\\\\\\\.[0-9]+$'' OR s', v_output_count, '.Variable_value REGEXP ''^[0-9]+\\\\\\\\.[0-9]+$'',\n"
  "                    ROUND((s', v_output_count, '.Variable_value-s', (v_output_count-1), '.Variable_value), 2),\n"
  "                    (s', v_output_count, '.Variable_value-s', (v_output_count-1), '.Variable_value)\n"
  "                   ),\n"
  "                 '' ('', ROUND((s', v_output_count, '.Variable_value-s', (v_output_count-1), '.Variable_value)/(', v_output_time, '-', v_output_time_prev, '), 2), ''/sec)''\n"
  "          ),\n"
  "          ''''\n"
  "       ) AS ''Delta (', (v_output_count-1), ' -> ', v_output_count, ')''');\n"
  "        END IF;\n"
  "        SET v_output_time_prev = v_output_time;\n"
  "        IF (@sys.diagnostics.include_raw = 'ON') THEN\n"
  "            IF (v_has_metrics) THEN\n"
  "                SELECT 'SELECT * FROM sys.metrics' AS 'The following output is:';\n"
  "            ELSE\n"
  "                SELECT 'sys.metrics equivalent' AS 'The following output is:';\n"
  "            END IF;\n"
  "            CALL sys.execute_prepared_stmt(CONCAT('SELECT Type, Variable_name, Enabled, Variable_value FROM ', v_table_name, ' ORDER BY Type, Variable_name'));\n"
  "        END IF;\n"
  "        IF (v_has_innodb IN ('DEFAULT', 'YES')) THEN\n"
  "            SELECT 'SHOW ENGINE INNODB STATUS' AS 'The following output is:';\n"
  "            EXECUTE stmt_innodb_status;\n"
  "            SELECT 'InnoDB - Transactions' AS 'The following output is:';\n"
  "            SELECT * FROM information_schema.INNODB_TRX;\n"
  "        END IF;\n"
  "        IF (v_has_ndb IN ('DEFAULT', 'YES')) THEN\n"
  "            SELECT 'SHOW ENGINE NDBCLUSTER STATUS' AS 'The following output is:';\n"
  "            EXECUTE stmt_ndbcluster_status;\n"
  "            SELECT 'ndbinfo.memoryusage' AS 'The following output is:';\n"
  "            SELECT node_id, memory_type, format_bytes(used) AS used, used_pages, format_bytes(total) AS total, total_pages,\n"
  "                   ROUND(100*(used/total), 2) AS 'Used %'\n"
  "            FROM ndbinfo.memoryusage;\n"
  "            SET v_done = FALSE;\n"
  "            OPEN c_ndbinfo;\n"
  "            c_ndbinfo_loop: LOOP\n"
  "                FETCH c_ndbinfo INTO v_table_name;\n"
  "                IF v_done THEN\n"
  "                LEAVE c_ndbinfo_loop;\n"
  "                END IF;\n"
  "                SELECT CONCAT('SELECT * FROM ndbinfo.', v_table_name) AS 'The following output is:';\n"
  "                CALL sys.execute_prepared_stmt(CONCAT('SELECT * FROM `ndbinfo`.`', v_table_name, '`'));\n"
  "            END LOOP;\n"
  "            CLOSE c_ndbinfo;\n"
  "            SELECT * FROM information_schema.FILES;\n"
  "        END IF;\n"
  "        SELECT 'SELECT * FROM sys.processlist' AS 'The following output is:';\n"
  "        SELECT processlist.* FROM sys.processlist;\n"
  "        IF (v_has_ps = 'YES') THEN\n"
  "            IF (sys.ps_is_consumer_enabled('events_waits_history_long') = 'YES') THEN\n"
  "                SELECT 'SELECT * FROM sys.latest_file_io' AS 'The following output is:';\n"
  "                SELECT * FROM sys.latest_file_io;\n"
  "            END IF;\n"
  "            IF (EXISTS(SELECT 1 FROM performance_schema.setup_instruments WHERE NAME LIKE 'memory/%' AND ENABLED = 'YES')) THEN\n"
  "                SELECT 'SELECT * FROM sys.memory_by_host_by_current_bytes' AS 'The following output is:';\n"
  "                SELECT * FROM sys.memory_by_host_by_current_bytes;\n"
  "                SELECT 'SELECT * FROM sys.memory_by_thread_by_current_bytes' AS 'The following output is:';\n"
  "                SELECT * FROM sys.memory_by_thread_by_current_bytes;\n"
  "                SELECT 'SELECT * FROM sys.memory_by_user_by_current_bytes' AS 'The following output is:';\n"
  "                SELECT * FROM sys.memory_by_user_by_current_bytes;\n"
  "                SELECT 'SELECT * FROM sys.memory_global_by_current_bytes' AS 'The following output is:';\n"
  "                SELECT * FROM sys.memory_global_by_current_bytes;\n"
  "            END IF;\n"
  "        END IF;\n"
  "        SET v_runtime = (UNIX_TIMESTAMP(NOW(2)) - v_start);\n"
  "    UNTIL (v_runtime + in_interval >= in_max_runtime) END REPEAT;\n"
  "    IF (v_has_ps = 'YES') THEN\n"
  "        SELECT 'SHOW ENGINE PERFORMANCE_SCHEMA STATUS' AS 'The following output is:';\n"
  "        EXECUTE stmt_ps_status;\n"
  "    END IF;\n"
  "    IF (v_has_innodb IN ('DEFAULT', 'YES')) THEN\n"
  "        DEALLOCATE PREPARE stmt_innodb_status;\n"
  "    END IF;\n"
  "    IF (v_has_ps = 'YES') THEN\n"
  "        DEALLOCATE PREPARE stmt_ps_status;\n"
  "    END IF;\n"
  "    IF (v_has_ndb IN ('DEFAULT', 'YES')) THEN\n"
  "        DEALLOCATE PREPARE stmt_ndbcluster_status;\n"
  "    END IF;\n"
  "    SELECT '\n"
  "============================\n"
  "     Schema Information\n"
  "============================\n"
  "' AS '';\n"
  "    SELECT COUNT(*) AS 'Total Number of Tables' FROM information_schema.TABLES;\n"
  "    IF (@sys.diagnostics.allow_i_s_tables = 'ON') THEN\n"
  "        SELECT 'Storage Engine Usage' AS 'The following output is:';\n"
  "        SELECT ENGINE, COUNT(*) AS NUM_TABLES,\n"
  "                format_bytes(SUM(DATA_LENGTH)) AS DATA_LENGTH,\n"
  "                format_bytes(SUM(INDEX_LENGTH)) AS INDEX_LENGTH,\n"
  "                format_bytes(SUM(DATA_LENGTH+INDEX_LENGTH)) AS TOTAL\n"
  "            FROM information_schema.TABLES\n"
  "            GROUP BY ENGINE;\n"
  "        SELECT 'Schema Object Overview' AS 'The following output is:';\n"
  "        SELECT * FROM sys.schema_object_overview;\n"
  "        SELECT 'Tables without a PRIMARY KEY' AS 'The following output is:';\n"
  "        SELECT TABLES.TABLE_SCHEMA, ENGINE, COUNT(*) AS NumTables\n"
  "          FROM information_schema.TABLES\n"
  "               LEFT OUTER JOIN information_schema.STATISTICS ON STATISTICS.TABLE_SCHEMA = TABLES.TABLE_SCHEMA\n"
  "                                                                AND STATISTICS.TABLE_NAME = TABLES.TABLE_NAME\n"
  "                                                                AND STATISTICS.INDEX_NAME = 'PRIMARY'\n"
  "         WHERE STATISTICS.TABLE_NAME IS NULL\n"
  "               AND TABLES.TABLE_SCHEMA NOT IN ('mysql', 'information_schema', 'performance_schema', 'sys')\n"
  "               AND TABLES.TABLE_TYPE = 'BASE TABLE'\n"
  "         GROUP BY TABLES.TABLE_SCHEMA, ENGINE;\n"
  "    END IF;\n"
  "    IF (v_has_ps = 'YES') THEN\n"
  "        SELECT 'Unused Indexes' AS 'The following output is:';\n"
  "        SELECT object_schema, COUNT(*) AS NumUnusedIndexes\n"
  "          FROM performance_schema.table_io_waits_summary_by_index_usage\n"
  "         WHERE index_name IS NOT NULL\n"
  "               AND count_star = 0\n"
  "               AND object_schema NOT IN ('mysql', 'sys')\n"
  "               AND index_name != 'PRIMARY'\n"
  "         GROUP BY object_schema;\n"
  "    END IF;\n"
  "    IF (v_has_ps = 'YES') THEN\n"
  "        SELECT '\n"
  "=========================\n"
  "     Overall Status\n"
  "=========================\n"
  "' AS '';\n"
  "        SELECT 'CALL sys.ps_statement_avg_latency_histogram()' AS 'The following output is:';\n"
  "        CALL sys.ps_statement_avg_latency_histogram();\n"
  "        CALL sys.statement_performance_analyzer('snapshot', NULL, NULL);\n"
  "        CALL sys.statement_performance_analyzer('overall', NULL, 'with_runtimes_in_95th_percentile');\n"
  "        SET @sys.diagnostics.sql = REPLACE(@sys.diagnostics.sql_gen_query_template, '%{OUTPUT}', 'end');\n"
  "        IF (@sys.debug = 'ON') THEN\n"
  "            SELECT 'The following query will be used to generate the query for each sys view' AS 'Debug';\n"
  "            SELECT @sys.diagnostics.sql AS 'Debug';\n"
  "        END IF;\n"
  "        PREPARE stmt_gen_query FROM @sys.diagnostics.sql;\n"
  "        SET v_done = FALSE;\n"
  "        OPEN c_sysviews_w_delta;\n"
  "        c_sysviews_w_delta_loop: LOOP\n"
  "            FETCH c_sysviews_w_delta INTO v_table_name;\n"
  "            IF v_done THEN\n"
  "                LEAVE c_sysviews_w_delta_loop;\n"
  "            END IF;\n"
  "            IF (@sys.debug = 'ON') THEN\n"
  "                SELECT CONCAT('The following queries are for storing the final content of ', v_table_name) AS 'Debug';\n"
  "            END IF;\n"
  "            CALL sys.execute_prepared_stmt(CONCAT('DROP TEMPORARY TABLE IF EXISTS `tmp_', v_table_name, '_end`'));\n"
  "            CALL sys.execute_prepared_stmt(CONCAT('CREATE TEMPORARY TABLE `tmp_', v_table_name, '_end` SELECT * FROM `sys`.`x$', v_table_name, '`'));\n"
  "            IF (@sys.diagnostics.include_raw = 'ON') THEN\n"
  "                SET @sys.diagnostics.table_name = CONCAT('x$', v_table_name);\n"
  "                EXECUTE stmt_gen_query USING @sys.diagnostics.table_name;\n"
  "                SELECT CONCAT(@sys.diagnostics.sql_select,\n"
  "                                IF(order_by IS NOT NULL, CONCAT('\\n ORDER BY ', REPLACE(order_by, '%{TABLE}', CONCAT('tmp_', v_table_name, '_end'))), ''),\n"
  "                                IF(limit_rows IS NOT NULL, CONCAT('\\n LIMIT ', limit_rows), '')\n"
  "                        )\n"
  "                    INTO @sys.diagnostics.sql_select\n"
  "                    FROM tmp_sys_views_delta\n"
  "                    WHERE TABLE_NAME = v_table_name;\n"
  "                SELECT CONCAT('Overall ', v_table_name) AS 'The following output is:';\n"
  "                CALL sys.execute_prepared_stmt(@sys.diagnostics.sql_select);\n"
  "            END IF;\n"
  "        END LOOP;\n"
  "        CLOSE c_sysviews_w_delta;\n"
  "        DEALLOCATE PREPARE stmt_gen_query;\n"
  "        SELECT '\n"
  "======================\n"
  "     Delta Status\n"
  "======================\n"
  "' AS '';\n"
  "        CALL sys.statement_performance_analyzer('delta', 'tmp_digests_start', 'with_runtimes_in_95th_percentile');\n"
  "        CALL sys.statement_performance_analyzer('cleanup', NULL, NULL);\n"
  "        DROP TEMPORARY TABLE tmp_digests_start;\n"
  "        IF (@sys.debug = 'ON') THEN\n"
  "            SELECT 'The following query will be used to generate the query for each sys view delta' AS 'Debug';\n"
  "            SELECT @sys.diagnostics.sql_gen_query_delta AS 'Debug';\n"
  "        END IF;\n"
  "        PREPARE stmt_gen_query_delta FROM @sys.diagnostics.sql_gen_query_delta;\n"
  "        SET v_old_group_concat_max_len = @@session.group_concat_max_len;\n"
  "        SET @@session.group_concat_max_len = 2048;\n"
  "        SET v_done = FALSE;\n"
  "        OPEN c_sysviews_w_delta;\n"
  "        c_sysviews_w_delta_loop: LOOP\n"
  "            FETCH c_sysviews_w_delta INTO v_table_name;\n"
  "            IF v_done THEN\n"
  "                LEAVE c_sysviews_w_delta_loop;\n"
  "            END IF;\n"
  "            SET @sys.diagnostics.table_name = v_table_name;\n"
  "            EXECUTE stmt_gen_query_delta USING @sys.diagnostics.table_name;\n"
  "            SELECT CONCAT(@sys.diagnostics.sql_select,\n"
  "                            IF(where_delta IS NOT NULL, CONCAT('\\n WHERE ', where_delta), ''),\n"
  "                            IF(order_by_delta IS NOT NULL, CONCAT('\\n ORDER BY ', order_by_delta), ''),\n"
  "                            IF(limit_rows IS NOT NULL, CONCAT('\\n LIMIT ', limit_rows), '')\n"
  "                    )\n"
  "                INTO @sys.diagnostics.sql_select\n"
  "                FROM tmp_sys_views_delta\n"
  "                WHERE TABLE_NAME = v_table_name;\n"
  "            SELECT CONCAT('Delta ', v_table_name) AS 'The following output is:';\n"
  "            CALL sys.execute_prepared_stmt(@sys.diagnostics.sql_select);\n"
  "            CALL sys.execute_prepared_stmt(CONCAT('DROP TEMPORARY TABLE `tmp_', v_table_name, '_end`'));\n"
  "            CALL sys.execute_prepared_stmt(CONCAT('DROP TEMPORARY TABLE `tmp_', v_table_name, '_start`'));\n"
  "        END LOOP;\n"
  "        CLOSE c_sysviews_w_delta;\n"
  "        SET @@session.group_concat_max_len = v_old_group_concat_max_len;\n"
  "        DEALLOCATE PREPARE stmt_gen_query_delta;\n"
  "        DROP TEMPORARY TABLE tmp_sys_views_delta;\n"
  "    END IF;\n"
  "    IF (v_has_metrics) THEN\n"
  "        SELECT 'SELECT * FROM sys.metrics' AS 'The following output is:';\n"
  "    ELSE\n"
  "        SELECT 'sys.metrics equivalent' AS 'The following output is:';\n"
  "    END IF;\n"
  "    CALL sys.execute_prepared_stmt(\n"
  "        CONCAT(v_sql_status_summary_select, v_sql_status_summary_delta, ', Type, s1.Enabled', v_sql_status_summary_from,\n"
  "               '\n"
  " ORDER BY Type, Variable_name'\n"
  "        )\n"
  "    );\n"
  "    SET v_count = 0;\n"
  "    WHILE (v_count < v_output_count) DO\n"
  "        SET v_count = v_count + 1;\n"
  "        SET v_table_name = CONCAT('tmp_metrics_', v_count);\n"
  "        CALL sys.execute_prepared_stmt(CONCAT('DROP TEMPORARY TABLE IF EXISTS ', v_table_name));\n"
  "    END WHILE;\n"
  "    IF (in_auto_config <> 'current') THEN\n"
  "        CALL sys.ps_setup_reload_saved();\n"
  "        SET sql_log_bin = @log_bin;\n"
  "    END IF;\n"
  "    SET @sys.diagnostics.output_time            = NULL,\n"
  "        @sys.diagnostics.sql                    = NULL,\n"
  "        @sys.diagnostics.sql_gen_query_delta    = NULL,\n"
  "        @sys.diagnostics.sql_gen_query_template = NULL,\n"
  "        @sys.diagnostics.sql_select             = NULL,\n"
  "        @sys.diagnostics.table_name             = NULL;\n"
  "    IF (v_this_thread_enabled = 'YES') THEN\n"
  "        CALL sys.ps_setup_enable_thread(CONNECTION_ID());\n"
  "    END IF;\n"
  "    IF (@log_bin = 1) THEN\n"
  "        SET sql_log_bin = @log_bin;\n"
  "    END IF;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS optimizer_switch_choice;\n",
"DROP PROCEDURE IF EXISTS optimizer_switch_on;\n",
"DROP PROCEDURE IF EXISTS optimizer_switch_off;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE optimizer_switch_choice(IN on_off VARCHAR(3))\n"
  "COMMENT 'return @@optimizer_switch options as a result set for easier readability'\n"
  "SQL SECURITY INVOKER\n"
  "NOT DETERMINISTIC\n"
  "CONTAINS SQL\n"
  "BEGIN\n"
  "  DECLARE tmp VARCHAR(1024);\n"
  "  DECLARE opt VARCHAR(1024);\n"
  "  DECLARE start INT;\n"
  "  DECLARE end INT;\n"
  "  DECLARE pos INT;\n"
  "  set tmp=concat(@@optimizer_switch,\",\");\n"
  "  CREATE OR REPLACE TEMPORARY TABLE tmp_opt_switch (a varchar(64), opt CHAR(3)) character set latin1 engine=heap;\n"
  "  set start=1;\n"
  "  FIND_OPTIONS:\n"
  "  LOOP\n"
  "    set pos= INSTR(SUBSTR(tmp, start), \",\");\n"
  "    if (pos = 0) THEN\n"
  "       LEAVE FIND_OPTIONS;\n"
  "    END IF;\n"
  "    set opt= MID(tmp, start, pos-1);\n"
  "    set end= INSTR(opt, \"=\");\n"
  "    insert into tmp_opt_switch values(LEFT(opt,end-1),SUBSTR(opt,end+1));\n"
  "    set start=start + pos;\n"
  "  END LOOP;\n"
  "  SELECT  t.a as \"option\",t.opt from tmp_opt_switch as t where t.opt = on_off order by a;\n"
  "  DROP TEMPORARY TABLE tmp_opt_switch;\n"
  "END$$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE optimizer_switch_on()\n"
  "COMMENT 'return @@optimizer_switch options that are on'\n"
  "SQL SECURITY INVOKER\n"
  "NOT DETERMINISTIC\n"
  "CONTAINS SQL\n"
  "BEGIN\n"
  "  call optimizer_switch_choice(\"on\");\n"
  "END$$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE optimizer_switch_off()\n"
  "COMMENT 'return @@optimizer_switch options that are off'\n"
  "SQL SECURITY INVOKER\n"
  "NOT DETERMINISTIC\n"
  "CONTAINS SQL\n"
  "BEGIN\n"
  "  call optimizer_switch_choice(\"off\");\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_statement_avg_latency_histogram;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_statement_avg_latency_histogram ()\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Outputs a textual histogram graph of the average latency values\n"
  "             across all normalized queries tracked within the Performance Schema\n"
  "             events_statements_summary_by_digest table.\n"
  "             Can be used to show a very high level picture of what kind of\n"
  "             latency distribution statements running within this instance have.\n"
  "             Parameters\n"
  "             None.\n"
  "             Example\n"
  "             mysql> CALL sys.ps_statement_avg_latency_histogram()\\\\G\n"
  "             *************************** 1. row ***************************\n"
  "             Performance Schema Statement Digest Average Latency Histogram:\n"
  "               . = 1 unit\n"
  "               * = 2 units\n"
  "               # = 3 units\n"
  "             (0 - 38ms)     240 | ################################################################################\n"
  "             (38 - 77ms)    38  | ......................................\n"
  "             (77 - 115ms)   3   | ...\n"
  "             (115 - 154ms)  62  | *******************************\n"
  "             (154 - 192ms)  3   | ...\n"
  "             (192 - 231ms)  0   |\n"
  "             (231 - 269ms)  0   |\n"
  "             (269 - 307ms)  0   |\n"
  "             (307 - 346ms)  0   |\n"
  "             (346 - 384ms)  1   | .\n"
  "             (384 - 423ms)  1   | .\n"
  "             (423 - 461ms)  0   |\n"
  "             (461 - 499ms)  0   |\n"
  "             (499 - 538ms)  0   |\n"
  "             (538 - 576ms)  0   |\n"
  "             (576 - 615ms)  1   | .\n"
  "               Total Statements: 350; Buckets: 16; Bucket Size: 38 ms;\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "SELECT CONCAT('\\n',\n"
  "       '\\n  . = 1 unit',\n"
  "       '\\n  * = 2 units',\n"
  "       '\\n  # = 3 units\\n',\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(0 - ',\n"
  "                                               ROUND((@bucket_size := (SELECT ROUND((MAX(avg_us) - MIN(avg_us)) / (@buckets := 16)) AS size\n"
  "                                                                         FROM sys.x$ps_digest_avg_latency_distribution)) / (@unit_div := 1000)),\n"
  "                                                (@unit := 'ms'), ')'),\n"
  "                        REPEAT(' ', (@max_label_size := ((1 + LENGTH(ROUND((@bucket_size * 15) / @unit_div)) + 3 + LENGTH(ROUND(@bucket_size * 16) / @unit_div)) + 1)) - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1\n"
  "                                                     WHERE b1.avg_us <= @bucket_size), 0)),\n"
  "       REPEAT(' ', (@max_label_len := (@max_label_size + LENGTH((@total_queries := (SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution)))) + 1) - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < (@one_unit := 40), '.', IF(@count_in_bucket < (@two_unit := 80), '*', '#')),\n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND(@bucket_size / @unit_div), ' - ', ROUND((@bucket_size * 2) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1\n"
  "                                                     WHERE b1.avg_us > @bucket_size AND b1.avg_us <= @bucket_size * 2), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')),\n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 2) / @unit_div), ' - ', ROUND((@bucket_size * 3) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1\n"
  "                                                     WHERE b1.avg_us > @bucket_size * 2 AND b1.avg_us <= @bucket_size * 3), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')),\n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 3) / @unit_div), ' - ', ROUND((@bucket_size * 4) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1\n"
  "                                                     WHERE b1.avg_us > @bucket_size * 3 AND b1.avg_us <= @bucket_size * 4), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')),\n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 4) / @unit_div), ' - ', ROUND((@bucket_size * 5) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1\n"
  "                                                     WHERE b1.avg_us > @bucket_size * 4 AND b1.avg_us <= @bucket_size * 5), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')),\n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 5) / @unit_div), ' - ', ROUND((@bucket_size * 6) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1\n"
  "                                                     WHERE b1.avg_us > @bucket_size * 5 AND b1.avg_us <= @bucket_size * 6), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')),\n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 6) / @unit_div), ' - ', ROUND((@bucket_size * 7) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1\n"
  "                                                     WHERE b1.avg_us > @bucket_size * 6 AND b1.avg_us <= @bucket_size * 7), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')),\n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 7) / @unit_div), ' - ', ROUND((@bucket_size * 8) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1\n"
  "                                                     WHERE b1.avg_us > @bucket_size * 7 AND b1.avg_us <= @bucket_size * 8), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')),\n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 8) / @unit_div), ' - ', ROUND((@bucket_size * 9) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1\n"
  "                                                     WHERE b1.avg_us > @bucket_size * 8 AND b1.avg_us <= @bucket_size * 9), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')),\n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 9) / @unit_div), ' - ', ROUND((@bucket_size * 10) / @unit_div), @unit, ')'),\n"
  "                         REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                         @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                       FROM sys.x$ps_digest_avg_latency_distribution AS b1\n"
  "                                                      WHERE b1.avg_us > @bucket_size * 9 AND b1.avg_us <= @bucket_size * 10), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')),\n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 10) / @unit_div), ' - ', ROUND((@bucket_size * 11) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1\n"
  "                                                     WHERE b1.avg_us > @bucket_size * 10 AND b1.avg_us <= @bucket_size * 11), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')),\n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 11) / @unit_div), ' - ', ROUND((@bucket_size * 12) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1\n"
  "                                                     WHERE b1.avg_us > @bucket_size * 11 AND b1.avg_us <= @bucket_size * 12), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')),\n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 12) / @unit_div), ' - ', ROUND((@bucket_size * 13) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1\n"
  "                                                     WHERE b1.avg_us > @bucket_size * 12 AND b1.avg_us <= @bucket_size * 13), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')),\n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 13) / @unit_div), ' - ', ROUND((@bucket_size * 14) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1\n"
  "                                                     WHERE b1.avg_us > @bucket_size * 13 AND b1.avg_us <= @bucket_size * 14), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')),\n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 14) / @unit_div), ' - ', ROUND((@bucket_size * 15) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1\n"
  "                                                     WHERE b1.avg_us > @bucket_size * 14 AND b1.avg_us <= @bucket_size * 15), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')),\n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 15) / @unit_div), ' - ', ROUND((@bucket_size * 16) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1\n"
  "                                                     WHERE b1.avg_us > @bucket_size * 15 AND b1.avg_us <= @bucket_size * 16), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')),\n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       '\\n\\n  Total Statements: ', @total_queries, '; Buckets: ', @buckets , '; Bucket Size: ', ROUND(@bucket_size / @unit_div) , ' ', @unit, ';\\n'\n"
  "      ) AS `Performance Schema Statement Digest Average Latency Histogram`;\n"
  "END $$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_trace_statement_digest;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_trace_statement_digest (\n"
  "        IN in_digest VARCHAR(32),\n"
  "        IN in_runtime INT,\n"
  "        IN in_interval DECIMAL(2,2),\n"
  "        IN in_start_fresh BOOLEAN,\n"
  "        IN in_auto_enable BOOLEAN\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Traces all instrumentation within Performance Schema for a specific\n"
  "             Statement Digest.\n"
  "             When finding a statement of interest within the\n"
  "             performance_schema.events_statements_summary_by_digest table, feed\n"
  "             the DIGEST MD5 value in to this procedure, set how long to poll for,\n"
  "             and at what interval to poll, and it will generate a report of all\n"
  "             statistics tracked within Performance Schema for that digest for the\n"
  "             interval.\n"
  "             It will also attempt to generate an EXPLAIN for the longest running\n"
  "             example of the digest during the interval. Note this may fail, as:\n"
  "                * Performance Schema truncates long SQL_TEXT values (and hence the\n"
  "                  EXPLAIN will fail due to parse errors)\n"
  "                * the default schema is sys (so tables that are not fully qualified\n"
  "                  in the query may not be found)\n"
  "                * some queries such as SHOW are not supported in EXPLAIN.\n"
  "             When the EXPLAIN fails, the error will be ignored and no EXPLAIN\n"
  "             output generated.\n"
  "             Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n"
  "             Parameters\n"
  "             in_digest (VARCHAR(32)):\n"
  "               The statement digest identifier you would like to analyze\n"
  "             in_runtime (INT):\n"
  "               The number of seconds to run analysis for\n"
  "             in_interval (DECIMAL(2,2)):\n"
  "               The interval (in seconds, may be fractional) at which to try\n"
  "               and take snapshots\n"
  "             in_start_fresh (BOOLEAN):\n"
  "               Whether to TRUNCATE the events_statements_history_long and\n"
  "               events_stages_history_long tables before starting\n"
  "             in_auto_enable (BOOLEAN):\n"
  "               Whether to automatically turn on required consumers\n"
  "             Example\n"
  "             mysql> call ps_trace_statement_digest(\\'891ec6860f98ba46d89dd20b0c03652c\\', 10, 0.1, true, true);\n"
  "             +--------------------+\n"
  "             | SUMMARY STATISTICS |\n"
  "             +--------------------+\n"
  "             | SUMMARY STATISTICS |\n"
  "             +--------------------+\n"
  "             1 row in set (9.11 sec)\n"
  "             +------------+-----------+-----------+-----------+---------------+------------+------------+\n"
  "             | executions | exec_time | lock_time | rows_sent | rows_examined | tmp_tables | full_scans |\n"
  "             +------------+-----------+-----------+-----------+---------------+------------+------------+\n"
  "             |         21 | 4.11 ms   | 2.00 ms   |         0 |            21 |          0 |          0 |\n"
  "             +------------+-----------+-----------+-----------+---------------+------------+------------+\n"
  "             1 row in set (9.11 sec)\n"
  "             +------------------------------------------+-------+-----------+\n"
  "             | event_name                               | count | latency   |\n"
  "             +------------------------------------------+-------+-----------+\n"
  "             | stage/sql/checking query cache for query |    16 | 724.37 us |\n"
  "             | stage/sql/statistics                     |    16 | 546.92 us |\n"
  "             | stage/sql/freeing items                  |    18 | 520.11 us |\n"
  "             | stage/sql/init                           |    51 | 466.80 us |\n"
  "             ...\n"
  "             | stage/sql/cleaning up                    |    18 | 11.92 us  |\n"
  "             | stage/sql/executing                      |    16 | 6.95 us   |\n"
  "             +------------------------------------------+-------+-----------+\n"
  "             17 rows in set (9.12 sec)\n"
  "             +---------------------------+\n"
  "             | LONGEST RUNNING STATEMENT |\n"
  "             +---------------------------+\n"
  "             | LONGEST RUNNING STATEMENT |\n"
  "             +---------------------------+\n"
  "             1 row in set (9.16 sec)\n"
  "             +-----------+-----------+-----------+-----------+---------------+------------+-----------+\n"
  "             | thread_id | exec_time | lock_time | rows_sent | rows_examined | tmp_tables | full_scan |\n"
  "             +-----------+-----------+-----------+-----------+---------------+------------+-----------+\n"
  "             |    166646 | 618.43 us | 1.00 ms   |         0 |             1 |          0 |         0 |\n"
  "             +-----------+-----------+-----------+-----------+---------------+------------+-----------+\n"
  "             1 row in set (9.16 sec)\n"
  "             // Truncated for clarity...\n"
  "             +-----------------------------------------------------------------+\n"
  "             | sql_text                                                        |\n"
  "             +-----------------------------------------------------------------+\n"
  "             | select hibeventhe0_.id as id1382_, hibeventhe0_.createdTime ... |\n"
  "             +-----------------------------------------------------------------+\n"
  "             1 row in set (9.17 sec)\n"
  "             +------------------------------------------+-----------+\n"
  "             | event_name                               | latency   |\n"
  "             +------------------------------------------+-----------+\n"
  "             | stage/sql/init                           | 8.61 us   |\n"
  "             | stage/sql/Waiting for query cache lock   | 453.23 us |\n"
  "             | stage/sql/init                           | 331.07 ns |\n"
  "             | stage/sql/checking query cache for query | 43.04 us  |\n"
  "             ...\n"
  "             | stage/sql/freeing items                  | 30.46 us  |\n"
  "             | stage/sql/cleaning up                    | 662.13 ns |\n"
  "             +------------------------------------------+-----------+\n"
  "             18 rows in set (9.23 sec)\n"
  "             +----+-------------+--------------+-------+---------------+-----------+---------+-------------+------+-------+\n"
  "             | id | select_type | table        | type  | possible_keys | key       | key_len | ref         | rows | Extra |\n"
  "             +----+-------------+--------------+-------+---------------+-----------+---------+-------------+------+-------+\n"
  "             |  1 | SIMPLE      | hibeventhe0_ | const | fixedTime     | fixedTime | 775     | const,const |    1 | NULL  |\n"
  "             +----+-------------+--------------+-------+---------------+-----------+---------+-------------+------+-------+\n"
  "             1 row in set (9.27 sec)\n"
  "             Query OK, 0 rows affected (9.28 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_start_fresh BOOLEAN DEFAULT false;\n"
  "    DECLARE v_auto_enable BOOLEAN DEFAULT false;\n"
  "    DECLARE v_explain     BOOLEAN DEFAULT true;\n"
  "    DECLARE v_this_thread_enabed ENUM('YES', 'NO');\n"
  "    DECLARE v_runtime INT DEFAULT 0;\n"
  "    DECLARE v_start INT DEFAULT 0;\n"
  "    DECLARE v_found_stmts INT;\n"
  "    SET @log_bin := @@sql_log_bin;\n"
  "    SET sql_log_bin = 0;\n"
  "    SELECT INSTRUMENTED INTO v_this_thread_enabed FROM performance_schema.threads WHERE PROCESSLIST_ID = CONNECTION_ID();\n"
  "    CALL sys.ps_setup_disable_thread(CONNECTION_ID());\n"
  "    DROP TEMPORARY TABLE IF EXISTS stmt_trace;\n"
  "    CREATE TEMPORARY TABLE stmt_trace (\n"
  "        thread_id BIGINT UNSIGNED,\n"
  "        timer_start BIGINT UNSIGNED,\n"
  "        event_id BIGINT UNSIGNED,\n"
  "        sql_text longtext,\n"
  "        timer_wait BIGINT UNSIGNED,\n"
  "        lock_time BIGINT UNSIGNED,\n"
  "        errors BIGINT UNSIGNED,\n"
  "        mysql_errno INT,\n"
  "        rows_sent BIGINT UNSIGNED,\n"
  "        rows_affected BIGINT UNSIGNED,\n"
  "        rows_examined BIGINT UNSIGNED,\n"
  "        created_tmp_tables BIGINT UNSIGNED,\n"
  "        created_tmp_disk_tables BIGINT UNSIGNED,\n"
  "        no_index_used BIGINT UNSIGNED,\n"
  "        PRIMARY KEY (thread_id, timer_start)\n"
  "    );\n"
  "    DROP TEMPORARY TABLE IF EXISTS stmt_stages;\n"
  "    CREATE TEMPORARY TABLE stmt_stages (\n"
  "       event_id BIGINT UNSIGNED,\n"
  "       stmt_id BIGINT UNSIGNED,\n"
  "       event_name VARCHAR(128),\n"
  "       timer_wait BIGINT UNSIGNED,\n"
  "       PRIMARY KEY (event_id)\n"
  "    );\n"
  "    SET v_start_fresh = in_start_fresh;\n"
  "    IF v_start_fresh THEN\n"
  "        TRUNCATE TABLE performance_schema.events_statements_history_long;\n"
  "        TRUNCATE TABLE performance_schema.events_stages_history_long;\n"
  "    END IF;\n"
  "    SET v_auto_enable = in_auto_enable;\n"
  "    IF v_auto_enable THEN\n"
  "        CALL sys.ps_setup_save(0);\n"
  "        UPDATE performance_schema.threads\n"
  "           SET INSTRUMENTED = IF(PROCESSLIST_ID IS NOT NULL, 'YES', 'NO');\n"
  "        UPDATE performance_schema.setup_consumers\n"
  "           SET ENABLED = 'YES'\n"
  "         WHERE NAME NOT LIKE '%\\_history'\n"
  "               AND NAME NOT LIKE 'events_wait%'\n"
  "               AND NAME NOT LIKE 'events_transactions%'\n"
  "               AND NAME <> 'statements_digest';\n"
  "        UPDATE performance_schema.setup_instruments\n"
  "           SET ENABLED = 'YES',\n"
  "               TIMED   = 'YES'\n"
  "         WHERE NAME LIKE 'statement/%' OR NAME LIKE 'stage/%';\n"
  "    END IF;\n"
  "    WHILE v_runtime < in_runtime DO\n"
  "        SELECT UNIX_TIMESTAMP() INTO v_start;\n"
  "        INSERT IGNORE INTO stmt_trace\n"
  "        SELECT thread_id, timer_start, event_id, sql_text, timer_wait, lock_time, errors, mysql_errno,\n"
  "               rows_sent, rows_affected, rows_examined, created_tmp_tables, created_tmp_disk_tables, no_index_used\n"
  "          FROM performance_schema.events_statements_history_long\n"
  "        WHERE digest = in_digest;\n"
  "        INSERT IGNORE INTO stmt_stages\n"
  "        SELECT stages.event_id, stmt_trace.event_id,\n"
  "               stages.event_name, stages.timer_wait\n"
  "          FROM performance_schema.events_stages_history_long AS stages\n"
  "          JOIN stmt_trace ON stages.nesting_event_id = stmt_trace.event_id;\n"
  "        SELECT SLEEP(in_interval) INTO @sleep;\n"
  "        SET v_runtime = v_runtime + (UNIX_TIMESTAMP() - v_start);\n"
  "    END WHILE;\n"
  "    SELECT \"SUMMARY STATISTICS\";\n"
  "    SELECT COUNT(*) executions,\n"
  "           format_pico_time(SUM(timer_wait)) AS exec_time,\n"
  "           format_pico_time(SUM(lock_time)) AS lock_time,\n"
  "           SUM(rows_sent) AS rows_sent,\n"
  "           SUM(rows_affected) AS rows_affected,\n"
  "           SUM(rows_examined) AS rows_examined,\n"
  "           SUM(created_tmp_tables) AS tmp_tables,\n"
  "           SUM(no_index_used) AS full_scans\n"
  "      FROM stmt_trace;\n"
  "    SELECT event_name,\n"
  "           COUNT(*) as count,\n"
  "           format_pico_time(SUM(timer_wait)) as latency\n"
  "      FROM stmt_stages\n"
  "     GROUP BY event_name\n"
  "     ORDER BY SUM(timer_wait) DESC;\n"
  "    SELECT \"LONGEST RUNNING STATEMENT\";\n"
  "    SELECT thread_id,\n"
  "           format_pico_time(timer_wait) AS exec_time,\n"
  "           format_pico_time(lock_time) AS lock_time,\n"
  "           rows_sent,\n"
  "           rows_affected,\n"
  "           rows_examined,\n"
  "           created_tmp_tables AS tmp_tables,\n"
  "           no_index_used AS full_scan\n"
  "      FROM stmt_trace\n"
  "     ORDER BY timer_wait DESC LIMIT 1;\n"
  "    SELECT sql_text\n"
  "      FROM stmt_trace\n"
  "     ORDER BY timer_wait DESC LIMIT 1;\n"
  "    SELECT sql_text, event_id INTO @sql, @sql_id\n"
  "      FROM stmt_trace\n"
  "    ORDER BY timer_wait DESC LIMIT 1;\n"
  "    IF (@sql_id IS NOT NULL) THEN\n"
  "        SELECT event_name,\n"
  "               format_pico_time(timer_wait) as latency\n"
  "          FROM stmt_stages\n"
  "         WHERE stmt_id = @sql_id\n"
  "         ORDER BY event_id;\n"
  "    END IF;\n"
  "    DROP TEMPORARY TABLE stmt_trace;\n"
  "    DROP TEMPORARY TABLE stmt_stages;\n"
  "    IF (@sql IS NOT NULL) THEN\n"
  "        SET @stmt := CONCAT(\"EXPLAIN FORMAT=JSON \", @sql);\n"
  "        BEGIN\n"
  "            DECLARE CONTINUE HANDLER FOR 1064, 1146 SET v_explain = false;\n"
  "            PREPARE explain_stmt FROM @stmt;\n"
  "        END;\n"
  "        IF (v_explain) THEN\n"
  "            EXECUTE explain_stmt;\n"
  "            DEALLOCATE PREPARE explain_stmt;\n"
  "        END IF;\n"
  "    END IF;\n"
  "    IF v_auto_enable THEN\n"
  "        CALL sys.ps_setup_reload_saved();\n"
  "    END IF;\n"
  "    IF (v_this_thread_enabed = 'YES') THEN\n"
  "        CALL sys.ps_setup_enable_thread(CONNECTION_ID());\n"
  "    END IF;\n"
  "    SET sql_log_bin = @log_bin;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_trace_thread;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_trace_thread (\n"
  "        IN in_thread_id BIGINT UNSIGNED,\n"
  "        IN in_outfile VARCHAR(255),\n"
  "        IN in_max_runtime DECIMAL(20,2),\n"
  "        IN in_interval DECIMAL(20,2),\n"
  "        IN in_start_fresh BOOLEAN,\n"
  "        IN in_auto_setup BOOLEAN,\n"
  "        IN in_debug BOOLEAN\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Dumps all data within Performance Schema for an instrumented thread,\n"
  "             to create a DOT formatted graph file.\n"
  "             Each resultset returned from the procedure should be used for a complete graph\n"
  "             Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n"
  "             Parameters\n"
  "             in_thread_id (BIGINT UNSIGNED):\n"
  "               The thread that you would like a stack trace for\n"
  "             in_outfile  (VARCHAR(255)):\n"
  "               The filename the dot file will be written to\n"
  "             in_max_runtime (DECIMAL(20,2)):\n"
  "               The maximum time to keep collecting data.\n"
  "               Use NULL to get the default which is 60 seconds.\n"
  "             in_interval (DECIMAL(20,2)):\n"
  "               How long to sleep between data collections.\n"
  "               Use NULL to get the default which is 1 second.\n"
  "             in_start_fresh (BOOLEAN):\n"
  "               Whether to reset all Performance Schema data before tracing.\n"
  "             in_auto_setup (BOOLEAN):\n"
  "               Whether to disable all other threads and enable all consumers/instruments.\n"
  "               This will also reset the settings at the end of the run.\n"
  "             in_debug (BOOLEAN):\n"
  "               Whether you would like to include file:lineno in the graph\n"
  "             Example\n"
  "             mysql> CALL sys.ps_trace_thread(25, CONCAT(\\'/tmp/stack-\\', REPLACE(NOW(), \\' \\', \\'-\\'), \\'.dot\\'), NULL, NULL, TRUE, TRUE, TRUE);\n"
  "             +-------------------+\n"
  "             | summary           |\n"
  "             +-------------------+\n"
  "             | Disabled 1 thread |\n"
  "             +-------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "             +---------------------------------------------+\n"
  "             | Info                                        |\n"
  "             +---------------------------------------------+\n"
  "             | Data collection starting for THREAD_ID = 25 |\n"
  "             +---------------------------------------------+\n"
  "             1 row in set (0.03 sec)\n"
  "             +-----------------------------------------------------------+\n"
  "             | Info                                                      |\n"
  "             +-----------------------------------------------------------+\n"
  "             | Stack trace written to /tmp/stack-2014-02-16-21:18:41.dot |\n"
  "             +-----------------------------------------------------------+\n"
  "             1 row in set (60.07 sec)\n"
  "             +-------------------------------------------------------------------+\n"
  "             | Convert to PDF                                                    |\n"
  "             +-------------------------------------------------------------------+\n"
  "             | dot -Tpdf -o /tmp/stack_25.pdf /tmp/stack-2014-02-16-21:18:41.dot |\n"
  "             +-------------------------------------------------------------------+\n"
  "             1 row in set (60.07 sec)\n"
  "             +-------------------------------------------------------------------+\n"
  "             | Convert to PNG                                                    |\n"
  "             +-------------------------------------------------------------------+\n"
  "             | dot -Tpng -o /tmp/stack_25.png /tmp/stack-2014-02-16-21:18:41.dot |\n"
  "             +-------------------------------------------------------------------+\n"
  "             1 row in set (60.07 sec)\n"
  "             +------------------+\n"
  "             | summary          |\n"
  "             +------------------+\n"
  "             | Enabled 1 thread |\n"
  "             +------------------+\n"
  "             1 row in set (60.32 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_done bool DEFAULT FALSE;\n"
  "    DECLARE v_start, v_runtime DECIMAL(20,2) DEFAULT 0.0;\n"
  "    DECLARE v_min_event_id bigint unsigned DEFAULT 0;\n"
  "    DECLARE v_this_thread_enabed ENUM('YES', 'NO');\n"
  "    DECLARE v_event longtext;\n"
  "    DECLARE c_stack CURSOR FOR\n"
  "        SELECT CONCAT(IF(nesting_event_id IS NOT NULL, CONCAT(nesting_event_id, ' -> '), ''),\n"
  "                    event_id, '; ', event_id, ' [label=\"',\n"
  "                    '(', format_pico_time(timer_wait), ') ',\n"
  "                    IF (event_name NOT LIKE 'wait/io%',\n"
  "                        SUBSTRING_INDEX(event_name, '/', -2),\n"
  "                        IF (event_name NOT LIKE 'wait/io/file%' OR event_name NOT LIKE 'wait/io/socket%',\n"
  "                            SUBSTRING_INDEX(event_name, '/', -4),\n"
  "                            event_name)\n"
  "                        ),\n"
  "                    IF (event_name LIKE 'statement/%', IFNULL(CONCAT('\\\\n', wait_info), ''), ''),\n"
  "                    IF (in_debug AND event_name LIKE 'wait%', wait_info, ''),\n"
  "                    '\", ',\n"
  "                    CASE WHEN event_name LIKE 'wait/io/file%' THEN\n"
  "                           'shape=box, style=filled, color=red'\n"
  "                         WHEN event_name LIKE 'wait/io/table%' THEN\n"
  "                           'shape=box, style=filled, color=green'\n"
  "                         WHEN event_name LIKE 'wait/io/socket%' THEN\n"
  "                           'shape=box, style=filled, color=yellow'\n"
  "                         WHEN event_name LIKE 'wait/synch/mutex%' THEN\n"
  "                           'style=filled, color=lightskyblue'\n"
  "                         WHEN event_name LIKE 'wait/synch/cond%' THEN\n"
  "                           'style=filled, color=darkseagreen3'\n"
  "                         WHEN event_name LIKE 'wait/synch/rwlock%' THEN\n"
  "                           'style=filled, color=orchid'\n"
  "                         WHEN event_name LIKE 'wait/lock%' THEN\n"
  "                           'shape=box, style=filled, color=tan'\n"
  "                         WHEN event_name LIKE 'statement/%' THEN\n"
  "                           CONCAT('shape=box, style=bold',\n"
  "                                  CASE WHEN event_name LIKE 'statement/com/%' THEN\n"
  "                                         ' style=filled, color=darkseagreen'\n"
  "                                       ELSE\n"
  "                                         IF((timer_wait/1000000000000) > @@log_slow_query_time,\n"
  "                                            ' style=filled, color=red',\n"
  "                                            ' style=filled, color=lightblue')\n"
  "                                  END\n"
  "                           )\n"
  "                         WHEN event_name LIKE 'stage/%' THEN\n"
  "                           'style=filled, color=slategray3'\n"
  "                         WHEN event_name LIKE '%idle%' THEN\n"
  "                           'shape=box, style=filled, color=firebrick3'\n"
  "                         ELSE '' END,\n"
  "                     '];\\n'\n"
  "                   ) event, event_id\n"
  "        FROM (\n"
  "             (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id,\n"
  "                     CONCAT(sql_text, '\\\\n',\n"
  "                            'errors: ', errors, '\\\\n',\n"
  "                            'warnings: ', warnings, '\\\\n',\n"
  "                            'lock time: ', format_pico_time(lock_time),'\\\\n',\n"
  "                            'rows affected: ', rows_affected, '\\\\n',\n"
  "                            'rows sent: ', rows_sent, '\\\\n',\n"
  "                            'rows examined: ', rows_examined, '\\\\n',\n"
  "                            'tmp tables: ', created_tmp_tables, '\\\\n',\n"
  "                            'tmp disk tables: ', created_tmp_disk_tables, '\\\\n'\n"
  "                            'select scan: ', select_scan, '\\\\n',\n"
  "                            'select full join: ', select_full_join, '\\\\n',\n"
  "                            'select full range join: ', select_full_range_join, '\\\\n',\n"
  "                            'select range: ', select_range, '\\\\n',\n"
  "                            'select range check: ', select_range_check, '\\\\n',\n"
  "                            'sort merge passes: ', sort_merge_passes, '\\\\n',\n"
  "                            'sort rows: ', sort_rows, '\\\\n',\n"
  "                            'sort range: ', sort_range, '\\\\n',\n"
  "                            'sort scan: ', sort_scan, '\\\\n',\n"
  "                            'no index used: ', IF(no_index_used, 'TRUE', 'FALSE'), '\\\\n',\n"
  "                            'no good index used: ', IF(no_good_index_used, 'TRUE', 'FALSE'), '\\\\n'\n"
  "                     ) AS wait_info\n"
  "                FROM performance_schema.events_statements_history_long\n"
  "               WHERE thread_id = in_thread_id AND event_id > v_min_event_id)\n"
  "             UNION\n"
  "             (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id, null AS wait_info\n"
  "                FROM performance_schema.events_stages_history_long\n"
  "               WHERE thread_id = in_thread_id AND event_id > v_min_event_id)\n"
  "             UNION\n"
  "             (SELECT thread_id, event_id,\n"
  "                     CONCAT(event_name,\n"
  "                            IF(event_name NOT LIKE 'wait/synch/mutex%', IFNULL(CONCAT(' - ', operation), ''), ''),\n"
  "                            IF(number_of_bytes IS NOT NULL, CONCAT(' ', number_of_bytes, ' bytes'), ''),\n"
  "                            IF(event_name LIKE 'wait/io/file%', '\\\\n', ''),\n"
  "                            IF(object_schema IS NOT NULL, CONCAT('\\\\nObject: ', object_schema, '.'), ''),\n"
  "                            IF(object_name IS NOT NULL,\n"
  "                               IF (event_name LIKE 'wait/io/socket%',\n"
  "                                   CONCAT('\\\\n', IF (object_name LIKE ':0%', @@socket, object_name)),\n"
  "                                   object_name),\n"
  "                               ''\n"
  "                            ),\n"
  "                            IF(index_name IS NOT NULL, CONCAT(' Index: ', index_name), ''), '\\\\n'\n"
  "                     ) AS event_name,\n"
  "                     timer_wait, timer_start, nesting_event_id, source AS wait_info\n"
  "                FROM performance_schema.events_waits_history_long\n"
  "               WHERE thread_id = in_thread_id AND event_id > v_min_event_id)\n"
  "           ) events\n"
  "       ORDER BY event_id;\n"
  "    DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;\n"
  "    SET @log_bin := @@sql_log_bin;\n"
  "    SET sql_log_bin = 0;\n"
  "    SELECT INSTRUMENTED INTO v_this_thread_enabed FROM performance_schema.threads WHERE PROCESSLIST_ID = CONNECTION_ID();\n"
  "    CALL sys.ps_setup_disable_thread(CONNECTION_ID());\n"
  "    IF (in_auto_setup) THEN\n"
  "        CALL sys.ps_setup_save(0);\n"
  "        DELETE FROM performance_schema.setup_actors;\n"
  "        UPDATE performance_schema.threads\n"
  "           SET INSTRUMENTED = IF(THREAD_ID = in_thread_id, 'YES', 'NO');\n"
  "        UPDATE performance_schema.setup_consumers\n"
  "           SET ENABLED = 'YES'\n"
  "         WHERE NAME NOT LIKE '%\\_history';\n"
  "        UPDATE performance_schema.setup_instruments\n"
  "           SET ENABLED = 'YES',\n"
  "               TIMED   = 'YES';\n"
  "    END IF;\n"
  "    IF (in_start_fresh) THEN\n"
  "        TRUNCATE performance_schema.events_statements_history_long;\n"
  "        TRUNCATE performance_schema.events_stages_history_long;\n"
  "        TRUNCATE performance_schema.events_waits_history_long;\n"
  "    END IF;\n"
  "    DROP TEMPORARY TABLE IF EXISTS tmp_events;\n"
  "    CREATE TEMPORARY TABLE tmp_events (\n"
  "      event_id bigint unsigned NOT NULL,\n"
  "      event longblob,\n"
  "      PRIMARY KEY (event_id)\n"
  "    );\n"
  "    INSERT INTO tmp_events VALUES (0, CONCAT('digraph events { rankdir=LR; nodesep=0.10;\\n',\n"
  "                                             '// Stack created .....: ', NOW(), '\\n',\n"
  "                                             '// MySQL version .....: ', VERSION(), '\\n',\n"
  "                                             '// MySQL hostname ....: ', @@hostname, '\\n',\n"
  "                                             '// MySQL port ........: ', @@port, '\\n',\n"
  "                                             '// MySQL socket ......: ', @@socket, '\\n',\n"
  "                                             '// MySQL user ........: ', CURRENT_USER(), '\\n'));\n"
  "    SELECT CONCAT('Data collection starting for THREAD_ID = ', in_thread_id) AS 'Info';\n"
  "    SET v_min_event_id = 0,\n"
  "        v_start        = UNIX_TIMESTAMP(),\n"
  "        in_interval    = IFNULL(in_interval, 1.00),\n"
  "        in_max_runtime = IFNULL(in_max_runtime, 60.00);\n"
  "    WHILE (v_runtime < in_max_runtime\n"
  "           AND (SELECT INSTRUMENTED FROM performance_schema.threads WHERE THREAD_ID = in_thread_id) = 'YES') DO\n"
  "        SET v_done = FALSE;\n"
  "        OPEN c_stack;\n"
  "        c_stack_loop: LOOP\n"
  "            FETCH c_stack INTO v_event, v_min_event_id;\n"
  "            IF v_done THEN\n"
  "                LEAVE c_stack_loop;\n"
  "            END IF;\n"
  "            IF (LENGTH(v_event) > 0) THEN\n"
  "                INSERT INTO tmp_events VALUES (v_min_event_id, v_event);\n"
  "            END IF;\n"
  "        END LOOP;\n"
  "        CLOSE c_stack;\n"
  "        SELECT SLEEP(in_interval) INTO @sleep;\n"
  "        SET v_runtime = (UNIX_TIMESTAMP() - v_start);\n"
  "    END WHILE;\n"
  "    INSERT INTO tmp_events VALUES (v_min_event_id+1, '}');\n"
  "    SET @query = CONCAT('SELECT event FROM tmp_events ORDER BY event_id INTO OUTFILE ''', in_outfile, ''' FIELDS ESCAPED BY '''' LINES TERMINATED BY ''''');\n"
  "    PREPARE stmt_output FROM @query;\n"
  "    EXECUTE stmt_output;\n"
  "    DEALLOCATE PREPARE stmt_output;\n"
  "    SELECT CONCAT('Stack trace written to ', in_outfile) AS 'Info';\n"
  "    SELECT CONCAT('dot -Tpdf -o /tmp/stack_', in_thread_id, '.pdf ', in_outfile) AS 'Convert to PDF';\n"
  "    SELECT CONCAT('dot -Tpng -o /tmp/stack_', in_thread_id, '.png ', in_outfile) AS 'Convert to PNG';\n"
  "    DROP TEMPORARY TABLE tmp_events;\n"
  "    IF (in_auto_setup) THEN\n"
  "        CALL sys.ps_setup_reload_saved();\n"
  "    END IF;\n"
  "    IF (v_this_thread_enabed = 'YES') THEN\n"
  "        CALL sys.ps_setup_enable_thread(CONNECTION_ID());\n"
  "    END IF;\n"
  "    SET sql_log_bin = @log_bin;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_setup_disable_background_threads;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_setup_disable_background_threads ()\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Disable all background thread instrumentation within Performance Schema.\n"
  "             Parameters\n"
  "             None.\n"
  "             Example\n"
  "             mysql> CALL sys.ps_setup_disable_background_threads();\n"
  "             +--------------------------------+\n"
  "             | summary                        |\n"
  "             +--------------------------------+\n"
  "             | Disabled 18 background threads |\n"
  "             +--------------------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    UPDATE performance_schema.threads\n"
  "       SET instrumented = 'NO'\n"
  "     WHERE type = 'BACKGROUND';\n"
  "    SELECT CONCAT('Disabled ', @rows := ROW_COUNT(), ' background thread', IF(@rows != 1, 's', '')) AS summary;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_setup_disable_consumer;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_setup_disable_consumer (\n"
  "        IN consumer VARCHAR(128)\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Disables consumers within Performance Schema\n"
  "             matching the input pattern.\n"
  "             Parameters\n"
  "             consumer (VARCHAR(128)):\n"
  "               A LIKE pattern match (using \"%consumer%\") of consumers to disable\n"
  "             Example\n"
  "             To disable all consumers:\n"
  "             mysql> CALL sys.ps_setup_disable_consumer(\\'\\');\n"
  "             +--------------------------+\n"
  "             | summary                  |\n"
  "             +--------------------------+\n"
  "             | Disabled 15 consumers    |\n"
  "             +--------------------------+\n"
  "             1 row in set (0.02 sec)\n"
  "             To disable just the event_stage consumers:\n"
  "             mysql> CALL sys.ps_setup_disable_comsumers(\\'stage\\');\n"
  "             +------------------------+\n"
  "             | summary                |\n"
  "             +------------------------+\n"
  "             | Disabled 3 consumers   |\n"
  "             +------------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    UPDATE performance_schema.setup_consumers\n"
  "       SET enabled = 'NO'\n"
  "     WHERE name LIKE CONCAT('%', consumer, '%');\n"
  "    SELECT CONCAT('Disabled ', @rows := ROW_COUNT(), ' consumer', IF(@rows != 1, 's', '')) AS summary;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_setup_disable_instrument;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_setup_disable_instrument (\n"
  "        IN in_pattern VARCHAR(128)\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Disables instruments within Performance Schema\n"
  "             matching the input pattern.\n"
  "             Parameters\n"
  "             in_pattern (VARCHAR(128)):\n"
  "               A LIKE pattern match (using \"%in_pattern%\") of events to disable\n"
  "             Example\n"
  "             To disable all mutex instruments:\n"
  "             mysql> CALL sys.ps_setup_disable_instrument(\\'wait/synch/mutex\\');\n"
  "             +--------------------------+\n"
  "             | summary                  |\n"
  "             +--------------------------+\n"
  "             | Disabled 155 instruments |\n"
  "             +--------------------------+\n"
  "             1 row in set (0.02 sec)\n"
  "             To disable just a specific TCP/IP based network IO instrument:\n"
  "             mysql> CALL sys.ps_setup_disable_instrument(\\'wait/io/socket/sql/server_tcpip_socket\\');\n"
  "             +------------------------+\n"
  "             | summary                |\n"
  "             +------------------------+\n"
  "             | Disabled 1 instruments |\n"
  "             +------------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "             To disable all instruments:\n"
  "             mysql> CALL sys.ps_setup_disable_instrument(\\'\\');\n"
  "             +--------------------------+\n"
  "             | summary                  |\n"
  "             +--------------------------+\n"
  "             | Disabled 547 instruments |\n"
  "             +--------------------------+\n"
  "             1 row in set (0.01 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    UPDATE performance_schema.setup_instruments\n"
  "       SET enabled = 'NO', timed = 'NO'\n"
  "     WHERE name LIKE CONCAT('%', in_pattern, '%');\n"
  "    SELECT CONCAT('Disabled ', @rows := ROW_COUNT(), ' instrument', IF(@rows != 1, 's', '')) AS summary;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_setup_disable_thread;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_setup_disable_thread (\n"
  "        IN in_connection_id BIGINT\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Disable the given connection/thread in Performance Schema.\n"
  "             Parameters\n"
  "             in_connection_id (BIGINT):\n"
  "               The connection ID (PROCESSLIST_ID from performance_schema.threads\n"
  "               or the ID shown within SHOW PROCESSLIST)\n"
  "             Example\n"
  "             mysql> CALL sys.ps_setup_disable_thread(3);\n"
  "             +-------------------+\n"
  "             | summary           |\n"
  "             +-------------------+\n"
  "             | Disabled 1 thread |\n"
  "             +-------------------+\n"
  "             1 row in set (0.01 sec)\n"
  "             To disable the current connection:\n"
  "             mysql> CALL sys.ps_setup_disable_thread(CONNECTION_ID());\n"
  "             +-------------------+\n"
  "             | summary           |\n"
  "             +-------------------+\n"
  "             | Disabled 1 thread |\n"
  "             +-------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    UPDATE performance_schema.threads\n"
  "       SET instrumented = 'NO'\n"
  "     WHERE processlist_id = in_connection_id;\n"
  "    SELECT CONCAT('Disabled ', @rows := ROW_COUNT(), ' thread', IF(@rows != 1, 's', '')) AS summary;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_setup_enable_background_threads;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_setup_enable_background_threads ()\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Enable all background thread instrumentation within Performance Schema.\n"
  "             Parameters\n"
  "             None.\n"
  "             Example\n"
  "             mysql> CALL sys.ps_setup_enable_background_threads();\n"
  "             +-------------------------------+\n"
  "             | summary                       |\n"
  "             +-------------------------------+\n"
  "             | Enabled 18 background threads |\n"
  "             +-------------------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    UPDATE performance_schema.threads\n"
  "       SET instrumented = 'YES'\n"
  "     WHERE type = 'BACKGROUND';\n"
  "    SELECT CONCAT('Enabled ', @rows := ROW_COUNT(), ' background thread', IF(@rows != 1, 's', '')) AS summary;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_setup_enable_consumer;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_setup_enable_consumer (\n"
  "        IN consumer VARCHAR(128)\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Enables consumers within Performance Schema\n"
  "             matching the input pattern.\n"
  "             Parameters\n"
  "             consumer (VARCHAR(128)):\n"
  "               A LIKE pattern match (using \"%consumer%\") of consumers to enable\n"
  "             Example\n"
  "             To enable all consumers:\n"
  "             mysql> CALL sys.ps_setup_enable_consumer(\\'\\');\n"
  "             +-------------------------+\n"
  "             | summary                 |\n"
  "             +-------------------------+\n"
  "             | Enabled 10 consumers    |\n"
  "             +-------------------------+\n"
  "             1 row in set (0.02 sec)\n"
  "             Query OK, 0 rows affected (0.02 sec)\n"
  "             To enable just \"waits\" consumers:\n"
  "             mysql> CALL sys.ps_setup_enable_consumer(\\'waits\\');\n"
  "             +-----------------------+\n"
  "             | summary               |\n"
  "             +-----------------------+\n"
  "             | Enabled 3 consumers   |\n"
  "             +-----------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "             Query OK, 0 rows affected (0.00 sec)\n"
  "             '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    UPDATE performance_schema.setup_consumers\n"
  "       SET enabled = 'YES'\n"
  "     WHERE name LIKE CONCAT('%', consumer, '%');\n"
  "    SELECT CONCAT('Enabled ', @rows := ROW_COUNT(), ' consumer', IF(@rows != 1, 's', '')) AS summary;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_setup_enable_instrument;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_setup_enable_instrument (\n"
  "        IN in_pattern VARCHAR(128)\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Enables instruments within Performance Schema\n"
  "             matching the input pattern.\n"
  "             Parameters\n"
  "             in_pattern (VARCHAR(128)):\n"
  "               A LIKE pattern match (using \"%in_pattern%\") of events to enable\n"
  "             Example\n"
  "             To enable all mutex instruments:\n"
  "             mysql> CALL sys.ps_setup_enable_instrument(\\'wait/synch/mutex\\');\n"
  "             +-------------------------+\n"
  "             | summary                 |\n"
  "             +-------------------------+\n"
  "             | Enabled 155 instruments |\n"
  "             +-------------------------+\n"
  "             1 row in set (0.02 sec)\n"
  "             Query OK, 0 rows affected (0.02 sec)\n"
  "             To enable just a specific TCP/IP based network IO instrument:\n"
  "             mysql> CALL sys.ps_setup_enable_instrument(\\'wait/io/socket/sql/server_tcpip_socket\\');\n"
  "             +-----------------------+\n"
  "             | summary               |\n"
  "             +-----------------------+\n"
  "             | Enabled 1 instruments |\n"
  "             +-----------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "             Query OK, 0 rows affected (0.00 sec)\n"
  "             To enable all instruments:\n"
  "             mysql> CALL sys.ps_setup_enable_instrument(\\'\\');\n"
  "             +-------------------------+\n"
  "             | summary                 |\n"
  "             +-------------------------+\n"
  "             | Enabled 547 instruments |\n"
  "             +-------------------------+\n"
  "             1 row in set (0.01 sec)\n"
  "             Query OK, 0 rows affected (0.01 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    UPDATE performance_schema.setup_instruments\n"
  "       SET enabled = 'YES', timed = 'YES'\n"
  "     WHERE name LIKE CONCAT('%', in_pattern, '%');\n"
  "    SELECT CONCAT('Enabled ', @rows := ROW_COUNT(), ' instrument', IF(@rows != 1, 's', '')) AS summary;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_setup_enable_thread;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_setup_enable_thread (\n"
  "        IN in_connection_id BIGINT\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Enable the given connection/thread in Performance Schema.\n"
  "             Parameters\n"
  "             in_connection_id (BIGINT):\n"
  "               The connection ID (PROCESSLIST_ID from performance_schema.threads\n"
  "               or the ID shown within SHOW PROCESSLIST)\n"
  "             Example\n"
  "             mysql> CALL sys.ps_setup_enable_thread(3);\n"
  "             +------------------+\n"
  "             | summary          |\n"
  "             +------------------+\n"
  "             | Enabled 1 thread |\n"
  "             +------------------+\n"
  "             1 row in set (0.01 sec)\n"
  "             To enable the current connection:\n"
  "             mysql> CALL sys.ps_setup_enable_thread(CONNECTION_ID());\n"
  "             +------------------+\n"
  "             | summary          |\n"
  "             +------------------+\n"
  "             | Enabled 1 thread |\n"
  "             +------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    UPDATE performance_schema.threads\n"
  "       SET instrumented = 'YES'\n"
  "     WHERE processlist_id = in_connection_id;\n"
  "    SELECT CONCAT('Enabled ', @rows := ROW_COUNT(), ' thread', IF(@rows != 1, 's', '')) AS summary;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_setup_reload_saved;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_setup_reload_saved ()\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Reloads a saved Performance Schema configuration,\n"
  "             so that you can alter the setup for debugging purposes,\n"
  "             but restore it to a previous state.\n"
  "             Use the companion procedure - ps_setup_save(), to\n"
  "             save a configuration.\n"
  "             Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n"
  "             Parameters\n"
  "             None.\n"
  "             Example\n"
  "             mysql> CALL sys.ps_setup_save();\n"
  "             Query OK, 0 rows affected (0.08 sec)\n"
  "             mysql> UPDATE performance_schema.setup_instruments SET enabled = \\'YES\\', timed = \\'YES\\';\n"
  "             Query OK, 547 rows affected (0.40 sec)\n"
  "             Rows matched: 784  Changed: 547  Warnings: 0\n"
  "             /* Run some tests that need more detailed instrumentation here */\n"
  "             mysql> CALL sys.ps_setup_reload_saved();\n"
  "             Query OK, 0 rows affected (0.32 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_done bool DEFAULT FALSE;\n"
  "    DECLARE v_lock_result INT;\n"
  "    DECLARE v_lock_used_by BIGINT;\n"
  "    DECLARE v_signal_message TEXT;\n"
  "    DECLARE EXIT HANDLER FOR SQLEXCEPTION\n"
  "    BEGIN\n"
  "        SIGNAL SQLSTATE VALUE '90001'\n"
  "           SET MESSAGE_TEXT = 'An error occurred, was sys.ps_setup_save() run before this procedure?';\n"
  "    END;\n"
  "    SET @log_bin := @@sql_log_bin;\n"
  "    SET sql_log_bin = 0;\n"
  "    SELECT IS_USED_LOCK('sys.ps_setup_save') INTO v_lock_used_by;\n"
  "    IF (v_lock_used_by != CONNECTION_ID()) THEN\n"
  "        SET v_signal_message = CONCAT('The sys.ps_setup_save lock is currently owned by ', v_lock_used_by);\n"
  "        SIGNAL SQLSTATE VALUE '90002'\n"
  "           SET MESSAGE_TEXT = v_signal_message;\n"
  "    END IF;\n"
  "    DELETE FROM performance_schema.setup_actors;\n"
  "    INSERT INTO performance_schema.setup_actors SELECT * FROM tmp_setup_actors;\n"
  "    BEGIN\n"
  "        DECLARE v_name varchar(64);\n"
  "        DECLARE v_enabled enum('YES', 'NO');\n"
  "        DECLARE c_consumers CURSOR FOR SELECT NAME, ENABLED FROM tmp_setup_consumers;\n"
  "        DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;\n"
  "        SET v_done = FALSE;\n"
  "        OPEN c_consumers;\n"
  "        c_consumers_loop: LOOP\n"
  "            FETCH c_consumers INTO v_name, v_enabled;\n"
  "            IF v_done THEN\n"
  "               LEAVE c_consumers_loop;\n"
  "            END IF;\n"
  "            UPDATE performance_schema.setup_consumers\n"
  "               SET ENABLED = v_enabled\n"
  "             WHERE NAME = v_name;\n"
  "         END LOOP;\n"
  "         CLOSE c_consumers;\n"
  "    END;\n"
  "    UPDATE performance_schema.setup_instruments\n"
  "     INNER JOIN tmp_setup_instruments USING (NAME)\n"
  "       SET performance_schema.setup_instruments.ENABLED = tmp_setup_instruments.ENABLED,\n"
  "           performance_schema.setup_instruments.TIMED   = tmp_setup_instruments.TIMED;\n"
  "    BEGIN\n"
  "        DECLARE v_thread_id bigint unsigned;\n"
  "        DECLARE v_instrumented enum('YES', 'NO');\n"
  "        DECLARE c_threads CURSOR FOR SELECT THREAD_ID, INSTRUMENTED FROM tmp_threads;\n"
  "        DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;\n"
  "        SET v_done = FALSE;\n"
  "        OPEN c_threads;\n"
  "        c_threads_loop: LOOP\n"
  "            FETCH c_threads INTO v_thread_id, v_instrumented;\n"
  "            IF v_done THEN\n"
  "               LEAVE c_threads_loop;\n"
  "            END IF;\n"
  "            UPDATE performance_schema.threads\n"
  "               SET INSTRUMENTED = v_instrumented\n"
  "             WHERE THREAD_ID = v_thread_id;\n"
  "        END LOOP;\n"
  "        CLOSE c_threads;\n"
  "    END;\n"
  "    UPDATE performance_schema.threads\n"
  "       SET INSTRUMENTED = IF(PROCESSLIST_USER IS NOT NULL,\n"
  "                             sys.ps_is_account_enabled(PROCESSLIST_HOST, PROCESSLIST_USER),\n"
  "                             'YES')\n"
  "     WHERE THREAD_ID NOT IN (SELECT THREAD_ID FROM tmp_threads);\n"
  "    DROP TEMPORARY TABLE tmp_setup_actors;\n"
  "    DROP TEMPORARY TABLE tmp_setup_consumers;\n"
  "    DROP TEMPORARY TABLE tmp_setup_instruments;\n"
  "    DROP TEMPORARY TABLE tmp_threads;\n"
  "    SELECT RELEASE_LOCK('sys.ps_setup_save') INTO v_lock_result;\n"
  "    SET sql_log_bin = @log_bin;\n"
  "END$$\n",
"DELIMITER ;\n",
"SET @old_sql_mode = @@session.sql_mode, @@session.sql_mode = '';\n",
"DROP PROCEDURE IF EXISTS ps_setup_reset_to_default;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_setup_reset_to_default (\n"
  "       IN in_verbose BOOLEAN\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Resets the Performance Schema setup to the default settings.\n"
  "             Parameters\n"
  "             in_verbose (BOOLEAN):\n"
  "               Whether to print each setup stage (including the SQL) whilst running.\n"
  "             Example\n"
  "             mysql> CALL sys.ps_setup_reset_to_default(true)\\\\G\n"
  "             *************************** 1. row ***************************\n"
  "             status: Resetting: setup_actors\n"
  "             DELETE\n"
  "             FROM performance_schema.setup_actors\n"
  "              WHERE NOT (HOST = \\'%\\' AND USER = \\'%\\' AND ROLE = \\'%\\')\n"
  "             1 row in set (0.00 sec)\n"
  "             *************************** 1. row ***************************\n"
  "             status: Resetting: setup_actors\n"
  "             INSERT IGNORE INTO performance_schema.setup_actors\n"
  "             VALUES (\\'%\\', \\'%\\', \\'%\\')\n"
  "             1 row in set (0.00 sec)\n"
  "             ...\n"
  "             mysql> CALL sys.ps_setup_reset_to_default(false)\\\\G\n"
  "             Query OK, 0 rows affected (0.00 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    SET @query = 'DELETE\n"
  "                    FROM performance_schema.setup_actors\n"
  "                   WHERE NOT (HOST = ''%'' AND USER = ''%'' AND ROLE = ''%'')';\n"
  "    IF (in_verbose) THEN\n"
  "        SELECT CONCAT('Resetting: setup_actors\\n', REPLACE(@query, '  ', '')) AS status;\n"
  "    END IF;\n"
  "    PREPARE reset_stmt FROM @query;\n"
  "    EXECUTE reset_stmt;\n"
  "    DEALLOCATE PREPARE reset_stmt;\n"
  "    SET @query = 'INSERT IGNORE INTO performance_schema.setup_actors\n"
  "                  VALUES (''%'', ''%'', ''%'', ''YES'', ''YES'')';\n"
  "    IF (in_verbose) THEN\n"
  "        SELECT CONCAT('Resetting: setup_actors\\n', REPLACE(@query, '  ', '')) AS status;\n"
  "    END IF;\n"
  "    PREPARE reset_stmt FROM @query;\n"
  "    EXECUTE reset_stmt;\n"
  "    DEALLOCATE PREPARE reset_stmt;\n"
  "    SET @query = 'UPDATE performance_schema.setup_instruments\n"
  "                     SET ENABLED = sys.ps_is_instrument_default_enabled(NAME),\n"
  "                         TIMED   = sys.ps_is_instrument_default_timed(NAME)';\n"
  "    IF (in_verbose) THEN\n"
  "        SELECT CONCAT('Resetting: setup_instruments\\n', REPLACE(@query, '  ', '')) AS status;\n"
  "    END IF;\n"
  "    PREPARE reset_stmt FROM @query;\n"
  "    EXECUTE reset_stmt;\n"
  "    DEALLOCATE PREPARE reset_stmt;\n"
  "    SET @query = 'UPDATE performance_schema.setup_consumers\n"
  "                     SET ENABLED = IF(NAME IN (''events_statements_current'', ''events_transactions_current'', ''global_instrumentation'', ''thread_instrumentation'', ''statements_digest''), ''YES'', ''NO'')';\n"
  "    IF (in_verbose) THEN\n"
  "        SELECT CONCAT('Resetting: setup_consumers\\n', REPLACE(@query, '  ', '')) AS status;\n"
  "    END IF;\n"
  "    PREPARE reset_stmt FROM @query;\n"
  "    EXECUTE reset_stmt;\n"
  "    DEALLOCATE PREPARE reset_stmt;\n"
  "    SET @query = 'DELETE\n"
  "                    FROM performance_schema.setup_objects\n"
  "                   WHERE NOT (OBJECT_TYPE IN (''EVENT'', ''FUNCTION'', ''PROCEDURE'', ''TABLE'', ''TRIGGER'') AND OBJECT_NAME = ''%''\n"
  "                     AND (OBJECT_SCHEMA = ''mysql''              AND ENABLED = ''NO''  AND TIMED = ''NO'' )\n"
  "                      OR (OBJECT_SCHEMA = ''performance_schema'' AND ENABLED = ''NO''  AND TIMED = ''NO'' )\n"
  "                      OR (OBJECT_SCHEMA = ''information_schema'' AND ENABLED = ''NO''  AND TIMED = ''NO'' )\n"
  "                      OR (OBJECT_SCHEMA = ''%''                  AND ENABLED = ''YES'' AND TIMED = ''YES''))';\n"
  "    IF (in_verbose) THEN\n"
  "        SELECT CONCAT('Resetting: setup_objects\\n', REPLACE(@query, '  ', '')) AS status;\n"
  "    END IF;\n"
  "    PREPARE reset_stmt FROM @query;\n"
  "    EXECUTE reset_stmt;\n"
  "    DEALLOCATE PREPARE reset_stmt;\n"
  "    SET @query = 'INSERT IGNORE INTO performance_schema.setup_objects\n"
  "                  VALUES (''EVENT''    , ''mysql''             , ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''EVENT''    , ''performance_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''EVENT''    , ''information_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''EVENT''    , ''%''                 , ''%'', ''YES'', ''YES''),\n"
  "                         (''FUNCTION'' , ''mysql''             , ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''FUNCTION'' , ''performance_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''FUNCTION'' , ''information_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''FUNCTION'' , ''%''                 , ''%'', ''YES'', ''YES''),\n"
  "                         (''PROCEDURE'', ''mysql''             , ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''PROCEDURE'', ''performance_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''PROCEDURE'', ''information_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''PROCEDURE'', ''%''                 , ''%'', ''YES'', ''YES''),\n"
  "                         (''TABLE''    , ''mysql''             , ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''TABLE''    , ''performance_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''TABLE''    , ''information_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''TABLE''    , ''%''                 , ''%'', ''YES'', ''YES''),\n"
  "                         (''TRIGGER''  , ''mysql''             , ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''TRIGGER''  , ''performance_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''TRIGGER''  , ''information_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''TRIGGER''  , ''%''                 , ''%'', ''YES'', ''YES'')';\n"
  "    IF (in_verbose) THEN\n"
  "        SELECT CONCAT('Resetting: setup_objects\\n', REPLACE(@query, '  ', '')) AS status;\n"
  "    END IF;\n"
  "    PREPARE reset_stmt FROM @query;\n"
  "    EXECUTE reset_stmt;\n"
  "    DEALLOCATE PREPARE reset_stmt;\n"
  "    SET @query = 'UPDATE performance_schema.threads\n"
  "                     SET INSTRUMENTED = ''YES''';\n"
  "    IF (in_verbose) THEN\n"
  "        SELECT CONCAT('Resetting: threads\\n', REPLACE(@query, '  ', '')) AS status;\n"
  "    END IF;\n"
  "    PREPARE reset_stmt FROM @query;\n"
  "    EXECUTE reset_stmt;\n"
  "    DEALLOCATE PREPARE reset_stmt;\n"
  "END$$\n",
"DELIMITER ;\n",
"SET @@session.sql_mode = @old_sql_mode;\n",
"DROP PROCEDURE IF EXISTS ps_setup_save;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_setup_save (\n"
  "        IN in_timeout INT\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Saves the current configuration of Performance Schema,\n"
  "             so that you can alter the setup for debugging purposes,\n"
  "             but restore it to a previous state.\n"
  "             Use the companion procedure - ps_setup_reload_saved(), to\n"
  "             restore the saved config.\n"
  "             The named lock \"sys.ps_setup_save\" is taken before the\n"
  "             current configuration is saved. If the attempt to get the named\n"
  "             lock times out, an error occurs.\n"
  "             The lock is released after the settings have been restored by\n"
  "             calling ps_setup_reload_saved().\n"
  "             Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n"
  "             Parameters\n"
  "             in_timeout INT\n"
  "               The timeout in seconds used when trying to obtain the lock.\n"
  "               A negative timeout means infinite timeout.\n"
  "             Example\n"
  "             mysql> CALL sys.ps_setup_save(-1);\n"
  "             Query OK, 0 rows affected (0.08 sec)\n"
  "             mysql> UPDATE performance_schema.setup_instruments\n"
  "                 ->    SET enabled = ''YES'', timed = ''YES'';\n"
  "             Query OK, 547 rows affected (0.40 sec)\n"
  "             Rows matched: 784  Changed: 547  Warnings: 0\n"
  "             /* Run some tests that need more detailed instrumentation here */\n"
  "             mysql> CALL sys.ps_setup_reload_saved();\n"
  "             Query OK, 0 rows affected (0.32 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_lock_result INT;\n"
  "    SELECT GET_LOCK('sys.ps_setup_save', in_timeout) INTO v_lock_result;\n"
  "    IF v_lock_result THEN\n"
  "        SET @log_bin := @@sql_log_bin;\n"
  "        SET sql_log_bin = 0;\n"
  "        DROP TEMPORARY TABLE IF EXISTS tmp_setup_actors;\n"
  "        DROP TEMPORARY TABLE IF EXISTS tmp_setup_consumers;\n"
  "        DROP TEMPORARY TABLE IF EXISTS tmp_setup_instruments;\n"
  "        DROP TEMPORARY TABLE IF EXISTS tmp_threads;\n"
  "        CREATE TEMPORARY TABLE tmp_setup_actors AS SELECT * FROM performance_schema.setup_actors;\n"
  "        CREATE TEMPORARY TABLE tmp_setup_consumers AS SELECT * FROM  performance_schema.setup_consumers;\n"
  "        CREATE TEMPORARY TABLE tmp_setup_instruments AS SELECT * FROM  performance_schema.setup_instruments;\n"
  "        CREATE TEMPORARY TABLE tmp_threads (THREAD_ID bigint unsigned NOT NULL PRIMARY KEY, INSTRUMENTED enum('YES','NO') NOT NULL);\n"
  "        INSERT INTO tmp_threads SELECT THREAD_ID, INSTRUMENTED FROM performance_schema.threads;\n"
  "        SET sql_log_bin = @log_bin;\n"
  "    ELSE\n"
  "        SIGNAL SQLSTATE VALUE '90000'\n"
  "           SET MESSAGE_TEXT = 'Could not lock the sys.ps_setup_save user lock, another thread has a saved configuration';\n"
  "    END IF;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_setup_show_disabled;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_setup_show_disabled (\n"
  "        IN in_show_instruments BOOLEAN,\n"
  "        IN in_show_threads BOOLEAN\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Shows all currently disable Performance Schema configuration.\n"
  "             Disabled users is only available for MySQL 5.7.6 and later.\n"
  "             In earlier versions it was only possible to enable users.\n"
  "             Parameters\n"
  "             in_show_instruments (BOOLEAN):\n"
  "               Whether to print disabled instruments (can print many items)\n"
  "             in_show_threads (BOOLEAN):\n"
  "               Whether to print disabled threads\n"
  "             Example\n"
  "             mysql> CALL sys.ps_setup_show_disabled(TRUE, TRUE);\n"
  "             +----------------------------+\n"
  "             | performance_schema_enabled |\n"
  "             +----------------------------+\n"
  "             |                          1 |\n"
  "             +----------------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "             +--------------------+\n"
  "             | disabled_users     |\n"
  "             +--------------------+\n"
  "             | \\'mark\\'@\\'localhost\\' |\n"
  "             +--------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "             +-------------+----------------------+---------+-------+\n"
  "             | object_type | objects              | enabled | timed |\n"
  "             +-------------+----------------------+---------+-------+\n"
  "             | EVENT       | mysql.%              | NO      | NO    |\n"
  "             | EVENT       | performance_schema.% | NO      | NO    |\n"
  "             | EVENT       | information_schema.% | NO      | NO    |\n"
  "             | FUNCTION    | mysql.%              | NO      | NO    |\n"
  "             | FUNCTION    | performance_schema.% | NO      | NO    |\n"
  "             | FUNCTION    | information_schema.% | NO      | NO    |\n"
  "             | PROCEDURE   | mysql.%              | NO      | NO    |\n"
  "             | PROCEDURE   | performance_schema.% | NO      | NO    |\n"
  "             | PROCEDURE   | information_schema.% | NO      | NO    |\n"
  "             | TABLE       | mysql.%              | NO      | NO    |\n"
  "             | TABLE       | performance_schema.% | NO      | NO    |\n"
  "             | TABLE       | information_schema.% | NO      | NO    |\n"
  "             | TRIGGER     | mysql.%              | NO      | NO    |\n"
  "             | TRIGGER     | performance_schema.% | NO      | NO    |\n"
  "             | TRIGGER     | information_schema.% | NO      | NO    |\n"
  "             +-------------+----------------------+---------+-------+\n"
  "             15 rows in set (0.00 sec)\n"
  "             +----------------------------------+\n"
  "             | disabled_consumers               |\n"
  "             +----------------------------------+\n"
  "             | events_stages_current            |\n"
  "             | events_stages_history            |\n"
  "             | events_stages_history_long       |\n"
  "             | events_statements_history        |\n"
  "             | events_statements_history_long   |\n"
  "             | events_transactions_history      |\n"
  "             | events_transactions_history_long |\n"
  "             | events_waits_current             |\n"
  "             | events_waits_history             |\n"
  "             | events_waits_history_long        |\n"
  "             +----------------------------------+\n"
  "             10 rows in set (0.00 sec)\n"
  "             Empty set (0.00 sec)\n"
  "             +---------------------------------------------------------------------------------------+-------+\n"
  "             | disabled_instruments                                                                  | timed |\n"
  "             +---------------------------------------------------------------------------------------+-------+\n"
  "             | wait/synch/mutex/sql/TC_LOG_MMAP::LOCK_tc                                             | NO    |\n"
  "             | wait/synch/mutex/sql/LOCK_des_key_file                                                | NO    |\n"
  "             | wait/synch/mutex/sql/MYSQL_BIN_LOG::LOCK_commit                                       | NO    |\n"
  "             ...\n"
  "             | memory/sql/servers_cache                                                              | NO    |\n"
  "             | memory/sql/udf_mem                                                                    | NO    |\n"
  "             | wait/lock/metadata/sql/mdl                                                            | NO    |\n"
  "             +---------------------------------------------------------------------------------------+-------+\n"
  "             547 rows in set (0.00 sec)\n"
  "             Query OK, 0 rows affected (0.01 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    SELECT @@performance_schema AS performance_schema_enabled;\n"
  "    /*!50706\n"
  "    SELECT CONCAT('\\'', user, '\\'@\\'', host, '\\'') AS disabled_users\n"
  "      FROM performance_schema.setup_actors\n"
  "     WHERE enabled = 'NO'\n"
  "     ORDER BY disabled_users;\n"
  "    */\n"
  "    SELECT object_type,\n"
  "           CONCAT(object_schema, '.', object_name) AS objects,\n"
  "           enabled,\n"
  "           timed\n"
  "      FROM performance_schema.setup_objects\n"
  "     WHERE enabled = 'NO'\n"
  "     ORDER BY object_type, objects;\n"
  "    SELECT name AS disabled_consumers\n"
  "      FROM performance_schema.setup_consumers\n"
  "     WHERE enabled = 'NO'\n"
  "     ORDER BY disabled_consumers;\n"
  "    IF (in_show_threads) THEN\n"
  "        SELECT IF(name = 'thread/sql/one_connection',\n"
  "                  CONCAT(processlist_user, '@', processlist_host),\n"
  "                  REPLACE(name, 'thread/', '')) AS disabled_threads,\n"
  "        TYPE AS thread_type\n"
  "          FROM performance_schema.threads\n"
  "         WHERE INSTRUMENTED = 'NO'\n"
  "         ORDER BY disabled_threads;\n"
  "    END IF;\n"
  "    IF (in_show_instruments) THEN\n"
  "        SELECT name AS disabled_instruments,\n"
  "               timed\n"
  "          FROM performance_schema.setup_instruments\n"
  "         WHERE enabled = 'NO'\n"
  "         ORDER BY disabled_instruments;\n"
  "    END IF;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_setup_show_disabled_consumers;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_setup_show_disabled_consumers ()\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Shows all currently disabled consumers.\n"
  "             Parameters\n"
  "             None\n"
  "             Example\n"
  "             mysql> CALL sys.ps_setup_show_disabled_consumers();\n"
  "             +---------------------------+\n"
  "             | disabled_consumers        |\n"
  "             +---------------------------+\n"
  "             | events_statements_current |\n"
  "             | global_instrumentation    |\n"
  "             | thread_instrumentation    |\n"
  "             | statements_digest         |\n"
  "             +---------------------------+\n"
  "             4 rows in set (0.05 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    SELECT name AS disabled_consumers\n"
  "      FROM performance_schema.setup_consumers\n"
  "     WHERE enabled = 'NO'\n"
  "     ORDER BY disabled_consumers;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_setup_show_disabled_instruments;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_setup_show_disabled_instruments ()\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Shows all currently disabled instruments.\n"
  "             Parameters\n"
  "             None\n"
  "             Example\n"
  "             mysql> CALL sys.ps_setup_show_disabled_instruments();\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    SELECT name AS disabled_instruments, timed\n"
  "      FROM performance_schema.setup_instruments\n"
  "     WHERE enabled = 'NO'\n"
  "     ORDER BY disabled_instruments;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_setup_show_enabled;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_setup_show_enabled (\n"
  "        IN in_show_instruments BOOLEAN,\n"
  "        IN in_show_threads BOOLEAN\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Shows all currently enabled Performance Schema configuration.\n"
  "             Parameters\n"
  "             in_show_instruments (BOOLEAN):\n"
  "               Whether to print enabled instruments (can print many items)\n"
  "             in_show_threads (BOOLEAN):\n"
  "               Whether to print enabled threads\n"
  "             Example\n"
  "             mysql> CALL sys.ps_setup_show_enabled(TRUE, TRUE);\n"
  "             +----------------------------+\n"
  "             | performance_schema_enabled |\n"
  "             +----------------------------+\n"
  "             |                          1 |\n"
  "             +----------------------------+\n"
  "             1 row in set (0.00 sec)\n"
  "             +---------------+\n"
  "             | enabled_users |\n"
  "             +---------------+\n"
  "             | \\'%\\'@\\'%\\'       |\n"
  "             +---------------+\n"
  "             1 row in set (0.01 sec)\n"
  "             +-------------+---------+---------+-------+\n"
  "             | object_type | objects | enabled | timed |\n"
  "             +-------------+---------+---------+-------+\n"
  "             | EVENT       | %.%     | YES     | YES   |\n"
  "             | FUNCTION    | %.%     | YES     | YES   |\n"
  "             | PROCEDURE   | %.%     | YES     | YES   |\n"
  "             | TABLE       | %.%     | YES     | YES   |\n"
  "             | TRIGGER     | %.%     | YES     | YES   |\n"
  "             +-------------+---------+---------+-------+\n"
  "             5 rows in set (0.01 sec)\n"
  "             +---------------------------+\n"
  "             | enabled_consumers         |\n"
  "             +---------------------------+\n"
  "             | events_statements_current |\n"
  "             | global_instrumentation    |\n"
  "             | thread_instrumentation    |\n"
  "             | statements_digest         |\n"
  "             +---------------------------+\n"
  "             4 rows in set (0.05 sec)\n"
  "             +---------------------------------+-------------+\n"
  "             | enabled_threads                 | thread_type |\n"
  "             +---------------------------------+-------------+\n"
  "             | sql/main                        | BACKGROUND  |\n"
  "             | sql/thread_timer_notifier       | BACKGROUND  |\n"
  "             | innodb/io_ibuf_thread           | BACKGROUND  |\n"
  "             | innodb/io_log_thread            | BACKGROUND  |\n"
  "             | innodb/io_read_thread           | BACKGROUND  |\n"
  "             | innodb/io_read_thread           | BACKGROUND  |\n"
  "             | innodb/io_write_thread          | BACKGROUND  |\n"
  "             | innodb/io_write_thread          | BACKGROUND  |\n"
  "             | innodb/page_cleaner             | BACKGROUND  |\n"
  "             | innodb/srv_lock_timeout_thread  | BACKGROUND  |\n"
  "             | innodb/srv_error_monitor_thread | BACKGROUND  |\n"
  "             | innodb/srv_monitor_thread       | BACKGROUND  |\n"
  "             | innodb/srv_master_thread        | BACKGROUND  |\n"
  "             | innodb/srv_purge_thread         | BACKGROUND  |\n"
  "             | innodb/srv_worker_thread        | BACKGROUND  |\n"
  "             | innodb/srv_worker_thread        | BACKGROUND  |\n"
  "             | innodb/srv_worker_thread        | BACKGROUND  |\n"
  "             | innodb/buf_dump_thread          | BACKGROUND  |\n"
  "             | innodb/dict_stats_thread        | BACKGROUND  |\n"
  "             | sql/signal_handler              | BACKGROUND  |\n"
  "             | sql/compress_gtid_table         | FOREGROUND  |\n"
  "             | root@localhost                  | FOREGROUND  |\n"
  "             +---------------------------------+-------------+\n"
  "             22 rows in set (0.01 sec)\n"
  "             +-------------------------------------+-------+\n"
  "             | enabled_instruments                 | timed |\n"
  "             +-------------------------------------+-------+\n"
  "             | wait/io/file/sql/map                | YES   |\n"
  "             | wait/io/file/sql/binlog             | YES   |\n"
  "             ...\n"
  "             | statement/com/Error                 | YES   |\n"
  "             | statement/com/                      | YES   |\n"
  "             | idle                                | YES   |\n"
  "             +-------------------------------------+-------+\n"
  "             210 rows in set (0.08 sec)\n"
  "             Query OK, 0 rows affected (0.89 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    SELECT @@performance_schema AS performance_schema_enabled;\n"
  "    SELECT CONCAT('\\'', user, '\\'@\\'', host, '\\'') AS enabled_users\n"
  "      FROM performance_schema.setup_actors\n"
  "      WHERE enabled = 'YES'\n"
  "     ORDER BY enabled_users;\n"
  "    SELECT object_type,\n"
  "           CONCAT(object_schema, '.', object_name) AS objects,\n"
  "           enabled,\n"
  "           timed\n"
  "      FROM performance_schema.setup_objects\n"
  "     WHERE enabled = 'YES'\n"
  "     ORDER BY object_type, objects;\n"
  "    SELECT name AS enabled_consumers\n"
  "      FROM performance_schema.setup_consumers\n"
  "     WHERE enabled = 'YES'\n"
  "     ORDER BY enabled_consumers;\n"
  "    IF (in_show_threads) THEN\n"
  "        SELECT IF(name = 'thread/sql/one_connection',\n"
  "                  CONCAT(processlist_user, '@', processlist_host),\n"
  "                  REPLACE(name, 'thread/', '')) AS enabled_threads,\n"
  "        TYPE AS thread_type\n"
  "          FROM performance_schema.threads\n"
  "         WHERE INSTRUMENTED = 'YES' AND name <> 'thread/innodb/thread_pool_thread'\n"
  "         ORDER BY enabled_threads;\n"
  "    END IF;\n"
  "    IF (in_show_instruments) THEN\n"
  "        SELECT name AS enabled_instruments,\n"
  "               timed\n"
  "          FROM performance_schema.setup_instruments\n"
  "         WHERE enabled = 'YES'\n"
  "         ORDER BY enabled_instruments;\n"
  "    END IF;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_setup_show_enabled_consumers;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_setup_show_enabled_consumers ()\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Shows all currently enabled consumers.\n"
  "             Parameters\n"
  "             None\n"
  "             Example\n"
  "             mysql> CALL sys.ps_setup_show_enabled_consumers();\n"
  "             +---------------------------+\n"
  "             | enabled_consumers         |\n"
  "             +---------------------------+\n"
  "             | events_statements_current |\n"
  "             | global_instrumentation    |\n"
  "             | thread_instrumentation    |\n"
  "             | statements_digest         |\n"
  "             +---------------------------+\n"
  "             4 rows in set (0.05 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    SELECT name AS enabled_consumers\n"
  "      FROM performance_schema.setup_consumers\n"
  "     WHERE enabled = 'YES'\n"
  "     ORDER BY enabled_consumers;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_setup_show_enabled_instruments;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_setup_show_enabled_instruments ()\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Shows all currently enabled instruments.\n"
  "             Parameters\n"
  "             None\n"
  "             Example\n"
  "             mysql> CALL sys.ps_setup_show_enabled_instruments();\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    SELECT name AS enabled_instruments, timed\n"
  "      FROM performance_schema.setup_instruments\n"
  "     WHERE enabled = 'YES'\n"
  "     ORDER BY enabled_instruments;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS ps_truncate_all_tables;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE ps_truncate_all_tables (\n"
  "        IN in_verbose BOOLEAN\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Truncates all summary tables within Performance Schema,\n"
  "             resetting all aggregated instrumentation as a snapshot.\n"
  "             Parameters\n"
  "             in_verbose (BOOLEAN):\n"
  "               Whether to print each TRUNCATE statement before running\n"
  "             Example\n"
  "             mysql> CALL sys.ps_truncate_all_tables(false);\n"
  "             +---------------------+\n"
  "             | summary             |\n"
  "             +---------------------+\n"
  "             | Truncated 44 tables |\n"
  "             +---------------------+\n"
  "             1 row in set (0.10 sec)\n"
  "             Query OK, 0 rows affected (0.10 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_done INT DEFAULT FALSE;\n"
  "    DECLARE v_total_tables INT DEFAULT 0;\n"
  "    DECLARE v_ps_table VARCHAR(64);\n"
  "    DECLARE ps_tables CURSOR FOR\n"
  "        SELECT table_name\n"
  "          FROM INFORMATION_SCHEMA.TABLES\n"
  "         WHERE table_schema = 'performance_schema'\n"
  "           AND (table_name LIKE '%summary%'\n"
  "            OR table_name LIKE '%history%');\n"
  "    DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;\n"
  "    OPEN ps_tables;\n"
  "    ps_tables_loop: LOOP\n"
  "        FETCH ps_tables INTO v_ps_table;\n"
  "        IF v_done THEN\n"
  "          LEAVE ps_tables_loop;\n"
  "        END IF;\n"
  "        SET @truncate_stmt := CONCAT('TRUNCATE TABLE performance_schema.', v_ps_table);\n"
  "        IF in_verbose THEN\n"
  "            SELECT CONCAT('Running: ', @truncate_stmt) AS status;\n"
  "        END IF;\n"
  "        PREPARE truncate_stmt FROM @truncate_stmt;\n"
  "        EXECUTE truncate_stmt;\n"
  "        DEALLOCATE PREPARE truncate_stmt;\n"
  "        SET v_total_tables = v_total_tables + 1;\n"
  "    END LOOP;\n"
  "    CLOSE ps_tables;\n"
  "    SELECT CONCAT('Truncated ', v_total_tables, ' tables') AS summary;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS statement_performance_analyzer;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE statement_performance_analyzer (\n"
  "        IN in_action ENUM('snapshot', 'overall', 'delta', 'create_table', 'create_tmp', 'save', 'cleanup'),\n"
  "        IN in_table VARCHAR(129),\n"
  "        IN in_views SET ('with_runtimes_in_95th_percentile', 'analysis', 'with_errors_or_warnings', 'with_full_table_scans', 'with_sorting', 'with_temp_tables', 'custom')\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Create a report of the statements running on the server.\n"
  "             The views are calculated based on the overall and/or delta activity.\n"
  "             Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n"
  "             Parameters\n"
  "             in_action (ENUM(''snapshot'', ''overall'', ''delta'', ''create_tmp'', ''create_table'', ''save'', ''cleanup'')):\n"
  "               The action to take. Supported actions are:\n"
  "                 * snapshot      Store a snapshot. The default is to make a snapshot of the current content of\n"
  "                                 performance_schema.events_statements_summary_by_digest, but by setting in_table\n"
  "                                 this can be overwritten to copy the content of the specified table.\n"
  "                                 The snapshot is stored in the sys.tmp_digests temporary table.\n"
  "                 * overall       Generate analyzis based on the content specified by in_table. For the overall analyzis,\n"
  "                                 in_table can be NOW() to use a fresh snapshot. This will overwrite an existing snapshot.\n"
  "                                 Use NULL for in_table to use the existing snapshot. If in_table IS NULL and no snapshot\n"
  "                                 exists, a new will be created.\n"
  "                                 See also in_views and @sys.statement_performance_analyzer.limit.\n"
  "                 * delta         Generate a delta analysis. The delta will be calculated between the reference table in\n"
  "                                 in_table and the snapshot. An existing snapshot must exist.\n"
  "                                 The action uses the sys.tmp_digests_delta temporary table.\n"
  "                                 See also in_views and @sys.statement_performance_analyzer.limit.\n"
  "                 * create_table  Create a regular table suitable for storing the snapshot for later use, e.g. for\n"
  "                                 calculating deltas.\n"
  "                 * create_tmp    Create a temporary table suitable for storing the snapshot for later use, e.g. for\n"
  "                                 calculating deltas.\n"
  "                 * save          Save the snapshot in the table specified by in_table. The table must exists and have\n"
  "                                 the correct structure.\n"
  "                                 If no snapshot exists, a new is created.\n"
  "                 * cleanup       Remove the temporary tables used for the snapshot and delta.\n"
  "             in_table (VARCHAR(129)):\n"
  "               The table argument used for some actions. Use the format ''db1.t1'' or ''t1'' without using any backticks (`)\n"
  "               for quoting. Periods (.) are not supported in the database and table names.\n"
  "               The meaning of the table for each action supporting the argument is:\n"
  "                 * snapshot      The snapshot is created based on the specified table. Set to NULL or NOW() to use\n"
  "                                 the current content of performance_schema.events_statements_summary_by_digest.\n"
  "                 * overall       The table with the content to create the overall analyzis for. The following values\n"
  "                                 can be used:\n"
  "                                   - A table name - use the content of that table.\n"
  "                                   - NOW()        - create a fresh snapshot and overwrite the existing snapshot.\n"
  "                                   - NULL         - use the last stored snapshot.\n"
  "                 * delta         The table name is mandatory and specified the reference view to compare the currently\n"
  "                                 stored snapshot against. If no snapshot exists, a new will be created.\n"
  "                 * create_table  The name of the regular table to create.\n"
  "                 * create_tmp    The name of the temporary table to create.\n"
  "                 * save          The name of the table to save the currently stored snapshot into.\n"
  "             in_views (SET (''with_runtimes_in_95th_percentile'', ''analysis'', ''with_errors_or_warnings'',\n"
  "                            ''with_full_table_scans'', ''with_sorting'', ''with_temp_tables'', ''custom''))\n"
  "               Which views to include:\n"
  "                 * with_runtimes_in_95th_percentile  Based on the sys.statements_with_runtimes_in_95th_percentile view\n"
  "                 * analysis                          Based on the sys.statement_analysis view\n"
  "                 * with_errors_or_warnings           Based on the sys.statements_with_errors_or_warnings view\n"
  "                 * with_full_table_scans             Based on the sys.statements_with_full_table_scans view\n"
  "                 * with_sorting                      Based on the sys.statements_with_sorting view\n"
  "                 * with_temp_tables                  Based on the sys.statements_with_temp_tables view\n"
  "                 * custom                            Use a custom view. This view must be specified in @sys.statement_performance_analyzer.view to an existing view or a query\n"
  "             Default is to include all except ''custom''.\n"
  "             Configuration Options\n"
  "             sys.statement_performance_analyzer.limit\n"
  "               The maximum number of rows to include for the views that does not have a built-in limit (e.g. the 95th percentile view).\n"
  "               If not set the limit is 100.\n"
  "             sys.statement_performance_analyzer.view\n"
  "               Used together with the ''custom'' view. If the value contains a space, it is considered a query, otherwise it must be\n"
  "               an existing view querying the performance_schema.events_statements_summary_by_digest table. There cannot be any limit\n"
  "               clause including in the query or view definition if @sys.statement_performance_analyzer.limit > 0.\n"
  "               If specifying a view, use the same format as for in_table.\n"
  "             sys.debug\n"
  "               Whether to provide debugging output.\n"
  "               Default is ''OFF''. Set to ''ON'' to include.\n"
  "             Example\n"
  "             To create a report with the queries in the 95th percentile since last truncate of performance_schema.events_statements_summary_by_digest\n"
  "             and the delta for a 1 minute period:\n"
  "                1. Create a temporary table to store the initial snapshot.\n"
  "                2. Create the initial snapshot.\n"
  "                3. Save the initial snapshot in the temporary table.\n"
  "                4. Wait one minute.\n"
  "                5. Create a new snapshot.\n"
  "                6. Perform analyzis based on the new snapshot.\n"
  "                7. Perform analyzis based on the delta between the initial and new snapshots.\n"
  "             mysql> CALL sys.statement_performance_analyzer(''create_tmp'', ''mydb.tmp_digests_ini'', NULL);\n"
  "             Query OK, 0 rows affected (0.08 sec)\n"
  "             mysql> CALL sys.statement_performance_analyzer(''snapshot'', NULL, NULL);\n"
  "             Query OK, 0 rows affected (0.02 sec)\n"
  "             mysql> CALL sys.statement_performance_analyzer(''save'', ''mydb.tmp_digests_ini'', NULL);\n"
  "             Query OK, 0 rows affected (0.00 sec)\n"
  "             mysql> DO SLEEP(60);\n"
  "             Query OK, 0 rows affected (1 min 0.00 sec)\n"
  "             mysql> CALL sys.statement_performance_analyzer(''snapshot'', NULL, NULL);\n"
  "             Query OK, 0 rows affected (0.02 sec)\n"
  "             mysql> CALL sys.statement_performance_analyzer(''overall'', NULL, ''with_runtimes_in_95th_percentile'');\n"
  "             +-----------------------------------------+\n"
  "             | Next Output                             |\n"
  "             +-----------------------------------------+\n"
  "             | Queries with Runtime in 95th Percentile |\n"
  "             +-----------------------------------------+\n"
  "             1 row in set (0.05 sec)\n"
  "             ...\n"
  "             mysql> CALL sys.statement_performance_analyzer(''delta'', ''mydb.tmp_digests_ini'', ''with_runtimes_in_95th_percentile'');\n"
  "             +-----------------------------------------+\n"
  "             | Next Output                             |\n"
  "             +-----------------------------------------+\n"
  "             | Queries with Runtime in 95th Percentile |\n"
  "             +-----------------------------------------+\n"
  "             1 row in set (0.03 sec)\n"
  "             ...\n"
  "             To create an overall report of the 95th percentile queries and the top 10 queries with full table scans:\n"
  "             mysql> CALL sys.statement_performance_analyzer(''snapshot'', NULL, NULL);\n"
  "             Query OK, 0 rows affected (0.01 sec)\n"
  "             mysql> SET @sys.statement_performance_analyzer.limit = 10;\n"
  "             Query OK, 0 rows affected (0.00 sec)\n"
  "             mysql> CALL sys.statement_performance_analyzer(''overall'', NULL, ''with_runtimes_in_95th_percentile,with_full_table_scans'');\n"
  "             +-----------------------------------------+\n"
  "             | Next Output                             |\n"
  "             +-----------------------------------------+\n"
  "             | Queries with Runtime in 95th Percentile |\n"
  "             +-----------------------------------------+\n"
  "             1 row in set (0.01 sec)\n"
  "             ...\n"
  "             +-------------------------------------+\n"
  "             | Next Output                         |\n"
  "             +-------------------------------------+\n"
  "             | Top 10 Queries with Full Table Scan |\n"
  "             +-------------------------------------+\n"
  "             1 row in set (0.09 sec)\n"
  "             ...\n"
  "             Use a custom view showing the top 10 query sorted by total execution time refreshing the view every minute using\n"
  "             the watch command in Linux.\n"
  "             mysql> CREATE OR REPLACE VIEW mydb.my_statements AS\n"
  "                 -> SELECT sys.format_statement(DIGEST_TEXT) AS query,\n"
  "                 ->        SCHEMA_NAME AS db,\n"
  "                 ->        COUNT_STAR AS exec_count,\n"
  "                 ->        format_pico_time(SUM_TIMER_WAIT) AS total_latency,\n"
  "                 ->        format_pico_time(AVG_TIMER_WAIT) AS avg_latency,\n"
  "                 ->        ROUND(IFNULL(SUM_ROWS_SENT / NULLIF(COUNT_STAR, 0), 0)) AS rows_sent_avg,\n"
  "                 ->        ROUND(IFNULL(SUM_ROWS_EXAMINED / NULLIF(COUNT_STAR, 0), 0)) AS rows_examined_avg,\n"
  "                 ->        ROUND(IFNULL(SUM_ROWS_AFFECTED / NULLIF(COUNT_STAR, 0), 0)) AS rows_affected_avg,\n"
  "                 ->        DIGEST AS digest\n"
  "                 ->   FROM performance_schema.events_statements_summary_by_digest\n"
  "                 -> ORDER BY SUM_TIMER_WAIT DESC;\n"
  "             Query OK, 0 rows affected (0.01 sec)\n"
  "             mysql> CALL sys.statement_performance_analyzer(''create_table'', ''mydb.digests_prev'', NULL);\n"
  "             Query OK, 0 rows affected (0.10 sec)\n"
  "             shell$ watch -n 60 \"mysql sys --table -e \\\"\n"
  "             > SET @sys.statement_performance_analyzer.view = ''mydb.my_statements'';\n"
  "             > SET @sys.statement_performance_analyzer.limit = 10;\n"
  "             > CALL statement_performance_analyzer(''snapshot'', NULL, NULL);\n"
  "             > CALL statement_performance_analyzer(''delta'', ''mydb.digests_prev'', ''custom'');\n"
  "             > CALL statement_performance_analyzer(''save'', ''mydb.digests_prev'', NULL);\n"
  "             > \\\"\"\n"
  "             Every 60.0s: mysql sys --table -e \"                                                                                                   ...  Mon Dec 22 10:58:51 2014\n"
  "             +----------------------------------+\n"
  "             | Next Output                      |\n"
  "             +----------------------------------+\n"
  "             | Top 10 Queries Using Custom View |\n"
  "             +----------------------------------+\n"
  "             +-------------------+-------+------------+---------------+-------------+---------------+-------------------+-------------------+----------------------------------+\n"
  "             | query             | db    | exec_count | total_latency | avg_latency | rows_sent_avg | rows_examined_avg | rows_affected_avg | digest                           |\n"
  "             +-------------------+-------+------------+---------------+-------------+---------------+-------------------+-------------------+----------------------------------+\n"
  "             ...\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    CONTAINS SQL\n"
  "BEGIN\n"
  "    DECLARE v_table_exists, v_tmp_digests_table_exists, v_custom_view_exists ENUM('', 'BASE TABLE', 'VIEW', 'TEMPORARY') DEFAULT '';\n"
  "    DECLARE v_this_thread_enabled ENUM('YES', 'NO');\n"
  "    DECLARE v_force_new_snapshot BOOLEAN DEFAULT FALSE;\n"
  "    DECLARE v_digests_table VARCHAR(133);\n"
  "    DECLARE v_quoted_table, v_quoted_custom_view VARCHAR(133) DEFAULT '';\n"
  "    DECLARE v_table_db, v_table_name, v_custom_db, v_custom_name VARCHAR(64);\n"
  "    DECLARE v_digest_table_template, v_checksum_ref, v_checksum_table text;\n"
  "    DECLARE v_sql longtext;\n"
  "    DECLARE v_error_msg VARCHAR(128);\n"
  "    SELECT INSTRUMENTED INTO v_this_thread_enabled FROM performance_schema.threads WHERE PROCESSLIST_ID = CONNECTION_ID();\n"
  "    IF (v_this_thread_enabled = 'YES') THEN\n"
  "        CALL sys.ps_setup_disable_thread(CONNECTION_ID());\n"
  "    END IF;\n"
  "    SET @log_bin := @@sql_log_bin;\n"
  "    IF (@log_bin = 1) THEN\n"
  "        SET sql_log_bin = 0;\n"
  "    END IF;\n"
  "    IF (@sys.statement_performance_analyzer.limit IS NULL) THEN\n"
  "        SET @sys.statement_performance_analyzer.limit = sys.sys_get_config('statement_performance_analyzer.limit', '100');\n"
  "    END IF;\n"
  "    IF (@sys.debug IS NULL) THEN\n"
  "        SET @sys.debug                                = sys.sys_get_config('debug'                               , 'OFF');\n"
  "    END IF;\n"
  "    IF (in_table = 'NOW()') THEN\n"
  "        SET v_force_new_snapshot = TRUE,\n"
  "            in_table             = NULL;\n"
  "    ELSEIF (in_table IS NOT NULL) THEN\n"
  "        IF (NOT INSTR(in_table, '.')) THEN\n"
  "            SET v_table_db   = DATABASE(),\n"
  "                v_table_name = in_table;\n"
  "        ELSE\n"
  "            SET v_table_db   = SUBSTRING_INDEX(in_table, '.', 1);\n"
  "            SET v_table_name = SUBSTRING(in_table, CHAR_LENGTH(v_table_db)+2);\n"
  "        END IF;\n"
  "        SET v_quoted_table = CONCAT('`', v_table_db, '`.`', v_table_name, '`');\n"
  "        IF (@sys.debug = 'ON') THEN\n"
  "            SELECT CONCAT('in_table is: db = ''', v_table_db, ''', table = ''', v_table_name, '''') AS 'Debug';\n"
  "        END IF;\n"
  "        IF (v_table_db = DATABASE() AND (v_table_name = 'tmp_digests' OR v_table_name = 'tmp_digests_delta')) THEN\n"
  "            SET v_error_msg = CONCAT('Invalid value for in_table: ', v_quoted_table, ' is reserved table name.');\n"
  "            SIGNAL SQLSTATE '45000'\n"
  "               SET MESSAGE_TEXT = v_error_msg;\n"
  "        END IF;\n"
  "        CALL sys.table_exists(v_table_db, v_table_name, v_table_exists);\n"
  "        IF (@sys.debug = 'ON') THEN\n"
  "            SELECT CONCAT('v_table_exists = ', v_table_exists) AS 'Debug';\n"
  "        END IF;\n"
  "        IF (v_table_exists = 'BASE TABLE') THEN\n"
  "            SET v_checksum_ref = (\n"
  "                 SELECT GROUP_CONCAT(CONCAT(COLUMN_NAME, COLUMN_TYPE) ORDER BY ORDINAL_POSITION) AS Checksum\n"
  "                   FROM information_schema.COLUMNS\n"
  "                  WHERE TABLE_SCHEMA = 'performance_schema' AND TABLE_NAME = 'events_statements_summary_by_digest'\n"
  "                ),\n"
  "                v_checksum_table = (\n"
  "                 SELECT GROUP_CONCAT(CONCAT(COLUMN_NAME, COLUMN_TYPE) ORDER BY ORDINAL_POSITION) AS Checksum\n"
  "                   FROM information_schema.COLUMNS\n"
  "                  WHERE TABLE_SCHEMA = v_table_db AND TABLE_NAME = v_table_name\n"
  "                );\n"
  "            IF (v_checksum_ref <> v_checksum_table) THEN\n"
  "                SET v_error_msg = CONCAT('The table ',\n"
  "                                         IF(CHAR_LENGTH(v_quoted_table) > 93, CONCAT('...', SUBSTRING(v_quoted_table, -90)), v_quoted_table),\n"
  "                                         ' has the wrong definition.');\n"
  "                SIGNAL SQLSTATE '45000'\n"
  "                   SET MESSAGE_TEXT = v_error_msg;\n"
  "            END IF;\n"
  "        END IF;\n"
  "    END IF;\n"
  "    IF (in_views IS NULL OR in_views = '') THEN\n"
  "        SET in_views = 'with_runtimes_in_95th_percentile,analysis,with_errors_or_warnings,with_full_table_scans,with_sorting,with_temp_tables';\n"
  "    END IF;\n"
  "    CALL sys.table_exists(DATABASE(), 'tmp_digests', v_tmp_digests_table_exists);\n"
  "    IF (@sys.debug = 'ON') THEN\n"
  "        SELECT CONCAT('v_tmp_digests_table_exists = ', v_tmp_digests_table_exists) AS 'Debug';\n"
  "    END IF;\n"
  "    CASE\n"
  "        WHEN in_action IN ('snapshot', 'overall') THEN\n"
  "            IF (in_table IS NOT NULL) THEN\n"
  "                IF (NOT v_table_exists IN ('TEMPORARY', 'BASE TABLE')) THEN\n"
  "                    SET v_error_msg = CONCAT('The ', in_action, ' action requires in_table to be NULL, NOW() or specify an existing table.',\n"
  "                                             ' The table ',\n"
  "                                             IF(CHAR_LENGTH(v_quoted_table) > 16, CONCAT('...', SUBSTRING(v_quoted_table, -13)), v_quoted_table),\n"
  "                                             ' does not exist.');\n"
  "                    SIGNAL SQLSTATE '45000'\n"
  "                       SET MESSAGE_TEXT = v_error_msg;\n"
  "                END IF;\n"
  "            END IF;\n"
  "        WHEN in_action IN ('delta', 'save') THEN\n"
  "            IF (v_table_exists NOT IN ('TEMPORARY', 'BASE TABLE')) THEN\n"
  "                SET v_error_msg = CONCAT('The ', in_action, ' action requires in_table to be an existing table.',\n"
  "                                         IF(in_table IS NOT NULL, CONCAT(' The table ',\n"
  "                                             IF(CHAR_LENGTH(v_quoted_table) > 39, CONCAT('...', SUBSTRING(v_quoted_table, -36)), v_quoted_table),\n"
  "                                             ' does not exist.'), ''));\n"
  "                SIGNAL SQLSTATE '45000'\n"
  "                   SET MESSAGE_TEXT = v_error_msg;\n"
  "            END IF;\n"
  "            IF (in_action = 'delta' AND v_tmp_digests_table_exists <> 'TEMPORARY') THEN\n"
  "                SIGNAL SQLSTATE '45000'\n"
  "                   SET MESSAGE_TEXT = 'An existing snapshot generated with the statement_performance_analyzer() must exist.';\n"
  "            END IF;\n"
  "        WHEN in_action = 'create_tmp' THEN\n"
  "            IF (v_table_exists = 'TEMPORARY') THEN\n"
  "                SET v_error_msg = CONCAT('Cannot create the table ',\n"
  "                                         IF(CHAR_LENGTH(v_quoted_table) > 72, CONCAT('...', SUBSTRING(v_quoted_table, -69)), v_quoted_table),\n"
  "                                         ' as it already exists.');\n"
  "                SIGNAL SQLSTATE '45000'\n"
  "                   SET MESSAGE_TEXT = v_error_msg;\n"
  "            END IF;\n"
  "        WHEN in_action = 'create_table' THEN\n"
  "            IF (v_table_exists <> '') THEN\n"
  "                SET v_error_msg = CONCAT('Cannot create the table ',\n"
  "                                         IF(CHAR_LENGTH(v_quoted_table) > 52, CONCAT('...', SUBSTRING(v_quoted_table, -49)), v_quoted_table),\n"
  "                                         ' as it already exists',\n"
  "                                         IF(v_table_exists = 'TEMPORARY', ' as a temporary table.', '.'));\n"
  "                SIGNAL SQLSTATE '45000'\n"
  "                   SET MESSAGE_TEXT = v_error_msg;\n"
  "            END IF;\n"
  "        WHEN in_action = 'cleanup' THEN\n"
  "            DO (SELECT 1);\n"
  "        ELSE\n"
  "            SIGNAL SQLSTATE '45000'\n"
  "               SET MESSAGE_TEXT = 'Unknown action. Supported actions are: cleanup, create_table, create_tmp, delta, overall, save, snapshot';\n"
  "    END CASE;\n"
  "    SET v_digest_table_template = 'CREATE %{TEMPORARY}TABLE %{TABLE_NAME} (\n"
  "  `SCHEMA_NAME` varchar(64) DEFAULT NULL,\n"
  "  `DIGEST` varchar(32) DEFAULT NULL,\n"
  "  `DIGEST_TEXT` longtext,\n"
  "  `COUNT_STAR` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_TIMER_WAIT` bigint(20) unsigned NOT NULL,\n"
  "  `MIN_TIMER_WAIT` bigint(20) unsigned NOT NULL,\n"
  "  `AVG_TIMER_WAIT` bigint(20) unsigned NOT NULL,\n"
  "  `MAX_TIMER_WAIT` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_LOCK_TIME` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_ERRORS` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_WARNINGS` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_ROWS_AFFECTED` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_ROWS_SENT` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_ROWS_EXAMINED` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_CREATED_TMP_DISK_TABLES` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_CREATED_TMP_TABLES` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_SELECT_FULL_JOIN` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_SELECT_FULL_RANGE_JOIN` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_SELECT_RANGE` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_SELECT_RANGE_CHECK` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_SELECT_SCAN` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_SORT_MERGE_PASSES` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_SORT_RANGE` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_SORT_ROWS` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_SORT_SCAN` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_NO_INDEX_USED` bigint(20) unsigned NOT NULL,\n"
  "  `SUM_NO_GOOD_INDEX_USED` bigint(20) unsigned NOT NULL,\n"
  "  `FIRST_SEEN` timestamp NULL DEFAULT NULL,\n"
  "  `LAST_SEEN` timestamp NULL DEFAULT NULL,\n"
  "  INDEX (SCHEMA_NAME, DIGEST)\n"
  ") DEFAULT CHARSET=utf8';\n"
  "    IF (v_force_new_snapshot\n"
  "           OR in_action = 'snapshot'\n"
  "           OR (in_action = 'overall' AND in_table IS NULL)\n"
  "           OR (in_action = 'save' AND v_tmp_digests_table_exists <> 'TEMPORARY')\n"
  "       ) THEN\n"
  "        IF (v_tmp_digests_table_exists = 'TEMPORARY') THEN\n"
  "            IF (@sys.debug = 'ON') THEN\n"
  "                SELECT 'DROP TEMPORARY TABLE IF EXISTS tmp_digests' AS 'Debug';\n"
  "            END IF;\n"
  "            DROP TEMPORARY TABLE IF EXISTS tmp_digests;\n"
  "        END IF;\n"
  "        CALL sys.execute_prepared_stmt(REPLACE(REPLACE(v_digest_table_template, '%{TEMPORARY}', 'TEMPORARY '), '%{TABLE_NAME}', 'tmp_digests'));\n"
  "        SET v_sql = CONCAT('INSERT INTO tmp_digests SELECT * FROM ',\n"
  "                           IF(in_table IS NULL OR in_action = 'save', 'performance_schema.events_statements_summary_by_digest', v_quoted_table));\n"
  "        CALL sys.execute_prepared_stmt(v_sql);\n"
  "    END IF;\n"
  "    IF (in_action IN ('create_table', 'create_tmp')) THEN\n"
  "        IF (in_action = 'create_table') THEN\n"
  "            CALL sys.execute_prepared_stmt(REPLACE(REPLACE(v_digest_table_template, '%{TEMPORARY}', ''), '%{TABLE_NAME}', v_quoted_table));\n"
  "        ELSE\n"
  "            CALL sys.execute_prepared_stmt(REPLACE(REPLACE(v_digest_table_template, '%{TEMPORARY}', 'TEMPORARY '), '%{TABLE_NAME}', v_quoted_table));\n"
  "        END IF;\n"
  "    ELSEIF (in_action = 'save') THEN\n"
  "        CALL sys.execute_prepared_stmt(CONCAT('DELETE FROM ', v_quoted_table));\n"
  "        CALL sys.execute_prepared_stmt(CONCAT('INSERT INTO ', v_quoted_table, ' SELECT * FROM tmp_digests'));\n"
  "    ELSEIF (in_action = 'cleanup') THEN\n"
  "        DROP TEMPORARY TABLE IF EXISTS sys.tmp_digests;\n"
  "        DROP TEMPORARY TABLE IF EXISTS sys.tmp_digests_delta;\n"
  "    ELSEIF (in_action IN ('overall', 'delta')) THEN\n"
  "        IF (in_action = 'overall') THEN\n"
  "            IF (in_table IS NULL) THEN\n"
  "                SET v_digests_table = 'tmp_digests';\n"
  "            ELSE\n"
  "                SET v_digests_table = v_quoted_table;\n"
  "            END IF;\n"
  "        ELSE\n"
  "            SET v_digests_table = 'tmp_digests_delta';\n"
  "            DROP TEMPORARY TABLE IF EXISTS tmp_digests_delta;\n"
  "            CREATE TEMPORARY TABLE tmp_digests_delta LIKE tmp_digests;\n"
  "            SET v_sql = CONCAT('INSERT INTO tmp_digests_delta\n"
  "SELECT `d_end`.`SCHEMA_NAME`,\n"
  "       `d_end`.`DIGEST`,\n"
  "       `d_end`.`DIGEST_TEXT`,\n"
  "       `d_end`.`COUNT_STAR`-IFNULL(`d_start`.`COUNT_STAR`, 0) AS ''COUNT_STAR'',\n"
  "       `d_end`.`SUM_TIMER_WAIT`-IFNULL(`d_start`.`SUM_TIMER_WAIT`, 0) AS ''SUM_TIMER_WAIT'',\n"
  "       `d_end`.`MIN_TIMER_WAIT` AS ''MIN_TIMER_WAIT'',\n"
  "       IFNULL((`d_end`.`SUM_TIMER_WAIT`-IFNULL(`d_start`.`SUM_TIMER_WAIT`, 0))/NULLIF(`d_end`.`COUNT_STAR`-IFNULL(`d_start`.`COUNT_STAR`, 0), 0), 0) AS ''AVG_TIMER_WAIT'',\n"
  "       `d_end`.`MAX_TIMER_WAIT` AS ''MAX_TIMER_WAIT'',\n"
  "       `d_end`.`SUM_LOCK_TIME`-IFNULL(`d_start`.`SUM_LOCK_TIME`, 0) AS ''SUM_LOCK_TIME'',\n"
  "       `d_end`.`SUM_ERRORS`-IFNULL(`d_start`.`SUM_ERRORS`, 0) AS ''SUM_ERRORS'',\n"
  "       `d_end`.`SUM_WARNINGS`-IFNULL(`d_start`.`SUM_WARNINGS`, 0) AS ''SUM_WARNINGS'',\n"
  "       `d_end`.`SUM_ROWS_AFFECTED`-IFNULL(`d_start`.`SUM_ROWS_AFFECTED`, 0) AS ''SUM_ROWS_AFFECTED'',\n"
  "       `d_end`.`SUM_ROWS_SENT`-IFNULL(`d_start`.`SUM_ROWS_SENT`, 0) AS ''SUM_ROWS_SENT'',\n"
  "       `d_end`.`SUM_ROWS_EXAMINED`-IFNULL(`d_start`.`SUM_ROWS_EXAMINED`, 0) AS ''SUM_ROWS_EXAMINED'',\n"
  "       `d_end`.`SUM_CREATED_TMP_DISK_TABLES`-IFNULL(`d_start`.`SUM_CREATED_TMP_DISK_TABLES`, 0) AS ''SUM_CREATED_TMP_DISK_TABLES'',\n"
  "       `d_end`.`SUM_CREATED_TMP_TABLES`-IFNULL(`d_start`.`SUM_CREATED_TMP_TABLES`, 0) AS ''SUM_CREATED_TMP_TABLES'',\n"
  "       `d_end`.`SUM_SELECT_FULL_JOIN`-IFNULL(`d_start`.`SUM_SELECT_FULL_JOIN`, 0) AS ''SUM_SELECT_FULL_JOIN'',\n"
  "       `d_end`.`SUM_SELECT_FULL_RANGE_JOIN`-IFNULL(`d_start`.`SUM_SELECT_FULL_RANGE_JOIN`, 0) AS ''SUM_SELECT_FULL_RANGE_JOIN'',\n"
  "       `d_end`.`SUM_SELECT_RANGE`-IFNULL(`d_start`.`SUM_SELECT_RANGE`, 0) AS ''SUM_SELECT_RANGE'',\n"
  "       `d_end`.`SUM_SELECT_RANGE_CHECK`-IFNULL(`d_start`.`SUM_SELECT_RANGE_CHECK`, 0) AS ''SUM_SELECT_RANGE_CHECK'',\n"
  "       `d_end`.`SUM_SELECT_SCAN`-IFNULL(`d_start`.`SUM_SELECT_SCAN`, 0) AS ''SUM_SELECT_SCAN'',\n"
  "       `d_end`.`SUM_SORT_MERGE_PASSES`-IFNULL(`d_start`.`SUM_SORT_MERGE_PASSES`, 0) AS ''SUM_SORT_MERGE_PASSES'',\n"
  "       `d_end`.`SUM_SORT_RANGE`-IFNULL(`d_start`.`SUM_SORT_RANGE`, 0) AS ''SUM_SORT_RANGE'',\n"
  "       `d_end`.`SUM_SORT_ROWS`-IFNULL(`d_start`.`SUM_SORT_ROWS`, 0) AS ''SUM_SORT_ROWS'',\n"
  "       `d_end`.`SUM_SORT_SCAN`-IFNULL(`d_start`.`SUM_SORT_SCAN`, 0) AS ''SUM_SORT_SCAN'',\n"
  "       `d_end`.`SUM_NO_INDEX_USED`-IFNULL(`d_start`.`SUM_NO_INDEX_USED`, 0) AS ''SUM_NO_INDEX_USED'',\n"
  "       `d_end`.`SUM_NO_GOOD_INDEX_USED`-IFNULL(`d_start`.`SUM_NO_GOOD_INDEX_USED`, 0) AS ''SUM_NO_GOOD_INDEX_USED'',\n"
  "       `d_end`.`FIRST_SEEN`,\n"
  "       `d_end`.`LAST_SEEN`\n"
  "  FROM tmp_digests d_end\n"
  "       LEFT OUTER JOIN ', v_quoted_table, ' d_start ON `d_start`.`DIGEST` = `d_end`.`DIGEST`\n"
  "                                                    AND (`d_start`.`SCHEMA_NAME` = `d_end`.`SCHEMA_NAME`\n"
  "                                                          OR (`d_start`.`SCHEMA_NAME` IS NULL AND `d_end`.`SCHEMA_NAME` IS NULL)\n"
  "                                                        )\n"
  " WHERE `d_end`.`COUNT_STAR`-IFNULL(`d_start`.`COUNT_STAR`, 0) > 0');\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "        END IF;\n"
  "        IF (FIND_IN_SET('with_runtimes_in_95th_percentile', in_views)) THEN\n"
  "            SELECT 'Queries with Runtime in 95th Percentile' AS 'Next Output';\n"
  "            DROP TEMPORARY TABLE IF EXISTS tmp_digest_avg_latency_distribution1;\n"
  "            DROP TEMPORARY TABLE IF EXISTS tmp_digest_avg_latency_distribution2;\n"
  "            DROP TEMPORARY TABLE IF EXISTS tmp_digest_95th_percentile_by_avg_us;\n"
  "            CREATE TEMPORARY TABLE tmp_digest_avg_latency_distribution1 (\n"
  "              cnt bigint unsigned NOT NULL,\n"
  "              avg_us decimal(21,0) NOT NULL,\n"
  "              PRIMARY KEY (avg_us)\n"
  "            ) ENGINE=InnoDB;\n"
  "            SET v_sql = CONCAT('INSERT INTO tmp_digest_avg_latency_distribution1\n"
  "SELECT COUNT(*) cnt,\n"
  "       ROUND(avg_timer_wait/1000000) AS avg_us\n"
  "  FROM ', v_digests_table, '\n"
  " GROUP BY avg_us');\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "            CREATE TEMPORARY TABLE tmp_digest_avg_latency_distribution2 LIKE tmp_digest_avg_latency_distribution1;\n"
  "            INSERT INTO tmp_digest_avg_latency_distribution2 SELECT * FROM tmp_digest_avg_latency_distribution1;\n"
  "            CREATE TEMPORARY TABLE tmp_digest_95th_percentile_by_avg_us (\n"
  "              avg_us decimal(21,0) NOT NULL,\n"
  "              percentile decimal(46,4) NOT NULL,\n"
  "              PRIMARY KEY (avg_us)\n"
  "            ) ENGINE=InnoDB;\n"
  "            SET v_sql = CONCAT('INSERT INTO tmp_digest_95th_percentile_by_avg_us\n"
  "SELECT s2.avg_us avg_us,\n"
  "       IFNULL(SUM(s1.cnt)/NULLIF((SELECT COUNT(*) FROM ', v_digests_table, '), 0), 0) percentile\n"
  "  FROM tmp_digest_avg_latency_distribution1 AS s1\n"
  "       JOIN tmp_digest_avg_latency_distribution2 AS s2 ON s1.avg_us <= s2.avg_us\n"
  " GROUP BY s2.avg_us\n"
  "HAVING percentile > 0.95\n"
  " ORDER BY percentile\n"
  " LIMIT 1');\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "            SET v_sql =\n"
  "                REPLACE(\n"
  "                    REPLACE(\n"
  "                        (SELECT VIEW_DEFINITION\n"
  "                           FROM information_schema.VIEWS\n"
  "                          WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'statements_with_runtimes_in_95th_percentile'\n"
  "                        ),\n"
  "                        '`performance_schema`.`events_statements_summary_by_digest`',\n"
  "                        v_digests_table\n"
  "                    ),\n"
  "                    'sys.x$ps_digest_95th_percentile_by_avg_us',\n"
  "                    '`sys`.`x$ps_digest_95th_percentile_by_avg_us`'\n"
  "              );\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "            DROP TEMPORARY TABLE tmp_digest_avg_latency_distribution1;\n"
  "            DROP TEMPORARY TABLE tmp_digest_avg_latency_distribution2;\n"
  "            DROP TEMPORARY TABLE tmp_digest_95th_percentile_by_avg_us;\n"
  "        END IF;\n"
  "        IF (FIND_IN_SET('analysis', in_views)) THEN\n"
  "            SELECT CONCAT('Top ', @sys.statement_performance_analyzer.limit, ' Queries Ordered by Total Latency') AS 'Next Output';\n"
  "            SET v_sql =\n"
  "                REPLACE(\n"
  "                    (SELECT VIEW_DEFINITION\n"
  "                       FROM information_schema.VIEWS\n"
  "                      WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'statement_analysis'\n"
  "                    ),\n"
  "                    '`performance_schema`.`events_statements_summary_by_digest`',\n"
  "                    v_digests_table\n"
  "                );\n"
  "            IF (@sys.statement_performance_analyzer.limit > 0) THEN\n"
  "                SET v_sql = CONCAT(v_sql, ' LIMIT ', @sys.statement_performance_analyzer.limit);\n"
  "            END IF;\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "        END IF;\n"
  "        IF (FIND_IN_SET('with_errors_or_warnings', in_views)) THEN\n"
  "            SELECT CONCAT('Top ', @sys.statement_performance_analyzer.limit, ' Queries with Errors') AS 'Next Output';\n"
  "            SET v_sql =\n"
  "                REPLACE(\n"
  "                    (SELECT VIEW_DEFINITION\n"
  "                       FROM information_schema.VIEWS\n"
  "                      WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'statements_with_errors_or_warnings'\n"
  "                    ),\n"
  "                    '`performance_schema`.`events_statements_summary_by_digest`',\n"
  "                    v_digests_table\n"
  "                );\n"
  "            IF (@sys.statement_performance_analyzer.limit > 0) THEN\n"
  "                SET v_sql = CONCAT(v_sql, ' LIMIT ', @sys.statement_performance_analyzer.limit);\n"
  "            END IF;\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "        END IF;\n"
  "        IF (FIND_IN_SET('with_full_table_scans', in_views)) THEN\n"
  "            SELECT CONCAT('Top ', @sys.statement_performance_analyzer.limit, ' Queries with Full Table Scan') AS 'Next Output';\n"
  "            SET v_sql =\n"
  "                REPLACE(\n"
  "                    (SELECT VIEW_DEFINITION\n"
  "                       FROM information_schema.VIEWS\n"
  "                      WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'statements_with_full_table_scans'\n"
  "                    ),\n"
  "                    '`performance_schema`.`events_statements_summary_by_digest`',\n"
  "                    v_digests_table\n"
  "                );\n"
  "            IF (@sys.statement_performance_analyzer.limit > 0) THEN\n"
  "                SET v_sql = CONCAT(v_sql, ' LIMIT ', @sys.statement_performance_analyzer.limit);\n"
  "            END IF;\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "        END IF;\n"
  "        IF (FIND_IN_SET('with_sorting', in_views)) THEN\n"
  "            SELECT CONCAT('Top ', @sys.statement_performance_analyzer.limit, ' Queries with Sorting') AS 'Next Output';\n"
  "            SET v_sql =\n"
  "                REPLACE(\n"
  "                    (SELECT VIEW_DEFINITION\n"
  "                       FROM information_schema.VIEWS\n"
  "                      WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'statements_with_sorting'\n"
  "                    ),\n"
  "                    '`performance_schema`.`events_statements_summary_by_digest`',\n"
  "                    v_digests_table\n"
  "                );\n"
  "            IF (@sys.statement_performance_analyzer.limit > 0) THEN\n"
  "                SET v_sql = CONCAT(v_sql, ' LIMIT ', @sys.statement_performance_analyzer.limit);\n"
  "            END IF;\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "        END IF;\n"
  "        IF (FIND_IN_SET('with_temp_tables', in_views)) THEN\n"
  "            SELECT CONCAT('Top ', @sys.statement_performance_analyzer.limit, ' Queries with Internal Temporary Tables') AS 'Next Output';\n"
  "            SET v_sql =\n"
  "                REPLACE(\n"
  "                    (SELECT VIEW_DEFINITION\n"
  "                       FROM information_schema.VIEWS\n"
  "                      WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'statements_with_temp_tables'\n"
  "                    ),\n"
  "                    '`performance_schema`.`events_statements_summary_by_digest`',\n"
  "                    v_digests_table\n"
  "                );\n"
  "            IF (@sys.statement_performance_analyzer.limit > 0) THEN\n"
  "                SET v_sql = CONCAT(v_sql, ' LIMIT ', @sys.statement_performance_analyzer.limit);\n"
  "            END IF;\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "        END IF;\n"
  "        IF (FIND_IN_SET('custom', in_views)) THEN\n"
  "            SELECT CONCAT('Top ', @sys.statement_performance_analyzer.limit, ' Queries Using Custom View') AS 'Next Output';\n"
  "            IF (@sys.statement_performance_analyzer.view IS NULL) THEN\n"
  "                SET @sys.statement_performance_analyzer.view = sys.sys_get_config('statement_performance_analyzer.view', NULL);\n"
  "            END IF;\n"
  "            IF (@sys.statement_performance_analyzer.view IS NULL) THEN\n"
  "                SIGNAL SQLSTATE '45000'\n"
  "                   SET MESSAGE_TEXT = 'The @sys.statement_performance_analyzer.view user variable must be set with the view or query to use.';\n"
  "            END IF;\n"
  "            IF (NOT INSTR(@sys.statement_performance_analyzer.view, ' ')) THEN\n"
  "                IF (NOT INSTR(@sys.statement_performance_analyzer.view, '.')) THEN\n"
  "                    SET v_custom_db   = DATABASE(),\n"
  "                        v_custom_name = @sys.statement_performance_analyzer.view;\n"
  "                ELSE\n"
  "                    SET v_custom_db   = SUBSTRING_INDEX(@sys.statement_performance_analyzer.view, '.', 1);\n"
  "                    SET v_custom_name = SUBSTRING(@sys.statement_performance_analyzer.view, CHAR_LENGTH(v_custom_db)+2);\n"
  "                END IF;\n"
  "                CALL sys.table_exists(v_custom_db, v_custom_name, v_custom_view_exists);\n"
  "                IF (v_custom_view_exists <> 'VIEW') THEN\n"
  "                    SIGNAL SQLSTATE '45000'\n"
  "                       SET MESSAGE_TEXT = 'The @sys.statement_performance_analyzer.view user variable is set but specified neither an existing view nor a query.';\n"
  "                END IF;\n"
  "                SET v_sql =\n"
  "                    REPLACE(\n"
  "                        (SELECT VIEW_DEFINITION\n"
  "                           FROM information_schema.VIEWS\n"
  "                          WHERE TABLE_SCHEMA = v_custom_db AND TABLE_NAME = v_custom_name\n"
  "                        ),\n"
  "                        '`performance_schema`.`events_statements_summary_by_digest`',\n"
  "                        v_digests_table\n"
  "                    );\n"
  "            ELSE\n"
  "                SET v_sql = REPLACE(@sys.statement_performance_analyzer.view, '`performance_schema`.`events_statements_summary_by_digest`', v_digests_table);\n"
  "            END IF;\n"
  "            IF (@sys.statement_performance_analyzer.limit > 0) THEN\n"
  "                SET v_sql = CONCAT(v_sql, ' LIMIT ', @sys.statement_performance_analyzer.limit);\n"
  "            END IF;\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "        END IF;\n"
  "    END IF;\n"
  "    IF (v_this_thread_enabled = 'YES') THEN\n"
  "        CALL sys.ps_setup_enable_thread(CONNECTION_ID());\n"
  "    END IF;\n"
  "    IF (@log_bin = 1) THEN\n"
  "        SET sql_log_bin = @log_bin;\n"
  "    END IF;\n"
  "END$$\n",
"DELIMITER ;\n",
"DROP PROCEDURE IF EXISTS table_exists;\n",
"DELIMITER $$\n",
"CREATE DEFINER='mariadb.sys'@'localhost' PROCEDURE table_exists (\n"
  "        IN in_db VARCHAR(64), IN in_table VARCHAR(64),\n"
  "        OUT out_exists ENUM('', 'BASE TABLE', 'VIEW', 'TEMPORARY', 'SEQUENCE', 'SYSTEM VIEW', 'TEMPORARY SEQUENCE')\n"
  "    )\n"
  "    COMMENT '\n"
  "             Description\n"
  "             Tests whether the table specified in in_db and in_table exists either as a regular\n"
  "             table, or as a temporary table. The returned value corresponds to the table that\n"
  "             will be used, so if there''s both a temporary and a permanent table with the given\n"
  "             name, then ''TEMPORARY'' will be returned.\n"
  "             Parameters\n"
  "             in_db (VARCHAR(64)):\n"
  "               The database name to check for the existence of the table in.\n"
  "             in_table (VARCHAR(64)):\n"
  "               The name of the table to check the existence of.\n"
  "             out_exists ENUM('''', ''BASE TABLE'', ''VIEW'', ''TEMPORARY'', ''SEQUENCE'', ''SYSTEM VIEW'', ''TEMPORARY SEQUENCE''):\n"
  "               The return value: whether the table exists. The value is one of:\n"
  "                 * ''''                    - the table does not exist neither as a base table, view, sequence nor temporary table/sequence.\n"
  "                 * ''BASE TABLE''          - the table name exists as a permanent base table table.\n"
  "                 * ''VIEW''                - the table name exists as a view.\n"
  "                 * ''TEMPORARY''           - the table name exists as a temporary table.\n"
  "                 * ''SEQUENCE''            - the table name exists as a sequence.\n"
  "                 * ''SYSTEM VIEW''         - the table name exists as a system view.\n"
  "                 * ''TEMPORARY SEQUENCE''  - the table name exists as a temporary sequence.\n"
  "             Example\n"
  "             MariaDB [sys]> CREATE DATABASE db1;\n"
  "             Query OK, 1 row affected (0.07 sec)\n"
  "             MariaDB [sys]> use db1;\n"
  "             Database changed\n"
  "             MariaDB [sys]> CREATE TABLE t1 (id INT PRIMARY KEY);\n"
  "             Query OK, 0 rows affected (0.08 sec)\n"
  "             MariaDB [sys]> CREATE TABLE t2 (id INT PRIMARY KEY);\n"
  "             Query OK, 0 rows affected (0.08 sec)\n"
  "             MariaDB [sys]> CREATE view v_t1 AS SELECT * FROM t1;\n"
  "             Query OK, 0 rows affected (0.00 sec)\n"
  "             MariaDB [sys]> CREATE TEMPORARY TABLE t1 (id INT PRIMARY KEY);\n"
  "             Query OK, 0 rows affected (0.00 sec)\n"
  "             MariaDB [sys]> CREATE SEQUENCE s;\n"
  "             Query OK, 0 rows affected (0.00 sec)\n"
  "             MariaDB [sys]> CREATE TEMPORARY SEQUENCE s_temp;\n"
  "             Query OK, 0 rows affected (0.00 sec)\n"
  "             MariaDB [sys]> CALL sys.table_exists(''db1'', ''t1'', @exists); SELECT @exists;\n"
  "             Query OK, 0 rows affected (0.00 sec)\n"
  "             +------------+\n"
  "             | @exists    |\n"
  "             +------------+\n"
  "             | TEMPORARY  |\n"
  "             +------------+\n"
  "             1 row in set (0.00 sec)\n"
  "             MariaDB [sys]> CALL sys.table_exists(''db1'', ''t2'', @exists); SELECT @exists;\n"
  "             Query OK, 0 rows affected (0.00 sec)\n"
  "             +------------+\n"
  "             | @exists    |\n"
  "             +------------+\n"
  "             | BASE TABLE |\n"
  "             +------------+\n"
  "             1 row in set (0.01 sec)\n"
  "             MariaDB [sys]> CALL sys.table_exists(''db1'', ''v_t1'', @exists); SELECT @exists;\n"
  "             Query OK, 0 rows affected (0.00 sec)\n"
  "             +---------+\n"
  "             | @exists |\n"
  "             +---------+\n"
  "             | VIEW    |\n"
  "             +---------+\n"
  "             1 row in set (0.00 sec)\n"
  "             MariaDB [sys]> CALL sys.table_exists(''db1'', ''s'', @exists); SELECT @exists;\n"
  "             Query OK, 0 rows affected (0.006 sec)\n"
  "             +----------+\n"
  "             | @exists  |\n"
  "             +----------+\n"
  "             | SEQUENCE |\n"
  "             +----------+\n"
  "             1 row in set (0.000 sec)\n"
  "             MariaDB [sys]> CALL table_exists(''information_schema'', ''user_variables'', @exists); SELECT @exists;\n"
  "             Query OK, 0 rows affected (0.003 sec)\n"
  "             +-------------+\n"
  "             | @exists     |\n"
  "             +-------------+\n"
  "             | SYSTEM VIEW |\n"
  "             +-------------+\n"
  "             1 row in set (0.001 sec)\n"
  "             MariaDB [sys]> CALL sys.table_exists(''db1'', ''t3'', @exists); SELECT @exists;\n"
  "             Query OK, 0 rows affected (0.01 sec)\n"
  "             +---------+\n"
  "             | @exists |\n"
  "             +---------+\n"
  "             |         |\n"
  "             +---------+\n"
  "             1 row in set (0.00 sec)\n"
  "             MariaDB [sys]> CALL table_exists(''db1'', ''s_temp'', @exists); SELECT @exists;\n"
  "             Query OK, 0 rows affected (0.003 sec)\n"
  "             +--------------------+\n"
  "             | @exists            |\n"
  "             +--------------------+\n"
  "             | TEMPORARY SEQUENCE |\n"
  "             +--------------------+\n"
  "             1 row in set (0.001 sec)\n"
  "            '\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    CONTAINS SQL\n"
  "BEGIN\n"
  "    DECLARE v_error BOOLEAN DEFAULT FALSE;\n"
  "    DECLARE db_quoted VARCHAR(64);\n"
  "    DECLARE table_quoted VARCHAR(64);\n"
  "    DECLARE v_table_type VARCHAR(30) DEFAULT '';\n"
  "    DECLARE CONTINUE HANDLER FOR 1050 SET v_error = TRUE;\n"
  "    DECLARE CONTINUE HANDLER FOR 1146 SET v_error = TRUE;\n"
  "    SET v_table_type = (SELECT GROUP_CONCAT(TABLE_TYPE) FROM information_schema.TABLES WHERE\n"
  "                            TABLE_SCHEMA = in_db AND TABLE_NAME = in_table);\n"
  "    IF v_table_type LIKE '%,%' THEN\n"
  "        SET out_exists = 'TEMPORARY';\n"
  "    ELSE\n"
  "        IF v_table_type is NULL\n"
  "        THEN\n"
  "            SET v_table_type='';\n"
  "        END IF;\n"
  "        IF v_table_type = 'SYSTEM VERSIONED' THEN\n"
  "            SET out_exists = 'BASE TABLE';\n"
  "        ELSE\n"
  "            SET out_exists = v_table_type;\n"
  "        END IF;\n"
  "    END IF;\n"
  "END$$\n",
"DELIMITER ;\n",
"SET @@sql_log_bin = @sql_log_bin;\n",
"use mysql;\n",
NULL
};
