'use strict';

module.exports = {
	// todo: enable caching. There are too many other issues to verify that
	// caching works correctly.
	cache: false,

	// todo: check coverage on all files not just those included in tests.
	// Enable when
	// https://github.com/istanbuljs/nyc/issues/537#issuecomment-390814662
	// is fixed.
	all: false,

	// Ignore files in vendor/, resources/, and elsewhere.
	include: [ 'src/**/*.js' ],

	// Set the coverage percentage by category thresholds.
	statements: 80,
	branches: 69,
	functions: 80,
	lines: 90,

	// Fail if the coverage is below threshold.
	'check-coverage': true,

	// Work around source maps being included
	// https://github.com/istanbuljs/nyc/issues/847:
	//   Error: ENAMETOOLONG: name too long,
	//   open '.../vagrant/mediawiki/extensions/Popups/src/data:application/json;...'
	// Unfortunately, the reported line numbers appear to be
	// nondeterministic across runs when all is enabled and incorrect when
	// disabled.
	sourceMap: false
};
