/* src/network/utils.rs
 *
 * Copyright 2025 Mission Center Developers
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

use std::path::Path;

use magpie_platform::network::ConnectionKind;

pub fn connection_kind(if_name: &str) -> ConnectionKind {
    if if_name.starts_with("bn") {
        ConnectionKind::Bluetooth
    } else if if_name.starts_with("br") || if_name.starts_with("virbr") {
        ConnectionKind::Bridge
    } else if if_name.starts_with("docker") {
        ConnectionKind::Docker
    } else if if_name.starts_with("eth") || if_name.starts_with("en") {
        ConnectionKind::Wired
    } else if if_name.starts_with("ib") {
        ConnectionKind::InfiniBand
    } else if if_name.starts_with("mp") {
        ConnectionKind::Multipass
    } else if if_name.starts_with("veth") {
        ConnectionKind::Virtual
    } else if if_name.starts_with("vpn") || if_name.starts_with("wg") {
        ConnectionKind::Vpn
    } else if if_name.starts_with("wl") || if_name.starts_with("ww") {
        ConnectionKind::Wireless
    } else if if_name.starts_with("mlan") {
        let path = Path::new("/sys/class/net").join(if_name).join("wireless");
        if path.exists() {
            ConnectionKind::Wireless
        } else {
            ConnectionKind::Other
        }
    } else {
        ConnectionKind::Other
    }
}
