use libc::c_int;

pub struct ProcessManager;

impl magpie_platform::processes::ProcessManager for ProcessManager {
    fn new() -> Self
    where
        Self: Sized,
    {
        Self {}
    }

    fn terminate_processes(&self, pids: Vec<u32>) {
        Self::send_signals(pids, libc::SIGTERM);
    }

    fn kill_processes(&self, pids: Vec<u32>) {
        Self::send_signals(pids, libc::SIGKILL);
    }

    fn interrupt_processes(&self, pids: Vec<u32>) {
        Self::send_signals(pids, libc::SIGINT);
    }

    fn signal_user_one_processes(&self, pids: Vec<u32>) {
        Self::send_signals(pids, libc::SIGUSR1);
    }

    fn signal_user_two_processes(&self, pids: Vec<u32>) {
        Self::send_signals(pids, libc::SIGUSR2);
    }

    fn hangup_processes(&self, pids: Vec<u32>) {
        Self::send_signals(pids, libc::SIGHUP);
    }

    fn continue_processes(&self, pids: Vec<u32>) {
        Self::send_signals(pids, libc::SIGCONT);
    }

    fn suspend_processes(&self, pids: Vec<u32>) {
        Self::send_signals(pids, libc::SIGSTOP);
    }
}

impl ProcessManager {
    fn send_signals(pids: Vec<u32>, signal: c_int) {
        for pid in pids {
            unsafe {
                libc::kill(pid as i32, signal);
            }
        }
    }
}
