// IWYU pragma: private, include "nvim/option_defs.h"

typedef enum {
  kOptInvalid = -1,
  kOptAleph = 0,
  kOptAllowrevins = 1,
  kOptAmbiwidth = 2,
  kOptArabic = 3,
  kOptArabicshape = 4,
  kOptAutochdir = 5,
  kOptAutocomplete = 6,
  kOptAutocompletedelay = 7,
  kOptAutocompletetimeout = 8,
  kOptAutoindent = 9,
  kOptAutoread = 10,
  kOptAutowrite = 11,
  kOptAutowriteall = 12,
  kOptBackground = 13,
  kOptBackspace = 14,
  kOptBackup = 15,
  kOptBackupcopy = 16,
  kOptBackupdir = 17,
  kOptBackupext = 18,
  kOptBackupskip = 19,
  kOptBelloff = 20,
  kOptBinary = 21,
  kOptBomb = 22,
  kOptBreakat = 23,
  kOptBreakindent = 24,
  kOptBreakindentopt = 25,
  kOptBrowsedir = 26,
  kOptBufhidden = 27,
  kOptBuflisted = 28,
  kOptBuftype = 29,
  kOptBusy = 30,
  kOptCasemap = 31,
  kOptCdhome = 32,
  kOptCdpath = 33,
  kOptCedit = 34,
  kOptChannel = 35,
  kOptCharconvert = 36,
  kOptChistory = 37,
  kOptCindent = 38,
  kOptCinkeys = 39,
  kOptCinoptions = 40,
  kOptCinscopedecls = 41,
  kOptCinwords = 42,
  kOptClipboard = 43,
  kOptCmdheight = 44,
  kOptCmdwinheight = 45,
  kOptColorcolumn = 46,
  kOptColumns = 47,
  kOptComments = 48,
  kOptCommentstring = 49,
  kOptCompatible = 50,
  kOptComplete = 51,
  kOptCompletefunc = 52,
  kOptCompleteitemalign = 53,
  kOptCompleteopt = 54,
  kOptCompleteslash = 55,
  kOptCompletetimeout = 56,
  kOptConcealcursor = 57,
  kOptConceallevel = 58,
  kOptConfirm = 59,
  kOptCopyindent = 60,
  kOptCpoptions = 61,
  kOptCursorbind = 62,
  kOptCursorcolumn = 63,
  kOptCursorline = 64,
  kOptCursorlineopt = 65,
  kOptDebug = 66,
  kOptDefine = 67,
  kOptDelcombine = 68,
  kOptDictionary = 69,
  kOptDiff = 70,
  kOptDiffanchors = 71,
  kOptDiffexpr = 72,
  kOptDiffopt = 73,
  kOptDigraph = 74,
  kOptDirectory = 75,
  kOptDisplay = 76,
  kOptEadirection = 77,
  kOptEdcompatible = 78,
  kOptEmoji = 79,
  kOptEncoding = 80,
  kOptEndoffile = 81,
  kOptEndofline = 82,
  kOptEqualalways = 83,
  kOptEqualprg = 84,
  kOptErrorbells = 85,
  kOptErrorfile = 86,
  kOptErrorformat = 87,
  kOptEventignore = 88,
  kOptEventignorewin = 89,
  kOptExpandtab = 90,
  kOptExrc = 91,
  kOptFileencoding = 92,
  kOptFileencodings = 93,
  kOptFileformat = 94,
  kOptFileformats = 95,
  kOptFileignorecase = 96,
  kOptFiletype = 97,
  kOptFillchars = 98,
  kOptFindfunc = 99,
  kOptFixendofline = 100,
  kOptFoldclose = 101,
  kOptFoldcolumn = 102,
  kOptFoldenable = 103,
  kOptFoldexpr = 104,
  kOptFoldignore = 105,
  kOptFoldlevel = 106,
  kOptFoldlevelstart = 107,
  kOptFoldmarker = 108,
  kOptFoldmethod = 109,
  kOptFoldminlines = 110,
  kOptFoldnestmax = 111,
  kOptFoldopen = 112,
  kOptFoldtext = 113,
  kOptFormatexpr = 114,
  kOptFormatlistpat = 115,
  kOptFormatoptions = 116,
  kOptFormatprg = 117,
  kOptFsync = 118,
  kOptGdefault = 119,
  kOptGrepformat = 120,
  kOptGrepprg = 121,
  kOptGuicursor = 122,
  kOptGuifont = 123,
  kOptGuifontwide = 124,
  kOptGuioptions = 125,
  kOptGuitablabel = 126,
  kOptGuitabtooltip = 127,
  kOptHelpfile = 128,
  kOptHelpheight = 129,
  kOptHelplang = 130,
  kOptHidden = 131,
  kOptHighlight = 132,
  kOptHistory = 133,
  kOptHkmap = 134,
  kOptHkmapp = 135,
  kOptHlsearch = 136,
  kOptIcon = 137,
  kOptIconstring = 138,
  kOptIgnorecase = 139,
  kOptImcmdline = 140,
  kOptImdisable = 141,
  kOptIminsert = 142,
  kOptImsearch = 143,
  kOptInccommand = 144,
  kOptInclude = 145,
  kOptIncludeexpr = 146,
  kOptIncsearch = 147,
  kOptIndentexpr = 148,
  kOptIndentkeys = 149,
  kOptInfercase = 150,
  kOptInsertmode = 151,
  kOptIsfname = 152,
  kOptIsident = 153,
  kOptIskeyword = 154,
  kOptIsprint = 155,
  kOptJoinspaces = 156,
  kOptJumpoptions = 157,
  kOptKeymap = 158,
  kOptKeymodel = 159,
  kOptKeywordprg = 160,
  kOptLangmap = 161,
  kOptLangmenu = 162,
  kOptLangnoremap = 163,
  kOptLangremap = 164,
  kOptLaststatus = 165,
  kOptLazyredraw = 166,
  kOptLhistory = 167,
  kOptLinebreak = 168,
  kOptLines = 169,
  kOptLinespace = 170,
  kOptLisp = 171,
  kOptLispoptions = 172,
  kOptLispwords = 173,
  kOptList = 174,
  kOptListchars = 175,
  kOptLoadplugins = 176,
  kOptMagic = 177,
  kOptMakeef = 178,
  kOptMakeencoding = 179,
  kOptMakeprg = 180,
  kOptMatchpairs = 181,
  kOptMatchtime = 182,
  kOptMaxcombine = 183,
  kOptMaxfuncdepth = 184,
  kOptMaxmapdepth = 185,
  kOptMaxmempattern = 186,
  kOptMaxsearchcount = 187,
  kOptMenuitems = 188,
  kOptMessagesopt = 189,
  kOptMkspellmem = 190,
  kOptModeline = 191,
  kOptModelineexpr = 192,
  kOptModelines = 193,
  kOptModifiable = 194,
  kOptModified = 195,
  kOptMore = 196,
  kOptMouse = 197,
  kOptMousefocus = 198,
  kOptMousehide = 199,
  kOptMousemodel = 200,
  kOptMousemoveevent = 201,
  kOptMousescroll = 202,
  kOptMouseshape = 203,
  kOptMousetime = 204,
  kOptNrformats = 205,
  kOptNumber = 206,
  kOptNumberwidth = 207,
  kOptOmnifunc = 208,
  kOptOpendevice = 209,
  kOptOperatorfunc = 210,
  kOptPackpath = 211,
  kOptParagraphs = 212,
  kOptPaste = 213,
  kOptPastetoggle = 214,
  kOptPatchexpr = 215,
  kOptPatchmode = 216,
  kOptPath = 217,
  kOptPreserveindent = 218,
  kOptPreviewheight = 219,
  kOptPreviewwindow = 220,
  kOptPrompt = 221,
  kOptPumblend = 222,
  kOptPumborder = 223,
  kOptPumheight = 224,
  kOptPummaxwidth = 225,
  kOptPumwidth = 226,
  kOptPyxversion = 227,
  kOptQuickfixtextfunc = 228,
  kOptQuoteescape = 229,
  kOptReadonly = 230,
  kOptRedrawdebug = 231,
  kOptRedrawtime = 232,
  kOptRegexpengine = 233,
  kOptRelativenumber = 234,
  kOptRemap = 235,
  kOptReport = 236,
  kOptRevins = 237,
  kOptRightleft = 238,
  kOptRightleftcmd = 239,
  kOptRuler = 240,
  kOptRulerformat = 241,
  kOptRuntimepath = 242,
  kOptScroll = 243,
  kOptScrollback = 244,
  kOptScrollbind = 245,
  kOptScrolljump = 246,
  kOptScrolloff = 247,
  kOptScrollopt = 248,
  kOptSections = 249,
  kOptSecure = 250,
  kOptSelection = 251,
  kOptSelectmode = 252,
  kOptSessionoptions = 253,
  kOptShada = 254,
  kOptShadafile = 255,
  kOptShell = 256,
  kOptShellcmdflag = 257,
  kOptShellpipe = 258,
  kOptShellquote = 259,
  kOptShellredir = 260,
  kOptShellslash = 261,
  kOptShelltemp = 262,
  kOptShellxescape = 263,
  kOptShellxquote = 264,
  kOptShiftround = 265,
  kOptShiftwidth = 266,
  kOptShortmess = 267,
  kOptShowbreak = 268,
  kOptShowcmd = 269,
  kOptShowcmdloc = 270,
  kOptShowfulltag = 271,
  kOptShowmatch = 272,
  kOptShowmode = 273,
  kOptShowtabline = 274,
  kOptSidescroll = 275,
  kOptSidescrolloff = 276,
  kOptSigncolumn = 277,
  kOptSmartcase = 278,
  kOptSmartindent = 279,
  kOptSmarttab = 280,
  kOptSmoothscroll = 281,
  kOptSofttabstop = 282,
  kOptSpell = 283,
  kOptSpellcapcheck = 284,
  kOptSpellfile = 285,
  kOptSpelllang = 286,
  kOptSpelloptions = 287,
  kOptSpellsuggest = 288,
  kOptSplitbelow = 289,
  kOptSplitkeep = 290,
  kOptSplitright = 291,
  kOptStartofline = 292,
  kOptStatuscolumn = 293,
  kOptStatusline = 294,
  kOptSuffixes = 295,
  kOptSuffixesadd = 296,
  kOptSwapfile = 297,
  kOptSwitchbuf = 298,
  kOptSynmaxcol = 299,
  kOptSyntax = 300,
  kOptTabclose = 301,
  kOptTabline = 302,
  kOptTabpagemax = 303,
  kOptTabstop = 304,
  kOptTagbsearch = 305,
  kOptTagcase = 306,
  kOptTagfunc = 307,
  kOptTaglength = 308,
  kOptTagrelative = 309,
  kOptTags = 310,
  kOptTagstack = 311,
  kOptTermbidi = 312,
  kOptTermencoding = 313,
  kOptTermguicolors = 314,
  kOptTermpastefilter = 315,
  kOptTermsync = 316,
  kOptTerse = 317,
  kOptTextwidth = 318,
  kOptThesaurus = 319,
  kOptThesaurusfunc = 320,
  kOptTildeop = 321,
  kOptTimeout = 322,
  kOptTimeoutlen = 323,
  kOptTitle = 324,
  kOptTitlelen = 325,
  kOptTitleold = 326,
  kOptTitlestring = 327,
  kOptTtimeout = 328,
  kOptTtimeoutlen = 329,
  kOptTtyfast = 330,
  kOptUndodir = 331,
  kOptUndofile = 332,
  kOptUndolevels = 333,
  kOptUndoreload = 334,
  kOptUpdatecount = 335,
  kOptUpdatetime = 336,
  kOptVarsofttabstop = 337,
  kOptVartabstop = 338,
  kOptVerbose = 339,
  kOptVerbosefile = 340,
  kOptViewdir = 341,
  kOptViewoptions = 342,
  kOptVirtualedit = 343,
  kOptVisualbell = 344,
  kOptWarn = 345,
  kOptWhichwrap = 346,
  kOptWildchar = 347,
  kOptWildcharm = 348,
  kOptWildignore = 349,
  kOptWildignorecase = 350,
  kOptWildmenu = 351,
  kOptWildmode = 352,
  kOptWildoptions = 353,
  kOptWinaltkeys = 354,
  kOptWinbar = 355,
  kOptWinblend = 356,
  kOptWinborder = 357,
  kOptWindow = 358,
  kOptWinfixbuf = 359,
  kOptWinfixheight = 360,
  kOptWinfixwidth = 361,
  kOptWinheight = 362,
  kOptWinhighlight = 363,
  kOptWinminheight = 364,
  kOptWinminwidth = 365,
  kOptWinwidth = 366,
  kOptWrap = 367,
  kOptWrapmargin = 368,
  kOptWrapscan = 369,
  kOptWrite = 370,
  kOptWriteany = 371,
  kOptWritebackup = 372,
  kOptWritedelay = 373,
  // Option count
#define kOptCount 374
} OptIndex;

typedef enum {
  kGlobalOptInvalid = -1,
  kGlobalOptAleph = 0,
  kGlobalOptAllowrevins = 1,
  kGlobalOptAmbiwidth = 2,
  kGlobalOptArabicshape = 3,
  kGlobalOptAutochdir = 4,
  kGlobalOptAutocomplete = 5,
  kGlobalOptAutocompletedelay = 6,
  kGlobalOptAutocompletetimeout = 7,
  kGlobalOptAutoread = 8,
  kGlobalOptAutowrite = 9,
  kGlobalOptAutowriteall = 10,
  kGlobalOptBackground = 11,
  kGlobalOptBackspace = 12,
  kGlobalOptBackup = 13,
  kGlobalOptBackupcopy = 14,
  kGlobalOptBackupdir = 15,
  kGlobalOptBackupext = 16,
  kGlobalOptBackupskip = 17,
  kGlobalOptBelloff = 18,
  kGlobalOptBreakat = 19,
  kGlobalOptBrowsedir = 20,
  kGlobalOptCasemap = 21,
  kGlobalOptCdhome = 22,
  kGlobalOptCdpath = 23,
  kGlobalOptCedit = 24,
  kGlobalOptCharconvert = 25,
  kGlobalOptChistory = 26,
  kGlobalOptClipboard = 27,
  kGlobalOptCmdheight = 28,
  kGlobalOptCmdwinheight = 29,
  kGlobalOptColumns = 30,
  kGlobalOptCompatible = 31,
  kGlobalOptCompleteitemalign = 32,
  kGlobalOptCompleteopt = 33,
  kGlobalOptCompletetimeout = 34,
  kGlobalOptConfirm = 35,
  kGlobalOptCpoptions = 36,
  kGlobalOptDebug = 37,
  kGlobalOptDefine = 38,
  kGlobalOptDelcombine = 39,
  kGlobalOptDictionary = 40,
  kGlobalOptDiffanchors = 41,
  kGlobalOptDiffexpr = 42,
  kGlobalOptDiffopt = 43,
  kGlobalOptDigraph = 44,
  kGlobalOptDirectory = 45,
  kGlobalOptDisplay = 46,
  kGlobalOptEadirection = 47,
  kGlobalOptEdcompatible = 48,
  kGlobalOptEmoji = 49,
  kGlobalOptEncoding = 50,
  kGlobalOptEqualalways = 51,
  kGlobalOptEqualprg = 52,
  kGlobalOptErrorbells = 53,
  kGlobalOptErrorfile = 54,
  kGlobalOptErrorformat = 55,
  kGlobalOptEventignore = 56,
  kGlobalOptExrc = 57,
  kGlobalOptFileencodings = 58,
  kGlobalOptFileformats = 59,
  kGlobalOptFileignorecase = 60,
  kGlobalOptFillchars = 61,
  kGlobalOptFindfunc = 62,
  kGlobalOptFoldclose = 63,
  kGlobalOptFoldlevelstart = 64,
  kGlobalOptFoldopen = 65,
  kGlobalOptFormatprg = 66,
  kGlobalOptFsync = 67,
  kGlobalOptGdefault = 68,
  kGlobalOptGrepformat = 69,
  kGlobalOptGrepprg = 70,
  kGlobalOptGuicursor = 71,
  kGlobalOptGuifont = 72,
  kGlobalOptGuifontwide = 73,
  kGlobalOptGuioptions = 74,
  kGlobalOptGuitablabel = 75,
  kGlobalOptGuitabtooltip = 76,
  kGlobalOptHelpfile = 77,
  kGlobalOptHelpheight = 78,
  kGlobalOptHelplang = 79,
  kGlobalOptHidden = 80,
  kGlobalOptHighlight = 81,
  kGlobalOptHistory = 82,
  kGlobalOptHkmap = 83,
  kGlobalOptHkmapp = 84,
  kGlobalOptHlsearch = 85,
  kGlobalOptIcon = 86,
  kGlobalOptIconstring = 87,
  kGlobalOptIgnorecase = 88,
  kGlobalOptImcmdline = 89,
  kGlobalOptImdisable = 90,
  kGlobalOptInccommand = 91,
  kGlobalOptInclude = 92,
  kGlobalOptIncsearch = 93,
  kGlobalOptInsertmode = 94,
  kGlobalOptIsfname = 95,
  kGlobalOptIsident = 96,
  kGlobalOptIsprint = 97,
  kGlobalOptJoinspaces = 98,
  kGlobalOptJumpoptions = 99,
  kGlobalOptKeymodel = 100,
  kGlobalOptKeywordprg = 101,
  kGlobalOptLangmap = 102,
  kGlobalOptLangmenu = 103,
  kGlobalOptLangnoremap = 104,
  kGlobalOptLangremap = 105,
  kGlobalOptLaststatus = 106,
  kGlobalOptLazyredraw = 107,
  kGlobalOptLines = 108,
  kGlobalOptLinespace = 109,
  kGlobalOptLispwords = 110,
  kGlobalOptListchars = 111,
  kGlobalOptLoadplugins = 112,
  kGlobalOptMagic = 113,
  kGlobalOptMakeef = 114,
  kGlobalOptMakeencoding = 115,
  kGlobalOptMakeprg = 116,
  kGlobalOptMatchtime = 117,
  kGlobalOptMaxcombine = 118,
  kGlobalOptMaxfuncdepth = 119,
  kGlobalOptMaxmapdepth = 120,
  kGlobalOptMaxmempattern = 121,
  kGlobalOptMaxsearchcount = 122,
  kGlobalOptMenuitems = 123,
  kGlobalOptMessagesopt = 124,
  kGlobalOptMkspellmem = 125,
  kGlobalOptModelineexpr = 126,
  kGlobalOptModelines = 127,
  kGlobalOptMore = 128,
  kGlobalOptMouse = 129,
  kGlobalOptMousefocus = 130,
  kGlobalOptMousehide = 131,
  kGlobalOptMousemodel = 132,
  kGlobalOptMousemoveevent = 133,
  kGlobalOptMousescroll = 134,
  kGlobalOptMouseshape = 135,
  kGlobalOptMousetime = 136,
  kGlobalOptOpendevice = 137,
  kGlobalOptOperatorfunc = 138,
  kGlobalOptPackpath = 139,
  kGlobalOptParagraphs = 140,
  kGlobalOptPaste = 141,
  kGlobalOptPastetoggle = 142,
  kGlobalOptPatchexpr = 143,
  kGlobalOptPatchmode = 144,
  kGlobalOptPath = 145,
  kGlobalOptPreviewheight = 146,
  kGlobalOptPrompt = 147,
  kGlobalOptPumblend = 148,
  kGlobalOptPumborder = 149,
  kGlobalOptPumheight = 150,
  kGlobalOptPummaxwidth = 151,
  kGlobalOptPumwidth = 152,
  kGlobalOptPyxversion = 153,
  kGlobalOptQuickfixtextfunc = 154,
  kGlobalOptRedrawdebug = 155,
  kGlobalOptRedrawtime = 156,
  kGlobalOptRegexpengine = 157,
  kGlobalOptRemap = 158,
  kGlobalOptReport = 159,
  kGlobalOptRevins = 160,
  kGlobalOptRuler = 161,
  kGlobalOptRulerformat = 162,
  kGlobalOptRuntimepath = 163,
  kGlobalOptScrolljump = 164,
  kGlobalOptScrolloff = 165,
  kGlobalOptScrollopt = 166,
  kGlobalOptSections = 167,
  kGlobalOptSecure = 168,
  kGlobalOptSelection = 169,
  kGlobalOptSelectmode = 170,
  kGlobalOptSessionoptions = 171,
  kGlobalOptShada = 172,
  kGlobalOptShadafile = 173,
  kGlobalOptShell = 174,
  kGlobalOptShellcmdflag = 175,
  kGlobalOptShellpipe = 176,
  kGlobalOptShellquote = 177,
  kGlobalOptShellredir = 178,
  kGlobalOptShellslash = 179,
  kGlobalOptShelltemp = 180,
  kGlobalOptShellxescape = 181,
  kGlobalOptShellxquote = 182,
  kGlobalOptShiftround = 183,
  kGlobalOptShortmess = 184,
  kGlobalOptShowbreak = 185,
  kGlobalOptShowcmd = 186,
  kGlobalOptShowcmdloc = 187,
  kGlobalOptShowfulltag = 188,
  kGlobalOptShowmatch = 189,
  kGlobalOptShowmode = 190,
  kGlobalOptShowtabline = 191,
  kGlobalOptSidescroll = 192,
  kGlobalOptSidescrolloff = 193,
  kGlobalOptSmartcase = 194,
  kGlobalOptSmarttab = 195,
  kGlobalOptSpellsuggest = 196,
  kGlobalOptSplitbelow = 197,
  kGlobalOptSplitkeep = 198,
  kGlobalOptSplitright = 199,
  kGlobalOptStartofline = 200,
  kGlobalOptStatusline = 201,
  kGlobalOptSuffixes = 202,
  kGlobalOptSwitchbuf = 203,
  kGlobalOptTabclose = 204,
  kGlobalOptTabline = 205,
  kGlobalOptTabpagemax = 206,
  kGlobalOptTagbsearch = 207,
  kGlobalOptTagcase = 208,
  kGlobalOptTaglength = 209,
  kGlobalOptTagrelative = 210,
  kGlobalOptTags = 211,
  kGlobalOptTagstack = 212,
  kGlobalOptTermbidi = 213,
  kGlobalOptTermencoding = 214,
  kGlobalOptTermguicolors = 215,
  kGlobalOptTermpastefilter = 216,
  kGlobalOptTermsync = 217,
  kGlobalOptTerse = 218,
  kGlobalOptThesaurus = 219,
  kGlobalOptThesaurusfunc = 220,
  kGlobalOptTildeop = 221,
  kGlobalOptTimeout = 222,
  kGlobalOptTimeoutlen = 223,
  kGlobalOptTitle = 224,
  kGlobalOptTitlelen = 225,
  kGlobalOptTitleold = 226,
  kGlobalOptTitlestring = 227,
  kGlobalOptTtimeout = 228,
  kGlobalOptTtimeoutlen = 229,
  kGlobalOptTtyfast = 230,
  kGlobalOptUndodir = 231,
  kGlobalOptUndolevels = 232,
  kGlobalOptUndoreload = 233,
  kGlobalOptUpdatecount = 234,
  kGlobalOptUpdatetime = 235,
  kGlobalOptVerbose = 236,
  kGlobalOptVerbosefile = 237,
  kGlobalOptViewdir = 238,
  kGlobalOptViewoptions = 239,
  kGlobalOptVirtualedit = 240,
  kGlobalOptVisualbell = 241,
  kGlobalOptWarn = 242,
  kGlobalOptWhichwrap = 243,
  kGlobalOptWildchar = 244,
  kGlobalOptWildcharm = 245,
  kGlobalOptWildignore = 246,
  kGlobalOptWildignorecase = 247,
  kGlobalOptWildmenu = 248,
  kGlobalOptWildmode = 249,
  kGlobalOptWildoptions = 250,
  kGlobalOptWinaltkeys = 251,
  kGlobalOptWinbar = 252,
  kGlobalOptWinborder = 253,
  kGlobalOptWindow = 254,
  kGlobalOptWinheight = 255,
  kGlobalOptWinminheight = 256,
  kGlobalOptWinminwidth = 257,
  kGlobalOptWinwidth = 258,
  kGlobalOptWrapscan = 259,
  kGlobalOptWrite = 260,
  kGlobalOptWriteany = 261,
  kGlobalOptWritebackup = 262,
  kGlobalOptWritedelay = 263,
  // Global option count
#define kGlobalOptCount 264
} GlobalOptIndex;

typedef enum {
  kBufOptInvalid = -1,
  kBufOptAutocomplete = 0,
  kBufOptAutoindent = 1,
  kBufOptAutoread = 2,
  kBufOptBackupcopy = 3,
  kBufOptBinary = 4,
  kBufOptBomb = 5,
  kBufOptBufhidden = 6,
  kBufOptBuflisted = 7,
  kBufOptBuftype = 8,
  kBufOptBusy = 9,
  kBufOptChannel = 10,
  kBufOptCindent = 11,
  kBufOptCinkeys = 12,
  kBufOptCinoptions = 13,
  kBufOptCinscopedecls = 14,
  kBufOptCinwords = 15,
  kBufOptComments = 16,
  kBufOptCommentstring = 17,
  kBufOptComplete = 18,
  kBufOptCompletefunc = 19,
  kBufOptCompleteopt = 20,
  kBufOptCompleteslash = 21,
  kBufOptCopyindent = 22,
  kBufOptDefine = 23,
  kBufOptDictionary = 24,
  kBufOptDiffanchors = 25,
  kBufOptEndoffile = 26,
  kBufOptEndofline = 27,
  kBufOptEqualprg = 28,
  kBufOptErrorformat = 29,
  kBufOptExpandtab = 30,
  kBufOptFileencoding = 31,
  kBufOptFileformat = 32,
  kBufOptFiletype = 33,
  kBufOptFindfunc = 34,
  kBufOptFixendofline = 35,
  kBufOptFormatexpr = 36,
  kBufOptFormatlistpat = 37,
  kBufOptFormatoptions = 38,
  kBufOptFormatprg = 39,
  kBufOptGrepformat = 40,
  kBufOptGrepprg = 41,
  kBufOptIminsert = 42,
  kBufOptImsearch = 43,
  kBufOptInclude = 44,
  kBufOptIncludeexpr = 45,
  kBufOptIndentexpr = 46,
  kBufOptIndentkeys = 47,
  kBufOptInfercase = 48,
  kBufOptIskeyword = 49,
  kBufOptKeymap = 50,
  kBufOptKeywordprg = 51,
  kBufOptLisp = 52,
  kBufOptLispoptions = 53,
  kBufOptLispwords = 54,
  kBufOptMakeencoding = 55,
  kBufOptMakeprg = 56,
  kBufOptMatchpairs = 57,
  kBufOptModeline = 58,
  kBufOptModifiable = 59,
  kBufOptModified = 60,
  kBufOptNrformats = 61,
  kBufOptOmnifunc = 62,
  kBufOptPath = 63,
  kBufOptPreserveindent = 64,
  kBufOptQuoteescape = 65,
  kBufOptReadonly = 66,
  kBufOptScrollback = 67,
  kBufOptShiftwidth = 68,
  kBufOptSmartindent = 69,
  kBufOptSofttabstop = 70,
  kBufOptSpellcapcheck = 71,
  kBufOptSpellfile = 72,
  kBufOptSpelllang = 73,
  kBufOptSpelloptions = 74,
  kBufOptSuffixesadd = 75,
  kBufOptSwapfile = 76,
  kBufOptSynmaxcol = 77,
  kBufOptSyntax = 78,
  kBufOptTabstop = 79,
  kBufOptTagcase = 80,
  kBufOptTagfunc = 81,
  kBufOptTags = 82,
  kBufOptTextwidth = 83,
  kBufOptThesaurus = 84,
  kBufOptThesaurusfunc = 85,
  kBufOptUndofile = 86,
  kBufOptUndolevels = 87,
  kBufOptVarsofttabstop = 88,
  kBufOptVartabstop = 89,
  kBufOptWrapmargin = 90,
  // Buf option count
#define kBufOptCount 91
} BufOptIndex;

typedef enum {
  kWinOptInvalid = -1,
  kWinOptArabic = 0,
  kWinOptBreakindent = 1,
  kWinOptBreakindentopt = 2,
  kWinOptColorcolumn = 3,
  kWinOptConcealcursor = 4,
  kWinOptConceallevel = 5,
  kWinOptCursorbind = 6,
  kWinOptCursorcolumn = 7,
  kWinOptCursorline = 8,
  kWinOptCursorlineopt = 9,
  kWinOptDiff = 10,
  kWinOptEventignorewin = 11,
  kWinOptFillchars = 12,
  kWinOptFoldcolumn = 13,
  kWinOptFoldenable = 14,
  kWinOptFoldexpr = 15,
  kWinOptFoldignore = 16,
  kWinOptFoldlevel = 17,
  kWinOptFoldmarker = 18,
  kWinOptFoldmethod = 19,
  kWinOptFoldminlines = 20,
  kWinOptFoldnestmax = 21,
  kWinOptFoldtext = 22,
  kWinOptLhistory = 23,
  kWinOptLinebreak = 24,
  kWinOptList = 25,
  kWinOptListchars = 26,
  kWinOptNumber = 27,
  kWinOptNumberwidth = 28,
  kWinOptPreviewwindow = 29,
  kWinOptRelativenumber = 30,
  kWinOptRightleft = 31,
  kWinOptRightleftcmd = 32,
  kWinOptScroll = 33,
  kWinOptScrollbind = 34,
  kWinOptScrolloff = 35,
  kWinOptShowbreak = 36,
  kWinOptSidescrolloff = 37,
  kWinOptSigncolumn = 38,
  kWinOptSmoothscroll = 39,
  kWinOptSpell = 40,
  kWinOptStatuscolumn = 41,
  kWinOptStatusline = 42,
  kWinOptVirtualedit = 43,
  kWinOptWinbar = 44,
  kWinOptWinblend = 45,
  kWinOptWinfixbuf = 46,
  kWinOptWinfixheight = 47,
  kWinOptWinfixwidth = 48,
  kWinOptWinhighlight = 49,
  kWinOptWrap = 50,
  // Win option count
#define kWinOptCount 51
} WinOptIndex;

EXTERN const OptIndex global_opt_idx[] INIT( = {
  [kGlobalOptAleph] = kOptAleph,
  [kGlobalOptAllowrevins] = kOptAllowrevins,
  [kGlobalOptAmbiwidth] = kOptAmbiwidth,
  [kGlobalOptArabicshape] = kOptArabicshape,
  [kGlobalOptAutochdir] = kOptAutochdir,
  [kGlobalOptAutocomplete] = kOptAutocomplete,
  [kGlobalOptAutocompletedelay] = kOptAutocompletedelay,
  [kGlobalOptAutocompletetimeout] = kOptAutocompletetimeout,
  [kGlobalOptAutoread] = kOptAutoread,
  [kGlobalOptAutowrite] = kOptAutowrite,
  [kGlobalOptAutowriteall] = kOptAutowriteall,
  [kGlobalOptBackground] = kOptBackground,
  [kGlobalOptBackspace] = kOptBackspace,
  [kGlobalOptBackup] = kOptBackup,
  [kGlobalOptBackupcopy] = kOptBackupcopy,
  [kGlobalOptBackupdir] = kOptBackupdir,
  [kGlobalOptBackupext] = kOptBackupext,
  [kGlobalOptBackupskip] = kOptBackupskip,
  [kGlobalOptBelloff] = kOptBelloff,
  [kGlobalOptBreakat] = kOptBreakat,
  [kGlobalOptBrowsedir] = kOptBrowsedir,
  [kGlobalOptCasemap] = kOptCasemap,
  [kGlobalOptCdhome] = kOptCdhome,
  [kGlobalOptCdpath] = kOptCdpath,
  [kGlobalOptCedit] = kOptCedit,
  [kGlobalOptCharconvert] = kOptCharconvert,
  [kGlobalOptChistory] = kOptChistory,
  [kGlobalOptClipboard] = kOptClipboard,
  [kGlobalOptCmdheight] = kOptCmdheight,
  [kGlobalOptCmdwinheight] = kOptCmdwinheight,
  [kGlobalOptColumns] = kOptColumns,
  [kGlobalOptCompatible] = kOptCompatible,
  [kGlobalOptCompleteitemalign] = kOptCompleteitemalign,
  [kGlobalOptCompleteopt] = kOptCompleteopt,
  [kGlobalOptCompletetimeout] = kOptCompletetimeout,
  [kGlobalOptConfirm] = kOptConfirm,
  [kGlobalOptCpoptions] = kOptCpoptions,
  [kGlobalOptDebug] = kOptDebug,
  [kGlobalOptDefine] = kOptDefine,
  [kGlobalOptDelcombine] = kOptDelcombine,
  [kGlobalOptDictionary] = kOptDictionary,
  [kGlobalOptDiffanchors] = kOptDiffanchors,
  [kGlobalOptDiffexpr] = kOptDiffexpr,
  [kGlobalOptDiffopt] = kOptDiffopt,
  [kGlobalOptDigraph] = kOptDigraph,
  [kGlobalOptDirectory] = kOptDirectory,
  [kGlobalOptDisplay] = kOptDisplay,
  [kGlobalOptEadirection] = kOptEadirection,
  [kGlobalOptEdcompatible] = kOptEdcompatible,
  [kGlobalOptEmoji] = kOptEmoji,
  [kGlobalOptEncoding] = kOptEncoding,
  [kGlobalOptEqualalways] = kOptEqualalways,
  [kGlobalOptEqualprg] = kOptEqualprg,
  [kGlobalOptErrorbells] = kOptErrorbells,
  [kGlobalOptErrorfile] = kOptErrorfile,
  [kGlobalOptErrorformat] = kOptErrorformat,
  [kGlobalOptEventignore] = kOptEventignore,
  [kGlobalOptExrc] = kOptExrc,
  [kGlobalOptFileencodings] = kOptFileencodings,
  [kGlobalOptFileformats] = kOptFileformats,
  [kGlobalOptFileignorecase] = kOptFileignorecase,
  [kGlobalOptFillchars] = kOptFillchars,
  [kGlobalOptFindfunc] = kOptFindfunc,
  [kGlobalOptFoldclose] = kOptFoldclose,
  [kGlobalOptFoldlevelstart] = kOptFoldlevelstart,
  [kGlobalOptFoldopen] = kOptFoldopen,
  [kGlobalOptFormatprg] = kOptFormatprg,
  [kGlobalOptFsync] = kOptFsync,
  [kGlobalOptGdefault] = kOptGdefault,
  [kGlobalOptGrepformat] = kOptGrepformat,
  [kGlobalOptGrepprg] = kOptGrepprg,
  [kGlobalOptGuicursor] = kOptGuicursor,
  [kGlobalOptGuifont] = kOptGuifont,
  [kGlobalOptGuifontwide] = kOptGuifontwide,
  [kGlobalOptGuioptions] = kOptGuioptions,
  [kGlobalOptGuitablabel] = kOptGuitablabel,
  [kGlobalOptGuitabtooltip] = kOptGuitabtooltip,
  [kGlobalOptHelpfile] = kOptHelpfile,
  [kGlobalOptHelpheight] = kOptHelpheight,
  [kGlobalOptHelplang] = kOptHelplang,
  [kGlobalOptHidden] = kOptHidden,
  [kGlobalOptHighlight] = kOptHighlight,
  [kGlobalOptHistory] = kOptHistory,
  [kGlobalOptHkmap] = kOptHkmap,
  [kGlobalOptHkmapp] = kOptHkmapp,
  [kGlobalOptHlsearch] = kOptHlsearch,
  [kGlobalOptIcon] = kOptIcon,
  [kGlobalOptIconstring] = kOptIconstring,
  [kGlobalOptIgnorecase] = kOptIgnorecase,
  [kGlobalOptImcmdline] = kOptImcmdline,
  [kGlobalOptImdisable] = kOptImdisable,
  [kGlobalOptInccommand] = kOptInccommand,
  [kGlobalOptInclude] = kOptInclude,
  [kGlobalOptIncsearch] = kOptIncsearch,
  [kGlobalOptInsertmode] = kOptInsertmode,
  [kGlobalOptIsfname] = kOptIsfname,
  [kGlobalOptIsident] = kOptIsident,
  [kGlobalOptIsprint] = kOptIsprint,
  [kGlobalOptJoinspaces] = kOptJoinspaces,
  [kGlobalOptJumpoptions] = kOptJumpoptions,
  [kGlobalOptKeymodel] = kOptKeymodel,
  [kGlobalOptKeywordprg] = kOptKeywordprg,
  [kGlobalOptLangmap] = kOptLangmap,
  [kGlobalOptLangmenu] = kOptLangmenu,
  [kGlobalOptLangnoremap] = kOptLangnoremap,
  [kGlobalOptLangremap] = kOptLangremap,
  [kGlobalOptLaststatus] = kOptLaststatus,
  [kGlobalOptLazyredraw] = kOptLazyredraw,
  [kGlobalOptLines] = kOptLines,
  [kGlobalOptLinespace] = kOptLinespace,
  [kGlobalOptLispwords] = kOptLispwords,
  [kGlobalOptListchars] = kOptListchars,
  [kGlobalOptLoadplugins] = kOptLoadplugins,
  [kGlobalOptMagic] = kOptMagic,
  [kGlobalOptMakeef] = kOptMakeef,
  [kGlobalOptMakeencoding] = kOptMakeencoding,
  [kGlobalOptMakeprg] = kOptMakeprg,
  [kGlobalOptMatchtime] = kOptMatchtime,
  [kGlobalOptMaxcombine] = kOptMaxcombine,
  [kGlobalOptMaxfuncdepth] = kOptMaxfuncdepth,
  [kGlobalOptMaxmapdepth] = kOptMaxmapdepth,
  [kGlobalOptMaxmempattern] = kOptMaxmempattern,
  [kGlobalOptMaxsearchcount] = kOptMaxsearchcount,
  [kGlobalOptMenuitems] = kOptMenuitems,
  [kGlobalOptMessagesopt] = kOptMessagesopt,
  [kGlobalOptMkspellmem] = kOptMkspellmem,
  [kGlobalOptModelineexpr] = kOptModelineexpr,
  [kGlobalOptModelines] = kOptModelines,
  [kGlobalOptMore] = kOptMore,
  [kGlobalOptMouse] = kOptMouse,
  [kGlobalOptMousefocus] = kOptMousefocus,
  [kGlobalOptMousehide] = kOptMousehide,
  [kGlobalOptMousemodel] = kOptMousemodel,
  [kGlobalOptMousemoveevent] = kOptMousemoveevent,
  [kGlobalOptMousescroll] = kOptMousescroll,
  [kGlobalOptMouseshape] = kOptMouseshape,
  [kGlobalOptMousetime] = kOptMousetime,
  [kGlobalOptOpendevice] = kOptOpendevice,
  [kGlobalOptOperatorfunc] = kOptOperatorfunc,
  [kGlobalOptPackpath] = kOptPackpath,
  [kGlobalOptParagraphs] = kOptParagraphs,
  [kGlobalOptPaste] = kOptPaste,
  [kGlobalOptPastetoggle] = kOptPastetoggle,
  [kGlobalOptPatchexpr] = kOptPatchexpr,
  [kGlobalOptPatchmode] = kOptPatchmode,
  [kGlobalOptPath] = kOptPath,
  [kGlobalOptPreviewheight] = kOptPreviewheight,
  [kGlobalOptPrompt] = kOptPrompt,
  [kGlobalOptPumblend] = kOptPumblend,
  [kGlobalOptPumborder] = kOptPumborder,
  [kGlobalOptPumheight] = kOptPumheight,
  [kGlobalOptPummaxwidth] = kOptPummaxwidth,
  [kGlobalOptPumwidth] = kOptPumwidth,
  [kGlobalOptPyxversion] = kOptPyxversion,
  [kGlobalOptQuickfixtextfunc] = kOptQuickfixtextfunc,
  [kGlobalOptRedrawdebug] = kOptRedrawdebug,
  [kGlobalOptRedrawtime] = kOptRedrawtime,
  [kGlobalOptRegexpengine] = kOptRegexpengine,
  [kGlobalOptRemap] = kOptRemap,
  [kGlobalOptReport] = kOptReport,
  [kGlobalOptRevins] = kOptRevins,
  [kGlobalOptRuler] = kOptRuler,
  [kGlobalOptRulerformat] = kOptRulerformat,
  [kGlobalOptRuntimepath] = kOptRuntimepath,
  [kGlobalOptScrolljump] = kOptScrolljump,
  [kGlobalOptScrolloff] = kOptScrolloff,
  [kGlobalOptScrollopt] = kOptScrollopt,
  [kGlobalOptSections] = kOptSections,
  [kGlobalOptSecure] = kOptSecure,
  [kGlobalOptSelection] = kOptSelection,
  [kGlobalOptSelectmode] = kOptSelectmode,
  [kGlobalOptSessionoptions] = kOptSessionoptions,
  [kGlobalOptShada] = kOptShada,
  [kGlobalOptShadafile] = kOptShadafile,
  [kGlobalOptShell] = kOptShell,
  [kGlobalOptShellcmdflag] = kOptShellcmdflag,
  [kGlobalOptShellpipe] = kOptShellpipe,
  [kGlobalOptShellquote] = kOptShellquote,
  [kGlobalOptShellredir] = kOptShellredir,
  [kGlobalOptShellslash] = kOptShellslash,
  [kGlobalOptShelltemp] = kOptShelltemp,
  [kGlobalOptShellxescape] = kOptShellxescape,
  [kGlobalOptShellxquote] = kOptShellxquote,
  [kGlobalOptShiftround] = kOptShiftround,
  [kGlobalOptShortmess] = kOptShortmess,
  [kGlobalOptShowbreak] = kOptShowbreak,
  [kGlobalOptShowcmd] = kOptShowcmd,
  [kGlobalOptShowcmdloc] = kOptShowcmdloc,
  [kGlobalOptShowfulltag] = kOptShowfulltag,
  [kGlobalOptShowmatch] = kOptShowmatch,
  [kGlobalOptShowmode] = kOptShowmode,
  [kGlobalOptShowtabline] = kOptShowtabline,
  [kGlobalOptSidescroll] = kOptSidescroll,
  [kGlobalOptSidescrolloff] = kOptSidescrolloff,
  [kGlobalOptSmartcase] = kOptSmartcase,
  [kGlobalOptSmarttab] = kOptSmarttab,
  [kGlobalOptSpellsuggest] = kOptSpellsuggest,
  [kGlobalOptSplitbelow] = kOptSplitbelow,
  [kGlobalOptSplitkeep] = kOptSplitkeep,
  [kGlobalOptSplitright] = kOptSplitright,
  [kGlobalOptStartofline] = kOptStartofline,
  [kGlobalOptStatusline] = kOptStatusline,
  [kGlobalOptSuffixes] = kOptSuffixes,
  [kGlobalOptSwitchbuf] = kOptSwitchbuf,
  [kGlobalOptTabclose] = kOptTabclose,
  [kGlobalOptTabline] = kOptTabline,
  [kGlobalOptTabpagemax] = kOptTabpagemax,
  [kGlobalOptTagbsearch] = kOptTagbsearch,
  [kGlobalOptTagcase] = kOptTagcase,
  [kGlobalOptTaglength] = kOptTaglength,
  [kGlobalOptTagrelative] = kOptTagrelative,
  [kGlobalOptTags] = kOptTags,
  [kGlobalOptTagstack] = kOptTagstack,
  [kGlobalOptTermbidi] = kOptTermbidi,
  [kGlobalOptTermencoding] = kOptTermencoding,
  [kGlobalOptTermguicolors] = kOptTermguicolors,
  [kGlobalOptTermpastefilter] = kOptTermpastefilter,
  [kGlobalOptTermsync] = kOptTermsync,
  [kGlobalOptTerse] = kOptTerse,
  [kGlobalOptThesaurus] = kOptThesaurus,
  [kGlobalOptThesaurusfunc] = kOptThesaurusfunc,
  [kGlobalOptTildeop] = kOptTildeop,
  [kGlobalOptTimeout] = kOptTimeout,
  [kGlobalOptTimeoutlen] = kOptTimeoutlen,
  [kGlobalOptTitle] = kOptTitle,
  [kGlobalOptTitlelen] = kOptTitlelen,
  [kGlobalOptTitleold] = kOptTitleold,
  [kGlobalOptTitlestring] = kOptTitlestring,
  [kGlobalOptTtimeout] = kOptTtimeout,
  [kGlobalOptTtimeoutlen] = kOptTtimeoutlen,
  [kGlobalOptTtyfast] = kOptTtyfast,
  [kGlobalOptUndodir] = kOptUndodir,
  [kGlobalOptUndolevels] = kOptUndolevels,
  [kGlobalOptUndoreload] = kOptUndoreload,
  [kGlobalOptUpdatecount] = kOptUpdatecount,
  [kGlobalOptUpdatetime] = kOptUpdatetime,
  [kGlobalOptVerbose] = kOptVerbose,
  [kGlobalOptVerbosefile] = kOptVerbosefile,
  [kGlobalOptViewdir] = kOptViewdir,
  [kGlobalOptViewoptions] = kOptViewoptions,
  [kGlobalOptVirtualedit] = kOptVirtualedit,
  [kGlobalOptVisualbell] = kOptVisualbell,
  [kGlobalOptWarn] = kOptWarn,
  [kGlobalOptWhichwrap] = kOptWhichwrap,
  [kGlobalOptWildchar] = kOptWildchar,
  [kGlobalOptWildcharm] = kOptWildcharm,
  [kGlobalOptWildignore] = kOptWildignore,
  [kGlobalOptWildignorecase] = kOptWildignorecase,
  [kGlobalOptWildmenu] = kOptWildmenu,
  [kGlobalOptWildmode] = kOptWildmode,
  [kGlobalOptWildoptions] = kOptWildoptions,
  [kGlobalOptWinaltkeys] = kOptWinaltkeys,
  [kGlobalOptWinbar] = kOptWinbar,
  [kGlobalOptWinborder] = kOptWinborder,
  [kGlobalOptWindow] = kOptWindow,
  [kGlobalOptWinheight] = kOptWinheight,
  [kGlobalOptWinminheight] = kOptWinminheight,
  [kGlobalOptWinminwidth] = kOptWinminwidth,
  [kGlobalOptWinwidth] = kOptWinwidth,
  [kGlobalOptWrapscan] = kOptWrapscan,
  [kGlobalOptWrite] = kOptWrite,
  [kGlobalOptWriteany] = kOptWriteany,
  [kGlobalOptWritebackup] = kOptWritebackup,
  [kGlobalOptWritedelay] = kOptWritedelay,
});

EXTERN const OptIndex buf_opt_idx[] INIT( = {
  [kBufOptAutocomplete] = kOptAutocomplete,
  [kBufOptAutoindent] = kOptAutoindent,
  [kBufOptAutoread] = kOptAutoread,
  [kBufOptBackupcopy] = kOptBackupcopy,
  [kBufOptBinary] = kOptBinary,
  [kBufOptBomb] = kOptBomb,
  [kBufOptBufhidden] = kOptBufhidden,
  [kBufOptBuflisted] = kOptBuflisted,
  [kBufOptBuftype] = kOptBuftype,
  [kBufOptBusy] = kOptBusy,
  [kBufOptChannel] = kOptChannel,
  [kBufOptCindent] = kOptCindent,
  [kBufOptCinkeys] = kOptCinkeys,
  [kBufOptCinoptions] = kOptCinoptions,
  [kBufOptCinscopedecls] = kOptCinscopedecls,
  [kBufOptCinwords] = kOptCinwords,
  [kBufOptComments] = kOptComments,
  [kBufOptCommentstring] = kOptCommentstring,
  [kBufOptComplete] = kOptComplete,
  [kBufOptCompletefunc] = kOptCompletefunc,
  [kBufOptCompleteopt] = kOptCompleteopt,
  [kBufOptCompleteslash] = kOptCompleteslash,
  [kBufOptCopyindent] = kOptCopyindent,
  [kBufOptDefine] = kOptDefine,
  [kBufOptDictionary] = kOptDictionary,
  [kBufOptDiffanchors] = kOptDiffanchors,
  [kBufOptEndoffile] = kOptEndoffile,
  [kBufOptEndofline] = kOptEndofline,
  [kBufOptEqualprg] = kOptEqualprg,
  [kBufOptErrorformat] = kOptErrorformat,
  [kBufOptExpandtab] = kOptExpandtab,
  [kBufOptFileencoding] = kOptFileencoding,
  [kBufOptFileformat] = kOptFileformat,
  [kBufOptFiletype] = kOptFiletype,
  [kBufOptFindfunc] = kOptFindfunc,
  [kBufOptFixendofline] = kOptFixendofline,
  [kBufOptFormatexpr] = kOptFormatexpr,
  [kBufOptFormatlistpat] = kOptFormatlistpat,
  [kBufOptFormatoptions] = kOptFormatoptions,
  [kBufOptFormatprg] = kOptFormatprg,
  [kBufOptGrepformat] = kOptGrepformat,
  [kBufOptGrepprg] = kOptGrepprg,
  [kBufOptIminsert] = kOptIminsert,
  [kBufOptImsearch] = kOptImsearch,
  [kBufOptInclude] = kOptInclude,
  [kBufOptIncludeexpr] = kOptIncludeexpr,
  [kBufOptIndentexpr] = kOptIndentexpr,
  [kBufOptIndentkeys] = kOptIndentkeys,
  [kBufOptInfercase] = kOptInfercase,
  [kBufOptIskeyword] = kOptIskeyword,
  [kBufOptKeymap] = kOptKeymap,
  [kBufOptKeywordprg] = kOptKeywordprg,
  [kBufOptLisp] = kOptLisp,
  [kBufOptLispoptions] = kOptLispoptions,
  [kBufOptLispwords] = kOptLispwords,
  [kBufOptMakeencoding] = kOptMakeencoding,
  [kBufOptMakeprg] = kOptMakeprg,
  [kBufOptMatchpairs] = kOptMatchpairs,
  [kBufOptModeline] = kOptModeline,
  [kBufOptModifiable] = kOptModifiable,
  [kBufOptModified] = kOptModified,
  [kBufOptNrformats] = kOptNrformats,
  [kBufOptOmnifunc] = kOptOmnifunc,
  [kBufOptPath] = kOptPath,
  [kBufOptPreserveindent] = kOptPreserveindent,
  [kBufOptQuoteescape] = kOptQuoteescape,
  [kBufOptReadonly] = kOptReadonly,
  [kBufOptScrollback] = kOptScrollback,
  [kBufOptShiftwidth] = kOptShiftwidth,
  [kBufOptSmartindent] = kOptSmartindent,
  [kBufOptSofttabstop] = kOptSofttabstop,
  [kBufOptSpellcapcheck] = kOptSpellcapcheck,
  [kBufOptSpellfile] = kOptSpellfile,
  [kBufOptSpelllang] = kOptSpelllang,
  [kBufOptSpelloptions] = kOptSpelloptions,
  [kBufOptSuffixesadd] = kOptSuffixesadd,
  [kBufOptSwapfile] = kOptSwapfile,
  [kBufOptSynmaxcol] = kOptSynmaxcol,
  [kBufOptSyntax] = kOptSyntax,
  [kBufOptTabstop] = kOptTabstop,
  [kBufOptTagcase] = kOptTagcase,
  [kBufOptTagfunc] = kOptTagfunc,
  [kBufOptTags] = kOptTags,
  [kBufOptTextwidth] = kOptTextwidth,
  [kBufOptThesaurus] = kOptThesaurus,
  [kBufOptThesaurusfunc] = kOptThesaurusfunc,
  [kBufOptUndofile] = kOptUndofile,
  [kBufOptUndolevels] = kOptUndolevels,
  [kBufOptVarsofttabstop] = kOptVarsofttabstop,
  [kBufOptVartabstop] = kOptVartabstop,
  [kBufOptWrapmargin] = kOptWrapmargin,
});

EXTERN const OptIndex win_opt_idx[] INIT( = {
  [kWinOptArabic] = kOptArabic,
  [kWinOptBreakindent] = kOptBreakindent,
  [kWinOptBreakindentopt] = kOptBreakindentopt,
  [kWinOptColorcolumn] = kOptColorcolumn,
  [kWinOptConcealcursor] = kOptConcealcursor,
  [kWinOptConceallevel] = kOptConceallevel,
  [kWinOptCursorbind] = kOptCursorbind,
  [kWinOptCursorcolumn] = kOptCursorcolumn,
  [kWinOptCursorline] = kOptCursorline,
  [kWinOptCursorlineopt] = kOptCursorlineopt,
  [kWinOptDiff] = kOptDiff,
  [kWinOptEventignorewin] = kOptEventignorewin,
  [kWinOptFillchars] = kOptFillchars,
  [kWinOptFoldcolumn] = kOptFoldcolumn,
  [kWinOptFoldenable] = kOptFoldenable,
  [kWinOptFoldexpr] = kOptFoldexpr,
  [kWinOptFoldignore] = kOptFoldignore,
  [kWinOptFoldlevel] = kOptFoldlevel,
  [kWinOptFoldmarker] = kOptFoldmarker,
  [kWinOptFoldmethod] = kOptFoldmethod,
  [kWinOptFoldminlines] = kOptFoldminlines,
  [kWinOptFoldnestmax] = kOptFoldnestmax,
  [kWinOptFoldtext] = kOptFoldtext,
  [kWinOptLhistory] = kOptLhistory,
  [kWinOptLinebreak] = kOptLinebreak,
  [kWinOptList] = kOptList,
  [kWinOptListchars] = kOptListchars,
  [kWinOptNumber] = kOptNumber,
  [kWinOptNumberwidth] = kOptNumberwidth,
  [kWinOptPreviewwindow] = kOptPreviewwindow,
  [kWinOptRelativenumber] = kOptRelativenumber,
  [kWinOptRightleft] = kOptRightleft,
  [kWinOptRightleftcmd] = kOptRightleftcmd,
  [kWinOptScroll] = kOptScroll,
  [kWinOptScrollbind] = kOptScrollbind,
  [kWinOptScrolloff] = kOptScrolloff,
  [kWinOptShowbreak] = kOptShowbreak,
  [kWinOptSidescrolloff] = kOptSidescrolloff,
  [kWinOptSigncolumn] = kOptSigncolumn,
  [kWinOptSmoothscroll] = kOptSmoothscroll,
  [kWinOptSpell] = kOptSpell,
  [kWinOptStatuscolumn] = kOptStatuscolumn,
  [kWinOptStatusline] = kOptStatusline,
  [kWinOptVirtualedit] = kOptVirtualedit,
  [kWinOptWinbar] = kOptWinbar,
  [kWinOptWinblend] = kOptWinblend,
  [kWinOptWinfixbuf] = kOptWinfixbuf,
  [kWinOptWinfixheight] = kOptWinfixheight,
  [kWinOptWinfixwidth] = kOptWinfixwidth,
  [kWinOptWinhighlight] = kOptWinhighlight,
  [kWinOptWrap] = kOptWrap,
});
