// IWYU pragma: private, include "nvim/buffer.h"
#define DEFINE_FUNC_ATTRIBUTES
#include "nvim/func_attr.h"
#undef DEFINE_FUNC_ATTRIBUTES
#ifndef DLLEXPORT
#  ifdef MSWIN
#    define DLLEXPORT __declspec(dllexport)
#  else
#    define DLLEXPORT
#  endif
#endif
DLLEXPORT int calc_percentage(int64_t part, int64_t whole);
DLLEXPORT int get_highest_fnum(void);
DLLEXPORT bool buf_ensure_loaded(buf_T *buf);
DLLEXPORT int open_buffer(bool read_stdin, exarg_T *eap, int flags_arg);
DLLEXPORT void set_bufref(bufref_T *bufref, buf_T *buf);
DLLEXPORT bool bufref_valid(bufref_T *bufref) FUNC_ATTR_PURE;
DLLEXPORT bool buf_valid(buf_T *buf) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT void buf_close_terminal(buf_T *buf);
DLLEXPORT bool close_buffer(win_T *win, buf_T *buf, int action, bool abort_if_last, bool ignore_abort);
DLLEXPORT void buf_clear_file(buf_T *buf);
DLLEXPORT void buf_clear(void);
DLLEXPORT void buf_freeall(buf_T *buf, int flags);
DLLEXPORT void goto_buffer(exarg_T *eap, int start, int dir, int count);
DLLEXPORT void handle_swap_exists(bufref_T *old_curbuf);
DLLEXPORT char *do_bufdel(int command, char *arg, int addr_count, int start_bnr, int end_bnr, int forceit);
DLLEXPORT int do_buffer(int action, int start, int dir, int count, int forceit);
DLLEXPORT void set_curbuf(buf_T *buf, int action, bool update_jumplist);
DLLEXPORT void do_autochdir(void);
DLLEXPORT void no_write_message_buf(buf_T *buf);
DLLEXPORT void no_write_message(void);
DLLEXPORT void no_write_message_nobang(const buf_T *const buf) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT buf_T *buflist_new(char *ffname_arg, char *sfname_arg, linenr_T lnum, int flags);
DLLEXPORT bool curbuf_reusable(void);
DLLEXPORT void free_buf_options(buf_T *buf, bool free_p_ff);
DLLEXPORT int buflist_getfile(int n, linenr_T lnum, int options, int forceit);
DLLEXPORT buf_T *buflist_findname_exp(char *fname);
DLLEXPORT buf_T *buflist_findname(char *ffname);
DLLEXPORT int buflist_findpat(const char *pattern, const char *pattern_end, bool unlisted, bool diffmode, bool curtab_only) FUNC_ATTR_NONNULL_ARG(1);
DLLEXPORT int ExpandBufnames(char *pat, int *num_file, char ***file, int options);
DLLEXPORT buf_T *buflist_findnr(int nr);
DLLEXPORT char *buflist_nr2name(int n, int fullname, int helptail);
DLLEXPORT void buflist_setfpos(buf_T *const buf, win_T *const win, linenr_T lnum, colnr_T col, bool copy_options) FUNC_ATTR_NONNULL_ARG(1);
DLLEXPORT void get_winopts(buf_T *buf);
DLLEXPORT fmark_T *buflist_findfmark(buf_T *buf) FUNC_ATTR_PURE;
DLLEXPORT linenr_T buflist_findlnum(buf_T *buf) FUNC_ATTR_PURE;
DLLEXPORT void buflist_list(exarg_T *eap);
DLLEXPORT int buflist_name_nr(int fnum, char **fname, linenr_T *lnum);
DLLEXPORT int setfname(buf_T *buf, char *ffname_arg, char *sfname_arg, bool message);
DLLEXPORT void buf_set_name(int fnum, char *name);
DLLEXPORT void buf_name_changed(buf_T *buf);
DLLEXPORT buf_T *setaltfname(char *ffname, char *sfname, linenr_T lnum);
DLLEXPORT char *getaltfname(bool errmsg);
DLLEXPORT int buflist_add(char *fname, int flags);
DLLEXPORT void buflist_slash_adjust(void);
DLLEXPORT void buflist_altfpos(win_T *win);
DLLEXPORT bool otherfile(char *ffname) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT FUNC_ATTR_NONNULL_ALL;
DLLEXPORT void buf_set_file_id(buf_T *buf);
DLLEXPORT void fileinfo(int fullname, int shorthelp, bool dont_truncate);
DLLEXPORT int col_print(char *buf, size_t buflen, int col, int vcol);
DLLEXPORT void maketitle(void);
DLLEXPORT void resettitle(void);
DLLEXPORT void free_titles(void);
DLLEXPORT int get_rel_pos(win_T *wp, char *buf, int buflen);
DLLEXPORT int append_arg_number(win_T *wp, char *buf, size_t buflen) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT void fname_expand(buf_T *buf, char **ffname, char **sfname);
DLLEXPORT bool bt_prompt(buf_T *buf) FUNC_ATTR_PURE;
DLLEXPORT void ex_buffer_all(exarg_T *eap);
DLLEXPORT void do_modelines(int flags);
DLLEXPORT bool bt_help(const buf_T *const buf) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool bt_normal(const buf_T *const buf) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool bt_quickfix(const buf_T *const buf) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool bt_terminal(const buf_T *const buf) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool bt_nofilename(const buf_T *const buf) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool bt_nofile(const buf_T *const buf) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool bt_dontwrite(const buf_T *const buf) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool bt_dontwrite_msg(const buf_T *const buf) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool buf_hide(const buf_T *const buf) FUNC_ATTR_PURE;
DLLEXPORT char *buf_spname(buf_T *buf);
DLLEXPORT char *buf_get_fname(const buf_T *buf) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT FUNC_ATTR_NONNULL_ALL;
DLLEXPORT void set_buflisted(int on);
DLLEXPORT bool buf_contents_changed(buf_T *buf) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT void wipe_buffer(buf_T *buf, bool aucmd);
DLLEXPORT int buf_open_scratch(handle_T bufnr, char *bufname);
DLLEXPORT bool buf_is_empty(buf_T *buf);
DLLEXPORT void buf_inc_changedtick(buf_T *const buf) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT void buf_set_changedtick(buf_T *const buf, const varnumber_T changedtick) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT void read_buffer_into(buf_T *buf, linenr_T start, linenr_T end, StringBuilder *sb) FUNC_ATTR_NONNULL_ALL;
#include "nvim/func_attr.h"
