/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* Copyright 2023, 2025 The OpenBLAS Project.                        */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_SAPPHIRERAPIDS;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_SAPPHIRERAPIDS.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES,

  SWITCH_RATIO,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_HFLOAT16
  0, 0, 0,
  SHGEMM_DEFAULT_UNROLL_M, SHGEMM_DEFAULT_UNROLL_N,
#ifdef SHGEMM_DEFAULT_UNROLL_MN
 SHGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SHGEMM_DEFAULT_UNROLL_M, SHGEMM_DEFAULT_UNROLL_N),
#endif
  shgemm_kernel_SAPPHIRERAPIDS, shgemm_beta_SAPPHIRERAPIDS,
#if SHGEMM_DEFAULT_UNROLL_M != SHGEMM_DEFAULT_UNROLL_N
  shgemm_incopy_SAPPHIRERAPIDS, shgemm_itcopy_SAPPHIRERAPIDS,
#else
  shgemm_oncopy_SAPPHIRERAPIDS, shgemm_otcopy_SAPPHIRERAPIDS,
#endif
  shgemm_oncopy_SAPPHIRERAPIDS, shgemm_otcopy_SAPPHIRERAPIDS,
  shgemv_n_SAPPHIRERAPIDS, shgemv_t_SAPPHIRERAPIDS,
#endif

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  BGEMM_DEFAULT_UNROLL_M, BGEMM_DEFAULT_UNROLL_N,
#ifdef BGEMM_DEFAULT_UNROLL_MN
 BGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(BGEMM_DEFAULT_UNROLL_M, BGEMM_DEFAULT_UNROLL_N),
#endif
  BGEMM_ALIGN_K,

  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  SBGEMM_ALIGN_K,
  0, // need_amxtile_permission

  sbstobf16_k_SAPPHIRERAPIDS, sbdtobf16_k_SAPPHIRERAPIDS, sbf16tos_k_SAPPHIRERAPIDS, dbf16tod_k_SAPPHIRERAPIDS,

  samax_k_SAPPHIRERAPIDS,  samin_k_SAPPHIRERAPIDS,  smax_k_SAPPHIRERAPIDS,  smin_k_SAPPHIRERAPIDS,
  isamax_k_SAPPHIRERAPIDS, isamin_k_SAPPHIRERAPIDS, ismax_k_SAPPHIRERAPIDS, ismin_k_SAPPHIRERAPIDS,
  snrm2_k_SAPPHIRERAPIDS,  sasum_k_SAPPHIRERAPIDS,  ssum_k_SAPPHIRERAPIDS, scopy_k_SAPPHIRERAPIDS, sbdot_k_SAPPHIRERAPIDS,
  dsdot_k_SAPPHIRERAPIDS,
  srot_k_SAPPHIRERAPIDS,   srotm_k_SAPPHIRERAPIDS, bscal_k_SAPPHIRERAPIDS, saxpy_k_SAPPHIRERAPIDS,  sscal_k_SAPPHIRERAPIDS, sswap_k_SAPPHIRERAPIDS,
  bgemv_n_SAPPHIRERAPIDS, bgemv_t_SAPPHIRERAPIDS, sbgemv_n_SAPPHIRERAPIDS, sbgemv_t_SAPPHIRERAPIDS, sger_k_SAPPHIRERAPIDS,
  ssymv_L_SAPPHIRERAPIDS, ssymv_U_SAPPHIRERAPIDS,

  bgemm_kernel_SAPPHIRERAPIDS, bgemm_beta_SAPPHIRERAPIDS,
#if BGEMM_DEFAULT_UNROLL_M != BGEMM_DEFAULT_UNROLL_N
  bgemm_incopy_SAPPHIRERAPIDS, bgemm_itcopy_SAPPHIRERAPIDS,
#else
  bgemm_oncopy_SAPPHIRERAPIDS, bgemm_otcopy_SAPPHIRERAPIDS,
#endif
  bgemm_oncopy_SAPPHIRERAPIDS, bgemm_otcopy_SAPPHIRERAPIDS,

  sbgemm_kernel_SAPPHIRERAPIDS, sbgemm_beta_SAPPHIRERAPIDS,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_SAPPHIRERAPIDS, sbgemm_itcopy_SAPPHIRERAPIDS,
#else
  sbgemm_oncopy_SAPPHIRERAPIDS, sbgemm_otcopy_SAPPHIRERAPIDS,
#endif
  sbgemm_oncopy_SAPPHIRERAPIDS, sbgemm_otcopy_SAPPHIRERAPIDS,

  strsm_kernel_LN_SAPPHIRERAPIDS, strsm_kernel_LT_SAPPHIRERAPIDS, strsm_kernel_RN_SAPPHIRERAPIDS, strsm_kernel_RT_SAPPHIRERAPIDS,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_SAPPHIRERAPIDS, strsm_iunncopy_SAPPHIRERAPIDS, strsm_iutucopy_SAPPHIRERAPIDS, strsm_iutncopy_SAPPHIRERAPIDS,
  strsm_ilnucopy_SAPPHIRERAPIDS, strsm_ilnncopy_SAPPHIRERAPIDS, strsm_iltucopy_SAPPHIRERAPIDS, strsm_iltncopy_SAPPHIRERAPIDS,
#else
  strsm_ounucopy_SAPPHIRERAPIDS, strsm_ounncopy_SAPPHIRERAPIDS, strsm_outucopy_SAPPHIRERAPIDS, strsm_outncopy_SAPPHIRERAPIDS,
  strsm_olnucopy_SAPPHIRERAPIDS, strsm_olnncopy_SAPPHIRERAPIDS, strsm_oltucopy_SAPPHIRERAPIDS, strsm_oltncopy_SAPPHIRERAPIDS,
#endif
  strsm_ounucopy_SAPPHIRERAPIDS, strsm_ounncopy_SAPPHIRERAPIDS, strsm_outucopy_SAPPHIRERAPIDS, strsm_outncopy_SAPPHIRERAPIDS,
  strsm_olnucopy_SAPPHIRERAPIDS, strsm_olnncopy_SAPPHIRERAPIDS, strsm_oltucopy_SAPPHIRERAPIDS, strsm_oltncopy_SAPPHIRERAPIDS,
  strmm_kernel_RN_SAPPHIRERAPIDS, strmm_kernel_RT_SAPPHIRERAPIDS, strmm_kernel_LN_SAPPHIRERAPIDS, strmm_kernel_LT_SAPPHIRERAPIDS,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_SAPPHIRERAPIDS, strmm_iunncopy_SAPPHIRERAPIDS, strmm_iutucopy_SAPPHIRERAPIDS, strmm_iutncopy_SAPPHIRERAPIDS,
  strmm_ilnucopy_SAPPHIRERAPIDS, strmm_ilnncopy_SAPPHIRERAPIDS, strmm_iltucopy_SAPPHIRERAPIDS, strmm_iltncopy_SAPPHIRERAPIDS,
#else
  strmm_ounucopy_SAPPHIRERAPIDS, strmm_ounncopy_SAPPHIRERAPIDS, strmm_outucopy_SAPPHIRERAPIDS, strmm_outncopy_SAPPHIRERAPIDS,
  strmm_olnucopy_SAPPHIRERAPIDS, strmm_olnncopy_SAPPHIRERAPIDS, strmm_oltucopy_SAPPHIRERAPIDS, strmm_oltncopy_SAPPHIRERAPIDS,
#endif
  strmm_ounucopy_SAPPHIRERAPIDS, strmm_ounncopy_SAPPHIRERAPIDS, strmm_outucopy_SAPPHIRERAPIDS, strmm_outncopy_SAPPHIRERAPIDS,
  strmm_olnucopy_SAPPHIRERAPIDS, strmm_olnncopy_SAPPHIRERAPIDS, strmm_oltucopy_SAPPHIRERAPIDS, strmm_oltncopy_SAPPHIRERAPIDS,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_SAPPHIRERAPIDS, ssymm_iltcopy_SAPPHIRERAPIDS,
#else
  ssymm_outcopy_SAPPHIRERAPIDS, ssymm_oltcopy_SAPPHIRERAPIDS,
#endif
  ssymm_outcopy_SAPPHIRERAPIDS, ssymm_oltcopy_SAPPHIRERAPIDS,

#ifndef NO_LAPACK
  sneg_tcopy_SAPPHIRERAPIDS, slaswp_ncopy_SAPPHIRERAPIDS,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_SAPPHIRERAPIDS,
  sbgemm_small_kernel_nn_SAPPHIRERAPIDS, sbgemm_small_kernel_nt_SAPPHIRERAPIDS, sbgemm_small_kernel_tn_SAPPHIRERAPIDS, sbgemm_small_kernel_tt_SAPPHIRERAPIDS,
  sbgemm_small_kernel_b0_nn_SAPPHIRERAPIDS, sbgemm_small_kernel_b0_nt_SAPPHIRERAPIDS, sbgemm_small_kernel_b0_tn_SAPPHIRERAPIDS, sbgemm_small_kernel_b0_tt_SAPPHIRERAPIDS,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  samax_k_SAPPHIRERAPIDS,  samin_k_SAPPHIRERAPIDS,  smax_k_SAPPHIRERAPIDS,  smin_k_SAPPHIRERAPIDS,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  isamax_k_SAPPHIRERAPIDS,
#endif 
#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  isamin_k_SAPPHIRERAPIDS, ismax_k_SAPPHIRERAPIDS, ismin_k_SAPPHIRERAPIDS,
  snrm2_k_SAPPHIRERAPIDS,  sasum_k_SAPPHIRERAPIDS,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_SAPPHIRERAPIDS,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_SAPPHIRERAPIDS, sdot_k_SAPPHIRERAPIDS,
//  dsdot_k_SAPPHIRERAPIDS,
  srot_k_SAPPHIRERAPIDS,  srotm_k_SAPPHIRERAPIDS,  saxpy_k_SAPPHIRERAPIDS,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_SAPPHIRERAPIDS,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_SAPPHIRERAPIDS,
  sgemv_n_SAPPHIRERAPIDS,  sgemv_t_SAPPHIRERAPIDS,
#endif
#if BUILD_SINGLE == 1
  sger_k_SAPPHIRERAPIDS,
#endif
#if BUILD_SINGLE == 1  
  ssymv_L_SAPPHIRERAPIDS, ssymv_U_SAPPHIRERAPIDS,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_SAPPHIRERAPIDS,
  sgemm_direct_performant_SAPPHIRERAPIDS,	
#endif
#ifdef ARCH_ARM64
  sgemm_direct_SAPPHIRERAPIDS,
  sgemm_direct_alpha_beta_SAPPHIRERAPIDS,
  ssymm_direct_alpha_betaLU_SAPPHIRERAPIDS,
  ssymm_direct_alpha_betaLL_SAPPHIRERAPIDS,
  strmm_direct_LNUN_SAPPHIRERAPIDS,
  strmm_direct_LNLN_SAPPHIRERAPIDS,
  strmm_direct_LTUN_SAPPHIRERAPIDS,
  strmm_direct_LTLN_SAPPHIRERAPIDS,
#endif

  sgemm_kernel_SAPPHIRERAPIDS, sgemm_beta_SAPPHIRERAPIDS,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_SAPPHIRERAPIDS, sgemm_itcopy_SAPPHIRERAPIDS,
#else
  sgemm_oncopy_SAPPHIRERAPIDS, sgemm_otcopy_SAPPHIRERAPIDS,
#endif
  sgemm_oncopy_SAPPHIRERAPIDS, sgemm_otcopy_SAPPHIRERAPIDS,
#endif

#if BUILD_SINGLE == 1 || BUILD_DOUBLE == 1 || BUILD_COMPLEX == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_SAPPHIRERAPIDS,
  sgemm_small_kernel_nn_SAPPHIRERAPIDS, sgemm_small_kernel_nt_SAPPHIRERAPIDS, sgemm_small_kernel_tn_SAPPHIRERAPIDS, sgemm_small_kernel_tt_SAPPHIRERAPIDS,
  sgemm_small_kernel_b0_nn_SAPPHIRERAPIDS, sgemm_small_kernel_b0_nt_SAPPHIRERAPIDS, sgemm_small_kernel_b0_tn_SAPPHIRERAPIDS, sgemm_small_kernel_b0_tt_SAPPHIRERAPIDS,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX == 1)
  strsm_kernel_LN_SAPPHIRERAPIDS, strsm_kernel_LT_SAPPHIRERAPIDS, strsm_kernel_RN_SAPPHIRERAPIDS, strsm_kernel_RT_SAPPHIRERAPIDS,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_SAPPHIRERAPIDS, strsm_iunncopy_SAPPHIRERAPIDS, strsm_iutucopy_SAPPHIRERAPIDS, strsm_iutncopy_SAPPHIRERAPIDS,
  strsm_ilnucopy_SAPPHIRERAPIDS, strsm_ilnncopy_SAPPHIRERAPIDS, strsm_iltucopy_SAPPHIRERAPIDS, strsm_iltncopy_SAPPHIRERAPIDS,
#else
  strsm_ounucopy_SAPPHIRERAPIDS, strsm_ounncopy_SAPPHIRERAPIDS, strsm_outucopy_SAPPHIRERAPIDS, strsm_outncopy_SAPPHIRERAPIDS,
  strsm_olnucopy_SAPPHIRERAPIDS, strsm_olnncopy_SAPPHIRERAPIDS, strsm_oltucopy_SAPPHIRERAPIDS, strsm_oltncopy_SAPPHIRERAPIDS,
#endif
  strsm_ounucopy_SAPPHIRERAPIDS, strsm_ounncopy_SAPPHIRERAPIDS, strsm_outucopy_SAPPHIRERAPIDS, strsm_outncopy_SAPPHIRERAPIDS,
  strsm_olnucopy_SAPPHIRERAPIDS, strsm_olnncopy_SAPPHIRERAPIDS, strsm_oltucopy_SAPPHIRERAPIDS, strsm_oltncopy_SAPPHIRERAPIDS,
#endif
#if (BUILD_SINGLE==1)
  strmm_kernel_RN_SAPPHIRERAPIDS, strmm_kernel_RT_SAPPHIRERAPIDS, strmm_kernel_LN_SAPPHIRERAPIDS, strmm_kernel_LT_SAPPHIRERAPIDS,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_SAPPHIRERAPIDS, strmm_iunncopy_SAPPHIRERAPIDS, strmm_iutucopy_SAPPHIRERAPIDS, strmm_iutncopy_SAPPHIRERAPIDS,
  strmm_ilnucopy_SAPPHIRERAPIDS, strmm_ilnncopy_SAPPHIRERAPIDS, strmm_iltucopy_SAPPHIRERAPIDS, strmm_iltncopy_SAPPHIRERAPIDS,
#else
  strmm_ounucopy_SAPPHIRERAPIDS, strmm_ounncopy_SAPPHIRERAPIDS, strmm_outucopy_SAPPHIRERAPIDS, strmm_outncopy_SAPPHIRERAPIDS,
  strmm_olnucopy_SAPPHIRERAPIDS, strmm_olnncopy_SAPPHIRERAPIDS, strmm_oltucopy_SAPPHIRERAPIDS, strmm_oltncopy_SAPPHIRERAPIDS,
#endif
  strmm_ounucopy_SAPPHIRERAPIDS, strmm_ounncopy_SAPPHIRERAPIDS, strmm_outucopy_SAPPHIRERAPIDS, strmm_outncopy_SAPPHIRERAPIDS,
  strmm_olnucopy_SAPPHIRERAPIDS, strmm_olnncopy_SAPPHIRERAPIDS, strmm_oltucopy_SAPPHIRERAPIDS, strmm_oltncopy_SAPPHIRERAPIDS,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_SAPPHIRERAPIDS, ssymm_iltcopy_SAPPHIRERAPIDS,
#else
  ssymm_outcopy_SAPPHIRERAPIDS, ssymm_oltcopy_SAPPHIRERAPIDS,
#endif
  ssymm_outcopy_SAPPHIRERAPIDS, ssymm_oltcopy_SAPPHIRERAPIDS,
#ifndef NO_LAPACK
  sneg_tcopy_SAPPHIRERAPIDS, slaswp_ncopy_SAPPHIRERAPIDS,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  damax_k_SAPPHIRERAPIDS,  damin_k_SAPPHIRERAPIDS,  dmax_k_SAPPHIRERAPIDS,  dmin_k_SAPPHIRERAPIDS,
  idamax_k_SAPPHIRERAPIDS, idamin_k_SAPPHIRERAPIDS, idmax_k_SAPPHIRERAPIDS, idmin_k_SAPPHIRERAPIDS,
  dnrm2_k_SAPPHIRERAPIDS, dasum_k_SAPPHIRERAPIDS,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_SAPPHIRERAPIDS,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dcopy_k_SAPPHIRERAPIDS, ddot_k_SAPPHIRERAPIDS,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_SAPPHIRERAPIDS,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  drot_k_SAPPHIRERAPIDS,
  drotm_k_SAPPHIRERAPIDS,
  daxpy_k_SAPPHIRERAPIDS,
  dscal_k_SAPPHIRERAPIDS, 
  dswap_k_SAPPHIRERAPIDS,
  dgemv_n_SAPPHIRERAPIDS,  dgemv_t_SAPPHIRERAPIDS,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_SAPPHIRERAPIDS,
  dsymv_L_SAPPHIRERAPIDS,  dsymv_U_SAPPHIRERAPIDS,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dgemm_kernel_SAPPHIRERAPIDS, dgemm_beta_SAPPHIRERAPIDS,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_SAPPHIRERAPIDS, dgemm_itcopy_SAPPHIRERAPIDS,
#else
  dgemm_oncopy_SAPPHIRERAPIDS, dgemm_otcopy_SAPPHIRERAPIDS,
#endif
  dgemm_oncopy_SAPPHIRERAPIDS, dgemm_otcopy_SAPPHIRERAPIDS,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_SAPPHIRERAPIDS,
  dgemm_small_kernel_nn_SAPPHIRERAPIDS, dgemm_small_kernel_nt_SAPPHIRERAPIDS, dgemm_small_kernel_tn_SAPPHIRERAPIDS, dgemm_small_kernel_tt_SAPPHIRERAPIDS,
  dgemm_small_kernel_b0_nn_SAPPHIRERAPIDS, dgemm_small_kernel_b0_nt_SAPPHIRERAPIDS, dgemm_small_kernel_b0_tn_SAPPHIRERAPIDS, dgemm_small_kernel_b0_tt_SAPPHIRERAPIDS,
#endif
#endif
#if  (BUILD_DOUBLE==1)   
  dtrsm_kernel_LN_SAPPHIRERAPIDS, dtrsm_kernel_LT_SAPPHIRERAPIDS, dtrsm_kernel_RN_SAPPHIRERAPIDS, dtrsm_kernel_RT_SAPPHIRERAPIDS,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_SAPPHIRERAPIDS, dtrsm_iunncopy_SAPPHIRERAPIDS, dtrsm_iutucopy_SAPPHIRERAPIDS, dtrsm_iutncopy_SAPPHIRERAPIDS,
  dtrsm_ilnucopy_SAPPHIRERAPIDS, dtrsm_ilnncopy_SAPPHIRERAPIDS, dtrsm_iltucopy_SAPPHIRERAPIDS, dtrsm_iltncopy_SAPPHIRERAPIDS,
#else
  dtrsm_ounucopy_SAPPHIRERAPIDS, dtrsm_ounncopy_SAPPHIRERAPIDS, dtrsm_outucopy_SAPPHIRERAPIDS, dtrsm_outncopy_SAPPHIRERAPIDS,
  dtrsm_olnucopy_SAPPHIRERAPIDS, dtrsm_olnncopy_SAPPHIRERAPIDS, dtrsm_oltucopy_SAPPHIRERAPIDS, dtrsm_oltncopy_SAPPHIRERAPIDS,
#endif
  dtrsm_ounucopy_SAPPHIRERAPIDS, dtrsm_ounncopy_SAPPHIRERAPIDS, dtrsm_outucopy_SAPPHIRERAPIDS, dtrsm_outncopy_SAPPHIRERAPIDS,
  dtrsm_olnucopy_SAPPHIRERAPIDS, dtrsm_olnncopy_SAPPHIRERAPIDS, dtrsm_oltucopy_SAPPHIRERAPIDS, dtrsm_oltncopy_SAPPHIRERAPIDS,
  dtrmm_kernel_RN_SAPPHIRERAPIDS, dtrmm_kernel_RT_SAPPHIRERAPIDS, dtrmm_kernel_LN_SAPPHIRERAPIDS, dtrmm_kernel_LT_SAPPHIRERAPIDS,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_SAPPHIRERAPIDS, dtrmm_iunncopy_SAPPHIRERAPIDS, dtrmm_iutucopy_SAPPHIRERAPIDS, dtrmm_iutncopy_SAPPHIRERAPIDS,
  dtrmm_ilnucopy_SAPPHIRERAPIDS, dtrmm_ilnncopy_SAPPHIRERAPIDS, dtrmm_iltucopy_SAPPHIRERAPIDS, dtrmm_iltncopy_SAPPHIRERAPIDS,
#else
  dtrmm_ounucopy_SAPPHIRERAPIDS, dtrmm_ounncopy_SAPPHIRERAPIDS, dtrmm_outucopy_SAPPHIRERAPIDS, dtrmm_outncopy_SAPPHIRERAPIDS,
  dtrmm_olnucopy_SAPPHIRERAPIDS, dtrmm_olnncopy_SAPPHIRERAPIDS, dtrmm_oltucopy_SAPPHIRERAPIDS, dtrmm_oltncopy_SAPPHIRERAPIDS,
#endif
  dtrmm_ounucopy_SAPPHIRERAPIDS, dtrmm_ounncopy_SAPPHIRERAPIDS, dtrmm_outucopy_SAPPHIRERAPIDS, dtrmm_outncopy_SAPPHIRERAPIDS,
  dtrmm_olnucopy_SAPPHIRERAPIDS, dtrmm_olnncopy_SAPPHIRERAPIDS, dtrmm_oltucopy_SAPPHIRERAPIDS, dtrmm_oltncopy_SAPPHIRERAPIDS,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_SAPPHIRERAPIDS, dsymm_iltcopy_SAPPHIRERAPIDS,
#else
  dsymm_outcopy_SAPPHIRERAPIDS, dsymm_oltcopy_SAPPHIRERAPIDS,
#endif
  dsymm_outcopy_SAPPHIRERAPIDS, dsymm_oltcopy_SAPPHIRERAPIDS,

#ifndef NO_LAPACK
  dneg_tcopy_SAPPHIRERAPIDS, dlaswp_ncopy_SAPPHIRERAPIDS,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_SAPPHIRERAPIDS,  qamin_k_SAPPHIRERAPIDS,  qmax_k_SAPPHIRERAPIDS,  qmin_k_SAPPHIRERAPIDS,
  iqamax_k_SAPPHIRERAPIDS, iqamin_k_SAPPHIRERAPIDS, iqmax_k_SAPPHIRERAPIDS, iqmin_k_SAPPHIRERAPIDS,
  qnrm2_k_SAPPHIRERAPIDS,  qasum_k_SAPPHIRERAPIDS,  qsum_k_SAPPHIRERAPIDS, qcopy_k_SAPPHIRERAPIDS, qdot_k_SAPPHIRERAPIDS,
  qrot_k_SAPPHIRERAPIDS,   qrotm_k_SAPPHIRERAPIDS,  qaxpy_k_SAPPHIRERAPIDS,  qscal_k_SAPPHIRERAPIDS, qswap_k_SAPPHIRERAPIDS,
  qgemv_n_SAPPHIRERAPIDS,  qgemv_t_SAPPHIRERAPIDS,  qger_k_SAPPHIRERAPIDS,
  qsymv_L_SAPPHIRERAPIDS,  qsymv_U_SAPPHIRERAPIDS,
  qgemm_kernel_SAPPHIRERAPIDS, qgemm_beta_SAPPHIRERAPIDS,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_SAPPHIRERAPIDS, qgemm_itcopy_SAPPHIRERAPIDS,
#else
  qgemm_oncopy_SAPPHIRERAPIDS, qgemm_otcopy_SAPPHIRERAPIDS,
#endif
  qgemm_oncopy_SAPPHIRERAPIDS, qgemm_otcopy_SAPPHIRERAPIDS,
  qtrsm_kernel_LN_SAPPHIRERAPIDS, qtrsm_kernel_LT_SAPPHIRERAPIDS, qtrsm_kernel_RN_SAPPHIRERAPIDS, qtrsm_kernel_RT_SAPPHIRERAPIDS,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_SAPPHIRERAPIDS, qtrsm_iunncopy_SAPPHIRERAPIDS, qtrsm_iutucopy_SAPPHIRERAPIDS, qtrsm_iutncopy_SAPPHIRERAPIDS,
  qtrsm_ilnucopy_SAPPHIRERAPIDS, qtrsm_ilnncopy_SAPPHIRERAPIDS, qtrsm_iltucopy_SAPPHIRERAPIDS, qtrsm_iltncopy_SAPPHIRERAPIDS,
#else
  qtrsm_ounucopy_SAPPHIRERAPIDS, qtrsm_ounncopy_SAPPHIRERAPIDS, qtrsm_outucopy_SAPPHIRERAPIDS, qtrsm_outncopy_SAPPHIRERAPIDS,
  qtrsm_olnucopy_SAPPHIRERAPIDS, qtrsm_olnncopy_SAPPHIRERAPIDS, qtrsm_oltucopy_SAPPHIRERAPIDS, qtrsm_oltncopy_SAPPHIRERAPIDS,
#endif
  qtrsm_ounucopy_SAPPHIRERAPIDS, qtrsm_ounncopy_SAPPHIRERAPIDS, qtrsm_outucopy_SAPPHIRERAPIDS, qtrsm_outncopy_SAPPHIRERAPIDS,
  qtrsm_olnucopy_SAPPHIRERAPIDS, qtrsm_olnncopy_SAPPHIRERAPIDS, qtrsm_oltucopy_SAPPHIRERAPIDS, qtrsm_oltncopy_SAPPHIRERAPIDS,
  qtrmm_kernel_RN_SAPPHIRERAPIDS, qtrmm_kernel_RT_SAPPHIRERAPIDS, qtrmm_kernel_LN_SAPPHIRERAPIDS, qtrmm_kernel_LT_SAPPHIRERAPIDS,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_SAPPHIRERAPIDS, qtrmm_iunncopy_SAPPHIRERAPIDS, qtrmm_iutucopy_SAPPHIRERAPIDS, qtrmm_iutncopy_SAPPHIRERAPIDS,
  qtrmm_ilnucopy_SAPPHIRERAPIDS, qtrmm_ilnncopy_SAPPHIRERAPIDS, qtrmm_iltucopy_SAPPHIRERAPIDS, qtrmm_iltncopy_SAPPHIRERAPIDS,
#else
  qtrmm_ounucopy_SAPPHIRERAPIDS, qtrmm_ounncopy_SAPPHIRERAPIDS, qtrmm_outucopy_SAPPHIRERAPIDS, qtrmm_outncopy_SAPPHIRERAPIDS,
  qtrmm_olnucopy_SAPPHIRERAPIDS, qtrmm_olnncopy_SAPPHIRERAPIDS, qtrmm_oltucopy_SAPPHIRERAPIDS, qtrmm_oltncopy_SAPPHIRERAPIDS,
#endif
  qtrmm_ounucopy_SAPPHIRERAPIDS, qtrmm_ounncopy_SAPPHIRERAPIDS, qtrmm_outucopy_SAPPHIRERAPIDS, qtrmm_outncopy_SAPPHIRERAPIDS,
  qtrmm_olnucopy_SAPPHIRERAPIDS, qtrmm_olnncopy_SAPPHIRERAPIDS, qtrmm_oltucopy_SAPPHIRERAPIDS, qtrmm_oltncopy_SAPPHIRERAPIDS,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_SAPPHIRERAPIDS, qsymm_iltcopy_SAPPHIRERAPIDS,
#else
  qsymm_outcopy_SAPPHIRERAPIDS, qsymm_oltcopy_SAPPHIRERAPIDS,
#endif
  qsymm_outcopy_SAPPHIRERAPIDS, qsymm_oltcopy_SAPPHIRERAPIDS,

#ifndef NO_LAPACK
  qneg_tcopy_SAPPHIRERAPIDS, qlaswp_ncopy_SAPPHIRERAPIDS,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
#if (BUILD_COMPLEX)
  camax_k_SAPPHIRERAPIDS, camin_k_SAPPHIRERAPIDS,
#endif
#if (BUILD_COMPLEX)
  icamax_k_SAPPHIRERAPIDS, 
#endif
#if (BUILD_COMPLEX)
  icamin_k_SAPPHIRERAPIDS,
  cnrm2_k_SAPPHIRERAPIDS, casum_k_SAPPHIRERAPIDS, csum_k_SAPPHIRERAPIDS,
#endif
#if (BUILD_COMPLEX)
  ccopy_k_SAPPHIRERAPIDS, cdotu_k_SAPPHIRERAPIDS, cdotc_k_SAPPHIRERAPIDS,
#endif
#if (BUILD_COMPLEX)
 csrot_k_SAPPHIRERAPIDS,
#endif
#if (BUILD_COMPLEX)
  caxpy_k_SAPPHIRERAPIDS,
  caxpyc_k_SAPPHIRERAPIDS, 
  cscal_k_SAPPHIRERAPIDS, 
  cswap_k_SAPPHIRERAPIDS,

  cgemv_n_SAPPHIRERAPIDS, cgemv_t_SAPPHIRERAPIDS, cgemv_r_SAPPHIRERAPIDS, cgemv_c_SAPPHIRERAPIDS,
  cgemv_o_SAPPHIRERAPIDS, cgemv_u_SAPPHIRERAPIDS, cgemv_s_SAPPHIRERAPIDS, cgemv_d_SAPPHIRERAPIDS,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_SAPPHIRERAPIDS, cgerc_k_SAPPHIRERAPIDS, cgerv_k_SAPPHIRERAPIDS, cgerd_k_SAPPHIRERAPIDS,
  csymv_L_SAPPHIRERAPIDS, csymv_U_SAPPHIRERAPIDS,
  chemv_L_SAPPHIRERAPIDS, chemv_U_SAPPHIRERAPIDS, chemv_M_SAPPHIRERAPIDS, chemv_V_SAPPHIRERAPIDS,
#endif
#if (BUILD_COMPLEX)
  cgemm_kernel_n_SAPPHIRERAPIDS, cgemm_kernel_l_SAPPHIRERAPIDS, cgemm_kernel_r_SAPPHIRERAPIDS, cgemm_kernel_b_SAPPHIRERAPIDS,
  cgemm_beta_SAPPHIRERAPIDS,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_SAPPHIRERAPIDS, cgemm_itcopy_SAPPHIRERAPIDS,
#else
  cgemm_oncopy_SAPPHIRERAPIDS, cgemm_otcopy_SAPPHIRERAPIDS,
#endif
  cgemm_oncopy_SAPPHIRERAPIDS, cgemm_otcopy_SAPPHIRERAPIDS,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_SAPPHIRERAPIDS,
  cgemm_small_kernel_nn_SAPPHIRERAPIDS, cgemm_small_kernel_nt_SAPPHIRERAPIDS, cgemm_small_kernel_nr_SAPPHIRERAPIDS, cgemm_small_kernel_nc_SAPPHIRERAPIDS,
  cgemm_small_kernel_tn_SAPPHIRERAPIDS, cgemm_small_kernel_tt_SAPPHIRERAPIDS, cgemm_small_kernel_tr_SAPPHIRERAPIDS, cgemm_small_kernel_tc_SAPPHIRERAPIDS,
  cgemm_small_kernel_rn_SAPPHIRERAPIDS, cgemm_small_kernel_rt_SAPPHIRERAPIDS, cgemm_small_kernel_rr_SAPPHIRERAPIDS, cgemm_small_kernel_rc_SAPPHIRERAPIDS,
  cgemm_small_kernel_cn_SAPPHIRERAPIDS, cgemm_small_kernel_ct_SAPPHIRERAPIDS, cgemm_small_kernel_cr_SAPPHIRERAPIDS, cgemm_small_kernel_cc_SAPPHIRERAPIDS,
  cgemm_small_kernel_b0_nn_SAPPHIRERAPIDS, cgemm_small_kernel_b0_nt_SAPPHIRERAPIDS, cgemm_small_kernel_b0_nr_SAPPHIRERAPIDS, cgemm_small_kernel_b0_nc_SAPPHIRERAPIDS,
  cgemm_small_kernel_b0_tn_SAPPHIRERAPIDS, cgemm_small_kernel_b0_tt_SAPPHIRERAPIDS, cgemm_small_kernel_b0_tr_SAPPHIRERAPIDS, cgemm_small_kernel_b0_tc_SAPPHIRERAPIDS,
  cgemm_small_kernel_b0_rn_SAPPHIRERAPIDS, cgemm_small_kernel_b0_rt_SAPPHIRERAPIDS, cgemm_small_kernel_b0_rr_SAPPHIRERAPIDS, cgemm_small_kernel_b0_rc_SAPPHIRERAPIDS,
  cgemm_small_kernel_b0_cn_SAPPHIRERAPIDS, cgemm_small_kernel_b0_ct_SAPPHIRERAPIDS, cgemm_small_kernel_b0_cr_SAPPHIRERAPIDS, cgemm_small_kernel_b0_cc_SAPPHIRERAPIDS,
#endif

  ctrsm_kernel_LN_SAPPHIRERAPIDS, ctrsm_kernel_LT_SAPPHIRERAPIDS, ctrsm_kernel_LR_SAPPHIRERAPIDS, ctrsm_kernel_LC_SAPPHIRERAPIDS,
  ctrsm_kernel_RN_SAPPHIRERAPIDS, ctrsm_kernel_RT_SAPPHIRERAPIDS, ctrsm_kernel_RR_SAPPHIRERAPIDS, ctrsm_kernel_RC_SAPPHIRERAPIDS,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_SAPPHIRERAPIDS,  ctrsm_iunncopy_SAPPHIRERAPIDS,  ctrsm_iutucopy_SAPPHIRERAPIDS,  ctrsm_iutncopy_SAPPHIRERAPIDS,
  ctrsm_ilnucopy_SAPPHIRERAPIDS,  ctrsm_ilnncopy_SAPPHIRERAPIDS,  ctrsm_iltucopy_SAPPHIRERAPIDS,  ctrsm_iltncopy_SAPPHIRERAPIDS,
#else
  ctrsm_ounucopy_SAPPHIRERAPIDS,  ctrsm_ounncopy_SAPPHIRERAPIDS,  ctrsm_outucopy_SAPPHIRERAPIDS,  ctrsm_outncopy_SAPPHIRERAPIDS,
  ctrsm_olnucopy_SAPPHIRERAPIDS,  ctrsm_olnncopy_SAPPHIRERAPIDS,  ctrsm_oltucopy_SAPPHIRERAPIDS,  ctrsm_oltncopy_SAPPHIRERAPIDS,
#endif
  ctrsm_ounucopy_SAPPHIRERAPIDS,  ctrsm_ounncopy_SAPPHIRERAPIDS,  ctrsm_outucopy_SAPPHIRERAPIDS,  ctrsm_outncopy_SAPPHIRERAPIDS,
  ctrsm_olnucopy_SAPPHIRERAPIDS,  ctrsm_olnncopy_SAPPHIRERAPIDS,  ctrsm_oltucopy_SAPPHIRERAPIDS,  ctrsm_oltncopy_SAPPHIRERAPIDS,
#endif
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_SAPPHIRERAPIDS,  ctrmm_kernel_RT_SAPPHIRERAPIDS,  ctrmm_kernel_RR_SAPPHIRERAPIDS,  ctrmm_kernel_RC_SAPPHIRERAPIDS,
  ctrmm_kernel_LN_SAPPHIRERAPIDS,  ctrmm_kernel_LT_SAPPHIRERAPIDS,  ctrmm_kernel_LR_SAPPHIRERAPIDS,  ctrmm_kernel_LC_SAPPHIRERAPIDS,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_SAPPHIRERAPIDS,  ctrmm_iunncopy_SAPPHIRERAPIDS,  ctrmm_iutucopy_SAPPHIRERAPIDS,  ctrmm_iutncopy_SAPPHIRERAPIDS,
  ctrmm_ilnucopy_SAPPHIRERAPIDS,  ctrmm_ilnncopy_SAPPHIRERAPIDS,  ctrmm_iltucopy_SAPPHIRERAPIDS,  ctrmm_iltncopy_SAPPHIRERAPIDS,
#else
  ctrmm_ounucopy_SAPPHIRERAPIDS,  ctrmm_ounncopy_SAPPHIRERAPIDS,  ctrmm_outucopy_SAPPHIRERAPIDS,  ctrmm_outncopy_SAPPHIRERAPIDS,
  ctrmm_olnucopy_SAPPHIRERAPIDS,  ctrmm_olnncopy_SAPPHIRERAPIDS,  ctrmm_oltucopy_SAPPHIRERAPIDS,  ctrmm_oltncopy_SAPPHIRERAPIDS,
#endif
  ctrmm_ounucopy_SAPPHIRERAPIDS,  ctrmm_ounncopy_SAPPHIRERAPIDS,  ctrmm_outucopy_SAPPHIRERAPIDS,  ctrmm_outncopy_SAPPHIRERAPIDS,
  ctrmm_olnucopy_SAPPHIRERAPIDS,  ctrmm_olnncopy_SAPPHIRERAPIDS,  ctrmm_oltucopy_SAPPHIRERAPIDS,  ctrmm_oltncopy_SAPPHIRERAPIDS,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_SAPPHIRERAPIDS,  csymm_iltcopy_SAPPHIRERAPIDS,
#else
  csymm_outcopy_SAPPHIRERAPIDS,  csymm_oltcopy_SAPPHIRERAPIDS,
#endif
  csymm_outcopy_SAPPHIRERAPIDS,  csymm_oltcopy_SAPPHIRERAPIDS,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_SAPPHIRERAPIDS,  chemm_iltcopy_SAPPHIRERAPIDS,
#else
  chemm_outcopy_SAPPHIRERAPIDS,  chemm_oltcopy_SAPPHIRERAPIDS,
#endif
  chemm_outcopy_SAPPHIRERAPIDS,  chemm_oltcopy_SAPPHIRERAPIDS,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_SAPPHIRERAPIDS,

  cgemm3m_incopyb_SAPPHIRERAPIDS,  cgemm3m_incopyr_SAPPHIRERAPIDS,
  cgemm3m_incopyi_SAPPHIRERAPIDS,  cgemm3m_itcopyb_SAPPHIRERAPIDS,
  cgemm3m_itcopyr_SAPPHIRERAPIDS,  cgemm3m_itcopyi_SAPPHIRERAPIDS,
  cgemm3m_oncopyb_SAPPHIRERAPIDS,  cgemm3m_oncopyr_SAPPHIRERAPIDS,
  cgemm3m_oncopyi_SAPPHIRERAPIDS,  cgemm3m_otcopyb_SAPPHIRERAPIDS,
  cgemm3m_otcopyr_SAPPHIRERAPIDS,  cgemm3m_otcopyi_SAPPHIRERAPIDS,

  csymm3m_iucopyb_SAPPHIRERAPIDS,  csymm3m_ilcopyb_SAPPHIRERAPIDS,
  csymm3m_iucopyr_SAPPHIRERAPIDS,  csymm3m_ilcopyr_SAPPHIRERAPIDS,
  csymm3m_iucopyi_SAPPHIRERAPIDS,  csymm3m_ilcopyi_SAPPHIRERAPIDS,
  csymm3m_oucopyb_SAPPHIRERAPIDS,  csymm3m_olcopyb_SAPPHIRERAPIDS,
  csymm3m_oucopyr_SAPPHIRERAPIDS,  csymm3m_olcopyr_SAPPHIRERAPIDS,
  csymm3m_oucopyi_SAPPHIRERAPIDS,  csymm3m_olcopyi_SAPPHIRERAPIDS,

  chemm3m_iucopyb_SAPPHIRERAPIDS,  chemm3m_ilcopyb_SAPPHIRERAPIDS,
  chemm3m_iucopyr_SAPPHIRERAPIDS,  chemm3m_ilcopyr_SAPPHIRERAPIDS,
  chemm3m_iucopyi_SAPPHIRERAPIDS,  chemm3m_ilcopyi_SAPPHIRERAPIDS,

  chemm3m_oucopyb_SAPPHIRERAPIDS,  chemm3m_olcopyb_SAPPHIRERAPIDS,
  chemm3m_oucopyr_SAPPHIRERAPIDS,  chemm3m_olcopyr_SAPPHIRERAPIDS,
  chemm3m_oucopyi_SAPPHIRERAPIDS,  chemm3m_olcopyi_SAPPHIRERAPIDS,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX)
#ifndef NO_LAPACK
  cneg_tcopy_SAPPHIRERAPIDS,
  
   claswp_ncopy_SAPPHIRERAPIDS,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_SAPPHIRERAPIDS, zamin_k_SAPPHIRERAPIDS, izamax_k_SAPPHIRERAPIDS, izamin_k_SAPPHIRERAPIDS,
  znrm2_k_SAPPHIRERAPIDS, zasum_k_SAPPHIRERAPIDS, zsum_k_SAPPHIRERAPIDS, zcopy_k_SAPPHIRERAPIDS,
  zdotu_k_SAPPHIRERAPIDS, zdotc_k_SAPPHIRERAPIDS, zdrot_k_SAPPHIRERAPIDS,
  zaxpy_k_SAPPHIRERAPIDS, zaxpyc_k_SAPPHIRERAPIDS, zscal_k_SAPPHIRERAPIDS, zswap_k_SAPPHIRERAPIDS,

  zgemv_n_SAPPHIRERAPIDS, zgemv_t_SAPPHIRERAPIDS, zgemv_r_SAPPHIRERAPIDS, zgemv_c_SAPPHIRERAPIDS,
  zgemv_o_SAPPHIRERAPIDS, zgemv_u_SAPPHIRERAPIDS, zgemv_s_SAPPHIRERAPIDS, zgemv_d_SAPPHIRERAPIDS,
  zgeru_k_SAPPHIRERAPIDS, zgerc_k_SAPPHIRERAPIDS, zgerv_k_SAPPHIRERAPIDS, zgerd_k_SAPPHIRERAPIDS,
  zsymv_L_SAPPHIRERAPIDS, zsymv_U_SAPPHIRERAPIDS,
  zhemv_L_SAPPHIRERAPIDS, zhemv_U_SAPPHIRERAPIDS, zhemv_M_SAPPHIRERAPIDS, zhemv_V_SAPPHIRERAPIDS,

  zgemm_kernel_n_SAPPHIRERAPIDS, zgemm_kernel_l_SAPPHIRERAPIDS, zgemm_kernel_r_SAPPHIRERAPIDS, zgemm_kernel_b_SAPPHIRERAPIDS,
  zgemm_beta_SAPPHIRERAPIDS,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_SAPPHIRERAPIDS, zgemm_itcopy_SAPPHIRERAPIDS,
#else
  zgemm_oncopy_SAPPHIRERAPIDS, zgemm_otcopy_SAPPHIRERAPIDS,
#endif
  zgemm_oncopy_SAPPHIRERAPIDS, zgemm_otcopy_SAPPHIRERAPIDS,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_SAPPHIRERAPIDS,
  zgemm_small_kernel_nn_SAPPHIRERAPIDS, zgemm_small_kernel_nt_SAPPHIRERAPIDS, zgemm_small_kernel_nr_SAPPHIRERAPIDS, zgemm_small_kernel_nc_SAPPHIRERAPIDS,
  zgemm_small_kernel_tn_SAPPHIRERAPIDS, zgemm_small_kernel_tt_SAPPHIRERAPIDS, zgemm_small_kernel_tr_SAPPHIRERAPIDS, zgemm_small_kernel_tc_SAPPHIRERAPIDS,
  zgemm_small_kernel_rn_SAPPHIRERAPIDS, zgemm_small_kernel_rt_SAPPHIRERAPIDS, zgemm_small_kernel_rr_SAPPHIRERAPIDS, zgemm_small_kernel_rc_SAPPHIRERAPIDS,
  zgemm_small_kernel_cn_SAPPHIRERAPIDS, zgemm_small_kernel_ct_SAPPHIRERAPIDS, zgemm_small_kernel_cr_SAPPHIRERAPIDS, zgemm_small_kernel_cc_SAPPHIRERAPIDS,
  zgemm_small_kernel_b0_nn_SAPPHIRERAPIDS, zgemm_small_kernel_b0_nt_SAPPHIRERAPIDS, zgemm_small_kernel_b0_nr_SAPPHIRERAPIDS, zgemm_small_kernel_b0_nc_SAPPHIRERAPIDS,
  zgemm_small_kernel_b0_tn_SAPPHIRERAPIDS, zgemm_small_kernel_b0_tt_SAPPHIRERAPIDS, zgemm_small_kernel_b0_tr_SAPPHIRERAPIDS, zgemm_small_kernel_b0_tc_SAPPHIRERAPIDS,
  zgemm_small_kernel_b0_rn_SAPPHIRERAPIDS, zgemm_small_kernel_b0_rt_SAPPHIRERAPIDS, zgemm_small_kernel_b0_rr_SAPPHIRERAPIDS, zgemm_small_kernel_b0_rc_SAPPHIRERAPIDS,
  zgemm_small_kernel_b0_cn_SAPPHIRERAPIDS, zgemm_small_kernel_b0_ct_SAPPHIRERAPIDS, zgemm_small_kernel_b0_cr_SAPPHIRERAPIDS, zgemm_small_kernel_b0_cc_SAPPHIRERAPIDS,
#endif

  ztrsm_kernel_LN_SAPPHIRERAPIDS, ztrsm_kernel_LT_SAPPHIRERAPIDS, ztrsm_kernel_LR_SAPPHIRERAPIDS, ztrsm_kernel_LC_SAPPHIRERAPIDS,
  ztrsm_kernel_RN_SAPPHIRERAPIDS, ztrsm_kernel_RT_SAPPHIRERAPIDS, ztrsm_kernel_RR_SAPPHIRERAPIDS, ztrsm_kernel_RC_SAPPHIRERAPIDS,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_SAPPHIRERAPIDS,  ztrsm_iunncopy_SAPPHIRERAPIDS,  ztrsm_iutucopy_SAPPHIRERAPIDS,  ztrsm_iutncopy_SAPPHIRERAPIDS,
  ztrsm_ilnucopy_SAPPHIRERAPIDS,  ztrsm_ilnncopy_SAPPHIRERAPIDS,  ztrsm_iltucopy_SAPPHIRERAPIDS,  ztrsm_iltncopy_SAPPHIRERAPIDS,
#else
  ztrsm_ounucopy_SAPPHIRERAPIDS,  ztrsm_ounncopy_SAPPHIRERAPIDS,  ztrsm_outucopy_SAPPHIRERAPIDS,  ztrsm_outncopy_SAPPHIRERAPIDS,
  ztrsm_olnucopy_SAPPHIRERAPIDS,  ztrsm_olnncopy_SAPPHIRERAPIDS,  ztrsm_oltucopy_SAPPHIRERAPIDS,  ztrsm_oltncopy_SAPPHIRERAPIDS,
#endif
  ztrsm_ounucopy_SAPPHIRERAPIDS,  ztrsm_ounncopy_SAPPHIRERAPIDS,  ztrsm_outucopy_SAPPHIRERAPIDS,  ztrsm_outncopy_SAPPHIRERAPIDS,
  ztrsm_olnucopy_SAPPHIRERAPIDS,  ztrsm_olnncopy_SAPPHIRERAPIDS,  ztrsm_oltucopy_SAPPHIRERAPIDS,  ztrsm_oltncopy_SAPPHIRERAPIDS,

  ztrmm_kernel_RN_SAPPHIRERAPIDS,  ztrmm_kernel_RT_SAPPHIRERAPIDS,  ztrmm_kernel_RR_SAPPHIRERAPIDS,  ztrmm_kernel_RC_SAPPHIRERAPIDS,
  ztrmm_kernel_LN_SAPPHIRERAPIDS,  ztrmm_kernel_LT_SAPPHIRERAPIDS,  ztrmm_kernel_LR_SAPPHIRERAPIDS,  ztrmm_kernel_LC_SAPPHIRERAPIDS,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_SAPPHIRERAPIDS,  ztrmm_iunncopy_SAPPHIRERAPIDS,  ztrmm_iutucopy_SAPPHIRERAPIDS,  ztrmm_iutncopy_SAPPHIRERAPIDS,
  ztrmm_ilnucopy_SAPPHIRERAPIDS,  ztrmm_ilnncopy_SAPPHIRERAPIDS,  ztrmm_iltucopy_SAPPHIRERAPIDS,  ztrmm_iltncopy_SAPPHIRERAPIDS,
#else
  ztrmm_ounucopy_SAPPHIRERAPIDS,  ztrmm_ounncopy_SAPPHIRERAPIDS,  ztrmm_outucopy_SAPPHIRERAPIDS,  ztrmm_outncopy_SAPPHIRERAPIDS,
  ztrmm_olnucopy_SAPPHIRERAPIDS,  ztrmm_olnncopy_SAPPHIRERAPIDS,  ztrmm_oltucopy_SAPPHIRERAPIDS,  ztrmm_oltncopy_SAPPHIRERAPIDS,
#endif
  ztrmm_ounucopy_SAPPHIRERAPIDS,  ztrmm_ounncopy_SAPPHIRERAPIDS,  ztrmm_outucopy_SAPPHIRERAPIDS,  ztrmm_outncopy_SAPPHIRERAPIDS,
  ztrmm_olnucopy_SAPPHIRERAPIDS,  ztrmm_olnncopy_SAPPHIRERAPIDS,  ztrmm_oltucopy_SAPPHIRERAPIDS,  ztrmm_oltncopy_SAPPHIRERAPIDS,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_SAPPHIRERAPIDS,  zsymm_iltcopy_SAPPHIRERAPIDS,
#else
  zsymm_outcopy_SAPPHIRERAPIDS,  zsymm_oltcopy_SAPPHIRERAPIDS,
#endif
  zsymm_outcopy_SAPPHIRERAPIDS,  zsymm_oltcopy_SAPPHIRERAPIDS,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_SAPPHIRERAPIDS,  zhemm_iltcopy_SAPPHIRERAPIDS,
#else
  zhemm_outcopy_SAPPHIRERAPIDS,  zhemm_oltcopy_SAPPHIRERAPIDS,
#endif
  zhemm_outcopy_SAPPHIRERAPIDS,  zhemm_oltcopy_SAPPHIRERAPIDS,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_SAPPHIRERAPIDS,

  zgemm3m_incopyb_SAPPHIRERAPIDS,  zgemm3m_incopyr_SAPPHIRERAPIDS,
  zgemm3m_incopyi_SAPPHIRERAPIDS,  zgemm3m_itcopyb_SAPPHIRERAPIDS,
  zgemm3m_itcopyr_SAPPHIRERAPIDS,  zgemm3m_itcopyi_SAPPHIRERAPIDS,
  zgemm3m_oncopyb_SAPPHIRERAPIDS,  zgemm3m_oncopyr_SAPPHIRERAPIDS,
  zgemm3m_oncopyi_SAPPHIRERAPIDS,  zgemm3m_otcopyb_SAPPHIRERAPIDS,
  zgemm3m_otcopyr_SAPPHIRERAPIDS,  zgemm3m_otcopyi_SAPPHIRERAPIDS,

  zsymm3m_iucopyb_SAPPHIRERAPIDS,  zsymm3m_ilcopyb_SAPPHIRERAPIDS,
  zsymm3m_iucopyr_SAPPHIRERAPIDS,  zsymm3m_ilcopyr_SAPPHIRERAPIDS,
  zsymm3m_iucopyi_SAPPHIRERAPIDS,  zsymm3m_ilcopyi_SAPPHIRERAPIDS,
  zsymm3m_oucopyb_SAPPHIRERAPIDS,  zsymm3m_olcopyb_SAPPHIRERAPIDS,
  zsymm3m_oucopyr_SAPPHIRERAPIDS,  zsymm3m_olcopyr_SAPPHIRERAPIDS,
  zsymm3m_oucopyi_SAPPHIRERAPIDS,  zsymm3m_olcopyi_SAPPHIRERAPIDS,

  zhemm3m_iucopyb_SAPPHIRERAPIDS,  zhemm3m_ilcopyb_SAPPHIRERAPIDS,
  zhemm3m_iucopyr_SAPPHIRERAPIDS,  zhemm3m_ilcopyr_SAPPHIRERAPIDS,
  zhemm3m_iucopyi_SAPPHIRERAPIDS,  zhemm3m_ilcopyi_SAPPHIRERAPIDS,

  zhemm3m_oucopyb_SAPPHIRERAPIDS,  zhemm3m_olcopyb_SAPPHIRERAPIDS,
  zhemm3m_oucopyr_SAPPHIRERAPIDS,  zhemm3m_olcopyr_SAPPHIRERAPIDS,
  zhemm3m_oucopyi_SAPPHIRERAPIDS,  zhemm3m_olcopyi_SAPPHIRERAPIDS,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_SAPPHIRERAPIDS, zlaswp_ncopy_SAPPHIRERAPIDS,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_SAPPHIRERAPIDS, xamin_k_SAPPHIRERAPIDS, ixamax_k_SAPPHIRERAPIDS, ixamin_k_SAPPHIRERAPIDS,
  xnrm2_k_SAPPHIRERAPIDS, xasum_k_SAPPHIRERAPIDS, xsum_k_SAPPHIRERAPIDS, xcopy_k_SAPPHIRERAPIDS,
  xdotu_k_SAPPHIRERAPIDS, xdotc_k_SAPPHIRERAPIDS, xqrot_k_SAPPHIRERAPIDS,
  xaxpy_k_SAPPHIRERAPIDS, xaxpyc_k_SAPPHIRERAPIDS, xscal_k_SAPPHIRERAPIDS, xswap_k_SAPPHIRERAPIDS,

  xgemv_n_SAPPHIRERAPIDS, xgemv_t_SAPPHIRERAPIDS, xgemv_r_SAPPHIRERAPIDS, xgemv_c_SAPPHIRERAPIDS,
  xgemv_o_SAPPHIRERAPIDS, xgemv_u_SAPPHIRERAPIDS, xgemv_s_SAPPHIRERAPIDS, xgemv_d_SAPPHIRERAPIDS,
  xgeru_k_SAPPHIRERAPIDS, xgerc_k_SAPPHIRERAPIDS, xgerv_k_SAPPHIRERAPIDS, xgerd_k_SAPPHIRERAPIDS,
  xsymv_L_SAPPHIRERAPIDS, xsymv_U_SAPPHIRERAPIDS,
  xhemv_L_SAPPHIRERAPIDS, xhemv_U_SAPPHIRERAPIDS, xhemv_M_SAPPHIRERAPIDS, xhemv_V_SAPPHIRERAPIDS,

  xgemm_kernel_n_SAPPHIRERAPIDS, xgemm_kernel_l_SAPPHIRERAPIDS, xgemm_kernel_r_SAPPHIRERAPIDS, xgemm_kernel_b_SAPPHIRERAPIDS,
  xgemm_beta_SAPPHIRERAPIDS,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_SAPPHIRERAPIDS, xgemm_itcopy_SAPPHIRERAPIDS,
#else
  xgemm_oncopy_SAPPHIRERAPIDS, xgemm_otcopy_SAPPHIRERAPIDS,
#endif
  xgemm_oncopy_SAPPHIRERAPIDS, xgemm_otcopy_SAPPHIRERAPIDS,

  xtrsm_kernel_LN_SAPPHIRERAPIDS, xtrsm_kernel_LT_SAPPHIRERAPIDS, xtrsm_kernel_LR_SAPPHIRERAPIDS, xtrsm_kernel_LC_SAPPHIRERAPIDS,
  xtrsm_kernel_RN_SAPPHIRERAPIDS, xtrsm_kernel_RT_SAPPHIRERAPIDS, xtrsm_kernel_RR_SAPPHIRERAPIDS, xtrsm_kernel_RC_SAPPHIRERAPIDS,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_SAPPHIRERAPIDS,  xtrsm_iunncopy_SAPPHIRERAPIDS,  xtrsm_iutucopy_SAPPHIRERAPIDS,  xtrsm_iutncopy_SAPPHIRERAPIDS,
  xtrsm_ilnucopy_SAPPHIRERAPIDS,  xtrsm_ilnncopy_SAPPHIRERAPIDS,  xtrsm_iltucopy_SAPPHIRERAPIDS,  xtrsm_iltncopy_SAPPHIRERAPIDS,
#else
  xtrsm_ounucopy_SAPPHIRERAPIDS,  xtrsm_ounncopy_SAPPHIRERAPIDS,  xtrsm_outucopy_SAPPHIRERAPIDS,  xtrsm_outncopy_SAPPHIRERAPIDS,
  xtrsm_olnucopy_SAPPHIRERAPIDS,  xtrsm_olnncopy_SAPPHIRERAPIDS,  xtrsm_oltucopy_SAPPHIRERAPIDS,  xtrsm_oltncopy_SAPPHIRERAPIDS,
#endif
  xtrsm_ounucopy_SAPPHIRERAPIDS,  xtrsm_ounncopy_SAPPHIRERAPIDS,  xtrsm_outucopy_SAPPHIRERAPIDS,  xtrsm_outncopy_SAPPHIRERAPIDS,
  xtrsm_olnucopy_SAPPHIRERAPIDS,  xtrsm_olnncopy_SAPPHIRERAPIDS,  xtrsm_oltucopy_SAPPHIRERAPIDS,  xtrsm_oltncopy_SAPPHIRERAPIDS,

  xtrmm_kernel_RN_SAPPHIRERAPIDS,  xtrmm_kernel_RT_SAPPHIRERAPIDS,  xtrmm_kernel_RR_SAPPHIRERAPIDS,  xtrmm_kernel_RC_SAPPHIRERAPIDS,
  xtrmm_kernel_LN_SAPPHIRERAPIDS,  xtrmm_kernel_LT_SAPPHIRERAPIDS,  xtrmm_kernel_LR_SAPPHIRERAPIDS,  xtrmm_kernel_LC_SAPPHIRERAPIDS,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_SAPPHIRERAPIDS,  xtrmm_iunncopy_SAPPHIRERAPIDS,  xtrmm_iutucopy_SAPPHIRERAPIDS,  xtrmm_iutncopy_SAPPHIRERAPIDS,
  xtrmm_ilnucopy_SAPPHIRERAPIDS,  xtrmm_ilnncopy_SAPPHIRERAPIDS,  xtrmm_iltucopy_SAPPHIRERAPIDS,  xtrmm_iltncopy_SAPPHIRERAPIDS,
#else
  xtrmm_ounucopy_SAPPHIRERAPIDS,  xtrmm_ounncopy_SAPPHIRERAPIDS,  xtrmm_outucopy_SAPPHIRERAPIDS,  xtrmm_outncopy_SAPPHIRERAPIDS,
  xtrmm_olnucopy_SAPPHIRERAPIDS,  xtrmm_olnncopy_SAPPHIRERAPIDS,  xtrmm_oltucopy_SAPPHIRERAPIDS,  xtrmm_oltncopy_SAPPHIRERAPIDS,
#endif
  xtrmm_ounucopy_SAPPHIRERAPIDS,  xtrmm_ounncopy_SAPPHIRERAPIDS,  xtrmm_outucopy_SAPPHIRERAPIDS,  xtrmm_outncopy_SAPPHIRERAPIDS,
  xtrmm_olnucopy_SAPPHIRERAPIDS,  xtrmm_olnncopy_SAPPHIRERAPIDS,  xtrmm_oltucopy_SAPPHIRERAPIDS,  xtrmm_oltncopy_SAPPHIRERAPIDS,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_SAPPHIRERAPIDS,  xsymm_iltcopy_SAPPHIRERAPIDS,
#else
  xsymm_outcopy_SAPPHIRERAPIDS,  xsymm_oltcopy_SAPPHIRERAPIDS,
#endif
  xsymm_outcopy_SAPPHIRERAPIDS,  xsymm_oltcopy_SAPPHIRERAPIDS,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_SAPPHIRERAPIDS,  xhemm_iltcopy_SAPPHIRERAPIDS,
#else
  xhemm_outcopy_SAPPHIRERAPIDS,  xhemm_oltcopy_SAPPHIRERAPIDS,
#endif
  xhemm_outcopy_SAPPHIRERAPIDS,  xhemm_oltcopy_SAPPHIRERAPIDS,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_SAPPHIRERAPIDS,

  xgemm3m_incopyb_SAPPHIRERAPIDS,  xgemm3m_incopyr_SAPPHIRERAPIDS,
  xgemm3m_incopyi_SAPPHIRERAPIDS,  xgemm3m_itcopyb_SAPPHIRERAPIDS,
  xgemm3m_itcopyr_SAPPHIRERAPIDS,  xgemm3m_itcopyi_SAPPHIRERAPIDS,
  xgemm3m_oncopyb_SAPPHIRERAPIDS,  xgemm3m_oncopyr_SAPPHIRERAPIDS,
  xgemm3m_oncopyi_SAPPHIRERAPIDS,  xgemm3m_otcopyb_SAPPHIRERAPIDS,
  xgemm3m_otcopyr_SAPPHIRERAPIDS,  xgemm3m_otcopyi_SAPPHIRERAPIDS,

  xsymm3m_iucopyb_SAPPHIRERAPIDS,  xsymm3m_ilcopyb_SAPPHIRERAPIDS,
  xsymm3m_iucopyr_SAPPHIRERAPIDS,  xsymm3m_ilcopyr_SAPPHIRERAPIDS,
  xsymm3m_iucopyi_SAPPHIRERAPIDS,  xsymm3m_ilcopyi_SAPPHIRERAPIDS,
  xsymm3m_oucopyb_SAPPHIRERAPIDS,  xsymm3m_olcopyb_SAPPHIRERAPIDS,
  xsymm3m_oucopyr_SAPPHIRERAPIDS,  xsymm3m_olcopyr_SAPPHIRERAPIDS,
  xsymm3m_oucopyi_SAPPHIRERAPIDS,  xsymm3m_olcopyi_SAPPHIRERAPIDS,

  xhemm3m_iucopyb_SAPPHIRERAPIDS,  xhemm3m_ilcopyb_SAPPHIRERAPIDS,
  xhemm3m_iucopyr_SAPPHIRERAPIDS,  xhemm3m_ilcopyr_SAPPHIRERAPIDS,
  xhemm3m_iucopyi_SAPPHIRERAPIDS,  xhemm3m_ilcopyi_SAPPHIRERAPIDS,

  xhemm3m_oucopyb_SAPPHIRERAPIDS,  xhemm3m_olcopyb_SAPPHIRERAPIDS,
  xhemm3m_oucopyr_SAPPHIRERAPIDS,  xhemm3m_olcopyr_SAPPHIRERAPIDS,
  xhemm3m_oucopyi_SAPPHIRERAPIDS,  xhemm3m_olcopyi_SAPPHIRERAPIDS,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_SAPPHIRERAPIDS, xlaswp_ncopy_SAPPHIRERAPIDS,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_SAPPHIRERAPIDS,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_SAPPHIRERAPIDS,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_SAPPHIRERAPIDS,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_SAPPHIRERAPIDS,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_SAPPHIRERAPIDS, somatcopy_k_ct_SAPPHIRERAPIDS, somatcopy_k_rn_SAPPHIRERAPIDS, somatcopy_k_rt_SAPPHIRERAPIDS,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_SAPPHIRERAPIDS, domatcopy_k_ct_SAPPHIRERAPIDS, domatcopy_k_rn_SAPPHIRERAPIDS, domatcopy_k_rt_SAPPHIRERAPIDS,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_SAPPHIRERAPIDS, comatcopy_k_ct_SAPPHIRERAPIDS, comatcopy_k_rn_SAPPHIRERAPIDS, comatcopy_k_rt_SAPPHIRERAPIDS,
  comatcopy_k_cnc_SAPPHIRERAPIDS, comatcopy_k_ctc_SAPPHIRERAPIDS, comatcopy_k_rnc_SAPPHIRERAPIDS, comatcopy_k_rtc_SAPPHIRERAPIDS,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_SAPPHIRERAPIDS, zomatcopy_k_ct_SAPPHIRERAPIDS, zomatcopy_k_rn_SAPPHIRERAPIDS, zomatcopy_k_rt_SAPPHIRERAPIDS,
  zomatcopy_k_cnc_SAPPHIRERAPIDS, zomatcopy_k_ctc_SAPPHIRERAPIDS, zomatcopy_k_rnc_SAPPHIRERAPIDS, zomatcopy_k_rtc_SAPPHIRERAPIDS,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_SAPPHIRERAPIDS, simatcopy_k_ct_SAPPHIRERAPIDS, simatcopy_k_rn_SAPPHIRERAPIDS, simatcopy_k_rt_SAPPHIRERAPIDS,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_SAPPHIRERAPIDS, dimatcopy_k_ct_SAPPHIRERAPIDS, dimatcopy_k_rn_SAPPHIRERAPIDS, dimatcopy_k_rt_SAPPHIRERAPIDS,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_SAPPHIRERAPIDS, cimatcopy_k_ct_SAPPHIRERAPIDS, cimatcopy_k_rn_SAPPHIRERAPIDS, cimatcopy_k_rt_SAPPHIRERAPIDS,
  cimatcopy_k_cnc_SAPPHIRERAPIDS, cimatcopy_k_ctc_SAPPHIRERAPIDS, cimatcopy_k_rnc_SAPPHIRERAPIDS, cimatcopy_k_rtc_SAPPHIRERAPIDS,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_SAPPHIRERAPIDS, zimatcopy_k_ct_SAPPHIRERAPIDS, zimatcopy_k_rn_SAPPHIRERAPIDS, zimatcopy_k_rt_SAPPHIRERAPIDS,
  zimatcopy_k_cnc_SAPPHIRERAPIDS, zimatcopy_k_ctc_SAPPHIRERAPIDS, zimatcopy_k_rnc_SAPPHIRERAPIDS, zimatcopy_k_rtc_SAPPHIRERAPIDS,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_SAPPHIRERAPIDS,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_SAPPHIRERAPIDS,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_SAPPHIRERAPIDS,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_SAPPHIRERAPIDS,
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_LOONGARCH64)
static int get_L3_size() {
  int ret = 0, id = 0x14;
  __asm__ volatile (
    "cpucfg %[ret], %[id]"
    : [ret]"=r"(ret)
    : [id]"r"(id)
    : "memory"
  );
  return ((ret & 0xffff) + 1) * pow(2, ((ret >> 16) & 0xff)) * pow(2, ((ret >> 24) & 0x7f)) / 1024 / 1024; // MB
}
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif

#if defined(LA464)
  int L3_size = get_L3_size();
#ifdef SMP
  if(blas_num_threads == 1){
#endif
    //single thread
    if (L3_size == 32){ // 3C5000 and 3D5000
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 8192;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 289;
      TABLE_NAME.dgemm_r = 4096;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 4096;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 2048;
    } else { // 3A5000 and 3C5000L
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 4096;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 300;
      TABLE_NAME.dgemm_r = 3024;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 2048;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 1024;
    }
#ifdef SMP
  }else{
    //multi thread
    if (L3_size == 32){ // 3C5000 and 3D5000
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 1024;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 289;
      TABLE_NAME.dgemm_r = 342;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 512;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 512;
    } else { // 3A5000 and 3C5000L
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 2048;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 300;
      TABLE_NAME.dgemm_r = 738;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 1024;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 1024;
    }
  }
#endif
#else
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
}
#else // (ARCH_LOONGARCH64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
	TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
	TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
	TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#if (ARCH_RISCV64)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_p = SHGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_r = SHGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_q = SHGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //RISCV64

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  l2 = readenv_atoi("OPENBLAS_L2_SIZE");
  if (l2 != 0)
    return l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_p = SHGEMM_DEFAULT_P;
  TABLE_NAME.shgemm_q = SHGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE) || defined(SAPPHIRERAPIDS)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#ifdef SAPPHIRERAPIDS
#if (BUILD_BFLOAT16 == 1)
  TABLE_NAME.need_amxtile_permission = 1;
#endif
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_BFLOAT16==1
  TABLE_NAME.sbgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sbgemm_p * TABLE_NAME.sbgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sbgemm_q *  4) - 15) & ~15);
  TABLE_NAME.bgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.bgemm_p * TABLE_NAME.bgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.bgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_HFLOAT16==1
  TABLE_NAME.shgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.shgemm_p * TABLE_NAME.shgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.shgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //RISCV64
#endif //POWER
#endif //ZARCH
#endif //(ARCH_LOONGARCH64)
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
