# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.4.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Statistical tests."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if getattr(globals().get("__spec__"), "parent", None) or __package__ or "." in __name__:
    from . import _stattests
else:
    import _stattests

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
class DickeyFullerTest(openturns.common.PersistentObject):
    r"""
    The Dickey-Fuller stationarity test.

    Refer to :ref:`dickey_fuller`.

    The Dickey-Fuller test checks the stationarity of a scalar time series using one time series.

    Parameters
    ----------
    series : `~openturns.TimeSeries`
        Time series to consider

    Examples
    --------
    Create an ARMA process and generate a time series:

    >>> import openturns as ot
    >>> arcoefficients = ot.ARMACoefficients([0.3])
    >>> macoefficients = ot.ARMACoefficients(0)
    >>> timeGrid = ot.RegularGrid(0.0, 0.1, 10)
    >>> whiteNoise = ot.WhiteNoise(ot.Normal(), timeGrid)
    >>> myARMA = ot.ARMA(arcoefficients, macoefficients, whiteNoise)

    >>> realization = ot.TimeSeries(myARMA.getRealization())
    >>> test = ot.DickeyFullerTest(realization)

    Test the stationarity of the data without any assumption on the model:

    >>> globalRes = test.runStrategy()

    Test the stationarity knowing you have a drift and linear trend model:

    >>> res1 = test.testUnitRootInDriftAndLinearTrendModel(0.95)

    Test the stationarity knowing you have a drift model:

    >>> res2 = test.testUnitRootInDriftModel(0.95)

    Test the stationarity knowing you have an AR1 model:

    >>> res3 = test.testUnitRootInAR1Model(0.95)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _stattests.DickeyFullerTest_getClassName(self)

    def testUnitRootInDriftAndLinearTrendModel(self, level=0.05):
        r"""
        Test for unit root in model with drift and trend.

        Parameters
        ----------
        alpha : float, :math:`0 < \alpha < 1`
            The first kind risk of the test.

            By default, :math:`\alpha=0.05`.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Results container of the test detailed in :eq:`TestModel1`.

        """
        return _stattests.DickeyFullerTest_testUnitRootInDriftAndLinearTrendModel(self, level)

    def testUnitRootInDriftModel(self, level=0.05):
        r"""
        Test for unit root in model with drift.

        Parameters
        ----------
        alpha : float, :math:`0 < \alpha < 1`
            The first kind risk of the test.

            By default, :math:`\alpha=0.05`.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Results container of the test detailed in :eq:`TestModel2`.

        """
        return _stattests.DickeyFullerTest_testUnitRootInDriftModel(self, level)

    def testUnitRootInAR1Model(self, level=0.05):
        r"""
        Test for unit root in AR1 model.

        Parameters
        ----------
        alpha : float, :math:`0 < \alpha < 1`
            The first kind risk of the test.

            By default, :math:`\alpha=0.05`.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Results container of the test detailed in :eq:`TestModel3`.

        """
        return _stattests.DickeyFullerTest_testUnitRootInAR1Model(self, level)

    def runStrategy(self, level=0.05):
        r"""
        Test the stationarity without any assumption on the model.

        Parameters
        ----------
        alpha : float, :math:`0 < \alpha < 1`
            The first kind risk of the test.

            By default, :math:`\alpha=0.05`.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Results container of the tests. The strategy if the one described above.

        """
        return _stattests.DickeyFullerTest_runStrategy(self, level)

    def testUnitRootAndNoLinearTrendInDriftAndLinearTrendModel(self, level=0.05):
        r"""
        Test for linear trend in model with unit root.

        Parameters
        ----------
        alpha : float, :math:`0 < \alpha < 1`
            The first kind risk of the test.

            By default, :math:`\alpha=0.05`

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Results container of the test detailed in :eq:`TestSousModele1_2`.

        """
        return _stattests.DickeyFullerTest_testUnitRootAndNoLinearTrendInDriftAndLinearTrendModel(self, level)

    def testNoUnitRootAndNoLinearTrendInDriftAndLinearTrendModel(self, level=0.05):
        r"""
        Test for trend in model without unit root.

        Parameters
        ----------
        alpha : float, :math:`0 < \alpha < 1`
            The first kind risk of the test.

            By default, :math:`\alpha=0.05`.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Results container of the test detailed in :eq:`TestSousModele1_1`.

        """
        return _stattests.DickeyFullerTest_testNoUnitRootAndNoLinearTrendInDriftAndLinearTrendModel(self, level)

    def testUnitRootAndNoDriftInDriftModel(self, level=0.05):
        r"""
        Test for null drift in model with unit root.

        Parameters
        ----------
        alpha : float, :math:`0 < \alpha < 1`
            The first kind risk of the test.

            By default, :math:`\alpha=0.05`.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Results container of the test detailed in :eq:`TestSousModele2_2`.

        """
        return _stattests.DickeyFullerTest_testUnitRootAndNoDriftInDriftModel(self, level)

    def testNoUnitRootAndNoDriftInDriftModel(self, level=0.05):
        r"""
        Test for null drift in model without unit root.

        Parameters
        ----------
        alpha : float, :math:`0 < \alpha < 1`
            The first kind risk of the test.

            By default, :math:`\alpha=0.05`.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Results container of the test detailed in :eq:`TestSousModele2_1`.

        """
        return _stattests.DickeyFullerTest_testNoUnitRootAndNoDriftInDriftModel(self, level)

    def __init__(self, *args):
        _stattests.DickeyFullerTest_swiginit(self, _stattests.new_DickeyFullerTest(*args))
    __swig_destroy__ = _stattests.delete_DickeyFullerTest

# Register DickeyFullerTest in _stattests:
_stattests.DickeyFullerTest_swigregister(DickeyFullerTest)

