# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.4.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Transformations."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if getattr(globals().get("__spec__"), "parent", None) or __package__ or "." in __name__:
    from . import _transformation
else:
    import _transformation

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
class MarginalTransformationEvaluation(openturns.func.EvaluationImplementation):
    r"""
    Marginal transformation evaluation.

    Available constructors:
        MarginalTransformationEvaluation(*distCol*)

        MarginalTransformationEvaluation(*distCol, direction, standardMarginal*)

        MarginalTransformationEvaluation(*distCol, outputDistCol*)


    Parameters
    ----------
    distCol : sequence of :class:`~openturns.Distribution`
        A collection of distributions.
    direction : int
        Flag for the direction of the transformation, either integer or 
        *MarginalTransformationEvaluation.FROM* (associated to the integer 0) or 
        *MarginalTransformationEvaluation.TO* (associated to the integer 1).
        Default is 0.
    standardMarginal : :class:`~openturns.Distribution`
        Target distribution marginal
        Default is Uniform(0, 1)
    outputDistCol : sequence of :class:`~openturns.Distribution`
        A collection of distributions.

    Notes
    -----
    This class contains a :class:`~openturns.Function` which can be
    evaluated in one point but which proposes no gradient nor hessian implementation.

    - In the two first usage, if :math:`direction = 0`, the created operator
      transforms a :class:`~openturns.Point` into its rank according to the
      marginal distributions described in *distCol*. Let
      :math:`(F_{X_1}, \ldots, F_{X_n})` be the CDF of the distributions contained
      in *distCol*, then the created operator works as follows:

      .. math::

          (x_1, \ldots, x_n) \rightarrow (F_{X_1}(x_1), \ldots, F_{X_n}(x_n))

      If :math:`direction = 1`, the created operator works in the opposite direction:

      .. math::

          (x_1, \ldots, x_n) \rightarrow (F^{-1}_{X_1}(x_1), \ldots, F^{-1}_{X_n}(x_n))

      In that case, it requires that all the values :math:`x_i` be in :math:`[0, 1]`.

    - In the third usage, the created operator transforms a
      :class:`~openturns.Point` into the following one, where *outputDistCol*
      contains the :math:`(F_{Y_1}, \ldots, F_{Y_n})` distributions:

      .. math::

          (x_1, \ldots, x_n) \rightarrow (F^{-1}_{Y_1} \circ F_{X_1}(x_1), \ldots, F^{-1}_{Y_n} \circ F_{X_n}(x_n))

    Examples
    --------
    >>> import openturns as ot
    >>> distCol = [ot.Normal(), ot.LogNormal()]
    >>> margTransEval = ot.MarginalTransformationEvaluation(distCol, 0)
    >>> print(margTransEval([1, 3]))
    [0.841345,0.864031]
    >>> margTransEvalInverse = ot.MarginalTransformationEvaluation(distCol, 1)
    >>> print(margTransEvalInverse([0.84, 0.86]))
    [0.994458,2.94562]
    >>> outputDistCol = [ot.WeibullMin(), ot.Exponential()]
    >>> margTransEvalComposed = ot.MarginalTransformationEvaluation(distCol, outputDistCol)
    >>> print(margTransEvalComposed([1, 3]))
    [1.84102,1.99533]

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.MarginalTransformationEvaluation_getClassName(self)
    FROM = _transformation.MarginalTransformationEvaluation_FROM
    TO = _transformation.MarginalTransformationEvaluation_TO

    def __call__(self, *args):
        return _transformation.MarginalTransformationEvaluation___call__(self, *args)

    def parameterGradient(self, inP):
        r"""
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _transformation.MarginalTransformationEvaluation_parameterGradient(self, inP)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _transformation.MarginalTransformationEvaluation_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _transformation.MarginalTransformationEvaluation_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _transformation.MarginalTransformationEvaluation_getParameterDescription(self)

    def setParameterDescription(self, description):
        r"""
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _transformation.MarginalTransformationEvaluation_setParameterDescription(self, description)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _transformation.MarginalTransformationEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _transformation.MarginalTransformationEvaluation_getOutputDimension(self)

    def setInputDistributionCollection(self, inputDistributionCollection):
        r"""
        Accessor to the input distribution collection.

        Parameters
        ----------
        inputDistCol : :class:`~openturns.DistributionCollection`
            The input distribution collection.
        """
        return _transformation.MarginalTransformationEvaluation_setInputDistributionCollection(self, inputDistributionCollection)

    def getInputDistributionCollection(self):
        r"""
        Accessor to the input distribution collection.

        Returns
        -------
        inputDistCol : :class:`~openturns.DistributionCollection`
            The input distribution collection.
        """
        return _transformation.MarginalTransformationEvaluation_getInputDistributionCollection(self)

    def setOutputDistributionCollection(self, outputDistributionCollection):
        r"""
        Accessor to the output distribution collection.

        Parameters
        ----------
        outputDistCol : :class:`~openturns.DistributionCollection`
            The output distribution collection.
        """
        return _transformation.MarginalTransformationEvaluation_setOutputDistributionCollection(self, outputDistributionCollection)

    def getOutputDistributionCollection(self):
        r"""
        Accessor to the output distribution collection.

        Returns
        -------
        outputDistCol : :class:`~openturns.DistributionCollection`
            The output distribution collection.
        """
        return _transformation.MarginalTransformationEvaluation_getOutputDistributionCollection(self)

    def getSimplifications(self):
        r"""Try to simplify the transformations if it is possible."""
        return _transformation.MarginalTransformationEvaluation_getSimplifications(self)

    def getExpressions(self):
        r"""
        Accessor to the numerical math function.

        Returns
        -------
        listFunction : :class:`~openturns.FunctionCollection`
            The collection of numerical math functions if the analytical expressions 
            exist.
        """
        return _transformation.MarginalTransformationEvaluation_getExpressions(self)

    def __repr__(self):
        return _transformation.MarginalTransformationEvaluation___repr__(self)

    def __str__(self, *args):
        return _transformation.MarginalTransformationEvaluation___str__(self, *args)

    def __init__(self, *args):
        _transformation.MarginalTransformationEvaluation_swiginit(self, _transformation.new_MarginalTransformationEvaluation(*args))
    __swig_destroy__ = _transformation.delete_MarginalTransformationEvaluation

# Register MarginalTransformationEvaluation in _transformation:
_transformation.MarginalTransformationEvaluation_swigregister(MarginalTransformationEvaluation)
class MarginalTransformationGradient(openturns.func.GradientImplementation):
    r"""Proxy of C++ OT::MarginalTransformationGradient."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.MarginalTransformationGradient_getClassName(self)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _transformation.MarginalTransformationGradient_gradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _transformation.MarginalTransformationGradient_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _transformation.MarginalTransformationGradient_getOutputDimension(self)

    def __repr__(self):
        return _transformation.MarginalTransformationGradient___repr__(self)

    def __str__(self, *args):
        return _transformation.MarginalTransformationGradient___str__(self, *args)

    def __init__(self, *args):
        _transformation.MarginalTransformationGradient_swiginit(self, _transformation.new_MarginalTransformationGradient(*args))
    __swig_destroy__ = _transformation.delete_MarginalTransformationGradient

# Register MarginalTransformationGradient in _transformation:
_transformation.MarginalTransformationGradient_swigregister(MarginalTransformationGradient)
class MarginalTransformationHessian(openturns.func.HessianImplementation):
    r"""Proxy of C++ OT::MarginalTransformationHessian."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.MarginalTransformationHessian_getClassName(self)

    def hessian(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _transformation.MarginalTransformationHessian_hessian(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _transformation.MarginalTransformationHessian_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _transformation.MarginalTransformationHessian_getOutputDimension(self)

    def __repr__(self):
        return _transformation.MarginalTransformationHessian___repr__(self)

    def __str__(self, *args):
        return _transformation.MarginalTransformationHessian___str__(self, *args)

    def __init__(self, *args):
        _transformation.MarginalTransformationHessian_swiginit(self, _transformation.new_MarginalTransformationHessian(*args))
    __swig_destroy__ = _transformation.delete_MarginalTransformationHessian

# Register MarginalTransformationHessian in _transformation:
_transformation.MarginalTransformationHessian_swigregister(MarginalTransformationHessian)
class NatafEllipticalCopulaEvaluation(openturns.func.EvaluationImplementation):
    r"""Proxy of C++ OT::NatafEllipticalCopulaEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.NatafEllipticalCopulaEvaluation_getClassName(self)

    def __call__(self, inP):
        return _transformation.NatafEllipticalCopulaEvaluation___call__(self, inP)

    def parameterGradient(self, inP):
        r"""
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _transformation.NatafEllipticalCopulaEvaluation_parameterGradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _transformation.NatafEllipticalCopulaEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _transformation.NatafEllipticalCopulaEvaluation_getOutputDimension(self)

    def __repr__(self):
        return _transformation.NatafEllipticalCopulaEvaluation___repr__(self)

    def __str__(self, *args):
        return _transformation.NatafEllipticalCopulaEvaluation___str__(self, *args)

    def __init__(self, *args):
        _transformation.NatafEllipticalCopulaEvaluation_swiginit(self, _transformation.new_NatafEllipticalCopulaEvaluation(*args))
    __swig_destroy__ = _transformation.delete_NatafEllipticalCopulaEvaluation

# Register NatafEllipticalCopulaEvaluation in _transformation:
_transformation.NatafEllipticalCopulaEvaluation_swigregister(NatafEllipticalCopulaEvaluation)
class NatafEllipticalCopulaGradient(openturns.func.GradientImplementation):
    r"""Proxy of C++ OT::NatafEllipticalCopulaGradient."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.NatafEllipticalCopulaGradient_getClassName(self)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _transformation.NatafEllipticalCopulaGradient_gradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _transformation.NatafEllipticalCopulaGradient_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _transformation.NatafEllipticalCopulaGradient_getOutputDimension(self)

    def __repr__(self):
        return _transformation.NatafEllipticalCopulaGradient___repr__(self)

    def __init__(self, *args):
        _transformation.NatafEllipticalCopulaGradient_swiginit(self, _transformation.new_NatafEllipticalCopulaGradient(*args))
    __swig_destroy__ = _transformation.delete_NatafEllipticalCopulaGradient

# Register NatafEllipticalCopulaGradient in _transformation:
_transformation.NatafEllipticalCopulaGradient_swigregister(NatafEllipticalCopulaGradient)
class NatafEllipticalCopulaHessian(openturns.func.HessianImplementation):
    r"""Proxy of C++ OT::NatafEllipticalCopulaHessian."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.NatafEllipticalCopulaHessian_getClassName(self)

    def hessian(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _transformation.NatafEllipticalCopulaHessian_hessian(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _transformation.NatafEllipticalCopulaHessian_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _transformation.NatafEllipticalCopulaHessian_getOutputDimension(self)

    def __repr__(self):
        return _transformation.NatafEllipticalCopulaHessian___repr__(self)

    def __init__(self, *args):
        _transformation.NatafEllipticalCopulaHessian_swiginit(self, _transformation.new_NatafEllipticalCopulaHessian(*args))
    __swig_destroy__ = _transformation.delete_NatafEllipticalCopulaHessian

# Register NatafEllipticalCopulaHessian in _transformation:
_transformation.NatafEllipticalCopulaHessian_swigregister(NatafEllipticalCopulaHessian)
class InverseNatafEllipticalCopulaEvaluation(openturns.func.EvaluationImplementation):
    r"""Proxy of C++ OT::InverseNatafEllipticalCopulaEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.InverseNatafEllipticalCopulaEvaluation_getClassName(self)

    def __call__(self, inP):
        return _transformation.InverseNatafEllipticalCopulaEvaluation___call__(self, inP)

    def parameterGradient(self, inP):
        r"""
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _transformation.InverseNatafEllipticalCopulaEvaluation_parameterGradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _transformation.InverseNatafEllipticalCopulaEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _transformation.InverseNatafEllipticalCopulaEvaluation_getOutputDimension(self)

    def __repr__(self):
        return _transformation.InverseNatafEllipticalCopulaEvaluation___repr__(self)

    def __str__(self, *args):
        return _transformation.InverseNatafEllipticalCopulaEvaluation___str__(self, *args)

    def __init__(self, *args):
        _transformation.InverseNatafEllipticalCopulaEvaluation_swiginit(self, _transformation.new_InverseNatafEllipticalCopulaEvaluation(*args))
    __swig_destroy__ = _transformation.delete_InverseNatafEllipticalCopulaEvaluation

# Register InverseNatafEllipticalCopulaEvaluation in _transformation:
_transformation.InverseNatafEllipticalCopulaEvaluation_swigregister(InverseNatafEllipticalCopulaEvaluation)
class InverseNatafEllipticalCopulaGradient(openturns.func.GradientImplementation):
    r"""Proxy of C++ OT::InverseNatafEllipticalCopulaGradient."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.InverseNatafEllipticalCopulaGradient_getClassName(self)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _transformation.InverseNatafEllipticalCopulaGradient_gradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _transformation.InverseNatafEllipticalCopulaGradient_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _transformation.InverseNatafEllipticalCopulaGradient_getOutputDimension(self)

    def __repr__(self):
        return _transformation.InverseNatafEllipticalCopulaGradient___repr__(self)

    def __init__(self, *args):
        _transformation.InverseNatafEllipticalCopulaGradient_swiginit(self, _transformation.new_InverseNatafEllipticalCopulaGradient(*args))
    __swig_destroy__ = _transformation.delete_InverseNatafEllipticalCopulaGradient

# Register InverseNatafEllipticalCopulaGradient in _transformation:
_transformation.InverseNatafEllipticalCopulaGradient_swigregister(InverseNatafEllipticalCopulaGradient)
class InverseNatafEllipticalCopulaHessian(openturns.func.HessianImplementation):
    r"""Proxy of C++ OT::InverseNatafEllipticalCopulaHessian."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.InverseNatafEllipticalCopulaHessian_getClassName(self)

    def hessian(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _transformation.InverseNatafEllipticalCopulaHessian_hessian(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _transformation.InverseNatafEllipticalCopulaHessian_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _transformation.InverseNatafEllipticalCopulaHessian_getOutputDimension(self)

    def __repr__(self):
        return _transformation.InverseNatafEllipticalCopulaHessian___repr__(self)

    def __init__(self, *args):
        _transformation.InverseNatafEllipticalCopulaHessian_swiginit(self, _transformation.new_InverseNatafEllipticalCopulaHessian(*args))
    __swig_destroy__ = _transformation.delete_InverseNatafEllipticalCopulaHessian

# Register InverseNatafEllipticalCopulaHessian in _transformation:
_transformation.InverseNatafEllipticalCopulaHessian_swigregister(InverseNatafEllipticalCopulaHessian)
class NatafIndependentCopulaEvaluation(openturns.func.EvaluationImplementation):
    r"""Proxy of C++ OT::NatafIndependentCopulaEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.NatafIndependentCopulaEvaluation_getClassName(self)

    def __call__(self, inP):
        return _transformation.NatafIndependentCopulaEvaluation___call__(self, inP)

    def parameterGradient(self, inP):
        r"""
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _transformation.NatafIndependentCopulaEvaluation_parameterGradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _transformation.NatafIndependentCopulaEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _transformation.NatafIndependentCopulaEvaluation_getOutputDimension(self)

    def __repr__(self):
        return _transformation.NatafIndependentCopulaEvaluation___repr__(self)

    def __str__(self, *args):
        return _transformation.NatafIndependentCopulaEvaluation___str__(self, *args)

    def __init__(self, *args):
        _transformation.NatafIndependentCopulaEvaluation_swiginit(self, _transformation.new_NatafIndependentCopulaEvaluation(*args))
    __swig_destroy__ = _transformation.delete_NatafIndependentCopulaEvaluation

# Register NatafIndependentCopulaEvaluation in _transformation:
_transformation.NatafIndependentCopulaEvaluation_swigregister(NatafIndependentCopulaEvaluation)
class NatafIndependentCopulaGradient(openturns.func.GradientImplementation):
    r"""Proxy of C++ OT::NatafIndependentCopulaGradient."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.NatafIndependentCopulaGradient_getClassName(self)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _transformation.NatafIndependentCopulaGradient_gradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _transformation.NatafIndependentCopulaGradient_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _transformation.NatafIndependentCopulaGradient_getOutputDimension(self)

    def __repr__(self):
        return _transformation.NatafIndependentCopulaGradient___repr__(self)

    def __init__(self, *args):
        _transformation.NatafIndependentCopulaGradient_swiginit(self, _transformation.new_NatafIndependentCopulaGradient(*args))
    __swig_destroy__ = _transformation.delete_NatafIndependentCopulaGradient

# Register NatafIndependentCopulaGradient in _transformation:
_transformation.NatafIndependentCopulaGradient_swigregister(NatafIndependentCopulaGradient)
class NatafIndependentCopulaHessian(openturns.func.HessianImplementation):
    r"""Proxy of C++ OT::NatafIndependentCopulaHessian."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.NatafIndependentCopulaHessian_getClassName(self)

    def hessian(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _transformation.NatafIndependentCopulaHessian_hessian(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _transformation.NatafIndependentCopulaHessian_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _transformation.NatafIndependentCopulaHessian_getOutputDimension(self)

    def __repr__(self):
        return _transformation.NatafIndependentCopulaHessian___repr__(self)

    def __init__(self, *args):
        _transformation.NatafIndependentCopulaHessian_swiginit(self, _transformation.new_NatafIndependentCopulaHessian(*args))
    __swig_destroy__ = _transformation.delete_NatafIndependentCopulaHessian

# Register NatafIndependentCopulaHessian in _transformation:
_transformation.NatafIndependentCopulaHessian_swigregister(NatafIndependentCopulaHessian)
class InverseNatafIndependentCopulaEvaluation(openturns.func.EvaluationImplementation):
    r"""Proxy of C++ OT::InverseNatafIndependentCopulaEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.InverseNatafIndependentCopulaEvaluation_getClassName(self)

    def __call__(self, inP):
        return _transformation.InverseNatafIndependentCopulaEvaluation___call__(self, inP)

    def parameterGradient(self, inP):
        r"""
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _transformation.InverseNatafIndependentCopulaEvaluation_parameterGradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _transformation.InverseNatafIndependentCopulaEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _transformation.InverseNatafIndependentCopulaEvaluation_getOutputDimension(self)

    def __repr__(self):
        return _transformation.InverseNatafIndependentCopulaEvaluation___repr__(self)

    def __str__(self, *args):
        return _transformation.InverseNatafIndependentCopulaEvaluation___str__(self, *args)

    def __init__(self, *args):
        _transformation.InverseNatafIndependentCopulaEvaluation_swiginit(self, _transformation.new_InverseNatafIndependentCopulaEvaluation(*args))
    __swig_destroy__ = _transformation.delete_InverseNatafIndependentCopulaEvaluation

# Register InverseNatafIndependentCopulaEvaluation in _transformation:
_transformation.InverseNatafIndependentCopulaEvaluation_swigregister(InverseNatafIndependentCopulaEvaluation)
class InverseNatafIndependentCopulaGradient(openturns.func.GradientImplementation):
    r"""Proxy of C++ OT::InverseNatafIndependentCopulaGradient."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.InverseNatafIndependentCopulaGradient_getClassName(self)

    def gradient(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _transformation.InverseNatafIndependentCopulaGradient_gradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _transformation.InverseNatafIndependentCopulaGradient_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _transformation.InverseNatafIndependentCopulaGradient_getOutputDimension(self)

    def __repr__(self):
        return _transformation.InverseNatafIndependentCopulaGradient___repr__(self)

    def __init__(self, *args):
        _transformation.InverseNatafIndependentCopulaGradient_swiginit(self, _transformation.new_InverseNatafIndependentCopulaGradient(*args))
    __swig_destroy__ = _transformation.delete_InverseNatafIndependentCopulaGradient

# Register InverseNatafIndependentCopulaGradient in _transformation:
_transformation.InverseNatafIndependentCopulaGradient_swigregister(InverseNatafIndependentCopulaGradient)
class InverseNatafIndependentCopulaHessian(openturns.func.HessianImplementation):
    r"""Proxy of C++ OT::InverseNatafIndependentCopulaHessian."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.InverseNatafIndependentCopulaHessian_getClassName(self)

    def hessian(self, inP):
        r"""
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _transformation.InverseNatafIndependentCopulaHessian_hessian(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _transformation.InverseNatafIndependentCopulaHessian_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _transformation.InverseNatafIndependentCopulaHessian_getOutputDimension(self)

    def __repr__(self):
        return _transformation.InverseNatafIndependentCopulaHessian___repr__(self)

    def __init__(self, *args):
        _transformation.InverseNatafIndependentCopulaHessian_swiginit(self, _transformation.new_InverseNatafIndependentCopulaHessian(*args))
    __swig_destroy__ = _transformation.delete_InverseNatafIndependentCopulaHessian

# Register InverseNatafIndependentCopulaHessian in _transformation:
_transformation.InverseNatafIndependentCopulaHessian_swigregister(InverseNatafIndependentCopulaHessian)
class NatafEllipticalDistributionEvaluation(openturns.func.LinearEvaluation):
    r"""Proxy of C++ OT::NatafEllipticalDistributionEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.NatafEllipticalDistributionEvaluation_getClassName(self)

    def parameterGradient(self, inP):
        r"""
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _transformation.NatafEllipticalDistributionEvaluation_parameterGradient(self, inP)

    def __repr__(self):
        return _transformation.NatafEllipticalDistributionEvaluation___repr__(self)

    def __init__(self, *args):
        _transformation.NatafEllipticalDistributionEvaluation_swiginit(self, _transformation.new_NatafEllipticalDistributionEvaluation(*args))
    __swig_destroy__ = _transformation.delete_NatafEllipticalDistributionEvaluation

# Register NatafEllipticalDistributionEvaluation in _transformation:
_transformation.NatafEllipticalDistributionEvaluation_swigregister(NatafEllipticalDistributionEvaluation)
class NatafEllipticalDistributionGradient(openturns.func.ConstantGradient):
    r"""Proxy of C++ OT::NatafEllipticalDistributionGradient."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.NatafEllipticalDistributionGradient_getClassName(self)

    def __repr__(self):
        return _transformation.NatafEllipticalDistributionGradient___repr__(self)

    def __init__(self, *args):
        _transformation.NatafEllipticalDistributionGradient_swiginit(self, _transformation.new_NatafEllipticalDistributionGradient(*args))
    __swig_destroy__ = _transformation.delete_NatafEllipticalDistributionGradient

# Register NatafEllipticalDistributionGradient in _transformation:
_transformation.NatafEllipticalDistributionGradient_swigregister(NatafEllipticalDistributionGradient)
class NatafEllipticalDistributionHessian(openturns.func.ConstantHessian):
    r"""Proxy of C++ OT::NatafEllipticalDistributionHessian."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.NatafEllipticalDistributionHessian_getClassName(self)

    def __repr__(self):
        return _transformation.NatafEllipticalDistributionHessian___repr__(self)

    def __init__(self, *args):
        _transformation.NatafEllipticalDistributionHessian_swiginit(self, _transformation.new_NatafEllipticalDistributionHessian(*args))
    __swig_destroy__ = _transformation.delete_NatafEllipticalDistributionHessian

# Register NatafEllipticalDistributionHessian in _transformation:
_transformation.NatafEllipticalDistributionHessian_swigregister(NatafEllipticalDistributionHessian)
class InverseNatafEllipticalDistributionEvaluation(openturns.func.LinearEvaluation):
    r"""Proxy of C++ OT::InverseNatafEllipticalDistributionEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.InverseNatafEllipticalDistributionEvaluation_getClassName(self)

    def parameterGradient(self, inP):
        r"""
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _transformation.InverseNatafEllipticalDistributionEvaluation_parameterGradient(self, inP)

    def __repr__(self):
        return _transformation.InverseNatafEllipticalDistributionEvaluation___repr__(self)

    def __init__(self, *args):
        _transformation.InverseNatafEllipticalDistributionEvaluation_swiginit(self, _transformation.new_InverseNatafEllipticalDistributionEvaluation(*args))
    __swig_destroy__ = _transformation.delete_InverseNatafEllipticalDistributionEvaluation

# Register InverseNatafEllipticalDistributionEvaluation in _transformation:
_transformation.InverseNatafEllipticalDistributionEvaluation_swigregister(InverseNatafEllipticalDistributionEvaluation)
class InverseNatafEllipticalDistributionGradient(openturns.func.ConstantGradient):
    r"""Proxy of C++ OT::InverseNatafEllipticalDistributionGradient."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.InverseNatafEllipticalDistributionGradient_getClassName(self)

    def __repr__(self):
        return _transformation.InverseNatafEllipticalDistributionGradient___repr__(self)

    def __init__(self, *args):
        _transformation.InverseNatafEllipticalDistributionGradient_swiginit(self, _transformation.new_InverseNatafEllipticalDistributionGradient(*args))
    __swig_destroy__ = _transformation.delete_InverseNatafEllipticalDistributionGradient

# Register InverseNatafEllipticalDistributionGradient in _transformation:
_transformation.InverseNatafEllipticalDistributionGradient_swigregister(InverseNatafEllipticalDistributionGradient)
class InverseNatafEllipticalDistributionHessian(openturns.func.ConstantHessian):
    r"""Proxy of C++ OT::InverseNatafEllipticalDistributionHessian."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.InverseNatafEllipticalDistributionHessian_getClassName(self)

    def __repr__(self):
        return _transformation.InverseNatafEllipticalDistributionHessian___repr__(self)

    def __init__(self, *args):
        _transformation.InverseNatafEllipticalDistributionHessian_swiginit(self, _transformation.new_InverseNatafEllipticalDistributionHessian(*args))
    __swig_destroy__ = _transformation.delete_InverseNatafEllipticalDistributionHessian

# Register InverseNatafEllipticalDistributionHessian in _transformation:
_transformation.InverseNatafEllipticalDistributionHessian_swigregister(InverseNatafEllipticalDistributionHessian)
class RosenblattEvaluation(openturns.func.EvaluationImplementation):
    r"""Proxy of C++ OT::RosenblattEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.RosenblattEvaluation_getClassName(self)

    def __call__(self, inP):
        return _transformation.RosenblattEvaluation___call__(self, inP)

    def parameterGradient(self, inP):
        r"""
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _transformation.RosenblattEvaluation_parameterGradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _transformation.RosenblattEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _transformation.RosenblattEvaluation_getOutputDimension(self)

    def __repr__(self):
        return _transformation.RosenblattEvaluation___repr__(self)

    def __str__(self, *args):
        return _transformation.RosenblattEvaluation___str__(self, *args)

    def __init__(self, *args):
        _transformation.RosenblattEvaluation_swiginit(self, _transformation.new_RosenblattEvaluation(*args))
    __swig_destroy__ = _transformation.delete_RosenblattEvaluation

# Register RosenblattEvaluation in _transformation:
_transformation.RosenblattEvaluation_swigregister(RosenblattEvaluation)
class InverseRosenblattEvaluation(openturns.func.EvaluationImplementation):
    r"""Proxy of C++ OT::InverseRosenblattEvaluation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.InverseRosenblattEvaluation_getClassName(self)

    def __call__(self, inP):
        return _transformation.InverseRosenblattEvaluation___call__(self, inP)

    def parameterGradient(self, inP):
        r"""
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _transformation.InverseRosenblattEvaluation_parameterGradient(self, inP)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _transformation.InverseRosenblattEvaluation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _transformation.InverseRosenblattEvaluation_getOutputDimension(self)

    def __repr__(self):
        return _transformation.InverseRosenblattEvaluation___repr__(self)

    def __str__(self, *args):
        return _transformation.InverseRosenblattEvaluation___str__(self, *args)

    def __init__(self, *args):
        _transformation.InverseRosenblattEvaluation_swiginit(self, _transformation.new_InverseRosenblattEvaluation(*args))
    __swig_destroy__ = _transformation.delete_InverseRosenblattEvaluation

# Register InverseRosenblattEvaluation in _transformation:
_transformation.InverseRosenblattEvaluation_swigregister(InverseRosenblattEvaluation)
class DistributionTransformation(openturns.func.Function):
    r"""
    Isoprobabilistic transformation.

    Parameters
    ----------
    left, right : :class:`~openturns.Distribution`
        The transformation that maps *left* into *right*.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.DistributionTransformation_getClassName(self)

    def __eq__(self, *args):
        return _transformation.DistributionTransformation___eq__(self, *args)

    def inverse(self):
        r"""
        Inverse isoprobabilistic transformation.

        Returns
        -------
        inverseT : :class:`~openturns.DistributionTransformation`
            The inverse transformation.

        Notes
        -----
        The DistributionTransformation maps the distribution *left* into the distribution *right*
        with the transformation :math:`T`.

        Let :math:`d_1` be the *left* distribution and :math:`d_2` be the *right* distribution, each
        of dimension :math:`d`. The transformation is defined by:

        .. math::
           T(d_1) = d_2

        We recall here the definition of the distribution of the standard space associated to a given
        distribution. It is defined as follows:

        - If the copula is normal, it is the normal distribution with zero mean, unit variance and identity
          correlation matrix. It is obtained with the Nataf transformation.

        - If the copula is elliptical, it is the associated elliptical distribution (obtained by a marginal
          transformation) which is finally transformed into a spherical distribution by a linear transformation.
          It is obtained with the generalized Nataf transformation.

        - If the copula is not elliptical, it is the normal distribution with zero mean, unit variance and
          identity correlation matrix. It is obtained with the Rosenblatt transformation.

        The library treats several cases.

        Case 1: Both distributions :math:`d_1` and :math:`d_2` are identical, then :math:`T` is the
        Identity transformation:

        .. math::
           T = Id

        Case 2: Both distributions share the same copula. Then, the transformation is a marginal transformation:
        each component :math:`d_1^i` is transformed into the associated component :math:`d_2^i` by the
        transformation :math:`T_i = (F_2^i)^{-1} \circ F_1^i`. Then :math:`T` is defined by:

        .. math::
           T = (T_1, \dots, T_d)

        Case 3: Both distributions share the same standard space. Then we can define the transformation
        :math:`T_i` that maps :math:`d_i` into the distribution of its standard space. As we have
        :math:`T_1(d_1) = T_2(d_2)`, we get: 

        .. math::
           T = T_2^{-1}\circ T_1

        Case 4: both distributions have different standard spaces. Then, we denote by :math:`T_i` the
        transformation that transforms :math:`d_i` into the normal distribution with zero mean, unit variance
        and identity correlation matrix. The final transformation :math:`T` is defined by:


        .. math::
           T = T_2^{-1}\circ T_1

        """
        return _transformation.DistributionTransformation_inverse(self)

    def __repr__(self):
        return _transformation.DistributionTransformation___repr__(self)

    def __str__(self, *args):
        return _transformation.DistributionTransformation___str__(self, *args)

    def __init__(self, *args):
        _transformation.DistributionTransformation_swiginit(self, _transformation.new_DistributionTransformation(*args))
    __swig_destroy__ = _transformation.delete_DistributionTransformation

# Register DistributionTransformation in _transformation:
_transformation.DistributionTransformation_swigregister(DistributionTransformation)
import openturns.metamodel
import openturns.weightedexperiment
import openturns.orthogonalbasis
import openturns.randomvector
class BoxCoxFactory(openturns.common.PersistentObject):
    r"""
    BoxCox transformation estimator.

    Notes
    -----
    The class :class:`~openturns.BoxCoxFactory` enables to build a Box Cox transformation from data.

    The Box Cox transformation :math:`h_{\vect{\lambda}, \vect{\alpha}}: \Rset^d \rightarrow \Rset^d` maps a sample into a new sample following a normal distribution with independent components. That sample may be the realization of a process as well as the realization of a distribution.

    In the multivariate case, we proceed component by component: :math:`h_{\lambda_i, \alpha_i}: \Rset \rightarrow \Rset` which writes:

    .. math::

        h_{\lambda_i, \alpha_i}(x) = 
        \left\{
        \begin{array}{ll}
        \dfrac{(x+\alpha_i)^\lambda-1}{\lambda_i} & \lambda_i \neq 0 \\
        \log(x+\alpha_i)                        & \lambda_i = 0
        \end{array}
        \right.

    for all :math:`x+\alpha_i >0`.

    |

    BoxCox transformation could also be performed in the case of the estimation of a general linear model through :class:`~openturns.GeneralLinearModelAlgorithm`.
    The objective is to estimate the most likely surrogate model (general linear model) which links input data :math:`x` and :math:`h_{\vect{\lambda}, \vect{\alpha}}(y)`. :math:`\vect{\lambda}` are to be calibrated such as maximizing the general linear model's likelihood function. In that context, a :class:`~openturns.CovarianceModel` and a :class:`~openturns.Basis` have to be fixed

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.BoxCoxFactory_getClassName(self)

    def __repr__(self):
        return _transformation.BoxCoxFactory___repr__(self)

    def __str__(self, *args):
        return _transformation.BoxCoxFactory___str__(self, *args)

    def build(self, *args):
        r"""
        Estimate the Box Cox transformation.

        Parameters
        ----------
        data : :class:`~openturns.Field` or 2-d sequence of float
            One realization of a process.
        shift : :class:`~openturns.Point`, optional
            It ensures that when shifted, the data are all positive.
            By default the opposite of the min vector of the data is used if some data are negative.

        Returns
        -------
        transform : :class:`~openturns.BoxCoxTransform`
            The estimated Box Cox transformation.

        Notes
        -----

        We describe the estimation in the univariate case, in the case of no surrogate model estimate. Only the parameter :math:`\lambda` is estimated. To clarify the notations, we omit the mention of :math:`\alpha` in :math:`h_\lambda`.

        We note :math:`(x_0, \dots, x_{N-1})` a sample of :math:`X`. We suppose that :math:`h_\lambda(X) \sim \cN(\beta , \sigma^2 )`.

        The parameters :math:`(\beta,\sigma,\lambda)` are  estimated by the maximum likelihood estimators. We note :math:`\Phi_{\beta, \sigma}` and :math:`\phi_{\beta, \sigma}` respectively the cumulative distribution function and the density probability function of the :math:`\cN(\beta , \sigma^2)` distribution.

        We have :

        .. math::

            \begin{array}{lcl}
              \forall v \geq 0, \, \Prob{ X \leq v } & = & \Prob{ h_\lambda(X) \leq h_\lambda(v) } \\
              & = & \Phi_{\beta, \sigma} \left(h_\lambda(v)\right)
            \end{array}

        from which we derive the  density probability function *p* of :math:`X`:

        .. math::

            \begin{array}{lcl}
              p(v) & = & h_\lambda'(v)\phi_{\beta, \sigma}(v) = v^{\lambda - 1}\phi_{\beta, \sigma}(v)
            \end{array}

        which enables to write the likelihood of the values :math:`(x_0, \dots, x_{N-1})`:

        .. math::

            \begin{array}{lcl}
              L(\beta,\sigma,\lambda)
              & = &
              \underbrace{ \frac{1}{(2\pi)^{N/2}}
                \times
                \frac{1}{(\sigma^2)^{N/2}}
                \times
                \exp\left[
                  -\frac{1}{2\sigma^2}
                  \sum_{k=0}^{N-1}
                  \left(
                  h_\lambda(x_k)-\beta
                  \right)^2
                  \right]
              }_{\Psi(\beta, \sigma)}
              \times
              \prod_{k=0}^{N-1} x_k^{\lambda - 1}
            \end{array}



        We notice that for each fixed :math:`\lambda`, the likelihood equation is proportional to the likelihood equation which estimates  :math:`(\beta, \sigma^2)`.

        Thus, the maximum likelihood estimators for :math:`(\beta(\lambda), \sigma^2(\lambda))` for a given :math:`\lambda`  are :

        .. math::

            \begin{array}{lcl}
             \hat{\beta}(\lambda) & = & \frac{1}{N} \sum_{k=0}^{N-1} h_{\lambda}(x_k) \\
             \hat{\sigma}^2(\lambda)  & = &  \frac{1}{N} \sum_{k=0}^{N-1} (h_{\lambda}(x_k) - \beta(\lambda))^2
            \end{array}

        Substituting these expressions in the likelihood equation and taking the :math:`\log-` likelihood leads to:

        .. math::

            \begin{array}{lcl}
              \ell(\lambda) = \log L( \hat{\beta}(\lambda), \hat{\sigma}(\lambda),\lambda ) & = & C -
              \frac{N}{2}
              \log\left[\hat{\sigma}^2(\lambda)\right]
              \;+\;
              \left(\lambda - 1 \right) \sum_{k=0}^{N-1} \log(x_i)\,,%\qquad mbox{where :math:`C` is a constant.}
            \end{array}

        The parameter :math:`\hat{\lambda}` is the one maximizing :math:`\ell(\lambda)`.

        In the case of surrogate model estimate, we note :math:`(x_0, \dots, x_{N-1})` the input sample of :math:`X`, :math:`(y_0, \dots, y_{N-1})` the input sample of :math:`Y`.
        We suppose the general linear model link :math:`h_\lambda(Y) = \vect{F}^t(\vect{x}) \vect{\beta} + \vect{Z}` with :math:`\mat{F} \in \mathcal{M}_{np, M}(\Rset)`:

        .. math::
            \mat{F}(\vect{x}) = \left(
              \begin{array}{lcl}
                \vect{f}_1(\vect{x}_1) & \dots & \vect{f}_M(\vect{x}_1) \\
                \dots & \dots & \\
                \vect{f}_1(\vect{x}_n) & \dots & \vect{f}_M(\vect{x}_n)
               \end{array}
             \right)

        :math:`(f_1, \dots, f_M)` is a functional basis with :math:`f_i: \Rset^d \mapsto \Rset^p` for all *i*, :math:`\beta` are the coefficients of the linear combination and :math:`Z` is a zero-mean gaussian process with a stationary covariance function :math:`C_{\vect{\sigma}, \vect{\theta}}`
        Thus implies that :math:`h_\lambda(Y) \sim \cN(\vect{F}^t(\vect{x}) \vect{\beta}, C_{\vect{\sigma}, \vect{\theta}})`.

        The likelihood function to be maximized writes as follows:

        .. math::

            \begin{array}{lcl}
              \ell_{glm}(\lambda) = \log L(\lambda ) & = & C - \log\left( |C^{\lambda}_{\vect{\sigma}, \vect{\theta}} | \right)
              \;-\;
            \left( h_\lambda(Y) - \vect{F}^t(\vect{x}) \vect{\beta} \right) {C^{\lambda}_{\vect{\sigma}, \vect{\theta}}}^{-1}
            \left( h_\lambda(Y) - \vect{F}^t(\vect{x}) \vect{\beta} \right)^t
            \end{array}

        where :math:`C^{\lambda}_{\vect{\sigma}, \vect{\theta}}` is the matrix resulted from the discretization of the covariance model over :math:`X`.
        The parameter :math:`\hat{\lambda}` is the one maximizing :math:`\ell_{glm}(\lambda)`.

        Examples
        --------
        Estimate the Box Cox transformation from a sample:

        >>> import openturns as ot
        >>> sample = ot.Exponential(2).getSample(10)
        >>> factory = ot.BoxCoxFactory()
        >>> transform = factory.build(sample)
        >>> estimatedLambda = transform.getLambda()

        Estimate the Box Cox transformation from a field:

        >>> indices = [10, 5]
        >>> mesher = ot.IntervalMesher(indices)
        >>> interval = ot.Interval([0.0, 0.0], [2.0, 1.0])
        >>> mesh = mesher.build(interval)
        >>> amplitude = [1.0]
        >>> scale = [0.2, 0.2]
        >>> covModel = ot.ExponentialModel(scale, amplitude)
        >>> Xproc = ot.GaussianProcess(covModel, mesh)
        >>> g = ot.SymbolicFunction(['x1'],  ['exp(x1)'])
        >>> dynTransform = ot.ValueFunction(g, mesh)
        >>> XtProcess = ot.CompositeProcess(dynTransform, Xproc)

        >>> field = XtProcess.getRealization()
        >>> transform = ot.BoxCoxFactory().build(field)

        """
        return _transformation.BoxCoxFactory_build(self, *args)

    def buildWithGraph(self, *args):
        r"""
        Estimate the Box Cox transformation with graph output.

        Parameters
        ----------
        data : :class:`~openturns.Field` or 2-d sequence of float
            One realization of a process.
        shift : :class:`~openturns.Point`
            It ensures that when shifted, the data are all positive.
            By default the opposite of the min vector of the data is used if some data are negative.

        Returns
        -------
        transform : :class:`~openturns.BoxCoxTransform`
            The estimated Box Cox transformation.
        graph : :class:`~openturns.Graph`
            The graph plots the evolution of the likelihood with respect to the value of :math:`\lambda` for each component *i*.
            It enables to graphically detect the optimal values.
        """
        return _transformation.BoxCoxFactory_buildWithGraph(self, *args)

    def buildWithGLM(self, *args):
        r"""
        Estimate the Box Cox transformation with general linear model.

        Refer to :meth:`build` for details.

        Parameters
        ----------
        inputSample, outputSample : :class:`~openturns.Sample` or 2d-array
            The input and output samples of a model evaluated apart.
        covarianceModel : :class:`~openturns.CovarianceModel`
            Covariance model.
            Should have input dimension equal to input sample's dimension and dimension equal to output sample's dimension.
            See note for some particular applications.
        basis : :class:`~openturns.Basis`, optional
            Functional basis to estimate the trend: :math:`(\varphi_j)_{1 \leq j \leq n_1}: \Rset^n \rightarrow \Rset`.
            If :math:`d>1`, the same basis is used for each marginal output.
        shift : :class:`~openturns.Point`
            It ensures that when shifted, the data are all positive.
            By default the opposite of the min vector of the data is used if some data are negative.

        Returns
        -------
        transform : :class:`~openturns.BoxCoxTransform`
            The estimated Box Cox transformation.
        generalLinearModelResult : :class:`~openturns.GeneralLinearModelResult`
            The structure that contains results of general linear model algorithm.

        Examples
        --------
        Estimation of a general linear model:

        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> inputSample = ot.Uniform(-1.0, 1.0).getSample(20)
        >>> outputSample = ot.Sample(inputSample)
        >>> # Evaluation of y = ax + b (a: scale, b: translate)
        >>> outputSample = outputSample * [3] + [3.1]
        >>> # inverse transfo + small noise
        >>> def f(x): import math; return [math.exp(x[0])]
        >>> inv_transfo = ot.PythonFunction(1, 1, f)
        >>> outputSample = inv_transfo(outputSample) + ot.Normal(0, 1.0e-2).getSample(20)
        >>> # Estimation
        >>> basis = ot.LinearBasisFactory(1).build()
        >>> covarianceModel = ot.DiracCovarianceModel()
        >>> shift = [1.0e-1]
        >>> boxCox, result = ot.BoxCoxFactory().buildWithGLM(inputSample, outputSample, covarianceModel, basis, shift)

        """
        return _transformation.BoxCoxFactory_buildWithGLM(self, *args)

    def buildWithLM(self, *args):
        r"""
        Estimate the Box Cox transformation with linear model.

        Refer to :meth:`build` for details.

        Parameters
        ----------
        inputSample, outputSample : :class:`~openturns.Sample` or 2d-array
            The input and output samples of a model evaluated apart.
        covarianceModel : :class:`~openturns.CovarianceModel`
            Covariance model.
            Should have input dimension equal to input sample's dimension and dimension equal to output sample's dimension.
            See note for some particular applications.
        basis : :class:`~openturns.Basis`, optional
            Functional basis to estimate the trend: :math:`(\varphi_j)_{1 \leq j \leq n_1}: \Rset^n \rightarrow \Rset`.
            If :math:`d>1`, the same basis is used for each marginal output.
        shift : :class:`~openturns.Point`
            It ensures that when shifted, the data are all positive.
            By default the opposite of the min vector of the data is used if some data are negative.

        Returns
        -------
        transform : :class:`~openturns.BoxCoxTransform`
            The estimated Box Cox transformation.
        linearModelResult : :class:`~openturns.LinearModelResult`
            The structure that contains results of linear model algorithm.

        Examples
        --------
        Estimation of a linear model:

        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> x = ot.Uniform(-1.0, 1.0).getSample(20)
        >>> y = ot.Sample(x)
        >>> # Evaluation of y = ax + b (a: scale, b: translate)
        >>> y = y * [3] + [3.1]
        >>> # inverse transformation
        >>> inv_transformation = ot.SymbolicFunction('x', 'exp(x)')
        >>> y = inv_transformation(y) + ot.Normal(0, 1.0e-4).getSample(20)
        >>> # Estimation
        >>> shift = [1.0e-1]
        >>> boxCox, result = ot.BoxCoxFactory().buildWithLM(x, y, shift)

        """
        return _transformation.BoxCoxFactory_buildWithLM(self, *args)

    def getOptimizationAlgorithm(self):
        r"""
        Accessor to the solver.

        Returns
        -------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for numerical optimization.
        """
        return _transformation.BoxCoxFactory_getOptimizationAlgorithm(self)

    def setOptimizationAlgorithm(self, solver):
        r"""
        Accessor to the solver.

        Parameters
        ----------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for numerical optimization.
        """
        return _transformation.BoxCoxFactory_setOptimizationAlgorithm(self, solver)

    def __init__(self, *args):
        _transformation.BoxCoxFactory_swiginit(self, _transformation.new_BoxCoxFactory(*args))
    __swig_destroy__ = _transformation.delete_BoxCoxFactory

# Register BoxCoxFactory in _transformation:
_transformation.BoxCoxFactory_swigregister(BoxCoxFactory)
class TrendFactory(openturns.common.PersistentObject):
    r"""
    Trend estimator.

    Refer to :ref:`trend_transform`.

    Parameters
    ----------
    basisSequenceFactory : :class:`~openturns.BasisSequenceFactory`
        The  regression strategy that provides the estimation of the  coefficients associated to the best model among the  basis functions.

        Default is the *least angle regression* (LARS) method for the choice of sparse models: :class:`~openturns.LARS`.
    fittingAlgorithm : :class:`~openturns.FittingAlgorithm`, optional
        The fitting algorithm that estimates the empirical error on each sub-basis.

        Default is the *leave one out* strategy: :class:`~openturns.CorrectedLeaveOneOut`.

    Notes
    -----
    A multivariate stochastic  process :math:`X: \Omega \times \cD \rightarrow \Rset^d` of dimension *d* where :math:`\cD \in \Rset^n` can write as the sum of a trend function :math:`f_{trend}: \Rset^n \rightarrow \Rset^d` and a stationary multivariate stochastic process :math:`X_{stat}: \Omega \times \cD \rightarrow \Rset^d` of dimension *d* as follows:

    .. math::

       X(\omega,\vect{t}) = X_{stat}(\omega,\vect{t}) + f_{trend}(\vect{t})

    The  :class:`~openturns.TrendFactory` enables to identify the trend  function :math:`f_{trend}` from a given field of the process *X* and then to remove this last one from the initial field. The resulting field is a realization of the process :math:`X_{stat}`.

    We consider the functional basis :math:`\cB = (f_1, f_2, \ldots, f_K)` with :math:`f_j : \Rset^n \longrightarrow \Rset^d`. The trend function :math:`f_{trend}` writes:

    .. math::

        f_{trend}(\vect{t}) = \sum_{j=1}^{K} \alpha_j f_j(\vect{t})

    The coefficients :math:`\alpha_j \in \Rset` have to be computed. In the case where the number of available data is of the same order as *K*, the least square system is ill-posed and a  more complex algorithm should be used. Some algorithms combine cross validation techniques and advanced regression strategies, in order to provide the estimation of the  coefficients associated to the best model among the  basis functions (sparse model). For example, we can use the *least angle regression* (LARS) method for the choice of sparse models.  Then, some fitting algorithms like the *leave one out*, coupled to the regression strategy, assess the error on the prediction and enable the selection of the best sparse model.


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _transformation.TrendFactory_getClassName(self)

    def getBasisSequenceFactory(self):
        r"""
        Accessor to functional basis.

        Returns
        -------
        myBasisSequenceFactory : :class:`~openturns.BasisSequenceFactory`
            The functional basis :math:`\cB`.


        """
        return _transformation.TrendFactory_getBasisSequenceFactory(self)

    def setBasisSequenceFactory(self, basisSequenceFactory):
        r"""
        Accessor to functional basis.

        Parameters
        ----------
        myBasisSequenceFactory : :class:`~openturns.BasisSequenceFactory`
            The functional basis :math:`\cB`.


        """
        return _transformation.TrendFactory_setBasisSequenceFactory(self, basisSequenceFactory)

    def getFittingAlgorithm(self):
        r"""
        Accessor to fitting algorithm  basis.

        Returns
        -------
        myFittingAlgorithm : :class:`~openturns.FittingAlgorithm`
            The fitting algorithm that estimates the empirical error on each sub-basis.


        """
        return _transformation.TrendFactory_getFittingAlgorithm(self)

    def setFittingAlgorithm(self, fittingAlgorithm):
        r"""
        Accessor to fitting algorithm  basis.

        Parameters
        ----------
        myFittingAlgorithm : :class:`~openturns.FittingAlgorithm`
            The fitting algorithm that estimates the empirical error on each sub-basis.


        """
        return _transformation.TrendFactory_setFittingAlgorithm(self, fittingAlgorithm)

    def __repr__(self):
        return _transformation.TrendFactory___repr__(self)

    def __str__(self, *args):
        return _transformation.TrendFactory___str__(self, *args)

    def build(self, field, basis):
        r"""
        Estimate the trend of a process.

        Available usages:
            build(*field, basis*)

        Parameters
        ----------
        field : :class:`~openturns.Field`
            One realization of the process.
        basis : :class:`~openturns.Basis`
            A collection of functions composing the functional basis.

        Returns
        -------
        myTrendTransform : :class:`~openturns.TrendTransform`
            The estimated trend function.

        Examples
        --------
        Define a scalar temporal Gaussian process on a mesh of dimension 1:

        >>> import openturns as ot
        >>> myGrid = ot.RegularGrid(0.0, 1.0, 100)
        >>> amplitude=[5.0]
        >>> scale=[0.2]
        >>> myCovModel=ot.ExponentialModel(scale, amplitude)
        >>> myXProcess=ot.GaussianProcess(myCovModel, myGrid)

        Create a trend function: :math:`f_{trend} : \Rset \mapsto \Rset` where :math:`f_{trend}(t)=1+2t+t^2`:

        >>> fTrend = ot.SymbolicFunction(['t'], ['1+2*t+t^2'])
        >>> fTemp = ot.TrendTransform(fTrend, myGrid)


        Add the trend to the initial process and get a field:

        >>> myYProcess = ot.CompositeProcess(fTemp, myXProcess)
        >>> myYField = myYProcess.getRealization()

        Estimate the trend function from the field:

        >>> myBasisSequenceFactory = ot.LARS()
        >>> myFittingAlgorithm = ot.KFold()
        >>> func1 = ot.SymbolicFunction(['t'], ['1'])
        >>> func2 = ot.SymbolicFunction(['t'], ['t'])
        >>> func3 = ot.SymbolicFunction(['t'], ['t^2'])
        >>> myBasis = ot.Basis([func1, func2, func3])

        >>> myTrendFactory = ot.TrendFactory(myBasisSequenceFactory, myFittingAlgorithm)
        >>> myTrendTransform =  myTrendFactory.build(myYField, myBasis)

        >>> graph = myTrendTransform.getTrendFunction().draw(0.0, 10)
        >>> graph.add(fTrend.draw(0.0, 10))
        >>> graph.add(ot.Cloud(myYField.getMesh().getVertices(), myYField.getValues()))
        >>> graph.setLegends(['estimated trend', 'actual trend', 'sample'])
        >>> graph.setLegendPosition('upper left')
        >>> graph.setTitle('Trend estimation from a field')
        >>> graph.setYTitle('values')


        """
        return _transformation.TrendFactory_build(self, field, basis)

    def __init__(self, *args):
        _transformation.TrendFactory_swiginit(self, _transformation.new_TrendFactory(*args))
    __swig_destroy__ = _transformation.delete_TrendFactory

# Register TrendFactory in _transformation:
_transformation.TrendFactory_swigregister(TrendFactory)

