/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.ext.awt.g2d.TransformStackElement;
import io.sf.carte.echosvg.svggen.AbstractSVGConverter;
import io.sf.carte.echosvg.svggen.SVGDescriptor;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGTransformDescriptor;
import java.util.Stack;

public class SVGTransform
extends AbstractSVGConverter {
    private static double radiansToDegrees = 57.29577951308232;

    public SVGTransform(SVGGeneratorContext generatorContext) {
        super(generatorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext gc) {
        return new SVGTransformDescriptor(this.toSVGTransform(gc));
    }

    public final String toSVGTransform(GraphicContext gc) {
        return this.toSVGTransform(gc.getTransformStack());
    }

    public final String toSVGTransform(TransformStackElement[] transformStack) {
        int nTransforms = transformStack.length;
        Stack<TransformStackElement> presentation = new Stack<TransformStackElement>(){
            private static final long serialVersionUID = 1L;

            @Override
            public TransformStackElement push(TransformStackElement o) {
                TransformStackElement element;
                if (o.isIdentity()) {
                    element = this.pop();
                } else {
                    super.push(o);
                    element = null;
                }
                return element;
            }

            @Override
            public TransformStackElement pop() {
                TransformStackElement element = null;
                if (!super.empty()) {
                    element = (TransformStackElement)super.pop();
                }
                return element;
            }
        };
        boolean canConcatenate = false;
        int i = 0;
        int j = 0;
        int next = 0;
        TransformStackElement element = null;
        while (i < nTransforms) {
            next = i;
            if (element == null) {
                element = transformStack[i].clone();
            }
            canConcatenate = true;
            for (j = ++next; j < nTransforms && (canConcatenate = element.concatenate(transformStack[j])); ++j) {
            }
            i = j;
            element = presentation.push(element);
        }
        if (element != null) {
            presentation.push(element);
        }
        int nPresentations = presentation.size();
        StringBuilder transformStackBuffer = new StringBuilder(nPresentations * 8);
        for (i = 0; i < nPresentations; ++i) {
            transformStackBuffer.append(this.convertTransform((TransformStackElement)presentation.get(i)));
            transformStackBuffer.append(" ");
        }
        String transformValue = transformStackBuffer.toString().trim();
        return transformValue;
    }

    final String convertTransform(TransformStackElement transformElement) {
        StringBuilder transformString = new StringBuilder();
        double[] transformParameters = transformElement.getTransformParameters();
        switch (transformElement.getType().toInt()) {
            case 0: {
                if (transformElement.isIdentity()) break;
                transformString.append("translate");
                transformString.append("(");
                transformString.append(this.doubleString(transformParameters[0]));
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[1]));
                transformString.append(")");
                break;
            }
            case 1: {
                if (transformElement.isIdentity()) break;
                transformString.append("rotate");
                transformString.append("(");
                transformString.append(this.doubleString(radiansToDegrees * transformParameters[0]));
                transformString.append(")");
                break;
            }
            case 2: {
                if (transformElement.isIdentity()) break;
                transformString.append("scale");
                transformString.append("(");
                transformString.append(this.doubleString(transformParameters[0]));
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[1]));
                transformString.append(")");
                break;
            }
            case 3: {
                if (transformElement.isIdentity()) break;
                transformString.append("matrix");
                transformString.append("(");
                transformString.append(1);
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[1]));
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[0]));
                transformString.append(",");
                transformString.append(1);
                transformString.append(",");
                transformString.append(0);
                transformString.append(",");
                transformString.append(0);
                transformString.append(")");
                break;
            }
            case 4: {
                if (transformElement.isIdentity()) break;
                transformString.append("matrix");
                transformString.append("(");
                transformString.append(this.doubleString(transformParameters[0]));
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[1]));
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[2]));
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[3]));
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[4]));
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[5]));
                transformString.append(")");
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return transformString.toString();
    }
}

