/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcLLAltGridding;
import gov.nasa.giss.data.nc.NcLLAltGriddingVarType;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjGridding;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LambertConformal;

public class NcArrayLonLatLambertConformalConic
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean USE_NJ_PROJ = false;
    private Projection njProj_;
    private double phi1_ = 30.0;
    private double phi2_ = -30.0;
    private double termF_;
    private double nn_;
    private double oneOverN_;
    private double rho0_;

    public NcArrayLonLatLambertConformalConic(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjGridding.LAMBERT_CONFORMAL);
        LOGGER.trace("");
        this.initMe();
    }

    private void initMe() {
        LOGGER.trace("");
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcLLAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcLLAltGriddingVarType)vtype).isGrid(NcLLAltGridding.LAMBERT_CONFORMAL)) {
            throw new NcException("Variable is not projected type Lambert conformal conic.");
        }
        LOGGER.trace("Using GISS proj");
        this.initGissProj();
    }

    private void initUnidataProj() {
        LOGGER.trace("");
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List csList = njvarDS.getCoordinateSystems();
        if (csList == null || csList.isEmpty()) {
            throw new NcException("No coordinate system(s) reported.");
        }
        CoordinateSystem cs = (CoordinateSystem)csList.get(0);
        LOGGER.trace("cs {}", (Object)cs);
        ProjectionImpl pj = cs.getProjection();
        if (pj == null) {
            throw new NcNullException("C.S. returned null projection handler.");
        }
        LOGGER.trace("C.S. returned projection {}", (Object)pj.getClass().getSimpleName());
        if (!(pj instanceof LambertConformal)) {
            LOGGER.warn("Expected LambertConformal class but got {}", (Object)pj.getClass().getSimpleName());
            throw new NcException("C.S. returned projection class " + pj.getClass().getSimpleName() + " when LambertConformal was expected");
        }
        this.njProj_ = pj;
        LOGGER.trace("pj {}", (Object)pj);
    }

    private void initGissProj() {
        LOGGER.trace("");
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("lambert_conformal_conic")) {
            LOGGER.trace("Found unusable mapping name {}", (Object)this.mappingName_);
            throw new NcException("Mapping name is not lambert_conformal_conic");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        Attribute parallelsA = this.mappingVarDS_.findAttribute("standard_parallel");
        if (parallelsA == null) {
            throw new NcException("Coordinate transform variable is missing standard parallel(s)");
        }
        if (parallelsA.isArray()) {
            Array pararray = parallelsA.getValues();
            double[] parvalues = (double[])pararray.get1DJavaArray(DataType.DOUBLE);
            this.phi1_ = parvalues[0];
            this.phi2_ = parvalues[1];
        } else {
            this.phi2_ = this.phi1_ = parallelsA.getNumericValue().doubleValue();
        }
        double phiCRad = this.phiCRad_;
        double phi1Rad = Math.toRadians(this.phi1_);
        double phi2Rad = Math.toRadians(this.phi2_);
        double cosPhi1 = Math.cos(phi1Rad);
        double cosPhi2 = Math.cos(phi2Rad);
        double tanTermC = Math.tan(0.7853981633974483 + 0.5 * phiCRad);
        double tanTerm1 = Math.tan(0.7853981633974483 + 0.5 * phi1Rad);
        double tanTerm2 = Math.tan(0.7853981633974483 + 0.5 * phi2Rad);
        this.nn_ = this.phi1_ == this.phi2_ ? Math.sin(phi1Rad) : Math.log(cosPhi1 / cosPhi2) / Math.log(tanTerm2 / tanTerm1);
        this.oneOverN_ = 1.0 / this.nn_;
        this.termF_ = cosPhi1 * Math.pow(tanTerm1, this.nn_) * this.oneOverN_;
        this.rho0_ = this.termF_ / Math.pow(tanTermC, this.nn_);
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        if (lat < 90.0 && lat > -90.0) {
            double lambdaRad = this.lonToLambdaRad(lon);
            double phiRad = Math.toRadians(lat);
            double rho = this.termF_ / Math.pow(Math.tan(0.7853981633974483 + 0.5 * phiRad), this.nn_);
            double thetaRad = this.nn_ * lambdaRad;
            double x = rho * Math.sin(thetaRad);
            double y = this.rho0_ - rho * Math.cos(thetaRad);
            return new Point2D.Double(x * this.radius_ + this.falseEasting_, y * this.radius_ + this.falseNorthing_);
        }
        if (lat == 90.0) {
            if (this.nn_ < 0.0) {
                return null;
            }
            return new Point2D.Double(0.0, this.rho0_ * this.radius_ + this.falseNorthing_);
        }
        if (this.nn_ > 0.0) {
            return null;
        }
        return new Point2D.Double(0.0, this.rho0_ * this.radius_ + this.falseNorthing_);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double phiRad;
        double xOverR = (x - this.falseEasting_) * this.oneOverR_;
        double yOverR = (y - this.falseNorthing_) * this.oneOverR_;
        double rho0MinusYOverR = this.rho0_ - yOverR;
        double rho = Math.hypot(xOverR, rho0MinusYOverR);
        if (this.nn_ < 0.0) {
            rho = -rho;
        }
        if (Math.abs(phiRad = 2.0 * (Math.atan(Math.pow(this.termF_ / rho, this.oneOverN_)) - 0.7853981633974483)) > 1.5707963267948966) {
            return null;
        }
        double thetaRad = this.nn_ < 0.0 ? Math.atan2(-xOverR, -rho0MinusYOverR) : Math.atan2(xOverR, rho0MinusYOverR);
        double lambdaRad = thetaRad * this.oneOverN_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }
}

