/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import com.google.common.collect.ImmutableList;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcLLAltGridding;
import gov.nasa.giss.data.nc.NcLLAltGriddingVarType;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjGridding;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLatRotatedPole;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonLatRotatedPole
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PointLL northPole_;
    private double[][] rotY_ = new double[3][3];
    private double[][] rotZ_ = new double[3][3];

    public NcArrayLonLatRotatedPole(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjGridding.ROTATED_POLE);
        this.initMe();
    }

    @Override
    protected void createAxes() {
        CoordinateAxis xaxis = NcUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.GEOX);
        CoordinateAxis yaxis = NcUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.GEOY);
        if (xaxis == null || yaxis == null) {
            LOGGER.trace("Searching for CoordinateAxes by standard_name");
            xaxis = this.getCoordinateAxisWithStdName("grid_longitude");
            yaxis = this.getCoordinateAxisWithStdName("grid_latitude");
        }
        if (xaxis == null || yaxis == null) {
            LOGGER.trace("Searching for CoordinateAxes by short name");
            xaxis = this.getCoordinateAxisMatchingShortName(".*lon.*");
            yaxis = this.getCoordinateAxisMatchingShortName(".*lat.*");
        }
        if (xaxis == null || yaxis == null) {
            LOGGER.trace("Trying to create CoordinateAxes");
            for (int i = 0; i < this.rank_; ++i) {
                VariableDS dimvar;
                String lcname;
                Dimension d = this.getDimension(i);
                String dname = d.getShortName();
                if (dname == null || !(lcname = dname.toLowerCase()).contains("lon") && !lcname.contains("lat") || (dimvar = this.getDataset().getVariableDS(dname)) == null) continue;
                if (lcname.contains("lon")) {
                    xaxis = NcUtils.getCoordinateAxisOfType(dimvar, AxisType.GeoX);
                    continue;
                }
                if (!lcname.contains("lat")) continue;
                yaxis = NcUtils.getCoordinateAxisOfType(dimvar, AxisType.GeoY);
            }
        }
        if (xaxis == null) {
            throw new NcNullException("Found null when retrieving GEOX coordinate axis");
        }
        if (yaxis == null) {
            throw new NcNullException("Found null when retrieving GEOY coordinate axis");
        }
        this.xAxis_ = new NcAxis(NcAxisType.GEOX, this.getDataset(), xaxis);
        this.yAxis_ = new NcAxis(NcAxisType.GEOY, this.getDataset(), yaxis);
        this.xDimIndex_ = this.findDimensionIndex(xaxis);
        this.yDimIndex_ = this.findDimensionIndex(yaxis);
        if (this.xDimIndex_ == -1) {
            throw new NcException("Unable to determine dim index for GEOX axis");
        }
        if (this.yDimIndex_ == -1) {
            throw new NcException("Unable to determine dim index for GEOY axis");
        }
    }

    private void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcLLAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcLLAltGriddingVarType)vtype).isGrid(NcLLAltGridding.ROTATED_POLE)) {
            throw new NcException("Variable is not a rotated pole variable");
        }
        Attribute gma = this.njvarDS_.attributes().findAttributeIgnoreCase("grid_mapping");
        String gmvarName = null;
        if (gma == null) {
            CoordinateSystem[] csarrray = this.getCoordinateSystems();
            CoordinateSystem cs = csarrray[0];
            ImmutableList<CoordinateTransform> ctList = cs.getCoordinateTransforms();
            if (ctList != null && !ctList.isEmpty()) {
                CoordinateTransform ct = (CoordinateTransform)ctList.get(0);
                gmvarName = ct.getName();
            }
        } else {
            gmvarName = gma.getStringValue();
        }
        if (gmvarName instanceof String) {
            this.examineMappingVariable(gmvarName);
        } else {
            if (!this.examineAxesPoleAttributes()) {
                throw new NcException("Could not find pole attributes");
            }
            if (!this.examineDimensions()) {
                throw new NcException("Could not find pole definition");
            }
        }
        this.buildRotationMatrices();
    }

    private void examineMappingVariable(String gmvarName) {
        VariableDS gmvar = this.dataset_.getVariableDS(gmvarName);
        if (gmvar == null) {
            throw new NcException("Grid mapping variable is missing");
        }
        Attribute gatt = gmvar.attributes().findAttributeIgnoreCase("grid_mapping_name");
        String gname = gatt.getStringValue();
        if (!(gname.equalsIgnoreCase("rotated_pole") || gname.equalsIgnoreCase("rotated_latitude_longitude") || gname.equalsIgnoreCase("rotated_latlon_grib"))) {
            throw new NcException("Grid mapping variable is not rotated pole");
        }
        Attribute lonA = gmvar.findAttribute("grid_north_pole_longitude");
        Attribute latA = gmvar.findAttribute("grid_north_pole_latitude");
        if (latA != null && lonA != null) {
            Number lonNum = lonA.getNumericValue();
            Number latNum = latA.getNumericValue();
            if (latNum == null || lonNum == null) {
                throw new NcException("Rotated N pole not defined with numerics");
            }
            this.northPole_ = new PointLL(lonNum.doubleValue(), latNum.doubleValue());
        } else {
            if (latA != null || lonA != null) {
                throw new NcException("Rotated N pole is ill defined");
            }
            lonA = gmvar.findAttribute("grid_south_pole_longitude");
            latA = gmvar.findAttribute("grid_south_pole_latitude");
            if (latA != null && lonA != null) {
                Number lonNum = lonA.getNumericValue();
                Number latNum = latA.getNumericValue();
                if (latNum == null || lonNum == null) {
                    throw new NcException("Rotated S pole not defined with numerics");
                }
                double sPoleLon = lonNum.doubleValue();
                double sPoleLat = latNum.doubleValue();
                this.northPole_ = new PointLL(sPoleLon + 180.0, -sPoleLat);
                Attribute rotA = gmvar.findAttribute("grid_south_pole_angle");
                Number rot = rotA.getNumericValue();
                if (rot != null && rot.doubleValue() != 0.0) {
                    LOGGER.warn("Non-zero grid_south_pole_angle specified. I'm not coded to handle that.");
                }
            } else if (latA != null || lonA != null) {
                throw new NcException("Rotated S pole is ill defined");
            }
        }
    }

    private boolean examineAxesPoleAttributes() {
        Attribute lonA = this.getXAxis().getNjAxisVar().findAttribute("grid_north_pole_longitude");
        Attribute latA = this.getYAxis().getNjAxisVar().findAttribute("grid_north_pole_latitude");
        if (lonA == null) {
            lonA = this.getXAxis().getNjAxisVar().findAttribute("north_pole");
        }
        if (latA == null) {
            latA = this.getYAxis().getNjAxisVar().findAttribute("north_pole");
        }
        if (latA == null || lonA == null) {
            return false;
        }
        Number lonNum = lonA.getNumericValue();
        Number latNum = latA.getNumericValue();
        if (latNum == null || lonNum == null) {
            throw new NcException("Rotated pole not defined with numerics (PA)");
        }
        this.northPole_ = new PointLL(lonNum.doubleValue(), latNum.doubleValue());
        return true;
    }

    private boolean examineDimensions() {
        String lonName = null;
        String latName = null;
        for (int i = 0; i < this.rank_; ++i) {
            Dimension d = this.getDimension(i);
            String dname = d.getShortName();
            if (dname == null) continue;
            String lcname = dname.toLowerCase();
            if (lcname.contains("lon")) {
                lonName = dname;
                continue;
            }
            if (!lcname.contains("lat")) continue;
            latName = dname;
        }
        if (lonName == null || latName == null) {
            return false;
        }
        Attribute lonA = this.getDataset().getVariableDS(lonName).findAttribute("long_name");
        Attribute latA = this.getDataset().getVariableDS(latName).findAttribute("long_name");
        if (lonA == null || latA == null) {
            return false;
        }
        if (!lonA.getStringValue().contains("rotated") || !latA.getStringValue().contains("rotated")) {
            return false;
        }
        this.examineMappingVariable("rotated_pole");
        return true;
    }

    private void buildRotationMatrices() {
        double lat = this.northPole_.getLat();
        double lon = this.northPole_.getLon();
        double betaRad = 0.0;
        double gammaRad = 0.0;
        if (lat == 90.0) {
            betaRad = 0.0;
            gammaRad = Math.toRadians(lon);
        } else {
            betaRad = -Math.toRadians(90.0 - lat);
            gammaRad = Math.toRadians(lon + 180.0);
        }
        double cosBeta = Math.cos(betaRad);
        double sinBeta = Math.sin(betaRad);
        double cosGamma = Math.cos(gammaRad);
        double sinGamma = Math.sin(gammaRad);
        this.rotY_[0][0] = cosBeta;
        this.rotY_[0][1] = 0.0;
        this.rotY_[0][2] = -sinBeta;
        this.rotY_[1][0] = 0.0;
        this.rotY_[1][1] = 1.0;
        this.rotY_[1][2] = 0.0;
        this.rotY_[2][0] = sinBeta;
        this.rotY_[2][1] = 0.0;
        this.rotY_[2][2] = cosBeta;
        this.rotZ_[0][0] = cosGamma;
        this.rotZ_[0][1] = sinGamma;
        this.rotZ_[0][2] = 0.0;
        this.rotZ_[1][0] = -sinGamma;
        this.rotZ_[1][1] = cosGamma;
        this.rotZ_[1][2] = 0.0;
        this.rotZ_[2][0] = 0.0;
        this.rotZ_[2][1] = 0.0;
        this.rotZ_[2][2] = 1.0;
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderLonLatRotatedPole();
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        double lonRad = Math.toRadians(lon);
        double latRad = Math.toRadians(lat);
        double[] p0 = new double[]{Math.cos(latRad) * Math.cos(lonRad), Math.cos(latRad) * Math.sin(lonRad), Math.sin(latRad)};
        double[] p1 = new double[]{this.rotZ_[0][0] * p0[0] + this.rotZ_[0][1] * p0[1], this.rotZ_[1][0] * p0[0] + this.rotZ_[1][1] * p0[1], p0[2]};
        double[] p2 = new double[]{this.rotY_[0][0] * p1[0] + this.rotY_[0][2] * p1[2], p1[1], this.rotY_[2][0] * p1[0] + this.rotY_[2][2] * p1[2]};
        double lonR = MapUtils.normalizeMP180(Math.toDegrees(Math.atan2(p2[1], p2[0])));
        double latR = Math.toDegrees(Math.asin(p2[2]));
        return new Point2D.Double(lonR, latR);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double lonR = x;
        double latR = y;
        double lonRRad = Math.toRadians(lonR);
        double latRRad = Math.toRadians(latR);
        double[] p0 = new double[]{Math.cos(latRRad) * Math.cos(lonRRad), Math.cos(latRRad) * Math.sin(lonRRad), Math.sin(latRRad)};
        double[] p1 = new double[]{this.rotY_[0][0] * p0[0] + this.rotY_[2][0] * p0[2], p0[1], this.rotY_[0][2] * p0[0] + this.rotY_[2][2] * p0[2]};
        double[] p2 = new double[]{this.rotZ_[0][0] * p1[0] + this.rotZ_[1][0] * p1[1], this.rotZ_[0][1] * p1[0] + this.rotZ_[1][1] * p1[1], p1[2]};
        double lon = Math.toDegrees(Math.atan2(p2[1], p2[0]));
        double lat = Math.toDegrees(Math.asin(p2[2]));
        return new PointLL(lon, lat);
    }
}

