/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.ui;

import gov.nasa.giss.data.nc.NcCatalog;
import gov.nasa.giss.data.nc.NcCatalogList;
import gov.nasa.giss.data.nc.NcCatalogNode;
import gov.nasa.giss.data.nc.ui.NcCatalogTreeTableModel;
import gov.nasa.giss.ui.treetable.SearchableTreeTablePanel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.EventQueue;
import javax.swing.BorderFactory;
import javax.swing.border.CompoundBorder;

public class NcCatalogTreeTablePanel
extends SearchableTreeTablePanel {
    private boolean expandNewNodes_ = true;

    public NcCatalogTreeTablePanel() {
        super(new NcCatalogTreeTableModel());
        this.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), this.getBorder()));
    }

    public void setExpandNewNodes(boolean expand) {
        this.expandNewNodes_ = expand;
    }

    public Object[] getCatalogs() {
        NcCatalogTreeTableModel model = (NcCatalogTreeTableModel)this.getModel();
        NcCatalogList clist = (NcCatalogList)model.getRoot();
        return clist.getChildren();
    }

    public int getCatalogCount() {
        return this.getCatalogs().length;
    }

    @Override
    public void removeAll() {
        for (Object catalog : this.getCatalogs()) {
            this.removeCatalog((NcCatalog)catalog);
        }
    }

    public void removeCatalog(NcCatalog node) {
        NcCatalogTreeTableModel model = (NcCatalogTreeTableModel)this.getModel();
        model.removeCatalog(node);
        this.fireItemRemoved(node);
    }

    public synchronized NcCatalogNode addCatalog(NcCatalog catalog) {
        if (catalog == null) {
            return null;
        }
        NcCatalogTreeTableModel model = (NcCatalogTreeTableModel)this.getModel();
        NcCatalogNode node = model.addCatalog(catalog);
        if (this.expandNewNodes_) {
            this.getTreeTable().expandNode(node);
        }
        EventQueue.invokeLater(() -> {
            this.getTreeTable().setSelectedNode(node);
            this.getTreeTable().makeNodeVisible(node);
            this.fireItemAdded(node);
        });
        return node;
    }

    @Override
    protected boolean nodeMatches(TreeTableNode node, String sterm) {
        String lcterm = sterm.toLowerCase();
        NcCatalogNode ncnode = (NcCatalogNode)node;
        return ncnode.getName().toLowerCase().contains(lcterm);
    }
}

