/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.plot;

import gov.nasa.giss.graphics.ColorUtils;
import gov.nasa.giss.graphics.plot.PlotPropertyEvent;
import gov.nasa.giss.graphics.plot.PlotPropertyListener;
import gov.nasa.giss.text.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.TreeMap;

public class PlotPropertyMap
extends TreeMap<String, Object> {
    private final Object lock_ = new Object();
    private final ArrayList<PlotPropertyListener> listeners_ = new ArrayList(20);

    @Override
    public Object get(Object key) {
        throw new IllegalArgumentException("Use get(String)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Objects.requireNonNull(key, "Property key cannot be null.");
        Object object = this.lock_;
        synchronized (object) {
            return super.get(key);
        }
    }

    public boolean getBoolean(String key) {
        Object o = this.get(key);
        if (!(o instanceof Boolean)) {
            throw new IllegalArgumentException("'" + key + "' is not a boolean property.");
        }
        try {
            return (Boolean)o;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("'" + key + "' is not a boolean property.");
        }
    }

    public Color getColor(String key) {
        Object o = this.get(key);
        if (!(o instanceof Color)) {
            throw new IllegalArgumentException("'" + key + "' is not a color property.");
        }
        return (Color)o;
    }

    public double getDouble(String key) {
        Object o = this.get(key);
        if (!(o instanceof Double)) {
            throw new IllegalArgumentException("'" + key + "' is not a double property.");
        }
        try {
            return (Double)o;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("'" + key + "' is not a double property.");
        }
    }

    public float getFloat(String key) {
        Object o = this.get(key);
        if (!(o instanceof Float)) {
            throw new IllegalArgumentException("'" + key + "' is not a float property.");
        }
        try {
            return ((Float)o).floatValue();
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("'" + key + "' is not a float property.");
        }
    }

    public int getInt(String key) {
        Object o = this.get(key);
        if (!(o instanceof Integer)) {
            throw new IllegalArgumentException("'" + key + "' is not an integer property");
        }
        try {
            return (Integer)o;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("'" + key + "' is not an integer property");
        }
    }

    public Dimension getDimension(String key) {
        Object o = this.get(key);
        if (!(o instanceof Dimension)) {
            throw new IllegalArgumentException("'" + key + "' is not a Dimension property.");
        }
        return (Dimension)o;
    }

    public Rectangle getRect(String key) {
        Object o = this.get(key);
        if (!(o instanceof Rectangle)) {
            throw new IllegalArgumentException("'" + key + "' not a Rectangle property.");
        }
        return (Rectangle)o;
    }

    public String getString(String key) {
        Object o = this.get(key);
        try {
            return (String)o;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("'" + key + "' is not a String property.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(String key, Object value) {
        Objects.requireNonNull(key, "Property key cannot be null.");
        Object object = this.lock_;
        synchronized (object) {
            super.put(key, value);
        }
        this.firePropertyChanged(key);
        return value;
    }

    public void set(String key, Object value) {
        this.put(key, value);
    }

    public void setBoolean(String key, boolean value) {
        this.put(key, (Object)value);
    }

    public Boolean setBoolean(String key, String svalue) {
        if (svalue == null || svalue.length() == 0) {
            this.setBoolean(key, false);
            return Boolean.FALSE;
        }
        if (svalue.equals("1") || svalue.equals("T")) {
            this.setBoolean(key, true);
            return Boolean.TRUE;
        }
        Boolean bb = Boolean.valueOf(svalue);
        this.setBoolean(key, bb);
        return bb;
    }

    public void setColor(String key, Color value) {
        this.put(key, (Object)value);
    }

    public Color setColor(String key, String svalue) throws ParseException {
        if (svalue == null) {
            this.setColor(key, Color.BLACK);
            return Color.BLACK;
        }
        Color cc = ColorUtils.parseColor(svalue);
        this.setColor(key, cc);
        return cc;
    }

    public void setDimension(String key, Dimension value) {
        this.put(key, (Object)value);
    }

    public void setDouble(String key, double value) {
        this.put(key, (Object)value);
    }

    public Double setDouble(String key, String svalue) throws NumberFormatException {
        if (svalue == null || svalue.length() == 0) {
            this.setDouble(key, 0.0);
            return 0.0;
        }
        double dd = StringUtils.parseDouble(svalue);
        this.setDouble(key, dd);
        return dd;
    }

    public void setFloat(String key, float value) {
        this.put(key, (Object)Float.valueOf(value));
    }

    public Float setFloat(String key, String svalue) throws NumberFormatException {
        if (svalue == null || svalue.length() == 0) {
            this.setFloat(key, 0.0f);
            return Float.valueOf(0.0f);
        }
        float ff = StringUtils.parseFloat(svalue);
        this.setFloat(key, ff);
        return Float.valueOf(ff);
    }

    public void setInt(String key, int value) {
        this.put(key, (Object)value);
    }

    public Integer setInt(String key, String svalue) throws NumberFormatException {
        if (svalue.length() == 0) {
            this.setInt(key, 0);
            return 0;
        }
        int ii = Integer.parseInt(svalue);
        this.setInt(key, ii);
        return ii;
    }

    public void setRect(String key, Rectangle value) {
        this.put(key, (Object)value);
    }

    public void setString(String key, String value) {
        this.put(key, (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setGroup(Object[] ... keyValuePairs) {
        int i;
        Objects.requireNonNull(keyValuePairs, "Key-value array cannot be null.");
        for (int i2 = 0; i2 < keyValuePairs.length; ++i2) {
            if (keyValuePairs[i2].length != 2) {
                throw new IllegalArgumentException("Key-value pair " + i2 + " must be two items");
            }
            if (keyValuePairs[i2][0] != null) continue;
            throw new IllegalArgumentException("Property key " + i2 + " is null.");
        }
        Object i2 = this.lock_;
        synchronized (i2) {
            for (i = 0; i < keyValuePairs.length; ++i) {
                super.put((String)keyValuePairs[i][0], keyValuePairs[i][1]);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < keyValuePairs.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append((String)keyValuePairs[i][0]);
        }
        this.firePropertyChanged(sb.toString());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlotPropertyListener(PlotPropertyListener ll) {
        ArrayList<PlotPropertyListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            this.listeners_.add(ll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlotPropertyListener(PlotPropertyListener ll) {
        ArrayList<PlotPropertyListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            this.listeners_.remove(ll);
        }
    }

    public synchronized void removePlotPropertyListeners() {
        this.listeners_.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void firePropertyChanged(String key) {
        PlotPropertyEvent e = new PlotPropertyEvent(this, key);
        ArrayList<PlotPropertyListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            int isize = this.listeners_.size();
            if (isize > 0) {
                for (int i = isize - 1; i >= 0; --i) {
                    this.listeners_.get(i).plotPropertyChanged(e);
                }
            }
        }
    }
}

