/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.img;

import gov.nasa.giss.graphics.GPrintable;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class SvgUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Object SAVE_LOCK = new Object();
    private static boolean libTested_;
    private static SvgLib svgLib_;

    public static boolean isSvgAvailable() {
        Class<?> cc;
        if (libTested_) {
            return svgLib_ != null;
        }
        try {
            cc = Class.forName("org.apache.batik.svggen.SVGGraphics2D");
            if (cc != null) {
                svgLib_ = SvgLib.BATIK;
                libTested_ = true;
                LOGGER.trace("Found Batik");
                return true;
            }
        }
        catch (Exception exc) {
            LOGGER.trace("Did not find Batik");
        }
        if (svgLib_ == null) {
            try {
                cc = Class.forName("io.sf.carte.echosvg.svggen.SVGGraphics2D");
                if (cc != null) {
                    svgLib_ = SvgLib.ECHO;
                    libTested_ = true;
                    LOGGER.trace("Found Echo");
                    return true;
                }
            }
            catch (Exception exc) {
                LOGGER.trace("Did not find Echo");
            }
        }
        if (svgLib_ == null) {
            try {
                cc = Class.forName("com.jsevy.jsvg.SVGDocument");
                if (cc != null) {
                    svgLib_ = SvgLib.JSVG;
                    libTested_ = true;
                    LOGGER.trace("Found JSVG");
                    return true;
                }
            }
            catch (Exception exc) {
                LOGGER.trace("Did not find JSVG");
            }
        }
        libTested_ = true;
        return false;
    }

    public static boolean save(File f, GPrintable plot, boolean vectorized) throws IOException {
        if (!SvgUtils.isSvgAvailable()) {
            throw new RuntimeException("No SVG library is available.");
        }
        switch (svgLib_) {
            case BATIK: {
                return SvgUtils.saveUsingBatik(f, plot, vectorized);
            }
            case ECHO: {
                return SvgUtils.saveUsingEcho(f, plot, vectorized);
            }
            case JSVG: {
                return SvgUtils.saveUsingJvsg(f, plot);
            }
        }
        throw new RuntimeException("Could not find an SVG library.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean saveUsingBatik(File f, GPrintable plot, boolean vectorized) throws IOException {
        LOGGER.trace("");
        Object object = SAVE_LOCK;
        synchronized (object) {
            try {
                Document document = SvgUtils.createSvgDocument();
                Class<?> g2dClass = Class.forName("org.apache.batik.svggen.SVGGraphics2D");
                Constructor<?> g2dConstruct = g2dClass.getConstructor(Document.class);
                Graphics2D g2d = (Graphics2D)g2dConstruct.newInstance(document);
                Dimension dd = plot.getSize();
                g2d.setClip(0, 0, dd.width, dd.height);
                Method sizeM = g2dClass.getMethod("setSVGCanvasSize", Dimension.class);
                sizeM.invoke((Object)g2d, dd);
                if (vectorized) {
                    plot.print(g2d);
                } else {
                    plot.paint(g2d);
                }
                Method streamM = g2dClass.getMethod("stream", Writer.class, Boolean.TYPE);
                FileWriter fw = new FileWriter(f);
                streamM.invoke((Object)g2d, fw, false);
                fw.flush();
                fw.close();
                g2d.dispose();
            }
            catch (ClassNotFoundException exc) {
                LOGGER.error("Unable to create class via reflection.");
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                String cname = exc.getMessage().replaceFirst(".*\\.", "");
                throw new RuntimeException("Unable to build SVG constructor. A necessary class, '" + cname + "', seems to be missing.");
            }
            catch (NoSuchMethodException exc) {
                LOGGER.error("Unable to execute method via reflection.");
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                throw new RuntimeException("Unable to build SVG constructor. A necessary method could not be called.");
            }
            catch (Exception exc) {
                LOGGER.error("Unable to save image as SVG.");
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                throw new RuntimeException("Unable to build SVG constructor due to unexpected exception.");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean saveUsingEcho(File f, GPrintable plot, boolean vectorized) throws IOException {
        LOGGER.trace("");
        Object object = SAVE_LOCK;
        synchronized (object) {
            try {
                Document document = SvgUtils.createSvgDocument();
                Class<?> g2dClass = Class.forName("io.sf.carte.echosvg.svggen.SVGGraphics2D");
                Constructor<?> g2dConstruct = g2dClass.getConstructor(Document.class);
                Graphics2D g2d = (Graphics2D)g2dConstruct.newInstance(document);
                Dimension dd = plot.getSize();
                g2d.setClip(0, 0, dd.width, dd.height);
                Method sizeM = g2dClass.getMethod("setSVGCanvasSize", Dimension.class);
                sizeM.invoke((Object)g2d, dd);
                if (vectorized) {
                    plot.print(g2d);
                } else {
                    plot.paint(g2d);
                }
                Method streamM = g2dClass.getMethod("stream", Writer.class, Boolean.TYPE);
                FileWriter fw = new FileWriter(f);
                streamM.invoke((Object)g2d, fw, false);
                fw.flush();
                fw.close();
                g2d.dispose();
            }
            catch (ClassNotFoundException exc) {
                LOGGER.error("Unable to create class via reflection.");
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                String cname = exc.getMessage().replaceFirst(".*\\.", "");
                throw new RuntimeException("Unable to build SVG constructor. A necessary class, '" + cname + "', seems to be missing.");
            }
            catch (NoSuchMethodException exc) {
                LOGGER.error("Unable to execute method via reflection.");
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                throw new RuntimeException("Unable to build SVG constructor. A necessary method could not be called.");
            }
            catch (Exception exc) {
                LOGGER.error("Unable to save image as SVG.");
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                throw new RuntimeException("Unable to build SVG constructor due to unexpected exception.");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean saveUsingJvsg(File f, GPrintable plot) throws IOException {
        LOGGER.trace("");
        Object object = SAVE_LOCK;
        synchronized (object) {
            try {
                Class<?> svgClass = Class.forName("com.jsevy.jsvg.SVGDocument");
                Constructor<?> svgConstruct = svgClass.getConstructor(new Class[0]);
                Object svgDoc = svgConstruct.newInstance(new Object[0]);
                Method getg2dM = svgClass.getMethod("getGraphics", new Class[0]);
                Graphics2D g2d = (Graphics2D)getg2dM.invoke(svgDoc, new Object[0]);
                Dimension dd = plot.getSize();
                g2d.setClip(0, 0, dd.width, dd.height);
                plot.print(g2d);
                Method toStrM = svgClass.getMethod("toSVGString", new Class[0]);
                String svgText = (String)toStrM.invoke(svgDoc, new Object[0]);
                FileWriter fw = new FileWriter(f);
                fw.write(svgText);
                fw.flush();
                fw.close();
                g2d.dispose();
            }
            catch (Exception exc) {
                LOGGER.error("Unable to save image as SVG.");
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return false;
            }
            return true;
        }
    }

    private static final Document createSvgDocument() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException exc) {
            throw new IllegalStateException(exc);
        }
        Document doc = builder.newDocument();
        DocumentType dtd = builder.getDOMImplementation().createDocumentType("svg", "-//W3C//DTD SVG 1.1//EN", "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd");
        Element svgRoot = doc.createElementNS("http://www.w3.org/2000/svg", "svg");
        doc.appendChild(dtd);
        doc.appendChild(svgRoot);
        return doc;
    }

    private SvgUtils() {
    }

    private static enum SvgLib {
        BATIK,
        ECHO,
        JSVG;

    }
}

