/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.kml;

import gov.nasa.giss.map.kml.KMLData;
import gov.nasa.giss.map.kml.KMLDataFilenameFilter;
import gov.nasa.giss.map.kml.KMLDataResourceListEntry;
import gov.nasa.giss.util.reslist.ResourceList;
import gov.nasa.giss.util.reslist.ResourceListEntry;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMLDataResourceList
extends ResourceList {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String RESOURCE_DESC = "KML underlay";
    private static final String RESOURCE_DESC_PLURAL = "KML underlays";
    private static final String APP_SUPPORT_DIR = "underlays";

    public KMLDataResourceList() {
        super(new KMLDataFilenameFilter());
        this.scanAppSupportDirectory(APP_SUPPORT_DIR);
    }

    @Override
    public String getResourceDescription() {
        return RESOURCE_DESC;
    }

    @Override
    public String getResourceDescriptionPlural() {
        return RESOURCE_DESC_PLURAL;
    }

    @Override
    public String getAppSupportDirectoryName() {
        return APP_SUPPORT_DIR;
    }

    @Override
    protected Object createObject(File f) {
        try {
            return new KMLData(f);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not load creat object: due to " + exc.getMessage());
            return null;
        }
    }

    @Override
    protected ResourceListEntry createSetEntry(ResourceListEntry.LocType loctype, Object link, Object o) {
        return new KMLDataResourceListEntry(loctype, link, o);
    }

    public void flush() {
        int isize = this.getSize();
        for (int i = 0; i < isize; ++i) {
            KMLDataResourceListEntry ee = (KMLDataResourceListEntry)this.getElementAt(i);
            ee.flush();
        }
    }
}

