/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Baranyi2
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Baranyi II";
    public static final int PROPERTIES = 8;
    private static final double CY = 2.199115;
    private static final double CA1 = 0.431991988;
    private static final double CA2 = 0.130270093;
    private static final double B11 = 3.358407;
    private static final double B31 = 1.308997;
    private static final double B12 = 18.9516562;
    private static final double B32 = 2.154235;
    private static final double JOIN_PHI = 69.230288;
    private static final double JOIN_PHIRAD = Math.toRadians(69.230288);
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 2.199115;

    public Baranyi2(int width, int height) {
        this(width, height, 0, 0);
    }

    public Baranyi2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 2.199115);
        this.finishConstruction();
        LOGGER.trace("fPhi(pi/2) {}", (Object)Baranyi2.getFPhi(1.5707963267948966));
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double absPhiRad = Math.abs(Math.toRadians(lat));
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        double y = 2.199115 * Baranyi2.getFPhi(absPhiRad);
        double x = 0.0;
        if (absPhiRad < JOIN_PHIRAD) {
            x = absLambdaRad * 0.3183098861837907 * (Math.sqrt(3.358407 - y * y) + 1.308997);
        } else {
            double sqterm = y + 2.154235;
            x = absLambdaRad * 0.3183098861837907 * Math.sqrt(18.9516562 - sqterm * sqterm);
        }
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        double phiRad = this.iteratePhiRad(absYOverRS);
        if (phiRad < JOIN_PHIRAD) {
            lambdaRad = absXOverRS * Math.PI / (Math.sqrt(3.358407 - absYOverRS * absYOverRS) + 1.308997);
        } else {
            double sqterm = absYOverRS + 2.154235;
            lambdaRad = absXOverRS * Math.PI / Math.sqrt(18.9516562 - sqterm * sqterm);
        }
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = y < 0.0 ? -Math.toDegrees(phiRad) : Math.toDegrees(phiRad);
        double lambda = x < 0.0 ? -Math.toDegrees(lambdaRad) : Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Baranyi2 baranyi2 = this;
        synchronized (baranyi2) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double phiTerm;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double phiRad = this.iteratePhiRad(yOverRS);
                if (phiRad < JOIN_PHIRAD) {
                    phiTerm = Math.PI / (Math.sqrt(3.358407 - yOverRS * yOverRS) + 1.308997);
                } else {
                    double sqterm = yOverRS + 2.154235;
                    phiTerm = Math.PI / Math.sqrt(18.9516562 - sqterm * sqterm);
                }
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lambdaRad = x * this.invRS_ * phiTerm;
                    if (Double.isNaN(lambdaRad)) {
                        LOGGER.trace("Got NaN lambda for x {}, dxMax_ {}", (Object)x, (Object)this.dxMax_);
                        continue block3;
                    }
                    if (lambdaRad > Math.PI) continue block3;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private static double getFPhi(double phiRad) {
        double phiRad2 = phiRad * phiRad;
        return 0.431991988 * phiRad + 0.130270093 * phiRad2;
    }

    private double iteratePhiRad(double yOverRS) {
        double phiRad = 1.5707963267948966 * yOverRS / 2.199115;
        for (int iter = 0; iter < 33; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double func = 2.199115 * (0.431991988 * phiRad + 0.130270093 * phiRad2) - yOverRS;
            double dfunc = 2.199115 * (0.431991988 + 0.260540186 * phiRad);
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return phiRad;
    }
}

